"use strict";
cc._RF.push(module, '1b988SumoxDT4KTvXu371gC', 'Utils');
// scripts/common/Utils.js

"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

/**
 * 工具类
 */
var Utils = {};

Utils.LoadRes = function (path, parent, reset, cbsuccess, cberror) {
  if (!path || !parent) {
    cc.error('LoadRes error:' + "null params");
    return;
  }

  var onResourceLoaded = function onResourceLoaded(errorMessage, loadedResource) {
    if (errorMessage) {
      cc.error('LoadRes error:' + errorMessage);
      cberror && cberror();
      return;
    }

    if (!(loadedResource instanceof cc.Prefab)) {
      cc.error('LoadRes error');
      cberror && cberror();
      return;
    }

    var node = null;

    if (reset) {
      node = Utils.Instantiate(loadedResource, parent);
    } else {
      node = Utils.InstantiateNoReset(loadedResource, parent);
    }

    cbsuccess && cbsuccess(node);
  };

  cc.loader.loadRes(path, onResourceLoaded);
};

Utils.LoadResAry = function (pathAry, parent, reset, cbsuccess, cberror) {
  if (!pathAry || !parent) {
    cc.error('LoadRes error:' + "null params");
    return;
  }

  var onResourceLoaded = function onResourceLoaded(errorMessage, assets) {
    if (errorMessage) {
      cc.error('LoadRes error:' + errorMessage);
      cberror && cberror();
      return;
    }

    var nodes = [];

    for (var index = 0; index < assets.length; index++) {
      var asset = assets[index];
      var node = null;

      if (reset) {
        node = Utils.Instantiate(asset, parent);
      } else {
        node = Utils.InstantiateNoReset(asset, parent);
      }

      nodes.push(node);
    }

    cbsuccess && cbsuccess(nodes);
  };

  cc.loader.loadResArray(pathAry, onResourceLoaded);
};

Utils.Instantiate = function (temp, parent) {
  var node = cc.instantiate(temp);
  parent.addChild(node);
  node.setPosition(0, 0);
  node.setScale(1);
  node.angle = 0;
  return node;
};

Utils.InstantiateNoReset = function (temp, parent) {
  var node = cc.instantiate(temp);
  parent.addChild(node);
  return node;
};

var _default = Utils;
exports["default"] = _default;
module.exports = exports["default"];

cc._RF.pop();