"use strict";
cc._RF.push(module, 'a4291VQoipP+IwcpMHILLNk', 'TipsManager');
// scripts/common/TipsManager.js

"use strict";

var _Com = _interopRequireDefault(require("./Com"));

var _Utils = _interopRequireDefault(require("./Utils"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/**
 * Tips管理类
 */
cc.Class({
  "extends": cc.Component,
  properties: {
    temp: cc.Node,
    root: cc.Node
  },
  onLoad: function onLoad() {
    _Com["default"].TipsManager = this;
    this.temp.active = false;
    this.pool = [];
  },
  getFreeTips: function getFreeTips() {
    for (var i = 0, len = this.pool.length; i < len; i++) {
      if (!this.pool[i].working) {
        return this.pool[i];
      }
    }

    return null;
  },
  createNewTips: function createNewTips() {
    var node = _Utils["default"].Instantiate(this.temp, this.root);

    var tips = node.getComponent("Tips");
    this.pool.push(tips);
    return tips;
  },
  show: function show(msg) {
    var tips = this.getFreeTips();

    if (!tips) {
      tips = this.createNewTips();
    }

    tips.reset(msg);
    console.log("Tips Count:" + this.pool.length);
  }
});

cc._RF.pop();