"use strict";
cc._RF.push(module, 'a5ac9TA8blD4IhlTilWZnib', 'ModuleManager');
// scripts/common/ModuleManager.js

"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _Utils = _interopRequireDefault(require("./Utils"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

var ModuleManager = {};
ModuleManager.modules = {};

ModuleManager.add = function (name, layer, cb) {
  if (ModuleManager.modules[name]) {
    cb && cb();
    console.log("重复添加模块!");
    return;
  } //因为是异步的,所以事先设定给一个值,防止同一时间多次加载


  ModuleManager.modules[name] = true; //

  var path = 'prefab/module/' + name;

  if (!layer || layer === "low") {
    parent = cc.find("Root/LayerLow");
  } else if (layer === "middle") {
    parent = cc.find("Root/LayerMiddle");
  } else {
    parent = cc.find("Root/LayerHigh");
  }

  _Utils["default"].LoadRes(path, parent, true, function (node) {
    ModuleManager.modules[name] = node;
    cb && cb();
  }, function () {
    ModuleManager.modules[name] = null;
  });
};

ModuleManager.remove = function (name) {
  var module = ModuleManager.modules[name];

  if (module && _typeof(module) === 'object') {
    module.destroy();
    ModuleManager.modules[name] = null;
  }
};

ModuleManager.removeAll = function () {
  for (var key in ModuleManager.modules) {
    if (ModuleManager.modules.hasOwnProperty(key)) {
      var module = ModuleManager.modules[key];
      module.destroy();
    }
  }

  ModuleManager.modules = {};
};

var _default = ModuleManager;
exports["default"] = _default;
module.exports = exports["default"];

cc._RF.pop();