let MaskType = cc.Enum( {
	RECT:    0,
	ELLIPSE: 1,
	IRR:     2,
	//SP:3
} );

let scriptClass = cc.Class( {

	extends:    cc._RendererInSG,
	editor:
	{
		//executeInEditMode: true,
		requireComponent: cc.PolygonCollider,
		menu: 'i18n:Raz/Script/MaskExtend',
	},
	properties:
	{
		PolygonCollider: { visible: false, get(){ return this.getComponent( cc.PolygonCollider ); } },
		_clippingStencil:
		{
			default:      null,
			serializable: false,
		},

		_Case:		null,
		_type:      2,
		_segements: 64,
		_area:
		{
			default: ()=>[cc.v2( -50, -50 ), cc.v2( -50, 50 ), cc.v2( 50, 50 ), cc.v2( 50, -50 )],
			type:    [cc.Vec2]
		},

		live: { default: true, tooltip: "是否realtime刷新多邊形 (編輯時開啟，運行看需求，主要怕影響性能)", },

		type:
		{
			get:  function (){ return this._type; },
			set:  function ( value ){ this._type = value; this._refreshStencil(); },
			type: MaskType
		},

		segements:
		{
			type: cc.Integer,
			get:  function (){ return this._segements; },
			set:  function ( value ){ if ( value < 3 ) value = 3; this._segements = value; this._refreshStencil(); }
		},

	},

	statics: { Type: MaskType, },

	lateUpdate: function ()
	{
		if ( this.live ) this._refreshStencil();
	},

	_createSgNode: function ()
	{
		this._clippingStencil = new cc.DrawNode();
		
		if ( CC_JSB ) this._clippingStencil.retain();
		this._Case = new cc.ClippingNode( this._clippingStencil );
		this._Case.setInverted( false );
		this._Case.setAlphaThreshold( 1 );

		return this._Case;
	},

	_initSgNode: function (){},

	_hitTest: function ( point )
	{
		let size = this.node.getContentSize(),
			w = size.width,
			h = size.height,
			trans = this.node.getNodeToWorldTransform();

		if ( this._type === MaskType.RECT )
		{
			let rect = cc.rect( 0, 0, w, h );
			cc._rectApplyAffineTransformIn( rect, trans );
			let left = point.x - rect.x,
				right = rect.x + rect.width - point.x,
				bottom = point.y - rect.y,
				top = rect.y + rect.height - point.y;
			return left >= 0 && right >= 0 && top >= 0 && bottom >= 0;
		}
		else
		{
			let a = w / 2, b = h / 2;
			let cx = trans.a * a + trans.c * b + trans.tx;
			let cy = trans.b * a + trans.d * b + trans.ty;
			let px = point.x - cx, py = point.y - cy;
			return px * px / (a * a) + py * py / (b * b) < 1;
		}
	},

	onEnable: function ()
	{
		this._refreshStencil();
		this._super();
		//this.node.on( 'size-changed', this._refreshStencil, this );
		//this.node.on( 'anchor-changed', this._refreshStencil, this );
	},

	onDisable: function ()
	{
		this._super();
		//this.node.off( 'size-changed', this._refreshStencil, this );
		//this.node.off( 'anchor-changed', this._refreshStencil, this );
	},

	_calculateCircle: function ( center, radius, segements )
	{
		let polies = [];
		let anglePerStep = Math.PI * 2 / segements;
		for ( let step = 0; step < segements; ++step )
		{
			polies.push( cc.v2( radius.x * Math.cos( anglePerStep * step ) + center.x, radius.y * Math.sin( anglePerStep * step ) + center.y ) );
		}

		return polies;
	},

	_refreshStencil: function ()
	{

		this._area = [];
		let points = this.PolygonCollider.points;

		let offsetX = this.PolygonCollider.offset.x;
		let offsetY = this.PolygonCollider.offset.y;

		for( let key in points )
		{
			let point = points[key];
			let v2 = cc.v2( point.x + offsetX, point.y + offsetY );
			this._area[key] = v2;
		}

		let contentSize = this.node.getContentSize();
		let anchorPoint = this.node.getAnchorPoint();
		let width = contentSize.width;
		let height = contentSize.height;
		let x = -width * anchorPoint.x;
		let y = -height * anchorPoint.y;
		let color = cc.color( 255, 255, 255, 0 );
		this._clippingStencil.clear();
		if ( this._type === MaskType.RECT )
		{
			let rectangle = [cc.v2( x, y ),
				cc.v2( x + width, y ),
				cc.v2( x + width, y + height ),
				cc.v2( x, y + height )];
			this._clippingStencil.drawPoly( rectangle, color, 0, color );

		}
		else if ( this._type === MaskType.IRR )
		{
			this._clippingStencil.drawPoly( this._area, color, 0, color );
		}
		else if ( this._type === MaskType.SP )
		{
			this._clippingStencil = this.A;
		}
		else
		{
			let center = cc.v2( x + width / 2, y + height / 2 );
			let radius = { x: width / 2, y: height / 2 };
			let segements = this._segements;
			this._clippingStencil.drawPoly( this._calculateCircle( center, radius, segements ), color, 0, color );
		}
	}
} );

if ( window.CC_JSB )
{
	// override onDestroy
	scriptClass.prototype.__superOnDestroy = cc._RendererInSG.prototype.onDestroy;
	scriptClass.prototype.onDestroy = function ()
	{
		try
		{
			this.__superOnDestroy();
			if ( this._clippingStencil )
			{
				this._clippingStencil.release();
				this._clippingStencil = null;
			}
		}
		catch ( ex ) { cc.error( '[MaskExtend] error on destroy: ' + ex ); }
	};
}

module.exports = scriptClass;