import Game from './gamet'
import Player from './player'
const { ccclass, property } = cc._decorator;

@ccclass
export default class NewClass extends cc.Component {

    @property(cc.Node)
    public gameNode: cc.Node = null;

    @property(cc.Node)
    public playerNode: cc.Node = null;

    @property(Game)
    _game: Game = null;

    @property(Player)
    _player: Player = null;

    // LIFE-CYCLE CALLBACKS:

    onLoad() {
        this._game = this.gameNode.getComponent('gamet');
        this._player = this.playerNode.getComponent('player');
    }

    start() {

    }

    update(dt: number) {

        if (this._game.isStateGameStart() == false)
            return;

        let movedis = this._player.speed * dt
        this.node.y -= movedis
        if (this.node.y <= -1 * cc.winSize.height)
            this.node.y = 0;
    }
}
