import Game from './gamet'
import Player from './player'
const { ccclass, property } = cc._decorator;

@ccclass
export default class NewClass extends cc.Component {

    @property(Number)
    speed = 0;

    @property(Number)
    pickRadius = 0;//碰撞距离

    @property(Game)
    _game: Game = null;

    @property(Player)
    _player: Player = null;

    // LIFE-CYCLE CALLBACKS:

    reuse(game: Game, player: Player) {

        this._game = game;
        this._player = player;

    }

    // onLoad () {}

    start() {

    }

    update(dt: number) {

        if (this._game.isStateGameStart() == false)
            return;

        //玩家与敌人碰撞游戏结束
        if (this.getPlayerDistance() < this.pickRadius) {
            this._game.gameOver();
            this.putEnemy();
            return;
        }

        let movedis = (this.speed - this._player.speed) * dt
        // let movedis = -1 * this.speed * dt;
        this.node.y += movedis;

        if(this.isOutOfWindow() == true)
            this.putEnemy();

    }

    getPlayerDistance() {
        //获取玩家相对于世界的位置
        let playerPos = this._player.node.convertToWorldSpaceAR(cc.v2(0, 0));
        //cc.log(playerPos)
        //获取敌人相对于世界的位置
        let enemyToWorldPos = this.node.convertToWorldSpaceAR(cc.v2(0, 0));
        //cc.log(enemyToWorldPos)
        //获取玩家与敌人之间的距离
        let dist = enemyToWorldPos.sub(playerPos).mag();
        return dist;
    }

    isOutOfWindow() {

        var posx = this.node.getPosition().x;
        var posy = this.node.getPosition().y;
        if (posx < -1.1 * Math.floor(cc.winSize.height) || posx > 1.1 * Math.floor(cc.winSize.height) || posy < -1.1 * Math.floor(cc.winSize.height) || posy > 1.1 * Math.floor(cc.winSize.height))
            return true;
        else
            return false;

    }

    putEnemy(){

        //将敌人对象放回对象池
        this._game._enemyPool.put(this.node);
        //设置隐藏(测试用)
        // this.node.active = false;

    }
}
