import Player from './player'
const { ccclass, property } = cc._decorator;
//游戏状态枚举
enum State {
    stateGameReady = 0, //准备开始
    stateGameStart = 10,//游戏中
    stateGamePause = 20,//暂停状态
    stateGameOver = 30,//游戏结束
};
@ccclass
export default class NewClass extends cc.Component {

    @property(cc.Integer)
    _state = 0;

    @property(Number)
    private _dis = 0;

    @property(cc.Node)
    bg: cc.Node = null;

    @property(cc.Node)
    playerNode: cc.Node = null;

    @property(Player)
    _player: Player = null;

    @property(cc.NodePool)
    _enemyPool: cc.NodePool = null;

    @property([cc.Node])
    _enemyList = [];

    @property([cc.Prefab])
    enemyPrefab = [];


    // LIFE-CYCLE CALLBACKS:

    onLoad() {

        cc.log(this.playerNode.height);
        //赋予游戏状态
        this._state = State.stateGameStart;
        //初始化对象
        this._player = this.playerNode.getComponent('player');
        this._player.init(this);

        let initEnemyCount = 10; //敌人暂时先创建10个
        //初始化对象池
        this._enemyPool = new cc.NodePool('enemy');
        for (let i = 0; i < initEnemyCount; i++) {
            let index = i % 3
            let newEnemy = cc.instantiate(this.enemyPrefab[index]);
            this._enemyPool.put(newEnemy);
        }

         //显示隐藏相关代码
        // for (let i = 0; i < initEnemyCount; i++) {
            // let index = i % 3
            // this._enemyList[i] = cc.instantiate(this.enemyPrefab[index]);
            // this._enemyList[i].getComponent('enemy').reuse(this, this._player);
            // this._enemyList[i].parent = this.bg;
            // this._enemyList[i].active = false;
        // }

    }

    onDestroy() {

        this._enemyPool.clear();

    }

    start() {
        // cc.log(this._player.speed);
    }

    update(dt: number) {

        let movedis = this._player.speed * dt

        this._dis += movedis;
        if (this._dis >= 5 * this.playerNode.height - movedis) {
            this.createEnemy();
            this._dis = 0;
        }
    }

    /**
     * 生成敌人(NPC) 
     */
    createEnemy() {
        // cc.log("create enemy")
        // let Index = this._player._curRoad
        // let nodeW = 300;
        // let posx = 0;
        // let posy = 0;
        // let dis = 1440;
        // let rot = -1 * this.bg.angle * Math.PI / 180;
        // posx = Math.sin(rot) == 0 ? nodeW * Index : -1 * Math.sin(rot) * dis
        // posy = Math.cos(rot) == 0 ? nodeW * Index : Math.cos(rot) * dis



        //cc.log(posx, posy);

        //创建敌人
        //对象池相关
        let newEnemy = null;
        let posx = 0;
        let posy = 1440
        if (this._enemyPool.size() > 0) {
            newEnemy = this._enemyPool.get(this, this._player);
        }
        else {
            newEnemy = cc.instantiate(this.enemyPrefab[2]);
            newEnemy.getComponent('enemy').reuse(this,this._player);
        }
        newEnemy.parent = this.bg;
        newEnemy.setPosition(cc.v2(posx, posy));

        //设置隐藏显示相关
        // let posx = 0;
        // let posy = 1440
        // let i = 0;
        // while (i < 10) {
        //     if (this._enemyList[i].active == false) {
        //         this._enemyList[i].active = true;
        //         this._enemyList[i].setPosition(cc.v2(posx, posy));
        //         return;
        //     }
        //     i++;
        // }

    }

    isStateGameStart() {

        if (this._state == State.stateGameStart)
            return true;
        else
            return false;
    }

    /**
     * 游戏结束
     */
    public gameOver() {
        // cc.log("game over")
    }
}
