import Game from './gamet'
const { ccclass, property } = cc._decorator;

@ccclass
export default class NewClass extends cc.Component {

    //不可见属性
    @property(Boolean)
    _isSpeedDown: Boolean = false

    @property(Number)
    _moveTime = 0.3

    @property(Number)
    _curRoad = 0; 

    @property(Game)
    private _game: Game = null;

    //初始速度
    @property(Number)
    speed = 0;
    //加速度
    @property(Number)
    accel = 600;
    //最大速度
    @property(Number)
    maxSpeed = 2000;

    @property(cc.Node)
    public bg: cc.Node = null;

    @property(cc.Button)
    speedBt: cc.Button = null;

    // LIFE-CYCLE CALLBACKS:

    onLoad() {

        this.speedBt.node.on(cc.Node.EventType.TOUCH_START, this.speedDown, this)

    }

    onDestroy() {
        //销毁按钮点击事件
        this.speedBt.node.off(cc.Node.EventType.TOUCH_START, this.speedDown, this);
    }

    init(game:Game){
        this._game = game;
    }

    start() {

    }

    leftTurn() {
        if (this._curRoad > -1) {
            this.bg.runAction(cc.moveBy(this._moveTime, cc.v2(300.0)));
            this._curRoad -= 1;
        }
    }

    speedDown() {
        if (this._isSpeedDown == false) {
            this._isSpeedDown = true;
        }
    }

    speedTouch(){
        if(this._isSpeedDown == true){
            this._isSpeedDown = false;
        }
    }

    rightTurn() {
        if (this._curRoad < 1) {
            this.bg.runAction(cc.moveBy(this._moveTime, cc.v2(-300.0)));
            this._curRoad += 1;
        }
    }

    update(dt: number) {

        if (this._game.isStateGameStart() == false)
            return;
        //点击减速按钮时设置减速状态
        if (this._isSpeedDown == true) {
            
            this.speed -= this.accel * dt
            //当速度为0时结束游戏
            if (this.speed <= 0) {
                this._game.gameOver();
            }
        }
        //未点击时自动加速
        else {
            this.speed += this.accel * dt
            if (this.speed > this.maxSpeed) {
                this.speed = this.maxSpeed
            }
        }
    }
}
