(function outer(modules, cache, entry) {
  function newRequire(name, jumped) {
    var module = cache[name];
    if (!module) {
      var moduleData = modules[name];
      if (!moduleData) return;
      var exports = {};
      module = cache[name] = {
        exports: exports
      };
      moduleData[0]((function(x) {
        return newRequire(moduleData[1][x] || x);
      }), module, exports);
    }
    return module.exports;
  }
  for (var i = 0; i < entry.length; i++) newRequire(entry[i]);
  return newRequire;
})({
  1: [ (function(require, module, exports) {
    module.exports = {
      1001: "cocos2d: removeAction: Target not found",
      1002: "cc.ActionManager.removeActionByTag(): an invalid tag",
      1003: "cc.ActionManager.removeActionByTag(): target must be non-null",
      1004: "cc.ActionManager.getActionByTag(): an invalid tag",
      1005: "cocos2d : getActionByTag(tag = %s): Action not found",
      1006: "[Action step]. override me",
      1007: "[Action update]. override me",
      1008: "cocos2d: FiniteTimeAction#reverse: Implement me",
      1009: "cc.EaseElastic.reverse(): it should be overridden in subclass.",
      1010: "cc.IntervalAction: reverse not implemented.",
      1011: "cc.ActionInterval.setAmplitudeRate(): it should be overridden in subclass.",
      1012: "cc.ActionInterval.getAmplitudeRate(): it should be overridden in subclass.",
      1013: "The speed parameter error",
      1014: "The repeat parameter error",
      1015: "parameters should not be ending with null in Javascript",
      1016: "cc.RotateTo.reverse(): it should be overridden in subclass.",
      1019: "Failed to construct, Sequence construction needs two or more actions.",
      1020: "Failed to construct, Spawn construction needs two or more actions.",
      1021: "cc.Speed.initWithAction(): action must be non nil",
      1022: "cc.Follow.initWithAction(): followedNode must be non nil",
      1023: "cc.ActionEase.initWithAction(): action must be non nil",
      1024: "Invalid configuration. It must at least have one control point",
      1025: "cc.Sequence.initWithTwoActions(): arguments must all be non nil",
      1026: "cc.RepeatForever.initWithAction(): action must be non null",
      1027: "cc.Spawn.initWithTwoActions(): arguments must all be non null",
      1028: "cc.ReverseTime.initWithAction(): action must be non null",
      1029: "cc.ReverseTime.initWithAction(): the action was already passed in.",
      1030: "cc.Animate.initWithAnimation(): animation must be non-NULL",
      1031: "Illegal parameter get passed in cc.tween: %s.",
      1100: "Expected 'data' dict, but not found. Config file: %s",
      1101: "Please load the resource first : %s",
      1200: "cocos2d: Director: Error in gettimeofday",
      1201: "cocos2d: Director: unrecognized projection",
      1203: "cocos2d: Director: Error in gettimeofday",
      1204: "running scene should not null",
      1205: "the scene should not null",
      1206: "loadScene: The scene index to load (%s) is out of range.",
      1207: "loadScene: Unknown name type to load: '%s'",
      1208: "loadScene: Failed to load scene '%s' because '%s' is already being loaded.",
      1209: "loadScene: Can not load the scene '%s' because it was not in the build settings before playing.",
      1210: "Failed to preload '%s', %s",
      1211: "loadScene: The scene index to load (%s) is out of range.",
      1212: "loadScene: Unknown name type to load: '%s'",
      1213: "loadScene: Failed to load scene '%s' because '%s' is already loading",
      1214: "loadScene: Can not load the scene '%s' because it was not in the build settings before playing.",
      1215: "Failed to preload '%s', %s",
      1216: "Director.runSceneImmediate: scene is not valid",
      1300: "element type is wrong!",
      1400: "'%s' is deprecated, please use '%s' instead.",
      1401: "The first argument should be the destination object",
      1402: "The 'visible' property of %s is deprecated, use 'enabled' instead please.",
      1403: "Sorry, cc.audioEngine.willPlayMusic is removed.",
      1404: "cc.spriteFrameCache is removed, please use cc.loader to load and cache sprite frames of atlas format.",
      1405: "The '%s' will be removed in v2.0, please use '%s' instead.",
      1406: "'%s.%s' is removed",
      1407: "cc.pool is being removed from v2.0, you are getting cc.js.Pool instead.",
      1408: "'%s' is not support in the '%s', please use '%s' instead.",
      1502: "cc.scheduler.scheduleCallbackForTarget(): target should be non-null.",
      1503: "cc.Scheduler.pauseTarget():target should be non-null",
      1504: "cc.Scheduler.resumeTarget():target should be non-null",
      1505: "cc.Scheduler.isTargetPaused():target should be non-null",
      1506: "warning: you CANNOT change update priority in scheduled function",
      1507: 'CCScheduler#scheduleSelector. Selector already scheduled. Updating interval from: %s to %s"',
      1508: "Argument callback must not be empty",
      1509: "Argument target must be non-nullptr",
      1510: "cc.Scheduler: Illegal target which doesn't have uuid or instanceId.",
      1511: "cc.Scheduler: pause state of the scheduled task doesn't match the element pause state in Scheduler, the given paused state will be ignored.",
      1512: "cc.Scheduler: updateFunc parameter is deprecated in scheduleUpdate function, and will be removed in v2.0",
      1513: "cc.Scheduler: scheduler stopped using `__instanceId` as id since v2.0, you should do scheduler.enableForTarget(target) before all scheduler API usage on target",
      1600: "getZOrder is deprecated. Please use getLocalZOrder instead.",
      1601: "setZOrder is deprecated. Please use setLocalZOrder instead.",
      1602: "RotationX != RotationY. Don't know which one to return",
      1603: "ScaleX != ScaleY. Don't know which one to return",
      1605: "child already added. It can't be added again",
      1606: "child must be non-null",
      1607: "removeFromParentAndCleanup is deprecated. Use removeFromParent instead",
      1608: "boundingBox is deprecated. Use getBoundingBox instead",
      1609: "argument tag is an invalid tag",
      1610: "cocos2d: removeChildByTag(tag = %s): child not found!",
      1612: "cc.Node.stopActionBy(): argument tag an invalid tag",
      1613: "cc.Node.getActionByTag(): argument tag is an invalid tag",
      1614: "resumeSchedulerAndActions is deprecated, please use resume instead.",
      1615: "pauseSchedulerAndActions is deprecated, please use pause instead.",
      1617: "child must be non-null",
      1618: "cc.Node.runAction(): action must be non-null",
      1619: "callback function must be non-null",
      1620: "interval must be positive",
      1623: "Set '%s' to normal node (not persist root node).",
      1624: "Replacing with the same sgNode",
      1625: "The replacement sgNode should not contain any child.",
      1626: "Should not set alpha via 'color', set 'opacity' please.",
      1627: "Not support for asynchronous creating node in SG",
      1632: "Node name can not include '/'.",
      1633: "Internal error, should not remove unknown node from parent.",
      1634: "addChild: The child to add must be instance of cc.Node, not %s.",
      1635: "reorderChild: this child is not in children list.",
      1636: "Node's zIndex value can't be greater than cc.macro.MAX_ZINDEX, setting to the maximum value",
      1637: "Node's zIndex value can't be smaller than cc.macro.MIN_ZINDEX, setting to the minimum value",
      1638: "Private node's zIndex can't be set, it will keep cc.macro.MIN_ZINDEX as its value",
      1800: "cc._EventListenerKeyboard.checkAvailable(): Invalid EventListenerKeyboard!",
      1801: "cc._EventListenerTouchOneByOne.checkAvailable(): Invalid EventListenerTouchOneByOne!",
      1802: "cc._EventListenerTouchAllAtOnce.checkAvailable(): Invalid EventListenerTouchAllAtOnce!",
      1803: "cc._EventListenerAcceleration.checkAvailable(): _onAccelerationEvent must be non-nil",
      1900: "Invalid parameter.",
      2000: "Don't call this method if the event is for touch.",
      2200: "Resolution not valid",
      2201: "should set resolutionPolicy",
      2300: "The touches is more than MAX_TOUCHES, nUnusedIndex = %s",
      2400: "WebGL error %s",
      2602: "cc.Sprite.setDisplayFrameWithAnimationName(): Frame not found",
      2603: "cc.Sprite.setDisplayFrameWithAnimationName(): Invalid frame index",
      2604: "setDisplayFrame is deprecated, please use setSpriteFrame instead.",
      2606: "cc.Sprite.initWithSpriteFrame(): spriteFrame should be non-null",
      2607: "cc.Sprite.initWithSpriteFrameName(): spriteFrameName should be non-null",
      2608: "%s is null, please check.",
      2609: "cc.Sprite.initWithFile(): filename should be non-null",
      2610: "cc.Sprite.setDisplayFrameWithAnimationName(): animationName must be non-null",
      2614: "cc.Sprite.addChild(): child should be non-null",
      2616: "cc.SpriteBatchNode.updateQuadFromSprite(): cc.SpriteBatchNode only supports cc.Sprites as children",
      2617: "cc.SpriteBatchNode.insertQuadFromSprite(): cc.SpriteBatchNode only supports cc.Sprites as children",
      2618: "cc.SpriteBatchNode.addChild(): cc.SpriteBatchNode only supports cc.Sprites as children",
      2619: "cc.SpriteBatchNode.addChild(): cc.Sprite is not using the same texture",
      2623: "cc.SpriteBatchNode.updateQuadFromSprite(): sprite should be non-null",
      2625: "too many tiles, only 16384 tiles will be show",
      2626: "Unrecognized fill type in bar fill",
      2627: "Can not generate quad",
      2628: "%s does not exist",
      2710: "Sprite.initWithTexture(): Argument must be non-nil",
      2712: "Invalid spriteFrameName",
      3002: "textureForKey is deprecated. Please use getTextureForKey instead.",
      3005: "cocos2d: '%s' id=%s %s x %s",
      3006: "cocos2d: '%s' id= HTMLCanvasElement %s x %s",
      3007: "cocos2d: TextureCache dumpDebugInfo: %s textures, HTMLCanvasElement for %s KB (%s MB)",
      3103: "cc.Texture.addImage(): path should be non-null",
      3112: "cc.Texture.addImage(): path should be non-null",
      3113: "NSInternalInconsistencyException",
      3116: "WebGLRenderingContext.CLAMP_TO_EDGE should be used in NPOT textures",
      3117: "Mimpap texture only works in POT textures",
      3118: "contentSize parameter is deprecated and ignored for cc.Texture2D initWithData function.",
      3119: "Lazy init texture with image element failed due to image loading failure: %s",
      3120: "Loading texture from '%s' with unsupported type: '%s'. Add '%s' into 'cc.macro.SUPPORT_TEXTURE_FORMATS' please.",
      3300: "Rect width exceeds maximum margin: %s",
      3400: "Rect height exceeds maximum margin: %s",
      3500: "0 priority is forbidden for fixed priority since it's used for scene graph based priority.",
      3501: "Invalid listener type!",
      3502: "Can't set fixed priority with scene graph based listener.",
      3503: "Invalid parameters.",
      3504: "listener must be a cc.EventListener object when adding a fixed priority listener",
      3505: "The listener has been registered, please don't register it again.",
      3506: "Unsupported listener target.",
      3507: "Invalid scene graph priority!",
      3508: "If program goes here, there should be event in dispatch.",
      3509: "_inDispatch should be 1 here.",
      3510: "%s's scene graph node not contains in the parent's children",
      3511: "event is undefined",
      3600: "cc.Class will automatically call super constructor of %s, you should not call it manually.",
      3601: "The editor property 'playOnFocus' should be used with 'executeInEditMode' in class '%s'",
      3602: "Unknown editor property '%s' in class '%s'.",
      3603: "Use 'cc.Float' or 'cc.Integer' instead of 'cc.Number' please.",
      3604: "Can only indicate one type attribute for %s.",
      3605: "The default value of %s is not instance of %s.",
      3606: "No needs to indicate the '%s' attribute for %s, which its default value is type of %s.",
      3607: "The default value of %s must be an empty string.",
      3608: "The type of %s must be cc.String, not String.",
      3609: "The type of %s must be cc.Boolean, not Boolean.",
      3610: "The type of %s must be cc.Float or cc.Integer, not Number.",
      3611: "Can not indicate the '%s' attribute for %s, which its default value is type of %s.",
      3612: "%s Just set the default value to 'new %s()' and it will be handled properly.",
      3613: "'No need to use 'serializable: false' or 'editorOnly: true' for the getter of '%s.%s', every getter is actually non-serialized.",
      3614: "Should not define constructor for cc.Component %s.",
      3615: "Each script can have at most one Component.",
      3616: "Should not specify class name %s for Component which defines in project.",
      3617: "Can not instantiate CCClass '%s' with arguments.",
      3618: "ctor of '%s' can not be another CCClass",
      3619: "ctor of '%s' must be function type",
      3620: "this._super declared in '%s.%s' but no super method defined",
      3621: "Unknown type of %s.%s, maybe you want is '%s'.",
      3622: "Unknown type of %s.%s, property should be defined in 'properties' or 'ctor'",
      3623: "Can not use 'editor' attribute, '%s' not inherits from Components.",
      3624: "'%s' overrided '%s' but '%s' is defined as 'false' so the super method will not be called. You can set '%s' to null to disable this warning.",
      3625: "[isChildClassOf] superclass should be function type, not",
      3626: "Can't remove '%s' because '%s' depends on it.",
      3627: "Should not add renderer component (%s) to a Canvas node.",
      3628: "Should not add %s to a node which size is already used by its other component.",
      3629: "attribute must be type object",
      3633: "Properties function of '%s' should return an object!",
      3634: "Disallow to use '.' in property name",
      3635: "Default array must be empty, set default value of %s.%s to [], and initialize in 'onLoad' or 'ctor' please. (just like 'this.%s = [...];')",
      3636: "Do not set default value to non-empty object, unless the object defines its own 'clone' function. Set default value of %s.%s to null or {}, and initialize in 'onLoad' or 'ctor' please. (just like 'this.%s = {foo: bar};')",
      3637: "Can not declare %s.%s, it is already defined in the prototype of %s",
      3638: "'%s': the getter of '%s' is already defined!",
      3639: "Can not apply the specified attribute to the getter of '%s.%s', attribute index: %s",
      3640: "'%s': the setter of '%s' is already defined!",
      3641: "Can not construct %s because it contains object property.",
      3642: "Cannot define %s.%s because static member name can not be '%s'.",
      3643: "Can not define a member called 'constructor' in the class '%s', please use 'ctor' instead.",
      3644: "Please define 'type' parameter of %s.%s as the actual constructor.",
      3645: "Please define 'type' parameter of %s.%s as the constructor of %s.",
      3646: "Unknown 'type' parameter of %s.%s\uff1a%s",
      3647: "The length of range array must be equal or greater than 2",
      3648: "Can not declare %s.%s method, it is already defined in the properties of %s.",
      3649: "CCClass %s have conflict between its ctor and __ctor__.",
      3651: 'Can not call `_super` or `prototype.ctor` in ES6 Classes "%s", use `super` instead please.',
      3652: 'Failed to construct a dummy instance of the "%s" class using `new` behind the scenes. This is for getting default values declared in TypeScript. Please ensure the class will be able to construct during script\'s initialization. %s.',
      3653: 'Please do not specifiy "default" attribute in decorator of "%s" property in "%s" class.  \nDefault value must be initialized at their declaration:\n \n// Before:\n@property({\n  type: cc.Integer\n  default: 0  // <--\n})\nvalue;\n// After:\n@property({\n  type: cc.Integer\n})\nvalue = 0;    // <--',
      3654: 'Please specifiy a default value for "%s" property at its declaration:\n \n// Before:\n@property(...)\nvalue; \n// After:\n@property(...)\nvalue = 0',
      3655: 'Can not specifiy "get" or "set"  attribute in decorator for "%s" property in "%s" class.  \nPlease use:\n \n@property(...)\nget %s () {\n    ...\n}\n@property\nset %s (value) {\n    ...\n}',
      3656: "The default value of %s.%s must be an empty string. (changed since 1.8)",
      3657: "The value assigned to %s should be Texture2D object, not url string. Since 1.8,  \nyou can declare a texture object directly in properties by using:  \n \n{\n    default: null,\n    type: cc.Texture2D  // use 'type:' instead of 'url:'\n}",
      3658: "browser does not support getters",
      3700: "internal error: _prefab is undefined",
      3701: "Failed to load prefab asset for node '%s'",
      3800: "The target can not be made persist because it's not a cc.Node or it doesn't have _id property.",
      3801: "The node can not be made persist because it's not under root node.",
      3802: "The node can not be made persist because it's not in current scene.",
      3803: "The target can not be made persist because it's not a cc.Node or it doesn't have _id property.",
      3804: "getComponent: Type must be non-nil",
      3805: "Can't add component '%s' because %s already contains the same component.",
      3806: "Can't add component '%s' to %s because it conflicts with the existing '%s' derived component.",
      3807: "addComponent: Failed to get class '%s'",
      3808: "addComponent: Should not add component ('%s') when the scripts are still loading.",
      3809: "addComponent: The component to add must be a constructor",
      3810: "addComponent: The component to add must be child class of cc.Component",
      3811: "_addComponentAt: The component to add must be a constructor",
      3812: "_addComponentAt: Index out of range",
      3813: "removeComponent: Component must be non-nil",
      3814: "Argument must be non-nil",
      3815: "Component not owned by this entity",
      3816: "Node '%s' is already activating",
      3817: "Sorry, the component of '%s' which with an index of %s is corrupted! It has been removed.",
      3818: "Failed to read or parse project.json",
      3819: "Warning: target element is not a DIV or CANVAS",
      3820: "The renderer doesn't support the renderMode %s",
      3821: "Cannot change hierarchy while activating or deactivating the parent.",
      3900: "Invalid clip to add",
      3901: "Invalid clip to remove",
      3902: "clip is defaultClip, set force to true to force remove clip and animation state",
      3903: "animation state is playing, set force to true to force stop and remove clip and animation state",
      3904: "motion path of target [%s] in prop [%s] frame [%s] is not valid",
      3905: "sprite frames must be an Array.",
      3906: "Can't find easing type [%s]",
      3907: "animator not added or already removed",
      3908: "animation not added or already removed",
      3912: "already-playing",
      4000: "Sorry, the cc.Font has been modified from Raw Asset to Asset. Please load the font asset before using.",
      4003: "Label font size can't be shirnked less than 0!",
      4004: "force notify all fonts loaded!",
      4011: "Property spriteFrame of Font '%s' is invalid. Using system font instead.",
      4012: "The texture of Font '%s' must be already loaded on JSB. Using system font instead.",
      4013: "Sorry, lineHeight of system font not supported on JSB.",
      4100: "Property padding is deprecated, please use paddingLeft, paddingRight, paddingTop and paddingBottom instead",
      4200: "MaskType: IMAGE_STENCIL only support WebGL mode.",
      4201: "The alphaThreshold invalid in Canvas Mode.",
      4202: "The inverted invalid in Canvas Mode.",
      4300: "can not found the %s page.",
      4400: "Invalid RichText img tag! The sprite frame name can't be found in the ImageAtlas!",
      4600: "Script attached to '%s' is missing or invalid.",
      4700: "The dom control is not created!",
      4800: "unknown asset type",
      4901: "loadRes: should not specify the extname in %s %s",
      4902: "No need to release non-cached asset.",
      4903: "Can not get class '%s'",
      4914: "Resources url '%s' does not exist.",
      4915: "Pack indices and data do not match in size",
      4916: "Failed to download package for %s",
      4920: "Sorry, you shouldn't use id as item identity any more, please use url or uuid instead, the current id is being set as url: (%s)",
      4921: "Invalid pipe or invalid index provided!",
      4922: "The pipe to be inserted is already in the pipeline!",
      4923: "Uuid Loader: Parse asset [ %s ] failed : %s",
      4924: "JSON Loader: Input item doesn't contain string content",
      4925: "Uuid Loader: Deserialize asset [ %s ] failed : %s",
      4926: "Audio Downloader: no web audio context.",
      4927: "Audio Downloader: audio not supported on this browser!",
      4928: "Load %s failed!",
      4929: "Load Webp ( %s ) failed",
      4930: "Load image ( %s ) failed",
      4931: "Download Uuid: can not find type of raw asset[ %s ]: %s",
      4932: 'Since v1.10, for any atlas ("%s") in the "resources" directory, it is not possible to find the contained SpriteFrames via `loadRes`, `getRes` or `releaseRes`. Load the SpriteAtlas first and then use `spriteAtlas.getSpriteFrame(name)` instead please.',
      4933: "Download Font [ %s ] failed, using Arial or system default font instead",
      5000: "object already destroyed",
      5001: "object not yet destroyed",
      5100: "Not a plist file!",
      5200: "Warning: localStorage isn't enabled. Please confirm browser cookie or privacy option",
      5201: "browser don't support web audio",
      5202: "This feature supports WebGL render mode only.",
      5300: "Type of target to deserialize not matched with data: target is %s, data is %s",
      5301: "Can not find script '%s'",
      5302: "Can not find class '%s'",
      5400: "'%s' is deprecated, use '%s' instead please.",
      5401: "'%s' is deprecated, use '%s' instead please.",
      5402: "cc.js.addon called on non-object:",
      5403: "cc.js.mixin: arguments must be type object:",
      5404: "The base class to extend from must be non-nil",
      5405: "The class to extend must be non-nil",
      5406: "Class should be extended before assigning any prototype members.",
      5500: "'notify' can't work with 'get/set' !",
      5501: "'notify' must work with 'default' !",
      5502: "Invalid url of %s.%s",
      5503: "The 'url' attribute of '%s.%s' is undefined when loading script.",
      5504: "The 'url' type of '%s.%s' must be child class of cc.RawAsset.",
      5505: "The 'url' type of '%s.%s' must not be child class of cc.Asset, otherwise you should use 'type: %s' instead.",
      5506: "Can not specify 'type' attribute for '%s.%s', because its 'url' is already defined.",
      5507: "The 'default' attribute of '%s.%s' must be an array",
      5508: "Invalid type of %s.%s",
      5510: "The 'type' attribute of '%s.%s' can not be 'Number', use 'Float' or 'Integer' instead please.",
      5511: "The 'type' attribute of '%s.%s' is undefined when loading script",
      5512: "Can not serialize '%s.%s' because the specified type is anonymous, please provide a class name or set the 'serializable' attribute of '%s.%s' to 'false'.",
      5513: "The 'default' value of '%s.%s' should not be used with a 'get' function.",
      5514: "The 'default' value of '%s.%s' should not be used with a 'set' function.",
      5515: "The 'default' value of '%s.%s' can not be an constructor. Set default to null please.",
      5516: "Property '%s.%s' must define at least one of 'default', 'get' or 'set'.",
      5517: "'%s.%s' hides inherited property '%s.%s'. To make the current property override that implementation, add the `override: true` attribute please.",
      5600: "Argument must be non-nil",
      5601: "Can not get current scene.",
      5602: "Scene is destroyed",
      5603: "reference node is destroyed",
      5700: "no %s or %s on %s",
      5800: "%s.lerp not yet implemented.",
      5801: "%s.clone not yet implemented.",
      5802: "%s.equals not yet implemented.",
      5900: "MotionStreak only support WebGL mode.",
      5901: "cc.MotionStreak.getOpacity has not been supported.",
      5902: "cc.MotionStreak.setOpacity has not been supported.",
      6000: "Custom should not be false if file is not specified.",
      6001: "The new %s must not be NaN",
      6017: "Incomplete or corrupt PNG file",
      6018: "Invalid filter algorithm: %s",
      6019: "Invalid byte order value.",
      6020: "You forgot your towel!",
      6021: "Unknown Field Tag: %s",
      6022: "Too many bits requested",
      6023: "No bits requested",
      6024: "Cannot recover from missing StripByteCounts",
      6025: "Cannot handle sub-byte bits per sample",
      6026: "Cannot handle sub-byte bits per pixel",
      6027: "Palette image missing color map",
      6028: "Unknown Photometric Interpretation: %s",
      6029: "Unkown error",
      6030: "cc.ParticleSystem: error decoding or ungzipping textureImageData",
      6031: "cc.ParticleSystem: unknown image format with Data",
      6032: "cc.ParticleSystem.initWithDictionary() : error loading the texture",
      6200: "Canvas doesn't support mesh slot!",
      6300: "only cc.DrawNode is accepted as stencil",
      6301: "Stencil buffer is not enabled.",
      6302: "Nesting more than %d stencils is not supported. Everything will be drawn without stencil for this node and its children.",
      6400: "asset.url is not usable in core process",
      6401: "asset.urls is not usable in core process",
      6402: "AssetLibrary has already been initialized!",
      6500: "Widget target must be one of the parent nodes of it",
      6600: "collider not added or already removed",
      6601: "Can't find testFunc for (%s, $s).",
      6700: "Can't init canvas '%s' because it conflicts with the existing '%s', the scene should only have one active canvas at the same time",
      6701: "Should not add Canvas to a node which already contains a renderer component (%s).",
      6702: "Should not add Canvas to a node which size is already used by its other component.",
      6703: "Can't initialise DrawingPrimitiveWebGL. context need is WebGLRenderingContext",
      6704: "Polygon's point must greater than 2",
      6705: "Argument must be non-nil",
      6800: "Callback of event must be non-nil",
      6801: "The message must be provided",
      6900: "The thing you want to instantiate must be an object",
      6901: "The thing you want to instantiate is nil",
      6902: "The thing you want to instantiate is destroyed",
      6903: "The instantiate method for given asset do not implemented",
      6904: "Can not instantiate array",
      6905: "Can not instantiate DOM element",
      7000: "Failed to init asset's raw path.",
      7001: "Should not load '%s' from script dynamically, unless it is placed in the 'resources' folder.",
      7002: "Sorry can not load '%s' because it is not placed in the 'resources' folder.",
      7003: "Failed to init builtin asset's raw path.",
      7100: "%s already defined in Enum.",
      7101: "Sorry, 'cc.Enum' not available on this platform, please report this error here: https://github.com/cocos-creator/engine/issues/new",
      7200: "Method 'initWithTMXFile' is no effect now, please set property 'tmxAsset' instead.",
      7201: "Method 'initWithXML' is no effect now, please set property 'tmxAsset' instead.",
      7202: "Add component TiledLayer into node failed.",
      7203: "Property 'mapLoaded' is unused now. Please write the logic to the callback 'start'.",
      7210: "TMX Hexa zOrder not supported",
      7211: "TMX invalid value",
      7214: "propertiesForGID is deprecated. Please use getPropertiesForGID instead.",
      7215: "cocos2d: Warning: TMX Layer %s has no tiles",
      7216: "cocos2d: TMXFormat: Unsupported TMX version: %s",
      7217: "cocos2d: TMXFomat: Unsupported orientation: %s",
      7218: "cc.TMXMapInfo.parseXMLFile(): unsupported compression method",
      7219: "cc.TMXMapInfo.parseXMLFile(): Only base64 and/or gzip/zlib maps are supported",
      7221: "cc.TMXMapInfo.parseXMLFile(): Texture '%s' not found.",
      7222: "Parse %s failed.",
      7236: "cc.TMXLayer.getTileAt(): TMXLayer: the tiles map has been released",
      7237: "cc.TMXLayer.getTileGIDAt(): TMXLayer: the tiles map has been released",
      7238: "cc.TMXLayer.setTileGID(): TMXLayer: the tiles map has been released",
      7239: "cc.TMXLayer.setTileGID(): invalid gid: %s",
      7240: "cc.TMXLayer.getTileFlagsAt(): TMXLayer: the tiles map has been released",
      7241: "cc.TiledMap.initWithXML(): Map not found. Please check the filename.",
      7401: "Failed to set _defaultArmatureIndex for '%s' because the index is out of range.",
      7402: "Failed to set _animationIndex for '%s' because the index is out of range.",
      7501: "Failed to set _defaultSkinIndex for '%s' because the index is out of range.",
      7502: "Failed to set _animationIndex for '%s' because its skeletonData is invalid.",
      7503: "Failed to set _animationIndex for '%s' because the index is out of range.",
      7504: "Can not render dynamic created SkeletonData",
      7505: "Invalid type of atlasFile, atlas should be registered as raw asset.",
      7506: "Failed to load spine atlas '$s'",
      7507: "Please re-import '%s' because its textures is not initialized! (This workflow will be improved in the future.)",
      7508: "The atlas asset of '%s' is not exists!",
      7509: "Spine: Animation not found: %s",
      7510: "Spine: Animation not found: %s",
      7600: "The context of RenderTexture is invalid.",
      7601: "cc.RenderTexture._initWithWidthAndHeightForWebGL() : only RGB and RGBA formats are valid for a render texture;",
      7602: "Could not attach texture to the framebuffer",
      7603: "clearDepth isn't supported on Cocos2d-Html5",
      7604: "saveToFile isn't supported on Cocos2d-Html5",
      7605: "newCCImage isn't supported on Cocos2d-Html5",
      7700: "On the web is always keep the aspect ratio",
      7701: "Can't know status",
      7702: "Video player's duration is not ready to get now!",
      7800: "Web does not support loading",
      7801: "Web does not support query history",
      7802: "Web does not support query history",
      7803: "The current browser does not support the GoBack",
      7804: "The current browser does not support the GoForward",
      7805: "Web does not support zoom",
      7900: "cc.math.Matrix3.assign(): current matrix equals matIn",
      7901: "cc.math.mat4Assign(): pOut equals pIn",
      7902: "cc.mat.Matrix4.assignFrom(): mat4 equals current matrix",
      7903: "cc.math.Matrix4 equal: pMat1 and pMat2 are same object.",
      7904: "cc.math.Matrix4.extractPlane: Invalid plane index",
      7905: "cc.math.mat4Assign(): pOut equals pIn",
      7906: "cc.mat.Matrix4.assignFrom(): mat4 equals current matrix",
      7907: "cc.math.Matrix4 equals: pMat1 and pMat2 are same object.",
      7908: "Invalid matrix mode specified",
      7909: "current quaternion is an invalid value",
      8000: "Can't handle this field type or size",
      8001: "No bytes requested",
      8002: "Too many bytes requested",
      8003: "Missing StripByteCounts!",
      8103: "cc.GLProgram.link(): Cannot link invalid program",
      8104: "cocos2d: ERROR: Failed to link program: %s",
      8105: "cocos2d: cc.shaderCache._loadDefaultShader, error shader type",
      8106: "Please load the resource firset : %s",
      8107: "cc.GLProgram.getUniformLocationForName(): uniform name should be non-null",
      8108: "cc.GLProgram.getUniformLocationForName(): Invalid operation. Cannot get uniform location when program is not initialized",
      8109: "modelView matrix is undefined.",
      8200: "Please set node's active instead of rigidbody's enabled.",
      8300: "Should only one camera exists, please check your project.",
      8301: "Camera does not support Canvas Mode.",
      8400: "Wrong type arguments, 'filePath' must be a String.",
      8401: "Since 1.10, `%s` accept %s instance directly, not a URL string. Please directly reference the %s object in your script, or load %s by loader first. Don't use %s's URL anymore.",
      9000: "Stencil manager does not support level bigger than %d in this device.",
      9001: "Stencil manager is already empty, cannot pop any mask",
      "0100": "%s not yet implemented."
    };
  }), {} ],
  2: [ (function(require, module, exports) {
    "use strict";
    require("../core/platform/CCClass");
    var misc = require("../core/utils/misc");
    cc.Action = cc.Class({
      name: "cc.Action",
      ctor: function ctor() {
        this.originalTarget = null;
        this.target = null;
        this.tag = cc.Action.TAG_INVALID;
      },
      clone: function clone() {
        var action = new cc.Action();
        action.originalTarget = null;
        action.target = null;
        action.tag = this.tag;
        return action;
      },
      isDone: function isDone() {
        return true;
      },
      startWithTarget: function startWithTarget(target) {
        this.originalTarget = target;
        this.target = target;
      },
      stop: function stop() {
        this.target = null;
      },
      step: function step(dt) {
        cc.logID(1006);
      },
      update: function update(dt) {
        cc.logID(1007);
      },
      getTarget: function getTarget() {
        return this.target;
      },
      setTarget: function setTarget(target) {
        this.target = target;
      },
      getOriginalTarget: function getOriginalTarget() {
        return this.originalTarget;
      },
      setOriginalTarget: function setOriginalTarget(originalTarget) {
        this.originalTarget = originalTarget;
      },
      getTag: function getTag() {
        return this.tag;
      },
      setTag: function setTag(tag) {
        this.tag = tag;
      },
      retain: function retain() {},
      release: function release() {}
    });
    cc.Action.TAG_INVALID = -1;
    cc.FiniteTimeAction = cc.Class({
      name: "cc.FiniteTimeAction",
      extends: cc.Action,
      ctor: function ctor() {
        this._duration = 0;
      },
      getDuration: function getDuration() {
        return this._duration * (this._timesForRepeat || 1);
      },
      setDuration: function setDuration(duration) {
        this._duration = duration;
      },
      reverse: function reverse() {
        cc.logID(1008);
        return null;
      },
      clone: function clone() {
        return new cc.FiniteTimeAction();
      }
    });
    cc.Speed = cc.Class({
      name: "cc.Speed",
      extends: cc.Action,
      ctor: function ctor(action, speed) {
        this._speed = 0;
        this._innerAction = null;
        action && this.initWithAction(action, speed);
      },
      getSpeed: function getSpeed() {
        return this._speed;
      },
      setSpeed: function setSpeed(speed) {
        this._speed = speed;
      },
      initWithAction: function initWithAction(action, speed) {
        if (!action) {
          cc.errorID(1021);
          return false;
        }
        this._innerAction = action;
        this._speed = speed;
        return true;
      },
      clone: function clone() {
        var action = new cc.Speed();
        action.initWithAction(this._innerAction.clone(), this._speed);
        return action;
      },
      startWithTarget: function startWithTarget(target) {
        cc.Action.prototype.startWithTarget.call(this, target);
        this._innerAction.startWithTarget(target);
      },
      stop: function stop() {
        this._innerAction.stop();
        cc.Action.prototype.stop.call(this);
      },
      step: function step(dt) {
        this._innerAction.step(dt * this._speed);
      },
      isDone: function isDone() {
        return this._innerAction.isDone();
      },
      reverse: function reverse() {
        return new cc.Speed(this._innerAction.reverse(), this._speed);
      },
      setInnerAction: function setInnerAction(action) {
        this._innerAction !== action && (this._innerAction = action);
      },
      getInnerAction: function getInnerAction() {
        return this._innerAction;
      }
    });
    cc.speed = function(action, speed) {
      return new cc.Speed(action, speed);
    };
    cc.Follow = cc.Class({
      name: "cc.Follow",
      extends: cc.Action,
      ctor: function ctor(followedNode, rect) {
        this._followedNode = null;
        this._boundarySet = false;
        this._boundaryFullyCovered = false;
        this._halfScreenSize = null;
        this._fullScreenSize = null;
        this.leftBoundary = 0;
        this.rightBoundary = 0;
        this.topBoundary = 0;
        this.bottomBoundary = 0;
        this._worldRect = cc.rect(0, 0, 0, 0);
        followedNode && (rect ? this.initWithTarget(followedNode, rect) : this.initWithTarget(followedNode));
      },
      clone: function clone() {
        var action = new cc.Follow();
        var locRect = this._worldRect;
        var rect = new cc.Rect(locRect.x, locRect.y, locRect.width, locRect.height);
        action.initWithTarget(this._followedNode, rect);
        return action;
      },
      isBoundarySet: function isBoundarySet() {
        return this._boundarySet;
      },
      setBoudarySet: function setBoudarySet(value) {
        this._boundarySet = value;
      },
      initWithTarget: function initWithTarget(followedNode, rect) {
        if (!followedNode) {
          cc.errorID(1022);
          return false;
        }
        var _this = this;
        rect = rect || cc.rect(0, 0, 0, 0);
        _this._followedNode = followedNode;
        _this._worldRect = rect;
        _this._boundarySet = !(0 === rect.width && 0 === rect.height);
        _this._boundaryFullyCovered = false;
        var winSize = cc.winSize;
        _this._fullScreenSize = cc.v2(winSize.width, winSize.height);
        _this._halfScreenSize = _this._fullScreenSize.mul(.5);
        if (_this._boundarySet) {
          _this.leftBoundary = -(rect.x + rect.width - _this._fullScreenSize.x);
          _this.rightBoundary = -rect.x;
          _this.topBoundary = -rect.y;
          _this.bottomBoundary = -(rect.y + rect.height - _this._fullScreenSize.y);
          _this.rightBoundary < _this.leftBoundary && (_this.rightBoundary = _this.leftBoundary = (_this.leftBoundary + _this.rightBoundary) / 2);
          _this.topBoundary < _this.bottomBoundary && (_this.topBoundary = _this.bottomBoundary = (_this.topBoundary + _this.bottomBoundary) / 2);
          _this.topBoundary === _this.bottomBoundary && _this.leftBoundary === _this.rightBoundary && (_this._boundaryFullyCovered = true);
        }
        return true;
      },
      step: function step(dt) {
        var targetWorldPos = this.target.convertToWorldSpaceAR(cc.Vec2.ZERO);
        var followedWorldPos = this._followedNode.convertToWorldSpaceAR(cc.Vec2.ZERO);
        var delta = targetWorldPos.sub(followedWorldPos);
        var tempPos = this.target.parent.convertToNodeSpaceAR(delta.add(this._halfScreenSize));
        if (this._boundarySet) {
          if (this._boundaryFullyCovered) return;
          this.target.setPosition(misc.clampf(tempPos.x, this.leftBoundary, this.rightBoundary), misc.clampf(tempPos.y, this.bottomBoundary, this.topBoundary));
        } else this.target.setPosition(tempPos.x, tempPos.y);
      },
      isDone: function isDone() {
        return !this._followedNode.activeInHierarchy;
      },
      stop: function stop() {
        this.target = null;
        cc.Action.prototype.stop.call(this);
      }
    });
    cc.follow = function(followedNode, rect) {
      return new cc.Follow(followedNode, rect);
    };
  }), {
    "../core/platform/CCClass": 118,
    "../core/utils/misc": 204
  } ],
  3: [ (function(require, module, exports) {
    "use strict";
    function cardinalSplineAt(p0, p1, p2, p3, tension, t) {
      var t2 = t * t;
      var t3 = t2 * t;
      var s = (1 - tension) / 2;
      var b1 = s * (2 * t2 - t3 - t);
      var b2 = s * (-t3 + t2) + (2 * t3 - 3 * t2 + 1);
      var b3 = s * (t3 - 2 * t2 + t) + (-2 * t3 + 3 * t2);
      var b4 = s * (t3 - t2);
      var x = p0.x * b1 + p1.x * b2 + p2.x * b3 + p3.x * b4;
      var y = p0.y * b1 + p1.y * b2 + p2.y * b3 + p3.y * b4;
      return cc.v2(x, y);
    }
    function getControlPointAt(controlPoints, pos) {
      var p = Math.min(controlPoints.length - 1, Math.max(pos, 0));
      return controlPoints[p];
    }
    function reverseControlPoints(controlPoints) {
      var newArray = [];
      for (var i = controlPoints.length - 1; i >= 0; i--) newArray.push(cc.v2(controlPoints[i].x, controlPoints[i].y));
      return newArray;
    }
    function cloneControlPoints(controlPoints) {
      var newArray = [];
      for (var i = 0; i < controlPoints.length; i++) newArray.push(cc.v2(controlPoints[i].x, controlPoints[i].y));
      return newArray;
    }
    cc.CardinalSplineTo = cc.Class({
      name: "cc.CardinalSplineTo",
      extends: cc.ActionInterval,
      ctor: function ctor(duration, points, tension) {
        this._points = [];
        this._deltaT = 0;
        this._tension = 0;
        this._previousPosition = null;
        this._accumulatedDiff = null;
        void 0 !== tension && cc.CardinalSplineTo.prototype.initWithDuration.call(this, duration, points, tension);
      },
      initWithDuration: function initWithDuration(duration, points, tension) {
        if (!points || 0 === points.length) {
          cc.errorID(1024);
          return false;
        }
        if (cc.ActionInterval.prototype.initWithDuration.call(this, duration)) {
          this.setPoints(points);
          this._tension = tension;
          return true;
        }
        return false;
      },
      clone: function clone() {
        var action = new cc.CardinalSplineTo();
        action.initWithDuration(this._duration, cloneControlPoints(this._points), this._tension);
        return action;
      },
      startWithTarget: function startWithTarget(target) {
        cc.ActionInterval.prototype.startWithTarget.call(this, target);
        this._deltaT = 1 / (this._points.length - 1);
        this._previousPosition = cc.v2(this.target.x, this.target.y);
        this._accumulatedDiff = cc.v2(0, 0);
      },
      update: function update(dt) {
        dt = this._computeEaseTime(dt);
        var p, lt;
        var ps = this._points;
        if (1 === dt) {
          p = ps.length - 1;
          lt = 1;
        } else {
          var locDT = this._deltaT;
          p = 0 | dt / locDT;
          lt = (dt - locDT * p) / locDT;
        }
        var newPos = cardinalSplineAt(getControlPointAt(ps, p - 1), getControlPointAt(ps, p - 0), getControlPointAt(ps, p + 1), getControlPointAt(ps, p + 2), this._tension, lt);
        if (cc.macro.ENABLE_STACKABLE_ACTIONS) {
          var tempX, tempY;
          tempX = this.target.x - this._previousPosition.x;
          tempY = this.target.y - this._previousPosition.y;
          if (0 !== tempX || 0 !== tempY) {
            var locAccDiff = this._accumulatedDiff;
            tempX = locAccDiff.x + tempX;
            tempY = locAccDiff.y + tempY;
            locAccDiff.x = tempX;
            locAccDiff.y = tempY;
            newPos.x += tempX;
            newPos.y += tempY;
          }
        }
        this.updatePosition(newPos);
      },
      reverse: function reverse() {
        var reversePoints = reverseControlPoints(this._points);
        return cc.cardinalSplineTo(this._duration, reversePoints, this._tension);
      },
      updatePosition: function updatePosition(newPos) {
        this.target.setPosition(newPos);
        this._previousPosition = newPos;
      },
      getPoints: function getPoints() {
        return this._points;
      },
      setPoints: function setPoints(points) {
        this._points = points;
      }
    });
    cc.cardinalSplineTo = function(duration, points, tension) {
      return new cc.CardinalSplineTo(duration, points, tension);
    };
    cc.CardinalSplineBy = cc.Class({
      name: "cc.CardinalSplineBy",
      extends: cc.CardinalSplineTo,
      ctor: function ctor(duration, points, tension) {
        this._startPosition = cc.v2(0, 0);
        void 0 !== tension && this.initWithDuration(duration, points, tension);
      },
      startWithTarget: function startWithTarget(target) {
        cc.CardinalSplineTo.prototype.startWithTarget.call(this, target);
        this._startPosition.x = target.x;
        this._startPosition.y = target.y;
      },
      reverse: function reverse() {
        var copyConfig = this._points.slice();
        var current;
        var p = copyConfig[0];
        for (var i = 1; i < copyConfig.length; ++i) {
          current = copyConfig[i];
          copyConfig[i] = current.sub(p);
          p = current;
        }
        var reverseArray = reverseControlPoints(copyConfig);
        p = reverseArray[reverseArray.length - 1];
        reverseArray.pop();
        p.x = -p.x;
        p.y = -p.y;
        reverseArray.unshift(p);
        for (var i = 1; i < reverseArray.length; ++i) {
          current = reverseArray[i];
          current.x = -current.x;
          current.y = -current.y;
          current.x += p.x;
          current.y += p.y;
          reverseArray[i] = current;
          p = current;
        }
        return cc.cardinalSplineBy(this._duration, reverseArray, this._tension);
      },
      updatePosition: function updatePosition(newPos) {
        var pos = this._startPosition;
        var posX = newPos.x + pos.x;
        var posY = newPos.y + pos.y;
        this._previousPosition.x = posX;
        this._previousPosition.y = posY;
        this.target.setPosition(posX, posY);
      },
      clone: function clone() {
        var a = new cc.CardinalSplineBy();
        a.initWithDuration(this._duration, cloneControlPoints(this._points), this._tension);
        return a;
      }
    });
    cc.cardinalSplineBy = function(duration, points, tension) {
      return new cc.CardinalSplineBy(duration, points, tension);
    };
    cc.CatmullRomTo = cc.Class({
      name: "cc.CatmullRomTo",
      extends: cc.CardinalSplineTo,
      ctor: function ctor(dt, points) {
        points && this.initWithDuration(dt, points);
      },
      initWithDuration: function initWithDuration(dt, points) {
        return cc.CardinalSplineTo.prototype.initWithDuration.call(this, dt, points, .5);
      },
      clone: function clone() {
        var action = new cc.CatmullRomTo();
        action.initWithDuration(this._duration, cloneControlPoints(this._points));
        return action;
      }
    });
    cc.catmullRomTo = function(dt, points) {
      return new cc.CatmullRomTo(dt, points);
    };
    cc.CatmullRomBy = cc.Class({
      name: "cc.CatmullRomBy",
      extends: cc.CardinalSplineBy,
      ctor: function ctor(dt, points) {
        points && this.initWithDuration(dt, points);
      },
      initWithDuration: function initWithDuration(dt, points) {
        return cc.CardinalSplineTo.prototype.initWithDuration.call(this, dt, points, .5);
      },
      clone: function clone() {
        var action = new cc.CatmullRomBy();
        action.initWithDuration(this._duration, cloneControlPoints(this._points));
        return action;
      }
    });
    cc.catmullRomBy = function(dt, points) {
      return new cc.CatmullRomBy(dt, points);
    };
  }), {} ],
  4: [ (function(require, module, exports) {
    "use strict";
    cc.easeIn = function(rate) {
      return {
        _rate: rate,
        easing: function easing(dt) {
          return Math.pow(dt, this._rate);
        },
        reverse: function reverse() {
          return cc.easeIn(1 / this._rate);
        }
      };
    };
    cc.easeOut = function(rate) {
      return {
        _rate: rate,
        easing: function easing(dt) {
          return Math.pow(dt, 1 / this._rate);
        },
        reverse: function reverse() {
          return cc.easeOut(1 / this._rate);
        }
      };
    };
    cc.easeInOut = function(rate) {
      return {
        _rate: rate,
        easing: function easing(dt) {
          dt *= 2;
          return dt < 1 ? .5 * Math.pow(dt, this._rate) : 1 - .5 * Math.pow(2 - dt, this._rate);
        },
        reverse: function reverse() {
          return cc.easeInOut(this._rate);
        }
      };
    };
    var _easeExponentialInObj = {
      easing: function easing(dt) {
        return 0 === dt ? 0 : Math.pow(2, 10 * (dt - 1));
      },
      reverse: function reverse() {
        return _easeExponentialOutObj;
      }
    };
    cc.easeExponentialIn = function() {
      return _easeExponentialInObj;
    };
    var _easeExponentialOutObj = {
      easing: function easing(dt) {
        return 1 === dt ? 1 : 1 - Math.pow(2, -10 * dt);
      },
      reverse: function reverse() {
        return _easeExponentialInObj;
      }
    };
    cc.easeExponentialOut = function() {
      return _easeExponentialOutObj;
    };
    var _easeExponentialInOutObj = {
      easing: function easing(dt) {
        if (1 !== dt && 0 !== dt) {
          dt *= 2;
          return dt < 1 ? .5 * Math.pow(2, 10 * (dt - 1)) : .5 * (2 - Math.pow(2, -10 * (dt - 1)));
        }
        return dt;
      },
      reverse: function reverse() {
        return _easeExponentialInOutObj;
      }
    };
    cc.easeExponentialInOut = function() {
      return _easeExponentialInOutObj;
    };
    var _easeSineInObj = {
      easing: function easing(dt) {
        return 0 === dt || 1 === dt ? dt : -1 * Math.cos(dt * Math.PI / 2) + 1;
      },
      reverse: function reverse() {
        return _easeSineOutObj;
      }
    };
    cc.easeSineIn = function() {
      return _easeSineInObj;
    };
    var _easeSineOutObj = {
      easing: function easing(dt) {
        return 0 === dt || 1 === dt ? dt : Math.sin(dt * Math.PI / 2);
      },
      reverse: function reverse() {
        return _easeSineInObj;
      }
    };
    cc.easeSineOut = function() {
      return _easeSineOutObj;
    };
    var _easeSineInOutObj = {
      easing: function easing(dt) {
        return 0 === dt || 1 === dt ? dt : -.5 * (Math.cos(Math.PI * dt) - 1);
      },
      reverse: function reverse() {
        return _easeSineInOutObj;
      }
    };
    cc.easeSineInOut = function() {
      return _easeSineInOutObj;
    };
    var _easeElasticInObj = {
      easing: function easing(dt) {
        if (0 === dt || 1 === dt) return dt;
        dt -= 1;
        return -Math.pow(2, 10 * dt) * Math.sin((dt - .075) * Math.PI * 2 / .3);
      },
      reverse: function reverse() {
        return _easeElasticOutObj;
      }
    };
    cc.easeElasticIn = function(period) {
      if (period && .3 !== period) return {
        _period: period,
        easing: function easing(dt) {
          if (0 === dt || 1 === dt) return dt;
          dt -= 1;
          return -Math.pow(2, 10 * dt) * Math.sin((dt - this._period / 4) * Math.PI * 2 / this._period);
        },
        reverse: function reverse() {
          return cc.easeElasticOut(this._period);
        }
      };
      return _easeElasticInObj;
    };
    var _easeElasticOutObj = {
      easing: function easing(dt) {
        return 0 === dt || 1 === dt ? dt : Math.pow(2, -10 * dt) * Math.sin((dt - .075) * Math.PI * 2 / .3) + 1;
      },
      reverse: function reverse() {
        return _easeElasticInObj;
      }
    };
    cc.easeElasticOut = function(period) {
      if (period && .3 !== period) return {
        _period: period,
        easing: function easing(dt) {
          return 0 === dt || 1 === dt ? dt : Math.pow(2, -10 * dt) * Math.sin((dt - this._period / 4) * Math.PI * 2 / this._period) + 1;
        },
        reverse: function reverse() {
          return cc.easeElasticIn(this._period);
        }
      };
      return _easeElasticOutObj;
    };
    cc.easeElasticInOut = function(period) {
      period = period || .3;
      return {
        _period: period,
        easing: function easing(dt) {
          var newT = 0;
          var locPeriod = this._period;
          if (0 === dt || 1 === dt) newT = dt; else {
            dt *= 2;
            locPeriod || (locPeriod = this._period = .3 * 1.5);
            var s = locPeriod / 4;
            dt -= 1;
            newT = dt < 0 ? -.5 * Math.pow(2, 10 * dt) * Math.sin((dt - s) * Math.PI * 2 / locPeriod) : Math.pow(2, -10 * dt) * Math.sin((dt - s) * Math.PI * 2 / locPeriod) * .5 + 1;
          }
          return newT;
        },
        reverse: function reverse() {
          return cc.easeElasticInOut(this._period);
        }
      };
    };
    function _bounceTime(time1) {
      if (time1 < 1 / 2.75) return 7.5625 * time1 * time1;
      if (time1 < 2 / 2.75) {
        time1 -= 1.5 / 2.75;
        return 7.5625 * time1 * time1 + .75;
      }
      if (time1 < 2.5 / 2.75) {
        time1 -= 2.25 / 2.75;
        return 7.5625 * time1 * time1 + .9375;
      }
      time1 -= 2.625 / 2.75;
      return 7.5625 * time1 * time1 + .984375;
    }
    var _easeBounceInObj = {
      easing: function easing(dt) {
        return 1 - _bounceTime(1 - dt);
      },
      reverse: function reverse() {
        return _easeBounceOutObj;
      }
    };
    cc.easeBounceIn = function() {
      return _easeBounceInObj;
    };
    var _easeBounceOutObj = {
      easing: function easing(dt) {
        return _bounceTime(dt);
      },
      reverse: function reverse() {
        return _easeBounceInObj;
      }
    };
    cc.easeBounceOut = function() {
      return _easeBounceOutObj;
    };
    var _easeBounceInOutObj = {
      easing: function easing(time1) {
        var newT;
        if (time1 < .5) {
          time1 *= 2;
          newT = .5 * (1 - _bounceTime(1 - time1));
        } else newT = .5 * _bounceTime(2 * time1 - 1) + .5;
        return newT;
      },
      reverse: function reverse() {
        return _easeBounceInOutObj;
      }
    };
    cc.easeBounceInOut = function() {
      return _easeBounceInOutObj;
    };
    var _easeBackInObj = {
      easing: function easing(time1) {
        var overshoot = 1.70158;
        return 0 === time1 || 1 === time1 ? time1 : time1 * time1 * ((overshoot + 1) * time1 - overshoot);
      },
      reverse: function reverse() {
        return _easeBackOutObj;
      }
    };
    cc.easeBackIn = function() {
      return _easeBackInObj;
    };
    var _easeBackOutObj = {
      easing: function easing(time1) {
        var overshoot = 1.70158;
        time1 -= 1;
        return time1 * time1 * ((overshoot + 1) * time1 + overshoot) + 1;
      },
      reverse: function reverse() {
        return _easeBackInObj;
      }
    };
    cc.easeBackOut = function() {
      return _easeBackOutObj;
    };
    var _easeBackInOutObj = {
      easing: function easing(time1) {
        var overshoot = 2.5949095;
        time1 *= 2;
        if (time1 < 1) return time1 * time1 * ((overshoot + 1) * time1 - overshoot) / 2;
        time1 -= 2;
        return time1 * time1 * ((overshoot + 1) * time1 + overshoot) / 2 + 1;
      },
      reverse: function reverse() {
        return _easeBackInOutObj;
      }
    };
    cc.easeBackInOut = function() {
      return _easeBackInOutObj;
    };
    cc.easeBezierAction = function(a, b, c, d) {
      return {
        easing: function easing(t) {
          return Math.pow(1 - t, 3) * a + 3 * t * Math.pow(1 - t, 2) * b + 3 * Math.pow(t, 2) * (1 - t) * c + Math.pow(t, 3) * d;
        },
        reverse: function reverse() {
          return cc.easeBezierAction(d, c, b, a);
        }
      };
    };
    var _easeQuadraticActionIn = {
      easing: function easing(time) {
        return Math.pow(time, 2);
      },
      reverse: function reverse() {
        return _easeQuadraticActionIn;
      }
    };
    cc.easeQuadraticActionIn = function() {
      return _easeQuadraticActionIn;
    };
    var _easeQuadraticActionOut = {
      easing: function easing(time) {
        return -time * (time - 2);
      },
      reverse: function reverse() {
        return _easeQuadraticActionOut;
      }
    };
    cc.easeQuadraticActionOut = function() {
      return _easeQuadraticActionOut;
    };
    var _easeQuadraticActionInOut = {
      easing: function easing(time) {
        var resultTime = time;
        time *= 2;
        if (time < 1) resultTime = time * time * .5; else {
          --time;
          resultTime = -.5 * (time * (time - 2) - 1);
        }
        return resultTime;
      },
      reverse: function reverse() {
        return _easeQuadraticActionInOut;
      }
    };
    cc.easeQuadraticActionInOut = function() {
      return _easeQuadraticActionInOut;
    };
    var _easeQuarticActionIn = {
      easing: function easing(time) {
        return time * time * time * time;
      },
      reverse: function reverse() {
        return _easeQuarticActionIn;
      }
    };
    cc.easeQuarticActionIn = function() {
      return _easeQuarticActionIn;
    };
    var _easeQuarticActionOut = {
      easing: function easing(time) {
        time -= 1;
        return -(time * time * time * time - 1);
      },
      reverse: function reverse() {
        return _easeQuarticActionOut;
      }
    };
    cc.easeQuarticActionOut = function() {
      return _easeQuarticActionOut;
    };
    var _easeQuarticActionInOut = {
      easing: function easing(time) {
        time *= 2;
        if (time < 1) return .5 * time * time * time * time;
        time -= 2;
        return -.5 * (time * time * time * time - 2);
      },
      reverse: function reverse() {
        return _easeQuarticActionInOut;
      }
    };
    cc.easeQuarticActionInOut = function() {
      return _easeQuarticActionInOut;
    };
    var _easeQuinticActionIn = {
      easing: function easing(time) {
        return time * time * time * time * time;
      },
      reverse: function reverse() {
        return _easeQuinticActionIn;
      }
    };
    cc.easeQuinticActionIn = function() {
      return _easeQuinticActionIn;
    };
    var _easeQuinticActionOut = {
      easing: function easing(time) {
        time -= 1;
        return time * time * time * time * time + 1;
      },
      reverse: function reverse() {
        return _easeQuinticActionOut;
      }
    };
    cc.easeQuinticActionOut = function() {
      return _easeQuinticActionOut;
    };
    var _easeQuinticActionInOut = {
      easing: function easing(time) {
        time *= 2;
        if (time < 1) return .5 * time * time * time * time * time;
        time -= 2;
        return .5 * (time * time * time * time * time + 2);
      },
      reverse: function reverse() {
        return _easeQuinticActionInOut;
      }
    };
    cc.easeQuinticActionInOut = function() {
      return _easeQuinticActionInOut;
    };
    var _easeCircleActionIn = {
      easing: function easing(time) {
        return -1 * (Math.sqrt(1 - time * time) - 1);
      },
      reverse: function reverse() {
        return _easeCircleActionIn;
      }
    };
    cc.easeCircleActionIn = function() {
      return _easeCircleActionIn;
    };
    var _easeCircleActionOut = {
      easing: function easing(time) {
        time -= 1;
        return Math.sqrt(1 - time * time);
      },
      reverse: function reverse() {
        return _easeCircleActionOut;
      }
    };
    cc.easeCircleActionOut = function() {
      return _easeCircleActionOut;
    };
    var _easeCircleActionInOut = {
      easing: function easing(time) {
        time *= 2;
        if (time < 1) return -.5 * (Math.sqrt(1 - time * time) - 1);
        time -= 2;
        return .5 * (Math.sqrt(1 - time * time) + 1);
      },
      reverse: function reverse() {
        return _easeCircleActionInOut;
      }
    };
    cc.easeCircleActionInOut = function() {
      return _easeCircleActionInOut;
    };
    var _easeCubicActionIn = {
      easing: function easing(time) {
        return time * time * time;
      },
      reverse: function reverse() {
        return _easeCubicActionIn;
      }
    };
    cc.easeCubicActionIn = function() {
      return _easeCubicActionIn;
    };
    var _easeCubicActionOut = {
      easing: function easing(time) {
        time -= 1;
        return time * time * time + 1;
      },
      reverse: function reverse() {
        return _easeCubicActionOut;
      }
    };
    cc.easeCubicActionOut = function() {
      return _easeCubicActionOut;
    };
    var _easeCubicActionInOut = {
      easing: function easing(time) {
        time *= 2;
        if (time < 1) return .5 * time * time * time;
        time -= 2;
        return .5 * (time * time * time + 2);
      },
      reverse: function reverse() {
        return _easeCubicActionInOut;
      }
    };
    cc.easeCubicActionInOut = function() {
      return _easeCubicActionInOut;
    };
  }), {} ],
  5: [ (function(require, module, exports) {
    "use strict";
    cc.ActionInstant = cc.Class({
      name: "cc.ActionInstant",
      extends: cc.FiniteTimeAction,
      isDone: function isDone() {
        return true;
      },
      step: function step(dt) {
        this.update(1);
      },
      update: function update(dt) {},
      reverse: function reverse() {
        return this.clone();
      },
      clone: function clone() {
        return new cc.ActionInstant();
      }
    });
    cc.Show = cc.Class({
      name: "cc.Show",
      extends: cc.ActionInstant,
      update: function update(dt) {
        var _renderComps = this.target.getComponentsInChildren(cc.RenderComponent);
        for (var i = 0; i < _renderComps.length; ++i) {
          var render = _renderComps[i];
          render.enabled = true;
        }
      },
      reverse: function reverse() {
        return new cc.Hide();
      },
      clone: function clone() {
        return new cc.Show();
      }
    });
    cc.show = function() {
      return new cc.Show();
    };
    cc.Hide = cc.Class({
      name: "cc.Hide",
      extends: cc.ActionInstant,
      update: function update(dt) {
        var _renderComps = this.target.getComponentsInChildren(cc.RenderComponent);
        for (var i = 0; i < _renderComps.length; ++i) {
          var render = _renderComps[i];
          render.enabled = false;
        }
      },
      reverse: function reverse() {
        return new cc.Show();
      },
      clone: function clone() {
        return new cc.Hide();
      }
    });
    cc.hide = function() {
      return new cc.Hide();
    };
    cc.ToggleVisibility = cc.Class({
      name: "cc.ToggleVisibility",
      extends: cc.ActionInstant,
      update: function update(dt) {
        var _renderComps = this.target.getComponentsInChildren(cc.RenderComponent);
        for (var i = 0; i < _renderComps.length; ++i) {
          var render = _renderComps[i];
          render.enabled = !render.enabled;
        }
      },
      reverse: function reverse() {
        return new cc.ToggleVisibility();
      },
      clone: function clone() {
        return new cc.ToggleVisibility();
      }
    });
    cc.toggleVisibility = function() {
      return new cc.ToggleVisibility();
    };
    cc.RemoveSelf = cc.Class({
      name: "cc.RemoveSelf",
      extends: cc.ActionInstant,
      ctor: function ctor(isNeedCleanUp) {
        this._isNeedCleanUp = true;
        void 0 !== isNeedCleanUp && this.init(isNeedCleanUp);
      },
      update: function update(dt) {
        this.target.removeFromParent(this._isNeedCleanUp);
      },
      init: function init(isNeedCleanUp) {
        this._isNeedCleanUp = isNeedCleanUp;
        return true;
      },
      reverse: function reverse() {
        return new cc.RemoveSelf(this._isNeedCleanUp);
      },
      clone: function clone() {
        return new cc.RemoveSelf(this._isNeedCleanUp);
      }
    });
    cc.removeSelf = function(isNeedCleanUp) {
      return new cc.RemoveSelf(isNeedCleanUp);
    };
    cc.FlipX = cc.Class({
      name: "cc.FlipX",
      extends: cc.ActionInstant,
      ctor: function ctor(flip) {
        this._flippedX = false;
        void 0 !== flip && this.initWithFlipX(flip);
      },
      initWithFlipX: function initWithFlipX(flip) {
        this._flippedX = flip;
        return true;
      },
      update: function update(dt) {
        this.target.scaleX = Math.abs(this.target.scaleX) * (this._flippedX ? -1 : 1);
      },
      reverse: function reverse() {
        return new cc.FlipX(!this._flippedX);
      },
      clone: function clone() {
        var action = new cc.FlipX();
        action.initWithFlipX(this._flippedX);
        return action;
      }
    });
    cc.flipX = function(flip) {
      return new cc.FlipX(flip);
    };
    cc.FlipY = cc.Class({
      name: "cc.FlipY",
      extends: cc.ActionInstant,
      ctor: function ctor(flip) {
        this._flippedY = false;
        void 0 !== flip && this.initWithFlipY(flip);
      },
      initWithFlipY: function initWithFlipY(flip) {
        this._flippedY = flip;
        return true;
      },
      update: function update(dt) {
        this.target.scaleY = Math.abs(this.target.scaleY) * (this._flippedY ? -1 : 1);
      },
      reverse: function reverse() {
        return new cc.FlipY(!this._flippedY);
      },
      clone: function clone() {
        var action = new cc.FlipY();
        action.initWithFlipY(this._flippedY);
        return action;
      }
    });
    cc.flipY = function(flip) {
      return new cc.FlipY(flip);
    };
    cc.Place = cc.Class({
      name: "cc.Place",
      extends: cc.ActionInstant,
      ctor: function ctor(pos, y) {
        this._x = 0;
        this._y = 0;
        if (void 0 !== pos) {
          if (void 0 !== pos.x) {
            y = pos.y;
            pos = pos.x;
          }
          this.initWithPosition(pos, y);
        }
      },
      initWithPosition: function initWithPosition(x, y) {
        this._x = x;
        this._y = y;
        return true;
      },
      update: function update(dt) {
        this.target.setPosition(this._x, this._y);
      },
      clone: function clone() {
        var action = new cc.Place();
        action.initWithPosition(this._x, this._y);
        return action;
      }
    });
    cc.place = function(pos, y) {
      return new cc.Place(pos, y);
    };
    cc.CallFunc = cc.Class({
      name: "cc.CallFunc",
      extends: cc.ActionInstant,
      ctor: function ctor(selector, selectorTarget, data) {
        this._selectorTarget = null;
        this._function = null;
        this._data = null;
        this.initWithFunction(selector, selectorTarget, data);
      },
      initWithFunction: function initWithFunction(selector, selectorTarget, data) {
        selector && (this._function = selector);
        selectorTarget && (this._selectorTarget = selectorTarget);
        void 0 !== data && (this._data = data);
        return true;
      },
      execute: function execute() {
        this._function && this._function.call(this._selectorTarget, this.target, this._data);
      },
      update: function update(dt) {
        this.execute();
      },
      getTargetCallback: function getTargetCallback() {
        return this._selectorTarget;
      },
      setTargetCallback: function setTargetCallback(sel) {
        if (sel !== this._selectorTarget) {
          this._selectorTarget && (this._selectorTarget = null);
          this._selectorTarget = sel;
        }
      },
      clone: function clone() {
        var action = new cc.CallFunc();
        action.initWithFunction(this._function, this._selectorTarget, this._data);
        return action;
      }
    });
    cc.callFunc = function(selector, selectorTarget, data) {
      return new cc.CallFunc(selector, selectorTarget, data);
    };
  }), {} ],
  6: [ (function(require, module, exports) {
    "use strict";
    cc.ActionInterval = cc.Class({
      name: "cc.ActionInterval",
      extends: cc.FiniteTimeAction,
      ctor: function ctor(d) {
        this.MAX_VALUE = 2;
        this._elapsed = 0;
        this._firstTick = false;
        this._easeList = null;
        this._speed = 1;
        this._timesForRepeat = 1;
        this._repeatForever = false;
        this._repeatMethod = false;
        this._speedMethod = false;
        void 0 !== d && cc.ActionInterval.prototype.initWithDuration.call(this, d);
      },
      getElapsed: function getElapsed() {
        return this._elapsed;
      },
      initWithDuration: function initWithDuration(d) {
        this._duration = 0 === d ? cc.macro.FLT_EPSILON : d;
        this._elapsed = 0;
        this._firstTick = true;
        return true;
      },
      isDone: function isDone() {
        return this._elapsed >= this._duration;
      },
      _cloneDecoration: function _cloneDecoration(action) {
        action._repeatForever = this._repeatForever;
        action._speed = this._speed;
        action._timesForRepeat = this._timesForRepeat;
        action._easeList = this._easeList;
        action._speedMethod = this._speedMethod;
        action._repeatMethod = this._repeatMethod;
      },
      _reverseEaseList: function _reverseEaseList(action) {
        if (this._easeList) {
          action._easeList = [];
          for (var i = 0; i < this._easeList.length; i++) action._easeList.push(this._easeList[i].reverse());
        }
      },
      clone: function clone() {
        var action = new cc.ActionInterval(this._duration);
        this._cloneDecoration(action);
        return action;
      },
      easing: function easing(easeObj) {
        this._easeList ? this._easeList.length = 0 : this._easeList = [];
        for (var i = 0; i < arguments.length; i++) this._easeList.push(arguments[i]);
        return this;
      },
      _computeEaseTime: function _computeEaseTime(dt) {
        var locList = this._easeList;
        if (!locList || 0 === locList.length) return dt;
        for (var i = 0, n = locList.length; i < n; i++) dt = locList[i].easing(dt);
        return dt;
      },
      step: function step(dt) {
        if (this._firstTick) {
          this._firstTick = false;
          this._elapsed = 0;
        } else this._elapsed += dt;
        var t = this._elapsed / (this._duration > 1.192092896e-7 ? this._duration : 1.192092896e-7);
        t = 1 > t ? t : 1;
        this.update(t > 0 ? t : 0);
        if (this._repeatMethod && this._timesForRepeat > 1 && this.isDone()) {
          this._repeatForever || this._timesForRepeat--;
          this.startWithTarget(this.target);
          this.step(this._elapsed - this._duration);
        }
      },
      startWithTarget: function startWithTarget(target) {
        cc.Action.prototype.startWithTarget.call(this, target);
        this._elapsed = 0;
        this._firstTick = true;
      },
      reverse: function reverse() {
        cc.logID(1010);
        return null;
      },
      setAmplitudeRate: function setAmplitudeRate(amp) {
        cc.logID(1011);
      },
      getAmplitudeRate: function getAmplitudeRate() {
        cc.logID(1012);
        return 0;
      },
      speed: function speed(_speed) {
        if (_speed <= 0) {
          cc.logID(1013);
          return this;
        }
        this._speedMethod = true;
        this._speed *= _speed;
        return this;
      },
      getSpeed: function getSpeed() {
        return this._speed;
      },
      setSpeed: function setSpeed(speed) {
        this._speed = speed;
        return this;
      },
      repeat: function repeat(times) {
        times = Math.round(times);
        if (isNaN(times) || times < 1) {
          cc.logID(1014);
          return this;
        }
        this._repeatMethod = true;
        this._timesForRepeat *= times;
        return this;
      },
      repeatForever: function repeatForever() {
        this._repeatMethod = true;
        this._timesForRepeat = this.MAX_VALUE;
        this._repeatForever = true;
        return this;
      }
    });
    cc.actionInterval = function(d) {
      return new cc.ActionInterval(d);
    };
    cc.Sequence = cc.Class({
      name: "cc.Sequence",
      extends: cc.ActionInterval,
      ctor: function ctor(tempArray) {
        this._actions = [];
        this._split = null;
        this._last = 0;
        this._reversed = false;
        var paramArray = tempArray instanceof Array ? tempArray : arguments;
        if (1 === paramArray.length) {
          cc.errorID(1019);
          return;
        }
        var last = paramArray.length - 1;
        last >= 0 && null == paramArray[last] && cc.logID(1015);
        if (last >= 0) {
          var prev = paramArray[0], action1;
          for (var i = 1; i < last; i++) if (paramArray[i]) {
            action1 = prev;
            prev = cc.Sequence._actionOneTwo(action1, paramArray[i]);
          }
          this.initWithTwoActions(prev, paramArray[last]);
        }
      },
      initWithTwoActions: function initWithTwoActions(actionOne, actionTwo) {
        if (!actionOne || !actionTwo) {
          cc.errorID(1025);
          return false;
        }
        var durationOne = actionOne._duration, durationTwo = actionTwo._duration;
        durationOne *= actionOne._repeatMethod ? actionOne._timesForRepeat : 1;
        durationTwo *= actionTwo._repeatMethod ? actionTwo._timesForRepeat : 1;
        var d = durationOne + durationTwo;
        this.initWithDuration(d);
        this._actions[0] = actionOne;
        this._actions[1] = actionTwo;
        return true;
      },
      clone: function clone() {
        var action = new cc.Sequence();
        this._cloneDecoration(action);
        action.initWithTwoActions(this._actions[0].clone(), this._actions[1].clone());
        return action;
      },
      startWithTarget: function startWithTarget(target) {
        cc.ActionInterval.prototype.startWithTarget.call(this, target);
        this._split = this._actions[0]._duration / this._duration;
        this._split *= this._actions[0]._repeatMethod ? this._actions[0]._timesForRepeat : 1;
        this._last = -1;
      },
      stop: function stop() {
        -1 !== this._last && this._actions[this._last].stop();
        cc.Action.prototype.stop.call(this);
      },
      update: function update(dt) {
        var new_t, found = 0;
        var locSplit = this._split, locActions = this._actions, locLast = this._last, actionFound;
        dt = this._computeEaseTime(dt);
        if (dt < locSplit) {
          new_t = 0 !== locSplit ? dt / locSplit : 1;
          if (0 === found && 1 === locLast && this._reversed) {
            locActions[1].update(0);
            locActions[1].stop();
          }
        } else {
          found = 1;
          new_t = 1 === locSplit ? 1 : (dt - locSplit) / (1 - locSplit);
          if (-1 === locLast) {
            locActions[0].startWithTarget(this.target);
            locActions[0].update(1);
            locActions[0].stop();
          }
          if (0 === locLast) {
            locActions[0].update(1);
            locActions[0].stop();
          }
        }
        actionFound = locActions[found];
        if (locLast === found && actionFound.isDone()) return;
        locLast !== found && actionFound.startWithTarget(this.target);
        new_t *= actionFound._timesForRepeat;
        actionFound.update(new_t > 1 ? new_t % 1 : new_t);
        this._last = found;
      },
      reverse: function reverse() {
        var action = cc.Sequence._actionOneTwo(this._actions[1].reverse(), this._actions[0].reverse());
        this._cloneDecoration(action);
        this._reverseEaseList(action);
        action._reversed = true;
        return action;
      }
    });
    cc.sequence = function(tempArray) {
      var paramArray = tempArray instanceof Array ? tempArray : arguments;
      if (1 === paramArray.length) {
        cc.errorID(1019);
        return null;
      }
      var last = paramArray.length - 1;
      last >= 0 && null == paramArray[last] && cc.logID(1015);
      var result = null;
      if (last >= 0) {
        result = paramArray[0];
        for (var i = 1; i <= last; i++) paramArray[i] && (result = cc.Sequence._actionOneTwo(result, paramArray[i]));
      }
      return result;
    };
    cc.Sequence._actionOneTwo = function(actionOne, actionTwo) {
      var sequence = new cc.Sequence();
      sequence.initWithTwoActions(actionOne, actionTwo);
      return sequence;
    };
    cc.Repeat = cc.Class({
      name: "cc.Repeat",
      extends: cc.ActionInterval,
      ctor: function ctor(action, times) {
        this._times = 0;
        this._total = 0;
        this._nextDt = 0;
        this._actionInstant = false;
        this._innerAction = null;
        void 0 !== times && this.initWithAction(action, times);
      },
      initWithAction: function initWithAction(action, times) {
        var duration = action._duration * times;
        if (this.initWithDuration(duration)) {
          this._times = times;
          this._innerAction = action;
          if (action instanceof cc.ActionInstant) {
            this._actionInstant = true;
            this._times -= 1;
          }
          this._total = 0;
          return true;
        }
        return false;
      },
      clone: function clone() {
        var action = new cc.Repeat();
        this._cloneDecoration(action);
        action.initWithAction(this._innerAction.clone(), this._times);
        return action;
      },
      startWithTarget: function startWithTarget(target) {
        this._total = 0;
        this._nextDt = this._innerAction._duration / this._duration;
        cc.ActionInterval.prototype.startWithTarget.call(this, target);
        this._innerAction.startWithTarget(target);
      },
      stop: function stop() {
        this._innerAction.stop();
        cc.Action.prototype.stop.call(this);
      },
      update: function update(dt) {
        dt = this._computeEaseTime(dt);
        var locInnerAction = this._innerAction;
        var locDuration = this._duration;
        var locTimes = this._times;
        var locNextDt = this._nextDt;
        if (dt >= locNextDt) {
          while (dt > locNextDt && this._total < locTimes) {
            locInnerAction.update(1);
            this._total++;
            locInnerAction.stop();
            locInnerAction.startWithTarget(this.target);
            locNextDt += locInnerAction._duration / locDuration;
            this._nextDt = locNextDt > 1 ? 1 : locNextDt;
          }
          if (dt >= 1 && this._total < locTimes) {
            locInnerAction.update(1);
            this._total++;
          }
          this._actionInstant || (this._total === locTimes ? locInnerAction.stop() : locInnerAction.update(dt - (locNextDt - locInnerAction._duration / locDuration)));
        } else locInnerAction.update(dt * locTimes % 1);
      },
      isDone: function isDone() {
        return this._total === this._times;
      },
      reverse: function reverse() {
        var action = new cc.Repeat(this._innerAction.reverse(), this._times);
        this._cloneDecoration(action);
        this._reverseEaseList(action);
        return action;
      },
      setInnerAction: function setInnerAction(action) {
        this._innerAction !== action && (this._innerAction = action);
      },
      getInnerAction: function getInnerAction() {
        return this._innerAction;
      }
    });
    cc.repeat = function(action, times) {
      return new cc.Repeat(action, times);
    };
    cc.RepeatForever = cc.Class({
      name: "cc.RepeatForever",
      extends: cc.ActionInterval,
      ctor: function ctor(action) {
        this._innerAction = null;
        action && this.initWithAction(action);
      },
      initWithAction: function initWithAction(action) {
        if (!action) {
          cc.errorID(1026);
          return false;
        }
        this._innerAction = action;
        return true;
      },
      clone: function clone() {
        var action = new cc.RepeatForever();
        this._cloneDecoration(action);
        action.initWithAction(this._innerAction.clone());
        return action;
      },
      startWithTarget: function startWithTarget(target) {
        cc.ActionInterval.prototype.startWithTarget.call(this, target);
        this._innerAction.startWithTarget(target);
      },
      step: function step(dt) {
        var locInnerAction = this._innerAction;
        locInnerAction.step(dt);
        if (locInnerAction.isDone()) {
          locInnerAction.startWithTarget(this.target);
          locInnerAction.step(locInnerAction.getElapsed() - locInnerAction._duration);
        }
      },
      isDone: function isDone() {
        return false;
      },
      reverse: function reverse() {
        var action = new cc.RepeatForever(this._innerAction.reverse());
        this._cloneDecoration(action);
        this._reverseEaseList(action);
        return action;
      },
      setInnerAction: function setInnerAction(action) {
        this._innerAction !== action && (this._innerAction = action);
      },
      getInnerAction: function getInnerAction() {
        return this._innerAction;
      }
    });
    cc.repeatForever = function(action) {
      return new cc.RepeatForever(action);
    };
    cc.Spawn = cc.Class({
      name: "cc.Spawn",
      extends: cc.ActionInterval,
      ctor: function ctor(tempArray) {
        this._one = null;
        this._two = null;
        var paramArray = tempArray instanceof Array ? tempArray : arguments;
        if (1 === paramArray.length) {
          cc.errorID(1020);
          return;
        }
        var last = paramArray.length - 1;
        last >= 0 && null == paramArray[last] && cc.logID(1015);
        if (last >= 0) {
          var prev = paramArray[0], action1;
          for (var i = 1; i < last; i++) if (paramArray[i]) {
            action1 = prev;
            prev = cc.Spawn._actionOneTwo(action1, paramArray[i]);
          }
          this.initWithTwoActions(prev, paramArray[last]);
        }
      },
      initWithTwoActions: function initWithTwoActions(action1, action2) {
        if (!action1 || !action2) {
          cc.errorID(1027);
          return false;
        }
        var ret = false;
        var d1 = action1._duration;
        var d2 = action2._duration;
        if (this.initWithDuration(Math.max(d1, d2))) {
          this._one = action1;
          this._two = action2;
          d1 > d2 ? this._two = cc.Sequence._actionOneTwo(action2, cc.delayTime(d1 - d2)) : d1 < d2 && (this._one = cc.Sequence._actionOneTwo(action1, cc.delayTime(d2 - d1)));
          ret = true;
        }
        return ret;
      },
      clone: function clone() {
        var action = new cc.Spawn();
        this._cloneDecoration(action);
        action.initWithTwoActions(this._one.clone(), this._two.clone());
        return action;
      },
      startWithTarget: function startWithTarget(target) {
        cc.ActionInterval.prototype.startWithTarget.call(this, target);
        this._one.startWithTarget(target);
        this._two.startWithTarget(target);
      },
      stop: function stop() {
        this._one.stop();
        this._two.stop();
        cc.Action.prototype.stop.call(this);
      },
      update: function update(dt) {
        dt = this._computeEaseTime(dt);
        this._one && this._one.update(dt);
        this._two && this._two.update(dt);
      },
      reverse: function reverse() {
        var action = cc.Spawn._actionOneTwo(this._one.reverse(), this._two.reverse());
        this._cloneDecoration(action);
        this._reverseEaseList(action);
        return action;
      }
    });
    cc.spawn = function(tempArray) {
      var paramArray = tempArray instanceof Array ? tempArray : arguments;
      if (1 === paramArray.length) {
        cc.errorID(1020);
        return null;
      }
      paramArray.length > 0 && null == paramArray[paramArray.length - 1] && cc.logID(1015);
      var prev = paramArray[0];
      for (var i = 1; i < paramArray.length; i++) null != paramArray[i] && (prev = cc.Spawn._actionOneTwo(prev, paramArray[i]));
      return prev;
    };
    cc.Spawn._actionOneTwo = function(action1, action2) {
      var pSpawn = new cc.Spawn();
      pSpawn.initWithTwoActions(action1, action2);
      return pSpawn;
    };
    cc.RotateTo = cc.Class({
      name: "cc.RotateTo",
      extends: cc.ActionInterval,
      ctor: function ctor(duration, dstAngle) {
        this._startAngle = 0;
        this._dstAngle = 0;
        this._angle = 0;
        void 0 !== dstAngle && this.initWithDuration(duration, dstAngle);
      },
      initWithDuration: function initWithDuration(duration, dstAngle) {
        if (cc.ActionInterval.prototype.initWithDuration.call(this, duration)) {
          this._dstAngle = dstAngle;
          return true;
        }
        return false;
      },
      clone: function clone() {
        var action = new cc.RotateTo();
        this._cloneDecoration(action);
        action.initWithDuration(this._duration, this._dstAngle);
        return action;
      },
      startWithTarget: function startWithTarget(target) {
        cc.ActionInterval.prototype.startWithTarget.call(this, target);
        var startAngle = target.angle % 360;
        var angle = cc.macro.ROTATE_ACTION_CCW ? this._dstAngle - startAngle : this._dstAngle + startAngle;
        angle > 180 && (angle -= 360);
        angle < -180 && (angle += 360);
        this._startAngle = startAngle;
        this._angle = cc.macro.ROTATE_ACTION_CCW ? angle : -angle;
      },
      reverse: function reverse() {
        cc.logID(1016);
      },
      update: function update(dt) {
        dt = this._computeEaseTime(dt);
        this.target && (this.target.angle = this._startAngle + this._angle * dt);
      }
    });
    cc.rotateTo = function(duration, dstAngle) {
      return new cc.RotateTo(duration, dstAngle);
    };
    cc.RotateBy = cc.Class({
      name: "cc.RotateBy",
      extends: cc.ActionInterval,
      ctor: function ctor(duration, deltaAngle) {
        deltaAngle *= cc.macro.ROTATE_ACTION_CCW ? 1 : -1;
        this._deltaAngle = 0;
        this._startAngle = 0;
        void 0 !== deltaAngle && this.initWithDuration(duration, deltaAngle);
      },
      initWithDuration: function initWithDuration(duration, deltaAngle) {
        if (cc.ActionInterval.prototype.initWithDuration.call(this, duration)) {
          this._deltaAngle = deltaAngle;
          return true;
        }
        return false;
      },
      clone: function clone() {
        var action = new cc.RotateBy();
        this._cloneDecoration(action);
        action.initWithDuration(this._duration, this._deltaAngle);
        return action;
      },
      startWithTarget: function startWithTarget(target) {
        cc.ActionInterval.prototype.startWithTarget.call(this, target);
        this._startAngle = target.angle;
      },
      update: function update(dt) {
        dt = this._computeEaseTime(dt);
        this.target && (this.target.angle = this._startAngle + this._deltaAngle * dt);
      },
      reverse: function reverse() {
        var action = new cc.RotateBy(this._duration, -this._deltaAngle);
        this._cloneDecoration(action);
        this._reverseEaseList(action);
        return action;
      }
    });
    cc.rotateBy = function(duration, deltaAngle) {
      return new cc.RotateBy(duration, deltaAngle);
    };
    cc.MoveBy = cc.Class({
      name: "cc.MoveBy",
      extends: cc.ActionInterval,
      ctor: function ctor(duration, deltaPos, deltaY) {
        this._positionDelta = cc.v2(0, 0);
        this._startPosition = cc.v2(0, 0);
        this._previousPosition = cc.v2(0, 0);
        void 0 !== deltaPos && cc.MoveBy.prototype.initWithDuration.call(this, duration, deltaPos, deltaY);
      },
      initWithDuration: function initWithDuration(duration, position, y) {
        if (cc.ActionInterval.prototype.initWithDuration.call(this, duration)) {
          if (void 0 !== position.x) {
            y = position.y;
            position = position.x;
          }
          this._positionDelta.x = position;
          this._positionDelta.y = y;
          return true;
        }
        return false;
      },
      clone: function clone() {
        var action = new cc.MoveBy();
        this._cloneDecoration(action);
        action.initWithDuration(this._duration, this._positionDelta);
        return action;
      },
      startWithTarget: function startWithTarget(target) {
        cc.ActionInterval.prototype.startWithTarget.call(this, target);
        var locPosX = target.x;
        var locPosY = target.y;
        this._previousPosition.x = locPosX;
        this._previousPosition.y = locPosY;
        this._startPosition.x = locPosX;
        this._startPosition.y = locPosY;
      },
      update: function update(dt) {
        dt = this._computeEaseTime(dt);
        if (this.target) {
          var x = this._positionDelta.x * dt;
          var y = this._positionDelta.y * dt;
          var locStartPosition = this._startPosition;
          if (cc.macro.ENABLE_STACKABLE_ACTIONS) {
            var targetX = this.target.x;
            var targetY = this.target.y;
            var locPreviousPosition = this._previousPosition;
            locStartPosition.x = locStartPosition.x + targetX - locPreviousPosition.x;
            locStartPosition.y = locStartPosition.y + targetY - locPreviousPosition.y;
            x += locStartPosition.x;
            y += locStartPosition.y;
            locPreviousPosition.x = x;
            locPreviousPosition.y = y;
            this.target.setPosition(x, y);
          } else this.target.setPosition(locStartPosition.x + x, locStartPosition.y + y);
        }
      },
      reverse: function reverse() {
        var action = new cc.MoveBy(this._duration, cc.v2(-this._positionDelta.x, -this._positionDelta.y));
        this._cloneDecoration(action);
        this._reverseEaseList(action);
        return action;
      }
    });
    cc.moveBy = function(duration, deltaPos, deltaY) {
      return new cc.MoveBy(duration, deltaPos, deltaY);
    };
    cc.MoveTo = cc.Class({
      name: "cc.MoveTo",
      extends: cc.MoveBy,
      ctor: function ctor(duration, position, y) {
        this._endPosition = cc.v2(0, 0);
        void 0 !== position && this.initWithDuration(duration, position, y);
      },
      initWithDuration: function initWithDuration(duration, position, y) {
        if (cc.MoveBy.prototype.initWithDuration.call(this, duration, position, y)) {
          if (void 0 !== position.x) {
            y = position.y;
            position = position.x;
          }
          this._endPosition.x = position;
          this._endPosition.y = y;
          return true;
        }
        return false;
      },
      clone: function clone() {
        var action = new cc.MoveTo();
        this._cloneDecoration(action);
        action.initWithDuration(this._duration, this._endPosition);
        return action;
      },
      startWithTarget: function startWithTarget(target) {
        cc.MoveBy.prototype.startWithTarget.call(this, target);
        this._positionDelta.x = this._endPosition.x - target.x;
        this._positionDelta.y = this._endPosition.y - target.y;
      }
    });
    cc.moveTo = function(duration, position, y) {
      return new cc.MoveTo(duration, position, y);
    };
    cc.SkewTo = cc.Class({
      name: "cc.SkewTo",
      extends: cc.ActionInterval,
      ctor: function ctor(t, sx, sy) {
        this._skewX = 0;
        this._skewY = 0;
        this._startSkewX = 0;
        this._startSkewY = 0;
        this._endSkewX = 0;
        this._endSkewY = 0;
        this._deltaX = 0;
        this._deltaY = 0;
        void 0 !== sy && cc.SkewTo.prototype.initWithDuration.call(this, t, sx, sy);
      },
      initWithDuration: function initWithDuration(t, sx, sy) {
        var ret = false;
        if (cc.ActionInterval.prototype.initWithDuration.call(this, t)) {
          this._endSkewX = sx;
          this._endSkewY = sy;
          ret = true;
        }
        return ret;
      },
      clone: function clone() {
        var action = new cc.SkewTo();
        this._cloneDecoration(action);
        action.initWithDuration(this._duration, this._endSkewX, this._endSkewY);
        return action;
      },
      startWithTarget: function startWithTarget(target) {
        cc.ActionInterval.prototype.startWithTarget.call(this, target);
        this._startSkewX = target.skewX % 180;
        this._deltaX = this._endSkewX - this._startSkewX;
        this._deltaX > 180 && (this._deltaX -= 360);
        this._deltaX < -180 && (this._deltaX += 360);
        this._startSkewY = target.skewY % 360;
        this._deltaY = this._endSkewY - this._startSkewY;
        this._deltaY > 180 && (this._deltaY -= 360);
        this._deltaY < -180 && (this._deltaY += 360);
      },
      update: function update(dt) {
        dt = this._computeEaseTime(dt);
        this.target.skewX = this._startSkewX + this._deltaX * dt;
        this.target.skewY = this._startSkewY + this._deltaY * dt;
      }
    });
    cc.skewTo = function(t, sx, sy) {
      return new cc.SkewTo(t, sx, sy);
    };
    cc.SkewBy = cc.Class({
      name: "cc.SkewBy",
      extends: cc.SkewTo,
      ctor: function ctor(t, sx, sy) {
        void 0 !== sy && this.initWithDuration(t, sx, sy);
      },
      initWithDuration: function initWithDuration(t, deltaSkewX, deltaSkewY) {
        var ret = false;
        if (cc.SkewTo.prototype.initWithDuration.call(this, t, deltaSkewX, deltaSkewY)) {
          this._skewX = deltaSkewX;
          this._skewY = deltaSkewY;
          ret = true;
        }
        return ret;
      },
      clone: function clone() {
        var action = new cc.SkewBy();
        this._cloneDecoration(action);
        action.initWithDuration(this._duration, this._skewX, this._skewY);
        return action;
      },
      startWithTarget: function startWithTarget(target) {
        cc.SkewTo.prototype.startWithTarget.call(this, target);
        this._deltaX = this._skewX;
        this._deltaY = this._skewY;
        this._endSkewX = this._startSkewX + this._deltaX;
        this._endSkewY = this._startSkewY + this._deltaY;
      },
      reverse: function reverse() {
        var action = new cc.SkewBy(this._duration, -this._skewX, -this._skewY);
        this._cloneDecoration(action);
        this._reverseEaseList(action);
        return action;
      }
    });
    cc.skewBy = function(t, sx, sy) {
      return new cc.SkewBy(t, sx, sy);
    };
    cc.JumpBy = cc.Class({
      name: "cc.JumpBy",
      extends: cc.ActionInterval,
      ctor: function ctor(duration, position, y, height, jumps) {
        this._startPosition = cc.v2(0, 0);
        this._previousPosition = cc.v2(0, 0);
        this._delta = cc.v2(0, 0);
        this._height = 0;
        this._jumps = 0;
        void 0 !== height && cc.JumpBy.prototype.initWithDuration.call(this, duration, position, y, height, jumps);
      },
      initWithDuration: function initWithDuration(duration, position, y, height, jumps) {
        if (cc.ActionInterval.prototype.initWithDuration.call(this, duration)) {
          if (void 0 === jumps) {
            jumps = height;
            height = y;
            y = position.y;
            position = position.x;
          }
          this._delta.x = position;
          this._delta.y = y;
          this._height = height;
          this._jumps = jumps;
          return true;
        }
        return false;
      },
      clone: function clone() {
        var action = new cc.JumpBy();
        this._cloneDecoration(action);
        action.initWithDuration(this._duration, this._delta, this._height, this._jumps);
        return action;
      },
      startWithTarget: function startWithTarget(target) {
        cc.ActionInterval.prototype.startWithTarget.call(this, target);
        var locPosX = target.x;
        var locPosY = target.y;
        this._previousPosition.x = locPosX;
        this._previousPosition.y = locPosY;
        this._startPosition.x = locPosX;
        this._startPosition.y = locPosY;
      },
      update: function update(dt) {
        dt = this._computeEaseTime(dt);
        if (this.target) {
          var frac = dt * this._jumps % 1;
          var y = 4 * this._height * frac * (1 - frac);
          y += this._delta.y * dt;
          var x = this._delta.x * dt;
          var locStartPosition = this._startPosition;
          if (cc.macro.ENABLE_STACKABLE_ACTIONS) {
            var targetX = this.target.x;
            var targetY = this.target.y;
            var locPreviousPosition = this._previousPosition;
            locStartPosition.x = locStartPosition.x + targetX - locPreviousPosition.x;
            locStartPosition.y = locStartPosition.y + targetY - locPreviousPosition.y;
            x += locStartPosition.x;
            y += locStartPosition.y;
            locPreviousPosition.x = x;
            locPreviousPosition.y = y;
            this.target.setPosition(x, y);
          } else this.target.setPosition(locStartPosition.x + x, locStartPosition.y + y);
        }
      },
      reverse: function reverse() {
        var action = new cc.JumpBy(this._duration, cc.v2(-this._delta.x, -this._delta.y), this._height, this._jumps);
        this._cloneDecoration(action);
        this._reverseEaseList(action);
        return action;
      }
    });
    cc.jumpBy = function(duration, position, y, height, jumps) {
      return new cc.JumpBy(duration, position, y, height, jumps);
    };
    cc.JumpTo = cc.Class({
      name: "cc.JumpTo",
      extends: cc.JumpBy,
      ctor: function ctor(duration, position, y, height, jumps) {
        this._endPosition = cc.v2(0, 0);
        void 0 !== height && this.initWithDuration(duration, position, y, height, jumps);
      },
      initWithDuration: function initWithDuration(duration, position, y, height, jumps) {
        if (cc.JumpBy.prototype.initWithDuration.call(this, duration, position, y, height, jumps)) {
          if (void 0 === jumps) {
            y = position.y;
            position = position.x;
          }
          this._endPosition.x = position;
          this._endPosition.y = y;
          return true;
        }
        return false;
      },
      startWithTarget: function startWithTarget(target) {
        cc.JumpBy.prototype.startWithTarget.call(this, target);
        this._delta.x = this._endPosition.x - this._startPosition.x;
        this._delta.y = this._endPosition.y - this._startPosition.y;
      },
      clone: function clone() {
        var action = new cc.JumpTo();
        this._cloneDecoration(action);
        action.initWithDuration(this._duration, this._endPosition, this._height, this._jumps);
        return action;
      }
    });
    cc.jumpTo = function(duration, position, y, height, jumps) {
      return new cc.JumpTo(duration, position, y, height, jumps);
    };
    function bezierAt(a, b, c, d, t) {
      return Math.pow(1 - t, 3) * a + 3 * t * Math.pow(1 - t, 2) * b + 3 * Math.pow(t, 2) * (1 - t) * c + Math.pow(t, 3) * d;
    }
    cc.BezierBy = cc.Class({
      name: "cc.BezierBy",
      extends: cc.ActionInterval,
      ctor: function ctor(t, c) {
        this._config = [];
        this._startPosition = cc.v2(0, 0);
        this._previousPosition = cc.v2(0, 0);
        c && cc.BezierBy.prototype.initWithDuration.call(this, t, c);
      },
      initWithDuration: function initWithDuration(t, c) {
        if (cc.ActionInterval.prototype.initWithDuration.call(this, t)) {
          this._config = c;
          return true;
        }
        return false;
      },
      clone: function clone() {
        var action = new cc.BezierBy();
        this._cloneDecoration(action);
        var newConfigs = [];
        for (var i = 0; i < this._config.length; i++) {
          var selConf = this._config[i];
          newConfigs.push(cc.v2(selConf.x, selConf.y));
        }
        action.initWithDuration(this._duration, newConfigs);
        return action;
      },
      startWithTarget: function startWithTarget(target) {
        cc.ActionInterval.prototype.startWithTarget.call(this, target);
        var locPosX = target.x;
        var locPosY = target.y;
        this._previousPosition.x = locPosX;
        this._previousPosition.y = locPosY;
        this._startPosition.x = locPosX;
        this._startPosition.y = locPosY;
      },
      update: function update(dt) {
        dt = this._computeEaseTime(dt);
        if (this.target) {
          var locConfig = this._config;
          var xa = 0;
          var xb = locConfig[0].x;
          var xc = locConfig[1].x;
          var xd = locConfig[2].x;
          var ya = 0;
          var yb = locConfig[0].y;
          var yc = locConfig[1].y;
          var yd = locConfig[2].y;
          var x = bezierAt(xa, xb, xc, xd, dt);
          var y = bezierAt(ya, yb, yc, yd, dt);
          var locStartPosition = this._startPosition;
          if (cc.macro.ENABLE_STACKABLE_ACTIONS) {
            var targetX = this.target.x;
            var targetY = this.target.y;
            var locPreviousPosition = this._previousPosition;
            locStartPosition.x = locStartPosition.x + targetX - locPreviousPosition.x;
            locStartPosition.y = locStartPosition.y + targetY - locPreviousPosition.y;
            x += locStartPosition.x;
            y += locStartPosition.y;
            locPreviousPosition.x = x;
            locPreviousPosition.y = y;
            this.target.setPosition(x, y);
          } else this.target.setPosition(locStartPosition.x + x, locStartPosition.y + y);
        }
      },
      reverse: function reverse() {
        var locConfig = this._config;
        var x0 = locConfig[0].x, y0 = locConfig[0].y;
        var x1 = locConfig[1].x, y1 = locConfig[1].y;
        var x2 = locConfig[2].x, y2 = locConfig[2].y;
        var r = [ cc.v2(x1 - x2, y1 - y2), cc.v2(x0 - x2, y0 - y2), cc.v2(-x2, -y2) ];
        var action = new cc.BezierBy(this._duration, r);
        this._cloneDecoration(action);
        this._reverseEaseList(action);
        return action;
      }
    });
    cc.bezierBy = function(t, c) {
      return new cc.BezierBy(t, c);
    };
    cc.BezierTo = cc.Class({
      name: "cc.BezierTo",
      extends: cc.BezierBy,
      ctor: function ctor(t, c) {
        this._toConfig = [];
        c && this.initWithDuration(t, c);
      },
      initWithDuration: function initWithDuration(t, c) {
        if (cc.ActionInterval.prototype.initWithDuration.call(this, t)) {
          this._toConfig = c;
          return true;
        }
        return false;
      },
      clone: function clone() {
        var action = new cc.BezierTo();
        this._cloneDecoration(action);
        action.initWithDuration(this._duration, this._toConfig);
        return action;
      },
      startWithTarget: function startWithTarget(target) {
        cc.BezierBy.prototype.startWithTarget.call(this, target);
        var locStartPos = this._startPosition;
        var locToConfig = this._toConfig;
        var locConfig = this._config;
        locConfig[0] = locToConfig[0].sub(locStartPos);
        locConfig[1] = locToConfig[1].sub(locStartPos);
        locConfig[2] = locToConfig[2].sub(locStartPos);
      }
    });
    cc.bezierTo = function(t, c) {
      return new cc.BezierTo(t, c);
    };
    cc.ScaleTo = cc.Class({
      name: "cc.ScaleTo",
      extends: cc.ActionInterval,
      ctor: function ctor(duration, sx, sy) {
        this._scaleX = 1;
        this._scaleY = 1;
        this._startScaleX = 1;
        this._startScaleY = 1;
        this._endScaleX = 0;
        this._endScaleY = 0;
        this._deltaX = 0;
        this._deltaY = 0;
        void 0 !== sx && cc.ScaleTo.prototype.initWithDuration.call(this, duration, sx, sy);
      },
      initWithDuration: function initWithDuration(duration, sx, sy) {
        if (cc.ActionInterval.prototype.initWithDuration.call(this, duration)) {
          this._endScaleX = sx;
          this._endScaleY = null != sy ? sy : sx;
          return true;
        }
        return false;
      },
      clone: function clone() {
        var action = new cc.ScaleTo();
        this._cloneDecoration(action);
        action.initWithDuration(this._duration, this._endScaleX, this._endScaleY);
        return action;
      },
      startWithTarget: function startWithTarget(target) {
        cc.ActionInterval.prototype.startWithTarget.call(this, target);
        this._startScaleX = target.scaleX;
        this._startScaleY = target.scaleY;
        this._deltaX = this._endScaleX - this._startScaleX;
        this._deltaY = this._endScaleY - this._startScaleY;
      },
      update: function update(dt) {
        dt = this._computeEaseTime(dt);
        if (this.target) {
          this.target.scaleX = this._startScaleX + this._deltaX * dt;
          this.target.scaleY = this._startScaleY + this._deltaY * dt;
        }
      }
    });
    cc.scaleTo = function(duration, sx, sy) {
      return new cc.ScaleTo(duration, sx, sy);
    };
    cc.ScaleBy = cc.Class({
      name: "cc.ScaleBy",
      extends: cc.ScaleTo,
      startWithTarget: function startWithTarget(target) {
        cc.ScaleTo.prototype.startWithTarget.call(this, target);
        this._deltaX = this._startScaleX * this._endScaleX - this._startScaleX;
        this._deltaY = this._startScaleY * this._endScaleY - this._startScaleY;
      },
      reverse: function reverse() {
        var action = new cc.ScaleBy(this._duration, 1 / this._endScaleX, 1 / this._endScaleY);
        this._cloneDecoration(action);
        this._reverseEaseList(action);
        return action;
      },
      clone: function clone() {
        var action = new cc.ScaleBy();
        this._cloneDecoration(action);
        action.initWithDuration(this._duration, this._endScaleX, this._endScaleY);
        return action;
      }
    });
    cc.scaleBy = function(duration, sx, sy) {
      return new cc.ScaleBy(duration, sx, sy);
    };
    cc.Blink = cc.Class({
      name: "cc.Blink",
      extends: cc.ActionInterval,
      ctor: function ctor(duration, blinks) {
        this._times = 0;
        this._originalState = false;
        void 0 !== blinks && this.initWithDuration(duration, blinks);
      },
      initWithDuration: function initWithDuration(duration, blinks) {
        if (cc.ActionInterval.prototype.initWithDuration.call(this, duration)) {
          this._times = blinks;
          return true;
        }
        return false;
      },
      clone: function clone() {
        var action = new cc.Blink();
        this._cloneDecoration(action);
        action.initWithDuration(this._duration, this._times);
        return action;
      },
      update: function update(dt) {
        dt = this._computeEaseTime(dt);
        if (this.target && !this.isDone()) {
          var slice = 1 / this._times;
          var m = dt % slice;
          this.target.opacity = m > slice / 2 ? 255 : 0;
        }
      },
      startWithTarget: function startWithTarget(target) {
        cc.ActionInterval.prototype.startWithTarget.call(this, target);
        this._originalState = target.opacity;
      },
      stop: function stop() {
        this.target.opacity = this._originalState;
        cc.ActionInterval.prototype.stop.call(this);
      },
      reverse: function reverse() {
        var action = new cc.Blink(this._duration, this._times);
        this._cloneDecoration(action);
        this._reverseEaseList(action);
        return action;
      }
    });
    cc.blink = function(duration, blinks) {
      return new cc.Blink(duration, blinks);
    };
    cc.FadeTo = cc.Class({
      name: "cc.FadeTo",
      extends: cc.ActionInterval,
      ctor: function ctor(duration, opacity) {
        this._toOpacity = 0;
        this._fromOpacity = 0;
        void 0 !== opacity && cc.FadeTo.prototype.initWithDuration.call(this, duration, opacity);
      },
      initWithDuration: function initWithDuration(duration, opacity) {
        if (cc.ActionInterval.prototype.initWithDuration.call(this, duration)) {
          this._toOpacity = opacity;
          return true;
        }
        return false;
      },
      clone: function clone() {
        var action = new cc.FadeTo();
        this._cloneDecoration(action);
        action.initWithDuration(this._duration, this._toOpacity);
        return action;
      },
      update: function update(time) {
        time = this._computeEaseTime(time);
        var fromOpacity = void 0 !== this._fromOpacity ? this._fromOpacity : 255;
        this.target.opacity = fromOpacity + (this._toOpacity - fromOpacity) * time;
      },
      startWithTarget: function startWithTarget(target) {
        cc.ActionInterval.prototype.startWithTarget.call(this, target);
        this._fromOpacity = target.opacity;
      }
    });
    cc.fadeTo = function(duration, opacity) {
      return new cc.FadeTo(duration, opacity);
    };
    cc.FadeIn = cc.Class({
      name: "cc.FadeIn",
      extends: cc.FadeTo,
      ctor: function ctor(duration) {
        null == duration && (duration = 0);
        this._reverseAction = null;
        this.initWithDuration(duration, 255);
      },
      reverse: function reverse() {
        var action = new cc.FadeOut();
        action.initWithDuration(this._duration, 0);
        this._cloneDecoration(action);
        this._reverseEaseList(action);
        return action;
      },
      clone: function clone() {
        var action = new cc.FadeIn();
        this._cloneDecoration(action);
        action.initWithDuration(this._duration, this._toOpacity);
        return action;
      },
      startWithTarget: function startWithTarget(target) {
        this._reverseAction && (this._toOpacity = this._reverseAction._fromOpacity);
        cc.FadeTo.prototype.startWithTarget.call(this, target);
      }
    });
    cc.fadeIn = function(duration) {
      return new cc.FadeIn(duration);
    };
    cc.FadeOut = cc.Class({
      name: "cc.FadeOut",
      extends: cc.FadeTo,
      ctor: function ctor(duration) {
        null == duration && (duration = 0);
        this._reverseAction = null;
        this.initWithDuration(duration, 0);
      },
      reverse: function reverse() {
        var action = new cc.FadeIn();
        action._reverseAction = this;
        action.initWithDuration(this._duration, 255);
        this._cloneDecoration(action);
        this._reverseEaseList(action);
        return action;
      },
      clone: function clone() {
        var action = new cc.FadeOut();
        this._cloneDecoration(action);
        action.initWithDuration(this._duration, this._toOpacity);
        return action;
      }
    });
    cc.fadeOut = function(d) {
      return new cc.FadeOut(d);
    };
    cc.TintTo = cc.Class({
      name: "cc.TintTo",
      extends: cc.ActionInterval,
      ctor: function ctor(duration, red, green, blue) {
        this._to = cc.color(0, 0, 0);
        this._from = cc.color(0, 0, 0);
        if (red instanceof cc.Color) {
          blue = red.b;
          green = red.g;
          red = red.r;
        }
        void 0 !== blue && this.initWithDuration(duration, red, green, blue);
      },
      initWithDuration: function initWithDuration(duration, red, green, blue) {
        if (cc.ActionInterval.prototype.initWithDuration.call(this, duration)) {
          this._to = cc.color(red, green, blue);
          return true;
        }
        return false;
      },
      clone: function clone() {
        var action = new cc.TintTo();
        this._cloneDecoration(action);
        var locTo = this._to;
        action.initWithDuration(this._duration, locTo.r, locTo.g, locTo.b);
        return action;
      },
      startWithTarget: function startWithTarget(target) {
        cc.ActionInterval.prototype.startWithTarget.call(this, target);
        this._from = this.target.color;
      },
      update: function update(dt) {
        dt = this._computeEaseTime(dt);
        var locFrom = this._from, locTo = this._to;
        locFrom && (this.target.color = cc.color(locFrom.r + (locTo.r - locFrom.r) * dt, locFrom.g + (locTo.g - locFrom.g) * dt, locFrom.b + (locTo.b - locFrom.b) * dt));
      }
    });
    cc.tintTo = function(duration, red, green, blue) {
      return new cc.TintTo(duration, red, green, blue);
    };
    cc.TintBy = cc.Class({
      name: "cc.TintBy",
      extends: cc.ActionInterval,
      ctor: function ctor(duration, deltaRed, deltaGreen, deltaBlue) {
        this._deltaR = 0;
        this._deltaG = 0;
        this._deltaB = 0;
        this._fromR = 0;
        this._fromG = 0;
        this._fromB = 0;
        void 0 !== deltaBlue && this.initWithDuration(duration, deltaRed, deltaGreen, deltaBlue);
      },
      initWithDuration: function initWithDuration(duration, deltaRed, deltaGreen, deltaBlue) {
        if (cc.ActionInterval.prototype.initWithDuration.call(this, duration)) {
          this._deltaR = deltaRed;
          this._deltaG = deltaGreen;
          this._deltaB = deltaBlue;
          return true;
        }
        return false;
      },
      clone: function clone() {
        var action = new cc.TintBy();
        this._cloneDecoration(action);
        action.initWithDuration(this._duration, this._deltaR, this._deltaG, this._deltaB);
        return action;
      },
      startWithTarget: function startWithTarget(target) {
        cc.ActionInterval.prototype.startWithTarget.call(this, target);
        var color = target.color;
        this._fromR = color.r;
        this._fromG = color.g;
        this._fromB = color.b;
      },
      update: function update(dt) {
        dt = this._computeEaseTime(dt);
        this.target.color = cc.color(this._fromR + this._deltaR * dt, this._fromG + this._deltaG * dt, this._fromB + this._deltaB * dt);
      },
      reverse: function reverse() {
        var action = new cc.TintBy(this._duration, -this._deltaR, -this._deltaG, -this._deltaB);
        this._cloneDecoration(action);
        this._reverseEaseList(action);
        return action;
      }
    });
    cc.tintBy = function(duration, deltaRed, deltaGreen, deltaBlue) {
      return new cc.TintBy(duration, deltaRed, deltaGreen, deltaBlue);
    };
    cc.DelayTime = cc.Class({
      name: "cc.DelayTime",
      extends: cc.ActionInterval,
      update: function update(dt) {},
      reverse: function reverse() {
        var action = new cc.DelayTime(this._duration);
        this._cloneDecoration(action);
        this._reverseEaseList(action);
        return action;
      },
      clone: function clone() {
        var action = new cc.DelayTime();
        this._cloneDecoration(action);
        action.initWithDuration(this._duration);
        return action;
      }
    });
    cc.delayTime = function(d) {
      return new cc.DelayTime(d);
    };
    cc.ReverseTime = cc.Class({
      name: "cc.ReverseTime",
      extends: cc.ActionInterval,
      ctor: function ctor(action) {
        this._other = null;
        action && this.initWithAction(action);
      },
      initWithAction: function initWithAction(action) {
        if (!action) {
          cc.errorID(1028);
          return false;
        }
        if (action === this._other) {
          cc.errorID(1029);
          return false;
        }
        if (cc.ActionInterval.prototype.initWithDuration.call(this, action._duration)) {
          this._other = action;
          return true;
        }
        return false;
      },
      clone: function clone() {
        var action = new cc.ReverseTime();
        this._cloneDecoration(action);
        action.initWithAction(this._other.clone());
        return action;
      },
      startWithTarget: function startWithTarget(target) {
        cc.ActionInterval.prototype.startWithTarget.call(this, target);
        this._other.startWithTarget(target);
      },
      update: function update(dt) {
        dt = this._computeEaseTime(dt);
        this._other && this._other.update(1 - dt);
      },
      reverse: function reverse() {
        return this._other.clone();
      },
      stop: function stop() {
        this._other.stop();
        cc.Action.prototype.stop.call(this);
      }
    });
    cc.reverseTime = function(action) {
      return new cc.ReverseTime(action);
    };
    cc.TargetedAction = cc.Class({
      name: "cc.TargetedAction",
      extends: cc.ActionInterval,
      ctor: function ctor(target, action) {
        this._action = null;
        this._forcedTarget = null;
        action && this.initWithTarget(target, action);
      },
      initWithTarget: function initWithTarget(target, action) {
        if (this.initWithDuration(action._duration)) {
          this._forcedTarget = target;
          this._action = action;
          return true;
        }
        return false;
      },
      clone: function clone() {
        var action = new cc.TargetedAction();
        this._cloneDecoration(action);
        action.initWithTarget(this._forcedTarget, this._action.clone());
        return action;
      },
      startWithTarget: function startWithTarget(target) {
        cc.ActionInterval.prototype.startWithTarget.call(this, target);
        this._action.startWithTarget(this._forcedTarget);
      },
      stop: function stop() {
        this._action.stop();
      },
      update: function update(dt) {
        dt = this._computeEaseTime(dt);
        this._action.update(dt);
      },
      getForcedTarget: function getForcedTarget() {
        return this._forcedTarget;
      },
      setForcedTarget: function setForcedTarget(forcedTarget) {
        this._forcedTarget !== forcedTarget && (this._forcedTarget = forcedTarget);
      }
    });
    cc.targetedAction = function(target, action) {
      return new cc.TargetedAction(target, action);
    };
  }), {} ],
  7: [ (function(require, module, exports) {
    "use strict";
    require("../core/platform/CCClass");
    var js = require("../core/platform/js");
    var HashElement = function HashElement() {
      this.actions = [];
      this.target = null;
      this.actionIndex = 0;
      this.currentAction = null;
      this.paused = false;
      this.lock = false;
    };
    cc.ActionManager = function() {
      this._hashTargets = js.createMap(true);
      this._arrayTargets = [];
      this._currentTarget = null;
      cc.director._scheduler && cc.director._scheduler.enableForTarget(this);
    };
    cc.ActionManager.prototype = {
      constructor: cc.ActionManager,
      _elementPool: [],
      _searchElementByTarget: function _searchElementByTarget(arr, target) {
        for (var k = 0; k < arr.length; k++) if (target === arr[k].target) return arr[k];
        return null;
      },
      _getElement: function _getElement(target, paused) {
        var element = this._elementPool.pop();
        element || (element = new HashElement());
        element.target = target;
        element.paused = !!paused;
        return element;
      },
      _putElement: function _putElement(element) {
        element.actions.length = 0;
        element.actionIndex = 0;
        element.currentAction = null;
        element.paused = false;
        element.target = null;
        element.lock = false;
        this._elementPool.push(element);
      },
      addAction: function addAction(action, target, paused) {
        if (!action || !target) {
          cc.errorID(1e3);
          return;
        }
        var element = this._hashTargets[target._id];
        if (element) element.actions || (element.actions = []); else {
          element = this._getElement(target, paused);
          this._hashTargets[target._id] = element;
          this._arrayTargets.push(element);
        }
        element.actions.push(action);
        action.startWithTarget(target);
      },
      removeAllActions: function removeAllActions() {
        var locTargets = this._arrayTargets;
        for (var i = 0; i < locTargets.length; i++) {
          var element = locTargets[i];
          element && this._putElement(element);
        }
        this._arrayTargets.length = 0;
        this._hashTargets = js.createMap(true);
      },
      removeAllActionsFromTarget: function removeAllActionsFromTarget(target, forceDelete) {
        if (null == target) return;
        var element = this._hashTargets[target._id];
        if (element) {
          element.actions.length = 0;
          this._deleteHashElement(element);
        }
      },
      removeAction: function removeAction(action) {
        if (null == action) return;
        var target = action.getOriginalTarget();
        var element = this._hashTargets[target._id];
        if (element) {
          for (var i = 0; i < element.actions.length; i++) if (element.actions[i] === action) {
            element.actions.splice(i, 1);
            element.actionIndex >= i && element.actionIndex--;
            break;
          }
        } else cc.logID(1001);
      },
      removeActionByTag: function removeActionByTag(tag, target) {
        tag === cc.Action.TAG_INVALID && cc.logID(1002);
        cc.assertID(target, 1003);
        var element = this._hashTargets[target._id];
        if (element) {
          var limit = element.actions.length;
          for (var i = 0; i < limit; ++i) {
            var action = element.actions[i];
            if (action && action.getTag() === tag && action.getOriginalTarget() === target) {
              this._removeActionAtIndex(i, element);
              break;
            }
          }
        }
      },
      getActionByTag: function getActionByTag(tag, target) {
        tag === cc.Action.TAG_INVALID && cc.logID(1004);
        var element = this._hashTargets[target._id];
        if (element) {
          if (null != element.actions) for (var i = 0; i < element.actions.length; ++i) {
            var action = element.actions[i];
            if (action && action.getTag() === tag) return action;
          }
          cc.logID(1005, tag);
        }
        return null;
      },
      getNumberOfRunningActionsInTarget: function getNumberOfRunningActionsInTarget(target) {
        var element = this._hashTargets[target._id];
        if (element) return element.actions ? element.actions.length : 0;
        return 0;
      },
      pauseTarget: function pauseTarget(target) {
        var element = this._hashTargets[target._id];
        element && (element.paused = true);
      },
      resumeTarget: function resumeTarget(target) {
        var element = this._hashTargets[target._id];
        element && (element.paused = false);
      },
      pauseAllRunningActions: function pauseAllRunningActions() {
        var idsWithActions = [];
        var locTargets = this._arrayTargets;
        for (var i = 0; i < locTargets.length; i++) {
          var element = locTargets[i];
          if (element && !element.paused) {
            element.paused = true;
            idsWithActions.push(element.target);
          }
        }
        return idsWithActions;
      },
      resumeTargets: function resumeTargets(targetsToResume) {
        if (!targetsToResume) return;
        for (var i = 0; i < targetsToResume.length; i++) targetsToResume[i] && this.resumeTarget(targetsToResume[i]);
      },
      pauseTargets: function pauseTargets(targetsToPause) {
        if (!targetsToPause) return;
        for (var i = 0; i < targetsToPause.length; i++) targetsToPause[i] && this.pauseTarget(targetsToPause[i]);
      },
      purgeSharedManager: function purgeSharedManager() {
        cc.director.getScheduler().unscheduleUpdate(this);
      },
      _removeActionAtIndex: function _removeActionAtIndex(index, element) {
        var action = element.actions[index];
        element.actions.splice(index, 1);
        element.actionIndex >= index && element.actionIndex--;
        0 === element.actions.length && this._deleteHashElement(element);
      },
      _deleteHashElement: function _deleteHashElement(element) {
        var ret = false;
        if (element && !element.lock && this._hashTargets[element.target._id]) {
          delete this._hashTargets[element.target._id];
          var targets = this._arrayTargets;
          for (var i = 0, l = targets.length; i < l; i++) if (targets[i] === element) {
            targets.splice(i, 1);
            break;
          }
          this._putElement(element);
          ret = true;
        }
        return ret;
      },
      update: function update(dt) {
        var locTargets = this._arrayTargets, locCurrTarget;
        for (var elt = 0; elt < locTargets.length; elt++) {
          this._currentTarget = locTargets[elt];
          locCurrTarget = this._currentTarget;
          if (!locCurrTarget.paused && locCurrTarget.actions) {
            locCurrTarget.lock = true;
            for (locCurrTarget.actionIndex = 0; locCurrTarget.actionIndex < locCurrTarget.actions.length; locCurrTarget.actionIndex++) {
              locCurrTarget.currentAction = locCurrTarget.actions[locCurrTarget.actionIndex];
              if (!locCurrTarget.currentAction) continue;
              locCurrTarget.currentAction.step(dt * (locCurrTarget.currentAction._speedMethod ? locCurrTarget.currentAction._speed : 1));
              if (locCurrTarget.currentAction && locCurrTarget.currentAction.isDone()) {
                locCurrTarget.currentAction.stop();
                var action = locCurrTarget.currentAction;
                locCurrTarget.currentAction = null;
                this.removeAction(action);
              }
              locCurrTarget.currentAction = null;
            }
            locCurrTarget.lock = false;
          }
          0 === locCurrTarget.actions.length && this._deleteHashElement(locCurrTarget) && elt--;
        }
      }
    };
    false;
  }), {
    "../core/platform/CCClass": 118,
    "../core/platform/js": 138
  } ],
  8: [ (function(require, module, exports) {
    "use strict";
    require("./CCActionManager");
    require("./CCAction");
    require("./CCActionInterval");
    require("./CCActionInstant");
    require("./CCActionEase");
    require("./CCActionCatmullRom");
    require("./tween");
  }), {
    "./CCAction": 2,
    "./CCActionCatmullRom": 3,
    "./CCActionEase": 4,
    "./CCActionInstant": 5,
    "./CCActionInterval": 6,
    "./CCActionManager": 7,
    "./tween": 9
  } ],
  9: [ (function(require, module, exports) {
    "use strict";
    var TweenAction = cc.Class({
      name: "cc.TweenAction",
      extends: cc.ActionInterval,
      ctor: function ctor(duration, props, opts) {
        this._opts = opts = opts || Object.create(null);
        this._props = Object.create(null);
        opts.progress = opts.progress || this.progress;
        if (opts.easing && "string" === typeof opts.easing) {
          var easingName = opts.easing;
          opts.easing = cc.easing[easingName];
          !opts.easing && cc.warnID(1031, easingName);
        }
        var relative = this._opts.relative;
        for (var name in props) {
          var value = props[name];
          var easing = void 0, progress = void 0;
          if (void 0 !== value.value && (value.easing || value.progress)) {
            if ("string" === typeof value.easing) {
              easing = cc.easing[value.easing];
              !easing && cc.warnID(1031, value.easing);
            } else easing = value.easing;
            progress = value.progress;
            value = value.value;
          }
          var isNumber = "number" === typeof value;
          if (!isNumber && (!value.lerp || relative && !value.add && !value.mul || !value.clone)) {
            cc.warn("Can not animate " + name + " property, because it do not have [lerp, (add|mul), clone] function.");
            continue;
          }
          var prop = Object.create(null);
          prop.value = value;
          prop.easing = easing;
          prop.progress = progress;
          this._props[name] = prop;
        }
        this._originProps = props;
        this.initWithDuration(duration);
      },
      clone: function clone() {
        var action = new TweenAction(this._duration, this._originProps, this._opts);
        this._cloneDecoration(action);
        return action;
      },
      startWithTarget: function startWithTarget(target) {
        cc.ActionInterval.prototype.startWithTarget.call(this, target);
        var relative = !!this._opts.relative;
        var props = this._props;
        for (var name in props) {
          var value = target[name];
          var prop = props[name];
          if ("number" === typeof value) {
            prop.start = value;
            prop.current = value;
            prop.end = relative ? value + prop.value : prop.value;
          } else {
            prop.start = value.clone();
            prop.current = value.clone();
            prop.end = relative ? (value.add || value.mul).call(value, prop.value) : prop.value;
          }
        }
      },
      update: function update(t) {
        var opts = this._opts;
        var easingTime = t;
        opts.easing && (easingTime = opts.easing(t));
        var target = this.target;
        if (!target) return;
        var props = this._props;
        var progress = this._opts.progress;
        for (var name in props) {
          var prop = props[name];
          var time = prop.easing ? prop.easing(t) : easingTime;
          var current = prop.current = (prop.progress || progress)(prop.start, prop.end, prop.current, time);
          target[name] = current;
        }
      },
      progress: function progress(start, end, current, t) {
        "number" === typeof start ? current = start + (end - start) * t : start.lerp(end, t, current);
        return current;
      }
    });
    var SetAction = cc.Class({
      name: "cc.SetAction",
      extends: cc.ActionInstant,
      ctor: function ctor(props) {
        this._props = {};
        void 0 !== props && this.init(props);
      },
      init: function init(props) {
        for (var name in props) this._props[name] = props[name];
        return true;
      },
      update: function update() {
        var props = this._props;
        var target = this.target;
        for (var name in props) target[name] = props[name];
      },
      clone: function clone() {
        var action = new SetAction();
        action.init(this._props);
        return action;
      }
    });
    function Tween(target) {
      this._actions = [];
      this._finalAction = null;
      this._target = target;
    }
    Tween.prototype.then = function(other) {
      other instanceof cc.Action ? this._actions.push(other.clone()) : this._actions.push(other._union());
      return this;
    };
    Tween.prototype.target = function(target) {
      this._target = target;
      return this;
    };
    Tween.prototype.start = function() {
      if (!this._target) {
        cc.warn("Please set target to tween first");
        return this;
      }
      this._finalAction && cc.director.getActionManager().removeAction(this._finalAction);
      this._finalAction = this._union();
      cc.director.getActionManager().addAction(this._finalAction, this._target, false);
      return this;
    };
    Tween.prototype.stop = function() {
      this._finalAction && cc.director.getActionManager().removeAction(this._finalAction);
      return this;
    };
    Tween.prototype.clone = function(target) {
      var action = this._union();
      return cc.tween(target).then(action.clone());
    };
    Tween.prototype.union = function() {
      var action = this._union();
      this._actions.length = 0;
      this._actions.push(action);
      return this;
    };
    Tween.prototype._union = function() {
      var actions = this._actions;
      actions = 1 === actions.length ? actions[0] : cc.sequence(actions);
      return actions;
    };
    var tmp_args = [];
    function wrapAction(action) {
      return function() {
        tmp_args.length = 0;
        for (var l = arguments.length, i = 0; i < l; i++) {
          var arg = tmp_args[i] = arguments[i];
          arg instanceof Tween && (tmp_args[i] = arg._union());
        }
        return action.apply(this, tmp_args);
      };
    }
    var actions = {
      to: function to(duration, props, opts) {
        opts = opts || Object.create(null);
        opts.relative = false;
        return new TweenAction(duration, props, opts);
      },
      by: function by(duration, props, opts) {
        opts = opts || Object.create(null);
        opts.relative = true;
        return new TweenAction(duration, props, opts);
      },
      set: function set(props) {
        return new SetAction(props);
      },
      delay: cc.delayTime,
      call: cc.callFunc,
      hide: cc.hide,
      show: cc.show,
      removeSelf: cc.removeSelf,
      sequence: wrapAction(cc.sequence),
      parallel: wrapAction(cc.spawn)
    };
    var previousAsInputActions = {
      repeat: cc.repeat,
      repeatForever: cc.repeatForever,
      reverseTime: cc.reverseTime
    };
    var keys = Object.keys(actions);
    var _loop = function _loop(i) {
      var key = keys[i];
      Tween.prototype[key] = function() {
        var action = actions[key].apply(actions, arguments);
        this._actions.push(action);
        return this;
      };
    };
    for (var i = 0; i < keys.length; i++) _loop(i);
    keys = Object.keys(previousAsInputActions);
    var _loop2 = function _loop2(i) {
      var key = keys[i];
      Tween.prototype[key] = function() {
        var actions = this._actions;
        var action = arguments[arguments.length - 1];
        var length = arguments.length - 1;
        if (action instanceof cc.Tween) action = action._union(); else if (!(action instanceof cc.Action)) {
          action = actions[actions.length - 1];
          actions.length -= 1;
          length += 1;
        }
        var args = [ action ];
        for (var _i = 0; _i < length; _i++) args.push(arguments[_i]);
        action = previousAsInputActions[key].apply(this, args);
        actions.push(action);
        return this;
      };
    };
    for (var i = 0; i < keys.length; i++) _loop2(i);
    cc.tween = function(target) {
      return new Tween(target);
    };
    cc.Tween = Tween;
  }), {} ],
  10: [ (function(require, module, exports) {
    "use strict";
    var js = cc.js;
    var Playable = require("./playable");
    var _require = require("./animation-curves"), EventAnimCurve = _require.EventAnimCurve, EventInfo = _require.EventInfo;
    var WrapModeMask = require("./types").WrapModeMask;
    var binarySearch = require("../core/utils/binary-search").binarySearchEpsilon;
    function AnimationAnimator(target, animation) {
      Playable.call(this);
      this.target = target;
      this.animation = animation;
      this._anims = new js.array.MutableForwardIterator([]);
    }
    js.extend(AnimationAnimator, Playable);
    var p = AnimationAnimator.prototype;
    p.playState = function(state, startTime) {
      if (!state.clip) return;
      state.curveLoaded || initClipData(this.target, state);
      state.animator = this;
      state.play();
      "number" === typeof startTime && state.setTime(startTime);
      this.play();
    };
    p.stopStatesExcept = function(state) {
      var iterator = this._anims;
      var array = iterator.array;
      for (iterator.i = 0; iterator.i < array.length; ++iterator.i) {
        var anim = array[iterator.i];
        if (anim === state) continue;
        this.stopState(anim);
      }
    };
    p.addAnimation = function(anim) {
      var index = this._anims.array.indexOf(anim);
      -1 === index && this._anims.push(anim);
      anim._setEventTarget(this.animation);
    };
    p.removeAnimation = function(anim) {
      var index = this._anims.array.indexOf(anim);
      if (index >= 0) {
        this._anims.fastRemoveAt(index);
        0 === this._anims.array.length && this.stop();
      } else cc.errorID(3908);
      anim.animator = null;
    };
    p.sample = function() {
      var iterator = this._anims;
      var array = iterator.array;
      for (iterator.i = 0; iterator.i < array.length; ++iterator.i) {
        var anim = array[iterator.i];
        anim.sample();
      }
    };
    p.stopState = function(state) {
      state && state.stop();
    };
    p.pauseState = function(state) {
      state && state.pause();
    };
    p.resumeState = function(state) {
      state && state.resume();
      this.isPaused && this.resume();
    };
    p.setStateTime = function(state, time) {
      if (void 0 !== time) {
        if (state) {
          state.setTime(time);
          state.sample();
        }
      } else {
        time = state;
        var array = this._anims.array;
        for (var i = 0; i < array.length; ++i) {
          var anim = array[i];
          anim.setTime(time);
          anim.sample();
        }
      }
    };
    p.onStop = function() {
      var iterator = this._anims;
      var array = iterator.array;
      for (iterator.i = 0; iterator.i < array.length; ++iterator.i) {
        var anim = array[iterator.i];
        anim.stop();
      }
    };
    p.onPause = function() {
      var array = this._anims.array;
      for (var i = 0; i < array.length; ++i) {
        var anim = array[i];
        anim.pause();
        anim.animator = null;
      }
    };
    p.onResume = function() {
      var array = this._anims.array;
      for (var i = 0; i < array.length; ++i) {
        var anim = array[i];
        anim.animator = this;
        anim.resume();
      }
    };
    p._reloadClip = function(state) {
      initClipData(this.target, state);
    };
    function createBatchedProperty(propPath, firstDotIndex, mainValue, animValue) {
      mainValue = mainValue.clone();
      var nextValue = mainValue;
      var leftIndex = firstDotIndex + 1;
      var rightIndex = propPath.indexOf(".", leftIndex);
      while (-1 !== rightIndex) {
        var nextName = propPath.slice(leftIndex, rightIndex);
        nextValue = nextValue[nextName];
        leftIndex = rightIndex + 1;
        rightIndex = propPath.indexOf(".", leftIndex);
      }
      var lastPropName = propPath.slice(leftIndex);
      nextValue[lastPropName] = animValue;
      return mainValue;
    }
    false;
    function initClipData(root, state) {
      var clip = state.clip;
      state.duration = clip.duration;
      state.speed = clip.speed;
      state.wrapMode = clip.wrapMode;
      state.frameRate = clip.sample;
      (state.wrapMode & WrapModeMask.Loop) === WrapModeMask.Loop ? state.repeatCount = Infinity : state.repeatCount = 1;
      var curves = state.curves = clip.createCurves(state, root);
      var events = clip.events;
      if (true, events) {
        var curve = void 0;
        for (var i = 0, l = events.length; i < l; i++) {
          if (!curve) {
            curve = new EventAnimCurve();
            curve.target = root;
            curves.push(curve);
          }
          var eventData = events[i];
          var ratio = eventData.frame / state.duration;
          var eventInfo = void 0;
          var index = binarySearch(curve.ratios, ratio);
          if (index >= 0) eventInfo = curve.events[index]; else {
            eventInfo = new EventInfo();
            curve.ratios.push(ratio);
            curve.events.push(eventInfo);
          }
          eventInfo.add(eventData.func, eventData.params);
        }
      }
    }
    false;
    module.exports = AnimationAnimator;
  }), {
    "../core/utils/binary-search": 196,
    "./animation-curves": 12,
    "./playable": 19,
    "./types": 20
  } ],
  11: [ (function(require, module, exports) {
    "use strict";
    var WrapMode = require("./types").WrapMode;
    var _require = require("./animation-curves"), DynamicAnimCurve = _require.DynamicAnimCurve, quickFindIndex = _require.quickFindIndex;
    var sampleMotionPaths = require("./motion-path-helper").sampleMotionPaths;
    var binarySearch = require("../core/utils/binary-search").binarySearchEpsilon;
    var AnimationClip = cc.Class({
      name: "cc.AnimationClip",
      extends: cc.Asset,
      properties: {
        _duration: {
          default: 0,
          type: "Float"
        },
        duration: {
          get: function get() {
            return this._duration;
          }
        },
        sample: {
          default: 60
        },
        speed: {
          default: 1
        },
        wrapMode: {
          default: WrapMode.Normal
        },
        curveData: {
          default: {},
          visible: false
        },
        events: {
          default: [],
          visible: false
        }
      },
      statics: {
        createWithSpriteFrames: function createWithSpriteFrames(spriteFrames, sample) {
          if (!Array.isArray(spriteFrames)) {
            cc.errorID(3905);
            return null;
          }
          var clip = new AnimationClip();
          clip.sample = sample || clip.sample;
          clip._duration = spriteFrames.length / clip.sample;
          var frames = [];
          var step = 1 / clip.sample;
          for (var i = 0, l = spriteFrames.length; i < l; i++) frames[i] = {
            frame: i * step,
            value: spriteFrames[i]
          };
          clip.curveData = {
            comps: {
              "cc.Sprite": {
                spriteFrame: frames
              }
            }
          };
          return clip;
        }
      },
      onLoad: function onLoad() {
        this._duration = Number.parseFloat(this.duration);
        this.speed = Number.parseFloat(this.speed);
        this.wrapMode = Number.parseInt(this.wrapMode);
        this.frameRate = Number.parseFloat(this.sample);
      },
      createPropCurve: function createPropCurve(target, propPath, keyframes) {
        var motionPaths = [];
        var isMotionPathProp = target instanceof cc.Node && "position" === propPath;
        var curve = new DynamicAnimCurve();
        curve.target = target;
        curve.prop = propPath;
        for (var i = 0, l = keyframes.length; i < l; i++) {
          var keyframe = keyframes[i];
          var ratio = keyframe.frame / this.duration;
          curve.ratios.push(ratio);
          isMotionPathProp && motionPaths.push(keyframe.motionPath);
          var curveValue = keyframe.value;
          curve.values.push(curveValue);
          var curveTypes = keyframe.curve;
          if (curveTypes) {
            if ("string" === typeof curveTypes) {
              curve.types.push(curveTypes);
              continue;
            }
            if (Array.isArray(curveTypes)) {
              curveTypes[0] === curveTypes[1] && curveTypes[2] === curveTypes[3] ? curve.types.push(DynamicAnimCurve.Linear) : curve.types.push(DynamicAnimCurve.Bezier(curveTypes));
              continue;
            }
          }
          curve.types.push(DynamicAnimCurve.Linear);
        }
        isMotionPathProp && sampleMotionPaths(motionPaths, curve, this.duration, this.sample, target);
        var ratios = curve.ratios;
        var currRatioDif = void 0, lastRatioDif = void 0;
        var canOptimize = true;
        var EPSILON = 1e-6;
        for (var _i = 1, _l = ratios.length; _i < _l; _i++) {
          currRatioDif = ratios[_i] - ratios[_i - 1];
          if (1 === _i) lastRatioDif = currRatioDif; else if (Math.abs(currRatioDif - lastRatioDif) > EPSILON) {
            canOptimize = false;
            break;
          }
        }
        curve._findFrameIndex = canOptimize ? quickFindIndex : binarySearch;
        var firstValue = curve.values[0];
        void 0 === firstValue || null === firstValue || curve._lerp || ("number" === typeof firstValue ? curve._lerp = DynamicAnimCurve.prototype._lerpNumber : firstValue instanceof cc.Quat ? curve._lerp = DynamicAnimCurve.prototype._lerpQuat : firstValue instanceof cc.Vec2 || firstValue instanceof cc.Vec3 ? curve._lerp = DynamicAnimCurve.prototype._lerpVector : firstValue.lerp && (curve._lerp = DynamicAnimCurve.prototype._lerpObject));
        return curve;
      },
      createTargetCurves: function createTargetCurves(target, curveData, curves) {
        var propsData = curveData.props;
        var compsData = curveData.comps;
        if (propsData) for (var propPath in propsData) {
          var data = propsData[propPath];
          var curve = this.createPropCurve(target, propPath, data);
          curves.push(curve);
        }
        if (compsData) for (var compName in compsData) {
          var comp = target.getComponent(compName);
          if (!comp) continue;
          var compData = compsData[compName];
          for (var _propPath in compData) {
            var _data = compData[_propPath];
            var _curve = this.createPropCurve(comp, _propPath, _data);
            curves.push(_curve);
          }
        }
      },
      createCurves: function createCurves(state, root) {
        var curveData = this.curveData;
        var childrenCurveDatas = curveData.paths;
        var curves = [];
        this.createTargetCurves(root, curveData, curves);
        for (var namePath in childrenCurveDatas) {
          var target = cc.find(namePath, root);
          if (!target) continue;
          var childCurveDatas = childrenCurveDatas[namePath];
          this.createTargetCurves(target, childCurveDatas, curves);
        }
        return curves;
      }
    });
    cc.AnimationClip = module.exports = AnimationClip;
  }), {
    "../core/utils/binary-search": 196,
    "./animation-curves": 12,
    "./motion-path-helper": 18,
    "./types": 20
  } ],
  12: [ (function(require, module, exports) {
    "use strict";
    var bezierByTime = require("./bezier").bezierByTime;
    var binarySearch = require("../core/utils/binary-search").binarySearchEpsilon;
    var WrapModeMask = require("./types").WrapModeMask;
    var WrappedInfo = require("./types").WrappedInfo;
    function computeRatioByType(ratio, type) {
      if ("string" === typeof type) {
        var func = cc.easing[type];
        func ? ratio = func(ratio) : cc.errorID(3906, type);
      } else Array.isArray(type) && (ratio = bezierByTime(type, ratio));
      return ratio;
    }
    var AnimCurve = cc.Class({
      name: "cc.AnimCurve",
      sample: function sample(time, ratio, state) {},
      onTimeChangedManually: void 0
    });
    function quickFindIndex(ratios, ratio) {
      var length = ratios.length - 1;
      if (0 === length) return 0;
      var start = ratios[0];
      if (ratio < start) return 0;
      var end = ratios[length];
      if (ratio > end) return length;
      ratio = (ratio - start) / (end - start);
      var eachLength = 1 / length;
      var index = ratio / eachLength;
      var floorIndex = 0 | index;
      var EPSILON = 1e-6;
      if (index - floorIndex < EPSILON) return floorIndex;
      if (floorIndex + 1 - index < EPSILON) return floorIndex + 1;
      return ~(floorIndex + 1);
    }
    var DynamicAnimCurve = cc.Class({
      name: "cc.DynamicAnimCurve",
      extends: AnimCurve,
      properties: {
        target: null,
        prop: "",
        values: [],
        ratios: [],
        types: []
      },
      _findFrameIndex: binarySearch,
      _lerp: void 0,
      _lerpNumber: function _lerpNumber(from, to, t) {
        return from + (to - from) * t;
      },
      _lerpObject: function _lerpObject(from, to, t) {
        return from.lerp(to, t);
      },
      _lerpQuat: (function() {
        var out = cc.quat();
        return function(from, to, t) {
          return from.lerp(to, t, out);
        };
      })(),
      _lerpVector: (function() {
        var out = cc.v3();
        return function(from, to, t) {
          return from.lerp(to, t, out);
        };
      })(),
      sample: function sample(time, ratio, state) {
        var values = this.values;
        var ratios = this.ratios;
        var frameCount = ratios.length;
        if (0 === frameCount) return;
        var value;
        var index = this._findFrameIndex(ratios, ratio);
        if (index < 0) {
          index = ~index;
          if (index <= 0) value = values[0]; else if (index >= frameCount) value = values[frameCount - 1]; else {
            var fromVal = values[index - 1];
            if (this._lerp) {
              var fromRatio = ratios[index - 1];
              var toRatio = ratios[index];
              var type = this.types[index - 1];
              var ratioBetweenFrames = (ratio - fromRatio) / (toRatio - fromRatio);
              type && (ratioBetweenFrames = computeRatioByType(ratioBetweenFrames, type));
              var toVal = values[index];
              value = this._lerp(fromVal, toVal, ratioBetweenFrames);
            } else value = fromVal;
          }
        } else value = values[index];
        this.target[this.prop] = value;
      }
    });
    DynamicAnimCurve.Linear = null;
    DynamicAnimCurve.Bezier = function(controlPoints) {
      return controlPoints;
    };
    var EventInfo = function EventInfo() {
      this.events = [];
    };
    EventInfo.prototype.add = function(func, params) {
      this.events.push({
        func: func || "",
        params: params || []
      });
    };
    var EventAnimCurve = cc.Class({
      name: "cc.EventAnimCurve",
      extends: AnimCurve,
      properties: {
        target: null,
        ratios: [],
        events: [],
        _wrappedInfo: {
          default: function _default() {
            return new WrappedInfo();
          }
        },
        _lastWrappedInfo: null,
        _ignoreIndex: NaN
      },
      _wrapIterations: function _wrapIterations(iterations) {
        iterations - (0 | iterations) === 0 && (iterations -= 1);
        return 0 | iterations;
      },
      sample: function sample(time, ratio, state) {
        var length = this.ratios.length;
        var currentWrappedInfo = state.getWrappedInfo(state.time, this._wrappedInfo);
        var direction = currentWrappedInfo.direction;
        var currentIndex = binarySearch(this.ratios, currentWrappedInfo.ratio);
        if (currentIndex < 0) {
          currentIndex = ~currentIndex - 1;
          direction < 0 && (currentIndex += 1);
        }
        this._ignoreIndex !== currentIndex && (this._ignoreIndex = NaN);
        currentWrappedInfo.frameIndex = currentIndex;
        if (!this._lastWrappedInfo) {
          this._fireEvent(currentIndex);
          this._lastWrappedInfo = new WrappedInfo(currentWrappedInfo);
          return;
        }
        var wrapMode = state.wrapMode;
        var currentIterations = this._wrapIterations(currentWrappedInfo.iterations);
        var lastWrappedInfo = this._lastWrappedInfo;
        var lastIterations = this._wrapIterations(lastWrappedInfo.iterations);
        var lastIndex = lastWrappedInfo.frameIndex;
        var lastDirection = lastWrappedInfo.direction;
        var interationsChanged = -1 !== lastIterations && currentIterations !== lastIterations;
        if (lastIndex === currentIndex && interationsChanged && 1 === length) this._fireEvent(0); else if (lastIndex !== currentIndex || interationsChanged) {
          direction = lastDirection;
          do {
            if (lastIndex !== currentIndex) {
              if (-1 === direction && 0 === lastIndex && currentIndex > 0) {
                (wrapMode & WrapModeMask.PingPong) === WrapModeMask.PingPong ? direction *= -1 : lastIndex = length;
                lastIterations++;
              } else if (1 === direction && lastIndex === length - 1 && currentIndex < length - 1) {
                (wrapMode & WrapModeMask.PingPong) === WrapModeMask.PingPong ? direction *= -1 : lastIndex = -1;
                lastIterations++;
              }
              if (lastIndex === currentIndex) break;
              if (lastIterations > currentIterations) break;
            }
            lastIndex += direction;
            cc.director.getAnimationManager().pushDelayEvent(this, "_fireEvent", [ lastIndex ]);
          } while (lastIndex !== currentIndex && lastIndex > -1 && lastIndex < length);
        }
        this._lastWrappedInfo.set(currentWrappedInfo);
      },
      _fireEvent: function _fireEvent(index) {
        if (index < 0 || index >= this.events.length || this._ignoreIndex === index) return;
        var eventInfo = this.events[index];
        var events = eventInfo.events;
        if (!this.target.isValid) return;
        var components = this.target._components;
        for (var i = 0; i < events.length; i++) {
          var event = events[i];
          var funcName = event.func;
          for (var j = 0; j < components.length; j++) {
            var component = components[j];
            var func = component[funcName];
            func && func.apply(component, event.params);
          }
        }
      },
      onTimeChangedManually: function onTimeChangedManually(time, state) {
        this._lastWrappedInfo = null;
        this._ignoreIndex = NaN;
        var info = state.getWrappedInfo(time, this._wrappedInfo);
        var direction = info.direction;
        var frameIndex = binarySearch(this.ratios, info.ratio);
        if (frameIndex < 0) {
          frameIndex = ~frameIndex - 1;
          direction < 0 && (frameIndex += 1);
          this._ignoreIndex = frameIndex;
        }
      }
    });
    false;
    module.exports = {
      AnimCurve: AnimCurve,
      DynamicAnimCurve: DynamicAnimCurve,
      EventAnimCurve: EventAnimCurve,
      EventInfo: EventInfo,
      computeRatioByType: computeRatioByType,
      quickFindIndex: quickFindIndex
    };
  }), {
    "../core/utils/binary-search": 196,
    "./bezier": 15,
    "./types": 20
  } ],
  13: [ (function(require, module, exports) {
    "use strict";
    var js = cc.js;
    var AnimationManager = cc.Class({
      ctor: function ctor() {
        this._anims = new js.array.MutableForwardIterator([]);
        this._delayEvents = [];
        cc.director._scheduler && cc.director._scheduler.enableForTarget(this);
      },
      update: function update(dt) {
        var iterator = this._anims;
        var array = iterator.array;
        for (iterator.i = 0; iterator.i < array.length; ++iterator.i) {
          var anim = array[iterator.i];
          anim._isPlaying && !anim._isPaused && anim.update(dt);
        }
        var events = this._delayEvents;
        for (var i = 0, l = events.length; i < l; i++) {
          var event = events[i];
          event.target[event.func].apply(event.target, event.args);
        }
        events.length = 0;
      },
      destruct: function destruct() {},
      addAnimation: function addAnimation(anim) {
        var index = this._anims.array.indexOf(anim);
        -1 === index && this._anims.push(anim);
      },
      removeAnimation: function removeAnimation(anim) {
        var index = this._anims.array.indexOf(anim);
        index >= 0 ? this._anims.fastRemoveAt(index) : cc.errorID(3907);
      },
      pushDelayEvent: function pushDelayEvent(target, func, args) {
        this._delayEvents.push({
          target: target,
          func: func,
          args: args
        });
      }
    });
    cc.AnimationManager = module.exports = AnimationManager;
  }), {} ],
  14: [ (function(require, module, exports) {
    "use strict";
    var js = cc.js;
    var Playable = require("./playable");
    var Types = require("./types");
    var WrappedInfo = Types.WrappedInfo;
    var WrapMode = Types.WrapMode;
    var WrapModeMask = Types.WrapModeMask;
    function AnimationState(clip, name) {
      Playable.call(this);
      this._currentFramePlayed = false;
      this._delay = 0;
      this._delayTime = 0;
      this._wrappedInfo = new WrappedInfo();
      this._lastWrappedInfo = null;
      this._process = process;
      this._clip = clip;
      this._name = name || clip && clip.name;
      this.animator = null;
      this.curves = [];
      this.delay = 0;
      this.repeatCount = 1;
      this.duration = 1;
      this.speed = 1;
      this.wrapMode = WrapMode.Normal;
      this.time = 0;
      this._target = null;
      this._lastframeEventOn = false;
      this.emit = function() {
        var args = new Array(arguments.length);
        for (var i = 0, l = args.length; i < l; i++) args[i] = arguments[i];
        cc.director.getAnimationManager().pushDelayEvent(this, "_emit", args);
      };
    }
    js.extend(AnimationState, Playable);
    var proto = AnimationState.prototype;
    proto._emit = function(type, state) {
      this._target && this._target.isValid && this._target.emit(type, type, state);
    };
    proto.on = function(type, callback, target) {
      if (this._target && this._target.isValid) {
        "lastframe" === type && (this._lastframeEventOn = true);
        return this._target.on(type, callback, target);
      }
      return null;
    };
    proto.once = function(type, callback, target) {
      if (this._target && this._target.isValid) {
        "lastframe" === type && (this._lastframeEventOn = true);
        var self = this;
        return this._target.once(type, (function(event) {
          callback.call(target, event);
          self._lastframeEventOn = false;
        }));
      }
      return null;
    };
    proto.off = function(type, callback, target) {
      if (this._target && this._target.isValid) {
        "lastframe" === type && (this._target.hasEventListener(type) || (this._lastframeEventOn = false));
        this._target.off(type, callback, target);
      }
    };
    proto._setEventTarget = function(target) {
      this._target = target;
    };
    proto.onPlay = function() {
      this.setTime(0);
      this._delayTime = this._delay;
      cc.director.getAnimationManager().addAnimation(this);
      this.animator && this.animator.addAnimation(this);
      this.emit("play", this);
    };
    proto.onStop = function() {
      this.isPaused || cc.director.getAnimationManager().removeAnimation(this);
      this.animator && this.animator.removeAnimation(this);
      this.emit("stop", this);
    };
    proto.onResume = function() {
      cc.director.getAnimationManager().addAnimation(this);
      this.emit("resume", this);
    };
    proto.onPause = function() {
      cc.director.getAnimationManager().removeAnimation(this);
      this.emit("pause", this);
    };
    proto.setTime = function(time) {
      this._currentFramePlayed = false;
      this.time = time || 0;
      var curves = this.curves;
      for (var i = 0, l = curves.length; i < l; i++) {
        var curve = curves[i];
        curve.onTimeChangedManually && curve.onTimeChangedManually(time, this);
      }
    };
    function process() {
      var info = this.sample();
      if (this._lastframeEventOn) {
        var lastInfo;
        lastInfo = this._lastWrappedInfo ? this._lastWrappedInfo : this._lastWrappedInfo = new WrappedInfo(info);
        this.repeatCount > 1 && (0 | info.iterations) > (0 | lastInfo.iterations) && this.emit("lastframe", this);
        lastInfo.set(info);
      }
      if (info.stopped) {
        this.stop();
        this.emit("finished", this);
      }
    }
    function simpleProcess() {
      var time = this.time;
      var duration = this.duration;
      if (time > duration) {
        time %= duration;
        0 === time && (time = duration);
      } else if (time < 0) {
        time %= duration;
        0 !== time && (time += duration);
      }
      var ratio = time / duration;
      var curves = this.curves;
      for (var i = 0, len = curves.length; i < len; i++) {
        var curve = curves[i];
        curve.sample(time, ratio, this);
      }
      if (this._lastframeEventOn) {
        void 0 === this._lastIterations && (this._lastIterations = ratio);
        (this.time > 0 && this._lastIterations > ratio || this.time < 0 && this._lastIterations < ratio) && this.emit("lastframe", this);
        this._lastIterations = ratio;
      }
    }
    proto.update = function(delta) {
      if (this._delayTime > 0) {
        this._delayTime -= delta;
        if (this._delayTime > 0) return;
      }
      this._currentFramePlayed ? this.time += delta * this.speed : this._currentFramePlayed = true;
      this._process();
    };
    proto._needRevers = function(currentIterations) {
      var wrapMode = this.wrapMode;
      var needRevers = false;
      if ((wrapMode & WrapModeMask.PingPong) === WrapModeMask.PingPong) {
        var isEnd = currentIterations - (0 | currentIterations) === 0;
        isEnd && currentIterations > 0 && (currentIterations -= 1);
        var isOddIteration = 1 & currentIterations;
        isOddIteration && (needRevers = !needRevers);
      }
      (wrapMode & WrapModeMask.Reverse) === WrapModeMask.Reverse && (needRevers = !needRevers);
      return needRevers;
    };
    proto.getWrappedInfo = function(time, info) {
      info = info || new WrappedInfo();
      var stopped = false;
      var duration = this.duration;
      var repeatCount = this.repeatCount;
      var currentIterations = time > 0 ? time / duration : -time / duration;
      if (currentIterations >= repeatCount) {
        currentIterations = repeatCount;
        stopped = true;
        var tempRatio = repeatCount - (0 | repeatCount);
        0 === tempRatio && (tempRatio = 1);
        time = tempRatio * duration * (time > 0 ? 1 : -1);
      }
      if (time > duration) {
        var tempTime = time % duration;
        time = 0 === tempTime ? duration : tempTime;
      } else if (time < 0) {
        time %= duration;
        0 !== time && (time += duration);
      }
      var needRevers = false;
      var shouldWrap = this._wrapMode & WrapModeMask.ShouldWrap;
      shouldWrap && (needRevers = this._needRevers(currentIterations));
      var direction = needRevers ? -1 : 1;
      this.speed < 0 && (direction *= -1);
      shouldWrap && needRevers && (time = duration - time);
      info.ratio = time / duration;
      info.time = time;
      info.direction = direction;
      info.stopped = stopped;
      info.iterations = currentIterations;
      return info;
    };
    proto.sample = function() {
      var info = this.getWrappedInfo(this.time, this._wrappedInfo);
      var curves = this.curves;
      for (var i = 0, len = curves.length; i < len; i++) {
        var curve = curves[i];
        curve.sample(info.time, info.ratio, this);
      }
      return info;
    };
    js.get(proto, "clip", (function() {
      return this._clip;
    }));
    js.get(proto, "name", (function() {
      return this._name;
    }));
    js.obsolete(proto, "AnimationState.length", "duration");
    js.getset(proto, "curveLoaded", (function() {
      return this.curves.length > 0;
    }), (function() {
      this.curves.length = 0;
    }));
    js.getset(proto, "wrapMode", (function() {
      return this._wrapMode;
    }), (function(value) {
      this._wrapMode = value;
      false;
      this.time = 0;
      value & WrapModeMask.Loop ? this.repeatCount = Infinity : this.repeatCount = 1;
    }));
    js.getset(proto, "repeatCount", (function() {
      return this._repeatCount;
    }), (function(value) {
      this._repeatCount = value;
      var shouldWrap = this._wrapMode & WrapModeMask.ShouldWrap;
      var reverse = (this.wrapMode & WrapModeMask.Reverse) === WrapModeMask.Reverse;
      this._process = Infinity !== value || shouldWrap || reverse ? process : simpleProcess;
    }));
    js.getset(proto, "delay", (function() {
      return this._delay;
    }), (function(value) {
      this._delayTime = this._delay = value;
    }));
    cc.AnimationState = module.exports = AnimationState;
  }), {
    "./playable": 19,
    "./types": 20
  } ],
  15: [ (function(require, module, exports) {
    "use strict";
    function bezier(C1, C2, C3, C4, t) {
      var t1 = 1 - t;
      return C1 * t1 * t1 * t1 + 3 * C2 * t1 * t1 * t + 3 * C3 * t1 * t * t + C4 * t * t * t;
    }
    var cos = Math.cos, acos = Math.acos, max = Math.max, pi = Math.PI, tau = 2 * pi, sqrt = Math.sqrt;
    function crt(v) {
      return v < 0 ? -Math.pow(-v, 1 / 3) : Math.pow(v, 1 / 3);
    }
    function cardano(curve, x) {
      var pa = x - 0;
      var pb = x - curve[0];
      var pc = x - curve[2];
      var pd = x - 1;
      var pa3 = 3 * pa;
      var pb3 = 3 * pb;
      var pc3 = 3 * pc;
      var d = -pa + pb3 - pc3 + pd, rd = 1 / d, r3 = 1 / 3, a = (pa3 - 6 * pb + pc3) * rd, a3 = a * r3, b = (-pa3 + pb3) * rd, c = pa * rd, p = (3 * b - a * a) * r3, p3 = p * r3, q = (2 * a * a * a - 9 * a * b + 27 * c) / 27, q2 = q / 2, discriminant = q2 * q2 + p3 * p3 * p3, u1, v1, x1, x2, x3;
      if (discriminant < 0) {
        var mp3 = -p * r3, mp33 = mp3 * mp3 * mp3, r = sqrt(mp33), t = -q / (2 * r), cosphi = t < -1 ? -1 : t > 1 ? 1 : t, phi = acos(cosphi), crtr = crt(r), t1 = 2 * crtr;
        x1 = t1 * cos(phi * r3) - a3;
        x2 = t1 * cos((phi + tau) * r3) - a3;
        x3 = t1 * cos((phi + 2 * tau) * r3) - a3;
        return 0 <= x1 && x1 <= 1 ? 0 <= x2 && x2 <= 1 ? 0 <= x3 && x3 <= 1 ? max(x1, x2, x3) : max(x1, x2) : 0 <= x3 && x3 <= 1 ? max(x1, x3) : x1 : 0 <= x2 && x2 <= 1 ? 0 <= x3 && x3 <= 1 ? max(x2, x3) : x2 : x3;
      }
      if (0 === discriminant) {
        u1 = q2 < 0 ? crt(-q2) : -crt(q2);
        x1 = 2 * u1 - a3;
        x2 = -u1 - a3;
        return 0 <= x1 && x1 <= 1 ? 0 <= x2 && x2 <= 1 ? max(x1, x2) : x1 : x2;
      }
      var sd = sqrt(discriminant);
      u1 = crt(-q2 + sd);
      v1 = crt(q2 + sd);
      x1 = u1 - v1 - a3;
      return x1;
    }
    function bezierByTime(controlPoints, x) {
      var percent = cardano(controlPoints, x);
      var p0y = 0;
      var p1y = controlPoints[1];
      var p2y = controlPoints[3];
      var p3y = 1;
      var t1 = 1 - percent;
      return p0y * t1 * t1 * t1 + 3 * p1y * percent * t1 * t1 + 3 * p2y * percent * percent * t1 + p3y * percent * percent * percent;
    }
    false;
    module.exports = {
      bezier: bezier,
      bezierByTime: bezierByTime
    };
  }), {} ],
  16: [ (function(require, module, exports) {
    "use strict";
    var easing = {
      constant: function constant() {
        return 0;
      },
      linear: function linear(k) {
        return k;
      },
      quadIn: function quadIn(k) {
        return k * k;
      },
      quadOut: function quadOut(k) {
        return k * (2 - k);
      },
      quadInOut: function quadInOut(k) {
        if ((k *= 2) < 1) return .5 * k * k;
        return -.5 * (--k * (k - 2) - 1);
      },
      cubicIn: function cubicIn(k) {
        return k * k * k;
      },
      cubicOut: function cubicOut(k) {
        return --k * k * k + 1;
      },
      cubicInOut: function cubicInOut(k) {
        if ((k *= 2) < 1) return .5 * k * k * k;
        return .5 * ((k -= 2) * k * k + 2);
      },
      quartIn: function quartIn(k) {
        return k * k * k * k;
      },
      quartOut: function quartOut(k) {
        return 1 - --k * k * k * k;
      },
      quartInOut: function quartInOut(k) {
        if ((k *= 2) < 1) return .5 * k * k * k * k;
        return -.5 * ((k -= 2) * k * k * k - 2);
      },
      quintIn: function quintIn(k) {
        return k * k * k * k * k;
      },
      quintOut: function quintOut(k) {
        return --k * k * k * k * k + 1;
      },
      quintInOut: function quintInOut(k) {
        if ((k *= 2) < 1) return .5 * k * k * k * k * k;
        return .5 * ((k -= 2) * k * k * k * k + 2);
      },
      sineIn: function sineIn(k) {
        return 1 - Math.cos(k * Math.PI / 2);
      },
      sineOut: function sineOut(k) {
        return Math.sin(k * Math.PI / 2);
      },
      sineInOut: function sineInOut(k) {
        return .5 * (1 - Math.cos(Math.PI * k));
      },
      expoIn: function expoIn(k) {
        return 0 === k ? 0 : Math.pow(1024, k - 1);
      },
      expoOut: function expoOut(k) {
        return 1 === k ? 1 : 1 - Math.pow(2, -10 * k);
      },
      expoInOut: function expoInOut(k) {
        if (0 === k) return 0;
        if (1 === k) return 1;
        if ((k *= 2) < 1) return .5 * Math.pow(1024, k - 1);
        return .5 * (2 - Math.pow(2, -10 * (k - 1)));
      },
      circIn: function circIn(k) {
        return 1 - Math.sqrt(1 - k * k);
      },
      circOut: function circOut(k) {
        return Math.sqrt(1 - --k * k);
      },
      circInOut: function circInOut(k) {
        if ((k *= 2) < 1) return -.5 * (Math.sqrt(1 - k * k) - 1);
        return .5 * (Math.sqrt(1 - (k -= 2) * k) + 1);
      },
      elasticIn: function elasticIn(k) {
        var s, a = .1, p = .4;
        if (0 === k) return 0;
        if (1 === k) return 1;
        if (!a || a < 1) {
          a = 1;
          s = p / 4;
        } else s = p * Math.asin(1 / a) / (2 * Math.PI);
        return -a * Math.pow(2, 10 * (k -= 1)) * Math.sin((k - s) * (2 * Math.PI) / p);
      },
      elasticOut: function elasticOut(k) {
        var s, a = .1, p = .4;
        if (0 === k) return 0;
        if (1 === k) return 1;
        if (!a || a < 1) {
          a = 1;
          s = p / 4;
        } else s = p * Math.asin(1 / a) / (2 * Math.PI);
        return a * Math.pow(2, -10 * k) * Math.sin((k - s) * (2 * Math.PI) / p) + 1;
      },
      elasticInOut: function elasticInOut(k) {
        var s, a = .1, p = .4;
        if (0 === k) return 0;
        if (1 === k) return 1;
        if (!a || a < 1) {
          a = 1;
          s = p / 4;
        } else s = p * Math.asin(1 / a) / (2 * Math.PI);
        if ((k *= 2) < 1) return a * Math.pow(2, 10 * (k -= 1)) * Math.sin((k - s) * (2 * Math.PI) / p) * -.5;
        return a * Math.pow(2, -10 * (k -= 1)) * Math.sin((k - s) * (2 * Math.PI) / p) * .5 + 1;
      },
      backIn: function backIn(k) {
        var s = 1.70158;
        return k * k * ((s + 1) * k - s);
      },
      backOut: function backOut(k) {
        var s = 1.70158;
        return --k * k * ((s + 1) * k + s) + 1;
      },
      backInOut: function backInOut(k) {
        var s = 2.5949095;
        if ((k *= 2) < 1) return k * k * ((s + 1) * k - s) * .5;
        return .5 * ((k -= 2) * k * ((s + 1) * k + s) + 2);
      },
      bounceIn: function bounceIn(k) {
        return 1 - easing.bounceOut(1 - k);
      },
      bounceOut: function bounceOut(k) {
        return k < 1 / 2.75 ? 7.5625 * k * k : k < 2 / 2.75 ? 7.5625 * (k -= 1.5 / 2.75) * k + .75 : k < 2.5 / 2.75 ? 7.5625 * (k -= 2.25 / 2.75) * k + .9375 : 7.5625 * (k -= 2.625 / 2.75) * k + .984375;
      },
      bounceInOut: function bounceInOut(k) {
        if (k < .5) return .5 * easing.bounceIn(2 * k);
        return .5 * easing.bounceOut(2 * k - 1) + .5;
      },
      smooth: function smooth(t) {
        if (t <= 0) return 0;
        if (t >= 1) return 1;
        return t * t * (3 - 2 * t);
      },
      fade: function fade(t) {
        if (t <= 0) return 0;
        if (t >= 1) return 1;
        return t * t * t * (t * (6 * t - 15) + 10);
      }
    };
    function _makeOutIn(fnIn, fnOut) {
      return function(k) {
        if (k < .5) return fnOut(2 * k) / 2;
        return fnIn(2 * k - 1) / 2 + .5;
      };
    }
    easing.quadOutIn = _makeOutIn(easing.quadIn, easing.quadOut);
    easing.cubicOutIn = _makeOutIn(easing.cubicIn, easing.cubicOut);
    easing.quartOutIn = _makeOutIn(easing.quartIn, easing.quartOut);
    easing.quintOutIn = _makeOutIn(easing.quintIn, easing.quintOut);
    easing.sineOutIn = _makeOutIn(easing.sineIn, easing.sineOut);
    easing.expoOutIn = _makeOutIn(easing.expoIn, easing.expoOut);
    easing.circOutIn = _makeOutIn(easing.circIn, easing.circOut);
    easing.backOutIn = _makeOutIn(easing.backIn, easing.backOut);
    easing.bounceIn = function(k) {
      return 1 - easing.bounceOut(1 - k);
    };
    easing.bounceInOut = function(k) {
      if (k < .5) return .5 * easing.bounceIn(2 * k);
      return .5 * easing.bounceOut(2 * k - 1) + .5;
    };
    easing.bounceOutIn = _makeOutIn(easing.bounceIn, easing.bounceOut);
    cc.easing = module.exports = easing;
  }), {} ],
  17: [ (function(require, module, exports) {
    "use strict";
    require("./bezier");
    require("./easing");
    require("./types");
    require("./motion-path-helper");
    require("./animation-curves");
    require("./animation-clip");
    require("./animation-manager");
    require("./animation-state");
    require("./animation-animator");
  }), {
    "./animation-animator": 10,
    "./animation-clip": 11,
    "./animation-curves": 12,
    "./animation-manager": 13,
    "./animation-state": 14,
    "./bezier": 15,
    "./easing": 16,
    "./motion-path-helper": 18,
    "./types": 20
  } ],
  18: [ (function(require, module, exports) {
    "use strict";
    var DynamicAnimCurve = require("./animation-curves").DynamicAnimCurve;
    var computeRatioByType = require("./animation-curves").computeRatioByType;
    var bezier = require("./bezier").bezier;
    var binarySearch = require("../core/utils/binary-search").binarySearchEpsilon;
    var v2 = cc.v2;
    function Curve(points) {
      this.points = points || [];
      this.beziers = [];
      this.ratios = [];
      this.progresses = [];
      this.length = 0;
      this.computeBeziers();
    }
    Curve.prototype.computeBeziers = function() {
      this.beziers.length = 0;
      this.ratios.length = 0;
      this.progresses.length = 0;
      this.length = 0;
      var bezier;
      for (var i = 1; i < this.points.length; i++) {
        var startPoint = this.points[i - 1];
        var endPoint = this.points[i];
        bezier = new Bezier();
        bezier.start = startPoint.pos;
        bezier.startCtrlPoint = startPoint.out;
        bezier.end = endPoint.pos;
        bezier.endCtrlPoint = endPoint.in;
        this.beziers.push(bezier);
        this.length += bezier.getLength();
      }
      var current = 0;
      for (var i = 0; i < this.beziers.length; i++) {
        bezier = this.beziers[i];
        this.ratios[i] = bezier.getLength() / this.length;
        this.progresses[i] = current += this.ratios[i];
      }
      return this.beziers;
    };
    function Bezier() {
      this.start = v2();
      this.end = v2();
      this.startCtrlPoint = v2();
      this.endCtrlPoint = v2();
    }
    Bezier.prototype.getPointAt = function(u) {
      var t = this.getUtoTmapping(u);
      return this.getPoint(t);
    };
    Bezier.prototype.getPoint = function(t) {
      var x = bezier(this.start.x, this.startCtrlPoint.x, this.endCtrlPoint.x, this.end.x, t);
      var y = bezier(this.start.y, this.startCtrlPoint.y, this.endCtrlPoint.y, this.end.y, t);
      return new v2(x, y);
    };
    Bezier.prototype.getLength = function() {
      var lengths = this.getLengths();
      return lengths[lengths.length - 1];
    };
    Bezier.prototype.getLengths = function(divisions) {
      divisions || (divisions = this.__arcLengthDivisions ? this.__arcLengthDivisions : 200);
      if (this.cacheArcLengths && this.cacheArcLengths.length === divisions + 1) return this.cacheArcLengths;
      var cache = [];
      var current, last = this.getPoint(0), vector = v2();
      var p, sum = 0;
      cache.push(0);
      for (p = 1; p <= divisions; p++) {
        current = this.getPoint(p / divisions);
        vector.x = last.x - current.x;
        vector.y = last.y - current.y;
        sum += vector.mag();
        cache.push(sum);
        last = current;
      }
      this.cacheArcLengths = cache;
      return cache;
    };
    Bezier.prototype.getUtoTmapping = function(u, distance) {
      var arcLengths = this.getLengths();
      var i = 0, il = arcLengths.length;
      var targetArcLength;
      targetArcLength = distance || u * arcLengths[il - 1];
      var low = 0, high = il - 1, comparison;
      while (low <= high) {
        i = Math.floor(low + (high - low) / 2);
        comparison = arcLengths[i] - targetArcLength;
        if (comparison < 0) {
          low = i + 1;
          continue;
        }
        if (comparison > 0) {
          high = i - 1;
          continue;
        }
        high = i;
        break;
      }
      i = high;
      if (arcLengths[i] === targetArcLength) {
        var t = i / (il - 1);
        return t;
      }
      var lengthBefore = arcLengths[i];
      var lengthAfter = arcLengths[i + 1];
      var segmentLength = lengthAfter - lengthBefore;
      var segmentFraction = (targetArcLength - lengthBefore) / segmentLength;
      var t = (i + segmentFraction) / (il - 1);
      return t;
    };
    function checkMotionPath(motionPath) {
      if (!Array.isArray(motionPath)) return false;
      for (var i = 0, l = motionPath.length; i < l; i++) {
        var controls = motionPath[i];
        if (!Array.isArray(controls) || 6 !== controls.length) return false;
      }
      return true;
    }
    function sampleMotionPaths(motionPaths, data, duration, fps, target) {
      function createControlPoints(array) {
        if (array instanceof cc.Vec2) return {
          in: array,
          pos: array,
          out: array
        };
        if (Array.isArray(array) && 6 === array.length) return {
          in: v2(array[2], array[3]),
          pos: v2(array[0], array[1]),
          out: v2(array[4], array[5])
        };
        return {
          in: cc.Vec2.ZERO,
          pos: cc.Vec2.ZERO,
          out: cc.Vec2.ZERO
        };
      }
      var values = data.values = data.values.map((function(value) {
        Array.isArray(value) && (value = 2 === value.length ? cc.v2(value[0], value[1]) : cc.v3(value[0], value[1], value[2]));
        return value;
      }));
      if (0 === motionPaths.length || 0 === values.length) return;
      var motionPathValid = false;
      for (var _i = 0; _i < motionPaths.length; _i++) {
        var _motionPath = motionPaths[_i];
        if (_motionPath && !checkMotionPath(_motionPath)) {
          cc.errorID(3904, target ? target.name : "", "position", _i);
          _motionPath = null;
        }
        if (_motionPath && _motionPath.length > 0) {
          motionPathValid = true;
          break;
        }
      }
      if (!motionPathValid) return;
      if (1 === values.length) return;
      var types = data.types;
      var ratios = data.ratios;
      var newValues = data.values = [];
      var newTypes = data.types = [];
      var newRatios = data.ratios = [];
      function addNewDatas(value, type, ratio) {
        newValues.push(value);
        newTypes.push(type);
        newRatios.push(ratio);
      }
      var startRatioOffset = 0;
      var EPSILON = 1e-6;
      var newType = DynamicAnimCurve.Linear;
      for (var i = 0, l = motionPaths.length; i < l - 1; i++) {
        var motionPath = motionPaths[i];
        var ratio = ratios[i];
        var nextRatio = ratios[i + 1];
        var betweenRatio = nextRatio - ratio;
        var value = values[i];
        var nextValue = values[i + 1];
        var type = types[i];
        var results = [];
        var progress = startRatioOffset / betweenRatio;
        var speed = 1 / (betweenRatio * duration * fps);
        var finalProgress;
        if (motionPath && motionPath.length > 0) {
          var points = [];
          points.push(createControlPoints(value));
          for (var j = 0, l2 = motionPath.length; j < l2; j++) {
            var controlPoints = createControlPoints(motionPath[j]);
            points.push(controlPoints);
          }
          points.push(createControlPoints(nextValue));
          var curve = new Curve(points);
          curve.computeBeziers();
          var progresses = curve.progresses;
          while (1 - progress > EPSILON) {
            finalProgress = progress;
            finalProgress = computeRatioByType(finalProgress, type);
            var pos, bezier, normal, length;
            if (finalProgress < 0) {
              bezier = curve.beziers[0];
              length = (0 - finalProgress) * bezier.getLength();
              normal = bezier.start.sub(bezier.endCtrlPoint).normalize();
              pos = bezier.start.add(normal.mul(length));
            } else if (finalProgress > 1) {
              bezier = curve.beziers[curve.beziers.length - 1];
              length = (finalProgress - 1) * bezier.getLength();
              normal = bezier.end.sub(bezier.startCtrlPoint).normalize();
              pos = bezier.end.add(normal.mul(length));
            } else {
              var bezierIndex = binarySearch(progresses, finalProgress);
              bezierIndex < 0 && (bezierIndex = ~bezierIndex);
              finalProgress -= bezierIndex > 0 ? progresses[bezierIndex - 1] : 0;
              finalProgress /= curve.ratios[bezierIndex];
              pos = curve.beziers[bezierIndex].getPointAt(finalProgress);
            }
            results.push(pos);
            progress += speed;
          }
        } else while (1 - progress > EPSILON) {
          finalProgress = progress;
          finalProgress = computeRatioByType(finalProgress, type);
          results.push(value.lerp(nextValue, finalProgress));
          progress += speed;
        }
        newType = "constant" === type ? type : DynamicAnimCurve.Linear;
        for (var j = 0, l2 = results.length; j < l2; j++) {
          var newRatio = ratio + startRatioOffset + speed * j * betweenRatio;
          addNewDatas(results[j], newType, newRatio);
        }
        startRatioOffset = Math.abs(progress - 1) > EPSILON ? (progress - 1) * betweenRatio : 0;
      }
      ratios[ratios.length - 1] !== newRatios[newRatios.length - 1] && addNewDatas(values[values.length - 1], newType, ratios[ratios.length - 1]);
    }
    false;
    module.exports = {
      sampleMotionPaths: sampleMotionPaths,
      Curve: Curve,
      Bezier: Bezier
    };
  }), {
    "../core/utils/binary-search": 196,
    "./animation-curves": 12,
    "./bezier": 15
  } ],
  19: [ (function(require, module, exports) {
    "use strict";
    var js = cc.js;
    var debug = require("../core/CCDebug");
    function Playable() {
      this._isPlaying = false;
      this._isPaused = false;
      this._stepOnce = false;
    }
    var prototype = Playable.prototype;
    js.get(prototype, "isPlaying", (function() {
      return this._isPlaying;
    }), true);
    js.get(prototype, "isPaused", (function() {
      return this._isPaused;
    }), true);
    var virtual = function virtual() {};
    prototype.onPlay = virtual;
    prototype.onPause = virtual;
    prototype.onResume = virtual;
    prototype.onStop = virtual;
    prototype.onError = virtual;
    prototype.play = function() {
      if (this._isPlaying) if (this._isPaused) {
        this._isPaused = false;
        this.onResume();
      } else this.onError(debug.getError(3912)); else {
        this._isPlaying = true;
        this.onPlay();
      }
    };
    prototype.stop = function() {
      if (this._isPlaying) {
        this._isPlaying = false;
        this.onStop();
        this._isPaused = false;
      }
    };
    prototype.pause = function() {
      if (this._isPlaying && !this._isPaused) {
        this._isPaused = true;
        this.onPause();
      }
    };
    prototype.resume = function() {
      if (this._isPlaying && this._isPaused) {
        this._isPaused = false;
        this.onResume();
      }
    };
    prototype.step = function() {
      this.pause();
      this._stepOnce = true;
      this._isPlaying || this.play();
    };
    module.exports = Playable;
  }), {
    "../core/CCDebug": 26
  } ],
  20: [ (function(require, module, exports) {
    "use strict";
    var WrapModeMask = {
      Loop: 2,
      ShouldWrap: 4,
      PingPong: 22,
      Reverse: 36
    };
    var WrapMode = cc.Enum({
      Default: 0,
      Normal: 1,
      Reverse: WrapModeMask.Reverse,
      Loop: WrapModeMask.Loop,
      LoopReverse: WrapModeMask.Loop | WrapModeMask.Reverse,
      PingPong: WrapModeMask.PingPong,
      PingPongReverse: WrapModeMask.PingPong | WrapModeMask.Reverse
    });
    cc.WrapMode = WrapMode;
    function WrappedInfo(info) {
      if (info) {
        this.set(info);
        return;
      }
      this.ratio = 0;
      this.time = 0;
      this.direction = 1;
      this.stopped = true;
      this.iterations = 0;
      this.frameIndex = void 0;
    }
    WrappedInfo.prototype.set = function(info) {
      this.ratio = info.ratio;
      this.time = info.time;
      this.direction = info.direction;
      this.stopped = info.stopped;
      this.iterations = info.iterations;
      this.frameIndex = info.frameIndex;
    };
    module.exports = {
      WrapModeMask: WrapModeMask,
      WrapMode: WrapMode,
      WrappedInfo: WrappedInfo
    };
  }), {} ],
  21: [ (function(require, module, exports) {
    "use strict";
    var codec = {
      name: "Jacob__Codec"
    };
    codec.Base64 = require("./base64");
    codec.GZip = require("./gzip");
    codec.unzip = function() {
      return codec.GZip.gunzip.apply(codec.GZip, arguments);
    };
    codec.unzipBase64 = function() {
      var buffer = codec.Base64.decode.apply(codec.Base64, arguments);
      try {
        return codec.GZip.gunzip.call(codec.GZip, buffer);
      } catch (e) {
        return buffer.slice(7);
      }
    };
    codec.unzipBase64AsArray = function(input, bytes) {
      bytes = bytes || 1;
      var dec = this.unzipBase64(input), ar = [], i, j, len;
      for (i = 0, len = dec.length / bytes; i < len; i++) {
        ar[i] = 0;
        for (j = bytes - 1; j >= 0; --j) ar[i] += dec.charCodeAt(i * bytes + j) << 8 * j;
      }
      return ar;
    };
    codec.unzipAsArray = function(input, bytes) {
      bytes = bytes || 1;
      var dec = this.unzip(input), ar = [], i, j, len;
      for (i = 0, len = dec.length / bytes; i < len; i++) {
        ar[i] = 0;
        for (j = bytes - 1; j >= 0; --j) ar[i] += dec.charCodeAt(i * bytes + j) << 8 * j;
      }
      return ar;
    };
    cc.codec = module.exports = codec;
  }), {
    "./base64": 22,
    "./gzip": 23
  } ],
  22: [ (function(require, module, exports) {
    "use strict";
    var misc = require("../core/utils/misc");
    var strValue = misc.BASE64_VALUES;
    var Base64 = {
      name: "Jacob__Codec__Base64"
    };
    Base64.decode = function Jacob__Codec__Base64__decode(input) {
      var output = [], chr1, chr2, chr3, enc1, enc2, enc3, enc4, i = 0;
      input = input.replace(/[^A-Za-z0-9\+\/\=]/g, "");
      while (i < input.length) {
        enc1 = strValue[input.charCodeAt(i++)];
        enc2 = strValue[input.charCodeAt(i++)];
        enc3 = strValue[input.charCodeAt(i++)];
        enc4 = strValue[input.charCodeAt(i++)];
        chr1 = enc1 << 2 | enc2 >> 4;
        chr2 = (15 & enc2) << 4 | enc3 >> 2;
        chr3 = (3 & enc3) << 6 | enc4;
        output.push(String.fromCharCode(chr1));
        64 !== enc3 && output.push(String.fromCharCode(chr2));
        64 !== enc4 && output.push(String.fromCharCode(chr3));
      }
      output = output.join("");
      return output;
    };
    Base64.decodeAsArray = function Jacob__Codec__Base64___decodeAsArray(input, bytes) {
      var dec = this.decode(input), ar = [], i, j, len;
      for (i = 0, len = dec.length / bytes; i < len; i++) {
        ar[i] = 0;
        for (j = bytes - 1; j >= 0; --j) ar[i] += dec.charCodeAt(i * bytes + j) << 8 * j;
      }
      return ar;
    };
    module.exports = Base64;
  }), {
    "../core/utils/misc": 204
  } ],
  23: [ (function(require, module, exports) {
    "use strict";
    var GZip = function Jacob__GZip(data) {
      this.data = data;
      this.debug = false;
      this.gpflags = void 0;
      this.files = 0;
      this.unzipped = [];
      this.buf32k = new Array(32768);
      this.bIdx = 0;
      this.modeZIP = false;
      this.bytepos = 0;
      this.bb = 1;
      this.bits = 0;
      this.nameBuf = [];
      this.fileout = void 0;
      this.literalTree = new Array(GZip.LITERALS);
      this.distanceTree = new Array(32);
      this.treepos = 0;
      this.Places = null;
      this.len = 0;
      this.fpos = new Array(17);
      this.fpos[0] = 0;
      this.flens = void 0;
      this.fmax = void 0;
    };
    GZip.gunzip = function(string) {
      string.constructor === Array || string.constructor === String;
      var gzip = new GZip(string);
      return gzip.gunzip()[0][0];
    };
    GZip.HufNode = function() {
      this.b0 = 0;
      this.b1 = 0;
      this.jump = null;
      this.jumppos = -1;
    };
    GZip.LITERALS = 288;
    GZip.NAMEMAX = 256;
    GZip.bitReverse = [ 0, 128, 64, 192, 32, 160, 96, 224, 16, 144, 80, 208, 48, 176, 112, 240, 8, 136, 72, 200, 40, 168, 104, 232, 24, 152, 88, 216, 56, 184, 120, 248, 4, 132, 68, 196, 36, 164, 100, 228, 20, 148, 84, 212, 52, 180, 116, 244, 12, 140, 76, 204, 44, 172, 108, 236, 28, 156, 92, 220, 60, 188, 124, 252, 2, 130, 66, 194, 34, 162, 98, 226, 18, 146, 82, 210, 50, 178, 114, 242, 10, 138, 74, 202, 42, 170, 106, 234, 26, 154, 90, 218, 58, 186, 122, 250, 6, 134, 70, 198, 38, 166, 102, 230, 22, 150, 86, 214, 54, 182, 118, 246, 14, 142, 78, 206, 46, 174, 110, 238, 30, 158, 94, 222, 62, 190, 126, 254, 1, 129, 65, 193, 33, 161, 97, 225, 17, 145, 81, 209, 49, 177, 113, 241, 9, 137, 73, 201, 41, 169, 105, 233, 25, 153, 89, 217, 57, 185, 121, 249, 5, 133, 69, 197, 37, 165, 101, 229, 21, 149, 85, 213, 53, 181, 117, 245, 13, 141, 77, 205, 45, 173, 109, 237, 29, 157, 93, 221, 61, 189, 125, 253, 3, 131, 67, 195, 35, 163, 99, 227, 19, 147, 83, 211, 51, 179, 115, 243, 11, 139, 75, 203, 43, 171, 107, 235, 27, 155, 91, 219, 59, 187, 123, 251, 7, 135, 71, 199, 39, 167, 103, 231, 23, 151, 87, 215, 55, 183, 119, 247, 15, 143, 79, 207, 47, 175, 111, 239, 31, 159, 95, 223, 63, 191, 127, 255 ];
    GZip.cplens = [ 3, 4, 5, 6, 7, 8, 9, 10, 11, 13, 15, 17, 19, 23, 27, 31, 35, 43, 51, 59, 67, 83, 99, 115, 131, 163, 195, 227, 258, 0, 0 ];
    GZip.cplext = [ 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 5, 0, 99, 99 ];
    GZip.cpdist = [ 1, 2, 3, 4, 5, 7, 9, 13, 17, 25, 33, 49, 65, 97, 129, 193, 257, 385, 513, 769, 1025, 1537, 2049, 3073, 4097, 6145, 8193, 12289, 16385, 24577 ];
    GZip.cpdext = [ 0, 0, 0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13 ];
    GZip.border = [ 16, 17, 18, 0, 8, 7, 9, 6, 10, 5, 11, 4, 12, 3, 13, 2, 14, 1, 15 ];
    GZip.prototype.gunzip = function() {
      this.outputArr = [];
      this.nextFile();
      return this.unzipped;
    };
    GZip.prototype.readByte = function() {
      this.bits += 8;
      return this.bytepos < this.data.length ? this.data.charCodeAt(this.bytepos++) : -1;
    };
    GZip.prototype.byteAlign = function() {
      this.bb = 1;
    };
    GZip.prototype.readBit = function() {
      var carry;
      this.bits++;
      carry = 1 & this.bb;
      this.bb >>= 1;
      if (0 === this.bb) {
        this.bb = this.readByte();
        carry = 1 & this.bb;
        this.bb = this.bb >> 1 | 128;
      }
      return carry;
    };
    GZip.prototype.readBits = function(a) {
      var res = 0, i = a;
      while (i--) res = res << 1 | this.readBit();
      a && (res = GZip.bitReverse[res] >> 8 - a);
      return res;
    };
    GZip.prototype.flushBuffer = function() {
      this.bIdx = 0;
    };
    GZip.prototype.addBuffer = function(a) {
      this.buf32k[this.bIdx++] = a;
      this.outputArr.push(String.fromCharCode(a));
      32768 === this.bIdx && (this.bIdx = 0);
    };
    GZip.prototype.IsPat = function() {
      while (1) {
        if (this.fpos[this.len] >= this.fmax) return -1;
        if (this.flens[this.fpos[this.len]] === this.len) return this.fpos[this.len]++;
        this.fpos[this.len]++;
      }
    };
    GZip.prototype.Rec = function() {
      var curplace = this.Places[this.treepos];
      var tmp;
      if (17 === this.len) return -1;
      this.treepos++;
      this.len++;
      tmp = this.IsPat();
      if (tmp >= 0) curplace.b0 = tmp; else {
        curplace.b0 = 32768;
        if (this.Rec()) return -1;
      }
      tmp = this.IsPat();
      if (tmp >= 0) {
        curplace.b1 = tmp;
        curplace.jump = null;
      } else {
        curplace.b1 = 32768;
        curplace.jump = this.Places[this.treepos];
        curplace.jumppos = this.treepos;
        if (this.Rec()) return -1;
      }
      this.len--;
      return 0;
    };
    GZip.prototype.CreateTree = function(currentTree, numval, lengths, show) {
      var i;
      this.Places = currentTree;
      this.treepos = 0;
      this.flens = lengths;
      this.fmax = numval;
      for (i = 0; i < 17; i++) this.fpos[i] = 0;
      this.len = 0;
      if (this.Rec()) return -1;
      return 0;
    };
    GZip.prototype.DecodeValue = function(currentTree) {
      var len, i, xtreepos = 0, X = currentTree[xtreepos], b;
      while (1) {
        b = this.readBit();
        if (b) {
          if (!(32768 & X.b1)) return X.b1;
          X = X.jump;
          len = currentTree.length;
          for (i = 0; i < len; i++) if (currentTree[i] === X) {
            xtreepos = i;
            break;
          }
        } else {
          if (!(32768 & X.b0)) return X.b0;
          xtreepos++;
          X = currentTree[xtreepos];
        }
      }
      return -1;
    };
    GZip.prototype.DeflateLoop = function() {
      var last, c, type, i, len;
      do {
        last = this.readBit();
        type = this.readBits(2);
        if (0 === type) {
          var blockLen, cSum;
          this.byteAlign();
          blockLen = this.readByte();
          blockLen |= this.readByte() << 8;
          cSum = this.readByte();
          cSum |= this.readByte() << 8;
          65535 & (blockLen ^ ~cSum) && document.write("BlockLen checksum mismatch\n");
          while (blockLen--) {
            c = this.readByte();
            this.addBuffer(c);
          }
        } else if (1 === type) {
          var j;
          while (1) {
            j = GZip.bitReverse[this.readBits(7)] >> 1;
            if (j > 23) {
              j = j << 1 | this.readBit();
              if (j > 199) {
                j -= 128;
                j = j << 1 | this.readBit();
              } else {
                j -= 48;
                j > 143 && (j += 136);
              }
            } else j += 256;
            if (j < 256) this.addBuffer(j); else {
              if (256 === j) break;
              var len, dist;
              j -= 257;
              len = this.readBits(GZip.cplext[j]) + GZip.cplens[j];
              j = GZip.bitReverse[this.readBits(5)] >> 3;
              if (GZip.cpdext[j] > 8) {
                dist = this.readBits(8);
                dist |= this.readBits(GZip.cpdext[j] - 8) << 8;
              } else dist = this.readBits(GZip.cpdext[j]);
              dist += GZip.cpdist[j];
              for (j = 0; j < len; j++) {
                var c = this.buf32k[this.bIdx - dist & 32767];
                this.addBuffer(c);
              }
            }
          }
        } else if (2 === type) {
          var j, n, literalCodes, distCodes, lenCodes;
          var ll = new Array(320);
          literalCodes = 257 + this.readBits(5);
          distCodes = 1 + this.readBits(5);
          lenCodes = 4 + this.readBits(4);
          for (j = 0; j < 19; j++) ll[j] = 0;
          for (j = 0; j < lenCodes; j++) ll[GZip.border[j]] = this.readBits(3);
          len = this.distanceTree.length;
          for (i = 0; i < len; i++) this.distanceTree[i] = new GZip.HufNode();
          if (this.CreateTree(this.distanceTree, 19, ll, 0)) {
            this.flushBuffer();
            return 1;
          }
          n = literalCodes + distCodes;
          i = 0;
          var z = -1;
          while (i < n) {
            z++;
            j = this.DecodeValue(this.distanceTree);
            if (j < 16) ll[i++] = j; else if (16 === j) {
              var l;
              j = 3 + this.readBits(2);
              if (i + j > n) {
                this.flushBuffer();
                return 1;
              }
              l = i ? ll[i - 1] : 0;
              while (j--) ll[i++] = l;
            } else {
              j = 17 === j ? 3 + this.readBits(3) : 11 + this.readBits(7);
              if (i + j > n) {
                this.flushBuffer();
                return 1;
              }
              while (j--) ll[i++] = 0;
            }
          }
          len = this.literalTree.length;
          for (i = 0; i < len; i++) this.literalTree[i] = new GZip.HufNode();
          if (this.CreateTree(this.literalTree, literalCodes, ll, 0)) {
            this.flushBuffer();
            return 1;
          }
          len = this.literalTree.length;
          for (i = 0; i < len; i++) this.distanceTree[i] = new GZip.HufNode();
          var ll2 = new Array();
          for (i = literalCodes; i < ll.length; i++) ll2[i - literalCodes] = ll[i];
          if (this.CreateTree(this.distanceTree, distCodes, ll2, 0)) {
            this.flushBuffer();
            return 1;
          }
          while (1) {
            j = this.DecodeValue(this.literalTree);
            if (j >= 256) {
              var len, dist;
              j -= 256;
              if (0 === j) break;
              j--;
              len = this.readBits(GZip.cplext[j]) + GZip.cplens[j];
              j = this.DecodeValue(this.distanceTree);
              if (GZip.cpdext[j] > 8) {
                dist = this.readBits(8);
                dist |= this.readBits(GZip.cpdext[j] - 8) << 8;
              } else dist = this.readBits(GZip.cpdext[j]);
              dist += GZip.cpdist[j];
              while (len--) {
                var c = this.buf32k[this.bIdx - dist & 32767];
                this.addBuffer(c);
              }
            } else this.addBuffer(j);
          }
        }
      } while (!last);
      this.flushBuffer();
      this.byteAlign();
      return 0;
    };
    GZip.prototype.unzipFile = function(name) {
      var i;
      this.gunzip();
      for (i = 0; i < this.unzipped.length; i++) if (this.unzipped[i][1] === name) return this.unzipped[i][0];
    };
    GZip.prototype.nextFile = function() {
      this.outputArr = [];
      this.modeZIP = false;
      var tmp = [];
      tmp[0] = this.readByte();
      tmp[1] = this.readByte();
      if (120 === tmp[0] && 218 === tmp[1]) {
        this.DeflateLoop();
        this.unzipped[this.files] = [ this.outputArr.join(""), "geonext.gxt" ];
        this.files++;
      }
      if (31 === tmp[0] && 139 === tmp[1]) {
        this.skipdir();
        this.unzipped[this.files] = [ this.outputArr.join(""), "file" ];
        this.files++;
      }
      if (80 === tmp[0] && 75 === tmp[1]) {
        this.modeZIP = true;
        tmp[2] = this.readByte();
        tmp[3] = this.readByte();
        if (3 === tmp[2] && 4 === tmp[3]) {
          tmp[0] = this.readByte();
          tmp[1] = this.readByte();
          this.gpflags = this.readByte();
          this.gpflags |= this.readByte() << 8;
          var method = this.readByte();
          method |= this.readByte() << 8;
          this.readByte();
          this.readByte();
          this.readByte();
          this.readByte();
          var compSize = this.readByte();
          compSize |= this.readByte() << 8;
          compSize |= this.readByte() << 16;
          compSize |= this.readByte() << 24;
          var size = this.readByte();
          size |= this.readByte() << 8;
          size |= this.readByte() << 16;
          size |= this.readByte() << 24;
          var filelen = this.readByte();
          filelen |= this.readByte() << 8;
          var extralen = this.readByte();
          extralen |= this.readByte() << 8;
          i = 0;
          this.nameBuf = [];
          while (filelen--) {
            var c = this.readByte();
            "/" === c | ":" === c ? i = 0 : i < GZip.NAMEMAX - 1 && (this.nameBuf[i++] = String.fromCharCode(c));
          }
          this.fileout || (this.fileout = this.nameBuf);
          var i = 0;
          while (i < extralen) {
            c = this.readByte();
            i++;
          }
          if (8 === method) {
            this.DeflateLoop();
            this.unzipped[this.files] = [ this.outputArr.join(""), this.nameBuf.join("") ];
            this.files++;
          }
          this.skipdir();
        }
      }
    };
    GZip.prototype.skipdir = function() {
      var tmp = [];
      var compSize, size, os, i, c;
      if (8 & this.gpflags) {
        tmp[0] = this.readByte();
        tmp[1] = this.readByte();
        tmp[2] = this.readByte();
        tmp[3] = this.readByte();
        compSize = this.readByte();
        compSize |= this.readByte() << 8;
        compSize |= this.readByte() << 16;
        compSize |= this.readByte() << 24;
        size = this.readByte();
        size |= this.readByte() << 8;
        size |= this.readByte() << 16;
        size |= this.readByte() << 24;
      }
      this.modeZIP && this.nextFile();
      tmp[0] = this.readByte();
      if (8 !== tmp[0]) return 0;
      this.gpflags = this.readByte();
      this.readByte();
      this.readByte();
      this.readByte();
      this.readByte();
      this.readByte();
      os = this.readByte();
      if (4 & this.gpflags) {
        tmp[0] = this.readByte();
        tmp[2] = this.readByte();
        this.len = tmp[0] + 256 * tmp[1];
        for (i = 0; i < this.len; i++) this.readByte();
      }
      if (8 & this.gpflags) {
        i = 0;
        this.nameBuf = [];
        while (c = this.readByte()) {
          "7" !== c && ":" !== c || (i = 0);
          i < GZip.NAMEMAX - 1 && (this.nameBuf[i++] = c);
        }
      }
      if (16 & this.gpflags) while (c = this.readByte()) ;
      if (2 & this.gpflags) {
        this.readByte();
        this.readByte();
      }
      this.DeflateLoop();
      size = this.readByte();
      size |= this.readByte() << 8;
      size |= this.readByte() << 16;
      size |= this.readByte() << 24;
      this.modeZIP && this.nextFile();
    };
    module.exports = GZip;
  }), {} ],
  24: [ (function(require, module, exports) {
    "use strict";
    (function() {
      function i(a) {
        throw a;
      }
      var r = void 0, v = !0, aa = this;
      function y(a, c) {
        var b = a.split("."), e = aa;
        !(b[0] in e) && e.execScript && e.execScript("var " + b[0]);
        for (var f; b.length && (f = b.shift()); ) b.length || c === r ? e = e[f] ? e[f] : e[f] = {} : e[f] = c;
      }
      var H = "undefined" !== typeof Uint8Array && "undefined" !== typeof Uint16Array && "undefined" !== typeof Uint32Array;
      function ba(a) {
        if ("string" === typeof a) {
          var c = a.split(""), b, e;
          b = 0;
          for (e = c.length; b < e; b++) c[b] = (255 & c[b].charCodeAt(0)) >>> 0;
          a = c;
        }
        for (var f = 1, d = 0, g = a.length, h, m = 0; 0 < g; ) {
          h = 1024 < g ? 1024 : g;
          g -= h;
          do {
            f += a[m++], d += f;
          } while (--h);
          f %= 65521;
          d %= 65521;
        }
        return (d << 16 | f) >>> 0;
      }
      function J(a, c) {
        this.index = "number" === typeof c ? c : 0;
        this.i = 0;
        this.buffer = a instanceof (H ? Uint8Array : Array) ? a : new (H ? Uint8Array : Array)(32768);
        2 * this.buffer.length <= this.index && i(Error("invalid index"));
        this.buffer.length <= this.index && this.f();
      }
      J.prototype.f = function() {
        var a = this.buffer, c, b = a.length, e = new (H ? Uint8Array : Array)(b << 1);
        if (H) e.set(a); else for (c = 0; c < b; ++c) e[c] = a[c];
        return this.buffer = e;
      };
      J.prototype.d = function(a, c, b) {
        var e = this.buffer, f = this.index, d = this.i, g = e[f], h;
        b && 1 < c && (a = 8 < c ? (N[255 & a] << 24 | N[a >>> 8 & 255] << 16 | N[a >>> 16 & 255] << 8 | N[a >>> 24 & 255]) >> 32 - c : N[a] >> 8 - c);
        if (8 > c + d) g = g << c | a, d += c; else for (h = 0; h < c; ++h) g = g << 1 | a >> c - h - 1 & 1, 
        8 === ++d && (d = 0, e[f++] = N[g], g = 0, f === e.length && (e = this.f()));
        e[f] = g;
        this.buffer = e;
        this.i = d;
        this.index = f;
      };
      J.prototype.finish = function() {
        var a = this.buffer, c = this.index, b;
        0 < this.i && (a[c] <<= 8 - this.i, a[c] = N[a[c]], c++);
        H ? b = a.subarray(0, c) : (a.length = c, b = a);
        return b;
      };
      var ca = new (H ? Uint8Array : Array)(256), ha;
      for (ha = 0; 256 > ha; ++ha) {
        for (var R = ha, ia = R, ja = 7, R = R >>> 1; R; R >>>= 1) ia <<= 1, ia |= 1 & R, 
        --ja;
        ca[ha] = (ia << ja & 255) >>> 0;
      }
      var N = ca;
      var ka = [ 0, 1996959894, 3993919788, 2567524794, 124634137, 1886057615, 3915621685, 2657392035, 249268274, 2044508324, 3772115230, 2547177864, 162941995, 2125561021, 3887607047, 2428444049, 498536548, 1789927666, 4089016648, 2227061214, 450548861, 1843258603, 4107580753, 2211677639, 325883990, 1684777152, 4251122042, 2321926636, 335633487, 1661365465, 4195302755, 2366115317, 997073096, 1281953886, 3579855332, 2724688242, 1006888145, 1258607687, 3524101629, 2768942443, 901097722, 1119000684, 3686517206, 2898065728, 853044451, 1172266101, 3705015759, 2882616665, 651767980, 1373503546, 3369554304, 3218104598, 565507253, 1454621731, 3485111705, 3099436303, 671266974, 1594198024, 3322730930, 2970347812, 795835527, 1483230225, 3244367275, 3060149565, 1994146192, 31158534, 2563907772, 4023717930, 1907459465, 112637215, 2680153253, 3904427059, 2013776290, 251722036, 2517215374, 3775830040, 2137656763, 141376813, 2439277719, 3865271297, 1802195444, 476864866, 2238001368, 4066508878, 1812370925, 453092731, 2181625025, 4111451223, 1706088902, 314042704, 2344532202, 4240017532, 1658658271, 366619977, 2362670323, 4224994405, 1303535960, 984961486, 2747007092, 3569037538, 1256170817, 1037604311, 2765210733, 3554079995, 1131014506, 879679996, 2909243462, 3663771856, 1141124467, 855842277, 2852801631, 3708648649, 1342533948, 654459306, 3188396048, 3373015174, 1466479909, 544179635, 3110523913, 3462522015, 1591671054, 702138776, 2966460450, 3352799412, 1504918807, 783551873, 3082640443, 3233442989, 3988292384, 2596254646, 62317068, 1957810842, 3939845945, 2647816111, 81470997, 1943803523, 3814918930, 2489596804, 225274430, 2053790376, 3826175755, 2466906013, 167816743, 2097651377, 4027552580, 2265490386, 503444072, 1762050814, 4150417245, 2154129355, 426522225, 1852507879, 4275313526, 2312317920, 282753626, 1742555852, 4189708143, 2394877945, 397917763, 1622183637, 3604390888, 2714866558, 953729732, 1340076626, 3518719985, 2797360999, 1068828381, 1219638859, 3624741850, 2936675148, 906185462, 1090812512, 3747672003, 2825379669, 829329135, 1181335161, 3412177804, 3160834842, 628085408, 1382605366, 3423369109, 3138078467, 570562233, 1426400815, 3317316542, 2998733608, 733239954, 1555261956, 3268935591, 3050360625, 752459403, 1541320221, 2607071920, 3965973030, 1969922972, 40735498, 2617837225, 3943577151, 1913087877, 83908371, 2512341634, 3803740692, 2075208622, 213261112, 2463272603, 3855990285, 2094854071, 198958881, 2262029012, 4057260610, 1759359992, 534414190, 2176718541, 4139329115, 1873836001, 414664567, 2282248934, 4279200368, 1711684554, 285281116, 2405801727, 4167216745, 1634467795, 376229701, 2685067896, 3608007406, 1308918612, 956543938, 2808555105, 3495958263, 1231636301, 1047427035, 2932959818, 3654703836, 1088359270, 936918e3, 2847714899, 3736837829, 1202900863, 817233897, 3183342108, 3401237130, 1404277552, 615818150, 3134207493, 3453421203, 1423857449, 601450431, 3009837614, 3294710456, 1567103746, 711928724, 3020668471, 3272380065, 1510334235, 755167117 ];
      H && new Uint32Array(ka);
      function la(a) {
        this.buffer = new (H ? Uint16Array : Array)(2 * a);
        this.length = 0;
      }
      la.prototype.getParent = function(a) {
        return 2 * ((a - 2) / 4 | 0);
      };
      la.prototype.push = function(a, c) {
        var b, e, f = this.buffer, d;
        b = this.length;
        f[this.length++] = c;
        for (f[this.length++] = a; 0 < b; ) {
          if (e = this.getParent(b), !(f[b] > f[e])) break;
          d = f[b], f[b] = f[e], f[e] = d, d = f[b + 1], f[b + 1] = f[e + 1], f[e + 1] = d, 
          b = e;
        }
        return this.length;
      };
      la.prototype.pop = function() {
        var a, c, b = this.buffer, e, f, d;
        c = b[0];
        a = b[1];
        this.length -= 2;
        b[0] = b[this.length];
        b[1] = b[this.length + 1];
        for (d = 0; ;) {
          f = 2 * d + 2;
          if (f >= this.length) break;
          f + 2 < this.length && b[f + 2] > b[f] && (f += 2);
          if (!(b[f] > b[d])) break;
          e = b[d], b[d] = b[f], b[f] = e, e = b[d + 1], b[d + 1] = b[f + 1], b[f + 1] = e;
          d = f;
        }
        return {
          index: a,
          value: c,
          length: this.length
        };
      };
      function S(a) {
        var c = a.length, b = 0, e = Number.POSITIVE_INFINITY, f, d, g, h, m, j, s, n, l;
        for (n = 0; n < c; ++n) a[n] > b && (b = a[n]), a[n] < e && (e = a[n]);
        f = 1 << b;
        d = new (H ? Uint32Array : Array)(f);
        g = 1;
        h = 0;
        for (m = 2; g <= b; ) {
          for (n = 0; n < c; ++n) if (a[n] === g) {
            j = 0;
            s = h;
            for (l = 0; l < g; ++l) j = j << 1 | 1 & s, s >>= 1;
            for (l = j; l < f; l += m) d[l] = g << 16 | n;
            ++h;
          }
          ++g;
          h <<= 1;
          m <<= 1;
        }
        return [ d, b, e ];
      }
      function ma(a, c) {
        this.h = pa;
        this.w = 0;
        this.input = a;
        this.b = 0;
        c && (c.lazy && (this.w = c.lazy), "number" === typeof c.compressionType && (this.h = c.compressionType), 
        c.outputBuffer && (this.a = H && c.outputBuffer instanceof Array ? new Uint8Array(c.outputBuffer) : c.outputBuffer), 
        "number" === typeof c.outputIndex && (this.b = c.outputIndex));
        this.a || (this.a = new (H ? Uint8Array : Array)(32768));
      }
      var pa = 2, qa = {
        NONE: 0,
        r: 1,
        j: pa,
        N: 3
      }, ra = [], T;
      for (T = 0; 288 > T; T++) switch (v) {
       case 143 >= T:
        ra.push([ T + 48, 8 ]);
        break;

       case 255 >= T:
        ra.push([ T - 144 + 400, 9 ]);
        break;

       case 279 >= T:
        ra.push([ T - 256 + 0, 7 ]);
        break;

       case 287 >= T:
        ra.push([ T - 280 + 192, 8 ]);
        break;

       default:
        i("invalid literal: " + T);
      }
      ma.prototype.n = function() {
        var a, c, b, e, f = this.input;
        switch (this.h) {
         case 0:
          b = 0;
          for (e = f.length; b < e; ) {
            c = H ? f.subarray(b, b + 65535) : f.slice(b, b + 65535);
            b += c.length;
            var d = c, g = b === e, h = r, m = r, j = r, s = r, n = r, l = this.a, q = this.b;
            if (H) {
              for (l = new Uint8Array(this.a.buffer); l.length <= q + d.length + 5; ) l = new Uint8Array(l.length << 1);
              l.set(this.a);
            }
            h = g ? 1 : 0;
            l[q++] = 0 | h;
            m = d.length;
            j = 65536 + ~m & 65535;
            l[q++] = 255 & m;
            l[q++] = m >>> 8 & 255;
            l[q++] = 255 & j;
            l[q++] = j >>> 8 & 255;
            if (H) l.set(d, q), q += d.length, l = l.subarray(0, q); else {
              s = 0;
              for (n = d.length; s < n; ++s) l[q++] = d[s];
              l.length = q;
            }
            this.b = q;
            this.a = l;
          }
          break;

         case 1:
          var E = new J(new Uint8Array(this.a.buffer), this.b);
          E.d(1, 1, v);
          E.d(1, 2, v);
          var t = sa(this, f), z, K, A;
          z = 0;
          for (K = t.length; z < K; z++) if (A = t[z], J.prototype.d.apply(E, ra[A]), 256 < A) E.d(t[++z], t[++z], v), 
          E.d(t[++z], 5), E.d(t[++z], t[++z], v); else if (256 === A) break;
          this.a = E.finish();
          this.b = this.a.length;
          break;

         case pa:
          var x = new J(new Uint8Array(this.a), this.b), B, k, p, D, C, da = [ 16, 17, 18, 0, 8, 7, 9, 6, 10, 5, 11, 4, 12, 3, 13, 2, 14, 1, 15 ], W, Ma, ea, Na, na, va = Array(19), Oa, $, oa, F, Pa;
          B = pa;
          x.d(1, 1, v);
          x.d(B, 2, v);
          k = sa(this, f);
          W = ta(this.L, 15);
          Ma = ua(W);
          ea = ta(this.K, 7);
          Na = ua(ea);
          for (p = 286; 257 < p && 0 === W[p - 1]; p--) ;
          for (D = 30; 1 < D && 0 === ea[D - 1]; D--) ;
          var Qa = p, Ra = D, M = new (H ? Uint32Array : Array)(Qa + Ra), u, O, w, fa, L = new (H ? Uint32Array : Array)(316), I, G, P = new (H ? Uint8Array : Array)(19);
          for (u = O = 0; u < Qa; u++) M[O++] = W[u];
          for (u = 0; u < Ra; u++) M[O++] = ea[u];
          if (!H) {
            u = 0;
            for (fa = P.length; u < fa; ++u) P[u] = 0;
          }
          u = I = 0;
          for (fa = M.length; u < fa; u += O) {
            for (O = 1; u + O < fa && M[u + O] === M[u]; ++O) ;
            w = O;
            if (0 === M[u]) if (3 > w) for (;0 < w--; ) L[I++] = 0, P[0]++; else for (;0 < w; ) G = 138 > w ? w : 138, 
            G > w - 3 && G < w && (G = w - 3), 10 >= G ? (L[I++] = 17, L[I++] = G - 3, P[17]++) : (L[I++] = 18, 
            L[I++] = G - 11, P[18]++), w -= G; else if (L[I++] = M[u], P[M[u]]++, w--, 3 > w) for (;0 < w--; ) L[I++] = M[u], 
            P[M[u]]++; else for (;0 < w; ) G = 6 > w ? w : 6, G > w - 3 && G < w && (G = w - 3), 
            L[I++] = 16, L[I++] = G - 3, P[16]++, w -= G;
          }
          a = H ? L.subarray(0, I) : L.slice(0, I);
          na = ta(P, 7);
          for (F = 0; 19 > F; F++) va[F] = na[da[F]];
          for (C = 19; 4 < C && 0 === va[C - 1]; C--) ;
          Oa = ua(na);
          x.d(p - 257, 5, v);
          x.d(D - 1, 5, v);
          x.d(C - 4, 4, v);
          for (F = 0; F < C; F++) x.d(va[F], 3, v);
          F = 0;
          for (Pa = a.length; F < Pa; F++) if ($ = a[F], x.d(Oa[$], na[$], v), 16 <= $) {
            F++;
            switch ($) {
             case 16:
              oa = 2;
              break;

             case 17:
              oa = 3;
              break;

             case 18:
              oa = 7;
              break;

             default:
              i("invalid code: " + $);
            }
            x.d(a[F], oa, v);
          }
          var Sa = [ Ma, W ], Ta = [ Na, ea ], Q, Ua, ga, ya, Va, Wa, Xa, Ya;
          Va = Sa[0];
          Wa = Sa[1];
          Xa = Ta[0];
          Ya = Ta[1];
          Q = 0;
          for (Ua = k.length; Q < Ua; ++Q) if (ga = k[Q], x.d(Va[ga], Wa[ga], v), 256 < ga) x.d(k[++Q], k[++Q], v), 
          ya = k[++Q], x.d(Xa[ya], Ya[ya], v), x.d(k[++Q], k[++Q], v); else if (256 === ga) break;
          this.a = x.finish();
          this.b = this.a.length;
          break;

         default:
          i("invalid compression type");
        }
        return this.a;
      };
      function wa(a, c) {
        this.length = a;
        this.G = c;
      }
      function xa() {
        var a = za;
        switch (v) {
         case 3 === a:
          return [ 257, a - 3, 0 ];

         case 4 === a:
          return [ 258, a - 4, 0 ];

         case 5 === a:
          return [ 259, a - 5, 0 ];

         case 6 === a:
          return [ 260, a - 6, 0 ];

         case 7 === a:
          return [ 261, a - 7, 0 ];

         case 8 === a:
          return [ 262, a - 8, 0 ];

         case 9 === a:
          return [ 263, a - 9, 0 ];

         case 10 === a:
          return [ 264, a - 10, 0 ];

         case 12 >= a:
          return [ 265, a - 11, 1 ];

         case 14 >= a:
          return [ 266, a - 13, 1 ];

         case 16 >= a:
          return [ 267, a - 15, 1 ];

         case 18 >= a:
          return [ 268, a - 17, 1 ];

         case 22 >= a:
          return [ 269, a - 19, 2 ];

         case 26 >= a:
          return [ 270, a - 23, 2 ];

         case 30 >= a:
          return [ 271, a - 27, 2 ];

         case 34 >= a:
          return [ 272, a - 31, 2 ];

         case 42 >= a:
          return [ 273, a - 35, 3 ];

         case 50 >= a:
          return [ 274, a - 43, 3 ];

         case 58 >= a:
          return [ 275, a - 51, 3 ];

         case 66 >= a:
          return [ 276, a - 59, 3 ];

         case 82 >= a:
          return [ 277, a - 67, 4 ];

         case 98 >= a:
          return [ 278, a - 83, 4 ];

         case 114 >= a:
          return [ 279, a - 99, 4 ];

         case 130 >= a:
          return [ 280, a - 115, 4 ];

         case 162 >= a:
          return [ 281, a - 131, 5 ];

         case 194 >= a:
          return [ 282, a - 163, 5 ];

         case 226 >= a:
          return [ 283, a - 195, 5 ];

         case 257 >= a:
          return [ 284, a - 227, 5 ];

         case 258 === a:
          return [ 285, a - 258, 0 ];

         default:
          i("invalid length: " + a);
        }
      }
      var Aa = [], za, Ba;
      for (za = 3; 258 >= za; za++) Ba = xa(), Aa[za] = Ba[2] << 24 | Ba[1] << 16 | Ba[0];
      var Ca = H ? new Uint32Array(Aa) : Aa;
      function sa(a, c) {
        function b(a, c) {
          var b = a.G, d = [], e = 0, f;
          f = Ca[a.length];
          d[e++] = 65535 & f;
          d[e++] = f >> 16 & 255;
          d[e++] = f >> 24;
          var g;
          switch (v) {
           case 1 === b:
            g = [ 0, b - 1, 0 ];
            break;

           case 2 === b:
            g = [ 1, b - 2, 0 ];
            break;

           case 3 === b:
            g = [ 2, b - 3, 0 ];
            break;

           case 4 === b:
            g = [ 3, b - 4, 0 ];
            break;

           case 6 >= b:
            g = [ 4, b - 5, 1 ];
            break;

           case 8 >= b:
            g = [ 5, b - 7, 1 ];
            break;

           case 12 >= b:
            g = [ 6, b - 9, 2 ];
            break;

           case 16 >= b:
            g = [ 7, b - 13, 2 ];
            break;

           case 24 >= b:
            g = [ 8, b - 17, 3 ];
            break;

           case 32 >= b:
            g = [ 9, b - 25, 3 ];
            break;

           case 48 >= b:
            g = [ 10, b - 33, 4 ];
            break;

           case 64 >= b:
            g = [ 11, b - 49, 4 ];
            break;

           case 96 >= b:
            g = [ 12, b - 65, 5 ];
            break;

           case 128 >= b:
            g = [ 13, b - 97, 5 ];
            break;

           case 192 >= b:
            g = [ 14, b - 129, 6 ];
            break;

           case 256 >= b:
            g = [ 15, b - 193, 6 ];
            break;

           case 384 >= b:
            g = [ 16, b - 257, 7 ];
            break;

           case 512 >= b:
            g = [ 17, b - 385, 7 ];
            break;

           case 768 >= b:
            g = [ 18, b - 513, 8 ];
            break;

           case 1024 >= b:
            g = [ 19, b - 769, 8 ];
            break;

           case 1536 >= b:
            g = [ 20, b - 1025, 9 ];
            break;

           case 2048 >= b:
            g = [ 21, b - 1537, 9 ];
            break;

           case 3072 >= b:
            g = [ 22, b - 2049, 10 ];
            break;

           case 4096 >= b:
            g = [ 23, b - 3073, 10 ];
            break;

           case 6144 >= b:
            g = [ 24, b - 4097, 11 ];
            break;

           case 8192 >= b:
            g = [ 25, b - 6145, 11 ];
            break;

           case 12288 >= b:
            g = [ 26, b - 8193, 12 ];
            break;

           case 16384 >= b:
            g = [ 27, b - 12289, 12 ];
            break;

           case 24576 >= b:
            g = [ 28, b - 16385, 13 ];
            break;

           case 32768 >= b:
            g = [ 29, b - 24577, 13 ];
            break;

           default:
            i("invalid distance");
          }
          f = g;
          d[e++] = f[0];
          d[e++] = f[1];
          d[e++] = f[2];
          var h, j;
          h = 0;
          for (j = d.length; h < j; ++h) l[q++] = d[h];
          t[d[0]]++;
          z[d[3]]++;
          E = a.length + c - 1;
          n = null;
        }
        var e, f, d, g, h, m = {}, j, s, n, l = H ? new Uint16Array(2 * c.length) : [], q = 0, E = 0, t = new (H ? Uint32Array : Array)(286), z = new (H ? Uint32Array : Array)(30), K = a.w, A;
        if (!H) {
          for (d = 0; 285 >= d; ) t[d++] = 0;
          for (d = 0; 29 >= d; ) z[d++] = 0;
        }
        t[256] = 1;
        e = 0;
        for (f = c.length; e < f; ++e) {
          d = h = 0;
          for (g = 3; d < g && e + d !== f; ++d) h = h << 8 | c[e + d];
          m[h] === r && (m[h] = []);
          j = m[h];
          if (!(0 < E--)) {
            for (;0 < j.length && 32768 < e - j[0]; ) j.shift();
            if (e + 3 >= f) {
              n && b(n, -1);
              d = 0;
              for (g = f - e; d < g; ++d) A = c[e + d], l[q++] = A, ++t[A];
              break;
            }
            if (0 < j.length) {
              var x = r, B = r, k = 0, p = r, D = r, C = r, da = r, W = c.length, D = 0, da = j.length;
              a: for (;D < da; D++) {
                x = j[da - D - 1];
                p = 3;
                if (3 < k) {
                  for (C = k; 3 < C; C--) if (c[x + C - 1] !== c[e + C - 1]) continue a;
                  p = k;
                }
                for (;258 > p && e + p < W && c[x + p] === c[e + p]; ) ++p;
                p > k && (B = x, k = p);
                if (258 === p) break;
              }
              s = new wa(k, e - B);
              n ? n.length < s.length ? (A = c[e - 1], l[q++] = A, ++t[A], b(s, 0)) : b(n, -1) : s.length < K ? n = s : b(s, 0);
            } else n ? b(n, -1) : (A = c[e], l[q++] = A, ++t[A]);
          }
          j.push(e);
        }
        l[q++] = 256;
        t[256]++;
        a.L = t;
        a.K = z;
        return H ? l.subarray(0, q) : l;
      }
      function ta(a, c) {
        function b(a) {
          var c = z[a][K[a]];
          c === n ? (b(a + 1), b(a + 1)) : --E[c];
          ++K[a];
        }
        var e = a.length, f = new la(572), d = new (H ? Uint8Array : Array)(e), g, h, m, j, s;
        if (!H) for (j = 0; j < e; j++) d[j] = 0;
        for (j = 0; j < e; ++j) 0 < a[j] && f.push(j, a[j]);
        g = Array(f.length / 2);
        h = new (H ? Uint32Array : Array)(f.length / 2);
        if (1 === g.length) return d[f.pop().index] = 1, d;
        j = 0;
        for (s = f.length / 2; j < s; ++j) g[j] = f.pop(), h[j] = g[j].value;
        var n = h.length, l = new (H ? Uint16Array : Array)(c), q = new (H ? Uint8Array : Array)(c), E = new (H ? Uint8Array : Array)(n), t = Array(c), z = Array(c), K = Array(c), A = (1 << c) - n, x = 1 << c - 1, B, k, p, D, C;
        l[c - 1] = n;
        for (k = 0; k < c; ++k) A < x ? q[k] = 0 : (q[k] = 1, A -= x), A <<= 1, l[c - 2 - k] = (l[c - 1 - k] / 2 | 0) + n;
        l[0] = q[0];
        t[0] = Array(l[0]);
        z[0] = Array(l[0]);
        for (k = 1; k < c; ++k) l[k] > 2 * l[k - 1] + q[k] && (l[k] = 2 * l[k - 1] + q[k]), 
        t[k] = Array(l[k]), z[k] = Array(l[k]);
        for (B = 0; B < n; ++B) E[B] = c;
        for (p = 0; p < l[c - 1]; ++p) t[c - 1][p] = h[p], z[c - 1][p] = p;
        for (B = 0; B < c; ++B) K[B] = 0;
        1 === q[c - 1] && (--E[0], ++K[c - 1]);
        for (k = c - 2; 0 <= k; --k) {
          D = B = 0;
          C = K[k + 1];
          for (p = 0; p < l[k]; p++) D = t[k + 1][C] + t[k + 1][C + 1], D > h[B] ? (t[k][p] = D, 
          z[k][p] = n, C += 2) : (t[k][p] = h[B], z[k][p] = B, ++B);
          K[k] = 0;
          1 === q[k] && b(k);
        }
        m = E;
        j = 0;
        for (s = g.length; j < s; ++j) d[g[j].index] = m[j];
        return d;
      }
      function ua(a) {
        var c = new (H ? Uint16Array : Array)(a.length), b = [], e = [], f = 0, d, g, h, m;
        d = 0;
        for (g = a.length; d < g; d++) b[a[d]] = 1 + (0 | b[a[d]]);
        d = 1;
        for (g = 16; d <= g; d++) e[d] = f, f += 0 | b[d], f > 1 << d && i("overcommitted"), 
        f <<= 1;
        65536 > f && i("undercommitted");
        d = 0;
        for (g = a.length; d < g; d++) {
          f = e[a[d]];
          e[a[d]] += 1;
          h = c[d] = 0;
          for (m = a[d]; h < m; h++) c[d] = c[d] << 1 | 1 & f, f >>>= 1;
        }
        return c;
      }
      function Da(a, c) {
        this.input = a;
        this.a = new (H ? Uint8Array : Array)(32768);
        this.h = U.j;
        var b = {}, e;
        !c && (c = {}) || "number" !== typeof c.compressionType || (this.h = c.compressionType);
        for (e in c) b[e] = c[e];
        b.outputBuffer = this.a;
        this.z = new ma(this.input, b);
      }
      var U = qa;
      Da.prototype.n = function() {
        var a, c, b, e, f, d, g, h = 0;
        g = this.a;
        a = Ea;
        switch (a) {
         case Ea:
          c = Math.LOG2E * Math.log(32768) - 8;
          break;

         default:
          i(Error("invalid compression method"));
        }
        b = c << 4 | a;
        g[h++] = b;
        switch (a) {
         case Ea:
          switch (this.h) {
           case U.NONE:
            f = 0;
            break;

           case U.r:
            f = 1;
            break;

           case U.j:
            f = 2;
            break;

           default:
            i(Error("unsupported compression type"));
          }
          break;

         default:
          i(Error("invalid compression method"));
        }
        e = f << 6 | 0;
        g[h++] = e | 31 - (256 * b + e) % 31;
        d = ba(this.input);
        this.z.b = h;
        g = this.z.n();
        h = g.length;
        H && (g = new Uint8Array(g.buffer), g.length <= h + 4 && (this.a = new Uint8Array(g.length + 4), 
        this.a.set(g), g = this.a), g = g.subarray(0, h + 4));
        g[h++] = d >> 24 & 255;
        g[h++] = d >> 16 & 255;
        g[h++] = d >> 8 & 255;
        g[h++] = 255 & d;
        return g;
      };
      y("Zlib.Deflate", Da);
      y("Zlib.Deflate.compress", (function(a, c) {
        return new Da(a, c).n();
      }));
      y("Zlib.Deflate.CompressionType", U);
      y("Zlib.Deflate.CompressionType.NONE", U.NONE);
      y("Zlib.Deflate.CompressionType.FIXED", U.r);
      y("Zlib.Deflate.CompressionType.DYNAMIC", U.j);
      function V(a, c) {
        this.k = [];
        this.l = 32768;
        this.e = this.g = this.c = this.q = 0;
        this.input = H ? new Uint8Array(a) : a;
        this.s = !1;
        this.m = Fa;
        this.B = !1;
        !c && (c = {}) || (c.index && (this.c = c.index), c.bufferSize && (this.l = c.bufferSize), 
        c.bufferType && (this.m = c.bufferType), c.resize && (this.B = c.resize));
        switch (this.m) {
         case Ga:
          this.b = 32768;
          this.a = new (H ? Uint8Array : Array)(32768 + this.l + 258);
          break;

         case Fa:
          this.b = 0;
          this.a = new (H ? Uint8Array : Array)(this.l);
          this.f = this.J;
          this.t = this.H;
          this.o = this.I;
          break;

         default:
          i(Error("invalid inflate mode"));
        }
      }
      var Ga = 0, Fa = 1, Ha = {
        D: Ga,
        C: Fa
      };
      V.prototype.p = function() {
        for (;!this.s; ) {
          var a = X(this, 3);
          1 & a && (this.s = v);
          a >>>= 1;
          switch (a) {
           case 0:
            var c = this.input, b = this.c, e = this.a, f = this.b, d = r, g = r, h = r, m = e.length, j = r;
            this.e = this.g = 0;
            d = c[b++];
            d === r && i(Error("invalid uncompressed block header: LEN (first byte)"));
            g = d;
            d = c[b++];
            d === r && i(Error("invalid uncompressed block header: LEN (second byte)"));
            g |= d << 8;
            d = c[b++];
            d === r && i(Error("invalid uncompressed block header: NLEN (first byte)"));
            h = d;
            d = c[b++];
            d === r && i(Error("invalid uncompressed block header: NLEN (second byte)"));
            h |= d << 8;
            g === ~h && i(Error("invalid uncompressed block header: length verify"));
            b + g > c.length && i(Error("input buffer is broken"));
            switch (this.m) {
             case Ga:
              for (;f + g > e.length; ) {
                j = m - f;
                g -= j;
                if (H) e.set(c.subarray(b, b + j), f), f += j, b += j; else for (;j--; ) e[f++] = c[b++];
                this.b = f;
                e = this.f();
                f = this.b;
              }
              break;

             case Fa:
              for (;f + g > e.length; ) e = this.f({
                v: 2
              });
              break;

             default:
              i(Error("invalid inflate mode"));
            }
            if (H) e.set(c.subarray(b, b + g), f), f += g, b += g; else for (;g--; ) e[f++] = c[b++];
            this.c = b;
            this.b = f;
            this.a = e;
            break;

           case 1:
            this.o(Ia, Ja);
            break;

           case 2:
            Ka(this);
            break;

           default:
            i(Error("unknown BTYPE: " + a));
          }
        }
        return this.t();
      };
      var La = [ 16, 17, 18, 0, 8, 7, 9, 6, 10, 5, 11, 4, 12, 3, 13, 2, 14, 1, 15 ], Za = H ? new Uint16Array(La) : La, $a = [ 3, 4, 5, 6, 7, 8, 9, 10, 11, 13, 15, 17, 19, 23, 27, 31, 35, 43, 51, 59, 67, 83, 99, 115, 131, 163, 195, 227, 258, 258, 258 ], ab = H ? new Uint16Array($a) : $a, bb = [ 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 5, 0, 0, 0 ], cb = H ? new Uint8Array(bb) : bb, db = [ 1, 2, 3, 4, 5, 7, 9, 13, 17, 25, 33, 49, 65, 97, 129, 193, 257, 385, 513, 769, 1025, 1537, 2049, 3073, 4097, 6145, 8193, 12289, 16385, 24577 ], eb = H ? new Uint16Array(db) : db, fb = [ 0, 0, 0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13 ], gb = H ? new Uint8Array(fb) : fb, hb = new (H ? Uint8Array : Array)(288), Y, ib;
      Y = 0;
      for (ib = hb.length; Y < ib; ++Y) hb[Y] = 143 >= Y ? 8 : 255 >= Y ? 9 : 279 >= Y ? 7 : 8;
      var Ia = S(hb), jb = new (H ? Uint8Array : Array)(30), kb, lb;
      kb = 0;
      for (lb = jb.length; kb < lb; ++kb) jb[kb] = 5;
      var Ja = S(jb);
      function X(a, c) {
        for (var b = a.g, e = a.e, f = a.input, d = a.c, g; e < c; ) g = f[d++], g === r && i(Error("input buffer is broken")), 
        b |= g << e, e += 8;
        g = b & (1 << c) - 1;
        a.g = b >>> c;
        a.e = e - c;
        a.c = d;
        return g;
      }
      function mb(a, c) {
        for (var b = a.g, e = a.e, f = a.input, d = a.c, g = c[0], h = c[1], m, j, s; e < h; ) m = f[d++], 
        m === r && i(Error("input buffer is broken")), b |= m << e, e += 8;
        j = g[b & (1 << h) - 1];
        s = j >>> 16;
        a.g = b >> s;
        a.e = e - s;
        a.c = d;
        return 65535 & j;
      }
      function Ka(a) {
        function c(a, b, c) {
          var d, e, f, g;
          for (g = 0; g < a; ) switch (d = mb(this, b), d) {
           case 16:
            for (f = 3 + X(this, 2); f--; ) c[g++] = e;
            break;

           case 17:
            for (f = 3 + X(this, 3); f--; ) c[g++] = 0;
            e = 0;
            break;

           case 18:
            for (f = 11 + X(this, 7); f--; ) c[g++] = 0;
            e = 0;
            break;

           default:
            e = c[g++] = d;
          }
          return c;
        }
        var b = X(a, 5) + 257, e = X(a, 5) + 1, f = X(a, 4) + 4, d = new (H ? Uint8Array : Array)(Za.length), g, h, m, j;
        for (j = 0; j < f; ++j) d[Za[j]] = X(a, 3);
        g = S(d);
        h = new (H ? Uint8Array : Array)(b);
        m = new (H ? Uint8Array : Array)(e);
        a.o(S(c.call(a, b, g, h)), S(c.call(a, e, g, m)));
      }
      V.prototype.o = function(a, c) {
        var b = this.a, e = this.b;
        this.u = a;
        for (var f = b.length - 258, d, g, h, m; 256 !== (d = mb(this, a)); ) if (256 > d) e >= f && (this.b = e, 
        b = this.f(), e = this.b), b[e++] = d; else {
          g = d - 257;
          m = ab[g];
          0 < cb[g] && (m += X(this, cb[g]));
          d = mb(this, c);
          h = eb[d];
          0 < gb[d] && (h += X(this, gb[d]));
          e >= f && (this.b = e, b = this.f(), e = this.b);
          for (;m--; ) b[e] = b[e++ - h];
        }
        for (;8 <= this.e; ) this.e -= 8, this.c--;
        this.b = e;
      };
      V.prototype.I = function(a, c) {
        var b = this.a, e = this.b;
        this.u = a;
        for (var f = b.length, d, g, h, m; 256 !== (d = mb(this, a)); ) if (256 > d) e >= f && (b = this.f(), 
        f = b.length), b[e++] = d; else {
          g = d - 257;
          m = ab[g];
          0 < cb[g] && (m += X(this, cb[g]));
          d = mb(this, c);
          h = eb[d];
          0 < gb[d] && (h += X(this, gb[d]));
          e + m > f && (b = this.f(), f = b.length);
          for (;m--; ) b[e] = b[e++ - h];
        }
        for (;8 <= this.e; ) this.e -= 8, this.c--;
        this.b = e;
      };
      V.prototype.f = function() {
        var a = new (H ? Uint8Array : Array)(this.b - 32768), c = this.b - 32768, b, e, f = this.a;
        if (H) a.set(f.subarray(32768, a.length)); else {
          b = 0;
          for (e = a.length; b < e; ++b) a[b] = f[b + 32768];
        }
        this.k.push(a);
        this.q += a.length;
        if (H) f.set(f.subarray(c, c + 32768)); else for (b = 0; 32768 > b; ++b) f[b] = f[c + b];
        this.b = 32768;
        return f;
      };
      V.prototype.J = function(a) {
        var c, b = this.input.length / this.c + 1 | 0, e, f, d, g = this.input, h = this.a;
        a && ("number" === typeof a.v && (b = a.v), "number" === typeof a.F && (b += a.F));
        2 > b ? (e = (g.length - this.c) / this.u[2], d = e / 2 * 258 | 0, f = d < h.length ? h.length + d : h.length << 1) : f = h.length * b;
        H ? (c = new Uint8Array(f), c.set(h)) : c = h;
        return this.a = c;
      };
      V.prototype.t = function() {
        var a = 0, c = this.a, b = this.k, e, f = new (H ? Uint8Array : Array)(this.q + (this.b - 32768)), d, g, h, m;
        if (0 === b.length) return H ? this.a.subarray(32768, this.b) : this.a.slice(32768, this.b);
        d = 0;
        for (g = b.length; d < g; ++d) {
          e = b[d];
          h = 0;
          for (m = e.length; h < m; ++h) f[a++] = e[h];
        }
        d = 32768;
        for (g = this.b; d < g; ++d) f[a++] = c[d];
        this.k = [];
        return this.buffer = f;
      };
      V.prototype.H = function() {
        var a, c = this.b;
        H ? this.B ? (a = new Uint8Array(c), a.set(this.a.subarray(0, c))) : a = this.a.subarray(0, c) : (this.a.length > c && (this.a.length = c), 
        a = this.a);
        return this.buffer = a;
      };
      function nb(a, c) {
        var b, e;
        this.input = a;
        this.c = 0;
        !c && (c = {}) || (c.index && (this.c = c.index), c.verify && (this.M = c.verify));
        b = a[this.c++];
        e = a[this.c++];
        switch (15 & b) {
         case Ea:
          this.method = Ea;
          break;

         default:
          i(Error("unsupported compression method"));
        }
        0 !== ((b << 8) + e) % 31 && i(Error("invalid fcheck flag:" + ((b << 8) + e) % 31));
        32 & e && i(Error("fdict flag is not supported"));
        this.A = new V(a, {
          index: this.c,
          bufferSize: c.bufferSize,
          bufferType: c.bufferType,
          resize: c.resize
        });
      }
      nb.prototype.p = function() {
        var a = this.input, c, b;
        c = this.A.p();
        this.c = this.A.c;
        this.M && (b = (a[this.c++] << 24 | a[this.c++] << 16 | a[this.c++] << 8 | a[this.c++]) >>> 0, 
        b !== ba(c) && i(Error("invalid adler-32 checksum")));
        return c;
      };
      y("Zlib.Inflate", nb);
      y("Zlib.Inflate.BufferType", Ha);
      Ha.ADAPTIVE = Ha.C;
      Ha.BLOCK = Ha.D;
      y("Zlib.Inflate.prototype.decompress", nb.prototype.p);
      var ob = [ 16, 17, 18, 0, 8, 7, 9, 6, 10, 5, 11, 4, 12, 3, 13, 2, 14, 1, 15 ];
      H && new Uint16Array(ob);
      var pb = [ 3, 4, 5, 6, 7, 8, 9, 10, 11, 13, 15, 17, 19, 23, 27, 31, 35, 43, 51, 59, 67, 83, 99, 115, 131, 163, 195, 227, 258, 258, 258 ];
      H && new Uint16Array(pb);
      var qb = [ 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 5, 0, 0, 0 ];
      H && new Uint8Array(qb);
      var rb = [ 1, 2, 3, 4, 5, 7, 9, 13, 17, 25, 33, 49, 65, 97, 129, 193, 257, 385, 513, 769, 1025, 1537, 2049, 3073, 4097, 6145, 8193, 12289, 16385, 24577 ];
      H && new Uint16Array(rb);
      var sb = [ 0, 0, 0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13 ];
      H && new Uint8Array(sb);
      var tb = new (H ? Uint8Array : Array)(288), Z, ub;
      Z = 0;
      for (ub = tb.length; Z < ub; ++Z) tb[Z] = 143 >= Z ? 8 : 255 >= Z ? 9 : 279 >= Z ? 7 : 8;
      S(tb);
      var vb = new (H ? Uint8Array : Array)(30), wb, xb;
      wb = 0;
      for (xb = vb.length; wb < xb; ++wb) vb[wb] = 5;
      S(vb);
      var Ea = 8;
    }).call(window);
    var _p = window.Zlib;
    _p.Deflate = _p["Deflate"];
    _p.Deflate.compress = _p.Deflate["compress"];
    _p.Inflate = _p["Inflate"];
    _p.Inflate.BufferType = _p.Inflate["BufferType"];
    _p.Inflate.prototype.decompress = _p.Inflate.prototype["decompress"];
    module.exports = _p;
  }), {} ],
  25: [ (function(require, module, exports) {
    "use strict";
    var _vmath = require("../vmath");
    var Node = require("../CCNode");
    var EventType = Node.EventType;
    var DirtyFlag = Node._LocalDirtyFlag;
    var RenderFlow = require("../renderer/render-flow");
    var ONE_DEGREE = Math.PI / 180;
    var POSITION_ON = 1;
    var SCALE_ON = 2;
    var ERR_INVALID_NUMBER = false;
    function _updateLocalMatrix3d() {
      if (this._localMatDirty) {
        var t = this._matrix;
        _vmath.mat4.fromRTS(t, this._quat, this._position, this._scale);
        if (this._skewX || this._skewY) {
          var a = t.m00, b = t.m01, c = t.m04, d = t.m05;
          var skx = Math.tan(this._skewX * ONE_DEGREE);
          var sky = Math.tan(this._skewY * ONE_DEGREE);
          Infinity === skx && (skx = 99999999);
          Infinity === sky && (sky = 99999999);
          t.m00 = a + c * sky;
          t.m01 = b + d * sky;
          t.m04 = c + a * skx;
          t.m05 = d + b * skx;
        }
        this._localMatDirty = 0;
        this._worldMatDirty = true;
      }
    }
    function _calculWorldMatrix3d() {
      this._localMatDirty && this._updateLocalMatrix();
      if (this._parent) {
        var parentMat = this._parent._worldMatrix;
        _vmath.mat4.mul(this._worldMatrix, parentMat, this._matrix);
      } else _vmath.mat4.copy(this._worldMatrix, this._matrix);
      this._worldMatDirty = false;
    }
    function setPosition(newPosOrX, y, z) {
      var x = void 0;
      if (void 0 === y) {
        x = newPosOrX.x;
        y = newPosOrX.y;
        z = newPosOrX.z || 0;
      } else {
        x = newPosOrX;
        z = z || 0;
      }
      var pos = this._position;
      if (pos.x === x && pos.y === y && pos.z === z) return;
      var oldPosition;
      false;
      pos.x = x;
      pos.y = y;
      pos.z = z;
      this.setLocalDirty(DirtyFlag.POSITION);
      this._renderFlag |= RenderFlow.FLAG_WORLD_TRANSFORM;
      if (this._eventMask & POSITION_ON) {
        false;
        this.emit(EventType.POSITION_CHANGED);
      }
    }
    function setScale(x, y, z) {
      if (x && "number" !== typeof x) {
        y = x.y;
        z = x.z || 1;
        x = x.x;
      } else if (void 0 !== x && void 0 === y) {
        y = x;
        z = x;
      } else void 0 === z && (z = 1);
      if (this._scale.x !== x || this._scale.y !== y || this._scale.z !== z) {
        this._scale.x = x;
        this._scale.y = y;
        this._scale.z = z;
        this.setLocalDirty(DirtyFlag.SCALE);
        this._renderFlag |= RenderFlow.FLAG_TRANSFORM;
        this._eventMask & SCALE_ON && this.emit(EventType.SCALE_CHANGED);
      }
    }
    function _update3DFunction() {
      if (this._is3DNode) {
        this._updateLocalMatrix = _updateLocalMatrix3d;
        this._calculWorldMatrix = _calculWorldMatrix3d;
        this._mulMat = _vmath.mat4.mul;
      } else {
        this._updateLocalMatrix = _updateLocalMatrix2d;
        this._calculWorldMatrix = _calculWorldMatrix2d;
        this._mulMat = _mulMat2d;
      }
      this._renderComponent && this._renderComponent._on3DNodeChanged && this._renderComponent._on3DNodeChanged();
      this._renderFlag |= RenderFlow.FLAG_TRANSFORM;
      this._localMatDirty = DirtyFlag.ALL;
    }
    function _upgrade_1x_to_2x() {
      this._is3DNode && this._update3DFunction();
      _upgrade_1x_to_2x_2d.call(this);
    }
    var proto = cc.Node.prototype;
    var _updateLocalMatrix2d = proto._updateLocalMatrix;
    var _calculWorldMatrix2d = proto._calculWorldMatrix;
    var _upgrade_1x_to_2x_2d = proto._upgrade_1x_to_2x;
    var _mulMat2d = proto._mulMat;
    proto.setPosition = setPosition;
    proto.setScale = setScale;
    proto._upgrade_1x_to_2x = _upgrade_1x_to_2x;
    proto._update3DFunction = _update3DFunction;
    cc.js.getset(proto, "position", proto.getPosition, setPosition, false, true);
    cc.js.getset(proto, "is3DNode", (function() {
      return this._is3DNode;
    }), (function(v) {
      if (this._is3DNode === v) return;
      this._is3DNode = v;
      this._update3DFunction();
    }));
    cc.js.getset(proto, "scaleZ", (function() {
      return this._scale.z;
    }), (function(v) {
      if (this._scale.z !== v) {
        this._scale.z = v;
        this.setLocalDirty(DirtyFlag.SCALE);
        this._renderFlag |= RenderFlow.FLAG_TRANSFORM;
        this._eventMask & SCALE_ON && this.emit(EventType.SCALE_CHANGED);
      }
    }));
    cc.js.getset(proto, "z", (function() {
      return this._position.z;
    }), (function(value) {
      var localPosition = this._position;
      if (value !== localPosition.z) {
        true;
        localPosition.z = value;
        this.setLocalDirty(DirtyFlag.POSITION);
        this._renderFlag |= RenderFlow.FLAG_WORLD_TRANSFORM;
        this._eventMask & POSITION_ON && this.emit(EventType.POSITION_CHANGED);
      }
    }));
    cc.js.getset(proto, "eulerAngles", (function() {
      false;
      return this._quat.toEuler(this._eulerAngles);
    }), (function(v) {
      false;
      this._quat.fromEuler(v);
      this.setLocalDirty(DirtyFlag.ROTATION);
      this._renderFlag |= RenderFlow.FLAG_TRANSFORM;
    }));
    cc.js.getset(proto, "quat", (function() {
      return this._quat;
    }), proto.setRotation);
  }), {
    "../CCNode": 29,
    "../renderer/render-flow": 162,
    "../vmath": 224
  } ],
  26: [ (function(require, module, exports) {
    "use strict";
    var debugInfos = require("../../DebugInfos") || {};
    var ERROR_MAP_URL = "https://github.com/cocos-creator/engine/blob/master/EngineErrorMap.md";
    var logList = void 0;
    cc.log = cc.warn = cc.error = cc.assert = console.log.bind ? console.log.bind(console) : console.log;
    var resetDebugSetting = function resetDebugSetting(mode) {
      cc.log = cc.warn = cc.error = cc.assert = function() {};
      if (mode === DebugMode.NONE) return;
      if (mode > DebugMode.ERROR) {
        var logToWebPage = function logToWebPage(msg) {
          if (!cc.game.canvas) return;
          if (!logList) {
            var logDiv = document.createElement("Div");
            logDiv.setAttribute("id", "logInfoDiv");
            logDiv.setAttribute("width", "200");
            logDiv.setAttribute("height", cc.game.canvas.height);
            var logDivStyle = logDiv.style;
            logDivStyle.zIndex = "99999";
            logDivStyle.position = "absolute";
            logDivStyle.top = logDivStyle.left = "0";
            logList = document.createElement("textarea");
            logList.setAttribute("rows", "20");
            logList.setAttribute("cols", "30");
            logList.setAttribute("disabled", "true");
            var logListStyle = logList.style;
            logListStyle.backgroundColor = "transparent";
            logListStyle.borderBottom = "1px solid #cccccc";
            logListStyle.borderTopWidth = logListStyle.borderLeftWidth = logListStyle.borderRightWidth = "0px";
            logListStyle.borderTopStyle = logListStyle.borderLeftStyle = logListStyle.borderRightStyle = "none";
            logListStyle.padding = "0px";
            logListStyle.margin = 0;
            logDiv.appendChild(logList);
            cc.game.canvas.parentNode.appendChild(logDiv);
          }
          logList.value = logList.value + msg + "\r\n";
          logList.scrollTop = logList.scrollHeight;
        };
        cc.error = function() {
          logToWebPage("ERROR :  " + cc.js.formatStr.apply(null, arguments));
        };
        cc.assert = function(cond, msg) {
          if (!cond && msg) {
            msg = cc.js.formatStr.apply(null, cc.js.shiftArguments.apply(null, arguments));
            logToWebPage("ASSERT: " + msg);
          }
        };
        mode !== DebugMode.ERROR_FOR_WEB_PAGE && (cc.warn = function() {
          logToWebPage("WARN :  " + cc.js.formatStr.apply(null, arguments));
        });
        mode === DebugMode.INFO_FOR_WEB_PAGE && (cc.log = function() {
          logToWebPage(cc.js.formatStr.apply(null, arguments));
        });
      } else if (console && console.log.apply) {
        console.error || (console.error = console.log);
        console.warn || (console.warn = console.log);
        false;
        console.error.bind ? cc.error = console.error.bind(console) : cc.error = (false, 
        function() {
          return console.error.apply(console, arguments);
        });
        cc.assert = function(cond, msg) {
          if (!cond) {
            msg && (msg = cc.js.formatStr.apply(null, cc.js.shiftArguments.apply(null, arguments)));
            false;
            false;
            throw new Error(msg);
          }
        };
      }
      if (mode !== DebugMode.ERROR) {
        false;
        console.warn.bind ? cc.warn = console.warn.bind(console) : cc.warn = (false, function() {
          return console.warn.apply(console, arguments);
        });
      }
      false;
      if (mode === DebugMode.INFO) {
        false, false;
        console.log.bind ? cc.log = console.log.bind(console) : cc.log = function() {
          return console.log.apply(console, arguments);
        };
      }
    };
    cc._throw = function(error) {
      var stack = error.stack;
      stack ? cc.error((false, stack)) : cc.error(error);
    };
    function getTypedFormatter(type) {
      return function() {
        var id = arguments[0];
        var msg = debugInfos[id] || "unknown id";
        if (1 === arguments.length) return msg;
        if (2 === arguments.length) return cc.js.formatStr(msg, arguments[1]);
        var argsArray = cc.js.shiftArguments.apply(null, arguments);
        return cc.js.formatStr.apply(null, [ msg ].concat(argsArray));
      };
    }
    var logFormatter = getTypedFormatter("Log");
    cc.logID = function() {
      cc.log(logFormatter.apply(null, arguments));
    };
    var warnFormatter = getTypedFormatter("Warning");
    cc.warnID = function() {
      cc.warn(warnFormatter.apply(null, arguments));
    };
    var errorFormatter = getTypedFormatter("Error");
    cc.errorID = function() {
      cc.error(errorFormatter.apply(null, arguments));
    };
    var assertFormatter = getTypedFormatter("Assert");
    cc.assertID = function(cond) {
      if (cond) return;
      cc.assert(false, assertFormatter.apply(null, cc.js.shiftArguments.apply(null, arguments)));
    };
    var DebugMode = cc.Enum({
      NONE: 0,
      INFO: 1,
      WARN: 2,
      ERROR: 3,
      INFO_FOR_WEB_PAGE: 4,
      WARN_FOR_WEB_PAGE: 5,
      ERROR_FOR_WEB_PAGE: 6
    });
    module.exports = cc.debug = {
      DebugMode: DebugMode,
      _resetDebugSetting: resetDebugSetting,
      getError: getTypedFormatter("ERROR"),
      isDisplayStats: function isDisplayStats() {
        return !!cc.profiler && cc.profiler.isShowingStats();
      },
      setDisplayStats: function setDisplayStats(displayStats) {
        if (cc.profiler) {
          displayStats ? cc.profiler.showStats() : cc.profiler.hideStats();
          cc.game.config.showFPS = !!displayStats;
        }
      }
    };
  }), {
    "../../DebugInfos": 1
  } ],
  27: [ (function(require, module, exports) {
    "use strict";
    var EventTarget = require("./event/event-target");
    var AutoReleaseUtils = require("./load-pipeline/auto-release-utils");
    var ComponentScheduler = require("./component-scheduler");
    var NodeActivator = require("./node-activator");
    var Obj = require("./platform/CCObject");
    var game = require("./CCGame");
    var renderer = require("./renderer");
    var eventManager = require("./event-manager");
    var Scheduler = require("./CCScheduler");
    cc.Director = function() {
      EventTarget.call(this);
      this._paused = false;
      this._purgeDirectorInNextLoop = false;
      this._winSizeInPoints = null;
      this._loadingScene = "";
      this._scene = null;
      this._totalFrames = 0;
      this._lastUpdate = 0;
      this._deltaTime = 0;
      this._scheduler = null;
      this._compScheduler = null;
      this._nodeActivator = null;
      this._actionManager = null;
      var self = this;
      game.on(game.EVENT_SHOW, (function() {
        self._lastUpdate = performance.now();
      }));
      game.once(game.EVENT_ENGINE_INITED, this.init, this);
    };
    cc.Director.prototype = {
      constructor: cc.Director,
      init: function init() {
        this._totalFrames = 0;
        this._lastUpdate = performance.now();
        this._paused = false;
        this._purgeDirectorInNextLoop = false;
        this._winSizeInPoints = cc.size(0, 0);
        this._scheduler = new Scheduler();
        if (cc.ActionManager) {
          this._actionManager = new cc.ActionManager();
          this._scheduler.scheduleUpdate(this._actionManager, Scheduler.PRIORITY_SYSTEM, false);
        } else this._actionManager = null;
        this.sharedInit();
        return true;
      },
      sharedInit: function sharedInit() {
        this._compScheduler = new ComponentScheduler();
        this._nodeActivator = new NodeActivator();
        eventManager && eventManager.setEnabled(true);
        if (cc.AnimationManager) {
          this._animationManager = new cc.AnimationManager();
          this._scheduler.scheduleUpdate(this._animationManager, Scheduler.PRIORITY_SYSTEM, false);
        } else this._animationManager = null;
        if (cc.CollisionManager) {
          this._collisionManager = new cc.CollisionManager();
          this._scheduler.scheduleUpdate(this._collisionManager, Scheduler.PRIORITY_SYSTEM, false);
        } else this._collisionManager = null;
        if (cc.PhysicsManager) {
          this._physicsManager = new cc.PhysicsManager();
          this._scheduler.scheduleUpdate(this._physicsManager, Scheduler.PRIORITY_SYSTEM, false);
        } else this._physicsManager = null;
        cc._widgetManager && cc._widgetManager.init(this);
        cc.loader.init(this);
      },
      calculateDeltaTime: function calculateDeltaTime(now) {
        now || (now = performance.now());
        this._deltaTime = (now - this._lastUpdate) / 1e3;
        (true, this._deltaTime > 1) && (this._deltaTime = 1 / 60);
        this._lastUpdate = now;
      },
      convertToGL: function convertToGL(uiPoint) {
        var container = game.container;
        var view = cc.view;
        var box = container.getBoundingClientRect();
        var left = box.left + window.pageXOffset - container.clientLeft;
        var top = box.top + window.pageYOffset - container.clientTop;
        var x = view._devicePixelRatio * (uiPoint.x - left);
        var y = view._devicePixelRatio * (top + box.height - uiPoint.y);
        return view._isRotated ? cc.v2(view._viewportRect.width - y, x) : cc.v2(x, y);
      },
      convertToUI: function convertToUI(glPoint) {
        var container = game.container;
        var view = cc.view;
        var box = container.getBoundingClientRect();
        var left = box.left + window.pageXOffset - container.clientLeft;
        var top = box.top + window.pageYOffset - container.clientTop;
        var uiPoint = cc.v2(0, 0);
        if (view._isRotated) {
          uiPoint.x = left + glPoint.y / view._devicePixelRatio;
          uiPoint.y = top + box.height - (view._viewportRect.width - glPoint.x) / view._devicePixelRatio;
        } else {
          uiPoint.x = left + glPoint.x * view._devicePixelRatio;
          uiPoint.y = top + box.height - glPoint.y * view._devicePixelRatio;
        }
        return uiPoint;
      },
      end: function end() {
        this._purgeDirectorInNextLoop = true;
      },
      getWinSize: function getWinSize() {
        return cc.size(cc.winSize);
      },
      getWinSizeInPixels: function getWinSizeInPixels() {
        return cc.size(cc.winSize);
      },
      pause: function pause() {
        if (this._paused) return;
        this._paused = true;
      },
      purgeCachedData: function purgeCachedData() {
        cc.loader.releaseAll();
      },
      purgeDirector: function purgeDirector() {
        this._scheduler.unscheduleAll();
        this._compScheduler.unscheduleAll();
        this._nodeActivator.reset();
        eventManager && eventManager.setEnabled(false);
        true;
        cc.isValid(this._scene) && this._scene.destroy();
        this._scene = null;
        cc.renderer.clear();
        cc.AssetLibrary.resetBuiltins();
        cc.game.pause();
        cc.loader.releaseAll();
      },
      reset: function reset() {
        this.purgeDirector();
        eventManager && eventManager.setEnabled(true);
        this._actionManager && this._scheduler.scheduleUpdate(this._actionManager, cc.Scheduler.PRIORITY_SYSTEM, false);
        this._animationManager && this._scheduler.scheduleUpdate(this._animationManager, cc.Scheduler.PRIORITY_SYSTEM, false);
        this._collisionManager && this._scheduler.scheduleUpdate(this._collisionManager, cc.Scheduler.PRIORITY_SYSTEM, false);
        this._physicsManager && this._scheduler.scheduleUpdate(this._physicsManager, cc.Scheduler.PRIORITY_SYSTEM, false);
        cc.game.resume();
      },
      runSceneImmediate: function runSceneImmediate(scene, onBeforeLoadScene, onLaunched) {
        cc.assertID(scene instanceof cc.Scene, 1216);
        (true, true) && console.time("InitScene");
        scene._load();
        (true, true) && console.timeEnd("InitScene");
        (true, true) && console.time("AttachPersist");
        var persistNodeList = Object.keys(game._persistRootNodes).map((function(x) {
          return game._persistRootNodes[x];
        }));
        for (var i = 0; i < persistNodeList.length; i++) {
          var node = persistNodeList[i];
          var existNode = scene.getChildByUuid(node.uuid);
          if (existNode) {
            var index = existNode.getSiblingIndex();
            existNode._destroyImmediate();
            scene.insertChild(node, index);
          } else node.parent = scene;
        }
        (true, true) && console.timeEnd("AttachPersist");
        var oldScene = this._scene;
        true;
        (true, true) && console.time("AutoRelease");
        var autoReleaseAssets = oldScene && oldScene.autoReleaseAssets && oldScene.dependAssets;
        AutoReleaseUtils.autoRelease(autoReleaseAssets, scene.dependAssets, persistNodeList);
        (true, true) && console.timeEnd("AutoRelease");
        (true, true) && console.time("Destroy");
        cc.isValid(oldScene) && oldScene.destroy();
        this._scene = null;
        Obj._deferredDestroy();
        (true, true) && console.timeEnd("Destroy");
        onBeforeLoadScene && onBeforeLoadScene();
        this.emit(cc.Director.EVENT_BEFORE_SCENE_LAUNCH, scene);
        this._scene = scene;
        (true, true) && console.time("Activate");
        scene._activate();
        (true, true) && console.timeEnd("Activate");
        cc.game.resume();
        onLaunched && onLaunched(null, scene);
        this.emit(cc.Director.EVENT_AFTER_SCENE_LAUNCH, scene);
      },
      runScene: function runScene(scene, onBeforeLoadScene, onLaunched) {
        cc.assertID(scene, 1205);
        cc.assertID(scene instanceof cc.Scene, 1216);
        scene._load();
        this.once(cc.Director.EVENT_AFTER_UPDATE, (function() {
          this.runSceneImmediate(scene, onBeforeLoadScene, onLaunched);
        }), this);
      },
      _getSceneUuid: function _getSceneUuid(key) {
        var scenes = game._sceneInfos;
        if ("string" === typeof key) {
          key.endsWith(".fire") || (key += ".fire");
          "/" === key[0] || key.startsWith("db://") || (key = "/" + key);
          for (var i = 0; i < scenes.length; i++) {
            var info = scenes[i];
            if (info.url.endsWith(key)) return info;
          }
        } else if ("number" === typeof key) {
          if (0 <= key && key < scenes.length) return scenes[key];
          cc.errorID(1206, key);
        } else cc.errorID(1207, key);
        return null;
      },
      loadScene: function loadScene(sceneName, onLaunched, _onUnloaded) {
        if (this._loadingScene) {
          cc.errorID(1208, sceneName, this._loadingScene);
          return false;
        }
        var info = this._getSceneUuid(sceneName);
        if (info) {
          var uuid = info.uuid;
          this.emit(cc.Director.EVENT_BEFORE_SCENE_LOADING, sceneName);
          this._loadingScene = sceneName;
          this._loadSceneByUuid(uuid, onLaunched, _onUnloaded);
          return true;
        }
        cc.errorID(1209, sceneName);
        return false;
      },
      preloadScene: function preloadScene(sceneName, onProgress, onLoaded) {
        if (void 0 === onLoaded) {
          onLoaded = onProgress;
          onProgress = null;
        }
        var info = this._getSceneUuid(sceneName);
        if (info) {
          this.emit(cc.Director.EVENT_BEFORE_SCENE_LOADING, sceneName);
          cc.loader.load({
            uuid: info.uuid,
            type: "uuid"
          }, onProgress, (function(error, asset) {
            error && cc.errorID(1210, sceneName, error.message);
            onLoaded && onLoaded(error, asset);
          }));
        } else {
          var error = 'Can not preload the scene "' + sceneName + '" because it is not in the build settings.';
          onLoaded(new Error(error));
          cc.error("preloadScene: " + error);
        }
      },
      _loadSceneByUuid: function _loadSceneByUuid(uuid, onLaunched, onUnloaded, dontRunScene) {
        false;
        console.time("LoadScene " + uuid);
        cc.AssetLibrary.loadAsset(uuid, (function(error, sceneAsset) {
          console.timeEnd("LoadScene " + uuid);
          var self = cc.director;
          self._loadingScene = "";
          if (error) {
            error = "Failed to load scene: " + error;
            cc.error(error);
          } else {
            if (sceneAsset instanceof cc.SceneAsset) {
              var scene = sceneAsset.scene;
              scene._id = sceneAsset._uuid;
              scene._name = sceneAsset._name;
              false;
              self.runSceneImmediate(scene, onUnloaded, onLaunched);
              return;
            }
            error = "The asset " + uuid + " is not a scene";
            cc.error(error);
          }
          onLaunched && onLaunched(error);
        }));
      },
      resume: function resume() {
        if (!this._paused) return;
        this._lastUpdate = performance.now();
        this._lastUpdate || cc.logID(1200);
        this._paused = false;
        this._deltaTime = 0;
      },
      setDepthTest: function setDepthTest(value) {
        if (!cc.Camera.main) return;
        cc.Camera.main.depth = !!value;
      },
      setClearColor: function setClearColor(clearColor) {
        if (!cc.Camera.main) return;
        cc.Camera.main.backgroundColor = clearColor;
      },
      getRunningScene: function getRunningScene() {
        return this._scene;
      },
      getScene: function getScene() {
        return this._scene;
      },
      getAnimationInterval: function getAnimationInterval() {
        return 1e3 / game.getFrameRate();
      },
      setAnimationInterval: function setAnimationInterval(value) {
        game.setFrameRate(Math.round(1e3 / value));
      },
      getDeltaTime: function getDeltaTime() {
        return this._deltaTime;
      },
      getTotalFrames: function getTotalFrames() {
        return this._totalFrames;
      },
      isPaused: function isPaused() {
        return this._paused;
      },
      getScheduler: function getScheduler() {
        return this._scheduler;
      },
      setScheduler: function setScheduler(scheduler) {
        this._scheduler !== scheduler && (this._scheduler = scheduler);
      },
      getActionManager: function getActionManager() {
        return this._actionManager;
      },
      setActionManager: function setActionManager(actionManager) {
        if (this._actionManager !== actionManager) {
          this._actionManager && this._scheduler.unscheduleUpdate(this._actionManager);
          this._actionManager = actionManager;
          this._scheduler.scheduleUpdate(this._actionManager, cc.Scheduler.PRIORITY_SYSTEM, false);
        }
      },
      getAnimationManager: function getAnimationManager() {
        return this._animationManager;
      },
      getCollisionManager: function getCollisionManager() {
        return this._collisionManager;
      },
      getPhysicsManager: function getPhysicsManager() {
        return this._physicsManager;
      },
      startAnimation: function startAnimation() {
        cc.game.resume();
      },
      stopAnimation: function stopAnimation() {
        cc.game.pause();
      },
      _resetDeltaTime: function _resetDeltaTime() {
        this._lastUpdate = performance.now();
        this._deltaTime = 0;
      },
      mainLoop: function(now) {
        if (this._purgeDirectorInNextLoop) {
          this._purgeDirectorInNextLoop = false;
          this.purgeDirector();
        } else {
          this.calculateDeltaTime(now);
          if (!this._paused) {
            this.emit(cc.Director.EVENT_BEFORE_UPDATE);
            this._compScheduler.startPhase();
            this._compScheduler.updatePhase(this._deltaTime);
            this._scheduler.update(this._deltaTime);
            this._compScheduler.lateUpdatePhase(this._deltaTime);
            this.emit(cc.Director.EVENT_AFTER_UPDATE);
            Obj._deferredDestroy();
          }
          this.emit(cc.Director.EVENT_BEFORE_DRAW);
          renderer.render(this._scene);
          this.emit(cc.Director.EVENT_AFTER_DRAW);
          eventManager.frameUpdateListeners();
          this._totalFrames++;
        }
      },
      __fastOn: function __fastOn(type, callback, target) {
        this.add(type, callback, target);
      },
      __fastOff: function __fastOff(type, callback, target) {
        this.remove(type, callback, target);
      }
    };
    cc.js.addon(cc.Director.prototype, EventTarget.prototype);
    cc.Director.EVENT_PROJECTION_CHANGED = "director_projection_changed";
    cc.Director.EVENT_BEFORE_SCENE_LOADING = "director_before_scene_loading";
    cc.Director.EVENT_BEFORE_SCENE_LAUNCH = "director_before_scene_launch";
    cc.Director.EVENT_AFTER_SCENE_LAUNCH = "director_after_scene_launch";
    cc.Director.EVENT_BEFORE_UPDATE = "director_before_update";
    cc.Director.EVENT_AFTER_UPDATE = "director_after_update";
    cc.Director.EVENT_BEFORE_VISIT = "director_before_draw";
    cc.Director.EVENT_AFTER_VISIT = "director_before_draw";
    cc.Director.EVENT_BEFORE_DRAW = "director_before_draw";
    cc.Director.EVENT_AFTER_DRAW = "director_after_draw";
    cc.Director.PROJECTION_2D = 0;
    cc.Director.PROJECTION_3D = 1;
    cc.Director.PROJECTION_CUSTOM = 3;
    cc.Director.PROJECTION_DEFAULT = cc.Director.PROJECTION_2D;
    cc.director = new cc.Director();
    module.exports = cc.director;
  }), {
    "./CCGame": 28,
    "./CCScheduler": 32,
    "./component-scheduler": 57,
    "./event-manager": 84,
    "./event/event-target": 86,
    "./load-pipeline/auto-release-utils": 99,
    "./node-activator": 115,
    "./platform/CCObject": 124,
    "./renderer": 161
  } ],
  28: [ (function(require, module, exports) {
    "use strict";
    var EventTarget = require("./event/event-target");
    require("../audio/CCAudioEngine");
    var debug = require("./CCDebug");
    var renderer = require("./renderer/index.js");
    var inputManager = require("./platform/CCInputManager");
    var dynamicAtlasManager = require("../core/renderer/utils/dynamic-atlas/manager");
    var game = {
      EVENT_HIDE: "game_on_hide",
      EVENT_SHOW: "game_on_show",
      EVENT_RESTART: "game_on_restart",
      EVENT_GAME_INITED: "game_inited",
      EVENT_ENGINE_INITED: "engine_inited",
      EVENT_RENDERER_INITED: "engine_inited",
      RENDER_TYPE_CANVAS: 0,
      RENDER_TYPE_WEBGL: 1,
      RENDER_TYPE_OPENGL: 2,
      _persistRootNodes: {},
      _paused: true,
      _configLoaded: false,
      _isCloning: false,
      _prepared: false,
      _rendererInitialized: false,
      _renderContext: null,
      _intervalId: null,
      _lastTime: null,
      _frameTime: null,
      _sceneInfos: [],
      frame: null,
      container: null,
      canvas: null,
      renderType: -1,
      config: null,
      onStart: null,
      setFrameRate: function setFrameRate(frameRate) {
        var config = this.config;
        config.frameRate = frameRate;
        this._intervalId && window.cancelAnimFrame(this._intervalId);
        this._intervalId = 0;
        this._paused = true;
        this._setAnimFrame();
        this._runMainLoop();
      },
      getFrameRate: function getFrameRate() {
        return this.config.frameRate;
      },
      step: function step() {
        cc.director.mainLoop();
      },
      pause: function pause() {
        if (this._paused) return;
        this._paused = true;
        cc.audioEngine && cc.audioEngine._break();
        this._intervalId && window.cancelAnimFrame(this._intervalId);
        this._intervalId = 0;
      },
      resume: function resume() {
        if (!this._paused) return;
        this._paused = false;
        cc.audioEngine && cc.audioEngine._restore();
        cc.director._resetDeltaTime();
        this._runMainLoop();
      },
      isPaused: function isPaused() {
        return this._paused;
      },
      restart: function restart() {
        cc.director.once(cc.Director.EVENT_AFTER_DRAW, (function() {
          for (var id in game._persistRootNodes) game.removePersistRootNode(game._persistRootNodes[id]);
          cc.director.getScene().destroy();
          cc.Object._deferredDestroy();
          cc.audioEngine && cc.audioEngine.uncacheAll();
          cc.director.reset();
          game.pause();
          cc.AssetLibrary._loadBuiltins((function() {
            game.onStart();
            game.emit(game.EVENT_RESTART);
          }));
        }));
      },
      end: function end() {
        close();
      },
      _initEngine: function _initEngine() {
        if (this._rendererInitialized) return;
        this._initRenderer();
        true;
        this._initEvents();
        this.emit(this.EVENT_ENGINE_INITED);
      },
      _prepareFinished: function _prepareFinished(cb) {
        var _this = this;
        false;
        this._prepared = true;
        this._initEngine();
        cc.AssetLibrary._loadBuiltins((function() {
          console.log("Cocos Creator v" + cc.ENGINE_VERSION);
          _this._setAnimFrame();
          _this._runMainLoop();
          _this.emit(_this.EVENT_GAME_INITED);
          cb && cb();
        }));
      },
      eventTargetOn: EventTarget.prototype.on,
      eventTargetOnce: EventTarget.prototype.once,
      on: function on(type, callback, target) {
        this._prepared && type === this.EVENT_ENGINE_INITED || !this._paused && type === this.EVENT_GAME_INITED ? callback.call(target) : this.eventTargetOn(type, callback, target);
      },
      once: function once(type, callback, target) {
        this._prepared && type === this.EVENT_ENGINE_INITED || !this._paused && type === this.EVENT_GAME_INITED ? callback.call(target) : this.eventTargetOnce(type, callback, target);
      },
      prepare: function prepare(cb) {
        if (this._prepared) {
          cb && cb();
          return;
        }
        var jsList = this.config.jsList;
        if (jsList && jsList.length > 0) {
          var self = this;
          cc.loader.load(jsList, (function(err) {
            if (err) throw new Error(JSON.stringify(err));
            self._prepareFinished(cb);
          }));
        } else this._prepareFinished(cb);
      },
      run: function run(config, onStart) {
        this._initConfig(config);
        this.onStart = onStart;
        this.prepare(game.onStart && game.onStart.bind(game));
      },
      addPersistRootNode: function addPersistRootNode(node) {
        if (!cc.Node.isNode(node) || !node.uuid) {
          cc.warnID(3800);
          return;
        }
        var id = node.uuid;
        if (!this._persistRootNodes[id]) {
          var scene = cc.director._scene;
          if (cc.isValid(scene)) if (node.parent) {
            if (!(node.parent instanceof cc.Scene)) {
              cc.warnID(3801);
              return;
            }
            if (node.parent !== scene) {
              cc.warnID(3802);
              return;
            }
          } else node.parent = scene;
          this._persistRootNodes[id] = node;
          node._persistNode = true;
        }
      },
      removePersistRootNode: function removePersistRootNode(node) {
        var id = node.uuid || "";
        if (node === this._persistRootNodes[id]) {
          delete this._persistRootNodes[id];
          node._persistNode = false;
        }
      },
      isPersistRootNode: function isPersistRootNode(node) {
        return node._persistNode;
      },
      _setAnimFrame: function _setAnimFrame() {
        this._lastTime = performance.now();
        var frameRate = game.config.frameRate;
        this._frameTime = 1e3 / frameRate;
        false, false;
        if (60 !== frameRate && 30 !== frameRate) {
          window.requestAnimFrame = this._stTime;
          window.cancelAnimFrame = this._ctTime;
        } else {
          window.requestAnimFrame = window.requestAnimationFrame || window.webkitRequestAnimationFrame || window.mozRequestAnimationFrame || window.oRequestAnimationFrame || window.msRequestAnimationFrame || this._stTime;
          window.cancelAnimFrame = window.cancelAnimationFrame || window.cancelRequestAnimationFrame || window.msCancelRequestAnimationFrame || window.mozCancelRequestAnimationFrame || window.oCancelRequestAnimationFrame || window.webkitCancelRequestAnimationFrame || window.msCancelAnimationFrame || window.mozCancelAnimationFrame || window.webkitCancelAnimationFrame || window.oCancelAnimationFrame || this._ctTime;
        }
      },
      _stTime: function _stTime(callback) {
        var currTime = performance.now();
        var timeToCall = Math.max(0, game._frameTime - (currTime - game._lastTime));
        var id = window.setTimeout((function() {
          callback();
        }), timeToCall);
        game._lastTime = currTime + timeToCall;
        return id;
      },
      _ctTime: function _ctTime(id) {
        window.clearTimeout(id);
      },
      _runMainLoop: function _runMainLoop() {
        false;
        var self = this, _callback, config = self.config, director = cc.director, skip = true, frameRate = config.frameRate;
        debug.setDisplayStats(config.showFPS);
        _callback = function callback(now) {
          if (!self._paused) {
            self._intervalId = window.requestAnimFrame(_callback);
            if ((true, true) && 30 === frameRate && (skip = !skip)) return;
            director.mainLoop(now);
          }
        };
        self._intervalId = window.requestAnimFrame(_callback);
        self._paused = false;
      },
      _initConfig: function _initConfig(config) {
        "number" !== typeof config.debugMode && (config.debugMode = 0);
        config.exposeClassName = !!config.exposeClassName;
        "number" !== typeof config.frameRate && (config.frameRate = 60);
        var renderMode = config.renderMode;
        ("number" !== typeof renderMode || renderMode > 2 || renderMode < 0) && (config.renderMode = 0);
        "boolean" !== typeof config.registerSystemEvent && (config.registerSystemEvent = true);
        config.showFPS = !!config.showFPS;
        this._sceneInfos = config.scenes || [];
        this.collisionMatrix = config.collisionMatrix || [];
        this.groupList = config.groupList || [];
        debug._resetDebugSetting(config.debugMode);
        this.config = config;
        this._configLoaded = true;
      },
      _determineRenderType: function _determineRenderType() {
        var config = this.config, userRenderMode = parseInt(config.renderMode) || 0;
        this.renderType = this.RENDER_TYPE_CANVAS;
        var supportRender = false;
        if (0 === userRenderMode) {
          if (cc.sys.capabilities["opengl"]) {
            this.renderType = this.RENDER_TYPE_WEBGL;
            supportRender = true;
          } else if (cc.sys.capabilities["canvas"]) {
            this.renderType = this.RENDER_TYPE_CANVAS;
            supportRender = true;
          }
        } else if (1 === userRenderMode && cc.sys.capabilities["canvas"]) {
          this.renderType = this.RENDER_TYPE_CANVAS;
          supportRender = true;
        } else if (2 === userRenderMode && cc.sys.capabilities["opengl"]) {
          this.renderType = this.RENDER_TYPE_WEBGL;
          supportRender = true;
        }
        if (!supportRender) throw new Error(debug.getError(3820, userRenderMode));
      },
      _initRenderer: function _initRenderer() {
        if (this._rendererInitialized) return;
        var el = this.config.id, width = void 0, height = void 0, localCanvas = void 0, localContainer = void 0;
        var addClass;
        var element;
        true;
        this.container = localContainer = document.createElement("DIV");
        this.frame = localContainer.parentNode === document.body ? document.documentElement : localContainer.parentNode;
        if (cc.sys.browserType === cc.sys.BROWSER_TYPE_WECHAT_GAME_SUB) localCanvas = window.sharedCanvas || wx.getSharedCanvas(); else {
          false, false;
          localCanvas = canvas;
        }
        this.canvas = localCanvas;
        this._determineRenderType();
        if (this.renderType === this.RENDER_TYPE_WEBGL) {
          var opts = {
            stencil: true,
            antialias: cc.macro.ENABLE_WEBGL_ANTIALIAS,
            alpha: cc.macro.ENABLE_TRANSPARENT_CANVAS
          };
          false;
          renderer.initWebGL(localCanvas, opts);
          this._renderContext = renderer.device._gl;
          !cc.macro.CLEANUP_IMAGE_CACHE && dynamicAtlasManager && (dynamicAtlasManager.enabled = true);
        }
        if (!this._renderContext) {
          this.renderType = this.RENDER_TYPE_CANVAS;
          renderer.initCanvas(localCanvas);
          this._renderContext = renderer.device._ctx;
        }
        this.canvas.oncontextmenu = function() {
          if (!cc._isContextMenuEnable) return false;
        };
        this._rendererInitialized = true;
      },
      _initEvents: function _initEvents() {
        var win = window, hiddenPropName;
        this.config.registerSystemEvent && inputManager.registerSystemEvent(this.canvas);
        "undefined" !== typeof document.hidden ? hiddenPropName = "hidden" : "undefined" !== typeof document.mozHidden ? hiddenPropName = "mozHidden" : "undefined" !== typeof document.msHidden ? hiddenPropName = "msHidden" : "undefined" !== typeof document.webkitHidden && (hiddenPropName = "webkitHidden");
        var hidden = false;
        function onHidden() {
          if (!hidden) {
            hidden = true;
            game.emit(game.EVENT_HIDE);
          }
        }
        function onShown(arg0, arg1, arg2, arg3, arg4) {
          if (hidden) {
            hidden = false;
            game.emit(game.EVENT_SHOW, arg0, arg1, arg2, arg3, arg4);
          }
        }
        if (hiddenPropName) {
          var changeList = [ "visibilitychange", "mozvisibilitychange", "msvisibilitychange", "webkitvisibilitychange", "qbrowserVisibilityChange" ];
          for (var i = 0; i < changeList.length; i++) document.addEventListener(changeList[i], (function(event) {
            var visible = document[hiddenPropName];
            visible = visible || event["hidden"];
            visible ? onHidden() : onShown();
          }));
        } else {
          win.addEventListener("blur", onHidden);
          win.addEventListener("focus", onShown);
        }
        navigator.userAgent.indexOf("MicroMessenger") > -1 && (win.onfocus = onShown);
        if (true, cc.sys.browserType !== cc.sys.BROWSER_TYPE_WECHAT_GAME_SUB) {
          wx.onShow && wx.onShow(onShown);
          wx.onAudioInterruptionEnd && wx.onAudioInterruptionEnd(onShown);
          wx.onHide && wx.onHide(onHidden);
          wx.onAudioInterruptionBegin && wx.onAudioInterruptionBegin(onHidden);
        }
        if ("onpageshow" in window && "onpagehide" in window) {
          win.addEventListener("pagehide", onHidden);
          win.addEventListener("pageshow", onShown);
          document.addEventListener("pagehide", onHidden);
          document.addEventListener("pageshow", onShown);
        }
        this.on(game.EVENT_HIDE, (function() {
          game.pause();
        }));
        this.on(game.EVENT_SHOW, (function() {
          game.resume();
        }));
      }
    };
    EventTarget.call(game);
    cc.js.addon(game, EventTarget.prototype);
    cc.game = module.exports = game;
  }), {
    "../audio/CCAudioEngine": void 0,
    "../core/renderer/utils/dynamic-atlas/manager": 164,
    "./CCDebug": 26,
    "./event/event-target": 86,
    "./platform/BKInputManager": 116,
    "./platform/CCInputManager": 122,
    "./renderer/index.js": 161
  } ],
  29: [ (function(require, module, exports) {
    "use strict";
    var _vmath = require("./vmath");
    var BaseNode = require("./utils/base-node");
    var PrefabHelper = require("./utils/prefab-helper");
    var mathPools = require("./utils/math-pools");
    var AffineTrans = require("./utils/affine-transform");
    var eventManager = require("./event-manager");
    var macro = require("./platform/CCMacro");
    var js = require("./platform/js");
    var Event = require("./event/event");
    var EventTarget = require("./event/event-target");
    var RenderFlow = require("./renderer/render-flow");
    var Flags = cc.Object.Flags;
    var Destroying = Flags.Destroying;
    var ERR_INVALID_NUMBER = false;
    var ONE_DEGREE = Math.PI / 180;
    var ActionManagerExist = !!cc.ActionManager;
    var emptyFunc = function emptyFunc() {};
    var _vec2a = cc.v2();
    var _vec2b = cc.v2();
    var _mat4_temp = _vmath.mat4.create();
    var _vec3_temp = _vmath.vec3.create();
    var _quat_temp = _vmath.quat.create();
    var _globalOrderOfArrival = 1;
    var _cachedArray = new Array(16);
    _cachedArray.length = 0;
    var POSITION_ON = 1;
    var SCALE_ON = 2;
    var ROTATION_ON = 4;
    var SIZE_ON = 8;
    var ANCHOR_ON = 16;
    var COLOR_ON = 32;
    var BuiltinGroupIndex = cc.Enum({
      DEBUG: 31
    });
    var LocalDirtyFlag = cc.Enum({
      POSITION: 1,
      SCALE: 2,
      ROTATION: 4,
      SKEW: 8,
      RT: 7,
      ALL: 65535
    });
    var EventType = cc.Enum({
      TOUCH_START: "touchstart",
      TOUCH_MOVE: "touchmove",
      TOUCH_END: "touchend",
      TOUCH_CANCEL: "touchcancel",
      MOUSE_DOWN: "mousedown",
      MOUSE_MOVE: "mousemove",
      MOUSE_ENTER: "mouseenter",
      MOUSE_LEAVE: "mouseleave",
      MOUSE_UP: "mouseup",
      MOUSE_WHEEL: "mousewheel",
      POSITION_CHANGED: "position-changed",
      ROTATION_CHANGED: "rotation-changed",
      SCALE_CHANGED: "scale-changed",
      SIZE_CHANGED: "size-changed",
      ANCHOR_CHANGED: "anchor-changed",
      COLOR_CHANGED: "color-changed",
      CHILD_ADDED: "child-added",
      CHILD_REMOVED: "child-removed",
      CHILD_REORDER: "child-reorder",
      GROUP_CHANGED: "group-changed"
    });
    var _touchEvents = [ EventType.TOUCH_START, EventType.TOUCH_MOVE, EventType.TOUCH_END, EventType.TOUCH_CANCEL ];
    var _mouseEvents = [ EventType.MOUSE_DOWN, EventType.MOUSE_ENTER, EventType.MOUSE_MOVE, EventType.MOUSE_LEAVE, EventType.MOUSE_UP, EventType.MOUSE_WHEEL ];
    var _currentHovered = null;
    var _touchStartHandler = function _touchStartHandler(touch, event) {
      var pos = touch.getLocation();
      var node = this.owner;
      if (node._hitTest(pos, this)) {
        event.type = EventType.TOUCH_START;
        event.touch = touch;
        event.bubbles = true;
        node.dispatchEvent(event);
        return true;
      }
      return false;
    };
    var _touchMoveHandler = function _touchMoveHandler(touch, event) {
      var node = this.owner;
      event.type = EventType.TOUCH_MOVE;
      event.touch = touch;
      event.bubbles = true;
      node.dispatchEvent(event);
    };
    var _touchEndHandler = function _touchEndHandler(touch, event) {
      var pos = touch.getLocation();
      var node = this.owner;
      node._hitTest(pos, this) ? event.type = EventType.TOUCH_END : event.type = EventType.TOUCH_CANCEL;
      event.touch = touch;
      event.bubbles = true;
      node.dispatchEvent(event);
    };
    var _touchCancelHandler = function _touchCancelHandler(touch, event) {
      var pos = touch.getLocation();
      var node = this.owner;
      event.type = EventType.TOUCH_CANCEL;
      event.touch = touch;
      event.bubbles = true;
      node.dispatchEvent(event);
    };
    var _mouseDownHandler = function _mouseDownHandler(event) {
      var pos = event.getLocation();
      var node = this.owner;
      if (node._hitTest(pos, this)) {
        event.type = EventType.MOUSE_DOWN;
        event.bubbles = true;
        node.dispatchEvent(event);
      }
    };
    var _mouseMoveHandler = function _mouseMoveHandler(event) {
      var pos = event.getLocation();
      var node = this.owner;
      var hit = node._hitTest(pos, this);
      if (hit) {
        if (!this._previousIn) {
          if (_currentHovered && _currentHovered._mouseListener) {
            event.type = EventType.MOUSE_LEAVE;
            _currentHovered.dispatchEvent(event);
            _currentHovered._mouseListener._previousIn = false;
          }
          _currentHovered = this.owner;
          event.type = EventType.MOUSE_ENTER;
          node.dispatchEvent(event);
          this._previousIn = true;
        }
        event.type = EventType.MOUSE_MOVE;
        event.bubbles = true;
        node.dispatchEvent(event);
      } else {
        if (!this._previousIn) return;
        event.type = EventType.MOUSE_LEAVE;
        node.dispatchEvent(event);
        this._previousIn = false;
        _currentHovered = null;
      }
      event.stopPropagation();
    };
    var _mouseUpHandler = function _mouseUpHandler(event) {
      var pos = event.getLocation();
      var node = this.owner;
      if (node._hitTest(pos, this)) {
        event.type = EventType.MOUSE_UP;
        event.bubbles = true;
        node.dispatchEvent(event);
        event.stopPropagation();
      }
    };
    var _mouseWheelHandler = function _mouseWheelHandler(event) {
      var pos = event.getLocation();
      var node = this.owner;
      if (node._hitTest(pos, this)) {
        event.type = EventType.MOUSE_WHEEL;
        event.bubbles = true;
        node.dispatchEvent(event);
        event.stopPropagation();
      }
    };
    function _searchMaskInParent(node) {
      var Mask = cc.Mask;
      if (Mask) {
        var index = 0;
        for (var curr = node; curr && cc.Node.isNode(curr); curr = curr._parent, ++index) if (curr.getComponent(Mask)) return {
          index: index,
          node: curr
        };
      }
      return null;
    }
    function _checkListeners(node, events) {
      if (!(node._objFlags & Destroying)) {
        var i = 0;
        if (node._bubblingListeners) for (;i < events.length; ++i) if (node._bubblingListeners.hasEventListener(events[i])) return true;
        if (node._capturingListeners) for (;i < events.length; ++i) if (node._capturingListeners.hasEventListener(events[i])) return true;
        return false;
      }
      return true;
    }
    function _doDispatchEvent(owner, event) {
      var target, i;
      event.target = owner;
      _cachedArray.length = 0;
      owner._getCapturingTargets(event.type, _cachedArray);
      event.eventPhase = 1;
      for (i = _cachedArray.length - 1; i >= 0; --i) {
        target = _cachedArray[i];
        if (target._capturingListeners) {
          event.currentTarget = target;
          target._capturingListeners.emit(event.type, event, _cachedArray);
          if (event._propagationStopped) {
            _cachedArray.length = 0;
            return;
          }
        }
      }
      _cachedArray.length = 0;
      event.eventPhase = 2;
      event.currentTarget = owner;
      owner._capturingListeners && owner._capturingListeners.emit(event.type, event);
      !event._propagationImmediateStopped && owner._bubblingListeners && owner._bubblingListeners.emit(event.type, event);
      if (!event._propagationStopped && event.bubbles) {
        owner._getBubblingTargets(event.type, _cachedArray);
        event.eventPhase = 3;
        for (i = 0; i < _cachedArray.length; ++i) {
          target = _cachedArray[i];
          if (target._bubblingListeners) {
            event.currentTarget = target;
            target._bubblingListeners.emit(event.type, event);
            if (event._propagationStopped) {
              _cachedArray.length = 0;
              return;
            }
          }
        }
      }
      _cachedArray.length = 0;
    }
    function _getActualGroupIndex(node) {
      var groupIndex = node.groupIndex;
      0 === groupIndex && node.parent && (groupIndex = _getActualGroupIndex(node.parent));
      return groupIndex;
    }
    function _updateCullingMask(node) {
      var index = _getActualGroupIndex(node);
      node._cullingMask = 1 << index;
      for (var i = 0; i < node._children.length; i++) _updateCullingMask(node._children[i]);
    }
    var NodeDefines = {
      name: "cc.Node",
      extends: BaseNode,
      properties: {
        _opacity: 255,
        _color: cc.Color.WHITE,
        _contentSize: cc.Size,
        _anchorPoint: cc.v2(.5, .5),
        _position: cc.Vec3,
        _scale: cc.Vec3.ONE,
        _eulerAngles: cc.Vec3,
        _skewX: 0,
        _skewY: 0,
        _zIndex: {
          default: void 0,
          type: cc.Integer
        },
        _localZOrder: {
          default: 0,
          serializable: false
        },
        _is3DNode: false,
        groupIndex: {
          default: 0,
          type: cc.Integer
        },
        group: {
          get: function get() {
            return cc.game.groupList[this.groupIndex] || "";
          },
          set: function set(value) {
            this.groupIndex = cc.game.groupList.indexOf(value);
            _updateCullingMask(this);
            this.emit(EventType.GROUP_CHANGED, this);
          }
        },
        x: {
          get: function get() {
            return this._position.x;
          },
          set: function set(value) {
            var localPosition = this._position;
            if (value !== localPosition.x) {
              true;
              var oldValue;
              false;
              localPosition.x = value;
              this.setLocalDirty(LocalDirtyFlag.POSITION);
              this._renderFlag |= RenderFlow.FLAG_WORLD_TRANSFORM;
              if (this._eventMask & POSITION_ON) {
                false;
                this.emit(EventType.POSITION_CHANGED);
              }
            }
          }
        },
        y: {
          get: function get() {
            return this._position.y;
          },
          set: function set(value) {
            var localPosition = this._position;
            if (value !== localPosition.y) {
              true;
              var oldValue;
              false;
              localPosition.y = value;
              this.setLocalDirty(LocalDirtyFlag.POSITION);
              this._renderFlag |= RenderFlow.FLAG_WORLD_TRANSFORM;
              if (this._eventMask & POSITION_ON) {
                false;
                this.emit(EventType.POSITION_CHANGED);
              }
            }
          }
        },
        rotation: {
          get: function get() {
            true;
            cc.warn("`cc.Node.rotation` is deprecated since v2.1.0, please use `-angle` instead. (`this.node.rotation` -> `-this.node.angle`)");
            return -this.angle;
          },
          set: function set(value) {
            true;
            cc.warn("`cc.Node.rotation` is deprecated since v2.1.0, please set `-angle` instead. (`this.node.rotation = x` -> `this.node.angle = -x`)");
            this.angle = -value;
          }
        },
        angle: {
          get: function get() {
            return this._eulerAngles.z;
          },
          set: function set(value) {
            _vmath.vec3.set(this._eulerAngles, 0, 0, value);
            _vmath.quat.fromAngleZ(this._quat, value);
            this.setLocalDirty(LocalDirtyFlag.ROTATION);
            this._renderFlag |= RenderFlow.FLAG_TRANSFORM;
            this._eventMask & ROTATION_ON && this.emit(EventType.ROTATION_CHANGED);
          }
        },
        rotationX: {
          get: function get() {
            true;
            cc.warn("`cc.Node.rotationX` is deprecated since v2.1.0, please use `eulerAngles.x` instead. (`this.node.rotationX` -> `this.node.eulerAngles.x`)");
            return this._eulerAngles.x;
          },
          set: function set(value) {
            true;
            cc.warn("`cc.Node.rotationX` is deprecated since v2.1.0, please set `eulerAngles` instead. (`this.node.rotationX = x` -> `this.node.is3DNode = true; this.node.eulerAngles = cc.v3(x, 0, 0)`");
            if (this._eulerAngles.x !== value) {
              this._eulerAngles.x = value;
              this._eulerAngles.x === this._eulerAngles.y ? _vmath.quat.fromAngleZ(this._quat, -value) : _vmath.quat.fromEuler(this._quat, value, this._eulerAngles.y, 0);
              this.setLocalDirty(LocalDirtyFlag.ROTATION);
              this._renderFlag |= RenderFlow.FLAG_TRANSFORM;
              this._eventMask & ROTATION_ON && this.emit(EventType.ROTATION_CHANGED);
            }
          }
        },
        rotationY: {
          get: function get() {
            true;
            cc.warn("`cc.Node.rotationY` is deprecated since v2.1.0, please use `eulerAngles.y` instead. (`this.node.rotationY` -> `this.node.eulerAngles.y`)");
            return this._eulerAngles.y;
          },
          set: function set(value) {
            true;
            cc.warn("`cc.Node.rotationY` is deprecated since v2.1.0, please set `eulerAngles` instead. (`this.node.rotationY = y` -> `this.node.is3DNode = true; this.node.eulerAngles = cc.v3(0, y, 0)`");
            if (this._eulerAngles.y !== value) {
              this._eulerAngles.y = value;
              this._eulerAngles.x === this._eulerAngles.y ? _vmath.quat.fromAngleZ(this._quat, -value) : _vmath.quat.fromEuler(this._quat, this._eulerAngles.x, value, 0);
              this.setLocalDirty(LocalDirtyFlag.ROTATION);
              this._renderFlag |= RenderFlow.FLAG_TRANSFORM;
              this._eventMask & ROTATION_ON && this.emit(EventType.ROTATION_CHANGED);
            }
          }
        },
        scale: {
          get: function get() {
            return this._scale.x;
          },
          set: function set(v) {
            this.setScale(v);
          }
        },
        scaleX: {
          get: function get() {
            return this._scale.x;
          },
          set: function set(value) {
            if (this._scale.x !== value) {
              this._scale.x = value;
              this.setLocalDirty(LocalDirtyFlag.SCALE);
              this._renderFlag |= RenderFlow.FLAG_TRANSFORM;
              this._eventMask & SCALE_ON && this.emit(EventType.SCALE_CHANGED);
            }
          }
        },
        scaleY: {
          get: function get() {
            return this._scale.y;
          },
          set: function set(value) {
            if (this._scale.y !== value) {
              this._scale.y = value;
              this.setLocalDirty(LocalDirtyFlag.SCALE);
              this._renderFlag |= RenderFlow.FLAG_TRANSFORM;
              this._eventMask & SCALE_ON && this.emit(EventType.SCALE_CHANGED);
            }
          }
        },
        skewX: {
          get: function get() {
            return this._skewX;
          },
          set: function set(value) {
            this._skewX = value;
            this.setLocalDirty(LocalDirtyFlag.SKEW);
            this._renderFlag |= RenderFlow.FLAG_TRANSFORM;
          }
        },
        skewY: {
          get: function get() {
            return this._skewY;
          },
          set: function set(value) {
            this._skewY = value;
            this.setLocalDirty(LocalDirtyFlag.SKEW);
            this._renderFlag |= RenderFlow.FLAG_TRANSFORM;
          }
        },
        opacity: {
          get: function get() {
            return this._opacity;
          },
          set: function set(value) {
            value = cc.misc.clampf(value, 0, 255);
            if (this._opacity !== value) {
              this._opacity = value;
              this._renderFlag |= RenderFlow.FLAG_OPACITY;
            }
          },
          range: [ 0, 255 ]
        },
        color: {
          get: function get() {
            return this._color.clone();
          },
          set: function set(value) {
            if (!this._color.equals(value)) {
              this._color.set(value);
              false;
              this._eventMask & COLOR_ON && this.emit(EventType.COLOR_CHANGED, value);
            }
          }
        },
        anchorX: {
          get: function get() {
            return this._anchorPoint.x;
          },
          set: function set(value) {
            var anchorPoint = this._anchorPoint;
            if (anchorPoint.x !== value) {
              anchorPoint.x = value;
              this._eventMask & ANCHOR_ON && this.emit(EventType.ANCHOR_CHANGED);
            }
          }
        },
        anchorY: {
          get: function get() {
            return this._anchorPoint.y;
          },
          set: function set(value) {
            var anchorPoint = this._anchorPoint;
            if (anchorPoint.y !== value) {
              anchorPoint.y = value;
              this._eventMask & ANCHOR_ON && this.emit(EventType.ANCHOR_CHANGED);
            }
          }
        },
        width: {
          get: function get() {
            return this._contentSize.width;
          },
          set: function set(value) {
            if (value !== this._contentSize.width) {
              var clone;
              false;
              this._contentSize.width = value;
              if (this._eventMask & SIZE_ON) {
                false;
                this.emit(EventType.SIZE_CHANGED);
              }
            }
          }
        },
        height: {
          get: function get() {
            return this._contentSize.height;
          },
          set: function set(value) {
            if (value !== this._contentSize.height) {
              var clone;
              false;
              this._contentSize.height = value;
              if (this._eventMask & SIZE_ON) {
                false;
                this.emit(EventType.SIZE_CHANGED);
              }
            }
          }
        },
        zIndex: {
          get: function get() {
            return this._localZOrder >> 16;
          },
          set: function set(value) {
            if (value > macro.MAX_ZINDEX) {
              cc.warnID(1636);
              value = macro.MAX_ZINDEX;
            } else if (value < macro.MIN_ZINDEX) {
              cc.warnID(1637);
              value = macro.MIN_ZINDEX;
            }
            if (this.zIndex !== value) {
              this._localZOrder = 65535 & this._localZOrder | value << 16;
              this._parent && this._onSiblingIndexChanged();
            }
          }
        }
      },
      ctor: function ctor() {
        this._reorderChildDirty = false;
        this._widget = null;
        this._renderComponent = null;
        this._capturingListeners = null;
        this._bubblingListeners = null;
        this._touchListener = null;
        this._mouseListener = null;
        this._matrix = mathPools.mat4.get();
        this._worldMatrix = mathPools.mat4.get();
        this._localMatDirty = LocalDirtyFlag.ALL;
        this._worldMatDirty = true;
        this._eventMask = 0;
        this._cullingMask = 1;
        this._childArrivalOrder = 1;
        this._quat = cc.quat();
      },
      statics: {
        EventType: EventType,
        _LocalDirtyFlag: LocalDirtyFlag,
        isNode: function isNode(obj) {
          return obj instanceof Node && (obj.constructor === Node || !(obj instanceof cc.Scene));
        },
        BuiltinGroupIndex: BuiltinGroupIndex
      },
      _onSiblingIndexChanged: function _onSiblingIndexChanged() {
        var parent = this._parent;
        var siblings = parent._children;
        var i = 0, len = siblings.length, sibling;
        for (;i < len; i++) {
          sibling = siblings[i];
          sibling._updateOrderOfArrival();
        }
        parent._delaySort();
      },
      _onPreDestroy: function _onPreDestroy() {
        var destroyByParent = this._onPreDestroyBase();
        ActionManagerExist && cc.director.getActionManager().removeAllActionsFromTarget(this);
        _currentHovered === this && (_currentHovered = null);
        if (this._touchListener || this._mouseListener) {
          eventManager.removeListeners(this);
          if (this._touchListener) {
            this._touchListener.owner = null;
            this._touchListener.mask = null;
            this._touchListener = null;
          }
          if (this._mouseListener) {
            this._mouseListener.owner = null;
            this._mouseListener.mask = null;
            this._mouseListener = null;
          }
        }
        mathPools.mat4.put(this._matrix);
        mathPools.mat4.put(this._worldMatrix);
        this._matrix = this._worldMatrix = null;
        this._reorderChildDirty && cc.director.__fastOff(cc.Director.EVENT_AFTER_UPDATE, this.sortAllChildren, this);
        destroyByParent || false;
      },
      _onPostActivated: function _onPostActivated(active) {
        var actionManager = ActionManagerExist ? cc.director.getActionManager() : null;
        if (active) {
          this._renderFlag |= RenderFlow.FLAG_WORLD_TRANSFORM;
          actionManager && actionManager.resumeTarget(this);
          eventManager.resumeTarget(this);
          if (this._touchListener) {
            var mask = this._touchListener.mask = _searchMaskInParent(this);
            this._mouseListener && (this._mouseListener.mask = mask);
          } else this._mouseListener && (this._mouseListener.mask = _searchMaskInParent(this));
        } else {
          actionManager && actionManager.pauseTarget(this);
          eventManager.pauseTarget(this);
        }
      },
      _onHierarchyChanged: function _onHierarchyChanged(oldParent) {
        this._updateOrderOfArrival();
        _updateCullingMask(this);
        this._parent && this._parent._delaySort();
        this._renderFlag |= RenderFlow.FLAG_WORLD_TRANSFORM;
        this._onHierarchyChangedBase(oldParent);
        cc._widgetManager && (cc._widgetManager._nodesOrderDirty = true);
      },
      _toEuler: function _toEuler() {
        if (this.is3DNode) this._quat.toEuler(this._eulerAngles); else {
          var z = Math.asin(this._quat.z) / ONE_DEGREE * 2;
          _vmath.vec3.set(this._eulerAngles, 0, 0, z);
        }
      },
      _fromEuler: function _fromEuler() {
        this.is3DNode ? this._quat.fromEuler(this._eulerAngles) : _vmath.quat.fromAngleZ(this._quat, this._eulerAngles.z);
      },
      _upgrade_1x_to_2x: function _upgrade_1x_to_2x() {
        if (void 0 !== this._scaleX) {
          this._scale.x = this._scaleX;
          this._scaleX = void 0;
        }
        if (void 0 !== this._scaleY) {
          this._scale.y = this._scaleY;
          this._scaleY = void 0;
        }
        if (void 0 !== this._zIndex) {
          this._localZOrder = this._zIndex << 16;
          this._zIndex = void 0;
        }
        var eulerAngles = this._eulerAngles;
        if ((this._rotationX || this._rotationY) && 0 === eulerAngles.x && 0 === eulerAngles.y && 0 === eulerAngles.z) {
          if (this._rotationX === this._rotationY) eulerAngles.z = -this._rotationX; else {
            eulerAngles.x = this._rotationX;
            eulerAngles.y = this._rotationY;
          }
          this._rotationX = this._rotationY = void 0;
        }
        this._fromEuler();
        if (this._color.a < 255 && 255 === this._opacity) {
          this._opacity = this._color.a;
          this._color.a = 255;
        }
      },
      _onBatchCreated: function _onBatchCreated() {
        var prefabInfo = this._prefab;
        if (prefabInfo && prefabInfo.sync && prefabInfo.root === this) {
          false;
          PrefabHelper.syncWithPrefab(this);
        }
        this._upgrade_1x_to_2x();
        this._updateOrderOfArrival();
        this._cullingMask = 1 << _getActualGroupIndex(this);
        if (!this._activeInHierarchy) {
          ActionManagerExist && cc.director.getActionManager().pauseTarget(this);
          eventManager.pauseTarget(this);
        }
        var children = this._children;
        for (var i = 0, len = children.length; i < len; i++) children[i]._onBatchCreated();
        children.length > 0 && (this._renderFlag |= RenderFlow.FLAG_CHILDREN);
      },
      _onBatchRestored: function _onBatchRestored() {
        this._upgrade_1x_to_2x();
        this._cullingMask = 1 << _getActualGroupIndex(this);
        if (!this._activeInHierarchy) {
          var manager = cc.director.getActionManager();
          manager && manager.pauseTarget(this);
          eventManager.pauseTarget(this);
        }
        var children = this._children;
        for (var i = 0, len = children.length; i < len; i++) children[i]._onBatchRestored();
        children.length > 0 && (this._renderFlag |= RenderFlow.FLAG_CHILDREN);
      },
      _checknSetupSysEvent: function _checknSetupSysEvent(type) {
        var newAdded = false;
        var forDispatch = false;
        if (-1 !== _touchEvents.indexOf(type)) {
          if (!this._touchListener) {
            this._touchListener = cc.EventListener.create({
              event: cc.EventListener.TOUCH_ONE_BY_ONE,
              swallowTouches: true,
              owner: this,
              mask: _searchMaskInParent(this),
              onTouchBegan: _touchStartHandler,
              onTouchMoved: _touchMoveHandler,
              onTouchEnded: _touchEndHandler,
              onTouchCancelled: _touchCancelHandler
            });
            eventManager.addListener(this._touchListener, this);
            newAdded = true;
          }
          forDispatch = true;
        } else if (-1 !== _mouseEvents.indexOf(type)) {
          if (!this._mouseListener) {
            this._mouseListener = cc.EventListener.create({
              event: cc.EventListener.MOUSE,
              _previousIn: false,
              owner: this,
              mask: _searchMaskInParent(this),
              onMouseDown: _mouseDownHandler,
              onMouseMove: _mouseMoveHandler,
              onMouseUp: _mouseUpHandler,
              onMouseScroll: _mouseWheelHandler
            });
            eventManager.addListener(this._mouseListener, this);
            newAdded = true;
          }
          forDispatch = true;
        }
        newAdded && !this._activeInHierarchy && cc.director.getScheduler().schedule((function() {
          this._activeInHierarchy || eventManager.pauseTarget(this);
        }), this, 0, 0, 0, false);
        return forDispatch;
      },
      on: function on(type, callback, target, useCapture) {
        var forDispatch = this._checknSetupSysEvent(type);
        if (forDispatch) return this._onDispatch(type, callback, target, useCapture);
        switch (type) {
         case EventType.POSITION_CHANGED:
          this._eventMask |= POSITION_ON;
          break;

         case EventType.SCALE_CHANGED:
          this._eventMask |= SCALE_ON;
          break;

         case EventType.ROTATION_CHANGED:
          this._eventMask |= ROTATION_ON;
          break;

         case EventType.SIZE_CHANGED:
          this._eventMask |= SIZE_ON;
          break;

         case EventType.ANCHOR_CHANGED:
          this._eventMask |= ANCHOR_ON;
          break;

         case EventType.COLOR_CHANGED:
          this._eventMask |= COLOR_ON;
        }
        this._bubblingListeners || (this._bubblingListeners = new EventTarget());
        return this._bubblingListeners.on(type, callback, target);
      },
      once: function once(type, callback, target, useCapture) {
        var forDispatch = this._checknSetupSysEvent(type);
        var eventType_hasOnceListener = "__ONCE_FLAG:" + type;
        var listeners = null;
        listeners = forDispatch && useCapture ? this._capturingListeners = this._capturingListeners || new EventTarget() : this._bubblingListeners = this._bubblingListeners || new EventTarget();
        var hasOnceListener = listeners.hasEventListener(eventType_hasOnceListener, callback, target);
        if (!hasOnceListener) {
          var self = this;
          var onceWrapper = function onceWrapper(arg1, arg2, arg3, arg4, arg5) {
            self.off(type, onceWrapper, target);
            listeners.remove(eventType_hasOnceListener, callback, target);
            callback.call(this, arg1, arg2, arg3, arg4, arg5);
          };
          this.on(type, onceWrapper, target);
          listeners.add(eventType_hasOnceListener, callback, target);
        }
      },
      _onDispatch: function _onDispatch(type, callback, target, useCapture) {
        if ("boolean" === typeof target) {
          useCapture = target;
          target = void 0;
        } else useCapture = !!useCapture;
        if (!callback) {
          cc.errorID(6800);
          return;
        }
        var listeners = null;
        listeners = useCapture ? this._capturingListeners = this._capturingListeners || new EventTarget() : this._bubblingListeners = this._bubblingListeners || new EventTarget();
        if (!listeners.hasEventListener(type, callback, target)) {
          listeners.add(type, callback, target);
          target && target.__eventTargets && target.__eventTargets.push(this);
        }
        return callback;
      },
      off: function off(type, callback, target, useCapture) {
        var touchEvent = -1 !== _touchEvents.indexOf(type);
        var mouseEvent = !touchEvent && -1 !== _mouseEvents.indexOf(type);
        if (touchEvent || mouseEvent) {
          this._offDispatch(type, callback, target, useCapture);
          if (touchEvent) {
            if (this._touchListener && !_checkListeners(this, _touchEvents)) {
              eventManager.removeListener(this._touchListener);
              this._touchListener = null;
            }
          } else if (mouseEvent && this._mouseListener && !_checkListeners(this, _mouseEvents)) {
            eventManager.removeListener(this._mouseListener);
            this._mouseListener = null;
          }
        } else if (this._bubblingListeners) {
          this._bubblingListeners.off(type, callback, target);
          var hasListeners = this._bubblingListeners.hasEventListener(type);
          if (!hasListeners) switch (type) {
           case EventType.POSITION_CHANGED:
            this._eventMask &= ~POSITION_ON;
            break;

           case EventType.SCALE_CHANGED:
            this._eventMask &= ~SCALE_ON;
            break;

           case EventType.ROTATION_CHANGED:
            this._eventMask &= ~ROTATION_ON;
            break;

           case EventType.SIZE_CHANGED:
            this._eventMask &= ~SIZE_ON;
            break;

           case EventType.ANCHOR_CHANGED:
            this._eventMask &= ~ANCHOR_ON;
            break;

           case EventType.COLOR_CHANGED:
            this._eventMask &= ~COLOR_ON;
          }
        }
      },
      _offDispatch: function _offDispatch(type, callback, target, useCapture) {
        if ("boolean" === typeof target) {
          useCapture = target;
          target = void 0;
        } else useCapture = !!useCapture;
        if (callback) {
          var listeners = useCapture ? this._capturingListeners : this._bubblingListeners;
          if (listeners) {
            listeners.remove(type, callback, target);
            target && target.__eventTargets && js.array.fastRemove(target.__eventTargets, this);
          }
        } else {
          this._capturingListeners && this._capturingListeners.removeAll(type);
          this._bubblingListeners && this._bubblingListeners.removeAll(type);
        }
      },
      targetOff: function targetOff(target) {
        var listeners = this._bubblingListeners;
        if (listeners) {
          listeners.targetOff(target);
          this._eventMask & POSITION_ON && !listeners.hasEventListener(EventType.POSITION_CHANGED) && (this._eventMask &= ~POSITION_ON);
          this._eventMask & SCALE_ON && !listeners.hasEventListener(EventType.SCALE_CHANGED) && (this._eventMask &= ~SCALE_ON);
          this._eventMask & ROTATION_ON && !listeners.hasEventListener(EventType.ROTATION_CHANGED) && (this._eventMask &= ~ROTATION_ON);
          this._eventMask & SIZE_ON && !listeners.hasEventListener(EventType.SIZE_CHANGED) && (this._eventMask &= ~SIZE_ON);
          this._eventMask & ANCHOR_ON && !listeners.hasEventListener(EventType.ANCHOR_CHANGED) && (this._eventMask &= ~ANCHOR_ON);
          this._eventMask & COLOR_ON && !listeners.hasEventListener(EventType.COLOR_CHANGED) && (this._eventMask &= ~COLOR_ON);
        }
        this._capturingListeners && this._capturingListeners.targetOff(target);
        if (this._touchListener && !_checkListeners(this, _touchEvents)) {
          eventManager.removeListener(this._touchListener);
          this._touchListener = null;
        }
        if (this._mouseListener && !_checkListeners(this, _mouseEvents)) {
          eventManager.removeListener(this._mouseListener);
          this._mouseListener = null;
        }
      },
      hasEventListener: function hasEventListener(type) {
        var has = false;
        this._bubblingListeners && (has = this._bubblingListeners.hasEventListener(type));
        !has && this._capturingListeners && (has = this._capturingListeners.hasEventListener(type));
        return has;
      },
      emit: function emit(type, arg1, arg2, arg3, arg4, arg5) {
        this._bubblingListeners && this._bubblingListeners.emit(type, arg1, arg2, arg3, arg4, arg5);
      },
      dispatchEvent: function dispatchEvent(event) {
        _doDispatchEvent(this, event);
        _cachedArray.length = 0;
      },
      pauseSystemEvents: function pauseSystemEvents(recursive) {
        eventManager.pauseTarget(this, recursive);
      },
      resumeSystemEvents: function resumeSystemEvents(recursive) {
        eventManager.resumeTarget(this, recursive);
      },
      _hitTest: function _hitTest(point, listener) {
        var w = this._contentSize.width, h = this._contentSize.height, cameraPt = _vec2a, testPt = _vec2b;
        var camera = cc.Camera.findCamera(this);
        camera ? camera.getCameraToWorldPoint(point, cameraPt) : cameraPt.set(point);
        this._updateWorldMatrix();
        if (!_vmath.mat4.invert(_mat4_temp, this._worldMatrix)) return false;
        _vmath.vec2.transformMat4(testPt, cameraPt, _mat4_temp);
        testPt.x += this._anchorPoint.x * w;
        testPt.y += this._anchorPoint.y * h;
        if (testPt.x >= 0 && testPt.y >= 0 && testPt.x <= w && testPt.y <= h) {
          if (listener && listener.mask) {
            var mask = listener.mask;
            var parent = this;
            for (var i = 0; parent && i < mask.index; ++i, parent = parent.parent) ;
            if (parent === mask.node) {
              var comp = parent.getComponent(cc.Mask);
              return !comp || !comp.enabledInHierarchy || comp._hitTest(cameraPt);
            }
            listener.mask = null;
            return true;
          }
          return true;
        }
        return false;
      },
      _getCapturingTargets: function _getCapturingTargets(type, array) {
        var parent = this.parent;
        while (parent) {
          parent._capturingListeners && parent._capturingListeners.hasEventListener(type) && array.push(parent);
          parent = parent.parent;
        }
      },
      _getBubblingTargets: function _getBubblingTargets(type, array) {
        var parent = this.parent;
        while (parent) {
          parent._bubblingListeners && parent._bubblingListeners.hasEventListener(type) && array.push(parent);
          parent = parent.parent;
        }
      },
      runAction: ActionManagerExist ? function(action) {
        if (!this.active) return;
        cc.assertID(action, 1618);
        cc.director.getActionManager().addAction(action, this, false);
        return action;
      } : emptyFunc,
      pauseAllActions: ActionManagerExist ? function() {
        cc.director.getActionManager().pauseTarget(this);
      } : emptyFunc,
      resumeAllActions: ActionManagerExist ? function() {
        cc.director.getActionManager().resumeTarget(this);
      } : emptyFunc,
      stopAllActions: ActionManagerExist ? function() {
        cc.director.getActionManager().removeAllActionsFromTarget(this);
      } : emptyFunc,
      stopAction: ActionManagerExist ? function(action) {
        cc.director.getActionManager().removeAction(action);
      } : emptyFunc,
      stopActionByTag: ActionManagerExist ? function(tag) {
        if (tag === cc.Action.TAG_INVALID) {
          cc.logID(1612);
          return;
        }
        cc.director.getActionManager().removeActionByTag(tag, this);
      } : emptyFunc,
      getActionByTag: ActionManagerExist ? function(tag) {
        if (tag === cc.Action.TAG_INVALID) {
          cc.logID(1613);
          return null;
        }
        return cc.director.getActionManager().getActionByTag(tag, this);
      } : function() {
        return null;
      },
      getNumberOfRunningActions: ActionManagerExist ? function() {
        return cc.director.getActionManager().getNumberOfRunningActionsInTarget(this);
      } : function() {
        return 0;
      },
      getPosition: function getPosition(out) {
        out = out || cc.v3();
        return out.set(this._position);
      },
      setPosition: function setPosition(newPosOrX, y) {
        var x;
        if (void 0 === y) {
          x = newPosOrX.x;
          y = newPosOrX.y;
        } else x = newPosOrX;
        var locPosition = this._position;
        if (locPosition.x === x && locPosition.y === y) return;
        var oldPosition;
        false;
        true;
        locPosition.x = x;
        true;
        locPosition.y = y;
        this.setLocalDirty(LocalDirtyFlag.POSITION);
        this._renderFlag |= RenderFlow.FLAG_WORLD_TRANSFORM;
        if (this._eventMask & POSITION_ON) {
          false;
          this.emit(EventType.POSITION_CHANGED);
        }
      },
      getScale: function getScale(out) {
        if (out) return out.set(this._scale);
        true;
        cc.warn("`cc.Node.getScale()` is deprecated since v2.1.0, please use `cc.Node.scale` instead. (`this.node.getScale()` -> `this.node.scale`)");
        return this._scale.x;
      },
      setScale: function setScale(x, y) {
        if (x && "number" !== typeof x) {
          y = x.y;
          x = x.x;
        } else void 0 === y && (y = x);
        if (this._scale.x !== x || this._scale.y !== y) {
          this._scale.x = x;
          this._scale.y = y;
          this.setLocalDirty(LocalDirtyFlag.SCALE);
          this._renderFlag |= RenderFlow.FLAG_TRANSFORM;
          this._eventMask & SCALE_ON && this.emit(EventType.SCALE_CHANGED);
        }
      },
      getRotation: function getRotation(out) {
        if (out instanceof cc.Quat) return out.set(this._quat);
        true;
        cc.warn("`cc.Node.getRotation()` is deprecated since v2.1.0, please use `-cc.Node.angle` instead. (`this.node.getRotation()` -> `-this.node.angle`)");
        return -this.angle;
      },
      setRotation: function setRotation(quat, y, z, w) {
        if ("number" === typeof quat && void 0 === y) {
          true;
          cc.warn("`cc.Node.setRotation(degree)` is deprecated since v2.1.0, please set `-cc.Node.angle` instead. (`this.node.setRotation(x)` -> `this.node.angle = -x`)");
          this.angle = -quat;
        } else {
          var x = quat;
          if (void 0 === y) {
            x = quat.x;
            y = quat.y;
            z = quat.z;
            w = quat.w;
          }
          var old = this._quat;
          if (old.x !== x || old.y !== y || old.z !== z || old.w !== w) {
            old.x = x;
            old.y = y;
            old.z = z;
            old.w = w;
            this.setLocalDirty(LocalDirtyFlag.ROTATION);
            this._renderFlag |= RenderFlow.FLAG_TRANSFORM;
            this._eventMask & ROTATION_ON && this.emit(EventType.ROTATION_CHANGED);
            false;
          }
        }
      },
      getContentSize: function getContentSize() {
        return cc.size(this._contentSize.width, this._contentSize.height);
      },
      setContentSize: function setContentSize(size, height) {
        var locContentSize = this._contentSize;
        var clone;
        if (void 0 === height) {
          if (size.width === locContentSize.width && size.height === locContentSize.height) return;
          false;
          locContentSize.width = size.width;
          locContentSize.height = size.height;
        } else {
          if (size === locContentSize.width && height === locContentSize.height) return;
          false;
          locContentSize.width = size;
          locContentSize.height = height;
        }
        if (this._eventMask & SIZE_ON) {
          false;
          this.emit(EventType.SIZE_CHANGED);
        }
      },
      getAnchorPoint: function getAnchorPoint() {
        return cc.v2(this._anchorPoint);
      },
      setAnchorPoint: function setAnchorPoint(point, y) {
        var locAnchorPoint = this._anchorPoint;
        if (void 0 === y) {
          if (point.x === locAnchorPoint.x && point.y === locAnchorPoint.y) return;
          locAnchorPoint.x = point.x;
          locAnchorPoint.y = point.y;
        } else {
          if (point === locAnchorPoint.x && y === locAnchorPoint.y) return;
          locAnchorPoint.x = point;
          locAnchorPoint.y = y;
        }
        this.setLocalDirty(LocalDirtyFlag.POSITION);
        this._eventMask & ANCHOR_ON && this.emit(EventType.ANCHOR_CHANGED);
      },
      _invTransformPoint: function _invTransformPoint(out, pos) {
        this._parent ? this._parent._invTransformPoint(out, pos) : _vmath.vec3.copy(out, pos);
        _vmath.vec3.sub(out, out, this._position);
        _vmath.quat.conjugate(_quat_temp, this._quat);
        _vmath.vec3.transformQuat(out, out, _quat_temp);
        _vmath.vec3.inverseSafe(_vec3_temp, this._scale);
        _vmath.vec3.mul(out, out, _vec3_temp);
        return out;
      },
      getWorldPosition: function getWorldPosition(out) {
        _vmath.vec3.copy(out, this._position);
        var curr = this._parent;
        while (curr) {
          _vmath.vec3.mul(out, out, curr._scale);
          _vmath.vec3.transformQuat(out, out, curr._quat);
          _vmath.vec3.add(out, out, curr._position);
          curr = curr._parent;
        }
        return out;
      },
      setWorldPosition: function setWorldPosition(pos) {
        var oldPosition;
        false;
        this._parent ? this._parent._invTransformPoint(this._position, pos) : _vmath.vec3.copy(this._position, pos);
        this.setLocalDirty(LocalDirtyFlag.POSITION);
        if (this._eventMask & POSITION_ON) {
          false;
          this.emit(EventType.POSITION_CHANGED);
        }
      },
      getWorldRotation: function getWorldRotation(out) {
        _vmath.quat.copy(out, this._quat);
        var curr = this._parent;
        while (curr) {
          _vmath.quat.mul(out, curr._quat, out);
          curr = curr._parent;
        }
        return out;
      },
      setWorldRotation: function setWorldRotation(val) {
        if (this._parent) {
          this._parent.getWorldRotation(this._quat);
          _vmath.quat.conjugate(this._quat, this._quat);
          _vmath.quat.mul(this._quat, this._quat, val);
        } else _vmath.quat.copy(this._quat, _vmath.quat);
        this._toEuler();
        this.setLocalDirty(LocalDirtyFlag.ROTATION);
      },
      getWorldScale: function getWorldScale(out) {
        _vmath.vec3.copy(out, this._scale);
        var curr = this._parent;
        while (curr) {
          _vmath.vec3.mul(out, out, curr._scale);
          curr = curr._parent;
        }
        return out;
      },
      setWorldScale: function setWorldScale(scale) {
        if (this._parent) {
          this._parent.getWorldScale(this._scale);
          _vmath.vec3.div(this._scale, scale, this._scale);
        } else _vmath.vec3.copy(this._scale, scale);
        this.setLocalDirty(LocalDirtyFlag.SCALE);
      },
      getWorldRT: function getWorldRT(out) {
        var opos = _vec3_temp;
        var orot = _quat_temp;
        _vmath.vec3.copy(opos, this._position);
        _vmath.quat.copy(orot, this._quat);
        var curr = this._parent;
        while (curr) {
          _vmath.vec3.mul(opos, opos, curr._scale);
          _vmath.vec3.transformQuat(opos, opos, curr._quat);
          _vmath.vec3.add(opos, opos, curr._position);
          _vmath.quat.mul(orot, curr._quat, orot);
          curr = curr._parent;
        }
        _vmath.mat4.fromRT(out, orot, opos);
        return out;
      },
      lookAt: function lookAt(pos, up) {
        this.getWorldPosition(_vec3_temp);
        _vmath.vec3.sub(_vec3_temp, _vec3_temp, pos);
        _vmath.vec3.normalize(_vec3_temp, _vec3_temp);
        _vmath.quat.fromViewUp(_quat_temp, _vec3_temp, up);
        this.setWorldRotation(_quat_temp);
      },
      _updateLocalMatrix: function _updateLocalMatrix() {
        var dirtyFlag = this._localMatDirty;
        if (!dirtyFlag) return;
        var t = this._matrix;
        if (dirtyFlag & (LocalDirtyFlag.RT | LocalDirtyFlag.SKEW)) {
          var rotation = -this._eulerAngles.z;
          var hasSkew = this._skewX || this._skewY;
          var sx = this._scale.x, sy = this._scale.y;
          if (rotation || hasSkew) {
            var a = 1, b = 0, c = 0, d = 1;
            if (rotation) {
              var rotationRadians = rotation * ONE_DEGREE;
              c = Math.sin(rotationRadians);
              d = Math.cos(rotationRadians);
              a = d;
              b = -c;
            }
            t.m00 = a *= sx;
            t.m01 = b *= sx;
            t.m04 = c *= sy;
            t.m05 = d *= sy;
            if (hasSkew) {
              var _a = t.m00, _b = t.m01, _c = t.m04, _d = t.m05;
              var skx = Math.tan(this._skewX * ONE_DEGREE);
              var sky = Math.tan(this._skewY * ONE_DEGREE);
              Infinity === skx && (skx = 99999999);
              Infinity === sky && (sky = 99999999);
              t.m00 = _a + _c * sky;
              t.m01 = _b + _d * sky;
              t.m04 = _c + _a * skx;
              t.m05 = _d + _b * skx;
            }
          } else {
            t.m00 = sx;
            t.m01 = 0;
            t.m04 = 0;
            t.m05 = sy;
          }
        }
        t.m12 = this._position.x;
        t.m13 = this._position.y;
        this._localMatDirty = 0;
        this._worldMatDirty = true;
      },
      _calculWorldMatrix: function _calculWorldMatrix() {
        this._localMatDirty && this._updateLocalMatrix();
        var parent = this._parent;
        parent ? this._mulMat(this._worldMatrix, parent._worldMatrix, this._matrix) : _vmath.mat4.copy(this._worldMatrix, this._matrix);
        this._worldMatDirty = false;
      },
      _mulMat: function _mulMat(out, a, b) {
        var aa = a.m00, ab = a.m01, ac = a.m04, ad = a.m05, atx = a.m12, aty = a.m13;
        var ba = b.m00, bb = b.m01, bc = b.m04, bd = b.m05, btx = b.m12, bty = b.m13;
        if (0 !== ab || 0 !== ac) {
          out.m00 = ba * aa + bb * ac;
          out.m01 = ba * ab + bb * ad;
          out.m04 = bc * aa + bd * ac;
          out.m05 = bc * ab + bd * ad;
          out.m12 = aa * btx + ac * bty + atx;
          out.m13 = ab * btx + ad * bty + aty;
        } else {
          out.m00 = ba * aa;
          out.m01 = bb * ad;
          out.m04 = bc * aa;
          out.m05 = bd * ad;
          out.m12 = aa * btx + atx;
          out.m13 = ad * bty + aty;
        }
      },
      _updateWorldMatrix: function _updateWorldMatrix() {
        this._parent && this._parent._updateWorldMatrix();
        if (this._worldMatDirty) {
          this._calculWorldMatrix();
          var children = this._children;
          for (var i = 0, l = children.length; i < l; i++) children[i]._worldMatDirty = true;
        }
      },
      setLocalDirty: function setLocalDirty(flag) {
        this._localMatDirty = this._localMatDirty | flag;
        this._worldMatDirty = true;
      },
      setWorldDirty: function setWorldDirty() {
        this._worldMatDirty = true;
      },
      getLocalMatrix: function getLocalMatrix(out) {
        this._updateLocalMatrix();
        return _vmath.mat4.copy(out, this._matrix);
      },
      getWorldMatrix: function getWorldMatrix(out) {
        this._updateWorldMatrix();
        return _vmath.mat4.copy(out, this._worldMatrix);
      },
      convertToNodeSpace: function convertToNodeSpace(worldPoint) {
        this._updateWorldMatrix();
        _vmath.mat4.invert(_mat4_temp, this._worldMatrix);
        var out = new cc.Vec2();
        _vmath.vec2.transformMat4(out, worldPoint, _mat4_temp);
        out.x += this._anchorPoint.x * this._contentSize.width;
        out.y += this._anchorPoint.y * this._contentSize.height;
        return out;
      },
      convertToWorldSpace: function convertToWorldSpace(nodePoint) {
        this._updateWorldMatrix();
        var out = new cc.Vec2(nodePoint.x - this._anchorPoint.x * this._contentSize.width, nodePoint.y - this._anchorPoint.y * this._contentSize.height);
        return _vmath.vec2.transformMat4(out, out, this._worldMatrix);
      },
      convertToNodeSpaceAR: function convertToNodeSpaceAR(worldPoint) {
        this._updateWorldMatrix();
        _vmath.mat4.invert(_mat4_temp, this._worldMatrix);
        var out = new cc.Vec2();
        return _vmath.vec2.transformMat4(out, worldPoint, _mat4_temp);
      },
      convertToWorldSpaceAR: function convertToWorldSpaceAR(nodePoint) {
        this._updateWorldMatrix();
        var out = new cc.Vec2();
        return _vmath.vec2.transformMat4(out, nodePoint, this._worldMatrix);
      },
      getNodeToParentTransform: function getNodeToParentTransform(out) {
        out || (out = AffineTrans.identity());
        this._updateLocalMatrix();
        var contentSize = this._contentSize;
        _vec3_temp.x = -this._anchorPoint.x * contentSize.width;
        _vec3_temp.y = -this._anchorPoint.y * contentSize.height;
        _vmath.mat4.copy(_mat4_temp, this._matrix);
        _vmath.mat4.translate(_mat4_temp, _mat4_temp, _vec3_temp);
        return AffineTrans.fromMat4(out, _mat4_temp);
      },
      getNodeToParentTransformAR: function getNodeToParentTransformAR(out) {
        out || (out = AffineTrans.identity());
        this._updateLocalMatrix();
        return AffineTrans.fromMat4(out, this._matrix);
      },
      getNodeToWorldTransform: function getNodeToWorldTransform(out) {
        out || (out = AffineTrans.identity());
        this._updateWorldMatrix();
        var contentSize = this._contentSize;
        _vec3_temp.x = -this._anchorPoint.x * contentSize.width;
        _vec3_temp.y = -this._anchorPoint.y * contentSize.height;
        _vmath.mat4.copy(_mat4_temp, this._worldMatrix);
        _vmath.mat4.translate(_mat4_temp, _mat4_temp, _vec3_temp);
        return AffineTrans.fromMat4(out, _mat4_temp);
      },
      getNodeToWorldTransformAR: function getNodeToWorldTransformAR(out) {
        out || (out = AffineTrans.identity());
        this._updateWorldMatrix();
        return AffineTrans.fromMat4(out, this._worldMatrix);
      },
      getParentToNodeTransform: function getParentToNodeTransform(out) {
        out || (out = AffineTrans.identity());
        this._updateLocalMatrix();
        _vmath.mat4.invert(_mat4_temp, this._matrix);
        return AffineTrans.fromMat4(out, _mat4_temp);
      },
      getWorldToNodeTransform: function getWorldToNodeTransform(out) {
        out || (out = AffineTrans.identity());
        this._updateWorldMatrix();
        _vmath.mat4.invert(_mat4_temp, this._worldMatrix);
        return AffineTrans.fromMat4(out, _mat4_temp);
      },
      convertTouchToNodeSpace: function convertTouchToNodeSpace(touch) {
        return this.convertToNodeSpace(touch.getLocation());
      },
      convertTouchToNodeSpaceAR: function convertTouchToNodeSpaceAR(touch) {
        return this.convertToNodeSpaceAR(touch.getLocation());
      },
      getBoundingBox: function getBoundingBox() {
        this._updateLocalMatrix();
        var width = this._contentSize.width;
        var height = this._contentSize.height;
        var rect = cc.rect(-this._anchorPoint.x * width, -this._anchorPoint.y * height, width, height);
        return rect.transformMat4(rect, this._matrix);
      },
      getBoundingBoxToWorld: function getBoundingBoxToWorld() {
        if (this._parent) {
          this._parent._updateWorldMatrix();
          return this._getBoundingBoxTo(this._parent._worldMatrix);
        }
        return this.getBoundingBox();
      },
      _getBoundingBoxTo: function _getBoundingBoxTo(parentMat) {
        this._updateLocalMatrix();
        var width = this._contentSize.width;
        var height = this._contentSize.height;
        var rect = cc.rect(-this._anchorPoint.x * width, -this._anchorPoint.y * height, width, height);
        var parentMat = _vmath.mat4.mul(this._worldMatrix, parentMat, this._matrix);
        rect.transformMat4(rect, parentMat);
        if (!this._children) return rect;
        var locChildren = this._children;
        for (var i = 0; i < locChildren.length; i++) {
          var child = locChildren[i];
          if (child && child.active) {
            var childRect = child._getBoundingBoxTo(parentMat);
            childRect && rect.union(rect, childRect);
          }
        }
        return rect;
      },
      _updateOrderOfArrival: function _updateOrderOfArrival() {
        var arrivalOrder = this._parent ? ++this._parent._childArrivalOrder : 0;
        this._localZOrder = 4294901760 & this._localZOrder | arrivalOrder;
        if (65535 === arrivalOrder) {
          var siblings = this._parent._children;
          siblings.forEach((function(node, index) {
            node._localZOrder = 4294901760 & node._localZOrder | index + 1;
          }));
          this._parent._childArrivalOrder = siblings.length;
        }
      },
      addChild: function addChild(child, zIndex, name) {
        false;
        cc.assertID(child, 1606);
        cc.assertID(null === child._parent, 1605);
        child.parent = this;
        void 0 !== zIndex && (child.zIndex = zIndex);
        void 0 !== name && (child.name = name);
      },
      cleanup: function cleanup() {
        ActionManagerExist && cc.director.getActionManager().removeAllActionsFromTarget(this);
        eventManager.removeListeners(this);
        var i, len = this._children.length, node;
        for (i = 0; i < len; ++i) {
          node = this._children[i];
          node && node.cleanup();
        }
      },
      sortAllChildren: function sortAllChildren() {
        if (this._reorderChildDirty) {
          eventManager._setDirtyForNode(this);
          this._reorderChildDirty = false;
          var _children = this._children;
          if (_children.length > 1) {
            var len = _children.length, i, j, child;
            for (i = 1; i < len; i++) {
              child = _children[i];
              j = i - 1;
              while (j >= 0) {
                if (!(child._localZOrder < _children[j]._localZOrder)) break;
                _children[j + 1] = _children[j];
                j--;
              }
              _children[j + 1] = child;
            }
            this.emit(EventType.CHILD_REORDER, this);
          }
          cc.director.__fastOff(cc.Director.EVENT_AFTER_UPDATE, this.sortAllChildren, this);
        }
      },
      _delaySort: function _delaySort() {
        if (!this._reorderChildDirty) {
          this._reorderChildDirty = true;
          cc.director.__fastOn(cc.Director.EVENT_AFTER_UPDATE, this.sortAllChildren, this);
        }
      },
      _restoreProperties: false,
      onRestore: false
    };
    false;
    var Node = cc.Class(NodeDefines);
    var _p = Node.prototype;
    js.getset(_p, "position", _p.getPosition, _p.setPosition, false, true);
    cc.Node = module.exports = Node;
  }), {
    "./event-manager": 84,
    "./event/event": 87,
    "./event/event-target": 86,
    "./platform/CCMacro": 123,
    "./platform/js": 138,
    "./renderer/render-flow": 162,
    "./utils/affine-transform": 194,
    "./utils/base-node": 195,
    "./utils/math-pools": 203,
    "./utils/prefab-helper": 206,
    "./vmath": 224
  } ],
  30: [ (function(require, module, exports) {
    "use strict";
    var Node = require("./CCNode");
    var RenderFlow = require("./renderer/render-flow");
    var HideInHierarchy = cc.Object.Flags.HideInHierarchy;
    var LocalDirtyFlag = Node._LocalDirtyFlag;
    var POSITION_ON = 1;
    var PrivateNode = cc.Class({
      name: "cc.PrivateNode",
      extends: Node,
      properties: {
        x: {
          get: function get() {
            return this._originPos.x;
          },
          set: function set(value) {
            var localPosition = this._originPos;
            if (value !== localPosition.x) {
              localPosition.x = value;
              this._posDirty(true);
            }
          },
          override: true
        },
        y: {
          get: function get() {
            return this._originPos.y;
          },
          set: function set(value) {
            var localPosition = this._originPos;
            if (value !== localPosition.y) {
              localPosition.y = value;
              this._posDirty(true);
            }
          },
          override: true
        },
        zIndex: {
          get: function get() {
            return cc.macro.MIN_ZINDEX;
          },
          set: function set() {
            cc.warnID(1638);
          },
          override: true
        },
        showInEditor: {
          default: false,
          editorOnly: true,
          override: true
        }
      },
      ctor: function ctor(name) {
        this._localZOrder = cc.macro.MIN_ZINDEX << 16;
        this._originPos = cc.v2();
        false;
      },
      _posDirty: function _posDirty(sendEvent) {
        this.setLocalDirty(LocalDirtyFlag.POSITION);
        this._renderFlag |= RenderFlow.FLAG_TRANSFORM;
        true === sendEvent && this._eventMask & POSITION_ON && this.emit(Node.EventType.POSITION_CHANGED);
      },
      _updateLocalMatrix: function _updateLocalMatrix() {
        if (!this._localMatDirty) return;
        var parent = this.parent;
        if (parent) {
          this._position.x = this._originPos.x - (parent._anchorPoint.x - .5) * parent._contentSize.width;
          this._position.y = this._originPos.y - (parent._anchorPoint.y - .5) * parent._contentSize.height;
        }
        this._super();
      },
      getPosition: function getPosition() {
        return new cc.Vec2(this._originPos);
      },
      setPosition: function setPosition(x, y) {
        if (void 0 === y) {
          x = x.x;
          y = x.y;
        }
        var pos = this._originPos;
        if (pos.x === x && pos.y === y) return;
        pos.x = x;
        pos.y = y;
        this._posDirty(true);
      },
      setParent: function setParent(value) {
        var oldParent = this._parent;
        this._super(value);
        if (oldParent !== value) {
          oldParent && oldParent.off(Node.EventType.ANCHOR_CHANGED, this._posDirty, this);
          value && value.on(Node.EventType.ANCHOR_CHANGED, this._posDirty, this);
        }
      },
      _updateOrderOfArrival: function _updateOrderOfArrival() {}
    });
    cc.js.getset(PrivateNode.prototype, "parent", PrivateNode.prototype.getParent, PrivateNode.prototype.setParent);
    cc.js.getset(PrivateNode.prototype, "position", PrivateNode.prototype.getPosition, PrivateNode.prototype.setPosition);
    cc.PrivateNode = module.exports = PrivateNode;
  }), {
    "./CCNode": 29,
    "./renderer/render-flow": 162
  } ],
  31: [ (function(require, module, exports) {
    "use strict";
    var NIL = function NIL() {};
    cc.Scene = cc.Class({
      name: "cc.Scene",
      extends: require("./CCNode"),
      properties: {
        _is3DNode: {
          default: true,
          override: true
        },
        autoReleaseAssets: {
          default: void 0,
          type: cc.Boolean
        }
      },
      ctor: function ctor() {
        this._anchorPoint.x = 0;
        this._anchorPoint.y = 0;
        this._activeInHierarchy = false;
        this._inited = !cc.game._isCloning;
        false;
        this.dependAssets = null;
      },
      destroy: function destroy() {
        if (cc.Object.prototype.destroy.call(this)) {
          var children = this._children;
          for (var i = 0; i < children.length; ++i) children[i].active = false;
        }
        this._active = false;
        this._activeInHierarchy = false;
      },
      _onHierarchyChanged: NIL,
      _instantiate: null,
      _load: function _load() {
        if (!this._inited) {
          false;
          false;
          this._onBatchCreated();
          this._inited = true;
        }
      },
      _activate: function _activate(active) {
        active = false !== active;
        false, false;
        cc.director._nodeActivator.activateNode(this, active);
      }
    });
    module.exports = cc.Scene;
  }), {
    "./CCNode": 29
  } ],
  32: [ (function(require, module, exports) {
    "use strict";
    var js = require("./platform/js");
    var IdGenerater = require("./platform/id-generater");
    var MAX_POOL_SIZE = 20;
    var idGenerater = new IdGenerater("Scheduler");
    var ListEntry = function ListEntry(target, priority, paused, markedForDeletion) {
      this.target = target;
      this.priority = priority;
      this.paused = paused;
      this.markedForDeletion = markedForDeletion;
    };
    var _listEntries = [];
    ListEntry.get = function(target, priority, paused, markedForDeletion) {
      var result = _listEntries.pop();
      if (result) {
        result.target = target;
        result.priority = priority;
        result.paused = paused;
        result.markedForDeletion = markedForDeletion;
      } else result = new ListEntry(target, priority, paused, markedForDeletion);
      return result;
    };
    ListEntry.put = function(entry) {
      if (_listEntries.length < MAX_POOL_SIZE) {
        entry.target = null;
        _listEntries.push(entry);
      }
    };
    var HashUpdateEntry = function HashUpdateEntry(list, entry, target, callback) {
      this.list = list;
      this.entry = entry;
      this.target = target;
      this.callback = callback;
    };
    var _hashUpdateEntries = [];
    HashUpdateEntry.get = function(list, entry, target, callback) {
      var result = _hashUpdateEntries.pop();
      if (result) {
        result.list = list;
        result.entry = entry;
        result.target = target;
        result.callback = callback;
      } else result = new HashUpdateEntry(list, entry, target, callback);
      return result;
    };
    HashUpdateEntry.put = function(entry) {
      if (_hashUpdateEntries.length < MAX_POOL_SIZE) {
        entry.list = entry.entry = entry.target = entry.callback = null;
        _hashUpdateEntries.push(entry);
      }
    };
    var HashTimerEntry = function HashTimerEntry(timers, target, timerIndex, currentTimer, currentTimerSalvaged, paused) {
      var _t = this;
      _t.timers = timers;
      _t.target = target;
      _t.timerIndex = timerIndex;
      _t.currentTimer = currentTimer;
      _t.currentTimerSalvaged = currentTimerSalvaged;
      _t.paused = paused;
    };
    var _hashTimerEntries = [];
    HashTimerEntry.get = function(timers, target, timerIndex, currentTimer, currentTimerSalvaged, paused) {
      var result = _hashTimerEntries.pop();
      if (result) {
        result.timers = timers;
        result.target = target;
        result.timerIndex = timerIndex;
        result.currentTimer = currentTimer;
        result.currentTimerSalvaged = currentTimerSalvaged;
        result.paused = paused;
      } else result = new HashTimerEntry(timers, target, timerIndex, currentTimer, currentTimerSalvaged, paused);
      return result;
    };
    HashTimerEntry.put = function(entry) {
      if (_hashTimerEntries.length < MAX_POOL_SIZE) {
        entry.timers = entry.target = entry.currentTimer = null;
        _hashTimerEntries.push(entry);
      }
    };
    function CallbackTimer() {
      this._lock = false;
      this._scheduler = null;
      this._elapsed = -1;
      this._runForever = false;
      this._useDelay = false;
      this._timesExecuted = 0;
      this._repeat = 0;
      this._delay = 0;
      this._interval = 0;
      this._target = null;
      this._callback = null;
    }
    var proto = CallbackTimer.prototype;
    proto.initWithCallback = function(scheduler, callback, target, seconds, repeat, delay) {
      this._lock = false;
      this._scheduler = scheduler;
      this._target = target;
      this._callback = callback;
      this._elapsed = -1;
      this._interval = seconds;
      this._delay = delay;
      this._useDelay = this._delay > 0;
      this._repeat = repeat;
      this._runForever = this._repeat === cc.macro.REPEAT_FOREVER;
      return true;
    };
    proto.getInterval = function() {
      return this._interval;
    };
    proto.setInterval = function(interval) {
      this._interval = interval;
    };
    proto.update = function(dt) {
      if (-1 === this._elapsed) {
        this._elapsed = 0;
        this._timesExecuted = 0;
      } else {
        this._elapsed += dt;
        if (this._runForever && !this._useDelay) {
          if (this._elapsed >= this._interval) {
            this.trigger();
            this._elapsed = 0;
          }
        } else {
          if (this._useDelay) {
            if (this._elapsed >= this._delay) {
              this.trigger();
              this._elapsed -= this._delay;
              this._timesExecuted += 1;
              this._useDelay = false;
            }
          } else if (this._elapsed >= this._interval) {
            this.trigger();
            this._elapsed = 0;
            this._timesExecuted += 1;
          }
          this._callback && !this._runForever && this._timesExecuted > this._repeat && this.cancel();
        }
      }
    };
    proto.getCallback = function() {
      return this._callback;
    };
    proto.trigger = function() {
      if (this._target && this._callback) {
        this._lock = true;
        this._callback.call(this._target, this._elapsed);
        this._lock = false;
      }
    };
    proto.cancel = function() {
      this._scheduler.unschedule(this._callback, this._target);
    };
    var _timers = [];
    CallbackTimer.get = function() {
      return _timers.pop() || new CallbackTimer();
    };
    CallbackTimer.put = function(timer) {
      if (_timers.length < MAX_POOL_SIZE && !timer._lock) {
        timer._scheduler = timer._target = timer._callback = null;
        _timers.push(timer);
      }
    };
    cc.Scheduler = function() {
      this._timeScale = 1;
      this._updatesNegList = [];
      this._updates0List = [];
      this._updatesPosList = [];
      this._hashForUpdates = js.createMap(true);
      this._hashForTimers = js.createMap(true);
      this._currentTarget = null;
      this._currentTargetSalvaged = false;
      this._updateHashLocked = false;
      this._arrayForTimers = [];
    };
    cc.Scheduler.prototype = {
      constructor: cc.Scheduler,
      _removeHashElement: function _removeHashElement(element) {
        delete this._hashForTimers[element.target._id];
        var arr = this._arrayForTimers;
        for (var i = 0, l = arr.length; i < l; i++) if (arr[i] === element) {
          arr.splice(i, 1);
          break;
        }
        HashTimerEntry.put(element);
      },
      _removeUpdateFromHash: function _removeUpdateFromHash(entry) {
        var targetId = entry.target._id;
        var self = this, element = self._hashForUpdates[targetId];
        if (element) {
          var list = element.list, listEntry = element.entry;
          for (var i = 0, l = list.length; i < l; i++) if (list[i] === listEntry) {
            list.splice(i, 1);
            break;
          }
          delete self._hashForUpdates[targetId];
          ListEntry.put(listEntry);
          HashUpdateEntry.put(element);
        }
      },
      _priorityIn: function _priorityIn(ppList, listElement, priority) {
        for (var i = 0; i < ppList.length; i++) if (priority < ppList[i].priority) {
          ppList.splice(i, 0, listElement);
          return;
        }
        ppList.push(listElement);
      },
      _appendIn: function _appendIn(ppList, listElement) {
        ppList.push(listElement);
      },
      enableForTarget: function enableForTarget(target) {
        target._id || (target.__instanceId ? cc.warnID(1513) : target._id = idGenerater.getNewId());
      },
      setTimeScale: function setTimeScale(timeScale) {
        this._timeScale = timeScale;
      },
      getTimeScale: function getTimeScale() {
        return this._timeScale;
      },
      update: function update(dt) {
        this._updateHashLocked = true;
        1 !== this._timeScale && (dt *= this._timeScale);
        var i, list, len, entry;
        for (i = 0, list = this._updatesNegList, len = list.length; i < len; i++) {
          entry = list[i];
          entry.paused || entry.markedForDeletion || entry.target.update(dt);
        }
        for (i = 0, list = this._updates0List, len = list.length; i < len; i++) {
          entry = list[i];
          entry.paused || entry.markedForDeletion || entry.target.update(dt);
        }
        for (i = 0, list = this._updatesPosList, len = list.length; i < len; i++) {
          entry = list[i];
          entry.paused || entry.markedForDeletion || entry.target.update(dt);
        }
        var elt, arr = this._arrayForTimers;
        for (i = 0; i < arr.length; i++) {
          elt = arr[i];
          this._currentTarget = elt;
          this._currentTargetSalvaged = false;
          if (!elt.paused) for (elt.timerIndex = 0; elt.timerIndex < elt.timers.length; ++elt.timerIndex) {
            elt.currentTimer = elt.timers[elt.timerIndex];
            elt.currentTimerSalvaged = false;
            elt.currentTimer.update(dt);
            elt.currentTimer = null;
          }
          if (this._currentTargetSalvaged && 0 === this._currentTarget.timers.length) {
            this._removeHashElement(this._currentTarget);
            --i;
          }
        }
        for (i = 0, list = this._updatesNegList; i < list.length; ) {
          entry = list[i];
          entry.markedForDeletion ? this._removeUpdateFromHash(entry) : i++;
        }
        for (i = 0, list = this._updates0List; i < list.length; ) {
          entry = list[i];
          entry.markedForDeletion ? this._removeUpdateFromHash(entry) : i++;
        }
        for (i = 0, list = this._updatesPosList; i < list.length; ) {
          entry = list[i];
          entry.markedForDeletion ? this._removeUpdateFromHash(entry) : i++;
        }
        this._updateHashLocked = false;
        this._currentTarget = null;
      },
      schedule: function schedule(callback, target, interval, repeat, delay, paused) {
        if ("function" !== typeof callback) {
          var tmp = callback;
          callback = target;
          target = tmp;
        }
        if (4 === arguments.length || 5 === arguments.length) {
          paused = !!repeat;
          repeat = cc.macro.REPEAT_FOREVER;
          delay = 0;
        }
        cc.assertID(target, 1502);
        var targetId = target._id;
        if (!targetId) if (target.__instanceId) {
          cc.warnID(1513);
          targetId = target._id = target.__instanceId;
        } else cc.errorID(1510);
        var element = this._hashForTimers[targetId];
        if (element) element.paused !== paused && cc.warnID(1511); else {
          element = HashTimerEntry.get(null, target, 0, null, null, paused);
          this._arrayForTimers.push(element);
          this._hashForTimers[targetId] = element;
        }
        var timer, i;
        if (null == element.timers) element.timers = []; else for (i = 0; i < element.timers.length; ++i) {
          timer = element.timers[i];
          if (timer && callback === timer._callback) {
            cc.logID(1507, timer.getInterval(), interval);
            timer._interval = interval;
            return;
          }
        }
        timer = CallbackTimer.get();
        timer.initWithCallback(this, callback, target, interval, repeat, delay);
        element.timers.push(timer);
        this._currentTarget === element && this._currentTargetSalvaged && (this._currentTargetSalvaged = false);
      },
      scheduleUpdate: function scheduleUpdate(target, priority, paused) {
        var targetId = target._id;
        if (!targetId) if (target.__instanceId) {
          cc.warnID(1513);
          targetId = target._id = target.__instanceId;
        } else cc.errorID(1510);
        var hashElement = this._hashForUpdates[targetId];
        if (hashElement && hashElement.entry) {
          if (hashElement.entry.priority === priority) {
            hashElement.entry.markedForDeletion = false;
            hashElement.entry.paused = paused;
            return;
          }
          if (this._updateHashLocked) {
            cc.logID(1506);
            hashElement.entry.markedForDeletion = false;
            hashElement.entry.paused = paused;
            return;
          }
          this.unscheduleUpdate(target);
        }
        var listElement = ListEntry.get(target, priority, paused, false);
        var ppList;
        if (0 === priority) {
          ppList = this._updates0List;
          this._appendIn(ppList, listElement);
        } else {
          ppList = priority < 0 ? this._updatesNegList : this._updatesPosList;
          this._priorityIn(ppList, listElement, priority);
        }
        this._hashForUpdates[targetId] = HashUpdateEntry.get(ppList, listElement, target, null);
      },
      unschedule: function unschedule(callback, target) {
        if (!target || !callback) return;
        var targetId = target._id;
        if (!targetId) if (target.__instanceId) {
          cc.warnID(1513);
          targetId = target._id = target.__instanceId;
        } else cc.errorID(1510);
        var self = this, element = self._hashForTimers[targetId];
        if (element) {
          var timers = element.timers;
          for (var i = 0, li = timers.length; i < li; i++) {
            var timer = timers[i];
            if (callback === timer._callback) {
              timer !== element.currentTimer || element.currentTimerSalvaged || (element.currentTimerSalvaged = true);
              timers.splice(i, 1);
              CallbackTimer.put(timer);
              element.timerIndex >= i && element.timerIndex--;
              0 === timers.length && (self._currentTarget === element ? self._currentTargetSalvaged = true : self._removeHashElement(element));
              return;
            }
          }
        }
      },
      unscheduleUpdate: function unscheduleUpdate(target) {
        if (!target) return;
        var targetId = target._id;
        if (!targetId) if (target.__instanceId) {
          cc.warnID(1513);
          targetId = target._id = target.__instanceId;
        } else cc.errorID(1510);
        var element = this._hashForUpdates[targetId];
        element && (this._updateHashLocked ? element.entry.markedForDeletion = true : this._removeUpdateFromHash(element.entry));
      },
      unscheduleAllForTarget: function unscheduleAllForTarget(target) {
        if (!target) return;
        var targetId = target._id;
        if (!targetId) if (target.__instanceId) {
          cc.warnID(1513);
          targetId = target._id = target.__instanceId;
        } else cc.errorID(1510);
        var element = this._hashForTimers[targetId];
        if (element) {
          var timers = element.timers;
          timers.indexOf(element.currentTimer) > -1 && !element.currentTimerSalvaged && (element.currentTimerSalvaged = true);
          for (var i = 0, l = timers.length; i < l; i++) CallbackTimer.put(timers[i]);
          timers.length = 0;
          this._currentTarget === element ? this._currentTargetSalvaged = true : this._removeHashElement(element);
        }
        this.unscheduleUpdate(target);
      },
      unscheduleAll: function unscheduleAll() {
        this.unscheduleAllWithMinPriority(cc.Scheduler.PRIORITY_SYSTEM);
      },
      unscheduleAllWithMinPriority: function unscheduleAllWithMinPriority(minPriority) {
        var i, element, arr = this._arrayForTimers;
        for (i = arr.length - 1; i >= 0; i--) {
          element = arr[i];
          this.unscheduleAllForTarget(element.target);
        }
        var entry;
        var temp_length = 0;
        if (minPriority < 0) for (i = 0; i < this._updatesNegList.length; ) {
          temp_length = this._updatesNegList.length;
          entry = this._updatesNegList[i];
          entry && entry.priority >= minPriority && this.unscheduleUpdate(entry.target);
          temp_length == this._updatesNegList.length && i++;
        }
        if (minPriority <= 0) for (i = 0; i < this._updates0List.length; ) {
          temp_length = this._updates0List.length;
          entry = this._updates0List[i];
          entry && this.unscheduleUpdate(entry.target);
          temp_length == this._updates0List.length && i++;
        }
        for (i = 0; i < this._updatesPosList.length; ) {
          temp_length = this._updatesPosList.length;
          entry = this._updatesPosList[i];
          entry && entry.priority >= minPriority && this.unscheduleUpdate(entry.target);
          temp_length == this._updatesPosList.length && i++;
        }
      },
      isScheduled: function isScheduled(callback, target) {
        cc.assertID(callback, 1508);
        cc.assertID(target, 1509);
        var targetId = target._id;
        if (!targetId) if (target.__instanceId) {
          cc.warnID(1513);
          targetId = target._id = target.__instanceId;
        } else cc.errorID(1510);
        var element = this._hashForTimers[targetId];
        if (!element) return false;
        if (null == element.timers) return false;
        var timers = element.timers;
        for (var i = 0; i < timers.length; ++i) {
          var timer = timers[i];
          if (callback === timer._callback) return true;
        }
        return false;
      },
      pauseAllTargets: function pauseAllTargets() {
        return this.pauseAllTargetsWithMinPriority(cc.Scheduler.PRIORITY_SYSTEM);
      },
      pauseAllTargetsWithMinPriority: function pauseAllTargetsWithMinPriority(minPriority) {
        var idsWithSelectors = [];
        var self = this, element, locArrayForTimers = self._arrayForTimers;
        var i, li;
        for (i = 0, li = locArrayForTimers.length; i < li; i++) {
          element = locArrayForTimers[i];
          if (element) {
            element.paused = true;
            idsWithSelectors.push(element.target);
          }
        }
        var entry;
        if (minPriority < 0) for (i = 0; i < this._updatesNegList.length; i++) {
          entry = this._updatesNegList[i];
          if (entry && entry.priority >= minPriority) {
            entry.paused = true;
            idsWithSelectors.push(entry.target);
          }
        }
        if (minPriority <= 0) for (i = 0; i < this._updates0List.length; i++) {
          entry = this._updates0List[i];
          if (entry) {
            entry.paused = true;
            idsWithSelectors.push(entry.target);
          }
        }
        for (i = 0; i < this._updatesPosList.length; i++) {
          entry = this._updatesPosList[i];
          if (entry && entry.priority >= minPriority) {
            entry.paused = true;
            idsWithSelectors.push(entry.target);
          }
        }
        return idsWithSelectors;
      },
      resumeTargets: function resumeTargets(targetsToResume) {
        if (!targetsToResume) return;
        for (var i = 0; i < targetsToResume.length; i++) this.resumeTarget(targetsToResume[i]);
      },
      pauseTarget: function pauseTarget(target) {
        cc.assertID(target, 1503);
        var targetId = target._id;
        if (!targetId) if (target.__instanceId) {
          cc.warnID(1513);
          targetId = target._id = target.__instanceId;
        } else cc.errorID(1510);
        var self = this, element = self._hashForTimers[targetId];
        element && (element.paused = true);
        var elementUpdate = self._hashForUpdates[targetId];
        elementUpdate && (elementUpdate.entry.paused = true);
      },
      resumeTarget: function resumeTarget(target) {
        cc.assertID(target, 1504);
        var targetId = target._id;
        if (!targetId) if (target.__instanceId) {
          cc.warnID(1513);
          targetId = target._id = target.__instanceId;
        } else cc.errorID(1510);
        var self = this, element = self._hashForTimers[targetId];
        element && (element.paused = false);
        var elementUpdate = self._hashForUpdates[targetId];
        elementUpdate && (elementUpdate.entry.paused = false);
      },
      isTargetPaused: function isTargetPaused(target) {
        cc.assertID(target, 1505);
        var targetId = target._id;
        if (!targetId) if (target.__instanceId) {
          cc.warnID(1513);
          targetId = target._id = target.__instanceId;
        } else cc.errorID(1510);
        var element = this._hashForTimers[targetId];
        if (element) return element.paused;
        var elementUpdate = this._hashForUpdates[targetId];
        if (elementUpdate) return elementUpdate.entry.paused;
        return false;
      }
    };
    cc.Scheduler.PRIORITY_SYSTEM = 1 << 31;
    cc.Scheduler.PRIORITY_NON_SYSTEM = cc.Scheduler.PRIORITY_SYSTEM + 1;
    module.exports = cc.Scheduler;
  }), {
    "./platform/id-generater": 134,
    "./platform/js": 138
  } ],
  33: [ (function(require, module, exports) {
    "use strict";
    var RawAsset = require("./CCRawAsset");
    cc.Asset = cc.Class({
      name: "cc.Asset",
      extends: RawAsset,
      ctor: function ctor() {
        this.loaded = true;
        this.url = "";
      },
      properties: {
        nativeUrl: {
          get: function get() {
            if (this._native) {
              var name = this._native;
              if (47 === name.charCodeAt(0)) return name.slice(1);
              if (cc.AssetLibrary) {
                var base = cc.AssetLibrary.getLibUrlNoExt(this._uuid, true);
                return 46 === name.charCodeAt(0) ? base + name : base + "/" + name;
              }
              cc.errorID(6400);
            }
            return "";
          },
          visible: false
        },
        _native: "",
        _nativeAsset: {
          get: function get() {
            return this._$nativeAsset;
          },
          set: function set(obj) {
            this._$nativeAsset = obj;
          }
        }
      },
      statics: {
        deserialize: false,
        preventDeferredLoadDependents: false,
        preventPreloadNativeObject: false
      },
      toString: function toString() {
        return this.nativeUrl;
      },
      serialize: false,
      createNode: null,
      _setRawAsset: function _setRawAsset(filename, inLibrary) {
        this._native = false !== inLibrary ? filename || void 0 : "/" + filename;
      }
    });
    module.exports = cc.Asset;
  }), {
    "./CCRawAsset": 42
  } ],
  34: [ (function(require, module, exports) {
    "use strict";
    var Asset = require("./CCAsset");
    var EventTarget = require("../event/event-target");
    var LoadMode = cc.Enum({
      WEB_AUDIO: 0,
      DOM_AUDIO: 1
    });
    var AudioClip = cc.Class({
      name: "cc.AudioClip",
      extends: Asset,
      mixins: [ EventTarget ],
      ctor: function ctor() {
        this.loaded = false;
        this._audio = null;
      },
      properties: {
        loadMode: {
          default: LoadMode.WEB_AUDIO,
          type: LoadMode
        },
        _nativeAsset: {
          get: function get() {
            return this._audio;
          },
          set: function set(value) {
            value instanceof cc.AudioClip ? this._audio = value._nativeAsset : this._audio = value;
            if (this._audio) {
              this.loaded = true;
              this.emit("load");
            }
          },
          override: true
        }
      },
      statics: {
        LoadMode: LoadMode,
        _loadByUrl: function _loadByUrl(url, callback) {
          var item = cc.loader.getItem(url) || cc.loader.getItem(url + "?useDom=1");
          item && item.complete ? item._owner instanceof AudioClip ? callback(null, item._owner) : callback(null, item.content) : cc.loader.load(url, (function(error, downloadUrl) {
            if (error) return callback(error);
            item = cc.loader.getItem(url) || cc.loader.getItem(url + "?useDom=1");
            callback(null, item.content);
          }));
        }
      },
      destroy: function destroy() {
        cc.audioEngine.uncache(this);
        this._super();
      }
    });
    cc.AudioClip = AudioClip;
    module.exports = AudioClip;
  }), {
    "../event/event-target": 86,
    "./CCAsset": 33
  } ],
  35: [ (function(require, module, exports) {
    "use strict";
    var BitmapFont = cc.Class({
      name: "cc.BitmapFont",
      extends: cc.Font,
      properties: {
        fntDataStr: {
          default: ""
        },
        spriteFrame: {
          default: null,
          type: cc.SpriteFrame
        },
        fontSize: {
          default: -1
        },
        _fntConfig: null
      }
    });
    cc.BitmapFont = BitmapFont;
    module.exports = BitmapFont;
  }), {} ],
  36: [ (function(require, module, exports) {
    "use strict";
    var BufferAsset = cc.Class({
      name: "cc.BufferAsset",
      extends: cc.Asset,
      ctor: function ctor() {
        this._buffer = null;
      },
      properties: {
        _nativeAsset: {
          get: function get() {
            return this._buffer;
          },
          set: function set(bin) {
            this._buffer = bin.buffer || bin;
          },
          override: true
        },
        buffer: function buffer() {
          return this._buffer;
        }
      }
    });
    cc.BufferAsset = module.exports = BufferAsset;
  }), {} ],
  37: [ (function(require, module, exports) {
    "use strict";
    var Asset = require("./CCAsset");
    var EffectAsset = cc.Class({
      name: "cc.EffectAsset",
      extends: Asset,
      properties: {
        properties: Object,
        techniques: [],
        shaders: []
      },
      onLoad: function onLoad() {
        if (cc.game.renderType === cc.game.RENDER_TYPE_CANVAS) return;
        var lib = cc.renderer._forward._programLib;
        for (var i = 0; i < this.shaders.length; i++) lib.define(this.shaders[i]);
      }
    });
    module.exports = cc.EffectAsset = EffectAsset;
  }), {
    "./CCAsset": 33
  } ],
  38: [ (function(require, module, exports) {
    "use strict";
    var Font = cc.Class({
      name: "cc.Font",
      extends: cc.Asset
    });
    cc.Font = module.exports = Font;
  }), {} ],
  39: [ (function(require, module, exports) {
    "use strict";
    var JsonAsset = cc.Class({
      name: "cc.JsonAsset",
      extends: cc.Asset,
      properties: {
        json: null
      }
    });
    module.exports = cc.JsonAsset = JsonAsset;
  }), {} ],
  40: [ (function(require, module, exports) {
    "use strict";
    var LabelAtlas = cc.Class({
      name: "cc.LabelAtlas",
      extends: cc.BitmapFont
    });
    cc.LabelAtlas = LabelAtlas;
    module.exports = LabelAtlas;
  }), {} ],
  41: [ (function(require, module, exports) {
    "use strict";
    var OptimizationPolicy = cc.Enum({
      AUTO: 0,
      SINGLE_INSTANCE: 1,
      MULTI_INSTANCE: 2
    });
    var Prefab = cc.Class({
      name: "cc.Prefab",
      extends: cc.Asset,
      ctor: function ctor() {
        this._createFunction = null;
        this._instantiatedTimes = 0;
      },
      properties: {
        data: null,
        optimizationPolicy: OptimizationPolicy.AUTO,
        asyncLoadAssets: false,
        readonly: {
          default: false,
          editorOnly: true
        }
      },
      statics: {
        OptimizationPolicy: OptimizationPolicy,
        OptimizationPolicyThreshold: 3
      },
      createNode: false,
      compileCreateFunction: function compileCreateFunction() {
        var jit = require("../platform/instantiate-jit");
        this._createFunction = jit.compile(this.data);
      },
      _doInstantiate: function _doInstantiate(rootToRedirect) {
        this.data._prefab ? this.data._prefab._synced = true : cc.warnID(3700);
        this._createFunction || this.compileCreateFunction();
        return this._createFunction(rootToRedirect);
      },
      _instantiate: function _instantiate() {
        var node, useJit = false;
        false;
        if (useJit) {
          node = this._doInstantiate();
          this.data._instantiate(node);
        } else {
          this.data._prefab._synced = true;
          node = this.data._instantiate();
        }
        ++this._instantiatedTimes;
        var PrefabUtils;
        false, false;
        return node;
      }
    });
    cc.Prefab = module.exports = Prefab;
    cc.js.obsolete(cc, "cc._Prefab", "Prefab");
  }), {
    "../platform/instantiate-jit": 136
  } ],
  42: [ (function(require, module, exports) {
    "use strict";
    var CCObject = require("../platform/CCObject");
    var js = require("../platform/js");
    cc.RawAsset = cc.Class({
      name: "cc.RawAsset",
      extends: CCObject,
      ctor: function ctor() {
        Object.defineProperty(this, "_uuid", {
          value: "",
          writable: true
        });
      }
    });
    js.value(cc.RawAsset, "isRawAssetType", (function(ctor) {
      return js.isChildClassOf(ctor, cc.RawAsset) && !js.isChildClassOf(ctor, cc.Asset);
    }));
    js.value(cc.RawAsset, "wasRawAssetType", (function(ctor) {
      return ctor === cc.Texture2D || ctor === cc.AudioClip || ctor === cc.ParticleAsset || ctor === cc.Asset;
    }));
    module.exports = cc.RawAsset;
  }), {
    "../platform/CCObject": 124,
    "../platform/js": 138
  } ],
  43: [ (function(require, module, exports) {
    "use strict";
    var _gfx = require("../../renderer/gfx");
    var _gfx2 = _interopRequireDefault(_gfx);
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : {
        default: obj
      };
    }
    var renderer = require("../renderer");
    var Texture2D = require("./CCTexture2D");
    var RenderTexture = cc.Class({
      name: "cc.RenderTexture",
      extends: Texture2D,
      ctor: function ctor() {
        this._framebuffer = null;
      },
      initWithSize: function initWithSize(width, height, depthStencilFormat) {
        this.width = Math.floor(width || cc.visibleRect.width);
        this.height = Math.floor(height || cc.visibleRect.height);
        this._resetUnderlyingMipmaps();
        var opts = {
          colors: [ this._texture ]
        };
        this._depthStencilBuffer && this._depthStencilBuffer.destroy();
        var depthStencilBuffer = void 0;
        if (depthStencilFormat) {
          depthStencilBuffer = new _gfx2.default.RenderBuffer(renderer.device, depthStencilFormat, width, height);
          depthStencilFormat === _gfx2.default.RB_FMT_D24S8 ? opts.depthStencil = depthStencilBuffer : depthStencilFormat === _gfx2.default.RB_FMT_S8 ? opts.stencil = depthStencilBuffer : depthStencilFormat === _gfx2.default.RB_FMT_D16 && (opts.depth = depthStencilBuffer);
        }
        this._depthStencilBuffer = depthStencilBuffer;
        this._framebuffer && this._framebuffer.destroy();
        this._framebuffer = new _gfx2.default.FrameBuffer(renderer.device, width, height, opts);
        this.loaded = true;
        this.emit("load");
      },
      updateSize: function updateSize(width, height) {
        this.width = Math.floor(width || cc.visibleRect.width);
        this.height = Math.floor(height || cc.visibleRect.height);
        this._resetUnderlyingMipmaps();
        var rbo = this._depthStencilBuffer;
        rbo && rbo.update(this.width, this.height);
        this._framebuffer._width = width;
        this._framebuffer._height = height;
      },
      drawTextureAt: function drawTextureAt(texture, x, y) {
        if (!texture._image) return;
        this._texture.updateSubImage({
          x: x,
          y: y,
          image: texture._image,
          width: texture.width,
          height: texture.height,
          level: 0,
          flipY: false,
          premultiplyAlpha: texture._premultiplyAlpha
        });
      },
      readPixels: function readPixels(data, x, y, w, h) {
        if (!this._framebuffer || !this._texture) return data;
        x = x || 0;
        y = y || 0;
        var width = w || this.width;
        var height = h || this.height;
        data = data || new Uint8Array(width * height * 4);
        var gl = renderer._forward._device._gl;
        var oldFBO = gl.getParameter(gl.FRAMEBUFFER_BINDING);
        gl.bindFramebuffer(gl.FRAMEBUFFER, this._framebuffer._glID);
        gl.readPixels(x, y, width, height, gl.RGBA, gl.UNSIGNED_BYTE, data);
        gl.bindFramebuffer(gl.FRAMEBUFFER, oldFBO);
        return data;
      },
      destroy: function destroy() {
        this._super();
        this._framebuffer && this._framebuffer.destroy();
      }
    });
    cc.RenderTexture = module.exports = RenderTexture;
  }), {
    "../../renderer/gfx": 256,
    "../renderer": 161,
    "./CCTexture2D": 50
  } ],
  44: [ (function(require, module, exports) {
    "use strict";
    var Scene = cc.Class({
      name: "cc.SceneAsset",
      extends: cc.Asset,
      properties: {
        scene: null,
        asyncLoadAssets: void 0
      }
    });
    cc.SceneAsset = Scene;
    module.exports = Scene;
  }), {} ],
  45: [ (function(require, module, exports) {
    "use strict";
    var Script = cc.Class({
      name: "cc.Script",
      extends: cc.Asset
    });
    cc._Script = Script;
    var JavaScript = cc.Class({
      name: "cc.JavaScript",
      extends: Script
    });
    cc._JavaScript = JavaScript;
    var CoffeeScript = cc.Class({
      name: "cc.CoffeeScript",
      extends: Script
    });
    cc._CoffeeScript = CoffeeScript;
    var TypeScript = cc.Class({
      name: "cc.TypeScript",
      extends: Script
    });
    cc._TypeScript = TypeScript;
  }), {} ],
  46: [ (function(require, module, exports) {
    "use strict";
    var SpriteAtlas = cc.Class({
      name: "cc.SpriteAtlas",
      extends: cc.Asset,
      properties: {
        _spriteFrames: {
          default: {}
        }
      },
      getTexture: function getTexture() {
        var keys = Object.keys(this._spriteFrames);
        if (keys.length > 0) {
          var spriteFrame = this._spriteFrames[keys[0]];
          return spriteFrame ? spriteFrame.getTexture() : null;
        }
        return null;
      },
      getSpriteFrame: function getSpriteFrame(key) {
        var sf = this._spriteFrames[key];
        if (!sf) return null;
        sf.name || (sf.name = key);
        return sf;
      },
      getSpriteFrames: function getSpriteFrames() {
        var frames = [];
        var spriteFrames = this._spriteFrames;
        for (var key in spriteFrames) frames.push(this.getSpriteFrame(key));
        return frames;
      }
    });
    cc.SpriteAtlas = SpriteAtlas;
    module.exports = SpriteAtlas;
  }), {} ],
  47: [ (function(require, module, exports) {
    "use strict";
    var EventTarget = require("../event/event-target");
    var textureUtil = require("../utils/texture-util");
    var INSET_LEFT = 0;
    var INSET_TOP = 1;
    var INSET_RIGHT = 2;
    var INSET_BOTTOM = 3;
    var temp_uvs = [ {
      u: 0,
      v: 0
    }, {
      u: 0,
      v: 0
    }, {
      u: 0,
      v: 0
    }, {
      u: 0,
      v: 0
    } ];
    var SpriteFrame = cc.Class({
      name: "cc.SpriteFrame",
      extends: require("../assets/CCAsset"),
      mixins: [ EventTarget ],
      properties: {
        _textureSetter: {
          set: function set(texture) {
            if (texture) {
              false;
              this._texture !== texture && this._refreshTexture(texture);
              this._textureFilename = texture.url;
            }
          }
        },
        insetTop: {
          get: function get() {
            return this._capInsets[INSET_TOP];
          },
          set: function set(value) {
            this._capInsets[INSET_TOP] = value;
            this._texture && this._calculateSlicedUV();
          }
        },
        insetBottom: {
          get: function get() {
            return this._capInsets[INSET_BOTTOM];
          },
          set: function set(value) {
            this._capInsets[INSET_BOTTOM] = value;
            this._texture && this._calculateSlicedUV();
          }
        },
        insetLeft: {
          get: function get() {
            return this._capInsets[INSET_LEFT];
          },
          set: function set(value) {
            this._capInsets[INSET_LEFT] = value;
            this._texture && this._calculateSlicedUV();
          }
        },
        insetRight: {
          get: function get() {
            return this._capInsets[INSET_RIGHT];
          },
          set: function set(value) {
            this._capInsets[INSET_RIGHT] = value;
            this._texture && this._calculateSlicedUV();
          }
        }
      },
      ctor: function ctor() {
        EventTarget.call(this);
        var filename = arguments[0];
        var rect = arguments[1];
        var rotated = arguments[2];
        var offset = arguments[3];
        var originalSize = arguments[4];
        this._rect = null;
        this.uv = [];
        this._texture = null;
        this._original = null;
        this._offset = null;
        this._originalSize = null;
        this._rotated = false;
        this.vertices = null;
        this._capInsets = [ 0, 0, 0, 0 ];
        this.uvSliced = [];
        this._textureFilename = "";
        false;
        void 0 !== filename && this.setTexture(filename, rect, rotated, offset, originalSize);
      },
      textureLoaded: function textureLoaded() {
        return this._texture && this._texture.loaded;
      },
      isRotated: function isRotated() {
        return this._rotated;
      },
      setRotated: function setRotated(bRotated) {
        this._rotated = bRotated;
        this._texture && this._calculateUV();
      },
      getRect: function getRect() {
        return cc.rect(this._rect);
      },
      setRect: function setRect(rect) {
        this._rect = rect;
        this._texture && this._calculateUV();
      },
      getOriginalSize: function getOriginalSize() {
        return cc.size(this._originalSize);
      },
      setOriginalSize: function setOriginalSize(size) {
        if (this._originalSize) {
          this._originalSize.width = size.width;
          this._originalSize.height = size.height;
        } else this._originalSize = cc.size(size);
      },
      getTexture: function getTexture() {
        return this._texture;
      },
      _textureLoadedCallback: function _textureLoadedCallback() {
        var self = this;
        var texture = this._texture;
        if (!texture) return;
        var w = texture.width, h = texture.height;
        if (self._rotated && cc.game.renderType === cc.game.RENDER_TYPE_CANVAS) {
          self._rotated = false;
          w = self._texture.width;
          h = self._texture.height;
          self._rect = cc.rect(0, 0, w, h);
        }
        self._rect ? self._checkRect(self._texture) : self._rect = cc.rect(0, 0, w, h);
        self._originalSize || self.setOriginalSize(cc.size(w, h));
        self._offset || self.setOffset(cc.v2(0, 0));
        self._calculateUV();
        self.emit("load");
      },
      _refreshTexture: function _refreshTexture(texture) {
        this._texture = texture;
        texture.loaded ? this._textureLoadedCallback() : texture.once("load", this._textureLoadedCallback, this);
      },
      getOffset: function getOffset() {
        return cc.v2(this._offset);
      },
      setOffset: function setOffset(offsets) {
        this._offset = cc.v2(offsets);
      },
      clone: function clone() {
        return new SpriteFrame(this._texture || this._textureFilename, this._rect, this._rotated, this._offset, this._originalSize);
      },
      setTexture: function setTexture(textureOrTextureFile, rect, rotated, offset, originalSize) {
        this._rect = rect || null;
        offset ? this.setOffset(offset) : this._offset = null;
        originalSize ? this.setOriginalSize(originalSize) : this._originalSize = null;
        this._rotated = rotated || false;
        var texture = textureOrTextureFile;
        if ("string" === typeof texture && texture) {
          this._textureFilename = texture;
          this._loadTexture();
        }
        texture instanceof cc.Texture2D && this._texture !== texture && this._refreshTexture(texture);
        return true;
      },
      _loadTexture: function _loadTexture() {
        if (this._textureFilename) {
          var texture = textureUtil.loadImage(this._textureFilename);
          this._refreshTexture(texture);
        }
      },
      ensureLoadTexture: function ensureLoadTexture() {
        if (this._texture) {
          if (!this._texture.loaded) {
            this._refreshTexture(this._texture);
            textureUtil.postLoadTexture(this._texture);
          }
        } else this._textureFilename && this._loadTexture();
      },
      clearTexture: function clearTexture() {
        this._texture = null;
      },
      _checkRect: function _checkRect(texture) {
        var rect = this._rect;
        var maxX = rect.x, maxY = rect.y;
        if (this._rotated) {
          maxX += rect.height;
          maxY += rect.width;
        } else {
          maxX += rect.width;
          maxY += rect.height;
        }
        maxX > texture.width && cc.errorID(3300, texture.url + "/" + this.name, maxX, texture.width);
        maxY > texture.height && cc.errorID(3400, texture.url + "/" + this.name, maxY, texture.height);
      },
      _calculateSlicedUV: function _calculateSlicedUV() {
        var rect = this._rect;
        var atlasWidth = this._texture.width;
        var atlasHeight = this._texture.height;
        var leftWidth = this._capInsets[INSET_LEFT];
        var rightWidth = this._capInsets[INSET_RIGHT];
        var centerWidth = rect.width - leftWidth - rightWidth;
        var topHeight = this._capInsets[INSET_TOP];
        var bottomHeight = this._capInsets[INSET_BOTTOM];
        var centerHeight = rect.height - topHeight - bottomHeight;
        var uvSliced = this.uvSliced;
        uvSliced.length = 0;
        if (this._rotated) {
          temp_uvs[0].u = rect.x / atlasWidth;
          temp_uvs[1].u = (rect.x + bottomHeight) / atlasWidth;
          temp_uvs[2].u = (rect.x + bottomHeight + centerHeight) / atlasWidth;
          temp_uvs[3].u = (rect.x + rect.height) / atlasWidth;
          temp_uvs[3].v = rect.y / atlasHeight;
          temp_uvs[2].v = (rect.y + leftWidth) / atlasHeight;
          temp_uvs[1].v = (rect.y + leftWidth + centerWidth) / atlasHeight;
          temp_uvs[0].v = (rect.y + rect.width) / atlasHeight;
          for (var row = 0; row < 4; ++row) {
            var rowD = temp_uvs[row];
            for (var col = 0; col < 4; ++col) {
              var colD = temp_uvs[3 - col];
              uvSliced.push({
                u: rowD.u,
                v: colD.v
              });
            }
          }
        } else {
          temp_uvs[0].u = rect.x / atlasWidth;
          temp_uvs[1].u = (rect.x + leftWidth) / atlasWidth;
          temp_uvs[2].u = (rect.x + leftWidth + centerWidth) / atlasWidth;
          temp_uvs[3].u = (rect.x + rect.width) / atlasWidth;
          temp_uvs[3].v = rect.y / atlasHeight;
          temp_uvs[2].v = (rect.y + topHeight) / atlasHeight;
          temp_uvs[1].v = (rect.y + topHeight + centerHeight) / atlasHeight;
          temp_uvs[0].v = (rect.y + rect.height) / atlasHeight;
          for (var _row = 0; _row < 4; ++_row) {
            var _rowD = temp_uvs[_row];
            for (var _col = 0; _col < 4; ++_col) {
              var _colD = temp_uvs[_col];
              uvSliced.push({
                u: _colD.u,
                v: _rowD.v
              });
            }
          }
        }
      },
      _setDynamicAtlasFrame: function _setDynamicAtlasFrame(frame) {
        if (!frame) return;
        this._original = {
          _texture: this._texture,
          _x: this._rect.x,
          _y: this._rect.y
        };
        this._texture = frame.texture;
        this._rect.x = frame.x;
        this._rect.y = frame.y;
        this._calculateUV();
      },
      _resetDynamicAtlasFrame: function _resetDynamicAtlasFrame() {
        if (!this._original) return;
        this._rect.x = this._original._x;
        this._rect.y = this._original._y;
        this._texture = this._original._texture;
        this._original = null;
        this._calculateUV();
      },
      _calculateUV: function _calculateUV() {
        var rect = this._rect, texture = this._texture, uv = this.uv, texw = texture.width, texh = texture.height;
        if (this._rotated) {
          var l = 0 === texw ? 0 : rect.x / texw;
          var r = 0 === texw ? 0 : (rect.x + rect.height) / texw;
          var b = 0 === texh ? 0 : (rect.y + rect.width) / texh;
          var t = 0 === texh ? 0 : rect.y / texh;
          uv[0] = l;
          uv[1] = t;
          uv[2] = l;
          uv[3] = b;
          uv[4] = r;
          uv[5] = t;
          uv[6] = r;
          uv[7] = b;
        } else {
          var _l = 0 === texw ? 0 : rect.x / texw;
          var _r = 0 === texw ? 0 : (rect.x + rect.width) / texw;
          var _b = 0 === texh ? 0 : (rect.y + rect.height) / texh;
          var _t = 0 === texh ? 0 : rect.y / texh;
          uv[0] = _l;
          uv[1] = _b;
          uv[2] = _r;
          uv[3] = _b;
          uv[4] = _l;
          uv[5] = _t;
          uv[6] = _r;
          uv[7] = _t;
        }
        var vertices = this.vertices;
        if (vertices) {
          vertices.nu.length = 0;
          vertices.nv.length = 0;
          for (var i = 0; i < vertices.u.length; i++) {
            vertices.nu[i] = vertices.u[i] / texw;
            vertices.nv[i] = vertices.v[i] / texh;
          }
        }
        this._calculateSlicedUV();
      },
      _serialize: false,
      _deserialize: function _deserialize(data, handle) {
        var rect = data.rect;
        rect && (this._rect = new cc.Rect(rect[0], rect[1], rect[2], rect[3]));
        data.offset && this.setOffset(new cc.Vec2(data.offset[0], data.offset[1]));
        data.originalSize && this.setOriginalSize(new cc.Size(data.originalSize[0], data.originalSize[1]));
        this._rotated = 1 === data.rotated;
        this._name = data.name;
        var capInsets = data.capInsets;
        if (capInsets) {
          this._capInsets[INSET_LEFT] = capInsets[INSET_LEFT];
          this._capInsets[INSET_TOP] = capInsets[INSET_TOP];
          this._capInsets[INSET_RIGHT] = capInsets[INSET_RIGHT];
          this._capInsets[INSET_BOTTOM] = capInsets[INSET_BOTTOM];
        }
        false;
        this.vertices = data.vertices;
        if (this.vertices) {
          this.vertices.nu = [];
          this.vertices.nv = [];
        }
        var textureUuid = data.texture;
        textureUuid && handle.result.push(this, "_textureSetter", textureUuid);
      }
    });
    var proto = SpriteFrame.prototype;
    proto.copyWithZone = proto.clone;
    proto.copy = proto.clone;
    proto.initWithTexture = proto.setTexture;
    cc.SpriteFrame = SpriteFrame;
    module.exports = SpriteFrame;
  }), {
    "../assets/CCAsset": 33,
    "../event/event-target": 86,
    "../utils/texture-util": 211
  } ],
  48: [ (function(require, module, exports) {
    "use strict";
    var Font = require("./CCFont");
    var TTFFont = cc.Class({
      name: "cc.TTFFont",
      extends: Font,
      properties: {
        _fontFamily: null,
        _nativeAsset: {
          type: cc.String,
          get: function get() {
            return this._fontFamily;
          },
          set: function set(value) {
            this._fontFamily = value || "Arial";
          },
          override: true
        }
      }
    });
    cc.TTFFont = module.exports = TTFFont;
  }), {
    "./CCFont": 38
  } ],
  49: [ (function(require, module, exports) {
    "use strict";
    var TextAsset = cc.Class({
      name: "cc.TextAsset",
      extends: cc.Asset,
      properties: {
        text: ""
      },
      toString: function toString() {
        return this.text;
      }
    });
    module.exports = cc.TextAsset = TextAsset;
  }), {} ],
  50: [ (function(require, module, exports) {
    "use strict";
    var _gfx = require("../../renderer/gfx");
    var _gfx2 = _interopRequireDefault(_gfx);
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : {
        default: obj
      };
    }
    var EventTarget = require("../event/event-target");
    var renderer = require("../renderer");
    require("../platform/CCClass");
    var GL_NEAREST = 9728;
    var GL_LINEAR = 9729;
    var GL_REPEAT = 10497;
    var GL_CLAMP_TO_EDGE = 33071;
    var GL_MIRRORED_REPEAT = 33648;
    var GL_RGBA = 6408;
    var CHAR_CODE_0 = 48;
    var CHAR_CODE_1 = 49;
    var idGenerater = new (require("../platform/id-generater"))("Tex");
    var PixelFormat = cc.Enum({
      RGB565: _gfx2.default.TEXTURE_FMT_R5_G6_B5,
      RGB5A1: _gfx2.default.TEXTURE_FMT_R5_G5_B5_A1,
      RGBA4444: _gfx2.default.TEXTURE_FMT_R4_G4_B4_A4,
      RGB888: _gfx2.default.TEXTURE_FMT_RGB8,
      RGBA8888: _gfx2.default.TEXTURE_FMT_RGBA8,
      RGBA32F: _gfx2.default.TEXTURE_FMT_RGBA32F,
      A8: _gfx2.default.TEXTURE_FMT_A8,
      I8: _gfx2.default.TEXTURE_FMT_L8,
      AI8: _gfx2.default.TEXTURE_FMT_L8_A8,
      RGB_PVRTC_2BPPV1: _gfx2.default.TEXTURE_FMT_RGB_PVRTC_2BPPV1,
      RGBA_PVRTC_2BPPV1: _gfx2.default.TEXTURE_FMT_RGBA_PVRTC_2BPPV1,
      RGB_PVRTC_4BPPV1: _gfx2.default.TEXTURE_FMT_RGB_PVRTC_4BPPV1,
      RGBA_PVRTC_4BPPV1: _gfx2.default.TEXTURE_FMT_RGBA_PVRTC_4BPPV1,
      RGB_ETC1: _gfx2.default.TEXTURE_FMT_RGB_ETC1,
      RGBA_ETC1: 1024,
      RGB_ETC2: _gfx2.default.TEXTURE_FMT_RGB_ETC2,
      RGBA_ETC2: _gfx2.default.TEXTURE_FMT_RGBA_ETC2
    });
    var WrapMode = cc.Enum({
      REPEAT: GL_REPEAT,
      CLAMP_TO_EDGE: GL_CLAMP_TO_EDGE,
      MIRRORED_REPEAT: GL_MIRRORED_REPEAT
    });
    var Filter = cc.Enum({
      LINEAR: GL_LINEAR,
      NEAREST: GL_NEAREST
    });
    var FilterIndex = {
      9728: 0,
      9729: 1
    };
    var _images = [];
    var _sharedOpts = {
      width: void 0,
      height: void 0,
      minFilter: void 0,
      magFilter: void 0,
      wrapS: void 0,
      wrapT: void 0,
      format: void 0,
      mipmap: void 0,
      images: void 0,
      image: void 0,
      flipY: void 0,
      premultiplyAlpha: void 0
    };
    function _getSharedOptions() {
      for (var key in _sharedOpts) _sharedOpts[key] = void 0;
      _images.length = 0;
      _sharedOpts.images = _images;
      _sharedOpts.flipY = false;
      return _sharedOpts;
    }
    var Texture2D = cc.Class({
      name: "cc.Texture2D",
      extends: require("../assets/CCAsset"),
      mixins: [ EventTarget ],
      properties: {
        _nativeAsset: {
          get: function get() {
            return this._image;
          },
          set: function set(data) {
            data._compressed && data._data ? this.initWithData(data._data, this._format, data.width, data.height) : this.initWithElement(data);
          },
          override: true
        },
        _hasMipmap: false,
        _format: PixelFormat.RGBA8888,
        _premultiplyAlpha: false,
        _flipY: false,
        _minFilter: Filter.LINEAR,
        _magFilter: Filter.LINEAR,
        _mipFilter: Filter.LINEAR,
        _wrapS: WrapMode.CLAMP_TO_EDGE,
        _wrapT: WrapMode.CLAMP_TO_EDGE
      },
      statics: {
        PixelFormat: PixelFormat,
        WrapMode: WrapMode,
        Filter: Filter,
        _FilterIndex: FilterIndex,
        extnames: [ ".png", ".jpg", ".jpeg", ".bmp", ".webp", ".pvr", ".pkm" ]
      },
      ctor: function ctor() {
        this._id = idGenerater.getNewId();
        this.loaded = false;
        this.width = 0;
        this.height = 0;
        this._hashDirty = true;
        this._hash = 0;
        this._texture = null;
        false;
      },
      getImpl: function getImpl() {
        return this._texture;
      },
      getId: function getId() {
        return this._id;
      },
      toString: function toString() {
        return this.url || "";
      },
      update: function update(options) {
        if (options) {
          var updateImg = false;
          void 0 !== options.width && (this.width = options.width);
          void 0 !== options.height && (this.height = options.height);
          if (void 0 !== options.minFilter) {
            this._minFilter = options.minFilter;
            options.minFilter = FilterIndex[options.minFilter];
          }
          if (void 0 !== options.magFilter) {
            this._magFilter = options.magFilter;
            options.magFilter = FilterIndex[options.magFilter];
          }
          if (void 0 !== options.mipFilter) {
            this._mipFilter = options.mipFilter;
            options.mipFilter = FilterIndex[options.mipFilter];
          }
          void 0 !== options.wrapS && (this._wrapS = options.wrapS);
          void 0 !== options.wrapT && (this._wrapT = options.wrapT);
          void 0 !== options.format && (this._format = options.format);
          if (void 0 !== options.flipY) {
            this._flipY = options.flipY;
            updateImg = true;
          }
          if (void 0 !== options.premultiplyAlpha) {
            this._premultiplyAlpha = options.premultiplyAlpha;
            updateImg = true;
          }
          void 0 !== options.mipmap && (this._hasMipmap = options.mipmap);
          updateImg && this._image && (options.image = this._image);
          if (options.images && options.images.length > 0) this._image = options.images[0]; else if (void 0 !== options.image) {
            this._image = options.image;
            if (!options.images) {
              _images.length = 0;
              options.images = _images;
            }
            options.images.push(options.image);
          }
          options.images && options.images.length > 0 && this._texture.update(options);
          this._hashDirty = true;
        }
      },
      initWithElement: function initWithElement(element) {
        if (!element) return;
        this._image = element;
        var self;
        true;
        this.handleLoadedTexture();
      },
      initWithData: function initWithData(data, pixelFormat, pixelsWidth, pixelsHeight) {
        var opts = _getSharedOptions();
        opts.image = data;
        opts.images = [ opts.image ];
        opts.hasMipmap = this._hasMipmap;
        opts.premultiplyAlpha = this._premultiplyAlpha;
        opts.flipY = this._flipY;
        opts.minFilter = FilterIndex[this._minFilter];
        opts.magFilter = FilterIndex[this._magFilter];
        opts.wrapS = this._wrapS;
        opts.wrapT = this._wrapT;
        opts.format = pixelFormat;
        pixelFormat === PixelFormat.RGBA_ETC1 && (opts.format = PixelFormat.RGB_ETC1);
        opts.width = pixelsWidth;
        opts.height = pixelsHeight;
        this._texture ? this._texture.update(opts) : this._texture = new renderer.Texture2D(renderer.device, opts);
        this.width = pixelsWidth;
        this.height = pixelsHeight;
        this.loaded = true;
        this.emit("load");
        return true;
      },
      getHtmlElementObj: function getHtmlElementObj() {
        return this._image;
      },
      destroy: function destroy() {
        this._image = null;
        this._texture && this._texture.destroy();
        this._super();
      },
      getPixelFormat: function getPixelFormat() {
        return this._format;
      },
      hasPremultipliedAlpha: function hasPremultipliedAlpha() {
        return this._premultiplyAlpha || false;
      },
      hasMipmap: function hasMipmap() {
        return this._hasMipmap || false;
      },
      handleLoadedTexture: function handleLoadedTexture() {
        if (!this._image || !this._image.width || !this._image.height) return;
        this.width = this._image.width;
        this.height = this._image.height;
        var opts = _getSharedOptions();
        opts.image = this._image;
        opts.images = [ opts.image ];
        opts.width = this.width;
        opts.height = this.height;
        opts.hasMipmap = this._hasMipmap;
        opts.format = this._format;
        this._format === PixelFormat.RGBA_ETC1 && (opts.format = PixelFormat.RGB_ETC1);
        opts.premultiplyAlpha = this._premultiplyAlpha;
        opts.flipY = this._flipY;
        opts.minFilter = FilterIndex[this._minFilter];
        opts.magFilter = FilterIndex[this._magFilter];
        opts.wrapS = this._wrapS;
        opts.wrapT = this._wrapT;
        this._texture ? this._texture.update(opts) : this._texture = new renderer.Texture2D(renderer.device, opts);
        this.loaded = true;
        this.emit("load");
        cc.macro.CLEANUP_IMAGE_CACHE && this._image instanceof HTMLImageElement && this._clearImage();
      },
      description: function description() {
        return "<cc.Texture2D | Name = " + this.url + " | Dimensions = " + this.width + " x " + this.height + ">";
      },
      releaseTexture: function releaseTexture() {
        this._image = null;
        this._texture && this._texture.destroy();
      },
      setWrapMode: function setWrapMode(wrapS, wrapT) {
        if (this._wrapS !== wrapS || this._wrapT !== wrapT) {
          var opts = _getSharedOptions();
          opts.wrapS = wrapS;
          opts.wrapT = wrapT;
          this.update(opts);
        }
      },
      setFilters: function setFilters(minFilter, magFilter) {
        if (this._minFilter !== minFilter || this._magFilter !== magFilter) {
          var opts = _getSharedOptions();
          opts.minFilter = minFilter;
          opts.magFilter = magFilter;
          this.update(opts);
        }
      },
      setFlipY: function setFlipY(flipY) {
        if (this._flipY !== flipY) {
          var opts = _getSharedOptions();
          opts.flipY = flipY;
          this.update(opts);
        }
      },
      setPremultiplyAlpha: function setPremultiplyAlpha(premultiply) {
        if (this._premultiplyAlpha !== premultiply) {
          var opts = _getSharedOptions();
          opts.premultiplyAlpha = premultiply;
          this.update(opts);
        }
      },
      setMipmap: function setMipmap(mipmap) {
        if (this._hasMipmap !== mipmap) {
          var opts = _getSharedOptions();
          opts.mipmap = mipmap;
          this.update(opts);
        }
      },
      _getOpts: function _getOpts() {
        var opts = _getSharedOptions();
        opts.width = this.width;
        opts.height = this.height;
        opts.mipmap = this._genMipmap;
        opts.format = this._format;
        opts.premultiplyAlpha = this._premultiplyAlpha;
        opts.anisotropy = this._anisotropy;
        opts.flipY = this._flipY;
        opts.minFilter = FilterIndex[this._minFilter];
        opts.magFilter = FilterIndex[this._magFilter];
        opts.mipFilter = FilterIndex[this._mipFilter];
        opts.wrapS = this._wrapS;
        opts.wrapT = this._wrapT;
        return opts;
      },
      _resetUnderlyingMipmaps: function _resetUnderlyingMipmaps(mipmapSources) {
        var opts = this._getOpts();
        opts.images = mipmapSources || [ null ];
        this._texture ? this._texture.update(opts) : this._texture = new renderer.Texture2D(renderer.device, opts);
      },
      _serialize: (false, false) && function() {
        var extId = "";
        var exportedExts = this._exportedExts;
        !exportedExts && this._native && (exportedExts = [ this._native ]);
        if (exportedExts) {
          var exts = [];
          for (var i = 0; i < exportedExts.length; i++) {
            var _extId = "";
            var ext = exportedExts[i];
            if (ext) {
              var extFormat = ext.split("@");
              _extId = Texture2D.extnames.indexOf(extFormat[0]);
              _extId < 0 && (_extId = ext);
              extFormat[1] && (_extId += "@" + extFormat[1]);
            }
            exts.push(_extId);
          }
          extId = exts.join("_");
        }
        var asset = extId + "," + this._minFilter + "," + this._magFilter + "," + this._wrapS + "," + this._wrapT + "," + (this._premultiplyAlpha ? 1 : 0);
        return asset;
      },
      _deserialize: function _deserialize(data, handle) {
        var device = cc.renderer.device;
        var fields = data.split(",");
        var extIdStr = fields[0];
        if (extIdStr) {
          var extIds = extIdStr.split("_");
          var defaultExt = "";
          var bestExt = "";
          var bestIndex = 999;
          var bestFormat = this._format;
          var SupportTextureFormats = cc.macro.SUPPORT_TEXTURE_FORMATS;
          for (var i = 0; i < extIds.length; i++) {
            var extFormat = extIds[i].split("@");
            var tmpExt = extFormat[0];
            tmpExt = Texture2D.extnames[tmpExt.charCodeAt(0) - CHAR_CODE_0] || tmpExt;
            var index = SupportTextureFormats.indexOf(tmpExt);
            if (-1 !== index && index < bestIndex) {
              var tmpFormat = extFormat[1] ? parseInt(extFormat[1]) : this._format;
              if (".pvr" === tmpExt && !device.ext("WEBGL_compressed_texture_pvrtc")) continue;
              if (!(tmpFormat !== PixelFormat.RGB_ETC1 && tmpFormat !== PixelFormat.RGBA_ETC1 || device.ext("WEBGL_compressed_texture_etc1"))) continue;
              if ((tmpFormat === PixelFormat.RGB_ETC2 || tmpFormat === PixelFormat.RGBA_ETC2) && !device.ext("WEBGL_compressed_texture_etc")) continue;
              bestIndex = index;
              bestExt = tmpExt;
              bestFormat = tmpFormat;
            } else defaultExt || (defaultExt = tmpExt);
          }
          if (bestExt) {
            this._setRawAsset(bestExt);
            this._format = bestFormat;
          } else {
            this._setRawAsset(defaultExt);
            cc.warnID(3120, handle.customEnv.url, defaultExt, defaultExt);
          }
        }
        if (6 === fields.length) {
          this._minFilter = parseInt(fields[1]);
          this._magFilter = parseInt(fields[2]);
          this._wrapS = parseInt(fields[3]);
          this._wrapT = parseInt(fields[4]);
          this._premultiplyAlpha = fields[5].charCodeAt(0) === CHAR_CODE_1;
        }
      },
      _getHash: function _getHash() {
        if (!this._hashDirty) return this._hash;
        var hasMipmap = this._hasMipmap ? 1 : 0;
        var premultiplyAlpha = this._premultiplyAlpha ? 1 : 0;
        var flipY = this._flipY ? 1 : 0;
        var minFilter = this._minFilter === Filter.LINEAR ? 1 : 2;
        var magFilter = this._magFilter === Filter.LINEAR ? 1 : 2;
        var wrapS = this._wrapS === WrapMode.REPEAT ? 1 : this._wrapS === WrapMode.CLAMP_TO_EDGE ? 2 : 3;
        var wrapT = this._wrapT === WrapMode.REPEAT ? 1 : this._wrapT === WrapMode.CLAMP_TO_EDGE ? 2 : 3;
        var pixelFormat = this._format;
        var image = this._image;
        false;
        this._hash = Number("" + minFilter + magFilter + pixelFormat + wrapS + wrapT + hasMipmap + premultiplyAlpha + flipY);
        this._hashDirty = false;
        return this._hash;
      },
      _isCompressed: function _isCompressed() {
        return this._texture && this._texture._compressed;
      },
      _clearImage: function _clearImage() {
        cc.loader.removeItem(this._image.id || this._image.src);
        this._image.src = "";
      }
    });
    cc.Texture2D = module.exports = Texture2D;
  }), {
    "../../renderer/gfx": 256,
    "../assets/CCAsset": 33,
    "../event/event-target": 86,
    "../platform/CCClass": 118,
    "../platform/id-generater": 134,
    "../renderer": 161
  } ],
  51: [ (function(require, module, exports) {
    "use strict";
    require("./CCRawAsset");
    require("./CCAsset");
    require("./CCFont");
    require("./CCPrefab");
    require("./CCAudioClip");
    require("./CCScripts");
    require("./CCSceneAsset");
    require("./CCSpriteFrame");
    require("./CCTexture2D");
    require("./CCRenderTexture");
    require("./CCTTFFont");
    require("./CCSpriteAtlas");
    require("./CCBitmapFont");
    require("./CCLabelAtlas");
    require("./CCTextAsset");
    require("./CCJsonAsset");
    require("./CCBufferAsset");
    require("./CCEffectAsset");
    require("./material/CCMaterial");
  }), {
    "./CCAsset": 33,
    "./CCAudioClip": 34,
    "./CCBitmapFont": 35,
    "./CCBufferAsset": 36,
    "./CCEffectAsset": 37,
    "./CCFont": 38,
    "./CCJsonAsset": 39,
    "./CCLabelAtlas": 40,
    "./CCPrefab": 41,
    "./CCRawAsset": 42,
    "./CCRenderTexture": 43,
    "./CCSceneAsset": 44,
    "./CCScripts": 45,
    "./CCSpriteAtlas": 46,
    "./CCSpriteFrame": 47,
    "./CCTTFFont": 48,
    "./CCTextAsset": 49,
    "./CCTexture2D": 50,
    "./material/CCMaterial": 52
  } ],
  52: [ (function(require, module, exports) {
    "use strict";
    var _effect = require("../../../renderer/core/effect");
    var _effect2 = _interopRequireDefault(_effect);
    var _murmurhash2_gc = require("./murmurhash2_gc");
    var _murmurhash2_gc2 = _interopRequireDefault(_murmurhash2_gc);
    var _utils = require("./utils");
    var _utils2 = _interopRequireDefault(_utils);
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : {
        default: obj
      };
    }
    var Asset = require("../CCAsset");
    var Texture = require("../CCTexture2D");
    var PixelFormat = Texture.PixelFormat;
    var EffectAsset = require("../CCEffectAsset");
    var Material = cc.Class({
      name: "cc.Material",
      extends: Asset,
      ctor: function ctor() {
        this._dirty = true;
        this._effect = null;
        this._owner = null;
      },
      properties: {
        _effectAsset: {
          type: EffectAsset,
          default: null
        },
        _defines: {
          default: {},
          type: Object
        },
        _props: {
          default: {},
          type: Object
        },
        effectName: void 0,
        effectAsset: {
          get: function get() {
            return this._effectAsset;
          },
          set: function set(asset) {
            if (cc.game.renderType === cc.game.RENDER_TYPE_CANVAS) return;
            this._effectAsset = asset;
            if (!asset) {
              cc.error("Can not set an empty effect asset.");
              return;
            }
            this._effect = _effect2.default.parseEffect(asset);
          }
        },
        effect: {
          get: function get() {
            return this._effect;
          }
        },
        owner: {
          get: function get() {
            return this._owner;
          }
        }
      },
      statics: {
        getBuiltinMaterial: function getBuiltinMaterial(name) {
          return cc.AssetLibrary.getBuiltin("material", "builtin-" + name);
        },
        getInstantiatedBuiltinMaterial: function getInstantiatedBuiltinMaterial(name, renderComponent) {
          var builtinMaterial = this.getBuiltinMaterial(name);
          return Material.getInstantiatedMaterial(builtinMaterial, renderComponent);
        },
        getInstantiatedMaterial: function getInstantiatedMaterial(mat, renderComponent) {
          if (mat._owner === renderComponent) return mat;
          var instance = new Material();
          instance.copy(mat);
          instance._name = mat._name + " (Instance)";
          instance._uuid = mat._uuid;
          instance._owner = renderComponent;
          return instance;
        }
      },
      copy: function copy(mat) {
        this.effectAsset = mat.effectAsset;
        for (var name in mat._defines) this.define(name, mat._defines[name]);
        for (var _name in mat._props) this.setProperty(_name, mat._props[_name]);
      },
      setProperty: function setProperty(name, val, force) {
        if (this._props[name] === val && !force) return;
        this._props[name] = val;
        this._dirty = true;
        if (this._effect) if (val instanceof Texture) {
          this._effect.setProperty(name, val.getImpl());
          val.getPixelFormat() === PixelFormat.RGBA_ETC1 && this.define("_USE_ETC1_" + name.toUpperCase(), true);
        } else this._effect.setProperty(name, val);
      },
      getProperty: function getProperty(name) {
        return this._props[name];
      },
      define: function define(name, val, force) {
        if (this._defines[name] === val && !force) return;
        this._defines[name] = val;
        this._dirty = true;
        this._effect && this._effect.define(name, val);
      },
      getDefine: function getDefine(name) {
        return this._defines[name];
      },
      setDirty: function setDirty(dirty) {
        this._dirty = dirty;
      },
      updateHash: function updateHash(hash) {
        this._dirty = false;
        this._hash = hash;
      },
      getHash: function getHash() {
        if (!this._dirty) return this._hash;
        this._dirty = false;
        var effect = this._effect;
        var hashStr = "";
        if (effect) {
          hashStr += _utils2.default.serializeDefines(effect._defines);
          hashStr += _utils2.default.serializeTechniques(effect._techniques);
          hashStr += _utils2.default.serializeUniforms(effect._properties);
        }
        return this._hash = (0, _murmurhash2_gc2.default)(hashStr, 666);
      },
      onLoad: function onLoad() {
        this.effectAsset = this._effectAsset;
        if (!this._effect) return;
        for (var def in this._defines) this.define(def, this._defines[def], true);
        for (var prop in this._props) this.setProperty(prop, this._props[prop], true);
      }
    });
    module.exports = cc.Material = Material;
  }), {
    "../../../renderer/core/effect": 245,
    "../CCAsset": 33,
    "../CCEffectAsset": 37,
    "../CCTexture2D": 50,
    "./murmurhash2_gc": 53,
    "./utils": 54
  } ],
  53: [ (function(require, module, exports) {
    "use strict";
    exports.__esModule = true;
    exports.default = murmurhash2_32_gc;
    function murmurhash2_32_gc(str, seed) {
      var l = str.length, h = seed ^ l, i = 0, k;
      while (l >= 4) {
        k = 255 & str.charCodeAt(i) | (255 & str.charCodeAt(++i)) << 8 | (255 & str.charCodeAt(++i)) << 16 | (255 & str.charCodeAt(++i)) << 24;
        k = 1540483477 * (65535 & k) + ((1540483477 * (k >>> 16) & 65535) << 16);
        k ^= k >>> 24;
        k = 1540483477 * (65535 & k) + ((1540483477 * (k >>> 16) & 65535) << 16);
        h = 1540483477 * (65535 & h) + ((1540483477 * (h >>> 16) & 65535) << 16) ^ k;
        l -= 4;
        ++i;
      }
      switch (l) {
       case 3:
        h ^= (255 & str.charCodeAt(i + 2)) << 16;

       case 2:
        h ^= (255 & str.charCodeAt(i + 1)) << 8;

       case 1:
        h ^= 255 & str.charCodeAt(i);
        h = 1540483477 * (65535 & h) + ((1540483477 * (h >>> 16) & 65535) << 16);
      }
      h ^= h >>> 13;
      h = 1540483477 * (65535 & h) + ((1540483477 * (h >>> 16) & 65535) << 16);
      h ^= h >>> 15;
      return h >>> 0;
    }
    module.exports = exports["default"];
  }), {} ],
  54: [ (function(require, module, exports) {
    "use strict";
    exports.__esModule = true;
    var _enums = require("../../../renderer/enums");
    var _enums2 = _interopRequireDefault(_enums);
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : {
        default: obj
      };
    }
    function serializeDefines(defines) {
      var str = "";
      for (var name in defines) str += name + defines[name];
      return str;
    }
    function serializePass(pass) {
      var str = pass._programName + pass._cullMode;
      pass._blend && (str += pass._blendEq + pass._blendAlphaEq + pass._blendSrc + pass._blendDst + pass._blendSrcAlpha + pass._blendDstAlpha + pass._blendColor);
      pass._depthTest && (str += pass._depthWrite + pass._depthFunc);
      pass._stencilTest && (str += pass._stencilFuncFront + pass._stencilRefFront + pass._stencilMaskFront + pass._stencilFailOpFront + pass._stencilZFailOpFront + pass._stencilZPassOpFront + pass._stencilWriteMaskFront + pass._stencilFuncBack + pass._stencilRefBack + pass._stencilMaskBack + pass._stencilFailOpBack + pass._stencilZFailOpBack + pass._stencilZPassOpBack + pass._stencilWriteMaskBack);
      return str;
    }
    function serializeTechniques(techniques) {
      var hashData = "";
      for (var i = 0; i < techniques.length; i++) {
        var techData = techniques[i];
        hashData += techData.stageIDs;
        for (var j = 0; j < techData.passes.length; j++) hashData += serializePass(techData.passes[j]);
      }
      return hashData;
    }
    function serializeUniforms(uniforms) {
      var hashData = "";
      for (var name in uniforms) {
        var param = uniforms[name];
        var prop = param.value;
        if (!prop) continue;
        switch (param.type) {
         case _enums2.default.PARAM_INT:
         case _enums2.default.PARAM_FLOAT:
          hashData += prop + ";";
          break;

         case _enums2.default.PARAM_INT2:
         case _enums2.default.PARAM_FLOAT2:
          hashData += prop.x + "," + prop.y + ";";
          break;

         case _enums2.default.PARAM_INT4:
         case _enums2.default.PARAM_FLOAT4:
          hashData += prop.x + "," + prop.y + "," + prop.z + "," + prop.w + ";";
          break;

         case _enums2.default.PARAM_COLOR4:
          hashData += prop.r + "," + prop.g + "," + prop.b + "," + prop.a + ";";
          break;

         case _enums2.default.PARAM_MAT2:
          hashData += prop.m00 + "," + prop.m01 + "," + prop.m02 + "," + prop.m03 + ";";
          break;

         case _enums2.default.PARAM_TEXTURE_2D:
         case _enums2.default.PARAM_TEXTURE_CUBE:
          hashData += prop._id + ";";
          break;

         case _enums2.default.PARAM_INT3:
         case _enums2.default.PARAM_FLOAT3:
         case _enums2.default.PARAM_COLOR3:
         case _enums2.default.PARAM_MAT3:
         case _enums2.default.PARAM_MAT4:
          hashData += JSON.stringify(prop) + ";";
        }
      }
      return hashData;
    }
    exports.default = {
      serializeDefines: serializeDefines,
      serializeTechniques: serializeTechniques,
      serializeUniforms: serializeUniforms
    };
    module.exports = exports["default"];
  }), {
    "../../../renderer/enums": 251
  } ],
  55: [ (function(require, module, exports) {
    "use strict";
    var Event = require("../CCNode").EventType;
    var TOP = 1;
    var MID = 2;
    var BOT = 4;
    var LEFT = 8;
    var CENTER = 16;
    var RIGHT = 32;
    var HORIZONTAL = LEFT | CENTER | RIGHT;
    var VERTICAL = TOP | MID | BOT;
    var AlignMode = cc.Enum({
      ONCE: 0,
      ON_WINDOW_RESIZE: 1,
      ALWAYS: 2
    });
    function getReadonlyNodeSize(parent) {
      return parent instanceof cc.Scene ? cc.visibleRect : parent._contentSize;
    }
    function computeInverseTransForTarget(widgetNode, target, out_inverseTranslate, out_inverseScale) {
      var scaleX = widgetNode._parent._scale.x;
      var scaleY = widgetNode._parent._scale.y;
      var translateX = 0;
      var translateY = 0;
      for (var node = widgetNode._parent; ;) {
        var pos = node._position;
        translateX += pos.x;
        translateY += pos.y;
        node = node._parent;
        if (!node) {
          out_inverseTranslate.x = out_inverseTranslate.y = 0;
          out_inverseScale.x = out_inverseScale.y = 1;
          return;
        }
        if (node === target) break;
        var sx = node._scale.x;
        var sy = node._scale.y;
        translateX *= sx;
        translateY *= sy;
        scaleX *= sx;
        scaleY *= sy;
      }
      out_inverseScale.x = 0 !== scaleX ? 1 / scaleX : 1;
      out_inverseScale.y = 0 !== scaleY ? 1 / scaleY : 1;
      out_inverseTranslate.x = -translateX;
      out_inverseTranslate.y = -translateY;
    }
    var tInverseTranslate = cc.Vec2.ZERO;
    var tInverseScale = cc.Vec2.ONE;
    function align(node, widget) {
      var hasTarget = widget._target;
      var target;
      var inverseTranslate, inverseScale;
      if (hasTarget) {
        target = hasTarget;
        inverseTranslate = tInverseTranslate;
        inverseScale = tInverseScale;
        computeInverseTransForTarget(node, target, inverseTranslate, inverseScale);
      } else target = node._parent;
      var targetSize = getReadonlyNodeSize(target);
      var targetAnchor = target._anchorPoint;
      var isRoot = (true, target instanceof cc.Scene);
      var x = node._position.x, y = node._position.y;
      var anchor = node._anchorPoint;
      if (widget._alignFlags & HORIZONTAL) {
        var localLeft, localRight, targetWidth = targetSize.width;
        if (isRoot) {
          localLeft = cc.visibleRect.left.x;
          localRight = cc.visibleRect.right.x;
        } else {
          localLeft = -targetAnchor.x * targetWidth;
          localRight = localLeft + targetWidth;
        }
        localLeft += widget._isAbsLeft ? widget._left : widget._left * targetWidth;
        localRight -= widget._isAbsRight ? widget._right : widget._right * targetWidth;
        if (hasTarget) {
          localLeft += inverseTranslate.x;
          localLeft *= inverseScale.x;
          localRight += inverseTranslate.x;
          localRight *= inverseScale.x;
        }
        var width, anchorX = anchor.x, scaleX = node._scale.x;
        if (scaleX < 0) {
          anchorX = 1 - anchorX;
          scaleX = -scaleX;
        }
        if (widget.isStretchWidth) {
          width = localRight - localLeft;
          0 !== scaleX && (node.width = width / scaleX);
          x = localLeft + anchorX * width;
        } else {
          width = node.width * scaleX;
          if (widget.isAlignHorizontalCenter) {
            var localHorizontalCenter = widget._isAbsHorizontalCenter ? widget._horizontalCenter : widget._horizontalCenter * targetWidth;
            var targetCenter = (.5 - targetAnchor.x) * targetSize.width;
            if (hasTarget) {
              localHorizontalCenter *= inverseScale.x;
              targetCenter += inverseTranslate.x;
              targetCenter *= inverseScale.x;
            }
            x = targetCenter + (anchorX - .5) * width + localHorizontalCenter;
          } else x = widget.isAlignLeft ? localLeft + anchorX * width : localRight + (anchorX - 1) * width;
        }
      }
      if (widget._alignFlags & VERTICAL) {
        var localTop, localBottom, targetHeight = targetSize.height;
        if (isRoot) {
          localBottom = cc.visibleRect.bottom.y;
          localTop = cc.visibleRect.top.y;
        } else {
          localBottom = -targetAnchor.y * targetHeight;
          localTop = localBottom + targetHeight;
        }
        localBottom += widget._isAbsBottom ? widget._bottom : widget._bottom * targetHeight;
        localTop -= widget._isAbsTop ? widget._top : widget._top * targetHeight;
        if (hasTarget) {
          localBottom += inverseTranslate.y;
          localBottom *= inverseScale.y;
          localTop += inverseTranslate.y;
          localTop *= inverseScale.y;
        }
        var height, anchorY = anchor.y, scaleY = node._scale.y;
        if (scaleY < 0) {
          anchorY = 1 - anchorY;
          scaleY = -scaleY;
        }
        if (widget.isStretchHeight) {
          height = localTop - localBottom;
          0 !== scaleY && (node.height = height / scaleY);
          y = localBottom + anchorY * height;
        } else {
          height = node.height * scaleY;
          if (widget.isAlignVerticalCenter) {
            var localVerticalCenter = widget._isAbsVerticalCenter ? widget._verticalCenter : widget._verticalCenter * targetHeight;
            var targetMiddle = (.5 - targetAnchor.y) * targetSize.height;
            if (hasTarget) {
              localVerticalCenter *= inverseScale.y;
              targetMiddle += inverseTranslate.y;
              targetMiddle *= inverseScale.y;
            }
            y = targetMiddle + (anchorY - .5) * height + localVerticalCenter;
          } else y = widget.isAlignBottom ? localBottom + anchorY * height : localTop + (anchorY - 1) * height;
        }
      }
      node.setPosition(x, y);
    }
    function visitNode(node) {
      var widget = node._widget;
      if (widget) {
        false;
        align(node, widget);
        true, widget.alignMode !== AlignMode.ALWAYS ? widget.enabled = false : activeWidgets.push(widget);
      }
      var children = node._children;
      for (var i = 0; i < children.length; i++) {
        var child = children[i];
        child._active && visitNode(child);
      }
    }
    var animationState;
    false;
    function refreshScene() {
      var AnimUtils;
      var EditMode;
      var nowPreviewing;
      var component;
      var animation;
      var _component;
      var _animation;
      false;
      var scene = cc.director.getScene();
      if (scene) {
        widgetManager.isAligning = true;
        if (widgetManager._nodesOrderDirty) {
          activeWidgets.length = 0;
          visitNode(scene);
          widgetManager._nodesOrderDirty = false;
        } else {
          var i, widget, iterator = widgetManager._activeWidgetsIterator;
          var AnimUtils;
          var editingNode;
          var node;
          false;
          for (iterator.i = 0; iterator.i < activeWidgets.length; ++iterator.i) {
            widget = activeWidgets[iterator.i];
            align(widget.node, widget);
          }
        }
        widgetManager.isAligning = false;
      }
      false;
    }
    var adjustWidgetToAllowMovingInEditor = false;
    var adjustWidgetToAllowResizingInEditor = false;
    var activeWidgets = [];
    function updateAlignment(node) {
      var parent = node._parent;
      cc.Node.isNode(parent) && updateAlignment(parent);
      var widget = node._widget || node.getComponent(cc.Widget);
      widget && parent && align(node, widget);
    }
    var widgetManager = cc._widgetManager = module.exports = {
      _AlignFlags: {
        TOP: TOP,
        MID: MID,
        BOT: BOT,
        LEFT: LEFT,
        CENTER: CENTER,
        RIGHT: RIGHT
      },
      isAligning: false,
      _nodesOrderDirty: false,
      _activeWidgetsIterator: new cc.js.array.MutableForwardIterator(activeWidgets),
      init: function init(director) {
        director.on(cc.Director.EVENT_AFTER_UPDATE, refreshScene);
        false;
        cc.sys.isMobile ? window.addEventListener("resize", this.onResized.bind(this)) : cc.view.on("canvas-resize", this.onResized, this);
      },
      add: function add(widget) {
        widget.node._widget = widget;
        this._nodesOrderDirty = true;
        false;
      },
      remove: function remove(widget) {
        widget.node._widget = null;
        this._activeWidgetsIterator.remove(widget);
        false;
      },
      onResized: function onResized() {
        var scene = cc.director.getScene();
        scene && this.refreshWidgetOnResized(scene);
      },
      refreshWidgetOnResized: function refreshWidgetOnResized(node) {
        var widget = cc.Node.isNode(node) && node.getComponent(cc.Widget);
        widget && widget.alignMode === AlignMode.ON_WINDOW_RESIZE && (widget.enabled = true);
        var children = node._children;
        for (var i = 0; i < children.length; i++) {
          var child = children[i];
          this.refreshWidgetOnResized(child);
        }
      },
      updateAlignment: updateAlignment,
      AlignMode: AlignMode
    };
    false;
  }), {
    "../CCNode": 29
  } ],
  56: [ (function(require, module, exports) {
    "use strict";
    var _geomUtils = require("../geom-utils");
    var _geomUtils2 = _interopRequireDefault(_geomUtils);
    var _camera = require("../../renderer/scene/camera");
    var _camera2 = _interopRequireDefault(_camera);
    var _view = require("../../renderer/core/view");
    var _view2 = _interopRequireDefault(_view);
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : {
        default: obj
      };
    }
    var AffineTrans = require("../utils/affine-transform");
    var renderer = require("../renderer/index");
    var RenderFlow = require("../renderer/render-flow");
    var game = require("../CCGame");
    var mat4 = cc.vmath.mat4;
    var vec2 = cc.vmath.vec2;
    var vec3 = cc.vmath.vec3;
    var _mat4_temp_1 = mat4.create();
    var _mat4_temp_2 = mat4.create();
    var _v3_temp_1 = vec3.create();
    var _v3_temp_2 = vec3.create();
    var _v3_temp_3 = vec3.create();
    var _cameras = [];
    var _debugCamera = null;
    function repositionDebugCamera() {
      if (!_debugCamera) return;
      var node = _debugCamera.getNode();
      var canvas = cc.game.canvas;
      node.z = canvas.height / 1.1566;
      node.x = canvas.width / 2;
      node.y = canvas.height / 2;
    }
    var ClearFlags = cc.Enum({
      COLOR: 1,
      DEPTH: 2,
      STENCIL: 4
    });
    var StageFlags = cc.Enum({
      OPAQUE: 1,
      TRANSPARENT: 2
    });
    var Camera = cc.Class({
      name: "cc.Camera",
      extends: cc.Component,
      ctor: function ctor() {
        if (game.renderType !== game.RENDER_TYPE_CANVAS) {
          var camera = new _camera2.default();
          camera.setStages([ "opaque" ]);
          camera.dirty = true;
          this._inited = false;
          this._camera = camera;
        } else this._inited = true;
      },
      editor: false,
      properties: {
        _cullingMask: 4294967295,
        _clearFlags: ClearFlags.DEPTH | ClearFlags.STENCIL,
        _backgroundColor: cc.color(0, 0, 0, 255),
        _depth: 0,
        _zoomRatio: 1,
        _targetTexture: null,
        _fov: 60,
        _orthoSize: 10,
        _nearClip: 1,
        _farClip: 4096,
        _ortho: true,
        _rect: cc.rect(0, 0, 1, 1),
        _renderStages: 1,
        zoomRatio: {
          get: function get() {
            return this._zoomRatio;
          },
          set: function set(value) {
            this._zoomRatio = value;
          }
        },
        fov: {
          get: function get() {
            return this._fov;
          },
          set: function set(v) {
            this._fov = v;
          }
        },
        orthoSize: {
          get: function get() {
            return this._orthoSize;
          },
          set: function set(v) {
            this._orthoSize = v;
          }
        },
        nearClip: {
          get: function get() {
            return this._nearClip;
          },
          set: function set(v) {
            this._nearClip = v;
            this._updateClippingpPlanes();
          }
        },
        farClip: {
          get: function get() {
            return this._farClip;
          },
          set: function set(v) {
            this._farClip = v;
            this._updateClippingpPlanes();
          }
        },
        ortho: {
          get: function get() {
            return this._ortho;
          },
          set: function set(v) {
            this._ortho = v;
            this._updateProjection();
          }
        },
        rect: {
          get: function get() {
            return this._rect;
          },
          set: function set(v) {
            this._rect = v;
            this._updateRect();
          }
        },
        cullingMask: {
          get: function get() {
            return this._cullingMask;
          },
          set: function set(value) {
            this._cullingMask = value;
            this._updateCameraMask();
          }
        },
        clearFlags: {
          get: function get() {
            return this._clearFlags;
          },
          set: function set(value) {
            this._clearFlags = value;
            this._camera && this._camera.setClearFlags(value);
          }
        },
        backgroundColor: {
          get: function get() {
            return this._backgroundColor;
          },
          set: function set(value) {
            this._backgroundColor = value;
            this._updateBackgroundColor();
          }
        },
        depth: {
          get: function get() {
            return this._depth;
          },
          set: function set(value) {
            this._depth = value;
            this._camera && (this._camera._priority = value);
          }
        },
        targetTexture: {
          get: function get() {
            return this._targetTexture;
          },
          set: function set(value) {
            this._targetTexture = value;
            this._updateTargetTexture();
          }
        },
        renderStages: {
          get: function get() {
            return this._renderStages;
          },
          set: function set(val) {
            this._renderStages = val;
            this._updateStages();
          }
        },
        _is3D: {
          get: function get() {
            return this.node && this.node._is3DNode;
          }
        }
      },
      statics: {
        main: null,
        cameras: _cameras,
        ClearFlags: ClearFlags,
        findCamera: function findCamera(node) {
          for (var i = 0, l = _cameras.length; i < l; i++) {
            var camera = _cameras[i];
            if (camera.containsNode(node)) return camera;
          }
          return null;
        },
        _findRendererCamera: function _findRendererCamera(node) {
          var cameras = renderer.scene._cameras;
          for (var i = 0; i < cameras._count; i++) if (cameras._data[i]._cullingMask & node._cullingMask) return cameras._data[i];
          return null;
        },
        _setupDebugCamera: function _setupDebugCamera() {
          if (_debugCamera) return;
          if (game.renderType === game.RENDER_TYPE_CANVAS) return;
          var camera = new _camera2.default();
          _debugCamera = camera;
          camera.setStages([ "opaque" ]);
          camera.setFov(60 * Math.PI / 180);
          camera.setNear(.1);
          camera.setFar(4096);
          camera.dirty = true;
          camera._cullingMask = 1 << cc.Node.BuiltinGroupIndex.DEBUG;
          camera._priority = cc.macro.MAX_ZINDEX;
          camera.setClearFlags(0);
          camera.setColor(0, 0, 0, 0);
          var node = new cc.Node();
          camera.setNode(node);
          repositionDebugCamera();
          cc.view.on("design-resolution-changed", repositionDebugCamera);
          renderer.scene.addCamera(camera);
        }
      },
      _updateCameraMask: function _updateCameraMask() {
        if (this._camera) {
          var mask = this._cullingMask & ~(1 << cc.Node.BuiltinGroupIndex.DEBUG);
          this._camera._cullingMask = mask;
        }
      },
      _updateBackgroundColor: function _updateBackgroundColor() {
        if (!this._camera) return;
        var color = this._backgroundColor;
        this._camera.setColor(color.r / 255, color.g / 255, color.b / 255, color.a / 255);
      },
      _updateTargetTexture: function _updateTargetTexture() {
        if (!this._camera) return;
        var texture = this._targetTexture;
        this._camera._framebuffer = texture ? texture._framebuffer : null;
      },
      _updateClippingpPlanes: function _updateClippingpPlanes() {
        if (!this._camera) return;
        this._camera.setNear(this._nearClip);
        this._camera.setFar(this._farClip);
      },
      _updateProjection: function _updateProjection() {
        if (!this._camera) return;
        var type = this._ortho ? 1 : 0;
        this._camera.setType(type);
      },
      _updateRect: function _updateRect() {
        if (!this._camera) return;
        this._camera.setRect(this._rect);
      },
      _updateStages: function _updateStages() {
        var flags = this._renderStages;
        var stages = this._camera._stages;
        stages.length = 0;
        flags & StageFlags.OPAQUE && stages.push("opaque");
        flags & StageFlags.TRANSPARENT && stages.push("transparent");
      },
      _init: function _init() {
        if (this._inited) return;
        this._inited = true;
        var camera = this._camera;
        if (!camera) return;
        camera.setNode(this.node);
        camera.setClearFlags(this._clearFlags);
        camera._priority = this._depth;
        this._updateBackgroundColor();
        this._updateCameraMask();
        this._updateTargetTexture();
        this._updateClippingpPlanes();
        this._updateProjection();
        this._updateStages();
      },
      onLoad: function onLoad() {
        this._init();
      },
      onEnable: function onEnable() {
        if (true, game.renderType !== game.RENDER_TYPE_CANVAS) {
          cc.director.on(cc.Director.EVENT_BEFORE_DRAW, this.beforeDraw, this);
          renderer.scene.addCamera(this._camera);
        }
        _cameras.push(this);
      },
      onDisable: function onDisable() {
        if (true, game.renderType !== game.RENDER_TYPE_CANVAS) {
          cc.director.off(cc.Director.EVENT_BEFORE_DRAW, this.beforeDraw, this);
          renderer.scene.removeCamera(this._camera);
        }
        cc.js.array.remove(_cameras, this);
      },
      getNodeToCameraTransform: function getNodeToCameraTransform(node) {
        var out = AffineTrans.identity();
        node.getWorldMatrix(_mat4_temp_2);
        if (this.containsNode(node)) {
          this.getWorldToCameraMatrix(_mat4_temp_1);
          mat4.mul(_mat4_temp_2, _mat4_temp_2, _mat4_temp_1);
        }
        AffineTrans.fromMat4(out, _mat4_temp_2);
        return out;
      },
      getCameraToWorldPoint: function getCameraToWorldPoint(point, out) {
        out = out || cc.v2();
        this.getCameraToWorldMatrix(_mat4_temp_1);
        vec2.transformMat4(out, point, _mat4_temp_1);
        return out;
      },
      getWorldToCameraPoint: function getWorldToCameraPoint(point, out) {
        out = out || cc.v2();
        this.getWorldToCameraMatrix(_mat4_temp_1);
        vec2.transformMat4(out, point, _mat4_temp_1);
        return out;
      },
      getCameraToWorldMatrix: function getCameraToWorldMatrix(out) {
        this.getWorldToCameraMatrix(out);
        mat4.invert(out, out);
        return out;
      },
      getWorldToCameraMatrix: function getWorldToCameraMatrix(out) {
        this.node.getWorldRT(_mat4_temp_1);
        var zoomRatio = this.zoomRatio;
        _mat4_temp_1.m00 *= zoomRatio;
        _mat4_temp_1.m01 *= zoomRatio;
        _mat4_temp_1.m04 *= zoomRatio;
        _mat4_temp_1.m05 *= zoomRatio;
        var m12 = _mat4_temp_1.m12;
        var m13 = _mat4_temp_1.m13;
        var center = cc.visibleRect.center;
        _mat4_temp_1.m12 = center.x - (_mat4_temp_1.m00 * m12 + _mat4_temp_1.m04 * m13);
        _mat4_temp_1.m13 = center.y - (_mat4_temp_1.m01 * m12 + _mat4_temp_1.m05 * m13);
        out !== _mat4_temp_1 && mat4.copy(out, _mat4_temp_1);
        return out;
      },
      getRay: function getRay(screenPos) {
        if (!_geomUtils2.default) return screenPos;
        vec3.set(_v3_temp_3, screenPos.x, screenPos.y, 1);
        this._camera.screenToWorld(_v3_temp_2, _v3_temp_3, cc.visibleRect.width, cc.visibleRect.height);
        if (this.ortho) {
          vec3.set(_v3_temp_3, screenPos.x, screenPos.y, -1);
          this._camera.screenToWorld(_v3_temp_1, _v3_temp_3, cc.visibleRect.width, cc.visibleRect.height);
        } else this.node.getWorldPosition(_v3_temp_1);
        return _geomUtils2.default.Ray.fromPoints(_geomUtils2.default.Ray.create(), _v3_temp_1, _v3_temp_2);
      },
      containsNode: function containsNode(node) {
        return node._cullingMask & this.cullingMask;
      },
      render: function render(root) {
        root = root || cc.director.getScene();
        if (!root) return null;
        this.node.getWorldMatrix(_mat4_temp_1);
        this.beforeDraw();
        RenderFlow.visit(root);
        renderer._forward.renderCamera(this._camera, renderer.scene);
      },
      _layout: function _layout() {
        var height = cc.game.canvas.height / cc.view._scaleY;
        var targetTexture = this._targetTexture;
        targetTexture && (height = targetTexture.height);
        var fov = this._fov * cc.macro.RAD;
        this.node.z = height / (2 * Math.tan(fov / 2));
        fov = 2 * Math.atan(Math.tan(fov / 2) / this.zoomRatio);
        this._camera.setFov(fov);
        this._camera.setOrthoHeight(height / 2 / this.zoomRatio);
      },
      beforeDraw: function beforeDraw() {
        if (!this._camera) return;
        if (this.node._is3DNode) {
          this._camera.setFov(this._fov * cc.macro.RAD);
          this._camera.setOrthoHeight(this._orthoSize);
        } else this._layout();
        this._camera.dirty = true;
      }
    });
    module.exports = cc.Camera = Camera;
  }), {
    "../../renderer/core/view": 250,
    "../../renderer/scene/camera": 278,
    "../CCGame": 28,
    "../geom-utils": void 0,
    "../renderer/index": 161,
    "../renderer/render-flow": 162,
    "../utils/affine-transform": 194
  } ],
  57: [ (function(require, module, exports) {
    "use strict";
    require("./platform/CCClass");
    var Flags = require("./platform/CCObject").Flags;
    var jsArray = require("./platform/js").array;
    var IsStartCalled = Flags.IsStartCalled;
    var IsOnEnableCalled = Flags.IsOnEnableCalled;
    var IsEditorOnEnableCalled = Flags.IsEditorOnEnableCalled;
    var callerFunctor = false;
    var callOnEnableInTryCatch = false;
    var callStartInTryCatch = false;
    var callUpdateInTryCatch = false;
    var callLateUpdateInTryCatch = false;
    var callOnDisableInTryCatch = false;
    var callStart = function(c) {
      c.start();
      c._objFlags |= IsStartCalled;
    };
    var callUpdate = function(c, dt) {
      c.update(dt);
    };
    var callLateUpdate = function(c, dt) {
      c.lateUpdate(dt);
    };
    function sortedIndex(array, comp) {
      var order = comp.constructor._executionOrder;
      var id = comp._id;
      for (var l = 0, h = array.length - 1, m = h >>> 1; l <= h; m = l + h >>> 1) {
        var test = array[m];
        var testOrder = test.constructor._executionOrder;
        if (testOrder > order) h = m - 1; else if (testOrder < order) l = m + 1; else {
          var testId = test._id;
          if (testId > id) h = m - 1; else {
            if (!(testId < id)) return m;
            l = m + 1;
          }
        }
      }
      return ~l;
    }
    function stableRemoveInactive(iterator, flagToClear) {
      var array = iterator.array;
      var next = iterator.i + 1;
      while (next < array.length) {
        var comp = array[next];
        if (comp._enabled && comp.node._activeInHierarchy) ++next; else {
          iterator.removeAt(next);
          flagToClear && (comp._objFlags &= ~flagToClear);
        }
      }
    }
    var LifeCycleInvoker = cc.Class({
      __ctor__: function __ctor__(invokeFunc) {
        var Iterator = jsArray.MutableForwardIterator;
        this._zero = new Iterator([]);
        this._neg = new Iterator([]);
        this._pos = new Iterator([]);
        false;
        this._invoke = invokeFunc;
      },
      statics: {
        stableRemoveInactive: stableRemoveInactive
      },
      add: null,
      remove: null,
      invoke: null
    });
    function compareOrder(a, b) {
      return a.constructor._executionOrder - b.constructor._executionOrder;
    }
    var OneOffInvoker = cc.Class({
      extends: LifeCycleInvoker,
      add: function add(comp) {
        var order = comp.constructor._executionOrder;
        (0 === order ? this._zero : order < 0 ? this._neg : this._pos).array.push(comp);
      },
      remove: function remove(comp) {
        var order = comp.constructor._executionOrder;
        (0 === order ? this._zero : order < 0 ? this._neg : this._pos).fastRemove(comp);
      },
      cancelInactive: function cancelInactive(flagToClear) {
        stableRemoveInactive(this._zero, flagToClear);
        stableRemoveInactive(this._neg, flagToClear);
        stableRemoveInactive(this._pos, flagToClear);
      },
      invoke: function invoke() {
        var compsNeg = this._neg;
        if (compsNeg.array.length > 0) {
          compsNeg.array.sort(compareOrder);
          this._invoke(compsNeg);
          compsNeg.array.length = 0;
        }
        this._invoke(this._zero);
        this._zero.array.length = 0;
        var compsPos = this._pos;
        if (compsPos.array.length > 0) {
          compsPos.array.sort(compareOrder);
          this._invoke(compsPos);
          compsPos.array.length = 0;
        }
      }
    });
    var ReusableInvoker = cc.Class({
      extends: LifeCycleInvoker,
      add: function add(comp) {
        var order = comp.constructor._executionOrder;
        if (0 === order) this._zero.array.push(comp); else {
          var array = order < 0 ? this._neg.array : this._pos.array;
          var i = sortedIndex(array, comp);
          i < 0 && array.splice(~i, 0, comp);
        }
      },
      remove: function remove(comp) {
        var order = comp.constructor._executionOrder;
        if (0 === order) this._zero.fastRemove(comp); else {
          var iterator = order < 0 ? this._neg : this._pos;
          var i = sortedIndex(iterator.array, comp);
          i >= 0 && iterator.removeAt(i);
        }
      },
      invoke: function invoke(dt) {
        this._neg.array.length > 0 && this._invoke(this._neg, dt);
        this._invoke(this._zero, dt);
        this._pos.array.length > 0 && this._invoke(this._pos, dt);
      }
    });
    function enableInEditor(comp) {
      if (!(comp._objFlags & IsEditorOnEnableCalled)) {
        cc.engine.emit("component-enabled", comp.uuid);
        comp._objFlags |= IsEditorOnEnableCalled;
      }
    }
    function createInvokeImpl(funcOrCode, useDt) {
      if ("function" === typeof funcOrCode) return useDt ? function(iterator, dt) {
        var array = iterator.array;
        for (iterator.i = 0; iterator.i < array.length; ++iterator.i) {
          var comp = array[iterator.i];
          funcOrCode(comp, dt);
        }
      } : function(iterator) {
        var array = iterator.array;
        for (iterator.i = 0; iterator.i < array.length; ++iterator.i) {
          var comp = array[iterator.i];
          funcOrCode(comp);
        }
      };
      var body = "var a=it.array;for(it.i=0;it.i<a.length;++it.i){var c=a[it.i];" + funcOrCode + "}";
      return useDt ? Function("it", "dt", body) : Function("it", body);
    }
    function ctor() {
      this.startInvoker = new OneOffInvoker(createInvokeImpl(callStart));
      this.updateInvoker = new ReusableInvoker(createInvokeImpl(callUpdate, true));
      this.lateUpdateInvoker = new ReusableInvoker(createInvokeImpl(callLateUpdate, true));
      this.scheduleInNextFrame = [];
      this._updating = false;
    }
    var ComponentScheduler = cc.Class({
      ctor: ctor,
      unscheduleAll: ctor,
      statics: {
        LifeCycleInvoker: LifeCycleInvoker,
        OneOffInvoker: OneOffInvoker,
        createInvokeImpl: createInvokeImpl,
        invokeOnEnable: function(iterator) {
          var compScheduler = cc.director._compScheduler;
          var array = iterator.array;
          for (iterator.i = 0; iterator.i < array.length; ++iterator.i) {
            var comp = array[iterator.i];
            if (comp._enabled) {
              comp.onEnable();
              var deactivatedDuringOnEnable = !comp.node._activeInHierarchy;
              deactivatedDuringOnEnable || compScheduler._onEnabled(comp);
            }
          }
        }
      },
      _onEnabled: function _onEnabled(comp) {
        cc.director.getScheduler().resumeTarget(comp);
        comp._objFlags |= IsOnEnableCalled;
        this._updating ? this.scheduleInNextFrame.push(comp) : this._scheduleImmediate(comp);
      },
      _onDisabled: function _onDisabled(comp) {
        cc.director.getScheduler().pauseTarget(comp);
        comp._objFlags &= ~IsOnEnableCalled;
        var index = this.scheduleInNextFrame.indexOf(comp);
        if (index >= 0) {
          jsArray.fastRemoveAt(this.scheduleInNextFrame, index);
          return;
        }
        !comp.start || comp._objFlags & IsStartCalled || this.startInvoker.remove(comp);
        comp.update && this.updateInvoker.remove(comp);
        comp.lateUpdate && this.lateUpdateInvoker.remove(comp);
      },
      enableComp: function(comp, invoker) {
        if (!(comp._objFlags & IsOnEnableCalled)) {
          if (comp.onEnable) {
            if (invoker) {
              invoker.add(comp);
              return;
            }
            comp.onEnable();
            var deactivatedDuringOnEnable = !comp.node._activeInHierarchy;
            if (deactivatedDuringOnEnable) return;
          }
          this._onEnabled(comp);
        }
      },
      disableComp: function(comp) {
        if (comp._objFlags & IsOnEnableCalled) {
          comp.onDisable && comp.onDisable();
          this._onDisabled(comp);
        }
      },
      _scheduleImmediate: function _scheduleImmediate(comp) {
        !comp.start || comp._objFlags & IsStartCalled || this.startInvoker.add(comp);
        comp.update && this.updateInvoker.add(comp);
        comp.lateUpdate && this.lateUpdateInvoker.add(comp);
      },
      _deferredSchedule: function _deferredSchedule() {
        var comps = this.scheduleInNextFrame;
        for (var i = 0, len = comps.length; i < len; i++) {
          var comp = comps[i];
          this._scheduleImmediate(comp);
        }
        comps.length = 0;
      },
      startPhase: function startPhase() {
        this._updating = true;
        this.scheduleInNextFrame.length > 0 && this._deferredSchedule();
        this.startInvoker.invoke();
      },
      updatePhase: function updatePhase(dt) {
        this.updateInvoker.invoke(dt);
      },
      lateUpdatePhase: function lateUpdatePhase(dt) {
        this.lateUpdateInvoker.invoke(dt);
        this._updating = false;
      }
    });
    module.exports = ComponentScheduler;
  }), {
    "./platform/CCClass": 118,
    "./platform/CCObject": 124,
    "./platform/js": 138,
    "./utils/misc": 204
  } ],
  58: [ (function(require, module, exports) {
    "use strict";
    var AnimationAnimator = require("../../animation/animation-animator");
    var AnimationClip = require("../../animation/animation-clip");
    var EventTarget = require("../event/event-target");
    var js = require("../platform/js");
    function equalClips(clip1, clip2) {
      if (clip1 === clip2) return true;
      return clip1 && clip2 && (clip1.name === clip2.name || clip1._uuid === clip2._uuid);
    }
    var EventType = cc.Enum({
      PLAY: "play",
      STOP: "stop",
      PAUSE: "pause",
      RESUME: "resume",
      LASTFRAME: "lastframe",
      FINISHED: "finished"
    });
    var Animation = cc.Class({
      name: "cc.Animation",
      extends: require("./CCComponent"),
      mixins: [ EventTarget ],
      editor: false,
      statics: {
        EventType: EventType
      },
      ctor: function ctor() {
        cc.EventTarget.call(this);
        this._animator = null;
        this._nameToState = js.createMap(true);
        this._didInit = false;
        this._currentClip = null;
      },
      properties: {
        _defaultClip: {
          default: null,
          type: AnimationClip
        },
        defaultClip: {
          type: AnimationClip,
          get: function get() {
            return this._defaultClip;
          },
          set: function set(value) {
            true;
            return;
            var clips;
            var i, l;
          },
          tooltip: false
        },
        currentClip: {
          get: function get() {
            return this._currentClip;
          },
          set: function set(value) {
            this._currentClip = value;
          },
          type: AnimationClip,
          visible: false
        },
        _writableClips: {
          get: function get() {
            return this._clips;
          },
          set: function set(val) {
            this._didInit = false;
            this._clips = val;
            this._init();
          },
          type: [ AnimationClip ]
        },
        _clips: {
          default: [],
          type: [ AnimationClip ],
          tooltip: false,
          visible: true
        },
        playOnLoad: {
          default: false,
          tooltip: false
        }
      },
      start: function start() {
        if ((true, this.playOnLoad) && this._defaultClip) {
          var isPlaying = this._animator && this._animator.isPlaying;
          if (!isPlaying) {
            var state = this.getAnimationState(this._defaultClip.name);
            this._animator.playState(state);
          }
        }
      },
      onEnable: function onEnable() {
        this._animator && this._animator.resume();
      },
      onDisable: function onDisable() {
        this._animator && this._animator.pause();
      },
      onDestroy: function onDestroy() {
        this.stop();
      },
      getClips: function getClips() {
        return this._clips;
      },
      play: function play(name, startTime) {
        var state = this.playAdditive(name, startTime);
        this._animator.stopStatesExcept(state);
        return state;
      },
      playAdditive: function playAdditive(name, startTime) {
        this._init();
        var state = this.getAnimationState(name || this._defaultClip && this._defaultClip.name);
        if (state) {
          this.enabled = true;
          var animator = this._animator;
          if (animator.isPlaying && state.isPlaying) if (state.isPaused) animator.resumeState(state); else {
            animator.stopState(state);
            animator.playState(state, startTime);
          } else animator.playState(state, startTime);
          this.enabledInHierarchy || animator.pause();
          this.currentClip = state.clip;
        }
        return state;
      },
      stop: function stop(name) {
        if (!this._didInit) return;
        if (name) {
          var state = this._nameToState[name];
          state && this._animator.stopState(state);
        } else this._animator.stop();
      },
      pause: function pause(name) {
        if (!this._didInit) return;
        if (name) {
          var state = this._nameToState[name];
          state && this._animator.pauseState(state);
        } else this.enabled = false;
      },
      resume: function resume(name) {
        if (!this._didInit) return;
        if (name) {
          var state = this._nameToState[name];
          state && this._animator.resumeState(state);
        } else this.enabled = true;
      },
      setCurrentTime: function setCurrentTime(time, name) {
        this._init();
        if (name) {
          var state = this._nameToState[name];
          state && this._animator.setStateTime(state, time);
        } else this._animator.setStateTime(time);
      },
      getAnimationState: function getAnimationState(name) {
        this._init();
        var state = this._nameToState[name];
        false;
        state && !state.curveLoaded && this._animator._reloadClip(state);
        return state || null;
      },
      addClip: function addClip(clip, newName) {
        if (!clip) {
          cc.warnID(3900);
          return;
        }
        this._init();
        cc.js.array.contains(this._clips, clip) || this._clips.push(clip);
        newName = newName || clip.name;
        var oldState = this._nameToState[newName];
        if (oldState) {
          if (oldState.clip === clip) return oldState;
          var index = this._clips.indexOf(oldState.clip);
          -1 !== index && this._clips.splice(index, 1);
        }
        var newState = new cc.AnimationState(clip, newName);
        this._nameToState[newName] = newState;
        return newState;
      },
      removeClip: function removeClip(clip, force) {
        if (!clip) {
          cc.warnID(3901);
          return;
        }
        this._init();
        var state = void 0;
        for (var name in this._nameToState) {
          state = this._nameToState[name];
          var stateClip = state.clip;
          if (stateClip === clip) break;
        }
        if (clip === this._defaultClip) {
          if (!force) {
            true;
            cc.warnID(3902);
            return;
          }
          this._defaultClip = null;
        }
        if (state && state.isPlaying) {
          if (!force) {
            true;
            cc.warnID(3903);
            return;
          }
          this.stop(state.name);
        }
        this._clips = this._clips.filter((function(item) {
          return item !== clip;
        }));
        state && delete this._nameToState[state.name];
      },
      sample: function sample(name) {
        this._init();
        if (name) {
          var state = this._nameToState[name];
          state && state.sample();
        } else this._animator.sample();
      },
      on: function on(type, callback, target, useCapture) {
        this._init();
        var ret = this._EventTargetOn(type, callback, target, useCapture);
        if ("lastframe" === type) {
          var array = this._animator._anims.array;
          for (var i = 0; i < array.length; ++i) {
            var state = array[i];
            state._lastframeEventOn = true;
          }
        }
        return ret;
      },
      off: function off(type, callback, target, useCapture) {
        this._init();
        if ("lastframe" === type) {
          var nameToState = this._nameToState;
          for (var name in nameToState) {
            var state = nameToState[name];
            state._lastframeEventOn = false;
          }
        }
        this._EventTargetOff(type, callback, target, useCapture);
      },
      _init: function _init() {
        if (this._didInit) return;
        this._didInit = true;
        this._animator = new AnimationAnimator(this.node, this);
        this._createStates();
      },
      _createStates: function _createStates() {
        this._nameToState = js.createMap(true);
        var state = null;
        var defaultClipState = false;
        for (var i = 0; i < this._clips.length; ++i) {
          var clip = this._clips[i];
          if (clip) {
            state = new cc.AnimationState(clip);
            false;
            this._nameToState[state.name] = state;
            equalClips(this._defaultClip, clip) && (defaultClipState = state);
          }
        }
        if (this._defaultClip && !defaultClipState) {
          state = new cc.AnimationState(this._defaultClip);
          false;
          this._nameToState[state.name] = state;
        }
      }
    });
    Animation.prototype._EventTargetOn = EventTarget.prototype.on;
    Animation.prototype._EventTargetOff = EventTarget.prototype.off;
    cc.Animation = module.exports = Animation;
  }), {
    "../../animation/animation-animator": 10,
    "../../animation/animation-clip": 11,
    "../event/event-target": 86,
    "../platform/js": 138,
    "./CCComponent": 62
  } ],
  59: [ (function(require, module, exports) {
    "use strict";
    var BlockEvents = [ "touchstart", "touchmove", "touchend", "mousedown", "mousemove", "mouseup", "mouseenter", "mouseleave", "mousewheel" ];
    function stopPropagation(event) {
      event.stopPropagation();
    }
    var BlockInputEvents = cc.Class({
      name: "cc.BlockInputEvents",
      extends: require("./CCComponent"),
      editor: {
        menu: "i18n:MAIN_MENU.component.ui/Block Input Events",
        inspector: "packages://inspector/inspectors/comps/block-input-events.js",
        help: "i18n:COMPONENT.help_url.block_input_events"
      },
      onEnable: function onEnable() {
        for (var i = 0; i < BlockEvents.length; i++) this.node.on(BlockEvents[i], stopPropagation, this);
      },
      onDisable: function onDisable() {
        for (var i = 0; i < BlockEvents.length; i++) this.node.off(BlockEvents[i], stopPropagation, this);
      }
    });
    cc.BlockInputEvents = module.exports = BlockInputEvents;
  }), {
    "./CCComponent": 62
  } ],
  60: [ (function(require, module, exports) {
    "use strict";
    var Component = require("./CCComponent");
    var GraySpriteState = require("../utils/gray-sprite-state");
    var Transition = cc.Enum({
      NONE: 0,
      COLOR: 1,
      SPRITE: 2,
      SCALE: 3
    });
    var State = cc.Enum({
      NORMAL: 0,
      HOVER: 1,
      PRESSED: 2,
      DISABLED: 3
    });
    var Button = cc.Class({
      name: "cc.Button",
      extends: Component,
      mixins: [ GraySpriteState ],
      ctor: function ctor() {
        this._pressed = false;
        this._hovered = false;
        this._fromColor = null;
        this._toColor = null;
        this._time = 0;
        this._transitionFinished = true;
        this._fromScale = cc.Vec2.ZERO;
        this._toScale = cc.Vec2.ZERO;
        this._originalScale = null;
        this._graySpriteMaterial = null;
        this._spriteMaterial = null;
        this._sprite = null;
      },
      editor: false,
      properties: {
        interactable: {
          default: true,
          tooltip: false,
          notify: function notify() {
            this._updateState();
            this.interactable || this._resetState();
          },
          animatable: false
        },
        _resizeToTarget: {
          animatable: false,
          set: function set(value) {
            value && this._resizeNodeToTargetNode();
          }
        },
        enableAutoGrayEffect: {
          default: false,
          tooltip: false,
          notify: function notify() {
            this._updateDisabledState();
          }
        },
        transition: {
          default: Transition.NONE,
          tooltip: false,
          type: Transition,
          animatable: false,
          notify: function notify(oldValue) {
            this._updateTransition(oldValue);
          },
          formerlySerializedAs: "transition"
        },
        normalColor: {
          default: cc.color(214, 214, 214),
          displayName: "Normal",
          tooltip: false,
          notify: function notify() {
            this.transition === Transition.Color && this._getButtonState() === State.NORMAL && (this._getTarget().opacity = this.normalColor.a);
            this._updateState();
          }
        },
        pressedColor: {
          default: cc.color(211, 211, 211),
          displayName: "Pressed",
          tooltip: false,
          notify: function notify() {
            this.transition === Transition.Color && this._getButtonState() === State.PRESSED && (this._getTarget().opacity = this.pressedColor.a);
            this._updateState();
          },
          formerlySerializedAs: "pressedColor"
        },
        hoverColor: {
          default: cc.Color.WHITE,
          displayName: "Hover",
          tooltip: false,
          notify: function notify() {
            this.transition === Transition.Color && this._getButtonState() === State.HOVER && (this._getTarget().opacity = this.hoverColor.a);
            this._updateState();
          },
          formerlySerializedAs: "hoverColor"
        },
        disabledColor: {
          default: cc.color(124, 124, 124),
          displayName: "Disabled",
          tooltip: false,
          notify: function notify() {
            this.transition === Transition.Color && this._getButtonState() === State.DISABLED && (this._getTarget().opacity = this.disabledColor.a);
            this._updateState();
          }
        },
        duration: {
          default: .1,
          range: [ 0, 10 ],
          tooltip: false
        },
        zoomScale: {
          default: 1.2,
          tooltip: false
        },
        normalSprite: {
          default: null,
          type: cc.SpriteFrame,
          displayName: "Normal",
          tooltip: false,
          notify: function notify() {
            this._updateState();
          }
        },
        pressedSprite: {
          default: null,
          type: cc.SpriteFrame,
          displayName: "Pressed",
          tooltip: false,
          formerlySerializedAs: "pressedSprite",
          notify: function notify() {
            this._updateState();
          }
        },
        hoverSprite: {
          default: null,
          type: cc.SpriteFrame,
          displayName: "Hover",
          tooltip: false,
          formerlySerializedAs: "hoverSprite",
          notify: function notify() {
            this._updateState();
          }
        },
        disabledSprite: {
          default: null,
          type: cc.SpriteFrame,
          displayName: "Disabled",
          tooltip: false,
          notify: function notify() {
            this._updateState();
          }
        },
        target: {
          default: null,
          type: cc.Node,
          tooltip: false,
          notify: function notify(oldValue) {
            this._applyTarget();
            oldValue && this.target !== oldValue && this._unregisterTargetEvent(oldValue);
          }
        },
        clickEvents: {
          default: [],
          type: cc.Component.EventHandler,
          tooltip: false
        }
      },
      statics: {
        Transition: Transition
      },
      __preload: function __preload() {
        this._applyTarget();
        this._updateState();
      },
      _resetState: function _resetState() {
        this._pressed = false;
        this._hovered = false;
        var target = this._getTarget();
        var transition = this.transition;
        var originalScale = this._originalScale;
        transition === Transition.COLOR && this.interactable ? this._setTargetColor(this.normalColor) : transition === Transition.SCALE && originalScale && target.setScale(originalScale.x, originalScale.y);
        this._transitionFinished = true;
      },
      onEnable: function onEnable() {
        this.normalSprite && this.normalSprite.ensureLoadTexture();
        this.hoverSprite && this.hoverSprite.ensureLoadTexture();
        this.pressedSprite && this.pressedSprite.ensureLoadTexture();
        this.disabledSprite && this.disabledSprite.ensureLoadTexture();
        true;
        this._registerNodeEvent();
      },
      onDisable: function onDisable() {
        this._resetState();
        true;
        this._unregisterNodeEvent();
      },
      _getTarget: function _getTarget() {
        return this.target ? this.target : this.node;
      },
      _onTargetSpriteFrameChanged: function _onTargetSpriteFrameChanged(comp) {
        this.transition === Transition.SPRITE && this._setCurrentStateSprite(comp.spriteFrame);
      },
      _onTargetColorChanged: function _onTargetColorChanged(color) {
        this.transition === Transition.COLOR && this._setCurrentStateColor(color);
      },
      _onTargetScaleChanged: function _onTargetScaleChanged() {
        var target = this._getTarget();
        if (this._originalScale && (this.transition !== Transition.SCALE || this._transitionFinished)) {
          this._originalScale.x = target.scaleX;
          this._originalScale.y = target.scaleY;
        }
      },
      _setTargetColor: function _setTargetColor(color) {
        var target = this._getTarget();
        target.color = color;
        target.opacity = color.a;
      },
      _getStateColor: function _getStateColor(state) {
        switch (state) {
         case State.NORMAL:
          return this.normalColor;

         case State.HOVER:
          return this.hoverColor;

         case State.PRESSED:
          return this.pressedColor;

         case State.DISABLED:
          return this.disabledColor;
        }
      },
      _getStateSprite: function _getStateSprite(state) {
        switch (state) {
         case State.NORMAL:
          return this.normalSprite;

         case State.HOVER:
          return this.hoverSprite;

         case State.PRESSED:
          return this.pressedSprite;

         case State.DISABLED:
          return this.disabledSprite;
        }
      },
      _setCurrentStateColor: function _setCurrentStateColor(color) {
        switch (this._getButtonState()) {
         case State.NORMAL:
          this.normalColor = color;
          break;

         case State.HOVER:
          this.hoverColor = color;
          break;

         case State.PRESSED:
          this.pressedColor = color;
          break;

         case State.DISABLED:
          this.disabledColor = color;
        }
      },
      _setCurrentStateSprite: function _setCurrentStateSprite(spriteFrame) {
        switch (this._getButtonState()) {
         case State.NORMAL:
          this.normalSprite = spriteFrame;
          break;

         case State.HOVER:
          this.hoverSprite = spriteFrame;
          break;

         case State.PRESSED:
          this.pressedSprite = spriteFrame;
          break;

         case State.DISABLED:
          this.disabledSprite = spriteFrame;
        }
      },
      update: function update(dt) {
        var target = this._getTarget();
        if (this._transitionFinished) return;
        if (this.transition !== Transition.COLOR && this.transition !== Transition.SCALE) return;
        this.time += dt;
        var ratio = 1;
        this.duration > 0 && (ratio = this.time / this.duration);
        ratio >= 1 && (ratio = 1);
        if (this.transition === Transition.COLOR) {
          var color = this._fromColor.lerp(this._toColor, ratio);
          this._setTargetColor(color);
        } else this.transition === Transition.SCALE && this._originalScale && (target.scale = this._fromScale.lerp(this._toScale, ratio));
        1 === ratio && (this._transitionFinished = true);
      },
      _registerNodeEvent: function _registerNodeEvent() {
        this.node.on(cc.Node.EventType.TOUCH_START, this._onTouchBegan, this);
        this.node.on(cc.Node.EventType.TOUCH_MOVE, this._onTouchMove, this);
        this.node.on(cc.Node.EventType.TOUCH_END, this._onTouchEnded, this);
        this.node.on(cc.Node.EventType.TOUCH_CANCEL, this._onTouchCancel, this);
        this.node.on(cc.Node.EventType.MOUSE_ENTER, this._onMouseMoveIn, this);
        this.node.on(cc.Node.EventType.MOUSE_LEAVE, this._onMouseMoveOut, this);
      },
      _unregisterNodeEvent: function _unregisterNodeEvent() {
        this.node.off(cc.Node.EventType.TOUCH_START, this._onTouchBegan, this);
        this.node.off(cc.Node.EventType.TOUCH_MOVE, this._onTouchMove, this);
        this.node.off(cc.Node.EventType.TOUCH_END, this._onTouchEnded, this);
        this.node.off(cc.Node.EventType.TOUCH_CANCEL, this._onTouchCancel, this);
        this.node.off(cc.Node.EventType.MOUSE_ENTER, this._onMouseMoveIn, this);
        this.node.off(cc.Node.EventType.MOUSE_LEAVE, this._onMouseMoveOut, this);
      },
      _registerTargetEvent: function _registerTargetEvent(target) {
        false;
        target.on(cc.Node.EventType.SCALE_CHANGED, this._onTargetScaleChanged, this);
      },
      _unregisterTargetEvent: function _unregisterTargetEvent(target) {
        false;
        target.off(cc.Node.EventType.SCALE_CHANGED, this._onTargetScaleChanged, this);
      },
      _getTargetSprite: function _getTargetSprite(target) {
        var sprite = null;
        target && (sprite = target.getComponent(cc.Sprite));
        return sprite;
      },
      _applyTarget: function _applyTarget() {
        var target = this._getTarget();
        this._sprite = this._getTargetSprite(target);
        this._originalScale || (this._originalScale = cc.Vec2.ZERO);
        this._originalScale.x = target.scaleX;
        this._originalScale.y = target.scaleY;
        this._registerTargetEvent(target);
      },
      _onTouchBegan: function _onTouchBegan(event) {
        if (!this.interactable || !this.enabledInHierarchy) return;
        this._pressed = true;
        this._updateState();
        event.stopPropagation();
      },
      _onTouchMove: function _onTouchMove(event) {
        if (!this.interactable || !this.enabledInHierarchy || !this._pressed) return;
        var touch = event.touch;
        var hit = this.node._hitTest(touch.getLocation());
        var target = this._getTarget();
        var originalScale = this._originalScale;
        if (this.transition === Transition.SCALE && originalScale) if (hit) {
          this._fromScale.x = originalScale.x;
          this._fromScale.y = originalScale.y;
          this._toScale.x = originalScale.x * this.zoomScale;
          this._toScale.y = originalScale.y * this.zoomScale;
          this._transitionFinished = false;
        } else {
          this.time = 0;
          this._transitionFinished = true;
          target.setScale(originalScale.x, originalScale.y);
        } else {
          var state = void 0;
          state = hit ? State.PRESSED : State.NORMAL;
          this._applyTransition(state);
        }
        event.stopPropagation();
      },
      _onTouchEnded: function _onTouchEnded(event) {
        if (!this.interactable || !this.enabledInHierarchy) return;
        if (this._pressed) {
          cc.Component.EventHandler.emitEvents(this.clickEvents, event);
          this.node.emit("click", this);
        }
        this._pressed = false;
        this._updateState();
        event.stopPropagation();
      },
      _onTouchCancel: function _onTouchCancel() {
        if (!this.interactable || !this.enabledInHierarchy) return;
        this._pressed = false;
        this._updateState();
      },
      _onMouseMoveIn: function _onMouseMoveIn() {
        if (this._pressed || !this.interactable || !this.enabledInHierarchy) return;
        if (this.transition === Transition.SPRITE && !this.hoverSprite) return;
        if (!this._hovered) {
          this._hovered = true;
          this._updateState();
        }
      },
      _onMouseMoveOut: function _onMouseMoveOut() {
        if (this._hovered) {
          this._hovered = false;
          this._updateState();
        }
      },
      _updateState: function _updateState() {
        var state = this._getButtonState();
        this._applyTransition(state);
        this._updateDisabledState();
      },
      _getButtonState: function _getButtonState() {
        var state = void 0;
        state = this.interactable ? this._pressed ? State.PRESSED : this._hovered ? State.HOVER : State.NORMAL : State.DISABLED;
        return state;
      },
      _updateColorTransitionImmediately: function _updateColorTransitionImmediately(state) {
        var color = this._getStateColor(state);
        this._setTargetColor(color);
      },
      _updateColorTransition: function _updateColorTransition(state) {
        if (false, state === State.DISABLED) this._updateColorTransitionImmediately(state); else {
          var target = this._getTarget();
          var color = this._getStateColor(state);
          this._fromColor = target.color.clone();
          this._toColor = color;
          this.time = 0;
          this._transitionFinished = false;
        }
      },
      _updateSpriteTransition: function _updateSpriteTransition(state) {
        var sprite = this._getStateSprite(state);
        this._sprite && sprite && (this._sprite.spriteFrame = sprite);
      },
      _updateScaleTransition: function _updateScaleTransition(state) {
        state === State.PRESSED ? this._zoomUp() : this._zoomBack();
      },
      _zoomUp: function _zoomUp() {
        if (!this._originalScale) return;
        this._fromScale.x = this._originalScale.x;
        this._fromScale.y = this._originalScale.y;
        this._toScale.x = this._originalScale.x * this.zoomScale;
        this._toScale.y = this._originalScale.y * this.zoomScale;
        this.time = 0;
        this._transitionFinished = false;
      },
      _zoomBack: function _zoomBack() {
        if (!this._originalScale) return;
        var target = this._getTarget();
        this._fromScale.x = target.scaleX;
        this._fromScale.y = target.scaleY;
        this._toScale.x = this._originalScale.x;
        this._toScale.y = this._originalScale.y;
        this.time = 0;
        this._transitionFinished = false;
      },
      _updateTransition: function _updateTransition(oldTransition) {
        oldTransition === Transition.COLOR ? this._updateColorTransitionImmediately(State.NORMAL) : oldTransition === Transition.SPRITE && this._updateSpriteTransition(State.NORMAL);
        this._updateState();
      },
      _applyTransition: function _applyTransition(state) {
        var transition = this.transition;
        transition === Transition.COLOR ? this._updateColorTransition(state) : transition === Transition.SPRITE ? this._updateSpriteTransition(state) : transition === Transition.SCALE && this._updateScaleTransition(state);
      },
      _resizeNodeToTargetNode: false,
      _updateDisabledState: function _updateDisabledState() {
        if (this._sprite) {
          var useGrayMaterial = false;
          this.enableAutoGrayEffect && (this.transition === Transition.SPRITE && this.disabledSprite || this.interactable || (useGrayMaterial = true));
          this._switchGrayMaterial(useGrayMaterial, this._sprite);
        }
      }
    });
    cc.Button = module.exports = Button;
  }), {
    "../utils/gray-sprite-state": 200,
    "./CCComponent": 62
  } ],
  61: [ (function(require, module, exports) {
    "use strict";
    var Camera = require("../camera/CCCamera");
    var Component = require("./CCComponent");
    var Canvas = cc.Class({
      name: "cc.Canvas",
      extends: Component,
      editor: false,
      resetInEditor: false,
      statics: {
        instance: null
      },
      properties: {
        _designResolution: cc.size(960, 640),
        designResolution: {
          get: function get() {
            return cc.size(this._designResolution);
          },
          set: function set(value) {
            this._designResolution.width = value.width;
            this._designResolution.height = value.height;
            this.applySettings();
            this.alignWithScreen();
          },
          tooltip: false
        },
        _fitWidth: false,
        _fitHeight: true,
        fitHeight: {
          get: function get() {
            return this._fitHeight;
          },
          set: function set(value) {
            if (this._fitHeight !== value) {
              this._fitHeight = value;
              this.applySettings();
              this.alignWithScreen();
            }
          },
          tooltip: false
        },
        fitWidth: {
          get: function get() {
            return this._fitWidth;
          },
          set: function set(value) {
            if (this._fitWidth !== value) {
              this._fitWidth = value;
              this.applySettings();
              this.alignWithScreen();
            }
          },
          tooltip: false
        }
      },
      ctor: function ctor() {
        this._thisOnResized = this.alignWithScreen.bind(this);
      },
      __preload: function __preload() {
        var Flags;
        false;
        if (Canvas.instance) return cc.errorID(6700, this.node.name, Canvas.instance.node.name);
        Canvas.instance = this;
        false;
        cc.sys.isMobile ? window.addEventListener("resize", this._thisOnResized) : cc.view.on("canvas-resize", this._thisOnResized);
        this.applySettings();
        this.alignWithScreen();
        var cameraNode = cc.find("Main Camera", this.node);
        if (!cameraNode) {
          cameraNode = new cc.Node("Main Camera");
          cameraNode.parent = this.node;
          cameraNode.setSiblingIndex(0);
        }
        var camera = cameraNode.getComponent(Camera);
        if (!camera) {
          camera = cameraNode.addComponent(Camera);
          var ClearFlags = Camera.ClearFlags;
          camera.clearFlags = ClearFlags.COLOR | ClearFlags.DEPTH | ClearFlags.STENCIL;
          camera.depth = -1;
        }
        Camera.main = camera;
      },
      onDestroy: function onDestroy() {
        false;
        cc.sys.isMobile ? window.removeEventListener("resize", this._thisOnResized) : cc.view.off("canvas-resize", this._thisOnResized);
        Canvas.instance === this && (Canvas.instance = null);
      },
      alignWithScreen: function alignWithScreen() {
        var designSize, nodeSize;
        false;
        var canvasSize = nodeSize = cc.visibleRect;
        designSize = cc.view.getDesignResolutionSize();
        var clipTopRight = !this.fitHeight && !this.fitWidth;
        var offsetX = 0;
        var offsetY = 0;
        if (clipTopRight) {
          offsetX = .5 * (designSize.width - canvasSize.width);
          offsetY = .5 * (designSize.height - canvasSize.height);
        }
        this.node.setPosition(.5 * canvasSize.width + offsetX, .5 * canvasSize.height + offsetY);
        this.node.width = nodeSize.width;
        this.node.height = nodeSize.height;
      },
      applySettings: function applySettings() {
        var ResolutionPolicy = cc.ResolutionPolicy;
        var policy;
        policy = this.fitHeight && this.fitWidth ? ResolutionPolicy.SHOW_ALL : this.fitHeight || this.fitWidth ? this.fitWidth ? ResolutionPolicy.FIXED_WIDTH : ResolutionPolicy.FIXED_HEIGHT : ResolutionPolicy.NO_BORDER;
        var designRes = this._designResolution;
        false;
        cc.view.setDesignResolutionSize(designRes.width, designRes.height, policy);
      }
    });
    cc.Canvas = module.exports = Canvas;
  }), {
    "../camera/CCCamera": 56,
    "./CCComponent": 62
  } ],
  62: [ (function(require, module, exports) {
    "use strict";
    var CCObject = require("../platform/CCObject");
    var js = require("../platform/js");
    var idGenerater = new (require("../platform/id-generater"))("Comp");
    var IsOnEnableCalled = CCObject.Flags.IsOnEnableCalled;
    var IsOnLoadCalled = CCObject.Flags.IsOnLoadCalled;
    var Component = cc.Class({
      name: "cc.Component",
      extends: CCObject,
      ctor: function() {
        this._id = idGenerater.getNewId();
        this.__eventTargets = [];
      },
      properties: {
        node: {
          default: null,
          visible: false
        },
        name: {
          get: function get() {
            if (this._name) return this._name;
            var className = cc.js.getClassName(this);
            var trimLeft = className.lastIndexOf(".");
            trimLeft >= 0 && (className = className.slice(trimLeft + 1));
            return this.node.name + "<" + className + ">";
          },
          set: function set(value) {
            this._name = value;
          },
          visible: false
        },
        uuid: {
          get: function get() {
            return this._id;
          },
          visible: false
        },
        __scriptAsset: false,
        _enabled: true,
        enabled: {
          get: function get() {
            return this._enabled;
          },
          set: function set(value) {
            if (this._enabled !== value) {
              this._enabled = value;
              if (this.node._activeInHierarchy) {
                var compScheduler = cc.director._compScheduler;
                value ? compScheduler.enableComp(this) : compScheduler.disableComp(this);
              }
            }
          },
          visible: false,
          animatable: true
        },
        enabledInHierarchy: {
          get: function get() {
            return this._enabled && this.node._activeInHierarchy;
          },
          visible: false
        },
        _isOnLoadCalled: {
          get: function get() {
            return this._objFlags & IsOnLoadCalled;
          }
        }
      },
      update: null,
      lateUpdate: null,
      __preload: null,
      onLoad: null,
      start: null,
      onEnable: null,
      onDisable: null,
      onDestroy: null,
      onFocusInEditor: null,
      onLostFocusInEditor: null,
      resetInEditor: null,
      addComponent: function addComponent(typeOrClassName) {
        return this.node.addComponent(typeOrClassName);
      },
      getComponent: function getComponent(typeOrClassName) {
        return this.node.getComponent(typeOrClassName);
      },
      getComponents: function getComponents(typeOrClassName) {
        return this.node.getComponents(typeOrClassName);
      },
      getComponentInChildren: function getComponentInChildren(typeOrClassName) {
        return this.node.getComponentInChildren(typeOrClassName);
      },
      getComponentsInChildren: function getComponentsInChildren(typeOrClassName) {
        return this.node.getComponentsInChildren(typeOrClassName);
      },
      _getLocalBounds: null,
      onRestore: null,
      destroy: function destroy() {
        var depend;
        false;
        this._super() && this._enabled && this.node._activeInHierarchy && cc.director._compScheduler.disableComp(this);
      },
      _onPreDestroy: function _onPreDestroy() {
        this.unscheduleAllCallbacks();
        var eventTargets = this.__eventTargets;
        for (var i = 0, l = eventTargets.length; i < l; ++i) {
          var target = eventTargets[i];
          target && target.targetOff(this);
        }
        eventTargets.length = 0;
        false;
        cc.director._nodeActivator.destroyComp(this);
        this.node._removeComponent(this);
      },
      _instantiate: function _instantiate(cloned) {
        cloned || (cloned = cc.instantiate._clone(this, this));
        cloned.node = null;
        return cloned;
      },
      schedule: function schedule(callback, interval, repeat, delay) {
        cc.assertID(callback, 1619);
        cc.assertID(interval >= 0, 1620);
        interval = interval || 0;
        repeat = isNaN(repeat) ? cc.macro.REPEAT_FOREVER : repeat;
        delay = delay || 0;
        var scheduler = cc.director.getScheduler();
        var paused = scheduler.isTargetPaused(this);
        scheduler.schedule(callback, this, interval, repeat, delay, paused);
      },
      scheduleOnce: function scheduleOnce(callback, delay) {
        this.schedule(callback, 0, 0, delay);
      },
      unschedule: function unschedule(callback_fn) {
        if (!callback_fn) return;
        cc.director.getScheduler().unschedule(callback_fn, this);
      },
      unscheduleAllCallbacks: function unscheduleAllCallbacks() {
        cc.director.getScheduler().unscheduleAllForTarget(this);
      }
    });
    Component._requireComponent = null;
    Component._executionOrder = 0;
    false, false;
    js.value(Component, "_registerEditorProps", (function(cls, props) {
      var reqComp = props.requireComponent;
      reqComp && (cls._requireComponent = reqComp);
      var order = props.executionOrder;
      order && "number" === typeof order && (cls._executionOrder = order);
      var name;
      var key;
      var val;
      var willExecuteInEditMode;
      false, false;
    }));
    Component.prototype.__scriptUuid = "";
    cc.Component = module.exports = Component;
  }), {
    "../platform/CCObject": 124,
    "../platform/id-generater": 134,
    "../platform/js": 138
  } ],
  63: [ (function(require, module, exports) {
    "use strict";
    cc.Component.EventHandler = cc.Class({
      name: "cc.ClickEvent",
      properties: {
        target: {
          default: null,
          type: cc.Node
        },
        component: "",
        _componentId: "",
        _componentName: {
          get: function get() {
            this._genCompIdIfNeeded();
            return this._compId2Name(this._componentId);
          },
          set: function set(value) {
            this._componentId = this._compName2Id(value);
          }
        },
        handler: {
          default: ""
        },
        customEventData: {
          default: ""
        }
      },
      statics: {
        emitEvents: function emitEvents(events) {
          var args = void 0;
          if (arguments.length > 0) {
            args = new Array(arguments.length - 1);
            for (var i = 0, l = args.length; i < l; i++) args[i] = arguments[i + 1];
          }
          for (var _i = 0, _l = events.length; _i < _l; _i++) {
            var event = events[_i];
            if (!(event instanceof cc.Component.EventHandler)) continue;
            event.emit(args);
          }
        }
      },
      emit: function emit(params) {
        var target = this.target;
        if (!cc.isValid(target)) return;
        this._genCompIdIfNeeded();
        var compType = cc.js._getClassById(this._componentId);
        var comp = target.getComponent(compType);
        if (!cc.isValid(comp)) return;
        var handler = comp[this.handler];
        if ("function" !== typeof handler) return;
        if (null != this.customEventData && "" !== this.customEventData) {
          params = params.slice();
          params.push(this.customEventData);
        }
        handler.apply(comp, params);
      },
      _compName2Id: function _compName2Id(compName) {
        var comp = cc.js.getClassByName(compName);
        return cc.js._getClassId(comp);
      },
      _compId2Name: function _compId2Name(compId) {
        var comp = cc.js._getClassById(compId);
        return cc.js.getClassName(comp);
      },
      _genCompIdIfNeeded: function _genCompIdIfNeeded() {
        if (!this._componentId) {
          this._componentName = this.component;
          this.component = "";
        }
      }
    });
  }), {} ],
  64: [ (function(require, module, exports) {
    "use strict";
    var macro = require("../platform/CCMacro");
    var RenderComponent = require("./CCRenderComponent");
    var Material = require("../assets/material/CCMaterial");
    var LabelFrame = require("../renderer/utils/label/label-frame");
    var RenderFlow = require("../renderer/render-flow");
    var opacityFlag = RenderFlow.FLAG_COLOR | RenderFlow.FLAG_OPACITY;
    var HorizontalAlign = macro.TextAlignment;
    var VerticalAlign = macro.VerticalTextAlignment;
    var Overflow = cc.Enum({
      NONE: 0,
      CLAMP: 1,
      SHRINK: 2,
      RESIZE_HEIGHT: 3
    });
    var CacheMode = cc.Enum({
      NONE: 0,
      BITMAP: 1,
      CHAR: 2
    });
    var Label = cc.Class({
      name: "cc.Label",
      extends: RenderComponent,
      ctor: function ctor() {
        false;
        this._actualFontSize = 0;
        this._assemblerData = null;
        this._frame = null;
        this._ttfTexture = null;
        this._letterTexture = null;
      },
      editor: false,
      properties: {
        _useOriginalSize: true,
        _string: {
          default: "",
          formerlySerializedAs: "_N$string"
        },
        string: {
          get: function get() {
            return this._string;
          },
          set: function set(value) {
            var oldValue = this._string;
            this._string = "" + value;
            this.string !== oldValue && this._updateRenderData();
            this._checkStringEmpty();
          },
          multiline: true,
          tooltip: false
        },
        horizontalAlign: {
          default: HorizontalAlign.LEFT,
          type: HorizontalAlign,
          tooltip: false,
          notify: function notify(oldValue) {
            if (this.horizontalAlign === oldValue) return;
            this._updateRenderData();
          },
          animatable: false
        },
        verticalAlign: {
          default: VerticalAlign.TOP,
          type: VerticalAlign,
          tooltip: false,
          notify: function notify(oldValue) {
            if (this.verticalAlign === oldValue) return;
            this._updateRenderData();
          },
          animatable: false
        },
        actualFontSize: {
          displayName: "Actual Font Size",
          animatable: false,
          readonly: true,
          get: function get() {
            return this._actualFontSize;
          },
          tooltip: false
        },
        _fontSize: 40,
        fontSize: {
          get: function get() {
            return this._fontSize;
          },
          set: function set(value) {
            if (this._fontSize === value) return;
            this._fontSize = value;
            this._updateRenderData();
          },
          range: [ 0, 512 ],
          tooltip: false
        },
        fontFamily: {
          default: "Arial",
          tooltip: false,
          notify: function notify(oldValue) {
            if (this.fontFamily === oldValue) return;
            this._updateRenderData();
          },
          animatable: false
        },
        _lineHeight: 40,
        lineHeight: {
          get: function get() {
            return this._lineHeight;
          },
          set: function set(value) {
            if (this._lineHeight === value) return;
            this._lineHeight = value;
            this._updateRenderData();
          },
          tooltip: false
        },
        overflow: {
          default: Overflow.NONE,
          type: Overflow,
          tooltip: false,
          notify: function notify(oldValue) {
            if (this.overflow === oldValue) return;
            this._updateRenderData();
          },
          animatable: false
        },
        _enableWrapText: true,
        enableWrapText: {
          get: function get() {
            return this._enableWrapText;
          },
          set: function set(value) {
            if (this._enableWrapText === value) return;
            this._enableWrapText = value;
            this._updateRenderData();
          },
          animatable: false,
          tooltip: false
        },
        _N$file: null,
        font: {
          get: function get() {
            return this._N$file;
          },
          set: function set(value) {
            if (this.font === value) return;
            value || (this._isSystemFontUsed = true);
            false;
            cc.Label.FontAtlasManager.releaseFontAtlas(this.font, this.node._id);
            this._N$file = value;
            value && this._isSystemFontUsed && (this._isSystemFontUsed = false);
            "string" === typeof value && cc.warnID(4e3);
            if (this._renderData) {
              this.destroyRenderData(this._renderData);
              this._renderData = null;
            }
            this._updateAssembler();
            this._applyFontTexture(true);
            this._updateRenderData();
          },
          type: cc.Font,
          tooltip: false,
          animatable: false
        },
        _isSystemFontUsed: true,
        useSystemFont: {
          get: function get() {
            return this._isSystemFontUsed;
          },
          set: function set(value) {
            if (this._isSystemFontUsed === value) return;
            this.destroyRenderData(this._renderData);
            this._renderData = null;
            false;
            this._isSystemFontUsed = !!value;
            if (value) {
              this.font = null;
              this._updateAssembler();
              this._updateRenderData();
              this._checkStringEmpty();
            } else this._userDefinedFont || this.disableRender();
          },
          animatable: false,
          tooltip: false
        },
        _bmFontOriginalSize: {
          displayName: "BMFont Original Size",
          get: function get() {
            return this._N$file instanceof cc.BitmapFont ? this._N$file.fontSize : -1;
          },
          visible: true,
          animatable: false
        },
        _spacingX: 0,
        spacingX: {
          get: function get() {
            return this._spacingX;
          },
          set: function set(value) {
            this._spacingX = value;
            this._updateRenderData();
          },
          tooltip: false
        },
        _batchAsBitmap: false,
        cacheMode: {
          default: CacheMode.NONE,
          type: CacheMode,
          tooltip: false,
          notify: function notify(oldValue) {
            if (this.cacheMode === oldValue) return;
            oldValue !== CacheMode.BITMAP || this.font instanceof cc.BitmapFont || this._frame._resetDynamicAtlasFrame();
            oldValue === CacheMode.CHAR && (this._ttfTexture = null);
            this._updateRenderData(true);
          },
          animatable: false
        },
        _isBold: {
          default: false,
          serializable: false
        },
        _isItalic: {
          default: false,
          serializable: false
        },
        _isUnderline: {
          default: false,
          serializable: false
        }
      },
      statics: {
        HorizontalAlign: HorizontalAlign,
        VerticalAlign: VerticalAlign,
        Overflow: Overflow,
        CacheMode: CacheMode
      },
      onLoad: function onLoad() {
        if (this._batchAsBitmap && this.cacheMode === CacheMode.NONE) {
          this.cacheMode = CacheMode.BITMAP;
          this._batchAsBitmap = false;
        }
      },
      onEnable: function onEnable() {
        this._super();
        this.font || this._isSystemFontUsed || (this.useSystemFont = true);
        this.useSystemFont && !this.fontFamily && (this.fontFamily = "Arial");
        this.node.on(cc.Node.EventType.SIZE_CHANGED, this._updateRenderData, this);
        this.node.on(cc.Node.EventType.ANCHOR_CHANGED, this._updateRenderData, this);
        this.node.on(cc.Node.EventType.COLOR_CHANGED, this._updateColor, this);
        this._checkStringEmpty();
        this._updateRenderData(true);
      },
      onDisable: function onDisable() {
        this._super();
        this.node.off(cc.Node.EventType.SIZE_CHANGED, this._updateRenderData, this);
        this.node.off(cc.Node.EventType.ANCHOR_CHANGED, this._updateRenderData, this);
        this.node.off(cc.Node.EventType.COLOR_CHANGED, this._updateColor, this);
      },
      onDestroy: function onDestroy() {
        this._assembler && this._assembler._resetAssemblerData && this._assembler._resetAssemblerData(this._assemblerData);
        this._assemblerData = null;
        this._letterTexture = null;
        if (this._ttfTexture) {
          this._ttfTexture.destroy();
          this._ttfTexture = null;
        }
        cc.Label.FontAtlasManager.releaseFontAtlas(this.font, this.node._id);
        this._super();
      },
      _canRender: function _canRender() {
        var result = this._super();
        var font = this.font;
        if (font instanceof cc.BitmapFont) {
          var spriteFrame = font.spriteFrame;
          spriteFrame && spriteFrame.textureLoaded() || (result = false);
        }
        return result;
      },
      _checkStringEmpty: function _checkStringEmpty() {
        this.markForRender(!!this.string);
      },
      _on3DNodeChanged: function _on3DNodeChanged() {
        this._updateAssembler();
        this._applyFontTexture(true);
      },
      _updateAssembler: function _updateAssembler() {
        var assembler = Label._assembler.getAssembler(this);
        if (this._assembler !== assembler) {
          this._assembler = assembler;
          this._renderData = null;
          this._frame = null;
        }
        if (!this._renderData) {
          this._renderData = this._assembler.createData(this);
          this.markForUpdateRenderData(true);
        }
      },
      _applyFontTexture: function _applyFontTexture(force) {
        var font = this.font;
        if (font instanceof cc.BitmapFont) {
          var spriteFrame = font.spriteFrame;
          this._frame = spriteFrame;
          var self = this;
          var onBMFontTextureLoaded = function onBMFontTextureLoaded() {
            self._frame._texture = spriteFrame._texture;
            self._activateMaterial(force);
            force && self._assembler && self._assembler.updateRenderData(self);
          };
          if (spriteFrame && spriteFrame.textureLoaded()) onBMFontTextureLoaded(); else {
            this.disableRender();
            if (spriteFrame) {
              spriteFrame.once("load", onBMFontTextureLoaded, this);
              spriteFrame.ensureLoadTexture();
            }
          }
        } else {
          this._frame || (this._frame = new LabelFrame());
          if (this.cacheMode === CacheMode.CHAR && cc.sys.browserType !== cc.sys.BROWSER_TYPE_WECHAT_GAME_SUB) {
            this._letterTexture = this._assembler._getAssemblerData();
            this._frame._refreshTexture(this._letterTexture);
          } else if (!this._ttfTexture) {
            this._ttfTexture = new cc.Texture2D();
            this._assemblerData = this._assembler._getAssemblerData();
            this._ttfTexture.initWithElement(this._assemblerData.canvas);
          }
          if (this.cacheMode !== CacheMode.CHAR) {
            this._frame._resetDynamicAtlasFrame();
            this._frame._refreshTexture(this._ttfTexture);
          }
          this._activateMaterial(force);
          force && this._assembler && this._assembler.updateRenderData(this);
        }
      },
      _updateColor: function _updateColor() {
        var font = this.font;
        if (!(font instanceof cc.BitmapFont)) {
          this._updateRenderData();
          this.node._renderFlag &= ~RenderFlow.FLAG_COLOR;
        }
      },
      _activateMaterial: function _activateMaterial(force) {
        if (!force) return;
        if (cc.game.renderType === cc.game.RENDER_TYPE_CANVAS) this._frame._texture.url = this.uuid + "_texture"; else {
          var material = this.sharedMaterials[0];
          material = material ? Material.getInstantiatedMaterial(material, this) : Material.getInstantiatedBuiltinMaterial("2d-sprite", this);
          material.setProperty("texture", this._frame._texture);
          this.setMaterial(0, material);
        }
        this.markForUpdateRenderData(true);
        this.markForRender(true);
      },
      _updateRenderData: function _updateRenderData(force) {
        var renderData = this._renderData;
        if (renderData) {
          renderData.vertDirty = true;
          renderData.uvDirty = true;
          this.markForUpdateRenderData(true);
        }
        if (true === force) {
          this._updateAssembler();
          this._applyFontTexture(force);
        }
      },
      _enableBold: function _enableBold(enabled) {
        this._isBold = !!enabled;
      },
      _enableItalics: function _enableItalics(enabled) {
        this._isItalic = !!enabled;
      },
      _enableUnderline: function _enableUnderline(enabled) {
        this._isUnderline = !!enabled;
      }
    });
    cc.Label = module.exports = Label;
  }), {
    "../assets/material/CCMaterial": 52,
    "../platform/CCMacro": 123,
    "../renderer/render-flow": 162,
    "../renderer/utils/label/label-frame": 166,
    "./CCRenderComponent": 70
  } ],
  65: [ (function(require, module, exports) {
    "use strict";
    var LabelOutline = cc.Class({
      name: "cc.LabelOutline",
      extends: require("./CCComponent"),
      editor: false,
      properties: {
        _color: cc.Color.WHITE,
        _width: 1,
        color: {
          tooltip: false,
          get: function get() {
            return this._color;
          },
          set: function set(value) {
            this._color = value;
            this._updateRenderData();
          }
        },
        width: {
          tooltip: false,
          get: function get() {
            return this._width;
          },
          set: function set(value) {
            this._width = value;
            this._updateRenderData();
          },
          range: [ 0, 512 ]
        }
      },
      onEnable: function onEnable() {
        this._updateRenderData();
      },
      onDisable: function onDisable() {
        this._updateRenderData();
      },
      _updateRenderData: function _updateRenderData() {
        var label = this.node.getComponent(cc.Label);
        label && label._updateRenderData();
      }
    });
    cc.LabelOutline = module.exports = LabelOutline;
  }), {
    "./CCComponent": 62
  } ],
  66: [ (function(require, module, exports) {
    "use strict";
    var LabelShadow = cc.Class({
      name: "cc.LabelShadow",
      extends: require("./CCComponent"),
      editor: false,
      properties: {
        _color: cc.Color.WHITE,
        _offset: cc.v2(2, 2),
        _blur: 2,
        color: {
          tooltip: false,
          get: function get() {
            return this._color;
          },
          set: function set(value) {
            this._color = value;
            this._updateRenderData();
          }
        },
        offset: {
          tooltip: false,
          get: function get() {
            return this._offset;
          },
          set: function set(value) {
            this._offset = value;
            this._updateRenderData();
          }
        },
        blur: {
          tooltip: false,
          get: function get() {
            return this._blur;
          },
          set: function set(value) {
            this._blur = value;
            this._updateRenderData();
          },
          range: [ 0, 1024 ]
        }
      },
      onEnable: function onEnable() {
        this._updateRenderData();
      },
      onDisable: function onDisable() {
        this._updateRenderData();
      },
      _updateRenderData: function _updateRenderData() {
        var label = this.node.getComponent(cc.Label);
        label && label._updateRenderData();
      }
    });
    cc.LabelShadow = module.exports = LabelShadow;
  }), {
    "./CCComponent": 62
  } ],
  67: [ (function(require, module, exports) {
    "use strict";
    var NodeEvent = require("../CCNode").EventType;
    var Type = cc.Enum({
      NONE: 0,
      HORIZONTAL: 1,
      VERTICAL: 2,
      GRID: 3
    });
    var ResizeMode = cc.Enum({
      NONE: 0,
      CONTAINER: 1,
      CHILDREN: 2
    });
    var AxisDirection = cc.Enum({
      HORIZONTAL: 0,
      VERTICAL: 1
    });
    var VerticalDirection = cc.Enum({
      BOTTOM_TO_TOP: 0,
      TOP_TO_BOTTOM: 1
    });
    var HorizontalDirection = cc.Enum({
      LEFT_TO_RIGHT: 0,
      RIGHT_TO_LEFT: 1
    });
    var Layout = cc.Class({
      name: "cc.Layout",
      extends: require("./CCComponent"),
      editor: false,
      properties: {
        _layoutSize: cc.size(300, 200),
        _layoutDirty: {
          default: true,
          serializable: false
        },
        _resize: ResizeMode.NONE,
        _N$layoutType: Type.NONE,
        type: {
          type: Type,
          get: function get() {
            return this._N$layoutType;
          },
          set: function set(value) {
            this._N$layoutType = value;
            var reLayouted;
            false;
            this._doLayoutDirty();
          },
          tooltip: false,
          animatable: false
        },
        resizeMode: {
          type: ResizeMode,
          tooltip: false,
          animatable: false,
          get: function get() {
            return this._resize;
          },
          set: function set(value) {
            if (this.type === Type.NONE && value === ResizeMode.CHILDREN) return;
            this._resize = value;
            var reLayouted;
            false;
            this._doLayoutDirty();
          }
        },
        cellSize: {
          default: cc.size(40, 40),
          tooltip: false,
          type: cc.Size,
          notify: function notify() {
            this._doLayoutDirty();
          }
        },
        startAxis: {
          default: AxisDirection.HORIZONTAL,
          tooltip: false,
          type: AxisDirection,
          notify: function notify() {
            var reLayouted;
            false;
            this._doLayoutDirty();
          },
          animatable: false
        },
        _N$padding: {
          default: 0
        },
        paddingLeft: {
          default: 0,
          tooltip: false,
          notify: function notify() {
            this._doLayoutDirty();
          }
        },
        paddingRight: {
          default: 0,
          tooltip: false,
          notify: function notify() {
            this._doLayoutDirty();
          }
        },
        paddingTop: {
          default: 0,
          tooltip: false,
          notify: function notify() {
            this._doLayoutDirty();
          }
        },
        paddingBottom: {
          default: 0,
          tooltip: false,
          notify: function notify() {
            this._doLayoutDirty();
          }
        },
        spacingX: {
          default: 0,
          notify: function notify() {
            this._doLayoutDirty();
          },
          tooltip: false
        },
        spacingY: {
          default: 0,
          notify: function notify() {
            this._doLayoutDirty();
          },
          tooltip: false
        },
        verticalDirection: {
          default: VerticalDirection.TOP_TO_BOTTOM,
          type: VerticalDirection,
          notify: function notify() {
            this._doLayoutDirty();
          },
          tooltip: false,
          animatable: false
        },
        horizontalDirection: {
          default: HorizontalDirection.LEFT_TO_RIGHT,
          type: HorizontalDirection,
          notify: function notify() {
            this._doLayoutDirty();
          },
          tooltip: false,
          animatable: false
        },
        affectedByScale: {
          default: false,
          notify: function notify() {
            this._doLayoutDirty();
          },
          animatable: false,
          tooltip: false
        }
      },
      statics: {
        Type: Type,
        VerticalDirection: VerticalDirection,
        HorizontalDirection: HorizontalDirection,
        ResizeMode: ResizeMode,
        AxisDirection: AxisDirection
      },
      _migratePaddingData: function _migratePaddingData() {
        this.paddingLeft = this._N$padding;
        this.paddingRight = this._N$padding;
        this.paddingTop = this._N$padding;
        this.paddingBottom = this._N$padding;
        this._N$padding = 0;
      },
      onEnable: function onEnable() {
        this._addEventListeners();
        this.node.getContentSize().equals(cc.size(0, 0)) && this.node.setContentSize(this._layoutSize);
        0 !== this._N$padding && this._migratePaddingData();
        this._doLayoutDirty();
      },
      onDisable: function onDisable() {
        this._removeEventListeners();
      },
      _doLayoutDirty: function _doLayoutDirty() {
        this._layoutDirty = true;
      },
      _doScaleDirty: function _doScaleDirty() {
        this._layoutDirty = this._layoutDirty || this.affectedByScale;
      },
      _addEventListeners: function _addEventListeners() {
        cc.director.on(cc.Director.EVENT_AFTER_UPDATE, this.updateLayout, this);
        this.node.on(NodeEvent.SIZE_CHANGED, this._resized, this);
        this.node.on(NodeEvent.ANCHOR_CHANGED, this._doLayoutDirty, this);
        this.node.on(NodeEvent.CHILD_ADDED, this._childAdded, this);
        this.node.on(NodeEvent.CHILD_REMOVED, this._childRemoved, this);
        this.node.on(NodeEvent.CHILD_REORDER, this._doLayoutDirty, this);
        this._addChildrenEventListeners();
      },
      _removeEventListeners: function _removeEventListeners() {
        cc.director.off(cc.Director.EVENT_AFTER_UPDATE, this.updateLayout, this);
        this.node.off(NodeEvent.SIZE_CHANGED, this._resized, this);
        this.node.off(NodeEvent.ANCHOR_CHANGED, this._doLayoutDirty, this);
        this.node.off(NodeEvent.CHILD_ADDED, this._childAdded, this);
        this.node.off(NodeEvent.CHILD_REMOVED, this._childRemoved, this);
        this.node.off(NodeEvent.CHILD_REORDER, this._doLayoutDirty, this);
        this._removeChildrenEventListeners();
      },
      _addChildrenEventListeners: function _addChildrenEventListeners() {
        var children = this.node.children;
        for (var i = 0; i < children.length; ++i) {
          var child = children[i];
          child.on(NodeEvent.SCALE_CHANGED, this._doScaleDirty, this);
          child.on(NodeEvent.SIZE_CHANGED, this._doLayoutDirty, this);
          child.on(NodeEvent.POSITION_CHANGED, this._doLayoutDirty, this);
          child.on(NodeEvent.ANCHOR_CHANGED, this._doLayoutDirty, this);
          child.on("active-in-hierarchy-changed", this._doLayoutDirty, this);
        }
      },
      _removeChildrenEventListeners: function _removeChildrenEventListeners() {
        var children = this.node.children;
        for (var i = 0; i < children.length; ++i) {
          var child = children[i];
          child.off(NodeEvent.SCALE_CHANGED, this._doScaleDirty, this);
          child.off(NodeEvent.SIZE_CHANGED, this._doLayoutDirty, this);
          child.off(NodeEvent.POSITION_CHANGED, this._doLayoutDirty, this);
          child.off(NodeEvent.ANCHOR_CHANGED, this._doLayoutDirty, this);
          child.off("active-in-hierarchy-changed", this._doLayoutDirty, this);
        }
      },
      _childAdded: function _childAdded(child) {
        child.on(NodeEvent.SCALE_CHANGED, this._doScaleDirty, this);
        child.on(NodeEvent.SIZE_CHANGED, this._doLayoutDirty, this);
        child.on(NodeEvent.POSITION_CHANGED, this._doLayoutDirty, this);
        child.on(NodeEvent.ANCHOR_CHANGED, this._doLayoutDirty, this);
        child.on("active-in-hierarchy-changed", this._doLayoutDirty, this);
        this._doLayoutDirty();
      },
      _childRemoved: function _childRemoved(child) {
        child.off(NodeEvent.SCALE_CHANGED, this._doScaleDirty, this);
        child.off(NodeEvent.SIZE_CHANGED, this._doLayoutDirty, this);
        child.off(NodeEvent.POSITION_CHANGED, this._doLayoutDirty, this);
        child.off(NodeEvent.ANCHOR_CHANGED, this._doLayoutDirty, this);
        child.off("active-in-hierarchy-changed", this._doLayoutDirty, this);
        this._doLayoutDirty();
      },
      _resized: function _resized() {
        this._layoutSize = this.node.getContentSize();
        this._doLayoutDirty();
      },
      _doLayoutHorizontally: function _doLayoutHorizontally(baseWidth, rowBreak, fnPositionY, applyChildren) {
        var layoutAnchor = this.node.getAnchorPoint();
        var children = this.node.children;
        var sign = 1;
        var paddingX = this.paddingLeft;
        var leftBoundaryOfLayout = -layoutAnchor.x * baseWidth;
        if (this.horizontalDirection === HorizontalDirection.RIGHT_TO_LEFT) {
          sign = -1;
          leftBoundaryOfLayout = (1 - layoutAnchor.x) * baseWidth;
          paddingX = this.paddingRight;
        }
        var nextX = leftBoundaryOfLayout + sign * paddingX - sign * this.spacingX;
        var rowMaxHeight = 0;
        var tempMaxHeight = 0;
        var secondMaxHeight = 0;
        var row = 0;
        var containerResizeBoundary = 0;
        var maxHeightChildAnchorY = 0;
        var activeChildCount = 0;
        for (var i = 0; i < children.length; ++i) {
          var child = children[i];
          child.activeInHierarchy && activeChildCount++;
        }
        var newChildWidth = this.cellSize.width;
        this.type !== Type.GRID && this.resizeMode === ResizeMode.CHILDREN && (newChildWidth = (baseWidth - (this.paddingLeft + this.paddingRight) - (activeChildCount - 1) * this.spacingX) / activeChildCount);
        for (var i = 0; i < children.length; ++i) {
          var child = children[i];
          var childScaleX = this._getUsedScaleValue(child.scaleX);
          var childScaleY = this._getUsedScaleValue(child.scaleY);
          if (!child.activeInHierarchy) continue;
          if (this._resize === ResizeMode.CHILDREN) {
            child.width = newChildWidth / childScaleX;
            this.type === Type.GRID && (child.height = this.cellSize.height / childScaleY);
          }
          var anchorX = child.anchorX;
          var childBoundingBoxWidth = child.width * childScaleX;
          var childBoundingBoxHeight = child.height * childScaleY;
          secondMaxHeight > tempMaxHeight && (tempMaxHeight = secondMaxHeight);
          if (childBoundingBoxHeight >= tempMaxHeight) {
            secondMaxHeight = tempMaxHeight;
            tempMaxHeight = childBoundingBoxHeight;
            maxHeightChildAnchorY = child.getAnchorPoint().y;
          }
          this.horizontalDirection === HorizontalDirection.RIGHT_TO_LEFT && (anchorX = 1 - child.anchorX);
          nextX = nextX + sign * anchorX * childBoundingBoxWidth + sign * this.spacingX;
          var rightBoundaryOfChild = sign * (1 - anchorX) * childBoundingBoxWidth;
          if (rowBreak) {
            var rowBreakBoundary = nextX + rightBoundaryOfChild + sign * (sign > 0 ? this.paddingRight : this.paddingLeft);
            var leftToRightRowBreak = this.horizontalDirection === HorizontalDirection.LEFT_TO_RIGHT && rowBreakBoundary > (1 - layoutAnchor.x) * baseWidth;
            var rightToLeftRowBreak = this.horizontalDirection === HorizontalDirection.RIGHT_TO_LEFT && rowBreakBoundary < -layoutAnchor.x * baseWidth;
            if (leftToRightRowBreak || rightToLeftRowBreak) {
              if (childBoundingBoxHeight >= tempMaxHeight) {
                0 === secondMaxHeight && (secondMaxHeight = tempMaxHeight);
                rowMaxHeight += secondMaxHeight;
                secondMaxHeight = tempMaxHeight;
              } else {
                rowMaxHeight += tempMaxHeight;
                secondMaxHeight = childBoundingBoxHeight;
                tempMaxHeight = 0;
              }
              nextX = leftBoundaryOfLayout + sign * (paddingX + anchorX * childBoundingBoxWidth);
              row++;
            }
          }
          var finalPositionY = fnPositionY(child, rowMaxHeight, row);
          baseWidth >= childBoundingBoxWidth + this.paddingLeft + this.paddingRight && applyChildren && child.setPosition(cc.v2(nextX, finalPositionY));
          var signX = 1;
          var tempFinalPositionY;
          var topMarign = 0 === tempMaxHeight ? childBoundingBoxHeight : tempMaxHeight;
          if (this.verticalDirection === VerticalDirection.TOP_TO_BOTTOM) {
            containerResizeBoundary = containerResizeBoundary || this.node._contentSize.height;
            signX = -1;
            tempFinalPositionY = finalPositionY + signX * (topMarign * maxHeightChildAnchorY + this.paddingBottom);
            tempFinalPositionY < containerResizeBoundary && (containerResizeBoundary = tempFinalPositionY);
          } else {
            containerResizeBoundary = containerResizeBoundary || -this.node._contentSize.height;
            tempFinalPositionY = finalPositionY + signX * (topMarign * maxHeightChildAnchorY + this.paddingTop);
            tempFinalPositionY > containerResizeBoundary && (containerResizeBoundary = tempFinalPositionY);
          }
          nextX += rightBoundaryOfChild;
        }
        return containerResizeBoundary;
      },
      _getVerticalBaseHeight: function _getVerticalBaseHeight(children) {
        var newHeight = 0;
        var activeChildCount = 0;
        if (this.resizeMode === ResizeMode.CONTAINER) {
          for (var i = 0; i < children.length; ++i) {
            var child = children[i];
            if (child.activeInHierarchy) {
              activeChildCount++;
              newHeight += child.height * this._getUsedScaleValue(child.scaleY);
            }
          }
          newHeight += (activeChildCount - 1) * this.spacingY + this.paddingBottom + this.paddingTop;
        } else newHeight = this.node.getContentSize().height;
        return newHeight;
      },
      _doLayoutVertically: function _doLayoutVertically(baseHeight, columnBreak, fnPositionX, applyChildren) {
        var layoutAnchor = this.node.getAnchorPoint();
        var children = this.node.children;
        var sign = 1;
        var paddingY = this.paddingBottom;
        var bottomBoundaryOfLayout = -layoutAnchor.y * baseHeight;
        if (this.verticalDirection === VerticalDirection.TOP_TO_BOTTOM) {
          sign = -1;
          bottomBoundaryOfLayout = (1 - layoutAnchor.y) * baseHeight;
          paddingY = this.paddingTop;
        }
        var nextY = bottomBoundaryOfLayout + sign * paddingY - sign * this.spacingY;
        var columnMaxWidth = 0;
        var tempMaxWidth = 0;
        var secondMaxWidth = 0;
        var column = 0;
        var containerResizeBoundary = 0;
        var maxWidthChildAnchorX = 0;
        var activeChildCount = 0;
        for (var i = 0; i < children.length; ++i) {
          var child = children[i];
          child.activeInHierarchy && activeChildCount++;
        }
        var newChildHeight = this.cellSize.height;
        this.type !== Type.GRID && this.resizeMode === ResizeMode.CHILDREN && (newChildHeight = (baseHeight - (this.paddingTop + this.paddingBottom) - (activeChildCount - 1) * this.spacingY) / activeChildCount);
        for (var i = 0; i < children.length; ++i) {
          var child = children[i];
          var childScaleX = this._getUsedScaleValue(child.scaleX);
          var childScaleY = this._getUsedScaleValue(child.scaleY);
          if (!child.activeInHierarchy) continue;
          if (this.resizeMode === ResizeMode.CHILDREN) {
            child.height = newChildHeight / childScaleY;
            this.type === Type.GRID && (child.width = this.cellSize.width / childScaleX);
          }
          var anchorY = child.anchorY;
          var childBoundingBoxWidth = child.width * childScaleX;
          var childBoundingBoxHeight = child.height * childScaleY;
          secondMaxWidth > tempMaxWidth && (tempMaxWidth = secondMaxWidth);
          if (childBoundingBoxWidth >= tempMaxWidth) {
            secondMaxWidth = tempMaxWidth;
            tempMaxWidth = childBoundingBoxWidth;
            maxWidthChildAnchorX = child.getAnchorPoint().x;
          }
          this.verticalDirection === VerticalDirection.TOP_TO_BOTTOM && (anchorY = 1 - child.anchorY);
          nextY = nextY + sign * anchorY * childBoundingBoxHeight + sign * this.spacingY;
          var topBoundaryOfChild = sign * (1 - anchorY) * childBoundingBoxHeight;
          if (columnBreak) {
            var columnBreakBoundary = nextY + topBoundaryOfChild + sign * (sign > 0 ? this.paddingTop : this.paddingBottom);
            var bottomToTopColumnBreak = this.verticalDirection === VerticalDirection.BOTTOM_TO_TOP && columnBreakBoundary > (1 - layoutAnchor.y) * baseHeight;
            var topToBottomColumnBreak = this.verticalDirection === VerticalDirection.TOP_TO_BOTTOM && columnBreakBoundary < -layoutAnchor.y * baseHeight;
            if (bottomToTopColumnBreak || topToBottomColumnBreak) {
              if (childBoundingBoxWidth >= tempMaxWidth) {
                0 === secondMaxWidth && (secondMaxWidth = tempMaxWidth);
                columnMaxWidth += secondMaxWidth;
                secondMaxWidth = tempMaxWidth;
              } else {
                columnMaxWidth += tempMaxWidth;
                secondMaxWidth = childBoundingBoxWidth;
                tempMaxWidth = 0;
              }
              nextY = bottomBoundaryOfLayout + sign * (paddingY + anchorY * childBoundingBoxHeight);
              column++;
            }
          }
          var finalPositionX = fnPositionX(child, columnMaxWidth, column);
          baseHeight >= childBoundingBoxHeight + (this.paddingTop + this.paddingBottom) && applyChildren && child.setPosition(cc.v2(finalPositionX, nextY));
          var signX = 1;
          var tempFinalPositionX;
          var rightMarign = 0 === tempMaxWidth ? childBoundingBoxWidth : tempMaxWidth;
          if (this.horizontalDirection === HorizontalDirection.RIGHT_TO_LEFT) {
            signX = -1;
            containerResizeBoundary = containerResizeBoundary || this.node._contentSize.width;
            tempFinalPositionX = finalPositionX + signX * (rightMarign * maxWidthChildAnchorX + this.paddingLeft);
            tempFinalPositionX < containerResizeBoundary && (containerResizeBoundary = tempFinalPositionX);
          } else {
            containerResizeBoundary = containerResizeBoundary || -this.node._contentSize.width;
            tempFinalPositionX = finalPositionX + signX * (rightMarign * maxWidthChildAnchorX + this.paddingRight);
            tempFinalPositionX > containerResizeBoundary && (containerResizeBoundary = tempFinalPositionX);
          }
          nextY += topBoundaryOfChild;
        }
        return containerResizeBoundary;
      },
      _doLayoutBasic: function _doLayoutBasic() {
        var children = this.node.children;
        var allChildrenBoundingBox = null;
        for (var i = 0; i < children.length; ++i) {
          var child = children[i];
          child.activeInHierarchy && (allChildrenBoundingBox ? allChildrenBoundingBox.union(allChildrenBoundingBox, child.getBoundingBoxToWorld()) : allChildrenBoundingBox = child.getBoundingBoxToWorld());
        }
        if (allChildrenBoundingBox) {
          var leftBottomInParentSpace = this.node.parent.convertToNodeSpaceAR(cc.v2(allChildrenBoundingBox.x, allChildrenBoundingBox.y));
          leftBottomInParentSpace = cc.v2(leftBottomInParentSpace.x - this.paddingLeft, leftBottomInParentSpace.y - this.paddingBottom);
          var rightTopInParentSpace = this.node.parent.convertToNodeSpaceAR(cc.v2(allChildrenBoundingBox.x + allChildrenBoundingBox.width, allChildrenBoundingBox.y + allChildrenBoundingBox.height));
          rightTopInParentSpace = cc.v2(rightTopInParentSpace.x + this.paddingRight, rightTopInParentSpace.y + this.paddingTop);
          var newSize = cc.size(parseFloat((rightTopInParentSpace.x - leftBottomInParentSpace.x).toFixed(2)), parseFloat((rightTopInParentSpace.y - leftBottomInParentSpace.y).toFixed(2)));
          var layoutPosition = this.node.getPosition();
          if (0 !== newSize.width) {
            var newAnchorX = (layoutPosition.x - leftBottomInParentSpace.x) / newSize.width;
            this.node.anchorX = parseFloat(newAnchorX.toFixed(2));
          }
          if (0 !== newSize.height) {
            var newAnchorY = (layoutPosition.y - leftBottomInParentSpace.y) / newSize.height;
            this.node.anchorY = parseFloat(newAnchorY.toFixed(2));
          }
          this.node.setContentSize(newSize);
        }
      },
      _doLayoutGridAxisHorizontal: function _doLayoutGridAxisHorizontal(layoutAnchor, layoutSize) {
        var baseWidth = layoutSize.width;
        var sign = 1;
        var bottomBoundaryOfLayout = -layoutAnchor.y * layoutSize.height;
        var paddingY = this.paddingBottom;
        if (this.verticalDirection === VerticalDirection.TOP_TO_BOTTOM) {
          sign = -1;
          bottomBoundaryOfLayout = (1 - layoutAnchor.y) * layoutSize.height;
          paddingY = this.paddingTop;
        }
        var fnPositionY = function(child, topOffset, row) {
          return bottomBoundaryOfLayout + sign * (topOffset + child.anchorY * child.height * this._getUsedScaleValue(child.scaleY) + paddingY + row * this.spacingY);
        }.bind(this);
        var newHeight = 0;
        if (this.resizeMode === ResizeMode.CONTAINER) {
          var boundary = this._doLayoutHorizontally(baseWidth, true, fnPositionY, false);
          newHeight = bottomBoundaryOfLayout - boundary;
          newHeight < 0 && (newHeight *= -1);
          bottomBoundaryOfLayout = -layoutAnchor.y * newHeight;
          if (this.verticalDirection === VerticalDirection.TOP_TO_BOTTOM) {
            sign = -1;
            bottomBoundaryOfLayout = (1 - layoutAnchor.y) * newHeight;
          }
        }
        this._doLayoutHorizontally(baseWidth, true, fnPositionY, true);
        this.resizeMode === ResizeMode.CONTAINER && this.node.setContentSize(baseWidth, newHeight);
      },
      _doLayoutGridAxisVertical: function _doLayoutGridAxisVertical(layoutAnchor, layoutSize) {
        var baseHeight = layoutSize.height;
        var sign = 1;
        var leftBoundaryOfLayout = -layoutAnchor.x * layoutSize.width;
        var paddingX = this.paddingLeft;
        if (this.horizontalDirection === HorizontalDirection.RIGHT_TO_LEFT) {
          sign = -1;
          leftBoundaryOfLayout = (1 - layoutAnchor.x) * layoutSize.width;
          paddingX = this.paddingRight;
        }
        var fnPositionX = function(child, leftOffset, column) {
          return leftBoundaryOfLayout + sign * (leftOffset + child.anchorX * child.width * this._getUsedScaleValue(child.scaleX) + paddingX + column * this.spacingX);
        }.bind(this);
        var newWidth = 0;
        if (this.resizeMode === ResizeMode.CONTAINER) {
          var boundary = this._doLayoutVertically(baseHeight, true, fnPositionX, false);
          newWidth = leftBoundaryOfLayout - boundary;
          newWidth < 0 && (newWidth *= -1);
          leftBoundaryOfLayout = -layoutAnchor.x * newWidth;
          if (this.horizontalDirection === HorizontalDirection.RIGHT_TO_LEFT) {
            sign = -1;
            leftBoundaryOfLayout = (1 - layoutAnchor.x) * newWidth;
          }
        }
        this._doLayoutVertically(baseHeight, true, fnPositionX, true);
        this.resizeMode === ResizeMode.CONTAINER && this.node.setContentSize(newWidth, baseHeight);
      },
      _doLayoutGrid: function _doLayoutGrid() {
        var layoutAnchor = this.node.getAnchorPoint();
        var layoutSize = this.node.getContentSize();
        this.startAxis === AxisDirection.HORIZONTAL ? this._doLayoutGridAxisHorizontal(layoutAnchor, layoutSize) : this.startAxis === AxisDirection.VERTICAL && this._doLayoutGridAxisVertical(layoutAnchor, layoutSize);
      },
      _getHorizontalBaseWidth: function _getHorizontalBaseWidth(children) {
        var newWidth = 0;
        var activeChildCount = 0;
        if (this.resizeMode === ResizeMode.CONTAINER) {
          for (var i = 0; i < children.length; ++i) {
            var child = children[i];
            if (child.activeInHierarchy) {
              activeChildCount++;
              newWidth += child.width * this._getUsedScaleValue(child.scaleX);
            }
          }
          newWidth += (activeChildCount - 1) * this.spacingX + this.paddingLeft + this.paddingRight;
        } else newWidth = this.node.getContentSize().width;
        return newWidth;
      },
      _doLayout: function _doLayout() {
        if (this.type === Type.HORIZONTAL) {
          var newWidth = this._getHorizontalBaseWidth(this.node.children);
          var fnPositionY = function fnPositionY(child) {
            return child.y;
          };
          this._doLayoutHorizontally(newWidth, false, fnPositionY, true);
          this.node.width = newWidth;
        } else if (this.type === Type.VERTICAL) {
          var newHeight = this._getVerticalBaseHeight(this.node.children);
          var fnPositionX = function fnPositionX(child) {
            return child.x;
          };
          this._doLayoutVertically(newHeight, false, fnPositionX, true);
          this.node.height = newHeight;
        } else this.type === Type.NONE ? this.resizeMode === ResizeMode.CONTAINER && this._doLayoutBasic() : this.type === Type.GRID && this._doLayoutGrid();
      },
      _getUsedScaleValue: function _getUsedScaleValue(value) {
        return this.affectedByScale ? Math.abs(value) : 1;
      },
      updateLayout: function updateLayout() {
        if (this._layoutDirty && this.node.children.length > 0) {
          this._doLayout();
          this._layoutDirty = false;
        }
      }
    });
    Object.defineProperty(Layout.prototype, "padding", {
      get: function get() {
        cc.warnID(4100);
        return this.paddingLeft;
      },
      set: function set(value) {
        this._N$padding = value;
        this._migratePaddingData();
        this._doLayoutDirty();
      }
    });
    cc.Layout = module.exports = Layout;
  }), {
    "../CCNode": 29,
    "./CCComponent": 62
  } ],
  68: [ (function(require, module, exports) {
    "use strict";
    var _gfx = require("../../renderer/gfx");
    var _gfx2 = _interopRequireDefault(_gfx);
    var _vmath = require("../vmath");
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : {
        default: obj
      };
    }
    var misc = require("../utils/misc");
    var Material = require("../assets/material/CCMaterial");
    var RenderComponent = require("./CCRenderComponent");
    var RenderFlow = require("../renderer/render-flow");
    var Graphics = require("../graphics/graphics");
    var Node = require("../CCNode");
    var _vec2_temp = cc.v2();
    var _mat4_temp = _vmath.mat4.create();
    var _circlepoints = [];
    function _calculateCircle(center, radius, segements) {
      _circlepoints.length = 0;
      var anglePerStep = 2 * Math.PI / segements;
      for (var step = 0; step < segements; ++step) _circlepoints.push(cc.v2(radius.x * Math.cos(anglePerStep * step) + center.x, radius.y * Math.sin(anglePerStep * step) + center.y));
      return _circlepoints;
    }
    var MaskType = cc.Enum({
      RECT: 0,
      ELLIPSE: 1,
      IMAGE_STENCIL: 2
    });
    var SEGEMENTS_MIN = 3;
    var SEGEMENTS_MAX = 1e4;
    var Mask = cc.Class({
      name: "cc.Mask",
      extends: RenderComponent,
      editor: false,
      ctor: function ctor() {
        this._graphics = null;
        this._enableMaterial = null;
        this._exitMaterial = null;
        this._clearMaterial = null;
      },
      properties: {
        _spriteFrame: {
          default: null,
          type: cc.SpriteFrame
        },
        _type: MaskType.RECT,
        type: {
          get: function get() {
            return this._type;
          },
          set: function set(value) {
            this._type = value;
            if (this._type !== MaskType.IMAGE_STENCIL) {
              this.spriteFrame = null;
              this.alphaThreshold = 0;
              this._updateGraphics();
            }
            if (this._renderData) {
              this.destroyRenderData(this._renderData);
              this._renderData = null;
            }
            this._activateMaterial();
          },
          type: MaskType,
          tooltip: false
        },
        spriteFrame: {
          type: cc.SpriteFrame,
          tooltip: false,
          get: function get() {
            return this._spriteFrame;
          },
          set: function set(value) {
            var lastSprite = this._spriteFrame;
            false;
            if (lastSprite === value) return;
            this._spriteFrame = value;
            this._applySpriteFrame(lastSprite);
          }
        },
        alphaThreshold: {
          default: 0,
          type: cc.Float,
          range: [ 0, 1, .1 ],
          slide: true,
          tooltip: false,
          notify: function notify() {
            if (cc.game.renderType === cc.game.RENDER_TYPE_CANVAS) {
              cc.warnID(4201);
              return;
            }
            var material = this.sharedMaterials[0];
            material && material.setProperty("alphaThreshold", this.alphaThreshold);
          }
        },
        inverted: {
          default: false,
          type: cc.Boolean,
          tooltip: false,
          notify: function notify() {
            if (cc.game.renderType === cc.game.RENDER_TYPE_CANVAS) {
              cc.warnID(4202);
              return;
            }
          }
        },
        _segments: 64,
        segements: {
          get: function get() {
            return this._segments;
          },
          set: function set(value) {
            this._segments = misc.clampf(value, SEGEMENTS_MIN, SEGEMENTS_MAX);
            this._updateGraphics();
          },
          type: cc.Integer,
          tooltip: false
        },
        _resizeToTarget: {
          animatable: false,
          set: function set(value) {
            value && this._resizeNodeToTargetNode();
          }
        }
      },
      statics: {
        Type: MaskType
      },
      onLoad: function onLoad() {
        this._createGraphics();
      },
      onRestore: function onRestore() {
        this._createGraphics();
        this._type !== MaskType.IMAGE_STENCIL ? this._updateGraphics() : this._applySpriteFrame();
      },
      onEnable: function onEnable() {
        this._super();
        if (this._type === MaskType.IMAGE_STENCIL) {
          if (!this._spriteFrame || !this._spriteFrame.textureLoaded()) {
            this.markForRender(false);
            if (this._spriteFrame) {
              this.markForUpdateRenderData(false);
              this._spriteFrame.once("load", this._onTextureLoaded, this);
              this._spriteFrame.ensureLoadTexture();
            }
          }
        } else this._updateGraphics();
        this.node.on(cc.Node.EventType.POSITION_CHANGED, this._updateGraphics, this);
        this.node.on(cc.Node.EventType.ROTATION_CHANGED, this._updateGraphics, this);
        this.node.on(cc.Node.EventType.SCALE_CHANGED, this._updateGraphics, this);
        this.node.on(cc.Node.EventType.SIZE_CHANGED, this._updateGraphics, this);
        this.node.on(cc.Node.EventType.ANCHOR_CHANGED, this._updateGraphics, this);
        this.node._renderFlag |= RenderFlow.FLAG_POST_RENDER;
        this._activateMaterial();
      },
      onDisable: function onDisable() {
        this._super();
        this.node.off(cc.Node.EventType.POSITION_CHANGED, this._updateGraphics, this);
        this.node.off(cc.Node.EventType.ROTATION_CHANGED, this._updateGraphics, this);
        this.node.off(cc.Node.EventType.SCALE_CHANGED, this._updateGraphics, this);
        this.node.off(cc.Node.EventType.SIZE_CHANGED, this._updateGraphics, this);
        this.node.off(cc.Node.EventType.ANCHOR_CHANGED, this._updateGraphics, this);
        this.node._renderFlag &= ~RenderFlow.FLAG_POST_RENDER;
      },
      onDestroy: function onDestroy() {
        this._super();
        this._removeGraphics();
      },
      _resizeNodeToTargetNode: false,
      _onTextureLoaded: function _onTextureLoaded() {
        if (this._renderData) {
          this._renderData.uvDirty = true;
          this._renderData.vertDirty = true;
          this.markForUpdateRenderData(true);
        }
        this.enabledInHierarchy && this._activateMaterial();
      },
      _applySpriteFrame: function _applySpriteFrame(oldFrame) {
        oldFrame && oldFrame.off && oldFrame.off("load", this._onTextureLoaded, this);
        var spriteFrame = this._spriteFrame;
        if (spriteFrame) if (spriteFrame.textureLoaded()) this._onTextureLoaded(null); else {
          spriteFrame.once("load", this._onTextureLoaded, this);
          spriteFrame.ensureLoadTexture();
        } else this.disableRender();
      },
      _activateMaterial: function _activateMaterial() {
        if (this._type === MaskType.IMAGE_STENCIL && (!this.spriteFrame || !this.spriteFrame.textureLoaded())) {
          this.markForRender(false);
          return;
        }
        if (cc.game.renderType !== cc.game.RENDER_TYPE_CANVAS) {
          var material = this.sharedMaterials[0];
          material = material ? Material.getInstantiatedMaterial(material, this) : Material.getInstantiatedBuiltinMaterial("2d-sprite", this);
          material.define("USE_ALPHA_TEST", true);
          if (this._type === MaskType.IMAGE_STENCIL) {
            var texture = this.spriteFrame.getTexture();
            material.define("_USE_MODEL", false);
            material.define("USE_TEXTURE", true);
            material.setProperty("texture", texture);
            material.setProperty("alphaThreshold", this.alphaThreshold);
          } else {
            material.define("_USE_MODEL", true);
            material.define("USE_TEXTURE", false);
          }
          this._enableMaterial || (this._enableMaterial = Material.getInstantiatedBuiltinMaterial("2d-sprite", this));
          if (!this._exitMaterial) {
            this._exitMaterial = Material.getInstantiatedBuiltinMaterial("2d-sprite", this);
            var passes = this._exitMaterial.effect.getDefaultTechnique().passes;
            for (var i = 0; i < passes.length; i++) passes[i].setStencilEnabled(_gfx2.default.STENCIL_DISABLE);
          }
          this._clearMaterial || (this._clearMaterial = Material.getInstantiatedBuiltinMaterial("clear-stencil", this));
          this.setMaterial(0, material);
        }
        this.markForRender(true);
      },
      _createGraphics: function _createGraphics() {
        if (!this._graphics) {
          this._graphics = new Graphics();
          this._graphics.node = this.node;
          this._graphics.lineWidth = 0;
          this._graphics.strokeColor = cc.color(0, 0, 0, 0);
        }
      },
      _updateGraphics: function _updateGraphics() {
        var node = this.node;
        var graphics = this._graphics;
        graphics.clear(false);
        var width = node._contentSize.width;
        var height = node._contentSize.height;
        var x = -width * node._anchorPoint.x;
        var y = -height * node._anchorPoint.y;
        if (this._type === MaskType.RECT) graphics.rect(x, y, width, height); else if (this._type === MaskType.ELLIPSE) {
          var center = cc.v2(x + width / 2, y + height / 2);
          var radius = {
            x: width / 2,
            y: height / 2
          };
          var points = _calculateCircle(center, radius, this._segments);
          for (var i = 0; i < points.length; ++i) {
            var point = points[i];
            0 === i ? graphics.moveTo(point.x, point.y) : graphics.lineTo(point.x, point.y);
          }
          graphics.close();
        }
        cc.game.renderType === cc.game.RENDER_TYPE_CANVAS ? graphics.stroke() : graphics.fill();
      },
      _removeGraphics: function _removeGraphics() {
        if (this._graphics) {
          this._graphics.destroy();
          this._graphics = null;
        }
        if (this._clearGraphics) {
          this._clearGraphics.destroy();
          this._clearGraphics = null;
        }
      },
      _hitTest: function _hitTest(cameraPt) {
        var node = this.node;
        var size = node.getContentSize(), w = size.width, h = size.height, testPt = _vec2_temp;
        node._updateWorldMatrix();
        if (!_vmath.mat4.invert(_mat4_temp, node._worldMatrix)) return false;
        _vmath.vec2.transformMat4(testPt, cameraPt, _mat4_temp);
        testPt.x += node._anchorPoint.x * w;
        testPt.y += node._anchorPoint.y * h;
        var result = false;
        if (this.type === MaskType.RECT || this.type === MaskType.IMAGE_STENCIL) result = testPt.x >= 0 && testPt.y >= 0 && testPt.x <= w && testPt.y <= h; else if (this.type === MaskType.ELLIPSE) {
          var rx = w / 2, ry = h / 2;
          var px = testPt.x - .5 * w, py = testPt.y - .5 * h;
          result = px * px / (rx * rx) + py * py / (ry * ry) < 1;
        }
        this.inverted && (result = !result);
        return result;
      },
      markForUpdateRenderData: function markForUpdateRenderData(enable) {
        enable && this.enabledInHierarchy ? this.node._renderFlag |= RenderFlow.FLAG_UPDATE_RENDER_DATA : enable || (this.node._renderFlag &= ~RenderFlow.FLAG_UPDATE_RENDER_DATA);
      },
      markForRender: function markForRender(enable) {
        enable && this.enabledInHierarchy ? this.node._renderFlag |= RenderFlow.FLAG_RENDER | RenderFlow.FLAG_UPDATE_RENDER_DATA | RenderFlow.FLAG_POST_RENDER : enable || (this.node._renderFlag &= ~(RenderFlow.FLAG_RENDER | RenderFlow.FLAG_POST_RENDER));
      },
      disableRender: function disableRender() {
        this.node._renderFlag &= ~(RenderFlow.FLAG_RENDER | RenderFlow.FLAG_UPDATE_RENDER_DATA | RenderFlow.FLAG_POST_RENDER);
      }
    });
    cc.Mask = module.exports = Mask;
  }), {
    "../../renderer/gfx": 256,
    "../CCNode": 29,
    "../assets/material/CCMaterial": 52,
    "../graphics/graphics": 90,
    "../renderer/render-flow": 162,
    "../utils/misc": 204,
    "../vmath": 224,
    "./CCRenderComponent": 70
  } ],
  69: [ (function(require, module, exports) {
    "use strict";
    var RenderComponent = require("../components/CCRenderComponent");
    var Material = require("../assets/material/CCMaterial");
    var textureUtil = require("../utils/texture-util");
    var BlendFunc = require("../../core/utils/blend-func");
    var MotionStreak = cc.Class({
      name: "cc.MotionStreak",
      extends: RenderComponent,
      mixins: [ BlendFunc ],
      editor: false,
      ctor: function ctor() {
        this._points = [];
      },
      properties: {
        preview: {
          default: false,
          editorOnly: true,
          notify: false,
          animatable: false
        },
        _fadeTime: 1,
        fadeTime: {
          get: function get() {
            return this._fadeTime;
          },
          set: function set(value) {
            this._fadeTime = value;
            this.reset();
          },
          animatable: false,
          tooltip: false
        },
        _minSeg: 1,
        minSeg: {
          get: function get() {
            return this._minSeg;
          },
          set: function set(value) {
            this._minSeg = value;
          },
          animatable: false,
          tooltip: false
        },
        _stroke: 64,
        stroke: {
          get: function get() {
            return this._stroke;
          },
          set: function set(value) {
            this._stroke = value;
          },
          animatable: false,
          tooltip: false
        },
        _texture: {
          default: null,
          type: cc.Texture2D
        },
        texture: {
          get: function get() {
            return this._texture;
          },
          set: function set(value) {
            if (this._texture === value) return;
            this._texture = value;
            if (value && value.loaded) this._activateMaterial(); else {
              this.disableRender();
              this._ensureLoadTexture();
            }
          },
          type: cc.Texture2D,
          animatable: false,
          tooltip: false
        },
        _color: cc.Color.WHITE,
        color: {
          get: function get() {
            return this._color;
          },
          set: function set(value) {
            this._color = value;
          },
          type: cc.Color,
          tooltip: false
        },
        _fastMode: false,
        fastMode: {
          get: function get() {
            return this._fastMode;
          },
          set: function set(value) {
            this._fastMode = value;
          },
          animatable: false,
          tooltip: false
        }
      },
      onEnable: function onEnable() {
        this._super();
        if (this._texture && this._texture.loaded) this._activateMaterial(); else {
          this.disableRender();
          this._ensureLoadTexture();
        }
        this.reset();
      },
      _ensureLoadTexture: function _ensureLoadTexture() {
        if (this._texture && !this._texture.loaded) {
          var self = this;
          textureUtil.postLoadTexture(this._texture, (function() {
            self._activateMaterial();
          }));
        }
      },
      _activateMaterial: function _activateMaterial() {
        if (!this._texture || !this._texture.loaded) {
          this.disableRender();
          return;
        }
        var material = this.sharedMaterials[0];
        material = material ? Material.getInstantiatedMaterial(material, this) : Material.getInstantiatedBuiltinMaterial("2d-sprite", this);
        material.setProperty("texture", this._texture);
        this.setMaterial(0, material);
        this.markForRender(true);
      },
      onFocusInEditor: false,
      onLostFocusInEditor: false,
      reset: function reset() {
        this._points.length = 0;
        var renderData = this._renderData;
        if (renderData) {
          renderData.dataLength = 0;
          renderData.vertexCount = 0;
          renderData.indiceCount = 0;
        }
        false;
      }
    });
    cc.MotionStreak = module.exports = MotionStreak;
  }), {
    "../../core/utils/blend-func": 197,
    "../assets/material/CCMaterial": 52,
    "../components/CCRenderComponent": 70,
    "../utils/texture-util": 211
  } ],
  70: [ (function(require, module, exports) {
    "use strict";
    var _gfx = require("../../renderer/gfx");
    var _gfx2 = _interopRequireDefault(_gfx);
    var _renderData = require("../../renderer/render-data/render-data");
    var _renderData2 = _interopRequireDefault(_renderData);
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : {
        default: obj
      };
    }
    var Component = require("./CCComponent");
    var RenderFlow = require("../renderer/render-flow");
    var BlendFactor = require("../platform/CCMacro").BlendFactor;
    var Material = require("../assets/material/CCMaterial");
    var RenderComponent = cc.Class({
      name: "RenderComponent",
      extends: Component,
      editor: false,
      properties: {
        _materials: {
          default: [],
          type: Material
        },
        sharedMaterials: {
          get: function get() {
            return this._materials;
          },
          set: function set(val) {
            this._materials = val;
            this._activateMaterial(true);
          },
          type: [ Material ],
          displayName: "Materials"
        }
      },
      ctor: function ctor() {
        this._renderData = null;
        this.__allocedDatas = [];
        this._vertexFormat = null;
        this._toPostHandle = false;
        this._assembler = this.constructor._assembler;
        this._postAssembler = this.constructor._postAssembler;
      },
      onEnable: function onEnable() {
        this.node._renderComponent && (this.node._renderComponent.enabled = false);
        this.node._renderComponent = this;
        this.node._renderFlag |= RenderFlow.FLAG_RENDER | RenderFlow.FLAG_UPDATE_RENDER_DATA;
      },
      onDisable: function onDisable() {
        this.node._renderComponent = null;
        this.disableRender();
      },
      onDestroy: function onDestroy() {
        for (var i = 0, l = this.__allocedDatas.length; i < l; i++) _renderData2.default.free(this.__allocedDatas[i]);
        this.__allocedDatas.length = 0;
        this._materials.length = 0;
        this._renderData = null;
        var uniforms = this._uniforms;
        for (var name in uniforms) _uniformPool.remove(_uniformPool._data.indexOf(uniforms[name]));
        this._uniforms = null;
        this._defines = null;
      },
      _canRender: function _canRender() {
        return this._enabled && this.node._activeInHierarchy;
      },
      markForUpdateRenderData: function markForUpdateRenderData(enable) {
        enable && this._canRender() ? this.node._renderFlag |= RenderFlow.FLAG_UPDATE_RENDER_DATA : enable || (this.node._renderFlag &= ~RenderFlow.FLAG_UPDATE_RENDER_DATA);
      },
      markForRender: function markForRender(enable) {
        enable && this._canRender() ? this.node._renderFlag |= RenderFlow.FLAG_RENDER : enable || (this.node._renderFlag &= ~RenderFlow.FLAG_RENDER);
      },
      markForCustomIARender: function markForCustomIARender(enable) {
        enable && this._canRender() ? this.node._renderFlag |= RenderFlow.FLAG_CUSTOM_IA_RENDER : enable || (this.node._renderFlag &= ~RenderFlow.FLAG_CUSTOM_IA_RENDER);
      },
      disableRender: function disableRender() {
        this.node._renderFlag &= ~(RenderFlow.FLAG_RENDER | RenderFlow.FLAG_CUSTOM_IA_RENDER | RenderFlow.FLAG_UPDATE_RENDER_DATA);
      },
      requestRenderData: function requestRenderData() {
        var data = _renderData2.default.alloc();
        this.__allocedDatas.push(data);
        return data;
      },
      destroyRenderData: function destroyRenderData(data) {
        var index = this.__allocedDatas.indexOf(data);
        if (-1 !== index) {
          this.__allocedDatas.splice(index, 1);
          _renderData2.default.free(data);
        }
      },
      getMaterial: function getMaterial(index) {
        if (index < 0 || index >= this._materials.length) return null;
        var material = this._materials[index];
        if (!material) return null;
        var instantiated = Material.getInstantiatedMaterial(material, this);
        instantiated !== material && this.setMaterial(index, instantiated);
        return this._materials[index];
      },
      setMaterial: function setMaterial(index, material) {
        this._materials[index] = material;
        material && this.markForUpdateRenderData(true);
      },
      _activateMaterial: function _activateMaterial(force) {}
    });
    RenderComponent._assembler = null;
    RenderComponent._postAssembler = null;
    cc.RenderComponent = module.exports = RenderComponent;
  }), {
    "../../renderer/gfx": 256,
    "../../renderer/render-data/render-data": 276,
    "../assets/material/CCMaterial": 52,
    "../platform/CCMacro": 123,
    "../renderer/render-flow": 162,
    "./CCComponent": 62
  } ],
  71: [ (function(require, module, exports) {
    "use strict";
    var js = require("../platform/js");
    var macro = require("../platform/CCMacro");
    var textUtils = require("../utils/text-utils");
    var HtmlTextParser = require("../utils/html-text-parser");
    var _htmlTextParser = new HtmlTextParser();
    var HorizontalAlign = macro.TextAlignment;
    var VerticalAlign = macro.VerticalTextAlignment;
    var RichTextChildName = "RICHTEXT_CHILD";
    var RichTextChildImageName = "RICHTEXT_Image_CHILD";
    function debounce(func, wait, immediate) {
      var timeout = void 0;
      return function() {
        var context = this;
        var later = function later() {
          timeout = null;
          immediate || func.apply(context, arguments);
        };
        var callNow = immediate && !timeout;
        clearTimeout(timeout);
        timeout = setTimeout(later, wait);
        callNow && func.apply(context, arguments);
      };
    }
    var pool = new js.Pool(function(node) {
      false;
      false;
      if (!cc.isValid(node)) return false;
      if (node.getComponent(cc.LabelOutline)) return false;
      return true;
    }, 20);
    pool.get = function(string, richtext) {
      var labelNode = this._get();
      labelNode || (labelNode = new cc.PrivateNode(RichTextChildName));
      var labelComponent = labelNode.getComponent(cc.Label);
      labelComponent || (labelComponent = labelNode.addComponent(cc.Label));
      labelNode.setPosition(0, 0);
      labelNode.setAnchorPoint(.5, .5);
      labelNode.setContentSize(128, 128);
      labelNode.skewX = 0;
      "string" !== typeof string && (string = "" + string);
      var isAsset = richtext.font instanceof cc.Font;
      isAsset ? labelComponent.font = richtext.font : labelComponent.fontFamily = richtext.fontFamily;
      labelComponent.string = string;
      labelComponent.horizontalAlign = HorizontalAlign.LEFT;
      labelComponent.verticalAlign = VerticalAlign.TOP;
      labelComponent.fontSize = richtext.fontSize || 40;
      labelComponent.overflow = 0;
      labelComponent.enableWrapText = true;
      labelComponent.lineHeight = 40;
      labelComponent._enableBold(false);
      labelComponent._enableItalics(false);
      labelComponent._enableUnderline(false);
      return labelNode;
    };
    var RichText = cc.Class({
      name: "cc.RichText",
      extends: cc.Component,
      ctor: function ctor() {
        this._textArray = null;
        this._labelSegments = [];
        this._labelSegmentsCache = [];
        this._linesWidth = [];
        false;
        this._updateRichTextStatus = this._updateRichText;
      },
      editor: false,
      properties: {
        string: {
          default: "<color=#00ff00>Rich</c><color=#0fffff>Text</color>",
          multiline: true,
          tooltip: false,
          notify: function notify() {
            this._updateRichTextStatus();
          }
        },
        horizontalAlign: {
          default: HorizontalAlign.LEFT,
          type: HorizontalAlign,
          tooltip: false,
          animatable: false,
          notify: function notify(oldValue) {
            if (this.horizontalAlign === oldValue) return;
            this._layoutDirty = true;
            this._updateRichTextStatus();
          }
        },
        fontSize: {
          default: 40,
          tooltip: false,
          notify: function notify(oldValue) {
            if (this.fontSize === oldValue) return;
            this._layoutDirty = true;
            this._updateRichTextStatus();
          }
        },
        _fontFamily: "Arial",
        fontFamily: {
          tooltip: false,
          get: function get() {
            return this._fontFamily;
          },
          set: function set(value) {
            if (this._fontFamily === value) return;
            this._fontFamily = value;
            this._layoutDirty = true;
            this._updateRichTextStatus();
          },
          animatable: false
        },
        font: {
          default: null,
          type: cc.TTFFont,
          tooltip: false,
          notify: function notify(oldValue) {
            if (this.font === oldValue) return;
            this._layoutDirty = true;
            if (this.font) {
              this.useSystemFont = false;
              this._onTTFLoaded();
            } else this.useSystemFont = true;
            this._updateRichTextStatus();
          }
        },
        _isSystemFontUsed: true,
        useSystemFont: {
          get: function get() {
            return this._isSystemFontUsed;
          },
          set: function set(value) {
            if (!value && !this.font || this._isSystemFontUsed === value) return;
            this._isSystemFontUsed = value;
            this._layoutDirty = true;
            this._updateRichTextStatus();
          },
          animatable: false,
          tooltip: false
        },
        maxWidth: {
          default: 0,
          tooltip: false,
          notify: function notify(oldValue) {
            if (this.maxWidth === oldValue) return;
            this._layoutDirty = true;
            this._updateRichTextStatus();
          }
        },
        lineHeight: {
          default: 40,
          tooltip: false,
          notify: function notify(oldValue) {
            if (this.lineHeight === oldValue) return;
            this._layoutDirty = true;
            this._updateRichTextStatus();
          }
        },
        imageAtlas: {
          default: null,
          type: cc.SpriteAtlas,
          tooltip: false,
          notify: function notify(oldValue) {
            if (this.imageAtlas === oldValue) return;
            this._layoutDirty = true;
            this._updateRichTextStatus();
          }
        },
        handleTouchEvent: {
          default: true,
          tooltip: false,
          notify: function notify(oldValue) {
            if (this.handleTouchEvent === oldValue) return;
            this.enabledInHierarchy && (this.handleTouchEvent ? this._addEventListeners() : this._removeEventListeners());
          }
        }
      },
      statics: {
        HorizontalAlign: HorizontalAlign,
        VerticalAlign: VerticalAlign
      },
      onEnable: function onEnable() {
        this.handleTouchEvent && this._addEventListeners();
        this._updateRichText();
        this._activateChildren(true);
      },
      onDisable: function onDisable() {
        this.handleTouchEvent && this._removeEventListeners();
        this._activateChildren(false);
      },
      start: function start() {
        this._onTTFLoaded();
      },
      _onColorChanged: function _onColorChanged(parentColor) {
        var children = this.node.children;
        children.forEach((function(childNode) {
          childNode.color = parentColor;
        }));
      },
      _addEventListeners: function _addEventListeners() {
        this.node.on(cc.Node.EventType.TOUCH_END, this._onTouchEnded, this);
        this.node.on(cc.Node.EventType.COLOR_CHANGED, this._onColorChanged, this);
      },
      _removeEventListeners: function _removeEventListeners() {
        this.node.off(cc.Node.EventType.TOUCH_END, this._onTouchEnded, this);
        this.node.off(cc.Node.EventType.COLOR_CHANGED, this._onColorChanged, this);
      },
      _updateLabelSegmentTextAttributes: function _updateLabelSegmentTextAttributes() {
        this._labelSegments.forEach(function(item) {
          this._applyTextAttribute(item);
        }.bind(this));
      },
      _createFontLabel: function _createFontLabel(string) {
        return pool.get(string, this);
      },
      _onTTFLoaded: function _onTTFLoaded() {
        if (this.font instanceof cc.TTFFont) if (this.font._nativeAsset) {
          this._layoutDirty = true;
          this._updateRichText();
        } else {
          var self = this;
          cc.loader.load(this.font.nativeUrl, (function(err, fontFamily) {
            self._layoutDirty = true;
            self._updateRichText();
          }));
        } else {
          this._layoutDirty = true;
          this._updateRichText();
        }
      },
      _measureText: function _measureText(styleIndex, string) {
        var self = this;
        var func = function func(string) {
          var label = void 0;
          if (0 === self._labelSegmentsCache.length) {
            label = self._createFontLabel(string);
            self._labelSegmentsCache.push(label);
          } else {
            label = self._labelSegmentsCache[0];
            label.getComponent(cc.Label).string = string;
          }
          label._styleIndex = styleIndex;
          self._applyTextAttribute(label);
          var labelSize = label.getContentSize();
          return labelSize.width;
        };
        return string ? func(string) : func;
      },
      _onTouchEnded: function _onTouchEnded(event) {
        var _this = this;
        var components = this.node.getComponents(cc.Component);
        var _loop = function _loop(i) {
          var labelSegment = _this._labelSegments[i];
          var clickHandler = labelSegment._clickHandler;
          var clickParam = labelSegment._clickParam;
          if (clickHandler && _this._containsTouchLocation(labelSegment, event.touch.getLocation())) {
            components.forEach((function(component) {
              component.enabledInHierarchy && component[clickHandler] && component[clickHandler](event, clickParam);
            }));
            event.stopPropagation();
          }
        };
        for (var i = 0; i < this._labelSegments.length; ++i) _loop(i);
      },
      _containsTouchLocation: function _containsTouchLocation(label, point) {
        var myRect = label.getBoundingBoxToWorld();
        return myRect.contains(point);
      },
      _resetState: function _resetState() {
        var children = this.node.children;
        for (var i = children.length - 1; i >= 0; i--) {
          var child = children[i];
          if (child.name === RichTextChildName || child.name === RichTextChildImageName) {
            child.parent === this.node ? child.parent = null : children.splice(i, 1);
            child.name === RichTextChildName && pool.put(child);
          }
        }
        this._labelSegments.length = 0;
        this._labelSegmentsCache.length = 0;
        this._linesWidth.length = 0;
        this._lineOffsetX = 0;
        this._lineCount = 1;
        this._labelWidth = 0;
        this._labelHeight = 0;
        this._layoutDirty = true;
      },
      onRestore: false,
      _activateChildren: function _activateChildren(active) {
        for (var i = this.node.children.length - 1; i >= 0; i--) {
          var child = this.node.children[i];
          child.name !== RichTextChildName && child.name !== RichTextChildImageName || (child.active = active);
        }
      },
      _addLabelSegment: function _addLabelSegment(stringToken, styleIndex) {
        var labelSegment = void 0;
        if (0 === this._labelSegmentsCache.length) labelSegment = this._createFontLabel(stringToken); else {
          labelSegment = this._labelSegmentsCache.pop();
          labelSegment.getComponent(cc.Label).string = stringToken;
        }
        labelSegment._styleIndex = styleIndex;
        labelSegment._lineCount = this._lineCount;
        labelSegment.active = this.node.active;
        labelSegment.setAnchorPoint(0, 0);
        this._applyTextAttribute(labelSegment);
        this.node.addChild(labelSegment);
        this._labelSegments.push(labelSegment);
        return labelSegment;
      },
      _updateRichTextWithMaxWidth: function _updateRichTextWithMaxWidth(labelString, labelWidth, styleIndex) {
        var fragmentWidth = labelWidth;
        var labelSegment = void 0;
        if (this._lineOffsetX > 0 && fragmentWidth + this._lineOffsetX > this.maxWidth) {
          var checkStartIndex = 0;
          while (this._lineOffsetX <= this.maxWidth) {
            var checkEndIndex = this._getFirstWordLen(labelString, checkStartIndex, labelString.length);
            var checkString = labelString.substr(checkStartIndex, checkEndIndex);
            var checkStringWidth = this._measureText(styleIndex, checkString);
            if (!(this._lineOffsetX + checkStringWidth <= this.maxWidth)) {
              if (checkStartIndex > 0) {
                var remainingString = labelString.substr(0, checkStartIndex);
                this._addLabelSegment(remainingString, styleIndex);
                labelString = labelString.substr(checkStartIndex, labelString.length);
                fragmentWidth = this._measureText(styleIndex, labelString);
              }
              this._updateLineInfo();
              break;
            }
            this._lineOffsetX += checkStringWidth;
            checkStartIndex += checkEndIndex;
          }
        }
        if (fragmentWidth > this.maxWidth) {
          var fragments = textUtils.fragmentText(labelString, fragmentWidth, this.maxWidth, this._measureText(styleIndex));
          for (var k = 0; k < fragments.length; ++k) {
            var splitString = fragments[k];
            labelSegment = this._addLabelSegment(splitString, styleIndex);
            var labelSize = labelSegment.getContentSize();
            this._lineOffsetX += labelSize.width;
            fragments.length > 1 && k < fragments.length - 1 && this._updateLineInfo();
          }
        } else {
          this._lineOffsetX += fragmentWidth;
          this._addLabelSegment(labelString, styleIndex);
        }
      },
      _isLastComponentCR: function _isLastComponentCR(stringToken) {
        return stringToken.length - 1 === stringToken.lastIndexOf("\n");
      },
      _updateLineInfo: function _updateLineInfo() {
        this._linesWidth.push(this._lineOffsetX);
        this._lineOffsetX = 0;
        this._lineCount++;
      },
      _needsUpdateTextLayout: function _needsUpdateTextLayout(newTextArray) {
        if (this._layoutDirty || !this._textArray || !newTextArray) return true;
        if (this._textArray.length !== newTextArray.length) return true;
        for (var i = 0; i < this._textArray.length; ++i) {
          var oldItem = this._textArray[i];
          var newItem = newTextArray[i];
          if (oldItem.text !== newItem.text) return true;
          if (oldItem.style) {
            if (newItem.style) {
              if (!!newItem.style.outline !== !!oldItem.style.outline) return true;
              if (oldItem.style.size !== newItem.style.size || oldItem.style.italic !== newItem.style.italic || oldItem.style.isImage !== newItem.style.isImage) return true;
              if (oldItem.style.isImage === newItem.style.isImage && oldItem.style.src !== newItem.style.src) return true;
            } else if (oldItem.style.size || oldItem.style.italic || oldItem.style.isImage || oldItem.style.outline) return true;
          } else if (newItem.style && (newItem.style.size || newItem.style.italic || newItem.style.isImage || newItem.style.outline)) return true;
        }
        return false;
      },
      _addRichTextImageElement: function _addRichTextImageElement(richTextElement) {
        var spriteFrameName = richTextElement.style.src;
        var spriteFrame = this.imageAtlas.getSpriteFrame(spriteFrameName);
        if (spriteFrame) {
          var spriteNode = new cc.PrivateNode(RichTextChildImageName);
          var spriteComponent = spriteNode.addComponent(cc.Sprite);
          spriteNode.setAnchorPoint(0, 0);
          spriteComponent.type = cc.Sprite.Type.SLICED;
          spriteComponent.sizeMode = cc.Sprite.SizeMode.CUSTOM;
          this.node.addChild(spriteNode);
          this._labelSegments.push(spriteNode);
          var spriteRect = spriteFrame.getRect();
          var scaleFactor = 1;
          var spriteWidth = spriteRect.width;
          var spriteHeight = spriteRect.height;
          var expectWidth = richTextElement.style.imageWidth;
          var expectHeight = richTextElement.style.imageHeight;
          if (expectHeight > 0 && expectHeight < this.lineHeight) {
            scaleFactor = expectHeight / spriteHeight;
            spriteWidth *= scaleFactor;
            spriteHeight *= scaleFactor;
          } else {
            scaleFactor = this.lineHeight / spriteHeight;
            spriteWidth *= scaleFactor;
            spriteHeight *= scaleFactor;
          }
          expectWidth > 0 && (spriteWidth = expectWidth);
          if (this.maxWidth > 0) {
            this._lineOffsetX + spriteWidth > this.maxWidth && this._updateLineInfo();
            this._lineOffsetX += spriteWidth;
          } else {
            this._lineOffsetX += spriteWidth;
            this._lineOffsetX > this._labelWidth && (this._labelWidth = this._lineOffsetX);
          }
          spriteComponent.spriteFrame = spriteFrame;
          spriteNode.setContentSize(spriteWidth, spriteHeight);
          spriteNode._lineCount = this._lineCount;
          if (richTextElement.style.event) {
            richTextElement.style.event.click && (spriteNode._clickHandler = richTextElement.style.event.click);
            richTextElement.style.event.param ? spriteNode._clickParam = richTextElement.style.event.param : spriteNode._clickParam = "";
          } else spriteNode._clickHandler = null;
        } else cc.warnID(4400);
      },
      _updateRichText: function _updateRichText() {
        if (!this.enabled) return;
        var newTextArray = _htmlTextParser.parse(this.string);
        if (!this._needsUpdateTextLayout(newTextArray)) {
          this._textArray = newTextArray;
          this._updateLabelSegmentTextAttributes();
          return;
        }
        this._textArray = newTextArray;
        this._resetState();
        var lastEmptyLine = false;
        var label = void 0;
        var labelSize = void 0;
        for (var i = 0; i < this._textArray.length; ++i) {
          var richTextElement = this._textArray[i];
          var text = richTextElement.text;
          if ("" === text) {
            if (richTextElement.style && richTextElement.style.newline) {
              this._updateLineInfo();
              continue;
            }
            if (richTextElement.style && richTextElement.style.isImage && this.imageAtlas) {
              this._addRichTextImageElement(richTextElement);
              continue;
            }
          }
          var multilineTexts = text.split("\n");
          for (var j = 0; j < multilineTexts.length; ++j) {
            var labelString = multilineTexts[j];
            if ("" === labelString) {
              if (this._isLastComponentCR(text) && j === multilineTexts.length - 1) continue;
              this._updateLineInfo();
              lastEmptyLine = true;
              continue;
            }
            lastEmptyLine = false;
            if (this.maxWidth > 0) {
              var labelWidth = this._measureText(i, labelString);
              this._updateRichTextWithMaxWidth(labelString, labelWidth, i);
              multilineTexts.length > 1 && j < multilineTexts.length - 1 && this._updateLineInfo();
            } else {
              label = this._addLabelSegment(labelString, i);
              labelSize = label.getContentSize();
              this._lineOffsetX += labelSize.width;
              this._lineOffsetX > this._labelWidth && (this._labelWidth = this._lineOffsetX);
              multilineTexts.length > 1 && j < multilineTexts.length - 1 && this._updateLineInfo();
            }
          }
        }
        lastEmptyLine || this._linesWidth.push(this._lineOffsetX);
        this.maxWidth > 0 && (this._labelWidth = this.maxWidth);
        this._labelHeight = (this._lineCount + textUtils.BASELINE_RATIO) * this.lineHeight;
        this.node.setContentSize(this._labelWidth, this._labelHeight);
        this._updateRichTextPosition();
        this._layoutDirty = false;
      },
      _getFirstWordLen: function _getFirstWordLen(text, startIndex, textLen) {
        var character = text.charAt(startIndex);
        if (textUtils.isUnicodeCJK(character) || textUtils.isUnicodeSpace(character)) return 1;
        var len = 1;
        for (var index = startIndex + 1; index < textLen; ++index) {
          character = text.charAt(index);
          if (textUtils.isUnicodeSpace(character) || textUtils.isUnicodeCJK(character)) break;
          len++;
        }
        return len;
      },
      _updateRichTextPosition: function _updateRichTextPosition() {
        var nextTokenX = 0;
        var nextLineIndex = 1;
        var totalLineCount = this._lineCount;
        for (var i = 0; i < this._labelSegments.length; ++i) {
          var label = this._labelSegments[i];
          var lineCount = label._lineCount;
          if (lineCount > nextLineIndex) {
            nextTokenX = 0;
            nextLineIndex = lineCount;
          }
          var lineOffsetX = 0;
          switch (this.horizontalAlign) {
           case HorizontalAlign.LEFT:
            lineOffsetX = -this._labelWidth / 2;
            break;

           case HorizontalAlign.CENTER:
            lineOffsetX = -this._linesWidth[lineCount - 1] / 2;
            break;

           case HorizontalAlign.RIGHT:
            lineOffsetX = this._labelWidth / 2 - this._linesWidth[lineCount - 1];
          }
          label.x = nextTokenX + lineOffsetX;
          var labelSize = label.getContentSize();
          label.y = this.lineHeight * (totalLineCount - lineCount) - this._labelHeight / 2;
          lineCount === nextLineIndex && (nextTokenX += labelSize.width);
        }
      },
      _convertLiteralColorValue: function _convertLiteralColorValue(color) {
        var colorValue = color.toUpperCase();
        if (cc.Color[colorValue]) return cc.Color[colorValue];
        var out = cc.color();
        return out.fromHEX(color);
      },
      _applyTextAttribute: function _applyTextAttribute(labelNode) {
        var labelComponent = labelNode.getComponent(cc.Label);
        if (!labelComponent) return;
        var index = labelNode._styleIndex;
        this._isSystemFontUsed && (labelComponent.fontFamily = this._fontFamily);
        labelComponent.useSystemFont = this._isSystemFontUsed;
        labelComponent.lineHeight = this.lineHeight;
        labelComponent.horizontalAlign = HorizontalAlign.LEFT;
        labelComponent.verticalAlign = VerticalAlign.CENTER;
        var textStyle = null;
        this._textArray[index] && (textStyle = this._textArray[index].style);
        textStyle && textStyle.color ? labelNode.color = this._convertLiteralColorValue(textStyle.color) : labelNode.color = this.node.color;
        labelComponent._enableBold(textStyle && textStyle.bold);
        labelComponent._enableItalics(textStyle && textStyle.italic);
        textStyle && textStyle.italic && (labelNode.skewX = 12);
        labelComponent._enableUnderline(textStyle && textStyle.underline);
        if (textStyle && textStyle.outline) {
          var labelOutlineComponent = labelNode.getComponent(cc.LabelOutline);
          labelOutlineComponent || (labelOutlineComponent = labelNode.addComponent(cc.LabelOutline));
          labelOutlineComponent.color = this._convertLiteralColorValue(textStyle.outline.color);
          labelOutlineComponent.width = textStyle.outline.width;
        }
        textStyle && textStyle.size ? labelComponent.fontSize = textStyle.size : labelComponent.fontSize = this.fontSize;
        labelComponent._updateRenderData(true);
        if (textStyle && textStyle.event) {
          textStyle.event.click && (labelNode._clickHandler = textStyle.event.click);
          textStyle.event.param ? labelNode._clickParam = textStyle.event.param : labelNode._clickParam = "";
        } else labelNode._clickHandler = null;
      },
      onDestroy: function onDestroy() {
        for (var i = 0; i < this._labelSegments.length; ++i) {
          this._labelSegments[i].removeFromParent();
          pool.put(this._labelSegments[i]);
        }
      }
    });
    cc.RichText = module.exports = RichText;
  }), {
    "../platform/CCMacro": 123,
    "../platform/js": 138,
    "../utils/html-text-parser": 201,
    "../utils/text-utils": 210
  } ],
  72: [ (function(require, module, exports) {
    "use strict";
    var misc = require("../utils/misc");
    var Component = require("./CCComponent");
    var Direction = cc.Enum({
      Horizontal: 0,
      Vertical: 1
    });
    var Slider = cc.Class({
      name: "cc.Slider",
      extends: Component,
      editor: false,
      ctor: function ctor() {
        this._offset = cc.v2();
        this._touchHandle = false;
        this._dragging = false;
      },
      properties: {
        handle: {
          default: null,
          type: cc.Button,
          tooltip: false,
          notify: function notify() {
            false;
          }
        },
        direction: {
          default: Direction.Horizontal,
          type: Direction,
          tooltip: false
        },
        progress: {
          default: .5,
          type: cc.Float,
          range: [ 0, 1, .1 ],
          slide: true,
          tooltip: false,
          notify: function notify() {
            this._updateHandlePosition();
          }
        },
        slideEvents: {
          default: [],
          type: cc.Component.EventHandler,
          tooltip: false
        }
      },
      statics: {
        Direction: Direction
      },
      __preload: function __preload() {
        this._updateHandlePosition();
      },
      onEnable: function onEnable() {
        this.node.on(cc.Node.EventType.TOUCH_START, this._onTouchBegan, this);
        this.node.on(cc.Node.EventType.TOUCH_MOVE, this._onTouchMoved, this);
        this.node.on(cc.Node.EventType.TOUCH_END, this._onTouchEnded, this);
        this.node.on(cc.Node.EventType.TOUCH_CANCEL, this._onTouchCancelled, this);
        if (this.handle && this.handle.isValid) {
          this.handle.node.on(cc.Node.EventType.TOUCH_START, this._onHandleDragStart, this);
          this.handle.node.on(cc.Node.EventType.TOUCH_MOVE, this._onTouchMoved, this);
          this.handle.node.on(cc.Node.EventType.TOUCH_END, this._onTouchEnded, this);
        }
      },
      onDisable: function onDisable() {
        this.node.off(cc.Node.EventType.TOUCH_START, this._onTouchBegan, this);
        this.node.off(cc.Node.EventType.TOUCH_MOVE, this._onTouchMoved, this);
        this.node.off(cc.Node.EventType.TOUCH_END, this._onTouchEnded, this);
        this.node.off(cc.Node.EventType.TOUCH_CANCEL, this._onTouchCancelled, this);
        if (this.handle && this.handle.isValid) {
          this.handle.node.off(cc.Node.EventType.TOUCH_START, this._onHandleDragStart, this);
          this.handle.node.off(cc.Node.EventType.TOUCH_MOVE, this._onTouchMoved, this);
          this.handle.node.off(cc.Node.EventType.TOUCH_END, this._onTouchEnded, this);
        }
      },
      _onHandleDragStart: function _onHandleDragStart(event) {
        this._dragging = true;
        this._touchHandle = true;
        this._offset = this.handle.node.convertToNodeSpaceAR(event.touch.getLocation());
        event.stopPropagation();
      },
      _onTouchBegan: function _onTouchBegan(event) {
        if (!this.handle) return;
        this._dragging = true;
        this._touchHandle || this._handleSliderLogic(event.touch);
        event.stopPropagation();
      },
      _onTouchMoved: function _onTouchMoved(event) {
        if (!this._dragging) return;
        this._handleSliderLogic(event.touch);
        event.stopPropagation();
      },
      _onTouchEnded: function _onTouchEnded(event) {
        this._dragging = false;
        this._touchHandle = false;
        this._offset = cc.v2();
        event.stopPropagation();
      },
      _onTouchCancelled: function _onTouchCancelled(event) {
        this._dragging = false;
        event.stopPropagation();
      },
      _handleSliderLogic: function _handleSliderLogic(touch) {
        this._updateProgress(touch);
        this._emitSlideEvent();
      },
      _emitSlideEvent: function _emitSlideEvent() {
        cc.Component.EventHandler.emitEvents(this.slideEvents, this);
        this.node.emit("slide", this);
      },
      _updateProgress: function _updateProgress(touch) {
        if (!this.handle) return;
        var localTouchPos = this.node.convertToNodeSpace(touch.getLocation());
        this.direction === Direction.Horizontal ? this.progress = misc.clamp01((localTouchPos.x - this._offset.x) / this.node.width) : this.progress = misc.clamp01((localTouchPos.y - this._offset.y) / this.node.height);
      },
      _updateHandlePosition: function _updateHandlePosition() {
        if (!this.handle) return;
        var handlelocalPos;
        handlelocalPos = this.direction === Direction.Horizontal ? cc.v2(-this.node.width * this.node.anchorX + this.progress * this.node.width, 0) : cc.v2(0, -this.node.height * this.node.anchorY + this.progress * this.node.height);
        var worldSpacePos = this.node.convertToWorldSpaceAR(handlelocalPos);
        this.handle.node.position = this.handle.node.parent.convertToNodeSpaceAR(worldSpacePos);
      }
    });
    cc.Slider = module.exports = Slider;
  }), {
    "../utils/misc": 204,
    "./CCComponent": 62
  } ],
  73: [ (function(require, module, exports) {
    "use strict";
    var misc = require("../utils/misc");
    var NodeEvent = require("../CCNode").EventType;
    var RenderComponent = require("./CCRenderComponent");
    var RenderFlow = require("../renderer/render-flow");
    var BlendFunc = require("../utils/blend-func");
    var Material = require("../assets/material/CCMaterial");
    var SpriteType = cc.Enum({
      SIMPLE: 0,
      SLICED: 1,
      TILED: 2,
      FILLED: 3,
      MESH: 4
    });
    var FillType = cc.Enum({
      HORIZONTAL: 0,
      VERTICAL: 1,
      RADIAL: 2
    });
    var SizeMode = cc.Enum({
      CUSTOM: 0,
      TRIMMED: 1,
      RAW: 2
    });
    var State = cc.Enum({
      NORMAL: 0,
      GRAY: 1
    });
    var Sprite = cc.Class({
      name: "cc.Sprite",
      extends: RenderComponent,
      mixins: [ BlendFunc ],
      editor: false,
      properties: {
        _spriteFrame: {
          default: null,
          type: cc.SpriteFrame
        },
        _type: SpriteType.SIMPLE,
        _sizeMode: SizeMode.TRIMMED,
        _fillType: 0,
        _fillCenter: cc.v2(0, 0),
        _fillStart: 0,
        _fillRange: 0,
        _isTrimmedMode: true,
        _atlas: {
          default: null,
          type: cc.SpriteAtlas,
          tooltip: false,
          editorOnly: true,
          visible: true,
          animatable: false
        },
        spriteFrame: {
          get: function get() {
            return this._spriteFrame;
          },
          set: function set(value, force) {
            var lastSprite = this._spriteFrame;
            false;
            if (lastSprite === value) return;
            this._spriteFrame = value;
            this.markForUpdateRenderData(false);
            this._applySpriteFrame(lastSprite);
            false;
          },
          type: cc.SpriteFrame
        },
        type: {
          get: function get() {
            return this._type;
          },
          set: function set(value) {
            if (this._type !== value) {
              this.destroyRenderData(this._renderData);
              this._renderData = null;
              this._type = value;
              this._updateAssembler();
            }
          },
          type: SpriteType,
          animatable: false,
          tooltip: false
        },
        fillType: {
          get: function get() {
            return this._fillType;
          },
          set: function set(value) {
            if (value !== this._fillType) {
              if (value === FillType.RADIAL || this._fillType === FillType.RADIAL) {
                this.destroyRenderData(this._renderData);
                this._renderData = null;
              } else this._renderData && this.markForUpdateRenderData(true);
              this._fillType = value;
              this._updateAssembler();
            }
          },
          type: FillType,
          tooltip: false
        },
        fillCenter: {
          get: function get() {
            return this._fillCenter;
          },
          set: function set(value) {
            this._fillCenter.x = value.x;
            this._fillCenter.y = value.y;
            this._type === SpriteType.FILLED && this._renderData && this.markForUpdateRenderData(true);
          },
          tooltip: false
        },
        fillStart: {
          get: function get() {
            return this._fillStart;
          },
          set: function set(value) {
            this._fillStart = misc.clampf(value, -1, 1);
            this._type === SpriteType.FILLED && this._renderData && this.markForUpdateRenderData(true);
          },
          tooltip: false
        },
        fillRange: {
          get: function get() {
            return this._fillRange;
          },
          set: function set(value) {
            this._fillRange = misc.clampf(value, -1, 1);
            this._type === SpriteType.FILLED && this._renderData && this.markForUpdateRenderData(true);
          },
          tooltip: false
        },
        trim: {
          get: function get() {
            return this._isTrimmedMode;
          },
          set: function set(value) {
            if (this._isTrimmedMode !== value) {
              this._isTrimmedMode = value;
              this._type !== SpriteType.SIMPLE && this._type !== SpriteType.MESH || !this._renderData || this.markForUpdateRenderData(true);
            }
          },
          animatable: false,
          tooltip: false
        },
        sizeMode: {
          get: function get() {
            return this._sizeMode;
          },
          set: function set(value) {
            this._sizeMode = value;
            value !== SizeMode.CUSTOM && this._applySpriteSize();
          },
          animatable: false,
          type: SizeMode,
          tooltip: false
        }
      },
      statics: {
        FillType: FillType,
        Type: SpriteType,
        SizeMode: SizeMode,
        State: State
      },
      setVisible: function setVisible(visible) {
        this.enabled = visible;
      },
      setState: function setState() {},
      getState: function getState() {},
      onEnable: function onEnable() {
        this._super();
        if (!this._spriteFrame || !this._spriteFrame.textureLoaded()) {
          this.disableRender();
          if (this._spriteFrame) {
            this._spriteFrame.once("load", this._onTextureLoaded, this);
            this._spriteFrame.ensureLoadTexture();
          }
        }
        this._updateAssembler();
        this._activateMaterial();
        this.node.on(NodeEvent.SIZE_CHANGED, this._onNodeSizeDirty, this);
        this.node.on(NodeEvent.ANCHOR_CHANGED, this._onNodeSizeDirty, this);
      },
      onDisable: function onDisable() {
        this._super();
        this.node.off(NodeEvent.SIZE_CHANGED, this._onNodeSizeDirty, this);
        this.node.off(NodeEvent.ANCHOR_CHANGED, this._onNodeSizeDirty, this);
      },
      _onNodeSizeDirty: function _onNodeSizeDirty() {
        if (!this._renderData) return;
        this.markForUpdateRenderData(true);
      },
      _on3DNodeChanged: function _on3DNodeChanged() {
        this._updateAssembler();
      },
      _updateAssembler: function _updateAssembler() {
        var assembler = Sprite._assembler.getAssembler(this);
        if (this._assembler !== assembler) {
          this._assembler = assembler;
          this._renderData = null;
        }
        if (!this._renderData) {
          this._renderData = this._assembler.createData(this);
          this.markForUpdateRenderData(true);
        }
      },
      _activateMaterial: function _activateMaterial() {
        if (cc.game.renderType === cc.game.RENDER_TYPE_CANVAS) {
          this.markForUpdateRenderData(true);
          this.markForRender(true);
          return;
        }
        var spriteFrame = this._spriteFrame;
        if (!spriteFrame || !spriteFrame.textureLoaded()) {
          this.disableRender();
          return;
        }
        var material = this.sharedMaterials[0];
        material = material ? Material.getInstantiatedMaterial(material, this) : Material.getInstantiatedBuiltinMaterial("2d-sprite", this);
        material.setProperty("texture", spriteFrame.getTexture());
        this.setMaterial(0, material);
        this.markForRender(true);
      },
      _applyAtlas: false,
      _canRender: function _canRender() {
        if (cc.game.renderType === cc.game.RENDER_TYPE_CANVAS) {
          if (!this._enabled) return false;
        } else if (!this._enabled || !this.sharedMaterials[0] || !this.node._activeInHierarchy) return false;
        var spriteFrame = this._spriteFrame;
        if (!spriteFrame || !spriteFrame.textureLoaded()) return false;
        return true;
      },
      markForUpdateRenderData: function markForUpdateRenderData(enable) {
        if (enable && this._canRender()) {
          this.node._renderFlag |= RenderFlow.FLAG_UPDATE_RENDER_DATA;
          var renderData = this._renderData;
          if (renderData) {
            renderData.uvDirty = true;
            renderData.vertDirty = true;
          }
        } else enable || (this.node._renderFlag &= ~RenderFlow.FLAG_UPDATE_RENDER_DATA);
      },
      _applySpriteSize: function _applySpriteSize() {
        if (this._spriteFrame) {
          if (SizeMode.RAW === this._sizeMode) {
            var size = this._spriteFrame.getOriginalSize();
            this.node.setContentSize(size);
          } else if (SizeMode.TRIMMED === this._sizeMode) {
            var rect = this._spriteFrame.getRect();
            this.node.setContentSize(rect.width, rect.height);
          }
          this._activateMaterial();
        }
      },
      _onTextureLoaded: function _onTextureLoaded() {
        if (!this.isValid) return;
        this._applySpriteSize();
      },
      _applySpriteFrame: function _applySpriteFrame(oldFrame) {
        oldFrame && oldFrame.off && oldFrame.off("load", this._onTextureLoaded, this);
        var spriteFrame = this._spriteFrame;
        var material = this.sharedMaterials[0];
        spriteFrame && (material && material._texture) === (spriteFrame && spriteFrame._texture) || this.markForRender(false);
        if (spriteFrame) if (oldFrame && spriteFrame._texture === oldFrame._texture) this._applySpriteSize(); else if (spriteFrame.textureLoaded()) this._onTextureLoaded(null); else {
          spriteFrame.once("load", this._onTextureLoaded, this);
          spriteFrame.ensureLoadTexture();
        }
        false;
      },
      _resized: false
    });
    false;
    cc.Sprite = module.exports = Sprite;
  }), {
    "../CCNode": 29,
    "../assets/material/CCMaterial": 52,
    "../renderer/render-flow": 162,
    "../utils/blend-func": 197,
    "../utils/misc": 204,
    "./CCRenderComponent": 70
  } ],
  74: [ (function(require, module, exports) {
    "use strict";
    var ComponentType = cc.Enum({
      NONE: 0,
      CHECKBOX: 1,
      TEXT_ATLAS: 2,
      SLIDER_BAR: 3,
      LIST_VIEW: 4,
      PAGE_VIEW: 5
    });
    var ListDirection = cc.Enum({
      VERTICAL: 0,
      HORIZONTAL: 1
    });
    var VerticalAlign = cc.Enum({
      TOP: 0,
      CENTER: 1,
      BOTTOM: 2
    });
    var HorizontalAlign = cc.Enum({
      LEFT: 0,
      CENTER: 1,
      RIGHT: 2
    });
    var StudioComponent = cc.Class({
      name: "cc.StudioComponent",
      extends: cc.Component,
      editor: false,
      properties: false,
      statics: {
        ComponentType: ComponentType,
        ListDirection: ListDirection,
        VerticalAlign: VerticalAlign,
        HorizontalAlign: HorizontalAlign
      }
    });
    var PrefabHelper = require("../utils/prefab-helper");
    StudioComponent.PlaceHolder = cc.Class({
      name: "cc.StudioComponent.PlaceHolder",
      extends: cc.Component,
      properties: {
        _baseUrl: "",
        nestedPrefab: cc.Prefab
      },
      onLoad: function onLoad() {
        if (!this.nestedPrefab) {
          false;
          return;
        }
        this._replaceWithNestedPrefab();
      },
      _replaceWithNestedPrefab: function _replaceWithNestedPrefab() {
        var node = this.node;
        var _prefab = node._prefab;
        _prefab.root = node;
        _prefab.asset = this.nestedPrefab;
        PrefabHelper.syncWithPrefab(node);
      }
    });
    cc.StudioComponent = module.exports = StudioComponent;
    var StudioWidget = cc.Class({
      name: "cc.StudioWidget",
      extends: cc.Widget,
      editor: false,
      _validateTargetInDEV: function _validateTargetInDEV() {}
    });
    cc.StudioWidget = module.exports = StudioWidget;
  }), {
    "../utils/prefab-helper": 206
  } ],
  75: [ (function(require, module, exports) {
    "use strict";
    var WidgetManager = require("../base-ui/CCWidgetManager");
    var AlignMode = WidgetManager.AlignMode;
    var AlignFlags = WidgetManager._AlignFlags;
    var TOP = AlignFlags.TOP;
    var MID = AlignFlags.MID;
    var BOT = AlignFlags.BOT;
    var LEFT = AlignFlags.LEFT;
    var CENTER = AlignFlags.CENTER;
    var RIGHT = AlignFlags.RIGHT;
    var TOP_BOT = TOP | BOT;
    var LEFT_RIGHT = LEFT | RIGHT;
    var Widget = cc.Class({
      name: "cc.Widget",
      extends: require("./CCComponent"),
      editor: false,
      properties: {
        target: {
          get: function get() {
            return this._target;
          },
          set: function set(value) {
            this._target = value;
            false;
          },
          type: cc.Node,
          tooltip: false
        },
        isAlignTop: {
          get: function get() {
            return (this._alignFlags & TOP) > 0;
          },
          set: function set(value) {
            this._setAlign(TOP, value);
          },
          animatable: false,
          tooltip: false
        },
        isAlignVerticalCenter: {
          get: function get() {
            return (this._alignFlags & MID) > 0;
          },
          set: function set(value) {
            if (value) {
              this.isAlignTop = false;
              this.isAlignBottom = false;
              this._alignFlags |= MID;
            } else this._alignFlags &= ~MID;
          },
          animatable: false,
          tooltip: false
        },
        isAlignBottom: {
          get: function get() {
            return (this._alignFlags & BOT) > 0;
          },
          set: function set(value) {
            this._setAlign(BOT, value);
          },
          animatable: false,
          tooltip: false
        },
        isAlignLeft: {
          get: function get() {
            return (this._alignFlags & LEFT) > 0;
          },
          set: function set(value) {
            this._setAlign(LEFT, value);
          },
          animatable: false,
          tooltip: false
        },
        isAlignHorizontalCenter: {
          get: function get() {
            return (this._alignFlags & CENTER) > 0;
          },
          set: function set(value) {
            if (value) {
              this.isAlignLeft = false;
              this.isAlignRight = false;
              this._alignFlags |= CENTER;
            } else this._alignFlags &= ~CENTER;
          },
          animatable: false,
          tooltip: false
        },
        isAlignRight: {
          get: function get() {
            return (this._alignFlags & RIGHT) > 0;
          },
          set: function set(value) {
            this._setAlign(RIGHT, value);
          },
          animatable: false,
          tooltip: false
        },
        isStretchWidth: {
          get: function get() {
            return (this._alignFlags & LEFT_RIGHT) === LEFT_RIGHT;
          },
          visible: false
        },
        isStretchHeight: {
          get: function get() {
            return (this._alignFlags & TOP_BOT) === TOP_BOT;
          },
          visible: false
        },
        top: {
          get: function get() {
            return this._top;
          },
          set: function set(value) {
            this._top = value;
          },
          tooltip: false
        },
        bottom: {
          get: function get() {
            return this._bottom;
          },
          set: function set(value) {
            this._bottom = value;
          },
          tooltip: false
        },
        left: {
          get: function get() {
            return this._left;
          },
          set: function set(value) {
            this._left = value;
          },
          tooltip: false
        },
        right: {
          get: function get() {
            return this._right;
          },
          set: function set(value) {
            this._right = value;
          },
          tooltip: false
        },
        horizontalCenter: {
          get: function get() {
            return this._horizontalCenter;
          },
          set: function set(value) {
            this._horizontalCenter = value;
          },
          tooltip: false
        },
        verticalCenter: {
          get: function get() {
            return this._verticalCenter;
          },
          set: function set(value) {
            this._verticalCenter = value;
          },
          tooltip: false
        },
        isAbsoluteHorizontalCenter: {
          get: function get() {
            return this._isAbsHorizontalCenter;
          },
          set: function set(value) {
            this._isAbsHorizontalCenter = value;
          },
          animatable: false
        },
        isAbsoluteVerticalCenter: {
          get: function get() {
            return this._isAbsVerticalCenter;
          },
          set: function set(value) {
            this._isAbsVerticalCenter = value;
          },
          animatable: false
        },
        isAbsoluteTop: {
          get: function get() {
            return this._isAbsTop;
          },
          set: function set(value) {
            this._isAbsTop = value;
          },
          animatable: false
        },
        isAbsoluteBottom: {
          get: function get() {
            return this._isAbsBottom;
          },
          set: function set(value) {
            this._isAbsBottom = value;
          },
          animatable: false
        },
        isAbsoluteLeft: {
          get: function get() {
            return this._isAbsLeft;
          },
          set: function set(value) {
            this._isAbsLeft = value;
          },
          animatable: false
        },
        isAbsoluteRight: {
          get: function get() {
            return this._isAbsRight;
          },
          set: function set(value) {
            this._isAbsRight = value;
          },
          animatable: false
        },
        alignMode: {
          default: AlignMode.ON_WINDOW_RESIZE,
          type: AlignMode,
          tooltip: false
        },
        _wasAlignOnce: {
          default: void 0,
          formerlySerializedAs: "isAlignOnce"
        },
        _target: null,
        _alignFlags: 0,
        _left: 0,
        _right: 0,
        _top: 0,
        _bottom: 0,
        _verticalCenter: 0,
        _horizontalCenter: 0,
        _isAbsLeft: true,
        _isAbsRight: true,
        _isAbsTop: true,
        _isAbsBottom: true,
        _isAbsHorizontalCenter: true,
        _isAbsVerticalCenter: true,
        _originalWidth: 0,
        _originalHeight: 0
      },
      statics: {
        AlignMode: AlignMode
      },
      onLoad: function onLoad() {
        if (void 0 !== this._wasAlignOnce) {
          this.alignMode = this._wasAlignOnce ? AlignMode.ONCE : AlignMode.ALWAYS;
          this._wasAlignOnce = void 0;
        }
      },
      onEnable: function onEnable() {
        WidgetManager.add(this);
      },
      onDisable: function onDisable() {
        WidgetManager.remove(this);
      },
      _validateTargetInDEV: false,
      _setAlign: function _setAlign(flag, isAlign) {
        var current = (this._alignFlags & flag) > 0;
        if (isAlign === current) return;
        var isHorizontal = (flag & LEFT_RIGHT) > 0;
        if (isAlign) {
          this._alignFlags |= flag;
          if (isHorizontal) {
            this.isAlignHorizontalCenter = false;
            if (this.isStretchWidth) {
              this._originalWidth = this.node.width;
              false;
            }
          } else {
            this.isAlignVerticalCenter = false;
            if (this.isStretchHeight) {
              this._originalHeight = this.node.height;
              false;
            }
          }
          false;
        } else {
          isHorizontal ? this.isStretchWidth && (this.node.width = this._originalWidth) : this.isStretchHeight && (this.node.height = this._originalHeight);
          this._alignFlags &= ~flag;
        }
      },
      updateAlignment: function updateAlignment() {
        WidgetManager.updateAlignment(this.node);
      }
    });
    Object.defineProperty(Widget.prototype, "isAlignOnce", {
      get: function get() {
        true;
        cc.warn("`widget.isAlignOnce` is deprecated, use `widget.alignMode === cc.Widget.AlignMode.ONCE` instead please.");
        return this.alignMode === AlignMode.ONCE;
      },
      set: function set(value) {
        true;
        cc.warn("`widget.isAlignOnce` is deprecated, use `widget.alignMode = cc.Widget.AlignMode.*` instead please.");
        this.alignMode = value ? AlignMode.ONCE : AlignMode.ALWAYS;
      }
    });
    cc.Widget = module.exports = Widget;
  }), {
    "../base-ui/CCWidgetManager": 55,
    "./CCComponent": 62
  } ],
  76: [ (function(require, module, exports) {
    "use strict";
    var Component = require("./CCComponent");
    var SwanSubContextView = void 0;
    var isBaiduGame = cc.sys.platform === cc.sys.BAIDU_GAME;
    true, SwanSubContextView = isBaiduGame ? cc.Class({
      name: "cc.SwanSubContextView",
      extends: Component,
      editor: false,
      properties: {
        _fps: 60,
        fps: {
          get: function get() {
            return this._fps;
          },
          set: function set(value) {
            if (this._fps === value) return;
            this._fps = value;
            this._updateInterval = 1 / value;
            this._updateSubContextFrameRate();
          },
          tooltip: false
        }
      },
      ctor: function ctor() {
        this._sprite = null;
        this._tex = new cc.Texture2D();
        this._context = null;
        this._updatedTime = performance.now();
        this._updateInterval = 0;
      },
      onLoad: function onLoad() {
        if (swan.getOpenDataContext) {
          this._updateInterval = 1e3 / this._fps;
          this._context = swan.getOpenDataContext();
          var sharedCanvas = this._context.canvas;
          if (sharedCanvas) {
            sharedCanvas.width = this.node.width;
            sharedCanvas.height = this.node.height;
          }
          this._tex.setPremultiplyAlpha(true);
          this._tex.initWithElement(sharedCanvas);
          this._sprite = this.node.getComponent(cc.Sprite);
          if (!this._sprite) {
            this._sprite = this.node.addComponent(cc.Sprite);
            this._sprite.srcBlendFactor = cc.macro.BlendFactor.ONE;
          }
          this._sprite.spriteFrame = new cc.SpriteFrame(this._tex);
        } else this.enabled = false;
      },
      onEnable: function onEnable() {
        this._runSubContextMainLoop();
        this._registerNodeEvent();
        this._updateSubContextFrameRate();
        this.updateSubContextViewport();
      },
      onDisable: function onDisable() {
        this._unregisterNodeEvent();
        this._stopSubContextMainLoop();
      },
      update: function update(dt) {
        var calledUpdateMannually = void 0 === dt;
        if (calledUpdateMannually) {
          this._context && this._context.postMessage({
            fromEngine: true,
            event: "step"
          });
          this._updateSubContextTexture();
          return;
        }
        var now = performance.now();
        var deltaTime = now - this._updatedTime;
        if (deltaTime >= this._updateInterval) {
          this._updatedTime += this._updateInterval;
          this._updateSubContextTexture();
        }
      },
      _updateSubContextTexture: function _updateSubContextTexture() {
        if (!this._tex || !this._context) return;
        this._tex.initWithElement(this._context.canvas);
        this._sprite._activateMaterial();
      },
      updateSubContextViewport: function updateSubContextViewport() {
        if (this._context) {
          var box = this.node.getBoundingBoxToWorld();
          var sx = cc.view._scaleX;
          var sy = cc.view._scaleY;
          this._context.postMessage({
            fromEngine: true,
            event: "viewport",
            x: box.x * sx + cc.view._viewportRect.x,
            y: box.y * sy + cc.view._viewportRect.y,
            width: box.width * sx,
            height: box.height * sy
          });
        }
      },
      _registerNodeEvent: function _registerNodeEvent() {
        this.node.on("position-changed", this.updateSubContextViewport, this);
        this.node.on("scale-changed", this.updateSubContextViewport, this);
        this.node.on("size-changed", this.updateSubContextViewport, this);
      },
      _unregisterNodeEvent: function _unregisterNodeEvent() {
        this.node.off("position-changed", this.updateSubContextViewport, this);
        this.node.off("scale-changed", this.updateSubContextViewport, this);
        this.node.off("size-changed", this.updateSubContextViewport, this);
      },
      _runSubContextMainLoop: function _runSubContextMainLoop() {
        this._context && this._context.postMessage({
          fromEngine: true,
          event: "mainLoop",
          value: true
        });
      },
      _stopSubContextMainLoop: function _stopSubContextMainLoop() {
        this._context && this._context.postMessage({
          fromEngine: true,
          event: "mainLoop",
          value: false
        });
      },
      _updateSubContextFrameRate: function _updateSubContextFrameRate() {
        this._context && this._context.postMessage({
          fromEngine: true,
          event: "frameRate",
          value: this._fps
        });
      }
    }) : cc.Class({
      name: "cc.SwanSubContextView",
      extends: Component
    });
    cc.SwanSubContextView = module.exports = SwanSubContextView;
  }), {
    "./CCComponent": 62
  } ],
  77: [ (function(require, module, exports) {
    "use strict";
    var Component = require("./CCComponent");
    var WXSubContextView = void 0;
    true, false;
    WXSubContextView = cc.Class({
      name: "cc.WXSubContextView",
      extends: Component,
      editor: false,
      properties: {
        _fps: 60,
        fps: {
          get: function get() {
            return this._fps;
          },
          set: function set(value) {
            if (this._fps === value) return;
            this._fps = value;
            this._updateInterval = 1 / value;
            this._updateSubContextFrameRate();
          },
          tooltip: false
        }
      },
      ctor: function ctor() {
        this._sprite = null;
        this._tex = new cc.Texture2D();
        this._context = null;
        this._updatedTime = performance.now();
        this._updateInterval = 0;
      },
      onLoad: function onLoad() {
        if (wx.getOpenDataContext) {
          this._updateInterval = 1e3 / this._fps;
          this._context = wx.getOpenDataContext();
          this.reset();
          this._tex.setPremultiplyAlpha(true);
          this._tex.initWithElement(sharedCanvas);
          this._sprite = this.node.getComponent(cc.Sprite);
          if (!this._sprite) {
            this._sprite = this.node.addComponent(cc.Sprite);
            this._sprite.srcBlendFactor = cc.macro.BlendFactor.ONE;
          }
          this._sprite.spriteFrame = new cc.SpriteFrame(this._tex);
        } else this.enabled = false;
      },
      reset: function reset() {
        if (this._context) {
          this.updateSubContextViewport();
          var _sharedCanvas = this._context.canvas;
          if (_sharedCanvas) {
            _sharedCanvas.width = this.node.width;
            _sharedCanvas.height = this.node.height;
          }
        }
      },
      onEnable: function onEnable() {
        this._runSubContextMainLoop();
        this._registerNodeEvent();
        this._updateSubContextFrameRate();
        this.updateSubContextViewport();
      },
      onDisable: function onDisable() {
        this._unregisterNodeEvent();
        this._stopSubContextMainLoop();
      },
      update: function update(dt) {
        var calledUpdateMannually = void 0 === dt;
        if (calledUpdateMannually) {
          this._context && this._context.postMessage({
            fromEngine: true,
            event: "step"
          });
          this._updateSubContextTexture();
          return;
        }
        var now = performance.now();
        var deltaTime = now - this._updatedTime;
        if (deltaTime >= this._updateInterval) {
          this._updatedTime += this._updateInterval;
          this._updateSubContextTexture();
        }
      },
      _updateSubContextTexture: function _updateSubContextTexture() {
        if (!this._tex || !this._context) return;
        this._tex.initWithElement(this._context.canvas);
        this._sprite._activateMaterial();
      },
      updateSubContextViewport: function updateSubContextViewport() {
        if (this._context) {
          var box = this.node.getBoundingBoxToWorld();
          var sx = cc.view._scaleX;
          var sy = cc.view._scaleY;
          this._context.postMessage({
            fromEngine: true,
            event: "viewport",
            x: box.x * sx + cc.view._viewportRect.x,
            y: box.y * sy + cc.view._viewportRect.y,
            width: box.width * sx,
            height: box.height * sy
          });
        }
      },
      _registerNodeEvent: function _registerNodeEvent() {
        this.node.on("position-changed", this.updateSubContextViewport, this);
        this.node.on("scale-changed", this.updateSubContextViewport, this);
        this.node.on("size-changed", this.updateSubContextViewport, this);
      },
      _unregisterNodeEvent: function _unregisterNodeEvent() {
        this.node.off("position-changed", this.updateSubContextViewport, this);
        this.node.off("scale-changed", this.updateSubContextViewport, this);
        this.node.off("size-changed", this.updateSubContextViewport, this);
      },
      _runSubContextMainLoop: function _runSubContextMainLoop() {
        this._context && this._context.postMessage({
          fromEngine: true,
          event: "mainLoop",
          value: true
        });
      },
      _stopSubContextMainLoop: function _stopSubContextMainLoop() {
        this._context && this._context.postMessage({
          fromEngine: true,
          event: "mainLoop",
          value: false
        });
      },
      _updateSubContextFrameRate: function _updateSubContextFrameRate() {
        this._context && this._context.postMessage({
          fromEngine: true,
          event: "frameRate",
          value: this._fps
        });
      }
    });
    cc.WXSubContextView = module.exports = WXSubContextView;
  }), {
    "./CCComponent": 62
  } ],
  78: [ (function(require, module, exports) {
    "use strict";
    require("./CCComponent");
    require("./CCComponentEventHandler");
    require("./missing-script");
    var components = [ require("./CCSprite"), require("./CCWidget"), require("./CCCanvas"), require("./CCAudioSource"), require("./CCAnimation"), require("./CCButton"), require("./CCLabel"), require("./CCProgressBar"), require("./CCMask"), require("./CCScrollBar"), require("./CCScrollView"), require("./CCPageViewIndicator"), require("./CCPageView"), require("./CCSlider"), require("./CCLayout"), require("./editbox/CCEditBox"), require("./CCLabelOutline"), require("./CCLabelShadow"), require("./CCRichText"), require("./CCToggleContainer"), require("./CCToggleGroup"), require("./CCToggle"), require("./CCBlockInputEvents"), require("./CCMotionStreak"), require("./WXSubContextView"), require("./SwanSubContextView") ];
    module.exports = components;
  }), {
    "./CCAnimation": 58,
    "./CCAudioSource": void 0,
    "./CCBlockInputEvents": 59,
    "./CCButton": 60,
    "./CCCanvas": 61,
    "./CCComponent": 62,
    "./CCComponentEventHandler": 63,
    "./CCLabel": 64,
    "./CCLabelOutline": 65,
    "./CCLabelShadow": 66,
    "./CCLayout": 67,
    "./CCMask": 68,
    "./CCMotionStreak": 69,
    "./CCPageView": void 0,
    "./CCPageViewIndicator": void 0,
    "./CCProgressBar": void 0,
    "./CCRichText": 71,
    "./CCScrollBar": void 0,
    "./CCScrollView": void 0,
    "./CCSlider": 72,
    "./CCSprite": 73,
    "./CCToggle": void 0,
    "./CCToggleContainer": void 0,
    "./CCToggleGroup": void 0,
    "./CCWidget": 75,
    "./SwanSubContextView": 76,
    "./WXSubContextView": 77,
    "./editbox/CCEditBox": void 0,
    "./missing-script": 79
  } ],
  79: [ (function(require, module, exports) {
    "use strict";
    var js = cc.js;
    var BUILTIN_CLASSID_RE = require("../utils/misc").BUILTIN_CLASSID_RE;
    var MissingClass = cc.Class({
      name: "cc.MissingClass",
      properties: {
        _$erialized: {
          default: null,
          visible: false,
          editorOnly: true
        }
      }
    });
    var MissingScript = cc.Class({
      name: "cc.MissingScript",
      extends: cc.Component,
      editor: {
        inspector: "packages://inspector/inspectors/comps/missing-script.js"
      },
      properties: {
        compiled: {
          default: false,
          serializable: false
        },
        _$erialized: {
          default: null,
          visible: false,
          editorOnly: true
        }
      },
      ctor: false,
      statics: {
        safeFindClass: function safeFindClass(id, data) {
          var cls = js._getClassById(id);
          if (cls) return cls;
          if (id) {
            cc.deserialize.reportMissingClass(id);
            return MissingScript.getMissingWrapper(id, data);
          }
          return null;
        },
        getMissingWrapper: function getMissingWrapper(id, data) {
          return data.node && (/^[0-9a-zA-Z+/]{23}$/.test(id) || BUILTIN_CLASSID_RE.test(id)) ? MissingScript : MissingClass;
        }
      },
      onLoad: function onLoad() {
        cc.warnID(4600, this.node.name);
      }
    });
    cc._MissingScript = module.exports = MissingScript;
  }), {
    "../utils/misc": 204
  } ],
  80: [ (function(require, module, exports) {
    "use strict";
    var js = cc.js;
    require("../event/event");
    var EventMouse = function EventMouse(eventType, bubbles) {
      cc.Event.call(this, cc.Event.MOUSE, bubbles);
      this._eventType = eventType;
      this._button = 0;
      this._x = 0;
      this._y = 0;
      this._prevX = 0;
      this._prevY = 0;
      this._scrollX = 0;
      this._scrollY = 0;
    };
    js.extend(EventMouse, cc.Event);
    var proto = EventMouse.prototype;
    proto.setScrollData = function(scrollX, scrollY) {
      this._scrollX = scrollX;
      this._scrollY = scrollY;
    };
    proto.getScrollX = function() {
      return this._scrollX;
    };
    proto.getScrollY = function() {
      return this._scrollY;
    };
    proto.setLocation = function(x, y) {
      this._x = x;
      this._y = y;
    };
    proto.getLocation = function() {
      return cc.v2(this._x, this._y);
    };
    proto.getLocationInView = function() {
      return cc.v2(this._x, cc.view._designResolutionSize.height - this._y);
    };
    proto._setPrevCursor = function(x, y) {
      this._prevX = x;
      this._prevY = y;
    };
    proto.getPreviousLocation = function() {
      return cc.v2(this._prevX, this._prevY);
    };
    proto.getDelta = function() {
      return cc.v2(this._x - this._prevX, this._y - this._prevY);
    };
    proto.getDeltaX = function() {
      return this._x - this._prevX;
    };
    proto.getDeltaY = function() {
      return this._y - this._prevY;
    };
    proto.setButton = function(button) {
      this._button = button;
    };
    proto.getButton = function() {
      return this._button;
    };
    proto.getLocationX = function() {
      return this._x;
    };
    proto.getLocationY = function() {
      return this._y;
    };
    EventMouse.NONE = 0;
    EventMouse.DOWN = 1;
    EventMouse.UP = 2;
    EventMouse.MOVE = 3;
    EventMouse.SCROLL = 4;
    EventMouse.BUTTON_LEFT = 0;
    EventMouse.BUTTON_RIGHT = 2;
    EventMouse.BUTTON_MIDDLE = 1;
    EventMouse.BUTTON_4 = 3;
    EventMouse.BUTTON_5 = 4;
    EventMouse.BUTTON_6 = 5;
    EventMouse.BUTTON_7 = 6;
    EventMouse.BUTTON_8 = 7;
    var EventTouch = function EventTouch(touchArr, bubbles) {
      cc.Event.call(this, cc.Event.TOUCH, bubbles);
      this._eventCode = 0;
      this._touches = touchArr || [];
      this.touch = null;
      this.currentTouch = null;
    };
    js.extend(EventTouch, cc.Event);
    proto = EventTouch.prototype;
    proto.getEventCode = function() {
      return this._eventCode;
    };
    proto.getTouches = function() {
      return this._touches;
    };
    proto._setEventCode = function(eventCode) {
      this._eventCode = eventCode;
    };
    proto._setTouches = function(touches) {
      this._touches = touches;
    };
    proto.setLocation = function(x, y) {
      this.touch && this.touch.setTouchInfo(this.touch.getID(), x, y);
    };
    proto.getLocation = function() {
      return this.touch ? this.touch.getLocation() : cc.v2();
    };
    proto.getLocationInView = function() {
      return this.touch ? this.touch.getLocationInView() : cc.v2();
    };
    proto.getPreviousLocation = function() {
      return this.touch ? this.touch.getPreviousLocation() : cc.v2();
    };
    proto.getStartLocation = function() {
      return this.touch ? this.touch.getStartLocation() : cc.v2();
    };
    proto.getID = function() {
      return this.touch ? this.touch.getID() : null;
    };
    proto.getDelta = function() {
      return this.touch ? this.touch.getDelta() : cc.v2();
    };
    proto.getDeltaX = function() {
      return this.touch ? this.touch.getDelta().x : 0;
    };
    proto.getDeltaY = function() {
      return this.touch ? this.touch.getDelta().y : 0;
    };
    proto.getLocationX = function() {
      return this.touch ? this.touch.getLocationX() : 0;
    };
    proto.getLocationY = function() {
      return this.touch ? this.touch.getLocationY() : 0;
    };
    EventTouch.MAX_TOUCHES = 5;
    EventTouch.BEGAN = 0;
    EventTouch.MOVED = 1;
    EventTouch.ENDED = 2;
    EventTouch.CANCELED = 3;
    var EventAcceleration = function EventAcceleration(acc, bubbles) {
      cc.Event.call(this, cc.Event.ACCELERATION, bubbles);
      this.acc = acc;
    };
    js.extend(EventAcceleration, cc.Event);
    var EventKeyboard = function EventKeyboard(keyCode, isPressed, bubbles) {
      cc.Event.call(this, cc.Event.KEYBOARD, bubbles);
      this.keyCode = keyCode;
      this.isPressed = isPressed;
    };
    js.extend(EventKeyboard, cc.Event);
    cc.Event.EventMouse = EventMouse;
    cc.Event.EventTouch = EventTouch;
    cc.Event.EventAcceleration = EventAcceleration;
    cc.Event.EventKeyboard = EventKeyboard;
    module.exports = cc.Event;
  }), {
    "../event/event": 87
  } ],
  81: [ (function(require, module, exports) {
    "use strict";
    var js = require("../platform/js");
    cc.EventListener = function(type, listenerID, callback) {
      this._onEvent = callback;
      this._type = type || 0;
      this._listenerID = listenerID || "";
      this._registered = false;
      this._fixedPriority = 0;
      this._node = null;
      this._target = null;
      this._paused = true;
      this._isEnabled = true;
    };
    cc.EventListener.prototype = {
      constructor: cc.EventListener,
      _setPaused: function _setPaused(paused) {
        this._paused = paused;
      },
      _isPaused: function _isPaused() {
        return this._paused;
      },
      _setRegistered: function _setRegistered(registered) {
        this._registered = registered;
      },
      _isRegistered: function _isRegistered() {
        return this._registered;
      },
      _getType: function _getType() {
        return this._type;
      },
      _getListenerID: function _getListenerID() {
        return this._listenerID;
      },
      _setFixedPriority: function _setFixedPriority(fixedPriority) {
        this._fixedPriority = fixedPriority;
      },
      _getFixedPriority: function _getFixedPriority() {
        return this._fixedPriority;
      },
      _setSceneGraphPriority: function _setSceneGraphPriority(node) {
        this._target = node;
        this._node = node;
      },
      _getSceneGraphPriority: function _getSceneGraphPriority() {
        return this._node;
      },
      checkAvailable: function checkAvailable() {
        return null !== this._onEvent;
      },
      clone: function clone() {
        return null;
      },
      setEnabled: function setEnabled(enabled) {
        this._isEnabled = enabled;
      },
      isEnabled: function isEnabled() {
        return this._isEnabled;
      },
      retain: function retain() {},
      release: function release() {}
    };
    cc.EventListener.UNKNOWN = 0;
    cc.EventListener.TOUCH_ONE_BY_ONE = 1;
    cc.EventListener.TOUCH_ALL_AT_ONCE = 2;
    cc.EventListener.KEYBOARD = 3;
    cc.EventListener.MOUSE = 4;
    cc.EventListener.ACCELERATION = 6;
    cc.EventListener.CUSTOM = 8;
    var ListenerID = cc.EventListener.ListenerID = {
      MOUSE: "__cc_mouse",
      TOUCH_ONE_BY_ONE: "__cc_touch_one_by_one",
      TOUCH_ALL_AT_ONCE: "__cc_touch_all_at_once",
      KEYBOARD: "__cc_keyboard",
      ACCELERATION: "__cc_acceleration"
    };
    var Custom = function Custom(listenerId, callback) {
      this._onCustomEvent = callback;
      cc.EventListener.call(this, cc.EventListener.CUSTOM, listenerId, this._callback);
    };
    js.extend(Custom, cc.EventListener);
    js.mixin(Custom.prototype, {
      _onCustomEvent: null,
      _callback: function _callback(event) {
        null !== this._onCustomEvent && this._onCustomEvent(event);
      },
      checkAvailable: function checkAvailable() {
        return cc.EventListener.prototype.checkAvailable.call(this) && null !== this._onCustomEvent;
      },
      clone: function clone() {
        return new Custom(this._listenerID, this._onCustomEvent);
      }
    });
    var Mouse = function Mouse() {
      cc.EventListener.call(this, cc.EventListener.MOUSE, ListenerID.MOUSE, this._callback);
    };
    js.extend(Mouse, cc.EventListener);
    js.mixin(Mouse.prototype, {
      onMouseDown: null,
      onMouseUp: null,
      onMouseMove: null,
      onMouseScroll: null,
      _callback: function _callback(event) {
        var eventType = cc.Event.EventMouse;
        switch (event._eventType) {
         case eventType.DOWN:
          this.onMouseDown && this.onMouseDown(event);
          break;

         case eventType.UP:
          this.onMouseUp && this.onMouseUp(event);
          break;

         case eventType.MOVE:
          this.onMouseMove && this.onMouseMove(event);
          break;

         case eventType.SCROLL:
          this.onMouseScroll && this.onMouseScroll(event);
        }
      },
      clone: function clone() {
        var eventListener = new Mouse();
        eventListener.onMouseDown = this.onMouseDown;
        eventListener.onMouseUp = this.onMouseUp;
        eventListener.onMouseMove = this.onMouseMove;
        eventListener.onMouseScroll = this.onMouseScroll;
        return eventListener;
      },
      checkAvailable: function checkAvailable() {
        return true;
      }
    });
    var TouchOneByOne = function TouchOneByOne() {
      cc.EventListener.call(this, cc.EventListener.TOUCH_ONE_BY_ONE, ListenerID.TOUCH_ONE_BY_ONE, null);
      this._claimedTouches = [];
    };
    js.extend(TouchOneByOne, cc.EventListener);
    js.mixin(TouchOneByOne.prototype, {
      constructor: TouchOneByOne,
      _claimedTouches: null,
      swallowTouches: false,
      onTouchBegan: null,
      onTouchMoved: null,
      onTouchEnded: null,
      onTouchCancelled: null,
      setSwallowTouches: function setSwallowTouches(needSwallow) {
        this.swallowTouches = needSwallow;
      },
      isSwallowTouches: function isSwallowTouches() {
        return this.swallowTouches;
      },
      clone: function clone() {
        var eventListener = new TouchOneByOne();
        eventListener.onTouchBegan = this.onTouchBegan;
        eventListener.onTouchMoved = this.onTouchMoved;
        eventListener.onTouchEnded = this.onTouchEnded;
        eventListener.onTouchCancelled = this.onTouchCancelled;
        eventListener.swallowTouches = this.swallowTouches;
        return eventListener;
      },
      checkAvailable: function checkAvailable() {
        if (!this.onTouchBegan) {
          cc.logID(1801);
          return false;
        }
        return true;
      }
    });
    var TouchAllAtOnce = function TouchAllAtOnce() {
      cc.EventListener.call(this, cc.EventListener.TOUCH_ALL_AT_ONCE, ListenerID.TOUCH_ALL_AT_ONCE, null);
    };
    js.extend(TouchAllAtOnce, cc.EventListener);
    js.mixin(TouchAllAtOnce.prototype, {
      constructor: TouchAllAtOnce,
      onTouchesBegan: null,
      onTouchesMoved: null,
      onTouchesEnded: null,
      onTouchesCancelled: null,
      clone: function clone() {
        var eventListener = new TouchAllAtOnce();
        eventListener.onTouchesBegan = this.onTouchesBegan;
        eventListener.onTouchesMoved = this.onTouchesMoved;
        eventListener.onTouchesEnded = this.onTouchesEnded;
        eventListener.onTouchesCancelled = this.onTouchesCancelled;
        return eventListener;
      },
      checkAvailable: function checkAvailable() {
        if (null === this.onTouchesBegan && null === this.onTouchesMoved && null === this.onTouchesEnded && null === this.onTouchesCancelled) {
          cc.logID(1802);
          return false;
        }
        return true;
      }
    });
    var Acceleration = function Acceleration(callback) {
      this._onAccelerationEvent = callback;
      cc.EventListener.call(this, cc.EventListener.ACCELERATION, ListenerID.ACCELERATION, this._callback);
    };
    js.extend(Acceleration, cc.EventListener);
    js.mixin(Acceleration.prototype, {
      constructor: Acceleration,
      _onAccelerationEvent: null,
      _callback: function _callback(event) {
        this._onAccelerationEvent(event.acc, event);
      },
      checkAvailable: function checkAvailable() {
        cc.assertID(this._onAccelerationEvent, 1803);
        return true;
      },
      clone: function clone() {
        return new Acceleration(this._onAccelerationEvent);
      }
    });
    var Keyboard = function Keyboard() {
      cc.EventListener.call(this, cc.EventListener.KEYBOARD, ListenerID.KEYBOARD, this._callback);
    };
    js.extend(Keyboard, cc.EventListener);
    js.mixin(Keyboard.prototype, {
      constructor: Keyboard,
      onKeyPressed: null,
      onKeyReleased: null,
      _callback: function _callback(event) {
        event.isPressed ? this.onKeyPressed && this.onKeyPressed(event.keyCode, event) : this.onKeyReleased && this.onKeyReleased(event.keyCode, event);
      },
      clone: function clone() {
        var eventListener = new Keyboard();
        eventListener.onKeyPressed = this.onKeyPressed;
        eventListener.onKeyReleased = this.onKeyReleased;
        return eventListener;
      },
      checkAvailable: function checkAvailable() {
        if (null === this.onKeyPressed && null === this.onKeyReleased) {
          cc.logID(1800);
          return false;
        }
        return true;
      }
    });
    cc.EventListener.create = function(argObj) {
      cc.assertID(argObj && argObj.event, 1900);
      var listenerType = argObj.event;
      delete argObj.event;
      var listener = null;
      if (listenerType === cc.EventListener.TOUCH_ONE_BY_ONE) listener = new TouchOneByOne(); else if (listenerType === cc.EventListener.TOUCH_ALL_AT_ONCE) listener = new TouchAllAtOnce(); else if (listenerType === cc.EventListener.MOUSE) listener = new Mouse(); else if (listenerType === cc.EventListener.CUSTOM) {
        listener = new Custom(argObj.eventName, argObj.callback);
        delete argObj.eventName;
        delete argObj.callback;
      } else if (listenerType === cc.EventListener.KEYBOARD) listener = new Keyboard(); else if (listenerType === cc.EventListener.ACCELERATION) {
        listener = new Acceleration(argObj.callback);
        delete argObj.callback;
      }
      for (var key in argObj) listener[key] = argObj[key];
      return listener;
    };
    module.exports = cc.EventListener;
  }), {
    "../platform/js": 138
  } ],
  82: [ (function(require, module, exports) {
    "use strict";
    var js = require("../platform/js");
    require("./CCEventListener");
    var ListenerID = cc.EventListener.ListenerID;
    var _EventListenerVector = function _EventListenerVector() {
      this._fixedListeners = [];
      this._sceneGraphListeners = [];
      this.gt0Index = 0;
    };
    _EventListenerVector.prototype = {
      constructor: _EventListenerVector,
      size: function size() {
        return this._fixedListeners.length + this._sceneGraphListeners.length;
      },
      empty: function empty() {
        return 0 === this._fixedListeners.length && 0 === this._sceneGraphListeners.length;
      },
      push: function push(listener) {
        0 === listener._getFixedPriority() ? this._sceneGraphListeners.push(listener) : this._fixedListeners.push(listener);
      },
      clearSceneGraphListeners: function clearSceneGraphListeners() {
        this._sceneGraphListeners.length = 0;
      },
      clearFixedListeners: function clearFixedListeners() {
        this._fixedListeners.length = 0;
      },
      clear: function clear() {
        this._sceneGraphListeners.length = 0;
        this._fixedListeners.length = 0;
      },
      getFixedPriorityListeners: function getFixedPriorityListeners() {
        return this._fixedListeners;
      },
      getSceneGraphPriorityListeners: function getSceneGraphPriorityListeners() {
        return this._sceneGraphListeners;
      }
    };
    var __getListenerID = function __getListenerID(event) {
      var eventType = cc.Event, type = event.type;
      if (type === eventType.ACCELERATION) return ListenerID.ACCELERATION;
      if (type === eventType.KEYBOARD) return ListenerID.KEYBOARD;
      if (type.startsWith(eventType.MOUSE)) return ListenerID.MOUSE;
      type.startsWith(eventType.TOUCH) && cc.logID(2e3);
      return "";
    };
    var eventManager = {
      DIRTY_NONE: 0,
      DIRTY_FIXED_PRIORITY: 1,
      DIRTY_SCENE_GRAPH_PRIORITY: 2,
      DIRTY_ALL: 3,
      _listenersMap: {},
      _priorityDirtyFlagMap: {},
      _nodeListenersMap: {},
      _toAddedListeners: [],
      _toRemovedListeners: [],
      _dirtyListeners: {},
      _inDispatch: 0,
      _isEnabled: false,
      _internalCustomListenerIDs: [],
      _setDirtyForNode: function _setDirtyForNode(node) {
        var selListeners = this._nodeListenersMap[node._id];
        if (void 0 !== selListeners) for (var j = 0, len = selListeners.length; j < len; j++) {
          var selListener = selListeners[j];
          var listenerID = selListener._getListenerID();
          null == this._dirtyListeners[listenerID] && (this._dirtyListeners[listenerID] = true);
        }
        if (node.getChildren) {
          var _children = node.getChildren();
          for (var i = 0, len = _children ? _children.length : 0; i < len; i++) this._setDirtyForNode(_children[i]);
        }
      },
      pauseTarget: function pauseTarget(node, recursive) {
        if (!(node instanceof cc._BaseNode)) {
          cc.warnID(3506);
          return;
        }
        var listeners = this._nodeListenersMap[node._id], i, len;
        if (listeners) for (i = 0, len = listeners.length; i < len; i++) listeners[i]._setPaused(true);
        if (true === recursive) {
          var locChildren = node.getChildren();
          for (i = 0, len = locChildren ? locChildren.length : 0; i < len; i++) this.pauseTarget(locChildren[i], true);
        }
      },
      resumeTarget: function resumeTarget(node, recursive) {
        if (!(node instanceof cc._BaseNode)) {
          cc.warnID(3506);
          return;
        }
        var listeners = this._nodeListenersMap[node._id], i, len;
        if (listeners) for (i = 0, len = listeners.length; i < len; i++) listeners[i]._setPaused(false);
        this._setDirtyForNode(node);
        if (true === recursive && node.getChildren) {
          var locChildren = node.getChildren();
          for (i = 0, len = locChildren ? locChildren.length : 0; i < len; i++) this.resumeTarget(locChildren[i], true);
        }
      },
      _addListener: function _addListener(listener) {
        0 === this._inDispatch ? this._forceAddEventListener(listener) : this._toAddedListeners.push(listener);
      },
      _forceAddEventListener: function _forceAddEventListener(listener) {
        var listenerID = listener._getListenerID();
        var listeners = this._listenersMap[listenerID];
        if (!listeners) {
          listeners = new _EventListenerVector();
          this._listenersMap[listenerID] = listeners;
        }
        listeners.push(listener);
        if (0 === listener._getFixedPriority()) {
          this._setDirty(listenerID, this.DIRTY_SCENE_GRAPH_PRIORITY);
          var node = listener._getSceneGraphPriority();
          null === node && cc.logID(3507);
          this._associateNodeAndEventListener(node, listener);
          node.activeInHierarchy && this.resumeTarget(node);
        } else this._setDirty(listenerID, this.DIRTY_FIXED_PRIORITY);
      },
      _getListeners: function _getListeners(listenerID) {
        return this._listenersMap[listenerID];
      },
      _updateDirtyFlagForSceneGraph: function _updateDirtyFlagForSceneGraph() {
        var locDirtyListeners = this._dirtyListeners;
        for (var selKey in locDirtyListeners) this._setDirty(selKey, this.DIRTY_SCENE_GRAPH_PRIORITY);
        this._dirtyListeners = {};
      },
      _removeAllListenersInVector: function _removeAllListenersInVector(listenerVector) {
        if (!listenerVector) return;
        var selListener;
        for (var i = listenerVector.length - 1; i >= 0; i--) {
          selListener = listenerVector[i];
          selListener._setRegistered(false);
          if (null != selListener._getSceneGraphPriority()) {
            this._dissociateNodeAndEventListener(selListener._getSceneGraphPriority(), selListener);
            selListener._setSceneGraphPriority(null);
          }
          0 === this._inDispatch && cc.js.array.removeAt(listenerVector, i);
        }
      },
      _removeListenersForListenerID: function _removeListenersForListenerID(listenerID) {
        var listeners = this._listenersMap[listenerID], i;
        if (listeners) {
          var fixedPriorityListeners = listeners.getFixedPriorityListeners();
          var sceneGraphPriorityListeners = listeners.getSceneGraphPriorityListeners();
          this._removeAllListenersInVector(sceneGraphPriorityListeners);
          this._removeAllListenersInVector(fixedPriorityListeners);
          delete this._priorityDirtyFlagMap[listenerID];
          if (!this._inDispatch) {
            listeners.clear();
            delete this._listenersMap[listenerID];
          }
        }
        var locToAddedListeners = this._toAddedListeners, listener;
        for (i = locToAddedListeners.length - 1; i >= 0; i--) {
          listener = locToAddedListeners[i];
          listener && listener._getListenerID() === listenerID && cc.js.array.removeAt(locToAddedListeners, i);
        }
      },
      _sortEventListeners: function _sortEventListeners(listenerID) {
        var dirtyFlag = this.DIRTY_NONE, locFlagMap = this._priorityDirtyFlagMap;
        locFlagMap[listenerID] && (dirtyFlag = locFlagMap[listenerID]);
        if (dirtyFlag !== this.DIRTY_NONE) {
          locFlagMap[listenerID] = this.DIRTY_NONE;
          dirtyFlag & this.DIRTY_FIXED_PRIORITY && this._sortListenersOfFixedPriority(listenerID);
          if (dirtyFlag & this.DIRTY_SCENE_GRAPH_PRIORITY) {
            var rootEntity = cc.director.getScene();
            rootEntity && this._sortListenersOfSceneGraphPriority(listenerID);
          }
        }
      },
      _sortListenersOfSceneGraphPriority: function _sortListenersOfSceneGraphPriority(listenerID) {
        var listeners = this._getListeners(listenerID);
        if (!listeners) return;
        var sceneGraphListener = listeners.getSceneGraphPriorityListeners();
        if (!sceneGraphListener || 0 === sceneGraphListener.length) return;
        listeners.getSceneGraphPriorityListeners().sort(this._sortEventListenersOfSceneGraphPriorityDes);
      },
      _sortEventListenersOfSceneGraphPriorityDes: function _sortEventListenersOfSceneGraphPriorityDes(l1, l2) {
        var node1 = l1._getSceneGraphPriority(), node2 = l2._getSceneGraphPriority();
        if (!(l2 && node2 && node2._activeInHierarchy && null !== node2._parent)) return -1;
        if (!l1 || !node1 || !node1._activeInHierarchy || null === node1._parent) return 1;
        var p1 = node1, p2 = node2, ex = false;
        while (p1._parent._id !== p2._parent._id) {
          p1 = null === p1._parent._parent ? (ex = true) && node2 : p1._parent;
          p2 = null === p2._parent._parent ? (ex = true) && node1 : p2._parent;
        }
        if (p1._id === p2._id) {
          if (p1._id === node2._id) return -1;
          if (p1._id === node1._id) return 1;
        }
        return ex ? p1._localZOrder - p2._localZOrder : p2._localZOrder - p1._localZOrder;
      },
      _sortListenersOfFixedPriority: function _sortListenersOfFixedPriority(listenerID) {
        var listeners = this._listenersMap[listenerID];
        if (!listeners) return;
        var fixedListeners = listeners.getFixedPriorityListeners();
        if (!fixedListeners || 0 === fixedListeners.length) return;
        fixedListeners.sort(this._sortListenersOfFixedPriorityAsc);
        var index = 0;
        for (var len = fixedListeners.length; index < len; ) {
          if (fixedListeners[index]._getFixedPriority() >= 0) break;
          ++index;
        }
        listeners.gt0Index = index;
      },
      _sortListenersOfFixedPriorityAsc: function _sortListenersOfFixedPriorityAsc(l1, l2) {
        return l1._getFixedPriority() - l2._getFixedPriority();
      },
      _onUpdateListeners: function _onUpdateListeners(listeners) {
        var fixedPriorityListeners = listeners.getFixedPriorityListeners();
        var sceneGraphPriorityListeners = listeners.getSceneGraphPriorityListeners();
        var i, selListener, idx, toRemovedListeners = this._toRemovedListeners;
        if (sceneGraphPriorityListeners) for (i = sceneGraphPriorityListeners.length - 1; i >= 0; i--) {
          selListener = sceneGraphPriorityListeners[i];
          if (!selListener._isRegistered()) {
            cc.js.array.removeAt(sceneGraphPriorityListeners, i);
            idx = toRemovedListeners.indexOf(selListener);
            -1 !== idx && toRemovedListeners.splice(idx, 1);
          }
        }
        if (fixedPriorityListeners) for (i = fixedPriorityListeners.length - 1; i >= 0; i--) {
          selListener = fixedPriorityListeners[i];
          if (!selListener._isRegistered()) {
            cc.js.array.removeAt(fixedPriorityListeners, i);
            idx = toRemovedListeners.indexOf(selListener);
            -1 !== idx && toRemovedListeners.splice(idx, 1);
          }
        }
        sceneGraphPriorityListeners && 0 === sceneGraphPriorityListeners.length && listeners.clearSceneGraphListeners();
        fixedPriorityListeners && 0 === fixedPriorityListeners.length && listeners.clearFixedListeners();
      },
      frameUpdateListeners: function frameUpdateListeners() {
        var locListenersMap = this._listenersMap, locPriorityDirtyFlagMap = this._priorityDirtyFlagMap;
        for (var selKey in locListenersMap) if (locListenersMap[selKey].empty()) {
          delete locPriorityDirtyFlagMap[selKey];
          delete locListenersMap[selKey];
        }
        var locToAddedListeners = this._toAddedListeners;
        if (0 !== locToAddedListeners.length) {
          for (var i = 0, len = locToAddedListeners.length; i < len; i++) this._forceAddEventListener(locToAddedListeners[i]);
          locToAddedListeners.length = 0;
        }
        0 !== this._toRemovedListeners.length && this._cleanToRemovedListeners();
      },
      _updateTouchListeners: function _updateTouchListeners(event) {
        var locInDispatch = this._inDispatch;
        cc.assertID(locInDispatch > 0, 3508);
        if (locInDispatch > 1) return;
        var listeners;
        listeners = this._listenersMap[ListenerID.TOUCH_ONE_BY_ONE];
        listeners && this._onUpdateListeners(listeners);
        listeners = this._listenersMap[ListenerID.TOUCH_ALL_AT_ONCE];
        listeners && this._onUpdateListeners(listeners);
        cc.assertID(1 === locInDispatch, 3509);
        var locToAddedListeners = this._toAddedListeners;
        if (0 !== locToAddedListeners.length) {
          for (var i = 0, len = locToAddedListeners.length; i < len; i++) this._forceAddEventListener(locToAddedListeners[i]);
          this._toAddedListeners.length = 0;
        }
        0 !== this._toRemovedListeners.length && this._cleanToRemovedListeners();
      },
      _cleanToRemovedListeners: function _cleanToRemovedListeners() {
        var toRemovedListeners = this._toRemovedListeners;
        for (var i = 0; i < toRemovedListeners.length; i++) {
          var selListener = toRemovedListeners[i];
          var listeners = this._listenersMap[selListener._getListenerID()];
          if (!listeners) continue;
          var idx, fixedPriorityListeners = listeners.getFixedPriorityListeners(), sceneGraphPriorityListeners = listeners.getSceneGraphPriorityListeners();
          if (sceneGraphPriorityListeners) {
            idx = sceneGraphPriorityListeners.indexOf(selListener);
            -1 !== idx && sceneGraphPriorityListeners.splice(idx, 1);
          }
          if (fixedPriorityListeners) {
            idx = fixedPriorityListeners.indexOf(selListener);
            -1 !== idx && fixedPriorityListeners.splice(idx, 1);
          }
        }
        toRemovedListeners.length = 0;
      },
      _onTouchEventCallback: function _onTouchEventCallback(listener, argsObj) {
        if (!listener._isRegistered()) return false;
        var event = argsObj.event, selTouch = event.currentTouch;
        event.currentTarget = listener._node;
        var isClaimed = false, removedIdx;
        var getCode = event.getEventCode(), EventTouch = cc.Event.EventTouch;
        if (getCode === EventTouch.BEGAN) {
          if (listener.onTouchBegan) {
            isClaimed = listener.onTouchBegan(selTouch, event);
            isClaimed && listener._registered && listener._claimedTouches.push(selTouch);
          }
        } else if (listener._claimedTouches.length > 0 && -1 !== (removedIdx = listener._claimedTouches.indexOf(selTouch))) {
          isClaimed = true;
          if (getCode === EventTouch.MOVED && listener.onTouchMoved) listener.onTouchMoved(selTouch, event); else if (getCode === EventTouch.ENDED) {
            listener.onTouchEnded && listener.onTouchEnded(selTouch, event);
            listener._registered && listener._claimedTouches.splice(removedIdx, 1);
          } else if (getCode === EventTouch.CANCELLED) {
            listener.onTouchCancelled && listener.onTouchCancelled(selTouch, event);
            listener._registered && listener._claimedTouches.splice(removedIdx, 1);
          }
        }
        if (event.isStopped()) {
          eventManager._updateTouchListeners(event);
          return true;
        }
        if (isClaimed && listener.swallowTouches) {
          argsObj.needsMutableSet && argsObj.touches.splice(selTouch, 1);
          return true;
        }
        return false;
      },
      _dispatchTouchEvent: function _dispatchTouchEvent(event) {
        this._sortEventListeners(ListenerID.TOUCH_ONE_BY_ONE);
        this._sortEventListeners(ListenerID.TOUCH_ALL_AT_ONCE);
        var oneByOneListeners = this._getListeners(ListenerID.TOUCH_ONE_BY_ONE);
        var allAtOnceListeners = this._getListeners(ListenerID.TOUCH_ALL_AT_ONCE);
        if (null === oneByOneListeners && null === allAtOnceListeners) return;
        var originalTouches = event.getTouches(), mutableTouches = cc.js.array.copy(originalTouches);
        var oneByOneArgsObj = {
          event: event,
          needsMutableSet: oneByOneListeners && allAtOnceListeners,
          touches: mutableTouches,
          selTouch: null
        };
        if (oneByOneListeners) for (var i = 0; i < originalTouches.length; i++) {
          event.currentTouch = originalTouches[i];
          event._propagationStopped = event._propagationImmediateStopped = false;
          this._dispatchEventToListeners(oneByOneListeners, this._onTouchEventCallback, oneByOneArgsObj);
        }
        if (allAtOnceListeners && mutableTouches.length > 0) {
          this._dispatchEventToListeners(allAtOnceListeners, this._onTouchesEventCallback, {
            event: event,
            touches: mutableTouches
          });
          if (event.isStopped()) return;
        }
        this._updateTouchListeners(event);
      },
      _onTouchesEventCallback: function _onTouchesEventCallback(listener, callbackParams) {
        if (!listener._registered) return false;
        var EventTouch = cc.Event.EventTouch, event = callbackParams.event, touches = callbackParams.touches, getCode = event.getEventCode();
        event.currentTarget = listener._node;
        getCode === EventTouch.BEGAN && listener.onTouchesBegan ? listener.onTouchesBegan(touches, event) : getCode === EventTouch.MOVED && listener.onTouchesMoved ? listener.onTouchesMoved(touches, event) : getCode === EventTouch.ENDED && listener.onTouchesEnded ? listener.onTouchesEnded(touches, event) : getCode === EventTouch.CANCELLED && listener.onTouchesCancelled && listener.onTouchesCancelled(touches, event);
        if (event.isStopped()) {
          eventManager._updateTouchListeners(event);
          return true;
        }
        return false;
      },
      _associateNodeAndEventListener: function _associateNodeAndEventListener(node, listener) {
        var listeners = this._nodeListenersMap[node._id];
        if (!listeners) {
          listeners = [];
          this._nodeListenersMap[node._id] = listeners;
        }
        listeners.push(listener);
      },
      _dissociateNodeAndEventListener: function _dissociateNodeAndEventListener(node, listener) {
        var listeners = this._nodeListenersMap[node._id];
        if (listeners) {
          cc.js.array.remove(listeners, listener);
          0 === listeners.length && delete this._nodeListenersMap[node._id];
        }
      },
      _dispatchEventToListeners: function _dispatchEventToListeners(listeners, onEvent, eventOrArgs) {
        var shouldStopPropagation = false;
        var fixedPriorityListeners = listeners.getFixedPriorityListeners();
        var sceneGraphPriorityListeners = listeners.getSceneGraphPriorityListeners();
        var i = 0, j, selListener;
        if (fixedPriorityListeners && 0 !== fixedPriorityListeners.length) for (;i < listeners.gt0Index; ++i) {
          selListener = fixedPriorityListeners[i];
          if (selListener.isEnabled() && !selListener._isPaused() && selListener._isRegistered() && onEvent(selListener, eventOrArgs)) {
            shouldStopPropagation = true;
            break;
          }
        }
        if (sceneGraphPriorityListeners && !shouldStopPropagation) for (j = 0; j < sceneGraphPriorityListeners.length; j++) {
          selListener = sceneGraphPriorityListeners[j];
          if (selListener.isEnabled() && !selListener._isPaused() && selListener._isRegistered() && onEvent(selListener, eventOrArgs)) {
            shouldStopPropagation = true;
            break;
          }
        }
        if (fixedPriorityListeners && !shouldStopPropagation) for (;i < fixedPriorityListeners.length; ++i) {
          selListener = fixedPriorityListeners[i];
          if (selListener.isEnabled() && !selListener._isPaused() && selListener._isRegistered() && onEvent(selListener, eventOrArgs)) {
            shouldStopPropagation = true;
            break;
          }
        }
      },
      _setDirty: function _setDirty(listenerID, flag) {
        var locDirtyFlagMap = this._priorityDirtyFlagMap;
        null == locDirtyFlagMap[listenerID] ? locDirtyFlagMap[listenerID] = flag : locDirtyFlagMap[listenerID] = flag | locDirtyFlagMap[listenerID];
      },
      _sortNumberAsc: function _sortNumberAsc(a, b) {
        return a - b;
      },
      hasEventListener: function hasEventListener(listenerID) {
        return !!this._getListeners(listenerID);
      },
      addListener: function addListener(listener, nodeOrPriority) {
        cc.assertID(listener && nodeOrPriority, 3503);
        if (!(cc.js.isNumber(nodeOrPriority) || nodeOrPriority instanceof cc._BaseNode)) {
          cc.warnID(3506);
          return;
        }
        if (listener instanceof cc.EventListener) {
          if (listener._isRegistered()) {
            cc.logID(3505);
            return;
          }
        } else {
          cc.assertID(!cc.js.isNumber(nodeOrPriority), 3504);
          listener = cc.EventListener.create(listener);
        }
        if (!listener.checkAvailable()) return;
        if (cc.js.isNumber(nodeOrPriority)) {
          if (0 === nodeOrPriority) {
            cc.logID(3500);
            return;
          }
          listener._setSceneGraphPriority(null);
          listener._setFixedPriority(nodeOrPriority);
          listener._setRegistered(true);
          listener._setPaused(false);
          this._addListener(listener);
        } else {
          listener._setSceneGraphPriority(nodeOrPriority);
          listener._setFixedPriority(0);
          listener._setRegistered(true);
          this._addListener(listener);
        }
        return listener;
      },
      addCustomListener: function addCustomListener(eventName, callback) {
        var listener = new cc.EventListener.create({
          event: cc.EventListener.CUSTOM,
          eventName: eventName,
          callback: callback
        });
        this.addListener(listener, 1);
        return listener;
      },
      removeListener: function removeListener(listener) {
        if (null == listener) return;
        var isFound, locListener = this._listenersMap;
        for (var selKey in locListener) {
          var listeners = locListener[selKey];
          var fixedPriorityListeners = listeners.getFixedPriorityListeners(), sceneGraphPriorityListeners = listeners.getSceneGraphPriorityListeners();
          isFound = this._removeListenerInVector(sceneGraphPriorityListeners, listener);
          if (isFound) this._setDirty(listener._getListenerID(), this.DIRTY_SCENE_GRAPH_PRIORITY); else {
            isFound = this._removeListenerInVector(fixedPriorityListeners, listener);
            isFound && this._setDirty(listener._getListenerID(), this.DIRTY_FIXED_PRIORITY);
          }
          if (listeners.empty()) {
            delete this._priorityDirtyFlagMap[listener._getListenerID()];
            delete locListener[selKey];
          }
          if (isFound) break;
        }
        if (!isFound) {
          var locToAddedListeners = this._toAddedListeners;
          for (var i = locToAddedListeners.length - 1; i >= 0; i--) {
            var selListener = locToAddedListeners[i];
            if (selListener === listener) {
              cc.js.array.removeAt(locToAddedListeners, i);
              selListener._setRegistered(false);
              break;
            }
          }
        }
      },
      _removeListenerInCallback: function _removeListenerInCallback(listeners, callback) {
        if (null == listeners) return false;
        for (var i = listeners.length - 1; i >= 0; i--) {
          var selListener = listeners[i];
          if (selListener._onCustomEvent === callback || selListener._onEvent === callback) {
            selListener._setRegistered(false);
            if (null != selListener._getSceneGraphPriority()) {
              this._dissociateNodeAndEventListener(selListener._getSceneGraphPriority(), selListener);
              selListener._setSceneGraphPriority(null);
            }
            0 === this._inDispatch ? cc.js.array.removeAt(listeners, i) : this._toRemovedListeners.push(selListener);
            return true;
          }
        }
        return false;
      },
      _removeListenerInVector: function _removeListenerInVector(listeners, listener) {
        if (null == listeners) return false;
        for (var i = listeners.length - 1; i >= 0; i--) {
          var selListener = listeners[i];
          if (selListener === listener) {
            selListener._setRegistered(false);
            if (null != selListener._getSceneGraphPriority()) {
              this._dissociateNodeAndEventListener(selListener._getSceneGraphPriority(), selListener);
              selListener._setSceneGraphPriority(null);
            }
            0 === this._inDispatch ? cc.js.array.removeAt(listeners, i) : this._toRemovedListeners.push(selListener);
            return true;
          }
        }
        return false;
      },
      removeListeners: function removeListeners(listenerType, recursive) {
        var i, _t = this;
        if (!(cc.js.isNumber(listenerType) || listenerType instanceof cc._BaseNode)) {
          cc.warnID(3506);
          return;
        }
        if (void 0 !== listenerType._id) {
          var listeners = _t._nodeListenersMap[listenerType._id], i;
          if (listeners) {
            var listenersCopy = cc.js.array.copy(listeners);
            for (i = 0; i < listenersCopy.length; i++) _t.removeListener(listenersCopy[i]);
            delete _t._nodeListenersMap[listenerType._id];
          }
          var locToAddedListeners = _t._toAddedListeners;
          for (i = 0; i < locToAddedListeners.length; ) {
            var listener = locToAddedListeners[i];
            if (listener._getSceneGraphPriority() === listenerType) {
              listener._setSceneGraphPriority(null);
              listener._setRegistered(false);
              locToAddedListeners.splice(i, 1);
            } else ++i;
          }
          if (true === recursive) {
            var locChildren = listenerType.getChildren(), len;
            for (i = 0, len = locChildren.length; i < len; i++) _t.removeListeners(locChildren[i], true);
          }
        } else listenerType === cc.EventListener.TOUCH_ONE_BY_ONE ? _t._removeListenersForListenerID(ListenerID.TOUCH_ONE_BY_ONE) : listenerType === cc.EventListener.TOUCH_ALL_AT_ONCE ? _t._removeListenersForListenerID(ListenerID.TOUCH_ALL_AT_ONCE) : listenerType === cc.EventListener.MOUSE ? _t._removeListenersForListenerID(ListenerID.MOUSE) : listenerType === cc.EventListener.ACCELERATION ? _t._removeListenersForListenerID(ListenerID.ACCELERATION) : listenerType === cc.EventListener.KEYBOARD ? _t._removeListenersForListenerID(ListenerID.KEYBOARD) : cc.logID(3501);
      },
      removeCustomListeners: function removeCustomListeners(customEventName) {
        this._removeListenersForListenerID(customEventName);
      },
      removeAllListeners: function removeAllListeners() {
        var locListeners = this._listenersMap, locInternalCustomEventIDs = this._internalCustomListenerIDs;
        for (var selKey in locListeners) -1 === locInternalCustomEventIDs.indexOf(selKey) && this._removeListenersForListenerID(selKey);
      },
      setPriority: function setPriority(listener, fixedPriority) {
        if (null == listener) return;
        var locListeners = this._listenersMap;
        for (var selKey in locListeners) {
          var selListeners = locListeners[selKey];
          var fixedPriorityListeners = selListeners.getFixedPriorityListeners();
          if (fixedPriorityListeners) {
            var found = fixedPriorityListeners.indexOf(listener);
            if (-1 !== found) {
              null != listener._getSceneGraphPriority() && cc.logID(3502);
              if (listener._getFixedPriority() !== fixedPriority) {
                listener._setFixedPriority(fixedPriority);
                this._setDirty(listener._getListenerID(), this.DIRTY_FIXED_PRIORITY);
              }
              return;
            }
          }
        }
      },
      setEnabled: function setEnabled(enabled) {
        this._isEnabled = enabled;
      },
      isEnabled: function isEnabled() {
        return this._isEnabled;
      },
      dispatchEvent: function dispatchEvent(event) {
        if (!this._isEnabled) return;
        this._updateDirtyFlagForSceneGraph();
        this._inDispatch++;
        if (!event || !event.getType) {
          cc.errorID(3511);
          return;
        }
        if (event.getType().startsWith(cc.Event.TOUCH)) {
          this._dispatchTouchEvent(event);
          this._inDispatch--;
          return;
        }
        var listenerID = __getListenerID(event);
        this._sortEventListeners(listenerID);
        var selListeners = this._listenersMap[listenerID];
        if (null != selListeners) {
          this._dispatchEventToListeners(selListeners, this._onListenerCallback, event);
          this._onUpdateListeners(selListeners);
        }
        this._inDispatch--;
      },
      _onListenerCallback: function _onListenerCallback(listener, event) {
        event.currentTarget = listener._target;
        listener._onEvent(event);
        return event.isStopped();
      },
      dispatchCustomEvent: function dispatchCustomEvent(eventName, optionalUserData) {
        var ev = new cc.Event.EventCustom(eventName);
        ev.setUserData(optionalUserData);
        this.dispatchEvent(ev);
      }
    };
    js.get(cc, "eventManager", (function() {
      cc.warnID(1405, "cc.eventManager", "cc.EventTarget or cc.systemEvent");
      return eventManager;
    }));
    module.exports = eventManager;
  }), {
    "../platform/js": 138,
    "./CCEventListener": 81
  } ],
  83: [ (function(require, module, exports) {
    "use strict";
    cc.Touch = function(x, y, id) {
      this._lastModified = 0;
      this.setTouchInfo(id, x, y);
    };
    cc.Touch.prototype = {
      constructor: cc.Touch,
      getLocation: function getLocation() {
        return cc.v2(this._point.x, this._point.y);
      },
      getLocationX: function getLocationX() {
        return this._point.x;
      },
      getLocationY: function getLocationY() {
        return this._point.y;
      },
      getPreviousLocation: function getPreviousLocation() {
        return cc.v2(this._prevPoint.x, this._prevPoint.y);
      },
      getStartLocation: function getStartLocation() {
        return cc.v2(this._startPoint.x, this._startPoint.y);
      },
      getDelta: function getDelta() {
        return this._point.sub(this._prevPoint);
      },
      getLocationInView: function getLocationInView() {
        return cc.v2(this._point.x, cc.view._designResolutionSize.height - this._point.y);
      },
      getPreviousLocationInView: function getPreviousLocationInView() {
        return cc.v2(this._prevPoint.x, cc.view._designResolutionSize.height - this._prevPoint.y);
      },
      getStartLocationInView: function getStartLocationInView() {
        return cc.v2(this._startPoint.x, cc.view._designResolutionSize.height - this._startPoint.y);
      },
      getID: function getID() {
        return this._id;
      },
      setTouchInfo: function setTouchInfo(id, x, y) {
        this._prevPoint = this._point;
        this._point = cc.v2(x || 0, y || 0);
        this._id = id;
        if (!this._startPointCaptured) {
          this._startPoint = cc.v2(this._point);
          cc.view._convertPointWithScale(this._startPoint);
          this._startPointCaptured = true;
        }
      },
      _setPoint: function _setPoint(x, y) {
        if (void 0 === y) {
          this._point.x = x.x;
          this._point.y = x.y;
        } else {
          this._point.x = x;
          this._point.y = y;
        }
      },
      _setPrevPoint: function _setPrevPoint(x, y) {
        this._prevPoint = void 0 === y ? cc.v2(x.x, x.y) : cc.v2(x || 0, y || 0);
      }
    };
  }), {} ],
  84: [ (function(require, module, exports) {
    "use strict";
    require("./CCEvent");
    require("./CCTouch");
    require("./CCEventListener");
    var eventManager = require("./CCEventManager");
    module.exports = eventManager;
    false;
  }), {
    "./CCEvent": 80,
    "./CCEventListener": 81,
    "./CCEventManager": 82,
    "./CCTouch": 83
  } ],
  85: [ (function(require, module, exports) {
    "use strict";
    var js = cc.js;
    var CallbacksHandler = require("../platform/callbacks-invoker").CallbacksHandler;
    function EventListeners() {
      CallbacksHandler.call(this);
    }
    js.extend(EventListeners, CallbacksHandler);
    EventListeners.prototype.invoke = function(event, captureListeners) {
      var key = event.type;
      var list = this._callbackTable[key];
      if (list) {
        var rootInvoker = !list.isInvoking;
        list.isInvoking = true;
        var callbacks = list.callbacks;
        var targets = list.targets;
        for (var i = 0, len = callbacks.length; i < len; ++i) {
          var callback = callbacks[i];
          if (callback) {
            var target = targets[i] || event.currentTarget;
            callback.call(target, event, captureListeners);
            if (event._propagationImmediateStopped) break;
          }
        }
        if (rootInvoker) {
          list.isInvoking = false;
          list.containCanceled && list.purgeCanceled();
        }
      }
    };
    module.exports = EventListeners;
    false;
  }), {
    "../platform/callbacks-invoker": 131
  } ],
  86: [ (function(require, module, exports) {
    "use strict";
    var js = require("../platform/js");
    var CallbacksInvoker = require("../platform/callbacks-invoker");
    var fastRemove = js.array.fastRemove;
    function EventTarget() {
      CallbacksInvoker.call(this);
    }
    js.extend(EventTarget, CallbacksInvoker);
    var proto = EventTarget.prototype;
    proto.on = function(type, callback, target) {
      if (!callback) {
        cc.errorID(6800);
        return;
      }
      if (!this.hasEventListener(type, callback, target)) {
        this.add(type, callback, target);
        target && target.__eventTargets && target.__eventTargets.push(this);
      }
      return callback;
    };
    proto.off = function(type, callback, target) {
      if (callback) {
        this.remove(type, callback, target);
        target && target.__eventTargets && fastRemove(target.__eventTargets, this);
      } else this.removeAll(type);
    };
    proto.targetOff = proto.removeAll;
    proto.once = function(type, callback, target) {
      var eventType_hasOnceListener = "__ONCE_FLAG:" + type;
      var hasOnceListener = this.hasEventListener(eventType_hasOnceListener, callback, target);
      if (!hasOnceListener) {
        var self = this;
        var onceWrapper = function onceWrapper(arg1, arg2, arg3, arg4, arg5) {
          self.off(type, onceWrapper, target);
          self.remove(eventType_hasOnceListener, callback, target);
          callback.call(this, arg1, arg2, arg3, arg4, arg5);
        };
        this.on(type, onceWrapper, target);
        this.add(eventType_hasOnceListener, callback, target);
      }
    };
    proto.emit = CallbacksInvoker.prototype.invoke;
    proto.dispatchEvent = function(event) {
      this.invoke(event.type, event);
    };
    cc.EventTarget = module.exports = EventTarget;
  }), {
    "../platform/callbacks-invoker": 131,
    "../platform/js": 138
  } ],
  87: [ (function(require, module, exports) {
    "use strict";
    var js = require("../platform/js");
    cc.Event = function(type, bubbles) {
      this.type = type;
      this.bubbles = !!bubbles;
      this.target = null;
      this.currentTarget = null;
      this.eventPhase = 0;
      this._propagationStopped = false;
      this._propagationImmediateStopped = false;
    };
    cc.Event.prototype = {
      constructor: cc.Event,
      unuse: function unuse() {
        this.type = cc.Event.NO_TYPE;
        this.target = null;
        this.currentTarget = null;
        this.eventPhase = cc.Event.NONE;
        this._propagationStopped = false;
        this._propagationImmediateStopped = false;
      },
      reuse: function reuse(type, bubbles) {
        this.type = type;
        this.bubbles = bubbles || false;
      },
      stopPropagation: function stopPropagation() {
        this._propagationStopped = true;
      },
      stopPropagationImmediate: function stopPropagationImmediate() {
        this._propagationImmediateStopped = true;
      },
      isStopped: function isStopped() {
        return this._propagationStopped || this._propagationImmediateStopped;
      },
      getCurrentTarget: function getCurrentTarget() {
        return this.currentTarget;
      },
      getType: function getType() {
        return this.type;
      }
    };
    cc.Event.NO_TYPE = "no_type";
    cc.Event.TOUCH = "touch";
    cc.Event.MOUSE = "mouse";
    cc.Event.KEYBOARD = "keyboard";
    cc.Event.ACCELERATION = "acceleration";
    cc.Event.NONE = 0;
    cc.Event.CAPTURING_PHASE = 1;
    cc.Event.AT_TARGET = 2;
    cc.Event.BUBBLING_PHASE = 3;
    var EventCustom = function EventCustom(type, bubbles) {
      cc.Event.call(this, type, bubbles);
      this.detail = null;
    };
    js.extend(EventCustom, cc.Event);
    EventCustom.prototype.reset = EventCustom;
    EventCustom.prototype.setUserData = function(data) {
      this.detail = data;
    };
    EventCustom.prototype.getUserData = function() {
      return this.detail;
    };
    EventCustom.prototype.getEventName = cc.Event.prototype.getType;
    var MAX_POOL_SIZE = 10;
    var _eventPool = new js.Pool(MAX_POOL_SIZE);
    EventCustom.put = function(event) {
      _eventPool.put(event);
    };
    EventCustom.get = function(type, bubbles) {
      var event = _eventPool._get();
      event ? event.reset(type, bubbles) : event = new EventCustom(type, bubbles);
      return event;
    };
    cc.Event.EventCustom = EventCustom;
    module.exports = cc.Event;
  }), {
    "../platform/js": 138
  } ],
  88: [ (function(require, module, exports) {
    "use strict";
    require("./event");
    require("./event-listeners");
    require("./event-target");
    require("./system-event");
  }), {
    "./event": 87,
    "./event-listeners": 85,
    "./event-target": 86,
    "./system-event": 89
  } ],
  89: [ (function(require, module, exports) {
    "use strict";
    var EventTarget = require("../event/event-target");
    var eventManager = require("../event-manager");
    var inputManger = require("../platform/CCInputManager");
    var EventType = cc.Enum({
      KEY_DOWN: "keydown",
      KEY_UP: "keyup",
      DEVICEMOTION: "devicemotion"
    });
    var keyboardListener = null;
    var accelerationListener = null;
    var SystemEvent = cc.Class({
      name: "SystemEvent",
      extends: EventTarget,
      statics: {
        EventType: EventType
      },
      setAccelerometerEnabled: function setAccelerometerEnabled(isEnable) {
        false;
        inputManger.setAccelerometerEnabled(isEnable);
      },
      setAccelerometerInterval: function setAccelerometerInterval(interval) {
        false;
        inputManger.setAccelerometerInterval(interval);
      },
      on: function on(type, callback, target) {
        false;
        this._super(type, callback, target);
        if (type === EventType.KEY_DOWN || type === EventType.KEY_UP) {
          keyboardListener || (keyboardListener = cc.EventListener.create({
            event: cc.EventListener.KEYBOARD,
            onKeyPressed: function onKeyPressed(keyCode, event) {
              event.type = EventType.KEY_DOWN;
              cc.systemEvent.dispatchEvent(event);
            },
            onKeyReleased: function onKeyReleased(keyCode, event) {
              event.type = EventType.KEY_UP;
              cc.systemEvent.dispatchEvent(event);
            }
          }));
          eventManager.hasEventListener(cc.EventListener.ListenerID.KEYBOARD) || eventManager.addListener(keyboardListener, 1);
        }
        if (type === EventType.DEVICEMOTION) {
          accelerationListener || (accelerationListener = cc.EventListener.create({
            event: cc.EventListener.ACCELERATION,
            callback: function callback(acc, event) {
              event.type = EventType.DEVICEMOTION;
              cc.systemEvent.dispatchEvent(event);
            }
          }));
          eventManager.hasEventListener(cc.EventListener.ListenerID.ACCELERATION) || eventManager.addListener(accelerationListener, 1);
        }
      },
      off: function off(type, callback, target) {
        false;
        this._super(type, callback, target);
        if (keyboardListener && (type === EventType.KEY_DOWN || type === EventType.KEY_UP)) {
          var hasKeyDownEventListener = this.hasEventListener(EventType.KEY_DOWN);
          var hasKeyUpEventListener = this.hasEventListener(EventType.KEY_UP);
          hasKeyDownEventListener || hasKeyUpEventListener || eventManager.removeListener(keyboardListener);
        }
        accelerationListener && type === EventType.DEVICEMOTION && eventManager.removeListener(accelerationListener);
      }
    });
    cc.SystemEvent = module.exports = SystemEvent;
    cc.systemEvent = new cc.SystemEvent();
  }), {
    "../event-manager": 84,
    "../event/event-target": 86,
    "../platform/CCInputManager": 122
  } ],
  90: [ (function(require, module, exports) {
    "use strict";
    var RenderComponent = require("../components/CCRenderComponent");
    var Material = require("../assets/material/CCMaterial");
    var Types = require("./types");
    var LineCap = Types.LineCap;
    var LineJoin = Types.LineJoin;
    var Graphics = cc.Class({
      name: "cc.Graphics",
      extends: RenderComponent,
      editor: false,
      ctor: function ctor() {
        this._impl = Graphics._assembler.createImpl(this);
      },
      properties: {
        _lineWidth: 1,
        _strokeColor: cc.Color.BLACK,
        _lineJoin: LineJoin.MITER,
        _lineCap: LineCap.BUTT,
        _fillColor: cc.Color.WHITE,
        _miterLimit: 10,
        lineWidth: {
          get: function get() {
            return this._lineWidth;
          },
          set: function set(value) {
            this._lineWidth = value;
            this._impl.lineWidth = value;
          }
        },
        lineJoin: {
          get: function get() {
            return this._lineJoin;
          },
          set: function set(value) {
            this._lineJoin = value;
            this._impl.lineJoin = value;
          },
          type: LineJoin
        },
        lineCap: {
          get: function get() {
            return this._lineCap;
          },
          set: function set(value) {
            this._lineCap = value;
            this._impl.lineCap = value;
          },
          type: LineCap
        },
        strokeColor: {
          get: function get() {
            return this._strokeColor;
          },
          set: function set(value) {
            this._impl.strokeColor = this._strokeColor = cc.color(value);
          }
        },
        fillColor: {
          get: function get() {
            return this._fillColor;
          },
          set: function set(value) {
            this._impl.fillColor = this._fillColor = cc.color(value);
          }
        },
        miterLimit: {
          get: function get() {
            return this._miterLimit;
          },
          set: function set(value) {
            this._miterLimit = value;
            this._impl.miterLimit = value;
          }
        }
      },
      statics: {
        LineJoin: LineJoin,
        LineCap: LineCap
      },
      onRestore: function onRestore() {
        this._impl || (this._impl = Graphics._assembler.createImpl());
      },
      onEnable: function onEnable() {
        this._super();
        this._activateMaterial();
      },
      onDestroy: function onDestroy() {
        this._super();
        this._impl.clear(this, true);
        this._impl = null;
      },
      _activateMaterial: function _activateMaterial() {
        if (cc.game.renderType === cc.game.RENDER_TYPE_CANVAS) {
          this.disableRender();
          return;
        }
        this.node._renderFlag &= ~cc.RenderFlow.FLAG_RENDER;
        this.node._renderFlag |= cc.RenderFlow.FLAG_CUSTOM_IA_RENDER;
        if (this.sharedMaterials[0]) return;
        var material = Material.getInstantiatedBuiltinMaterial("2d-base", this);
        material.define("_USE_MODEL", true);
        this.setMaterial(0, material);
      },
      moveTo: function moveTo(x, y) {
        if (true, x instanceof cc.Vec2) {
          cc.warn("[moveTo] : Can not pass Vec2 as [x, y] value, please check it.");
          return;
        }
        this._impl.moveTo(x, y);
      },
      lineTo: function lineTo(x, y) {
        if (true, x instanceof cc.Vec2) {
          cc.warn("[moveTo] : Can not pass Vec2 as [x, y] value, please check it.");
          return;
        }
        this._impl.lineTo(x, y);
      },
      bezierCurveTo: function bezierCurveTo(c1x, c1y, c2x, c2y, x, y) {
        this._impl.bezierCurveTo(c1x, c1y, c2x, c2y, x, y);
      },
      quadraticCurveTo: function quadraticCurveTo(cx, cy, x, y) {
        this._impl.quadraticCurveTo(cx, cy, x, y);
      },
      arc: function arc(cx, cy, r, startAngle, endAngle, counterclockwise) {
        this._impl.arc(cx, cy, r, startAngle, endAngle, counterclockwise);
      },
      ellipse: function ellipse(cx, cy, rx, ry) {
        this._impl.ellipse(cx, cy, rx, ry);
      },
      circle: function circle(cx, cy, r) {
        this._impl.circle(cx, cy, r);
      },
      rect: function rect(x, y, w, h) {
        this._impl.rect(x, y, w, h);
      },
      roundRect: function roundRect(x, y, w, h, r) {
        this._impl.roundRect(x, y, w, h, r);
      },
      fillRect: function fillRect(x, y, w, h) {
        this.rect(x, y, w, h);
        this.fill();
      },
      clear: function clear(clean) {
        this._impl.clear(this, clean);
      },
      close: function close() {
        this._impl.close();
      },
      stroke: function stroke() {
        Graphics._assembler.stroke(this);
      },
      fill: function fill() {
        Graphics._assembler.fill(this);
      }
    });
    cc.Graphics = module.exports = Graphics;
  }), {
    "../assets/material/CCMaterial": 52,
    "../components/CCRenderComponent": 70,
    "./types": 93
  } ],
  91: [ (function(require, module, exports) {
    "use strict";
    var PointFlags = require("./types").PointFlags;
    var PI = Math.PI;
    var min = Math.min;
    var max = Math.max;
    var cos = Math.cos;
    var sin = Math.sin;
    var abs = Math.abs;
    var sign = Math.sign;
    var KAPPA90 = .5522847493;
    function arc(ctx, cx, cy, r, startAngle, endAngle, counterclockwise) {
      counterclockwise = counterclockwise || false;
      var a = 0, da = 0, hda = 0, kappa = 0;
      var dx = 0, dy = 0, x = 0, y = 0, tanx = 0, tany = 0;
      var px = 0, py = 0, ptanx = 0, ptany = 0;
      var i, ndivs;
      da = endAngle - startAngle;
      if (counterclockwise) if (abs(da) >= 2 * PI) da = 2 * PI; else while (da < 0) da += 2 * PI; else if (abs(da) >= 2 * PI) da = 2 * -PI; else while (da > 0) da -= 2 * PI;
      ndivs = 0 | max(1, min(abs(da) / (.5 * PI) + .5, 5));
      hda = da / ndivs / 2;
      kappa = abs(4 / 3 * (1 - cos(hda)) / sin(hda));
      counterclockwise || (kappa = -kappa);
      for (i = 0; i <= ndivs; i++) {
        a = startAngle + da * (i / ndivs);
        dx = cos(a);
        dy = sin(a);
        x = cx + dx * r;
        y = cy + dy * r;
        tanx = -dy * r * kappa;
        tany = dx * r * kappa;
        0 === i ? ctx.moveTo(x, y) : ctx.bezierCurveTo(px + ptanx, py + ptany, x - tanx, y - tany, x, y);
        px = x;
        py = y;
        ptanx = tanx;
        ptany = tany;
      }
    }
    function ellipse(ctx, cx, cy, rx, ry) {
      ctx.moveTo(cx - rx, cy);
      ctx.bezierCurveTo(cx - rx, cy + ry * KAPPA90, cx - rx * KAPPA90, cy + ry, cx, cy + ry);
      ctx.bezierCurveTo(cx + rx * KAPPA90, cy + ry, cx + rx, cy + ry * KAPPA90, cx + rx, cy);
      ctx.bezierCurveTo(cx + rx, cy - ry * KAPPA90, cx + rx * KAPPA90, cy - ry, cx, cy - ry);
      ctx.bezierCurveTo(cx - rx * KAPPA90, cy - ry, cx - rx, cy - ry * KAPPA90, cx - rx, cy);
      ctx.close();
    }
    function roundRect(ctx, x, y, w, h, r) {
      if (r < .1) {
        ctx.rect(x, y, w, h);
        return;
      }
      var rx = min(r, .5 * abs(w)) * sign(w), ry = min(r, .5 * abs(h)) * sign(h);
      ctx.moveTo(x, y + ry);
      ctx.lineTo(x, y + h - ry);
      ctx.bezierCurveTo(x, y + h - ry * (1 - KAPPA90), x + rx * (1 - KAPPA90), y + h, x + rx, y + h);
      ctx.lineTo(x + w - rx, y + h);
      ctx.bezierCurveTo(x + w - rx * (1 - KAPPA90), y + h, x + w, y + h - ry * (1 - KAPPA90), x + w, y + h - ry);
      ctx.lineTo(x + w, y + ry);
      ctx.bezierCurveTo(x + w, y + ry * (1 - KAPPA90), x + w - rx * (1 - KAPPA90), y, x + w - rx, y);
      ctx.lineTo(x + rx, y);
      ctx.bezierCurveTo(x + rx * (1 - KAPPA90), y, x, y + ry * (1 - KAPPA90), x, y + ry);
      ctx.close();
    }
    function tesselateBezier(ctx, x1, y1, x2, y2, x3, y3, x4, y4, level, type) {
      var x12, y12, x23, y23, x34, y34, x123, y123, x234, y234, x1234, y1234;
      var dx, dy, d2, d3;
      if (level > 10) return;
      x12 = .5 * (x1 + x2);
      y12 = .5 * (y1 + y2);
      x23 = .5 * (x2 + x3);
      y23 = .5 * (y2 + y3);
      x34 = .5 * (x3 + x4);
      y34 = .5 * (y3 + y4);
      x123 = .5 * (x12 + x23);
      y123 = .5 * (y12 + y23);
      dx = x4 - x1;
      dy = y4 - y1;
      d2 = abs((x2 - x4) * dy - (y2 - y4) * dx);
      d3 = abs((x3 - x4) * dy - (y3 - y4) * dx);
      if ((d2 + d3) * (d2 + d3) < ctx._tessTol * (dx * dx + dy * dy)) {
        ctx._addPoint(x4, y4, 0 === type ? type | PointFlags.PT_BEVEL : type);
        return;
      }
      x234 = .5 * (x23 + x34);
      y234 = .5 * (y23 + y34);
      x1234 = .5 * (x123 + x234);
      y1234 = .5 * (y123 + y234);
      tesselateBezier(ctx, x1, y1, x12, y12, x123, y123, x1234, y1234, level + 1, 0);
      tesselateBezier(ctx, x1234, y1234, x234, y234, x34, y34, x4, y4, level + 1, type);
    }
    module.exports = {
      arc: arc,
      ellipse: ellipse,
      roundRect: roundRect,
      tesselateBezier: tesselateBezier
    };
  }), {
    "./types": 93
  } ],
  92: [ (function(require, module, exports) {
    "use strict";
    require("./graphics");
  }), {
    "./graphics": 90
  } ],
  93: [ (function(require, module, exports) {
    "use strict";
    var LineCap = cc.Enum({
      BUTT: 0,
      ROUND: 1,
      SQUARE: 2
    });
    var LineJoin = cc.Enum({
      BEVEL: 0,
      ROUND: 1,
      MITER: 2
    });
    var PointFlags = cc.Enum({
      PT_CORNER: 1,
      PT_LEFT: 2,
      PT_BEVEL: 4,
      PT_INNERBEVEL: 8
    });
    module.exports = {
      LineCap: LineCap,
      LineJoin: LineJoin,
      PointFlags: PointFlags
    };
  }), {} ],
  94: [ (function(require, module, exports) {
    "use strict";
    require("./platform");
    require("./assets");
    true;
    require("./CCNode");
    require("./CCPrivateNode");
    require("./CCScene");
    require("./components");
    require("./graphics");
    require("./collider");
    require("./collider/CCIntersection");
    require("./physics");
    require("./camera/CCCamera");
    require("./geom-utils");
    require("./mesh");
    require("./3d");
    require("./3d/polyfill-3d");
    require("./base-ui/CCWidgetManager");
  }), {
    "./3d": void 0,
    "./3d/polyfill-3d": 25,
    "./CCNode": 29,
    "./CCPrivateNode": 30,
    "./CCScene": 31,
    "./assets": 51,
    "./base-ui/CCWidgetManager": 55,
    "./camera/CCCamera": 56,
    "./collider": void 0,
    "./collider/CCIntersection": void 0,
    "./components": 78,
    "./geom-utils": void 0,
    "./graphics": 92,
    "./mesh": void 0,
    "./physics": void 0,
    "./platform": 135
  } ],
  95: [ (function(require, module, exports) {
    "use strict";
    var js = require("../platform/js");
    var Pipeline = require("./pipeline");
    var LoadingItems = require("./loading-items");
    var AssetLoader = require("./asset-loader");
    var Downloader = require("./downloader");
    var Loader = require("./loader");
    var AssetTable = require("./asset-table");
    var callInNextTick = require("../platform/utils").callInNextTick;
    var AutoReleaseUtils = require("./auto-release-utils");
    var ReleasedAssetChecker = (true, require("./released-asset-checker"));
    var assetTables = Object.create(null);
    assetTables.assets = new AssetTable();
    assetTables.internal = new AssetTable();
    function getXMLHttpRequest() {
      return window.XMLHttpRequest ? new window.XMLHttpRequest() : new ActiveXObject("MSXML2.XMLHTTP");
    }
    var _info = {
      url: null,
      raw: false
    };
    function getResWithUrl(res) {
      var id, result, isUuid;
      if ("object" === typeof res) {
        result = res;
        if (res.url) return result;
        id = res.uuid;
      } else {
        result = {};
        id = res;
      }
      isUuid = result.type ? "uuid" === result.type : cc.AssetLibrary._uuidInSettings(id);
      cc.AssetLibrary._getAssetInfoInRuntime(id, _info);
      result.url = isUuid ? _info.url : id;
      if (_info.url && "uuid" === result.type && _info.raw) {
        result.type = null;
        result.isRawAsset = true;
      } else isUuid || (result.isRawAsset = true);
      return result;
    }
    var _sharedResources = [];
    var _sharedList = [];
    function CCLoader() {
      var assetLoader = new AssetLoader();
      var downloader = new Downloader();
      var loader = new Loader();
      Pipeline.call(this, [ assetLoader, downloader, loader ]);
      this.assetLoader = assetLoader;
      this.md5Pipe = null;
      this.downloader = downloader;
      this.loader = loader;
      this.onProgress = null;
      this._autoReleaseSetting = js.createMap(true);
      true;
      this._releasedAssetChecker_DEBUG = new ReleasedAssetChecker();
    }
    js.extend(CCLoader, Pipeline);
    var proto = CCLoader.prototype;
    proto.init = function(director) {
      true;
      var self = this;
      director.on(cc.Director.EVENT_AFTER_UPDATE, (function() {
        self._releasedAssetChecker_DEBUG.checkCouldRelease(self._cache);
      }));
    };
    proto.getXMLHttpRequest = getXMLHttpRequest;
    proto.addDownloadHandlers = function(extMap) {
      this.downloader.addHandlers(extMap);
    };
    proto.addLoadHandlers = function(extMap) {
      this.loader.addHandlers(extMap);
    };
    proto.load = function(resources, progressCallback, completeCallback) {
      false;
      if (void 0 === completeCallback) {
        completeCallback = progressCallback;
        progressCallback = this.onProgress || null;
      }
      var self = this;
      var singleRes = false;
      var res;
      if (!(resources instanceof Array)) if (resources) {
        singleRes = true;
        resources = [ resources ];
      } else resources = [];
      _sharedResources.length = 0;
      for (var i = 0; i < resources.length; ++i) {
        var resource = resources[i];
        if (resource && resource.id) {
          cc.warnID(4920, resource.id);
          resource.uuid || resource.url || (resource.url = resource.id);
        }
        res = getResWithUrl(resource);
        if (!res.url && !res.uuid) continue;
        var item = this._cache[res.url];
        _sharedResources.push(item || res);
      }
      var queue = LoadingItems.create(this, progressCallback, (function(errors, items) {
        callInNextTick((function() {
          if (completeCallback) {
            if (singleRes) {
              var id = res.url;
              completeCallback.call(self, errors, items.getContent(id));
            } else completeCallback.call(self, errors, items);
            completeCallback = null;
          }
          var _id;
          false;
          items.destroy();
        }));
      }));
      LoadingItems.initQueueDeps(queue);
      queue.append(_sharedResources);
      _sharedResources.length = 0;
    };
    proto.flowInDeps = function(owner, urlList, callback) {
      _sharedList.length = 0;
      for (var i = 0; i < urlList.length; ++i) {
        var res = getResWithUrl(urlList[i]);
        if (!res.url && !res.uuid) continue;
        var item = this._cache[res.url];
        item ? _sharedList.push(item) : _sharedList.push(res);
      }
      var queue = LoadingItems.create(this, owner ? function(completedCount, totalCount, item) {
        this._ownerQueue && this._ownerQueue.onProgress && this._ownerQueue._childOnProgress(item);
      } : null, (function(errors, items) {
        callback(errors, items);
        owner && owner.deps && (owner.deps.length = 0);
        items.destroy();
      }));
      if (owner) {
        var ownerQueue = LoadingItems.getQueue(owner);
        queue._ownerQueue = ownerQueue._ownerQueue || ownerQueue;
      }
      var accepted = queue.append(_sharedList, owner);
      _sharedList.length = 0;
      return accepted;
    };
    proto._assetTables = assetTables;
    proto._getResUuid = function(url, type, mount, quiet) {
      mount = mount || "assets";
      var assetTable = assetTables[mount];
      if (!url || !assetTable) return null;
      var index = url.indexOf("?");
      -1 !== index && (url = url.substr(0, index));
      var uuid = assetTable.getUuid(url, type);
      if (!uuid) {
        var extname = cc.path.extname(url);
        if (extname) {
          url = url.slice(0, -extname.length);
          uuid = assetTable.getUuid(url, type);
          uuid && !quiet && cc.warnID(4901, url, extname);
        }
      }
      return uuid;
    };
    proto._getReferenceKey = function(assetOrUrlOrUuid) {
      var key;
      "object" === typeof assetOrUrlOrUuid ? key = assetOrUrlOrUuid._uuid || null : "string" === typeof assetOrUrlOrUuid && (key = this._getResUuid(assetOrUrlOrUuid, null, null, true) || assetOrUrlOrUuid);
      if (!key) {
        cc.warnID(4800, assetOrUrlOrUuid);
        return key;
      }
      cc.AssetLibrary._getAssetInfoInRuntime(key, _info);
      return this._cache[_info.url] ? _info.url : key;
    };
    proto._urlNotFound = function(url, type, completeCallback) {
      callInNextTick((function() {
        url = cc.url.normalize(url);
        var info = (type ? js.getClassName(type) : "Asset") + ' in "resources/' + url + '" does not exist.';
        completeCallback && completeCallback(new Error(info), []);
      }));
    };
    proto._parseLoadResArgs = function(type, onProgress, onComplete) {
      if (void 0 === onComplete) {
        var isValidType = type instanceof Array || js.isChildClassOf(type, cc.RawAsset);
        if (onProgress) {
          onComplete = onProgress;
          isValidType && (onProgress = this.onProgress || null);
        } else if (void 0 === onProgress && !isValidType) {
          onComplete = type;
          onProgress = this.onProgress || null;
          type = null;
        }
        if (void 0 !== onProgress && !isValidType) {
          onProgress = type;
          type = null;
        }
      }
      return {
        type: type,
        onProgress: onProgress,
        onComplete: onComplete
      };
    };
    proto.loadRes = function(url, type, mount, progressCallback, completeCallback) {
      if (5 !== arguments.length) {
        completeCallback = progressCallback;
        progressCallback = mount;
        mount = "assets";
      }
      var args = this._parseLoadResArgs(type, progressCallback, completeCallback);
      type = args.type;
      progressCallback = args.onProgress;
      completeCallback = args.onComplete;
      var self = this;
      var uuid = self._getResUuid(url, type, mount);
      uuid ? this.load({
        type: "uuid",
        uuid: uuid
      }, progressCallback, (function(err, asset) {
        asset && self.setAutoReleaseRecursively(uuid, false);
        completeCallback && completeCallback(err, asset);
      })) : self._urlNotFound(url, type, completeCallback);
    };
    proto._loadResUuids = function(uuids, progressCallback, completeCallback, urls) {
      if (uuids.length > 0) {
        var self = this;
        var res = uuids.map((function(uuid) {
          return {
            type: "uuid",
            uuid: uuid
          };
        }));
        this.load(res, progressCallback, (function(errors, items) {
          if (completeCallback) {
            var assetRes = [];
            var urlRes = urls && [];
            for (var i = 0; i < res.length; ++i) {
              var uuid = res[i].uuid;
              var id = this._getReferenceKey(uuid);
              var item = items.getContent(id);
              if (item) {
                self.setAutoReleaseRecursively(uuid, false);
                assetRes.push(item);
                urlRes && urlRes.push(urls[i]);
              }
            }
            urls ? completeCallback(errors, assetRes, urlRes) : completeCallback(errors, assetRes);
          }
        }));
      } else completeCallback && callInNextTick((function() {
        urls ? completeCallback(null, [], []) : completeCallback(null, []);
      }));
    };
    proto.loadResArray = function(urls, type, mount, progressCallback, completeCallback) {
      if (5 !== arguments.length) {
        completeCallback = progressCallback;
        progressCallback = mount;
        mount = "assets";
      }
      var args = this._parseLoadResArgs(type, progressCallback, completeCallback);
      type = args.type;
      progressCallback = args.onProgress;
      completeCallback = args.onComplete;
      var uuids = [];
      var isTypesArray = type instanceof Array;
      for (var i = 0; i < urls.length; i++) {
        var url = urls[i];
        var assetType = isTypesArray ? type[i] : type;
        var uuid = this._getResUuid(url, assetType, mount);
        if (!uuid) {
          this._urlNotFound(url, assetType, completeCallback);
          return;
        }
        uuids.push(uuid);
      }
      this._loadResUuids(uuids, progressCallback, completeCallback);
    };
    proto.loadResDir = function(url, type, mount, progressCallback, completeCallback) {
      if (5 !== arguments.length) {
        completeCallback = progressCallback;
        progressCallback = mount;
        mount = "assets";
      }
      if (!assetTables[mount]) return;
      var args = this._parseLoadResArgs(type, progressCallback, completeCallback);
      type = args.type;
      progressCallback = args.onProgress;
      completeCallback = args.onComplete;
      var urls = [];
      var uuids = assetTables[mount].getUuidArray(url, type, urls);
      this._loadResUuids(uuids, progressCallback, completeCallback, urls);
    };
    proto.getRes = function(url, type) {
      var item = this._cache[url];
      if (!item) {
        var uuid = this._getResUuid(url, type, null, true);
        if (!uuid) return null;
        var ref = this._getReferenceKey(uuid);
        item = this._cache[ref];
      }
      item && item.alias && (item = item.alias);
      return item && item.complete ? item.content : null;
    };
    proto.getResCount = function() {
      return Object.keys(this._cache).length;
    };
    proto.getDependsRecursively = function(owner) {
      if (owner) {
        var key = this._getReferenceKey(owner);
        var assets = AutoReleaseUtils.getDependsRecursively(key);
        assets.push(key);
        return assets;
      }
      return [];
    };
    proto.release = function(asset) {
      if (Array.isArray(asset)) for (var i = 0; i < asset.length; i++) {
        var key = asset[i];
        this.release(key);
      } else if (asset) {
        var id = this._getReferenceKey(asset);
        var item = this.getItem(id);
        if (item) {
          var removed = this.removeItem(id);
          asset = item.content;
          (true, removed) && this._releasedAssetChecker_DEBUG.setReleased(item, id);
        }
        if (asset instanceof cc.Asset) {
          var nativeUrl = asset.nativeUrl;
          nativeUrl && this.release(nativeUrl);
          asset.destroy();
        }
      }
    };
    proto.releaseAsset = function(asset) {
      var uuid = asset._uuid;
      uuid && this.release(uuid);
    };
    proto.releaseRes = function(url, type, mount) {
      var uuid = this._getResUuid(url, type, mount);
      uuid ? this.release(uuid) : cc.errorID(4914, url);
    };
    proto.releaseResDir = function(url, type, mount) {
      mount = mount || "assets";
      if (!assetTables[mount]) return;
      var uuids = assetTables[mount].getUuidArray(url, type);
      for (var i = 0; i < uuids.length; i++) {
        var uuid = uuids[i];
        this.release(uuid);
      }
    };
    proto.releaseAll = function() {
      for (var id in this._cache) this.release(id);
    };
    proto.removeItem = function(key) {
      var removed = Pipeline.prototype.removeItem.call(this, key);
      delete this._autoReleaseSetting[key];
      return removed;
    };
    proto.setAutoRelease = function(assetOrUrlOrUuid, autoRelease) {
      var key = this._getReferenceKey(assetOrUrlOrUuid);
      !!key && (this._autoReleaseSetting[key] = !!autoRelease);
    };
    proto.setAutoReleaseRecursively = function(assetOrUrlOrUuid, autoRelease) {
      autoRelease = !!autoRelease;
      var key = this._getReferenceKey(assetOrUrlOrUuid);
      if (key) {
        this._autoReleaseSetting[key] = autoRelease;
        var depends = AutoReleaseUtils.getDependsRecursively(key);
        for (var i = 0; i < depends.length; i++) {
          var depend = depends[i];
          this._autoReleaseSetting[depend] = autoRelease;
        }
      } else false;
    };
    proto.isAutoRelease = function(assetOrUrl) {
      var key = this._getReferenceKey(assetOrUrl);
      if (key) return !!this._autoReleaseSetting[key];
      return false;
    };
    cc.loader = new CCLoader();
    false;
    module.exports = cc.loader;
  }), {
    "../platform/js": 138,
    "../platform/utils": 142,
    "./asset-loader": 96,
    "./asset-table": 97,
    "./auto-release-utils": 99,
    "./downloader": 101,
    "./loader": 104,
    "./loading-items": 105,
    "./pipeline": 108,
    "./released-asset-checker": 109
  } ],
  96: [ (function(require, module, exports) {
    "use strict";
    require("../utils/CCPath");
    var debug = require("../CCDebug");
    var Pipeline = require("./pipeline");
    var LoadingItems = require("./loading-items");
    var ID = "AssetLoader";
    var AssetLoader = function AssetLoader(extMap) {
      this.id = ID;
      this.async = true;
      this.pipeline = null;
    };
    AssetLoader.ID = ID;
    var reusedArray = [];
    AssetLoader.prototype.handle = function(item, callback) {
      var uuid = item.uuid;
      if (!uuid) return item.content || null;
      var self = this;
      cc.AssetLibrary.queryAssetInfo(uuid, (function(error, url, isRawAsset) {
        if (error) callback(error); else {
          item.url = item.rawUrl = url;
          item.isRawAsset = isRawAsset;
          if (isRawAsset) {
            var ext = cc.path.extname(url).toLowerCase();
            if (!ext) {
              callback(new Error(debug.getError(4931, uuid, url)));
              return;
            }
            ext = ext.substr(1);
            var queue = LoadingItems.getQueue(item);
            reusedArray[0] = {
              queueId: item.queueId,
              id: url,
              url: url,
              type: ext,
              error: null,
              alias: item,
              complete: true
            };
            false;
            queue.append(reusedArray);
            item.type = ext;
            callback(null, item.content);
          } else {
            item.type = "uuid";
            callback(null, item.content);
          }
        }
      }));
    };
    Pipeline.AssetLoader = module.exports = AssetLoader;
  }), {
    "../CCDebug": 26,
    "../utils/CCPath": 193,
    "./loading-items": 105,
    "./pipeline": 108
  } ],
  97: [ (function(require, module, exports) {
    "use strict";
    var pushToMap = require("../utils/misc").pushToMap;
    var js = require("../platform/js");
    function Entry(uuid, type) {
      this.uuid = uuid;
      this.type = type;
    }
    function AssetTable() {
      this._pathToUuid = js.createMap(true);
    }
    function isMatchByWord(path, test) {
      if (path.length > test.length) {
        var nextAscii = path.charCodeAt(test.length);
        return 46 === nextAscii || 47 === nextAscii;
      }
      return true;
    }
    var proto = AssetTable.prototype;
    proto.getUuid = function(path, type) {
      path = cc.url.normalize(path);
      var item = this._pathToUuid[path];
      if (item) if (Array.isArray(item)) {
        if (!type) return item[0].uuid;
        for (var i = 0; i < item.length; i++) {
          var entry = item[i];
          if (js.isChildClassOf(entry.type, type)) return entry.uuid;
        }
        if (true, js.isChildClassOf(type, cc.SpriteFrame)) for (var _i = 0; _i < item.length; _i++) {
          var _entry = item[_i];
          if (js.isChildClassOf(_entry.type, cc.SpriteAtlas)) {
            cc.errorID(4932, path);
            break;
          }
        }
      } else {
        if (!type || js.isChildClassOf(item.type, type)) return item.uuid;
        (true, js.isChildClassOf(type, cc.SpriteFrame)) && js.isChildClassOf(item.type, cc.SpriteAtlas) && cc.errorID(4932, path);
      }
      return "";
    };
    proto.getUuidArray = function(path, type, out_urls) {
      path = cc.url.normalize(path);
      "/" === path[path.length - 1] && (path = path.slice(0, -1));
      var path2uuid = this._pathToUuid;
      var uuids = [];
      var isChildClassOf = js.isChildClassOf;
      var _foundAtlasUrl;
      for (var p in path2uuid) if (p.startsWith(path) && isMatchByWord(p, path) || !path) {
        var item = path2uuid[p];
        if (Array.isArray(item)) for (var i = 0; i < item.length; i++) {
          var entry = item[i];
          if (!type || isChildClassOf(entry.type, type)) {
            uuids.push(entry.uuid);
            out_urls && out_urls.push(p);
          } else (true, entry.type === cc.SpriteAtlas) && (_foundAtlasUrl = p);
        } else if (!type || isChildClassOf(item.type, type)) {
          uuids.push(item.uuid);
          out_urls && out_urls.push(p);
        } else (true, item.type === cc.SpriteAtlas) && (_foundAtlasUrl = p);
      }
      (true, 0 === uuids.length) && _foundAtlasUrl && js.isChildClassOf(type, cc.SpriteFrame) && cc.errorID(4932, _foundAtlasUrl);
      return uuids;
    };
    proto.add = function(path, uuid, type, isMainAsset) {
      path = path.substring(0, path.length - cc.path.extname(path).length);
      var newEntry = new Entry(uuid, type);
      pushToMap(this._pathToUuid, path, newEntry, isMainAsset);
    };
    proto._getInfo_DEBUG = (true, function(uuid, out_info) {
      var path2uuid = this._pathToUuid;
      var paths = Object.keys(path2uuid);
      for (var p = 0; p < paths.length; ++p) {
        var path = paths[p];
        var item = path2uuid[path];
        if (Array.isArray(item)) for (var i = 0; i < item.length; i++) {
          var entry = item[i];
          if (entry.uuid === uuid) {
            out_info.path = path;
            out_info.type = entry.type;
            return true;
          }
        } else if (item.uuid === uuid) {
          out_info.path = path;
          out_info.type = item.type;
          return true;
        }
      }
      return false;
    });
    proto.reset = function() {
      this._pathToUuid = js.createMap(true);
    };
    module.exports = AssetTable;
  }), {
    "../platform/js": 138,
    "../utils/misc": 204
  } ],
  98: [ (function(require, module, exports) {
    "use strict";
    var sys = require("../platform/CCSys");
    var debug = require("../CCDebug");
    var __audioSupport = sys.__audioSupport;
    var formatSupport = __audioSupport.format;
    var context = __audioSupport.context;
    function loadDomAudio(item, callback) {
      var dom = document.createElement("audio");
      dom.src = item.url;
      var isXiaomiGame = cc.sys.platform === cc.sys.XIAOMI_GAME;
      var isBaiduGame = cc.sys.platform === cc.sys.BAIDU_GAME;
      true;
      callback(null, dom);
      return;
      var clearEvent;
      var timer;
      var success;
      var failure;
    }
    function loadWebAudio(item, callback) {
      context || callback(new Error(debug.getError(4926)));
      var request = cc.loader.getXMLHttpRequest();
      request.open("GET", item.url, true);
      request.responseType = "arraybuffer";
      request.onload = function() {
        context["decodeAudioData"](request.response, (function(buffer) {
          callback(null, buffer);
        }), (function() {
          callback("decode error - " + item.id, null);
        }));
      };
      request.onerror = function() {
        callback("request error - " + item.id, null);
      };
      request.send();
    }
    function downloadAudio(item, callback) {
      if (0 === formatSupport.length) return new Error(debug.getError(4927));
      var loader;
      if (__audioSupport.WEB_AUDIO) {
        var loadByDeserializedAudio = item._owner instanceof cc.AudioClip;
        loader = loadByDeserializedAudio ? item._owner.loadMode === cc.AudioClip.LoadMode.WEB_AUDIO ? loadWebAudio : loadDomAudio : item.urlParam && item.urlParam["useDom"] ? loadDomAudio : loadWebAudio;
      } else loader = loadDomAudio;
      loader(item, callback);
    }
    module.exports = downloadAudio;
  }), {
    "../CCDebug": 26,
    "../platform/CCSys": 127
  } ],
  99: [ (function(require, module, exports) {
    "use strict";
    var js = require("../platform/js");
    function parseDepends(key, parsed) {
      var item = cc.loader.getItem(key);
      if (item) {
        var depends = item.dependKeys;
        if (depends) for (var i = 0; i < depends.length; i++) {
          var depend = depends[i];
          if (!parsed[depend]) {
            parsed[depend] = true;
            parseDepends(depend, parsed);
          }
        }
      }
    }
    function visitAsset(asset, excludeMap) {
      if (!asset._uuid) return;
      var key = cc.loader._getReferenceKey(asset);
      if (!excludeMap[key]) {
        excludeMap[key] = true;
        parseDepends(key, excludeMap);
      }
    }
    function visitComponent(comp, excludeMap) {
      var props = Object.getOwnPropertyNames(comp);
      for (var i = 0; i < props.length; i++) {
        var value = comp[props[i]];
        if ("object" === typeof value && value) if (Array.isArray(value)) for (var j = 0; j < value.length; j++) {
          var val = value[j];
          val instanceof cc.RawAsset && visitAsset(val, excludeMap);
        } else if (value.constructor && value.constructor !== Object) value instanceof cc.RawAsset && visitAsset(value, excludeMap); else {
          var keys = Object.getOwnPropertyNames(value);
          for (var _j = 0; _j < keys.length; _j++) {
            var _val = value[keys[_j]];
            _val instanceof cc.RawAsset && visitAsset(_val, excludeMap);
          }
        }
      }
    }
    function visitNode(node, excludeMap) {
      for (var i = 0; i < node._components.length; i++) visitComponent(node._components[i], excludeMap);
      for (var _i = 0; _i < node._children.length; _i++) visitNode(node._children[_i], excludeMap);
    }
    module.exports = {
      autoRelease: function autoRelease(oldSceneAssets, nextSceneAssets, persistNodes) {
        var releaseSettings = cc.loader._autoReleaseSetting;
        var excludeMap = js.createMap();
        if (nextSceneAssets) for (var i = 0; i < nextSceneAssets.length; i++) excludeMap[nextSceneAssets[i]] = true;
        for (var _i2 = 0; _i2 < persistNodes.length; _i2++) visitNode(persistNodes[_i2], excludeMap);
        if (oldSceneAssets) for (var _i3 = 0; _i3 < oldSceneAssets.length; _i3++) {
          var key = oldSceneAssets[_i3];
          false === releaseSettings[key] || excludeMap[key] || cc.loader.release(key);
        }
        var keys = Object.keys(releaseSettings);
        for (var _i4 = 0; _i4 < keys.length; _i4++) {
          var _key = keys[_i4];
          true !== releaseSettings[_key] || excludeMap[_key] || cc.loader.release(_key);
        }
      },
      getDependsRecursively: function getDependsRecursively(key) {
        var depends = {};
        parseDepends(key, depends);
        return Object.keys(depends);
      }
    };
  }), {
    "../platform/js": 138
  } ],
  100: [ (function(require, module, exports) {
    "use strict";
    function downloadBinary(item, callback) {
      var url = item.url;
      var xhr = cc.loader.getXMLHttpRequest(), errInfo = "Load binary data failed: " + url;
      xhr.open("GET", url, true);
      xhr.responseType = "arraybuffer";
      xhr.onload = function() {
        var arrayBuffer = xhr.response;
        if (arrayBuffer) {
          var result = new Uint8Array(arrayBuffer);
          callback(null, result);
        } else callback({
          status: xhr.status,
          errorMessage: errInfo + "(no response)"
        });
      };
      xhr.onerror = function() {
        callback({
          status: xhr.status,
          errorMessage: errInfo + "(error)"
        });
      };
      xhr.ontimeout = function() {
        callback({
          status: xhr.status,
          errorMessage: errInfo + "(time out)"
        });
      };
      xhr.send(null);
    }
    module.exports = downloadBinary;
  }), {} ],
  101: [ (function(require, module, exports) {
    "use strict";
    var js = require("../platform/js");
    var debug = require("../CCDebug");
    require("../utils/CCPath");
    var Pipeline = require("./pipeline");
    var PackDownloader = require("./pack-downloader");
    var downloadBinary = require("./binary-downloader");
    var downloadText = require("./text-downloader");
    var urlAppendTimestamp = require("./utils").urlAppendTimestamp;
    var downloadAudio;
    true;
    downloadAudio = require("./audio-downloader");
    function skip() {
      return null;
    }
    function downloadScript(item, callback, isAsync) {
      var url = item.url, d = document, s = document.createElement("script");
      "file:" !== window.location.protocol && (s.crossOrigin = "anonymous");
      s.async = isAsync;
      s.src = urlAppendTimestamp(url);
      function loadHandler() {
        s.parentNode.removeChild(s);
        s.removeEventListener("load", loadHandler, false);
        s.removeEventListener("error", errorHandler, false);
        callback(null, url);
      }
      function errorHandler() {
        s.parentNode.removeChild(s);
        s.removeEventListener("load", loadHandler, false);
        s.removeEventListener("error", errorHandler, false);
        callback(new Error(debug.getError(4928, url)));
      }
      s.addEventListener("load", loadHandler, false);
      s.addEventListener("error", errorHandler, false);
      d.body.appendChild(s);
    }
    function downloadWebp(item, callback, isCrossOrigin, img) {
      if (!cc.sys.capabilities.webp) return new Error(debug.getError(4929, item.url));
      return downloadImage(item, callback, isCrossOrigin, img);
    }
    function downloadImage(item, callback, isCrossOrigin, img) {
      void 0 === isCrossOrigin && (isCrossOrigin = true);
      var url = urlAppendTimestamp(item.url);
      img = img || new Image();
      isCrossOrigin && "file:" !== window.location.protocol ? img.crossOrigin = "anonymous" : img.crossOrigin = null;
      if (img.complete && img.naturalWidth > 0 && img.src === url) return img;
      var loadCallback = function loadCallback() {
        img.removeEventListener("load", loadCallback);
        img.removeEventListener("error", errorCallback);
        img.id = item.id;
        callback(null, img);
      };
      var errorCallback = function errorCallback() {
        img.removeEventListener("load", loadCallback);
        img.removeEventListener("error", errorCallback);
        "https:" !== window.location.protocol && img.crossOrigin && "anonymous" === img.crossOrigin.toLowerCase() ? downloadImage(item, callback, false, img) : callback(new Error(debug.getError(4930, url)));
      };
      img.addEventListener("load", loadCallback);
      img.addEventListener("error", errorCallback);
      img.src = url;
    }
    function downloadUuid(item, callback) {
      var result = PackDownloader.load(item, callback);
      if (void 0 === result) return this.extMap["json"](item, callback);
      return result || void 0;
    }
    var defaultMap = {
      js: downloadScript,
      png: downloadImage,
      jpg: downloadImage,
      bmp: downloadImage,
      jpeg: downloadImage,
      gif: downloadImage,
      ico: downloadImage,
      tiff: downloadImage,
      webp: downloadWebp,
      image: downloadImage,
      pvr: downloadBinary,
      pkm: downloadBinary,
      mp3: downloadAudio,
      ogg: downloadAudio,
      wav: downloadAudio,
      m4a: downloadAudio,
      txt: downloadText,
      xml: downloadText,
      vsh: downloadText,
      fsh: downloadText,
      atlas: downloadText,
      tmx: downloadText,
      tsx: downloadText,
      json: downloadText,
      ExportJson: downloadText,
      plist: downloadText,
      fnt: downloadText,
      font: skip,
      eot: skip,
      ttf: skip,
      woff: skip,
      svg: skip,
      ttc: skip,
      uuid: downloadUuid,
      binary: downloadBinary,
      bin: downloadBinary,
      dbbin: downloadBinary,
      default: downloadText
    };
    var ID = "Downloader";
    var Downloader = function Downloader(extMap) {
      this.id = ID;
      this.async = true;
      this.pipeline = null;
      this._curConcurrent = 0;
      this._loadQueue = [];
      this._subpackages = {};
      this.extMap = js.mixin(extMap, defaultMap);
    };
    Downloader.ID = ID;
    Downloader.PackDownloader = PackDownloader;
    Downloader.prototype.addHandlers = function(extMap) {
      js.mixin(this.extMap, extMap);
    };
    Downloader.prototype._handleLoadQueue = function() {
      while (this._curConcurrent < cc.macro.DOWNLOAD_MAX_CONCURRENT) {
        var nextOne = this._loadQueue.shift();
        if (!nextOne) break;
        var syncRet = this.handle(nextOne.item, nextOne.callback);
        void 0 !== syncRet && (syncRet instanceof Error ? nextOne.callback(syncRet) : nextOne.callback(null, syncRet));
      }
    };
    Downloader.prototype.handle = function(item, callback) {
      var self = this;
      var downloadFunc = this.extMap[item.type] || this.extMap["default"];
      var syncRet = void 0;
      if (this._curConcurrent < cc.macro.DOWNLOAD_MAX_CONCURRENT) {
        this._curConcurrent++;
        syncRet = downloadFunc.call(this, item, (function(err, result) {
          self._curConcurrent = Math.max(0, self._curConcurrent - 1);
          self._handleLoadQueue();
          callback && callback(err, result);
        }));
        if (void 0 !== syncRet) {
          this._curConcurrent = Math.max(0, this._curConcurrent - 1);
          this._handleLoadQueue();
          return syncRet;
        }
      } else if (item.ignoreMaxConcurrency) {
        syncRet = downloadFunc.call(this, item, callback);
        if (void 0 !== syncRet) return syncRet;
      } else this._loadQueue.push({
        item: item,
        callback: callback
      });
    };
    Downloader.prototype.loadSubpackage = function(name, completeCallback) {
      var pac = this._subpackages[name];
      pac ? pac.loaded ? completeCallback && completeCallback() : downloadScript({
        url: pac.path + "index.js"
      }, (function(err) {
        err || (pac.loaded = true);
        completeCallback && completeCallback(err);
      })) : completeCallback && completeCallback(new Error("Can't find subpackage " + name));
    };
    Pipeline.Downloader = module.exports = Downloader;
  }), {
    "../CCDebug": 26,
    "../platform/js": 138,
    "../utils/CCPath": 193,
    "./audio-downloader": 98,
    "./binary-downloader": 100,
    "./pack-downloader": 107,
    "./pipeline": 108,
    "./text-downloader": 111,
    "./utils": 113
  } ],
  102: [ (function(require, module, exports) {
    "use strict";
    var textUtils = require("../utils/text-utils");
    var _canvasContext = null;
    var _testString = "BES bswy:->@123\u4e01\u3041\u1101";
    var _fontFaces = {};
    var _intervalId = -1;
    var _loadingFonts = [];
    var _timeout = 3e3;
    var useNativeCheck = (function() {
      var nativeCheck = void 0;
      return function() {
        if (void 0 === nativeCheck) if (!window.FontFace) nativeCheck = false; else {
          var match = /Gecko.*Firefox\/(\d+)/.exec(window.navigator.userAgent);
          var safari10Match = /OS X.*Version\/10\..*Safari/.exec(window.navigator.userAgent) && /Apple/.exec(window.navigator.vendor);
          nativeCheck = match ? parseInt(match[1], 10) > 42 : !safari10Match;
        }
        return nativeCheck;
      };
    })();
    function _checkFontLoaded() {
      var allFontsLoaded = true;
      var now = Date.now();
      for (var i = _loadingFonts.length - 1; i >= 0; i--) {
        var fontLoadHandle = _loadingFonts[i];
        var fontFamily = fontLoadHandle.fontFamilyName;
        if (now - fontLoadHandle.startTime > _timeout) {
          cc.warnID(4933, fontFamily);
          fontLoadHandle.callback(null, fontFamily);
          _loadingFonts.splice(i, 1);
          continue;
        }
        var oldWidth = fontLoadHandle.refWidth;
        _canvasContext.font = "40px " + fontFamily;
        var newWidth = textUtils.safeMeasureText(_canvasContext, _testString);
        if (oldWidth !== newWidth) {
          _loadingFonts.splice(i, 1);
          fontLoadHandle.callback(null, fontFamily);
        } else allFontsLoaded = false;
      }
      if (allFontsLoaded) {
        clearInterval(_intervalId);
        _intervalId = -1;
      }
    }
    function nativeCheckFontLoaded(start, font, callback) {
      var loader = new Promise(function(resolve, reject) {
        var check = function check() {
          var now = Date.now();
          now - start >= _timeout ? reject() : document.fonts.load("40px " + font).then((function(fonts) {
            fonts.length >= 1 ? resolve() : setTimeout(check, 100);
          }), (function() {
            reject();
          }));
        };
        check();
      });
      var timeoutId = null, timer = new Promise(function(resolve, reject) {
        timeoutId = setTimeout(reject, _timeout);
      });
      Promise.race([ timer, loader ]).then((function() {
        if (timeoutId) {
          clearTimeout(timeoutId);
          timeoutId = null;
        }
        callback(null, font);
      }), (function() {
        cc.warnID(4933, font);
        callback(null, font);
      }));
    }
    var fontLoader = {
      loadFont: function loadFont(item, callback) {
        var url = item.url;
        var fontFamilyName = fontLoader._getFontFamily(url);
        if (_fontFaces[fontFamilyName]) return fontFamilyName;
        if (!_canvasContext) {
          var labelCanvas = document.createElement("canvas");
          labelCanvas.width = 100;
          labelCanvas.height = 100;
          _canvasContext = labelCanvas.getContext("2d");
        }
        var fontDesc = "40px " + fontFamilyName;
        _canvasContext.font = fontDesc;
        var refWidth = textUtils.safeMeasureText(_canvasContext, _testString);
        var fontStyle = document.createElement("style");
        fontStyle.type = "text/css";
        var fontStr = "";
        isNaN(fontFamilyName - 0) ? fontStr += "@font-face { font-family:" + fontFamilyName + "; src:" : fontStr += "@font-face { font-family:'" + fontFamilyName + "'; src:";
        fontStr += "url('" + url + "');";
        fontStyle.textContent = fontStr + "}";
        document.body.appendChild(fontStyle);
        var preloadDiv = document.createElement("div");
        var divStyle = preloadDiv.style;
        divStyle.fontFamily = fontFamilyName;
        preloadDiv.innerHTML = ".";
        divStyle.position = "absolute";
        divStyle.left = "-100px";
        divStyle.top = "-100px";
        document.body.appendChild(preloadDiv);
        if (useNativeCheck()) nativeCheckFontLoaded(Date.now(), fontFamilyName, callback); else {
          var fontLoadHandle = {
            fontFamilyName: fontFamilyName,
            refWidth: refWidth,
            callback: callback,
            startTime: Date.now()
          };
          _loadingFonts.push(fontLoadHandle);
          -1 === _intervalId && (_intervalId = setInterval(_checkFontLoaded, 100));
        }
        _fontFaces[fontFamilyName] = fontStyle;
      },
      _getFontFamily: function _getFontFamily(fontHandle) {
        var ttfIndex = fontHandle.lastIndexOf(".ttf");
        if (-1 === ttfIndex) return fontHandle;
        var slashPos = fontHandle.lastIndexOf("/");
        var fontFamilyName;
        fontFamilyName = -1 === slashPos ? fontHandle.substring(0, ttfIndex) + "_LABEL" : fontHandle.substring(slashPos + 1, ttfIndex) + "_LABEL";
        -1 !== fontFamilyName.indexOf(" ") && (fontFamilyName = '"' + fontFamilyName + '"');
        return fontFamilyName;
      }
    };
    module.exports = fontLoader;
  }), {
    "../utils/text-utils": 210
  } ],
  103: [ (function(require, module, exports) {
    "use strict";
    require("./downloader");
    require("./loader");
    require("./loading-items");
    require("./pipeline");
    require("./CCLoader");
  }), {
    "./CCLoader": 95,
    "./downloader": 101,
    "./loader": 104,
    "./loading-items": 105,
    "./pipeline": 108
  } ],
  104: [ (function(require, module, exports) {
    "use strict";
    var js = require("../platform/js");
    var plistParser = require("../platform/CCSAXParser").plistParser;
    var Pipeline = require("./pipeline");
    var Texture2D = require("../assets/CCTexture2D");
    var loadUuid = require("./uuid-loader");
    var fontLoader = require("./font-loader");
    function loadNothing() {
      return null;
    }
    function loadJSON(item) {
      if ("string" !== typeof item.content) return new Error("JSON Loader: Input item doesn't contain string content");
      try {
        var result = JSON.parse(item.content);
        return result;
      } catch (e) {
        return new Error("JSON Loader: Parse json [" + item.id + "] failed : " + e);
      }
    }
    function loadImage(item) {
      var loadByDeserializedAsset = item._owner instanceof cc.Asset;
      if (loadByDeserializedAsset) return null;
      var image = item.content;
      false;
      var tex = item.texture || new Texture2D();
      tex._uuid = item.uuid;
      tex.url = item.url;
      tex._setRawAsset(item.rawUrl, false);
      tex._nativeAsset = image;
      return tex;
    }
    function loadAudioAsAsset(item, callback) {
      var loadByDeserializedAsset = item._owner instanceof cc.Asset;
      if (loadByDeserializedAsset) return null;
      var audioClip = new cc.AudioClip();
      audioClip._setRawAsset(item.rawUrl, false);
      audioClip._nativeAsset = item.content;
      audioClip.url = item.url;
      return audioClip;
    }
    function loadPlist(item) {
      if ("string" !== typeof item.content) return new Error("Plist Loader: Input item doesn't contain string content");
      var result = plistParser.parse(item.content);
      return result || new Error("Plist Loader: Parse [" + item.id + "] failed");
    }
    function loadBinary(item) {
      return item.load ? item.load(item.content) : null;
    }
    var PVR_HEADER_LENGTH = 13;
    var PVR_MAGIC = 55727696;
    var PVR_HEADER_MAGIC = 0;
    var PVR_HEADER_FORMAT = 2;
    var PVR_HEADER_HEIGHT = 6;
    var PVR_HEADER_WIDTH = 7;
    var PVR_HEADER_MIPMAPCOUNT = 11;
    var PVR_HEADER_METADATA = 12;
    function loadPVRTex(item) {
      var buffer = item.content instanceof ArrayBuffer ? item.content : item.content.buffer;
      var header = new Int32Array(buffer, 0, PVR_HEADER_LENGTH);
      if (header[PVR_HEADER_MAGIC] != PVR_MAGIC) return new Error("Invalid magic number in PVR header");
      var width = header[PVR_HEADER_WIDTH];
      var height = header[PVR_HEADER_HEIGHT];
      var dataOffset = header[PVR_HEADER_METADATA] + 52;
      var pvrtcData = new Uint8Array(buffer, dataOffset);
      var pvrAsset = {
        _data: pvrtcData,
        _compressed: true,
        width: width,
        height: height
      };
      return pvrAsset;
    }
    var ETC_PKM_HEADER_SIZE = 16;
    var ETC_PKM_FORMAT_OFFSET = 6;
    var ETC_PKM_ENCODED_WIDTH_OFFSET = 8;
    var ETC_PKM_ENCODED_HEIGHT_OFFSET = 10;
    var ETC_PKM_WIDTH_OFFSET = 12;
    var ETC_PKM_HEIGHT_OFFSET = 14;
    var ETC1_RGB_NO_MIPMAPS = 0;
    var ETC2_RGB_NO_MIPMAPS = 1;
    var ETC2_RGBA_NO_MIPMAPS = 3;
    function readBEUint16(header, offset) {
      return header[offset] << 8 | header[offset + 1];
    }
    function loadPKMTex(item) {
      var buffer = item.content instanceof ArrayBuffer ? item.content : item.content.buffer;
      var header = new Uint8Array(buffer);
      var format = readBEUint16(header, ETC_PKM_FORMAT_OFFSET);
      if (format !== ETC1_RGB_NO_MIPMAPS && format !== ETC2_RGB_NO_MIPMAPS && format !== ETC2_RGBA_NO_MIPMAPS) return new Error("Invalid magic number in ETC header");
      var width = readBEUint16(header, ETC_PKM_WIDTH_OFFSET);
      var height = readBEUint16(header, ETC_PKM_HEIGHT_OFFSET);
      var encodedWidth = readBEUint16(header, ETC_PKM_ENCODED_WIDTH_OFFSET);
      var encodedHeight = readBEUint16(header, ETC_PKM_ENCODED_HEIGHT_OFFSET);
      var etcData = new Uint8Array(buffer, ETC_PKM_HEADER_SIZE);
      var etcAsset = {
        _data: etcData,
        _compressed: true,
        width: width,
        height: height
      };
      return etcAsset;
    }
    var defaultMap = {
      png: loadImage,
      jpg: loadImage,
      bmp: loadImage,
      jpeg: loadImage,
      gif: loadImage,
      ico: loadImage,
      tiff: loadImage,
      webp: loadImage,
      image: loadImage,
      pvr: loadPVRTex,
      pkm: loadPKMTex,
      mp3: loadAudioAsAsset,
      ogg: loadAudioAsAsset,
      wav: loadAudioAsAsset,
      m4a: loadAudioAsAsset,
      json: loadJSON,
      ExportJson: loadJSON,
      plist: loadPlist,
      uuid: loadUuid,
      prefab: loadUuid,
      fire: loadUuid,
      scene: loadUuid,
      binary: loadBinary,
      dbbin: loadBinary,
      bin: loadBinary,
      font: fontLoader.loadFont,
      eot: fontLoader.loadFont,
      ttf: fontLoader.loadFont,
      woff: fontLoader.loadFont,
      svg: fontLoader.loadFont,
      ttc: fontLoader.loadFont,
      default: loadNothing
    };
    var ID = "Loader";
    var Loader = function Loader(extMap) {
      this.id = ID;
      this.async = true;
      this.pipeline = null;
      this.extMap = js.mixin(extMap, defaultMap);
    };
    Loader.ID = ID;
    Loader.prototype.addHandlers = function(extMap) {
      this.extMap = js.mixin(this.extMap, extMap);
    };
    Loader.prototype.handle = function(item, callback) {
      var loadFunc = this.extMap[item.type] || this.extMap["default"];
      return loadFunc.call(this, item, callback);
    };
    Pipeline.Loader = module.exports = Loader;
  }), {
    "../assets/CCTexture2D": 50,
    "../platform/CCSAXParser": 125,
    "../platform/js": 138,
    "./font-loader": 102,
    "./pipeline": 108,
    "./uuid-loader": 114
  } ],
  105: [ (function(require, module, exports) {
    "use strict";
    var CallbacksInvoker = require("../platform/callbacks-invoker");
    require("../utils/CCPath");
    var js = require("../platform/js");
    var _qid = 0 | 998 * Math.random();
    var _queues = js.createMap(true);
    var _pool = [];
    var _POOL_MAX_LENGTH = 10;
    var ItemState = {
      WORKING: 1,
      COMPLETE: 2,
      ERROR: 3
    };
    var _queueDeps = js.createMap(true);
    function isIdValid(id) {
      var realId = id.url || id;
      return "string" === typeof realId;
    }
    function _parseUrlParam(url) {
      if (!url) return;
      var split = url.split("?");
      if (!split || !split[0] || !split[1]) return;
      var urlParam = {};
      var queries = split[1].split("&");
      queries.forEach((function(item) {
        var itemSplit = item.split("=");
        urlParam[itemSplit[0]] = itemSplit[1];
      }));
      return urlParam;
    }
    function createItem(id, queueId) {
      var url = "object" === typeof id ? id.url : id;
      var result = {
        queueId: queueId,
        id: url,
        url: url,
        rawUrl: void 0,
        urlParam: _parseUrlParam(url),
        type: "",
        error: null,
        content: null,
        complete: false,
        states: {},
        deps: null
      };
      if ("object" === typeof id) {
        js.mixin(result, id);
        if (id.skips) for (var i = 0; i < id.skips.length; i++) {
          var skip = id.skips[i];
          result.states[skip] = ItemState.COMPLETE;
        }
      }
      result.rawUrl = result.url;
      url && !result.type && (result.type = cc.path.extname(url).toLowerCase().substr(1));
      return result;
    }
    var checkedIds = [];
    function checkCircleReference(owner, item, recursiveCall) {
      if (!owner || !item) return false;
      var result = false;
      checkedIds.push(item.id);
      if (item.deps) {
        var i, deps = item.deps, subDep;
        for (i = 0; i < deps.length; i++) {
          subDep = deps[i];
          if (subDep.id === owner.id) {
            result = true;
            break;
          }
          if (checkedIds.indexOf(subDep.id) >= 0) continue;
          if (subDep.deps && checkCircleReference(owner, subDep, true)) {
            result = true;
            break;
          }
        }
      }
      recursiveCall || (checkedIds.length = 0);
      return result;
    }
    var LoadingItems = function LoadingItems(pipeline, urlList, onProgress, onComplete) {
      CallbacksInvoker.call(this);
      this._id = ++_qid;
      _queues[this._id] = this;
      this._pipeline = pipeline;
      this._errorUrls = js.createMap(true);
      this._appending = false;
      this._ownerQueue = null;
      this.onProgress = onProgress;
      this.onComplete = onComplete;
      this.map = js.createMap(true);
      this.completed = {};
      this.totalCount = 0;
      this.completedCount = 0;
      this._pipeline ? this.active = true : this.active = false;
      urlList && (urlList.length > 0 ? this.append(urlList) : this.allComplete());
    };
    LoadingItems.ItemState = new cc.Enum(ItemState);
    LoadingItems.create = function(pipeline, urlList, onProgress, onComplete) {
      if (void 0 === onProgress) {
        if ("function" === typeof urlList) {
          onComplete = urlList;
          urlList = onProgress = null;
        }
      } else if (void 0 === onComplete) if ("function" === typeof urlList) {
        onComplete = onProgress;
        onProgress = urlList;
        urlList = null;
      } else {
        onComplete = onProgress;
        onProgress = null;
      }
      var queue = _pool.pop();
      if (queue) {
        queue._pipeline = pipeline;
        queue.onProgress = onProgress;
        queue.onComplete = onComplete;
        _queues[queue._id] = queue;
        queue._pipeline && (queue.active = true);
        urlList && queue.append(urlList);
      } else queue = new LoadingItems(pipeline, urlList, onProgress, onComplete);
      return queue;
    };
    LoadingItems.getQueue = function(item) {
      return item.queueId ? _queues[item.queueId] : null;
    };
    LoadingItems.itemComplete = function(item) {
      var queue = _queues[item.queueId];
      queue && queue.itemComplete(item.id);
    };
    LoadingItems.initQueueDeps = function(queue) {
      var dep = _queueDeps[queue._id];
      if (dep) {
        dep.completed.length = 0;
        dep.deps.length = 0;
      } else dep = _queueDeps[queue._id] = {
        completed: [],
        deps: []
      };
    };
    LoadingItems.registerQueueDep = function(owner, depId) {
      var queueId = owner.queueId || owner;
      if (!queueId) return false;
      var queueDepList = _queueDeps[queueId];
      if (queueDepList) -1 === queueDepList.deps.indexOf(depId) && queueDepList.deps.push(depId); else if (owner.id) for (var id in _queueDeps) {
        var queue = _queueDeps[id];
        -1 !== queue.deps.indexOf(owner.id) && -1 === queue.deps.indexOf(depId) && queue.deps.push(depId);
      }
    };
    LoadingItems.finishDep = function(depId) {
      for (var id in _queueDeps) {
        var queue = _queueDeps[id];
        -1 !== queue.deps.indexOf(depId) && -1 === queue.completed.indexOf(depId) && queue.completed.push(depId);
      }
    };
    var proto = LoadingItems.prototype;
    js.mixin(proto, CallbacksInvoker.prototype);
    proto.append = function(urlList, owner) {
      if (!this.active) return [];
      owner && !owner.deps && (owner.deps = []);
      this._appending = true;
      var accepted = [], i, url, item;
      for (i = 0; i < urlList.length; ++i) {
        url = urlList[i];
        if (url.queueId && !this.map[url.id]) {
          this.map[url.id] = url;
          owner && owner.deps.push(url);
          if (url.complete || checkCircleReference(owner, url)) {
            this.totalCount++;
            this.itemComplete(url.id);
            continue;
          }
          var self = this;
          var queue = _queues[url.queueId];
          if (queue) {
            this.totalCount++;
            LoadingItems.registerQueueDep(owner || this._id, url.id);
            queue.addListener(url.id, (function(item) {
              self.itemComplete(item.id);
            }));
          }
          continue;
        }
        if (isIdValid(url)) {
          item = createItem(url, this._id);
          var key = item.id;
          if (!this.map[key]) {
            this.map[key] = item;
            this.totalCount++;
            owner && owner.deps.push(item);
            LoadingItems.registerQueueDep(owner || this._id, key);
            accepted.push(item);
          }
        }
      }
      this._appending = false;
      this.completedCount === this.totalCount ? this.allComplete() : this._pipeline.flowIn(accepted);
      return accepted;
    };
    proto._childOnProgress = function(item) {
      if (this.onProgress) {
        var dep = _queueDeps[this._id];
        this.onProgress(dep ? dep.completed.length : this.completedCount, dep ? dep.deps.length : this.totalCount, item);
      }
    };
    proto.allComplete = function() {
      var errors = js.isEmptyObject(this._errorUrls) ? null : this._errorUrls;
      this.onComplete && this.onComplete(errors, this);
    };
    proto.isCompleted = function() {
      return this.completedCount >= this.totalCount;
    };
    proto.isItemCompleted = function(id) {
      return !!this.completed[id];
    };
    proto.exists = function(id) {
      return !!this.map[id];
    };
    proto.getContent = function(id) {
      var item = this.map[id];
      var ret = null;
      item && (item.content ? ret = item.content : item.alias && (ret = item.alias.content));
      return ret;
    };
    proto.getError = function(id) {
      var item = this.map[id];
      var ret = null;
      item && (item.error ? ret = item.error : item.alias && (ret = item.alias.error));
      return ret;
    };
    proto.addListener = CallbacksInvoker.prototype.add;
    proto.hasListener = CallbacksInvoker.prototype.has;
    proto.removeListener = CallbacksInvoker.prototype.remove;
    proto.removeAllListeners = CallbacksInvoker.prototype.removeAll;
    proto.removeItem = function(url) {
      var item = this.map[url];
      if (!item) return;
      if (!this.completed[item.alias || url]) return;
      delete this.completed[url];
      delete this.map[url];
      if (item.alias) {
        delete this.completed[item.alias.id];
        delete this.map[item.alias.id];
      }
      this.completedCount--;
      this.totalCount--;
    };
    proto.itemComplete = function(id) {
      var item = this.map[id];
      if (!item) return;
      var errorListId = id in this._errorUrls;
      item.error instanceof Error || js.isString(item.error) ? this._errorUrls[id] = item.error : item.error ? js.mixin(this._errorUrls, item.error) : !item.error && errorListId && delete this._errorUrls[id];
      this.completed[id] = item;
      this.completedCount++;
      LoadingItems.finishDep(item.id);
      if (this.onProgress) {
        var dep = _queueDeps[this._id];
        this.onProgress(dep ? dep.completed.length : this.completedCount, dep ? dep.deps.length : this.totalCount, item);
      }
      this.invoke(id, item);
      this.removeAll(id);
      !this._appending && this.completedCount >= this.totalCount && this.allComplete();
    };
    proto.destroy = function() {
      this.active = false;
      this._appending = false;
      this._pipeline = null;
      this._ownerQueue = null;
      js.clear(this._errorUrls);
      this.onProgress = null;
      this.onComplete = null;
      this.map = js.createMap(true);
      this.completed = {};
      this.totalCount = 0;
      this.completedCount = 0;
      CallbacksInvoker.call(this);
      if (_queueDeps[this._id]) {
        _queueDeps[this._id].completed.length = 0;
        _queueDeps[this._id].deps.length = 0;
      }
      delete _queues[this._id];
      delete _queueDeps[this._id];
      -1 === _pool.indexOf(this) && _pool.length < _POOL_MAX_LENGTH && _pool.push(this);
    };
    cc.LoadingItems = module.exports = LoadingItems;
  }), {
    "../platform/callbacks-invoker": 131,
    "../platform/js": 138,
    "../utils/CCPath": 193
  } ],
  106: [ (function(require, module, exports) {
    "use strict";
    var Pipeline = require("./pipeline");
    var ID = "MD5Pipe";
    var UuidRegex = /.*[/\\][0-9a-fA-F]{2}[/\\]([0-9a-fA-F-]{8,})/;
    var MD5Pipe = function MD5Pipe(md5AssetsMap, md5NativeAssetsMap, libraryBase) {
      this.id = ID;
      this.async = false;
      this.pipeline = null;
      this.md5AssetsMap = md5AssetsMap;
      this.md5NativeAssetsMap = md5NativeAssetsMap;
      this.libraryBase = libraryBase;
    };
    MD5Pipe.ID = ID;
    MD5Pipe.prototype.handle = function(item) {
      item.url = this.transformURL(item.url);
      return null;
    };
    MD5Pipe.prototype.transformURL = function(url) {
      var isNativeAsset = !url.startsWith(this.libraryBase);
      var map = isNativeAsset ? this.md5NativeAssetsMap : this.md5AssetsMap;
      url = url.replace(UuidRegex, (function(match, uuid) {
        var hashValue = map[uuid];
        return hashValue ? match + "." + hashValue : match;
      }));
      return url;
    };
    Pipeline.MD5Pipe = module.exports = MD5Pipe;
  }), {
    "./pipeline": 108
  } ],
  107: [ (function(require, module, exports) {
    "use strict";
    var Unpackers = require("./unpackers");
    var pushToMap = require("../utils/misc").pushToMap;
    var PackState = {
      Invalid: 0,
      Removed: 1,
      Downloading: 2,
      Loaded: 3
    };
    function UnpackerData() {
      this.unpacker = null;
      this.state = PackState.Invalid;
    }
    var uuidToPack = {};
    var packIndices = {};
    var globalUnpackers = {};
    function error(uuid, packUuid) {
      return new Error("Can not retrieve " + uuid + " from packer " + packUuid);
    }
    module.exports = {
      initPacks: function initPacks(packs) {
        packIndices = packs;
        uuidToPack = {};
        for (var packUuid in packs) {
          var uuids = packs[packUuid];
          for (var i = 0; i < uuids.length; i++) {
            var uuid = uuids[i];
            var pushFront = 1 === uuids.length;
            pushToMap(uuidToPack, uuid, packUuid, pushFront);
          }
        }
      },
      _loadNewPack: function _loadNewPack(uuid, packUuid, callback) {
        var self = this;
        var packUrl = cc.AssetLibrary.getLibUrlNoExt(packUuid) + ".json";
        cc.loader.load({
          url: packUrl,
          ignoreMaxConcurrency: true
        }, (function(err, packJson) {
          if (err) {
            cc.errorID(4916, uuid);
            return callback(err);
          }
          var res = self._doLoadNewPack(uuid, packUuid, packJson);
          res ? callback(null, res) : callback(error(uuid, packUuid));
        }));
      },
      _doPreload: function _doPreload(packUuid, packJson) {
        var unpackerData = globalUnpackers[packUuid];
        if (!unpackerData) {
          unpackerData = globalUnpackers[packUuid] = new UnpackerData();
          unpackerData.state = PackState.Downloading;
        }
        if (unpackerData.state !== PackState.Loaded) {
          unpackerData.unpacker = new Unpackers.JsonUnpacker();
          unpackerData.unpacker.load(packIndices[packUuid], packJson);
          unpackerData.state = PackState.Loaded;
        }
      },
      _doLoadNewPack: function _doLoadNewPack(uuid, packUuid, packedJson) {
        var unpackerData = globalUnpackers[packUuid];
        if (unpackerData.state !== PackState.Loaded) {
          "string" === typeof packedJson && (packedJson = JSON.parse(packedJson));
          Array.isArray(packedJson) ? unpackerData.unpacker = new Unpackers.JsonUnpacker() : packedJson.type === Unpackers.TextureUnpacker.ID && (unpackerData.unpacker = new Unpackers.TextureUnpacker());
          unpackerData.unpacker.load(packIndices[packUuid], packedJson);
          unpackerData.state = PackState.Loaded;
        }
        return unpackerData.unpacker.retrieve(uuid);
      },
      _selectLoadedPack: function _selectLoadedPack(packUuids) {
        var existsPackState = PackState.Invalid;
        var existsPackUuid = "";
        for (var i = 0; i < packUuids.length; i++) {
          var packUuid = packUuids[i];
          var unpackerData = globalUnpackers[packUuid];
          if (unpackerData) {
            var state = unpackerData.state;
            if (state === PackState.Loaded) return packUuid;
            if (state > existsPackState) {
              existsPackState = state;
              existsPackUuid = packUuid;
            }
          }
        }
        return existsPackState !== PackState.Invalid ? existsPackUuid : packUuids[0];
      },
      load: function load(item, callback) {
        var uuid = item.uuid;
        var packUuid = uuidToPack[uuid];
        if (!packUuid) return;
        Array.isArray(packUuid) && (packUuid = this._selectLoadedPack(packUuid));
        var unpackerData = globalUnpackers[packUuid];
        if (unpackerData && unpackerData.state === PackState.Loaded) {
          var json = unpackerData.unpacker.retrieve(uuid);
          return json || error(uuid, packUuid);
        }
        if (!unpackerData) {
          true;
          console.log("Create unpacker %s for %s", packUuid, uuid);
          unpackerData = globalUnpackers[packUuid] = new UnpackerData();
          unpackerData.state = PackState.Downloading;
        }
        this._loadNewPack(uuid, packUuid, callback);
        return null;
      }
    };
    false;
  }), {
    "../utils/misc": 204,
    "./unpackers": 112
  } ],
  108: [ (function(require, module, exports) {
    "use strict";
    var js = require("../platform/js");
    var LoadingItems = require("./loading-items");
    var ItemState = LoadingItems.ItemState;
    function flow(pipe, item) {
      var pipeId = pipe.id;
      var itemState = item.states[pipeId];
      var next = pipe.next;
      var pipeline = pipe.pipeline;
      if (item.error || itemState === ItemState.WORKING || itemState === ItemState.ERROR) return;
      if (itemState === ItemState.COMPLETE) next ? flow(next, item) : pipeline.flowOut(item); else {
        item.states[pipeId] = ItemState.WORKING;
        var result = pipe.handle(item, (function(err, result) {
          if (err) {
            item.error = err;
            item.states[pipeId] = ItemState.ERROR;
            pipeline.flowOut(item);
          } else {
            result && (item.content = result);
            item.states[pipeId] = ItemState.COMPLETE;
            next ? flow(next, item) : pipeline.flowOut(item);
          }
        }));
        if (result instanceof Error) {
          item.error = result;
          item.states[pipeId] = ItemState.ERROR;
          pipeline.flowOut(item);
        } else if (void 0 !== result) {
          null !== result && (item.content = result);
          item.states[pipeId] = ItemState.COMPLETE;
          next ? flow(next, item) : pipeline.flowOut(item);
        }
      }
    }
    var Pipeline = function Pipeline(pipes) {
      this._pipes = pipes;
      this._cache = js.createMap(true);
      for (var i = 0; i < pipes.length; ++i) {
        var pipe = pipes[i];
        if (!pipe.handle || !pipe.id) continue;
        pipe.pipeline = this;
        pipe.next = i < pipes.length - 1 ? pipes[i + 1] : null;
      }
    };
    Pipeline.ItemState = ItemState;
    var proto = Pipeline.prototype;
    proto.insertPipe = function(pipe, index) {
      if (!pipe.handle || !pipe.id || index > this._pipes.length) {
        cc.warnID(4921);
        return;
      }
      if (this._pipes.indexOf(pipe) > 0) {
        cc.warnID(4922);
        return;
      }
      pipe.pipeline = this;
      var nextPipe = null;
      index < this._pipes.length && (nextPipe = this._pipes[index]);
      var previousPipe = null;
      index > 0 && (previousPipe = this._pipes[index - 1]);
      previousPipe && (previousPipe.next = pipe);
      pipe.next = nextPipe;
      this._pipes.splice(index, 0, pipe);
    };
    proto.insertPipeAfter = function(refPipe, newPipe) {
      var index = this._pipes.indexOf(refPipe);
      if (index < 0) return;
      this.insertPipe(newPipe, index + 1);
    };
    proto.appendPipe = function(pipe) {
      if (!pipe.handle || !pipe.id) return;
      pipe.pipeline = this;
      pipe.next = null;
      this._pipes.length > 0 && (this._pipes[this._pipes.length - 1].next = pipe);
      this._pipes.push(pipe);
    };
    proto.flowIn = function(items) {
      var i, pipe = this._pipes[0], item;
      if (pipe) {
        for (i = 0; i < items.length; i++) {
          item = items[i];
          this._cache[item.id] = item;
        }
        for (i = 0; i < items.length; i++) {
          item = items[i];
          flow(pipe, item);
        }
      } else for (i = 0; i < items.length; i++) this.flowOut(items[i]);
    };
    proto.flowInDeps = function(owner, urlList, callback) {
      var deps = LoadingItems.create(this, (function(errors, items) {
        callback(errors, items);
        items.destroy();
      }));
      return deps.append(urlList, owner);
    };
    proto.flowOut = function(item) {
      item.error ? delete this._cache[item.id] : this._cache[item.id] || (this._cache[item.id] = item);
      item.complete = true;
      LoadingItems.itemComplete(item);
    };
    proto.copyItemStates = function(srcItem, dstItems) {
      if (!(dstItems instanceof Array)) {
        dstItems.states = srcItem.states;
        return;
      }
      for (var i = 0; i < dstItems.length; ++i) dstItems[i].states = srcItem.states;
    };
    proto.getItem = function(id) {
      var item = this._cache[id];
      if (!item) return item;
      item.alias && (item = item.alias);
      return item;
    };
    proto.removeItem = function(id) {
      var removed = this._cache[id];
      removed && removed.complete && delete this._cache[id];
      return removed;
    };
    proto.clear = function() {
      for (var id in this._cache) {
        var item = this._cache[id];
        delete this._cache[id];
        if (!item.complete) {
          item.error = new Error("Canceled manually");
          this.flowOut(item);
        }
      }
    };
    cc.Pipeline = module.exports = Pipeline;
  }), {
    "../platform/js": 138,
    "./loading-items": 105
  } ],
  109: [ (function(require, module, exports) {
    "use strict";
    true;
    var ReleasedAssetChecker = function ReleasedAssetChecker() {
      this._releasedKeys = js.createMap(true);
      this._dirty = false;
    };
    var getItemDesc = function getItemDesc(item) {
      if (item.uuid) {
        tmpInfo || (tmpInfo = {
          path: "",
          type: null
        });
        if (cc.loader._assetTables.assets._getInfo_DEBUG(item.uuid, tmpInfo)) {
          tmpInfo.path = "resources/" + tmpInfo.path;
          return '"' + tmpInfo.path + '" (type: ' + js.getClassName(tmpInfo.type) + ", uuid: " + item.uuid + ")";
        }
        return '"' + item.rawUrl + '" (' + item.uuid + ")";
      }
      return '"' + item.rawUrl + '"';
    };
    var doCheckCouldRelease = function doCheckCouldRelease(releasedKey, refOwnerItem, caches) {
      var loadedAgain = caches[releasedKey];
      loadedAgain || cc.log('"' + releasedKey + '" was released but maybe still referenced by ' + getItemDesc(refOwnerItem));
    };
    var js = require("../platform/js");
    ReleasedAssetChecker.prototype.setReleased = function(item, releasedKey) {
      this._releasedKeys[releasedKey] = true;
      this._dirty = true;
    };
    var tmpInfo = null;
    ReleasedAssetChecker.prototype.checkCouldRelease = function(caches) {
      if (!this._dirty) return;
      this._dirty = false;
      var released = this._releasedKeys;
      for (var id in caches) {
        var item = caches[id];
        item.alias && (item = item.alias);
        var depends = item.dependKeys;
        if (depends) for (var i = 0; i < depends.length; ++i) {
          var depend = depends[i];
          if (released[depend]) {
            doCheckCouldRelease(depend, item, caches);
            delete released[depend];
          }
        }
      }
      js.clear(released);
    };
    module.exports = ReleasedAssetChecker;
  }), {
    "../platform/js": 138
  } ],
  110: [ (function(require, module, exports) {
    "use strict";
    var Pipeline = require("./pipeline");
    var ID = "SubPackPipe";
    var UuidRegex = /.*[/\\][0-9a-fA-F]{2}[/\\]([0-9a-fA-F-]{8,})/;
    function getUuidFromURL(url) {
      var matches = url.match(UuidRegex);
      if (matches) return matches[1];
      return "";
    }
    var _uuidToSubPack = Object.create(null);
    var SubPackPipe = function SubPackPipe(subpackage) {
      this.id = ID;
      this.async = false;
      this.pipeline = null;
      for (var packName in subpackage) {
        var pack = subpackage[packName];
        pack.uuids && pack.uuids.forEach((function(val) {
          _uuidToSubPack[val] = pack.path;
        }));
      }
    };
    SubPackPipe.ID = ID;
    SubPackPipe.prototype.handle = function(item) {
      item.url = this.transformURL(item.url);
      return null;
    };
    SubPackPipe.prototype.transformURL = function(url) {
      var uuid = getUuidFromURL(url);
      if (uuid) {
        var subpackage = _uuidToSubPack[uuid];
        if (subpackage) return url.replace("res/raw-assets/", subpackage + "raw-assets/");
      }
      return url;
    };
    Pipeline.SubPackPipe = module.exports = SubPackPipe;
  }), {
    "./pipeline": 108
  } ],
  111: [ (function(require, module, exports) {
    "use strict";
    var urlAppendTimestamp = require("./utils").urlAppendTimestamp;
    module.exports = function(item, callback) {
      var url = item.url;
      url = urlAppendTimestamp(url);
      var xhr = cc.loader.getXMLHttpRequest(), errInfo = "Load text file failed: " + url;
      xhr.open("GET", url, true);
      xhr.overrideMimeType && xhr.overrideMimeType("text/plain; charset=utf-8");
      xhr.onload = function() {
        4 === xhr.readyState ? 200 === xhr.status || 0 === xhr.status ? callback(null, xhr.responseText) : callback({
          status: xhr.status,
          errorMessage: errInfo + "(wrong status)"
        }) : callback({
          status: xhr.status,
          errorMessage: errInfo + "(wrong readyState)"
        });
      };
      xhr.onerror = function() {
        callback({
          status: xhr.status,
          errorMessage: errInfo + "(error)"
        });
      };
      xhr.ontimeout = function() {
        callback({
          status: xhr.status,
          errorMessage: errInfo + "(time out)"
        });
      };
      xhr.send(null);
    };
  }), {
    "./utils": 113
  } ],
  112: [ (function(require, module, exports) {
    "use strict";
    var Texture2D = require("../assets/CCTexture2D");
    var js = require("../platform/js");
    function JsonUnpacker() {
      this.jsons = {};
    }
    JsonUnpacker.prototype.load = function(indices, packedJson) {
      packedJson.length !== indices.length && cc.errorID(4915);
      for (var i = 0; i < indices.length; i++) {
        var key = indices[i];
        var json = packedJson[i];
        this.jsons[key] = json;
      }
    };
    JsonUnpacker.prototype.retrieve = function(key) {
      return this.jsons[key] || null;
    };
    function TextureUnpacker() {
      this.contents = {};
    }
    TextureUnpacker.ID = js._getClassId(Texture2D);
    TextureUnpacker.prototype.load = function(indices, packedJson) {
      var datas = packedJson.data.split("|");
      datas.length !== indices.length && cc.errorID(4915);
      for (var i = 0; i < indices.length; i++) this.contents[indices[i]] = datas[i];
    };
    TextureUnpacker.prototype.retrieve = function(key) {
      var content = this.contents[key];
      return content ? {
        __type__: TextureUnpacker.ID,
        content: content
      } : null;
    };
    false;
    module.exports = {
      JsonUnpacker: JsonUnpacker,
      TextureUnpacker: TextureUnpacker
    };
  }), {
    "../assets/CCTexture2D": 50,
    "../platform/js": 138
  } ],
  113: [ (function(require, module, exports) {
    "use strict";
    var _noCacheRex = /\?/;
    module.exports = {
      urlAppendTimestamp: function urlAppendTimestamp(url) {
        cc.game.config["noCache"] && "string" === typeof url && (_noCacheRex.test(url) ? url += "&_t=" + (new Date() - 0) : url += "?_t=" + (new Date() - 0));
        return url;
      }
    };
  }), {} ],
  114: [ (function(require, module, exports) {
    "use strict";
    var js = require("../platform/js");
    var debug = require("../CCDebug");
    require("../platform/deserialize");
    var LoadingItems = require("./loading-items");
    function isSceneObj(json) {
      var SCENE_ID = "cc.Scene";
      var PREFAB_ID = "cc.Prefab";
      return json && (json[0] && json[0].__type__ === SCENE_ID || json[1] && json[1].__type__ === SCENE_ID || json[0] && json[0].__type__ === PREFAB_ID);
    }
    function parseDepends(item, asset, tdInfo, deferredLoadRawAssetsInRuntime) {
      var uuidList = tdInfo.uuidList;
      var objList = tdInfo.uuidObjList;
      var propList = tdInfo.uuidPropList;
      var stillUseUrl = tdInfo._stillUseUrl;
      var depends;
      var i, dependUuid;
      var dependKeys = item.dependKeys = [];
      if (deferredLoadRawAssetsInRuntime) {
        depends = [];
        for (i = 0; i < uuidList.length; i++) {
          dependUuid = uuidList[i];
          var obj = objList[i];
          var prop = propList[i];
          var info = cc.AssetLibrary._getAssetInfoInRuntime(dependUuid);
          if (info.raw) {
            var url = info.url;
            obj[prop] = url;
            dependKeys.push(url);
          } else depends.push({
            type: "uuid",
            uuid: dependUuid,
            deferredLoadRaw: true,
            _owner: obj,
            _ownerProp: prop,
            _stillUseUrl: stillUseUrl[i]
          });
        }
      } else {
        depends = new Array(uuidList.length);
        for (i = 0; i < uuidList.length; i++) {
          dependUuid = uuidList[i];
          depends[i] = {
            type: "uuid",
            uuid: dependUuid,
            _owner: objList[i],
            _ownerProp: propList[i],
            _stillUseUrl: stillUseUrl[i]
          };
        }
        asset._native && !asset.constructor.preventPreloadNativeObject && depends.push({
          url: asset.nativeUrl,
          _owner: asset,
          _ownerProp: "_nativeAsset"
        });
      }
      return depends;
    }
    function loadDepends(pipeline, item, asset, depends, callback) {
      item.content = asset;
      var dependKeys = item.dependKeys;
      pipeline.flowInDeps(item, depends, (function(errors, items) {
        var item, missingAssetReporter;
        var itemsMap = items.map;
        for (var src in itemsMap) {
          item = itemsMap[src];
          item.uuid && item.content && (item.content._uuid = item.uuid);
        }
        for (var i = 0; i < depends.length; i++) {
          var loadCallback = function loadCallback(item) {
            var value = item.content;
            this._stillUseUrl && (value = value && cc.RawAsset.wasRawAssetType(value.constructor) ? value.nativeUrl : item.rawUrl);
            "_nativeAsset" === this._ownerProp && (this._owner.url = item.url);
            this._owner[this._ownerProp] = value;
            item.uuid !== asset._uuid && dependKeys.indexOf(item.id) < 0 && dependKeys.push(item.id);
          };
          var dep = depends[i];
          var dependSrc = dep.uuid;
          var dependUrl = dep.url;
          var dependObj = dep._owner;
          var dependProp = dep._ownerProp;
          item = itemsMap[dependUrl];
          if (!item) continue;
          var loadCallbackCtx = dep;
          if (item.complete || item.content) if (item.error) {
            var MissingObjectReporter;
            false;
            cc._throw(item.error.message || item.error.errorMessage || item.error);
          } else loadCallback.call(loadCallbackCtx, item); else {
            var queue = LoadingItems.getQueue(item);
            var list = queue._callbackTable[dependSrc];
            list ? list.unshift(loadCallback, loadCallbackCtx) : queue.addListener(dependSrc, loadCallback, loadCallbackCtx);
          }
        }
        false;
        !errors && asset.onLoad && asset.onLoad();
        callback(errors, asset);
      }));
    }
    function canDeferredLoad(asset, item, isScene) {
      false;
      var res = item.deferredLoadRaw;
      res ? asset instanceof cc.Asset && asset.constructor.preventDeferredLoadDependents && (res = false) : isScene && (asset instanceof cc.SceneAsset || asset instanceof cc.Prefab) && (res = asset.asyncLoadAssets);
      return res;
    }
    var MissingClass;
    function loadUuid(item, callback) {
      false;
      var json;
      if ("string" === typeof item.content) try {
        json = JSON.parse(item.content);
      } catch (e) {
        return new Error(debug.getError(4923, item.id, e.stack));
      } else {
        if ("object" !== typeof item.content) return new Error(debug.getError(4924));
        json = item.content;
      }
      var classFinder;
      var isScene = isSceneObj(json);
      if (isScene) {
        false;
        classFinder = cc._MissingScript.safeFindClass;
      } else classFinder = function classFinder(id) {
        var cls = js._getClassById(id);
        if (cls) return cls;
        cc.warnID(4903, id);
        return Object;
      };
      var tdInfo = cc.deserialize.Details.pool.get();
      var asset;
      try {
        asset = cc.deserialize(json, tdInfo, {
          classFinder: classFinder,
          target: item.existingAsset,
          customEnv: item
        });
      } catch (e) {
        cc.deserialize.Details.pool.put(tdInfo);
        var err = (false, e.stack);
        return new Error(debug.getError(4925, item.id, err));
      }
      asset._uuid = item.uuid;
      asset.url = asset.nativeUrl;
      false;
      var deferredLoad = canDeferredLoad(asset, item, isScene);
      var depends = parseDepends(item, asset, tdInfo, deferredLoad);
      cc.deserialize.Details.pool.put(tdInfo);
      if (0 === depends.length) {
        asset.onLoad && asset.onLoad();
        return callback(null, asset);
      }
      loadDepends(this.pipeline, item, asset, depends, callback);
    }
    module.exports = loadUuid;
    loadUuid.isSceneObj = isSceneObj;
  }), {
    "../CCDebug": 26,
    "../platform/deserialize": 133,
    "../platform/js": 138,
    "./loading-items": 105
  } ],
  115: [ (function(require, module, exports) {
    "use strict";
    var CompScheduler = require("./component-scheduler");
    var Flags = require("./platform/CCObject").Flags;
    var js = require("./platform/js");
    var callerFunctor = false;
    var MAX_POOL_SIZE = 4;
    var IsPreloadStarted = Flags.IsPreloadStarted;
    var IsOnLoadStarted = Flags.IsOnLoadStarted;
    var IsOnLoadCalled = Flags.IsOnLoadCalled;
    var Deactivating = Flags.Deactivating;
    var callPreloadInTryCatch = false;
    var callOnLoadInTryCatch = false;
    var callOnDestroyInTryCatch = false;
    var callResetInTryCatch = false;
    var callOnFocusInTryCatch = false;
    var callOnLostFocusInTryCatch = false;
    var callPreload = function(c) {
      c.__preload();
    };
    var callOnLoad = function(c) {
      c.onLoad();
      c._objFlags |= IsOnLoadCalled;
    };
    var UnsortedInvoker = cc.Class({
      extends: CompScheduler.LifeCycleInvoker,
      add: function add(comp) {
        this._zero.array.push(comp);
      },
      remove: function remove(comp) {
        this._zero.fastRemove(comp);
      },
      cancelInactive: function cancelInactive(flagToClear) {
        CompScheduler.LifeCycleInvoker.stableRemoveInactive(this._zero, flagToClear);
      },
      invoke: function invoke() {
        this._invoke(this._zero);
        this._zero.array.length = 0;
      }
    });
    var invokePreload = CompScheduler.createInvokeImpl(callPreload);
    var invokeOnLoad = CompScheduler.createInvokeImpl(callOnLoad);
    var activateTasksPool = new js.Pool(MAX_POOL_SIZE);
    activateTasksPool.get = function getActivateTask() {
      var task = this._get() || {
        preload: new UnsortedInvoker(invokePreload),
        onLoad: new CompScheduler.OneOffInvoker(invokeOnLoad),
        onEnable: new CompScheduler.OneOffInvoker(CompScheduler.invokeOnEnable)
      };
      task.preload._zero.i = -1;
      var invoker = task.onLoad;
      invoker._zero.i = -1;
      invoker._neg.i = -1;
      invoker._pos.i = -1;
      invoker = task.onEnable;
      invoker._zero.i = -1;
      invoker._neg.i = -1;
      invoker._pos.i = -1;
      return task;
    };
    function _componentCorrupted(node, comp, index) {
      false;
      comp ? node._removeComponent(comp) : js.array.removeAt(node._components, index);
    }
    function _onLoadInEditor(comp) {
      if (comp.onLoad && !cc.engine._isPlaying) {
        var focused = Editor.Selection.curActivate("node") === comp.node.uuid;
        focused ? comp.onFocusInEditor && callOnFocusInTryCatch(comp) : comp.onLostFocusInEditor && callOnLostFocusInTryCatch(comp);
      }
      true;
      _Scene.AssetsWatcher.start(comp);
    }
    function ctor() {
      this._activatingStack = [];
    }
    var NodeActivator = cc.Class({
      ctor: ctor,
      reset: ctor,
      _activateNodeRecursively: function _activateNodeRecursively(node, preloadInvoker, onLoadInvoker, onEnableInvoker) {
        if (node._objFlags & Deactivating) {
          cc.errorID(3816, node.name);
          return;
        }
        node._activeInHierarchy = true;
        var originCount = node._components.length;
        for (var i = 0; i < originCount; ++i) {
          var component = node._components[i];
          if (component instanceof cc.Component) this.activateComp(component, preloadInvoker, onLoadInvoker, onEnableInvoker); else {
            _componentCorrupted(node, component, i);
            --i;
            --originCount;
          }
        }
        node._childArrivalOrder = node._children.length;
        for (var _i = 0, len = node._children.length; _i < len; ++_i) {
          var child = node._children[_i];
          child._localZOrder = 4294901760 & child._localZOrder | _i + 1;
          child._active && this._activateNodeRecursively(child, preloadInvoker, onLoadInvoker, onEnableInvoker);
        }
        node._onPostActivated(true);
      },
      _deactivateNodeRecursively: function _deactivateNodeRecursively(node) {
        false;
        node._objFlags |= Deactivating;
        node._activeInHierarchy = false;
        var originCount = node._components.length;
        for (var c = 0; c < originCount; ++c) {
          var component = node._components[c];
          if (component._enabled) {
            cc.director._compScheduler.disableComp(component);
            if (node._activeInHierarchy) {
              node._objFlags &= ~Deactivating;
              return;
            }
          }
        }
        for (var i = 0, len = node._children.length; i < len; ++i) {
          var child = node._children[i];
          if (child._activeInHierarchy) {
            this._deactivateNodeRecursively(child);
            if (node._activeInHierarchy) {
              node._objFlags &= ~Deactivating;
              return;
            }
          }
        }
        node._onPostActivated(false);
        node._objFlags &= ~Deactivating;
      },
      activateNode: function activateNode(node, active) {
        if (active) {
          var task = activateTasksPool.get();
          this._activatingStack.push(task);
          this._activateNodeRecursively(node, task.preload, task.onLoad, task.onEnable);
          task.preload.invoke();
          task.onLoad.invoke();
          task.onEnable.invoke();
          this._activatingStack.pop();
          activateTasksPool.put(task);
        } else {
          this._deactivateNodeRecursively(node);
          var stack = this._activatingStack;
          for (var i = 0; i < stack.length; i++) {
            var lastTask = stack[i];
            lastTask.preload.cancelInactive(IsPreloadStarted);
            lastTask.onLoad.cancelInactive(IsOnLoadStarted);
            lastTask.onEnable.cancelInactive();
          }
        }
        node.emit("active-in-hierarchy-changed", node);
      },
      activateComp: function(comp, preloadInvoker, onLoadInvoker, onEnableInvoker) {
        if (!cc.isValid(comp, true)) return;
        if (!(comp._objFlags & IsPreloadStarted)) {
          comp._objFlags |= IsPreloadStarted;
          comp.__preload && (preloadInvoker ? preloadInvoker.add(comp) : comp.__preload());
        }
        if (!(comp._objFlags & IsOnLoadStarted)) {
          comp._objFlags |= IsOnLoadStarted;
          if (comp.onLoad) if (onLoadInvoker) onLoadInvoker.add(comp); else {
            comp.onLoad();
            comp._objFlags |= IsOnLoadCalled;
          } else comp._objFlags |= IsOnLoadCalled;
        }
        if (comp._enabled) {
          var deactivatedOnLoading = !comp.node._activeInHierarchy;
          if (deactivatedOnLoading) return;
          cc.director._compScheduler.enableComp(comp, onEnableInvoker);
        }
      },
      destroyComp: function(comp) {
        cc.director._compScheduler.disableComp(comp);
        comp.onDestroy && comp._objFlags & IsOnLoadCalled && comp.onDestroy();
      },
      resetComp: false
    });
    module.exports = NodeActivator;
  }), {
    "./component-scheduler": 57,
    "./platform/CCObject": 124,
    "./platform/js": 138,
    "./utils/misc": 204
  } ],
  116: [ (function(require, module, exports) {
    "use strict";
    var js;
    var macro;
    var sys;
    var eventManager;
    var TOUCH_TIMEOUT;
    var bkInputManager;
    false;
  }), {
    "../event-manager": 84,
    "../platform/js": 138,
    "./CCMacro": 123,
    "./CCSys": 127
  } ],
  117: [ (function(require, module, exports) {
    "use strict";
    var Asset = require("../assets/CCAsset");
    var callInNextTick = require("./utils").callInNextTick;
    var Loader = require("../load-pipeline/CCLoader");
    var AssetTable = require("../load-pipeline/asset-table");
    var PackDownloader = require("../load-pipeline/pack-downloader");
    var AutoReleaseUtils = require("../load-pipeline/auto-release-utils");
    var decodeUuid = require("../utils/decode-uuid");
    var MD5Pipe = require("../load-pipeline/md5-pipe");
    var SubPackPipe = require("../load-pipeline/subpackage-pipe");
    var js = require("./js");
    var _libraryBase = "";
    var _rawAssetsBase = "";
    var _uuidToRawAsset = js.createMap(true);
    function isScene(asset) {
      return asset && (asset.constructor === cc.SceneAsset || asset instanceof cc.Scene);
    }
    function RawAssetEntry(url, type) {
      this.url = url;
      this.type = type;
    }
    var AssetLibrary = {
      loadAsset: function loadAsset(uuid, callback, options) {
        if ("string" !== typeof uuid) return callInNextTick(callback, new Error("[AssetLibrary] uuid must be string"), null);
        var item = {
          uuid: uuid,
          type: "uuid"
        };
        options && options.existingAsset && (item.existingAsset = options.existingAsset);
        Loader.load(item, (function(error, asset) {
          if (error || !asset) error = new Error("[AssetLibrary] loading JSON or dependencies failed: " + (error ? error.message : "Unknown error")); else {
            if (asset.constructor === cc.SceneAsset) {
              false;
              var key = cc.loader._getReferenceKey(uuid);
              asset.scene.dependAssets = AutoReleaseUtils.getDependsRecursively(key);
            }
            if (false, isScene(asset)) {
              var id = cc.loader._getReferenceKey(uuid);
              Loader.removeItem(id);
            }
          }
          callback && callback(error, asset);
        }));
      },
      getLibUrlNoExt: function getLibUrlNoExt(uuid, inRawAssetsDir) {
        true;
        uuid = decodeUuid(uuid);
        var base = (true, inRawAssetsDir ? _rawAssetsBase + "assets/" : _libraryBase);
        return base + uuid.slice(0, 2) + "/" + uuid;
      },
      _queryAssetInfoInEditor: function _queryAssetInfoInEditor(uuid, callback) {
        false;
      },
      _getAssetInfoInRuntime: function _getAssetInfoInRuntime(uuid, result) {
        result = result || {
          url: null,
          raw: false
        };
        var info = _uuidToRawAsset[uuid];
        if (info && !js.isChildClassOf(info.type, cc.Asset)) {
          result.url = _rawAssetsBase + info.url;
          result.raw = true;
        } else {
          result.url = this.getLibUrlNoExt(uuid) + ".json";
          result.raw = false;
        }
        return result;
      },
      _uuidInSettings: function _uuidInSettings(uuid) {
        return uuid in _uuidToRawAsset;
      },
      queryAssetInfo: function queryAssetInfo(uuid, callback) {
        false;
        var info = this._getAssetInfoInRuntime(uuid);
        callback(null, info.url, info.raw);
      },
      parseUuidInEditor: function parseUuidInEditor(url) {
        var uuid;
        var isImported;
        var dir;
        var dirBasename;
        var isAssetUrl;
        var index;
        false;
      },
      loadJson: function loadJson(json, callback) {
        var randomUuid = "" + (new Date().getTime() + Math.random());
        var item = {
          uuid: randomUuid,
          type: "uuid",
          content: json,
          skips: [ Loader.assetLoader.id, Loader.downloader.id ]
        };
        Loader.load(item, (function(error, asset) {
          if (error) error = new Error("[AssetLibrary] loading JSON or dependencies failed: " + error.message); else {
            if (asset.constructor === cc.SceneAsset) {
              var key = cc.loader._getReferenceKey(randomUuid);
              asset.scene.dependAssets = AutoReleaseUtils.getDependsRecursively(key);
            }
            if (false, isScene(asset)) {
              var id = cc.loader._getReferenceKey(randomUuid);
              Loader.removeItem(id);
            }
          }
          asset._uuid = "";
          callback && callback(error, asset);
        }));
      },
      getAssetByUuid: function getAssetByUuid(uuid) {
        return AssetLibrary._uuidToAsset[uuid] || null;
      },
      init: function init(options) {
        false;
        var libraryPath = options.libraryPath;
        libraryPath = libraryPath.replace(/\\/g, "/");
        _libraryBase = cc.path.stripSep(libraryPath) + "/";
        _rawAssetsBase = options.rawAssetsBase;
        if (options.subpackages) {
          var subPackPipe = new SubPackPipe(options.subpackages);
          cc.loader.insertPipeAfter(cc.loader.assetLoader, subPackPipe);
          cc.loader.subPackPipe = subPackPipe;
        }
        var md5AssetsMap = options.md5AssetsMap;
        if (md5AssetsMap && md5AssetsMap.import) {
          var i = 0, uuid = 0;
          var md5ImportMap = js.createMap(true);
          var md5Entries = md5AssetsMap.import;
          for (i = 0; i < md5Entries.length; i += 2) {
            uuid = decodeUuid(md5Entries[i]);
            md5ImportMap[uuid] = md5Entries[i + 1];
          }
          var md5RawAssetsMap = js.createMap(true);
          md5Entries = md5AssetsMap["raw-assets"];
          for (i = 0; i < md5Entries.length; i += 2) {
            uuid = decodeUuid(md5Entries[i]);
            md5RawAssetsMap[uuid] = md5Entries[i + 1];
          }
          var md5Pipe = new MD5Pipe(md5ImportMap, md5RawAssetsMap, _libraryBase);
          cc.loader.insertPipeAfter(cc.loader.assetLoader, md5Pipe);
          cc.loader.md5Pipe = md5Pipe;
        }
        var assetTables = Loader._assetTables;
        for (var mount in assetTables) assetTables[mount].reset();
        var rawAssets = options.rawAssets;
        if (rawAssets) for (var mountPoint in rawAssets) {
          var assets = rawAssets[mountPoint];
          for (var uuid in assets) {
            var info = assets[uuid];
            var url = info[0];
            var typeId = info[1];
            var type = cc.js._getClassById(typeId);
            if (!type) {
              cc.error("Cannot get", typeId);
              continue;
            }
            _uuidToRawAsset[uuid] = new RawAssetEntry(mountPoint + "/" + url, type);
            var ext = cc.path.extname(url);
            ext && (url = url.slice(0, -ext.length));
            var isSubAsset = 1 === info[2];
            assetTables[mountPoint] || (assetTables[mountPoint] = new AssetTable());
            assetTables[mountPoint].add(url, uuid, type, !isSubAsset);
          }
        }
        options.packedAssets && PackDownloader.initPacks(options.packedAssets);
        cc.url._init(options.mountPaths && options.mountPaths.assets || _rawAssetsBase + "assets");
      }
    };
    AssetLibrary._uuidToAsset = {};
    var _builtins = {
      effect: {},
      material: {}
    };
    function loadBuiltins(name, type, cb) {
      var dirname = name + "s";
      var builtin = _builtins[name] = {};
      var internalMountPath = "internal";
      false;
      cc.loader.loadResDir(dirname, type, internalMountPath, (function() {}), (function(err, assets) {
        if (err) cc.error(err); else for (var i = 0; i < assets.length; i++) builtin["" + assets[i].name] = assets[i];
        cb();
      }));
    }
    AssetLibrary._loadBuiltins = function(cb) {
      if (cc.game.renderType === cc.game.RENDER_TYPE_CANVAS) return cb && cb();
      loadBuiltins("effect", cc.EffectAsset, (function() {
        loadBuiltins("material", cc.Material, cb);
      }));
    };
    AssetLibrary.getBuiltin = function(type, name) {
      return _builtins[type][name];
    };
    AssetLibrary.getBuiltins = function(type) {
      if (!type) return _builtins;
      return _builtins[type];
    };
    AssetLibrary.resetBuiltins = function() {
      _builtins = {
        effect: {},
        material: {}
      };
    };
    module.exports = cc.AssetLibrary = AssetLibrary;
  }), {
    "../assets/CCAsset": 33,
    "../load-pipeline/CCLoader": 95,
    "../load-pipeline/asset-table": 97,
    "../load-pipeline/auto-release-utils": 99,
    "../load-pipeline/md5-pipe": 106,
    "../load-pipeline/pack-downloader": 107,
    "../load-pipeline/subpackage-pipe": 110,
    "../utils/decode-uuid": 198,
    "./js": 138,
    "./utils": 142
  } ],
  118: [ (function(require, module, exports) {
    "use strict";
    var js = require("./js");
    var Enum = require("./CCEnum");
    var utils = require("./utils");
    var _isPlainEmptyObj_DEV = utils.isPlainEmptyObj_DEV;
    var _cloneable_DEV = utils.cloneable_DEV;
    var Attr = require("./attribute");
    var DELIMETER = Attr.DELIMETER;
    var getTypeChecker = Attr.getTypeChecker;
    var preprocess = require("./preprocess-class");
    require("./requiring-frame");
    var BUILTIN_ENTRIES = [ "name", "extends", "mixins", "ctor", "__ctor__", "properties", "statics", "editor", "__ES6__" ];
    var INVALID_STATICS_DEV = false;
    function pushUnique(array, item) {
      array.indexOf(item) < 0 && array.push(item);
    }
    var deferredInitializer = {
      datas: null,
      push: function push(data) {
        if (this.datas) this.datas.push(data); else {
          this.datas = [ data ];
          var self = this;
          setTimeout((function() {
            self.init();
          }), 0);
        }
      },
      init: function init() {
        var datas = this.datas;
        if (datas) {
          for (var i = 0; i < datas.length; ++i) {
            var data = datas[i];
            var cls = data.cls;
            var properties = data.props;
            "function" === typeof properties && (properties = properties());
            var name = js.getClassName(cls);
            properties ? declareProperties(cls, name, properties, cls.$super, data.mixins) : cc.errorID(3633, name);
          }
          this.datas = null;
        }
      }
    };
    function appendProp(cls, name) {
      false;
      pushUnique(cls.__props__, name);
    }
    var tmpArray = [];
    function defineProp(cls, className, propName, val, es6) {
      var defaultValue = val.default;
      false;
      Attr.setClassAttr(cls, propName, "default", defaultValue);
      appendProp(cls, propName);
      var attrs = parseAttributes(cls, val, className, propName, false);
      if (attrs) {
        var onAfterProp = tmpArray;
        for (var i = 0; i < attrs.length; i++) {
          var attr = attrs[i];
          Attr.attr(cls, propName, attr);
          attr._onAfterProp && onAfterProp.push(attr._onAfterProp);
        }
        for (var c = 0; c < onAfterProp.length; c++) onAfterProp[c](cls, propName);
        tmpArray.length = 0;
        attrs.length = 0;
      }
    }
    function defineGetSet(cls, name, propName, val, es6) {
      var getter = val.get;
      var setter = val.set;
      var proto = cls.prototype;
      var d = Object.getOwnPropertyDescriptor(proto, propName);
      var setterUndefined = !d;
      if (getter) {
        false;
        var attrs = parseAttributes(cls, val, name, propName, true);
        for (var i = 0; i < attrs.length; i++) Attr.attr(cls, propName, attrs[i]);
        attrs.length = 0;
        Attr.setClassAttr(cls, propName, "serializable", false);
        false;
        es6 || js.get(proto, propName, getter, setterUndefined, setterUndefined);
        false, false;
      }
      if (setter) {
        if (!es6) {
          false;
          js.set(proto, propName, setter, setterUndefined, setterUndefined);
        }
        false, false;
      }
    }
    function getDefault(defaultVal) {
      if ("function" === typeof defaultVal) {
        false;
        return defaultVal();
      }
      return defaultVal;
    }
    function mixinWithInherited(dest, src, filter) {
      for (var prop in src) dest.hasOwnProperty(prop) || filter && !filter(prop) || Object.defineProperty(dest, prop, js.getPropertyDescriptor(src, prop));
    }
    function doDefine(className, baseClass, mixins, options) {
      var shouldAddProtoCtor;
      var __ctor__ = options.__ctor__;
      var ctor = options.ctor;
      var __es6__ = options.__ES6__;
      var ctorToUse;
      false;
      var ctors;
      var fireClass;
      if (__es6__) {
        ctors = [ ctor ];
        fireClass = ctor;
      } else {
        ctors = __ctor__ ? [ __ctor__ ] : _getAllCtors(baseClass, mixins, options);
        fireClass = _createCtor(ctors, baseClass, className, options);
        js.value(fireClass, "extend", (function(options) {
          options.extends = this;
          return CCClass(options);
        }), true);
      }
      js.value(fireClass, "__ctors__", ctors.length > 0 ? ctors : null, true);
      var prototype = fireClass.prototype;
      if (baseClass) {
        if (!__es6__) {
          js.extend(fireClass, baseClass);
          prototype = fireClass.prototype;
        }
        fireClass.$super = baseClass;
        false;
      }
      if (mixins) {
        for (var m = mixins.length - 1; m >= 0; m--) {
          var mixin = mixins[m];
          mixinWithInherited(prototype, mixin.prototype);
          mixinWithInherited(fireClass, mixin, (function(prop) {
            return mixin.hasOwnProperty(prop) && true;
          }));
          CCClass._isCCClass(mixin) && mixinWithInherited(Attr.getClassAttrs(fireClass).constructor.prototype, Attr.getClassAttrs(mixin).constructor.prototype);
        }
        prototype.constructor = fireClass;
      }
      __es6__ || (prototype.__initProps__ = compileProps);
      js.setClassName(className, fireClass);
      return fireClass;
    }
    function define(className, baseClass, mixins, options) {
      var Component = cc.Component;
      var frame = cc._RF.peek();
      if (frame && js.isChildClassOf(baseClass, Component)) {
        if (js.isChildClassOf(frame.cls, Component)) {
          cc.errorID(3615);
          return null;
        }
        false;
        className = className || frame.script;
      }
      var cls = doDefine(className, baseClass, mixins, options);
      if (frame) if (js.isChildClassOf(baseClass, Component)) {
        var uuid = frame.uuid;
        if (uuid) {
          js._setClassId(uuid, cls);
          false;
        }
        frame.cls = cls;
      } else js.isChildClassOf(frame.cls, Component) || (frame.cls = cls);
      return cls;
    }
    function normalizeClassName_DEV(className) {
      var DefaultName = "CCClass";
      if (className) {
        className = className.replace(/^[^$A-Za-z_]/, "_").replace(/[^0-9A-Za-z_$]/g, "_");
        try {
          Function("function " + className + "(){}")();
          return className;
        } catch (e) {}
      }
      return DefaultName;
    }
    function getNewValueTypeCodeJit(value) {
      var clsName = js.getClassName(value);
      var type = value.constructor;
      var res = "new " + clsName + "(";
      for (var i = 0; i < type.__props__.length; i++) {
        var prop = type.__props__[i];
        var propVal = value[prop];
        false;
        res += propVal;
        i < type.__props__.length - 1 && (res += ",");
      }
      return res + ")";
    }
    function escapeForJS(s) {
      return JSON.stringify(s).replace(/\u2028/g, "\\u2028").replace(/\u2029/g, "\\u2029");
    }
    function getInitPropsJit(attrs, propList) {
      var F = [];
      var func = "";
      for (var i = 0; i < propList.length; i++) {
        var prop = propList[i];
        var attrKey = prop + DELIMETER + "default";
        if (attrKey in attrs) {
          var statement;
          statement = IDENTIFIER_RE.test(prop) ? "this." + prop + "=" : "this[" + escapeForJS(prop) + "]=";
          var expression;
          var def = attrs[attrKey];
          if ("object" === typeof def && def) expression = def instanceof cc.ValueType ? getNewValueTypeCodeJit(def) : Array.isArray(def) ? "[]" : "{}"; else if ("function" === typeof def) {
            var index = F.length;
            F.push(def);
            expression = "F[" + index + "]()";
            false;
          } else expression = "string" === typeof def ? escapeForJS(def) : def;
          statement = statement + expression + ";\n";
          func += statement;
        }
      }
      var initProps;
      initProps = 0 === F.length ? Function(func) : Function("F", "return (function(){\n" + func + "})")(F);
      return initProps;
    }
    function getInitProps(attrs, propList) {
      var advancedProps = [];
      var advancedValues = [];
      var simpleProps = [];
      var simpleValues = [];
      for (var i = 0; i < propList.length; ++i) {
        var prop = propList[i];
        var attrKey = prop + DELIMETER + "default";
        if (attrKey in attrs) {
          var def = attrs[attrKey];
          if ("object" === typeof def && def || "function" === typeof def) {
            advancedProps.push(prop);
            advancedValues.push(def);
          } else {
            simpleProps.push(prop);
            simpleValues.push(def);
          }
        }
      }
      return function() {
        for (var _i = 0; _i < simpleProps.length; ++_i) this[simpleProps[_i]] = simpleValues[_i];
        for (var _i2 = 0; _i2 < advancedProps.length; _i2++) {
          var _prop = advancedProps[_i2];
          var expression;
          var def = advancedValues[_i2];
          if ("object" === typeof def) expression = def instanceof cc.ValueType ? def.clone() : Array.isArray(def) ? [] : {}; else {
            false;
            expression = def();
          }
          this[_prop] = expression;
        }
      };
    }
    var IDENTIFIER_RE = /^[A-Za-z_$][0-9A-Za-z_$]*$/;
    function compileProps(actualClass) {
      var attrs = Attr.getClassAttrs(actualClass);
      var propList = actualClass.__props__;
      if (null === propList) {
        deferredInitializer.init();
        propList = actualClass.__props__;
      }
      var initProps = getInitProps(attrs, propList);
      actualClass.prototype.__initProps__ = initProps;
      initProps.call(this);
    }
    var _createCtor = function(ctors, baseClass, className, options) {
      var superCallBounded = baseClass && boundSuperCalls(baseClass, options, className);
      var ctorLen = ctors.length;
      var _Class5;
      _Class5 = ctorLen > 0 ? superCallBounded ? 2 === ctorLen ? function Class() {
        this._super = null;
        this.__initProps__(_Class5);
        ctors[0].apply(this, arguments);
        ctors[1].apply(this, arguments);
      } : function _Class() {
        this._super = null;
        this.__initProps__(_Class5);
        for (var i = 0; i < ctors.length; ++i) ctors[i].apply(this, arguments);
      } : 3 === ctorLen ? function _Class2() {
        this.__initProps__(_Class5);
        ctors[0].apply(this, arguments);
        ctors[1].apply(this, arguments);
        ctors[2].apply(this, arguments);
      } : function _Class3() {
        this.__initProps__(_Class5);
        var ctors = _Class5.__ctors__;
        for (var i = 0; i < ctors.length; ++i) ctors[i].apply(this, arguments);
      } : function _Class4() {
        superCallBounded && (this._super = null);
        this.__initProps__(_Class5);
      };
      return _Class5;
    };
    function _validateCtor_DEV(ctor, baseClass, className, options) {
      var originCtor;
      false;
      !(ctor.length > 0) || className && className.startsWith("cc.") || cc.warnID(3617, className);
      return ctor;
    }
    function _getAllCtors(baseClass, mixins, options) {
      function getCtors(cls) {
        return CCClass._isCCClass(cls) ? cls.__ctors__ || [] : [ cls ];
      }
      var ctors = [];
      var baseOrMixins = [ baseClass ].concat(mixins);
      for (var b = 0; b < baseOrMixins.length; b++) {
        var baseOrMixin = baseOrMixins[b];
        if (baseOrMixin) {
          var baseCtors = getCtors(baseOrMixin);
          for (var c = 0; c < baseCtors.length; c++) pushUnique(ctors, baseCtors[c]);
        }
      }
      var ctor = options.ctor;
      ctor && ctors.push(ctor);
      return ctors;
    }
    var SuperCallReg = /xyz/.test((function() {
      xyz;
    })) ? /\b\._super\b/ : /.*/;
    var SuperCallRegStrict = /xyz/.test((function() {
      xyz;
    })) ? /this\._super\s*\(/ : /(NONE){99}/;
    function boundSuperCalls(baseClass, options, className) {
      var hasSuperCall = false;
      for (var funcName in options) {
        if (BUILTIN_ENTRIES.indexOf(funcName) >= 0) continue;
        var func = options[funcName];
        if ("function" !== typeof func) continue;
        var pd = js.getPropertyDescriptor(baseClass.prototype, funcName);
        if (pd) {
          var superFunc = pd.value;
          if ("function" === typeof superFunc) {
            if (SuperCallReg.test(func)) {
              hasSuperCall = true;
              options[funcName] = (function(superFunc, func) {
                return function() {
                  var tmp = this._super;
                  this._super = superFunc;
                  var ret = func.apply(this, arguments);
                  this._super = tmp;
                  return ret;
                };
              })(superFunc, func);
            }
            continue;
          }
        }
        false;
      }
      return hasSuperCall;
    }
    function declareProperties(cls, className, properties, baseClass, mixins, es6) {
      cls.__props__ = [];
      baseClass && baseClass.__props__ && (cls.__props__ = baseClass.__props__.slice());
      if (mixins) for (var m = 0; m < mixins.length; ++m) {
        var mixin = mixins[m];
        mixin.__props__ && (cls.__props__ = cls.__props__.concat(mixin.__props__.filter((function(x) {
          return cls.__props__.indexOf(x) < 0;
        }))));
      }
      if (properties) {
        preprocess.preprocessAttrs(properties, className, cls, es6);
        for (var propName in properties) {
          var val = properties[propName];
          "default" in val ? defineProp(cls, className, propName, val, es6) : defineGetSet(cls, className, propName, val, es6);
        }
      }
      var attrs = Attr.getClassAttrs(cls);
      cls.__values__ = cls.__props__.filter((function(prop) {
        return false !== attrs[prop + DELIMETER + "serializable"];
      }));
    }
    function CCClass(options) {
      options = options || {};
      var name = options.name;
      var base = options.extends;
      var mixins = options.mixins;
      var cls = define(name, base, mixins, options);
      name || (name = cc.js.getClassName(cls));
      cls._sealed = true;
      base && (base._sealed = false);
      var properties = options.properties;
      if ("function" === typeof properties || base && null === base.__props__ || mixins && mixins.some((function(x) {
        return null === x.__props__;
      }))) {
        false;
        deferredInitializer.push({
          cls: cls,
          props: properties,
          mixins: mixins
        });
        cls.__props__ = cls.__values__ = null;
      } else declareProperties(cls, name, properties, base, options.mixins, options.__ES6__);
      var statics = options.statics;
      if (statics) {
        var staticPropName;
        false;
        for (staticPropName in statics) cls[staticPropName] = statics[staticPropName];
      }
      for (var funcName in options) {
        if (BUILTIN_ENTRIES.indexOf(funcName) >= 0) continue;
        var func = options[funcName];
        if (!preprocess.validateMethodWithProps(func, funcName, name, cls, base)) continue;
        js.value(cls.prototype, funcName, func, true, true);
      }
      var editor = options.editor;
      editor && !!js.isChildClassOf(base, cc.Component) && cc.Component._registerEditorProps(cls, editor);
      return cls;
    }
    CCClass._isCCClass = function(constructor) {
      return constructor && constructor.hasOwnProperty("__ctors__");
    };
    CCClass._fastDefine = function(className, constructor, serializableFields) {
      js.setClassName(className, constructor);
      var props = constructor.__props__ = constructor.__values__ = Object.keys(serializableFields);
      var attrProtos = Attr.getClassAttrsProto(constructor);
      for (var i = 0; i < props.length; i++) {
        var key = props[i];
        attrProtos[key + DELIMETER + "visible"] = false;
        attrProtos[key + DELIMETER + "default"] = serializableFields[key];
      }
    };
    CCClass.Attr = Attr;
    CCClass.attr = Attr.attr;
    CCClass.getInheritanceChain = function(klass) {
      var chain = [];
      for (;;) {
        klass = js.getSuper(klass);
        if (!klass) break;
        klass !== Object && chain.push(klass);
      }
      return chain;
    };
    var PrimitiveTypes = {
      Integer: "Number",
      Float: "Number",
      Boolean: "Boolean",
      String: "String"
    };
    var tmpAttrs = [];
    function parseAttributes(cls, attrs, className, propName, usedInGetter) {
      var ERR_Type = "";
      var attrsProto = null;
      var attrsProtoKey = "";
      function getAttrsProto() {
        attrsProtoKey = propName + DELIMETER;
        return attrsProto = Attr.getClassAttrsProto(cls);
      }
      tmpAttrs.length = 0;
      var result = tmpAttrs;
      var type = attrs.type;
      if (type) {
        var primitiveType = PrimitiveTypes[type];
        if (primitiveType) result.push({
          type: type,
          _onAfterProp: getTypeChecker(primitiveType, "cc." + type)
        }); else if ("Object" === type) false; else if (type === Attr.ScriptUuid) {
          var attr = Attr.ObjectType(cc.ScriptAsset);
          attr.type = "Script";
          result.push(attr);
        } else "object" === typeof type ? !!Enum.isEnum(type) && result.push({
          type: "Enum",
          enumList: Enum.getList(type)
        }) : "function" === typeof type && (attrs.url ? result.push({
          type: "Object",
          ctor: type,
          _onAfterProp: getTypeChecker("String", "cc.String")
        }) : result.push(attrs._short ? {
          type: "Object",
          ctor: type
        } : Attr.ObjectType(type)));
      }
      function parseSimpleAttr(attrName, expectType) {
        if (attrName in attrs) {
          var val = attrs[attrName];
          typeof val === expectType && ((attrsProto || getAttrsProto())[attrsProtoKey + attrName] = val);
        }
      }
      if (attrs.editorOnly) {
        false;
        (attrsProto || getAttrsProto())[attrsProtoKey + "editorOnly"] = true;
      }
      false;
      attrs.url && ((attrsProto || getAttrsProto())[attrsProtoKey + "saveUrlAsAsset"] = true);
      if (false === attrs.serializable) {
        false;
        (attrsProto || getAttrsProto())[attrsProtoKey + "serializable"] = false;
      }
      parseSimpleAttr("formerlySerializedAs", "string");
      false;
      var visible;
      var startsWithUS;
      false;
      var range = attrs.range;
      if (range) if (Array.isArray(range)) if (range.length >= 2) {
        (attrsProto || getAttrsProto())[attrsProtoKey + "min"] = range[0];
        attrsProto[attrsProtoKey + "max"] = range[1];
        range.length > 2 && (attrsProto[attrsProtoKey + "step"] = range[2]);
      } else false; else false;
      parseSimpleAttr("min", "number");
      parseSimpleAttr("max", "number");
      parseSimpleAttr("step", "number");
      return result;
    }
    cc.Class = CCClass;
    module.exports = {
      isArray: function isArray(defaultVal) {
        defaultVal = getDefault(defaultVal);
        return Array.isArray(defaultVal);
      },
      fastDefine: CCClass._fastDefine,
      getNewValueTypeCode: false,
      IDENTIFIER_RE: IDENTIFIER_RE,
      escapeForJS: escapeForJS,
      getDefault: getDefault
    };
    false;
  }), {
    "./CCEnum": 120,
    "./attribute": 130,
    "./js": 138,
    "./preprocess-class": 139,
    "./requiring-frame": 140,
    "./utils": 142
  } ],
  119: [ (function(require, module, exports) {
    "use strict";
    require("./CCClass");
    var Preprocess = require("./preprocess-class");
    var js = require("./js");
    var isPlainEmptyObj_DEV = false;
    var CACHE_KEY = "__ccclassCache__";
    function fNOP(ctor) {
      return ctor;
    }
    function getSubDict(obj, key) {
      return obj[key] || (obj[key] = {});
    }
    function checkCtorArgument(decorate) {
      return function(target) {
        if ("function" === typeof target) return decorate(target);
        return function(ctor) {
          return decorate(ctor, target);
        };
      };
    }
    function _checkNormalArgument(validator_DEV, decorate, decoratorName) {
      return function(target) {
        false;
        return function(ctor) {
          return decorate(ctor, target);
        };
      };
    }
    var checkCompArgument = _checkNormalArgument.bind(null, false);
    function _argumentChecker(type) {
      return _checkNormalArgument.bind(null, false);
    }
    var checkStringArgument = _argumentChecker("string");
    var checkNumberArgument = _argumentChecker("number");
    function getClassCache(ctor, decoratorName) {
      false;
      return getSubDict(ctor, CACHE_KEY);
    }
    function getDefaultFromInitializer(initializer) {
      var value;
      try {
        value = initializer();
      } catch (e) {
        return initializer;
      }
      return "object" !== typeof value || null === value ? value : initializer;
    }
    function extractActualDefaultValues(ctor) {
      var dummyObj;
      try {
        dummyObj = new ctor();
      } catch (e) {
        false;
        return {};
      }
      return dummyObj;
    }
    function genProperty(ctor, properties, propName, options, desc, cache) {
      var fullOptions;
      if (options) {
        fullOptions = Preprocess.getFullFormOfProperty(options);
        fullOptions = fullOptions || options;
      }
      var existsProperty = properties[propName];
      var prop = js.mixin(existsProperty || {}, fullOptions || {});
      var isGetset = desc && (desc.get || desc.set);
      if (isGetset) {
        var errorProps;
        false;
        desc.get && (prop.get = desc.get);
        desc.set && (prop.set = desc.set);
      } else {
        false;
        var defaultValue = void 0;
        var isDefaultValueSpecified = false;
        if (desc) {
          if (desc.initializer) {
            defaultValue = getDefaultFromInitializer(desc.initializer);
            isDefaultValueSpecified = true;
          }
        } else {
          var actualDefaultValues = cache.default || (cache.default = extractActualDefaultValues(ctor));
          if (actualDefaultValues.hasOwnProperty(propName)) {
            defaultValue = actualDefaultValues[propName];
            isDefaultValueSpecified = true;
          }
        }
        false;
        prop.default = defaultValue;
      }
      properties[propName] = prop;
    }
    var ccclass = checkCtorArgument((function(ctor, name) {
      var base = js.getSuper(ctor);
      base === Object && (base = null);
      var proto = {
        name: name,
        extends: base,
        ctor: ctor,
        __ES6__: true
      };
      var cache = ctor[CACHE_KEY];
      if (cache) {
        var decoratedProto = cache.proto;
        decoratedProto && js.mixin(proto, decoratedProto);
        ctor[CACHE_KEY] = void 0;
      }
      var res = cc.Class(proto);
      var propNames;
      var i;
      var prop;
      var desc;
      var func;
      false;
      return res;
    }));
    function property(ctorProtoOrOptions, propName, desc) {
      var options = null;
      function normalized(ctorProto, propName, desc) {
        var cache = getClassCache(ctorProto.constructor);
        if (cache) {
          var ccclassProto = getSubDict(cache, "proto");
          var properties = getSubDict(ccclassProto, "properties");
          genProperty(ctorProto.constructor, properties, propName, options, desc, cache);
        }
      }
      if ("undefined" === typeof propName) {
        options = ctorProtoOrOptions;
        return normalized;
      }
      normalized(ctorProtoOrOptions, propName, desc);
    }
    function createEditorDecorator(argCheckFunc, editorPropName, staticValue) {
      return argCheckFunc((function(ctor, decoratedValue) {
        var cache = getClassCache(ctor, editorPropName);
        if (cache) {
          var value = void 0 !== staticValue ? staticValue : decoratedValue;
          var proto = getSubDict(cache, "proto");
          getSubDict(proto, "editor")[editorPropName] = value;
        }
      }), editorPropName);
    }
    function createDummyDecorator(argCheckFunc) {
      return argCheckFunc(fNOP);
    }
    var executeInEditMode = createDummyDecorator(checkCtorArgument, "executeInEditMode", true);
    var requireComponent = createEditorDecorator(checkCompArgument, "requireComponent");
    var menu = createDummyDecorator(checkStringArgument, "menu");
    var executionOrder = createEditorDecorator(checkNumberArgument, "executionOrder");
    var disallowMultiple = createDummyDecorator(checkCtorArgument, "disallowMultiple");
    var playOnFocus = createDummyDecorator(checkCtorArgument, "playOnFocus", true);
    var inspector = createDummyDecorator(checkStringArgument, "inspector");
    var icon = createDummyDecorator(checkStringArgument, "icon");
    var help = createDummyDecorator(checkStringArgument, "help");
    function mixins() {
      var mixins = [];
      for (var i = 0; i < arguments.length; i++) mixins[i] = arguments[i];
      return function(ctor) {
        var cache = getClassCache(ctor, "mixins");
        cache && (getSubDict(cache, "proto").mixins = mixins);
      };
    }
    cc._decorator = module.exports = {
      ccclass: ccclass,
      property: property,
      executeInEditMode: executeInEditMode,
      requireComponent: requireComponent,
      menu: menu,
      executionOrder: executionOrder,
      disallowMultiple: disallowMultiple,
      playOnFocus: playOnFocus,
      inspector: inspector,
      icon: icon,
      help: help,
      mixins: mixins
    };
  }), {
    "./CCClass": 118,
    "./js": 138,
    "./preprocess-class": 139,
    "./utils": 142
  } ],
  120: [ (function(require, module, exports) {
    "use strict";
    var js = require("./js");
    function Enum(obj) {
      if ("__enums__" in obj) return obj;
      js.value(obj, "__enums__", null, true);
      var lastIndex = -1;
      var keys = Object.keys(obj);
      for (var i = 0; i < keys.length; i++) {
        var key = keys[i];
        var val = obj[key];
        if (-1 === val) {
          val = ++lastIndex;
          obj[key] = val;
        } else if ("number" === typeof val) lastIndex = val; else if ("string" === typeof val && Number.isInteger(parseFloat(key))) continue;
        var reverseKey = "" + val;
        if (key !== reverseKey) {
          if ((false, false) && reverseKey in obj && obj[reverseKey] !== key) {
            cc.errorID(7100, reverseKey);
            continue;
          }
          js.value(obj, reverseKey, key);
        }
      }
      return obj;
    }
    Enum.isEnum = function(enumType) {
      return enumType && enumType.hasOwnProperty("__enums__");
    };
    Enum.getList = function(enumDef) {
      if (enumDef.__enums__) return enumDef.__enums__;
      var enums = enumDef.__enums__ = [];
      for (var name in enumDef) {
        var value = enumDef[name];
        Number.isInteger(value) && enums.push({
          name: name,
          value: value
        });
      }
      enums.sort((function(a, b) {
        return a.value - b.value;
      }));
      return enums;
    };
    var _TestEnum;
    false;
    module.exports = cc.Enum = Enum;
  }), {
    "./js": 138
  } ],
  121: [ (function(require, module, exports) {
    "use strict";
    var eventManager = require("../event-manager");
    var inputManager = require("./CCInputManager");
    var PORTRAIT = 0;
    var LANDSCAPE_LEFT = -90;
    var PORTRAIT_UPSIDE_DOWN = 180;
    var LANDSCAPE_RIGHT = 90;
    var _didAccelerateFun = void 0;
    cc.Acceleration = function(x, y, z, timestamp) {
      this.x = x || 0;
      this.y = y || 0;
      this.z = z || 0;
      this.timestamp = timestamp || 0;
    };
    inputManager.setAccelerometerEnabled = function(isEnable) {
      var _t = this;
      if (_t._accelEnabled === isEnable) return;
      _t._accelEnabled = isEnable;
      var scheduler = cc.director.getScheduler();
      scheduler.enableForTarget(_t);
      if (_t._accelEnabled) {
        _t._registerAccelerometerEvent();
        _t._accelCurTime = 0;
        scheduler.scheduleUpdate(_t);
      } else {
        _t._unregisterAccelerometerEvent();
        _t._accelCurTime = 0;
        scheduler.unscheduleUpdate(_t);
      }
      false, false;
    };
    inputManager.setAccelerometerInterval = function(interval) {
      if (this._accelInterval !== interval) {
        this._accelInterval = interval;
        false, false;
      }
    };
    inputManager._registerKeyboardEvent = function() {
      cc.game.canvas.addEventListener("keydown", (function(e) {
        eventManager.dispatchEvent(new cc.Event.EventKeyboard(e.keyCode, true));
        e.stopPropagation();
        e.preventDefault();
      }), false);
      cc.game.canvas.addEventListener("keyup", (function(e) {
        eventManager.dispatchEvent(new cc.Event.EventKeyboard(e.keyCode, false));
        e.stopPropagation();
        e.preventDefault();
      }), false);
    };
    inputManager._registerAccelerometerEvent = function() {
      var w = window, _t = this;
      _t._acceleration = new cc.Acceleration();
      _t._accelDeviceEvent = w.DeviceMotionEvent || w.DeviceOrientationEvent;
      cc.sys.browserType === cc.sys.BROWSER_TYPE_MOBILE_QQ && (_t._accelDeviceEvent = window.DeviceOrientationEvent);
      var _deviceEventType = _t._accelDeviceEvent === w.DeviceMotionEvent ? "devicemotion" : "deviceorientation";
      var ua = navigator.userAgent;
      (/Android/.test(ua) || /Adr/.test(ua) && cc.sys.browserType === cc.BROWSER_TYPE_UC) && (_t._minus = -1);
      _didAccelerateFun = _t.didAccelerate.bind(_t);
      w.addEventListener(_deviceEventType, _didAccelerateFun, false);
    };
    inputManager._unregisterAccelerometerEvent = function() {
      var w = window, _t = this;
      var _deviceEventType = _t._accelDeviceEvent === w.DeviceMotionEvent ? "devicemotion" : "deviceorientation";
      _didAccelerateFun && w.removeEventListener(_deviceEventType, _didAccelerateFun, false);
    };
    inputManager.didAccelerate = function(eventData) {
      var _t = this, w = window;
      if (!_t._accelEnabled) return;
      var mAcceleration = _t._acceleration;
      var x = void 0, y = void 0, z = void 0;
      if (_t._accelDeviceEvent === window.DeviceMotionEvent) {
        var eventAcceleration = eventData["accelerationIncludingGravity"];
        x = _t._accelMinus * eventAcceleration.x * .1;
        y = _t._accelMinus * eventAcceleration.y * .1;
        z = .1 * eventAcceleration.z;
      } else {
        x = eventData["gamma"] / 90 * .981;
        y = -eventData["beta"] / 90 * .981;
        z = eventData["alpha"] / 90 * .981;
      }
      if (cc.view._isRotated) {
        var tmp = x;
        x = -y;
        y = tmp;
      }
      mAcceleration.x = x;
      mAcceleration.y = y;
      mAcceleration.z = z;
      mAcceleration.timestamp = eventData.timeStamp || Date.now();
      var tmpX = mAcceleration.x;
      if (w.orientation === LANDSCAPE_RIGHT) {
        mAcceleration.x = -mAcceleration.y;
        mAcceleration.y = tmpX;
      } else if (w.orientation === LANDSCAPE_LEFT) {
        mAcceleration.x = mAcceleration.y;
        mAcceleration.y = -tmpX;
      } else if (w.orientation === PORTRAIT_UPSIDE_DOWN) {
        mAcceleration.x = -mAcceleration.x;
        mAcceleration.y = -mAcceleration.y;
      }
      if (cc.sys.os === cc.sys.OS_ANDROID && cc.sys.browserType !== cc.sys.BROWSER_TYPE_MOBILE_QQ) {
        mAcceleration.x = -mAcceleration.x;
        mAcceleration.y = -mAcceleration.y;
      }
    };
  }), {
    "../event-manager": 84,
    "./CCInputManager": 122
  } ],
  122: [ (function(require, module, exports) {
    "use strict";
    var macro = require("./CCMacro");
    var sys = require("./CCSys");
    var eventManager = require("../event-manager");
    var TOUCH_TIMEOUT = macro.TOUCH_TIMEOUT;
    var _vec2 = cc.v2();
    var inputManager = {
      _mousePressed: false,
      _isRegisterEvent: false,
      _preTouchPoint: cc.v2(0, 0),
      _prevMousePoint: cc.v2(0, 0),
      _preTouchPool: [],
      _preTouchPoolPointer: 0,
      _touches: [],
      _touchesIntegerDict: {},
      _indexBitsUsed: 0,
      _maxTouches: 8,
      _accelEnabled: false,
      _accelInterval: .2,
      _accelMinus: 1,
      _accelCurTime: 0,
      _acceleration: null,
      _accelDeviceEvent: null,
      _getUnUsedIndex: function _getUnUsedIndex() {
        var temp = this._indexBitsUsed;
        var now = cc.sys.now();
        for (var i = 0; i < this._maxTouches; i++) {
          if (!(1 & temp)) {
            this._indexBitsUsed |= 1 << i;
            return i;
          }
          var touch = this._touches[i];
          if (now - touch._lastModified > TOUCH_TIMEOUT) {
            this._removeUsedIndexBit(i);
            delete this._touchesIntegerDict[touch.getID()];
            return i;
          }
          temp >>= 1;
        }
        return -1;
      },
      _removeUsedIndexBit: function _removeUsedIndexBit(index) {
        if (index < 0 || index >= this._maxTouches) return;
        var temp = 1 << index;
        temp = ~temp;
        this._indexBitsUsed &= temp;
      },
      _glView: null,
      handleTouchesBegin: function handleTouchesBegin(touches) {
        var selTouch = void 0, index = void 0, curTouch = void 0, touchID = void 0, handleTouches = [], locTouchIntDict = this._touchesIntegerDict, now = sys.now();
        for (var i = 0, len = touches.length; i < len; i++) {
          selTouch = touches[i];
          touchID = selTouch.getID();
          index = locTouchIntDict[touchID];
          if (null == index) {
            var unusedIndex = this._getUnUsedIndex();
            if (-1 === unusedIndex) {
              cc.logID(2300, unusedIndex);
              continue;
            }
            curTouch = this._touches[unusedIndex] = new cc.Touch(selTouch._point.x, selTouch._point.y, selTouch.getID());
            curTouch._lastModified = now;
            curTouch._setPrevPoint(selTouch._prevPoint);
            locTouchIntDict[touchID] = unusedIndex;
            handleTouches.push(curTouch);
          }
        }
        if (handleTouches.length > 0) {
          this._glView._convertTouchesWithScale(handleTouches);
          var touchEvent = new cc.Event.EventTouch(handleTouches);
          touchEvent._eventCode = cc.Event.EventTouch.BEGAN;
          eventManager.dispatchEvent(touchEvent);
        }
      },
      handleTouchesMove: function handleTouchesMove(touches) {
        var selTouch = void 0, index = void 0, touchID = void 0, handleTouches = [], locTouches = this._touches, now = sys.now();
        for (var i = 0, len = touches.length; i < len; i++) {
          selTouch = touches[i];
          touchID = selTouch.getID();
          index = this._touchesIntegerDict[touchID];
          if (null == index) continue;
          if (locTouches[index]) {
            locTouches[index]._setPoint(selTouch._point);
            locTouches[index]._setPrevPoint(selTouch._prevPoint);
            locTouches[index]._lastModified = now;
            handleTouches.push(locTouches[index]);
          }
        }
        if (handleTouches.length > 0) {
          this._glView._convertTouchesWithScale(handleTouches);
          var touchEvent = new cc.Event.EventTouch(handleTouches);
          touchEvent._eventCode = cc.Event.EventTouch.MOVED;
          eventManager.dispatchEvent(touchEvent);
        }
      },
      handleTouchesEnd: function handleTouchesEnd(touches) {
        var handleTouches = this.getSetOfTouchesEndOrCancel(touches);
        if (handleTouches.length > 0) {
          this._glView._convertTouchesWithScale(handleTouches);
          var touchEvent = new cc.Event.EventTouch(handleTouches);
          touchEvent._eventCode = cc.Event.EventTouch.ENDED;
          eventManager.dispatchEvent(touchEvent);
        }
        this._preTouchPool.length = 0;
      },
      handleTouchesCancel: function handleTouchesCancel(touches) {
        var handleTouches = this.getSetOfTouchesEndOrCancel(touches);
        if (handleTouches.length > 0) {
          this._glView._convertTouchesWithScale(handleTouches);
          var touchEvent = new cc.Event.EventTouch(handleTouches);
          touchEvent._eventCode = cc.Event.EventTouch.CANCELLED;
          eventManager.dispatchEvent(touchEvent);
        }
        this._preTouchPool.length = 0;
      },
      getSetOfTouchesEndOrCancel: function getSetOfTouchesEndOrCancel(touches) {
        var selTouch = void 0, index = void 0, touchID = void 0, handleTouches = [], locTouches = this._touches, locTouchesIntDict = this._touchesIntegerDict;
        for (var i = 0, len = touches.length; i < len; i++) {
          selTouch = touches[i];
          touchID = selTouch.getID();
          index = locTouchesIntDict[touchID];
          if (null == index) continue;
          if (locTouches[index]) {
            locTouches[index]._setPoint(selTouch._point);
            locTouches[index]._setPrevPoint(selTouch._prevPoint);
            handleTouches.push(locTouches[index]);
            this._removeUsedIndexBit(index);
            delete locTouchesIntDict[touchID];
          }
        }
        return handleTouches;
      },
      getHTMLElementPosition: function getHTMLElementPosition(element) {
        true;
        return {
          left: 0,
          top: 0,
          width: window.innerWidth,
          height: window.innerHeight
        };
        var docElem;
        var leftOffset;
        var topOffset;
        var box;
      },
      getPreTouch: function getPreTouch(touch) {
        var preTouch = null;
        var locPreTouchPool = this._preTouchPool;
        var id = touch.getID();
        for (var i = locPreTouchPool.length - 1; i >= 0; i--) if (locPreTouchPool[i].getID() === id) {
          preTouch = locPreTouchPool[i];
          break;
        }
        preTouch || (preTouch = touch);
        return preTouch;
      },
      setPreTouch: function setPreTouch(touch) {
        var find = false;
        var locPreTouchPool = this._preTouchPool;
        var id = touch.getID();
        for (var i = locPreTouchPool.length - 1; i >= 0; i--) if (locPreTouchPool[i].getID() === id) {
          locPreTouchPool[i] = touch;
          find = true;
          break;
        }
        if (!find) if (locPreTouchPool.length <= 50) locPreTouchPool.push(touch); else {
          locPreTouchPool[this._preTouchPoolPointer] = touch;
          this._preTouchPoolPointer = (this._preTouchPoolPointer + 1) % 50;
        }
      },
      getTouchByXY: function getTouchByXY(tx, ty, pos) {
        var locPreTouch = this._preTouchPoint;
        var location = this._glView.convertToLocationInView(tx, ty, pos);
        var touch = new cc.Touch(location.x, location.y, 0);
        touch._setPrevPoint(locPreTouch.x, locPreTouch.y);
        locPreTouch.x = location.x;
        locPreTouch.y = location.y;
        return touch;
      },
      getMouseEvent: function getMouseEvent(location, pos, eventType) {
        var locPreMouse = this._prevMousePoint;
        var mouseEvent = new cc.Event.EventMouse(eventType);
        mouseEvent._setPrevCursor(locPreMouse.x, locPreMouse.y);
        locPreMouse.x = location.x;
        locPreMouse.y = location.y;
        this._glView._convertMouseToLocationInView(locPreMouse, pos);
        mouseEvent.setLocation(locPreMouse.x, locPreMouse.y);
        return mouseEvent;
      },
      getPointByEvent: function getPointByEvent(event, pos) {
        if (null != event.pageX) return {
          x: event.pageX,
          y: event.pageY
        };
        true;
        pos.left = 0;
        pos.top = 0;
        return {
          x: event.clientX,
          y: event.clientY
        };
      },
      getTouchesByEvent: function getTouchesByEvent(event, pos) {
        var touchArr = [], locView = this._glView;
        var touch_event = void 0, touch = void 0, preLocation = void 0;
        var locPreTouch = this._preTouchPoint;
        var length = event.changedTouches.length;
        for (var i = 0; i < length; i++) {
          touch_event = event.changedTouches[i];
          if (touch_event) {
            var location = void 0;
            location = sys.BROWSER_TYPE_FIREFOX === sys.browserType ? locView.convertToLocationInView(touch_event.pageX, touch_event.pageY, pos, _vec2) : locView.convertToLocationInView(touch_event.clientX, touch_event.clientY, pos, _vec2);
            if (null != touch_event.identifier) {
              touch = new cc.Touch(location.x, location.y, touch_event.identifier);
              preLocation = this.getPreTouch(touch).getLocation();
              touch._setPrevPoint(preLocation.x, preLocation.y);
              this.setPreTouch(touch);
            } else {
              touch = new cc.Touch(location.x, location.y);
              touch._setPrevPoint(locPreTouch.x, locPreTouch.y);
            }
            locPreTouch.x = location.x;
            locPreTouch.y = location.y;
            touchArr.push(touch);
          }
        }
        return touchArr;
      },
      registerSystemEvent: function registerSystemEvent(element) {
        if (this._isRegisterEvent) return;
        this._glView = cc.view;
        var selfPointer = this;
        var prohibition = sys.isMobile;
        var supportMouse = "mouse" in sys.capabilities;
        var supportTouches = "touches" in sys.capabilities;
        true;
        prohibition = false;
        supportTouches = true;
        supportMouse = false;
        if (supportMouse) {
          if (!prohibition) {
            window.addEventListener("mousedown", (function() {
              selfPointer._mousePressed = true;
            }), false);
            window.addEventListener("mouseup", (function(event) {
              if (!selfPointer._mousePressed) return;
              selfPointer._mousePressed = false;
              var pos = selfPointer.getHTMLElementPosition(element);
              var location = selfPointer.getPointByEvent(event, pos);
              if (!cc.rect(pos.left, pos.top, pos.width, pos.height).contains(location)) {
                selfPointer.handleTouchesEnd([ selfPointer.getTouchByXY(location.x, location.y, pos) ]);
                var mouseEvent = selfPointer.getMouseEvent(location, pos, cc.Event.EventMouse.UP);
                mouseEvent.setButton(event.button);
                eventManager.dispatchEvent(mouseEvent);
              }
            }), false);
          }
          var EventMouse = cc.Event.EventMouse;
          var _mouseEventsOnElement = [ !prohibition && [ "mousedown", EventMouse.DOWN, function(event, mouseEvent, location, pos) {
            selfPointer._mousePressed = true;
            selfPointer.handleTouchesBegin([ selfPointer.getTouchByXY(location.x, location.y, pos) ]);
            element.focus();
          } ], !prohibition && [ "mouseup", EventMouse.UP, function(event, mouseEvent, location, pos) {
            selfPointer._mousePressed = false;
            selfPointer.handleTouchesEnd([ selfPointer.getTouchByXY(location.x, location.y, pos) ]);
          } ], !prohibition && [ "mousemove", EventMouse.MOVE, function(event, mouseEvent, location, pos) {
            selfPointer.handleTouchesMove([ selfPointer.getTouchByXY(location.x, location.y, pos) ]);
            selfPointer._mousePressed || mouseEvent.setButton(null);
          } ], [ "mousewheel", EventMouse.SCROLL, function(event, mouseEvent) {
            mouseEvent.setScrollData(0, event.wheelDelta);
          } ], [ "DOMMouseScroll", EventMouse.SCROLL, function(event, mouseEvent) {
            mouseEvent.setScrollData(0, -120 * event.detail);
          } ] ];
          for (var i = 0; i < _mouseEventsOnElement.length; ++i) {
            var entry = _mouseEventsOnElement[i];
            entry && (function() {
              var name = entry[0];
              var type = entry[1];
              var handler = entry[2];
              element.addEventListener(name, (function(event) {
                var pos = selfPointer.getHTMLElementPosition(element);
                var location = selfPointer.getPointByEvent(event, pos);
                var mouseEvent = selfPointer.getMouseEvent(location, pos, type);
                mouseEvent.setButton(event.button);
                handler(event, mouseEvent, location, pos);
                eventManager.dispatchEvent(mouseEvent);
                event.stopPropagation();
                event.preventDefault();
              }), false);
            })();
          }
        }
        if (window.navigator.msPointerEnabled) {
          var _pointerEventsMap = {
            MSPointerDown: selfPointer.handleTouchesBegin,
            MSPointerMove: selfPointer.handleTouchesMove,
            MSPointerUp: selfPointer.handleTouchesEnd,
            MSPointerCancel: selfPointer.handleTouchesCancel
          };
          var _loop = function _loop(eventName) {
            var touchEvent = _pointerEventsMap[eventName];
            element.addEventListener(eventName, (function(event) {
              var pos = selfPointer.getHTMLElementPosition(element);
              pos.left -= document.documentElement.scrollLeft;
              pos.top -= document.documentElement.scrollTop;
              touchEvent.call(selfPointer, [ selfPointer.getTouchByXY(event.clientX, event.clientY, pos) ]);
              event.stopPropagation();
            }), false);
          };
          for (var eventName in _pointerEventsMap) _loop(eventName);
        }
        if (supportTouches) {
          var _touchEventsMap = {
            touchstart: function touchstart(touchesToHandle) {
              selfPointer.handleTouchesBegin(touchesToHandle);
              false;
            },
            touchmove: function touchmove(touchesToHandle) {
              selfPointer.handleTouchesMove(touchesToHandle);
            },
            touchend: function touchend(touchesToHandle) {
              selfPointer.handleTouchesEnd(touchesToHandle);
            },
            touchcancel: function touchcancel(touchesToHandle) {
              selfPointer.handleTouchesCancel(touchesToHandle);
            }
          };
          var registerTouchEvent = void 0;
          if (cc.sys.browserType === cc.sys.BROWSER_TYPE_WECHAT_GAME_SUB) {
            _touchEventsMap = {
              onTouchStart: _touchEventsMap.touchstart,
              onTouchMove: _touchEventsMap.touchmove,
              onTouchEnd: _touchEventsMap.touchend,
              onTouchCancel: _touchEventsMap.touchcancel
            };
            registerTouchEvent = function registerTouchEvent(eventName) {
              var handler = _touchEventsMap[eventName];
              wx[eventName]((function(event) {
                if (!event.changedTouches) return;
                var pos = selfPointer.getHTMLElementPosition(element);
                var body = document.body;
                pos.left -= body.scrollLeft || 0;
                pos.top -= body.scrollTop || 0;
                handler(selfPointer.getTouchesByEvent(event, pos));
              }));
            };
          } else registerTouchEvent = function registerTouchEvent(eventName) {
            var handler = _touchEventsMap[eventName];
            element.addEventListener(eventName, (function(event) {
              if (!event.changedTouches) return;
              var pos = selfPointer.getHTMLElementPosition(element);
              var body = document.body;
              pos.left -= body.scrollLeft || 0;
              pos.top -= body.scrollTop || 0;
              handler(selfPointer.getTouchesByEvent(event, pos));
              event.stopPropagation();
              event.preventDefault();
            }), false);
          };
          for (var eventName in _touchEventsMap) registerTouchEvent(eventName);
        }
        cc.sys.browserType !== cc.sys.BROWSER_TYPE_WECHAT_GAME_SUB && this._registerKeyboardEvent();
        this._isRegisterEvent = true;
      },
      _registerKeyboardEvent: function _registerKeyboardEvent() {},
      _registerAccelerometerEvent: function _registerAccelerometerEvent() {},
      update: function update(dt) {
        if (this._accelCurTime > this._accelInterval) {
          this._accelCurTime -= this._accelInterval;
          eventManager.dispatchEvent(new cc.Event.EventAcceleration(this._acceleration));
        }
        this._accelCurTime += dt;
      }
    };
    module.exports = _cc.inputManager = inputManager;
  }), {
    "../event-manager": 84,
    "./CCMacro": 123,
    "./CCSys": 127
  } ],
  123: [ (function(require, module, exports) {
    "use strict";
    var js = require("./js");
    cc.macro = {
      RAD: Math.PI / 180,
      DEG: 180 / Math.PI,
      REPEAT_FOREVER: Number.MAX_VALUE - 1,
      FLT_EPSILON: 1.192092896e-7,
      MIN_ZINDEX: -Math.pow(2, 15),
      MAX_ZINDEX: Math.pow(2, 15) - 1,
      ONE: 1,
      ZERO: 0,
      SRC_ALPHA: 770,
      SRC_ALPHA_SATURATE: 776,
      SRC_COLOR: 768,
      DST_ALPHA: 772,
      DST_COLOR: 774,
      ONE_MINUS_SRC_ALPHA: 771,
      ONE_MINUS_SRC_COLOR: 769,
      ONE_MINUS_DST_ALPHA: 773,
      ONE_MINUS_DST_COLOR: 775,
      ONE_MINUS_CONSTANT_ALPHA: 32772,
      ONE_MINUS_CONSTANT_COLOR: 32770,
      ORIENTATION_PORTRAIT: 1,
      ORIENTATION_LANDSCAPE: 2,
      ORIENTATION_AUTO: 3,
      DENSITYDPI_DEVICE: "device-dpi",
      DENSITYDPI_HIGH: "high-dpi",
      DENSITYDPI_MEDIUM: "medium-dpi",
      DENSITYDPI_LOW: "low-dpi",
      FIX_ARTIFACTS_BY_STRECHING_TEXEL_TMX: true,
      DIRECTOR_STATS_POSITION: cc.v2(0, 0),
      ENABLE_STACKABLE_ACTIONS: true,
      TOUCH_TIMEOUT: 5e3,
      BATCH_VERTEX_COUNT: 2e4,
      ENABLE_TILEDMAP_CULLING: true,
      DOWNLOAD_MAX_CONCURRENT: 64,
      ENABLE_TRANSPARENT_CANVAS: false,
      ENABLE_WEBGL_ANTIALIAS: false,
      ENABLE_CULLING: false,
      CLEANUP_IMAGE_CACHE: false,
      SHOW_MESH_WIREFRAME: false,
      ROTATE_ACTION_CCW: false
    };
    var SUPPORT_TEXTURE_FORMATS = [ ".pkm", ".pvr", ".webp", ".jpg", ".jpeg", ".bmp", ".png" ];
    cc.macro.SUPPORT_TEXTURE_FORMATS = SUPPORT_TEXTURE_FORMATS;
    cc.macro.KEY = {
      none: 0,
      back: 6,
      menu: 18,
      backspace: 8,
      tab: 9,
      enter: 13,
      shift: 16,
      ctrl: 17,
      alt: 18,
      pause: 19,
      capslock: 20,
      escape: 27,
      space: 32,
      pageup: 33,
      pagedown: 34,
      end: 35,
      home: 36,
      left: 37,
      up: 38,
      right: 39,
      down: 40,
      select: 41,
      insert: 45,
      Delete: 46,
      0: 48,
      1: 49,
      2: 50,
      3: 51,
      4: 52,
      5: 53,
      6: 54,
      7: 55,
      8: 56,
      9: 57,
      a: 65,
      b: 66,
      c: 67,
      d: 68,
      e: 69,
      f: 70,
      g: 71,
      h: 72,
      i: 73,
      j: 74,
      k: 75,
      l: 76,
      m: 77,
      n: 78,
      o: 79,
      p: 80,
      q: 81,
      r: 82,
      s: 83,
      t: 84,
      u: 85,
      v: 86,
      w: 87,
      x: 88,
      y: 89,
      z: 90,
      num0: 96,
      num1: 97,
      num2: 98,
      num3: 99,
      num4: 100,
      num5: 101,
      num6: 102,
      num7: 103,
      num8: 104,
      num9: 105,
      "*": 106,
      "+": 107,
      "-": 109,
      numdel: 110,
      "/": 111,
      f1: 112,
      f2: 113,
      f3: 114,
      f4: 115,
      f5: 116,
      f6: 117,
      f7: 118,
      f8: 119,
      f9: 120,
      f10: 121,
      f11: 122,
      f12: 123,
      numlock: 144,
      scrolllock: 145,
      ";": 186,
      semicolon: 186,
      equal: 187,
      "=": 187,
      ",": 188,
      comma: 188,
      dash: 189,
      ".": 190,
      period: 190,
      forwardslash: 191,
      grave: 192,
      "[": 219,
      openbracket: 219,
      backslash: 220,
      "]": 221,
      closebracket: 221,
      quote: 222,
      dpadLeft: 1e3,
      dpadRight: 1001,
      dpadUp: 1003,
      dpadDown: 1004,
      dpadCenter: 1005
    };
    cc.macro.ImageFormat = cc.Enum({
      JPG: 0,
      PNG: 1,
      TIFF: 2,
      WEBP: 3,
      PVR: 4,
      ETC: 5,
      S3TC: 6,
      ATITC: 7,
      TGA: 8,
      RAWDATA: 9,
      UNKNOWN: 10
    });
    cc.macro.BlendFactor = cc.Enum({
      ONE: 1,
      ZERO: 0,
      SRC_ALPHA: 770,
      SRC_COLOR: 768,
      DST_ALPHA: 772,
      DST_COLOR: 774,
      ONE_MINUS_SRC_ALPHA: 771,
      ONE_MINUS_SRC_COLOR: 769,
      ONE_MINUS_DST_ALPHA: 773,
      ONE_MINUS_DST_COLOR: 775
    });
    cc.macro.TextAlignment = cc.Enum({
      LEFT: 0,
      CENTER: 1,
      RIGHT: 2
    });
    cc.macro.VerticalTextAlignment = cc.Enum({
      TOP: 0,
      CENTER: 1,
      BOTTOM: 2
    });
    module.exports = cc.macro;
  }), {
    "./js": 138
  } ],
  124: [ (function(require, module, exports) {
    "use strict";
    var js = require("./js");
    var CCClass = require("./CCClass");
    var Destroyed = 1;
    var RealDestroyed = 2;
    var ToDestroy = 4;
    var DontSave = 8;
    var EditorOnly = 16;
    var Dirty = 32;
    var DontDestroy = 64;
    var Destroying = 128;
    var Deactivating = 256;
    var LockedInEditor = 512;
    var HideInHierarchy = 1024;
    var IsOnEnableCalled = 2048;
    var IsEditorOnEnableCalled = 4096;
    var IsPreloadStarted = 8192;
    var IsOnLoadCalled = 16384;
    var IsOnLoadStarted = 32768;
    var IsStartCalled = 65536;
    var IsRotationLocked = 1 << 17;
    var IsScaleLocked = 1 << 18;
    var IsAnchorLocked = 1 << 19;
    var IsSizeLocked = 1 << 20;
    var IsPositionLocked = 1 << 21;
    var PersistentMask = ~(ToDestroy | Dirty | Destroying | DontDestroy | Deactivating | IsPreloadStarted | IsOnLoadStarted | IsOnLoadCalled | IsStartCalled | IsOnEnableCalled | IsEditorOnEnableCalled | IsRotationLocked | IsScaleLocked | IsAnchorLocked | IsSizeLocked | IsPositionLocked);
    function CCObject() {
      this._name = "";
      this._objFlags = 0;
    }
    CCClass.fastDefine("cc.Object", CCObject, {
      _name: "",
      _objFlags: 0
    });
    js.value(CCObject, "Flags", {
      Destroyed: Destroyed,
      DontSave: DontSave,
      EditorOnly: EditorOnly,
      Dirty: Dirty,
      DontDestroy: DontDestroy,
      PersistentMask: PersistentMask,
      Destroying: Destroying,
      Deactivating: Deactivating,
      LockedInEditor: LockedInEditor,
      HideInHierarchy: HideInHierarchy,
      IsPreloadStarted: IsPreloadStarted,
      IsOnLoadStarted: IsOnLoadStarted,
      IsOnLoadCalled: IsOnLoadCalled,
      IsOnEnableCalled: IsOnEnableCalled,
      IsStartCalled: IsStartCalled,
      IsEditorOnEnableCalled: IsEditorOnEnableCalled,
      IsPositionLocked: IsPositionLocked,
      IsRotationLocked: IsRotationLocked,
      IsScaleLocked: IsScaleLocked,
      IsAnchorLocked: IsAnchorLocked,
      IsSizeLocked: IsSizeLocked
    });
    var objectsToDestroy = [];
    function deferredDestroy() {
      var deleteCount = objectsToDestroy.length;
      for (var i = 0; i < deleteCount; ++i) {
        var obj = objectsToDestroy[i];
        obj._objFlags & Destroyed || obj._destroyImmediate();
      }
      deleteCount === objectsToDestroy.length ? objectsToDestroy.length = 0 : objectsToDestroy.splice(0, deleteCount);
      false;
    }
    js.value(CCObject, "_deferredDestroy", deferredDestroy);
    false;
    var prototype = CCObject.prototype;
    js.getset(prototype, "name", (function() {
      return this._name;
    }), (function(value) {
      this._name = value;
    }), true);
    js.get(prototype, "isValid", (function() {
      return !(this._objFlags & Destroyed);
    }), true);
    false, false;
    var deferredDestroyTimer = null;
    prototype.destroy = function() {
      if (this._objFlags & Destroyed) {
        cc.warnID(5e3);
        return false;
      }
      if (this._objFlags & ToDestroy) return false;
      this._objFlags |= ToDestroy;
      objectsToDestroy.push(this);
      false;
      return true;
    };
    false, false;
    function compileDestruct(obj, ctor) {
      var shouldSkipId = obj instanceof cc._BaseNode || obj instanceof cc.Component;
      var idToSkip = shouldSkipId ? "_id" : null;
      var key, propsToReset = {};
      for (key in obj) if (obj.hasOwnProperty(key)) {
        if (key === idToSkip) continue;
        switch (typeof obj[key]) {
         case "string":
          propsToReset[key] = "";
          break;

         case "object":
         case "function":
          propsToReset[key] = null;
        }
      }
      if (cc.Class._isCCClass(ctor)) {
        var attrs = cc.Class.Attr.getClassAttrs(ctor);
        var propList = ctor.__props__;
        for (var i = 0; i < propList.length; i++) {
          key = propList[i];
          var attrKey = key + cc.Class.Attr.DELIMETER + "default";
          if (attrKey in attrs) {
            if (shouldSkipId && "_id" === key) continue;
            switch (typeof attrs[attrKey]) {
             case "string":
              propsToReset[key] = "";
              break;

             case "object":
             case "function":
              propsToReset[key] = null;
              break;

             case "undefined":
              propsToReset[key] = void 0;
            }
          }
        }
      }
      var func;
      var statement;
      var val;
      false;
      return function(o) {
        for (var key in propsToReset) o[key] = propsToReset[key];
      };
    }
    prototype._destruct = function() {
      var ctor = this.constructor;
      var destruct = ctor.__destruct__;
      if (!destruct) {
        destruct = compileDestruct(this, ctor);
        js.value(ctor, "__destruct__", destruct, true);
      }
      destruct(this);
    };
    prototype._onPreDestroy = null;
    prototype._destroyImmediate = function() {
      if (this._objFlags & Destroyed) {
        cc.errorID(5e3);
        return;
      }
      this._onPreDestroy && this._onPreDestroy();
      true;
      this._destruct();
      this._objFlags |= Destroyed;
    };
    false;
    prototype._deserialize = null;
    cc.isValid = function(value, strictMode) {
      return "object" === typeof value ? !!value && !(value._objFlags & (strictMode ? Destroyed | ToDestroy : Destroyed)) : "undefined" !== typeof value;
    };
    false, false;
    cc.Object = module.exports = CCObject;
  }), {
    "./CCClass": 118,
    "./js": 138
  } ],
  125: [ (function(require, module, exports) {
    "use strict";
    var js = require("../platform/js");
    cc.SAXParser = function() {
      if (true, window.DOMParser) {
        this._isSupportDOMParser = true;
        this._parser = new DOMParser();
      } else {
        this._isSupportDOMParser = false;
        this._parser = null;
      }
    };
    cc.SAXParser.prototype = {
      constructor: cc.SAXParser,
      parse: function parse(xmlTxt) {
        return this._parseXML(xmlTxt);
      },
      _parseXML: function _parseXML(textxml) {
        var xmlDoc;
        if (this._isSupportDOMParser) xmlDoc = this._parser.parseFromString(textxml, "text/xml"); else {
          xmlDoc = new ActiveXObject("Microsoft.XMLDOM");
          xmlDoc.async = "false";
          xmlDoc.loadXML(textxml);
        }
        return xmlDoc;
      }
    };
    cc.PlistParser = function() {
      cc.SAXParser.call(this);
    };
    js.extend(cc.PlistParser, cc.SAXParser);
    js.mixin(cc.PlistParser.prototype, {
      parse: function parse(xmlTxt) {
        var xmlDoc = this._parseXML(xmlTxt);
        var plist = xmlDoc.documentElement;
        if ("plist" !== plist.tagName) {
          cc.warnID(5100);
          return {};
        }
        var node = null;
        for (var i = 0, len = plist.childNodes.length; i < len; i++) {
          node = plist.childNodes[i];
          if (1 === node.nodeType) break;
        }
        xmlDoc = null;
        return this._parseNode(node);
      },
      _parseNode: function _parseNode(node) {
        var data = null, tagName = node.tagName;
        if ("dict" === tagName) data = this._parseDict(node); else if ("array" === tagName) data = this._parseArray(node); else if ("string" === tagName) if (1 === node.childNodes.length) data = node.firstChild.nodeValue; else {
          data = "";
          for (var i = 0; i < node.childNodes.length; i++) data += node.childNodes[i].nodeValue;
        } else "false" === tagName ? data = false : "true" === tagName ? data = true : "real" === tagName ? data = parseFloat(node.firstChild.nodeValue) : "integer" === tagName && (data = parseInt(node.firstChild.nodeValue, 10));
        return data;
      },
      _parseArray: function _parseArray(node) {
        var data = [];
        for (var i = 0, len = node.childNodes.length; i < len; i++) {
          var child = node.childNodes[i];
          if (1 !== child.nodeType) continue;
          data.push(this._parseNode(child));
        }
        return data;
      },
      _parseDict: function _parseDict(node) {
        var data = {};
        var key = null;
        for (var i = 0, len = node.childNodes.length; i < len; i++) {
          var child = node.childNodes[i];
          if (1 !== child.nodeType) continue;
          "key" === child.tagName ? key = child.firstChild.nodeValue : data[key] = this._parseNode(child);
        }
        return data;
      }
    });
    cc.saxParser = new cc.SAXParser();
    cc.plistParser = new cc.PlistParser();
    module.exports = {
      saxParser: cc.saxParser,
      plistParser: cc.plistParser
    };
  }), {
    "../platform/js": 138
  } ],
  126: [ (function(require, module, exports) {
    "use strict";
    cc.screen = {
      _supportsFullScreen: false,
      _onfullscreenchange: null,
      _onfullscreenerror: null,
      _preOnFullScreenChange: null,
      _preOnFullScreenError: null,
      _preOnTouch: null,
      _touchEvent: "",
      _fn: null,
      _fnMap: [ [ "requestFullscreen", "exitFullscreen", "fullscreenchange", "fullscreenEnabled", "fullscreenElement", "fullscreenerror" ], [ "requestFullScreen", "exitFullScreen", "fullScreenchange", "fullScreenEnabled", "fullScreenElement", "fullscreenerror" ], [ "webkitRequestFullScreen", "webkitCancelFullScreen", "webkitfullscreenchange", "webkitIsFullScreen", "webkitCurrentFullScreenElement", "webkitfullscreenerror" ], [ "mozRequestFullScreen", "mozCancelFullScreen", "mozfullscreenchange", "mozFullScreen", "mozFullScreenElement", "mozfullscreenerror" ], [ "msRequestFullscreen", "msExitFullscreen", "MSFullscreenChange", "msFullscreenEnabled", "msFullscreenElement", "msfullscreenerror" ] ],
      init: function init() {
        this._fn = {};
        var i, l, val, map = this._fnMap, valL;
        for (i = 0, l = map.length; i < l; i++) {
          val = map[i];
          if (val && "undefined" !== typeof document[val[1]]) {
            for (i = 0, valL = val.length; i < valL; i++) this._fn[map[0][i]] = val[i];
            break;
          }
        }
        this._supportsFullScreen = void 0 !== this._fn.requestFullscreen;
        this._touchEvent = "ontouchend" in window ? "touchend" : "mousedown";
      },
      fullScreen: function fullScreen() {
        return !!this._supportsFullScreen && !!(document[this._fn.fullscreenElement] || document[this._fn.webkitFullscreenElement] || document[this._fn.mozFullScreenElement]);
      },
      requestFullScreen: function requestFullScreen(element, onFullScreenChange, onFullScreenError) {
        if (element && "video" === element.tagName.toLowerCase()) {
          if (cc.sys.os === cc.sys.OS_IOS && cc.sys.isBrowser && element.readyState > 0) {
            element.webkitEnterFullscreen && element.webkitEnterFullscreen();
            return;
          }
          element.setAttribute("x5-video-player-fullscreen", "true");
        }
        if (!this._supportsFullScreen) return;
        element = element || document.documentElement;
        if (onFullScreenChange) {
          var eventName = this._fn.fullscreenchange;
          this._onfullscreenchange && document.removeEventListener(eventName, this._onfullscreenchange);
          this._onfullscreenchange = onFullScreenChange;
          document.addEventListener(eventName, onFullScreenChange, false);
        }
        if (onFullScreenError) {
          var _eventName = this._fn.fullscreenerror;
          this._onfullscreenerror && document.removeEventListener(_eventName, this._onfullscreenerror);
          this._onfullscreenerror = onFullScreenError;
          document.addEventListener(_eventName, onFullScreenError, {
            once: true
          });
        }
        element[this._fn.requestFullscreen]();
      },
      exitFullScreen: function exitFullScreen(element) {
        if (element && "video" === element.tagName.toLowerCase()) {
          if (cc.sys.os === cc.sys.OS_IOS && cc.sys.isBrowser) {
            element.webkitExitFullscreen && element.webkitExitFullscreen();
            return;
          }
          element.setAttribute("x5-video-player-fullscreen", "false");
        }
        return !this._supportsFullScreen || document[this._fn.exitFullscreen]();
      },
      autoFullScreen: function autoFullScreen(element, onFullScreenChange) {
        element = element || document.body;
        this._ensureFullScreen(element, onFullScreenChange);
        this.requestFullScreen(element, onFullScreenChange);
      },
      disableAutoFullScreen: function disableAutoFullScreen(element) {
        var touchTarget = cc.game.canvas || element;
        var touchEventName = this._touchEvent;
        if (this._preOnTouch) {
          touchTarget.removeEventListener(touchEventName, this._preOnTouch);
          this._preOnTouch = null;
        }
      },
      _ensureFullScreen: function _ensureFullScreen(element, onFullScreenChange) {
        var self = this;
        var touchTarget = cc.game.canvas || element;
        var fullScreenErrorEventName = this._fn.fullscreenerror;
        var touchEventName = this._touchEvent;
        function onFullScreenError() {
          self._preOnFullScreenError = null;
          function onTouch() {
            self._preOnTouch = null;
            self.requestFullScreen(element, onFullScreenChange);
          }
          self._preOnTouch && touchTarget.removeEventListener(touchEventName, self._preOnTouch);
          self._preOnTouch = onTouch;
          touchTarget.addEventListener(touchEventName, self._preOnTouch, {
            once: true
          });
        }
        this._preOnFullScreenError && element.removeEventListener(fullScreenErrorEventName, this._preOnFullScreenError);
        this._preOnFullScreenError = onFullScreenError;
        element.addEventListener(fullScreenErrorEventName, onFullScreenError, {
          once: true
        });
      }
    };
    cc.screen.init();
  }), {} ],
  127: [ (function(require, module, exports) {
    "use strict";
    var settingPlatform = void 0;
    true;
    settingPlatform = window._CCSettings ? _CCSettings.platform : void 0;
    var isBaiduGame = "baidugame" === settingPlatform || "baidugame-subcontext" === settingPlatform;
    var isVivoGame = "qgame" === settingPlatform;
    var isOppoGame = "quickgame" === settingPlatform;
    var isHuaweiGame = "huawei" === settingPlatform;
    var isJKWGame = "jkw-game" === settingPlatform;
    var _global = "undefined" === typeof window ? global : window;
    function initSys() {
      cc.sys = {};
      var sys = cc.sys;
      sys.LANGUAGE_ENGLISH = "en";
      sys.LANGUAGE_CHINESE = "zh";
      sys.LANGUAGE_FRENCH = "fr";
      sys.LANGUAGE_ITALIAN = "it";
      sys.LANGUAGE_GERMAN = "de";
      sys.LANGUAGE_SPANISH = "es";
      sys.LANGUAGE_DUTCH = "du";
      sys.LANGUAGE_RUSSIAN = "ru";
      sys.LANGUAGE_KOREAN = "ko";
      sys.LANGUAGE_JAPANESE = "ja";
      sys.LANGUAGE_HUNGARIAN = "hu";
      sys.LANGUAGE_PORTUGUESE = "pt";
      sys.LANGUAGE_ARABIC = "ar";
      sys.LANGUAGE_NORWEGIAN = "no";
      sys.LANGUAGE_POLISH = "pl";
      sys.LANGUAGE_TURKISH = "tr";
      sys.LANGUAGE_UKRAINIAN = "uk";
      sys.LANGUAGE_ROMANIAN = "ro";
      sys.LANGUAGE_BULGARIAN = "bg";
      sys.LANGUAGE_UNKNOWN = "unknown";
      sys.OS_IOS = "iOS";
      sys.OS_ANDROID = "Android";
      sys.OS_WINDOWS = "Windows";
      sys.OS_MARMALADE = "Marmalade";
      sys.OS_LINUX = "Linux";
      sys.OS_BADA = "Bada";
      sys.OS_BLACKBERRY = "Blackberry";
      sys.OS_OSX = "OS X";
      sys.OS_WP8 = "WP8";
      sys.OS_WINRT = "WINRT";
      sys.OS_UNKNOWN = "Unknown";
      sys.UNKNOWN = -1;
      sys.WIN32 = 0;
      sys.LINUX = 1;
      sys.MACOS = 2;
      sys.ANDROID = 3;
      sys.IPHONE = 4;
      sys.IPAD = 5;
      sys.BLACKBERRY = 6;
      sys.NACL = 7;
      sys.EMSCRIPTEN = 8;
      sys.TIZEN = 9;
      sys.WINRT = 10;
      sys.WP8 = 11;
      sys.MOBILE_BROWSER = 100;
      sys.DESKTOP_BROWSER = 101;
      sys.EDITOR_PAGE = 102;
      sys.EDITOR_CORE = 103;
      sys.WECHAT_GAME = 104;
      sys.QQ_PLAY = 105;
      sys.FB_PLAYABLE_ADS = 106;
      sys.BAIDU_GAME = 107;
      sys.VIVO_GAME = 108;
      sys.OPPO_GAME = 109;
      sys.HUAWEI_GAME = 110;
      sys.XIAOMI_GAME = 111;
      sys.JKW_GAME = 112;
      sys.BROWSER_TYPE_WECHAT = "wechat";
      sys.BROWSER_TYPE_WECHAT_GAME = "wechatgame";
      sys.BROWSER_TYPE_WECHAT_GAME_SUB = "wechatgamesub";
      sys.BROWSER_TYPE_BAIDU_GAME = "baidugame";
      sys.BROWSER_TYPE_BAIDU_GAME_SUB = "baidugamesub";
      sys.BROWSER_TYPE_XIAOMI_GAME = "xiaomigame";
      sys.BROWSER_TYPE_QQ_PLAY = "qqplay";
      sys.BROWSER_TYPE_ANDROID = "androidbrowser";
      sys.BROWSER_TYPE_IE = "ie";
      sys.BROWSER_TYPE_QQ = "qqbrowser";
      sys.BROWSER_TYPE_MOBILE_QQ = "mqqbrowser";
      sys.BROWSER_TYPE_UC = "ucbrowser";
      sys.BROWSER_TYPE_UCBS = "ucbs";
      sys.BROWSER_TYPE_360 = "360browser";
      sys.BROWSER_TYPE_BAIDU_APP = "baiduboxapp";
      sys.BROWSER_TYPE_BAIDU = "baidubrowser";
      sys.BROWSER_TYPE_MAXTHON = "maxthon";
      sys.BROWSER_TYPE_OPERA = "opera";
      sys.BROWSER_TYPE_OUPENG = "oupeng";
      sys.BROWSER_TYPE_MIUI = "miuibrowser";
      sys.BROWSER_TYPE_FIREFOX = "firefox";
      sys.BROWSER_TYPE_SAFARI = "safari";
      sys.BROWSER_TYPE_CHROME = "chrome";
      sys.BROWSER_TYPE_LIEBAO = "liebao";
      sys.BROWSER_TYPE_QZONE = "qzone";
      sys.BROWSER_TYPE_SOUGOU = "sogou";
      sys.BROWSER_TYPE_UNKNOWN = "unknown";
      sys.isNative = (false, false);
      sys.isBrowser = "object" === typeof window && "object" === typeof document && false;
      sys.glExtension = function(name) {
        if (true, "OES_texture_float" === name) return false;
        return !!cc.renderer.device.ext(name);
      };
      sys.getMaxJointMatrixSize = function() {
        if (!sys._maxJointMatrixSize) {
          var JOINT_MATRICES_SIZE = 50;
          var LEFT_UNIFORM_SIZE = 10;
          var gl = cc.game._renderContext;
          var maxUniforms = Math.floor(gl.getParameter(gl.MAX_VERTEX_UNIFORM_VECTORS) / 4) - LEFT_UNIFORM_SIZE;
          sys._maxJointMatrixSize = maxUniforms < JOINT_MATRICES_SIZE ? 0 : JOINT_MATRICES_SIZE;
        }
        return sys._maxJointMatrixSize;
      };
      if (_global.__platform && _global.__platform.getSystemInfo) {
        var _env = _global.__platform.getSystemInfo();
        sys.isNative = _env.isNative;
        sys.isBrowser = _env.isBrowser;
        sys.platform = _env.platform;
        sys.browserType = _env.browserType;
        sys.isMobile = _env.isMobile;
        sys.language = _env.language;
        sys.languageCode = _env.language.toLowerCase();
        sys.os = _env.os;
        sys.osVersion = _env.osVersion;
        sys.osMainVersion = _env.osMainVersion;
        sys.browserVersion = _env.browserVersion;
        sys.windowPixelResolution = _env.windowPixelResolution;
        sys.localStorage = _env.localStorage;
        sys.capabilities = _env.capabilities;
        sys.__audioSupport = _env.audioSupport;
        _global.__platform = void 0;
      } else {
        false;
        var platform;
        var languageCode;
        var w;
        var h;
        var ratio;
        var capabilities;
        false, false;
        var env;
        var w;
        var h;
        var ratio;
        var _env2;
        var win, nav, doc, docEle;
        var ua;
        var currLanguage;
        var isAndroid, iOS, osVersion, osMainVersion;
        var uaResult;
        var osName;
        var w;
        var h;
        var ratio;
        var _tmpCanvas1;
        var create3DContext;
        var localStorage;
        var warn;
        var _supportWebp;
        var _supportCanvas;
        var _supportWebGL;
        var capabilities;
        var __audioSupport;
        var formatSupport;
        true;
        var env = wx.getSystemInfoSync();
        sys.isMobile = true;
        sys.platform = sys.WECHAT_GAME;
        sys.language = env.language.substr(0, 2);
        sys.languageCode = env.language.toLowerCase();
        var system = env.system.toLowerCase();
        if ("android" === env.platform) sys.os = sys.OS_ANDROID; else if ("ios" === env.platform) sys.os = sys.OS_IOS; else if ("devtools" === env.platform) {
          sys.isMobile = false;
          system.indexOf("android") > -1 ? sys.os = sys.OS_ANDROID : system.indexOf("ios") > -1 && (sys.os = sys.OS_IOS);
        }
        "android p" === system && (system = "android p 9.0");
        var version = /[\d\.]+/.exec(system);
        sys.osVersion = version ? version[0] : system;
        sys.osMainVersion = parseInt(sys.osVersion);
        false;
        sys.browserType = sys.BROWSER_TYPE_WECHAT_GAME;
        sys.browserVersion = env.version;
        var w = env.windowWidth;
        var h = env.windowHeight;
        var ratio = env.pixelRatio || 1;
        sys.windowPixelResolution = {
          width: ratio * w,
          height: ratio * h
        };
        sys.localStorage = window.localStorage;
        var _supportWebGL = _supportWebp = false;
        try {
          var _canvas = document.createElement("canvas");
          _supportWebGL = _canvas.getContext("webgl");
          _supportWebp = _canvas.toDataURL("image/webp").startsWith("data:image/webp");
        } catch (err) {}
        sys.capabilities = {
          canvas: true,
          opengl: !!_supportWebGL,
          webp: _supportWebp
        };
        sys.__audioSupport = {
          ONLY_ONE: false,
          WEB_AUDIO: false,
          DELAY_CREATE_CTX: false,
          format: [ ".mp3" ]
        };
      }
      sys.NetworkType = {
        NONE: 0,
        LAN: 1,
        WWAN: 2
      };
      sys.getNetworkType = function() {
        return sys.NetworkType.LAN;
      };
      sys.getBatteryLevel = function() {
        return 1;
      };
      sys.garbageCollect = function() {};
      sys.restartVM = function() {};
      sys.getSafeAreaRect = function() {
        var visibleSize = cc.view.getVisibleSize();
        return cc.rect(0, 0, visibleSize.width, visibleSize.height);
      };
      sys.isObjectValid = function(obj) {
        if (obj) return true;
        return false;
      };
      sys.dump = function() {
        var self = this;
        var str = "";
        str += "isMobile : " + self.isMobile + "\r\n";
        str += "language : " + self.language + "\r\n";
        str += "browserType : " + self.browserType + "\r\n";
        str += "browserVersion : " + self.browserVersion + "\r\n";
        str += "capabilities : " + JSON.stringify(self.capabilities) + "\r\n";
        str += "os : " + self.os + "\r\n";
        str += "osVersion : " + self.osVersion + "\r\n";
        str += "platform : " + self.platform + "\r\n";
        str += "Using " + (cc.game.renderType === cc.game.RENDER_TYPE_WEBGL ? "WEBGL" : "CANVAS") + " renderer.\r\n";
        cc.log(str);
      };
      sys.openURL = function(url) {
        false, false;
        window.open(url);
      };
      sys.now = function() {
        return Date.now ? Date.now() : +new Date();
      };
      return sys;
    }
    var sys = cc && cc.sys ? cc.sys : initSys();
    module.exports = sys;
  }), {} ],
  128: [ (function(require, module, exports) {
    "use strict";
    var EventTarget = require("../event/event-target");
    var js = require("../platform/js");
    var renderer = require("../renderer");
    require("../platform/CCClass");
    var isXiaomiGame = cc.sys.platform === cc.sys.XIAOMI_GAME;
    var isBaiduGame = cc.sys.platform === cc.sys.BAIDU_GAME;
    var __BrowserGetter = {
      init: function init() {
        false;
      },
      availWidth: function availWidth(frame) {
        return frame && frame !== this.html ? frame.clientWidth : window.innerWidth;
      },
      availHeight: function availHeight(frame) {
        return frame && frame !== this.html ? frame.clientHeight : window.innerHeight;
      },
      meta: {
        width: "device-width"
      },
      adaptationType: cc.sys.browserType
    };
    cc.sys.os === cc.sys.OS_IOS && (__BrowserGetter.adaptationType = cc.sys.BROWSER_TYPE_SAFARI);
    isBaiduGame && (cc.sys.browserType === cc.sys.BROWSER_TYPE_BAIDU_GAME_SUB ? __BrowserGetter.adaptationType = cc.sys.BROWSER_TYPE_BAIDU_GAME_SUB : __BrowserGetter.adaptationType = cc.sys.BROWSER_TYPE_BAIDU_GAME);
    isXiaomiGame && (__BrowserGetter.adaptationType = cc.sys.BROWSER_TYPE_XIAOMI_GAME);
    true;
    cc.sys.browserType === cc.sys.BROWSER_TYPE_WECHAT_GAME_SUB ? __BrowserGetter.adaptationType = cc.sys.BROWSER_TYPE_WECHAT_GAME_SUB : __BrowserGetter.adaptationType = cc.sys.BROWSER_TYPE_WECHAT_GAME;
    false;
    switch (__BrowserGetter.adaptationType) {
     case cc.sys.BROWSER_TYPE_SAFARI:
      __BrowserGetter.meta["minimal-ui"] = "true";

     case cc.sys.BROWSER_TYPE_SOUGOU:
     case cc.sys.BROWSER_TYPE_UC:
      __BrowserGetter.availWidth = function(frame) {
        return frame.clientWidth;
      };
      __BrowserGetter.availHeight = function(frame) {
        return frame.clientHeight;
      };
      break;

     case cc.sys.BROWSER_TYPE_WECHAT_GAME:
      __BrowserGetter.availWidth = function() {
        return window.innerWidth;
      };
      __BrowserGetter.availHeight = function() {
        return window.innerHeight;
      };
      break;

     case cc.sys.BROWSER_TYPE_WECHAT_GAME_SUB:
      var sharedCanvas = window.sharedCanvas || wx.getSharedCanvas();
      __BrowserGetter.availWidth = function() {
        return sharedCanvas.width;
      };
      __BrowserGetter.availHeight = function() {
        return sharedCanvas.height;
      };
    }
    var _scissorRect = null;
    var View = function View() {
      EventTarget.call(this);
      var _t = this, _strategyer = cc.ContainerStrategy, _strategy = cc.ContentStrategy;
      __BrowserGetter.init(this);
      _t._frameSize = cc.size(0, 0);
      _t._designResolutionSize = cc.size(0, 0);
      _t._originalDesignResolutionSize = cc.size(0, 0);
      _t._scaleX = 1;
      _t._scaleY = 1;
      _t._viewportRect = cc.rect(0, 0, 0, 0);
      _t._visibleRect = cc.rect(0, 0, 0, 0);
      _t._autoFullScreen = false;
      _t._devicePixelRatio = 1;
      _t._maxPixelRatio = 2;
      _t._retinaEnabled = false;
      _t._resizeCallback = null;
      _t._resizing = false;
      _t._resizeWithBrowserSize = false;
      _t._orientationChanging = true;
      _t._isRotated = false;
      _t._orientation = cc.macro.ORIENTATION_AUTO;
      _t._isAdjustViewport = true;
      _t._antiAliasEnabled = false;
      _t._resolutionPolicy = null;
      _t._rpExactFit = new cc.ResolutionPolicy(_strategyer.EQUAL_TO_FRAME, _strategy.EXACT_FIT);
      _t._rpShowAll = new cc.ResolutionPolicy(_strategyer.EQUAL_TO_FRAME, _strategy.SHOW_ALL);
      _t._rpNoBorder = new cc.ResolutionPolicy(_strategyer.EQUAL_TO_FRAME, _strategy.NO_BORDER);
      _t._rpFixedHeight = new cc.ResolutionPolicy(_strategyer.EQUAL_TO_FRAME, _strategy.FIXED_HEIGHT);
      _t._rpFixedWidth = new cc.ResolutionPolicy(_strategyer.EQUAL_TO_FRAME, _strategy.FIXED_WIDTH);
      cc.game.once(cc.game.EVENT_ENGINE_INITED, this.init, this);
    };
    cc.js.extend(View, EventTarget);
    cc.js.mixin(View.prototype, {
      init: function init() {
        this._initFrameSize();
        this.enableAntiAlias(true);
        var w = cc.game.canvas.width, h = cc.game.canvas.height;
        this._designResolutionSize.width = w;
        this._designResolutionSize.height = h;
        this._originalDesignResolutionSize.width = w;
        this._originalDesignResolutionSize.height = h;
        this._viewportRect.width = w;
        this._viewportRect.height = h;
        this._visibleRect.width = w;
        this._visibleRect.height = h;
        cc.winSize.width = this._visibleRect.width;
        cc.winSize.height = this._visibleRect.height;
        cc.visibleRect && cc.visibleRect.init(this._visibleRect);
      },
      _resizeEvent: function _resizeEvent(forceOrEvent) {
        var view;
        view = this.setDesignResolutionSize ? this : cc.view;
        var prevFrameW = view._frameSize.width, prevFrameH = view._frameSize.height, prevRotated = view._isRotated;
        if (cc.sys.isMobile) {
          var containerStyle = cc.game.container.style, margin = containerStyle.margin;
          containerStyle.margin = "0";
          containerStyle.display = "none";
          view._initFrameSize();
          containerStyle.margin = margin;
          containerStyle.display = "block";
        } else view._initFrameSize();
        if (true !== forceOrEvent && view._isRotated === prevRotated && view._frameSize.width === prevFrameW && view._frameSize.height === prevFrameH) return;
        var width = view._originalDesignResolutionSize.width;
        var height = view._originalDesignResolutionSize.height;
        view._resizing = true;
        width > 0 && view.setDesignResolutionSize(width, height, view._resolutionPolicy);
        view._resizing = false;
        view.emit("canvas-resize");
        view._resizeCallback && view._resizeCallback.call();
      },
      _orientationChange: function _orientationChange() {
        cc.view._orientationChanging = true;
        cc.view._resizeEvent();
      },
      resizeWithBrowserSize: function resizeWithBrowserSize(enabled) {
        if (enabled) {
          if (!this._resizeWithBrowserSize) {
            this._resizeWithBrowserSize = true;
            window.addEventListener("resize", this._resizeEvent);
            window.addEventListener("orientationchange", this._orientationChange);
          }
        } else if (this._resizeWithBrowserSize) {
          this._resizeWithBrowserSize = false;
          window.removeEventListener("resize", this._resizeEvent);
          window.removeEventListener("orientationchange", this._orientationChange);
        }
      },
      setResizeCallback: function setResizeCallback(callback) {
        false;
        "function" !== typeof callback && null != callback || (this._resizeCallback = callback);
      },
      setOrientation: function setOrientation(orientation) {
        orientation &= cc.macro.ORIENTATION_AUTO;
        if (orientation && this._orientation !== orientation) {
          this._orientation = orientation;
          var designWidth = this._originalDesignResolutionSize.width;
          var designHeight = this._originalDesignResolutionSize.height;
          this.setDesignResolutionSize(designWidth, designHeight, this._resolutionPolicy);
        }
      },
      _initFrameSize: function _initFrameSize() {
        var locFrameSize = this._frameSize;
        var w = __BrowserGetter.availWidth(cc.game.frame);
        var h = __BrowserGetter.availHeight(cc.game.frame);
        var isLandscape = w >= h;
        if ((false, !cc.sys.isMobile) || isLandscape && this._orientation & cc.macro.ORIENTATION_LANDSCAPE || !isLandscape && this._orientation & cc.macro.ORIENTATION_PORTRAIT) {
          locFrameSize.width = w;
          locFrameSize.height = h;
          cc.game.container.style["-webkit-transform"] = "rotate(0deg)";
          cc.game.container.style.transform = "rotate(0deg)";
          this._isRotated = false;
        } else {
          locFrameSize.width = h;
          locFrameSize.height = w;
          cc.game.container.style["-webkit-transform"] = "rotate(90deg)";
          cc.game.container.style.transform = "rotate(90deg)";
          cc.game.container.style["-webkit-transform-origin"] = "0px 0px 0px";
          cc.game.container.style.transformOrigin = "0px 0px 0px";
          this._isRotated = true;
        }
        this._orientationChanging && setTimeout((function() {
          cc.view._orientationChanging = false;
        }), 1e3);
      },
      _adjustSizeKeepCanvasSize: function _adjustSizeKeepCanvasSize() {
        var designWidth = this._originalDesignResolutionSize.width;
        var designHeight = this._originalDesignResolutionSize.height;
        designWidth > 0 && this.setDesignResolutionSize(designWidth, designHeight, this._resolutionPolicy);
      },
      _setViewportMeta: function _setViewportMeta(metas, overwrite) {
        var vp = document.getElementById("cocosMetaElement");
        vp && overwrite && document.head.removeChild(vp);
        var elems = document.getElementsByName("viewport"), currentVP = elems ? elems[0] : null, content, key, pattern;
        content = currentVP ? currentVP.content : "";
        vp = vp || document.createElement("meta");
        vp.id = "cocosMetaElement";
        vp.name = "viewport";
        vp.content = "";
        for (key in metas) if (-1 == content.indexOf(key)) content += "," + key + "=" + metas[key]; else if (overwrite) {
          pattern = new RegExp(key + "s*=s*[^,]+");
          content.replace(pattern, key + "=" + metas[key]);
        }
        /^,/.test(content) && (content = content.substr(1));
        vp.content = content;
        currentVP && (currentVP.content = content);
        document.head.appendChild(vp);
      },
      _adjustViewportMeta: function _adjustViewportMeta() {
        if (this._isAdjustViewport && false) {
          this._setViewportMeta(__BrowserGetter.meta, false);
          this._isAdjustViewport = false;
        }
      },
      adjustViewportMeta: function adjustViewportMeta(enabled) {
        this._isAdjustViewport = enabled;
      },
      enableRetina: function enableRetina(enabled) {
        this._retinaEnabled = !!enabled;
      },
      isRetinaEnabled: function isRetinaEnabled() {
        return this._retinaEnabled;
      },
      enableAntiAlias: function enableAntiAlias(enabled) {
        if (this._antiAliasEnabled === enabled) return;
        this._antiAliasEnabled = enabled;
        if (cc.game.renderType === cc.game.RENDER_TYPE_WEBGL) {
          var cache = cc.loader._cache;
          for (var key in cache) {
            var item = cache[key];
            var tex = item && item.content instanceof cc.Texture2D ? item.content : null;
            if (tex) {
              var Filter = cc.Texture2D.Filter;
              enabled ? tex.setFilters(Filter.LINEAR, Filter.LINEAR) : tex.setFilters(Filter.NEAREST, Filter.NEAREST);
            }
          }
        } else if (cc.game.renderType === cc.game.RENDER_TYPE_CANVAS) {
          var ctx = cc.game.canvas.getContext("2d");
          ctx.imageSmoothingEnabled = enabled;
          ctx.mozImageSmoothingEnabled = enabled;
        }
      },
      isAntiAliasEnabled: function isAntiAliasEnabled() {
        return this._antiAliasEnabled;
      },
      enableAutoFullScreen: function enableAutoFullScreen(enabled) {
        if (enabled && enabled !== this._autoFullScreen && cc.sys.isMobile && cc.sys.browserType !== cc.sys.BROWSER_TYPE_WECHAT) {
          this._autoFullScreen = true;
          cc.screen.autoFullScreen(cc.game.frame);
        } else {
          this._autoFullScreen = false;
          cc.screen.disableAutoFullScreen(cc.game.frame);
        }
      },
      isAutoFullScreenEnabled: function isAutoFullScreenEnabled() {
        return this._autoFullScreen;
      },
      setCanvasSize: function setCanvasSize(width, height) {
        var canvas = cc.game.canvas;
        var container = cc.game.container;
        canvas.width = width * this._devicePixelRatio;
        canvas.height = height * this._devicePixelRatio;
        canvas.style.width = width + "px";
        canvas.style.height = height + "px";
        container.style.width = width + "px";
        container.style.height = height + "px";
        this._resizeEvent();
      },
      getCanvasSize: function getCanvasSize() {
        return cc.size(cc.game.canvas.width, cc.game.canvas.height);
      },
      getFrameSize: function getFrameSize() {
        return cc.size(this._frameSize.width, this._frameSize.height);
      },
      setFrameSize: function setFrameSize(width, height) {
        this._frameSize.width = width;
        this._frameSize.height = height;
        cc.game.frame.style.width = width + "px";
        cc.game.frame.style.height = height + "px";
        this._resizeEvent(true);
      },
      getVisibleSize: function getVisibleSize() {
        return cc.size(this._visibleRect.width, this._visibleRect.height);
      },
      getVisibleSizeInPixel: function getVisibleSizeInPixel() {
        return cc.size(this._visibleRect.width * this._scaleX, this._visibleRect.height * this._scaleY);
      },
      getVisibleOrigin: function getVisibleOrigin() {
        return cc.v2(this._visibleRect.x, this._visibleRect.y);
      },
      getVisibleOriginInPixel: function getVisibleOriginInPixel() {
        return cc.v2(this._visibleRect.x * this._scaleX, this._visibleRect.y * this._scaleY);
      },
      getResolutionPolicy: function getResolutionPolicy() {
        return this._resolutionPolicy;
      },
      setResolutionPolicy: function setResolutionPolicy(resolutionPolicy) {
        var _t = this;
        if (resolutionPolicy instanceof cc.ResolutionPolicy) _t._resolutionPolicy = resolutionPolicy; else {
          var _locPolicy = cc.ResolutionPolicy;
          resolutionPolicy === _locPolicy.EXACT_FIT && (_t._resolutionPolicy = _t._rpExactFit);
          resolutionPolicy === _locPolicy.SHOW_ALL && (_t._resolutionPolicy = _t._rpShowAll);
          resolutionPolicy === _locPolicy.NO_BORDER && (_t._resolutionPolicy = _t._rpNoBorder);
          resolutionPolicy === _locPolicy.FIXED_HEIGHT && (_t._resolutionPolicy = _t._rpFixedHeight);
          resolutionPolicy === _locPolicy.FIXED_WIDTH && (_t._resolutionPolicy = _t._rpFixedWidth);
        }
      },
      setDesignResolutionSize: function setDesignResolutionSize(width, height, resolutionPolicy) {
        if (!(width > 0 || height > 0)) {
          cc.logID(2200);
          return;
        }
        this.setResolutionPolicy(resolutionPolicy);
        var policy = this._resolutionPolicy;
        policy && policy.preApply(this);
        cc.sys.isMobile && this._adjustViewportMeta();
        this._orientationChanging = true;
        this._resizing || this._initFrameSize();
        if (!policy) {
          cc.logID(2201);
          return;
        }
        this._originalDesignResolutionSize.width = this._designResolutionSize.width = width;
        this._originalDesignResolutionSize.height = this._designResolutionSize.height = height;
        var result = policy.apply(this, this._designResolutionSize);
        if (result.scale && 2 === result.scale.length) {
          this._scaleX = result.scale[0];
          this._scaleY = result.scale[1];
        }
        if (result.viewport) {
          var vp = this._viewportRect, vb = this._visibleRect, rv = result.viewport;
          vp.x = rv.x;
          vp.y = rv.y;
          vp.width = rv.width;
          vp.height = rv.height;
          vb.x = 0;
          vb.y = 0;
          vb.width = rv.width / this._scaleX;
          vb.height = rv.height / this._scaleY;
        }
        policy.postApply(this);
        cc.winSize.width = this._visibleRect.width;
        cc.winSize.height = this._visibleRect.height;
        cc.visibleRect && cc.visibleRect.init(this._visibleRect);
        renderer.updateCameraViewport();
        this.emit("design-resolution-changed");
      },
      getDesignResolutionSize: function getDesignResolutionSize() {
        return cc.size(this._designResolutionSize.width, this._designResolutionSize.height);
      },
      setRealPixelResolution: function setRealPixelResolution(width, height, resolutionPolicy) {
        if ((true, true) && false) {
          this._setViewportMeta({
            width: width
          }, true);
          document.documentElement.style.width = width + "px";
          document.body.style.width = width + "px";
          document.body.style.left = "0px";
          document.body.style.top = "0px";
        }
        this.setDesignResolutionSize(width, height, resolutionPolicy);
      },
      setViewportInPoints: function setViewportInPoints(x, y, w, h) {
        var locScaleX = this._scaleX, locScaleY = this._scaleY;
        cc.game._renderContext.viewport(x * locScaleX + this._viewportRect.x, y * locScaleY + this._viewportRect.y, w * locScaleX, h * locScaleY);
      },
      setScissorInPoints: function setScissorInPoints(x, y, w, h) {
        var scaleX = this._scaleX, scaleY = this._scaleY;
        var sx = Math.ceil(x * scaleX + this._viewportRect.x);
        var sy = Math.ceil(y * scaleY + this._viewportRect.y);
        var sw = Math.ceil(w * scaleX);
        var sh = Math.ceil(h * scaleY);
        var gl = cc.game._renderContext;
        if (!_scissorRect) {
          var boxArr = gl.getParameter(gl.SCISSOR_BOX);
          _scissorRect = cc.rect(boxArr[0], boxArr[1], boxArr[2], boxArr[3]);
        }
        if (_scissorRect.x !== sx || _scissorRect.y !== sy || _scissorRect.width !== sw || _scissorRect.height !== sh) {
          _scissorRect.x = sx;
          _scissorRect.y = sy;
          _scissorRect.width = sw;
          _scissorRect.height = sh;
          gl.scissor(sx, sy, sw, sh);
        }
      },
      isScissorEnabled: function isScissorEnabled() {
        return cc.game._renderContext.isEnabled(gl.SCISSOR_TEST);
      },
      getScissorRect: function getScissorRect() {
        if (!_scissorRect) {
          var boxArr = gl.getParameter(gl.SCISSOR_BOX);
          _scissorRect = cc.rect(boxArr[0], boxArr[1], boxArr[2], boxArr[3]);
        }
        var scaleXFactor = 1 / this._scaleX;
        var scaleYFactor = 1 / this._scaleY;
        return cc.rect((_scissorRect.x - this._viewportRect.x) * scaleXFactor, (_scissorRect.y - this._viewportRect.y) * scaleYFactor, _scissorRect.width * scaleXFactor, _scissorRect.height * scaleYFactor);
      },
      getViewportRect: function getViewportRect() {
        return this._viewportRect;
      },
      getScaleX: function getScaleX() {
        return this._scaleX;
      },
      getScaleY: function getScaleY() {
        return this._scaleY;
      },
      getDevicePixelRatio: function getDevicePixelRatio() {
        return this._devicePixelRatio;
      },
      convertToLocationInView: function convertToLocationInView(tx, ty, relatedPos, out) {
        var result = out || cc.v2();
        var x = this._devicePixelRatio * (tx - relatedPos.left);
        var y = this._devicePixelRatio * (relatedPos.top + relatedPos.height - ty);
        if (this._isRotated) {
          result.x = cc.game.canvas.width - y;
          result.y = x;
        } else {
          result.x = x;
          result.y = y;
        }
        return result;
      },
      _convertMouseToLocationInView: function _convertMouseToLocationInView(in_out_point, relatedPos) {
        var viewport = this._viewportRect, _t = this;
        in_out_point.x = (_t._devicePixelRatio * (in_out_point.x - relatedPos.left) - viewport.x) / _t._scaleX;
        in_out_point.y = (_t._devicePixelRatio * (relatedPos.top + relatedPos.height - in_out_point.y) - viewport.y) / _t._scaleY;
      },
      _convertPointWithScale: function _convertPointWithScale(point) {
        var viewport = this._viewportRect;
        point.x = (point.x - viewport.x) / this._scaleX;
        point.y = (point.y - viewport.y) / this._scaleY;
      },
      _convertTouchesWithScale: function _convertTouchesWithScale(touches) {
        var viewport = this._viewportRect, scaleX = this._scaleX, scaleY = this._scaleY, selTouch, selPoint, selPrePoint;
        for (var i = 0; i < touches.length; i++) {
          selTouch = touches[i];
          selPoint = selTouch._point;
          selPrePoint = selTouch._prevPoint;
          selPoint.x = (selPoint.x - viewport.x) / scaleX;
          selPoint.y = (selPoint.y - viewport.y) / scaleY;
          selPrePoint.x = (selPrePoint.x - viewport.x) / scaleX;
          selPrePoint.y = (selPrePoint.y - viewport.y) / scaleY;
        }
      }
    });
    cc.ContainerStrategy = cc.Class({
      name: "ContainerStrategy",
      preApply: function preApply(view) {},
      apply: function apply(view, designedResolution) {},
      postApply: function postApply(view) {},
      _setupContainer: function _setupContainer(view, w, h) {
        var locCanvas = cc.game.canvas, locContainer = cc.game.container;
        false;
        var devicePixelRatio = view._devicePixelRatio = 1;
        view.isRetinaEnabled() && (devicePixelRatio = view._devicePixelRatio = Math.min(view._maxPixelRatio, window.devicePixelRatio || 1));
        locCanvas.width = w * devicePixelRatio;
        locCanvas.height = h * devicePixelRatio;
      },
      _fixContainer: function _fixContainer() {
        document.body.insertBefore(cc.game.container, document.body.firstChild);
        var bs = document.body.style;
        bs.width = window.innerWidth + "px";
        bs.height = window.innerHeight + "px";
        bs.overflow = "hidden";
        var contStyle = cc.game.container.style;
        contStyle.position = "fixed";
        contStyle.left = contStyle.top = "0px";
        document.body.scrollTop = 0;
      }
    });
    cc.ContentStrategy = cc.Class({
      name: "ContentStrategy",
      ctor: function ctor() {
        this._result = {
          scale: [ 1, 1 ],
          viewport: null
        };
      },
      _buildResult: function _buildResult(containerW, containerH, contentW, contentH, scaleX, scaleY) {
        Math.abs(containerW - contentW) < 2 && (contentW = containerW);
        Math.abs(containerH - contentH) < 2 && (contentH = containerH);
        var viewport = cc.rect((containerW - contentW) / 2, (containerH - contentH) / 2, contentW, contentH);
        cc.game.renderType === cc.game.RENDER_TYPE_CANVAS;
        this._result.scale = [ scaleX, scaleY ];
        this._result.viewport = viewport;
        return this._result;
      },
      preApply: function preApply(view) {},
      apply: function apply(view, designedResolution) {
        return {
          scale: [ 1, 1 ]
        };
      },
      postApply: function postApply(view) {}
    });
    (function() {
      var EqualToFrame = cc.Class({
        name: "EqualToFrame",
        extends: cc.ContainerStrategy,
        apply: function apply(view) {
          var frameH = view._frameSize.height, containerStyle = cc.game.container.style;
          this._setupContainer(view, view._frameSize.width, view._frameSize.height);
          view._isRotated ? containerStyle.margin = "0 0 0 " + frameH + "px" : containerStyle.margin = "0px";
          containerStyle.padding = "0px";
        }
      });
      var ProportionalToFrame = cc.Class({
        name: "ProportionalToFrame",
        extends: cc.ContainerStrategy,
        apply: function apply(view, designedResolution) {
          var frameW = view._frameSize.width, frameH = view._frameSize.height, containerStyle = cc.game.container.style, designW = designedResolution.width, designH = designedResolution.height, scaleX = frameW / designW, scaleY = frameH / designH, containerW, containerH;
          scaleX < scaleY ? (containerW = frameW, containerH = designH * scaleX) : (containerW = designW * scaleY, 
          containerH = frameH);
          var offx = Math.round((frameW - containerW) / 2);
          var offy = Math.round((frameH - containerH) / 2);
          containerW = frameW - 2 * offx;
          containerH = frameH - 2 * offy;
          this._setupContainer(view, containerW, containerH);
          true;
          view._isRotated ? containerStyle.margin = "0 0 0 " + frameH + "px" : containerStyle.margin = "0px";
          containerStyle.paddingLeft = offx + "px";
          containerStyle.paddingRight = offx + "px";
          containerStyle.paddingTop = offy + "px";
          containerStyle.paddingBottom = offy + "px";
        }
      });
      var EqualToWindow = cc.Class({
        name: "EqualToWindow",
        extends: EqualToFrame,
        preApply: function preApply(view) {
          this._super(view);
          cc.game.frame = document.documentElement;
        },
        apply: function apply(view) {
          this._super(view);
          this._fixContainer();
        }
      });
      var ProportionalToWindow = cc.Class({
        name: "ProportionalToWindow",
        extends: ProportionalToFrame,
        preApply: function preApply(view) {
          this._super(view);
          cc.game.frame = document.documentElement;
        },
        apply: function apply(view, designedResolution) {
          this._super(view, designedResolution);
          this._fixContainer();
        }
      });
      var OriginalContainer = cc.Class({
        name: "OriginalContainer",
        extends: cc.ContainerStrategy,
        apply: function apply(view) {
          this._setupContainer(view, cc.game.canvas.width, cc.game.canvas.height);
        }
      });
      cc.ContainerStrategy.EQUAL_TO_FRAME = new EqualToFrame();
      cc.ContainerStrategy.PROPORTION_TO_FRAME = new ProportionalToFrame();
      cc.ContainerStrategy.ORIGINAL_CONTAINER = new OriginalContainer();
      var ExactFit = cc.Class({
        name: "ExactFit",
        extends: cc.ContentStrategy,
        apply: function apply(view, designedResolution) {
          var containerW = cc.game.canvas.width, containerH = cc.game.canvas.height, scaleX = containerW / designedResolution.width, scaleY = containerH / designedResolution.height;
          return this._buildResult(containerW, containerH, containerW, containerH, scaleX, scaleY);
        }
      });
      var ShowAll = cc.Class({
        name: "ShowAll",
        extends: cc.ContentStrategy,
        apply: function apply(view, designedResolution) {
          var containerW = cc.game.canvas.width, containerH = cc.game.canvas.height, designW = designedResolution.width, designH = designedResolution.height, scaleX = containerW / designW, scaleY = containerH / designH, scale = 0, contentW, contentH;
          scaleX < scaleY ? (scale = scaleX, contentW = containerW, contentH = designH * scale) : (scale = scaleY, 
          contentW = designW * scale, contentH = containerH);
          return this._buildResult(containerW, containerH, contentW, contentH, scale, scale);
        }
      });
      var NoBorder = cc.Class({
        name: "NoBorder",
        extends: cc.ContentStrategy,
        apply: function apply(view, designedResolution) {
          var containerW = cc.game.canvas.width, containerH = cc.game.canvas.height, designW = designedResolution.width, designH = designedResolution.height, scaleX = containerW / designW, scaleY = containerH / designH, scale, contentW, contentH;
          scaleX < scaleY ? (scale = scaleY, contentW = designW * scale, contentH = containerH) : (scale = scaleX, 
          contentW = containerW, contentH = designH * scale);
          return this._buildResult(containerW, containerH, contentW, contentH, scale, scale);
        }
      });
      var FixedHeight = cc.Class({
        name: "FixedHeight",
        extends: cc.ContentStrategy,
        apply: function apply(view, designedResolution) {
          var containerW = cc.game.canvas.width, containerH = cc.game.canvas.height, designH = designedResolution.height, scale = containerH / designH, contentW = containerW, contentH = containerH;
          return this._buildResult(containerW, containerH, contentW, contentH, scale, scale);
        }
      });
      var FixedWidth = cc.Class({
        name: "FixedWidth",
        extends: cc.ContentStrategy,
        apply: function apply(view, designedResolution) {
          var containerW = cc.game.canvas.width, containerH = cc.game.canvas.height, designW = designedResolution.width, scale = containerW / designW, contentW = containerW, contentH = containerH;
          return this._buildResult(containerW, containerH, contentW, contentH, scale, scale);
        }
      });
      cc.ContentStrategy.EXACT_FIT = new ExactFit();
      cc.ContentStrategy.SHOW_ALL = new ShowAll();
      cc.ContentStrategy.NO_BORDER = new NoBorder();
      cc.ContentStrategy.FIXED_HEIGHT = new FixedHeight();
      cc.ContentStrategy.FIXED_WIDTH = new FixedWidth();
    })();
    cc.ResolutionPolicy = cc.Class({
      name: "cc.ResolutionPolicy",
      ctor: function ctor(containerStg, contentStg) {
        this._containerStrategy = null;
        this._contentStrategy = null;
        this.setContainerStrategy(containerStg);
        this.setContentStrategy(contentStg);
      },
      preApply: function preApply(view) {
        this._containerStrategy.preApply(view);
        this._contentStrategy.preApply(view);
      },
      apply: function apply(view, designedResolution) {
        this._containerStrategy.apply(view, designedResolution);
        return this._contentStrategy.apply(view, designedResolution);
      },
      postApply: function postApply(view) {
        this._containerStrategy.postApply(view);
        this._contentStrategy.postApply(view);
      },
      setContainerStrategy: function setContainerStrategy(containerStg) {
        containerStg instanceof cc.ContainerStrategy && (this._containerStrategy = containerStg);
      },
      setContentStrategy: function setContentStrategy(contentStg) {
        contentStg instanceof cc.ContentStrategy && (this._contentStrategy = contentStg);
      }
    });
    js.get(cc.ResolutionPolicy.prototype, "canvasSize", (function() {
      return cc.v2(cc.game.canvas.width, cc.game.canvas.height);
    }));
    cc.ResolutionPolicy.EXACT_FIT = 0;
    cc.ResolutionPolicy.NO_BORDER = 1;
    cc.ResolutionPolicy.SHOW_ALL = 2;
    cc.ResolutionPolicy.FIXED_HEIGHT = 3;
    cc.ResolutionPolicy.FIXED_WIDTH = 4;
    cc.ResolutionPolicy.UNKNOWN = 5;
    cc.view = new View();
    cc.winSize = cc.v2();
    module.exports = cc.view;
  }), {
    "../event/event-target": 86,
    "../platform/CCClass": 118,
    "../platform/js": 138,
    "../renderer": 161
  } ],
  129: [ (function(require, module, exports) {
    "use strict";
    cc.visibleRect = {
      topLeft: cc.v2(0, 0),
      topRight: cc.v2(0, 0),
      top: cc.v2(0, 0),
      bottomLeft: cc.v2(0, 0),
      bottomRight: cc.v2(0, 0),
      bottom: cc.v2(0, 0),
      center: cc.v2(0, 0),
      left: cc.v2(0, 0),
      right: cc.v2(0, 0),
      width: 0,
      height: 0,
      init: function init(visibleRect) {
        var w = this.width = visibleRect.width;
        var h = this.height = visibleRect.height;
        var l = visibleRect.x, b = visibleRect.y, t = b + h, r = l + w;
        this.topLeft.x = l;
        this.topLeft.y = t;
        this.topRight.x = r;
        this.topRight.y = t;
        this.top.x = l + w / 2;
        this.top.y = t;
        this.bottomLeft.x = l;
        this.bottomLeft.y = b;
        this.bottomRight.x = r;
        this.bottomRight.y = b;
        this.bottom.x = l + w / 2;
        this.bottom.y = b;
        this.center.x = l + w / 2;
        this.center.y = b + h / 2;
        this.left.x = l;
        this.left.y = b + h / 2;
        this.right.x = r;
        this.right.y = b + h / 2;
      }
    };
  }), {} ],
  130: [ (function(require, module, exports) {
    "use strict";
    var js = require("./js");
    var isPlainEmptyObj = require("./utils").isPlainEmptyObj_DEV;
    var DELIMETER = "$_$";
    function createAttrsSingle(owner, ownerCtor, superAttrs) {
      var AttrsCtor;
      var ctorName;
      false;
      AttrsCtor = function AttrsCtor() {};
      superAttrs && js.extend(AttrsCtor, superAttrs.constructor);
      var attrs = new AttrsCtor();
      js.value(owner, "__attrs__", attrs);
      return attrs;
    }
    function createAttrs(subclass) {
      var superClass;
      var chains = cc.Class.getInheritanceChain(subclass);
      for (var i = chains.length - 1; i >= 0; i--) {
        var cls = chains[i];
        var attrs = cls.hasOwnProperty("__attrs__") && cls.__attrs__;
        if (!attrs) {
          superClass = chains[i + 1];
          createAttrsSingle(cls, cls, superClass && superClass.__attrs__);
        }
      }
      superClass = chains[0];
      createAttrsSingle(subclass, subclass, superClass && superClass.__attrs__);
      return subclass.__attrs__;
    }
    function attr(ctor, propName, newAttrs) {
      var attrs, setter, key;
      if ("function" === typeof ctor) {
        attrs = getClassAttrs(ctor);
        setter = attrs.constructor.prototype;
      } else {
        var instance = ctor;
        attrs = instance.__attrs__;
        if (!attrs) {
          ctor = instance.constructor;
          var clsAttrs = getClassAttrs(ctor);
          attrs = createAttrsSingle(instance, ctor, clsAttrs);
        }
        setter = attrs;
      }
      if ("undefined" === typeof newAttrs) {
        var prefix = propName + DELIMETER;
        var ret = {};
        for (key in attrs) key.startsWith(prefix) && (ret[key.slice(prefix.length)] = attrs[key]);
        return ret;
      }
      if ("object" === typeof newAttrs) for (key in newAttrs) 95 !== key.charCodeAt(0) && (setter[propName + DELIMETER + key] = newAttrs[key]); else false;
    }
    function getClassAttrs(ctor) {
      return ctor.hasOwnProperty("__attrs__") && ctor.__attrs__ || createAttrs(ctor);
    }
    function getClassAttrsProto(ctor) {
      return getClassAttrs(ctor).constructor.prototype;
    }
    function setClassAttr(ctor, propName, key, value) {
      var proto = getClassAttrsProto(ctor);
      proto[propName + DELIMETER + key] = value;
    }
    cc.Integer = "Integer";
    cc.Float = "Float";
    false;
    cc.Boolean = "Boolean";
    cc.String = "String";
    function getTypeChecker(type, attrName) {
      false;
    }
    function ObjectType(typeCtor) {
      return {
        type: "Object",
        ctor: typeCtor,
        _onAfterProp: false
      };
    }
    module.exports = {
      attr: attr,
      getClassAttrs: getClassAttrs,
      getClassAttrsProto: getClassAttrsProto,
      setClassAttr: setClassAttr,
      DELIMETER: DELIMETER,
      getTypeChecker: getTypeChecker,
      ObjectType: ObjectType,
      ScriptUuid: {}
    };
  }), {
    "./CCClass": 118,
    "./js": 138,
    "./utils": 142
  } ],
  131: [ (function(require, module, exports) {
    "use strict";
    var js = require("./js");
    var fastRemoveAt = js.array.fastRemoveAt;
    function CallbackList() {
      this.callbacks = [];
      this.targets = [];
      this.isInvoking = false;
      this.containCanceled = false;
    }
    var proto = CallbackList.prototype;
    proto.removeBy = function(array, value) {
      var callbacks = this.callbacks;
      var targets = this.targets;
      for (var i = 0; i < array.length; ++i) if (array[i] === value) {
        fastRemoveAt(callbacks, i);
        fastRemoveAt(targets, i);
        --i;
      }
    };
    proto.cancel = function(index) {
      this.callbacks[index] = this.targets[index] = null;
      this.containCanceled = true;
    };
    proto.cancelAll = function() {
      var callbacks = this.callbacks;
      var targets = this.targets;
      for (var i = 0; i < callbacks.length; i++) callbacks[i] = targets[i] = null;
      this.containCanceled = true;
    };
    proto.purgeCanceled = function() {
      this.removeBy(this.callbacks, null);
      this.containCanceled = false;
    };
    var MAX_SIZE = 16;
    var callbackListPool = new js.Pool(function(list) {
      list.callbacks.length = 0;
      list.targets.length = 0;
      list.isInvoking = false;
      list.containCanceled = false;
    }, MAX_SIZE);
    callbackListPool.get = function() {
      return this._get() || new CallbackList();
    };
    function CallbacksHandler() {
      this._callbackTable = js.createMap(true);
    }
    proto = CallbacksHandler.prototype;
    proto.add = function(key, callback, target) {
      var list = this._callbackTable[key];
      list || (list = this._callbackTable[key] = callbackListPool.get());
      list.callbacks.push(callback);
      list.targets.push(target || null);
    };
    proto.hasEventListener = function(key, callback, target) {
      var list = this._callbackTable[key];
      if (!list) return false;
      var callbacks = list.callbacks;
      if (!callback) {
        if (list.isInvoking) {
          for (var i = 0; i < callbacks.length; i++) if (callbacks[i]) return true;
          return false;
        }
        return callbacks.length > 0;
      }
      target = target || null;
      var targets = list.targets;
      for (var _i = 0; _i < callbacks.length; ++_i) if (callbacks[_i] === callback && targets[_i] === target) return true;
      return false;
    };
    proto.removeAll = function(keyOrTarget) {
      if ("string" === typeof keyOrTarget) {
        var list = this._callbackTable[keyOrTarget];
        if (list) if (list.isInvoking) list.cancelAll(); else {
          callbackListPool.put(list);
          delete this._callbackTable[keyOrTarget];
        }
      } else if (keyOrTarget) for (var key in this._callbackTable) {
        var _list = this._callbackTable[key];
        if (_list.isInvoking) {
          var targets = _list.targets;
          for (var i = 0; i < targets.length; ++i) targets[i] === keyOrTarget && _list.cancel(i);
        } else _list.removeBy(_list.targets, keyOrTarget);
      }
    };
    proto.remove = function(key, callback, target) {
      var list = this._callbackTable[key];
      if (list) {
        target = target || null;
        var callbacks = list.callbacks;
        var targets = list.targets;
        for (var i = 0; i < callbacks.length; ++i) if (callbacks[i] === callback && targets[i] === target) {
          if (list.isInvoking) list.cancel(i); else {
            fastRemoveAt(callbacks, i);
            fastRemoveAt(targets, i);
          }
          break;
        }
      }
    };
    var CallbacksInvoker = function CallbacksInvoker() {
      CallbacksHandler.call(this);
    };
    js.extend(CallbacksInvoker, CallbacksHandler);
    false;
    CallbacksInvoker.prototype.invoke = function(key, p1, p2, p3, p4, p5) {
      var list = this._callbackTable[key];
      if (list) {
        var rootInvoker = !list.isInvoking;
        list.isInvoking = true;
        var callbacks = list.callbacks;
        var targets = list.targets;
        for (var i = 0, len = callbacks.length; i < len; ++i) {
          var callback = callbacks[i];
          if (callback) {
            var target = targets[i];
            target ? callback.call(target, p1, p2, p3, p4, p5) : callback(p1, p2, p3, p4, p5);
          }
        }
        if (rootInvoker) {
          list.isInvoking = false;
          list.containCanceled && list.purgeCanceled();
        }
      }
    };
    CallbacksInvoker.CallbacksHandler = CallbacksHandler;
    module.exports = CallbacksInvoker;
  }), {
    "./js": 138
  } ],
  132: [ (function(require, module, exports) {
    "use strict";
    function deepFlatten(strList, array) {
      for (var i = 0; i < array.length; i++) {
        var item = array[i];
        Array.isArray(item) ? deepFlatten(strList, item) : strList.push(item);
      }
    }
    function flattenCodeArray(array) {
      var separator = "";
      var strList = [];
      deepFlatten(strList, array);
      return strList.join(separator);
    }
    module.exports = {
      flattenCodeArray: flattenCodeArray
    };
  }), {} ],
  133: [ (function(require, module, exports) {
    "use strict";
    var js = require("./js");
    var Attr = require("./attribute");
    var CCClass = require("./CCClass");
    var misc = require("../utils/misc");
    var Details = function Details() {
      this.uuidList = [];
      this.uuidObjList = [];
      this.uuidPropList = [];
      this._stillUseUrl = js.createMap(true);
    };
    Details.prototype.reset = function() {
      this.uuidList.length = 0;
      this.uuidObjList.length = 0;
      this.uuidPropList.length = 0;
      js.clear(this._stillUseUrl);
    };
    false, false;
    Details.prototype.push = function(obj, propName, uuid, _stillUseUrl) {
      _stillUseUrl && (this._stillUseUrl[this.uuidList.length] = true);
      this.uuidList.push(uuid);
      this.uuidObjList.push(obj);
      this.uuidPropList.push(propName);
    };
    Details.pool = new js.Pool(function(obj) {
      obj.reset();
    }, 10);
    Details.pool.get = function() {
      return this._get() || new Details();
    };
    var _Deserializer = (function() {
      function _Deserializer(result, target, classFinder, customEnv, ignoreEditorOnly) {
        this.result = result;
        this.customEnv = customEnv;
        this.deserializedList = [];
        this.deserializedData = null;
        this._classFinder = classFinder;
        false;
        this._idList = [];
        this._idObjList = [];
        this._idPropList = [];
      }
      function _dereference(self) {
        var deserializedList = self.deserializedList;
        var idPropList = self._idPropList;
        var idList = self._idList;
        var idObjList = self._idObjList;
        var onDereferenced = self._classFinder && self._classFinder.onDereferenced;
        var i, propName, id;
        false;
        for (i = 0; i < idList.length; i++) {
          propName = idPropList[i];
          id = idList[i];
          idObjList[i][propName] = deserializedList[id];
        }
      }
      var prototype = _Deserializer.prototype;
      prototype.deserialize = function(jsonObj) {
        if (Array.isArray(jsonObj)) {
          var jsonArray = jsonObj;
          var refCount = jsonArray.length;
          this.deserializedList.length = refCount;
          for (var i = 0; i < refCount; i++) if (jsonArray[i]) {
            var mainTarget;
            false, false;
            this.deserializedList[i] = this._deserializeObject(jsonArray[i], false);
          }
          this.deserializedData = refCount > 0 ? this.deserializedList[0] : [];
        } else {
          this.deserializedList.length = 1;
          false, false;
          this.deserializedData = jsonObj ? this._deserializeObject(jsonObj, false) : null;
          this.deserializedList[0] = this.deserializedData;
        }
        _dereference(this);
        return this.deserializedData;
      };
      prototype._deserializeObject = function(serialized, _stillUseUrl, target, owner, propName) {
        var prop;
        var obj = null;
        var klass = null;
        var type = serialized.__type__;
        if (type) {
          klass = this._classFinder(type, serialized, owner, propName);
          if (!klass) {
            var notReported = this._classFinder === js._getClassById;
            notReported && cc.deserialize.reportMissingClass(type);
            return null;
          }
          if ((false, false) && target) {
            target instanceof klass || cc.warnID(5300, js.getClassName(target), klass);
            obj = target;
          } else obj = new klass();
          if (obj._deserialize) {
            obj._deserialize(serialized.content, this);
            return obj;
          }
          cc.Class._isCCClass(klass) ? _deserializeFireClass(this, obj, serialized, klass, target) : this._deserializeTypedObject(obj, serialized, klass);
        } else if (Array.isArray(serialized)) {
          if ((false, false) && target) {
            target.length = serialized.length;
            obj = target;
          } else obj = new Array(serialized.length);
          for (var i = 0; i < serialized.length; i++) {
            prop = serialized[i];
            if ("object" === typeof prop && prop) {
              false, false;
              this._deserializeObjField(obj, prop, "" + i, null, _stillUseUrl);
            } else obj[i] = prop;
          }
        } else {
          obj = (false, false) && target || {};
          this._deserializePrimitiveObject(obj, serialized);
        }
        return obj;
      };
      prototype._deserializeObjField = function(obj, jsonObj, propName, target, _stillUseUrl) {
        var id = jsonObj.__id__;
        if (void 0 === id) {
          var uuid = jsonObj.__uuid__;
          if (uuid) this.result.push(obj, propName, uuid, _stillUseUrl); else {
            false, false;
            obj[propName] = this._deserializeObject(jsonObj, _stillUseUrl);
          }
        } else {
          var dObj = this.deserializedList[id];
          if (dObj) obj[propName] = dObj; else {
            this._idList.push(id);
            this._idObjList.push(obj);
            this._idPropList.push(propName);
          }
        }
      };
      prototype._deserializePrimitiveObject = function(instance, serialized) {
        var self = this;
        for (var propName in serialized) if (serialized.hasOwnProperty(propName)) {
          var prop = serialized[propName];
          if ("object" !== typeof prop) "__type__" !== propName && (instance[propName] = prop); else if (prop) {
            false, false;
            self._deserializeObjField(instance, prop, propName);
          } else instance[propName] = null;
        }
      };
      prototype._deserializeTypedObject = function(instance, serialized, klass) {
        if (klass === cc.Vec2) {
          instance.x = serialized.x || 0;
          instance.y = serialized.y || 0;
          return;
        }
        if (klass === cc.Vec3) {
          instance.x = serialized.x || 0;
          instance.y = serialized.y || 0;
          instance.z = serialized.z || 0;
          return;
        }
        if (klass === cc.Color) {
          instance.r = serialized.r || 0;
          instance.g = serialized.g || 0;
          instance.b = serialized.b || 0;
          var a = serialized.a;
          instance.a = void 0 === a ? 255 : a;
          return;
        }
        if (klass === cc.Size) {
          instance.width = serialized.width || 0;
          instance.height = serialized.height || 0;
          return;
        }
        var DEFAULT = Attr.DELIMETER + "default";
        var attrs = Attr.getClassAttrs(klass);
        var fastDefinedProps = klass.__props__ || Object.keys(instance);
        for (var i = 0; i < fastDefinedProps.length; i++) {
          var propName = fastDefinedProps[i];
          var value = serialized[propName];
          void 0 !== value && serialized.hasOwnProperty(propName) || (value = CCClass.getDefault(attrs[propName + DEFAULT]));
          if ("object" !== typeof value) instance[propName] = value; else if (value) {
            false, false;
            this._deserializeObjField(instance, value, propName);
          } else instance[propName] = null;
        }
      };
      function compileObjectTypeJit(sources, defaultValue, accessorToSet, propNameLiteralToSet, assumeHavePropIfIsValue, stillUseUrl) {
        if (defaultValue instanceof cc.ValueType) {
          assumeHavePropIfIsValue || sources.push("if(prop){");
          var ctorCode = js.getClassName(defaultValue);
          sources.push("s._deserializeTypedObject(o" + accessorToSet + ",prop," + ctorCode + ");");
          assumeHavePropIfIsValue || sources.push("}else o" + accessorToSet + "=null;");
        } else {
          sources.push("if(prop){");
          sources.push("s._deserializeObjField(o,prop," + propNameLiteralToSet + (false, ",null,") + !!stillUseUrl + ");");
          sources.push("}else o" + accessorToSet + "=null;");
        }
      }
      var compileDeserialize = function(self, klass) {
        var fastMode = misc.BUILTIN_CLASSID_RE.test(js._getClassId(klass));
        var shouldCopyId = cc.js.isChildClassOf(klass, cc._BaseNode) || cc.js.isChildClassOf(klass, cc.Component);
        var shouldCopyRawData;
        var simpleProps = [];
        var simplePropsToRead = simpleProps;
        var advancedProps = [];
        var advancedPropsToRead = advancedProps;
        var advancedPropsUseUrl = [];
        var advancedPropsValueType = [];
        (function() {
          var props = klass.__values__;
          shouldCopyRawData = "_$erialized" === props[props.length - 1];
          var attrs = Attr.getClassAttrs(klass);
          var TYPE = Attr.DELIMETER + "type";
          var DEFAULT = Attr.DELIMETER + "default";
          var SAVE_URL_AS_ASSET = Attr.DELIMETER + "saveUrlAsAsset";
          var FORMERLY_SERIALIZED_AS = Attr.DELIMETER + "formerlySerializedAs";
          for (var p = 0; p < props.length; p++) {
            var propName = props[p];
            var propNameToRead = propName;
            attrs[propName + FORMERLY_SERIALIZED_AS] && (propNameToRead = attrs[propName + FORMERLY_SERIALIZED_AS]);
            var stillUseUrl = attrs[propName + SAVE_URL_AS_ASSET];
            var defaultValue = CCClass.getDefault(attrs[propName + DEFAULT]);
            var isPrimitiveType = false;
            if (fastMode) {
              var userType = attrs[propName + TYPE];
              if (void 0 === defaultValue && userType) isPrimitiveType = userType === cc.String || userType === cc.Integer || userType === cc.Float || userType === cc.Boolean; else {
                var defaultType = typeof defaultValue;
                isPrimitiveType = "string" === defaultType && !stillUseUrl || "number" === defaultType || "boolean" === defaultType;
              }
            }
            if (fastMode && isPrimitiveType) {
              propNameToRead !== propName && simplePropsToRead === simpleProps && (simplePropsToRead = simpleProps.slice());
              simpleProps.push(propName);
              simplePropsToRead !== simpleProps && simplePropsToRead.push(propNameToRead);
            } else {
              propNameToRead !== propName && advancedPropsToRead === advancedProps && (advancedPropsToRead = advancedProps.slice());
              advancedProps.push(propName);
              advancedPropsToRead !== advancedProps && advancedPropsToRead.push(propNameToRead);
              advancedPropsUseUrl.push(stillUseUrl);
              advancedPropsValueType.push(defaultValue instanceof cc.ValueType && defaultValue.constructor);
            }
          }
        })();
        return function(s, o, d, k, t) {
          for (var i = 0; i < simpleProps.length; ++i) {
            var _prop = d[simplePropsToRead[i]];
            void 0 !== _prop && (o[simpleProps[i]] = _prop);
          }
          for (var _i = 0; _i < advancedProps.length; ++_i) {
            var propName = advancedProps[_i];
            var prop = d[advancedPropsToRead[_i]];
            if (void 0 === prop) continue;
            if (fastMode || "object" === typeof prop) {
              var valueTypeCtor = advancedPropsValueType[_i];
              valueTypeCtor ? fastMode || prop ? s._deserializeTypedObject(o[propName], prop, valueTypeCtor) : o[propName] = null : prop ? s._deserializeObjField(o, prop, propName, (false, 
              null), advancedPropsUseUrl[_i]) : o[propName] = null;
            } else o[propName] = prop;
          }
          shouldCopyId && d._id && (o._id = d._id);
          if (shouldCopyRawData) {
            o._$erialized = JSON.parse(JSON.stringify(d));
            s._deserializePrimitiveObject(o._$erialized, d);
          }
        };
      };
      function unlinkUnusedPrefab(self, serialized, obj) {
        var uuid = serialized["asset"] && serialized["asset"].__uuid__;
        if (uuid) {
          var last = self.result.uuidList.length - 1;
          if (self.result.uuidList[last] === uuid && self.result.uuidObjList[last] === obj && "asset" === self.result.uuidPropList[last]) {
            self.result.uuidList.pop();
            self.result.uuidObjList.pop();
            self.result.uuidPropList.pop();
          } else {
            var debugEnvOnlyInfo = "Failed to skip prefab asset while deserializing PrefabInfo";
            cc.warn(debugEnvOnlyInfo);
          }
        }
      }
      function _deserializeFireClass(self, obj, serialized, klass, target) {
        var deserialize;
        if (klass.hasOwnProperty("__deserialize__")) deserialize = klass.__deserialize__; else {
          deserialize = compileDeserialize(self, klass);
          js.value(klass, "__deserialize__", deserialize, true);
        }
        deserialize(self, obj, serialized, klass, target);
        false, false;
      }
      _Deserializer.pool = new js.Pool(function(obj) {
        obj.result = null;
        obj.customEnv = null;
        obj.deserializedList.length = 0;
        obj.deserializedData = null;
        obj._classFinder = null;
        false;
        obj._idList.length = 0;
        obj._idObjList.length = 0;
        obj._idPropList.length = 0;
      }, 1);
      _Deserializer.pool.get = function(result, target, classFinder, customEnv, ignoreEditorOnly) {
        var cache = this._get();
        if (cache) {
          cache.result = result;
          cache.customEnv = customEnv;
          cache._classFinder = classFinder;
          false;
          return cache;
        }
        return new _Deserializer(result, target, classFinder, customEnv, ignoreEditorOnly);
      };
      return _Deserializer;
    })();
    cc.deserialize = function(data, details, options) {
      options = options || {};
      var classFinder = options.classFinder || js._getClassById;
      var createAssetRefs = options.createAssetRefs || cc.sys.platform === cc.sys.EDITOR_CORE;
      var target = (false, false) && options.target;
      var customEnv = options.customEnv;
      var ignoreEditorOnly = options.ignoreEditorOnly;
      false;
      "string" === typeof data && (data = JSON.parse(data));
      var tempDetails = !details;
      details = details || Details.pool.get();
      var deserializer = _Deserializer.pool.get(details, target, classFinder, customEnv, ignoreEditorOnly);
      cc.game._isCloning = true;
      var res = deserializer.deserialize(data);
      cc.game._isCloning = false;
      _Deserializer.pool.put(deserializer);
      createAssetRefs && details.assignAssetsBy(Editor.serialize.asAsset);
      tempDetails && Details.pool.put(details);
      return res;
    };
    cc.deserialize.Details = Details;
    cc.deserialize.reportMissingClass = function(id) {
      false;
      cc.warnID(5302, id);
    };
  }), {
    "../utils/misc": 204,
    "./CCClass": 118,
    "./attribute": 130,
    "./js": 138
  } ],
  134: [ (function(require, module, exports) {
    "use strict";
    var NonUuidMark = ".";
    function IdGenerater(category) {
      this.id = 0 | 998 * Math.random();
      this.prefix = category ? category + NonUuidMark : "";
    }
    IdGenerater.prototype.getNewId = function() {
      return this.prefix + ++this.id;
    };
    IdGenerater.global = new IdGenerater("global");
    module.exports = IdGenerater;
  }), {} ],
  135: [ (function(require, module, exports) {
    "use strict";
    require("./js");
    require("./CCClass");
    require("./CCClassDecorator");
    require("./CCEnum");
    require("./CCObject");
    require("./callbacks-invoker");
    require("./url");
    require("./deserialize");
    require("./instantiate");
    require("./instantiate-jit");
    require("./requiring-frame");
    require("./CCSys");
    require("./CCMacro");
    true;
    require("./CCAssetLibrary");
    require("./CCVisibleRect");
  }), {
    "./CCAssetLibrary": 117,
    "./CCClass": 118,
    "./CCClassDecorator": 119,
    "./CCEnum": 120,
    "./CCMacro": 123,
    "./CCObject": 124,
    "./CCSys": 127,
    "./CCVisibleRect": 129,
    "./callbacks-invoker": 131,
    "./deserialize": 133,
    "./instantiate": 137,
    "./instantiate-jit": 136,
    "./js": 138,
    "./requiring-frame": 140,
    "./url": 141
  } ],
  136: [ (function(require, module, exports) {
    "use strict";
    var CCObject = require("./CCObject");
    var Destroyed = CCObject.Flags.Destroyed;
    var PersistentMask = CCObject.Flags.PersistentMask;
    var Attr = require("./attribute");
    var js = require("./js");
    var CCClass = require("./CCClass");
    var Compiler = require("./compiler");
    var DEFAULT = Attr.DELIMETER + "default";
    var IDENTIFIER_RE = CCClass.IDENTIFIER_RE;
    var escapeForJS = CCClass.escapeForJS;
    var VAR = "var ";
    var LOCAL_OBJ = "o";
    var LOCAL_TEMP_OBJ = "t";
    var LOCAL_ARRAY = "a";
    var LINE_INDEX_OF_NEW_OBJ = 0;
    var DEFAULT_MODULE_CACHE = {
      "cc.Node": "cc.Node",
      "cc.Sprite": "cc.Sprite",
      "cc.Label": "cc.Label",
      "cc.Button": "cc.Button",
      "cc.Widget": "cc.Widget",
      "cc.Animation": "cc.Animation",
      "cc.ClickEvent": false,
      "cc.PrefabInfo": false
    };
    function Declaration(varName, expression) {
      this.varName = varName;
      this.expression = expression;
    }
    Declaration.prototype.toString = function() {
      return VAR + this.varName + "=" + this.expression + ";";
    };
    function mergeDeclaration(statement, expression) {
      return expression instanceof Declaration ? new Declaration(expression.varName, statement + expression.expression) : statement + expression;
    }
    function writeAssignment(codeArray, statement, expression) {
      if (Array.isArray(expression)) {
        expression[0] = mergeDeclaration(statement, expression[0]);
        codeArray.push(expression);
      } else codeArray.push(mergeDeclaration(statement, expression) + ";");
    }
    function Assignments(targetExpression) {
      this._exps = [];
      this._targetExp = targetExpression;
    }
    Assignments.prototype.append = function(key, expression) {
      this._exps.push([ key, expression ]);
    };
    Assignments.prototype.writeCode = function(codeArray) {
      var targetVar;
      if (this._exps.length > 1) {
        codeArray.push(LOCAL_TEMP_OBJ + "=" + this._targetExp + ";");
        targetVar = LOCAL_TEMP_OBJ;
      } else {
        if (1 !== this._exps.length) return;
        targetVar = this._targetExp;
      }
      for (var i = 0; i < this._exps.length; i++) {
        var pair = this._exps[i];
        writeAssignment(codeArray, targetVar + getPropAccessor(pair[0]) + "=", pair[1]);
      }
    };
    Assignments.pool = new js.Pool(function(obj) {
      obj._exps.length = 0;
      obj._targetExp = null;
    }, 1);
    Assignments.pool.get = function(targetExpression) {
      var cache = this._get() || new Assignments();
      cache._targetExp = targetExpression;
      return cache;
    };
    function equalsToDefault(def, value) {
      if ("function" === typeof def) try {
        def = def();
      } catch (e) {
        return false;
      }
      if (def === value) return true;
      if (def && value) {
        if (def instanceof cc.ValueType && def.equals(value)) return true;
        if (Array.isArray(def) && Array.isArray(value) || def.constructor === Object && value.constructor === Object) try {
          return Array.isArray(def) && Array.isArray(value) && 0 === def.length && 0 === value.length;
        } catch (e) {}
      }
      return false;
    }
    function getPropAccessor(key) {
      return IDENTIFIER_RE.test(key) ? "." + key : "[" + escapeForJS(key) + "]";
    }
    function Parser(obj, parent) {
      this.parent = parent;
      this.objsToClear_iN$t = [];
      this.codeArray = [];
      this.objs = [];
      this.funcs = [];
      this.funcModuleCache = js.createMap();
      js.mixin(this.funcModuleCache, DEFAULT_MODULE_CACHE);
      this.globalVariables = [];
      this.globalVariableId = 0;
      this.localVariableId = 0;
      this.codeArray.push(VAR + LOCAL_OBJ + "," + LOCAL_TEMP_OBJ + ";", "if(R){", LOCAL_OBJ + "=R;", "}else{", LOCAL_OBJ + "=R=new " + this.getFuncModule(obj.constructor, true) + "();", "}");
      js.value(obj, "_iN$t", {
        globalVar: "R"
      }, true);
      this.objsToClear_iN$t.push(obj);
      this.enumerateObject(this.codeArray, obj);
      var globalVariablesDeclaration;
      this.globalVariables.length > 0 && (globalVariablesDeclaration = VAR + this.globalVariables.join(",") + ";");
      var code = Compiler.flattenCodeArray([ "return (function(R){", globalVariablesDeclaration || [], this.codeArray, "return o;", "})" ]);
      this.result = Function("O", "F", code)(this.objs, this.funcs);
      for (var i = 0, len = this.objsToClear_iN$t.length; i < len; ++i) this.objsToClear_iN$t[i]._iN$t = null;
      this.objsToClear_iN$t.length = 0;
    }
    var proto = Parser.prototype;
    proto.getFuncModule = function(func, usedInNew) {
      var clsName = js.getClassName(func);
      if (clsName) {
        var cache = this.funcModuleCache[clsName];
        if (cache) return cache;
        if (void 0 === cache) {
          var clsNameIsModule = -1 !== clsName.indexOf(".");
          if (clsNameIsModule) try {
            clsNameIsModule = func === Function("return " + clsName)();
            if (clsNameIsModule) {
              this.funcModuleCache[clsName] = clsName;
              return clsName;
            }
          } catch (e) {}
        }
      }
      var index = this.funcs.indexOf(func);
      if (index < 0) {
        index = this.funcs.length;
        this.funcs.push(func);
      }
      var res = "F[" + index + "]";
      usedInNew && (res = "(" + res + ")");
      this.funcModuleCache[clsName] = res;
      return res;
    };
    proto.getObjRef = function(obj) {
      var index = this.objs.indexOf(obj);
      if (index < 0) {
        index = this.objs.length;
        this.objs.push(obj);
      }
      return "O[" + index + "]";
    };
    proto.setValueType = function(codeArray, defaultValue, srcValue, targetExpression) {
      var assignments = Assignments.pool.get(targetExpression);
      var fastDefinedProps = defaultValue.constructor.__props__;
      fastDefinedProps || (fastDefinedProps = Object.keys(defaultValue));
      for (var i = 0; i < fastDefinedProps.length; i++) {
        var propName = fastDefinedProps[i];
        var prop = srcValue[propName];
        if (defaultValue[propName] === prop) continue;
        var expression = this.enumerateField(srcValue, propName, prop);
        assignments.append(propName, expression);
      }
      assignments.writeCode(codeArray);
      Assignments.pool.put(assignments);
    };
    proto.enumerateCCClass = function(codeArray, obj, klass) {
      var props = klass.__values__;
      var attrs = Attr.getClassAttrs(klass);
      for (var p = 0; p < props.length; p++) {
        var key = props[p];
        var val = obj[key];
        var defaultValue = attrs[key + DEFAULT];
        if (equalsToDefault(defaultValue, val)) continue;
        if ("object" === typeof val && val instanceof cc.ValueType) {
          defaultValue = CCClass.getDefault(defaultValue);
          if (defaultValue && defaultValue.constructor === val.constructor) {
            var targetExpression = LOCAL_OBJ + getPropAccessor(key);
            this.setValueType(codeArray, defaultValue, val, targetExpression);
            continue;
          }
        }
        this.setObjProp(codeArray, obj, key, val);
      }
    };
    proto.instantiateArray = function(value) {
      if (0 === value.length) return "[]";
      var arrayVar = LOCAL_ARRAY + ++this.localVariableId;
      var declaration = new Declaration(arrayVar, "new Array(" + value.length + ")");
      var codeArray = [ declaration ];
      js.value(value, "_iN$t", {
        globalVar: "",
        source: codeArray
      }, true);
      this.objsToClear_iN$t.push(value);
      for (var i = 0; i < value.length; ++i) {
        var statement = arrayVar + "[" + i + "]=";
        var expression = this.enumerateField(value, i, value[i]);
        writeAssignment(codeArray, statement, expression);
      }
      return codeArray;
    };
    proto.enumerateField = function(obj, key, value) {
      if ("object" === typeof value && value) {
        var _iN$t = value._iN$t;
        if (_iN$t) {
          var globalVar = _iN$t.globalVar;
          if (!globalVar) {
            globalVar = _iN$t.globalVar = "v" + ++this.globalVariableId;
            this.globalVariables.push(globalVar);
            var line = _iN$t.source[LINE_INDEX_OF_NEW_OBJ];
            _iN$t.source[LINE_INDEX_OF_NEW_OBJ] = mergeDeclaration(globalVar + "=", line);
          }
          return globalVar;
        }
        return Array.isArray(value) ? this.instantiateArray(value) : this.instantiateObj(value);
      }
      if ("function" === typeof value) return this.getFuncModule(value);
      if ("string" === typeof value) return escapeForJS(value);
      "_objFlags" === key && obj instanceof CCObject && (value &= PersistentMask);
      return value;
    };
    proto.setObjProp = function(codeArray, obj, key, value) {
      var statement = LOCAL_OBJ + getPropAccessor(key) + "=";
      var expression = this.enumerateField(obj, key, value);
      writeAssignment(codeArray, statement, expression);
    };
    proto.enumerateObject = function(codeArray, obj) {
      var klass = obj.constructor;
      if (cc.Class._isCCClass(klass)) this.enumerateCCClass(codeArray, obj, klass); else for (var key in obj) {
        if (!obj.hasOwnProperty(key) || 95 === key.charCodeAt(0) && 95 === key.charCodeAt(1) && "__type__" !== key) continue;
        var value = obj[key];
        if ("object" === typeof value && value && value === obj._iN$t) continue;
        this.setObjProp(codeArray, obj, key, value);
      }
    };
    proto.instantiateObj = function(obj) {
      if (obj instanceof cc.ValueType) return CCClass.getNewValueTypeCode(obj);
      if (obj instanceof cc.Asset) return this.getObjRef(obj);
      if (obj._objFlags & Destroyed) return null;
      var createCode;
      var ctor = obj.constructor;
      if (cc.Class._isCCClass(ctor)) {
        if (this.parent) if (this.parent instanceof cc.Component) {
          if (obj instanceof cc._BaseNode || obj instanceof cc.Component) return this.getObjRef(obj);
        } else if (this.parent instanceof cc._BaseNode) if (obj instanceof cc._BaseNode) {
          if (!obj.isChildOf(this.parent)) return this.getObjRef(obj);
        } else if (obj instanceof cc.Component && !obj.node.isChildOf(this.parent)) return this.getObjRef(obj);
        createCode = new Declaration(LOCAL_OBJ, "new " + this.getFuncModule(ctor, true) + "()");
      } else if (ctor === Object) createCode = new Declaration(LOCAL_OBJ, "{}"); else {
        if (ctor) return this.getObjRef(obj);
        createCode = new Declaration(LOCAL_OBJ, "Object.create(null)");
      }
      var codeArray = [ createCode ];
      js.value(obj, "_iN$t", {
        globalVar: "",
        source: codeArray
      }, true);
      this.objsToClear_iN$t.push(obj);
      this.enumerateObject(codeArray, obj);
      return [ "(function(){", codeArray, "return o;})();" ];
    };
    function compile(node) {
      var root = node instanceof cc._BaseNode && node;
      var parser = new Parser(node, root);
      return parser.result;
    }
    module.exports = {
      compile: compile,
      equalsToDefault: equalsToDefault
    };
    false;
  }), {
    "./CCClass": 118,
    "./CCObject": 124,
    "./attribute": 130,
    "./compiler": 132,
    "./js": 138
  } ],
  137: [ (function(require, module, exports) {
    "use strict";
    var CCObject = require("./CCObject");
    var CCValueType = require("../value-types/value-type");
    var Destroyed = CCObject.Flags.Destroyed;
    var PersistentMask = CCObject.Flags.PersistentMask;
    var _isDomNode = require("./utils").isDomNode;
    var js = require("./js");
    function instantiate(original, internal_force) {
      if (!internal_force) {
        if ("object" !== typeof original || Array.isArray(original)) {
          false;
          return null;
        }
        if (!original) {
          false;
          return null;
        }
        if (!cc.isValid(original)) {
          false;
          return null;
        }
        false;
      }
      var clone;
      if (original instanceof CCObject) {
        if (original._instantiate) {
          cc.game._isCloning = true;
          clone = original._instantiate();
          cc.game._isCloning = false;
          return clone;
        }
        if (original instanceof cc.Asset) {
          false;
          return null;
        }
      }
      cc.game._isCloning = true;
      clone = doInstantiate(original);
      cc.game._isCloning = false;
      return clone;
    }
    var objsToClearTmpVar = [];
    function doInstantiate(obj, parent) {
      if (Array.isArray(obj)) {
        false;
        return null;
      }
      if (_isDomNode && _isDomNode(obj)) {
        false;
        return null;
      }
      var clone;
      if (obj._iN$t) clone = obj._iN$t; else if (obj.constructor) {
        var klass = obj.constructor;
        clone = new klass();
      } else clone = Object.create(null);
      enumerateObject(obj, clone, parent);
      for (var i = 0, len = objsToClearTmpVar.length; i < len; ++i) objsToClearTmpVar[i]._iN$t = null;
      objsToClearTmpVar.length = 0;
      return clone;
    }
    function enumerateCCClass(klass, obj, clone, parent) {
      var props = klass.__values__;
      for (var p = 0; p < props.length; p++) {
        var key = props[p];
        var value = obj[key];
        if ("object" === typeof value && value) {
          var initValue = clone[key];
          initValue instanceof CCValueType && initValue.constructor === value.constructor ? initValue.set(value) : clone[key] = value._iN$t || instantiateObj(value, parent);
        } else clone[key] = value;
      }
    }
    function enumerateObject(obj, clone, parent) {
      js.value(obj, "_iN$t", clone, true);
      objsToClearTmpVar.push(obj);
      var klass = obj.constructor;
      if (cc.Class._isCCClass(klass)) enumerateCCClass(klass, obj, clone, parent); else for (var key in obj) {
        if (!obj.hasOwnProperty(key) || 95 === key.charCodeAt(0) && 95 === key.charCodeAt(1) && "__type__" !== key) continue;
        var value = obj[key];
        if ("object" === typeof value && value) {
          if (value === clone) continue;
          clone[key] = value._iN$t || instantiateObj(value, parent);
        } else clone[key] = value;
      }
      obj instanceof CCObject && (clone._objFlags &= PersistentMask);
    }
    function instantiateObj(obj, parent) {
      if (obj instanceof CCValueType) return obj.clone();
      if (obj instanceof cc.Asset) return obj;
      var clone;
      if (Array.isArray(obj)) {
        var len = obj.length;
        clone = new Array(len);
        js.value(obj, "_iN$t", clone, true);
        for (var i = 0; i < len; ++i) {
          var value = obj[i];
          clone[i] = "object" === typeof value && value ? value._iN$t || instantiateObj(value, parent) : value;
        }
        objsToClearTmpVar.push(obj);
        return clone;
      }
      if (obj._objFlags & Destroyed) return null;
      var ctor = obj.constructor;
      if (cc.Class._isCCClass(ctor)) {
        if (parent) if (parent instanceof cc.Component) {
          if (obj instanceof cc._BaseNode || obj instanceof cc.Component) return obj;
        } else if (parent instanceof cc._BaseNode) if (obj instanceof cc._BaseNode) {
          if (!obj.isChildOf(parent)) return obj;
        } else if (obj instanceof cc.Component && !obj.node.isChildOf(parent)) return obj;
        clone = new ctor();
      } else if (ctor === Object) clone = {}; else {
        if (ctor) return obj;
        clone = Object.create(null);
      }
      enumerateObject(obj, clone, parent);
      return clone;
    }
    instantiate._clone = doInstantiate;
    cc.instantiate = instantiate;
    module.exports = instantiate;
  }), {
    "../value-types/value-type": 218,
    "./CCObject": 124,
    "./js": 138,
    "./utils": 142
  } ],
  138: [ (function(require, module, exports) {
    "use strict";
    var tempCIDGenerater = new (require("./id-generater"))("TmpCId.");
    function _getPropertyDescriptor(obj, name) {
      while (obj) {
        var pd = Object.getOwnPropertyDescriptor(obj, name);
        if (pd) return pd;
        obj = Object.getPrototypeOf(obj);
      }
      return null;
    }
    function _copyprop(name, source, target) {
      var pd = _getPropertyDescriptor(source, name);
      Object.defineProperty(target, name, pd);
    }
    var js = {
      isNumber: function isNumber(obj) {
        return "number" === typeof obj || obj instanceof Number;
      },
      isString: function isString(obj) {
        return "string" === typeof obj || obj instanceof String;
      },
      addon: function addon(obj) {
        obj = obj || {};
        for (var i = 1, length = arguments.length; i < length; i++) {
          var source = arguments[i];
          if (source) {
            if ("object" !== typeof source) {
              cc.errorID(5402, source);
              continue;
            }
            for (var name in source) name in obj || _copyprop(name, source, obj);
          }
        }
        return obj;
      },
      mixin: function mixin(obj) {
        obj = obj || {};
        for (var i = 1, length = arguments.length; i < length; i++) {
          var source = arguments[i];
          if (source) {
            if ("object" !== typeof source) {
              cc.errorID(5403, source);
              continue;
            }
            for (var name in source) _copyprop(name, source, obj);
          }
        }
        return obj;
      },
      extend: function extend(cls, base) {
        false;
        for (var p in base) base.hasOwnProperty(p) && (cls[p] = base[p]);
        cls.prototype = Object.create(base.prototype, {
          constructor: {
            value: cls,
            writable: true,
            configurable: true
          }
        });
        return cls;
      },
      getSuper: function getSuper(ctor) {
        var proto = ctor.prototype;
        var dunderProto = proto && Object.getPrototypeOf(proto);
        return dunderProto && dunderProto.constructor;
      },
      isChildClassOf: function isChildClassOf(subclass, superclass) {
        if (subclass && superclass) {
          if ("function" !== typeof subclass) return false;
          if ("function" !== typeof superclass) {
            false;
            return false;
          }
          if (subclass === superclass) return true;
          for (;;) {
            subclass = js.getSuper(subclass);
            if (!subclass) return false;
            if (subclass === superclass) return true;
          }
        }
        return false;
      },
      clear: function clear(obj) {
        var keys = Object.keys(obj);
        for (var i = 0; i < keys.length; i++) delete obj[keys[i]];
      },
      isEmptyObject: function isEmptyObject(obj) {
        for (var key in obj) return false;
        return true;
      },
      getPropertyDescriptor: _getPropertyDescriptor
    };
    var tmpValueDesc = {
      value: void 0,
      enumerable: false,
      writable: false,
      configurable: true
    };
    js.value = function(obj, prop, value, writable, enumerable) {
      tmpValueDesc.value = value;
      tmpValueDesc.writable = writable;
      tmpValueDesc.enumerable = enumerable;
      Object.defineProperty(obj, prop, tmpValueDesc);
      tmpValueDesc.value = void 0;
    };
    var tmpGetSetDesc = {
      get: null,
      set: null,
      enumerable: false
    };
    js.getset = function(obj, prop, getter, setter, enumerable, configurable) {
      if ("function" !== typeof setter) {
        enumerable = setter;
        setter = void 0;
      }
      tmpGetSetDesc.get = getter;
      tmpGetSetDesc.set = setter;
      tmpGetSetDesc.enumerable = enumerable;
      tmpGetSetDesc.configurable = configurable;
      Object.defineProperty(obj, prop, tmpGetSetDesc);
      tmpGetSetDesc.get = null;
      tmpGetSetDesc.set = null;
    };
    var tmpGetDesc = {
      get: null,
      enumerable: false,
      configurable: false
    };
    js.get = function(obj, prop, getter, enumerable, configurable) {
      tmpGetDesc.get = getter;
      tmpGetDesc.enumerable = enumerable;
      tmpGetDesc.configurable = configurable;
      Object.defineProperty(obj, prop, tmpGetDesc);
      tmpGetDesc.get = null;
    };
    var tmpSetDesc = {
      set: null,
      enumerable: false,
      configurable: false
    };
    js.set = function(obj, prop, setter, enumerable, configurable) {
      tmpSetDesc.set = setter;
      tmpSetDesc.enumerable = enumerable;
      tmpSetDesc.configurable = configurable;
      Object.defineProperty(obj, prop, tmpSetDesc);
      tmpSetDesc.set = null;
    };
    js.getClassName = function(objOrCtor) {
      if ("function" === typeof objOrCtor) {
        var prototype = objOrCtor.prototype;
        if (prototype && prototype.hasOwnProperty("__classname__") && prototype.__classname__) return prototype.__classname__;
        var retval = "";
        objOrCtor.name && (retval = objOrCtor.name);
        if (objOrCtor.toString) {
          var arr, str = objOrCtor.toString();
          arr = "[" === str.charAt(0) ? str.match(/\[\w+\s*(\w+)\]/) : str.match(/function\s*(\w+)/);
          arr && 2 === arr.length && (retval = arr[1]);
        }
        return "Object" !== retval ? retval : "";
      }
      if (objOrCtor && objOrCtor.constructor) return js.getClassName(objOrCtor.constructor);
      return "";
    };
    function isTempClassId(id) {
      return "string" !== typeof id || id.startsWith(tempCIDGenerater.prefix);
    }
    (function() {
      var _idToClass = {};
      var _nameToClass = {};
      function setup(key, publicName, table) {
        js.getset(js, publicName, (function() {
          return Object.assign({}, table);
        }), (function(value) {
          js.clear(table);
          Object.assign(table, value);
        }));
        return function(id, constructor) {
          constructor.prototype.hasOwnProperty(key) && delete table[constructor.prototype[key]];
          js.value(constructor.prototype, key, id);
          if (id) {
            var registered = table[id];
            if (registered && registered !== constructor) {
              var error = "A Class already exists with the same " + key + ' : "' + id + '".';
              false;
              cc.error(error);
            } else table[id] = constructor;
          }
        };
      }
      js._setClassId = setup("__cid__", "_registeredClassIds", _idToClass);
      var doSetClassName = setup("__classname__", "_registeredClassNames", _nameToClass);
      js.setClassName = function(className, constructor) {
        doSetClassName(className, constructor);
        if (!constructor.prototype.hasOwnProperty("__cid__")) {
          var id = className || tempCIDGenerater.getNewId();
          id && js._setClassId(id, constructor);
        }
      };
      js.unregisterClass = function() {
        for (var i = 0; i < arguments.length; i++) {
          var p = arguments[i].prototype;
          var classId = p.__cid__;
          classId && delete _idToClass[classId];
          var classname = p.__classname__;
          classname && delete _nameToClass[classname];
        }
      };
      js._getClassById = function(classId) {
        return _idToClass[classId];
      };
      js.getClassByName = function(classname) {
        return _nameToClass[classname];
      };
      js._getClassId = function(obj, allowTempId) {
        allowTempId = "undefined" === typeof allowTempId || allowTempId;
        var res;
        if ("function" === typeof obj && obj.prototype.hasOwnProperty("__cid__")) {
          res = obj.prototype.__cid__;
          if (!allowTempId && (false, false) && isTempClassId(res)) return "";
          return res;
        }
        if (obj && obj.constructor) {
          var prototype = obj.constructor.prototype;
          if (prototype && prototype.hasOwnProperty("__cid__")) {
            res = obj.__cid__;
            if (!allowTempId && (false, false) && isTempClassId(res)) return "";
            return res;
          }
        }
        return "";
      };
    })();
    js.obsolete = function(obj, obsoleted, newExpr, writable) {
      var extractPropName = /([^.]+)$/;
      var oldProp = extractPropName.exec(obsoleted)[0];
      var newProp = extractPropName.exec(newExpr)[0];
      function get() {
        false;
        return this[newProp];
      }
      writable ? js.getset(obj, oldProp, get, (function(value) {
        false;
        this[newProp] = value;
      })) : js.get(obj, oldProp, get);
    };
    js.obsoletes = function(obj, objName, props, writable) {
      for (var obsoleted in props) {
        var newName = props[obsoleted];
        js.obsolete(obj, objName + "." + obsoleted, newName, writable);
      }
    };
    var REGEXP_NUM_OR_STR = /(%d)|(%s)/;
    var REGEXP_STR = /%s/;
    js.formatStr = function() {
      var argLen = arguments.length;
      if (0 === argLen) return "";
      var msg = arguments[0];
      if (1 === argLen) return "" + msg;
      var hasSubstitution = "string" === typeof msg && REGEXP_NUM_OR_STR.test(msg);
      if (hasSubstitution) for (var i = 1; i < argLen; ++i) {
        var arg = arguments[i];
        var regExpToTest = "number" === typeof arg ? REGEXP_NUM_OR_STR : REGEXP_STR;
        regExpToTest.test(msg) ? msg = msg.replace(regExpToTest, arg) : msg += " " + arg;
      } else for (var _i = 1; _i < argLen; ++_i) msg += " " + arguments[_i];
      return msg;
    };
    js.shiftArguments = function() {
      var len = arguments.length - 1;
      var args = new Array(len);
      for (var i = 0; i < len; ++i) args[i] = arguments[i + 1];
      return args;
    };
    js.createMap = function(forceDictMode) {
      var map = Object.create(null);
      if (forceDictMode) {
        var INVALID_IDENTIFIER_1 = ".";
        var INVALID_IDENTIFIER_2 = "/";
        map[INVALID_IDENTIFIER_1] = true;
        map[INVALID_IDENTIFIER_2] = true;
        delete map[INVALID_IDENTIFIER_1];
        delete map[INVALID_IDENTIFIER_2];
      }
      return map;
    };
    function removeAt(array, index) {
      array.splice(index, 1);
    }
    function fastRemoveAt(array, index) {
      var length = array.length;
      if (index < 0 || index >= length) return;
      array[index] = array[length - 1];
      array.length = length - 1;
    }
    function remove(array, value) {
      var index = array.indexOf(value);
      if (index >= 0) {
        removeAt(array, index);
        return true;
      }
      return false;
    }
    function fastRemove(array, value) {
      var index = array.indexOf(value);
      if (index >= 0) {
        array[index] = array[array.length - 1];
        --array.length;
      }
    }
    function verifyType(array, type) {
      if (array && array.length > 0) for (var i = 0; i < array.length; i++) if (!(array[i] instanceof type)) {
        cc.logID(1300);
        return false;
      }
      return true;
    }
    function removeArray(array, minusArr) {
      for (var i = 0, l = minusArr.length; i < l; i++) remove(array, minusArr[i]);
    }
    function appendObjectsAt(array, addObjs, index) {
      array.splice.apply(array, [ index, 0 ].concat(addObjs));
      return array;
    }
    var indexOf = Array.prototype.indexOf;
    function contains(array, value) {
      return array.indexOf(value) >= 0;
    }
    function copy(array) {
      var i, len = array.length, arr_clone = new Array(len);
      for (i = 0; i < len; i += 1) arr_clone[i] = array[i];
      return arr_clone;
    }
    js.array = {
      remove: remove,
      fastRemove: fastRemove,
      removeAt: removeAt,
      fastRemoveAt: fastRemoveAt,
      contains: contains,
      verifyType: verifyType,
      removeArray: removeArray,
      appendObjectsAt: appendObjectsAt,
      copy: copy,
      indexOf: indexOf,
      MutableForwardIterator: require("../utils/mutable-forward-iterator")
    };
    function Pool(cleanupFunc, size) {
      if (void 0 === size) {
        size = cleanupFunc;
        cleanupFunc = null;
      }
      this.get = null;
      this.count = 0;
      this._pool = new Array(size);
      this._cleanup = cleanupFunc;
    }
    Pool.prototype._get = function() {
      if (this.count > 0) {
        --this.count;
        var cache = this._pool[this.count];
        this._pool[this.count] = null;
        return cache;
      }
      return null;
    };
    Pool.prototype.put = function(obj) {
      var pool = this._pool;
      if (this.count < pool.length) {
        if (this._cleanup && false === this._cleanup(obj)) return;
        pool[this.count] = obj;
        ++this.count;
      }
    };
    Pool.prototype.resize = function(length) {
      if (length >= 0) {
        this._pool.length = length;
        this.count > length && (this.count = length);
      }
    };
    js.Pool = Pool;
    cc.js = js;
    module.exports = js;
  }), {
    "../utils/mutable-forward-iterator": 205,
    "./id-generater": 134
  } ],
  139: [ (function(require, module, exports) {
    "use strict";
    var js = require("./js");
    var SerializableAttrs = {
      url: {
        canUsedInGet: true
      },
      default: {},
      serializable: {},
      editorOnly: {},
      formerlySerializedAs: {}
    };
    var TYPO_TO_CORRECT_DEV = false;
    function parseNotify(val, propName, notify, properties) {
      if (val.get || val.set) {
        false;
        return;
      }
      if (val.hasOwnProperty("default")) {
        var newKey = "_N$" + propName;
        val.get = function() {
          return this[newKey];
        };
        val.set = function(value) {
          var oldValue = this[newKey];
          this[newKey] = value;
          notify.call(this, oldValue);
        };
        false;
        var newValue = {};
        properties[newKey] = newValue;
        for (var attr in SerializableAttrs) {
          var v = SerializableAttrs[attr];
          if (val.hasOwnProperty(attr)) {
            newValue[attr] = val[attr];
            v.canUsedInGet || delete val[attr];
          }
        }
      } else false;
    }
    function checkUrl(val, className, propName, url) {
      Array.isArray(url) && url.length > 0 && (url = url[0]);
      false;
      val.type = url;
    }
    function parseType(val, type, className, propName) {
      if (Array.isArray(type)) {
        var isArray;
        false;
        if (!(type.length > 0)) return cc.errorID(5508, className, propName);
        if (cc.RawAsset.isRawAssetType(type[0])) {
          val.url = type[0];
          delete val.type;
          return;
        }
        val.type = type = type[0];
      }
      false;
    }
    function postCheckType(val, type, className, propName) {
      false;
    }
    function getBaseClassWherePropertyDefined_DEV(propName, cls) {
      var res;
      false;
    }
    exports.getFullFormOfProperty = function(options, propname_dev, classname_dev) {
      var isLiteral = options && options.constructor === Object;
      if (!isLiteral) {
        if (Array.isArray(options) && options.length > 0) {
          var type = options[0];
          false;
          return {
            default: [],
            type: options,
            _short: true
          };
        }
        if ("function" === typeof options) {
          var type = options;
          if (!cc.RawAsset.isRawAssetType(type)) {
            if (!cc.RawAsset.wasRawAssetType(type)) return {
              default: js.isChildClassOf(type, cc.ValueType) ? new type() : null,
              type: type,
              _short: true
            };
            false;
          }
          return {
            default: "",
            url: type,
            _short: true
          };
        }
        return {
          default: options,
          _short: true
        };
      }
      return null;
    };
    exports.preprocessAttrs = function(properties, className, cls, es6) {
      for (var propName in properties) {
        var val = properties[propName];
        var fullForm = exports.getFullFormOfProperty(val, propName, className);
        fullForm && (val = properties[propName] = fullForm);
        if (val) {
          var maybeTypeScript;
          false;
          var baseClass;
          false;
          var notify = val.notify;
          if (notify) {
            false;
            parseNotify(val, propName, notify, properties);
          }
          "type" in val && parseType(val, val.type, className, propName);
          "url" in val && checkUrl(val, className, propName, val.url);
          "type" in val && postCheckType(val, val.type, className, propName);
        }
      }
    };
    var CALL_SUPER_DESTROY_REG_DEV;
    false;
    exports.validateMethodWithProps = function(func, funcName, className, cls, base) {
      false;
      if ("function" !== typeof func && null !== func) {
        var overrided;
        var baseFuc;
        var subFuc;
        var correct;
        false;
        return false;
      }
      false;
      return true;
    };
  }), {
    "./CCClass": 118,
    "./js": 138
  } ],
  140: [ (function(require, module, exports) {
    "use strict";
    var requiringFrames = [];
    cc._RF = {
      push: function push(module, uuid, script) {
        if (void 0 === script) {
          script = uuid;
          uuid = "";
        }
        requiringFrames.push({
          uuid: uuid,
          script: script,
          module: module,
          exports: module.exports,
          beh: null
        });
      },
      pop: function pop() {
        var frameInfo = requiringFrames.pop();
        var module = frameInfo.module;
        var exports = module.exports;
        if (exports === frameInfo.exports) {
          for (var anyKey in exports) return;
          module.exports = exports = frameInfo.cls;
        }
      },
      peek: function peek() {
        return requiringFrames[requiringFrames.length - 1];
      }
    };
    false;
  }), {} ],
  141: [ (function(require, module, exports) {
    "use strict";
    cc.url = {
      _rawAssets: "",
      normalize: function normalize(url) {
        url && (46 === url.charCodeAt(0) && 47 === url.charCodeAt(1) ? url = url.slice(2) : 47 === url.charCodeAt(0) && (url = url.slice(1)));
        return url;
      },
      raw: function raw(url) {
        false;
        url = this.normalize(url);
        if (url.startsWith("resources/")) {
          var uuid = cc.loader._getResUuid(url.slice(10), cc.Asset, null, true);
          if (uuid) return cc.AssetLibrary.getLibUrlNoExt(uuid, true) + cc.path.extname(url);
        } else cc.errorID(7002, url);
        return this._rawAssets + url;
      },
      _init: function _init(assets) {
        this._rawAssets = cc.path.stripSep(assets) + "/";
      }
    };
    module.exports = cc.url;
  }), {} ],
  142: [ (function(require, module, exports) {
    "use strict";
    var js = require("./js");
    module.exports = {
      contains: function contains(refNode, otherNode) {
        if ("function" == typeof refNode.contains) return refNode.contains(otherNode);
        if ("function" == typeof refNode.compareDocumentPosition) return !!(16 & refNode.compareDocumentPosition(otherNode));
        var node = otherNode.parentNode;
        if (node) do {
          if (node === refNode) return true;
          node = node.parentNode;
        } while (null !== node);
        return false;
      },
      isDomNode: "object" === typeof window && ("function" === typeof Node ? function(obj) {
        return obj instanceof Node;
      } : function(obj) {
        return obj && "object" === typeof obj && "number" === typeof obj.nodeType && "string" === typeof obj.nodeName;
      }),
      callInNextTick: function(callback, p1, p2) {
        callback && setTimeout((function() {
          callback(p1, p2);
        }), 0);
      }
    };
    false;
    false;
  }), {
    "./js": 138
  } ],
  143: [ (function(require, module, exports) {
    "use strict";
    require("./platform/js");
    require("./value-types");
    require("./utils");
    require("./platform/CCInputManager");
    require("./platform/CCInputExtension");
    require("./event");
    require("./platform/CCSys");
    require("./platform/CCMacro");
    require("./load-pipeline");
    require("./CCDirector");
    require("./renderer");
    true;
    require("./platform/CCView");
    require("./platform/CCScreen");
    require("./CCScheduler");
    require("./event-manager");
  }), {
    "./CCDirector": 27,
    "./CCScheduler": 32,
    "./event": 88,
    "./event-manager": 84,
    "./load-pipeline": 103,
    "./platform/CCInputExtension": 121,
    "./platform/CCInputManager": 122,
    "./platform/CCMacro": 123,
    "./platform/CCScreen": 126,
    "./platform/CCSys": 127,
    "./platform/CCView": 128,
    "./platform/js": 138,
    "./renderer": 161,
    "./utils": 202,
    "./value-types": 213
  } ],
  144: [ (function(require, module, exports) {
    "use strict";
    var Device = function Device(canvasEL) {
      var ctx;
      try {
        ctx = canvasEL.getContext("2d");
      } catch (err) {
        console.error(err);
        return;
      }
      this._canvas = canvasEL;
      this._ctx = ctx;
      this._caps = {};
      this._stats = {
        drawcalls: 0
      };
      this._vx = this._vy = this._vw = this._vh = 0;
      this._sx = this._sy = this._sw = this._sh = 0;
    };
    Device.prototype._restoreTexture = function _restoreTexture(unit) {};
    Device.prototype.setViewport = function setViewport(x, y, w, h) {
      if (this._vx !== x || this._vy !== y || this._vw !== w || this._vh !== h) {
        this._vx = x;
        this._vy = y;
        this._vw = w;
        this._vh = h;
      }
    };
    Device.prototype.setScissor = function setScissor(x, y, w, h) {
      if (this._sx !== x || this._sy !== y || this._sw !== w || this._sh !== h) {
        this._sx = x;
        this._sy = y;
        this._sw = w;
        this._sh = h;
      }
    };
    Device.prototype.clear = function clear(color) {
      var ctx = this._ctx;
      ctx.clearRect(this._vx, this._vy, this._vw, this._vh);
      if (color && (0 !== color[0] || 0 !== color[1] || 0 !== color[2])) {
        ctx.fillStyle = "rgb(" + color[0] + "," + color[1] + "," + color[2] + ")";
        ctx.globalAlpha = color[3];
        ctx.fillRect(this._vx, this._vy, this._vw, this._vh);
      }
    };
    module.exports = Device;
  }), {} ],
  145: [ (function(require, module, exports) {
    "use strict";
    var Texture2D = function Texture2D(device, options) {
      this._device = device;
      this._width = 4;
      this._height = 4;
      this._image = null;
      if (options) {
        void 0 !== options.width && (this._width = options.width);
        void 0 !== options.height && (this._height = options.height);
        this.updateImage(options);
      }
    };
    Texture2D.prototype.update = function update(options) {
      this.updateImage(options);
    };
    Texture2D.prototype.updateImage = function updateImage(options) {
      if (options.images && options.images[0]) {
        var image = options.images[0];
        image && image !== this._image && (this._image = image);
      }
    };
    Texture2D.prototype.destroy = function destroy() {
      this._image = null;
    };
    module.exports = Texture2D;
  }), {} ],
  146: [ (function(require, module, exports) {
    "use strict";
    var ForwardRenderer = function ForwardRenderer() {};
    ForwardRenderer.prototype = {
      constructor: ForwardRenderer,
      clear: function clear() {},
      render: function render() {}
    };
    module.exports = ForwardRenderer;
  }), {} ],
  147: [ (function(require, module, exports) {
    "use strict";
    module.exports = {
      ForwardRenderer: require("./forward-renderer"),
      RenderComponentHandle: require("./render-component-handle"),
      _renderers: require("./renderers")
    };
  }), {
    "./forward-renderer": 146,
    "./render-component-handle": 148,
    "./renderers": 151
  } ],
  148: [ (function(require, module, exports) {
    "use strict";
    require("./renderers");
    var utils = require("./renderers/utils");
    var RenderComponentHandle = function RenderComponentHandle(device, defaultCamera) {
      this._device = device;
      this._camera = defaultCamera;
      this.parentOpacity = 1;
      this.parentOpacityDirty = 0;
      this.worldMatDirty = 0;
      this.walking = false;
    };
    RenderComponentHandle.prototype = {
      constructor: RenderComponentHandle,
      reset: function reset() {
        var ctx = this._device._ctx;
        var canvas = this._device._canvas;
        var color = cc.Camera.main ? cc.Camera.main.backgroundColor : cc.color();
        var rgba = "rgba(" + color.r + ", " + color.g + ", " + color.b + ", " + color.a / 255 + ")";
        ctx.fillStyle = rgba;
        ctx.setTransform(1, 0, 0, 1, 0, 0);
        ctx.clearRect(0, 0, canvas.width, canvas.height);
        ctx.fillRect(0, 0, canvas.width, canvas.height);
        this._device._stats.drawcalls = 0;
        utils.context.reset();
      },
      terminate: function terminate() {},
      _commitComp: function _commitComp(comp, assembler) {
        var ctx = this._device._ctx;
        var cam = this._camera;
        ctx.setTransform(cam.a, cam.b, cam.c, cam.d, cam.tx, cam.ty);
        ctx.scale(1, -1);
        assembler.draw(ctx, comp);
      }
    };
    module.exports = RenderComponentHandle;
  }), {
    "./renderers": 151,
    "./renderers/utils": 160
  } ],
  149: [ (function(require, module, exports) {
    "use strict";
    var Helper = require("../../../../graphics/helper");
    var Types = require("../../../../graphics/types");
    var js = require("../../../../platform/js");
    var PointFlags = Types.PointFlags;
    var LineJoin = Types.LineJoin;
    var LineCap = Types.LineCap;
    function Impl() {
      this.cmds = [];
      this.style = {
        strokeStyle: "black",
        fillStyle: "white",
        lineCap: "butt",
        lineJoin: "miter",
        miterLimit: 10
      };
    }
    var _proto = Impl.prototype;
    js.mixin(_proto, {
      moveTo: function moveTo(x, y) {
        this.cmds.push([ "moveTo", [ x, y ] ]);
      },
      lineTo: function lineTo(x, y) {
        this.cmds.push([ "lineTo", [ x, y ] ]);
      },
      bezierCurveTo: function bezierCurveTo(c1x, c1y, c2x, c2y, x, y) {
        this.cmds.push([ "bezierCurveTo", [ c1x, c1y, c2x, c2y, x, y ] ]);
      },
      quadraticCurveTo: function quadraticCurveTo(cx, cy, x, y) {
        this.cmds.push([ "quadraticCurveTo", [ cx, cy, x, y ] ]);
      },
      arc: function arc(cx, cy, r, startAngle, endAngle, counterclockwise) {
        Helper.arc(this, cx, cy, r, startAngle, endAngle, counterclockwise);
      },
      ellipse: function ellipse(cx, cy, rx, ry) {
        Helper.ellipse(this, cx, cy, rx, ry);
      },
      circle: function circle(cx, cy, r) {
        Helper.ellipse(this, cx, cy, r, r);
      },
      rect: function rect(x, y, w, h) {
        this.moveTo(x, y);
        this.lineTo(x, y + h);
        this.lineTo(x + w, y + h);
        this.lineTo(x + w, y);
        this.close();
      },
      roundRect: function roundRect(x, y, w, h, r) {
        Helper.roundRect(this, x, y, w, h, r);
      },
      clear: function clear(comp, clean) {
        this.cmds.length = 0;
      },
      close: function close() {
        this.cmds.push([ "closePath", [] ]);
      },
      stroke: function stroke() {
        this.cmds.push([ "stroke", [] ]);
      },
      fill: function fill() {
        this.cmds.push([ "fill", [] ]);
      }
    });
    js.set(_proto, "strokeColor", (function(v) {
      var strokeStyle = "rgba(" + (0 | v.r) + "," + (0 | v.g) + "," + (0 | v.b) + "," + v.a / 255 + ")";
      this.cmds.push([ "strokeStyle", strokeStyle ]);
      this.style.strokeStyle = strokeStyle;
    }));
    js.set(_proto, "fillColor", (function(v) {
      var fillStyle = "rgba(" + (0 | v.r) + "," + (0 | v.g) + "," + (0 | v.b) + "," + v.a / 255 + ")";
      this.cmds.push([ "fillStyle", fillStyle ]);
      this.style.fillStyle = fillStyle;
    }));
    js.set(_proto, "lineWidth", (function(v) {
      this.cmds.push([ "lineWidth", v ]);
      this.style.lineWidth = v;
    }));
    js.set(_proto, "lineCap", (function(v) {
      var lineCap = "butt";
      v === LineCap.BUTT ? lineCap = "butt" : v === LineCap.ROUND ? lineCap = "round" : v === LineCap.SQUARE && (lineCap = "square");
      this.cmds.push([ "lineCap", lineCap ]);
      this.style.lineCap = lineCap;
    }));
    js.set(_proto, "lineJoin", (function(v) {
      var lineJoin = "bevel";
      v === LineJoin.BEVEL ? lineJoin = "bevel" : v === LineJoin.ROUND ? lineJoin = "round" : v === LineJoin.MITER && (lineJoin = "miter");
      this.cmds.push([ "lineJoin", lineJoin ]);
      this.style.lineJoin = lineJoin;
    }));
    js.set(_proto, "miterLimit", (function(v) {
      this.cmds.push([ "miterLimit", v ]);
      this.style.miterLimit = v;
    }));
    module.exports = Impl;
  }), {
    "../../../../graphics/helper": 91,
    "../../../../graphics/types": 93,
    "../../../../platform/js": 138
  } ],
  150: [ (function(require, module, exports) {
    "use strict";
    var Impl = require("./impl");
    module.exports = {
      createImpl: function createImpl() {
        return new Impl();
      },
      draw: function draw(ctx, comp) {
        var node = comp.node;
        var matrix = node._worldMatrix;
        var a = matrix.m00, b = matrix.m01, c = matrix.m04, d = matrix.m05, tx = matrix.m12, ty = matrix.m13;
        ctx.transform(a, b, c, d, tx, ty);
        ctx.save();
        ctx.globalAlpha = node.opacity / 255;
        var style = comp._impl.style;
        ctx.strokeStyle = style.strokeStyle;
        ctx.fillStyle = style.fillStyle;
        ctx.lineWidth = style.lineWidth;
        ctx.lineJoin = style.lineJoin;
        ctx.miterLimit = style.miterLimit;
        var endPath = true;
        var cmds = comp._impl.cmds;
        for (var i = 0, l = cmds.length; i < l; i++) {
          var cmd = cmds[i];
          var ctxCmd = cmd[0], args = cmd[1];
          if ("moveTo" === ctxCmd && endPath) {
            ctx.beginPath();
            endPath = false;
          } else "fill" !== ctxCmd && "stroke" !== ctxCmd && "fillRect" !== ctxCmd || (endPath = true);
          "function" === typeof ctx[ctxCmd] ? ctx[ctxCmd].apply(ctx, args) : ctx[ctxCmd] = args;
        }
        ctx.restore();
        return 1;
      },
      stroke: function stroke(comp) {
        comp._impl.stroke();
      },
      fill: function fill(comp) {
        comp._impl.fill();
      }
    };
  }), {
    "./impl": 149
  } ],
  151: [ (function(require, module, exports) {
    "use strict";
    var js = require("../../../platform/js");
    var Sprite = require("../../../components/CCSprite");
    var Label = require("../../../components/CCLabel");
    var Mask = require("../../../components/CCMask");
    var Graphics = require("../../../graphics/graphics");
    var spriteRenderer = require("./sprite");
    var labelRenderer = require("./label");
    var graphicsRenderer = require("./graphics");
    var maskRenderer = require("./mask");
    var map = {};
    var postMap = {};
    function addRenderer(Component, handler, postHandler) {
      var name = js.getClassName(Component);
      map[name] = handler;
      postHandler && (postMap[name] = postHandler);
      Component._assembler = handler;
      Component._postAssembler = postHandler;
    }
    addRenderer(Sprite, spriteRenderer);
    addRenderer(Label, labelRenderer);
    Mask && addRenderer(Mask, maskRenderer.beforeHandler, maskRenderer.afterHandler);
    Graphics && addRenderer(Graphics, graphicsRenderer);
    module.exports = {
      map: map,
      postMap: postMap,
      addRenderer: addRenderer
    };
  }), {
    "../../../components/CCLabel": 64,
    "../../../components/CCMask": 68,
    "../../../components/CCSprite": 73,
    "../../../graphics/graphics": 90,
    "../../../platform/js": 138,
    "./graphics": 150,
    "./label": 153,
    "./mask": 155,
    "./sprite": 156
  } ],
  152: [ (function(require, module, exports) {
    "use strict";
    var bmfontUtils = require("../../../utils/label/bmfont");
    var js = require("../../../../platform/js");
    var utils = require("../utils");
    module.exports = js.addon({
      createData: function createData(comp) {
        return comp.requestRenderData();
      },
      appendQuad: function appendQuad(renderData, texture, rect, rotated, x, y, scale) {
        var dataOffset = renderData.dataLength;
        renderData.dataLength += 2;
        var data = renderData._data;
        var texw = texture.width, texh = texture.height;
        var rectWidth = rect.width, rectHeight = rect.height;
        var l = void 0, b = void 0, r = void 0, t = void 0;
        if (rotated) {
          l = rect.x;
          r = rect.x + rectHeight;
          b = rect.y;
          t = rect.y + rectWidth;
          data[dataOffset].u = l;
          data[dataOffset].v = t;
          data[dataOffset + 1].u = l;
          data[dataOffset + 1].v = b;
        } else {
          l = rect.x;
          r = rect.x + rectWidth;
          b = rect.y;
          t = rect.y + rectHeight;
          data[dataOffset].u = l;
          data[dataOffset].v = b;
          data[dataOffset + 1].u = r;
          data[dataOffset + 1].v = t;
        }
        data[dataOffset].x = x;
        data[dataOffset].y = y - rectHeight * scale;
        data[dataOffset + 1].x = x + rectWidth * scale;
        data[dataOffset + 1].y = y;
      },
      draw: function draw(ctx, comp) {
        var node = comp.node;
        var matrix = node._worldMatrix;
        var a = matrix.m00, b = matrix.m01, c = matrix.m04, d = matrix.m05, tx = matrix.m12, ty = matrix.m13;
        ctx.transform(a, b, c, d, tx, ty);
        ctx.scale(1, -1);
        utils.context.setGlobalAlpha(ctx, node.opacity / 255);
        var tex = comp._frame._texture, data = comp._renderData._data;
        var image = utils.getColorizedImage(tex, node._color);
        for (var i = 0, l = data.length; i < l; i += 2) {
          var x = data[i].x;
          var y = data[i].y;
          var w = data[i + 1].x - x;
          var h = data[i + 1].y - y;
          y = -y - h;
          var sx = data[i].u;
          var sy = data[i].v;
          var sw = data[i + 1].u - sx;
          var sh = data[i + 1].v - sy;
          ctx.drawImage(image, sx, sy, sw, sh, x, y, w, h);
        }
        return 1;
      }
    }, bmfontUtils);
  }), {
    "../../../../platform/js": 138,
    "../../../utils/label/bmfont": 165,
    "../utils": 160
  } ],
  153: [ (function(require, module, exports) {
    "use strict";
    var Label = require("../../../../components/CCLabel");
    var ttf = require("./ttf");
    var bmfont = require("./bmfont");
    var canvasPool = {
      pool: [],
      get: function get() {
        var data = this.pool.pop();
        if (!data) {
          var canvas = document.createElement("canvas");
          var context = canvas.getContext("2d");
          data = {
            canvas: canvas,
            context: context
          };
        }
        return data;
      },
      put: function put(canvas) {
        if (this.pool.length >= 32) return;
        this.pool.push(canvas);
      }
    };
    Label._canvasPool = canvasPool;
    module.exports = {
      getAssembler: function getAssembler(comp) {
        var assembler = ttf;
        comp.font instanceof cc.BitmapFont && (assembler = bmfont);
        return assembler;
      },
      createData: function createData(comp) {
        return comp._assembler.createData(comp);
      },
      draw: function draw(ctx, comp) {
        if (!comp._texture) return 0;
        var assembler = comp._assembler;
        if (!assembler) return 0;
        assembler.updateRenderData(comp);
        return assembler.draw(ctx, comp);
      }
    };
  }), {
    "../../../../components/CCLabel": 64,
    "./bmfont": 152,
    "./ttf": 154
  } ],
  154: [ (function(require, module, exports) {
    "use strict";
    var ttfUtils = require("../../../utils/label/ttf");
    var js = require("../../../../platform/js");
    var utils = require("../utils");
    module.exports = js.addon({
      createData: function createData(sprite) {
        var renderData = sprite.requestRenderData();
        renderData.dataLength = 2;
        return renderData;
      },
      _updateVerts: function _updateVerts(comp) {
        var renderData = comp._renderData;
        var node = comp.node, width = node.width, height = node.height, appx = node.anchorX * width, appy = node.anchorY * height;
        var data = renderData._data;
        data[0].x = -appx;
        data[0].y = -appy;
        data[1].x = width - appx;
        data[1].y = height - appy;
      },
      _updateTexture: function _updateTexture(comp) {
        ttfUtils._updateTexture(comp);
        var texture = comp._frame._texture;
        utils.dropColorizedImage(texture, comp.node.color);
      },
      draw: function draw(ctx, comp) {
        var node = comp.node;
        var matrix = node._worldMatrix;
        var a = matrix.m00, b = matrix.m01, c = matrix.m04, d = matrix.m05, tx = matrix.m12, ty = matrix.m13;
        ctx.transform(a, b, c, d, tx, ty);
        ctx.scale(1, -1);
        utils.context.setGlobalAlpha(ctx, node.opacity / 255);
        var tex = comp._frame._texture, data = comp._renderData._data;
        var image = tex.getHtmlElementObj();
        var x = data[0].x;
        var y = data[0].y;
        var w = data[1].x - x;
        var h = data[1].y - y;
        y = -y - h;
        ctx.drawImage(image, x, y, w, h);
        return 1;
      }
    }, ttfUtils);
  }), {
    "../../../../platform/js": 138,
    "../../../utils/label/ttf": 168,
    "../utils": 160
  } ],
  155: [ (function(require, module, exports) {
    "use strict";
    var Mask = require("../../../components/CCMask");
    var graphicsHandler = require("./graphics");
    var beforeHandler = {
      updateRenderData: function updateRenderData(comp) {},
      draw: function draw(ctx, mask) {
        ctx.save();
        graphicsHandler.draw(ctx, mask._graphics);
        ctx.clip();
      }
    };
    var afterHandler = {
      updateRenderData: function updateRenderData(comp) {},
      draw: function draw(ctx, mask) {
        ctx.restore();
      }
    };
    module.exports = {
      beforeHandler: beforeHandler,
      afterHandler: afterHandler
    };
  }), {
    "../../../components/CCMask": 68,
    "./graphics": 150
  } ],
  156: [ (function(require, module, exports) {
    "use strict";
    var Sprite = require("../../../../components/CCSprite");
    var SpriteType = Sprite.Type;
    var FillType = Sprite.FillType;
    var simple = require("./simple");
    var sliced = require("./sliced");
    var tiled = require("./tiled");
    false;
    module.exports = {
      getAssembler: function getAssembler(sprite) {
        switch (sprite.type) {
         case SpriteType.SIMPLE:
          return simple;

         case SpriteType.SLICED:
          return sliced;

         case SpriteType.TILED:
          return tiled;

         case SpriteType.FILLED:
          return sprite._fillType === FillType.RADIAL, null;
        }
      },
      createData: function createData(sprite) {
        return sprite._assembler.createData(sprite);
      }
    };
  }), {
    "../../../../components/CCSprite": 73,
    "../../../webgl/assemblers/sprite/index.js": 186,
    "./simple": 157,
    "./sliced": 158,
    "./tiled": 159
  } ],
  157: [ (function(require, module, exports) {
    "use strict";
    var utils = require("../utils");
    var renderer = {
      createData: function createData(sprite) {
        var renderData = sprite.requestRenderData();
        renderData.dataLength = 2;
        return renderData;
      },
      updateRenderData: function updateRenderData(sprite) {
        sprite._material || sprite._activateMaterial();
        var renderData = sprite._renderData;
        renderData.uvDirty && this.updateUVs(sprite);
        renderData.vertDirty && this.updateVerts(sprite);
      },
      updateUVs: function updateUVs(sprite) {
        var frame = sprite.spriteFrame;
        var renderData = sprite._renderData;
        var data = renderData._data;
        var rect = frame._rect;
        var texture = frame._texture;
        if (frame._rotated) {
          var l = rect.x;
          var r = rect.height;
          var b = rect.y;
          var t = rect.width;
          data[0].u = l;
          data[0].v = t;
          data[1].u = r;
          data[1].v = b;
        } else {
          var _l = rect.x;
          var _r = rect.width;
          var _b = rect.y;
          var _t = rect.height;
          data[0].u = _l;
          data[0].v = _b;
          data[1].u = _r;
          data[1].v = _t;
        }
        renderData.uvDirty = false;
      },
      updateVerts: function updateVerts(sprite) {
        var renderData = sprite._renderData, node = sprite.node, data = renderData._data, cw = node.width, ch = node.height, appx = node.anchorX * cw, appy = node.anchorY * ch, l = void 0, b = void 0, r = void 0, t = void 0;
        if (sprite.trim) {
          l = -appx;
          b = -appy;
          r = cw;
          t = ch;
        } else {
          var frame = sprite.spriteFrame, ow = frame._originalSize.width, oh = frame._originalSize.height, rw = frame._rect.width, rh = frame._rect.height, offset = frame._offset, scaleX = cw / ow, scaleY = ch / oh;
          var trimLeft = offset.x + (ow - rw) / 2;
          var trimRight = offset.x - (ow - rw) / 2;
          var trimBottom = offset.y + (oh - rh) / 2;
          var trimTop = offset.y - (oh - rh) / 2;
          l = trimLeft * scaleX - appx;
          b = trimBottom * scaleY - appy;
          r = cw;
          t = ch;
        }
        data[0].x = l;
        data[0].y = b;
        data[1].x = r;
        data[1].y = t;
        renderData.vertDirty = false;
      },
      draw: function draw(ctx, comp) {
        var node = comp.node;
        var matrix = node._worldMatrix;
        var a = matrix.m00, b = matrix.m01, c = matrix.m04, d = matrix.m05, tx = matrix.m12, ty = matrix.m13;
        ctx.transform(a, b, c, d, tx, ty);
        ctx.scale(1, -1);
        utils.context.setGlobalAlpha(ctx, node.opacity / 255);
        var tex = comp._spriteFrame._texture, data = comp._renderData._data;
        var image = utils.getColorizedImage(tex, node._color);
        var x = data[0].x;
        var y = data[0].y;
        var w = data[1].x;
        var h = data[1].y;
        y = -y - h;
        var sx = data[0].u;
        var sy = data[0].v;
        var sw = data[1].u;
        var sh = data[1].v;
        ctx.drawImage(image, sx, sy, sw, sh, x, y, w, h);
        return 1;
      }
    };
    module.exports = renderer;
  }), {
    "../utils": 160
  } ],
  158: [ (function(require, module, exports) {
    "use strict";
    var utils = require("../utils");
    var simple = require("./simple");
    var renderer = {
      createData: function createData(sprite) {
        var renderData = sprite.requestRenderData();
        renderData.dataLength = 4;
        return renderData;
      },
      updateRenderData: simple.updateRenderData,
      updateUVs: function updateUVs(sprite) {
        var frame = sprite.spriteFrame;
        var renderData = sprite._renderData;
        var rect = frame._rect;
        var texture = frame._texture;
        var leftWidth = frame.insetLeft;
        var rightWidth = frame.insetRight;
        var centerWidth = rect.width - leftWidth - rightWidth;
        var topHeight = frame.insetTop;
        var bottomHeight = frame.insetBottom;
        var centerHeight = rect.height - topHeight - bottomHeight;
        var data = renderData._data;
        if (frame._rotated) {
          data[0].u = rect.x;
          data[1].u = bottomHeight + rect.x;
          data[2].u = bottomHeight + centerHeight + rect.x;
          data[3].u = rect.x + rect.height;
          data[3].v = rect.y;
          data[2].v = leftWidth + rect.y;
          data[1].v = leftWidth + centerWidth + rect.y;
          data[0].v = rect.y + rect.width;
        } else {
          data[0].u = rect.x;
          data[1].u = leftWidth + rect.x;
          data[2].u = leftWidth + centerWidth + rect.x;
          data[3].u = rect.x + rect.width;
          data[3].v = rect.y;
          data[2].v = topHeight + rect.y;
          data[1].v = topHeight + centerHeight + rect.y;
          data[0].v = rect.y + rect.height;
        }
        renderData.uvDirty = false;
      },
      updateVerts: function updateVerts(sprite) {
        var renderData = sprite._renderData, data = renderData._data, node = sprite.node, width = node.width, height = node.height, appx = node.anchorX * width, appy = node.anchorY * height;
        var frame = sprite.spriteFrame;
        var rect = frame._rect;
        var leftWidth = frame.insetLeft;
        var rightWidth = frame.insetRight;
        var topHeight = frame.insetTop;
        var bottomHeight = frame.insetBottom;
        var sizableWidth = width - leftWidth - rightWidth;
        var sizableHeight = height - topHeight - bottomHeight;
        var xScale = width / (leftWidth + rightWidth);
        var yScale = height / (topHeight + bottomHeight);
        xScale = isNaN(xScale) || xScale > 1 ? 1 : xScale;
        yScale = isNaN(yScale) || yScale > 1 ? 1 : yScale;
        sizableWidth = sizableWidth < 0 ? 0 : sizableWidth;
        sizableHeight = sizableHeight < 0 ? 0 : sizableHeight;
        data[0].x = -appx;
        data[0].y = -appy;
        data[1].x = leftWidth * xScale - appx;
        data[1].y = bottomHeight * yScale - appy;
        data[2].x = data[1].x + sizableWidth;
        data[2].y = data[1].y + sizableHeight;
        data[3].x = width - appx;
        data[3].y = height - appy;
        renderData.vertDirty = false;
      },
      draw: function draw(ctx, comp) {
        var node = comp.node;
        var matrix = node._worldMatrix;
        var a = matrix.m00, b = matrix.m01, c = matrix.m04, d = matrix.m05, tx = matrix.m12, ty = matrix.m13;
        ctx.transform(a, b, c, d, tx, ty);
        ctx.scale(1, -1);
        utils.context.setGlobalAlpha(ctx, node.opacity / 255);
        var tex = comp._spriteFrame._texture, data = comp._renderData._data;
        var image = utils.getColorizedImage(tex, node._color);
        var drawCall = 0;
        var off = void 0, ld = void 0, rd = void 0, td = void 0, bd = void 0, x = void 0, y = void 0, w = void 0, h = void 0, sx = void 0, sy = void 0, sw = void 0, sh = void 0;
        for (var r = 0; r < 3; ++r) {
          bd = data[r];
          td = data[r + 1];
          for (var _c = 0; _c < 3; ++_c) {
            ld = data[_c];
            rd = data[_c + 1];
            x = ld.x;
            y = bd.y;
            w = rd.x - x;
            h = td.y - y;
            y = -y - h;
            sx = ld.u;
            sy = td.v;
            sw = rd.u - sx;
            sh = bd.v - sy;
            if (sw > 0 && sh > 0 && w > 0 && h > 0) {
              ctx.drawImage(image, sx, sy, sw, sh, x, y, w, h);
              drawCall++;
            }
          }
        }
        return drawCall;
      }
    };
    module.exports = renderer;
  }), {
    "../utils": 160,
    "./simple": 157
  } ],
  159: [ (function(require, module, exports) {
    "use strict";
    var utils = require("../utils");
    var renderer = {
      createData: function createData(sprite) {
        var renderData = sprite.requestRenderData();
        return renderData;
      },
      updateRenderData: function updateRenderData(sprite) {
        sprite._material || sprite._activateMaterial();
      },
      draw: function draw(ctx, sprite) {
        var node = sprite.node;
        var matrix = node._worldMatrix;
        var a = matrix.m00, b = matrix.m01, c = matrix.m04, d = matrix.m05, tx = matrix.m12, ty = matrix.m13;
        ctx.transform(a, b, c, d, tx, ty);
        ctx.scale(1, -1);
        utils.context.setGlobalAlpha(ctx, node.opacity / 255);
        var frame = sprite.spriteFrame;
        var rect = frame._rect;
        var tex = frame._texture;
        var sx = rect.x;
        var sy = rect.y;
        var sw = frame._rotated ? rect.height : rect.width;
        var sh = frame._rotated ? rect.width : rect.height;
        var image = utils.getFrameCache(tex, node._color, sx, sy, sw, sh);
        var w = node.width, h = node.height, x = -node.anchorX * w, y = -node.anchorY * h;
        y = -y - h;
        ctx.translate(x, y);
        ctx.fillStyle = ctx.createPattern(image, "repeat");
        ctx.fillRect(0, 0, w, h);
        return 1;
      }
    };
    module.exports = renderer;
  }), {
    "../utils": 160
  } ],
  160: [ (function(require, module, exports) {
    "use strict";
    var WHITE = 16777215;
    var MAX_CANVAS_COUNT = 32;
    function colorizedFrame(canvas, texture, color, sx, sy, sw, sh) {
      var image = texture._image;
      var ctx = canvas.getContext("2d");
      canvas.width = sw;
      canvas.height = sh;
      ctx.globalCompositeOperation = "source-over";
      ctx.fillStyle = "rgb(" + color.r + "," + color.g + "," + color.b + ")";
      ctx.fillRect(0, 0, sw, sh);
      ctx.globalCompositeOperation = "multiply";
      ctx.drawImage(image, sx, sy, sw, sh, 0, 0, sw, sh);
      ctx.globalCompositeOperation = "destination-atop";
      ctx.drawImage(image, sx, sy, sw, sh, 0, 0, sw, sh);
      return canvas;
    }
    var canvasMgr = {
      canvasMap: {},
      canvasUsed: {},
      canvasPool: [],
      checking: false,
      check: function check() {
        var exist = false;
        for (var key in this.canvasUsed) {
          exist = true;
          if (this.canvasUsed[key]) this.canvasUsed[key] = false; else {
            var canvas = this.canvasMap[key];
            canvas.width = 0;
            canvas.height = 0;
            this.canvasPool.length < 32 && this.canvasPool.push(canvas);
            delete this.canvasMap[key];
            delete this.canvasUsed[key];
          }
        }
        if (!exist) {
          cc.director.off(cc.Director.EVENT_AFTER_DRAW, this.check, this);
          this.checking = false;
        }
      },
      startCheck: function startCheck() {
        cc.director.on(cc.Director.EVENT_AFTER_DRAW, this.check, this);
        this.checking = true;
      },
      getCanvas: function getCanvas(key) {
        this.canvasUsed[key] = true;
        return this.canvasMap[key];
      },
      cacheCanvas: function cacheCanvas(canvas, key) {
        this.canvasMap[key] = canvas;
        this.canvasUsed[key] = true;
        this.checking || this.startCheck();
      },
      dropImage: function dropImage(key) {
        this.canvasMap[key] && delete this.canvasMap[key];
      }
    };
    module.exports = {
      getColorizedImage: function getColorizedImage(texture, color) {
        if (!texture) return null;
        if (0 === texture.width || 0 === texture.height) return texture._image;
        var cval = 16777215 & color._val;
        if (cval === WHITE) return texture._image;
        var key = texture.url + cval;
        var cache = canvasMgr.getCanvas(key);
        if (!cache) {
          cache = canvasMgr.canvasPool.pop() || document.createElement("canvas");
          colorizedFrame(cache, texture, color, 0, 0, texture.width, texture.height);
          canvasMgr.cacheCanvas(cache, key);
        }
        return cache;
      },
      getFrameCache: function getFrameCache(texture, color, sx, sy, sw, sh) {
        if (!texture || !texture.url || sx < 0 || sy < 0 || sw <= 0 || sh <= 0) return null;
        var key = texture.url;
        var generate = false;
        var cval = 16777215 & color._val;
        if (cval !== WHITE) {
          key += cval;
          generate = true;
        }
        if (0 !== sx || 0 !== sy && sw !== texture.width && sh !== texture.height) {
          key += "_" + sx + "_" + sy + "_" + sw + "_" + sh;
          generate = true;
        }
        if (!generate) return texture._image;
        var cache = canvasMgr.getCanvas(key);
        if (!cache) {
          cache = canvasMgr.canvasPool.pop() || document.createElement("canvas");
          colorizedFrame(cache, texture, color, sx, sy, sw, sh);
          canvasMgr.cacheCanvas(cache, key);
        }
        return cache;
      },
      dropColorizedImage: function dropColorizedImage(texture, color) {
        var key = texture.url + (16777215 & color._val);
        canvasMgr.dropImage(key);
      }
    };
    var _globalAlpha = -1;
    var context = {
      setGlobalAlpha: function setGlobalAlpha(ctx, alpha) {
        if (_globalAlpha === alpha) return;
        _globalAlpha = alpha;
        ctx.globalAlpha = _globalAlpha;
      },
      reset: function reset() {
        _globalAlpha = -1;
      }
    };
    module.exports.context = context;
  }), {} ],
  161: [ (function(require, module, exports) {
    "use strict";
    var _forwardRenderer = require("../../renderer/renderers/forward-renderer");
    var _forwardRenderer2 = _interopRequireDefault(_forwardRenderer);
    var _config = require("../../renderer/config");
    var _config2 = _interopRequireDefault(_config);
    var _gfx = require("../../renderer/gfx");
    var _gfx2 = _interopRequireDefault(_gfx);
    var _scene = require("../../renderer/scene/scene");
    var _scene2 = _interopRequireDefault(_scene);
    var _inputAssembler = require("../../renderer/core/input-assembler");
    var _inputAssembler2 = _interopRequireDefault(_inputAssembler);
    var _iaRenderData = require("../../renderer/render-data/ia-render-data");
    var _iaRenderData2 = _interopRequireDefault(_iaRenderData);
    var _pass = require("../../renderer/core/pass");
    var _pass2 = _interopRequireDefault(_pass);
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : {
        default: obj
      };
    }
    var RenderFlow = require("./render-flow");
    function _initBuiltins(device) {
      var defaultTexture = new _gfx2.default.Texture2D(device, {
        images: [],
        width: 128,
        height: 128,
        wrapS: _gfx2.default.WRAP_REPEAT,
        wrapT: _gfx2.default.WRAP_REPEAT,
        format: _gfx2.default.TEXTURE_FMT_RGB8,
        mipmap: false
      });
      return {
        defaultTexture: defaultTexture
      };
    }
    cc.renderer = module.exports = {
      Texture2D: null,
      InputAssembler: _inputAssembler2.default,
      IARenderData: _iaRenderData2.default,
      Pass: _pass2.default,
      renderEngine: null,
      canvas: null,
      device: null,
      scene: null,
      drawCalls: 0,
      _handle: null,
      _cameraNode: null,
      _camera: null,
      _forward: null,
      initWebGL: function initWebGL(canvas, opts) {
        require("./webgl/assemblers");
        var ModelBatcher = require("./webgl/model-batcher");
        this.Texture2D = _gfx2.default.Texture2D;
        this.canvas = canvas;
        false;
        this.device = new _gfx2.default.Device(canvas, opts);
        this.scene = new _scene2.default();
        this._handle = new ModelBatcher(this.device, this.scene);
        RenderFlow.init(this._handle);
        var builtins = _initBuiltins(this.device);
        this._forward = new _forwardRenderer2.default(this.device, builtins);
        _config2.default.addStage("shadowcast");
        _config2.default.addStage("opaque");
        _config2.default.addStage("transparent");
      },
      initCanvas: function initCanvas(canvas) {
        var canvasRenderer = require("./canvas");
        var Texture2D = require("./canvas/Texture2D");
        var Device = require("./canvas/Device");
        this.Device = Device;
        this.Texture2D = Texture2D;
        this.canvas = canvas;
        this.device = new Device(canvas);
        this._camera = {
          a: 1,
          b: 0,
          c: 0,
          d: 1,
          tx: 0,
          ty: 0
        };
        this._handle = new canvasRenderer.RenderComponentHandle(this.device, this._camera);
        RenderFlow.init(this._handle);
        this._forward = new canvasRenderer.ForwardRenderer();
      },
      updateCameraViewport: function updateCameraViewport() {
        if (true, cc.director) {
          var ecScene = cc.director.getScene();
          ecScene.setScale(1, 1, 1);
        }
        if (cc.game.renderType === cc.game.RENDER_TYPE_CANVAS) {
          var vp = cc.view.getViewportRect();
          this.device.setViewport(vp.x, vp.y, vp.width, vp.height);
          this._camera.a = cc.view.getScaleX();
          this._camera.d = cc.view.getScaleY();
          this._camera.tx = vp.x;
          this._camera.ty = vp.y + vp.height;
        }
      },
      render: function render(ecScene) {
        this.device._stats.drawcalls = 0;
        if (ecScene) {
          RenderFlow.visit(ecScene);
          this._forward.render(this.scene);
          this.drawCalls = this.device._stats.drawcalls;
        }
      },
      clear: function clear() {
        this._handle.reset();
        this._forward.clear();
      }
    };
  }), {
    "../../renderer/config": 243,
    "../../renderer/core/input-assembler": 246,
    "../../renderer/core/pass": 247,
    "../../renderer/gfx": 256,
    "../../renderer/render-data/ia-render-data": 275,
    "../../renderer/renderers/forward-renderer": 277,
    "../../renderer/scene/scene": 280,
    "./canvas": 147,
    "./canvas/Device": 144,
    "./canvas/Texture2D": 145,
    "./render-flow": 162,
    "./webgl/assemblers": 173,
    "./webgl/model-batcher": 189
  } ],
  162: [ (function(require, module, exports) {
    "use strict";
    var DONOTHING = 0;
    var LOCAL_TRANSFORM = 1;
    var WORLD_TRANSFORM = 2;
    var TRANSFORM = LOCAL_TRANSFORM | WORLD_TRANSFORM;
    var UPDATE_RENDER_DATA = 4;
    var OPACITY = 8;
    var RENDER = 16;
    var CUSTOM_IA_RENDER = 32;
    var CHILDREN = 64;
    var POST_UPDATE_RENDER_DATA = 128;
    var POST_RENDER = 256;
    var FINAL = 512;
    var _batcher = void 0;
    var _cullingMask = 0;
    function RenderFlow() {
      this._func = init;
      this._next = null;
    }
    var _proto = RenderFlow.prototype;
    _proto._doNothing = function() {};
    _proto._localTransform = function(node) {
      node._updateLocalMatrix();
      node._renderFlag &= ~LOCAL_TRANSFORM;
      this._next._func(node);
    };
    _proto._worldTransform = function(node) {
      _batcher.worldMatDirty++;
      var t = node._matrix;
      var position = node._position;
      t.m12 = position.x;
      t.m13 = position.y;
      t.m14 = position.z;
      node._mulMat(node._worldMatrix, node._parent._worldMatrix, t);
      node._renderFlag &= ~WORLD_TRANSFORM;
      this._next._func(node);
      _batcher.worldMatDirty--;
    };
    _proto._opacity = function(node) {
      _batcher.parentOpacityDirty++;
      var comp = node._renderComponent;
      comp && comp._updateColor && comp._updateColor();
      node._renderFlag &= ~OPACITY;
      this._next._func(node);
      _batcher.parentOpacityDirty--;
    };
    _proto._updateRenderData = function(node) {
      var comp = node._renderComponent;
      comp._assembler.updateRenderData(comp);
      node._renderFlag &= ~UPDATE_RENDER_DATA;
      this._next._func(node);
    };
    _proto._render = function(node) {
      var comp = node._renderComponent;
      _batcher._commitComp(comp, comp._assembler, node._cullingMask);
      this._next._func(node);
    };
    _proto._customIARender = function(node) {
      var comp = node._renderComponent;
      _batcher._commitIA(comp, comp._assembler, node._cullingMask);
      this._next._func(node);
    };
    _proto._children = function(node) {
      var cullingMask = _cullingMask;
      var batcher = _batcher;
      var parentOpacity = batcher.parentOpacity;
      var opacity = batcher.parentOpacity *= node._opacity / 255;
      var worldTransformFlag = batcher.worldMatDirty ? WORLD_TRANSFORM : 0;
      var worldOpacityFlag = batcher.parentOpacityDirty ? OPACITY : 0;
      var worldDirtyFlag = worldTransformFlag | worldOpacityFlag;
      var children = node._children;
      for (var i = 0, l = children.length; i < l; i++) {
        var c = children[i];
        c._renderFlag |= worldDirtyFlag;
        if (!c._activeInHierarchy || 0 === c._opacity) continue;
        var colorVal = c._color._val;
        c._color._fastSetA(c._opacity * opacity);
        flows[c._renderFlag]._func(c);
        c._color._val = colorVal;
      }
      batcher.parentOpacity = parentOpacity;
      this._next._func(node);
    };
    _proto._postUpdateRenderData = function(node) {
      var comp = node._renderComponent;
      comp._postAssembler && comp._postAssembler.updateRenderData(comp);
      node._renderFlag &= ~POST_UPDATE_RENDER_DATA;
      this._next._func(node);
    };
    _proto._postRender = function(node) {
      var comp = node._renderComponent;
      _batcher._commitComp(comp, comp._postAssembler, node._cullingMask);
      this._next._func(node);
    };
    var EMPTY_FLOW = new RenderFlow();
    EMPTY_FLOW._func = EMPTY_FLOW._doNothing;
    EMPTY_FLOW._next = EMPTY_FLOW;
    var flows = {};
    function createFlow(flag, next) {
      var flow = new RenderFlow();
      flow._next = next || EMPTY_FLOW;
      switch (flag) {
       case DONOTHING:
        flow._func = flow._doNothing;
        break;

       case LOCAL_TRANSFORM:
        flow._func = flow._localTransform;
        break;

       case WORLD_TRANSFORM:
        flow._func = flow._worldTransform;
        break;

       case OPACITY:
        flow._func = flow._opacity;
        break;

       case UPDATE_RENDER_DATA:
        flow._func = flow._updateRenderData;
        break;

       case RENDER:
        flow._func = flow._render;
        break;

       case CUSTOM_IA_RENDER:
        flow._func = flow._customIARender;
        break;

       case CHILDREN:
        flow._func = flow._children;
        break;

       case POST_UPDATE_RENDER_DATA:
        flow._func = flow._postUpdateRenderData;
        break;

       case POST_RENDER:
        flow._func = flow._postRender;
      }
      return flow;
    }
    function getFlow(flag) {
      var flow = null;
      var tFlag = FINAL;
      while (tFlag > 0) {
        tFlag & flag && (flow = createFlow(tFlag, flow));
        tFlag >>= 1;
      }
      return flow;
    }
    function init(node) {
      var flag = node._renderFlag;
      var r = flows[flag] = getFlow(flag);
      r._func(node);
    }
    RenderFlow.flows = flows;
    RenderFlow.createFlow = createFlow;
    RenderFlow.visit = function(scene) {
      _batcher.reset();
      _batcher.walking = true;
      _cullingMask = 1 << scene.groupIndex;
      if (scene._renderFlag & WORLD_TRANSFORM) {
        _batcher.worldMatDirty++;
        scene._calculWorldMatrix();
        scene._renderFlag &= ~WORLD_TRANSFORM;
        flows[scene._renderFlag]._func(scene);
        _batcher.worldMatDirty--;
      } else flows[scene._renderFlag]._func(scene);
      _batcher.terminate();
      _batcher.walking = false;
    };
    RenderFlow.init = function(batcher) {
      _batcher = batcher;
      flows[0] = EMPTY_FLOW;
      for (var i = 1; i < FINAL; i++) flows[i] = new RenderFlow();
    };
    RenderFlow.FLAG_DONOTHING = DONOTHING;
    RenderFlow.FLAG_LOCAL_TRANSFORM = LOCAL_TRANSFORM;
    RenderFlow.FLAG_WORLD_TRANSFORM = WORLD_TRANSFORM;
    RenderFlow.FLAG_TRANSFORM = TRANSFORM;
    RenderFlow.FLAG_OPACITY = OPACITY;
    RenderFlow.FLAG_UPDATE_RENDER_DATA = UPDATE_RENDER_DATA;
    RenderFlow.FLAG_RENDER = RENDER;
    RenderFlow.FLAG_CUSTOM_IA_RENDER = CUSTOM_IA_RENDER;
    RenderFlow.FLAG_CHILDREN = CHILDREN;
    RenderFlow.FLAG_POST_UPDATE_RENDER_DATA = POST_UPDATE_RENDER_DATA;
    RenderFlow.FLAG_POST_RENDER = POST_RENDER;
    RenderFlow.FLAG_FINAL = FINAL;
    module.exports = cc.RenderFlow = RenderFlow;
  }), {} ],
  163: [ (function(require, module, exports) {
    "use strict";
    var RenderTexture = require("../../../assets/CCRenderTexture");
    var space = 2;
    function Atlas(width, height) {
      var texture = new RenderTexture();
      texture.initWithSize(width, height);
      texture.update();
      this._texture = texture;
      this._x = space;
      this._y = space;
      this._nexty = space;
      this._width = width;
      this._height = height;
      this._innerTextureInfos = {};
      this._innerSpriteFrames = [];
    }
    Atlas.DEFAULT_HASH = new RenderTexture()._getHash();
    cc.js.mixin(Atlas.prototype, {
      insertSpriteFrame: function insertSpriteFrame(spriteFrame) {
        var rect = spriteFrame._rect, texture = spriteFrame._texture, info = this._innerTextureInfos[texture._id];
        var sx = rect.x, sy = rect.y;
        if (info) {
          sx += info.x;
          sy += info.y;
        } else {
          var width = texture.width, height = texture.height;
          if (this._x + width + space > this._width) {
            this._x = space;
            this._y = this._nexty;
          }
          this._y + height > this._nexty && (this._nexty = this._y + height + space);
          if (this._nexty > this._height) return null;
          this._texture.drawTextureAt(texture, this._x - 1, this._y);
          this._texture.drawTextureAt(texture, this._x + 1, this._y);
          this._texture.drawTextureAt(texture, this._x, this._y - 1);
          this._texture.drawTextureAt(texture, this._x, this._y + 1);
          this._texture.drawTextureAt(texture, this._x, this._y);
          this._innerTextureInfos[texture._id] = {
            x: this._x,
            y: this._y,
            texture: texture
          };
          sx += this._x;
          sy += this._y;
          this._x += width + space;
          this._dirty = true;
        }
        var frame = {
          x: sx,
          y: sy,
          texture: this._texture
        };
        this._innerSpriteFrames.push(spriteFrame);
        return frame;
      },
      update: function update() {
        if (!this._dirty) return;
        this._texture.update();
        this._dirty = false;
      },
      deleteInnerTexture: function deleteInnerTexture(texture) {
        texture && delete this._innerTextureInfos[texture._id];
      },
      reset: function reset() {
        this._x = space;
        this._y = space;
        this._nexty = space;
        var frames = this._innerSpriteFrames;
        for (var i = 0, l = frames.length; i < l; i++) {
          var frame = frames[i];
          if (!frame.isValid) continue;
          frame._resetDynamicAtlasFrame();
        }
        this._innerSpriteFrames.length = 0;
        this._innerTextureInfos = {};
      },
      destroy: function destroy() {
        this.reset();
        this._texture.destroy();
      }
    });
    module.exports = Atlas;
  }), {
    "../../../assets/CCRenderTexture": 43
  } ],
  164: [ (function(require, module, exports) {
    "use strict";
    var Atlas = require("./atlas");
    var _atlases = [];
    var _atlasIndex = -1;
    var _maxAtlasCount = 5;
    var _textureSize = 2048;
    var _minFrameSize = 8;
    var _maxFrameSize = 512;
    var _debugNode = null;
    function newAtlas() {
      var atlas = _atlases[++_atlasIndex];
      if (!atlas) {
        atlas = new Atlas(_textureSize, _textureSize);
        _atlases.push(atlas);
      }
      return atlas;
    }
    function beforeSceneLoad() {
      dynamicAtlasManager.reset();
    }
    var _enabled = false;
    var dynamicAtlasManager = {
      get enabled() {
        return _enabled;
      },
      set enabled(value) {
        if (_enabled === value) return;
        if (value) {
          this.reset();
          cc.director.on(cc.Director.EVENT_BEFORE_SCENE_LAUNCH, beforeSceneLoad);
        } else cc.director.off(cc.Director.EVENT_BEFORE_SCENE_LAUNCH, beforeSceneLoad);
        _enabled = value;
      },
      get maxAtlasCount() {
        return _maxAtlasCount;
      },
      set maxAtlasCount(value) {
        _maxAtlasCount = value;
      },
      get textureSize() {
        return _textureSize;
      },
      set textureSize(value) {
        _textureSize = value;
      },
      get maxFrameSize() {
        return _maxFrameSize;
      },
      set maxFrameSize(value) {
        _maxFrameSize = value;
      },
      insertSpriteFrame: function insertSpriteFrame(spriteFrame) {
        false;
        if (!_enabled || _atlasIndex === _maxAtlasCount || !spriteFrame || spriteFrame._original) return null;
        var texture = spriteFrame._texture;
        if (texture instanceof cc.RenderTexture || texture._isCompressed()) return null;
        var w = texture.width, h = texture.height;
        if (w > _maxFrameSize || h > _maxFrameSize || w <= _minFrameSize || h <= _minFrameSize || texture._getHash() !== Atlas.DEFAULT_HASH) return null;
        var atlas = _atlases[_atlasIndex];
        atlas || (atlas = newAtlas());
        var frame = atlas.insertSpriteFrame(spriteFrame);
        if (!frame && _atlasIndex !== _maxAtlasCount) {
          atlas = newAtlas();
          return atlas.insertSpriteFrame(spriteFrame);
        }
        return frame;
      },
      reset: function reset() {
        for (var i = 0, l = _atlases.length; i < l; i++) _atlases[i].destroy();
        _atlases.length = 0;
        _atlasIndex = -1;
      },
      deleteAtlasTexture: function deleteAtlasTexture(spriteFrame) {
        if (!spriteFrame._original) return;
        var texture = spriteFrame._original._texture;
        if (texture) for (var i = 0, l = _atlases.length; i < l; i++) _atlases[i].deleteInnerTexture(texture);
      },
      showDebug: false,
      update: function update() {
        if (!this.enabled) return;
        for (var i = 0; i <= _atlasIndex; i++) _atlases[i].update();
      }
    };
    module.exports = cc.dynamicAtlasManager = dynamicAtlasManager;
  }), {
    "./atlas": 163
  } ],
  165: [ (function(require, module, exports) {
    "use strict";
    var macro = require("../../../platform/CCMacro");
    var Label = require("../../../components/CCLabel");
    var Overflow = Label.Overflow;
    var textUtils = require("../../../utils/text-utils");
    var FontLetterDefinition = function FontLetterDefinition() {
      this._u = 0;
      this._v = 0;
      this._width = 0;
      this._height = 0;
      this._offsetX = 0;
      this._offsetY = 0;
      this._textureID = 0;
      this._validDefinition = false;
      this._xAdvance = 0;
    };
    cc.FontAtlas = function(texture) {
      this._letterDefinitions = {};
      this._texture = texture;
    };
    cc.FontAtlas.prototype = {
      constructor: cc.FontAtlas,
      addLetterDefinitions: function addLetterDefinitions(letter, letterDefinition) {
        this._letterDefinitions[letter] = letterDefinition;
      },
      cloneLetterDefinition: function cloneLetterDefinition() {
        var copyLetterDefinitions = {};
        for (var key in this._letterDefinitions) {
          var value = new FontLetterDefinition();
          cc.js.mixin(value, this._letterDefinitions[key]);
          copyLetterDefinitions[key] = value;
        }
        return copyLetterDefinitions;
      },
      assignLetterDefinitions: function assignLetterDefinitions(letterDefinition) {
        for (var key in this._letterDefinitions) {
          var newValue = letterDefinition[key];
          var oldValue = this._letterDefinitions[key];
          cc.js.mixin(oldValue, newValue);
        }
      },
      scaleFontLetterDefinition: function scaleFontLetterDefinition(scaleFactor) {
        for (var fontDefinition in this._letterDefinitions) {
          var letterDefinitions = this._letterDefinitions[fontDefinition];
          letterDefinitions._width *= scaleFactor;
          letterDefinitions._height *= scaleFactor;
          letterDefinitions._offsetX *= scaleFactor;
          letterDefinitions._offsetY *= scaleFactor;
          letterDefinitions._xAdvance *= scaleFactor;
        }
      },
      getLetterDefinitionForChar: function getLetterDefinitionForChar(char) {
        var hasKey = this._letterDefinitions.hasOwnProperty(char.charCodeAt(0));
        var letterDefinition = void 0;
        letterDefinition = hasKey ? this._letterDefinitions[char.charCodeAt(0)] : null;
        return letterDefinition;
      }
    };
    var FontAtlasManager = function FontAtlasManager() {
      this._fontAtlas = {};
      this._references = {};
      cc.director.on(cc.Director.EVENT_BEFORE_SCENE_LAUNCH, this.clear, this);
    };
    FontAtlasManager.prototype.getFontAtlas = function(comp) {
      var fontAsset = comp.font;
      var fntConfig = fontAsset._fntConfig;
      var name = fntConfig.atlasName;
      var atlas = this._fontAtlas[name];
      if (!atlas) {
        atlas = this.createFontAtlas(fontAsset);
        this._fontAtlas[name] = atlas;
      }
      this._references[name] || (this._references[name] = []);
      -1 === this._references[name].indexOf(comp.node._id) && this._references[name].push(comp.node._id);
      return this._fontAtlas[name];
    };
    FontAtlasManager.prototype.releaseFontAtlas = function(font, id) {
      if (!font) return;
      if (!(font instanceof cc.BitmapFont)) return;
      if (!font._fntConfig) return;
      var fntConfig = font._fntConfig;
      var name = fntConfig.atlasName;
      var reference = this._references[name];
      if (reference) for (var i = reference.length - 1; i >= 0; i--) if (reference[i] === id) {
        reference.splice(i, 1);
        break;
      }
      reference && 0 !== reference.length || delete this._fontAtlas[name];
    };
    FontAtlasManager.prototype.createFontAtlas = function(fontAsset) {
      var spriteFrame = fontAsset.spriteFrame;
      var fntConfig = fontAsset._fntConfig;
      var atlas = new cc.FontAtlas(spriteFrame.texture);
      var fontDict = fntConfig.fontDefDictionary;
      for (var fontDef in fontDict) {
        var letterDefinition = new FontLetterDefinition();
        var rect = fontDict[fontDef].rect;
        letterDefinition._offsetX = fontDict[fontDef].xOffset;
        letterDefinition._offsetY = fontDict[fontDef].yOffset;
        letterDefinition._width = rect.width;
        letterDefinition._height = rect.height;
        letterDefinition._u = rect.x;
        letterDefinition._v = rect.y;
        letterDefinition._textureID = 0;
        letterDefinition._validDefinition = true;
        letterDefinition._xAdvance = fontDict[fontDef].xAdvance;
        atlas.addLetterDefinitions(fontDef, letterDefinition);
      }
      return atlas;
    };
    FontAtlasManager.prototype.clear = function() {
      this._fontAtlas = {};
      this._references = {};
    };
    cc.Label.FontAtlasManager = new FontAtlasManager();
    var LetterInfo = function LetterInfo() {
      this._char = "";
      this._valid = true;
      this._positionX = 0;
      this._positionY = 0;
      this._lineIndex = 0;
    };
    var _tmpRect = cc.rect();
    var _comp = null;
    var _horizontalKernings = [];
    var _lettersInfo = [];
    var _linesWidth = [];
    var _linesOffsetX = [];
    var _labelDimensions = cc.size();
    var _fontAtlas = null;
    var _fntConfig = null;
    var _numberOfLines = 0;
    var _textDesiredHeight = 0;
    var _letterOffsetY = 0;
    var _tailoredTopY = 0;
    var _tailoredBottomY = 0;
    var _bmfontScale = 1;
    var _lineBreakWithoutSpaces = false;
    var _spriteFrame = null;
    var _lineSpacing = 0;
    var _string = "";
    var _fontSize = 0;
    var _originFontSize = 0;
    var _contentSize = cc.size();
    var _hAlign = 0;
    var _vAlign = 0;
    var _spacingX = 0;
    var _lineHeight = 0;
    var _overflow = 0;
    var _isWrapText = false;
    var _labelWidth = 0;
    var _labelHeight = 0;
    var _maxLineWidth = 0;
    module.exports = {
      updateRenderData: function updateRenderData(comp) {
        if (!comp._renderData.vertDirty) return;
        if (_comp === comp) return;
        _comp = comp;
        this._updateProperties();
        this._updateContent();
        _comp._actualFontSize = _fontSize;
        _comp.node.setContentSize(_contentSize);
        _comp._renderData.vertDirty = _comp._renderData.uvDirty = false;
        _comp = null;
        this._resetProperties();
      },
      _updateFontScale: function _updateFontScale() {
        _bmfontScale = _fontSize / _originFontSize;
      },
      _updateProperties: function _updateProperties() {
        var fontAsset = _comp.font;
        _spriteFrame = fontAsset.spriteFrame;
        _fntConfig = fontAsset._fntConfig;
        _fontAtlas = cc.Label.FontAtlasManager.getFontAtlas(_comp);
        _string = _comp.string.toString();
        _fontSize = _comp.fontSize;
        _originFontSize = _fntConfig.fontSize;
        _contentSize.width = _comp.node._contentSize.width;
        _contentSize.height = _comp.node._contentSize.height;
        _hAlign = _comp.horizontalAlign;
        _vAlign = _comp.verticalAlign;
        _spacingX = _comp.spacingX;
        _overflow = _comp.overflow;
        _lineHeight = _comp._lineHeight;
        _isWrapText = _overflow !== Overflow.NONE && (_overflow === Overflow.RESIZE_HEIGHT || _comp.enableWrapText);
        this._setupBMFontOverflowMetrics();
      },
      _resetProperties: function _resetProperties() {
        _fontAtlas = null;
        _fntConfig = null;
        _spriteFrame = null;
      },
      _updateContent: function _updateContent() {
        this._updateFontScale();
        this._computeHorizontalKerningForText();
        this._alignText();
      },
      _computeHorizontalKerningForText: function _computeHorizontalKerningForText() {
        var string = _string;
        var stringLen = string.length;
        var kerningDict = _fntConfig.kerningDict;
        var horizontalKernings = _horizontalKernings;
        var prev = -1;
        for (var i = 0; i < stringLen; ++i) {
          var key = string.charCodeAt(i);
          var kerningAmount = kerningDict[prev << 16 | 65535 & key] || 0;
          horizontalKernings[i] = i < stringLen - 1 ? kerningAmount : 0;
          prev = key;
        }
      },
      _multilineTextWrap: function _multilineTextWrap(nextTokenFunc) {
        var textLen = _string.length;
        var lineIndex = 0;
        var nextTokenX = 0;
        var nextTokenY = 0;
        var longestLine = 0;
        var letterRight = 0;
        var highestY = 0;
        var lowestY = 0;
        var letterDef = null;
        var letterPosition = cc.v2(0, 0);
        this._updateFontScale();
        var letterDefinitions = _fontAtlas._letterDefinitions;
        for (var index = 0; index < textLen; ) {
          var character = _string.charAt(index);
          if ("\n" === character) {
            _linesWidth.push(letterRight);
            letterRight = 0;
            lineIndex++;
            nextTokenX = 0;
            nextTokenY -= _lineHeight * _bmfontScale + _lineSpacing;
            this._recordPlaceholderInfo(index, character);
            index++;
            continue;
          }
          var tokenLen = nextTokenFunc(_string, index, textLen);
          var tokenHighestY = highestY;
          var tokenLowestY = lowestY;
          var tokenRight = letterRight;
          var nextLetterX = nextTokenX;
          var newLine = false;
          for (var tmp = 0; tmp < tokenLen; ++tmp) {
            var letterIndex = index + tmp;
            character = _string.charAt(letterIndex);
            if ("\r" === character) {
              this._recordPlaceholderInfo(letterIndex, character);
              continue;
            }
            letterDef = _fontAtlas.getLetterDefinitionForChar(character);
            if (!letterDef) {
              this._recordPlaceholderInfo(letterIndex, character);
              console.log("Can't find letter definition in texture atlas " + _fntConfig.atlasName + " for letter:" + character);
              continue;
            }
            var letterX = nextLetterX + letterDef._offsetX * _bmfontScale;
            if (_isWrapText && _maxLineWidth > 0 && nextTokenX > 0 && letterX + letterDef._width * _bmfontScale > _maxLineWidth && !textUtils.isUnicodeSpace(character)) {
              _linesWidth.push(letterRight);
              letterRight = 0;
              lineIndex++;
              nextTokenX = 0;
              nextTokenY -= _lineHeight * _bmfontScale + _lineSpacing;
              newLine = true;
              break;
            }
            letterPosition.x = letterX;
            letterPosition.y = nextTokenY - letterDef._offsetY * _bmfontScale;
            this._recordLetterInfo(letterDefinitions, letterPosition, character, letterIndex, lineIndex);
            letterIndex + 1 < _horizontalKernings.length && letterIndex < textLen - 1 && (nextLetterX += _horizontalKernings[letterIndex + 1]);
            nextLetterX += letterDef._xAdvance * _bmfontScale + _spacingX;
            tokenRight = letterPosition.x + letterDef._width * _bmfontScale;
            tokenHighestY < letterPosition.y && (tokenHighestY = letterPosition.y);
            tokenLowestY > letterPosition.y - letterDef._height * _bmfontScale && (tokenLowestY = letterPosition.y - letterDef._height * _bmfontScale);
          }
          if (newLine) continue;
          nextTokenX = nextLetterX;
          letterRight = tokenRight;
          highestY < tokenHighestY && (highestY = tokenHighestY);
          lowestY > tokenLowestY && (lowestY = tokenLowestY);
          longestLine < letterRight && (longestLine = letterRight);
          index += tokenLen;
        }
        _linesWidth.push(letterRight);
        _numberOfLines = lineIndex + 1;
        _textDesiredHeight = _numberOfLines * _lineHeight * _bmfontScale;
        _numberOfLines > 1 && (_textDesiredHeight += (_numberOfLines - 1) * _lineSpacing);
        _contentSize.width = _labelWidth;
        _contentSize.height = _labelHeight;
        _labelWidth <= 0 && (_contentSize.width = parseFloat(longestLine.toFixed(2)));
        _labelHeight <= 0 && (_contentSize.height = parseFloat(_textDesiredHeight.toFixed(2)));
        _tailoredTopY = _contentSize.height;
        _tailoredBottomY = 0;
        highestY > 0 && (_tailoredTopY = _contentSize.height + highestY);
        lowestY < -_textDesiredHeight && (_tailoredBottomY = _textDesiredHeight + lowestY);
        return true;
      },
      _getFirstCharLen: function _getFirstCharLen() {
        return 1;
      },
      _getFirstWordLen: function _getFirstWordLen(text, startIndex, textLen) {
        var character = text.charAt(startIndex);
        if (textUtils.isUnicodeCJK(character) || "\n" === character || textUtils.isUnicodeSpace(character)) return 1;
        var len = 1;
        var letterDef = _fontAtlas.getLetterDefinitionForChar(character);
        if (!letterDef) return len;
        var nextLetterX = letterDef._xAdvance * _bmfontScale + _spacingX;
        var letterX = void 0;
        for (var index = startIndex + 1; index < textLen; ++index) {
          character = text.charAt(index);
          letterDef = _fontAtlas.getLetterDefinitionForChar(character);
          if (!letterDef) break;
          letterX = nextLetterX + letterDef._offsetX * _bmfontScale;
          if (letterX + letterDef._width * _bmfontScale > _maxLineWidth && !textUtils.isUnicodeSpace(character) && _maxLineWidth > 0) return len;
          nextLetterX += letterDef._xAdvance * _bmfontScale + _spacingX;
          if ("\n" === character || textUtils.isUnicodeSpace(character) || textUtils.isUnicodeCJK(character)) break;
          len++;
        }
        return len;
      },
      _multilineTextWrapByWord: function _multilineTextWrapByWord() {
        return this._multilineTextWrap(this._getFirstWordLen);
      },
      _multilineTextWrapByChar: function _multilineTextWrapByChar() {
        return this._multilineTextWrap(this._getFirstCharLen);
      },
      _recordPlaceholderInfo: function _recordPlaceholderInfo(letterIndex, char) {
        if (letterIndex >= _lettersInfo.length) {
          var tmpInfo = new LetterInfo();
          _lettersInfo.push(tmpInfo);
        }
        _lettersInfo[letterIndex]._char = char;
        _lettersInfo[letterIndex]._valid = false;
      },
      _recordLetterInfo: function _recordLetterInfo(letterDefinitions, letterPosition, character, letterIndex, lineIndex) {
        if (letterIndex >= _lettersInfo.length) {
          var tmpInfo = new LetterInfo();
          _lettersInfo.push(tmpInfo);
        }
        character = character.charCodeAt(0);
        _lettersInfo[letterIndex]._lineIndex = lineIndex;
        _lettersInfo[letterIndex]._char = character;
        _lettersInfo[letterIndex]._valid = letterDefinitions[character]._validDefinition;
        _lettersInfo[letterIndex]._positionX = letterPosition.x;
        _lettersInfo[letterIndex]._position