"use strict";
cc._RF.push(module, '0cb3ek3it1FcqEsliDysOiN', 'player');
// script/game/player.ts

"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
var gamet_1 = require("./gamet");
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var NewClass = /** @class */ (function (_super) {
    __extends(NewClass, _super);
    function NewClass() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        //不可见属性
        _this._isSpeedDown = false;
        _this._moveTime = 0.3;
        _this._curRoad = 0;
        _this._game = null;
        //初始速度
        _this.speed = 0;
        //加速度
        _this.accel = 600;
        //最大速度
        _this.maxSpeed = 2000;
        _this.bg = null;
        _this.speedBt = null;
        return _this;
    }
    // LIFE-CYCLE CALLBACKS:
    NewClass.prototype.onLoad = function () {
        this.speedBt.node.on(cc.Node.EventType.TOUCH_START, this.speedDown, this);
    };
    NewClass.prototype.onDestroy = function () {
        //销毁按钮点击事件
        this.speedBt.node.off(cc.Node.EventType.TOUCH_START, this.speedDown, this);
    };
    NewClass.prototype.init = function (game) {
        this._game = game;
    };
    NewClass.prototype.start = function () {
    };
    NewClass.prototype.leftTurn = function () {
        if (this._curRoad > -1) {
            this.bg.runAction(cc.moveBy(this._moveTime, cc.v2(300.0)));
            this._curRoad -= 1;
        }
    };
    NewClass.prototype.speedDown = function () {
        if (this._isSpeedDown == false) {
            this._isSpeedDown = true;
        }
    };
    NewClass.prototype.speedTouch = function () {
        if (this._isSpeedDown == true) {
            this._isSpeedDown = false;
        }
    };
    NewClass.prototype.rightTurn = function () {
        if (this._curRoad < 1) {
            this.bg.runAction(cc.moveBy(this._moveTime, cc.v2(-300.0)));
            this._curRoad += 1;
        }
    };
    NewClass.prototype.update = function (dt) {
        if (this._game.isStateGameStart() == false)
            return;
        //点击减速按钮时设置减速状态
        if (this._isSpeedDown == true) {
            this.speed -= this.accel * dt;
            //当速度为0时结束游戏
            if (this.speed <= 0) {
                this._game.gameOver();
            }
        }
        //未点击时自动加速
        else {
            this.speed += this.accel * dt;
            if (this.speed > this.maxSpeed) {
                this.speed = this.maxSpeed;
            }
        }
    };
    __decorate([
        property(Boolean)
    ], NewClass.prototype, "_isSpeedDown", void 0);
    __decorate([
        property(Number)
    ], NewClass.prototype, "_moveTime", void 0);
    __decorate([
        property(Number)
    ], NewClass.prototype, "_curRoad", void 0);
    __decorate([
        property(gamet_1.default)
    ], NewClass.prototype, "_game", void 0);
    __decorate([
        property(Number)
    ], NewClass.prototype, "speed", void 0);
    __decorate([
        property(Number)
    ], NewClass.prototype, "accel", void 0);
    __decorate([
        property(Number)
    ], NewClass.prototype, "maxSpeed", void 0);
    __decorate([
        property(cc.Node)
    ], NewClass.prototype, "bg", void 0);
    __decorate([
        property(cc.Button)
    ], NewClass.prototype, "speedBt", void 0);
    NewClass = __decorate([
        ccclass
    ], NewClass);
    return NewClass;
}(cc.Component));
exports.default = NewClass;

cc._RF.pop();