"use strict";
cc._RF.push(module, '29ad1TWoNpBPqXW0Crzpwuj', 'gamet');
// script/game/gamet.ts

"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
var player_1 = require("./player");
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
//游戏状态枚举
var State;
(function (State) {
    State[State["stateGameReady"] = 0] = "stateGameReady";
    State[State["stateGameStart"] = 10] = "stateGameStart";
    State[State["stateGamePause"] = 20] = "stateGamePause";
    State[State["stateGameOver"] = 30] = "stateGameOver";
})(State || (State = {}));
;
var NewClass = /** @class */ (function (_super) {
    __extends(NewClass, _super);
    function NewClass() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this._state = 0;
        _this._dis = 0;
        _this.bg = null;
        _this.playerNode = null;
        _this._player = null;
        _this._enemyPool = null;
        _this._enemyList = [];
        _this.enemyPrefab = [];
        return _this;
    }
    // LIFE-CYCLE CALLBACKS:
    NewClass.prototype.onLoad = function () {
        cc.log(this.playerNode.height);
        //赋予游戏状态
        this._state = State.stateGameStart;
        //初始化对象
        this._player = this.playerNode.getComponent('player');
        this._player.init(this);
        var initEnemyCount = 10; //敌人暂时先创建10个
        //初始化对象池
        this._enemyPool = new cc.NodePool('enemy');
        for (var i = 0; i < initEnemyCount; i++) {
            var index = i % 3;
            var newEnemy = cc.instantiate(this.enemyPrefab[index]);
            this._enemyPool.put(newEnemy);
        }
        //显示隐藏相关代码
        // for (let i = 0; i < initEnemyCount; i++) {
        // let index = i % 3
        // this._enemyList[i] = cc.instantiate(this.enemyPrefab[index]);
        // this._enemyList[i].getComponent('enemy').reuse(this, this._player);
        // this._enemyList[i].parent = this.bg;
        // this._enemyList[i].active = false;
        // }
    };
    NewClass.prototype.onDestroy = function () {
        this._enemyPool.clear();
    };
    NewClass.prototype.start = function () {
        // cc.log(this._player.speed);
    };
    NewClass.prototype.update = function (dt) {
        var movedis = this._player.speed * dt;
        this._dis += movedis;
        if (this._dis >= 5 * this.playerNode.height - movedis) {
            this.createEnemy();
            this._dis = 0;
        }
    };
    /**
     * 生成敌人(NPC)
     */
    NewClass.prototype.createEnemy = function () {
        // cc.log("create enemy")
        // let Index = this._player._curRoad
        // let nodeW = 300;
        // let posx = 0;
        // let posy = 0;
        // let dis = 1440;
        // let rot = -1 * this.bg.angle * Math.PI / 180;
        // posx = Math.sin(rot) == 0 ? nodeW * Index : -1 * Math.sin(rot) * dis
        // posy = Math.cos(rot) == 0 ? nodeW * Index : Math.cos(rot) * dis
        //cc.log(posx, posy);
        //创建敌人
        //对象池相关
        var newEnemy = null;
        var posx = 0;
        var posy = 1440;
        if (this._enemyPool.size() > 0) {
            newEnemy = this._enemyPool.get(this, this._player);
        }
        else {
            newEnemy = cc.instantiate(this.enemyPrefab[2]);
            newEnemy.getComponent('enemy').reuse(this, this._player);
        }
        newEnemy.parent = this.bg;
        newEnemy.setPosition(cc.v2(posx, posy));
        //设置隐藏显示相关
        // let posx = 0;
        // let posy = 1440
        // let i = 0;
        // while (i < 10) {
        //     if (this._enemyList[i].active == false) {
        //         this._enemyList[i].active = true;
        //         this._enemyList[i].setPosition(cc.v2(posx, posy));
        //         return;
        //     }
        //     i++;
        // }
    };
    NewClass.prototype.isStateGameStart = function () {
        if (this._state == State.stateGameStart)
            return true;
        else
            return false;
    };
    /**
     * 游戏结束
     */
    NewClass.prototype.gameOver = function () {
        // cc.log("game over")
    };
    __decorate([
        property(cc.Integer)
    ], NewClass.prototype, "_state", void 0);
    __decorate([
        property(Number)
    ], NewClass.prototype, "_dis", void 0);
    __decorate([
        property(cc.Node)
    ], NewClass.prototype, "bg", void 0);
    __decorate([
        property(cc.Node)
    ], NewClass.prototype, "playerNode", void 0);
    __decorate([
        property(player_1.default)
    ], NewClass.prototype, "_player", void 0);
    __decorate([
        property(cc.NodePool)
    ], NewClass.prototype, "_enemyPool", void 0);
    __decorate([
        property([cc.Node])
    ], NewClass.prototype, "_enemyList", void 0);
    __decorate([
        property([cc.Prefab])
    ], NewClass.prototype, "enemyPrefab", void 0);
    NewClass = __decorate([
        ccclass
    ], NewClass);
    return NewClass;
}(cc.Component));
exports.default = NewClass;

cc._RF.pop();