"use strict";
cc._RF.push(module, 'c2ef3l6aVxCfLjJ82aV3xhQ', 'enemy');
// script/game/enemy.ts

"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
var gamet_1 = require("./gamet");
var player_1 = require("./player");
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var NewClass = /** @class */ (function (_super) {
    __extends(NewClass, _super);
    function NewClass() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.speed = 0;
        _this.pickRadius = 0; //碰撞距离
        _this._game = null;
        _this._player = null;
        return _this;
    }
    // LIFE-CYCLE CALLBACKS:
    NewClass.prototype.reuse = function (game, player) {
        this._game = game;
        this._player = player;
    };
    // onLoad () {}
    NewClass.prototype.start = function () {
    };
    NewClass.prototype.update = function (dt) {
        if (this._game.isStateGameStart() == false)
            return;
        //玩家与敌人碰撞游戏结束
        if (this.getPlayerDistance() < this.pickRadius) {
            this._game.gameOver();
            this.putEnemy();
            return;
        }
        var movedis = (this.speed - this._player.speed) * dt;
        // let movedis = -1 * this.speed * dt;
        this.node.y += movedis;
        if (this.isOutOfWindow() == true)
            this.putEnemy();
    };
    NewClass.prototype.getPlayerDistance = function () {
        //获取玩家相对于世界的位置
        var playerPos = this._player.node.convertToWorldSpaceAR(cc.v2(0, 0));
        //cc.log(playerPos)
        //获取敌人相对于世界的位置
        var enemyToWorldPos = this.node.convertToWorldSpaceAR(cc.v2(0, 0));
        //cc.log(enemyToWorldPos)
        //获取玩家与敌人之间的距离
        var dist = enemyToWorldPos.sub(playerPos).mag();
        return dist;
    };
    NewClass.prototype.isOutOfWindow = function () {
        var posx = this.node.getPosition().x;
        var posy = this.node.getPosition().y;
        if (posx < -1.1 * Math.floor(cc.winSize.height) || posx > 1.1 * Math.floor(cc.winSize.height) || posy < -1.1 * Math.floor(cc.winSize.height) || posy > 1.1 * Math.floor(cc.winSize.height))
            return true;
        else
            return false;
    };
    NewClass.prototype.putEnemy = function () {
        //将敌人对象放回对象池
        this._game._enemyPool.put(this.node);
        //设置隐藏(测试用)
        // this.node.active = false;
    };
    __decorate([
        property(Number)
    ], NewClass.prototype, "speed", void 0);
    __decorate([
        property(Number)
    ], NewClass.prototype, "pickRadius", void 0);
    __decorate([
        property(gamet_1.default)
    ], NewClass.prototype, "_game", void 0);
    __decorate([
        property(player_1.default)
    ], NewClass.prototype, "_player", void 0);
    NewClass = __decorate([
        ccclass
    ], NewClass);
    return NewClass;
}(cc.Component));
exports.default = NewClass;

cc._RF.pop();