cc.Class({
    extends: cc.Component,

    properties: {
        brush: cc.Node
    },

    // LIFE-CYCLE CALLBACKS:

    onLoad () {
        this.node.on('touchstart', this.onTouchStart, this);
        this.node.on('touchmove', this.onTouchMove, this);
    },

    onTouchStart(event) {
        // 设置画笔起始位置
        let pos = this.node.convertToNodeSpaceAR(event.getLocation());
        this.brush.getComponent('Brush').setBrushPos(pos.x, pos.y);
    },

    onTouchMove(event) {
        let pos = this.node.convertToNodeSpaceAR(event.getLocation());
        this.brush.getComponent('Brush').drawTo(pos.x, pos.y);
    }
    // update (dt) {},
});
