cc.Class({
    extends: require('./textureRenderUtils'),

    properties: {
       bg_node : cc.Node,
       show_cut : cc.Sprite,
    },
    onLoad(){
        let spriteFrame = new cc.SpriteFrame();
        this.show_img.spriteFrame = spriteFrame;
    },
    start () {
        cc.log('-------')
        cc.game.setFrameRate(60);
        this.init();

        var self = this;

        var g = this.bg_node.getComponent(cc.Graphics);
        g.lineWidth = 20;

        // var g = this.bg_node.getComponent(cc.Graphics);
        // g.lineWidth = 10;
        // g.fillColor.fromHEX('#ff0000');
        this.g = g;
        // g.moveTo(-20, 0);
        // g.lineTo(0, -100);
        // g.lineTo(20, 0);
        // g.lineTo(0, 100);
        // g.close();
        // g.stroke();
        // g.fill();

        //TOUCH_START
        this.node.on(cc.Node.EventType.TOUCH_START,function(touch,event){

            if (self.touchId != null) {
                return false;
            }

            self.touchId = touch.touch.__instanceId;
            var touchLoc = touch.getLocation();
            var locationInNode = self.gold.convertToNodeSpace(touchLoc);
            var size = self.gold.getContentSize();
            var rect = new cc.Rect(0, 0, size.width, size.height);
            //cc.log(touchLoc, locationInNode, rect, rect.contains(locationInNode));
            if(rect.contains(locationInNode)){
                self.pre_pos = touchLoc;
            }
            
            return true;

        }.bind(this),this.node)

        //TOUCH_MOVE
        this.node.on(cc.Node.EventType.TOUCH_MOVE,function(touch,event){

            if (self.touchId != touch.touch.__instanceId){
                return false;
            }
            var touchLoc = touch.getLocation();
            if(self.pre_pos){
                var locationInNode = self.gold.convertToNodeSpace(touchLoc);
                var size = self.gold.getContentSize();
                var rect = new cc.Rect(0, 0, size.width, size.height);
                //cc.log('move', locationInNode, rect, rect.contains(locationInNode));
                // if(rect.contains(locationInNode)){
                    var d = touch.getDelta();
                    self.gold.x += d.x
                    self.gold.y += d.y

                    this.renderSprite();
                    // this.texture.drawTextureAt(this.gold_sprite.spriteFrame.getTexture(), self.gold.x, self.gold.y);

                    this.show_img.spriteFrame.setTexture(this.texture);

                //}
                // self.g.lineWidth = 10;
                // self.g.fillColor.fromHEX('#ff0000');
                // self.g.moveTo(self.pre_pos.x, self.pre_pos.y);
                
                // cc.log('pos', self.pre_pos, touchLoc)
                // self.g.lineTo(touchLoc.x, touchLoc.y);
                // self.g.close();
                // self.g.stroke();
                // self.g.fill();


                // this.renderSprite();
                // var img = this.initImage();
                // let texture = new cc.Texture2D();
                // texture.initWithElement(img);
                // let spriteFrame = new cc.SpriteFrame();
                // spriteFrame.setTexture(texture);
                // this.show_img.spriteFrame = spriteFrame;
                self.pre_pos = touchLoc;
            }
           
            return true;
            
        }.bind(this),this.node)

        //TOUCH_END
        this.node.on(cc.Node.EventType.TOUCH_END,function(touch,event){
            if (self.touchId != touch.touch.__instanceId){
                return false;
            }
            self.pre_pos = null;
            console.log('TOUCH_END');

            self.touchId = null;
            var touchLoc = touch.getLocation();

        }.bind(this),this.node)
    },

    captureAndShow () {
        this.createSprite();
        var img = this.initImage();
        // this.showSprite(img);
        // download the pic as the file to your local
        this.label.string = 'Showing the capture'
        // this.saveFile('capture_to_web.png', img.src);

        let texture = new cc.Texture2D();
        texture.initWithElement(img);
        let spriteFrame = new cc.SpriteFrame();
        spriteFrame.setTexture(texture);
        this.show_cut.spriteFrame = spriteFrame;
    },

    saveFile (fileName, dataUrl) {
        let a = document.createElement('a');
        a.href = dataUrl;
        a.download = fileName;
        const event = document.createEvent('MouseEvents');
        event.initMouseEvent('click', true, false, window, 0, 0, 0, 0, 0, false, false, false, false, 0, null);
        a.dispatchEvent(event);
    }
});
