cc.Class({
    extends: cc.Component,

    properties: {
        testNode:cc.Node,
        maskNode:cc.Node
    },

    onLoad() {
    },
    //释放spine
    releaseClick(){
        let deps = cc.loader.getDependsRecursively("20001",sp.SkeletonData);
        cc.loader.releaseRes("20001",sp.SkeletonData);
        cc.loader.release(deps);
    },

    createClick(){
        this.removeNode();
        //构建普通节点的spine
        this.createSpine("20001",this.testNode);

        //构建mask组件内的spine
        this.createSpine("20001",this.maskNode);
    },

    createSpine(url,parent){
        let node = new cc.Node(); 
        node.parent = parent;
        cc.loader.loadRes(url, sp.SkeletonData, function(err, skeletonData) {
            let skeleton = node.addComponent(sp.Skeleton);
            skeleton.skeletonData = skeletonData;
            skeleton.premultipliedAlpha = false;
            skeleton.animation = ("animation")
        }.bind(this));
    },

    //移除节点
    removeNode(){
        let node = this.testNode.children[0];
        if (node) {
            node.destroy();
        }

        let node2 = this.maskNode.children[0];
        if (node2) {
            node2.destroy();
        }
        // this.testNode.removeChildByName("1005");
    },
    //如果需要接收指定服务端数据的通知 则使用这个方法
    //onRecvCmdAction(key ,data){},
    // start() {this._super();},

    // update (dt) {this._super();},
});
