(function() {"use strict";var __module = CC_EDITOR ? module : {exports:{}};var __filename = 'preview-scripts/assets/TestScene.js';var __require = CC_EDITOR ? function (request) {return cc.require(request, require);} : function (request) {return cc.require(request, __filename);};function __define (exports, require, module) {"use strict";
cc._RF.push(module, 'bd475qM2G1EI7oef1JG4mxN', 'TestScene', __filename);
// TestScene.js

"use strict";

cc.Class({
    extends: cc.Component,

    properties: {
        testNode: cc.Node,
        maskNode: cc.Node
    },

    onLoad: function onLoad() {},

    //释放spine
    releaseClick: function releaseClick() {
        var deps = cc.loader.getDependsRecursively("20001", sp.SkeletonData);
        cc.loader.releaseRes("20001", sp.SkeletonData);
        cc.loader.release(deps);
    },
    createClick: function createClick() {
        this.removeNode();
        //构建普通节点的spine
        this.createSpine("20001", this.testNode);

        //构建mask组件内的spine
        this.createSpine("20001", this.maskNode);
    },
    createSpine: function createSpine(url, parent) {
        var node = new cc.Node();
        node.parent = parent;
        cc.loader.loadRes(url, sp.SkeletonData, function (err, skeletonData) {
            var skeleton = node.addComponent(sp.Skeleton);
            skeleton.skeletonData = skeletonData;
            skeleton.premultipliedAlpha = false;
            skeleton.animation = "animation";
        }.bind(this));
    },


    //移除节点
    removeNode: function removeNode() {
        var node = this.testNode.children[0];
        if (node) {
            node.destroy();
        }

        var node2 = this.maskNode.children[0];
        if (node2) {
            node2.destroy();
        }
        // this.testNode.removeChildByName("1005");
    }
}
//如果需要接收指定服务端数据的通知 则使用这个方法
//onRecvCmdAction(key ,data){},
// start() {this._super();},

// update (dt) {this._super();},
);

cc._RF.pop();
        }
        if (CC_EDITOR) {
            __define(__module.exports, __require, __module);
        }
        else {
            cc.registerModuleFunc(__filename, function () {
                __define(__module.exports, __require, __module);
            });
        }
        })();
        //# sourceMappingURL=TestScene.js.map
        