System.register(["cc", "code-quality:cr", "./AStarNode.js"], function (_export, _context) {
  "use strict";

  var _cclegacy, _reporterNs, _decorator, Component, AStarNode, E_Node_Type, _dec, _class, _class2, _temp, _crd, ccclass, property, AStarMgr;

  function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

  function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

  function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

  function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

  function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

  function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

  function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

  function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

  function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

  function _reportPossibleCrUseOfAStarNode(extras) {
    _reporterNs.report("AStarNode", "./AStarNode", _context.meta, extras);
  }

  function _reportPossibleCrUseOfE_Node_Type(extras) {
    _reporterNs.report("E_Node_Type", "./AStarNode", _context.meta, extras);
  }

  _export({
    _dec: void 0,
    _class: void 0,
    _class2: void 0,
    _temp: void 0
  });

  return {
    setters: [function (_cc) {
      _cclegacy = _cc.cclegacy;
      _decorator = _cc._decorator;
      Component = _cc.Component;
    }, function (_codeQualityCr) {
      _reporterNs = _codeQualityCr;
    }, function (_AStarNodeJs) {
      AStarNode = _AStarNodeJs.AStarNode;
      E_Node_Type = _AStarNodeJs.E_Node_Type;
    }],
    execute: function () {
      _cclegacy._RF.push({}, "7823cv6QmlMkb4FfyafPntl", "AStarMgr", _context.meta);

      _crd = true;
      ccclass = _decorator.ccclass;
      property = _decorator.property; /// <summary>
      /// AStar寻路算法的基本原理就是不停的找自己周围的点，选出一个新的点作为起点再循环的找
      /// 1.寻路消耗公式：
      ///           f(寻路消耗)=g(离起点的距离)+h(离终点的距离)
      /// 2.开启列表：
      /// 每次从新的点找周围的点时，如果周围的点已经在开启列表或者关闭列表中了，我们就不去管它了
      /// 3.关闭列表：
      /// 每次往关闭列表中放点时，我们都应该判断这个点是不是和终点一样，如果是一样证明路径找完了，如果不一样，继续找。
      /// 4.格子对象的父对象   
      /// </summary>

      _export("AStarMgr", AStarMgr = (_dec = ccclass('AStartMgr'), _dec(_class = (_temp = _class2 = /*#__PURE__*/function (_Component) {
        _inherits(AStarMgr, _Component);

        _createClass(AStarMgr, null, [{
          key: "Instance",
          value: function Instance() {
            return this.instance;
          }
          /**
           * 地图的宽
           */

        }]);

        function AStarMgr() {
          var _this;

          _classCallCheck(this, AStarMgr);

          _this = _possibleConstructorReturn(this, _getPrototypeOf(AStarMgr).call(this));
          _this.nodes = new Array();
          _this.openLst = new Array();
          _this.closeLst = new Array();
          _this.path = new Array();
          AStarMgr.instance = _assertThisInitialized(_this);
          return _this;
        }

        _createClass(AStarMgr, [{
          key: "Init",
          value: function Init() {
            //AStarMgr.instance=this;
            console.log("初始化AStarMgr...");
          }
          /**
           * 初始化地图
           * @param w 地图的宽
           * @param h 地图的高
           */

        }, {
          key: "InitMapInfo",
          value: function InitMapInfo(w, h) {
            //根据宽高 创建格子 阻挡的问题 我们可以随机阻挡
            //因为我们现在没有地图相关的数据
            var self = this; //记录宽高

            self.mapW = w;
            self.mapH = h; //声明容器可以装多少个格子
            //self.nodes= new AStarNode[w][h];
            //生成格子

            for (var i = 0; i < w; ++i) {
              //console.log("self.nodes.length:" + self.nodes.length);
              self.nodes[i] = [];

              for (var j = 0; j < h; ++j) {
                //用三目运算符随机生成阻挡格子
                //应该从地图配置表读取生成的
                var nodeObj = new (_crd && AStarNode === void 0 ? (_reportPossibleCrUseOfAStarNode({
                  error: Error()
                }), AStarNode) : AStarNode)(i, j, self.RandomNum(0, 100) < 20 ? (_crd && E_Node_Type === void 0 ? (_reportPossibleCrUseOfE_Node_Type({
                  error: Error()
                }), E_Node_Type) : E_Node_Type).Stop : (_crd && E_Node_Type === void 0 ? (_reportPossibleCrUseOfE_Node_Type({
                  error: Error()
                }), E_Node_Type) : E_Node_Type).Walk);
                self.nodes[i][j] = nodeObj;
              }
            }
          }
          /**
           * 寻路方法
           * @param startPos 开始点
           * @param endPos 结束点
           */

        }, {
          key: "FindPath",
          value: function FindPath(startPos, endPos) {
            var self = this; //实际项目中 传入的点往往是 坐标系中的点
            //我们这里省略换算的步骤 直接认为它是传进来的格子坐标
            //首先判断 传入的两个点 是否合法
            //1.首先 要在地图范围内
            //如果不合法 应该直接 返回null 意味着不能寻路

            if (startPos.x < 0 || startPos.x >= this.mapW || startPos.y < 0 || startPos.y >= this.mapH || endPos.x < 0 || endPos.x >= this.mapW || endPos.y < 0 || endPos.y >= this.mapH) {
              console.log("开始或者结束点在地图格子范围外");
              return null;
            } //2.要不是阻挡
            //得到起点和终点  对应的格子


            var start = self.nodes[startPos.x][startPos.y];
            var end = self.nodes[endPos.x][endPos.y];

            if (start.type == (_crd && E_Node_Type === void 0 ? (_reportPossibleCrUseOfE_Node_Type({
              error: Error()
            }), E_Node_Type) : E_Node_Type).Stop || end.type == (_crd && E_Node_Type === void 0 ? (_reportPossibleCrUseOfE_Node_Type({
              error: Error()
            }), E_Node_Type) : E_Node_Type).Stop) {
              console.log("开始或者结束点是阻挡");
              return null;
            } //清空上一次相关的数据 避免他们影响  这一次的寻路计算
            //清空关闭和开启列表


            self.closeLst = [];
            self.openLst = []; //把开始点放入关闭列表中

            start.father = null;
            start.f = 0;
            start.g = 0;
            start.h = 0;
            self.closeLst.push(start);

            while (true) {
              //从起点开始 找周围的点 并放入开启列表中
              //左上  x-1 y-1
              self.FindNearlyNodeToOpenLst(start.x - 1, start.y - 1, 1.4, start, end); //上 x  y-1

              self.FindNearlyNodeToOpenLst(start.x, start.y - 1, 1, start, end); //右上  x+1 y-1

              self.FindNearlyNodeToOpenLst(start.x + 1, start.y - 1, 1.4, start, end); //左 x-1 y

              self.FindNearlyNodeToOpenLst(start.x - 1, start.y, 1, start, end); //右 x+1 y

              self.FindNearlyNodeToOpenLst(start.x + 1, start.y, 1, start, end); //左下 x-1 y+1

              self.FindNearlyNodeToOpenLst(start.x - 1, start.y + 1, 1.4, start, end); //下 x y+1

              self.FindNearlyNodeToOpenLst(start.x, start.y + 1, 1, start, end); //右下 x+1 y+1

              self.FindNearlyNodeToOpenLst(start.x + 1, start.y + 1, 1.4, start, end); //死路判断  开启列表为空 都还没有找到终点 就认为是死路

              if (self.openLst.length == 0) {
                console.log("死路...");
                return null;
              } //选出开启列表中 寻路消耗最小的点


              self.openLst.sort(self.SortOpenLst);
              console.log("****************");

              for (var i = 0; i < self.openLst.length; ++i) {
                var targetNode = self.openLst[i];
                console.log("点:" + targetNode.x + " ," + targetNode.y + "  :g=" + targetNode.g + "  h=" + targetNode.h + "  f=" + targetNode.f);
              } //放入关闭列表中 然后再从开启列表中移除


              self.closeLst.push(self.openLst[0]); //找得这个点 又变成新的起点 进入下一次寻路计算了

              start = self.openLst[0];
              self.openLst.shift(); //如果这个点已经是终点 那么得到最终结果返回出去
              //如果这个点 不是终点 那么继续寻路

              if (start == end) {
                //找完了 找到路径
                //返回路径
                self.path = [];
                self.path.push(end); //father是空时是找到start点，start点的father就是空

                while (end.father != null) {
                  self.path.push(end.father);
                  end = end.father;
                } //列表翻正得到正确的路径


                self.path.reverse();
                return self.path;
              }
            }
          }
          /**
           * 排序函数
           * @param a 
           * @param b 
           */

        }, {
          key: "SortOpenLst",
          value: function SortOpenLst(a, b) {
            if (a.f > b.f) return 1;else if (a.f == b.f) return 1;else return -1;
          }
          /**
           *  把临近的点放入开启列表中的函数
           * @param x 
           * @param y 
           * @param g 
           * @param father 
           * @param end 
           */

        }, {
          key: "FindNearlyNodeToOpenLst",
          value: function FindNearlyNodeToOpenLst(x, y, g, father, end) {
            var self = this; //边界判断

            if (x < 0 || x >= self.mapW || y < 0 || y >= self.mapH) return; //在范围内 再去取点

            var tempNode = self.nodes[x][y]; //判断这些点 是否是边界 是否是阻挡 是否在开启或者关闭列表 如果都不是 才放入开启列表

            if (tempNode == null || tempNode.type == (_crd && E_Node_Type === void 0 ? (_reportPossibleCrUseOfE_Node_Type({
              error: Error()
            }), E_Node_Type) : E_Node_Type).Stop || self.IsInArray(self.closeLst, tempNode) || self.IsInArray(self.openLst, tempNode)) return; //计算f值
            //f=g+h
            //记录父对象

            tempNode.father = father; //计算g  我离起点的距离  就是我父亲离起点的距离 +我离我父亲的距离

            tempNode.g = father.g + g; //曼哈顿街区算法

            tempNode.h = Math.abs(end.x - tempNode.x) + Math.abs(end.y - tempNode.y);
            tempNode.f = tempNode.g + tempNode.h; //如果通过了上面的合法验证 存放到开启列表中

            self.openLst.push(tempNode);
          }
          /**
           * 是否在数组里
           * @param arr 
           * @param target
           */

        }, {
          key: "IsInArray",
          value: function IsInArray(arr, target) {
            var isExit = false;
            arr.find(function (val) {
              if (val == target) return isExit = true;
            });
            return isExit;
          }
          /**
           * 生成随机数
           * @param min 最小值
           * @param max 最大值
           */

        }, {
          key: "RandomNum",
          value: function RandomNum(min, max) {
            switch (arguments.length) {
              case 1:
                return parseInt((Math.random() * min + 1).toString(), 10);
                break;

              case 2:
                return parseInt((Math.random() * (max - min + 1) + min).toString(), 10);
                break;

              default:
                return 0;
                break;
            }
          }
        }]);

        return AStarMgr;
      }(Component), _class2.instance = null, _temp)) || _class));

      _crd = false;

      _cclegacy._RF.pop();
    }
  };
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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