System.register(["cc", "code-quality:cr", "./Grid.js"], function (_export, _context) {
  "use strict";

  var _cclegacy, _reporterNs, _decorator, Component, Node, GraphicsComponent, systemEvent, SystemEventType, Color, Vec2, GridType, Grid, _dec, _dec2, _dec3, _class, _class2, _descriptor, _descriptor2, _temp, _crd, ccclass, property, AStar;

  function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

  function _initializerDefineProperty(target, property, descriptor, context) { if (!descriptor) return; Object.defineProperty(target, property, { enumerable: descriptor.enumerable, configurable: descriptor.configurable, writable: descriptor.writable, value: descriptor.initializer ? descriptor.initializer.call(context) : void 0 }); }

  function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

  function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

  function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

  function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

  function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

  function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

  function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

  function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

  function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) { var desc = {}; Object.keys(descriptor).forEach(function (key) { desc[key] = descriptor[key]; }); desc.enumerable = !!desc.enumerable; desc.configurable = !!desc.configurable; if ('value' in desc || desc.initializer) { desc.writable = true; } desc = decorators.slice().reverse().reduce(function (desc, decorator) { return decorator(target, property, desc) || desc; }, desc); if (context && desc.initializer !== void 0) { desc.value = desc.initializer ? desc.initializer.call(context) : void 0; desc.initializer = undefined; } if (desc.initializer === void 0) { Object.defineProperty(target, property, desc); desc = null; } return desc; }

  function _initializerWarningHelper(descriptor, context) { throw new Error('Decorating class property failed. Please ensure that ' + 'proposal-class-properties is enabled and runs after the decorators transform.'); }

  function _reportPossibleCrUseOfGridType(extras) {
    _reporterNs.report("GridType", "./Grid", _context.meta, extras);
  }

  function _reportPossibleCrUseOfGrid(extras) {
    _reporterNs.report("Grid", "./Grid", _context.meta, extras);
  }

  _export({
    _dec: void 0,
    _dec2: void 0,
    _dec3: void 0,
    _class: void 0,
    _class2: void 0,
    _descriptor: void 0,
    _descriptor2: void 0,
    _temp: void 0
  });

  return {
    setters: [function (_cc) {
      _cclegacy = _cc.cclegacy;
      _decorator = _cc._decorator;
      Component = _cc.Component;
      Node = _cc.Node;
      GraphicsComponent = _cc.GraphicsComponent;
      systemEvent = _cc.systemEvent;
      SystemEventType = _cc.SystemEventType;
      Color = _cc.Color;
      Vec2 = _cc.Vec2;
    }, function (_codeQualityCr) {
      _reporterNs = _codeQualityCr;
    }, function (_GridJs) {
      GridType = _GridJs.GridType;
      Grid = _GridJs.Grid;
    }],
    execute: function () {
      _cclegacy._RF.push({}, "f2f51STBOdFZrD5Lr/JJcb+", "AStar", _context.meta);

      _crd = true;
      ccclass = _decorator.ccclass;
      property = _decorator.property;

      _export("AStar", AStar = (_dec = ccclass('AStar'), _dec2 = property({
        type: Node
      }), _dec3 = property({
        type: GraphicsComponent
      }), _dec(_class = (_class2 = (_temp = /*#__PURE__*/function (_Component) {
        _inherits(AStar, _Component);

        /**
         * 格子列表
         */

        /**
         * 路径数组
         */

        /**
         * 开启列表
         */

        /**
         * 关闭列表
         */
        function AStar() {
          var _this;

          _classCallCheck(this, AStar);

          _this = _possibleConstructorReturn(this, _getPrototypeOf(AStar).call(this));

          _initializerDefineProperty(_this, "mapPos", _descriptor, _assertThisInitialized(_this));

          _initializerDefineProperty(_this, "map", _descriptor2, _assertThisInitialized(_this));

          _this.gridsLst = new Array();
          _this.path = null;
          _this.openLst = null;
          _this.closeLst = null;
          _this.map;
          return _this;
        }

        _createClass(AStar, [{
          key: "onLoad",
          value: function onLoad() {
            this.gridW = 50;
            this.gridH = 50;
            this.mapH = 15;
            this.mapW = 25;
            this.is8dir = true;
            systemEvent.on(SystemEventType.TOUCH_START, this.OnTouchStart, this);
            systemEvent.on(SystemEventType.TOUCH_MOVE, this.OnTouchMove, this);
            systemEvent.on(SystemEventType.TOUCH_START, this.OnTouchEnd, this); //初始化map
            //this.map=this.mapPos.getComponent<GraphicsComponent>();
            //初始化地图

            this.InitMap();
          }
          /**
           * 当触摸开始时
           */

        }, {
          key: "OnTouchStart",
          value: function OnTouchStart() {} // this.InitMap();

          /** 
           * 当触摸时
          */

        }, {
          key: "OnTouchMove",
          value: function OnTouchMove(event) {
            var pos = event.getLocation();
            var x = Math.floor(pos.x / (this.gridW + 2));
            var y = Math.floor(pos.y / (this.gridH + 2));

            if (this.gridsLst[x][y].type == (_crd && GridType === void 0 ? (_reportPossibleCrUseOfGridType({
              error: Error()
            }), GridType) : GridType).Normal) {
              this.gridsLst[x][y].type = (_crd && GridType === void 0 ? (_reportPossibleCrUseOfGridType({
                error: Error()
              }), GridType) : GridType).Barrier;
              this.Draw(x, y, Color.CYAN);
            }
          }
          /**
           * 当触摸结束时
           */

        }, {
          key: "OnTouchEnd",
          value: function OnTouchEnd() {
            // 开始寻路
            this.FindPath(new Vec2(1, 2), new Vec2(16, 3));
          }
          /**
           * 初始化地图
           */

        }, {
          key: "InitMap",
          value: function InitMap() {
            this.openLst = new Array();
            this.closeLst = new Array();
            this.path = new Array(); // 初始化格子二维数组

            this.gridsLst = new Array(this.mapW + 1);

            for (var col = 0; col < this.gridsLst.length; col++) {
              this.gridsLst[col] = new Array(this.mapH + 1);
            }

            console.log("map 是否存在：" + this.map);
            this.map.clear();

            for (var _col = 0; _col <= this.mapW; _col++) {
              for (var row = 0; row <= this.mapH; row++) {
                this.Draw(_col, row, Color.WHITE);
                this.AddGrid(_col, row, (_crd && GridType === void 0 ? (_reportPossibleCrUseOfGridType({
                  error: Error()
                }), GridType) : GridType).Normal);
              }
            } // 设置起点和终点


            var startX = 1;
            var startY = 2;
            var endX = 16;
            var endY = 3;
            this.gridsLst[startX][startY].type = (_crd && GridType === void 0 ? (_reportPossibleCrUseOfGridType({
              error: Error()
            }), GridType) : GridType).Start;
            this.Draw(startX, startY, Color.MAGENTA);
            this.gridsLst[endX][endY].type = (_crd && GridType === void 0 ? (_reportPossibleCrUseOfGridType({
              error: Error()
            }), GridType) : GridType).End;
            this.Draw(endX, endY, Color.BLUE);
          }
          /**
           * 添加格子
           * @param x 列
           * @param y 行
           * @param type 格子类型
           */

        }, {
          key: "AddGrid",
          value: function AddGrid(x, y, type) {
            var grid = new (_crd && Grid === void 0 ? (_reportPossibleCrUseOfGrid({
              error: Error()
            }), Grid) : Grid)();
            grid.x = x;
            grid.y = y;
            grid.type = type;
            this.gridsLst[x][y] = grid;
          }
          /**
           * 排序方法
           * @param x 格子1
           * @param y 格子2
           */

        }, {
          key: "SortFunc",
          value: function SortFunc(x, y) {
            return x.f - y.f;
          }
          /**
           * 生成路径
           * @param grid 
           */

        }, {
          key: "GeneratePath",
          value: function GeneratePath(grid) {
            this.path.push(grid);

            while (grid.parent) {
              grid = grid.parent;
              this.path.push(grid);
            }

            console.log("Path.length: " + this.path.length);

            for (var i = 0; i < this.path.length; i++) {
              // 起点终点不覆盖，方便看效果
              if (i != 0 && i != this.path.length - 1) {
                var _grid = this.path[i];
                this.Draw(_grid.x, _grid.y, Color.GREEN);
              }
            }
          }
          /**
            * 找到路径
            * @param startPos 起点
            * @param endPos 终点
            */

        }, {
          key: "FindPath",
          value: function FindPath(startPos, endPos) {
            //首先判断 传入的两个点 是否合法
            //1.首先 要在地图范围内
            //如果不合法 应该直接 返回null 意味着不能寻路
            if (startPos.x < 0 || startPos.x >= this.mapW || startPos.y < 0 || startPos.y >= this.mapH || endPos.x < 0 || endPos.y >= this.mapH) {
              console.log("开始或者结束点在地图格子范围外");
              return;
            } else {
              //要不是阻挡
              //得到起点和终点 对应的格子
              var startGrid = this.gridsLst[startPos.x][startPos.y];
              var endGrid = this.gridsLst[endPos.x][endPos.y];
              this.openLst.push(startGrid);
              var curGrid = this.openLst[0];

              while (this.openLst.length > 0 && curGrid.type != (_crd && GridType === void 0 ? (_reportPossibleCrUseOfGridType({
                error: Error()
              }), GridType) : GridType).Start) {
                // 每次都取出f值最小的节点进行查找
                curGrid = this.openLst[0];

                if (curGrid.type == (_crd && GridType === void 0 ? (_reportPossibleCrUseOfGridType({
                  error: Error()
                }), GridType) : GridType).Start) {
                  console.log("Find path success.");
                  this.GeneratePath(curGrid);
                  return;
                }

                for (var i = -1; i <= 1; i++) {
                  for (var j = -1; j <= 1; j++) {
                    if (i != 0 || j != 0) {
                      var col = curGrid.x + i;
                      var row = curGrid.y + j;

                      if (col >= 0 && row >= 0 && col <= this.mapW && row <= this.mapH && this.gridsLst[col][row].type != (_crd && GridType === void 0 ? (_reportPossibleCrUseOfGridType({
                        error: Error()
                      }), GridType) : GridType).Barrier && this.closeLst.indexOf(this.gridsLst[col][row]) < 0) {
                        if (this.is8dir) {
                          // 8方向 斜向走动时要考虑相邻的是不是障碍物
                          if (this.gridsLst[col - i][row].type == (_crd && GridType === void 0 ? (_reportPossibleCrUseOfGridType({
                            error: Error()
                          }), GridType) : GridType).Barrier || this.gridsLst[col][row - j].type == (_crd && GridType === void 0 ? (_reportPossibleCrUseOfGridType({
                            error: Error()
                          }), GridType) : GridType).Barrier) {
                            continue;
                          }
                        } else {
                          // 四方形行走
                          if (Math.abs(i) == Math.abs(j)) {
                            continue;
                          }
                        } // 计算g值


                        var g = curGrid.g + parseInt(Math.sqrt(Math.pow(i * 10, 2) + Math.pow(j * 10, 2)).toString());

                        if (this.gridsLst[col][row].g == 0 || this.gridsLst[col][row].g > g) {
                          this.gridsLst[col][row].g = g; // 更新父节点

                          this.gridsLst[col][row].parent = curGrid;
                        } // 计算h值 manhattan估算法


                        this.gridsLst[col][row].h = Math.abs(endPos.x - col) + Math.abs(endPos.y - row); // 更新f值

                        this.gridsLst[col][row].f = this.gridsLst[col][row].g + this.gridsLst[col][row].h; // 如果不在开放列表里则添加到开放列表里

                        if (this.openLst.indexOf(this.gridsLst[col][row]) < 0) {
                          this.openLst.push(this.gridsLst[col][row]);
                        } // // 重新按照f值排序（升序排列)
                        // this.openList.sort(this._sortFunc);

                      }
                    }
                  }
                } // 遍历完四周节点后把当前节点加入关闭列表


                this.closeLst.push(curGrid); // 从开放列表把当前节点移除

                this.openLst.splice(this.openLst.indexOf(curGrid), 1);

                if (this.openLst.length <= 0) {
                  console.log("Find path failed.");
                } // 重新按照f值排序（升序排列)


                this.openLst.sort(this.SortFunc);
              }
            }
          }
          /**
           * 划线
           * @param col 列
           * @param row 行
           * @param color 颜色
           */

        }, {
          key: "Draw",
          value: function Draw(col, row, color) {
            color = color != undefined ? color : Color.GRAY;
            this.map.fillColor = color;
            var posX = 2 + col * (this.gridW + 2);
            var posY = 2 + row * (this.gridH + 2);
            this.map.fillRect(posX, posY, this.gridW, this.gridH);
          }
        }]);

        return AStar;
      }(Component), _temp), (_descriptor = _applyDecoratedDescriptor(_class2.prototype, "mapPos", [_dec2], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return null;
        }
      }), _descriptor2 = _applyDecoratedDescriptor(_class2.prototype, "map", [_dec3], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return null;
        }
      })), _class2)) || _class));

      _crd = false;

      _cclegacy._RF.pop();
    }
  };
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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