(function outer(modules, cache, entry) {
  function newRequire(name, jumped) {
    var module = cache[name];
    if (!module) {
      var moduleData = modules[name];
      if (!moduleData) return;
      var exports = {};
      module = cache[name] = {
        exports: exports
      };
      moduleData[0]((function(x) {
        return newRequire(moduleData[1][x] || x);
      }), module, exports);
    }
    return module.exports;
  }
  for (var i = 0; i < entry.length; i++) newRequire(entry[i]);
  return newRequire;
})({
  1: [ (function(require, module, exports) {
    module.exports = {
      1001: "cocos2d: removeAction: Target not found",
      1002: "cc.ActionManager.removeActionByTag(): an invalid tag",
      1003: "cc.ActionManager.removeActionByTag(): target must be non-null",
      1004: "cc.ActionManager.getActionByTag(): an invalid tag",
      1005: "cocos2d : getActionByTag(tag = %s): Action not found",
      1006: "[Action step]. override me",
      1007: "[Action update]. override me",
      1008: "cocos2d: FiniteTimeAction#reverse: Implement me",
      1009: "cc.EaseElastic.reverse(): it should be overridden in subclass.",
      1010: "cc.IntervalAction: reverse not implemented.",
      1011: "cc.ActionInterval.setAmplitudeRate(): it should be overridden in subclass.",
      1012: "cc.ActionInterval.getAmplitudeRate(): it should be overridden in subclass.",
      1013: "The speed parameter error",
      1014: "The repeat parameter error",
      1015: "parameters should not be ending with null in Javascript",
      1016: "cc.RotateTo.reverse(): it should be overridden in subclass.",
      1019: "Failed to construct, Sequence construction needs two or more actions.",
      1020: "Failed to construct, Spawn construction needs two or more actions.",
      1021: "cc.Speed.initWithAction(): action must be non nil",
      1022: "cc.Follow.initWithAction(): followedNode must be non nil",
      1023: "cc.ActionEase.initWithAction(): action must be non nil",
      1024: "Invalid configuration. It must at least have one control point",
      1025: "cc.Sequence.initWithTwoActions(): arguments must all be non nil",
      1026: "cc.RepeatForever.initWithAction(): action must be non null",
      1027: "cc.Spawn.initWithTwoActions(): arguments must all be non null",
      1028: "cc.ReverseTime.initWithAction(): action must be non null",
      1029: "cc.ReverseTime.initWithAction(): the action was already passed in.",
      1030: "cc.Animate.initWithAnimation(): animation must be non-NULL",
      1031: "Illegal parameter get passed in cc.tween: %s.",
      1100: "Expected 'data' dict, but not found. Config file: %s",
      1101: "Please load the resource first : %s",
      1200: "cocos2d: Director: Error in gettimeofday",
      1201: "cocos2d: Director: unrecognized projection",
      1203: "cocos2d: Director: Error in gettimeofday",
      1204: "running scene should not null",
      1205: "the scene should not null",
      1206: "loadScene: The scene index to load (%s) is out of range.",
      1207: "loadScene: Unknown name type to load: '%s'",
      1208: "loadScene: Failed to load scene '%s' because '%s' is already being loaded.",
      1209: "loadScene: Can not load the scene '%s' because it was not in the build settings before playing.",
      1210: "Failed to preload '%s', %s",
      1211: "loadScene: The scene index to load (%s) is out of range.",
      1212: "loadScene: Unknown name type to load: '%s'",
      1213: "loadScene: Failed to load scene '%s' because '%s' is already loading",
      1214: "loadScene: Can not load the scene '%s' because it was not in the build settings before playing.",
      1215: "Failed to preload '%s', %s",
      1216: "Director.runSceneImmediate: scene is not valid",
      1300: "element type is wrong!",
      1400: "'%s' is deprecated, please use '%s' instead.",
      1401: "The first argument should be the destination object",
      1402: "The 'visible' property of %s is deprecated, use 'enabled' instead please.",
      1403: "Sorry, cc.audioEngine.willPlayMusic is removed.",
      1404: "cc.spriteFrameCache is removed, please use cc.loader to load and cache sprite frames of atlas format.",
      1405: "The '%s' will be removed in v2.0, please use '%s' instead.",
      1406: "'%s.%s' is removed",
      1407: "cc.pool is being removed from v2.0, you are getting cc.js.Pool instead.",
      1408: "'%s' is not support in the '%s', please use '%s' instead.",
      1502: "cc.scheduler.scheduleCallbackForTarget(): target should be non-null.",
      1503: "cc.Scheduler.pauseTarget():target should be non-null",
      1504: "cc.Scheduler.resumeTarget():target should be non-null",
      1505: "cc.Scheduler.isTargetPaused():target should be non-null",
      1506: "warning: you CANNOT change update priority in scheduled function",
      1507: 'CCScheduler#scheduleSelector. Selector already scheduled. Updating interval from: %s to %s"',
      1508: "Argument callback must not be empty",
      1509: "Argument target must be non-nullptr",
      1510: "cc.Scheduler: Illegal target which doesn't have uuid or instanceId.",
      1511: "cc.Scheduler: pause state of the scheduled task doesn't match the element pause state in Scheduler, the given paused state will be ignored.",
      1512: "cc.Scheduler: updateFunc parameter is deprecated in scheduleUpdate function, and will be removed in v2.0",
      1513: "cc.Scheduler: scheduler stopped using `__instanceId` as id since v2.0, you should do scheduler.enableForTarget(target) before all scheduler API usage on target",
      1600: "getZOrder is deprecated. Please use getLocalZOrder instead.",
      1601: "setZOrder is deprecated. Please use setLocalZOrder instead.",
      1602: "RotationX != RotationY. Don't know which one to return",
      1603: "ScaleX != ScaleY. Don't know which one to return",
      1605: "child already added. It can't be added again",
      1606: "child must be non-null",
      1607: "removeFromParentAndCleanup is deprecated. Use removeFromParent instead",
      1608: "boundingBox is deprecated. Use getBoundingBox instead",
      1609: "argument tag is an invalid tag",
      1610: "cocos2d: removeChildByTag(tag = %s): child not found!",
      1612: "cc.Node.stopActionBy(): argument tag an invalid tag",
      1613: "cc.Node.getActionByTag(): argument tag is an invalid tag",
      1614: "resumeSchedulerAndActions is deprecated, please use resume instead.",
      1615: "pauseSchedulerAndActions is deprecated, please use pause instead.",
      1617: "child must be non-null",
      1618: "cc.Node.runAction(): action must be non-null",
      1619: "callback function must be non-null",
      1620: "interval must be positive",
      1623: "Set '%s' to normal node (not persist root node).",
      1624: "Replacing with the same sgNode",
      1625: "The replacement sgNode should not contain any child.",
      1626: "Should not set alpha via 'color', set 'opacity' please.",
      1627: "Not support for asynchronous creating node in SG",
      1632: "Node name can not include '/'.",
      1633: "Internal error, should not remove unknown node from parent.",
      1634: "addChild: The child to add must be instance of cc.Node, not %s.",
      1635: "reorderChild: this child is not in children list.",
      1636: "Node's zIndex value can't be greater than cc.macro.MAX_ZINDEX, setting to the maximum value",
      1637: "Node's zIndex value can't be smaller than cc.macro.MIN_ZINDEX, setting to the minimum value",
      1638: "Private node's zIndex can't be set, it will keep cc.macro.MIN_ZINDEX as its value",
      1800: "cc._EventListenerKeyboard.checkAvailable(): Invalid EventListenerKeyboard!",
      1801: "cc._EventListenerTouchOneByOne.checkAvailable(): Invalid EventListenerTouchOneByOne!",
      1802: "cc._EventListenerTouchAllAtOnce.checkAvailable(): Invalid EventListenerTouchAllAtOnce!",
      1803: "cc._EventListenerAcceleration.checkAvailable(): _onAccelerationEvent must be non-nil",
      1900: "Invalid parameter.",
      2000: "Don't call this method if the event is for touch.",
      2200: "Resolution not valid",
      2201: "should set resolutionPolicy",
      2300: "The touches is more than MAX_TOUCHES, nUnusedIndex = %s",
      2400: "WebGL error %s",
      2602: "cc.Sprite.setDisplayFrameWithAnimationName(): Frame not found",
      2603: "cc.Sprite.setDisplayFrameWithAnimationName(): Invalid frame index",
      2604: "setDisplayFrame is deprecated, please use setSpriteFrame instead.",
      2606: "cc.Sprite.initWithSpriteFrame(): spriteFrame should be non-null",
      2607: "cc.Sprite.initWithSpriteFrameName(): spriteFrameName should be non-null",
      2608: "%s is null, please check.",
      2609: "cc.Sprite.initWithFile(): filename should be non-null",
      2610: "cc.Sprite.setDisplayFrameWithAnimationName(): animationName must be non-null",
      2614: "cc.Sprite.addChild(): child should be non-null",
      2616: "cc.SpriteBatchNode.updateQuadFromSprite(): cc.SpriteBatchNode only supports cc.Sprites as children",
      2617: "cc.SpriteBatchNode.insertQuadFromSprite(): cc.SpriteBatchNode only supports cc.Sprites as children",
      2618: "cc.SpriteBatchNode.addChild(): cc.SpriteBatchNode only supports cc.Sprites as children",
      2619: "cc.SpriteBatchNode.addChild(): cc.Sprite is not using the same texture",
      2623: "cc.SpriteBatchNode.updateQuadFromSprite(): sprite should be non-null",
      2625: "too many tiles, only 16384 tiles will be show",
      2626: "Unrecognized fill type in bar fill",
      2627: "Can not generate quad",
      2628: "%s does not exist",
      2710: "Sprite.initWithTexture(): Argument must be non-nil",
      2712: "Invalid spriteFrameName",
      3002: "textureForKey is deprecated. Please use getTextureForKey instead.",
      3005: "cocos2d: '%s' id=%s %s x %s",
      3006: "cocos2d: '%s' id= HTMLCanvasElement %s x %s",
      3007: "cocos2d: TextureCache dumpDebugInfo: %s textures, HTMLCanvasElement for %s KB (%s MB)",
      3103: "cc.Texture.addImage(): path should be non-null",
      3112: "cc.Texture.addImage(): path should be non-null",
      3113: "NSInternalInconsistencyException",
      3116: "WebGLRenderingContext.CLAMP_TO_EDGE should be used in NPOT textures",
      3117: "Mimpap texture only works in POT textures",
      3118: "contentSize parameter is deprecated and ignored for cc.Texture2D initWithData function.",
      3119: "Lazy init texture with image element failed due to image loading failure: %s",
      3120: "Loading texture from '%s' with unsupported type: '%s'. Add '%s' into 'cc.macro.SUPPORT_TEXTURE_FORMATS' please.",
      3300: "Rect width exceeds maximum margin: %s",
      3400: "Rect height exceeds maximum margin: %s",
      3500: "0 priority is forbidden for fixed priority since it's used for scene graph based priority.",
      3501: "Invalid listener type!",
      3502: "Can't set fixed priority with scene graph based listener.",
      3503: "Invalid parameters.",
      3504: "listener must be a cc.EventListener object when adding a fixed priority listener",
      3505: "The listener has been registered, please don't register it again.",
      3506: "Unsupported listener target.",
      3507: "Invalid scene graph priority!",
      3508: "If program goes here, there should be event in dispatch.",
      3509: "_inDispatch should be 1 here.",
      3510: "%s's scene graph node not contains in the parent's children",
      3511: "event is undefined",
      3600: "cc.Class will automatically call super constructor of %s, you should not call it manually.",
      3601: "The editor property 'playOnFocus' should be used with 'executeInEditMode' in class '%s'",
      3602: "Unknown editor property '%s' in class '%s'.",
      3603: "Use 'cc.Float' or 'cc.Integer' instead of 'cc.Number' please.",
      3604: "Can only indicate one type attribute for %s.",
      3605: "The default value of %s is not instance of %s.",
      3606: "No needs to indicate the '%s' attribute for %s, which its default value is type of %s.",
      3607: "The default value of %s must be an empty string.",
      3608: "The type of %s must be cc.String, not String.",
      3609: "The type of %s must be cc.Boolean, not Boolean.",
      3610: "The type of %s must be cc.Float or cc.Integer, not Number.",
      3611: "Can not indicate the '%s' attribute for %s, which its default value is type of %s.",
      3612: "%s Just set the default value to 'new %s()' and it will be handled properly.",
      3613: "'No need to use 'serializable: false' or 'editorOnly: true' for the getter of '%s.%s', every getter is actually non-serialized.",
      3614: "Should not define constructor for cc.Component %s.",
      3615: "Each script can have at most one Component.",
      3616: "Should not specify class name %s for Component which defines in project.",
      3617: "Can not instantiate CCClass '%s' with arguments.",
      3618: "ctor of '%s' can not be another CCClass",
      3619: "ctor of '%s' must be function type",
      3620: "this._super declared in '%s.%s' but no super method defined",
      3621: "Unknown type of %s.%s, maybe you want is '%s'.",
      3622: "Unknown type of %s.%s, property should be defined in 'properties' or 'ctor'",
      3623: "Can not use 'editor' attribute, '%s' not inherits from Components.",
      3624: "'%s' overrided '%s' but '%s' is defined as 'false' so the super method will not be called. You can set '%s' to null to disable this warning.",
      3625: "[isChildClassOf] superclass should be function type, not",
      3626: "Can't remove '%s' because '%s' depends on it.",
      3627: "Should not add renderer component (%s) to a Canvas node.",
      3628: "Should not add %s to a node which size is already used by its other component.",
      3633: "Properties function of '%s' should return an object!",
      3634: "Disallow to use '.' in property name",
      3635: "Default array must be empty, set default value of %s.%s to [], and initialize in 'onLoad' or 'ctor' please. (just like 'this.%s = [...];')",
      3636: "Do not set default value to non-empty object, unless the object defines its own 'clone' function. Set default value of %s.%s to null or {}, and initialize in 'onLoad' or 'ctor' please. (just like 'this.%s = {foo: bar};')",
      3637: "Can not declare %s.%s, it is already defined in the prototype of %s",
      3638: "'%s': the getter of '%s' is already defined!",
      3639: "Can not apply the specified attribute to the getter of '%s.%s', attribute index: %s",
      3640: "'%s': the setter of '%s' is already defined!",
      3641: "Can not construct %s because it contains object property.",
      3642: "Cannot define %s.%s because static member name can not be '%s'.",
      3643: "Can not define a member called 'constructor' in the class '%s', please use 'ctor' instead.",
      3644: "Please define 'type' parameter of %s.%s as the actual constructor.",
      3645: "Please define 'type' parameter of %s.%s as the constructor of %s.",
      3646: "Unknown 'type' parameter of %s.%s\uff1a%s",
      3647: "The length of range array must be equal or greater than 2",
      3648: "Can not declare %s.%s method, it is already defined in the properties of %s.",
      3649: "CCClass %s have conflict between its ctor and __ctor__.",
      3651: 'Can not call `_super` or `prototype.ctor` in ES6 Classes "%s", use `super` instead please.',
      3652: 'Failed to construct a dummy instance of the "%s" class using `new` behind the scenes. This is for getting default values declared in TypeScript. Please ensure the class will be able to construct during script\'s initialization. %s.',
      3653: 'Please do not specifiy "default" attribute in decorator of "%s" property in "%s" class.  \nDefault value must be initialized at their declaration:\n \n// Before:\n@property({\n  type: cc.Integer\n  default: 0  // <--\n})\nmyProp;\n// After:\n@property({\n  type: cc.Integer\n})\nmyProp = 0;    // <--',
      3654: 'Please specifiy a default value for "%s.%s" at its declaration:\n \n// Before:\n@property(...)\nmyProp;\n// After:\n@property(...)\nmyProp = 0;',
      3655: 'Can not specifiy "get" or "set"  attribute in decorator for "%s" property in "%s" class.  \nPlease use:\n \n@property(...)\nget %s () {\n    ...\n}\n@property\nset %s (value) {\n    ...\n}',
      3656: "The default value of %s.%s must be an empty string. (changed since 1.8)",
      3657: "The value assigned to %s should be Texture2D object, not url string. Since 1.8,  \nyou can declare a texture object directly in properties by using:  \n \n{\n    default: null,\n    type: cc.Texture2D  // use 'type:' instead of 'url:'\n}",
      3658: "browser does not support getters",
      3700: "internal error: _prefab is undefined",
      3701: "Failed to load prefab asset for node '%s'",
      3800: "The target can not be made persist because it's not a cc.Node or it doesn't have _id property.",
      3801: "The node can not be made persist because it's not under root node.",
      3802: "The node can not be made persist because it's not in current scene.",
      3803: "The target can not be made persist because it's not a cc.Node or it doesn't have _id property.",
      3804: "getComponent: Type must be non-nil",
      3805: "Can't add component '%s' because %s already contains the same component.",
      3806: "Can't add component '%s' to %s because it conflicts with the existing '%s' derived component.",
      3807: "addComponent: Failed to get class '%s'",
      3808: "addComponent: Should not add component ('%s') when the scripts are still loading.",
      3809: "addComponent: The component to add must be a constructor",
      3810: "addComponent: The component to add must be child class of cc.Component",
      3811: "_addComponentAt: The component to add must be a constructor",
      3812: "_addComponentAt: Index out of range",
      3813: "removeComponent: Component must be non-nil",
      3814: "Argument must be non-nil",
      3815: "Component not owned by this entity",
      3816: "Node '%s' is already activating",
      3817: "Sorry, the component of '%s' which with an index of %s is corrupted! It has been removed.",
      3818: "Failed to read or parse project.json",
      3819: "Warning: target element is not a DIV or CANVAS",
      3820: "The renderer doesn't support the renderMode %s",
      3821: "Cannot change hierarchy while activating or deactivating the parent.",
      3900: "Invalid clip to add",
      3901: "Invalid clip to remove",
      3902: "clip is defaultClip, set force to true to force remove clip and animation state",
      3903: "animation state is playing, set force to true to force stop and remove clip and animation state",
      3904: "motion path of target [%s] in prop [%s] frame [%s] is not valid",
      3905: "sprite frames must be an Array.",
      3906: "Can't find easing type [%s]",
      3907: "animator not added or already removed",
      3908: "animation not added or already removed",
      3912: "already-playing",
      4000: "Sorry, the cc.Font has been modified from Raw Asset to Asset. Please load the font asset before using.",
      4003: "Label font size can't be shirnked less than 0!",
      4004: "force notify all fonts loaded!",
      4011: "Property spriteFrame of Font '%s' is invalid. Using system font instead.",
      4012: "The texture of Font '%s' must be already loaded on JSB. Using system font instead.",
      4013: "Sorry, lineHeight of system font not supported on JSB.",
      4100: "Property padding is deprecated, please use paddingLeft, paddingRight, paddingTop and paddingBottom instead",
      4200: "MaskType: IMAGE_STENCIL only support WebGL mode.",
      4201: "The alphaThreshold invalid in Canvas Mode.",
      4202: "The inverted invalid in Canvas Mode.",
      4300: "can not found the %s page.",
      4400: "Invalid RichText img tag! The sprite frame name can't be found in the ImageAtlas!",
      4600: "Script attached to '%s' is missing or invalid.",
      4700: "The dom control is not created!",
      4800: "unknown asset type",
      4901: "loadRes: should not specify the extname in %s %s",
      4902: "No need to release non-cached asset.",
      4903: "Can not get class '%s'",
      4914: "Resources url '%s' does not exist.",
      4915: "Pack indices and data do not match in size",
      4916: "Failed to download package for %s",
      4920: "Sorry, you shouldn't use id as item identity any more, please use url or uuid instead, the current id is being set as url: (%s)",
      4921: "Invalid pipe or invalid index provided!",
      4922: "The pipe to be inserted is already in the pipeline!",
      4923: "Uuid Loader: Parse asset [ %s ] failed : %s",
      4924: "JSON Loader: Input item doesn't contain string content",
      4925: "Uuid Loader: Deserialize asset [ %s ] failed : %s",
      4926: "Audio Downloader: no web audio context.",
      4927: "Audio Downloader: audio not supported on this browser!",
      4928: "Load %s failed!",
      4929: "Load Webp ( %s ) failed",
      4930: "Load image ( %s ) failed",
      4931: "Download Uuid: can not find type of raw asset[ %s ]: %s",
      4932: 'Since v1.10, for any atlas ("%s") in the "resources" directory, it is not possible to find the contained SpriteFrames via `loadRes`, `getRes` or `releaseRes`. Load the SpriteAtlas first and then use `spriteAtlas.getSpriteFrame(name)` instead please.',
      4933: "Download Font [ %s ] failed, using Arial or system default font instead",
      5000: "object already destroyed",
      5001: "object not yet destroyed",
      5100: "Not a plist file!",
      5200: "Warning: localStorage isn't enabled. Please confirm browser cookie or privacy option",
      5201: "browser don't support web audio",
      5202: "This feature supports WebGL render mode only.",
      5300: "Type of target to deserialize not matched with data: target is %s, data is %s",
      5301: "Can not find script '%s'",
      5302: "Can not find class '%s'",
      5400: "'%s' is deprecated, use '%s' instead please.",
      5401: "'%s' is deprecated, use '%s' instead please.",
      5402: "cc.js.addon called on non-object:",
      5403: "cc.js.mixin: arguments must be type object:",
      5404: "The base class to extend from must be non-nil",
      5405: "The class to extend must be non-nil",
      5406: "Class should be extended before assigning any prototype members.",
      5500: "'notify' can't work with 'get/set' !",
      5501: "'notify' must work with 'default' !",
      5502: "Invalid url of %s.%s",
      5503: "The 'url' attribute of '%s.%s' is undefined when loading script.",
      5504: "The 'url' type of '%s.%s' must be child class of cc.RawAsset.",
      5505: "The 'url' type of '%s.%s' must not be child class of cc.Asset, otherwise you should use 'type: %s' instead.",
      5506: "Can not specify 'type' attribute for '%s.%s', because its 'url' is already defined.",
      5507: "The 'default' attribute of '%s.%s' must be an array",
      5508: "Invalid type of %s.%s",
      5509: "The 'type' attribute of '%s.%s' must be child class of cc.Asset, otherwise you should use 'url: %s' instead",
      5510: "The 'type' attribute of '%s.%s' can not be 'Number', use cc.Float or cc.Integer instead please.",
      5511: "The 'type' attribute of '%s.%s' is undefined when loading script",
      5512: "Can not serialize '%s.%s' because the specified type is anonymous, please provide a class name or set the 'serializable' attribute of '%s.%s' to 'false'.",
      5513: "The 'default' value of '%s.%s' should not be used with a 'get' function.",
      5514: "The 'default' value of '%s.%s' should not be used with a 'set' function.",
      5515: "The 'default' value of '%s.%s' can not be an constructor. Set default to null please.",
      5516: "Property '%s.%s' must define at least one of 'default', 'get' or 'set'.",
      5517: "'%s.%s' hides inherited property '%s.%s'. To make the current property override that implementation, add the `override: true` attribute please.",
      5600: "Argument must be non-nil",
      5601: "Can not get current scene.",
      5602: "Scene is destroyed",
      5603: "reference node is destroyed",
      5700: "no %s or %s on %s",
      5800: "%s.lerp not yet implemented.",
      5801: "%s.clone not yet implemented.",
      5802: "%s.equals not yet implemented.",
      5900: "MotionStreak only support WebGL mode.",
      5901: "cc.MotionStreak.getOpacity has not been supported.",
      5902: "cc.MotionStreak.setOpacity has not been supported.",
      6000: "Custom should not be false if file is not specified.",
      6001: "The new %s must not be NaN",
      6017: "Incomplete or corrupt PNG file",
      6018: "Invalid filter algorithm: %s",
      6019: "Invalid byte order value.",
      6020: "You forgot your towel!",
      6021: "Unknown Field Tag: %s",
      6022: "Too many bits requested",
      6023: "No bits requested",
      6024: "Cannot recover from missing StripByteCounts",
      6025: "Cannot handle sub-byte bits per sample",
      6026: "Cannot handle sub-byte bits per pixel",
      6027: "Palette image missing color map",
      6028: "Unknown Photometric Interpretation: %s",
      6029: "Unkown error",
      6030: "cc.ParticleSystem: error decoding or ungzipping textureImageData",
      6031: "cc.ParticleSystem: unknown image format with Data",
      6032: "cc.ParticleSystem.initWithDictionary() : error loading the texture",
      6200: "Canvas doesn't support mesh slot!",
      6300: "only cc.DrawNode is accepted as stencil",
      6301: "Stencil buffer is not enabled.",
      6302: "Nesting more than %d stencils is not supported. Everything will be drawn without stencil for this node and its children.",
      6400: "asset.url is not usable in core process",
      6401: "asset.urls is not usable in core process",
      6402: "AssetLibrary has already been initialized!",
      6500: "Widget target must be one of the parent nodes of it",
      6600: "collider not added or already removed",
      6601: "Can't find testFunc for (%s, $s).",
      6700: "Can't init canvas '%s' because it conflicts with the existing '%s', the scene should only have one active canvas at the same time",
      6701: "Should not add Canvas to a node which already contains a renderer component (%s).",
      6702: "Should not add Canvas to a node which size is already used by its other component.",
      6703: "Can't initialise DrawingPrimitiveWebGL. context need is WebGLRenderingContext",
      6704: "Polygon's point must greater than 2",
      6705: "Argument must be non-nil",
      6800: "Callback of event must be non-nil",
      6801: "The message must be provided",
      6900: "The thing you want to instantiate must be an object",
      6901: "The thing you want to instantiate is nil",
      6902: "The thing you want to instantiate is destroyed",
      6903: "The instantiate method for given asset do not implemented",
      6904: "Can not instantiate array",
      6905: "Can not instantiate DOM element",
      7000: "Failed to init asset's raw path.",
      7001: "Should not load '%s' from script dynamically, unless it is placed in the 'resources' folder.",
      7002: "Sorry can not load '%s' because it is not placed in the 'resources' folder.",
      7003: "Failed to init builtin asset's raw path.",
      7100: "%s already defined in Enum.",
      7101: "Sorry, 'cc.Enum' not available on this platform, please report this error here: https://github.com/cocos-creator/engine/issues/new",
      7200: "Method 'initWithTMXFile' is no effect now, please set property 'tmxAsset' instead.",
      7201: "Method 'initWithXML' is no effect now, please set property 'tmxAsset' instead.",
      7202: "Add component TiledLayer into node failed.",
      7203: "Property 'mapLoaded' is unused now. Please write the logic to the callback 'start'.",
      7210: "TMX Hexa zOrder not supported",
      7211: "TMX invalid value",
      7214: "propertiesForGID is deprecated. Please use getPropertiesForGID instead.",
      7215: "cocos2d: Warning: TMX Layer %s has no tiles",
      7216: "cocos2d: TMXFormat: Unsupported TMX version: %s",
      7217: "cocos2d: TMXFomat: Unsupported orientation: %s",
      7218: "cc.TMXMapInfo.parseXMLFile(): unsupported compression method",
      7219: "cc.TMXMapInfo.parseXMLFile(): Only base64 and/or gzip/zlib maps are supported",
      7221: "cc.TMXMapInfo.parseXMLFile(): Texture '%s' not found.",
      7222: "Parse %s failed.",
      7236: "cc.TMXLayer.getTileAt(): TMXLayer: the tiles map has been released",
      7237: "cc.TMXLayer.getTileGIDAt(): TMXLayer: the tiles map has been released",
      7238: "cc.TMXLayer.setTileGID(): TMXLayer: the tiles map has been released",
      7239: "cc.TMXLayer.setTileGID(): invalid gid: %s",
      7240: "cc.TMXLayer.getTileFlagsAt(): TMXLayer: the tiles map has been released",
      7241: "cc.TiledMap.initWithXML(): Map not found. Please check the filename.",
      7401: "Failed to set _defaultArmatureIndex for '%s' because the index is out of range.",
      7402: "Failed to set _animationIndex for '%s' because the index is out of range.",
      7501: "Failed to set _defaultSkinIndex for '%s' because the index is out of range.",
      7502: "Failed to set _animationIndex for '%s' because its skeletonData is invalid.",
      7503: "Failed to set _animationIndex for '%s' because the index is out of range.",
      7504: "Can not render dynamic created SkeletonData",
      7505: "Invalid type of atlasFile, atlas should be registered as raw asset.",
      7506: "Failed to load spine atlas '$s'",
      7507: "Please re-import '%s' because its textures is not initialized! (This workflow will be improved in the future.)",
      7508: "The atlas asset of '%s' is not exists!",
      7509: "Spine: Animation not found: %s",
      7510: "Spine: Animation not found: %s",
      7600: "The context of RenderTexture is invalid.",
      7601: "cc.RenderTexture._initWithWidthAndHeightForWebGL() : only RGB and RGBA formats are valid for a render texture;",
      7602: "Could not attach texture to the framebuffer",
      7603: "clearDepth isn't supported on Cocos2d-Html5",
      7604: "saveToFile isn't supported on Cocos2d-Html5",
      7605: "newCCImage isn't supported on Cocos2d-Html5",
      7700: "On the web is always keep the aspect ratio",
      7701: "Can't know status",
      7702: "Video player's duration is not ready to get now!",
      7800: "Web does not support loading",
      7801: "Web does not support query history",
      7802: "Web does not support query history",
      7803: "The current browser does not support the GoBack",
      7804: "The current browser does not support the GoForward",
      7805: "Web does not support zoom",
      7900: "cc.math.Matrix3.assign(): current matrix equals matIn",
      7901: "cc.math.mat4Assign(): pOut equals pIn",
      7902: "cc.mat.Matrix4.assignFrom(): mat4 equals current matrix",
      7903: "cc.math.Matrix4 equal: pMat1 and pMat2 are same object.",
      7904: "cc.math.Matrix4.extractPlane: Invalid plane index",
      7905: "cc.math.mat4Assign(): pOut equals pIn",
      7906: "cc.mat.Matrix4.assignFrom(): mat4 equals current matrix",
      7907: "cc.math.Matrix4 equals: pMat1 and pMat2 are same object.",
      7908: "Invalid matrix mode specified",
      7909: "current quaternion is an invalid value",
      8000: "Can't handle this field type or size",
      8001: "No bytes requested",
      8002: "Too many bytes requested",
      8003: "Missing StripByteCounts!",
      8103: "cc.GLProgram.link(): Cannot link invalid program",
      8104: "cocos2d: ERROR: Failed to link program: %s",
      8105: "cocos2d: cc.shaderCache._loadDefaultShader, error shader type",
      8106: "Please load the resource firset : %s",
      8107: "cc.GLProgram.getUniformLocationForName(): uniform name should be non-null",
      8108: "cc.GLProgram.getUniformLocationForName(): Invalid operation. Cannot get uniform location when program is not initialized",
      8109: "modelView matrix is undefined.",
      8200: "Please set node's active instead of rigidbody's enabled.",
      8300: "Should only one camera exists, please check your project.",
      8301: "Camera does not support Canvas Mode.",
      8400: "Wrong type arguments, 'filePath' must be a String.",
      8401: "Since 1.10, `%s` accept %s instance directly, not a URL string. Please directly reference the %s object in your script, or load %s by loader first. Don't use %s's URL anymore.",
      9000: "Stencil manager does not support level bigger than %d in this device.",
      9001: "Stencil manager is already empty, cannot pop any mask.",
      9100: "LabelAtlas '%s' cannot be loaded, raw texture does not exist.",
      9101: "LabelAtlas '%s' cannot be loaded, fnt data does not exist.",
      9102: "Program not support highp precision, will change to mediump.",
      "0100": "%s not yet implemented."
    };
  }), {} ],
  2: [ (function(require, module, exports) {
    "use strict";
    require("../core/platform/CCClass");
    var misc = require("../core/utils/misc");
    cc.Action = cc.Class({
      name: "cc.Action",
      ctor: function ctor() {
        this.originalTarget = null;
        this.target = null;
        this.tag = cc.Action.TAG_INVALID;
      },
      clone: function clone() {
        var action = new cc.Action();
        action.originalTarget = null;
        action.target = null;
        action.tag = this.tag;
        return action;
      },
      isDone: function isDone() {
        return true;
      },
      startWithTarget: function startWithTarget(target) {
        this.originalTarget = target;
        this.target = target;
      },
      stop: function stop() {
        this.target = null;
      },
      step: function step(dt) {
        cc.logID(1006);
      },
      update: function update(dt) {
        cc.logID(1007);
      },
      getTarget: function getTarget() {
        return this.target;
      },
      setTarget: function setTarget(target) {
        this.target = target;
      },
      getOriginalTarget: function getOriginalTarget() {
        return this.originalTarget;
      },
      setOriginalTarget: function setOriginalTarget(originalTarget) {
        this.originalTarget = originalTarget;
      },
      getTag: function getTag() {
        return this.tag;
      },
      setTag: function setTag(tag) {
        this.tag = tag;
      },
      retain: function retain() {},
      release: function release() {}
    });
    cc.Action.TAG_INVALID = -1;
    cc.FiniteTimeAction = cc.Class({
      name: "cc.FiniteTimeAction",
      extends: cc.Action,
      ctor: function ctor() {
        this._duration = 0;
      },
      getDuration: function getDuration() {
        return this._duration * (this._timesForRepeat || 1);
      },
      setDuration: function setDuration(duration) {
        this._duration = duration;
      },
      reverse: function reverse() {
        cc.logID(1008);
        return null;
      },
      clone: function clone() {
        return new cc.FiniteTimeAction();
      }
    });
    cc.Speed = cc.Class({
      name: "cc.Speed",
      extends: cc.Action,
      ctor: function ctor(action, speed) {
        this._speed = 0;
        this._innerAction = null;
        action && this.initWithAction(action, speed);
      },
      getSpeed: function getSpeed() {
        return this._speed;
      },
      setSpeed: function setSpeed(speed) {
        this._speed = speed;
      },
      initWithAction: function initWithAction(action, speed) {
        if (!action) {
          cc.errorID(1021);
          return false;
        }
        this._innerAction = action;
        this._speed = speed;
        return true;
      },
      clone: function clone() {
        var action = new cc.Speed();
        action.initWithAction(this._innerAction.clone(), this._speed);
        return action;
      },
      startWithTarget: function startWithTarget(target) {
        cc.Action.prototype.startWithTarget.call(this, target);
        this._innerAction.startWithTarget(target);
      },
      stop: function stop() {
        this._innerAction.stop();
        cc.Action.prototype.stop.call(this);
      },
      step: function step(dt) {
        this._innerAction.step(dt * this._speed);
      },
      isDone: function isDone() {
        return this._innerAction.isDone();
      },
      reverse: function reverse() {
        return new cc.Speed(this._innerAction.reverse(), this._speed);
      },
      setInnerAction: function setInnerAction(action) {
        this._innerAction !== action && (this._innerAction = action);
      },
      getInnerAction: function getInnerAction() {
        return this._innerAction;
      }
    });
    cc.speed = function(action, speed) {
      return new cc.Speed(action, speed);
    };
    cc.Follow = cc.Class({
      name: "cc.Follow",
      extends: cc.Action,
      ctor: function ctor(followedNode, rect) {
        this._followedNode = null;
        this._boundarySet = false;
        this._boundaryFullyCovered = false;
        this._halfScreenSize = null;
        this._fullScreenSize = null;
        this.leftBoundary = 0;
        this.rightBoundary = 0;
        this.topBoundary = 0;
        this.bottomBoundary = 0;
        this._worldRect = cc.rect(0, 0, 0, 0);
        followedNode && (rect ? this.initWithTarget(followedNode, rect) : this.initWithTarget(followedNode));
      },
      clone: function clone() {
        var action = new cc.Follow();
        var locRect = this._worldRect;
        var rect = new cc.Rect(locRect.x, locRect.y, locRect.width, locRect.height);
        action.initWithTarget(this._followedNode, rect);
        return action;
      },
      isBoundarySet: function isBoundarySet() {
        return this._boundarySet;
      },
      setBoudarySet: function setBoudarySet(value) {
        this._boundarySet = value;
      },
      initWithTarget: function initWithTarget(followedNode, rect) {
        if (!followedNode) {
          cc.errorID(1022);
          return false;
        }
        var _this = this;
        rect = rect || cc.rect(0, 0, 0, 0);
        _this._followedNode = followedNode;
        _this._worldRect = rect;
        _this._boundarySet = !(0 === rect.width && 0 === rect.height);
        _this._boundaryFullyCovered = false;
        var winSize = cc.winSize;
        _this._fullScreenSize = cc.v2(winSize.width, winSize.height);
        _this._halfScreenSize = _this._fullScreenSize.mul(.5);
        if (_this._boundarySet) {
          _this.leftBoundary = -(rect.x + rect.width - _this._fullScreenSize.x);
          _this.rightBoundary = -rect.x;
          _this.topBoundary = -rect.y;
          _this.bottomBoundary = -(rect.y + rect.height - _this._fullScreenSize.y);
          _this.rightBoundary < _this.leftBoundary && (_this.rightBoundary = _this.leftBoundary = (_this.leftBoundary + _this.rightBoundary) / 2);
          _this.topBoundary < _this.bottomBoundary && (_this.topBoundary = _this.bottomBoundary = (_this.topBoundary + _this.bottomBoundary) / 2);
          _this.topBoundary === _this.bottomBoundary && _this.leftBoundary === _this.rightBoundary && (_this._boundaryFullyCovered = true);
        }
        return true;
      },
      step: function step(dt) {
        var targetWorldPos = this.target.convertToWorldSpaceAR(cc.Vec2.ZERO);
        var followedWorldPos = this._followedNode.convertToWorldSpaceAR(cc.Vec2.ZERO);
        var delta = targetWorldPos.sub(followedWorldPos);
        var tempPos = this.target.parent.convertToNodeSpaceAR(delta.add(this._halfScreenSize));
        if (this._boundarySet) {
          if (this._boundaryFullyCovered) return;
          this.target.setPosition(misc.clampf(tempPos.x, this.leftBoundary, this.rightBoundary), misc.clampf(tempPos.y, this.bottomBoundary, this.topBoundary));
        } else this.target.setPosition(tempPos.x, tempPos.y);
      },
      isDone: function isDone() {
        return !this._followedNode.activeInHierarchy;
      },
      stop: function stop() {
        this.target = null;
        cc.Action.prototype.stop.call(this);
      }
    });
    cc.follow = function(followedNode, rect) {
      return new cc.Follow(followedNode, rect);
    };
  }), {
    "../core/platform/CCClass": 199,
    "../core/utils/misc": 299
  } ],
  3: [ (function(require, module, exports) {
    "use strict";
    function cardinalSplineAt(p0, p1, p2, p3, tension, t) {
      var t2 = t * t;
      var t3 = t2 * t;
      var s = (1 - tension) / 2;
      var b1 = s * (2 * t2 - t3 - t);
      var b2 = s * (-t3 + t2) + (2 * t3 - 3 * t2 + 1);
      var b3 = s * (t3 - 2 * t2 + t) + (-2 * t3 + 3 * t2);
      var b4 = s * (t3 - t2);
      var x = p0.x * b1 + p1.x * b2 + p2.x * b3 + p3.x * b4;
      var y = p0.y * b1 + p1.y * b2 + p2.y * b3 + p3.y * b4;
      return cc.v2(x, y);
    }
    function getControlPointAt(controlPoints, pos) {
      var p = Math.min(controlPoints.length - 1, Math.max(pos, 0));
      return controlPoints[p];
    }
    function reverseControlPoints(controlPoints) {
      var newArray = [];
      for (var i = controlPoints.length - 1; i >= 0; i--) newArray.push(cc.v2(controlPoints[i].x, controlPoints[i].y));
      return newArray;
    }
    function cloneControlPoints(controlPoints) {
      var newArray = [];
      for (var i = 0; i < controlPoints.length; i++) newArray.push(cc.v2(controlPoints[i].x, controlPoints[i].y));
      return newArray;
    }
    cc.CardinalSplineTo = cc.Class({
      name: "cc.CardinalSplineTo",
      extends: cc.ActionInterval,
      ctor: function ctor(duration, points, tension) {
        this._points = [];
        this._deltaT = 0;
        this._tension = 0;
        this._previousPosition = null;
        this._accumulatedDiff = null;
        void 0 !== tension && cc.CardinalSplineTo.prototype.initWithDuration.call(this, duration, points, tension);
      },
      initWithDuration: function initWithDuration(duration, points, tension) {
        if (!points || 0 === points.length) {
          cc.errorID(1024);
          return false;
        }
        if (cc.ActionInterval.prototype.initWithDuration.call(this, duration)) {
          this.setPoints(points);
          this._tension = tension;
          return true;
        }
        return false;
      },
      clone: function clone() {
        var action = new cc.CardinalSplineTo();
        action.initWithDuration(this._duration, cloneControlPoints(this._points), this._tension);
        return action;
      },
      startWithTarget: function startWithTarget(target) {
        cc.ActionInterval.prototype.startWithTarget.call(this, target);
        this._deltaT = 1 / (this._points.length - 1);
        this._previousPosition = cc.v2(this.target.x, this.target.y);
        this._accumulatedDiff = cc.v2(0, 0);
      },
      update: function update(dt) {
        dt = this._computeEaseTime(dt);
        var p, lt;
        var ps = this._points;
        if (1 === dt) {
          p = ps.length - 1;
          lt = 1;
        } else {
          var locDT = this._deltaT;
          p = 0 | dt / locDT;
          lt = (dt - locDT * p) / locDT;
        }
        var newPos = cardinalSplineAt(getControlPointAt(ps, p - 1), getControlPointAt(ps, p - 0), getControlPointAt(ps, p + 1), getControlPointAt(ps, p + 2), this._tension, lt);
        if (cc.macro.ENABLE_STACKABLE_ACTIONS) {
          var tempX, tempY;
          tempX = this.target.x - this._previousPosition.x;
          tempY = this.target.y - this._previousPosition.y;
          if (0 !== tempX || 0 !== tempY) {
            var locAccDiff = this._accumulatedDiff;
            tempX = locAccDiff.x + tempX;
            tempY = locAccDiff.y + tempY;
            locAccDiff.x = tempX;
            locAccDiff.y = tempY;
            newPos.x += tempX;
            newPos.y += tempY;
          }
        }
        this.updatePosition(newPos);
      },
      reverse: function reverse() {
        var reversePoints = reverseControlPoints(this._points);
        return cc.cardinalSplineTo(this._duration, reversePoints, this._tension);
      },
      updatePosition: function updatePosition(newPos) {
        this.target.setPosition(newPos);
        this._previousPosition = newPos;
      },
      getPoints: function getPoints() {
        return this._points;
      },
      setPoints: function setPoints(points) {
        this._points = points;
      }
    });
    cc.cardinalSplineTo = function(duration, points, tension) {
      return new cc.CardinalSplineTo(duration, points, tension);
    };
    cc.CardinalSplineBy = cc.Class({
      name: "cc.CardinalSplineBy",
      extends: cc.CardinalSplineTo,
      ctor: function ctor(duration, points, tension) {
        this._startPosition = cc.v2(0, 0);
        void 0 !== tension && this.initWithDuration(duration, points, tension);
      },
      startWithTarget: function startWithTarget(target) {
        cc.CardinalSplineTo.prototype.startWithTarget.call(this, target);
        this._startPosition.x = target.x;
        this._startPosition.y = target.y;
      },
      reverse: function reverse() {
        var copyConfig = this._points.slice();
        var current;
        var p = copyConfig[0];
        for (var i = 1; i < copyConfig.length; ++i) {
          current = copyConfig[i];
          copyConfig[i] = current.sub(p);
          p = current;
        }
        var reverseArray = reverseControlPoints(copyConfig);
        p = reverseArray[reverseArray.length - 1];
        reverseArray.pop();
        p.x = -p.x;
        p.y = -p.y;
        reverseArray.unshift(p);
        for (var i = 1; i < reverseArray.length; ++i) {
          current = reverseArray[i];
          current.x = -current.x;
          current.y = -current.y;
          current.x += p.x;
          current.y += p.y;
          reverseArray[i] = current;
          p = current;
        }
        return cc.cardinalSplineBy(this._duration, reverseArray, this._tension);
      },
      updatePosition: function updatePosition(newPos) {
        var pos = this._startPosition;
        var posX = newPos.x + pos.x;
        var posY = newPos.y + pos.y;
        this._previousPosition.x = posX;
        this._previousPosition.y = posY;
        this.target.setPosition(posX, posY);
      },
      clone: function clone() {
        var a = new cc.CardinalSplineBy();
        a.initWithDuration(this._duration, cloneControlPoints(this._points), this._tension);
        return a;
      }
    });
    cc.cardinalSplineBy = function(duration, points, tension) {
      return new cc.CardinalSplineBy(duration, points, tension);
    };
    cc.CatmullRomTo = cc.Class({
      name: "cc.CatmullRomTo",
      extends: cc.CardinalSplineTo,
      ctor: function ctor(dt, points) {
        points && this.initWithDuration(dt, points);
      },
      initWithDuration: function initWithDuration(dt, points) {
        return cc.CardinalSplineTo.prototype.initWithDuration.call(this, dt, points, .5);
      },
      clone: function clone() {
        var action = new cc.CatmullRomTo();
        action.initWithDuration(this._duration, cloneControlPoints(this._points));
        return action;
      }
    });
    cc.catmullRomTo = function(dt, points) {
      return new cc.CatmullRomTo(dt, points);
    };
    cc.CatmullRomBy = cc.Class({
      name: "cc.CatmullRomBy",
      extends: cc.CardinalSplineBy,
      ctor: function ctor(dt, points) {
        points && this.initWithDuration(dt, points);
      },
      initWithDuration: function initWithDuration(dt, points) {
        return cc.CardinalSplineTo.prototype.initWithDuration.call(this, dt, points, .5);
      },
      clone: function clone() {
        var action = new cc.CatmullRomBy();
        action.initWithDuration(this._duration, cloneControlPoints(this._points));
        return action;
      }
    });
    cc.catmullRomBy = function(dt, points) {
      return new cc.CatmullRomBy(dt, points);
    };
  }), {} ],
  4: [ (function(require, module, exports) {
    "use strict";
    cc.easeIn = function(rate) {
      return {
        _rate: rate,
        easing: function easing(dt) {
          return Math.pow(dt, this._rate);
        },
        reverse: function reverse() {
          return cc.easeIn(1 / this._rate);
        }
      };
    };
    cc.easeOut = function(rate) {
      return {
        _rate: rate,
        easing: function easing(dt) {
          return Math.pow(dt, 1 / this._rate);
        },
        reverse: function reverse() {
          return cc.easeOut(1 / this._rate);
        }
      };
    };
    cc.easeInOut = function(rate) {
      return {
        _rate: rate,
        easing: function easing(dt) {
          dt *= 2;
          return dt < 1 ? .5 * Math.pow(dt, this._rate) : 1 - .5 * Math.pow(2 - dt, this._rate);
        },
        reverse: function reverse() {
          return cc.easeInOut(this._rate);
        }
      };
    };
    var _easeExponentialInObj = {
      easing: function easing(dt) {
        return 0 === dt ? 0 : Math.pow(2, 10 * (dt - 1));
      },
      reverse: function reverse() {
        return _easeExponentialOutObj;
      }
    };
    cc.easeExponentialIn = function() {
      return _easeExponentialInObj;
    };
    var _easeExponentialOutObj = {
      easing: function easing(dt) {
        return 1 === dt ? 1 : 1 - Math.pow(2, -10 * dt);
      },
      reverse: function reverse() {
        return _easeExponentialInObj;
      }
    };
    cc.easeExponentialOut = function() {
      return _easeExponentialOutObj;
    };
    var _easeExponentialInOutObj = {
      easing: function easing(dt) {
        if (1 !== dt && 0 !== dt) {
          dt *= 2;
          return dt < 1 ? .5 * Math.pow(2, 10 * (dt - 1)) : .5 * (2 - Math.pow(2, -10 * (dt - 1)));
        }
        return dt;
      },
      reverse: function reverse() {
        return _easeExponentialInOutObj;
      }
    };
    cc.easeExponentialInOut = function() {
      return _easeExponentialInOutObj;
    };
    var _easeSineInObj = {
      easing: function easing(dt) {
        return 0 === dt || 1 === dt ? dt : -1 * Math.cos(dt * Math.PI / 2) + 1;
      },
      reverse: function reverse() {
        return _easeSineOutObj;
      }
    };
    cc.easeSineIn = function() {
      return _easeSineInObj;
    };
    var _easeSineOutObj = {
      easing: function easing(dt) {
        return 0 === dt || 1 === dt ? dt : Math.sin(dt * Math.PI / 2);
      },
      reverse: function reverse() {
        return _easeSineInObj;
      }
    };
    cc.easeSineOut = function() {
      return _easeSineOutObj;
    };
    var _easeSineInOutObj = {
      easing: function easing(dt) {
        return 0 === dt || 1 === dt ? dt : -.5 * (Math.cos(Math.PI * dt) - 1);
      },
      reverse: function reverse() {
        return _easeSineInOutObj;
      }
    };
    cc.easeSineInOut = function() {
      return _easeSineInOutObj;
    };
    var _easeElasticInObj = {
      easing: function easing(dt) {
        if (0 === dt || 1 === dt) return dt;
        dt -= 1;
        return -Math.pow(2, 10 * dt) * Math.sin((dt - .075) * Math.PI * 2 / .3);
      },
      reverse: function reverse() {
        return _easeElasticOutObj;
      }
    };
    cc.easeElasticIn = function(period) {
      if (period && .3 !== period) return {
        _period: period,
        easing: function easing(dt) {
          if (0 === dt || 1 === dt) return dt;
          dt -= 1;
          return -Math.pow(2, 10 * dt) * Math.sin((dt - this._period / 4) * Math.PI * 2 / this._period);
        },
        reverse: function reverse() {
          return cc.easeElasticOut(this._period);
        }
      };
      return _easeElasticInObj;
    };
    var _easeElasticOutObj = {
      easing: function easing(dt) {
        return 0 === dt || 1 === dt ? dt : Math.pow(2, -10 * dt) * Math.sin((dt - .075) * Math.PI * 2 / .3) + 1;
      },
      reverse: function reverse() {
        return _easeElasticInObj;
      }
    };
    cc.easeElasticOut = function(period) {
      if (period && .3 !== period) return {
        _period: period,
        easing: function easing(dt) {
          return 0 === dt || 1 === dt ? dt : Math.pow(2, -10 * dt) * Math.sin((dt - this._period / 4) * Math.PI * 2 / this._period) + 1;
        },
        reverse: function reverse() {
          return cc.easeElasticIn(this._period);
        }
      };
      return _easeElasticOutObj;
    };
    cc.easeElasticInOut = function(period) {
      period = period || .3;
      return {
        _period: period,
        easing: function easing(dt) {
          var newT = 0;
          var locPeriod = this._period;
          if (0 === dt || 1 === dt) newT = dt; else {
            dt *= 2;
            locPeriod || (locPeriod = this._period = .3 * 1.5);
            var s = locPeriod / 4;
            dt -= 1;
            newT = dt < 0 ? -.5 * Math.pow(2, 10 * dt) * Math.sin((dt - s) * Math.PI * 2 / locPeriod) : Math.pow(2, -10 * dt) * Math.sin((dt - s) * Math.PI * 2 / locPeriod) * .5 + 1;
          }
          return newT;
        },
        reverse: function reverse() {
          return cc.easeElasticInOut(this._period);
        }
      };
    };
    function _bounceTime(time1) {
      if (time1 < 1 / 2.75) return 7.5625 * time1 * time1;
      if (time1 < 2 / 2.75) {
        time1 -= 1.5 / 2.75;
        return 7.5625 * time1 * time1 + .75;
      }
      if (time1 < 2.5 / 2.75) {
        time1 -= 2.25 / 2.75;
        return 7.5625 * time1 * time1 + .9375;
      }
      time1 -= 2.625 / 2.75;
      return 7.5625 * time1 * time1 + .984375;
    }
    var _easeBounceInObj = {
      easing: function easing(dt) {
        return 1 - _bounceTime(1 - dt);
      },
      reverse: function reverse() {
        return _easeBounceOutObj;
      }
    };
    cc.easeBounceIn = function() {
      return _easeBounceInObj;
    };
    var _easeBounceOutObj = {
      easing: function easing(dt) {
        return _bounceTime(dt);
      },
      reverse: function reverse() {
        return _easeBounceInObj;
      }
    };
    cc.easeBounceOut = function() {
      return _easeBounceOutObj;
    };
    var _easeBounceInOutObj = {
      easing: function easing(time1) {
        var newT;
        if (time1 < .5) {
          time1 *= 2;
          newT = .5 * (1 - _bounceTime(1 - time1));
        } else newT = .5 * _bounceTime(2 * time1 - 1) + .5;
        return newT;
      },
      reverse: function reverse() {
        return _easeBounceInOutObj;
      }
    };
    cc.easeBounceInOut = function() {
      return _easeBounceInOutObj;
    };
    var _easeBackInObj = {
      easing: function easing(time1) {
        var overshoot = 1.70158;
        return 0 === time1 || 1 === time1 ? time1 : time1 * time1 * ((overshoot + 1) * time1 - overshoot);
      },
      reverse: function reverse() {
        return _easeBackOutObj;
      }
    };
    cc.easeBackIn = function() {
      return _easeBackInObj;
    };
    var _easeBackOutObj = {
      easing: function easing(time1) {
        var overshoot = 1.70158;
        time1 -= 1;
        return time1 * time1 * ((overshoot + 1) * time1 + overshoot) + 1;
      },
      reverse: function reverse() {
        return _easeBackInObj;
      }
    };
    cc.easeBackOut = function() {
      return _easeBackOutObj;
    };
    var _easeBackInOutObj = {
      easing: function easing(time1) {
        var overshoot = 2.5949095;
        time1 *= 2;
        if (time1 < 1) return time1 * time1 * ((overshoot + 1) * time1 - overshoot) / 2;
        time1 -= 2;
        return time1 * time1 * ((overshoot + 1) * time1 + overshoot) / 2 + 1;
      },
      reverse: function reverse() {
        return _easeBackInOutObj;
      }
    };
    cc.easeBackInOut = function() {
      return _easeBackInOutObj;
    };
    cc.easeBezierAction = function(a, b, c, d) {
      return {
        easing: function easing(t) {
          return Math.pow(1 - t, 3) * a + 3 * t * Math.pow(1 - t, 2) * b + 3 * Math.pow(t, 2) * (1 - t) * c + Math.pow(t, 3) * d;
        },
        reverse: function reverse() {
          return cc.easeBezierAction(d, c, b, a);
        }
      };
    };
    var _easeQuadraticActionIn = {
      easing: function easing(time) {
        return Math.pow(time, 2);
      },
      reverse: function reverse() {
        return _easeQuadraticActionIn;
      }
    };
    cc.easeQuadraticActionIn = function() {
      return _easeQuadraticActionIn;
    };
    var _easeQuadraticActionOut = {
      easing: function easing(time) {
        return -time * (time - 2);
      },
      reverse: function reverse() {
        return _easeQuadraticActionOut;
      }
    };
    cc.easeQuadraticActionOut = function() {
      return _easeQuadraticActionOut;
    };
    var _easeQuadraticActionInOut = {
      easing: function easing(time) {
        var resultTime = time;
        time *= 2;
        if (time < 1) resultTime = time * time * .5; else {
          --time;
          resultTime = -.5 * (time * (time - 2) - 1);
        }
        return resultTime;
      },
      reverse: function reverse() {
        return _easeQuadraticActionInOut;
      }
    };
    cc.easeQuadraticActionInOut = function() {
      return _easeQuadraticActionInOut;
    };
    var _easeQuarticActionIn = {
      easing: function easing(time) {
        return time * time * time * time;
      },
      reverse: function reverse() {
        return _easeQuarticActionIn;
      }
    };
    cc.easeQuarticActionIn = function() {
      return _easeQuarticActionIn;
    };
    var _easeQuarticActionOut = {
      easing: function easing(time) {
        time -= 1;
        return -(time * time * time * time - 1);
      },
      reverse: function reverse() {
        return _easeQuarticActionOut;
      }
    };
    cc.easeQuarticActionOut = function() {
      return _easeQuarticActionOut;
    };
    var _easeQuarticActionInOut = {
      easing: function easing(time) {
        time *= 2;
        if (time < 1) return .5 * time * time * time * time;
        time -= 2;
        return -.5 * (time * time * time * time - 2);
      },
      reverse: function reverse() {
        return _easeQuarticActionInOut;
      }
    };
    cc.easeQuarticActionInOut = function() {
      return _easeQuarticActionInOut;
    };
    var _easeQuinticActionIn = {
      easing: function easing(time) {
        return time * time * time * time * time;
      },
      reverse: function reverse() {
        return _easeQuinticActionIn;
      }
    };
    cc.easeQuinticActionIn = function() {
      return _easeQuinticActionIn;
    };
    var _easeQuinticActionOut = {
      easing: function easing(time) {
        time -= 1;
        return time * time * time * time * time + 1;
      },
      reverse: function reverse() {
        return _easeQuinticActionOut;
      }
    };
    cc.easeQuinticActionOut = function() {
      return _easeQuinticActionOut;
    };
    var _easeQuinticActionInOut = {
      easing: function easing(time) {
        time *= 2;
        if (time < 1) return .5 * time * time * time * time * time;
        time -= 2;
        return .5 * (time * time * time * time * time + 2);
      },
      reverse: function reverse() {
        return _easeQuinticActionInOut;
      }
    };
    cc.easeQuinticActionInOut = function() {
      return _easeQuinticActionInOut;
    };
    var _easeCircleActionIn = {
      easing: function easing(time) {
        return -1 * (Math.sqrt(1 - time * time) - 1);
      },
      reverse: function reverse() {
        return _easeCircleActionIn;
      }
    };
    cc.easeCircleActionIn = function() {
      return _easeCircleActionIn;
    };
    var _easeCircleActionOut = {
      easing: function easing(time) {
        time -= 1;
        return Math.sqrt(1 - time * time);
      },
      reverse: function reverse() {
        return _easeCircleActionOut;
      }
    };
    cc.easeCircleActionOut = function() {
      return _easeCircleActionOut;
    };
    var _easeCircleActionInOut = {
      easing: function easing(time) {
        time *= 2;
        if (time < 1) return -.5 * (Math.sqrt(1 - time * time) - 1);
        time -= 2;
        return .5 * (Math.sqrt(1 - time * time) + 1);
      },
      reverse: function reverse() {
        return _easeCircleActionInOut;
      }
    };
    cc.easeCircleActionInOut = function() {
      return _easeCircleActionInOut;
    };
    var _easeCubicActionIn = {
      easing: function easing(time) {
        return time * time * time;
      },
      reverse: function reverse() {
        return _easeCubicActionIn;
      }
    };
    cc.easeCubicActionIn = function() {
      return _easeCubicActionIn;
    };
    var _easeCubicActionOut = {
      easing: function easing(time) {
        time -= 1;
        return time * time * time + 1;
      },
      reverse: function reverse() {
        return _easeCubicActionOut;
      }
    };
    cc.easeCubicActionOut = function() {
      return _easeCubicActionOut;
    };
    var _easeCubicActionInOut = {
      easing: function easing(time) {
        time *= 2;
        if (time < 1) return .5 * time * time * time;
        time -= 2;
        return .5 * (time * time * time + 2);
      },
      reverse: function reverse() {
        return _easeCubicActionInOut;
      }
    };
    cc.easeCubicActionInOut = function() {
      return _easeCubicActionInOut;
    };
  }), {} ],
  5: [ (function(require, module, exports) {
    "use strict";
    cc.ActionInstant = cc.Class({
      name: "cc.ActionInstant",
      extends: cc.FiniteTimeAction,
      isDone: function isDone() {
        return true;
      },
      step: function step(dt) {
        this.update(1);
      },
      update: function update(dt) {},
      reverse: function reverse() {
        return this.clone();
      },
      clone: function clone() {
        return new cc.ActionInstant();
      }
    });
    cc.Show = cc.Class({
      name: "cc.Show",
      extends: cc.ActionInstant,
      update: function update(dt) {
        var _renderComps = this.target.getComponentsInChildren(cc.RenderComponent);
        for (var i = 0; i < _renderComps.length; ++i) {
          var render = _renderComps[i];
          render.enabled = true;
        }
      },
      reverse: function reverse() {
        return new cc.Hide();
      },
      clone: function clone() {
        return new cc.Show();
      }
    });
    cc.show = function() {
      return new cc.Show();
    };
    cc.Hide = cc.Class({
      name: "cc.Hide",
      extends: cc.ActionInstant,
      update: function update(dt) {
        var _renderComps = this.target.getComponentsInChildren(cc.RenderComponent);
        for (var i = 0; i < _renderComps.length; ++i) {
          var render = _renderComps[i];
          render.enabled = false;
        }
      },
      reverse: function reverse() {
        return new cc.Show();
      },
      clone: function clone() {
        return new cc.Hide();
      }
    });
    cc.hide = function() {
      return new cc.Hide();
    };
    cc.ToggleVisibility = cc.Class({
      name: "cc.ToggleVisibility",
      extends: cc.ActionInstant,
      update: function update(dt) {
        var _renderComps = this.target.getComponentsInChildren(cc.RenderComponent);
        for (var i = 0; i < _renderComps.length; ++i) {
          var render = _renderComps[i];
          render.enabled = !render.enabled;
        }
      },
      reverse: function reverse() {
        return new cc.ToggleVisibility();
      },
      clone: function clone() {
        return new cc.ToggleVisibility();
      }
    });
    cc.toggleVisibility = function() {
      return new cc.ToggleVisibility();
    };
    cc.RemoveSelf = cc.Class({
      name: "cc.RemoveSelf",
      extends: cc.ActionInstant,
      ctor: function ctor(isNeedCleanUp) {
        this._isNeedCleanUp = true;
        void 0 !== isNeedCleanUp && this.init(isNeedCleanUp);
      },
      update: function update(dt) {
        this.target.removeFromParent(this._isNeedCleanUp);
      },
      init: function init(isNeedCleanUp) {
        this._isNeedCleanUp = isNeedCleanUp;
        return true;
      },
      reverse: function reverse() {
        return new cc.RemoveSelf(this._isNeedCleanUp);
      },
      clone: function clone() {
        return new cc.RemoveSelf(this._isNeedCleanUp);
      }
    });
    cc.removeSelf = function(isNeedCleanUp) {
      return new cc.RemoveSelf(isNeedCleanUp);
    };
    cc.FlipX = cc.Class({
      name: "cc.FlipX",
      extends: cc.ActionInstant,
      ctor: function ctor(flip) {
        this._flippedX = false;
        void 0 !== flip && this.initWithFlipX(flip);
      },
      initWithFlipX: function initWithFlipX(flip) {
        this._flippedX = flip;
        return true;
      },
      update: function update(dt) {
        this.target.scaleX = Math.abs(this.target.scaleX) * (this._flippedX ? -1 : 1);
      },
      reverse: function reverse() {
        return new cc.FlipX(!this._flippedX);
      },
      clone: function clone() {
        var action = new cc.FlipX();
        action.initWithFlipX(this._flippedX);
        return action;
      }
    });
    cc.flipX = function(flip) {
      return new cc.FlipX(flip);
    };
    cc.FlipY = cc.Class({
      name: "cc.FlipY",
      extends: cc.ActionInstant,
      ctor: function ctor(flip) {
        this._flippedY = false;
        void 0 !== flip && this.initWithFlipY(flip);
      },
      initWithFlipY: function initWithFlipY(flip) {
        this._flippedY = flip;
        return true;
      },
      update: function update(dt) {
        this.target.scaleY = Math.abs(this.target.scaleY) * (this._flippedY ? -1 : 1);
      },
      reverse: function reverse() {
        return new cc.FlipY(!this._flippedY);
      },
      clone: function clone() {
        var action = new cc.FlipY();
        action.initWithFlipY(this._flippedY);
        return action;
      }
    });
    cc.flipY = function(flip) {
      return new cc.FlipY(flip);
    };
    cc.Place = cc.Class({
      name: "cc.Place",
      extends: cc.ActionInstant,
      ctor: function ctor(pos, y) {
        this._x = 0;
        this._y = 0;
        if (void 0 !== pos) {
          if (void 0 !== pos.x) {
            y = pos.y;
            pos = pos.x;
          }
          this.initWithPosition(pos, y);
        }
      },
      initWithPosition: function initWithPosition(x, y) {
        this._x = x;
        this._y = y;
        return true;
      },
      update: function update(dt) {
        this.target.setPosition(this._x, this._y);
      },
      clone: function clone() {
        var action = new cc.Place();
        action.initWithPosition(this._x, this._y);
        return action;
      }
    });
    cc.place = function(pos, y) {
      return new cc.Place(pos, y);
    };
    cc.CallFunc = cc.Class({
      name: "cc.CallFunc",
      extends: cc.ActionInstant,
      ctor: function ctor(selector, selectorTarget, data) {
        this._selectorTarget = null;
        this._function = null;
        this._data = null;
        this.initWithFunction(selector, selectorTarget, data);
      },
      initWithFunction: function initWithFunction(selector, selectorTarget, data) {
        selector && (this._function = selector);
        selectorTarget && (this._selectorTarget = selectorTarget);
        void 0 !== data && (this._data = data);
        return true;
      },
      execute: function execute() {
        this._function && this._function.call(this._selectorTarget, this.target, this._data);
      },
      update: function update(dt) {
        this.execute();
      },
      getTargetCallback: function getTargetCallback() {
        return this._selectorTarget;
      },
      setTargetCallback: function setTargetCallback(sel) {
        if (sel !== this._selectorTarget) {
          this._selectorTarget && (this._selectorTarget = null);
          this._selectorTarget = sel;
        }
      },
      clone: function clone() {
        var action = new cc.CallFunc();
        action.initWithFunction(this._function, this._selectorTarget, this._data);
        return action;
      }
    });
    cc.callFunc = function(selector, selectorTarget, data) {
      return new cc.CallFunc(selector, selectorTarget, data);
    };
  }), {} ],
  6: [ (function(require, module, exports) {
    "use strict";
    cc.ActionInterval = cc.Class({
      name: "cc.ActionInterval",
      extends: cc.FiniteTimeAction,
      ctor: function ctor(d) {
        this.MAX_VALUE = 2;
        this._elapsed = 0;
        this._firstTick = false;
        this._easeList = null;
        this._speed = 1;
        this._timesForRepeat = 1;
        this._repeatForever = false;
        this._repeatMethod = false;
        this._speedMethod = false;
        void 0 !== d && cc.ActionInterval.prototype.initWithDuration.call(this, d);
      },
      getElapsed: function getElapsed() {
        return this._elapsed;
      },
      initWithDuration: function initWithDuration(d) {
        this._duration = 0 === d ? cc.macro.FLT_EPSILON : d;
        this._elapsed = 0;
        this._firstTick = true;
        return true;
      },
      isDone: function isDone() {
        return this._elapsed >= this._duration;
      },
      _cloneDecoration: function _cloneDecoration(action) {
        action._repeatForever = this._repeatForever;
        action._speed = this._speed;
        action._timesForRepeat = this._timesForRepeat;
        action._easeList = this._easeList;
        action._speedMethod = this._speedMethod;
        action._repeatMethod = this._repeatMethod;
      },
      _reverseEaseList: function _reverseEaseList(action) {
        if (this._easeList) {
          action._easeList = [];
          for (var i = 0; i < this._easeList.length; i++) action._easeList.push(this._easeList[i].reverse());
        }
      },
      clone: function clone() {
        var action = new cc.ActionInterval(this._duration);
        this._cloneDecoration(action);
        return action;
      },
      easing: function easing(easeObj) {
        this._easeList ? this._easeList.length = 0 : this._easeList = [];
        for (var i = 0; i < arguments.length; i++) this._easeList.push(arguments[i]);
        return this;
      },
      _computeEaseTime: function _computeEaseTime(dt) {
        var locList = this._easeList;
        if (!locList || 0 === locList.length) return dt;
        for (var i = 0, n = locList.length; i < n; i++) dt = locList[i].easing(dt);
        return dt;
      },
      step: function step(dt) {
        if (this._firstTick) {
          this._firstTick = false;
          this._elapsed = 0;
        } else this._elapsed += dt;
        var t = this._elapsed / (this._duration > 1.192092896e-7 ? this._duration : 1.192092896e-7);
        t = 1 > t ? t : 1;
        this.update(t > 0 ? t : 0);
        if (this._repeatMethod && this._timesForRepeat > 1 && this.isDone()) {
          this._repeatForever || this._timesForRepeat--;
          this.startWithTarget(this.target);
          this.step(this._elapsed - this._duration);
        }
      },
      startWithTarget: function startWithTarget(target) {
        cc.Action.prototype.startWithTarget.call(this, target);
        this._elapsed = 0;
        this._firstTick = true;
      },
      reverse: function reverse() {
        cc.logID(1010);
        return null;
      },
      setAmplitudeRate: function setAmplitudeRate(amp) {
        cc.logID(1011);
      },
      getAmplitudeRate: function getAmplitudeRate() {
        cc.logID(1012);
        return 0;
      },
      speed: function speed(_speed) {
        if (_speed <= 0) {
          cc.logID(1013);
          return this;
        }
        this._speedMethod = true;
        this._speed *= _speed;
        return this;
      },
      getSpeed: function getSpeed() {
        return this._speed;
      },
      setSpeed: function setSpeed(speed) {
        this._speed = speed;
        return this;
      },
      repeat: function repeat(times) {
        times = Math.round(times);
        if (isNaN(times) || times < 1) {
          cc.logID(1014);
          return this;
        }
        this._repeatMethod = true;
        this._timesForRepeat *= times;
        return this;
      },
      repeatForever: function repeatForever() {
        this._repeatMethod = true;
        this._timesForRepeat = this.MAX_VALUE;
        this._repeatForever = true;
        return this;
      }
    });
    cc.actionInterval = function(d) {
      return new cc.ActionInterval(d);
    };
    cc.Sequence = cc.Class({
      name: "cc.Sequence",
      extends: cc.ActionInterval,
      ctor: function ctor(tempArray) {
        this._actions = [];
        this._split = null;
        this._last = 0;
        this._reversed = false;
        var paramArray = tempArray instanceof Array ? tempArray : arguments;
        if (1 === paramArray.length) {
          cc.errorID(1019);
          return;
        }
        var last = paramArray.length - 1;
        last >= 0 && null == paramArray[last] && cc.logID(1015);
        if (last >= 0) {
          var prev = paramArray[0], action1;
          for (var i = 1; i < last; i++) if (paramArray[i]) {
            action1 = prev;
            prev = cc.Sequence._actionOneTwo(action1, paramArray[i]);
          }
          this.initWithTwoActions(prev, paramArray[last]);
        }
      },
      initWithTwoActions: function initWithTwoActions(actionOne, actionTwo) {
        if (!actionOne || !actionTwo) {
          cc.errorID(1025);
          return false;
        }
        var durationOne = actionOne._duration, durationTwo = actionTwo._duration;
        durationOne *= actionOne._repeatMethod ? actionOne._timesForRepeat : 1;
        durationTwo *= actionTwo._repeatMethod ? actionTwo._timesForRepeat : 1;
        var d = durationOne + durationTwo;
        this.initWithDuration(d);
        this._actions[0] = actionOne;
        this._actions[1] = actionTwo;
        return true;
      },
      clone: function clone() {
        var action = new cc.Sequence();
        this._cloneDecoration(action);
        action.initWithTwoActions(this._actions[0].clone(), this._actions[1].clone());
        return action;
      },
      startWithTarget: function startWithTarget(target) {
        cc.ActionInterval.prototype.startWithTarget.call(this, target);
        this._split = this._actions[0]._duration / this._duration;
        this._split *= this._actions[0]._repeatMethod ? this._actions[0]._timesForRepeat : 1;
        this._last = -1;
      },
      stop: function stop() {
        -1 !== this._last && this._actions[this._last].stop();
        cc.Action.prototype.stop.call(this);
      },
      update: function update(dt) {
        var new_t, found = 0;
        var locSplit = this._split, locActions = this._actions, locLast = this._last, actionFound;
        dt = this._computeEaseTime(dt);
        if (dt < locSplit) {
          new_t = 0 !== locSplit ? dt / locSplit : 1;
          if (0 === found && 1 === locLast && this._reversed) {
            locActions[1].update(0);
            locActions[1].stop();
          }
        } else {
          found = 1;
          new_t = 1 === locSplit ? 1 : (dt - locSplit) / (1 - locSplit);
          if (-1 === locLast) {
            locActions[0].startWithTarget(this.target);
            locActions[0].update(1);
            locActions[0].stop();
          }
          if (0 === locLast) {
            locActions[0].update(1);
            locActions[0].stop();
          }
        }
        actionFound = locActions[found];
        if (locLast === found && actionFound.isDone()) return;
        locLast !== found && actionFound.startWithTarget(this.target);
        new_t *= actionFound._timesForRepeat;
        actionFound.update(new_t > 1 ? new_t % 1 : new_t);
        this._last = found;
      },
      reverse: function reverse() {
        var action = cc.Sequence._actionOneTwo(this._actions[1].reverse(), this._actions[0].reverse());
        this._cloneDecoration(action);
        this._reverseEaseList(action);
        action._reversed = true;
        return action;
      }
    });
    cc.sequence = function(tempArray) {
      var paramArray = tempArray instanceof Array ? tempArray : arguments;
      if (1 === paramArray.length) {
        cc.errorID(1019);
        return null;
      }
      var last = paramArray.length - 1;
      last >= 0 && null == paramArray[last] && cc.logID(1015);
      var result = null;
      if (last >= 0) {
        result = paramArray[0];
        for (var i = 1; i <= last; i++) paramArray[i] && (result = cc.Sequence._actionOneTwo(result, paramArray[i]));
      }
      return result;
    };
    cc.Sequence._actionOneTwo = function(actionOne, actionTwo) {
      var sequence = new cc.Sequence();
      sequence.initWithTwoActions(actionOne, actionTwo);
      return sequence;
    };
    cc.Repeat = cc.Class({
      name: "cc.Repeat",
      extends: cc.ActionInterval,
      ctor: function ctor(action, times) {
        this._times = 0;
        this._total = 0;
        this._nextDt = 0;
        this._actionInstant = false;
        this._innerAction = null;
        void 0 !== times && this.initWithAction(action, times);
      },
      initWithAction: function initWithAction(action, times) {
        var duration = action._duration * times;
        if (this.initWithDuration(duration)) {
          this._times = times;
          this._innerAction = action;
          if (action instanceof cc.ActionInstant) {
            this._actionInstant = true;
            this._times -= 1;
          }
          this._total = 0;
          return true;
        }
        return false;
      },
      clone: function clone() {
        var action = new cc.Repeat();
        this._cloneDecoration(action);
        action.initWithAction(this._innerAction.clone(), this._times);
        return action;
      },
      startWithTarget: function startWithTarget(target) {
        this._total = 0;
        this._nextDt = this._innerAction._duration / this._duration;
        cc.ActionInterval.prototype.startWithTarget.call(this, target);
        this._innerAction.startWithTarget(target);
      },
      stop: function stop() {
        this._innerAction.stop();
        cc.Action.prototype.stop.call(this);
      },
      update: function update(dt) {
        dt = this._computeEaseTime(dt);
        var locInnerAction = this._innerAction;
        var locDuration = this._duration;
        var locTimes = this._times;
        var locNextDt = this._nextDt;
        if (dt >= locNextDt) {
          while (dt > locNextDt && this._total < locTimes) {
            locInnerAction.update(1);
            this._total++;
            locInnerAction.stop();
            locInnerAction.startWithTarget(this.target);
            locNextDt += locInnerAction._duration / locDuration;
            this._nextDt = locNextDt > 1 ? 1 : locNextDt;
          }
          if (dt >= 1 && this._total < locTimes) {
            locInnerAction.update(1);
            this._total++;
          }
          this._actionInstant || (this._total === locTimes ? locInnerAction.stop() : locInnerAction.update(dt - (locNextDt - locInnerAction._duration / locDuration)));
        } else locInnerAction.update(dt * locTimes % 1);
      },
      isDone: function isDone() {
        return this._total === this._times;
      },
      reverse: function reverse() {
        var action = new cc.Repeat(this._innerAction.reverse(), this._times);
        this._cloneDecoration(action);
        this._reverseEaseList(action);
        return action;
      },
      setInnerAction: function setInnerAction(action) {
        this._innerAction !== action && (this._innerAction = action);
      },
      getInnerAction: function getInnerAction() {
        return this._innerAction;
      }
    });
    cc.repeat = function(action, times) {
      return new cc.Repeat(action, times);
    };
    cc.RepeatForever = cc.Class({
      name: "cc.RepeatForever",
      extends: cc.ActionInterval,
      ctor: function ctor(action) {
        this._innerAction = null;
        action && this.initWithAction(action);
      },
      initWithAction: function initWithAction(action) {
        if (!action) {
          cc.errorID(1026);
          return false;
        }
        this._innerAction = action;
        return true;
      },
      clone: function clone() {
        var action = new cc.RepeatForever();
        this._cloneDecoration(action);
        action.initWithAction(this._innerAction.clone());
        return action;
      },
      startWithTarget: function startWithTarget(target) {
        cc.ActionInterval.prototype.startWithTarget.call(this, target);
        this._innerAction.startWithTarget(target);
      },
      step: function step(dt) {
        var locInnerAction = this._innerAction;
        locInnerAction.step(dt);
        if (locInnerAction.isDone()) {
          locInnerAction.startWithTarget(this.target);
          locInnerAction.step(locInnerAction.getElapsed() - locInnerAction._duration);
        }
      },
      isDone: function isDone() {
        return false;
      },
      reverse: function reverse() {
        var action = new cc.RepeatForever(this._innerAction.reverse());
        this._cloneDecoration(action);
        this._reverseEaseList(action);
        return action;
      },
      setInnerAction: function setInnerAction(action) {
        this._innerAction !== action && (this._innerAction = action);
      },
      getInnerAction: function getInnerAction() {
        return this._innerAction;
      }
    });
    cc.repeatForever = function(action) {
      return new cc.RepeatForever(action);
    };
    cc.Spawn = cc.Class({
      name: "cc.Spawn",
      extends: cc.ActionInterval,
      ctor: function ctor(tempArray) {
        this._one = null;
        this._two = null;
        var paramArray = tempArray instanceof Array ? tempArray : arguments;
        if (1 === paramArray.length) {
          cc.errorID(1020);
          return;
        }
        var last = paramArray.length - 1;
        last >= 0 && null == paramArray[last] && cc.logID(1015);
        if (last >= 0) {
          var prev = paramArray[0], action1;
          for (var i = 1; i < last; i++) if (paramArray[i]) {
            action1 = prev;
            prev = cc.Spawn._actionOneTwo(action1, paramArray[i]);
          }
          this.initWithTwoActions(prev, paramArray[last]);
        }
      },
      initWithTwoActions: function initWithTwoActions(action1, action2) {
        if (!action1 || !action2) {
          cc.errorID(1027);
          return false;
        }
        var ret = false;
        var d1 = action1._duration;
        var d2 = action2._duration;
        if (this.initWithDuration(Math.max(d1, d2))) {
          this._one = action1;
          this._two = action2;
          d1 > d2 ? this._two = cc.Sequence._actionOneTwo(action2, cc.delayTime(d1 - d2)) : d1 < d2 && (this._one = cc.Sequence._actionOneTwo(action1, cc.delayTime(d2 - d1)));
          ret = true;
        }
        return ret;
      },
      clone: function clone() {
        var action = new cc.Spawn();
        this._cloneDecoration(action);
        action.initWithTwoActions(this._one.clone(), this._two.clone());
        return action;
      },
      startWithTarget: function startWithTarget(target) {
        cc.ActionInterval.prototype.startWithTarget.call(this, target);
        this._one.startWithTarget(target);
        this._two.startWithTarget(target);
      },
      stop: function stop() {
        this._one.stop();
        this._two.stop();
        cc.Action.prototype.stop.call(this);
      },
      update: function update(dt) {
        dt = this._computeEaseTime(dt);
        this._one && this._one.update(dt);
        this._two && this._two.update(dt);
      },
      reverse: function reverse() {
        var action = cc.Spawn._actionOneTwo(this._one.reverse(), this._two.reverse());
        this._cloneDecoration(action);
        this._reverseEaseList(action);
        return action;
      }
    });
    cc.spawn = function(tempArray) {
      var paramArray = tempArray instanceof Array ? tempArray : arguments;
      if (1 === paramArray.length) {
        cc.errorID(1020);
        return null;
      }
      paramArray.length > 0 && null == paramArray[paramArray.length - 1] && cc.logID(1015);
      var prev = paramArray[0];
      for (var i = 1; i < paramArray.length; i++) null != paramArray[i] && (prev = cc.Spawn._actionOneTwo(prev, paramArray[i]));
      return prev;
    };
    cc.Spawn._actionOneTwo = function(action1, action2) {
      var pSpawn = new cc.Spawn();
      pSpawn.initWithTwoActions(action1, action2);
      return pSpawn;
    };
    cc.RotateTo = cc.Class({
      name: "cc.RotateTo",
      extends: cc.ActionInterval,
      ctor: function ctor(duration, dstAngle) {
        this._startAngle = 0;
        this._dstAngle = 0;
        this._angle = 0;
        void 0 !== dstAngle && this.initWithDuration(duration, dstAngle);
      },
      initWithDuration: function initWithDuration(duration, dstAngle) {
        if (cc.ActionInterval.prototype.initWithDuration.call(this, duration)) {
          this._dstAngle = dstAngle;
          return true;
        }
        return false;
      },
      clone: function clone() {
        var action = new cc.RotateTo();
        this._cloneDecoration(action);
        action.initWithDuration(this._duration, this._dstAngle);
        return action;
      },
      startWithTarget: function startWithTarget(target) {
        cc.ActionInterval.prototype.startWithTarget.call(this, target);
        var startAngle = target.angle % 360;
        var angle = cc.macro.ROTATE_ACTION_CCW ? this._dstAngle - startAngle : startAngle - this._dstAngle;
        angle > 180 && (angle -= 360);
        angle < -180 && (angle += 360);
        this._startAngle = startAngle;
        this._angle = cc.macro.ROTATE_ACTION_CCW ? angle : -angle;
      },
      reverse: function reverse() {
        cc.logID(1016);
      },
      update: function update(dt) {
        dt = this._computeEaseTime(dt);
        this.target && (this.target.angle = this._startAngle + this._angle * dt);
      }
    });
    cc.rotateTo = function(duration, dstAngle) {
      return new cc.RotateTo(duration, dstAngle);
    };
    cc.RotateBy = cc.Class({
      name: "cc.RotateBy",
      extends: cc.ActionInterval,
      ctor: function ctor(duration, deltaAngle) {
        deltaAngle *= cc.macro.ROTATE_ACTION_CCW ? 1 : -1;
        this._deltaAngle = 0;
        this._startAngle = 0;
        void 0 !== deltaAngle && this.initWithDuration(duration, deltaAngle);
      },
      initWithDuration: function initWithDuration(duration, deltaAngle) {
        if (cc.ActionInterval.prototype.initWithDuration.call(this, duration)) {
          this._deltaAngle = deltaAngle;
          return true;
        }
        return false;
      },
      clone: function clone() {
        var action = new cc.RotateBy();
        this._cloneDecoration(action);
        action.initWithDuration(this._duration, this._deltaAngle);
        return action;
      },
      startWithTarget: function startWithTarget(target) {
        cc.ActionInterval.prototype.startWithTarget.call(this, target);
        this._startAngle = target.angle;
      },
      update: function update(dt) {
        dt = this._computeEaseTime(dt);
        this.target && (this.target.angle = this._startAngle + this._deltaAngle * dt);
      },
      reverse: function reverse() {
        var action = new cc.RotateBy();
        action.initWithDuration(this._duration, -this._deltaAngle);
        this._cloneDecoration(action);
        this._reverseEaseList(action);
        return action;
      }
    });
    cc.rotateBy = function(duration, deltaAngle) {
      return new cc.RotateBy(duration, deltaAngle);
    };
    cc.MoveBy = cc.Class({
      name: "cc.MoveBy",
      extends: cc.ActionInterval,
      ctor: function ctor(duration, deltaPos, deltaY) {
        this._positionDelta = cc.v2(0, 0);
        this._startPosition = cc.v2(0, 0);
        this._previousPosition = cc.v2(0, 0);
        void 0 !== deltaPos && cc.MoveBy.prototype.initWithDuration.call(this, duration, deltaPos, deltaY);
      },
      initWithDuration: function initWithDuration(duration, position, y) {
        if (cc.ActionInterval.prototype.initWithDuration.call(this, duration)) {
          if (void 0 !== position.x) {
            y = position.y;
            position = position.x;
          }
          this._positionDelta.x = position;
          this._positionDelta.y = y;
          return true;
        }
        return false;
      },
      clone: function clone() {
        var action = new cc.MoveBy();
        this._cloneDecoration(action);
        action.initWithDuration(this._duration, this._positionDelta);
        return action;
      },
      startWithTarget: function startWithTarget(target) {
        cc.ActionInterval.prototype.startWithTarget.call(this, target);
        var locPosX = target.x;
        var locPosY = target.y;
        this._previousPosition.x = locPosX;
        this._previousPosition.y = locPosY;
        this._startPosition.x = locPosX;
        this._startPosition.y = locPosY;
      },
      update: function update(dt) {
        dt = this._computeEaseTime(dt);
        if (this.target) {
          var x = this._positionDelta.x * dt;
          var y = this._positionDelta.y * dt;
          var locStartPosition = this._startPosition;
          if (cc.macro.ENABLE_STACKABLE_ACTIONS) {
            var targetX = this.target.x;
            var targetY = this.target.y;
            var locPreviousPosition = this._previousPosition;
            locStartPosition.x = locStartPosition.x + targetX - locPreviousPosition.x;
            locStartPosition.y = locStartPosition.y + targetY - locPreviousPosition.y;
            x += locStartPosition.x;
            y += locStartPosition.y;
            locPreviousPosition.x = x;
            locPreviousPosition.y = y;
            this.target.setPosition(x, y);
          } else this.target.setPosition(locStartPosition.x + x, locStartPosition.y + y);
        }
      },
      reverse: function reverse() {
        var action = new cc.MoveBy(this._duration, cc.v2(-this._positionDelta.x, -this._positionDelta.y));
        this._cloneDecoration(action);
        this._reverseEaseList(action);
        return action;
      }
    });
    cc.moveBy = function(duration, deltaPos, deltaY) {
      return new cc.MoveBy(duration, deltaPos, deltaY);
    };
    cc.MoveTo = cc.Class({
      name: "cc.MoveTo",
      extends: cc.MoveBy,
      ctor: function ctor(duration, position, y) {
        this._endPosition = cc.v2(0, 0);
        void 0 !== position && this.initWithDuration(duration, position, y);
      },
      initWithDuration: function initWithDuration(duration, position, y) {
        if (cc.MoveBy.prototype.initWithDuration.call(this, duration, position, y)) {
          if (void 0 !== position.x) {
            y = position.y;
            position = position.x;
          }
          this._endPosition.x = position;
          this._endPosition.y = y;
          return true;
        }
        return false;
      },
      clone: function clone() {
        var action = new cc.MoveTo();
        this._cloneDecoration(action);
        action.initWithDuration(this._duration, this._endPosition);
        return action;
      },
      startWithTarget: function startWithTarget(target) {
        cc.MoveBy.prototype.startWithTarget.call(this, target);
        this._positionDelta.x = this._endPosition.x - target.x;
        this._positionDelta.y = this._endPosition.y - target.y;
      }
    });
    cc.moveTo = function(duration, position, y) {
      return new cc.MoveTo(duration, position, y);
    };
    cc.SkewTo = cc.Class({
      name: "cc.SkewTo",
      extends: cc.ActionInterval,
      ctor: function ctor(t, sx, sy) {
        this._skewX = 0;
        this._skewY = 0;
        this._startSkewX = 0;
        this._startSkewY = 0;
        this._endSkewX = 0;
        this._endSkewY = 0;
        this._deltaX = 0;
        this._deltaY = 0;
        void 0 !== sy && cc.SkewTo.prototype.initWithDuration.call(this, t, sx, sy);
      },
      initWithDuration: function initWithDuration(t, sx, sy) {
        var ret = false;
        if (cc.ActionInterval.prototype.initWithDuration.call(this, t)) {
          this._endSkewX = sx;
          this._endSkewY = sy;
          ret = true;
        }
        return ret;
      },
      clone: function clone() {
        var action = new cc.SkewTo();
        this._cloneDecoration(action);
        action.initWithDuration(this._duration, this._endSkewX, this._endSkewY);
        return action;
      },
      startWithTarget: function startWithTarget(target) {
        cc.ActionInterval.prototype.startWithTarget.call(this, target);
        this._startSkewX = target.skewX % 180;
        this._deltaX = this._endSkewX - this._startSkewX;
        this._deltaX > 180 && (this._deltaX -= 360);
        this._deltaX < -180 && (this._deltaX += 360);
        this._startSkewY = target.skewY % 360;
        this._deltaY = this._endSkewY - this._startSkewY;
        this._deltaY > 180 && (this._deltaY -= 360);
        this._deltaY < -180 && (this._deltaY += 360);
      },
      update: function update(dt) {
        dt = this._computeEaseTime(dt);
        this.target.skewX = this._startSkewX + this._deltaX * dt;
        this.target.skewY = this._startSkewY + this._deltaY * dt;
      }
    });
    cc.skewTo = function(t, sx, sy) {
      return new cc.SkewTo(t, sx, sy);
    };
    cc.SkewBy = cc.Class({
      name: "cc.SkewBy",
      extends: cc.SkewTo,
      ctor: function ctor(t, sx, sy) {
        void 0 !== sy && this.initWithDuration(t, sx, sy);
      },
      initWithDuration: function initWithDuration(t, deltaSkewX, deltaSkewY) {
        var ret = false;
        if (cc.SkewTo.prototype.initWithDuration.call(this, t, deltaSkewX, deltaSkewY)) {
          this._skewX = deltaSkewX;
          this._skewY = deltaSkewY;
          ret = true;
        }
        return ret;
      },
      clone: function clone() {
        var action = new cc.SkewBy();
        this._cloneDecoration(action);
        action.initWithDuration(this._duration, this._skewX, this._skewY);
        return action;
      },
      startWithTarget: function startWithTarget(target) {
        cc.SkewTo.prototype.startWithTarget.call(this, target);
        this._deltaX = this._skewX;
        this._deltaY = this._skewY;
        this._endSkewX = this._startSkewX + this._deltaX;
        this._endSkewY = this._startSkewY + this._deltaY;
      },
      reverse: function reverse() {
        var action = new cc.SkewBy(this._duration, -this._skewX, -this._skewY);
        this._cloneDecoration(action);
        this._reverseEaseList(action);
        return action;
      }
    });
    cc.skewBy = function(t, sx, sy) {
      return new cc.SkewBy(t, sx, sy);
    };
    cc.JumpBy = cc.Class({
      name: "cc.JumpBy",
      extends: cc.ActionInterval,
      ctor: function ctor(duration, position, y, height, jumps) {
        this._startPosition = cc.v2(0, 0);
        this._previousPosition = cc.v2(0, 0);
        this._delta = cc.v2(0, 0);
        this._height = 0;
        this._jumps = 0;
        void 0 !== height && cc.JumpBy.prototype.initWithDuration.call(this, duration, position, y, height, jumps);
      },
      initWithDuration: function initWithDuration(duration, position, y, height, jumps) {
        if (cc.ActionInterval.prototype.initWithDuration.call(this, duration)) {
          if (void 0 === jumps) {
            jumps = height;
            height = y;
            y = position.y;
            position = position.x;
          }
          this._delta.x = position;
          this._delta.y = y;
          this._height = height;
          this._jumps = jumps;
          return true;
        }
        return false;
      },
      clone: function clone() {
        var action = new cc.JumpBy();
        this._cloneDecoration(action);
        action.initWithDuration(this._duration, this._delta, this._height, this._jumps);
        return action;
      },
      startWithTarget: function startWithTarget(target) {
        cc.ActionInterval.prototype.startWithTarget.call(this, target);
        var locPosX = target.x;
        var locPosY = target.y;
        this._previousPosition.x = locPosX;
        this._previousPosition.y = locPosY;
        this._startPosition.x = locPosX;
        this._startPosition.y = locPosY;
      },
      update: function update(dt) {
        dt = this._computeEaseTime(dt);
        if (this.target) {
          var frac = dt * this._jumps % 1;
          var y = 4 * this._height * frac * (1 - frac);
          y += this._delta.y * dt;
          var x = this._delta.x * dt;
          var locStartPosition = this._startPosition;
          if (cc.macro.ENABLE_STACKABLE_ACTIONS) {
            var targetX = this.target.x;
            var targetY = this.target.y;
            var locPreviousPosition = this._previousPosition;
            locStartPosition.x = locStartPosition.x + targetX - locPreviousPosition.x;
            locStartPosition.y = locStartPosition.y + targetY - locPreviousPosition.y;
            x += locStartPosition.x;
            y += locStartPosition.y;
            locPreviousPosition.x = x;
            locPreviousPosition.y = y;
            this.target.setPosition(x, y);
          } else this.target.setPosition(locStartPosition.x + x, locStartPosition.y + y);
        }
      },
      reverse: function reverse() {
        var action = new cc.JumpBy(this._duration, cc.v2(-this._delta.x, -this._delta.y), this._height, this._jumps);
        this._cloneDecoration(action);
        this._reverseEaseList(action);
        return action;
      }
    });
    cc.jumpBy = function(duration, position, y, height, jumps) {
      return new cc.JumpBy(duration, position, y, height, jumps);
    };
    cc.JumpTo = cc.Class({
      name: "cc.JumpTo",
      extends: cc.JumpBy,
      ctor: function ctor(duration, position, y, height, jumps) {
        this._endPosition = cc.v2(0, 0);
        void 0 !== height && this.initWithDuration(duration, position, y, height, jumps);
      },
      initWithDuration: function initWithDuration(duration, position, y, height, jumps) {
        if (cc.JumpBy.prototype.initWithDuration.call(this, duration, position, y, height, jumps)) {
          if (void 0 === jumps) {
            y = position.y;
            position = position.x;
          }
          this._endPosition.x = position;
          this._endPosition.y = y;
          return true;
        }
        return false;
      },
      startWithTarget: function startWithTarget(target) {
        cc.JumpBy.prototype.startWithTarget.call(this, target);
        this._delta.x = this._endPosition.x - this._startPosition.x;
        this._delta.y = this._endPosition.y - this._startPosition.y;
      },
      clone: function clone() {
        var action = new cc.JumpTo();
        this._cloneDecoration(action);
        action.initWithDuration(this._duration, this._endPosition, this._height, this._jumps);
        return action;
      }
    });
    cc.jumpTo = function(duration, position, y, height, jumps) {
      return new cc.JumpTo(duration, position, y, height, jumps);
    };
    function bezierAt(a, b, c, d, t) {
      return Math.pow(1 - t, 3) * a + 3 * t * Math.pow(1 - t, 2) * b + 3 * Math.pow(t, 2) * (1 - t) * c + Math.pow(t, 3) * d;
    }
    cc.BezierBy = cc.Class({
      name: "cc.BezierBy",
      extends: cc.ActionInterval,
      ctor: function ctor(t, c) {
        this._config = [];
        this._startPosition = cc.v2(0, 0);
        this._previousPosition = cc.v2(0, 0);
        c && cc.BezierBy.prototype.initWithDuration.call(this, t, c);
      },
      initWithDuration: function initWithDuration(t, c) {
        if (cc.ActionInterval.prototype.initWithDuration.call(this, t)) {
          this._config = c;
          return true;
        }
        return false;
      },
      clone: function clone() {
        var action = new cc.BezierBy();
        this._cloneDecoration(action);
        var newConfigs = [];
        for (var i = 0; i < this._config.length; i++) {
          var selConf = this._config[i];
          newConfigs.push(cc.v2(selConf.x, selConf.y));
        }
        action.initWithDuration(this._duration, newConfigs);
        return action;
      },
      startWithTarget: function startWithTarget(target) {
        cc.ActionInterval.prototype.startWithTarget.call(this, target);
        var locPosX = target.x;
        var locPosY = target.y;
        this._previousPosition.x = locPosX;
        this._previousPosition.y = locPosY;
        this._startPosition.x = locPosX;
        this._startPosition.y = locPosY;
      },
      update: function update(dt) {
        dt = this._computeEaseTime(dt);
        if (this.target) {
          var locConfig = this._config;
          var xa = 0;
          var xb = locConfig[0].x;
          var xc = locConfig[1].x;
          var xd = locConfig[2].x;
          var ya = 0;
          var yb = locConfig[0].y;
          var yc = locConfig[1].y;
          var yd = locConfig[2].y;
          var x = bezierAt(xa, xb, xc, xd, dt);
          var y = bezierAt(ya, yb, yc, yd, dt);
          var locStartPosition = this._startPosition;
          if (cc.macro.ENABLE_STACKABLE_ACTIONS) {
            var targetX = this.target.x;
            var targetY = this.target.y;
            var locPreviousPosition = this._previousPosition;
            locStartPosition.x = locStartPosition.x + targetX - locPreviousPosition.x;
            locStartPosition.y = locStartPosition.y + targetY - locPreviousPosition.y;
            x += locStartPosition.x;
            y += locStartPosition.y;
            locPreviousPosition.x = x;
            locPreviousPosition.y = y;
            this.target.setPosition(x, y);
          } else this.target.setPosition(locStartPosition.x + x, locStartPosition.y + y);
        }
      },
      reverse: function reverse() {
        var locConfig = this._config;
        var x0 = locConfig[0].x, y0 = locConfig[0].y;
        var x1 = locConfig[1].x, y1 = locConfig[1].y;
        var x2 = locConfig[2].x, y2 = locConfig[2].y;
        var r = [ cc.v2(x1 - x2, y1 - y2), cc.v2(x0 - x2, y0 - y2), cc.v2(-x2, -y2) ];
        var action = new cc.BezierBy(this._duration, r);
        this._cloneDecoration(action);
        this._reverseEaseList(action);
        return action;
      }
    });
    cc.bezierBy = function(t, c) {
      return new cc.BezierBy(t, c);
    };
    cc.BezierTo = cc.Class({
      name: "cc.BezierTo",
      extends: cc.BezierBy,
      ctor: function ctor(t, c) {
        this._toConfig = [];
        c && this.initWithDuration(t, c);
      },
      initWithDuration: function initWithDuration(t, c) {
        if (cc.ActionInterval.prototype.initWithDuration.call(this, t)) {
          this._toConfig = c;
          return true;
        }
        return false;
      },
      clone: function clone() {
        var action = new cc.BezierTo();
        this._cloneDecoration(action);
        action.initWithDuration(this._duration, this._toConfig);
        return action;
      },
      startWithTarget: function startWithTarget(target) {
        cc.BezierBy.prototype.startWithTarget.call(this, target);
        var locStartPos = this._startPosition;
        var locToConfig = this._toConfig;
        var locConfig = this._config;
        locConfig[0] = locToConfig[0].sub(locStartPos);
        locConfig[1] = locToConfig[1].sub(locStartPos);
        locConfig[2] = locToConfig[2].sub(locStartPos);
      }
    });
    cc.bezierTo = function(t, c) {
      return new cc.BezierTo(t, c);
    };
    cc.ScaleTo = cc.Class({
      name: "cc.ScaleTo",
      extends: cc.ActionInterval,
      ctor: function ctor(duration, sx, sy) {
        this._scaleX = 1;
        this._scaleY = 1;
        this._startScaleX = 1;
        this._startScaleY = 1;
        this._endScaleX = 0;
        this._endScaleY = 0;
        this._deltaX = 0;
        this._deltaY = 0;
        void 0 !== sx && cc.ScaleTo.prototype.initWithDuration.call(this, duration, sx, sy);
      },
      initWithDuration: function initWithDuration(duration, sx, sy) {
        if (cc.ActionInterval.prototype.initWithDuration.call(this, duration)) {
          this._endScaleX = sx;
          this._endScaleY = null != sy ? sy : sx;
          return true;
        }
        return false;
      },
      clone: function clone() {
        var action = new cc.ScaleTo();
        this._cloneDecoration(action);
        action.initWithDuration(this._duration, this._endScaleX, this._endScaleY);
        return action;
      },
      startWithTarget: function startWithTarget(target) {
        cc.ActionInterval.prototype.startWithTarget.call(this, target);
        this._startScaleX = target.scaleX;
        this._startScaleY = target.scaleY;
        this._deltaX = this._endScaleX - this._startScaleX;
        this._deltaY = this._endScaleY - this._startScaleY;
      },
      update: function update(dt) {
        dt = this._computeEaseTime(dt);
        if (this.target) {
          this.target.scaleX = this._startScaleX + this._deltaX * dt;
          this.target.scaleY = this._startScaleY + this._deltaY * dt;
        }
      }
    });
    cc.scaleTo = function(duration, sx, sy) {
      return new cc.ScaleTo(duration, sx, sy);
    };
    cc.ScaleBy = cc.Class({
      name: "cc.ScaleBy",
      extends: cc.ScaleTo,
      startWithTarget: function startWithTarget(target) {
        cc.ScaleTo.prototype.startWithTarget.call(this, target);
        this._deltaX = this._startScaleX * this._endScaleX - this._startScaleX;
        this._deltaY = this._startScaleY * this._endScaleY - this._startScaleY;
      },
      reverse: function reverse() {
        var action = new cc.ScaleBy(this._duration, 1 / this._endScaleX, 1 / this._endScaleY);
        this._cloneDecoration(action);
        this._reverseEaseList(action);
        return action;
      },
      clone: function clone() {
        var action = new cc.ScaleBy();
        this._cloneDecoration(action);
        action.initWithDuration(this._duration, this._endScaleX, this._endScaleY);
        return action;
      }
    });
    cc.scaleBy = function(duration, sx, sy) {
      return new cc.ScaleBy(duration, sx, sy);
    };
    cc.Blink = cc.Class({
      name: "cc.Blink",
      extends: cc.ActionInterval,
      ctor: function ctor(duration, blinks) {
        this._times = 0;
        this._originalState = false;
        void 0 !== blinks && this.initWithDuration(duration, blinks);
      },
      initWithDuration: function initWithDuration(duration, blinks) {
        if (cc.ActionInterval.prototype.initWithDuration.call(this, duration)) {
          this._times = blinks;
          return true;
        }
        return false;
      },
      clone: function clone() {
        var action = new cc.Blink();
        this._cloneDecoration(action);
        action.initWithDuration(this._duration, this._times);
        return action;
      },
      update: function update(dt) {
        dt = this._computeEaseTime(dt);
        if (this.target && !this.isDone()) {
          var slice = 1 / this._times;
          var m = dt % slice;
          this.target.opacity = m > slice / 2 ? 255 : 0;
        }
      },
      startWithTarget: function startWithTarget(target) {
        cc.ActionInterval.prototype.startWithTarget.call(this, target);
        this._originalState = target.opacity;
      },
      stop: function stop() {
        this.target.opacity = this._originalState;
        cc.ActionInterval.prototype.stop.call(this);
      },
      reverse: function reverse() {
        var action = new cc.Blink(this._duration, this._times);
        this._cloneDecoration(action);
        this._reverseEaseList(action);
        return action;
      }
    });
    cc.blink = function(duration, blinks) {
      return new cc.Blink(duration, blinks);
    };
    cc.FadeTo = cc.Class({
      name: "cc.FadeTo",
      extends: cc.ActionInterval,
      ctor: function ctor(duration, opacity) {
        this._toOpacity = 0;
        this._fromOpacity = 0;
        void 0 !== opacity && cc.FadeTo.prototype.initWithDuration.call(this, duration, opacity);
      },
      initWithDuration: function initWithDuration(duration, opacity) {
        if (cc.ActionInterval.prototype.initWithDuration.call(this, duration)) {
          this._toOpacity = opacity;
          return true;
        }
        return false;
      },
      clone: function clone() {
        var action = new cc.FadeTo();
        this._cloneDecoration(action);
        action.initWithDuration(this._duration, this._toOpacity);
        return action;
      },
      update: function update(time) {
        time = this._computeEaseTime(time);
        var fromOpacity = void 0 !== this._fromOpacity ? this._fromOpacity : 255;
        this.target.opacity = fromOpacity + (this._toOpacity - fromOpacity) * time;
      },
      startWithTarget: function startWithTarget(target) {
        cc.ActionInterval.prototype.startWithTarget.call(this, target);
        this._fromOpacity = target.opacity;
      }
    });
    cc.fadeTo = function(duration, opacity) {
      return new cc.FadeTo(duration, opacity);
    };
    cc.FadeIn = cc.Class({
      name: "cc.FadeIn",
      extends: cc.FadeTo,
      ctor: function ctor(duration) {
        null == duration && (duration = 0);
        this._reverseAction = null;
        this.initWithDuration(duration, 255);
      },
      reverse: function reverse() {
        var action = new cc.FadeOut();
        action.initWithDuration(this._duration, 0);
        this._cloneDecoration(action);
        this._reverseEaseList(action);
        return action;
      },
      clone: function clone() {
        var action = new cc.FadeIn();
        this._cloneDecoration(action);
        action.initWithDuration(this._duration, this._toOpacity);
        return action;
      },
      startWithTarget: function startWithTarget(target) {
        this._reverseAction && (this._toOpacity = this._reverseAction._fromOpacity);
        cc.FadeTo.prototype.startWithTarget.call(this, target);
      }
    });
    cc.fadeIn = function(duration) {
      return new cc.FadeIn(duration);
    };
    cc.FadeOut = cc.Class({
      name: "cc.FadeOut",
      extends: cc.FadeTo,
      ctor: function ctor(duration) {
        null == duration && (duration = 0);
        this._reverseAction = null;
        this.initWithDuration(duration, 0);
      },
      reverse: function reverse() {
        var action = new cc.FadeIn();
        action._reverseAction = this;
        action.initWithDuration(this._duration, 255);
        this._cloneDecoration(action);
        this._reverseEaseList(action);
        return action;
      },
      clone: function clone() {
        var action = new cc.FadeOut();
        this._cloneDecoration(action);
        action.initWithDuration(this._duration, this._toOpacity);
        return action;
      }
    });
    cc.fadeOut = function(d) {
      return new cc.FadeOut(d);
    };
    cc.TintTo = cc.Class({
      name: "cc.TintTo",
      extends: cc.ActionInterval,
      ctor: function ctor(duration, red, green, blue) {
        this._to = cc.color(0, 0, 0);
        this._from = cc.color(0, 0, 0);
        if (red instanceof cc.Color) {
          blue = red.b;
          green = red.g;
          red = red.r;
        }
        void 0 !== blue && this.initWithDuration(duration, red, green, blue);
      },
      initWithDuration: function initWithDuration(duration, red, green, blue) {
        if (cc.ActionInterval.prototype.initWithDuration.call(this, duration)) {
          this._to = cc.color(red, green, blue);
          return true;
        }
        return false;
      },
      clone: function clone() {
        var action = new cc.TintTo();
        this._cloneDecoration(action);
        var locTo = this._to;
        action.initWithDuration(this._duration, locTo.r, locTo.g, locTo.b);
        return action;
      },
      startWithTarget: function startWithTarget(target) {
        cc.ActionInterval.prototype.startWithTarget.call(this, target);
        this._from = this.target.color;
      },
      update: function update(dt) {
        dt = this._computeEaseTime(dt);
        var locFrom = this._from, locTo = this._to;
        locFrom && (this.target.color = cc.color(locFrom.r + (locTo.r - locFrom.r) * dt, locFrom.g + (locTo.g - locFrom.g) * dt, locFrom.b + (locTo.b - locFrom.b) * dt));
      }
    });
    cc.tintTo = function(duration, red, green, blue) {
      return new cc.TintTo(duration, red, green, blue);
    };
    cc.TintBy = cc.Class({
      name: "cc.TintBy",
      extends: cc.ActionInterval,
      ctor: function ctor(duration, deltaRed, deltaGreen, deltaBlue) {
        this._deltaR = 0;
        this._deltaG = 0;
        this._deltaB = 0;
        this._fromR = 0;
        this._fromG = 0;
        this._fromB = 0;
        void 0 !== deltaBlue && this.initWithDuration(duration, deltaRed, deltaGreen, deltaBlue);
      },
      initWithDuration: function initWithDuration(duration, deltaRed, deltaGreen, deltaBlue) {
        if (cc.ActionInterval.prototype.initWithDuration.call(this, duration)) {
          this._deltaR = deltaRed;
          this._deltaG = deltaGreen;
          this._deltaB = deltaBlue;
          return true;
        }
        return false;
      },
      clone: function clone() {
        var action = new cc.TintBy();
        this._cloneDecoration(action);
        action.initWithDuration(this._duration, this._deltaR, this._deltaG, this._deltaB);
        return action;
      },
      startWithTarget: function startWithTarget(target) {
        cc.ActionInterval.prototype.startWithTarget.call(this, target);
        var color = target.color;
        this._fromR = color.r;
        this._fromG = color.g;
        this._fromB = color.b;
      },
      update: function update(dt) {
        dt = this._computeEaseTime(dt);
        this.target.color = cc.color(this._fromR + this._deltaR * dt, this._fromG + this._deltaG * dt, this._fromB + this._deltaB * dt);
      },
      reverse: function reverse() {
        var action = new cc.TintBy(this._duration, -this._deltaR, -this._deltaG, -this._deltaB);
        this._cloneDecoration(action);
        this._reverseEaseList(action);
        return action;
      }
    });
    cc.tintBy = function(duration, deltaRed, deltaGreen, deltaBlue) {
      return new cc.TintBy(duration, deltaRed, deltaGreen, deltaBlue);
    };
    cc.DelayTime = cc.Class({
      name: "cc.DelayTime",
      extends: cc.ActionInterval,
      update: function update(dt) {},
      reverse: function reverse() {
        var action = new cc.DelayTime(this._duration);
        this._cloneDecoration(action);
        this._reverseEaseList(action);
        return action;
      },
      clone: function clone() {
        var action = new cc.DelayTime();
        this._cloneDecoration(action);
        action.initWithDuration(this._duration);
        return action;
      }
    });
    cc.delayTime = function(d) {
      return new cc.DelayTime(d);
    };
    cc.ReverseTime = cc.Class({
      name: "cc.ReverseTime",
      extends: cc.ActionInterval,
      ctor: function ctor(action) {
        this._other = null;
        action && this.initWithAction(action);
      },
      initWithAction: function initWithAction(action) {
        if (!action) {
          cc.errorID(1028);
          return false;
        }
        if (action === this._other) {
          cc.errorID(1029);
          return false;
        }
        if (cc.ActionInterval.prototype.initWithDuration.call(this, action._duration)) {
          this._other = action;
          return true;
        }
        return false;
      },
      clone: function clone() {
        var action = new cc.ReverseTime();
        this._cloneDecoration(action);
        action.initWithAction(this._other.clone());
        return action;
      },
      startWithTarget: function startWithTarget(target) {
        cc.ActionInterval.prototype.startWithTarget.call(this, target);
        this._other.startWithTarget(target);
      },
      update: function update(dt) {
        dt = this._computeEaseTime(dt);
        this._other && this._other.update(1 - dt);
      },
      reverse: function reverse() {
        return this._other.clone();
      },
      stop: function stop() {
        this._other.stop();
        cc.Action.prototype.stop.call(this);
      }
    });
    cc.reverseTime = function(action) {
      return new cc.ReverseTime(action);
    };
    cc.TargetedAction = cc.Class({
      name: "cc.TargetedAction",
      extends: cc.ActionInterval,
      ctor: function ctor(target, action) {
        this._action = null;
        this._forcedTarget = null;
        action && this.initWithTarget(target, action);
      },
      initWithTarget: function initWithTarget(target, action) {
        if (this.initWithDuration(action._duration)) {
          this._forcedTarget = target;
          this._action = action;
          return true;
        }
        return false;
      },
      clone: function clone() {
        var action = new cc.TargetedAction();
        this._cloneDecoration(action);
        action.initWithTarget(this._forcedTarget, this._action.clone());
        return action;
      },
      startWithTarget: function startWithTarget(target) {
        cc.ActionInterval.prototype.startWithTarget.call(this, target);
        this._action.startWithTarget(this._forcedTarget);
      },
      stop: function stop() {
        this._action.stop();
      },
      update: function update(dt) {
        dt = this._computeEaseTime(dt);
        this._action.update(dt);
      },
      getForcedTarget: function getForcedTarget() {
        return this._forcedTarget;
      },
      setForcedTarget: function setForcedTarget(forcedTarget) {
        this._forcedTarget !== forcedTarget && (this._forcedTarget = forcedTarget);
      }
    });
    cc.targetedAction = function(target, action) {
      return new cc.TargetedAction(target, action);
    };
  }), {} ],
  7: [ (function(require, module, exports) {
    "use strict";
    require("../core/platform/CCClass");
    var js = require("../core/platform/js");
    var HashElement = function HashElement() {
      this.actions = [];
      this.target = null;
      this.actionIndex = 0;
      this.currentAction = null;
      this.paused = false;
      this.lock = false;
    };
    cc.ActionManager = function() {
      this._hashTargets = js.createMap(true);
      this._arrayTargets = [];
      this._currentTarget = null;
      cc.director._scheduler && cc.director._scheduler.enableForTarget(this);
    };
    cc.ActionManager.prototype = {
      constructor: cc.ActionManager,
      _elementPool: [],
      _searchElementByTarget: function _searchElementByTarget(arr, target) {
        for (var k = 0; k < arr.length; k++) if (target === arr[k].target) return arr[k];
        return null;
      },
      _getElement: function _getElement(target, paused) {
        var element = this._elementPool.pop();
        element || (element = new HashElement());
        element.target = target;
        element.paused = !!paused;
        return element;
      },
      _putElement: function _putElement(element) {
        element.actions.length = 0;
        element.actionIndex = 0;
        element.currentAction = null;
        element.paused = false;
        element.target = null;
        element.lock = false;
        this._elementPool.push(element);
      },
      addAction: function addAction(action, target, paused) {
        if (!action || !target) {
          cc.errorID(1e3);
          return;
        }
        var element = this._hashTargets[target._id];
        if (element) element.actions || (element.actions = []); else {
          element = this._getElement(target, paused);
          this._hashTargets[target._id] = element;
          this._arrayTargets.push(element);
        }
        element.actions.push(action);
        action.startWithTarget(target);
      },
      removeAllActions: function removeAllActions() {
        var locTargets = this._arrayTargets;
        for (var i = 0; i < locTargets.length; i++) {
          var element = locTargets[i];
          element && this._putElement(element);
        }
        this._arrayTargets.length = 0;
        this._hashTargets = js.createMap(true);
      },
      removeAllActionsFromTarget: function removeAllActionsFromTarget(target, forceDelete) {
        if (null == target) return;
        var element = this._hashTargets[target._id];
        if (element) {
          element.actions.length = 0;
          this._deleteHashElement(element);
        }
      },
      removeAction: function removeAction(action) {
        if (null == action) return;
        var target = action.getOriginalTarget();
        var element = this._hashTargets[target._id];
        if (element) {
          for (var i = 0; i < element.actions.length; i++) if (element.actions[i] === action) {
            element.actions.splice(i, 1);
            element.actionIndex >= i && element.actionIndex--;
            break;
          }
        } else cc.logID(1001);
      },
      removeActionByTag: function removeActionByTag(tag, target) {
        tag === cc.Action.TAG_INVALID && cc.logID(1002);
        cc.assertID(target, 1003);
        var element = this._hashTargets[target._id];
        if (element) {
          var limit = element.actions.length;
          for (var i = 0; i < limit; ++i) {
            var action = element.actions[i];
            if (action && action.getTag() === tag && action.getOriginalTarget() === target) {
              this._removeActionAtIndex(i, element);
              break;
            }
          }
        }
      },
      getActionByTag: function getActionByTag(tag, target) {
        tag === cc.Action.TAG_INVALID && cc.logID(1004);
        var element = this._hashTargets[target._id];
        if (element) {
          if (null != element.actions) for (var i = 0; i < element.actions.length; ++i) {
            var action = element.actions[i];
            if (action && action.getTag() === tag) return action;
          }
          cc.logID(1005, tag);
        }
        return null;
      },
      getNumberOfRunningActionsInTarget: function getNumberOfRunningActionsInTarget(target) {
        var element = this._hashTargets[target._id];
        if (element) return element.actions ? element.actions.length : 0;
        return 0;
      },
      pauseTarget: function pauseTarget(target) {
        var element = this._hashTargets[target._id];
        element && (element.paused = true);
      },
      resumeTarget: function resumeTarget(target) {
        var element = this._hashTargets[target._id];
        element && (element.paused = false);
      },
      pauseAllRunningActions: function pauseAllRunningActions() {
        var idsWithActions = [];
        var locTargets = this._arrayTargets;
        for (var i = 0; i < locTargets.length; i++) {
          var element = locTargets[i];
          if (element && !element.paused) {
            element.paused = true;
            idsWithActions.push(element.target);
          }
        }
        return idsWithActions;
      },
      resumeTargets: function resumeTargets(targetsToResume) {
        if (!targetsToResume) return;
        for (var i = 0; i < targetsToResume.length; i++) targetsToResume[i] && this.resumeTarget(targetsToResume[i]);
      },
      pauseTargets: function pauseTargets(targetsToPause) {
        if (!targetsToPause) return;
        for (var i = 0; i < targetsToPause.length; i++) targetsToPause[i] && this.pauseTarget(targetsToPause[i]);
      },
      purgeSharedManager: function purgeSharedManager() {
        cc.director.getScheduler().unscheduleUpdate(this);
      },
      _removeActionAtIndex: function _removeActionAtIndex(index, element) {
        var action = element.actions[index];
        element.actions.splice(index, 1);
        element.actionIndex >= index && element.actionIndex--;
        0 === element.actions.length && this._deleteHashElement(element);
      },
      _deleteHashElement: function _deleteHashElement(element) {
        var ret = false;
        if (element && !element.lock && this._hashTargets[element.target._id]) {
          delete this._hashTargets[element.target._id];
          var targets = this._arrayTargets;
          for (var i = 0, l = targets.length; i < l; i++) if (targets[i] === element) {
            targets.splice(i, 1);
            break;
          }
          this._putElement(element);
          ret = true;
        }
        return ret;
      },
      update: function update(dt) {
        var locTargets = this._arrayTargets, locCurrTarget;
        for (var elt = 0; elt < locTargets.length; elt++) {
          this._currentTarget = locTargets[elt];
          locCurrTarget = this._currentTarget;
          if (!locCurrTarget.paused && locCurrTarget.actions) {
            locCurrTarget.lock = true;
            for (locCurrTarget.actionIndex = 0; locCurrTarget.actionIndex < locCurrTarget.actions.length; locCurrTarget.actionIndex++) {
              locCurrTarget.currentAction = locCurrTarget.actions[locCurrTarget.actionIndex];
              if (!locCurrTarget.currentAction) continue;
              locCurrTarget.currentAction.step(dt * (locCurrTarget.currentAction._speedMethod ? locCurrTarget.currentAction._speed : 1));
              if (locCurrTarget.currentAction && locCurrTarget.currentAction.isDone()) {
                locCurrTarget.currentAction.stop();
                var action = locCurrTarget.currentAction;
                locCurrTarget.currentAction = null;
                this.removeAction(action);
              }
              locCurrTarget.currentAction = null;
            }
            locCurrTarget.lock = false;
          }
          0 === locCurrTarget.actions.length && this._deleteHashElement(locCurrTarget) && elt--;
        }
      }
    };
    false;
  }), {
    "../core/platform/CCClass": 199,
    "../core/platform/js": 219
  } ],
  8: [ (function(require, module, exports) {
    "use strict";
    require("./CCActionManager");
    require("./CCAction");
    require("./CCActionInterval");
    require("./CCActionInstant");
    require("./CCActionEase");
    require("./CCActionCatmullRom");
    require("./tween");
  }), {
    "./CCAction": 2,
    "./CCActionCatmullRom": 3,
    "./CCActionEase": 4,
    "./CCActionInstant": 5,
    "./CCActionInterval": 6,
    "./CCActionManager": 7,
    "./tween": 9
  } ],
  9: [ (function(require, module, exports) {
    "use strict";
    var TweenAction = cc.Class({
      name: "cc.TweenAction",
      extends: cc.ActionInterval,
      ctor: function ctor(duration, props, opts) {
        this._opts = opts = opts || Object.create(null);
        this._props = Object.create(null);
        opts.progress = opts.progress || this.progress;
        if (opts.easing && "string" === typeof opts.easing) {
          var easingName = opts.easing;
          opts.easing = cc.easing[easingName];
          !opts.easing && cc.warnID(1031, easingName);
        }
        var relative = this._opts.relative;
        for (var name in props) {
          var value = props[name];
          var easing = void 0, progress = void 0;
          if (void 0 !== value.value && (value.easing || value.progress)) {
            if ("string" === typeof value.easing) {
              easing = cc.easing[value.easing];
              !easing && cc.warnID(1031, value.easing);
            } else easing = value.easing;
            progress = value.progress;
            value = value.value;
          }
          var isNumber = "number" === typeof value;
          if (!isNumber && (!value.lerp || relative && !value.add && !value.mul || !value.clone)) {
            cc.warn("Can not animate " + name + " property, because it do not have [lerp, (add|mul), clone] function.");
            continue;
          }
          var prop = Object.create(null);
          prop.value = value;
          prop.easing = easing;
          prop.progress = progress;
          this._props[name] = prop;
        }
        this._originProps = props;
        this.initWithDuration(duration);
      },
      clone: function clone() {
        var action = new TweenAction(this._duration, this._originProps, this._opts);
        this._cloneDecoration(action);
        return action;
      },
      startWithTarget: function startWithTarget(target) {
        cc.ActionInterval.prototype.startWithTarget.call(this, target);
        var relative = !!this._opts.relative;
        var props = this._props;
        for (var name in props) {
          var value = target[name];
          var prop = props[name];
          if ("number" === typeof value) {
            prop.start = value;
            prop.current = value;
            prop.end = relative ? value + prop.value : prop.value;
          } else {
            prop.start = value.clone();
            prop.current = value.clone();
            prop.end = relative ? (value.add || value.mul).call(value, prop.value) : prop.value;
          }
        }
      },
      update: function update(t) {
        var opts = this._opts;
        var easingTime = t;
        opts.easing && (easingTime = opts.easing(t));
        var target = this.target;
        if (!target) return;
        var props = this._props;
        var progress = this._opts.progress;
        for (var name in props) {
          var prop = props[name];
          var time = prop.easing ? prop.easing(t) : easingTime;
          var current = prop.current = (prop.progress || progress)(prop.start, prop.end, prop.current, time);
          target[name] = current;
        }
      },
      progress: function progress(start, end, current, t) {
        "number" === typeof start ? current = start + (end - start) * t : start.lerp(end, t, current);
        return current;
      }
    });
    var SetAction = cc.Class({
      name: "cc.SetAction",
      extends: cc.ActionInstant,
      ctor: function ctor(props) {
        this._props = {};
        void 0 !== props && this.init(props);
      },
      init: function init(props) {
        for (var name in props) this._props[name] = props[name];
        return true;
      },
      update: function update() {
        var props = this._props;
        var target = this.target;
        for (var name in props) target[name] = props[name];
      },
      clone: function clone() {
        var action = new SetAction();
        action.init(this._props);
        return action;
      }
    });
    function Tween(target) {
      this._actions = [];
      this._finalAction = null;
      this._target = target;
    }
    Tween.prototype.then = function(other) {
      other instanceof cc.Action ? this._actions.push(other.clone()) : this._actions.push(other._union());
      return this;
    };
    Tween.prototype.target = function(target) {
      this._target = target;
      return this;
    };
    Tween.prototype.start = function() {
      if (!this._target) {
        cc.warn("Please set target to tween first");
        return this;
      }
      this._finalAction && cc.director.getActionManager().removeAction(this._finalAction);
      this._finalAction = this._union();
      cc.director.getActionManager().addAction(this._finalAction, this._target, false);
      return this;
    };
    Tween.prototype.stop = function() {
      this._finalAction && cc.director.getActionManager().removeAction(this._finalAction);
      return this;
    };
    Tween.prototype.clone = function(target) {
      var action = this._union();
      return cc.tween(target).then(action.clone());
    };
    Tween.prototype.union = function() {
      var action = this._union();
      this._actions.length = 0;
      this._actions.push(action);
      return this;
    };
    Tween.prototype._union = function() {
      var actions = this._actions;
      actions = 1 === actions.length ? actions[0] : cc.sequence(actions);
      return actions;
    };
    var tmp_args = [];
    function wrapAction(action) {
      return function() {
        tmp_args.length = 0;
        for (var l = arguments.length, i = 0; i < l; i++) {
          var arg = tmp_args[i] = arguments[i];
          arg instanceof Tween && (tmp_args[i] = arg._union());
        }
        return action.apply(this, tmp_args);
      };
    }
    var actions = {
      to: function to(duration, props, opts) {
        opts = opts || Object.create(null);
        opts.relative = false;
        return new TweenAction(duration, props, opts);
      },
      by: function by(duration, props, opts) {
        opts = opts || Object.create(null);
        opts.relative = true;
        return new TweenAction(duration, props, opts);
      },
      set: function set(props) {
        return new SetAction(props);
      },
      delay: cc.delayTime,
      call: cc.callFunc,
      hide: cc.hide,
      show: cc.show,
      removeSelf: cc.removeSelf,
      sequence: wrapAction(cc.sequence),
      parallel: wrapAction(cc.spawn)
    };
    var previousAsInputActions = {
      repeat: cc.repeat,
      repeatForever: function repeatForever(action) {
        return cc.repeat(action, 1e9);
      },
      reverseTime: cc.reverseTime
    };
    var keys = Object.keys(actions);
    var _loop = function _loop(i) {
      var key = keys[i];
      Tween.prototype[key] = function() {
        var action = actions[key].apply(actions, arguments);
        this._actions.push(action);
        return this;
      };
    };
    for (var i = 0; i < keys.length; i++) _loop(i);
    keys = Object.keys(previousAsInputActions);
    var _loop2 = function _loop2(i) {
      var key = keys[i];
      Tween.prototype[key] = function() {
        var actions = this._actions;
        var action = arguments[arguments.length - 1];
        var length = arguments.length - 1;
        if (action instanceof cc.Tween) action = action._union(); else if (!(action instanceof cc.Action)) {
          action = actions[actions.length - 1];
          actions.length -= 1;
          length += 1;
        }
        var args = [ action ];
        for (var _i = 0; _i < length; _i++) args.push(arguments[_i]);
        action = previousAsInputActions[key].apply(this, args);
        actions.push(action);
        return this;
      };
    };
    for (var i = 0; i < keys.length; i++) _loop2(i);
    cc.tween = function(target) {
      return new Tween(target);
    };
    cc.Tween = Tween;
  }), {} ],
  10: [ (function(require, module, exports) {
    "use strict";
    var js = cc.js;
    var Playable = require("./playable");
    var _require = require("./animation-curves"), EventAnimCurve = _require.EventAnimCurve, EventInfo = _require.EventInfo;
    var WrapModeMask = require("./types").WrapModeMask;
    var binarySearch = require("../core/utils/binary-search").binarySearchEpsilon;
    function AnimationAnimator(target, animation) {
      Playable.call(this);
      this.target = target;
      this.animation = animation;
      this._anims = new js.array.MutableForwardIterator([]);
    }
    js.extend(AnimationAnimator, Playable);
    var p = AnimationAnimator.prototype;
    p.playState = function(state, startTime) {
      if (!state.clip) return;
      state.curveLoaded || initClipData(this.target, state);
      state.animator = this;
      state.play();
      "number" === typeof startTime && state.setTime(startTime);
      this.play();
    };
    p.stopStatesExcept = function(state) {
      var iterator = this._anims;
      var array = iterator.array;
      for (iterator.i = 0; iterator.i < array.length; ++iterator.i) {
        var anim = array[iterator.i];
        if (anim === state) continue;
        this.stopState(anim);
      }
    };
    p.addAnimation = function(anim) {
      var index = this._anims.array.indexOf(anim);
      -1 === index && this._anims.push(anim);
      anim._setEventTarget(this.animation);
    };
    p.removeAnimation = function(anim) {
      var index = this._anims.array.indexOf(anim);
      if (index >= 0) {
        this._anims.fastRemoveAt(index);
        0 === this._anims.array.length && this.stop();
      } else cc.errorID(3908);
      anim.animator = null;
    };
    p.sample = function() {
      var iterator = this._anims;
      var array = iterator.array;
      for (iterator.i = 0; iterator.i < array.length; ++iterator.i) {
        var anim = array[iterator.i];
        anim.sample();
      }
    };
    p.stopState = function(state) {
      state && state.stop();
    };
    p.pauseState = function(state) {
      state && state.pause();
    };
    p.resumeState = function(state) {
      state && state.resume();
      this.isPaused && this.resume();
    };
    p.setStateTime = function(state, time) {
      if (void 0 !== time) {
        if (state) {
          state.setTime(time);
          state.sample();
        }
      } else {
        time = state;
        var array = this._anims.array;
        for (var i = 0; i < array.length; ++i) {
          var anim = array[i];
          anim.setTime(time);
          anim.sample();
        }
      }
    };
    p.onStop = function() {
      var iterator = this._anims;
      var array = iterator.array;
      for (iterator.i = 0; iterator.i < array.length; ++iterator.i) {
        var anim = array[iterator.i];
        anim.stop();
      }
    };
    p.onPause = function() {
      var array = this._anims.array;
      for (var i = 0; i < array.length; ++i) {
        var anim = array[i];
        anim.pause();
        anim.animator = null;
      }
    };
    p.onResume = function() {
      var array = this._anims.array;
      for (var i = 0; i < array.length; ++i) {
        var anim = array[i];
        anim.animator = this;
        anim.resume();
      }
    };
    p._reloadClip = function(state) {
      initClipData(this.target, state);
    };
    function createBatchedProperty(propPath, firstDotIndex, mainValue, animValue) {
      mainValue = mainValue.clone();
      var nextValue = mainValue;
      var leftIndex = firstDotIndex + 1;
      var rightIndex = propPath.indexOf(".", leftIndex);
      while (-1 !== rightIndex) {
        var nextName = propPath.slice(leftIndex, rightIndex);
        nextValue = nextValue[nextName];
        leftIndex = rightIndex + 1;
        rightIndex = propPath.indexOf(".", leftIndex);
      }
      var lastPropName = propPath.slice(leftIndex);
      nextValue[lastPropName] = animValue;
      return mainValue;
    }
    false;
    function initClipData(root, state) {
      var clip = state.clip;
      state.duration = clip.duration;
      state.speed = clip.speed;
      state.wrapMode = clip.wrapMode;
      state.frameRate = clip.sample;
      (state.wrapMode & WrapModeMask.Loop) === WrapModeMask.Loop ? state.repeatCount = Infinity : state.repeatCount = 1;
      var curves = state.curves = clip.createCurves(state, root);
      var events = clip.events;
      if (true, events) {
        var curve = void 0;
        for (var i = 0, l = events.length; i < l; i++) {
          if (!curve) {
            curve = new EventAnimCurve();
            curve.target = root;
            curves.push(curve);
          }
          var eventData = events[i];
          var ratio = eventData.frame / state.duration;
          var eventInfo = void 0;
          var index = binarySearch(curve.ratios, ratio);
          if (index >= 0) eventInfo = curve.events[index]; else {
            eventInfo = new EventInfo();
            curve.ratios.push(ratio);
            curve.events.push(eventInfo);
          }
          eventInfo.add(eventData.func, eventData.params);
        }
      }
    }
    false;
    module.exports = AnimationAnimator;
  }), {
    "../core/utils/binary-search": 291,
    "./animation-curves": 12,
    "./playable": 19,
    "./types": 20
  } ],
  11: [ (function(require, module, exports) {
    "use strict";
    var WrapMode = require("./types").WrapMode;
    var _require = require("./animation-curves"), DynamicAnimCurve = _require.DynamicAnimCurve, quickFindIndex = _require.quickFindIndex;
    var sampleMotionPaths = require("./motion-path-helper").sampleMotionPaths;
    var binarySearch = require("../core/utils/binary-search").binarySearchEpsilon;
    var AnimationClip = cc.Class({
      name: "cc.AnimationClip",
      extends: cc.Asset,
      properties: {
        _duration: {
          default: 0,
          type: cc.Float
        },
        duration: {
          get: function get() {
            return this._duration;
          }
        },
        sample: {
          default: 60
        },
        speed: {
          default: 1
        },
        wrapMode: {
          default: WrapMode.Normal
        },
        curveData: {
          default: {},
          visible: false
        },
        events: {
          default: [],
          visible: false
        }
      },
      statics: {
        createWithSpriteFrames: function createWithSpriteFrames(spriteFrames, sample) {
          if (!Array.isArray(spriteFrames)) {
            cc.errorID(3905);
            return null;
          }
          var clip = new AnimationClip();
          clip.sample = sample || clip.sample;
          clip._duration = spriteFrames.length / clip.sample;
          var frames = [];
          var step = 1 / clip.sample;
          for (var i = 0, l = spriteFrames.length; i < l; i++) frames[i] = {
            frame: i * step,
            value: spriteFrames[i]
          };
          clip.curveData = {
            comps: {
              "cc.Sprite": {
                spriteFrame: frames
              }
            }
          };
          return clip;
        }
      },
      onLoad: function onLoad() {
        this._duration = Number.parseFloat(this.duration);
        this.speed = Number.parseFloat(this.speed);
        this.wrapMode = Number.parseInt(this.wrapMode);
        this.frameRate = Number.parseFloat(this.sample);
      },
      createPropCurve: function createPropCurve(target, propPath, keyframes) {
        var motionPaths = [];
        var isMotionPathProp = target instanceof cc.Node && "position" === propPath;
        var curve = new DynamicAnimCurve();
        curve.target = target;
        curve.prop = propPath;
        for (var i = 0, l = keyframes.length; i < l; i++) {
          var keyframe = keyframes[i];
          var ratio = keyframe.frame / this.duration;
          curve.ratios.push(ratio);
          isMotionPathProp && motionPaths.push(keyframe.motionPath);
          var curveValue = keyframe.value;
          curve.values.push(curveValue);
          var curveTypes = keyframe.curve;
          if (curveTypes) {
            if ("string" === typeof curveTypes) {
              curve.types.push(curveTypes);
              continue;
            }
            if (Array.isArray(curveTypes)) {
              curveTypes[0] === curveTypes[1] && curveTypes[2] === curveTypes[3] ? curve.types.push(DynamicAnimCurve.Linear) : curve.types.push(DynamicAnimCurve.Bezier(curveTypes));
              continue;
            }
          }
          curve.types.push(DynamicAnimCurve.Linear);
        }
        isMotionPathProp && sampleMotionPaths(motionPaths, curve, this.duration, this.sample, target);
        var ratios = curve.ratios;
        var currRatioDif = void 0, lastRatioDif = void 0;
        var canOptimize = true;
        var EPSILON = 1e-6;
        for (var _i = 1, _l = ratios.length; _i < _l; _i++) {
          currRatioDif = ratios[_i] - ratios[_i - 1];
          if (1 === _i) lastRatioDif = currRatioDif; else if (Math.abs(currRatioDif - lastRatioDif) > EPSILON) {
            canOptimize = false;
            break;
          }
        }
        curve._findFrameIndex = canOptimize ? quickFindIndex : binarySearch;
        var firstValue = curve.values[0];
        void 0 === firstValue || null === firstValue || curve._lerp || ("number" === typeof firstValue ? curve._lerp = DynamicAnimCurve.prototype._lerpNumber : firstValue instanceof cc.Quat ? curve._lerp = DynamicAnimCurve.prototype._lerpQuat : firstValue instanceof cc.Vec2 || firstValue instanceof cc.Vec3 ? curve._lerp = DynamicAnimCurve.prototype._lerpVector : firstValue.lerp && (curve._lerp = DynamicAnimCurve.prototype._lerpObject));
        return curve;
      },
      createTargetCurves: function createTargetCurves(target, curveData, curves) {
        var propsData = curveData.props;
        var compsData = curveData.comps;
        if (propsData) for (var propPath in propsData) {
          var data = propsData[propPath];
          var curve = this.createPropCurve(target, propPath, data);
          curves.push(curve);
        }
        if (compsData) for (var compName in compsData) {
          var comp = target.getComponent(compName);
          if (!comp) continue;
          var compData = compsData[compName];
          for (var _propPath in compData) {
            var _data = compData[_propPath];
            var _curve = this.createPropCurve(comp, _propPath, _data);
            curves.push(_curve);
          }
        }
      },
      createCurves: function createCurves(state, root) {
        var curveData = this.curveData;
        var childrenCurveDatas = curveData.paths;
        var curves = [];
        this.createTargetCurves(root, curveData, curves);
        for (var namePath in childrenCurveDatas) {
          var target = cc.find(namePath, root);
          if (!target) continue;
          var childCurveDatas = childrenCurveDatas[namePath];
          this.createTargetCurves(target, childCurveDatas, curves);
        }
        return curves;
      }
    });
    cc.AnimationClip = module.exports = AnimationClip;
  }), {
    "../core/utils/binary-search": 291,
    "./animation-curves": 12,
    "./motion-path-helper": 18,
    "./types": 20
  } ],
  12: [ (function(require, module, exports) {
    "use strict";
    var bezierByTime = require("./bezier").bezierByTime;
    var binarySearch = require("../core/utils/binary-search").binarySearchEpsilon;
    var WrapModeMask = require("./types").WrapModeMask;
    var WrappedInfo = require("./types").WrappedInfo;
    function computeRatioByType(ratio, type) {
      if ("string" === typeof type) {
        var func = cc.easing[type];
        func ? ratio = func(ratio) : cc.errorID(3906, type);
      } else Array.isArray(type) && (ratio = bezierByTime(type, ratio));
      return ratio;
    }
    var AnimCurve = cc.Class({
      name: "cc.AnimCurve",
      sample: function sample(time, ratio, state) {},
      onTimeChangedManually: void 0
    });
    function quickFindIndex(ratios, ratio) {
      var length = ratios.length - 1;
      if (0 === length) return 0;
      var start = ratios[0];
      if (ratio < start) return 0;
      var end = ratios[length];
      if (ratio > end) return ~ratios.length;
      ratio = (ratio - start) / (end - start);
      var eachLength = 1 / length;
      var index = ratio / eachLength;
      var floorIndex = 0 | index;
      var EPSILON = 1e-6;
      if (index - floorIndex < EPSILON) return floorIndex;
      if (floorIndex + 1 - index < EPSILON) return floorIndex + 1;
      return ~(floorIndex + 1);
    }
    var DynamicAnimCurve = cc.Class({
      name: "cc.DynamicAnimCurve",
      extends: AnimCurve,
      ctor: function ctor() {
        this._cachedIndex = 0;
      },
      properties: {
        target: null,
        prop: "",
        values: [],
        ratios: [],
        types: []
      },
      _findFrameIndex: binarySearch,
      _lerp: void 0,
      _lerpNumber: function _lerpNumber(from, to, t) {
        return from + (to - from) * t;
      },
      _lerpObject: function _lerpObject(from, to, t) {
        return from.lerp(to, t);
      },
      _lerpQuat: (function() {
        var out = cc.quat();
        return function(from, to, t) {
          return from.lerp(to, t, out);
        };
      })(),
      _lerpVector: (function() {
        var out = cc.v3();
        return function(from, to, t) {
          return from.lerp(to, t, out);
        };
      })(),
      sample: function sample(time, ratio, state) {
        var values = this.values;
        var ratios = this.ratios;
        var frameCount = ratios.length;
        if (0 === frameCount) return;
        var shoudRefind = true;
        var cachedIndex = this._cachedIndex;
        if (cachedIndex < 0) {
          cachedIndex = ~cachedIndex;
          if (cachedIndex > 0 && cachedIndex < ratios.length) {
            var _fromRatio = ratios[cachedIndex - 1];
            var _toRatio = ratios[cachedIndex];
            ratio > _fromRatio && ratio < _toRatio && (shoudRefind = false);
          }
        }
        shoudRefind && (this._cachedIndex = this._findFrameIndex(ratios, ratio));
        var value = void 0;
        var index = this._cachedIndex;
        if (index < 0) {
          index = ~index;
          if (index <= 0) value = values[0]; else if (index >= frameCount) value = values[frameCount - 1]; else {
            var fromVal = values[index - 1];
            if (this._lerp) {
              var fromRatio = ratios[index - 1];
              var toRatio = ratios[index];
              var type = this.types[index - 1];
              var ratioBetweenFrames = (ratio - fromRatio) / (toRatio - fromRatio);
              type && (ratioBetweenFrames = computeRatioByType(ratioBetweenFrames, type));
              var toVal = values[index];
              value = this._lerp(fromVal, toVal, ratioBetweenFrames);
            } else value = fromVal;
          }
        } else value = values[index];
        this.target[this.prop] = value;
      }
    });
    DynamicAnimCurve.Linear = null;
    DynamicAnimCurve.Bezier = function(controlPoints) {
      return controlPoints;
    };
    var EventInfo = function EventInfo() {
      this.events = [];
    };
    EventInfo.prototype.add = function(func, params) {
      this.events.push({
        func: func || "",
        params: params || []
      });
    };
    var EventAnimCurve = cc.Class({
      name: "cc.EventAnimCurve",
      extends: AnimCurve,
      properties: {
        target: null,
        ratios: [],
        events: [],
        _wrappedInfo: {
          default: function _default() {
            return new WrappedInfo();
          }
        },
        _lastWrappedInfo: null,
        _ignoreIndex: NaN
      },
      _wrapIterations: function _wrapIterations(iterations) {
        iterations - (0 | iterations) === 0 && (iterations -= 1);
        return 0 | iterations;
      },
      sample: function sample(time, ratio, state) {
        var length = this.ratios.length;
        var currentWrappedInfo = state.getWrappedInfo(state.time, this._wrappedInfo);
        var direction = currentWrappedInfo.direction;
        var currentIndex = binarySearch(this.ratios, currentWrappedInfo.ratio);
        if (currentIndex < 0) {
          currentIndex = ~currentIndex - 1;
          direction < 0 && (currentIndex += 1);
        }
        this._ignoreIndex !== currentIndex && (this._ignoreIndex = NaN);
        currentWrappedInfo.frameIndex = currentIndex;
        if (!this._lastWrappedInfo) {
          this._fireEvent(currentIndex);
          this._lastWrappedInfo = new WrappedInfo(currentWrappedInfo);
          return;
        }
        var wrapMode = state.wrapMode;
        var currentIterations = this._wrapIterations(currentWrappedInfo.iterations);
        var lastWrappedInfo = this._lastWrappedInfo;
        var lastIterations = this._wrapIterations(lastWrappedInfo.iterations);
        var lastIndex = lastWrappedInfo.frameIndex;
        var lastDirection = lastWrappedInfo.direction;
        var interationsChanged = -1 !== lastIterations && currentIterations !== lastIterations;
        if (lastIndex === currentIndex && interationsChanged && 1 === length) this._fireEvent(0); else if (lastIndex !== currentIndex || interationsChanged) {
          direction = lastDirection;
          do {
            if (lastIndex !== currentIndex) {
              if (-1 === direction && 0 === lastIndex && currentIndex > 0) {
                (wrapMode & WrapModeMask.PingPong) === WrapModeMask.PingPong ? direction *= -1 : lastIndex = length;
                lastIterations++;
              } else if (1 === direction && lastIndex === length - 1 && currentIndex < length - 1) {
                (wrapMode & WrapModeMask.PingPong) === WrapModeMask.PingPong ? direction *= -1 : lastIndex = -1;
                lastIterations++;
              }
              if (lastIndex === currentIndex) break;
              if (lastIterations > currentIterations) break;
            }
            lastIndex += direction;
            cc.director.getAnimationManager().pushDelayEvent(this, "_fireEvent", [ lastIndex ]);
          } while (lastIndex !== currentIndex && lastIndex > -1 && lastIndex < length);
        }
        this._lastWrappedInfo.set(currentWrappedInfo);
      },
      _fireEvent: function _fireEvent(index) {
        if (index < 0 || index >= this.events.length || this._ignoreIndex === index) return;
        var eventInfo = this.events[index];
        var events = eventInfo.events;
        if (!this.target.isValid) return;
        var components = this.target._components;
        for (var i = 0; i < events.length; i++) {
          var event = events[i];
          var funcName = event.func;
          for (var j = 0; j < components.length; j++) {
            var component = components[j];
            var func = component[funcName];
            func && func.apply(component, event.params);
          }
        }
      },
      onTimeChangedManually: function onTimeChangedManually(time, state) {
        this._lastWrappedInfo = null;
        this._ignoreIndex = NaN;
        var info = state.getWrappedInfo(time, this._wrappedInfo);
        var direction = info.direction;
        var frameIndex = binarySearch(this.ratios, info.ratio);
        if (frameIndex < 0) {
          frameIndex = ~frameIndex - 1;
          direction < 0 && (frameIndex += 1);
          this._ignoreIndex = frameIndex;
        }
      }
    });
    false;
    module.exports = {
      AnimCurve: AnimCurve,
      DynamicAnimCurve: DynamicAnimCurve,
      EventAnimCurve: EventAnimCurve,
      EventInfo: EventInfo,
      computeRatioByType: computeRatioByType,
      quickFindIndex: quickFindIndex
    };
  }), {
    "../core/utils/binary-search": 291,
    "./bezier": 15,
    "./types": 20
  } ],
  13: [ (function(require, module, exports) {
    "use strict";
    var js = cc.js;
    var AnimationManager = cc.Class({
      ctor: function ctor() {
        this._anims = new js.array.MutableForwardIterator([]);
        this._delayEvents = [];
        cc.director._scheduler && cc.director._scheduler.enableForTarget(this);
      },
      update: function update(dt) {
        var iterator = this._anims;
        var array = iterator.array;
        for (iterator.i = 0; iterator.i < array.length; ++iterator.i) {
          var anim = array[iterator.i];
          anim._isPlaying && !anim._isPaused && anim.update(dt);
        }
        var events = this._delayEvents;
        for (var i = 0; i < events.length; i++) {
          var event = events[i];
          event.target[event.func].apply(event.target, event.args);
        }
        events.length = 0;
      },
      destruct: function destruct() {},
      addAnimation: function addAnimation(anim) {
        var index = this._anims.array.indexOf(anim);
        -1 === index && this._anims.push(anim);
      },
      removeAnimation: function removeAnimation(anim) {
        var index = this._anims.array.indexOf(anim);
        index >= 0 ? this._anims.fastRemoveAt(index) : cc.errorID(3907);
      },
      pushDelayEvent: function pushDelayEvent(target, func, args) {
        this._delayEvents.push({
          target: target,
          func: func,
          args: args
        });
      }
    });
    cc.AnimationManager = module.exports = AnimationManager;
  }), {} ],
  14: [ (function(require, module, exports) {
    "use strict";
    var js = cc.js;
    var Playable = require("./playable");
    var Types = require("./types");
    var WrappedInfo = Types.WrappedInfo;
    var WrapMode = Types.WrapMode;
    var WrapModeMask = Types.WrapModeMask;
    function AnimationState(clip, name) {
      Playable.call(this);
      this._currentFramePlayed = false;
      this._delay = 0;
      this._delayTime = 0;
      this._wrappedInfo = new WrappedInfo();
      this._lastWrappedInfo = null;
      this._process = process;
      this._clip = clip;
      this._name = name || clip && clip.name;
      this.animator = null;
      this.curves = [];
      this.delay = 0;
      this.repeatCount = 1;
      this.duration = 1;
      this.speed = 1;
      this.wrapMode = WrapMode.Normal;
      this.time = 0;
      this._target = null;
      this._lastframeEventOn = false;
      this.emit = function() {
        var args = new Array(arguments.length);
        for (var i = 0, l = args.length; i < l; i++) args[i] = arguments[i];
        cc.director.getAnimationManager().pushDelayEvent(this, "_emit", args);
      };
    }
    js.extend(AnimationState, Playable);
    var proto = AnimationState.prototype;
    proto._emit = function(type, state) {
      this._target && this._target.isValid && this._target.emit(type, type, state);
    };
    proto.on = function(type, callback, target) {
      if (this._target && this._target.isValid) {
        "lastframe" === type && (this._lastframeEventOn = true);
        return this._target.on(type, callback, target);
      }
      return null;
    };
    proto.once = function(type, callback, target) {
      if (this._target && this._target.isValid) {
        "lastframe" === type && (this._lastframeEventOn = true);
        var self = this;
        return this._target.once(type, (function(event) {
          callback.call(target, event);
          self._lastframeEventOn = false;
        }));
      }
      return null;
    };
    proto.off = function(type, callback, target) {
      if (this._target && this._target.isValid) {
        "lastframe" === type && (this._target.hasEventListener(type) || (this._lastframeEventOn = false));
        this._target.off(type, callback, target);
      }
    };
    proto._setEventTarget = function(target) {
      this._target = target;
    };
    proto.onPlay = function() {
      this.setTime(0);
      this._delayTime = this._delay;
      cc.director.getAnimationManager().addAnimation(this);
      this.animator && this.animator.addAnimation(this);
      this.emit("play", this);
    };
    proto.onStop = function() {
      this.isPaused || cc.director.getAnimationManager().removeAnimation(this);
      this.animator && this.animator.removeAnimation(this);
      this.emit("stop", this);
    };
    proto.onResume = function() {
      cc.director.getAnimationManager().addAnimation(this);
      this.emit("resume", this);
    };
    proto.onPause = function() {
      cc.director.getAnimationManager().removeAnimation(this);
      this.emit("pause", this);
    };
    proto.setTime = function(time) {
      this._currentFramePlayed = false;
      this.time = time || 0;
      var curves = this.curves;
      for (var i = 0, l = curves.length; i < l; i++) {
        var curve = curves[i];
        curve.onTimeChangedManually && curve.onTimeChangedManually(time, this);
      }
    };
    function process() {
      var info = this.sample();
      if (this._lastframeEventOn) {
        var lastInfo;
        lastInfo = this._lastWrappedInfo ? this._lastWrappedInfo : this._lastWrappedInfo = new WrappedInfo(info);
        this.repeatCount > 1 && (0 | info.iterations) > (0 | lastInfo.iterations) && this.emit("lastframe", this);
        lastInfo.set(info);
      }
      if (info.stopped) {
        this.stop();
        this.emit("finished", this);
      }
    }
    function simpleProcess() {
      var time = this.time;
      var duration = this.duration;
      if (time > duration) {
        time %= duration;
        0 === time && (time = duration);
      } else if (time < 0) {
        time %= duration;
        0 !== time && (time += duration);
      }
      var ratio = time / duration;
      var curves = this.curves;
      for (var i = 0, len = curves.length; i < len; i++) {
        var curve = curves[i];
        curve.sample(time, ratio, this);
      }
      if (this._lastframeEventOn) {
        void 0 === this._lastIterations && (this._lastIterations = ratio);
        (this.time > 0 && this._lastIterations > ratio || this.time < 0 && this._lastIterations < ratio) && this.emit("lastframe", this);
        this._lastIterations = ratio;
      }
    }
    proto.update = function(delta) {
      if (this._delayTime > 0) {
        this._delayTime -= delta;
        if (this._delayTime > 0) return;
      }
      this._currentFramePlayed ? this.time += delta * this.speed : this._currentFramePlayed = true;
      this._process();
    };
    proto._needRevers = function(currentIterations) {
      var wrapMode = this.wrapMode;
      var needRevers = false;
      if ((wrapMode & WrapModeMask.PingPong) === WrapModeMask.PingPong) {
        var isEnd = currentIterations - (0 | currentIterations) === 0;
        isEnd && currentIterations > 0 && (currentIterations -= 1);
        var isOddIteration = 1 & currentIterations;
        isOddIteration && (needRevers = !needRevers);
      }
      (wrapMode & WrapModeMask.Reverse) === WrapModeMask.Reverse && (needRevers = !needRevers);
      return needRevers;
    };
    proto.getWrappedInfo = function(time, info) {
      info = info || new WrappedInfo();
      var stopped = false;
      var duration = this.duration;
      var repeatCount = this.repeatCount;
      var currentIterations = time > 0 ? time / duration : -time / duration;
      if (currentIterations >= repeatCount) {
        currentIterations = repeatCount;
        stopped = true;
        var tempRatio = repeatCount - (0 | repeatCount);
        0 === tempRatio && (tempRatio = 1);
        time = tempRatio * duration * (time > 0 ? 1 : -1);
      }
      if (time > duration) {
        var tempTime = time % duration;
        time = 0 === tempTime ? duration : tempTime;
      } else if (time < 0) {
        time %= duration;
        0 !== time && (time += duration);
      }
      var needRevers = false;
      var shouldWrap = this._wrapMode & WrapModeMask.ShouldWrap;
      shouldWrap && (needRevers = this._needRevers(currentIterations));
      var direction = needRevers ? -1 : 1;
      this.speed < 0 && (direction *= -1);
      shouldWrap && needRevers && (time = duration - time);
      info.ratio = time / duration;
      info.time = time;
      info.direction = direction;
      info.stopped = stopped;
      info.iterations = currentIterations;
      return info;
    };
    proto.sample = function() {
      var info = this.getWrappedInfo(this.time, this._wrappedInfo);
      var curves = this.curves;
      for (var i = 0, len = curves.length; i < len; i++) {
        var curve = curves[i];
        curve.sample(info.time, info.ratio, this);
      }
      return info;
    };
    js.get(proto, "clip", (function() {
      return this._clip;
    }));
    js.get(proto, "name", (function() {
      return this._name;
    }));
    js.obsolete(proto, "AnimationState.length", "duration");
    js.getset(proto, "curveLoaded", (function() {
      return this.curves.length > 0;
    }), (function() {
      this.curves.length = 0;
    }));
    js.getset(proto, "wrapMode", (function() {
      return this._wrapMode;
    }), (function(value) {
      this._wrapMode = value;
      false;
      this.time = 0;
      value & WrapModeMask.Loop ? this.repeatCount = Infinity : this.repeatCount = 1;
    }));
    js.getset(proto, "repeatCount", (function() {
      return this._repeatCount;
    }), (function(value) {
      this._repeatCount = value;
      var shouldWrap = this._wrapMode & WrapModeMask.ShouldWrap;
      var reverse = (this.wrapMode & WrapModeMask.Reverse) === WrapModeMask.Reverse;
      this._process = Infinity !== value || shouldWrap || reverse ? process : simpleProcess;
    }));
    js.getset(proto, "delay", (function() {
      return this._delay;
    }), (function(value) {
      this._delayTime = this._delay = value;
    }));
    cc.AnimationState = module.exports = AnimationState;
  }), {
    "./playable": 19,
    "./types": 20
  } ],
  15: [ (function(require, module, exports) {
    "use strict";
    function bezier(C1, C2, C3, C4, t) {
      var t1 = 1 - t;
      return t1 * (t1 * (C1 + (3 * C2 - C1) * t) + 3 * C3 * t * t) + C4 * t * t * t;
    }
    var cos = Math.cos, acos = Math.acos, max = Math.max, pi = Math.PI, tau = 2 * pi, sqrt = Math.sqrt;
    function crt(v) {
      return v < 0 ? -Math.pow(-v, 1 / 3) : Math.pow(v, 1 / 3);
    }
    function cardano(curve, x) {
      var pa = x - 0;
      var pb = x - curve[0];
      var pc = x - curve[2];
      var pd = x - 1;
      var pa3 = 3 * pa;
      var pb3 = 3 * pb;
      var pc3 = 3 * pc;
      var d = -pa + pb3 - pc3 + pd, rd = 1 / d, r3 = 1 / 3, a = (pa3 - 6 * pb + pc3) * rd, a3 = a * r3, b = (-pa3 + pb3) * rd, c = pa * rd, p = (3 * b - a * a) * r3, p3 = p * r3, q = (2 * a * a * a - 9 * a * b + 27 * c) / 27, q2 = q / 2, discriminant = q2 * q2 + p3 * p3 * p3, u1, v1, x1, x2, x3;
      if (discriminant < 0) {
        var mp3 = -p * r3, mp33 = mp3 * mp3 * mp3, r = sqrt(mp33), t = -q / (2 * r), cosphi = t < -1 ? -1 : t > 1 ? 1 : t, phi = acos(cosphi), crtr = crt(r), t1 = 2 * crtr;
        x1 = t1 * cos(phi * r3) - a3;
        x2 = t1 * cos((phi + tau) * r3) - a3;
        x3 = t1 * cos((phi + 2 * tau) * r3) - a3;
        return 0 <= x1 && x1 <= 1 ? 0 <= x2 && x2 <= 1 ? 0 <= x3 && x3 <= 1 ? max(x1, x2, x3) : max(x1, x2) : 0 <= x3 && x3 <= 1 ? max(x1, x3) : x1 : 0 <= x2 && x2 <= 1 ? 0 <= x3 && x3 <= 1 ? max(x2, x3) : x2 : x3;
      }
      if (0 === discriminant) {
        u1 = q2 < 0 ? crt(-q2) : -crt(q2);
        x1 = 2 * u1 - a3;
        x2 = -u1 - a3;
        return 0 <= x1 && x1 <= 1 ? 0 <= x2 && x2 <= 1 ? max(x1, x2) : x1 : x2;
      }
      var sd = sqrt(discriminant);
      u1 = crt(-q2 + sd);
      v1 = crt(q2 + sd);
      x1 = u1 - v1 - a3;
      return x1;
    }
    function bezierByTime(controlPoints, x) {
      var percent = cardano(controlPoints, x);
      var p1y = controlPoints[1];
      var p2y = controlPoints[3];
      return ((1 - percent) * (p1y + (p2y - p1y) * percent) * 3 + percent * percent) * percent;
    }
    false;
    module.exports = {
      bezier: bezier,
      bezierByTime: bezierByTime
    };
  }), {} ],
  16: [ (function(require, module, exports) {
    "use strict";
    var easing = {
      constant: function constant() {
        return 0;
      },
      linear: function linear(k) {
        return k;
      },
      quadIn: function quadIn(k) {
        return k * k;
      },
      quadOut: function quadOut(k) {
        return k * (2 - k);
      },
      quadInOut: function quadInOut(k) {
        if ((k *= 2) < 1) return .5 * k * k;
        return -.5 * (--k * (k - 2) - 1);
      },
      cubicIn: function cubicIn(k) {
        return k * k * k;
      },
      cubicOut: function cubicOut(k) {
        return --k * k * k + 1;
      },
      cubicInOut: function cubicInOut(k) {
        if ((k *= 2) < 1) return .5 * k * k * k;
        return .5 * ((k -= 2) * k * k + 2);
      },
      quartIn: function quartIn(k) {
        return k * k * k * k;
      },
      quartOut: function quartOut(k) {
        return 1 - --k * k * k * k;
      },
      quartInOut: function quartInOut(k) {
        if ((k *= 2) < 1) return .5 * k * k * k * k;
        return -.5 * ((k -= 2) * k * k * k - 2);
      },
      quintIn: function quintIn(k) {
        return k * k * k * k * k;
      },
      quintOut: function quintOut(k) {
        return --k * k * k * k * k + 1;
      },
      quintInOut: function quintInOut(k) {
        if ((k *= 2) < 1) return .5 * k * k * k * k * k;
        return .5 * ((k -= 2) * k * k * k * k + 2);
      },
      sineIn: function sineIn(k) {
        return 1 - Math.cos(k * Math.PI / 2);
      },
      sineOut: function sineOut(k) {
        return Math.sin(k * Math.PI / 2);
      },
      sineInOut: function sineInOut(k) {
        return .5 * (1 - Math.cos(Math.PI * k));
      },
      expoIn: function expoIn(k) {
        return 0 === k ? 0 : Math.pow(1024, k - 1);
      },
      expoOut: function expoOut(k) {
        return 1 === k ? 1 : 1 - Math.pow(2, -10 * k);
      },
      expoInOut: function expoInOut(k) {
        if (0 === k) return 0;
        if (1 === k) return 1;
        if ((k *= 2) < 1) return .5 * Math.pow(1024, k - 1);
        return .5 * (2 - Math.pow(2, -10 * (k - 1)));
      },
      circIn: function circIn(k) {
        return 1 - Math.sqrt(1 - k * k);
      },
      circOut: function circOut(k) {
        return Math.sqrt(1 - --k * k);
      },
      circInOut: function circInOut(k) {
        if ((k *= 2) < 1) return -.5 * (Math.sqrt(1 - k * k) - 1);
        return .5 * (Math.sqrt(1 - (k -= 2) * k) + 1);
      },
      elasticIn: function elasticIn(k) {
        var s, a = .1, p = .4;
        if (0 === k) return 0;
        if (1 === k) return 1;
        if (!a || a < 1) {
          a = 1;
          s = p / 4;
        } else s = p * Math.asin(1 / a) / (2 * Math.PI);
        return -a * Math.pow(2, 10 * (k -= 1)) * Math.sin((k - s) * (2 * Math.PI) / p);
      },
      elasticOut: function elasticOut(k) {
        var s, a = .1, p = .4;
        if (0 === k) return 0;
        if (1 === k) return 1;
        if (!a || a < 1) {
          a = 1;
          s = p / 4;
        } else s = p * Math.asin(1 / a) / (2 * Math.PI);
        return a * Math.pow(2, -10 * k) * Math.sin((k - s) * (2 * Math.PI) / p) + 1;
      },
      elasticInOut: function elasticInOut(k) {
        var s, a = .1, p = .4;
        if (0 === k) return 0;
        if (1 === k) return 1;
        if (!a || a < 1) {
          a = 1;
          s = p / 4;
        } else s = p * Math.asin(1 / a) / (2 * Math.PI);
        if ((k *= 2) < 1) return a * Math.pow(2, 10 * (k -= 1)) * Math.sin((k - s) * (2 * Math.PI) / p) * -.5;
        return a * Math.pow(2, -10 * (k -= 1)) * Math.sin((k - s) * (2 * Math.PI) / p) * .5 + 1;
      },
      backIn: function backIn(k) {
        var s = 1.70158;
        return k * k * ((s + 1) * k - s);
      },
      backOut: function backOut(k) {
        var s = 1.70158;
        return --k * k * ((s + 1) * k + s) + 1;
      },
      backInOut: function backInOut(k) {
        var s = 2.5949095;
        if ((k *= 2) < 1) return k * k * ((s + 1) * k - s) * .5;
        return .5 * ((k -= 2) * k * ((s + 1) * k + s) + 2);
      },
      bounceIn: function bounceIn(k) {
        return 1 - easing.bounceOut(1 - k);
      },
      bounceOut: function bounceOut(k) {
        return k < 1 / 2.75 ? 7.5625 * k * k : k < 2 / 2.75 ? 7.5625 * (k -= 1.5 / 2.75) * k + .75 : k < 2.5 / 2.75 ? 7.5625 * (k -= 2.25 / 2.75) * k + .9375 : 7.5625 * (k -= 2.625 / 2.75) * k + .984375;
      },
      bounceInOut: function bounceInOut(k) {
        if (k < .5) return .5 * easing.bounceIn(2 * k);
        return .5 * easing.bounceOut(2 * k - 1) + .5;
      },
      smooth: function smooth(t) {
        if (t <= 0) return 0;
        if (t >= 1) return 1;
        return t * t * (3 - 2 * t);
      },
      fade: function fade(t) {
        if (t <= 0) return 0;
        if (t >= 1) return 1;
        return t * t * t * (t * (6 * t - 15) + 10);
      }
    };
    function _makeOutIn(fnIn, fnOut) {
      return function(k) {
        if (k < .5) return fnOut(2 * k) / 2;
        return fnIn(2 * k - 1) / 2 + .5;
      };
    }
    easing.quadOutIn = _makeOutIn(easing.quadIn, easing.quadOut);
    easing.cubicOutIn = _makeOutIn(easing.cubicIn, easing.cubicOut);
    easing.quartOutIn = _makeOutIn(easing.quartIn, easing.quartOut);
    easing.quintOutIn = _makeOutIn(easing.quintIn, easing.quintOut);
    easing.sineOutIn = _makeOutIn(easing.sineIn, easing.sineOut);
    easing.expoOutIn = _makeOutIn(easing.expoIn, easing.expoOut);
    easing.circOutIn = _makeOutIn(easing.circIn, easing.circOut);
    easing.backOutIn = _makeOutIn(easing.backIn, easing.backOut);
    easing.bounceIn = function(k) {
      return 1 - easing.bounceOut(1 - k);
    };
    easing.bounceInOut = function(k) {
      if (k < .5) return .5 * easing.bounceIn(2 * k);
      return .5 * easing.bounceOut(2 * k - 1) + .5;
    };
    easing.bounceOutIn = _makeOutIn(easing.bounceIn, easing.bounceOut);
    cc.easing = module.exports = easing;
  }), {} ],
  17: [ (function(require, module, exports) {
    "use strict";
    require("./bezier");
    require("./easing");
    require("./types");
    require("./motion-path-helper");
    require("./animation-curves");
    require("./animation-clip");
    require("./animation-manager");
    require("./animation-state");
    require("./animation-animator");
  }), {
    "./animation-animator": 10,
    "./animation-clip": 11,
    "./animation-curves": 12,
    "./animation-manager": 13,
    "./animation-state": 14,
    "./bezier": 15,
    "./easing": 16,
    "./motion-path-helper": 18,
    "./types": 20
  } ],
  18: [ (function(require, module, exports) {
    "use strict";
    var DynamicAnimCurve = require("./animation-curves").DynamicAnimCurve;
    var computeRatioByType = require("./animation-curves").computeRatioByType;
    var bezier = require("./bezier").bezier;
    var binarySearch = require("../core/utils/binary-search").binarySearchEpsilon;
    var v2 = cc.v2;
    function Curve(points) {
      this.points = points || [];
      this.beziers = [];
      this.ratios = [];
      this.progresses = [];
      this.length = 0;
      this.computeBeziers();
    }
    Curve.prototype.computeBeziers = function() {
      this.beziers.length = 0;
      this.ratios.length = 0;
      this.progresses.length = 0;
      this.length = 0;
      var bezier;
      for (var i = 1; i < this.points.length; i++) {
        var startPoint = this.points[i - 1];
        var endPoint = this.points[i];
        bezier = new Bezier();
        bezier.start = startPoint.pos;
        bezier.startCtrlPoint = startPoint.out;
        bezier.end = endPoint.pos;
        bezier.endCtrlPoint = endPoint.in;
        this.beziers.push(bezier);
        this.length += bezier.getLength();
      }
      var current = 0;
      for (var i = 0; i < this.beziers.length; i++) {
        bezier = this.beziers[i];
        this.ratios[i] = bezier.getLength() / this.length;
        this.progresses[i] = current += this.ratios[i];
      }
      return this.beziers;
    };
    function Bezier() {
      this.start = v2();
      this.end = v2();
      this.startCtrlPoint = v2();
      this.endCtrlPoint = v2();
    }
    Bezier.prototype.getPointAt = function(u) {
      var t = this.getUtoTmapping(u);
      return this.getPoint(t);
    };
    Bezier.prototype.getPoint = function(t) {
      var x = bezier(this.start.x, this.startCtrlPoint.x, this.endCtrlPoint.x, this.end.x, t);
      var y = bezier(this.start.y, this.startCtrlPoint.y, this.endCtrlPoint.y, this.end.y, t);
      return new v2(x, y);
    };
    Bezier.prototype.getLength = function() {
      var lengths = this.getLengths();
      return lengths[lengths.length - 1];
    };
    Bezier.prototype.getLengths = function(divisions) {
      divisions || (divisions = this.__arcLengthDivisions ? this.__arcLengthDivisions : 200);
      if (this.cacheArcLengths && this.cacheArcLengths.length === divisions + 1) return this.cacheArcLengths;
      var cache = [];
      var current, last = this.getPoint(0), vector = v2();
      var p, sum = 0;
      cache.push(0);
      for (p = 1; p <= divisions; p++) {
        current = this.getPoint(p / divisions);
        vector.x = last.x - current.x;
        vector.y = last.y - current.y;
        sum += vector.mag();
        cache.push(sum);
        last = current;
      }
      this.cacheArcLengths = cache;
      return cache;
    };
    Bezier.prototype.getUtoTmapping = function(u, distance) {
      var arcLengths = this.getLengths();
      var i = 0, il = arcLengths.length;
      var targetArcLength;
      targetArcLength = distance || u * arcLengths[il - 1];
      var low = 0, high = il - 1, comparison;
      while (low <= high) {
        i = Math.floor(low + (high - low) / 2);
        comparison = arcLengths[i] - targetArcLength;
        if (comparison < 0) {
          low = i + 1;
          continue;
        }
        if (comparison > 0) {
          high = i - 1;
          continue;
        }
        high = i;
        break;
      }
      i = high;
      if (arcLengths[i] === targetArcLength) {
        var t = i / (il - 1);
        return t;
      }
      var lengthBefore = arcLengths[i];
      var lengthAfter = arcLengths[i + 1];
      var segmentLength = lengthAfter - lengthBefore;
      var segmentFraction = (targetArcLength - lengthBefore) / segmentLength;
      var t = (i + segmentFraction) / (il - 1);
      return t;
    };
    function checkMotionPath(motionPath) {
      if (!Array.isArray(motionPath)) return false;
      for (var i = 0, l = motionPath.length; i < l; i++) {
        var controls = motionPath[i];
        if (!Array.isArray(controls) || 6 !== controls.length) return false;
      }
      return true;
    }
    function sampleMotionPaths(motionPaths, data, duration, fps, target) {
      function createControlPoints(array) {
        if (array instanceof cc.Vec2) return {
          in: array,
          pos: array,
          out: array
        };
        if (Array.isArray(array) && 6 === array.length) return {
          in: v2(array[2], array[3]),
          pos: v2(array[0], array[1]),
          out: v2(array[4], array[5])
        };
        return {
          in: cc.Vec2.ZERO,
          pos: cc.Vec2.ZERO,
          out: cc.Vec2.ZERO
        };
      }
      var values = data.values = data.values.map((function(value) {
        Array.isArray(value) && (value = 2 === value.length ? cc.v2(value[0], value[1]) : cc.v3(value[0], value[1], value[2]));
        return value;
      }));
      if (0 === motionPaths.length || 0 === values.length) return;
      var motionPathValid = false;
      for (var _i = 0; _i < motionPaths.length; _i++) {
        var _motionPath = motionPaths[_i];
        if (_motionPath && !checkMotionPath(_motionPath)) {
          cc.errorID(3904, target ? target.name : "", "position", _i);
          _motionPath = null;
        }
        if (_motionPath && _motionPath.length > 0) {
          motionPathValid = true;
          break;
        }
      }
      if (!motionPathValid) return;
      if (1 === values.length) return;
      var types = data.types;
      var ratios = data.ratios;
      var newValues = data.values = [];
      var newTypes = data.types = [];
      var newRatios = data.ratios = [];
      function addNewDatas(value, type, ratio) {
        newValues.push(value);
        newTypes.push(type);
        newRatios.push(ratio);
      }
      var startRatioOffset = 0;
      var EPSILON = 1e-6;
      var newType = DynamicAnimCurve.Linear;
      for (var i = 0, l = motionPaths.length; i < l - 1; i++) {
        var motionPath = motionPaths[i];
        var ratio = ratios[i];
        var nextRatio = ratios[i + 1];
        var betweenRatio = nextRatio - ratio;
        var value = values[i];
        var nextValue = values[i + 1];
        var type = types[i];
        var results = [];
        var progress = startRatioOffset / betweenRatio;
        var speed = 1 / (betweenRatio * duration * fps);
        var finalProgress;
        if (motionPath && motionPath.length > 0) {
          var points = [];
          points.push(createControlPoints(value));
          for (var j = 0, l2 = motionPath.length; j < l2; j++) {
            var controlPoints = createControlPoints(motionPath[j]);
            points.push(controlPoints);
          }
          points.push(createControlPoints(nextValue));
          var curve = new Curve(points);
          curve.computeBeziers();
          var progresses = curve.progresses;
          while (1 - progress > EPSILON) {
            finalProgress = progress;
            finalProgress = computeRatioByType(finalProgress, type);
            var pos, bezier, normal, length;
            if (finalProgress < 0) {
              bezier = curve.beziers[0];
              length = (0 - finalProgress) * bezier.getLength();
              normal = bezier.start.sub(bezier.endCtrlPoint).normalize();
              pos = bezier.start.add(normal.mul(length));
            } else if (finalProgress > 1) {
              bezier = curve.beziers[curve.beziers.length - 1];
              length = (finalProgress - 1) * bezier.getLength();
              normal = bezier.end.sub(bezier.startCtrlPoint).normalize();
              pos = bezier.end.add(normal.mul(length));
            } else {
              var bezierIndex = binarySearch(progresses, finalProgress);
              bezierIndex < 0 && (bezierIndex = ~bezierIndex);
              finalProgress -= bezierIndex > 0 ? progresses[bezierIndex - 1] : 0;
              finalProgress /= curve.ratios[bezierIndex];
              pos = curve.beziers[bezierIndex].getPointAt(finalProgress);
            }
            results.push(pos);
            progress += speed;
          }
        } else while (1 - progress > EPSILON) {
          finalProgress = progress;
          finalProgress = computeRatioByType(finalProgress, type);
          results.push(value.lerp(nextValue, finalProgress));
          progress += speed;
        }
        newType = "constant" === type ? type : DynamicAnimCurve.Linear;
        for (var j = 0, l2 = results.length; j < l2; j++) {
          var newRatio = ratio + startRatioOffset + speed * j * betweenRatio;
          addNewDatas(results[j], newType, newRatio);
        }
        startRatioOffset = Math.abs(progress - 1) > EPSILON ? (progress - 1) * betweenRatio : 0;
      }
      ratios[ratios.length - 1] !== newRatios[newRatios.length - 1] && addNewDatas(values[values.length - 1], newType, ratios[ratios.length - 1]);
    }
    false;
    module.exports = {
      sampleMotionPaths: sampleMotionPaths,
      Curve: Curve,
      Bezier: Bezier
    };
  }), {
    "../core/utils/binary-search": 291,
    "./animation-curves": 12,
    "./bezier": 15
  } ],
  19: [ (function(require, module, exports) {
    "use strict";
    var js = cc.js;
    var debug = require("../core/CCDebug");
    function Playable() {
      this._isPlaying = false;
      this._isPaused = false;
      this._stepOnce = false;
    }
    var prototype = Playable.prototype;
    js.get(prototype, "isPlaying", (function() {
      return this._isPlaying;
    }), true);
    js.get(prototype, "isPaused", (function() {
      return this._isPaused;
    }), true);
    var virtual = function virtual() {};
    prototype.onPlay = virtual;
    prototype.onPause = virtual;
    prototype.onResume = virtual;
    prototype.onStop = virtual;
    prototype.onError = virtual;
    prototype.play = function() {
      if (this._isPlaying) if (this._isPaused) {
        this._isPaused = false;
        this.onResume();
      } else this.onError(debug.getError(3912)); else {
        this._isPlaying = true;
        this.onPlay();
      }
    };
    prototype.stop = function() {
      if (this._isPlaying) {
        this._isPlaying = false;
        this.onStop();
        this._isPaused = false;
      }
    };
    prototype.pause = function() {
      if (this._isPlaying && !this._isPaused) {
        this._isPaused = true;
        this.onPause();
      }
    };
    prototype.resume = function() {
      if (this._isPlaying && this._isPaused) {
        this._isPaused = false;
        this.onResume();
      }
    };
    prototype.step = function() {
      this.pause();
      this._stepOnce = true;
      this._isPlaying || this.play();
    };
    module.exports = Playable;
  }), {
    "../core/CCDebug": 50
  } ],
  20: [ (function(require, module, exports) {
    "use strict";
    var WrapModeMask = {
      Loop: 2,
      ShouldWrap: 4,
      PingPong: 22,
      Reverse: 36
    };
    var WrapMode = cc.Enum({
      Default: 0,
      Normal: 1,
      Reverse: WrapModeMask.Reverse,
      Loop: WrapModeMask.Loop,
      LoopReverse: WrapModeMask.Loop | WrapModeMask.Reverse,
      PingPong: WrapModeMask.PingPong,
      PingPongReverse: WrapModeMask.PingPong | WrapModeMask.Reverse
    });
    cc.WrapMode = WrapMode;
    function WrappedInfo(info) {
      if (info) {
        this.set(info);
        return;
      }
      this.ratio = 0;
      this.time = 0;
      this.direction = 1;
      this.stopped = true;
      this.iterations = 0;
      this.frameIndex = void 0;
    }
    WrappedInfo.prototype.set = function(info) {
      this.ratio = info.ratio;
      this.time = info.time;
      this.direction = info.direction;
      this.stopped = info.stopped;
      this.iterations = info.iterations;
      this.frameIndex = info.frameIndex;
    };
    module.exports = {
      WrapModeMask: WrapModeMask,
      WrapMode: WrapMode,
      WrappedInfo: WrappedInfo
    };
  }), {} ],
  21: [ (function(require, module, exports) {
    "use strict";
    var EventTarget = require("../core/event/event-target");
    var sys = require("../core/platform/CCSys");
    var LoadMode = require("../core/assets/CCAudioClip").LoadMode;
    var touchBinded = false;
    var touchPlayList = [];
    var Audio = function Audio(src) {
      EventTarget.call(this);
      this._src = src;
      this._element = null;
      this.id = 0;
      this._volume = 1;
      this._loop = false;
      this._nextTime = 0;
      this._state = Audio.State.INITIALZING;
      this._onended = function() {
        this._state = Audio.State.STOPPED;
        this.emit("ended");
      }.bind(this);
    };
    cc.js.extend(Audio, EventTarget);
    Audio.State = {
      ERROR: -1,
      INITIALZING: 0,
      PLAYING: 1,
      PAUSED: 2,
      STOPPED: 3
    };
    (function(proto) {
      proto._bindEnded = function(callback) {
        callback = callback || this._onended;
        var elem = this._element;
        this._src && elem instanceof HTMLAudioElement ? elem.addEventListener("ended", callback) : elem.onended = callback;
      };
      proto._unbindEnded = function() {
        var elem = this._element;
        elem instanceof HTMLAudioElement ? elem.removeEventListener("ended", this._onended) : elem && (elem.onended = null);
      };
      proto._onLoaded = function() {
        this._createElement();
        this.setVolume(this._volume);
        this.setLoop(this._loop);
        0 !== this._nextTime && this.setCurrentTime(this._nextTime);
        this.getState() === Audio.State.PLAYING ? this.play() : this._state = Audio.State.INITIALZING;
      };
      proto._createElement = function() {
        var elem = this._src._nativeAsset;
        if (elem instanceof HTMLAudioElement) {
          this._element || (this._element = document.createElement("audio"));
          this._element.src = elem.src;
        } else this._element = new WebAudioElement(elem, this);
      };
      proto.play = function() {
        this._state = Audio.State.PLAYING;
        if (!this._element) return;
        this._bindEnded();
        this._element.play();
        this._touchToPlay();
      };
      proto._touchToPlay = function() {
        this._src && this._src.loadMode === LoadMode.DOM_AUDIO && this._element.paused && touchPlayList.push({
          instance: this,
          offset: 0,
          audio: this._element
        });
        if (touchBinded) return;
        touchBinded = true;
        var touchEventName = "ontouchend" in window ? "touchend" : "mousedown";
        cc.game.canvas.addEventListener(touchEventName, (function() {
          var item = void 0;
          while (item = touchPlayList.pop()) item.audio.play(item.offset);
        }));
      };
      proto.destroy = function() {
        this._element = null;
      };
      proto.pause = function() {
        if (!this._element || this.getState() !== Audio.State.PLAYING) return;
        this._unbindEnded();
        this._element.pause();
        this._state = Audio.State.PAUSED;
      };
      proto.resume = function() {
        if (!this._element || this.getState() !== Audio.State.PAUSED) return;
        this._bindEnded();
        this._element.play();
        this._state = Audio.State.PLAYING;
      };
      proto.stop = function() {
        if (!this._element) return;
        this._element.pause();
        try {
          this._element.currentTime = 0;
        } catch (error) {}
        for (var i = 0; i < touchPlayList.length; i++) if (touchPlayList[i].instance === this) {
          touchPlayList.splice(i, 1);
          break;
        }
        this._unbindEnded();
        this.emit("stop");
        this._state = Audio.State.STOPPED;
      };
      proto.setLoop = function(loop) {
        this._loop = loop;
        this._element && (this._element.loop = loop);
      };
      proto.getLoop = function() {
        return this._loop;
      };
      proto.setVolume = function(num) {
        this._volume = num;
        this._element && (this._element.volume = num);
      };
      proto.getVolume = function() {
        return this._volume;
      };
      proto.setCurrentTime = function(num) {
        if (!this._element) {
          this._nextTime = num;
          return;
        }
        this._nextTime = 0;
        this._unbindEnded();
        this._bindEnded(function() {
          this._bindEnded();
        }.bind(this));
        try {
          this._element.currentTime = num;
        } catch (err) {
          var _element = this._element;
          if (_element.addEventListener) {
            var func = function func() {
              _element.removeEventListener("loadedmetadata", func);
              _element.currentTime = num;
            };
            _element.addEventListener("loadedmetadata", func);
          }
        }
      };
      proto.getCurrentTime = function() {
        return this._element ? this._element.currentTime : 0;
      };
      proto.getDuration = function() {
        return this._element ? this._element.duration : 0;
      };
      proto.getState = function() {
        this._forceUpdatingState();
        return this._state;
      };
      proto._forceUpdatingState = function() {
        var elem = this._element;
        elem && (Audio.State.PLAYING === this._state && elem.paused ? this._state = Audio.State.STOPPED : Audio.State.STOPPED !== this._state || elem.paused || (this._state = Audio.State.PLAYING));
      };
      Object.defineProperty(proto, "src", {
        get: function get() {
          return this._src;
        },
        set: function set(clip) {
          this._unbindEnded();
          if (clip) {
            this._src = clip;
            if (clip.loaded) this._onLoaded(); else {
              var self = this;
              clip.once("load", (function() {
                clip === self._src && self._onLoaded();
              }));
              cc.loader.load({
                url: clip.nativeUrl,
                skips: [ "Loader" ]
              }, (function(err, audioNativeAsset) {
                if (err) {
                  cc.error(err);
                  return;
                }
                clip.loaded || (clip._nativeAsset = audioNativeAsset);
              }));
            }
          } else {
            this._src = null;
            this._element instanceof HTMLAudioElement ? this._element.src = "" : this._element = null;
            this._state = Audio.State.INITIALZING;
          }
          return clip;
        },
        enumerable: true,
        configurable: true
      });
      Object.defineProperty(proto, "paused", {
        get: function get() {
          return !this._element || this._element.paused;
        },
        enumerable: true,
        configurable: true
      });
    })(Audio.prototype);
    var TIME_CONSTANT = void 0;
    TIME_CONSTANT = cc.sys.browserType === cc.sys.BROWSER_TYPE_EDGE || cc.sys.browserType === cc.sys.BROWSER_TYPE_BAIDU || cc.sys.browserType === cc.sys.BROWSER_TYPE_UC ? .01 : 0;
    var WebAudioElement = function WebAudioElement(buffer, audio) {
      this._audio = audio;
      this._context = sys.__audioSupport.context;
      this._buffer = buffer;
      this._gainObj = this._context["createGain"]();
      this.volume = 1;
      this._gainObj["connect"](this._context["destination"]);
      this._loop = false;
      this._startTime = -1;
      this._currentSource = null;
      this.playedLength = 0;
      this._currentTimer = null;
      this._endCallback = function() {
        this.onended && this.onended(this);
      }.bind(this);
    };
    (function(proto) {
      proto.play = function(offset) {
        if (this._currentSource && !this.paused) {
          this._currentSource.onended = null;
          this._currentSource.stop(0);
          this.playedLength = 0;
        }
        var audio = this._context["createBufferSource"]();
        audio.buffer = this._buffer;
        audio["connect"](this._gainObj);
        audio.loop = this._loop;
        this._startTime = this._context.currentTime;
        offset = offset || this.playedLength;
        offset && (this._startTime -= offset);
        var duration = this._buffer.duration;
        var startTime = offset;
        var endTime = void 0;
        if (this._loop) audio.start ? audio.start(0, startTime) : audio["notoGrainOn"] ? audio["noteGrainOn"](0, startTime) : audio["noteOn"](0, startTime); else {
          endTime = duration - offset;
          audio.start ? audio.start(0, startTime, endTime) : audio["noteGrainOn"] ? audio["noteGrainOn"](0, startTime, endTime) : audio["noteOn"](0, startTime, endTime);
        }
        this._currentSource = audio;
        audio.onended = this._endCallback;
        if ((!audio.context.state || "suspended" === audio.context.state) && 0 === this._context.currentTime) {
          var self = this;
          clearTimeout(this._currentTimer);
          this._currentTimer = setTimeout((function() {
            0 === self._context.currentTime && touchPlayList.push({
              instance: self._audio,
              offset: offset,
              audio: self
            });
          }), 10);
        }
      };
      proto.pause = function() {
        clearTimeout(this._currentTimer);
        if (this.paused) return;
        this.playedLength = this._context.currentTime - this._startTime;
        this.playedLength %= this._buffer.duration;
        var audio = this._currentSource;
        this._currentSource = null;
        this._startTime = -1;
        audio && audio.stop(0);
      };
      Object.defineProperty(proto, "paused", {
        get: function get() {
          if (this._currentSource && this._currentSource.loop) return false;
          if (-1 === this._startTime) return true;
          return this._context.currentTime - this._startTime > this._buffer.duration;
        },
        enumerable: true,
        configurable: true
      });
      Object.defineProperty(proto, "loop", {
        get: function get() {
          return this._loop;
        },
        set: function set(bool) {
          this._currentSource && (this._currentSource.loop = bool);
          return this._loop = bool;
        },
        enumerable: true,
        configurable: true
      });
      Object.defineProperty(proto, "volume", {
        get: function get() {
          return this._volume;
        },
        set: function set(num) {
          this._volume = num;
          if (this._gainObj.gain.setTargetAtTime) try {
            this._gainObj.gain.setTargetAtTime(num, this._context.currentTime, TIME_CONSTANT);
          } catch (e) {
            this._gainObj.gain.setTargetAtTime(num, this._context.currentTime, .01);
          } else this._gainObj.gain.value = num;
          if (sys.os === sys.OS_IOS && !this.paused && this._currentSource) {
            this._currentSource.onended = null;
            this.pause();
            this.play();
          }
        },
        enumerable: true,
        configurable: true
      });
      Object.defineProperty(proto, "currentTime", {
        get: function get() {
          if (this.paused) return this.playedLength;
          this.playedLength = this._context.currentTime - this._startTime;
          this.playedLength %= this._buffer.duration;
          return this.playedLength;
        },
        set: function set(num) {
          if (this.paused) this.playedLength = num; else {
            this.pause();
            this.playedLength = num;
            this.play();
          }
          return num;
        },
        enumerable: true,
        configurable: true
      });
      Object.defineProperty(proto, "duration", {
        get: function get() {
          return this._buffer.duration;
        },
        enumerable: true,
        configurable: true
      });
    })(WebAudioElement.prototype);
    module.exports = cc.Audio = Audio;
  }), {
    "../core/assets/CCAudioClip": 58,
    "../core/event/event-target": 132,
    "../core/platform/CCSys": 208
  } ],
  22: [ (function(require, module, exports) {
    "use strict";
    var Audio = require("./CCAudio");
    var AudioClip = require("../core/assets/CCAudioClip");
    var js = cc.js;
    var _instanceId = 0;
    var _id2audio = js.createMap(true);
    var _url2id = {};
    var _audioPool = [];
    var recycleAudio = function recycleAudio(audio) {
      audio._finishCallback = null;
      audio.off("ended");
      audio.off("stop");
      audio.src = null;
      _audioPool.includes(audio) || (_audioPool.length < 32 ? _audioPool.push(audio) : audio.destroy());
    };
    var getAudioFromPath = function getAudioFromPath(path) {
      var id = _instanceId++;
      var list = _url2id[path];
      list || (list = _url2id[path] = []);
      if (audioEngine._maxAudioInstance <= list.length) {
        var oldId = list.shift();
        var oldAudio = getAudioFromId(oldId);
        oldAudio.stop();
      }
      var audio = _audioPool.pop() || new Audio();
      var callback = function callback() {
        var audioInList = getAudioFromId(this.id);
        if (audioInList) {
          delete _id2audio[this.id];
          var index = list.indexOf(this.id);
          cc.js.array.fastRemoveAt(list, index);
        }
        recycleAudio(this);
      };
      audio.on("ended", (function() {
        this._finishCallback && this._finishCallback();
        callback.call(this);
      }), audio);
      audio.on("stop", callback, audio);
      audio.id = id;
      _id2audio[id] = audio;
      list.push(id);
      return audio;
    };
    var getAudioFromId = function getAudioFromId(id) {
      return _id2audio[id];
    };
    var handleVolume = function handleVolume(volume) {
      void 0 === volume ? volume = 1 : "string" === typeof volume && (volume = Number.parseFloat(volume));
      return volume;
    };
    var audioEngine = {
      AudioState: Audio.State,
      _maxWebAudioSize: 2097152,
      _maxAudioInstance: 24,
      _id2audio: _id2audio,
      play: function play(clip, loop, volume) {
        var path = clip;
        var audio;
        if ("string" === typeof clip) {
          cc.warnID(8401, "cc.audioEngine", "cc.AudioClip", "AudioClip", "cc.AudioClip", "audio");
          path = clip;
          audio = getAudioFromPath(path);
          AudioClip._loadByUrl(path, (function(err, clip) {
            clip && (audio.src = clip);
          }));
        } else {
          if (!clip) return;
          path = clip.nativeUrl;
          audio = getAudioFromPath(path);
          audio.src = clip;
        }
        audio.setLoop(loop || false);
        volume = handleVolume(volume);
        audio.setVolume(volume);
        audio.play();
        return audio.id;
      },
      setLoop: function setLoop(audioID, loop) {
        var audio = getAudioFromId(audioID);
        if (!audio || !audio.setLoop) return;
        audio.setLoop(loop);
      },
      isLoop: function isLoop(audioID) {
        var audio = getAudioFromId(audioID);
        if (!audio || !audio.getLoop) return false;
        return audio.getLoop();
      },
      setVolume: function setVolume(audioID, volume) {
        var audio = getAudioFromId(audioID);
        audio && audio.setVolume(volume);
      },
      getVolume: function getVolume(audioID) {
        var audio = getAudioFromId(audioID);
        return audio ? audio.getVolume() : 1;
      },
      setCurrentTime: function setCurrentTime(audioID, sec) {
        var audio = getAudioFromId(audioID);
        if (audio) {
          audio.setCurrentTime(sec);
          return true;
        }
        return false;
      },
      getCurrentTime: function getCurrentTime(audioID) {
        var audio = getAudioFromId(audioID);
        return audio ? audio.getCurrentTime() : 0;
      },
      getDuration: function getDuration(audioID) {
        var audio = getAudioFromId(audioID);
        return audio ? audio.getDuration() : 0;
      },
      getState: function getState(audioID) {
        var audio = getAudioFromId(audioID);
        return audio ? audio.getState() : this.AudioState.ERROR;
      },
      setFinishCallback: function setFinishCallback(audioID, callback) {
        var audio = getAudioFromId(audioID);
        if (!audio) return;
        audio._finishCallback = callback;
      },
      pause: function pause(audioID) {
        var audio = getAudioFromId(audioID);
        if (audio) {
          audio.pause();
          return true;
        }
        return false;
      },
      _pauseIDCache: [],
      pauseAll: function pauseAll() {
        for (var id in _id2audio) {
          var audio = _id2audio[id];
          var state = audio.getState();
          if (state === Audio.State.PLAYING) {
            this._pauseIDCache.push(id);
            audio.pause();
          }
        }
      },
      resume: function resume(audioID) {
        var audio = getAudioFromId(audioID);
        audio && audio.resume();
      },
      resumeAll: function resumeAll() {
        for (var i = 0; i < this._pauseIDCache.length; ++i) {
          var id = this._pauseIDCache[i];
          var audio = getAudioFromId(id);
          audio && audio.resume();
        }
        this._pauseIDCache.length = 0;
      },
      stop: function stop(audioID) {
        var audio = getAudioFromId(audioID);
        if (audio) {
          audio.stop();
          return true;
        }
        return false;
      },
      stopAll: function stopAll() {
        for (var id in _id2audio) {
          var audio = _id2audio[id];
          audio && audio.stop();
        }
      },
      setMaxAudioInstance: function setMaxAudioInstance(num) {
        this._maxAudioInstance = num;
      },
      getMaxAudioInstance: function getMaxAudioInstance() {
        return this._maxAudioInstance;
      },
      uncache: function uncache(clip) {
        var filePath = clip;
        if ("string" === typeof clip) {
          cc.warnID(8401, "cc.audioEngine", "cc.AudioClip", "AudioClip", "cc.AudioClip", "audio");
          filePath = clip;
        } else {
          if (!clip) return;
          filePath = clip.nativeUrl;
        }
        var list = _url2id[filePath];
        if (!list) return;
        while (list.length > 0) {
          var id = list.pop();
          var audio = _id2audio[id];
          if (audio) {
            audio.stop();
            delete _id2audio[id];
          }
        }
      },
      uncacheAll: function uncacheAll() {
        this.stopAll();
        var audio = void 0;
        for (var id in _id2audio) {
          audio = _id2audio[id];
          audio && audio.destroy();
        }
        while (audio = _audioPool.pop()) audio.destroy();
        _id2audio = js.createMap(true);
        _url2id = {};
      },
      getProfile: function getProfile(profileName) {},
      preload: function preload(filePath, callback) {
        true;
        cc.warn("`cc.audioEngine.preload` is deprecated, use `cc.loader.loadRes(url, cc.AudioClip)` instead please.");
        cc.loader.load(filePath, callback && function(error) {
          error || callback();
        });
      },
      setMaxWebAudioSize: function setMaxWebAudioSize(kb) {
        this._maxWebAudioSize = 1024 * kb;
      },
      _breakCache: null,
      _break: function _break() {
        this._breakCache = [];
        for (var id in _id2audio) {
          var audio = _id2audio[id];
          var state = audio.getState();
          if (state === Audio.State.PLAYING) {
            this._breakCache.push(id);
            audio.pause();
          }
        }
      },
      _restore: function _restore() {
        if (!this._breakCache) return;
        while (this._breakCache.length > 0) {
          var id = this._breakCache.pop();
          var audio = getAudioFromId(id);
          audio && audio.resume && audio.resume();
        }
        this._breakCache = null;
      },
      _music: {
        id: -1,
        loop: false,
        volume: 1
      },
      _effect: {
        volume: 1,
        pauseCache: []
      },
      playMusic: function playMusic(clip, loop) {
        var music = this._music;
        this.stop(music.id);
        music.id = this.play(clip, loop, music.volume);
        music.loop = loop;
        return music.id;
      },
      stopMusic: function stopMusic() {
        this.stop(this._music.id);
      },
      pauseMusic: function pauseMusic() {
        this.pause(this._music.id);
        return this._music.id;
      },
      resumeMusic: function resumeMusic() {
        this.resume(this._music.id);
        return this._music.id;
      },
      getMusicVolume: function getMusicVolume() {
        return this._music.volume;
      },
      setMusicVolume: function setMusicVolume(volume) {
        volume = handleVolume(volume);
        var music = this._music;
        music.volume = volume;
        this.setVolume(music.id, music.volume);
        return music.volume;
      },
      isMusicPlaying: function isMusicPlaying() {
        return this.getState(this._music.id) === this.AudioState.PLAYING;
      },
      playEffect: function playEffect(clip, loop) {
        return this.play(clip, loop || false, this._effect.volume);
      },
      setEffectsVolume: function setEffectsVolume(volume) {
        volume = handleVolume(volume);
        var musicId = this._music.id;
        this._effect.volume = volume;
        for (var id in _id2audio) {
          var audio = _id2audio[id];
          if (!audio || audio.id === musicId) continue;
          audioEngine.setVolume(id, volume);
        }
      },
      getEffectsVolume: function getEffectsVolume() {
        return this._effect.volume;
      },
      pauseEffect: function pauseEffect(audioID) {
        return this.pause(audioID);
      },
      pauseAllEffects: function pauseAllEffects() {
        var musicId = this._music.id;
        var effect = this._effect;
        effect.pauseCache.length = 0;
        for (var id in _id2audio) {
          var audio = _id2audio[id];
          if (!audio || audio.id === musicId) continue;
          var state = audio.getState();
          if (state === this.AudioState.PLAYING) {
            effect.pauseCache.push(id);
            audio.pause();
          }
        }
      },
      resumeEffect: function resumeEffect(id) {
        this.resume(id);
      },
      resumeAllEffects: function resumeAllEffects() {
        var pauseIDCache = this._effect.pauseCache;
        for (var i = 0; i < pauseIDCache.length; ++i) {
          var id = pauseIDCache[i];
          var audio = _id2audio[id];
          audio && audio.resume();
        }
      },
      stopEffect: function stopEffect(audioID) {
        return this.stop(audioID);
      },
      stopAllEffects: function stopAllEffects() {
        var musicId = this._music.id;
        for (var id in _id2audio) {
          var audio = _id2audio[id];
          if (!audio || audio.id === musicId) continue;
          var state = audio.getState();
          state === audioEngine.AudioState.PLAYING && audio.stop();
        }
      }
    };
    module.exports = cc.audioEngine = audioEngine;
  }), {
    "../core/assets/CCAudioClip": 58,
    "./CCAudio": 21
  } ],
  23: [ (function(require, module, exports) {
    "use strict";
    var codec = {
      name: "Jacob__Codec"
    };
    codec.Base64 = require("./base64");
    codec.GZip = require("./gzip");
    codec.unzip = function() {
      return codec.GZip.gunzip.apply(codec.GZip, arguments);
    };
    codec.unzipBase64 = function() {
      var buffer = codec.Base64.decode.apply(codec.Base64, arguments);
      try {
        return codec.GZip.gunzip.call(codec.GZip, buffer);
      } catch (e) {
        return buffer.slice(7);
      }
    };
    codec.unzipBase64AsArray = function(input, bytes) {
      bytes = bytes || 1;
      var dec = this.unzipBase64(input), ar = [], i, j, len;
      for (i = 0, len = dec.length / bytes; i < len; i++) {
        ar[i] = 0;
        for (j = bytes - 1; j >= 0; --j) ar[i] += dec.charCodeAt(i * bytes + j) << 8 * j;
      }
      return ar;
    };
    codec.unzipAsArray = function(input, bytes) {
      bytes = bytes || 1;
      var dec = this.unzip(input), ar = [], i, j, len;
      for (i = 0, len = dec.length / bytes; i < len; i++) {
        ar[i] = 0;
        for (j = bytes - 1; j >= 0; --j) ar[i] += dec.charCodeAt(i * bytes + j) << 8 * j;
      }
      return ar;
    };
    cc.codec = module.exports = codec;
  }), {
    "./base64": 24,
    "./gzip": 25
  } ],
  24: [ (function(require, module, exports) {
    "use strict";
    var misc = require("../core/utils/misc");
    var strValue = misc.BASE64_VALUES;
    var Base64 = {
      name: "Jacob__Codec__Base64"
    };
    Base64.decode = function Jacob__Codec__Base64__decode(input) {
      var output = [], chr1, chr2, chr3, enc1, enc2, enc3, enc4, i = 0;
      input = input.replace(/[^A-Za-z0-9\+\/\=]/g, "");
      while (i < input.length) {
        enc1 = strValue[input.charCodeAt(i++)];
        enc2 = strValue[input.charCodeAt(i++)];
        enc3 = strValue[input.charCodeAt(i++)];
        enc4 = strValue[input.charCodeAt(i++)];
        chr1 = enc1 << 2 | enc2 >> 4;
        chr2 = (15 & enc2) << 4 | enc3 >> 2;
        chr3 = (3 & enc3) << 6 | enc4;
        output.push(String.fromCharCode(chr1));
        64 !== enc3 && output.push(String.fromCharCode(chr2));
        64 !== enc4 && output.push(String.fromCharCode(chr3));
      }
      output = output.join("");
      return output;
    };
    Base64.decodeAsArray = function Jacob__Codec__Base64___decodeAsArray(input, bytes) {
      var dec = this.decode(input), ar = [], i, j, len;
      for (i = 0, len = dec.length / bytes; i < len; i++) {
        ar[i] = 0;
        for (j = bytes - 1; j >= 0; --j) ar[i] += dec.charCodeAt(i * bytes + j) << 8 * j;
      }
      return ar;
    };
    module.exports = Base64;
  }), {
    "../core/utils/misc": 299
  } ],
  25: [ (function(require, module, exports) {
    "use strict";
    var GZip = function Jacob__GZip(data) {
      this.data = data;
      this.debug = false;
      this.gpflags = void 0;
      this.files = 0;
      this.unzipped = [];
      this.buf32k = new Array(32768);
      this.bIdx = 0;
      this.modeZIP = false;
      this.bytepos = 0;
      this.bb = 1;
      this.bits = 0;
      this.nameBuf = [];
      this.fileout = void 0;
      this.literalTree = new Array(GZip.LITERALS);
      this.distanceTree = new Array(32);
      this.treepos = 0;
      this.Places = null;
      this.len = 0;
      this.fpos = new Array(17);
      this.fpos[0] = 0;
      this.flens = void 0;
      this.fmax = void 0;
    };
    GZip.gunzip = function(string) {
      string.constructor === Array || string.constructor === String;
      var gzip = new GZip(string);
      return gzip.gunzip()[0][0];
    };
    GZip.HufNode = function() {
      this.b0 = 0;
      this.b1 = 0;
      this.jump = null;
      this.jumppos = -1;
    };
    GZip.LITERALS = 288;
    GZip.NAMEMAX = 256;
    GZip.bitReverse = [ 0, 128, 64, 192, 32, 160, 96, 224, 16, 144, 80, 208, 48, 176, 112, 240, 8, 136, 72, 200, 40, 168, 104, 232, 24, 152, 88, 216, 56, 184, 120, 248, 4, 132, 68, 196, 36, 164, 100, 228, 20, 148, 84, 212, 52, 180, 116, 244, 12, 140, 76, 204, 44, 172, 108, 236, 28, 156, 92, 220, 60, 188, 124, 252, 2, 130, 66, 194, 34, 162, 98, 226, 18, 146, 82, 210, 50, 178, 114, 242, 10, 138, 74, 202, 42, 170, 106, 234, 26, 154, 90, 218, 58, 186, 122, 250, 6, 134, 70, 198, 38, 166, 102, 230, 22, 150, 86, 214, 54, 182, 118, 246, 14, 142, 78, 206, 46, 174, 110, 238, 30, 158, 94, 222, 62, 190, 126, 254, 1, 129, 65, 193, 33, 161, 97, 225, 17, 145, 81, 209, 49, 177, 113, 241, 9, 137, 73, 201, 41, 169, 105, 233, 25, 153, 89, 217, 57, 185, 121, 249, 5, 133, 69, 197, 37, 165, 101, 229, 21, 149, 85, 213, 53, 181, 117, 245, 13, 141, 77, 205, 45, 173, 109, 237, 29, 157, 93, 221, 61, 189, 125, 253, 3, 131, 67, 195, 35, 163, 99, 227, 19, 147, 83, 211, 51, 179, 115, 243, 11, 139, 75, 203, 43, 171, 107, 235, 27, 155, 91, 219, 59, 187, 123, 251, 7, 135, 71, 199, 39, 167, 103, 231, 23, 151, 87, 215, 55, 183, 119, 247, 15, 143, 79, 207, 47, 175, 111, 239, 31, 159, 95, 223, 63, 191, 127, 255 ];
    GZip.cplens = [ 3, 4, 5, 6, 7, 8, 9, 10, 11, 13, 15, 17, 19, 23, 27, 31, 35, 43, 51, 59, 67, 83, 99, 115, 131, 163, 195, 227, 258, 0, 0 ];
    GZip.cplext = [ 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 5, 0, 99, 99 ];
    GZip.cpdist = [ 1, 2, 3, 4, 5, 7, 9, 13, 17, 25, 33, 49, 65, 97, 129, 193, 257, 385, 513, 769, 1025, 1537, 2049, 3073, 4097, 6145, 8193, 12289, 16385, 24577 ];
    GZip.cpdext = [ 0, 0, 0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13 ];
    GZip.border = [ 16, 17, 18, 0, 8, 7, 9, 6, 10, 5, 11, 4, 12, 3, 13, 2, 14, 1, 15 ];
    GZip.prototype.gunzip = function() {
      this.outputArr = [];
      this.nextFile();
      return this.unzipped;
    };
    GZip.prototype.readByte = function() {
      this.bits += 8;
      return this.bytepos < this.data.length ? this.data.charCodeAt(this.bytepos++) : -1;
    };
    GZip.prototype.byteAlign = function() {
      this.bb = 1;
    };
    GZip.prototype.readBit = function() {
      var carry;
      this.bits++;
      carry = 1 & this.bb;
      this.bb >>= 1;
      if (0 === this.bb) {
        this.bb = this.readByte();
        carry = 1 & this.bb;
        this.bb = this.bb >> 1 | 128;
      }
      return carry;
    };
    GZip.prototype.readBits = function(a) {
      var res = 0, i = a;
      while (i--) res = res << 1 | this.readBit();
      a && (res = GZip.bitReverse[res] >> 8 - a);
      return res;
    };
    GZip.prototype.flushBuffer = function() {
      this.bIdx = 0;
    };
    GZip.prototype.addBuffer = function(a) {
      this.buf32k[this.bIdx++] = a;
      this.outputArr.push(String.fromCharCode(a));
      32768 === this.bIdx && (this.bIdx = 0);
    };
    GZip.prototype.IsPat = function() {
      while (1) {
        if (this.fpos[this.len] >= this.fmax) return -1;
        if (this.flens[this.fpos[this.len]] === this.len) return this.fpos[this.len]++;
        this.fpos[this.len]++;
      }
    };
    GZip.prototype.Rec = function() {
      var curplace = this.Places[this.treepos];
      var tmp;
      if (17 === this.len) return -1;
      this.treepos++;
      this.len++;
      tmp = this.IsPat();
      if (tmp >= 0) curplace.b0 = tmp; else {
        curplace.b0 = 32768;
        if (this.Rec()) return -1;
      }
      tmp = this.IsPat();
      if (tmp >= 0) {
        curplace.b1 = tmp;
        curplace.jump = null;
      } else {
        curplace.b1 = 32768;
        curplace.jump = this.Places[this.treepos];
        curplace.jumppos = this.treepos;
        if (this.Rec()) return -1;
      }
      this.len--;
      return 0;
    };
    GZip.prototype.CreateTree = function(currentTree, numval, lengths, show) {
      var i;
      this.Places = currentTree;
      this.treepos = 0;
      this.flens = lengths;
      this.fmax = numval;
      for (i = 0; i < 17; i++) this.fpos[i] = 0;
      this.len = 0;
      if (this.Rec()) return -1;
      return 0;
    };
    GZip.prototype.DecodeValue = function(currentTree) {
      var len, i, xtreepos = 0, X = currentTree[xtreepos], b;
      while (1) {
        b = this.readBit();
        if (b) {
          if (!(32768 & X.b1)) return X.b1;
          X = X.jump;
          len = currentTree.length;
          for (i = 0; i < len; i++) if (currentTree[i] === X) {
            xtreepos = i;
            break;
          }
        } else {
          if (!(32768 & X.b0)) return X.b0;
          xtreepos++;
          X = currentTree[xtreepos];
        }
      }
      return -1;
    };
    GZip.prototype.DeflateLoop = function() {
      var last, c, type, i, len;
      do {
        last = this.readBit();
        type = this.readBits(2);
        if (0 === type) {
          var blockLen, cSum;
          this.byteAlign();
          blockLen = this.readByte();
          blockLen |= this.readByte() << 8;
          cSum = this.readByte();
          cSum |= this.readByte() << 8;
          65535 & (blockLen ^ ~cSum) && document.write("BlockLen checksum mismatch\n");
          while (blockLen--) {
            c = this.readByte();
            this.addBuffer(c);
          }
        } else if (1 === type) {
          var j;
          while (1) {
            j = GZip.bitReverse[this.readBits(7)] >> 1;
            if (j > 23) {
              j = j << 1 | this.readBit();
              if (j > 199) {
                j -= 128;
                j = j << 1 | this.readBit();
              } else {
                j -= 48;
                j > 143 && (j += 136);
              }
            } else j += 256;
            if (j < 256) this.addBuffer(j); else {
              if (256 === j) break;
              var len, dist;
              j -= 257;
              len = this.readBits(GZip.cplext[j]) + GZip.cplens[j];
              j = GZip.bitReverse[this.readBits(5)] >> 3;
              if (GZip.cpdext[j] > 8) {
                dist = this.readBits(8);
                dist |= this.readBits(GZip.cpdext[j] - 8) << 8;
              } else dist = this.readBits(GZip.cpdext[j]);
              dist += GZip.cpdist[j];
              for (j = 0; j < len; j++) {
                var c = this.buf32k[this.bIdx - dist & 32767];
                this.addBuffer(c);
              }
            }
          }
        } else if (2 === type) {
          var j, n, literalCodes, distCodes, lenCodes;
          var ll = new Array(320);
          literalCodes = 257 + this.readBits(5);
          distCodes = 1 + this.readBits(5);
          lenCodes = 4 + this.readBits(4);
          for (j = 0; j < 19; j++) ll[j] = 0;
          for (j = 0; j < lenCodes; j++) ll[GZip.border[j]] = this.readBits(3);
          len = this.distanceTree.length;
          for (i = 0; i < len; i++) this.distanceTree[i] = new GZip.HufNode();
          if (this.CreateTree(this.distanceTree, 19, ll, 0)) {
            this.flushBuffer();
            return 1;
          }
          n = literalCodes + distCodes;
          i = 0;
          var z = -1;
          while (i < n) {
            z++;
            j = this.DecodeValue(this.distanceTree);
            if (j < 16) ll[i++] = j; else if (16 === j) {
              var l;
              j = 3 + this.readBits(2);
              if (i + j > n) {
                this.flushBuffer();
                return 1;
              }
              l = i ? ll[i - 1] : 0;
              while (j--) ll[i++] = l;
            } else {
              j = 17 === j ? 3 + this.readBits(3) : 11 + this.readBits(7);
              if (i + j > n) {
                this.flushBuffer();
                return 1;
              }
              while (j--) ll[i++] = 0;
            }
          }
          len = this.literalTree.length;
          for (i = 0; i < len; i++) this.literalTree[i] = new GZip.HufNode();
          if (this.CreateTree(this.literalTree, literalCodes, ll, 0)) {
            this.flushBuffer();
            return 1;
          }
          len = this.literalTree.length;
          for (i = 0; i < len; i++) this.distanceTree[i] = new GZip.HufNode();
          var ll2 = new Array();
          for (i = literalCodes; i < ll.length; i++) ll2[i - literalCodes] = ll[i];
          if (this.CreateTree(this.distanceTree, distCodes, ll2, 0)) {
            this.flushBuffer();
            return 1;
          }
          while (1) {
            j = this.DecodeValue(this.literalTree);
            if (j >= 256) {
              var len, dist;
              j -= 256;
              if (0 === j) break;
              j--;
              len = this.readBits(GZip.cplext[j]) + GZip.cplens[j];
              j = this.DecodeValue(this.distanceTree);
              if (GZip.cpdext[j] > 8) {
                dist = this.readBits(8);
                dist |= this.readBits(GZip.cpdext[j] - 8) << 8;
              } else dist = this.readBits(GZip.cpdext[j]);
              dist += GZip.cpdist[j];
              while (len--) {
                var c = this.buf32k[this.bIdx - dist & 32767];
                this.addBuffer(c);
              }
            } else this.addBuffer(j);
          }
        }
      } while (!last);
      this.flushBuffer();
      this.byteAlign();
      return 0;
    };
    GZip.prototype.unzipFile = function(name) {
      var i;
      this.gunzip();
      for (i = 0; i < this.unzipped.length; i++) if (this.unzipped[i][1] === name) return this.unzipped[i][0];
    };
    GZip.prototype.nextFile = function() {
      this.outputArr = [];
      this.modeZIP = false;
      var tmp = [];
      tmp[0] = this.readByte();
      tmp[1] = this.readByte();
      if (120 === tmp[0] && 218 === tmp[1]) {
        this.DeflateLoop();
        this.unzipped[this.files] = [ this.outputArr.join(""), "geonext.gxt" ];
        this.files++;
      }
      if (31 === tmp[0] && 139 === tmp[1]) {
        this.skipdir();
        this.unzipped[this.files] = [ this.outputArr.join(""), "file" ];
        this.files++;
      }
      if (80 === tmp[0] && 75 === tmp[1]) {
        this.modeZIP = true;
        tmp[2] = this.readByte();
        tmp[3] = this.readByte();
        if (3 === tmp[2] && 4 === tmp[3]) {
          tmp[0] = this.readByte();
          tmp[1] = this.readByte();
          this.gpflags = this.readByte();
          this.gpflags |= this.readByte() << 8;
          var method = this.readByte();
          method |= this.readByte() << 8;
          this.readByte();
          this.readByte();
          this.readByte();
          this.readByte();
          var compSize = this.readByte();
          compSize |= this.readByte() << 8;
          compSize |= this.readByte() << 16;
          compSize |= this.readByte() << 24;
          var size = this.readByte();
          size |= this.readByte() << 8;
          size |= this.readByte() << 16;
          size |= this.readByte() << 24;
          var filelen = this.readByte();
          filelen |= this.readByte() << 8;
          var extralen = this.readByte();
          extralen |= this.readByte() << 8;
          i = 0;
          this.nameBuf = [];
          while (filelen--) {
            var c = this.readByte();
            "/" === c | ":" === c ? i = 0 : i < GZip.NAMEMAX - 1 && (this.nameBuf[i++] = String.fromCharCode(c));
          }
          this.fileout || (this.fileout = this.nameBuf);
          var i = 0;
          while (i < extralen) {
            c = this.readByte();
            i++;
          }
          if (8 === method) {
            this.DeflateLoop();
            this.unzipped[this.files] = [ this.outputArr.join(""), this.nameBuf.join("") ];
            this.files++;
          }
          this.skipdir();
        }
      }
    };
    GZip.prototype.skipdir = function() {
      var tmp = [];
      var compSize, size, os, i, c;
      if (8 & this.gpflags) {
        tmp[0] = this.readByte();
        tmp[1] = this.readByte();
        tmp[2] = this.readByte();
        tmp[3] = this.readByte();
        compSize = this.readByte();
        compSize |= this.readByte() << 8;
        compSize |= this.readByte() << 16;
        compSize |= this.readByte() << 24;
        size = this.readByte();
        size |= this.readByte() << 8;
        size |= this.readByte() << 16;
        size |= this.readByte() << 24;
      }
      this.modeZIP && this.nextFile();
      tmp[0] = this.readByte();
      if (8 !== tmp[0]) return 0;
      this.gpflags = this.readByte();
      this.readByte();
      this.readByte();
      this.readByte();
      this.readByte();
      this.readByte();
      os = this.readByte();
      if (4 & this.gpflags) {
        tmp[0] = this.readByte();
        tmp[2] = this.readByte();
        this.len = tmp[0] + 256 * tmp[1];
        for (i = 0; i < this.len; i++) this.readByte();
      }
      if (8 & this.gpflags) {
        i = 0;
        this.nameBuf = [];
        while (c = this.readByte()) {
          "7" !== c && ":" !== c || (i = 0);
          i < GZip.NAMEMAX - 1 && (this.nameBuf[i++] = c);
        }
      }
      if (16 & this.gpflags) while (c = this.readByte()) ;
      if (2 & this.gpflags) {
        this.readByte();
        this.readByte();
      }
      this.DeflateLoop();
      size = this.readByte();
      size |= this.readByte() << 8;
      size |= this.readByte() << 16;
      size |= this.readByte() << 24;
      this.modeZIP && this.nextFile();
    };
    module.exports = GZip;
  }), {} ],
  26: [ (function(require, module, exports) {
    "use strict";
    (function() {
      function i(a) {
        throw a;
      }
      var r = void 0, v = !0, aa = this;
      function y(a, c) {
        var b = a.split("."), e = aa;
        !(b[0] in e) && e.execScript && e.execScript("var " + b[0]);
        for (var f; b.length && (f = b.shift()); ) b.length || c === r ? e = e[f] ? e[f] : e[f] = {} : e[f] = c;
      }
      var H = "undefined" !== typeof Uint8Array && "undefined" !== typeof Uint16Array && "undefined" !== typeof Uint32Array;
      function ba(a) {
        if ("string" === typeof a) {
          var c = a.split(""), b, e;
          b = 0;
          for (e = c.length; b < e; b++) c[b] = (255 & c[b].charCodeAt(0)) >>> 0;
          a = c;
        }
        for (var f = 1, d = 0, g = a.length, h, m = 0; 0 < g; ) {
          h = 1024 < g ? 1024 : g;
          g -= h;
          do {
            f += a[m++], d += f;
          } while (--h);
          f %= 65521;
          d %= 65521;
        }
        return (d << 16 | f) >>> 0;
      }
      function J(a, c) {
        this.index = "number" === typeof c ? c : 0;
        this.i = 0;
        this.buffer = a instanceof (H ? Uint8Array : Array) ? a : new (H ? Uint8Array : Array)(32768);
        2 * this.buffer.length <= this.index && i(Error("invalid index"));
        this.buffer.length <= this.index && this.f();
      }
      J.prototype.f = function() {
        var a = this.buffer, c, b = a.length, e = new (H ? Uint8Array : Array)(b << 1);
        if (H) e.set(a); else for (c = 0; c < b; ++c) e[c] = a[c];
        return this.buffer = e;
      };
      J.prototype.d = function(a, c, b) {
        var e = this.buffer, f = this.index, d = this.i, g = e[f], h;
        b && 1 < c && (a = 8 < c ? (N[255 & a] << 24 | N[a >>> 8 & 255] << 16 | N[a >>> 16 & 255] << 8 | N[a >>> 24 & 255]) >> 32 - c : N[a] >> 8 - c);
        if (8 > c + d) g = g << c | a, d += c; else for (h = 0; h < c; ++h) g = g << 1 | a >> c - h - 1 & 1, 
        8 === ++d && (d = 0, e[f++] = N[g], g = 0, f === e.length && (e = this.f()));
        e[f] = g;
        this.buffer = e;
        this.i = d;
        this.index = f;
      };
      J.prototype.finish = function() {
        var a = this.buffer, c = this.index, b;
        0 < this.i && (a[c] <<= 8 - this.i, a[c] = N[a[c]], c++);
        H ? b = a.subarray(0, c) : (a.length = c, b = a);
        return b;
      };
      var ca = new (H ? Uint8Array : Array)(256), ha;
      for (ha = 0; 256 > ha; ++ha) {
        for (var R = ha, ia = R, ja = 7, R = R >>> 1; R; R >>>= 1) ia <<= 1, ia |= 1 & R, 
        --ja;
        ca[ha] = (ia << ja & 255) >>> 0;
      }
      var N = ca;
      var ka = [ 0, 1996959894, 3993919788, 2567524794, 124634137, 1886057615, 3915621685, 2657392035, 249268274, 2044508324, 3772115230, 2547177864, 162941995, 2125561021, 3887607047, 2428444049, 498536548, 1789927666, 4089016648, 2227061214, 450548861, 1843258603, 4107580753, 2211677639, 325883990, 1684777152, 4251122042, 2321926636, 335633487, 1661365465, 4195302755, 2366115317, 997073096, 1281953886, 3579855332, 2724688242, 1006888145, 1258607687, 3524101629, 2768942443, 901097722, 1119000684, 3686517206, 2898065728, 853044451, 1172266101, 3705015759, 2882616665, 651767980, 1373503546, 3369554304, 3218104598, 565507253, 1454621731, 3485111705, 3099436303, 671266974, 1594198024, 3322730930, 2970347812, 795835527, 1483230225, 3244367275, 3060149565, 1994146192, 31158534, 2563907772, 4023717930, 1907459465, 112637215, 2680153253, 3904427059, 2013776290, 251722036, 2517215374, 3775830040, 2137656763, 141376813, 2439277719, 3865271297, 1802195444, 476864866, 2238001368, 4066508878, 1812370925, 453092731, 2181625025, 4111451223, 1706088902, 314042704, 2344532202, 4240017532, 1658658271, 366619977, 2362670323, 4224994405, 1303535960, 984961486, 2747007092, 3569037538, 1256170817, 1037604311, 2765210733, 3554079995, 1131014506, 879679996, 2909243462, 3663771856, 1141124467, 855842277, 2852801631, 3708648649, 1342533948, 654459306, 3188396048, 3373015174, 1466479909, 544179635, 3110523913, 3462522015, 1591671054, 702138776, 2966460450, 3352799412, 1504918807, 783551873, 3082640443, 3233442989, 3988292384, 2596254646, 62317068, 1957810842, 3939845945, 2647816111, 81470997, 1943803523, 3814918930, 2489596804, 225274430, 2053790376, 3826175755, 2466906013, 167816743, 2097651377, 4027552580, 2265490386, 503444072, 1762050814, 4150417245, 2154129355, 426522225, 1852507879, 4275313526, 2312317920, 282753626, 1742555852, 4189708143, 2394877945, 397917763, 1622183637, 3604390888, 2714866558, 953729732, 1340076626, 3518719985, 2797360999, 1068828381, 1219638859, 3624741850, 2936675148, 906185462, 1090812512, 3747672003, 2825379669, 829329135, 1181335161, 3412177804, 3160834842, 628085408, 1382605366, 3423369109, 3138078467, 570562233, 1426400815, 3317316542, 2998733608, 733239954, 1555261956, 3268935591, 3050360625, 752459403, 1541320221, 2607071920, 3965973030, 1969922972, 40735498, 2617837225, 3943577151, 1913087877, 83908371, 2512341634, 3803740692, 2075208622, 213261112, 2463272603, 3855990285, 2094854071, 198958881, 2262029012, 4057260610, 1759359992, 534414190, 2176718541, 4139329115, 1873836001, 414664567, 2282248934, 4279200368, 1711684554, 285281116, 2405801727, 4167216745, 1634467795, 376229701, 2685067896, 3608007406, 1308918612, 956543938, 2808555105, 3495958263, 1231636301, 1047427035, 2932959818, 3654703836, 1088359270, 936918e3, 2847714899, 3736837829, 1202900863, 817233897, 3183342108, 3401237130, 1404277552, 615818150, 3134207493, 3453421203, 1423857449, 601450431, 3009837614, 3294710456, 1567103746, 711928724, 3020668471, 3272380065, 1510334235, 755167117 ];
      H && new Uint32Array(ka);
      function la(a) {
        this.buffer = new (H ? Uint16Array : Array)(2 * a);
        this.length = 0;
      }
      la.prototype.getParent = function(a) {
        return 2 * ((a - 2) / 4 | 0);
      };
      la.prototype.push = function(a, c) {
        var b, e, f = this.buffer, d;
        b = this.length;
        f[this.length++] = c;
        for (f[this.length++] = a; 0 < b; ) {
          if (e = this.getParent(b), !(f[b] > f[e])) break;
          d = f[b], f[b] = f[e], f[e] = d, d = f[b + 1], f[b + 1] = f[e + 1], f[e + 1] = d, 
          b = e;
        }
        return this.length;
      };
      la.prototype.pop = function() {
        var a, c, b = this.buffer, e, f, d;
        c = b[0];
        a = b[1];
        this.length -= 2;
        b[0] = b[this.length];
        b[1] = b[this.length + 1];
        for (d = 0; ;) {
          f = 2 * d + 2;
          if (f >= this.length) break;
          f + 2 < this.length && b[f + 2] > b[f] && (f += 2);
          if (!(b[f] > b[d])) break;
          e = b[d], b[d] = b[f], b[f] = e, e = b[d + 1], b[d + 1] = b[f + 1], b[f + 1] = e;
          d = f;
        }
        return {
          index: a,
          value: c,
          length: this.length
        };
      };
      function S(a) {
        var c = a.length, b = 0, e = Number.POSITIVE_INFINITY, f, d, g, h, m, j, s, n, l;
        for (n = 0; n < c; ++n) a[n] > b && (b = a[n]), a[n] < e && (e = a[n]);
        f = 1 << b;
        d = new (H ? Uint32Array : Array)(f);
        g = 1;
        h = 0;
        for (m = 2; g <= b; ) {
          for (n = 0; n < c; ++n) if (a[n] === g) {
            j = 0;
            s = h;
            for (l = 0; l < g; ++l) j = j << 1 | 1 & s, s >>= 1;
            for (l = j; l < f; l += m) d[l] = g << 16 | n;
            ++h;
          }
          ++g;
          h <<= 1;
          m <<= 1;
        }
        return [ d, b, e ];
      }
      function ma(a, c) {
        this.h = pa;
        this.w = 0;
        this.input = a;
        this.b = 0;
        c && (c.lazy && (this.w = c.lazy), "number" === typeof c.compressionType && (this.h = c.compressionType), 
        c.outputBuffer && (this.a = H && c.outputBuffer instanceof Array ? new Uint8Array(c.outputBuffer) : c.outputBuffer), 
        "number" === typeof c.outputIndex && (this.b = c.outputIndex));
        this.a || (this.a = new (H ? Uint8Array : Array)(32768));
      }
      var pa = 2, qa = {
        NONE: 0,
        r: 1,
        j: pa,
        N: 3
      }, ra = [], T;
      for (T = 0; 288 > T; T++) switch (v) {
       case 143 >= T:
        ra.push([ T + 48, 8 ]);
        break;

       case 255 >= T:
        ra.push([ T - 144 + 400, 9 ]);
        break;

       case 279 >= T:
        ra.push([ T - 256 + 0, 7 ]);
        break;

       case 287 >= T:
        ra.push([ T - 280 + 192, 8 ]);
        break;

       default:
        i("invalid literal: " + T);
      }
      ma.prototype.n = function() {
        var a, c, b, e, f = this.input;
        switch (this.h) {
         case 0:
          b = 0;
          for (e = f.length; b < e; ) {
            c = H ? f.subarray(b, b + 65535) : f.slice(b, b + 65535);
            b += c.length;
            var d = c, g = b === e, h = r, m = r, j = r, s = r, n = r, l = this.a, q = this.b;
            if (H) {
              for (l = new Uint8Array(this.a.buffer); l.length <= q + d.length + 5; ) l = new Uint8Array(l.length << 1);
              l.set(this.a);
            }
            h = g ? 1 : 0;
            l[q++] = 0 | h;
            m = d.length;
            j = 65536 + ~m & 65535;
            l[q++] = 255 & m;
            l[q++] = m >>> 8 & 255;
            l[q++] = 255 & j;
            l[q++] = j >>> 8 & 255;
            if (H) l.set(d, q), q += d.length, l = l.subarray(0, q); else {
              s = 0;
              for (n = d.length; s < n; ++s) l[q++] = d[s];
              l.length = q;
            }
            this.b = q;
            this.a = l;
          }
          break;

         case 1:
          var E = new J(new Uint8Array(this.a.buffer), this.b);
          E.d(1, 1, v);
          E.d(1, 2, v);
          var t = sa(this, f), z, K, A;
          z = 0;
          for (K = t.length; z < K; z++) if (A = t[z], J.prototype.d.apply(E, ra[A]), 256 < A) E.d(t[++z], t[++z], v), 
          E.d(t[++z], 5), E.d(t[++z], t[++z], v); else if (256 === A) break;
          this.a = E.finish();
          this.b = this.a.length;
          break;

         case pa:
          var x = new J(new Uint8Array(this.a), this.b), B, k, p, D, C, da = [ 16, 17, 18, 0, 8, 7, 9, 6, 10, 5, 11, 4, 12, 3, 13, 2, 14, 1, 15 ], W, Ma, ea, Na, na, va = Array(19), Oa, $, oa, F, Pa;
          B = pa;
          x.d(1, 1, v);
          x.d(B, 2, v);
          k = sa(this, f);
          W = ta(this.L, 15);
          Ma = ua(W);
          ea = ta(this.K, 7);
          Na = ua(ea);
          for (p = 286; 257 < p && 0 === W[p - 1]; p--) ;
          for (D = 30; 1 < D && 0 === ea[D - 1]; D--) ;
          var Qa = p, Ra = D, M = new (H ? Uint32Array : Array)(Qa + Ra), u, O, w, fa, L = new (H ? Uint32Array : Array)(316), I, G, P = new (H ? Uint8Array : Array)(19);
          for (u = O = 0; u < Qa; u++) M[O++] = W[u];
          for (u = 0; u < Ra; u++) M[O++] = ea[u];
          if (!H) {
            u = 0;
            for (fa = P.length; u < fa; ++u) P[u] = 0;
          }
          u = I = 0;
          for (fa = M.length; u < fa; u += O) {
            for (O = 1; u + O < fa && M[u + O] === M[u]; ++O) ;
            w = O;
            if (0 === M[u]) if (3 > w) for (;0 < w--; ) L[I++] = 0, P[0]++; else for (;0 < w; ) G = 138 > w ? w : 138, 
            G > w - 3 && G < w && (G = w - 3), 10 >= G ? (L[I++] = 17, L[I++] = G - 3, P[17]++) : (L[I++] = 18, 
            L[I++] = G - 11, P[18]++), w -= G; else if (L[I++] = M[u], P[M[u]]++, w--, 3 > w) for (;0 < w--; ) L[I++] = M[u], 
            P[M[u]]++; else for (;0 < w; ) G = 6 > w ? w : 6, G > w - 3 && G < w && (G = w - 3), 
            L[I++] = 16, L[I++] = G - 3, P[16]++, w -= G;
          }
          a = H ? L.subarray(0, I) : L.slice(0, I);
          na = ta(P, 7);
          for (F = 0; 19 > F; F++) va[F] = na[da[F]];
          for (C = 19; 4 < C && 0 === va[C - 1]; C--) ;
          Oa = ua(na);
          x.d(p - 257, 5, v);
          x.d(D - 1, 5, v);
          x.d(C - 4, 4, v);
          for (F = 0; F < C; F++) x.d(va[F], 3, v);
          F = 0;
          for (Pa = a.length; F < Pa; F++) if ($ = a[F], x.d(Oa[$], na[$], v), 16 <= $) {
            F++;
            switch ($) {
             case 16:
              oa = 2;
              break;

             case 17:
              oa = 3;
              break;

             case 18:
              oa = 7;
              break;

             default:
              i("invalid code: " + $);
            }
            x.d(a[F], oa, v);
          }
          var Sa = [ Ma, W ], Ta = [ Na, ea ], Q, Ua, ga, ya, Va, Wa, Xa, Ya;
          Va = Sa[0];
          Wa = Sa[1];
          Xa = Ta[0];
          Ya = Ta[1];
          Q = 0;
          for (Ua = k.length; Q < Ua; ++Q) if (ga = k[Q], x.d(Va[ga], Wa[ga], v), 256 < ga) x.d(k[++Q], k[++Q], v), 
          ya = k[++Q], x.d(Xa[ya], Ya[ya], v), x.d(k[++Q], k[++Q], v); else if (256 === ga) break;
          this.a = x.finish();
          this.b = this.a.length;
          break;

         default:
          i("invalid compression type");
        }
        return this.a;
      };
      function wa(a, c) {
        this.length = a;
        this.G = c;
      }
      function xa() {
        var a = za;
        switch (v) {
         case 3 === a:
          return [ 257, a - 3, 0 ];

         case 4 === a:
          return [ 258, a - 4, 0 ];

         case 5 === a:
          return [ 259, a - 5, 0 ];

         case 6 === a:
          return [ 260, a - 6, 0 ];

         case 7 === a:
          return [ 261, a - 7, 0 ];

         case 8 === a:
          return [ 262, a - 8, 0 ];

         case 9 === a:
          return [ 263, a - 9, 0 ];

         case 10 === a:
          return [ 264, a - 10, 0 ];

         case 12 >= a:
          return [ 265, a - 11, 1 ];

         case 14 >= a:
          return [ 266, a - 13, 1 ];

         case 16 >= a:
          return [ 267, a - 15, 1 ];

         case 18 >= a:
          return [ 268, a - 17, 1 ];

         case 22 >= a:
          return [ 269, a - 19, 2 ];

         case 26 >= a:
          return [ 270, a - 23, 2 ];

         case 30 >= a:
          return [ 271, a - 27, 2 ];

         case 34 >= a:
          return [ 272, a - 31, 2 ];

         case 42 >= a:
          return [ 273, a - 35, 3 ];

         case 50 >= a:
          return [ 274, a - 43, 3 ];

         case 58 >= a:
          return [ 275, a - 51, 3 ];

         case 66 >= a:
          return [ 276, a - 59, 3 ];

         case 82 >= a:
          return [ 277, a - 67, 4 ];

         case 98 >= a:
          return [ 278, a - 83, 4 ];

         case 114 >= a:
          return [ 279, a - 99, 4 ];

         case 130 >= a:
          return [ 280, a - 115, 4 ];

         case 162 >= a:
          return [ 281, a - 131, 5 ];

         case 194 >= a:
          return [ 282, a - 163, 5 ];

         case 226 >= a:
          return [ 283, a - 195, 5 ];

         case 257 >= a:
          return [ 284, a - 227, 5 ];

         case 258 === a:
          return [ 285, a - 258, 0 ];

         default:
          i("invalid length: " + a);
        }
      }
      var Aa = [], za, Ba;
      for (za = 3; 258 >= za; za++) Ba = xa(), Aa[za] = Ba[2] << 24 | Ba[1] << 16 | Ba[0];
      var Ca = H ? new Uint32Array(Aa) : Aa;
      function sa(a, c) {
        function b(a, c) {
          var b = a.G, d = [], e = 0, f;
          f = Ca[a.length];
          d[e++] = 65535 & f;
          d[e++] = f >> 16 & 255;
          d[e++] = f >> 24;
          var g;
          switch (v) {
           case 1 === b:
            g = [ 0, b - 1, 0 ];
            break;

           case 2 === b:
            g = [ 1, b - 2, 0 ];
            break;

           case 3 === b:
            g = [ 2, b - 3, 0 ];
            break;

           case 4 === b:
            g = [ 3, b - 4, 0 ];
            break;

           case 6 >= b:
            g = [ 4, b - 5, 1 ];
            break;

           case 8 >= b:
            g = [ 5, b - 7, 1 ];
            break;

           case 12 >= b:
            g = [ 6, b - 9, 2 ];
            break;

           case 16 >= b:
            g = [ 7, b - 13, 2 ];
            break;

           case 24 >= b:
            g = [ 8, b - 17, 3 ];
            break;

           case 32 >= b:
            g = [ 9, b - 25, 3 ];
            break;

           case 48 >= b:
            g = [ 10, b - 33, 4 ];
            break;

           case 64 >= b:
            g = [ 11, b - 49, 4 ];
            break;

           case 96 >= b:
            g = [ 12, b - 65, 5 ];
            break;

           case 128 >= b:
            g = [ 13, b - 97, 5 ];
            break;

           case 192 >= b:
            g = [ 14, b - 129, 6 ];
            break;

           case 256 >= b:
            g = [ 15, b - 193, 6 ];
            break;

           case 384 >= b:
            g = [ 16, b - 257, 7 ];
            break;

           case 512 >= b:
            g = [ 17, b - 385, 7 ];
            break;

           case 768 >= b:
            g = [ 18, b - 513, 8 ];
            break;

           case 1024 >= b:
            g = [ 19, b - 769, 8 ];
            break;

           case 1536 >= b:
            g = [ 20, b - 1025, 9 ];
            break;

           case 2048 >= b:
            g = [ 21, b - 1537, 9 ];
            break;

           case 3072 >= b:
            g = [ 22, b - 2049, 10 ];
            break;

           case 4096 >= b:
            g = [ 23, b - 3073, 10 ];
            break;

           case 6144 >= b:
            g = [ 24, b - 4097, 11 ];
            break;

           case 8192 >= b:
            g = [ 25, b - 6145, 11 ];
            break;

           case 12288 >= b:
            g = [ 26, b - 8193, 12 ];
            break;

           case 16384 >= b:
            g = [ 27, b - 12289, 12 ];
            break;

           case 24576 >= b:
            g = [ 28, b - 16385, 13 ];
            break;

           case 32768 >= b:
            g = [ 29, b - 24577, 13 ];
            break;

           default:
            i("invalid distance");
          }
          f = g;
          d[e++] = f[0];
          d[e++] = f[1];
          d[e++] = f[2];
          var h, j;
          h = 0;
          for (j = d.length; h < j; ++h) l[q++] = d[h];
          t[d[0]]++;
          z[d[3]]++;
          E = a.length + c - 1;
          n = null;
        }
        var e, f, d, g, h, m = {}, j, s, n, l = H ? new Uint16Array(2 * c.length) : [], q = 0, E = 0, t = new (H ? Uint32Array : Array)(286), z = new (H ? Uint32Array : Array)(30), K = a.w, A;
        if (!H) {
          for (d = 0; 285 >= d; ) t[d++] = 0;
          for (d = 0; 29 >= d; ) z[d++] = 0;
        }
        t[256] = 1;
        e = 0;
        for (f = c.length; e < f; ++e) {
          d = h = 0;
          for (g = 3; d < g && e + d !== f; ++d) h = h << 8 | c[e + d];
          m[h] === r && (m[h] = []);
          j = m[h];
          if (!(0 < E--)) {
            for (;0 < j.length && 32768 < e - j[0]; ) j.shift();
            if (e + 3 >= f) {
              n && b(n, -1);
              d = 0;
              for (g = f - e; d < g; ++d) A = c[e + d], l[q++] = A, ++t[A];
              break;
            }
            if (0 < j.length) {
              var x = r, B = r, k = 0, p = r, D = r, C = r, da = r, W = c.length, D = 0, da = j.length;
              a: for (;D < da; D++) {
                x = j[da - D - 1];
                p = 3;
                if (3 < k) {
                  for (C = k; 3 < C; C--) if (c[x + C - 1] !== c[e + C - 1]) continue a;
                  p = k;
                }
                for (;258 > p && e + p < W && c[x + p] === c[e + p]; ) ++p;
                p > k && (B = x, k = p);
                if (258 === p) break;
              }
              s = new wa(k, e - B);
              n ? n.length < s.length ? (A = c[e - 1], l[q++] = A, ++t[A], b(s, 0)) : b(n, -1) : s.length < K ? n = s : b(s, 0);
            } else n ? b(n, -1) : (A = c[e], l[q++] = A, ++t[A]);
          }
          j.push(e);
        }
        l[q++] = 256;
        t[256]++;
        a.L = t;
        a.K = z;
        return H ? l.subarray(0, q) : l;
      }
      function ta(a, c) {
        function b(a) {
          var c = z[a][K[a]];
          c === n ? (b(a + 1), b(a + 1)) : --E[c];
          ++K[a];
        }
        var e = a.length, f = new la(572), d = new (H ? Uint8Array : Array)(e), g, h, m, j, s;
        if (!H) for (j = 0; j < e; j++) d[j] = 0;
        for (j = 0; j < e; ++j) 0 < a[j] && f.push(j, a[j]);
        g = Array(f.length / 2);
        h = new (H ? Uint32Array : Array)(f.length / 2);
        if (1 === g.length) return d[f.pop().index] = 1, d;
        j = 0;
        for (s = f.length / 2; j < s; ++j) g[j] = f.pop(), h[j] = g[j].value;
        var n = h.length, l = new (H ? Uint16Array : Array)(c), q = new (H ? Uint8Array : Array)(c), E = new (H ? Uint8Array : Array)(n), t = Array(c), z = Array(c), K = Array(c), A = (1 << c) - n, x = 1 << c - 1, B, k, p, D, C;
        l[c - 1] = n;
        for (k = 0; k < c; ++k) A < x ? q[k] = 0 : (q[k] = 1, A -= x), A <<= 1, l[c - 2 - k] = (l[c - 1 - k] / 2 | 0) + n;
        l[0] = q[0];
        t[0] = Array(l[0]);
        z[0] = Array(l[0]);
        for (k = 1; k < c; ++k) l[k] > 2 * l[k - 1] + q[k] && (l[k] = 2 * l[k - 1] + q[k]), 
        t[k] = Array(l[k]), z[k] = Array(l[k]);
        for (B = 0; B < n; ++B) E[B] = c;
        for (p = 0; p < l[c - 1]; ++p) t[c - 1][p] = h[p], z[c - 1][p] = p;
        for (B = 0; B < c; ++B) K[B] = 0;
        1 === q[c - 1] && (--E[0], ++K[c - 1]);
        for (k = c - 2; 0 <= k; --k) {
          D = B = 0;
          C = K[k + 1];
          for (p = 0; p < l[k]; p++) D = t[k + 1][C] + t[k + 1][C + 1], D > h[B] ? (t[k][p] = D, 
          z[k][p] = n, C += 2) : (t[k][p] = h[B], z[k][p] = B, ++B);
          K[k] = 0;
          1 === q[k] && b(k);
        }
        m = E;
        j = 0;
        for (s = g.length; j < s; ++j) d[g[j].index] = m[j];
        return d;
      }
      function ua(a) {
        var c = new (H ? Uint16Array : Array)(a.length), b = [], e = [], f = 0, d, g, h, m;
        d = 0;
        for (g = a.length; d < g; d++) b[a[d]] = 1 + (0 | b[a[d]]);
        d = 1;
        for (g = 16; d <= g; d++) e[d] = f, f += 0 | b[d], f > 1 << d && i("overcommitted"), 
        f <<= 1;
        65536 > f && i("undercommitted");
        d = 0;
        for (g = a.length; d < g; d++) {
          f = e[a[d]];
          e[a[d]] += 1;
          h = c[d] = 0;
          for (m = a[d]; h < m; h++) c[d] = c[d] << 1 | 1 & f, f >>>= 1;
        }
        return c;
      }
      function Da(a, c) {
        this.input = a;
        this.a = new (H ? Uint8Array : Array)(32768);
        this.h = U.j;
        var b = {}, e;
        !c && (c = {}) || "number" !== typeof c.compressionType || (this.h = c.compressionType);
        for (e in c) b[e] = c[e];
        b.outputBuffer = this.a;
        this.z = new ma(this.input, b);
      }
      var U = qa;
      Da.prototype.n = function() {
        var a, c, b, e, f, d, g, h = 0;
        g = this.a;
        a = Ea;
        switch (a) {
         case Ea:
          c = Math.LOG2E * Math.log(32768) - 8;
          break;

         default:
          i(Error("invalid compression method"));
        }
        b = c << 4 | a;
        g[h++] = b;
        switch (a) {
         case Ea:
          switch (this.h) {
           case U.NONE:
            f = 0;
            break;

           case U.r:
            f = 1;
            break;

           case U.j:
            f = 2;
            break;

           default:
            i(Error("unsupported compression type"));
          }
          break;

         default:
          i(Error("invalid compression method"));
        }
        e = f << 6 | 0;
        g[h++] = e | 31 - (256 * b + e) % 31;
        d = ba(this.input);
        this.z.b = h;
        g = this.z.n();
        h = g.length;
        H && (g = new Uint8Array(g.buffer), g.length <= h + 4 && (this.a = new Uint8Array(g.length + 4), 
        this.a.set(g), g = this.a), g = g.subarray(0, h + 4));
        g[h++] = d >> 24 & 255;
        g[h++] = d >> 16 & 255;
        g[h++] = d >> 8 & 255;
        g[h++] = 255 & d;
        return g;
      };
      y("Zlib.Deflate", Da);
      y("Zlib.Deflate.compress", (function(a, c) {
        return new Da(a, c).n();
      }));
      y("Zlib.Deflate.CompressionType", U);
      y("Zlib.Deflate.CompressionType.NONE", U.NONE);
      y("Zlib.Deflate.CompressionType.FIXED", U.r);
      y("Zlib.Deflate.CompressionType.DYNAMIC", U.j);
      function V(a, c) {
        this.k = [];
        this.l = 32768;
        this.e = this.g = this.c = this.q = 0;
        this.input = H ? new Uint8Array(a) : a;
        this.s = !1;
        this.m = Fa;
        this.B = !1;
        !c && (c = {}) || (c.index && (this.c = c.index), c.bufferSize && (this.l = c.bufferSize), 
        c.bufferType && (this.m = c.bufferType), c.resize && (this.B = c.resize));
        switch (this.m) {
         case Ga:
          this.b = 32768;
          this.a = new (H ? Uint8Array : Array)(32768 + this.l + 258);
          break;

         case Fa:
          this.b = 0;
          this.a = new (H ? Uint8Array : Array)(this.l);
          this.f = this.J;
          this.t = this.H;
          this.o = this.I;
          break;

         default:
          i(Error("invalid inflate mode"));
        }
      }
      var Ga = 0, Fa = 1, Ha = {
        D: Ga,
        C: Fa
      };
      V.prototype.p = function() {
        for (;!this.s; ) {
          var a = X(this, 3);
          1 & a && (this.s = v);
          a >>>= 1;
          switch (a) {
           case 0:
            var c = this.input, b = this.c, e = this.a, f = this.b, d = r, g = r, h = r, m = e.length, j = r;
            this.e = this.g = 0;
            d = c[b++];
            d === r && i(Error("invalid uncompressed block header: LEN (first byte)"));
            g = d;
            d = c[b++];
            d === r && i(Error("invalid uncompressed block header: LEN (second byte)"));
            g |= d << 8;
            d = c[b++];
            d === r && i(Error("invalid uncompressed block header: NLEN (first byte)"));
            h = d;
            d = c[b++];
            d === r && i(Error("invalid uncompressed block header: NLEN (second byte)"));
            h |= d << 8;
            g === ~h && i(Error("invalid uncompressed block header: length verify"));
            b + g > c.length && i(Error("input buffer is broken"));
            switch (this.m) {
             case Ga:
              for (;f + g > e.length; ) {
                j = m - f;
                g -= j;
                if (H) e.set(c.subarray(b, b + j), f), f += j, b += j; else for (;j--; ) e[f++] = c[b++];
                this.b = f;
                e = this.f();
                f = this.b;
              }
              break;

             case Fa:
              for (;f + g > e.length; ) e = this.f({
                v: 2
              });
              break;

             default:
              i(Error("invalid inflate mode"));
            }
            if (H) e.set(c.subarray(b, b + g), f), f += g, b += g; else for (;g--; ) e[f++] = c[b++];
            this.c = b;
            this.b = f;
            this.a = e;
            break;

           case 1:
            this.o(Ia, Ja);
            break;

           case 2:
            Ka(this);
            break;

           default:
            i(Error("unknown BTYPE: " + a));
          }
        }
        return this.t();
      };
      var La = [ 16, 17, 18, 0, 8, 7, 9, 6, 10, 5, 11, 4, 12, 3, 13, 2, 14, 1, 15 ], Za = H ? new Uint16Array(La) : La, $a = [ 3, 4, 5, 6, 7, 8, 9, 10, 11, 13, 15, 17, 19, 23, 27, 31, 35, 43, 51, 59, 67, 83, 99, 115, 131, 163, 195, 227, 258, 258, 258 ], ab = H ? new Uint16Array($a) : $a, bb = [ 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 5, 0, 0, 0 ], cb = H ? new Uint8Array(bb) : bb, db = [ 1, 2, 3, 4, 5, 7, 9, 13, 17, 25, 33, 49, 65, 97, 129, 193, 257, 385, 513, 769, 1025, 1537, 2049, 3073, 4097, 6145, 8193, 12289, 16385, 24577 ], eb = H ? new Uint16Array(db) : db, fb = [ 0, 0, 0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13 ], gb = H ? new Uint8Array(fb) : fb, hb = new (H ? Uint8Array : Array)(288), Y, ib;
      Y = 0;
      for (ib = hb.length; Y < ib; ++Y) hb[Y] = 143 >= Y ? 8 : 255 >= Y ? 9 : 279 >= Y ? 7 : 8;
      var Ia = S(hb), jb = new (H ? Uint8Array : Array)(30), kb, lb;
      kb = 0;
      for (lb = jb.length; kb < lb; ++kb) jb[kb] = 5;
      var Ja = S(jb);
      function X(a, c) {
        for (var b = a.g, e = a.e, f = a.input, d = a.c, g; e < c; ) g = f[d++], g === r && i(Error("input buffer is broken")), 
        b |= g << e, e += 8;
        g = b & (1 << c) - 1;
        a.g = b >>> c;
        a.e = e - c;
        a.c = d;
        return g;
      }
      function mb(a, c) {
        for (var b = a.g, e = a.e, f = a.input, d = a.c, g = c[0], h = c[1], m, j, s; e < h; ) m = f[d++], 
        m === r && i(Error("input buffer is broken")), b |= m << e, e += 8;
        j = g[b & (1 << h) - 1];
        s = j >>> 16;
        a.g = b >> s;
        a.e = e - s;
        a.c = d;
        return 65535 & j;
      }
      function Ka(a) {
        function c(a, b, c) {
          var d, e, f, g;
          for (g = 0; g < a; ) switch (d = mb(this, b), d) {
           case 16:
            for (f = 3 + X(this, 2); f--; ) c[g++] = e;
            break;

           case 17:
            for (f = 3 + X(this, 3); f--; ) c[g++] = 0;
            e = 0;
            break;

           case 18:
            for (f = 11 + X(this, 7); f--; ) c[g++] = 0;
            e = 0;
            break;

           default:
            e = c[g++] = d;
          }
          return c;
        }
        var b = X(a, 5) + 257, e = X(a, 5) + 1, f = X(a, 4) + 4, d = new (H ? Uint8Array : Array)(Za.length), g, h, m, j;
        for (j = 0; j < f; ++j) d[Za[j]] = X(a, 3);
        g = S(d);
        h = new (H ? Uint8Array : Array)(b);
        m = new (H ? Uint8Array : Array)(e);
        a.o(S(c.call(a, b, g, h)), S(c.call(a, e, g, m)));
      }
      V.prototype.o = function(a, c) {
        var b = this.a, e = this.b;
        this.u = a;
        for (var f = b.length - 258, d, g, h, m; 256 !== (d = mb(this, a)); ) if (256 > d) e >= f && (this.b = e, 
        b = this.f(), e = this.b), b[e++] = d; else {
          g = d - 257;
          m = ab[g];
          0 < cb[g] && (m += X(this, cb[g]));
          d = mb(this, c);
          h = eb[d];
          0 < gb[d] && (h += X(this, gb[d]));
          e >= f && (this.b = e, b = this.f(), e = this.b);
          for (;m--; ) b[e] = b[e++ - h];
        }
        for (;8 <= this.e; ) this.e -= 8, this.c--;
        this.b = e;
      };
      V.prototype.I = function(a, c) {
        var b = this.a, e = this.b;
        this.u = a;
        for (var f = b.length, d, g, h, m; 256 !== (d = mb(this, a)); ) if (256 > d) e >= f && (b = this.f(), 
        f = b.length), b[e++] = d; else {
          g = d - 257;
          m = ab[g];
          0 < cb[g] && (m += X(this, cb[g]));
          d = mb(this, c);
          h = eb[d];
          0 < gb[d] && (h += X(this, gb[d]));
          e + m > f && (b = this.f(), f = b.length);
          for (;m--; ) b[e] = b[e++ - h];
        }
        for (;8 <= this.e; ) this.e -= 8, this.c--;
        this.b = e;
      };
      V.prototype.f = function() {
        var a = new (H ? Uint8Array : Array)(this.b - 32768), c = this.b - 32768, b, e, f = this.a;
        if (H) a.set(f.subarray(32768, a.length)); else {
          b = 0;
          for (e = a.length; b < e; ++b) a[b] = f[b + 32768];
        }
        this.k.push(a);
        this.q += a.length;
        if (H) f.set(f.subarray(c, c + 32768)); else for (b = 0; 32768 > b; ++b) f[b] = f[c + b];
        this.b = 32768;
        return f;
      };
      V.prototype.J = function(a) {
        var c, b = this.input.length / this.c + 1 | 0, e, f, d, g = this.input, h = this.a;
        a && ("number" === typeof a.v && (b = a.v), "number" === typeof a.F && (b += a.F));
        2 > b ? (e = (g.length - this.c) / this.u[2], d = e / 2 * 258 | 0, f = d < h.length ? h.length + d : h.length << 1) : f = h.length * b;
        H ? (c = new Uint8Array(f), c.set(h)) : c = h;
        return this.a = c;
      };
      V.prototype.t = function() {
        var a = 0, c = this.a, b = this.k, e, f = new (H ? Uint8Array : Array)(this.q + (this.b - 32768)), d, g, h, m;
        if (0 === b.length) return H ? this.a.subarray(32768, this.b) : this.a.slice(32768, this.b);
        d = 0;
        for (g = b.length; d < g; ++d) {
          e = b[d];
          h = 0;
          for (m = e.length; h < m; ++h) f[a++] = e[h];
        }
        d = 32768;
        for (g = this.b; d < g; ++d) f[a++] = c[d];
        this.k = [];
        return this.buffer = f;
      };
      V.prototype.H = function() {
        var a, c = this.b;
        H ? this.B ? (a = new Uint8Array(c), a.set(this.a.subarray(0, c))) : a = this.a.subarray(0, c) : (this.a.length > c && (this.a.length = c), 
        a = this.a);
        return this.buffer = a;
      };
      function nb(a, c) {
        var b, e;
        this.input = a;
        this.c = 0;
        !c && (c = {}) || (c.index && (this.c = c.index), c.verify && (this.M = c.verify));
        b = a[this.c++];
        e = a[this.c++];
        switch (15 & b) {
         case Ea:
          this.method = Ea;
          break;

         default:
          i(Error("unsupported compression method"));
        }
        0 !== ((b << 8) + e) % 31 && i(Error("invalid fcheck flag:" + ((b << 8) + e) % 31));
        32 & e && i(Error("fdict flag is not supported"));
        this.A = new V(a, {
          index: this.c,
          bufferSize: c.bufferSize,
          bufferType: c.bufferType,
          resize: c.resize
        });
      }
      nb.prototype.p = function() {
        var a = this.input, c, b;
        c = this.A.p();
        this.c = this.A.c;
        this.M && (b = (a[this.c++] << 24 | a[this.c++] << 16 | a[this.c++] << 8 | a[this.c++]) >>> 0, 
        b !== ba(c) && i(Error("invalid adler-32 checksum")));
        return c;
      };
      y("Zlib.Inflate", nb);
      y("Zlib.Inflate.BufferType", Ha);
      Ha.ADAPTIVE = Ha.C;
      Ha.BLOCK = Ha.D;
      y("Zlib.Inflate.prototype.decompress", nb.prototype.p);
      var ob = [ 16, 17, 18, 0, 8, 7, 9, 6, 10, 5, 11, 4, 12, 3, 13, 2, 14, 1, 15 ];
      H && new Uint16Array(ob);
      var pb = [ 3, 4, 5, 6, 7, 8, 9, 10, 11, 13, 15, 17, 19, 23, 27, 31, 35, 43, 51, 59, 67, 83, 99, 115, 131, 163, 195, 227, 258, 258, 258 ];
      H && new Uint16Array(pb);
      var qb = [ 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 5, 0, 0, 0 ];
      H && new Uint8Array(qb);
      var rb = [ 1, 2, 3, 4, 5, 7, 9, 13, 17, 25, 33, 49, 65, 97, 129, 193, 257, 385, 513, 769, 1025, 1537, 2049, 3073, 4097, 6145, 8193, 12289, 16385, 24577 ];
      H && new Uint16Array(rb);
      var sb = [ 0, 0, 0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13 ];
      H && new Uint8Array(sb);
      var tb = new (H ? Uint8Array : Array)(288), Z, ub;
      Z = 0;
      for (ub = tb.length; Z < ub; ++Z) tb[Z] = 143 >= Z ? 8 : 255 >= Z ? 9 : 279 >= Z ? 7 : 8;
      S(tb);
      var vb = new (H ? Uint8Array : Array)(30), wb, xb;
      wb = 0;
      for (xb = vb.length; wb < xb; ++wb) vb[wb] = 5;
      S(vb);
      var Ea = 8;
    }).call(window);
    var _p = window.Zlib;
    _p.Deflate = _p["Deflate"];
    _p.Deflate.compress = _p.Deflate["compress"];
    _p.Inflate = _p["Inflate"];
    _p.Inflate.BufferType = _p.Inflate["BufferType"];
    _p.Inflate.prototype.decompress = _p.Inflate.prototype["decompress"];
    module.exports = _p;
  }), {} ],
  27: [ (function(require, module, exports) {
    "use strict";
    exports.__esModule = true;
    exports.default = void 0;
    var _createClass = (function() {
      function defineProperties(target, props) {
        for (var i = 0; i < props.length; i++) {
          var descriptor = props[i];
          descriptor.enumerable = descriptor.enumerable || false;
          descriptor.configurable = true;
          "value" in descriptor && (descriptor.writable = true);
          Object.defineProperty(target, descriptor.key, descriptor);
        }
      }
      return function(Constructor, protoProps, staticProps) {
        protoProps && defineProperties(Constructor.prototype, protoProps);
        staticProps && defineProperties(Constructor, staticProps);
        return Constructor;
      };
    })();
    var _dec, _dec2, _dec3, _dec4, _dec5, _class, _desc, _value, _class2, _descriptor, _descriptor2, _descriptor3, _descriptor4, _descriptor5, _descriptor6, _descriptor7, _descriptor8, _descriptor9, _descriptor10, _descriptor11, _descriptor12, _descriptor13, _descriptor14, _class3, _temp;
    var _enums = require("../../renderer/enums");
    var _enums2 = _interopRequireDefault(_enums);
    var _valueTypes = require("../value-types");
    var _vmath = require("../vmath");
    var _mat = require("../vmath/mat4");
    var _mat2 = _interopRequireDefault(_mat);
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : {
        default: obj
      };
    }
    function _initDefineProp(target, property, descriptor, context) {
      if (!descriptor) return;
      Object.defineProperty(target, property, {
        enumerable: descriptor.enumerable,
        configurable: descriptor.configurable,
        writable: descriptor.writable,
        value: descriptor.initializer ? descriptor.initializer.call(context) : void 0
      });
    }
    function _classCallCheck(instance, Constructor) {
      if (!(instance instanceof Constructor)) throw new TypeError("Cannot call a class as a function");
    }
    function _possibleConstructorReturn(self, call) {
      if (!self) throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
      return !call || "object" !== typeof call && "function" !== typeof call ? self : call;
    }
    function _inherits(subClass, superClass) {
      if ("function" !== typeof superClass && null !== superClass) throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
      subClass.prototype = Object.create(superClass && superClass.prototype, {
        constructor: {
          value: subClass,
          enumerable: false,
          writable: true,
          configurable: true
        }
      });
      superClass && (Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass);
    }
    function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
      var desc = {};
      Object["keys"](descriptor).forEach((function(key) {
        desc[key] = descriptor[key];
      }));
      desc.enumerable = !!desc.enumerable;
      desc.configurable = !!desc.configurable;
      ("value" in desc || desc.initializer) && (desc.writable = true);
      desc = decorators.slice().reverse().reduce((function(desc, decorator) {
        return decorator(target, property, desc) || desc;
      }), desc);
      if (context && void 0 !== desc.initializer) {
        desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
        desc.initializer = void 0;
      }
      if (void 0 === desc.initializer) {
        Object["defineProperty"](target, property, desc);
        desc = null;
      }
      return desc;
    }
    function _initializerWarningHelper(descriptor, context) {
      throw new Error("Decorating class property failed. Please ensure that transform-class-properties is enabled.");
    }
    var RendererLight = null;
    true, true;
    RendererLight = window.renderer.Light;
    var renderer = require("../renderer/index");
    var Enum = require("../platform/CCEnum");
    var CCComponent = require("../components/CCComponent");
    var _require = require("../platform/CCClassDecorator"), ccclass = _require.ccclass, menu = _require.menu, inspector = _require.inspector, property = _require.property, executeInEditMode = _require.executeInEditMode;
    var _mat4_temp = _mat2.default.create();
    var LightType = Enum({
      DIRECTIONAL: 0,
      POINT: 1,
      SPOT: 2,
      AMBIENT: 3
    });
    var LightShadowType = Enum({
      NONE: 0,
      HARD: 2
    });
    var Light = (_dec = ccclass("cc.Light"), _dec2 = menu("i18n:MAIN_MENU.component.renderers/Light"), 
    _dec3 = inspector("packages://inspector/inspectors/comps/light.js"), _dec4 = property({
      type: LightType
    }), _dec5 = property({
      type: LightShadowType
    }), _dec(_class = _dec2(_class = executeInEditMode(_class = _dec3(_class = (_class2 = (_temp = _class3 = (function(_CCComponent) {
      _inherits(Light, _CCComponent);
      _createClass(Light, [ {
        key: "type",
        get: function get() {
          return this._type;
        },
        set: function set(val) {
          this._type = val;
          var type = _enums2.default.LIGHT_DIRECTIONAL;
          val === LightType.POINT ? type = _enums2.default.LIGHT_POINT : val === LightType.SPOT ? type = _enums2.default.LIGHT_SPOT : val === LightType.AMBIENT && (type = _enums2.default.LIGHT_AMBIENT);
          this._light.setType(type);
        }
      }, {
        key: "color",
        get: function get() {
          return this._color;
        },
        set: function set(val) {
          this._color = val;
          this._light.setColor(val.r / 255, val.g / 255, val.b / 255);
        }
      }, {
        key: "intensity",
        get: function get() {
          return this._intensity;
        },
        set: function set(val) {
          this._intensity = val;
          this._light.setIntensity(val);
        }
      }, {
        key: "range",
        get: function get() {
          return this._range;
        },
        set: function set(val) {
          this._range = val;
          this._light.setRange(val);
        }
      }, {
        key: "spotAngle",
        get: function get() {
          return this._spotAngle;
        },
        set: function set(val) {
          this._spotAngle = val;
          this._light.setSpotAngle((0, _vmath.toRadian)(val));
        }
      }, {
        key: "spotExp",
        get: function get() {
          return this._spotExp;
        },
        set: function set(val) {
          this._spotExp = val;
          this._light.setSpotExp(val);
        }
      }, {
        key: "shadowType",
        get: function get() {
          return this._shadowType;
        },
        set: function set(val) {
          this._shadowType = val;
          var type = _enums2.default.SHADOW_NONE;
          val === LightShadowType.HARD ? type = _enums2.default.SHADOW_HARD : val === LightShadowType.SOFT && (type = _enums2.default.SHADOW_SOFT);
          this._light.setShadowType(type);
        }
      }, {
        key: "shadowResolution",
        get: function get() {
          return this._shadowResolution;
        },
        set: function set(val) {
          this._shadowResolution = val;
          this._light.setShadowResolution(val);
        }
      }, {
        key: "shadowDarkness",
        get: function get() {
          return this._shadowDarkness;
        },
        set: function set(val) {
          this._shadowDarkness = val;
          this._light.setShadowDarkness(val);
        }
      }, {
        key: "shadowMinDepth",
        get: function get() {
          return this._shadowMinDepth;
        },
        set: function set(val) {
          this._shadowMinDepth = val;
          this._light.setShadowMinDepth(val);
        }
      }, {
        key: "shadowMaxDepth",
        get: function get() {
          return this._shadowMaxDepth;
        },
        set: function set(val) {
          this._shadowMaxDepth = val;
          this._light.setShadowMaxDepth(val);
        }
      }, {
        key: "shadowDepthScale",
        get: function get() {
          return this._shadowDepthScale;
        },
        set: function set(val) {
          this._shadowDepthScale = val;
          this._light.setShadowDepthScale(val);
        }
      }, {
        key: "shadowFrustumSize",
        get: function get() {
          return this._shadowFrustumSize;
        },
        set: function set(val) {
          this._shadowFrustumSize = val;
          this._light.setShadowFrustumSize(val);
        }
      } ]);
      function Light() {
        _classCallCheck(this, Light);
        var _this = _possibleConstructorReturn(this, _CCComponent.call(this));
        _initDefineProp(_this, "_type", _descriptor, _this);
        _initDefineProp(_this, "_color", _descriptor2, _this);
        _initDefineProp(_this, "_intensity", _descriptor3, _this);
        _initDefineProp(_this, "_range", _descriptor4, _this);
        _initDefineProp(_this, "_spotAngle", _descriptor5, _this);
        _initDefineProp(_this, "_spotExp", _descriptor6, _this);
        _initDefineProp(_this, "_shadowType", _descriptor7, _this);
        _initDefineProp(_this, "_shadowResolution", _descriptor8, _this);
        _initDefineProp(_this, "_shadowDarkness", _descriptor9, _this);
        _initDefineProp(_this, "_shadowMinDepth", _descriptor10, _this);
        _initDefineProp(_this, "_shadowMaxDepth", _descriptor11, _this);
        _initDefineProp(_this, "_shadowDepthScale", _descriptor12, _this);
        _initDefineProp(_this, "_shadowFrustumSize", _descriptor13, _this);
        _initDefineProp(_this, "_shadowBias", _descriptor14, _this);
        _this._light = new RendererLight();
        return _this;
      }
      Light.prototype.onLoad = function onLoad() {
        this._light.setNode(this.node);
        this.type = this._type;
        this.color = this._color;
        this.intensity = this._intensity;
        this.range = this._range;
        this.spotAngle = this._spotAngle;
        this.spotExp = this._spotExp;
        this.shadowType = this._shadowType;
        this.shadowResolution = this._shadowResolution;
        this.shadowDarkness = this._shadowDarkness;
        this.shadowMaxDepth = this._shadowMaxDepth;
        this.shadowDepthScale = this._shadowDepthScale;
        this.shadowFrustumSize = this._shadowFrustumSize;
        this.shadowBias = this._shadowBias;
      };
      Light.prototype.onEnable = function onEnable() {
        renderer.scene.addLight(this._light);
      };
      Light.prototype.onDisable = function onDisable() {
        renderer.scene.removeLight(this._light);
      };
      return Light;
    })(CCComponent), _class3.Type = LightType, _class3.ShadowType = LightShadowType, 
    _temp), _descriptor = _applyDecoratedDescriptor(_class2.prototype, "_type", [ property ], {
      enumerable: true,
      initializer: function initializer() {
        return LightType.DIRECTIONAL;
      }
    }), _descriptor2 = _applyDecoratedDescriptor(_class2.prototype, "_color", [ property ], {
      enumerable: true,
      initializer: function initializer() {
        return _valueTypes.Color.WHITE;
      }
    }), _descriptor3 = _applyDecoratedDescriptor(_class2.prototype, "_intensity", [ property ], {
      enumerable: true,
      initializer: function initializer() {
        return 1;
      }
    }), _descriptor4 = _applyDecoratedDescriptor(_class2.prototype, "_range", [ property ], {
      enumerable: true,
      initializer: function initializer() {
        return 1e3;
      }
    }), _descriptor5 = _applyDecoratedDescriptor(_class2.prototype, "_spotAngle", [ property ], {
      enumerable: true,
      initializer: function initializer() {
        return 60;
      }
    }), _descriptor6 = _applyDecoratedDescriptor(_class2.prototype, "_spotExp", [ property ], {
      enumerable: true,
      initializer: function initializer() {
        return 1;
      }
    }), _descriptor7 = _applyDecoratedDescriptor(_class2.prototype, "_shadowType", [ property ], {
      enumerable: true,
      initializer: function initializer() {
        return LightShadowType.NONE;
      }
    }), _descriptor8 = _applyDecoratedDescriptor(_class2.prototype, "_shadowResolution", [ property ], {
      enumerable: true,
      initializer: function initializer() {
        return 1024;
      }
    }), _descriptor9 = _applyDecoratedDescriptor(_class2.prototype, "_shadowDarkness", [ property ], {
      enumerable: true,
      initializer: function initializer() {
        return .5;
      }
    }), _descriptor10 = _applyDecoratedDescriptor(_class2.prototype, "_shadowMinDepth", [ property ], {
      enumerable: true,
      initializer: function initializer() {
        return 1;
      }
    }), _descriptor11 = _applyDecoratedDescriptor(_class2.prototype, "_shadowMaxDepth", [ property ], {
      enumerable: true,
      initializer: function initializer() {
        return 4096;
      }
    }), _descriptor12 = _applyDecoratedDescriptor(_class2.prototype, "_shadowDepthScale", [ property ], {
      enumerable: true,
      initializer: function initializer() {
        return 250;
      }
    }), _descriptor13 = _applyDecoratedDescriptor(_class2.prototype, "_shadowFrustumSize", [ property ], {
      enumerable: true,
      initializer: function initializer() {
        return 1024;
      }
    }), _descriptor14 = _applyDecoratedDescriptor(_class2.prototype, "_shadowBias", [ property ], {
      enumerable: true,
      initializer: function initializer() {
        return 5e-4;
      }
    }), _applyDecoratedDescriptor(_class2.prototype, "type", [ _dec4 ], Object.getOwnPropertyDescriptor(_class2.prototype, "type"), _class2.prototype), 
    _applyDecoratedDescriptor(_class2.prototype, "color", [ property ], Object.getOwnPropertyDescriptor(_class2.prototype, "color"), _class2.prototype), 
    _applyDecoratedDescriptor(_class2.prototype, "intensity", [ property ], Object.getOwnPropertyDescriptor(_class2.prototype, "intensity"), _class2.prototype), 
    _applyDecoratedDescriptor(_class2.prototype, "range", [ property ], Object.getOwnPropertyDescriptor(_class2.prototype, "range"), _class2.prototype), 
    _applyDecoratedDescriptor(_class2.prototype, "spotAngle", [ property ], Object.getOwnPropertyDescriptor(_class2.prototype, "spotAngle"), _class2.prototype), 
    _applyDecoratedDescriptor(_class2.prototype, "spotExp", [ property ], Object.getOwnPropertyDescriptor(_class2.prototype, "spotExp"), _class2.prototype), 
    _applyDecoratedDescriptor(_class2.prototype, "shadowType", [ _dec5 ], Object.getOwnPropertyDescriptor(_class2.prototype, "shadowType"), _class2.prototype), 
    _applyDecoratedDescriptor(_class2.prototype, "shadowResolution", [ property ], Object.getOwnPropertyDescriptor(_class2.prototype, "shadowResolution"), _class2.prototype), 
    _applyDecoratedDescriptor(_class2.prototype, "shadowDarkness", [ property ], Object.getOwnPropertyDescriptor(_class2.prototype, "shadowDarkness"), _class2.prototype), 
    _applyDecoratedDescriptor(_class2.prototype, "shadowMinDepth", [ property ], Object.getOwnPropertyDescriptor(_class2.prototype, "shadowMinDepth"), _class2.prototype), 
    _applyDecoratedDescriptor(_class2.prototype, "shadowMaxDepth", [ property ], Object.getOwnPropertyDescriptor(_class2.prototype, "shadowMaxDepth"), _class2.prototype), 
    _applyDecoratedDescriptor(_class2.prototype, "shadowDepthScale", [ property ], Object.getOwnPropertyDescriptor(_class2.prototype, "shadowDepthScale"), _class2.prototype), 
    _applyDecoratedDescriptor(_class2.prototype, "shadowFrustumSize", [ property ], Object.getOwnPropertyDescriptor(_class2.prototype, "shadowFrustumSize"), _class2.prototype), 
    _class2)) || _class) || _class) || _class) || _class);
    exports.default = Light;
    cc.Light = Light;
    module.exports = exports["default"];
  }), {
    "../../renderer/enums": 351,
    "../../renderer/scene/light": void 0,
    "../components/CCComponent": 96,
    "../platform/CCClassDecorator": 200,
    "../platform/CCEnum": 201,
    "../renderer/index": 248,
    "../value-types": 314,
    "../vmath": 325,
    "../vmath/mat4": 329
  } ],
  28: [ (function(require, module, exports) {
    "use strict";
    var Model = cc.Class({
      name: "cc.Model",
      extends: cc.Asset,
      ctor: function ctor() {
        this._rootNode = null;
      },
      properties: {
        _nodes: {
          default: []
        },
        _precomputeJointMatrix: false,
        nodes: {
          get: function get() {
            return this._nodes;
          }
        },
        rootNode: {
          get: function get() {
            return this._rootNode;
          }
        },
        precomputeJointMatrix: {
          get: function get() {
            return this._precomputeJointMatrix;
          }
        }
      },
      onLoad: function onLoad() {
        var nodes = this._nodes;
        this._rootNode = nodes[0];
        for (var i = 0; i < nodes.length; i++) {
          var node = nodes[i];
          node.position = cc.v3.apply(this, node.position);
          node.scale = cc.v3.apply(this, node.scale);
          node.quat = cc.quat.apply(this, node.quat);
          node.uniqueBindPose && (node.uniqueBindPose = cc.mat4.apply(this, node.uniqueBindPose));
          var pose = node.bindpose;
          if (pose) for (var _i in pose) pose[_i] = cc.mat4.apply(this, pose[_i]);
          var children = node.children;
          if (children) for (var _i2 = 0; _i2 < children.length; _i2++) children[_i2] = nodes[children[_i2]];
        }
      }
    });
    cc.Model = module.exports = Model;
  }), {} ],
  29: [ (function(require, module, exports) {
    "use strict";
    var quat = cc.vmath.quat;
    var _quat_tmp = cc.quat();
    var _vec3_tmp = cc.v3();
    cc.Rotate3DTo = cc.Class({
      name: "cc.Rotate3DTo",
      extends: cc.ActionInterval,
      ctor: function ctor(duration, dstAngleX, dstAngleY, dstAngleZ) {
        this._startQuat = cc.quat();
        this._dstQuat = cc.quat();
        void 0 !== dstAngleX && this.initWithDuration(duration, dstAngleX, dstAngleY, dstAngleZ);
      },
      initWithDuration: function initWithDuration(duration, dstAngleX, dstAngleY, dstAngleZ) {
        if (cc.ActionInterval.prototype.initWithDuration.call(this, duration)) {
          var dstQuat = this._dstQuat;
          if (dstAngleX instanceof cc.Quat) dstQuat.set(dstAngleX); else {
            if (dstAngleX instanceof cc.Vec3) {
              dstAngleY = dstAngleX.y;
              dstAngleZ = dstAngleX.z;
              dstAngleX = dstAngleX.x;
            } else {
              dstAngleY = dstAngleY || 0;
              dstAngleZ = dstAngleZ || 0;
            }
            cc.vmath.quat.fromEuler(dstQuat, dstAngleX, dstAngleY, dstAngleZ);
          }
          return true;
        }
        return false;
      },
      clone: function clone() {
        var action = new cc.Rotate3DTo();
        this._cloneDecoration(action);
        action.initWithDuration(this._duration, this._dstQuat);
        return action;
      },
      startWithTarget: function startWithTarget(target) {
        cc.ActionInterval.prototype.startWithTarget.call(this, target);
        this._startQuat.set(target.quat);
      },
      reverse: function reverse() {
        cc.logID(1016);
      },
      update: function update(dt) {
        dt = this._computeEaseTime(dt);
        if (this.target) {
          quat.slerp(_quat_tmp, this._startQuat, this._dstQuat, dt);
          this.target.setRotation(_quat_tmp);
        }
      }
    });
    cc.rotate3DTo = function(duration, dstAngleX, dstAngleY, dstAngleZ) {
      return new cc.Rotate3DTo(duration, dstAngleX, dstAngleY, dstAngleZ);
    };
    cc.Rotate3DBy = cc.Class({
      name: "cc.Rotate3DBy",
      extends: cc.ActionInterval,
      ctor: function ctor(duration, deltaAngleX, deltaAngleY, deltaAngleZ) {
        this._angle = cc.v3();
        this._quat = cc.quat();
        this._lastDt = 0;
        void 0 !== deltaAngleX && this.initWithDuration(duration, deltaAngleX, deltaAngleY, deltaAngleZ);
      },
      initWithDuration: function initWithDuration(duration, deltaAngleX, deltaAngleY, deltaAngleZ) {
        if (cc.ActionInterval.prototype.initWithDuration.call(this, duration)) {
          if (deltaAngleX instanceof cc.Vec3) {
            deltaAngleY = deltaAngleX.y;
            deltaAngleZ = deltaAngleX.z;
            deltaAngleX = deltaAngleX.x;
          } else {
            deltaAngleY = deltaAngleY || 0;
            deltaAngleZ = deltaAngleZ || 0;
          }
          cc.vmath.vec3.set(this._angle, deltaAngleX, deltaAngleY, deltaAngleZ);
          return true;
        }
        return false;
      },
      clone: function clone() {
        var action = new cc.Rotate3DBy();
        this._cloneDecoration(action);
        action.initWithDuration(this._duration, this._angle);
        return action;
      },
      startWithTarget: function startWithTarget(target) {
        cc.ActionInterval.prototype.startWithTarget.call(this, target);
        this._quat.set(target.quat);
        this._lastDt = 0;
      },
      update: (function() {
        var RAD = Math.PI / 180;
        return function(dt) {
          dt = this._computeEaseTime(dt);
          if (this.target) {
            var angle = this._angle;
            var dstQuat = this._quat;
            var delta = dt - this._lastDt;
            var angleX = angle.x, angleY = angle.y, angleZ = angle.z;
            angleX && quat.rotateX(dstQuat, dstQuat, angleX * RAD * delta);
            angleY && quat.rotateY(dstQuat, dstQuat, angleY * RAD * delta);
            angleZ && quat.rotateZ(dstQuat, dstQuat, angleZ * RAD * delta);
            this.target.setRotation(dstQuat);
            this._lastDt = dt;
          }
        };
      })(),
      reverse: function reverse() {
        var angle = this._angle;
        _vec3_tmp.x = -angle.x;
        _vec3_tmp.y = -angle.y;
        _vec3_tmp.z = -angle.z;
        var action = new cc.Rotate3DBy(this._duration, _vec3_tmp);
        this._cloneDecoration(action);
        this._reverseEaseList(action);
        return action;
      }
    });
    cc.rotate3DBy = function(duration, deltaAngleX, deltaAngleY, deltaAngleZ) {
      return new cc.Rotate3DBy(duration, deltaAngleX, deltaAngleY, deltaAngleZ);
    };
  }), {} ],
  30: [ (function(require, module, exports) {
    "use strict";
    true, true;
    require("./polyfill-3d");
    require("./primitive");
    require("./CCModel");
    require("./skeleton/CCSkeleton");
    require("./skeleton/CCSkeletonAnimationClip");
    require("./actions");
    true;
    require("./skeleton/CCSkeletonAnimation");
    require("./skeleton/CCSkinnedMeshRenderer");
    require("./skeleton/skinned-mesh-renderer");
    require("./CCLightComponent");
  }), {
    "./CCLightComponent": 27,
    "./CCModel": 28,
    "./actions": 29,
    "./polyfill-3d": 31,
    "./primitive": 36,
    "./skeleton/CCSkeleton": 45,
    "./skeleton/CCSkeletonAnimation": 46,
    "./skeleton/CCSkeletonAnimationClip": 47,
    "./skeleton/CCSkinnedMeshRenderer": 48,
    "./skeleton/skinned-mesh-renderer": 49
  } ],
  31: [ (function(require, module, exports) {
    "use strict";
    var _vmath = require("../vmath");
    var Node = require("../CCNode");
    var EventType = Node.EventType;
    var DirtyFlag = Node._LocalDirtyFlag;
    var RenderFlow = require("../renderer/render-flow");
    var ONE_DEGREE = Math.PI / 180;
    var POSITION_ON = 1;
    var SCALE_ON = 2;
    var ERR_INVALID_NUMBER = false;
    function _updateLocalMatrix3d() {
      if (this._localMatDirty) {
        var t = this._matrix;
        var tm = t.m;
        _vmath.mat4.fromTRSArray(t, this._trs);
        if (this._skewX || this._skewY) {
          var a = tm[0], b = tm[1], c = tm[4], d = tm[5];
          var skx = Math.tan(this._skewX * ONE_DEGREE);
          var sky = Math.tan(this._skewY * ONE_DEGREE);
          Infinity === skx && (skx = 99999999);
          Infinity === sky && (sky = 99999999);
          tm[0] = a + c * sky;
          tm[1] = b + d * sky;
          tm[4] = c + a * skx;
          tm[5] = d + b * skx;
        }
        this._localMatDirty = 0;
        this._worldMatDirty = true;
      }
    }
    function _calculWorldMatrix3d() {
      this._localMatDirty && this._updateLocalMatrix();
      if (this._parent) {
        var parentMat = this._parent._worldMatrix;
        _vmath.mat4.mul(this._worldMatrix, parentMat, this._matrix);
      } else _vmath.mat4.copy(this._worldMatrix, this._matrix);
      this._worldMatDirty = false;
    }
    function setPosition(newPosOrX, y, z) {
      var x = void 0;
      if (void 0 === y) {
        x = newPosOrX.x;
        y = newPosOrX.y;
        z = newPosOrX.z || 0;
      } else {
        x = newPosOrX;
        z = z || 0;
      }
      var trs = this._trs;
      if (trs[0] === x && trs[1] === y && trs[2] === z) return;
      var oldPosition;
      false;
      trs[0] = x;
      trs[1] = y;
      trs[2] = z;
      this.setLocalDirty(DirtyFlag.POSITION);
      false;
      if (this._eventMask & POSITION_ON) {
        false;
        this.emit(EventType.POSITION_CHANGED);
      }
    }
    function setScale(x, y, z) {
      if (x && "number" !== typeof x) {
        y = x.y;
        z = void 0 === x.z ? 1 : x.z;
        x = x.x;
      } else if (void 0 !== x && void 0 === y) {
        y = x;
        z = x;
      } else void 0 === z && (z = 1);
      var trs = this._trs;
      if (trs[7] !== x || trs[8] !== y || trs[9] !== z) {
        trs[7] = x;
        trs[8] = y;
        trs[9] = z;
        this.setLocalDirty(DirtyFlag.SCALE);
        false;
        this._eventMask & SCALE_ON && this.emit(EventType.SCALE_CHANGED);
      }
    }
    function _update3DFunction() {
      if (this._is3DNode) {
        this._updateLocalMatrix = _updateLocalMatrix3d;
        this._calculWorldMatrix = _calculWorldMatrix3d;
        this._mulMat = _vmath.mat4.mul;
      } else {
        this._updateLocalMatrix = _updateLocalMatrix2d;
        this._calculWorldMatrix = _calculWorldMatrix2d;
        this._mulMat = _mulMat2d;
      }
      this._renderComponent && this._renderComponent._on3DNodeChanged && this._renderComponent._on3DNodeChanged();
      this._renderFlag |= RenderFlow.FLAG_TRANSFORM;
      this._localMatDirty = DirtyFlag.ALL;
      true, true;
      this._proxy.update3DNode();
    }
    function _upgrade_1x_to_2x() {
      this._is3DNode && this._update3DFunction();
      _upgrade_1x_to_2x_2d.call(this);
    }
    var proto = cc.Node.prototype;
    var _updateLocalMatrix2d = proto._updateLocalMatrix;
    var _calculWorldMatrix2d = proto._calculWorldMatrix;
    var _upgrade_1x_to_2x_2d = proto._upgrade_1x_to_2x;
    var _mulMat2d = proto._mulMat;
    proto.setPosition = setPosition;
    proto.setScale = setScale;
    proto._upgrade_1x_to_2x = _upgrade_1x_to_2x;
    proto._update3DFunction = _update3DFunction;
    cc.js.getset(proto, "position", proto.getPosition, setPosition, false, true);
    cc.js.getset(proto, "is3DNode", (function() {
      return this._is3DNode;
    }), (function(v) {
      this._is3DNode = v;
      this._update3DFunction();
    }));
    cc.js.getset(proto, "scaleZ", (function() {
      return this._trs[9];
    }), (function(value) {
      if (this._trs[9] !== value) {
        this._trs[9] = value;
        this.setLocalDirty(DirtyFlag.SCALE);
        false;
        this._eventMask & SCALE_ON && this.emit(EventType.SCALE_CHANGED);
      }
    }));
    cc.js.getset(proto, "z", (function() {
      return this._trs[2];
    }), (function(value) {
      var trs = this._trs;
      if (value !== trs[2]) {
        true;
        trs[2] = value;
        this.setLocalDirty(DirtyFlag.POSITION);
        false;
        this._eventMask & POSITION_ON && this.emit(EventType.POSITION_CHANGED);
      }
    }));
    var vec3_tmp;
    false;
    cc.js.getset(proto, "eulerAngles", (function() {
      false;
      return _vmath.trs.toEuler(this._eulerAngles, this._trs);
    }), (function(v) {
      false;
      _vmath.trs.fromEuler(this._trs, v);
      this.setLocalDirty(DirtyFlag.ROTATION);
      false;
    }));
    cc.js.getset(proto, "quat", (function() {
      var trs = this._trs;
      return cc.quat(trs[3], trs[4], trs[5], trs[6]);
    }), proto.setRotation);
  }), {
    "../CCNode": 53,
    "../renderer/render-flow": 249,
    "../vmath": 325
  } ],
  32: [ (function(require, module, exports) {
    "use strict";
    exports.__esModule = true;
    exports.default = function() {
      var width = arguments.length > 0 && void 0 !== arguments[0] ? arguments[0] : 1;
      var height = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : 1;
      var length = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : 1;
      var opts = arguments.length > 3 && void 0 !== arguments[3] ? arguments[3] : {};
      var ws = void 0 !== opts.widthSegments ? opts.widthSegments : 1;
      var hs = void 0 !== opts.heightSegments ? opts.heightSegments : 1;
      var ls = void 0 !== opts.lengthSegments ? opts.lengthSegments : 1;
      var inv = void 0 !== opts.invWinding && opts.invWinding;
      var hw = .5 * width;
      var hh = .5 * height;
      var hl = .5 * length;
      var corners = [ _vmath.vec3.set(c0, -hw, -hh, hl), _vmath.vec3.set(c1, hw, -hh, hl), _vmath.vec3.set(c2, hw, hh, hl), _vmath.vec3.set(c3, -hw, hh, hl), _vmath.vec3.set(c4, hw, -hh, -hl), _vmath.vec3.set(c5, -hw, -hh, -hl), _vmath.vec3.set(c6, -hw, hh, -hl), _vmath.vec3.set(c7, hw, hh, -hl) ];
      var faceAxes = [ [ 2, 3, 1 ], [ 4, 5, 7 ], [ 7, 6, 2 ], [ 1, 0, 4 ], [ 1, 4, 2 ], [ 5, 0, 6 ] ];
      var faceNormals = [ [ 0, 0, 1 ], [ 0, 0, -1 ], [ 0, 1, 0 ], [ 0, -1, 0 ], [ 1, 0, 0 ], [ -1, 0, 0 ] ];
      var positions = [];
      var normals = [];
      var uvs = [];
      var indices = [];
      var minPos = _vmath.vec3.create(-hw, -hh, -hl);
      var maxPos = _vmath.vec3.create(hw, hh, hl);
      var boundingRadius = Math.sqrt(hw * hw + hh * hh + hl * hl);
      function _buildPlane(side, uSegments, vSegments) {
        var u = void 0, v = void 0;
        var ix = void 0, iy = void 0;
        var offset = positions.length / 3;
        var faceAxe = faceAxes[side];
        var faceNormal = faceNormals[side];
        for (iy = 0; iy <= vSegments; iy++) for (ix = 0; ix <= uSegments; ix++) {
          u = ix / uSegments;
          v = iy / vSegments;
          _vmath.vec3.lerp(temp1, corners[faceAxe[0]], corners[faceAxe[1]], u);
          _vmath.vec3.lerp(temp2, corners[faceAxe[0]], corners[faceAxe[2]], v);
          _vmath.vec3.sub(temp3, temp2, corners[faceAxe[0]]);
          _vmath.vec3.add(r, temp1, temp3);
          positions.push(r.x, r.y, r.z);
          normals.push(faceNormal[0], faceNormal[1], faceNormal[2]);
          uvs.push(u, v);
          if (ix < uSegments && iy < vSegments) {
            var useg1 = uSegments + 1;
            var a = ix + iy * useg1;
            var b = ix + (iy + 1) * useg1;
            var c = ix + 1 + (iy + 1) * useg1;
            var d = ix + 1 + iy * useg1;
            if (inv) {
              indices.push(offset + a, offset + b, offset + d);
              indices.push(offset + d, offset + b, offset + c);
            } else {
              indices.push(offset + a, offset + d, offset + b);
              indices.push(offset + b, offset + d, offset + c);
            }
          }
        }
      }
      _buildPlane(0, ws, hs);
      _buildPlane(4, ls, hs);
      _buildPlane(1, ws, hs);
      _buildPlane(5, ls, hs);
      _buildPlane(3, ws, ls);
      _buildPlane(2, ws, ls);
      return new _vertexData2.default(positions, normals, uvs, indices, minPos, maxPos, boundingRadius);
    };
    var _vmath = require("../../vmath");
    var _vertexData = require("./vertex-data");
    var _vertexData2 = _interopRequireDefault(_vertexData);
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : {
        default: obj
      };
    }
    var temp1 = _vmath.vec3.create(0, 0, 0);
    var temp2 = _vmath.vec3.create(0, 0, 0);
    var temp3 = _vmath.vec3.create(0, 0, 0);
    var r = _vmath.vec3.create(0, 0, 0);
    var c0 = _vmath.vec3.create(0, 0, 0);
    var c1 = _vmath.vec3.create(0, 0, 0);
    var c2 = _vmath.vec3.create(0, 0, 0);
    var c3 = _vmath.vec3.create(0, 0, 0);
    var c4 = _vmath.vec3.create(0, 0, 0);
    var c5 = _vmath.vec3.create(0, 0, 0);
    var c6 = _vmath.vec3.create(0, 0, 0);
    var c7 = _vmath.vec3.create(0, 0, 0);
    module.exports = exports["default"];
  }), {
    "../../vmath": 325,
    "./vertex-data": 43
  } ],
  33: [ (function(require, module, exports) {
    "use strict";
    exports.__esModule = true;
    exports.default = function() {
      var radiusTop = arguments.length > 0 && void 0 !== arguments[0] ? arguments[0] : .5;
      var radiusBottom = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : .5;
      var height = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : 2;
      var opts = arguments.length > 3 && void 0 !== arguments[3] ? arguments[3] : {};
      var torsoHeight = height - radiusTop - radiusBottom;
      var sides = opts.sides || 32;
      var heightSegments = opts.heightSegments || 32;
      var bottomProp = radiusBottom / height;
      var torProp = torsoHeight / height;
      var topProp = radiusTop / height;
      var bottomSegments = Math.floor(heightSegments * bottomProp);
      var topSegments = Math.floor(heightSegments * topProp);
      var torSegments = Math.floor(heightSegments * torProp);
      var topOffset = torsoHeight + radiusBottom - height / 2;
      var torOffset = radiusBottom - height / 2;
      var bottomOffset = radiusBottom - height / 2;
      var arc = opts.arc || 2 * Math.PI;
      var positions = [];
      var normals = [];
      var uvs = [];
      var indices = [];
      var maxRadius = Math.max(radiusTop, radiusBottom);
      var minPos = _vmath.vec3.create(-maxRadius, -height / 2, -maxRadius);
      var maxPos = _vmath.vec3.create(maxRadius, height / 2, maxRadius);
      var boundingRadius = height / 2;
      var index = 0;
      var indexArray = [];
      generateBottom();
      generateTorso();
      generateTop();
      return new _vertexData2.default(positions, normals, uvs, indices, minPos, maxPos, boundingRadius);
      function generateTorso() {
        var slope = (radiusTop - radiusBottom) / torsoHeight;
        for (var y = 0; y <= torSegments; y++) {
          var indexRow = [];
          var lat = y / torSegments;
          var radius = lat * (radiusTop - radiusBottom) + radiusBottom;
          for (var x = 0; x <= sides; ++x) {
            var u = x / sides;
            var v = lat * torProp + bottomProp;
            var theta = u * arc - arc / 4;
            var sinTheta = Math.sin(theta);
            var cosTheta = Math.cos(theta);
            positions.push(radius * sinTheta);
            positions.push(lat * torsoHeight + torOffset);
            positions.push(radius * cosTheta);
            _vmath.vec3.normalize(temp1, _vmath.vec3.set(temp2, sinTheta, -slope, cosTheta));
            normals.push(temp1.x);
            normals.push(temp1.y);
            normals.push(temp1.z);
            uvs.push(u, v);
            indexRow.push(index);
            ++index;
          }
          indexArray.push(indexRow);
        }
        for (var _y = 0; _y < torSegments; ++_y) for (var _x5 = 0; _x5 < sides; ++_x5) {
          var i1 = indexArray[_y][_x5];
          var i2 = indexArray[_y + 1][_x5];
          var i3 = indexArray[_y + 1][_x5 + 1];
          var i4 = indexArray[_y][_x5 + 1];
          indices.push(i1);
          indices.push(i4);
          indices.push(i2);
          indices.push(i4);
          indices.push(i3);
          indices.push(i2);
        }
      }
      function generateBottom() {
        for (var lat = 0; lat <= bottomSegments; ++lat) {
          var theta = lat * Math.PI / bottomSegments / 2;
          var sinTheta = Math.sin(theta);
          var cosTheta = -Math.cos(theta);
          for (var lon = 0; lon <= sides; ++lon) {
            var phi = 2 * lon * Math.PI / sides - Math.PI / 2;
            var sinPhi = Math.sin(phi);
            var cosPhi = Math.cos(phi);
            var x = sinPhi * sinTheta;
            var y = cosTheta;
            var z = cosPhi * sinTheta;
            var u = lon / sides;
            var v = lat / heightSegments;
            positions.push(x * radiusBottom, y * radiusBottom + bottomOffset, z * radiusBottom);
            normals.push(x, y, z);
            uvs.push(u, v);
            if (lat < bottomSegments && lon < sides) {
              var seg1 = sides + 1;
              var a = seg1 * lat + lon;
              var b = seg1 * (lat + 1) + lon;
              var c = seg1 * (lat + 1) + lon + 1;
              var d = seg1 * lat + lon + 1;
              indices.push(a, d, b);
              indices.push(d, c, b);
            }
            ++index;
          }
        }
      }
      function generateTop() {
        for (var lat = 0; lat <= topSegments; ++lat) {
          var theta = lat * Math.PI / topSegments / 2 + Math.PI / 2;
          var sinTheta = Math.sin(theta);
          var cosTheta = -Math.cos(theta);
          for (var lon = 0; lon <= sides; ++lon) {
            var phi = 2 * lon * Math.PI / sides - Math.PI / 2;
            var sinPhi = Math.sin(phi);
            var cosPhi = Math.cos(phi);
            var x = sinPhi * sinTheta;
            var y = cosTheta;
            var z = cosPhi * sinTheta;
            var u = lon / sides;
            var v = lat / heightSegments + (1 - topProp);
            positions.push(x * radiusTop, y * radiusTop + topOffset, z * radiusTop);
            normals.push(x, y, z);
            uvs.push(u, v);
            if (lat < topSegments && lon < sides) {
              var seg1 = sides + 1;
              var a = seg1 * lat + lon + indexArray[torSegments][sides] + 1;
              var b = seg1 * (lat + 1) + lon + indexArray[torSegments][sides] + 1;
              var c = seg1 * (lat + 1) + lon + 1 + indexArray[torSegments][sides] + 1;
              var d = seg1 * lat + lon + 1 + indexArray[torSegments][sides] + 1;
              indices.push(a, d, b);
              indices.push(d, c, b);
            }
          }
        }
      }
    };
    var _vmath = require("../../vmath");
    var _vertexData = require("./vertex-data");
    var _vertexData2 = _interopRequireDefault(_vertexData);
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : {
        default: obj
      };
    }
    var temp1 = _vmath.vec3.create(0, 0, 0);
    var temp2 = _vmath.vec3.create(0, 0, 0);
    module.exports = exports["default"];
  }), {
    "../../vmath": 325,
    "./vertex-data": 43
  } ],
  34: [ (function(require, module, exports) {
    "use strict";
    exports.__esModule = true;
    exports.default = function() {
      var radius = arguments.length > 0 && void 0 !== arguments[0] ? arguments[0] : .5;
      var height = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : 1;
      var opts = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : {};
      return (0, _cylinder2.default)(0, radius, height, opts);
    };
    var _cylinder = require("./cylinder");
    var _cylinder2 = _interopRequireDefault(_cylinder);
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : {
        default: obj
      };
    }
    module.exports = exports["default"];
  }), {
    "./cylinder": 35
  } ],
  35: [ (function(require, module, exports) {
    "use strict";
    exports.__esModule = true;
    exports.default = function() {
      var radiusTop = arguments.length > 0 && void 0 !== arguments[0] ? arguments[0] : .5;
      var radiusBottom = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : .5;
      var height = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : 2;
      var opts = arguments.length > 3 && void 0 !== arguments[3] ? arguments[3] : {};
      var halfHeight = .5 * height;
      var radialSegments = opts.radialSegments || 32;
      var heightSegments = opts.heightSegments || 1;
      var capped = void 0 === opts.capped || opts.capped;
      var arc = opts.arc || 2 * Math.PI;
      var cntCap = 0;
      if (!capped) {
        radiusTop > 0 && cntCap++;
        radiusBottom > 0 && cntCap++;
      }
      var vertCount = (radialSegments + 1) * (heightSegments + 1);
      capped && (vertCount += (radialSegments + 1) * cntCap + radialSegments * cntCap);
      var indexCount = radialSegments * heightSegments * 2 * 3;
      capped && (indexCount += radialSegments * cntCap * 3);
      var indices = new Array(indexCount);
      var positions = new Array(3 * vertCount);
      var normals = new Array(3 * vertCount);
      var uvs = new Array(2 * vertCount);
      var maxRadius = Math.max(radiusTop, radiusBottom);
      var minPos = _vmath.vec3.create(-maxRadius, -halfHeight, -maxRadius);
      var maxPos = _vmath.vec3.create(maxRadius, halfHeight, maxRadius);
      var boundingRadius = Math.sqrt(maxRadius * maxRadius + halfHeight * halfHeight);
      var index = 0;
      var indexOffset = 0;
      generateTorso();
      if (capped) {
        radiusBottom > 0 && generateCap(false);
        radiusTop > 0 && generateCap(true);
      }
      return new _vertexData2.default(positions, normals, uvs, indices, minPos, maxPos, boundingRadius);
      function generateTorso() {
        var indexArray = [];
        var r = radiusTop - radiusBottom;
        var slope = r * r / height * Math.sign(r);
        for (var y = 0; y <= heightSegments; y++) {
          var indexRow = [];
          var v = y / heightSegments;
          var radius = v * r + radiusBottom;
          for (var x = 0; x <= radialSegments; ++x) {
            var u = x / radialSegments;
            var theta = u * arc;
            var sinTheta = Math.sin(theta);
            var cosTheta = Math.cos(theta);
            positions[3 * index] = radius * sinTheta;
            positions[3 * index + 1] = v * height - halfHeight;
            positions[3 * index + 2] = radius * cosTheta;
            _vmath.vec3.normalize(temp1, _vmath.vec3.set(temp2, sinTheta, -slope, cosTheta));
            normals[3 * index] = temp1.x;
            normals[3 * index + 1] = temp1.y;
            normals[3 * index + 2] = temp1.z;
            uvs[2 * index] = 2 * (1 - u) % 1;
            uvs[2 * index + 1] = v;
            indexRow.push(index);
            ++index;
          }
          indexArray.push(indexRow);
        }
        for (var _y = 0; _y < heightSegments; ++_y) for (var _x5 = 0; _x5 < radialSegments; ++_x5) {
          var i1 = indexArray[_y][_x5];
          var i2 = indexArray[_y + 1][_x5];
          var i3 = indexArray[_y + 1][_x5 + 1];
          var i4 = indexArray[_y][_x5 + 1];
          indices[indexOffset] = i1;
          ++indexOffset;
          indices[indexOffset] = i4;
          ++indexOffset;
          indices[indexOffset] = i2;
          ++indexOffset;
          indices[indexOffset] = i4;
          ++indexOffset;
          indices[indexOffset] = i3;
          ++indexOffset;
          indices[indexOffset] = i2;
          ++indexOffset;
        }
      }
      function generateCap(top) {
        var centerIndexStart = void 0, centerIndexEnd = void 0;
        var radius = top ? radiusTop : radiusBottom;
        var sign = top ? 1 : -1;
        centerIndexStart = index;
        for (var x = 1; x <= radialSegments; ++x) {
          positions[3 * index] = 0;
          positions[3 * index + 1] = halfHeight * sign;
          positions[3 * index + 2] = 0;
          normals[3 * index] = 0;
          normals[3 * index + 1] = sign;
          normals[3 * index + 2] = 0;
          uvs[2 * index] = .5;
          uvs[2 * index + 1] = .5;
          ++index;
        }
        centerIndexEnd = index;
        for (var _x6 = 0; _x6 <= radialSegments; ++_x6) {
          var u = _x6 / radialSegments;
          var theta = u * arc;
          var cosTheta = Math.cos(theta);
          var sinTheta = Math.sin(theta);
          positions[3 * index] = radius * sinTheta;
          positions[3 * index + 1] = halfHeight * sign;
          positions[3 * index + 2] = radius * cosTheta;
          normals[3 * index] = 0;
          normals[3 * index + 1] = sign;
          normals[3 * index + 2] = 0;
          uvs[2 * index] = .5 - .5 * sinTheta * sign;
          uvs[2 * index + 1] = .5 + .5 * cosTheta;
          ++index;
        }
        for (var _x7 = 0; _x7 < radialSegments; ++_x7) {
          var c = centerIndexStart + _x7;
          var i = centerIndexEnd + _x7;
          if (top) {
            indices[indexOffset] = i + 1;
            ++indexOffset;
            indices[indexOffset] = c;
            ++indexOffset;
            indices[indexOffset] = i;
            ++indexOffset;
          } else {
            indices[indexOffset] = c;
            ++indexOffset;
            indices[indexOffset] = i + 1;
            ++indexOffset;
            indices[indexOffset] = i;
            ++indexOffset;
          }
        }
      }
    };
    var _vmath = require("../../vmath");
    var _vertexData = require("./vertex-data");
    var _vertexData2 = _interopRequireDefault(_vertexData);
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : {
        default: obj
      };
    }
    var temp1 = _vmath.vec3.create(0, 0, 0);
    var temp2 = _vmath.vec3.create(0, 0, 0);
    module.exports = exports["default"];
  }), {
    "../../vmath": 325,
    "./vertex-data": 43
  } ],
  36: [ (function(require, module, exports) {
    "use strict";
    var _utils = require("./utils");
    var _utils2 = _interopRequireDefault(_utils);
    var _box = require("./box");
    var _box2 = _interopRequireDefault(_box);
    var _cone = require("./cone");
    var _cone2 = _interopRequireDefault(_cone);
    var _cylinder = require("./cylinder");
    var _cylinder2 = _interopRequireDefault(_cylinder);
    var _plane = require("./plane");
    var _plane2 = _interopRequireDefault(_plane);
    var _quad = require("./quad");
    var _quad2 = _interopRequireDefault(_quad);
    var _sphere = require("./sphere");
    var _sphere2 = _interopRequireDefault(_sphere);
    var _torus = require("./torus");
    var _torus2 = _interopRequireDefault(_torus);
    var _capsule = require("./capsule");
    var _capsule2 = _interopRequireDefault(_capsule);
    var _polyhedron = require("./polyhedron");
    var _vertexData = require("./vertex-data");
    var _vertexData2 = _interopRequireDefault(_vertexData);
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : {
        default: obj
      };
    }
    cc.primitive = Object.assign({
      box: _box2.default,
      cone: _cone2.default,
      cylinder: _cylinder2.default,
      plane: _plane2.default,
      quad: _quad2.default,
      sphere: _sphere2.default,
      torus: _torus2.default,
      capsule: _capsule2.default,
      polyhedron: _polyhedron.polyhedron,
      PolyhedronType: _polyhedron.PolyhedronType,
      VertexData: _vertexData2.default
    }, _utils2.default);
  }), {
    "./box": 32,
    "./capsule": 33,
    "./cone": 34,
    "./cylinder": 35,
    "./plane": 37,
    "./polyhedron": 38,
    "./quad": 39,
    "./sphere": 40,
    "./torus": 41,
    "./utils": 42,
    "./vertex-data": 43
  } ],
  37: [ (function(require, module, exports) {
    "use strict";
    exports.__esModule = true;
    exports.default = function() {
      var width = arguments.length > 0 && void 0 !== arguments[0] ? arguments[0] : 10;
      var length = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : 10;
      var opts = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : {};
      var uSegments = void 0 !== opts.widthSegments ? opts.widthSegments : 10;
      var vSegments = void 0 !== opts.lengthSegments ? opts.lengthSegments : 10;
      var hw = .5 * width;
      var hl = .5 * length;
      var positions = [];
      var normals = [];
      var uvs = [];
      var indices = [];
      var minPos = _vmath.vec3.create(-hw, 0, -hl);
      var maxPos = _vmath.vec3.create(hw, 0, hl);
      var boundingRadius = Math.sqrt(width * width + length * length);
      _vmath.vec3.set(c00, -hw, 0, hl);
      _vmath.vec3.set(c10, hw, 0, hl);
      _vmath.vec3.set(c01, -hw, 0, -hl);
      for (var y = 0; y <= vSegments; y++) for (var x = 0; x <= uSegments; x++) {
        var u = x / uSegments;
        var v = y / vSegments;
        _vmath.vec3.lerp(temp1, c00, c10, u);
        _vmath.vec3.lerp(temp2, c00, c01, v);
        _vmath.vec3.sub(temp3, temp2, c00);
        _vmath.vec3.add(r, temp1, temp3);
        positions.push(r.x, r.y, r.z);
        normals.push(0, 1, 0);
        uvs.push(u, v);
        if (x < uSegments && y < vSegments) {
          var useg1 = uSegments + 1;
          var a = x + y * useg1;
          var b = x + (y + 1) * useg1;
          var c = x + 1 + (y + 1) * useg1;
          var d = x + 1 + y * useg1;
          indices.push(a, d, b);
          indices.push(d, c, b);
        }
      }
      return new _vertexData2.default(positions, normals, uvs, indices, minPos, maxPos, boundingRadius);
    };
    var _vmath = require("../../vmath");
    var _vertexData = require("./vertex-data");
    var _vertexData2 = _interopRequireDefault(_vertexData);
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : {
        default: obj
      };
    }
    var temp1 = _vmath.vec3.create(0, 0, 0);
    var temp2 = _vmath.vec3.create(0, 0, 0);
    var temp3 = _vmath.vec3.create(0, 0, 0);
    var r = _vmath.vec3.create(0, 0, 0);
    var c00 = _vmath.vec3.create(0, 0, 0);
    var c10 = _vmath.vec3.create(0, 0, 0);
    var c01 = _vmath.vec3.create(0, 0, 0);
    module.exports = exports["default"];
  }), {
    "../../vmath": 325,
    "./vertex-data": 43
  } ],
  38: [ (function(require, module, exports) {
    "use strict";
    exports.__esModule = true;
    exports.polyhedron = exports.PolyhedronType = void 0;
    var _utils = require("./utils");
    var _vmath = require("../../vmath");
    var _vertexData = require("./vertex-data");
    var _vertexData2 = _interopRequireDefault(_vertexData);
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : {
        default: obj
      };
    }
    var PolyhedronType = exports.PolyhedronType = cc.Enum({
      Tetrahedron: 0,
      Octahedron: 1,
      Dodecahedron: 2,
      Icosahedron: 3,
      Rhombicuboctahedron: 4,
      TriangularPrism: 5,
      PentagonalPrism: 6,
      HexagonalPrism: 7,
      SquarePyramid: 8,
      PentagonalPyramid: 9,
      TriangularDipyramid: 10,
      PentagonalDipyramid: 11,
      ElongatedSquareDipyramid: 12,
      ElongatedPentagonalDipyramid: 13,
      ElongatedPentagonalCupola: 14
    });
    var polyhedra = [];
    polyhedra[0] = {
      vertex: [ [ 0, 0, 1.732051 ], [ 1.632993, 0, -.5773503 ], [ -.8164966, 1.414214, -.5773503 ], [ -.8164966, -1.414214, -.5773503 ] ],
      face: [ [ 0, 1, 2 ], [ 0, 2, 3 ], [ 0, 3, 1 ], [ 1, 3, 2 ] ]
    };
    polyhedra[1] = {
      vertex: [ [ 0, 0, 1.414214 ], [ 1.414214, 0, 0 ], [ 0, 1.414214, 0 ], [ -1.414214, 0, 0 ], [ 0, -1.414214, 0 ], [ 0, 0, -1.414214 ] ],
      face: [ [ 0, 1, 2 ], [ 0, 2, 3 ], [ 0, 3, 4 ], [ 0, 4, 1 ], [ 1, 4, 5 ], [ 1, 5, 2 ], [ 2, 5, 3 ], [ 3, 5, 4 ] ]
    };
    polyhedra[2] = {
      vertex: [ [ 0, 0, 1.070466 ], [ .7136442, 0, .7978784 ], [ -.3568221, .618034, .7978784 ], [ -.3568221, -.618034, .7978784 ], [ .7978784, .618034, .3568221 ], [ .7978784, -.618034, .3568221 ], [ -.9341724, .381966, .3568221 ], [ .1362939, 1, .3568221 ], [ .1362939, -1, .3568221 ], [ -.9341724, -.381966, .3568221 ], [ .9341724, .381966, -.3568221 ], [ .9341724, -.381966, -.3568221 ], [ -.7978784, .618034, -.3568221 ], [ -.1362939, 1, -.3568221 ], [ -.1362939, -1, -.3568221 ], [ -.7978784, -.618034, -.3568221 ], [ .3568221, .618034, -.7978784 ], [ .3568221, -.618034, -.7978784 ], [ -.7136442, 0, -.7978784 ], [ 0, 0, -1.070466 ] ],
      face: [ [ 0, 1, 4, 7, 2 ], [ 0, 2, 6, 9, 3 ], [ 0, 3, 8, 5, 1 ], [ 1, 5, 11, 10, 4 ], [ 2, 7, 13, 12, 6 ], [ 3, 9, 15, 14, 8 ], [ 4, 10, 16, 13, 7 ], [ 5, 8, 14, 17, 11 ], [ 6, 12, 18, 15, 9 ], [ 10, 11, 17, 19, 16 ], [ 12, 13, 16, 19, 18 ], [ 14, 15, 18, 19, 17 ] ]
    };
    polyhedra[3] = {
      vertex: [ [ 0, 0, 1.175571 ], [ 1.051462, 0, .5257311 ], [ .3249197, 1, .5257311 ], [ -.8506508, .618034, .5257311 ], [ -.8506508, -.618034, .5257311 ], [ .3249197, -1, .5257311 ], [ .8506508, .618034, -.5257311 ], [ .8506508, -.618034, -.5257311 ], [ -.3249197, 1, -.5257311 ], [ -1.051462, 0, -.5257311 ], [ -.3249197, -1, -.5257311 ], [ 0, 0, -1.175571 ] ],
      face: [ [ 0, 1, 2 ], [ 0, 2, 3 ], [ 0, 3, 4 ], [ 0, 4, 5 ], [ 0, 5, 1 ], [ 1, 5, 7 ], [ 1, 7, 6 ], [ 1, 6, 2 ], [ 2, 6, 8 ], [ 2, 8, 3 ], [ 3, 8, 9 ], [ 3, 9, 4 ], [ 4, 9, 10 ], [ 4, 10, 5 ], [ 5, 10, 7 ], [ 6, 7, 11 ], [ 6, 11, 8 ], [ 7, 10, 11 ], [ 8, 11, 9 ], [ 9, 11, 10 ] ]
    };
    polyhedra[4] = {
      vertex: [ [ 0, 0, 1.070722 ], [ .7148135, 0, .7971752 ], [ -.104682, .7071068, .7971752 ], [ -.6841528, .2071068, .7971752 ], [ -.104682, -.7071068, .7971752 ], [ .6101315, .7071068, .5236279 ], [ 1.04156, .2071068, .1367736 ], [ .6101315, -.7071068, .5236279 ], [ -.3574067, 1, .1367736 ], [ -.7888348, -.5, .5236279 ], [ -.9368776, .5, .1367736 ], [ -.3574067, -1, .1367736 ], [ .3574067, 1, -.1367736 ], [ .9368776, -.5, -.1367736 ], [ .7888348, .5, -.5236279 ], [ .3574067, -1, -.1367736 ], [ -.6101315, .7071068, -.5236279 ], [ -1.04156, -.2071068, -.1367736 ], [ -.6101315, -.7071068, -.5236279 ], [ .104682, .7071068, -.7971752 ], [ .6841528, -.2071068, -.7971752 ], [ .104682, -.7071068, -.7971752 ], [ -.7148135, 0, -.7971752 ], [ 0, 0, -1.070722 ] ],
      face: [ [ 0, 2, 3 ], [ 1, 6, 5 ], [ 4, 9, 11 ], [ 7, 15, 13 ], [ 8, 16, 10 ], [ 12, 14, 19 ], [ 17, 22, 18 ], [ 20, 21, 23 ], [ 0, 1, 5, 2 ], [ 0, 3, 9, 4 ], [ 0, 4, 7, 1 ], [ 1, 7, 13, 6 ], [ 2, 5, 12, 8 ], [ 2, 8, 10, 3 ], [ 3, 10, 17, 9 ], [ 4, 11, 15, 7 ], [ 5, 6, 14, 12 ], [ 6, 13, 20, 14 ], [ 8, 12, 19, 16 ], [ 9, 17, 18, 11 ], [ 10, 16, 22, 17 ], [ 11, 18, 21, 15 ], [ 13, 15, 21, 20 ], [ 14, 20, 23, 19 ], [ 16, 19, 23, 22 ], [ 18, 22, 23, 21 ] ]
    };
    polyhedra[5] = {
      vertex: [ [ 0, 0, 1.322876 ], [ 1.309307, 0, .1889822 ], [ -.9819805, .8660254, .1889822 ], [ .1636634, -1.299038, .1889822 ], [ .3273268, .8660254, -.9449112 ], [ -.8183171, -.4330127, -.9449112 ] ],
      face: [ [ 0, 3, 1 ], [ 2, 4, 5 ], [ 0, 1, 4, 2 ], [ 0, 2, 5, 3 ], [ 1, 3, 5, 4 ] ]
    };
    polyhedra[6] = {
      vertex: [ [ 0, 0, 1.159953 ], [ 1.013464, 0, .5642542 ], [ -.3501431, .9510565, .5642542 ], [ -.7715208, -.6571639, .5642542 ], [ .6633206, .9510565, -.03144481 ], [ .8682979, -.6571639, -.3996071 ], [ -1.121664, .2938926, -.03144481 ], [ -.2348831, -1.063314, -.3996071 ], [ .5181548, .2938926, -.9953061 ], [ -.5850262, -.112257, -.9953061 ] ],
      face: [ [ 0, 1, 4, 2 ], [ 0, 2, 6, 3 ], [ 1, 5, 8, 4 ], [ 3, 6, 9, 7 ], [ 5, 7, 9, 8 ], [ 0, 3, 7, 5, 1 ], [ 2, 4, 8, 9, 6 ] ]
    };
    polyhedra[7] = {
      vertex: [ [ 0, 0, 1.118034 ], [ .8944272, 0, .6708204 ], [ -.2236068, .8660254, .6708204 ], [ -.7826238, -.4330127, .6708204 ], [ .6708204, .8660254, .2236068 ], [ 1.006231, -.4330127, -.2236068 ], [ -1.006231, .4330127, .2236068 ], [ -.6708204, -.8660254, -.2236068 ], [ .7826238, .4330127, -.6708204 ], [ .2236068, -.8660254, -.6708204 ], [ -.8944272, 0, -.6708204 ], [ 0, 0, -1.118034 ] ],
      face: [ [ 0, 1, 4, 2 ], [ 0, 2, 6, 3 ], [ 1, 5, 8, 4 ], [ 3, 6, 10, 7 ], [ 5, 9, 11, 8 ], [ 7, 10, 11, 9 ], [ 0, 3, 7, 9, 5, 1 ], [ 2, 4, 8, 11, 10, 6 ] ]
    };
    polyhedra[8] = {
      vertex: [ [ -.729665, .670121, .319155 ], [ -.655235, -.29213, -.754096 ], [ -.093922, -.607123, .537818 ], [ .702196, .595691, .485187 ], [ .776626, -.36656, -.588064 ] ],
      face: [ [ 1, 4, 2 ], [ 0, 1, 2 ], [ 3, 0, 2 ], [ 4, 3, 2 ], [ 4, 1, 0, 3 ] ]
    };
    polyhedra[9] = {
      vertex: [ [ -.868849, -.100041, .61257 ], [ -.329458, .976099, .28078 ], [ -.26629, -.013796, -.477654 ], [ -.13392, -1.034115, .229829 ], [ .738834, .707117, -.307018 ], [ .859683, -.535264, -.338508 ] ],
      face: [ [ 3, 0, 2 ], [ 5, 3, 2 ], [ 4, 5, 2 ], [ 1, 4, 2 ], [ 0, 1, 2 ], [ 0, 3, 5, 4, 1 ] ]
    };
    polyhedra[10] = {
      vertex: [ [ -.610389, .243975, .531213 ], [ -.187812, -.48795, -.664016 ], [ -.187812, .9759, -.664016 ], [ .187812, -.9759, .664016 ], [ .798201, .243975, .132803 ] ],
      face: [ [ 1, 3, 0 ], [ 3, 4, 0 ], [ 3, 1, 4 ], [ 0, 2, 1 ], [ 0, 4, 2 ], [ 2, 4, 1 ] ]
    };
    polyhedra[11] = {
      vertex: [ [ -1.028778, .392027, -.048786 ], [ -.640503, -.646161, .621837 ], [ -.125162, -.395663, -.540059 ], [ .004683, .888447, -.651988 ], [ .125161, .395663, .540059 ], [ .632925, -.791376, .433102 ], [ 1.031672, .157063, -.354165 ] ],
      face: [ [ 3, 2, 0 ], [ 2, 1, 0 ], [ 2, 5, 1 ], [ 0, 4, 3 ], [ 0, 1, 4 ], [ 4, 1, 5 ], [ 2, 3, 6 ], [ 3, 4, 6 ], [ 5, 2, 6 ], [ 4, 5, 6 ] ]
    };
    polyhedra[12] = {
      vertex: [ [ -.669867, .334933, -.529576 ], [ -.669867, .334933, .529577 ], [ -.4043, 1.212901, 0 ], [ -.334933, -.669867, -.529576 ], [ -.334933, -.669867, .529577 ], [ .334933, .669867, -.529576 ], [ .334933, .669867, .529577 ], [ .4043, -1.212901, 0 ], [ .669867, -.334933, -.529576 ], [ .669867, -.334933, .529577 ] ],
      face: [ [ 8, 9, 7 ], [ 6, 5, 2 ], [ 3, 8, 7 ], [ 5, 0, 2 ], [ 4, 3, 7 ], [ 0, 1, 2 ], [ 9, 4, 7 ], [ 1, 6, 2 ], [ 9, 8, 5, 6 ], [ 8, 3, 0, 5 ], [ 3, 4, 1, 0 ], [ 4, 9, 6, 1 ] ]
    };
    polyhedra[13] = {
      vertex: [ [ -.931836, .219976, -.264632 ], [ -.636706, .318353, .692816 ], [ -.613483, -.735083, -.264632 ], [ -.326545, .979634, 0 ], [ -.318353, -.636706, .692816 ], [ -.159176, .477529, -.856368 ], [ .159176, -.477529, -.856368 ], [ .318353, .636706, .692816 ], [ .326545, -.979634, 0 ], [ .613482, .735082, -.264632 ], [ .636706, -.318353, .692816 ], [ .931835, -.219977, -.264632 ] ],
      face: [ [ 11, 10, 8 ], [ 7, 9, 3 ], [ 6, 11, 8 ], [ 9, 5, 3 ], [ 2, 6, 8 ], [ 5, 0, 3 ], [ 4, 2, 8 ], [ 0, 1, 3 ], [ 10, 4, 8 ], [ 1, 7, 3 ], [ 10, 11, 9, 7 ], [ 11, 6, 5, 9 ], [ 6, 2, 0, 5 ], [ 2, 4, 1, 0 ], [ 4, 10, 7, 1 ] ]
    };
    polyhedra[14] = {
      vertex: [ [ -.93465, .300459, -.271185 ], [ -.838689, -.260219, -.516017 ], [ -.711319, .717591, .128359 ], [ -.710334, -.156922, .080946 ], [ -.599799, .556003, -.725148 ], [ -.503838, -.004675, -.969981 ], [ -.487004, .26021, .48049 ], [ -.460089, -.750282, -.512622 ], [ -.376468, .973135, -.325605 ], [ -.331735, -.646985, .084342 ], [ -.254001, .831847, .530001 ], [ -.125239, -.494738, -.966586 ], [ .029622, .027949, .730817 ], [ .056536, -.982543, -.262295 ], [ .08085, 1.087391, .076037 ], [ .125583, -.532729, .485984 ], [ .262625, .599586, .780328 ], [ .391387, -.726999, -.716259 ], [ .513854, -.868287, .139347 ], [ .597475, .85513, .326364 ], [ .641224, .109523, .783723 ], [ .737185, -.451155, .538891 ], [ .848705, -.612742, -.314616 ], [ .976075, .365067, .32976 ], [ 1.072036, -.19561, .084927 ] ],
      face: [ [ 15, 18, 21 ], [ 12, 20, 16 ], [ 6, 10, 2 ], [ 3, 0, 1 ], [ 9, 7, 13 ], [ 2, 8, 4, 0 ], [ 0, 4, 5, 1 ], [ 1, 5, 11, 7 ], [ 7, 11, 17, 13 ], [ 13, 17, 22, 18 ], [ 18, 22, 24, 21 ], [ 21, 24, 23, 20 ], [ 20, 23, 19, 16 ], [ 16, 19, 14, 10 ], [ 10, 14, 8, 2 ], [ 15, 9, 13, 18 ], [ 12, 15, 21, 20 ], [ 6, 12, 16, 10 ], [ 3, 6, 2, 0 ], [ 9, 3, 1, 7 ], [ 9, 15, 12, 6, 3 ], [ 22, 17, 11, 5, 4, 8, 14, 19, 23, 24 ] ]
    };
    var polyhedron = exports.polyhedron = function polyhedron(type) {
      var size = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : 1;
      var opts = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : {};
      type = type && (type < 0 || type >= polyhedra.length) ? 0 : type || 0;
      var sizeX = opts.sizeX || size;
      var sizeY = opts.sizeY || size;
      var sizeZ = opts.sizeZ || size;
      var data = polyhedra[type];
      var nbfaces = data.face.length;
      var positions = [];
      var indices = [];
      var normals = [];
      var uvs = [];
      var minPos = _vmath.vec3.create(Infinity, Infinity, Infinity);
      var maxPos = _vmath.vec3.create(-Infinity, -Infinity, -Infinity);
      for (var i = 0; i < data.vertex.length; i++) {
        var x = data.vertex[i][0] * sizeX;
        var y = data.vertex[i][1] * sizeY;
        var z = data.vertex[i][2] * sizeZ;
        minPos.x = Math.min(minPos.x, x);
        minPos.y = Math.min(minPos.y, y);
        minPos.z = Math.min(minPos.z, z);
        maxPos.x = Math.max(maxPos.x, x);
        maxPos.y = Math.max(maxPos.y, y);
        maxPos.z = Math.max(maxPos.z, z);
        positions.push(x, y, z);
        uvs.push(0, 0);
      }
      for (var f = 0; f < nbfaces; f++) for (var _i = 0; _i < data.face[f].length - 2; _i++) indices.push(data.face[f][0], data.face[f][_i + 2], data.face[f][_i + 1]);
      (0, _utils.calcNormals)(positions, indices, normals);
      var boundingRadius = Math.sqrt(Math.pow(maxPos.x - minPos.x, 2), Math.pow(maxPos.y - minPos.y, 2), Math.pow(maxPos.z - minPos.z, 2));
      return new _vertexData2.default(positions, normals, uvs, indices, minPos, maxPos, boundingRadius);
    };
  }), {
    "../../vmath": 325,
    "./utils": 42,
    "./vertex-data": 43
  } ],
  39: [ (function(require, module, exports) {
    "use strict";
    exports.__esModule = true;
    exports.default = function() {
      return new _vertexData2.default(positions, normals, uvs, indices, minPos, maxPos, boundingRadius);
    };
    var _vmath = require("../../vmath");
    var _vertexData = require("./vertex-data");
    var _vertexData2 = _interopRequireDefault(_vertexData);
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : {
        default: obj
      };
    }
    var positions = [ -.5, -.5, 0, -.5, .5, 0, .5, .5, 0, .5, -.5, 0 ];
    var normals = [ 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 1 ];
    var uvs = [ 0, 0, 0, 1, 1, 1, 1, 0 ];
    var indices = [ 0, 3, 1, 3, 2, 1 ];
    var minPos = _vmath.vec3.create(-.5, -.5, 0);
    var maxPos = _vmath.vec3.create(.5, .5, 0);
    var boundingRadius = Math.sqrt(.5);
    module.exports = exports["default"];
  }), {
    "../../vmath": 325,
    "./vertex-data": 43
  } ],
  40: [ (function(require, module, exports) {
    "use strict";
    exports.__esModule = true;
    exports.default = function() {
      var radius = arguments.length > 0 && void 0 !== arguments[0] ? arguments[0] : .5;
      var opts = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : {};
      var segments = void 0 !== opts.segments ? opts.segments : 32;
      var positions = [];
      var normals = [];
      var uvs = [];
      var indices = [];
      var minPos = _vmath.vec3.create(-radius, -radius, -radius);
      var maxPos = _vmath.vec3.create(radius, radius, radius);
      var boundingRadius = radius;
      for (var lat = 0; lat <= segments; ++lat) {
        var theta = lat * Math.PI / segments;
        var sinTheta = Math.sin(theta);
        var cosTheta = -Math.cos(theta);
        for (var lon = 0; lon <= segments; ++lon) {
          var phi = 2 * lon * Math.PI / segments - Math.PI / 2;
          var sinPhi = Math.sin(phi);
          var cosPhi = Math.cos(phi);
          var x = sinPhi * sinTheta;
          var y = cosTheta;
          var z = cosPhi * sinTheta;
          var u = lon / segments;
          var v = lat / segments;
          positions.push(x * radius, y * radius, z * radius);
          normals.push(x, y, z);
          uvs.push(u, v);
          if (lat < segments && lon < segments) {
            var seg1 = segments + 1;
            var a = seg1 * lat + lon;
            var b = seg1 * (lat + 1) + lon;
            var c = seg1 * (lat + 1) + lon + 1;
            var d = seg1 * lat + lon + 1;
            indices.push(a, d, b);
            indices.push(d, c, b);
          }
        }
      }
      return new _vertexData2.default(positions, normals, uvs, indices, minPos, maxPos, boundingRadius);
    };
    var _vmath = require("../../vmath");
    var _vertexData = require("./vertex-data");
    var _vertexData2 = _interopRequireDefault(_vertexData);
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : {
        default: obj
      };
    }
    module.exports = exports["default"];
  }), {
    "../../vmath": 325,
    "./vertex-data": 43
  } ],
  41: [ (function(require, module, exports) {
    "use strict";
    exports.__esModule = true;
    exports.default = function() {
      var radius = arguments.length > 0 && void 0 !== arguments[0] ? arguments[0] : .4;
      var tube = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : .1;
      var opts = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : {};
      var radialSegments = opts.radialSegments || 32;
      var tubularSegments = opts.tubularSegments || 32;
      var arc = opts.arc || 2 * Math.PI;
      var positions = [];
      var normals = [];
      var uvs = [];
      var indices = [];
      var minPos = _vmath.vec3.create(-radius - tube, -tube, -radius - tube);
      var maxPos = _vmath.vec3.create(radius + tube, tube, radius + tube);
      var boundingRadius = radius + tube;
      for (var j = 0; j <= radialSegments; j++) for (var i = 0; i <= tubularSegments; i++) {
        var u = i / tubularSegments;
        var v = j / radialSegments;
        var u1 = u * arc;
        var v1 = v * Math.PI * 2;
        var x = (radius + tube * Math.cos(v1)) * Math.sin(u1);
        var y = tube * Math.sin(v1);
        var z = (radius + tube * Math.cos(v1)) * Math.cos(u1);
        var nx = Math.sin(u1) * Math.cos(v1);
        var ny = Math.sin(v1);
        var nz = Math.cos(u1) * Math.cos(v1);
        positions.push(x, y, z);
        normals.push(nx, ny, nz);
        uvs.push(u, v);
        if (i < tubularSegments && j < radialSegments) {
          var seg1 = tubularSegments + 1;
          var a = seg1 * j + i;
          var b = seg1 * (j + 1) + i;
          var c = seg1 * (j + 1) + i + 1;
          var d = seg1 * j + i + 1;
          indices.push(a, d, b);
          indices.push(d, c, b);
        }
      }
      return new _vertexData2.default(positions, normals, uvs, indices, minPos, maxPos, boundingRadius);
    };
    var _vmath = require("../../vmath");
    var _vertexData = require("./vertex-data");
    var _vertexData2 = _interopRequireDefault(_vertexData);
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : {
        default: obj
      };
    }
    module.exports = exports["default"];
  }), {
    "../../vmath": 325,
    "./vertex-data": 43
  } ],
  42: [ (function(require, module, exports) {
    "use strict";
    exports.__esModule = true;
    exports.wireframe = wireframe;
    exports.invWinding = invWinding;
    exports.toWavefrontOBJ = toWavefrontOBJ;
    exports.normals = normals;
    exports.calcNormals = calcNormals;
    var _vmath = require("../../vmath");
    function wireframe(indices) {
      var offsets = [ [ 0, 1 ], [ 1, 2 ], [ 2, 0 ] ];
      var lines = [];
      var lineIDs = {};
      for (var i = 0; i < indices.length; i += 3) for (var k = 0; k < 3; ++k) {
        var i1 = indices[i + offsets[k][0]];
        var i2 = indices[i + offsets[k][1]];
        var id = i1 > i2 ? i2 << 16 | i1 : i1 << 16 | i2;
        if (void 0 === lineIDs[id]) {
          lineIDs[id] = 0;
          lines.push(i1, i2);
        }
      }
      return lines;
    }
    function invWinding(indices) {
      var newIB = [];
      for (var i = 0; i < indices.length; i += 3) newIB.push(indices[i], indices[i + 2], indices[i + 1]);
      return newIB;
    }
    function toWavefrontOBJ(primitive) {
      var scale = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : 1;
      var v = primitive.positions, t = primitive.uvs, n = primitive.normals, IB = primitive.indices;
      var V = function V(i) {
        return IB[i] + 1 + "/" + (IB[i] + 1) + "/" + (IB[i] + 1);
      };
      var content = "";
      for (var i = 0; i < v.length; i += 3) content += "v " + v[i] * scale + " " + v[i + 1] * scale + " " + v[i + 2] * scale + "\n";
      for (var _i = 0; _i < t.length; _i += 2) content += "vt " + t[_i] + " " + t[_i + 1] + "\n";
      for (var _i2 = 0; _i2 < n.length; _i2 += 3) content += "vn " + n[_i2] + " " + n[_i2 + 1] + " " + n[_i2 + 2] + "\n";
      for (var _i3 = 0; _i3 < IB.length; _i3 += 3) content += "f " + V(_i3) + " " + V(_i3 + 1) + " " + V(_i3 + 2) + "\n";
      return content;
    }
    function normals(positions, normals) {
      var length = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : 1;
      var verts = new Array(2 * positions.length);
      for (var i = 0; i < positions.length / 3; ++i) {
        var i3 = 3 * i;
        var i6 = 6 * i;
        verts[i6 + 0] = positions[i3 + 0];
        verts[i6 + 1] = positions[i3 + 1];
        verts[i6 + 2] = positions[i3 + 2];
        verts[i6 + 3] = positions[i3 + 0] + normals[i3 + 0] * length;
        verts[i6 + 4] = positions[i3 + 1] + normals[i3 + 1] * length;
        verts[i6 + 5] = positions[i3 + 2] + normals[i3 + 2] * length;
      }
      return verts;
    }
    function fromArray(out, a, offset) {
      out.x = a[offset];
      out.y = a[offset + 1];
      out.z = a[offset + 2];
    }
    function calcNormals(positions, indices, normals) {
      normals = normals || new Array(positions.length);
      for (var i = 0, l = normals.length; i < l; i++) normals[i] = 0;
      var vA = void 0, vB = void 0, vC = void 0;
      var pA = cc.v3(), pB = cc.v3(), pC = cc.v3();
      var cb = cc.v3(), ab = cc.v3();
      for (var _i4 = 0, il = indices.length; _i4 < il; _i4 += 3) {
        vA = 3 * indices[_i4 + 0];
        vB = 3 * indices[_i4 + 1];
        vC = 3 * indices[_i4 + 2];
        fromArray(pA, positions, vA);
        fromArray(pB, positions, vB);
        fromArray(pC, positions, vC);
        _vmath.vec3.sub(cb, pC, pB);
        _vmath.vec3.sub(ab, pA, pB);
        _vmath.vec3.cross(cb, cb, ab);
        normals[vA] += cb.x;
        normals[vA + 1] += cb.y;
        normals[vA + 2] += cb.z;
        normals[vB] += cb.x;
        normals[vB + 1] += cb.y;
        normals[vB + 2] += cb.z;
        normals[vC] += cb.x;
        normals[vC + 1] += cb.y;
        normals[vC + 2] += cb.z;
      }
      var tempNormal = cc.v3();
      for (var _i5 = 0, _l = normals.length; _i5 < _l; _i5 += 3) {
        tempNormal.x = normals[_i5];
        tempNormal.y = normals[_i5 + 1];
        tempNormal.z = normals[_i5 + 2];
        tempNormal.normalizeSelf();
        normals[_i5] = tempNormal.x;
        normals[_i5 + 1] = tempNormal.y;
        normals[_i5 + 2] = tempNormal.z;
      }
      return normals;
    }
  }), {
    "../../vmath": 325
  } ],
  43: [ (function(require, module, exports) {
    "use strict";
    exports.__esModule = true;
    exports.default = VertexData;
    function VertexData(positions, normals, uvs, indices, minPos, maxPos, boundingRadius) {
      this.positions = positions;
      this.normals = normals;
      this.uvs = uvs;
      this.indices = indices;
      this.minPos = minPos;
      this.maxPos = maxPos;
      this.boundingRadius = boundingRadius;
    }
    module.exports = exports["default"];
  }), {} ],
  44: [ (function(require, module, exports) {
    "use strict";
    var _require = require("../../../animation/animation-curves"), DynamicAnimCurve = _require.DynamicAnimCurve, quickFindIndex = _require.quickFindIndex;
    var JointMatrixCurve = cc.Class({
      name: "cc.JointMatrixCurve",
      extends: DynamicAnimCurve,
      _findFrameIndex: quickFindIndex,
      sample: function sample(time, ratio) {
        var ratios = this.ratios;
        var index = this._findFrameIndex(ratios, ratio);
        index < -1 && (index = ~index - 1);
        var pairs = this.pairs;
        for (var i = 0; i < pairs.length; i++) {
          var pair = pairs[i];
          pair.target._jointMatrix = pair.values[index];
        }
      }
    });
    module.exports = JointMatrixCurve;
  }), {
    "../../../animation/animation-curves": 12
  } ],
  45: [ (function(require, module, exports) {
    "use strict";
    var Skeleton = cc.Class({
      name: "cc.Skeleton",
      extends: cc.Asset,
      ctor: function ctor() {
        this._bindposes = [];
        this._uniqueBindPoses = [];
        this._jointPaths = [];
      },
      properties: {
        _model: cc.Model,
        _jointIndices: [],
        _skinIndex: -1,
        jointPaths: {
          get: function get() {
            return this._jointPaths;
          }
        },
        bindposes: {
          get: function get() {
            return this._bindposes;
          }
        },
        uniqueBindPoses: {
          get: function get() {
            return this._uniqueBindPoses;
          }
        },
        model: {
          get: function get() {
            return this._model;
          }
        }
      },
      onLoad: function onLoad() {
        var nodes = this._model.nodes;
        var jointIndices = this._jointIndices;
        var jointPaths = this._jointPaths;
        var bindposes = this._bindposes;
        var uniqueBindPoses = this._uniqueBindPoses;
        for (var i = 0; i < jointIndices.length; i++) {
          var node = nodes[jointIndices[i]];
          jointPaths[i] = node.path;
          node.uniqueBindPose ? bindposes[i] = uniqueBindPoses[i] = node.uniqueBindPose : bindposes[i] = node.bindpose[this._skinIndex];
        }
      }
    });
    cc.Skeleton = module.exports = Skeleton;
  }), {} ],
  46: [ (function(require, module, exports) {
    "use strict";
    var Animation = require("../../components/CCAnimation");
    var Model = require("../CCModel");
    var SkeletonAnimationClip = require("./CCSkeletonAnimationClip");
    var SkeletonAnimation = cc.Class({
      name: "cc.SkeletonAnimation",
      extends: Animation,
      editor: false,
      properties: {
        _model: {
          default: null,
          type: Model
        },
        _defaultClip: {
          override: true,
          default: null,
          type: SkeletonAnimationClip
        },
        _clips: {
          override: true,
          default: [],
          type: [ SkeletonAnimationClip ],
          visible: true
        },
        defaultClip: {
          override: true,
          get: function get() {
            return this._defaultClip;
          },
          set: function set(v) {
            this._defaultClip = v;
          },
          type: SkeletonAnimationClip
        },
        model: {
          get: function get() {
            return this._model;
          },
          set: function set(val) {
            this._model = val;
            this._updateClipModel();
          },
          type: Model
        }
      },
      __preload: function __preload() {
        this._updateClipModel();
      },
      _updateClipModel: function _updateClipModel() {
        this._defaultClip && (this._defaultClip._model = this._model);
        var clips = this._clips;
        for (var i = 0; i < clips.length; i++) clips[i]._model = this._model;
      },
      addClip: function addClip(clip, newName) {
        clip._model = this._model;
        return Animation.prototype.addClip.call(this, clip, newName);
      },
      searchClips: false
    });
    cc.SkeletonAnimation = module.exports = SkeletonAnimation;
  }), {
    "../../components/CCAnimation": 91,
    "../CCModel": 28,
    "./CCSkeletonAnimationClip": 47,
    "fire-path": void 0
  } ],
  47: [ (function(require, module, exports) {
    "use strict";
    var _mat = require("../../vmath/mat4");
    var _mat2 = _interopRequireDefault(_mat);
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : {
        default: obj
      };
    }
    var AnimationClip = require("../../../animation/animation-clip");
    var JointMatrixCurve = require("./CCJointMatrixCurve");
    function maxtrixToArray(matrix) {
      var data = new Float32Array(16);
      data.set(matrix.m);
      return data;
    }
    var SkeletonAnimationClip = cc.Class({
      name: "cc.SkeletonAnimationClip",
      extends: AnimationClip,
      properties: {
        _nativeAsset: {
          override: true,
          get: function get() {
            return this._buffer;
          },
          set: function set(bin) {
            var buffer = ArrayBuffer.isView(bin) ? bin.buffer : bin;
            this._buffer = new Float32Array(buffer || bin, 0, buffer.byteLength / 4);
          }
        },
        description: {
          default: null,
          type: Object
        },
        curveData: {
          visible: false,
          override: true,
          get: function get() {
            return this._curveData || {};
          },
          set: function set() {}
        }
      },
      statics: {
        preventDeferredLoadDependents: true
      },
      _init: function _init() {
        if (this._curveData) return this._curveData;
        this._curveData = {};
        this._generateCommonCurve();
        this._model.precomputeJointMatrix && this._generateJointMatrixCurve();
        return this._curveData;
      },
      _generateCommonCurve: function _generateCommonCurve() {
        var buffer = this._buffer;
        var description = this.description;
        var offset = 0;
        function getValue() {
          return buffer[offset++];
        }
        this._curveData.paths || (this._curveData.paths = {});
        var paths = this._curveData.paths;
        for (var path in description) {
          var des = description[path];
          var curves = {};
          paths[path] = {
            props: curves
          };
          for (var property in des) {
            var frames = [];
            var frameCount = des[property].frameCount;
            offset = des[property].offset;
            for (var i = 0; i < frameCount; i++) {
              var frame = getValue();
              var value = void 0;
              "position" === property || "scale" === property ? value = cc.v3(getValue(), getValue(), getValue()) : "quat" === property && (value = cc.quat(getValue(), getValue(), getValue(), getValue()));
              frames.push({
                frame: frame,
                value: value
              });
            }
            curves[property] = frames;
          }
        }
      },
      _generateJointMatrixCurve: function _generateJointMatrixCurve() {
        var rootNode = this._model.rootNode;
        var curveData = this._curveData;
        var paths = curveData.paths;
        var newCurveData = {
          ratios: [],
          jointMatrixMap: {}
        };
        var jointMatrixMap = newCurveData.jointMatrixMap;
        function walk(node, time, pm) {
          var matrix = void 0;
          var EPSILON = 1e-4;
          var path = paths[node.path];
          if (node !== rootNode && path) {
            var props = path.props;
            for (var prop in props) {
              var frames = props[prop];
              for (var i = 0; i < frames.length; i++) {
                var end = frames[i];
                if (Math.abs(end.frame - time) < EPSILON) {
                  node[prop].set(end.value);
                  break;
                }
                if (end.frame > time) {
                  var start = frames[i - 1];
                  var ratio = (time - start.frame) / (end.frame - start.frame);
                  start.value.lerp(end.value, ratio, node[prop]);
                  break;
                }
              }
            }
            matrix = _mat2.default.create();
            _mat2.default.fromRTS(matrix, node.quat, node.position, node.scale);
            pm && _mat2.default.mul(matrix, pm, matrix);
            props._jointMatrix || (props._jointMatrix = []);
            var bindWorldMatrix = void 0;
            if (node.uniqueBindPose) {
              bindWorldMatrix = _mat2.default.create();
              _mat2.default.mul(bindWorldMatrix, matrix, node.uniqueBindPose);
            }
            jointMatrixMap[node.path] || (jointMatrixMap[node.path] = []);
            bindWorldMatrix ? jointMatrixMap[node.path].push(maxtrixToArray(bindWorldMatrix)) : jointMatrixMap[node.path].push(matrix);
          }
          var children = node.children;
          for (var name in children) {
            var child = children[name];
            walk(child, time, matrix);
          }
        }
        var time = 0;
        var duration = this.duration;
        var step = 1 / this.sample;
        while (time < duration) {
          newCurveData.ratios.push(time / duration);
          walk(rootNode, time);
          time += step;
        }
        this._curveData = newCurveData;
      },
      _createJointMatrixCurve: function _createJointMatrixCurve(state, root) {
        var curve = new JointMatrixCurve();
        curve.ratios = this.curveData.ratios;
        curve.pairs = [];
        var jointMatrixMap = this.curveData.jointMatrixMap;
        for (var path in jointMatrixMap) {
          var target = cc.find(path, root);
          if (!target) continue;
          curve.pairs.push({
            target: target,
            values: jointMatrixMap[path]
          });
        }
        return [ curve ];
      },
      createCurves: function createCurves(state, root) {
        if (!this._model) {
          cc.warn("Skeleton Animation Clip [" + this.name + "] Can not find model");
          return [];
        }
        this._init();
        return this._model.precomputeJointMatrix ? this._createJointMatrixCurve(state, root) : AnimationClip.prototype.createCurves.call(this, state, root);
      }
    });
    cc.SkeletonAnimationClip = module.exports = SkeletonAnimationClip;
  }), {
    "../../../animation/animation-clip": 11,
    "../../vmath/mat4": 329,
    "./CCJointMatrixCurve": 44
  } ],
  48: [ (function(require, module, exports) {
    "use strict";
    var Skeleton = require("./CCSkeleton");
    var MeshRenderer = require("../../mesh/CCMeshRenderer");
    var RenderFlow = require("../../renderer/render-flow");
    var enums = require("../../../renderer/enums");
    var mat4 = cc.vmath.mat4;
    var _m4_tmp = mat4.create();
    var _m4_tmp2 = mat4.create();
    var SkinnedMeshRenderer = cc.Class({
      name: "cc.SkinnedMeshRenderer",
      extends: MeshRenderer,
      editor: false,
      ctor: function ctor() {
        this._jointsData = this._jointsFloat32Data = null;
        this._jointsTexture = null;
        this._joints = [];
        this._dummyNode = new cc.Node();
        this._jointsTextureOptions = null;
        this._usingRGBA8Texture = false;
      },
      properties: {
        _skeleton: Skeleton,
        _rootBone: cc.Node,
        skeleton: {
          get: function get() {
            return this._skeleton;
          },
          set: function set(val) {
            this._skeleton = val;
            this._init();
            this._activateMaterial(true);
          },
          type: Skeleton
        },
        rootBone: {
          get: function get() {
            return this._rootBone;
          },
          set: function set(val) {
            this._rootBone = val;
            this._init();
          },
          type: cc.Node
        },
        enableAutoBatch: {
          get: function get() {
            return false;
          },
          visible: false,
          override: true
        }
      },
      _activateMaterial: function _activateMaterial(force) {
        if (!this._jointsData) {
          this.disableRender();
          return;
        }
        this._super(force);
      },
      __preload: function __preload() {
        this._resetAssembler();
        this._init();
      },
      _init: function _init() {
        this._model = this._skeleton && this._skeleton.model;
        this._calFunc = null;
        this._initJoints();
        this._initJointsTexture();
        this._initCalcFunc();
        this._updateRenderNode();
      },
      _calcWorldMatrixToRoot: function _calcWorldMatrixToRoot(joint) {
        var worldMatrixToRoot = joint._worldMatrixToRoot;
        if (worldMatrixToRoot) return;
        joint._worldMatrixToRoot = worldMatrixToRoot = cc.mat4();
        joint.getLocalMatrix(worldMatrixToRoot);
        var parent = joint.parent;
        if (parent !== this.rootBone) {
          parent._worldMatrixToRoot || this._calcWorldMatrixToRoot(parent);
          mat4.mul(worldMatrixToRoot, parent._worldMatrixToRoot, worldMatrixToRoot);
        }
      },
      _initJoints: function _initJoints() {
        var joints = this._joints;
        joints.length = 0;
        if (!this.skeleton || !this.rootBone) return;
        var useJointMatrix = this._useJointMatrix();
        var jointPaths = this.skeleton.jointPaths;
        var rootBone = this.rootBone;
        for (var i = 0; i < jointPaths.length; i++) {
          var joint = cc.find(jointPaths[i], rootBone);
          joint || cc.warn("Can not find joint in root bone [%s] with path [%s]", rootBone.name, jointPaths[i]);
          if (useJointMatrix) {
            joint._renderFlag &= ~RenderFlow.FLAG_CHILDREN;
            this._calcWorldMatrixToRoot(joint);
          }
          joints.push(joint);
        }
        if (useJointMatrix) {
          var uniqueBindPoses = this.skeleton.uniqueBindPoses;
          for (var _i = 0; _i < jointPaths.length; _i++) {
            var _joint = joints[_i];
            if (uniqueBindPoses[_i]) {
              mat4.mul(_m4_tmp, _joint._worldMatrixToRoot, uniqueBindPoses[_i]);
              _joint._jointMatrix = mat4.array([], _m4_tmp);
            } else _joint._jointMatrix = _joint._worldMatrixToRoot;
          }
        }
      },
      _initJointsTexture: function _initJointsTexture() {
        if (!this._skeleton) return;
        var jointCount = this._joints.length;
        var customProperties = this._customProperties;
        var inited = false;
        if (jointCount <= cc.sys.getMaxJointMatrixSize()) {
          inited = true;
          this._jointsData = this._jointsFloat32Data = new Float32Array(16 * jointCount);
          customProperties.setProperty("cc_jointMatrices", this._jointsFloat32Data, enums.PARAM_FLOAT4, true);
          customProperties.define("CC_USE_JOINTS_TEXTRUE", false);
        }
        if (!inited) {
          var SUPPORT_FLOAT_TEXTURE = !!cc.sys.glExtension("OES_texture_float");
          var size = void 0;
          size = jointCount > 256 ? 64 : jointCount > 64 ? 32 : jointCount > 16 ? 16 : 8;
          this._jointsData = this._jointsFloat32Data = new Float32Array(size * size * 4);
          var pixelFormat = cc.Texture2D.PixelFormat.RGBA32F, width = size, height = size;
          if (!SUPPORT_FLOAT_TEXTURE) {
            this._jointsData = new Uint8Array(this._jointsFloat32Data.buffer);
            pixelFormat = cc.Texture2D.PixelFormat.RGBA8888;
            width *= 4;
            this._usingRGBA8Texture = true;
            cc.warn("SkinnedMeshRenderer [" + this.node.name + "] has too many joints [" + jointCount + "] and device do not support float32 texture, fallback to use RGBA8888 texture, which is much slower.");
          }
          var texture = this._jointsTexture || new cc.Texture2D();
          var NEAREST = cc.Texture2D.Filter.NEAREST;
          texture.setFilters(NEAREST, NEAREST);
          texture.initWithData(this._jointsData, pixelFormat, width, height);
          this._jointsTexture = texture;
          this._jointsTextureOptions = {
            format: pixelFormat,
            width: texture.width,
            height: texture.height,
            images: []
          };
          customProperties.setProperty("cc_jointsTexture", texture.getImpl(), enums.PARAM_TEXTURE_2D);
          customProperties.setProperty("cc_jointsTextureSize", new Float32Array([ width, height ]), enums.PARAM_FLOAT2);
          customProperties.define("CC_JOINTS_TEXTURE_FLOAT32", SUPPORT_FLOAT_TEXTURE);
          customProperties.define("CC_USE_JOINTS_TEXTRUE", true);
        }
        customProperties.define("CC_USE_SKINNING", true);
      },
      _setJointsDataWithArray: function _setJointsDataWithArray(iMatrix, matrixArray) {
        var data = this._jointsFloat32Data;
        data.set(matrixArray, 16 * iMatrix);
      },
      _setJointsDataWithMatrix: function _setJointsDataWithMatrix(iMatrix, matrix) {
        this._jointsFloat32Data.set(matrix.m, 16 * iMatrix);
      },
      _commitJointsData: function _commitJointsData() {
        if (this._jointsTexture) {
          this._jointsTextureOptions.images[0] = this._jointsData;
          this._jointsTexture.update(this._jointsTextureOptions);
        }
      },
      _useJointMatrix: function _useJointMatrix() {
        return this._model && this._model.precomputeJointMatrix;
      },
      _updateRenderNode: function _updateRenderNode() {
        this._useJointMatrix() || this._usingRGBA8Texture ? this._assembler.setRenderNode(this.rootBone) : this._assembler.setRenderNode(this._dummyNode);
      },
      _initCalcFunc: function _initCalcFunc() {
        this._useJointMatrix() ? this._calFunc = this._calJointMatrix : this._usingRGBA8Texture ? this._calFunc = this._calRGBA8WorldMatrix : this._calFunc = this._calWorldMatrix;
      },
      _calJointMatrix: function _calJointMatrix() {
        var joints = this._joints;
        var bindposes = this.skeleton.bindposes;
        var uniqueBindPoses = this.skeleton.uniqueBindPoses;
        for (var i = 0; i < joints.length; ++i) {
          var joint = joints[i];
          var jointMatrix = joint._jointMatrix;
          if (uniqueBindPoses[i]) this._setJointsDataWithArray(i, jointMatrix); else {
            mat4.multiply(_m4_tmp, jointMatrix, bindposes[i]);
            this._setJointsDataWithMatrix(i, _m4_tmp);
          }
        }
      },
      _calRGBA8WorldMatrix: function _calRGBA8WorldMatrix() {
        var joints = this._joints;
        var bindposes = this.skeleton.bindposes;
        this.rootBone._updateWorldMatrix();
        var rootMatrix = this.rootBone._worldMatrix;
        var invRootMat = mat4.invert(_m4_tmp2, rootMatrix);
        for (var i = 0; i < joints.length; ++i) {
          var joint = joints[i];
          joint._updateWorldMatrix();
          mat4.multiply(_m4_tmp, invRootMat, joint._worldMatrix);
          mat4.multiply(_m4_tmp, _m4_tmp, bindposes[i]);
          this._setJointsDataWithMatrix(i, _m4_tmp);
        }
      },
      _calWorldMatrix: function _calWorldMatrix() {
        var joints = this._joints;
        var bindposes = this.skeleton.bindposes;
        for (var i = 0; i < joints.length; ++i) {
          var joint = joints[i];
          joint._updateWorldMatrix();
          mat4.multiply(_m4_tmp, joint._worldMatrix, bindposes[i]);
          this._setJointsDataWithMatrix(i, _m4_tmp);
        }
      },
      calcJointMatrix: function calcJointMatrix() {
        if (!this.skeleton || !this.rootBone) return;
        this._calFunc.call(this);
        this._commitJointsData();
      }
    });
    cc.SkinnedMeshRenderer = module.exports = SkinnedMeshRenderer;
  }), {
    "../../../renderer/enums": 351,
    "../../mesh/CCMeshRenderer": 167,
    "../../renderer/render-flow": 249,
    "./CCSkeleton": 45
  } ],
  49: [ (function(require, module, exports) {
    "use strict";
    exports.__esModule = true;
    function _classCallCheck(instance, Constructor) {
      if (!(instance instanceof Constructor)) throw new TypeError("Cannot call a class as a function");
    }
    function _possibleConstructorReturn(self, call) {
      if (!self) throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
      return !call || "object" !== typeof call && "function" !== typeof call ? self : call;
    }
    function _inherits(subClass, superClass) {
      if ("function" !== typeof superClass && null !== superClass) throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
      subClass.prototype = Object.create(superClass && superClass.prototype, {
        constructor: {
          value: subClass,
          enumerable: false,
          writable: true,
          configurable: true
        }
      });
      superClass && (Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass);
    }
    var SkinnedMeshRenderer = require("./CCSkinnedMeshRenderer");
    var MeshRendererAssembler = require("../../mesh/mesh-renderer");
    var RenderFlow = require("../../renderer/render-flow");
    var SkinnedMeshRendererAssembler = (function(_MeshRendererAssemble) {
      _inherits(SkinnedMeshRendererAssembler, _MeshRendererAssemble);
      function SkinnedMeshRendererAssembler() {
        _classCallCheck(this, SkinnedMeshRendererAssembler);
        return _possibleConstructorReturn(this, _MeshRendererAssemble.apply(this, arguments));
      }
      SkinnedMeshRendererAssembler.prototype.fillBuffers = function fillBuffers(comp, renderer) {
        comp.calcJointMatrix();
        _MeshRendererAssemble.prototype.fillBuffers.call(this, comp, renderer);
      };
      return SkinnedMeshRendererAssembler;
    })(MeshRendererAssembler);
    exports.default = SkinnedMeshRendererAssembler;
    cc.Assembler.register(SkinnedMeshRenderer, SkinnedMeshRendererAssembler);
    module.exports = exports["default"];
  }), {
    "../../mesh/mesh-renderer": 170,
    "../../renderer/render-flow": 249,
    "./CCSkinnedMeshRenderer": 48
  } ],
  50: [ (function(require, module, exports) {
    "use strict";
    var utils = require("./platform/utils");
    var debugInfos = require("../../DebugInfos") || {};
    var ERROR_MAP_URL = "https://github.com/cocos-creator/engine/blob/master/EngineErrorMap.md";
    var logList = void 0;
    cc.log = cc.warn = cc.error = cc.assert = console.log.bind ? console.log.bind(console) : console.log;
    var resetDebugSetting = function resetDebugSetting(mode) {
      cc.log = cc.warn = cc.error = cc.assert = function() {};
      if (mode === DebugMode.NONE) return;
      if (mode > DebugMode.ERROR) {
        var logToWebPage = function logToWebPage(msg) {
          if (!cc.game.canvas) return;
          if (!logList) {
            var logDiv = document.createElement("Div");
            logDiv.setAttribute("id", "logInfoDiv");
            logDiv.setAttribute("width", "200");
            logDiv.setAttribute("height", cc.game.canvas.height);
            var logDivStyle = logDiv.style;
            logDivStyle.zIndex = "99999";
            logDivStyle.position = "absolute";
            logDivStyle.top = logDivStyle.left = "0";
            logList = document.createElement("textarea");
            logList.setAttribute("rows", "20");
            logList.setAttribute("cols", "30");
            logList.setAttribute("disabled", "true");
            var logListStyle = logList.style;
            logListStyle.backgroundColor = "transparent";
            logListStyle.borderBottom = "1px solid #cccccc";
            logListStyle.borderTopWidth = logListStyle.borderLeftWidth = logListStyle.borderRightWidth = "0px";
            logListStyle.borderTopStyle = logListStyle.borderLeftStyle = logListStyle.borderRightStyle = "none";
            logListStyle.padding = "0px";
            logListStyle.margin = 0;
            logDiv.appendChild(logList);
            cc.game.canvas.parentNode.appendChild(logDiv);
          }
          logList.value = logList.value + msg + "\r\n";
          logList.scrollTop = logList.scrollHeight;
        };
        cc.error = function() {
          logToWebPage("ERROR :  " + cc.js.formatStr.apply(null, arguments));
        };
        cc.assert = function(cond, msg) {
          if (!cond && msg) {
            msg = cc.js.formatStr.apply(null, cc.js.shiftArguments.apply(null, arguments));
            logToWebPage("ASSERT: " + msg);
          }
        };
        mode !== DebugMode.ERROR_FOR_WEB_PAGE && (cc.warn = function() {
          logToWebPage("WARN :  " + cc.js.formatStr.apply(null, arguments));
        });
        mode === DebugMode.INFO_FOR_WEB_PAGE && (cc.log = function() {
          logToWebPage(cc.js.formatStr.apply(null, arguments));
        });
      } else if (console && console.log.apply) {
        console.error || (console.error = console.log);
        console.warn || (console.warn = console.log);
        false;
        console.error.bind ? cc.error = console.error.bind(console) : cc.error = console.error;
        cc.assert = function(cond, msg) {
          if (!cond) {
            msg && (msg = cc.js.formatStr.apply(null, cc.js.shiftArguments.apply(null, arguments)));
            false;
            false;
            throw new Error(msg);
          }
        };
      }
      if (mode !== DebugMode.ERROR) {
        false;
        console.warn.bind ? cc.warn = console.warn.bind(console) : cc.warn = console.warn;
      }
      false;
      if (mode === DebugMode.INFO) {
        true;
        "JavaScriptCore" === scriptEngineType ? cc.log = function() {
          return console.log.apply(console, arguments);
        } : cc.log = console.log;
      }
    };
    cc._throw = function(error) {
      utils.callInNextTick((function() {
        throw error;
      }));
    };
    function getTypedFormatter(type) {
      return function() {
        var id = arguments[0];
        var msg = debugInfos[id] || "unknown id";
        if (1 === arguments.length) return msg;
        if (2 === arguments.length) return cc.js.formatStr(msg, arguments[1]);
        var argsArray = cc.js.shiftArguments.apply(null, arguments);
        return cc.js.formatStr.apply(null, [ msg ].concat(argsArray));
      };
    }
    var logFormatter = getTypedFormatter("Log");
    cc.logID = function() {
      cc.log(logFormatter.apply(null, arguments));
    };
    var warnFormatter = getTypedFormatter("Warning");
    cc.warnID = function() {
      cc.warn(warnFormatter.apply(null, arguments));
    };
    var errorFormatter = getTypedFormatter("Error");
    cc.errorID = function() {
      cc.error(errorFormatter.apply(null, arguments));
    };
    var assertFormatter = getTypedFormatter("Assert");
    cc.assertID = function(cond) {
      if (cond) return;
      cc.assert(false, assertFormatter.apply(null, cc.js.shiftArguments.apply(null, arguments)));
    };
    var DebugMode = cc.Enum({
      NONE: 0,
      INFO: 1,
      WARN: 2,
      ERROR: 3,
      INFO_FOR_WEB_PAGE: 4,
      WARN_FOR_WEB_PAGE: 5,
      ERROR_FOR_WEB_PAGE: 6
    });
    module.exports = cc.debug = {
      DebugMode: DebugMode,
      _resetDebugSetting: resetDebugSetting,
      getError: getTypedFormatter("ERROR"),
      isDisplayStats: function isDisplayStats() {
        return !!cc.profiler && cc.profiler.isShowingStats();
      },
      setDisplayStats: function setDisplayStats(displayStats) {
        if (cc.profiler) {
          displayStats ? cc.profiler.showStats() : cc.profiler.hideStats();
          cc.game.config.showFPS = !!displayStats;
        }
      }
    };
  }), {
    "../../DebugInfos": 1,
    "./platform/utils": 223
  } ],
  51: [ (function(require, module, exports) {
    "use strict";
    var EventTarget = require("./event/event-target");
    var AutoReleaseUtils = require("./load-pipeline/auto-release-utils");
    var ComponentScheduler = require("./component-scheduler");
    var NodeActivator = require("./node-activator");
    var Obj = require("./platform/CCObject");
    var game = require("./CCGame");
    var renderer = require("./renderer");
    var eventManager = require("./event-manager");
    var Scheduler = require("./CCScheduler");
    cc.Director = function() {
      EventTarget.call(this);
      this._paused = false;
      this._purgeDirectorInNextLoop = false;
      this._winSizeInPoints = null;
      this._loadingScene = "";
      this._scene = null;
      this._totalFrames = 0;
      this._lastUpdate = 0;
      this._deltaTime = 0;
      this._startTime = 0;
      this._scheduler = null;
      this._compScheduler = null;
      this._nodeActivator = null;
      this._actionManager = null;
      var self = this;
      game.on(game.EVENT_SHOW, (function() {
        self._lastUpdate = performance.now();
      }));
      game.once(game.EVENT_ENGINE_INITED, this.init, this);
    };
    cc.Director.prototype = {
      constructor: cc.Director,
      init: function init() {
        this._totalFrames = 0;
        this._lastUpdate = performance.now();
        this._startTime = this._lastUpdate;
        this._paused = false;
        this._purgeDirectorInNextLoop = false;
        this._winSizeInPoints = cc.size(0, 0);
        this._scheduler = new Scheduler();
        if (cc.ActionManager) {
          this._actionManager = new cc.ActionManager();
          this._scheduler.scheduleUpdate(this._actionManager, Scheduler.PRIORITY_SYSTEM, false);
        } else this._actionManager = null;
        this.sharedInit();
        return true;
      },
      sharedInit: function sharedInit() {
        this._compScheduler = new ComponentScheduler();
        this._nodeActivator = new NodeActivator();
        eventManager && eventManager.setEnabled(true);
        if (cc.AnimationManager) {
          this._animationManager = new cc.AnimationManager();
          this._scheduler.scheduleUpdate(this._animationManager, Scheduler.PRIORITY_SYSTEM, false);
        } else this._animationManager = null;
        if (cc.CollisionManager) {
          this._collisionManager = new cc.CollisionManager();
          this._scheduler.scheduleUpdate(this._collisionManager, Scheduler.PRIORITY_SYSTEM, false);
        } else this._collisionManager = null;
        if (cc.PhysicsManager) {
          this._physicsManager = new cc.PhysicsManager();
          this._scheduler.scheduleUpdate(this._physicsManager, Scheduler.PRIORITY_SYSTEM, false);
        } else this._physicsManager = null;
        cc._widgetManager && cc._widgetManager.init(this);
        cc.loader.init(this);
      },
      calculateDeltaTime: function calculateDeltaTime(now) {
        now || (now = performance.now());
        this._deltaTime = now > this._lastUpdate ? (now - this._lastUpdate) / 1e3 : 0;
        (true, this._deltaTime > 1) && (this._deltaTime = 1 / 60);
        this._lastUpdate = now;
      },
      convertToGL: function convertToGL(uiPoint) {
        var container = game.container;
        var view = cc.view;
        var box = container.getBoundingClientRect();
        var left = box.left + window.pageXOffset - container.clientLeft;
        var top = box.top + window.pageYOffset - container.clientTop;
        var x = view._devicePixelRatio * (uiPoint.x - left);
        var y = view._devicePixelRatio * (top + box.height - uiPoint.y);
        return view._isRotated ? cc.v2(view._viewportRect.width - y, x) : cc.v2(x, y);
      },
      convertToUI: function convertToUI(glPoint) {
        var container = game.container;
        var view = cc.view;
        var box = container.getBoundingClientRect();
        var left = box.left + window.pageXOffset - container.clientLeft;
        var top = box.top + window.pageYOffset - container.clientTop;
        var uiPoint = cc.v2(0, 0);
        if (view._isRotated) {
          uiPoint.x = left + glPoint.y / view._devicePixelRatio;
          uiPoint.y = top + box.height - (view._viewportRect.width - glPoint.x) / view._devicePixelRatio;
        } else {
          uiPoint.x = left + glPoint.x * view._devicePixelRatio;
          uiPoint.y = top + box.height - glPoint.y * view._devicePixelRatio;
        }
        return uiPoint;
      },
      end: function end() {
        this._purgeDirectorInNextLoop = true;
      },
      getWinSize: function getWinSize() {
        return cc.size(cc.winSize);
      },
      getWinSizeInPixels: function getWinSizeInPixels() {
        return cc.size(cc.winSize);
      },
      pause: function pause() {
        if (this._paused) return;
        this._paused = true;
      },
      purgeCachedData: function purgeCachedData() {
        cc.loader.releaseAll();
      },
      purgeDirector: function purgeDirector() {
        this._scheduler.unscheduleAll();
        this._compScheduler.unscheduleAll();
        this._nodeActivator.reset();
        eventManager && eventManager.setEnabled(false);
        true;
        cc.isValid(this._scene) && this._scene.destroy();
        this._scene = null;
        cc.renderer.clear();
        cc.AssetLibrary.resetBuiltins();
        cc.game.pause();
        cc.loader.releaseAll();
      },
      reset: function reset() {
        this.purgeDirector();
        eventManager && eventManager.setEnabled(true);
        this._actionManager && this._scheduler.scheduleUpdate(this._actionManager, cc.Scheduler.PRIORITY_SYSTEM, false);
        this._animationManager && this._scheduler.scheduleUpdate(this._animationManager, cc.Scheduler.PRIORITY_SYSTEM, false);
        this._collisionManager && this._scheduler.scheduleUpdate(this._collisionManager, cc.Scheduler.PRIORITY_SYSTEM, false);
        this._physicsManager && this._scheduler.scheduleUpdate(this._physicsManager, cc.Scheduler.PRIORITY_SYSTEM, false);
        cc.game.resume();
      },
      runSceneImmediate: function runSceneImmediate(scene, onBeforeLoadScene, onLaunched) {
        cc.assertID(scene instanceof cc.Scene, 1216);
        (true, true) && console.time("InitScene");
        scene._load();
        (true, true) && console.timeEnd("InitScene");
        (true, true) && console.time("AttachPersist");
        var persistNodeList = Object.keys(game._persistRootNodes).map((function(x) {
          return game._persistRootNodes[x];
        }));
        for (var i = 0; i < persistNodeList.length; i++) {
          var node = persistNodeList[i];
          var existNode = scene.getChildByUuid(node.uuid);
          if (existNode) {
            var index = existNode.getSiblingIndex();
            existNode._destroyImmediate();
            scene.insertChild(node, index);
          } else node.parent = scene;
        }
        (true, true) && console.timeEnd("AttachPersist");
        var oldScene = this._scene;
        true;
        (true, true) && console.time("AutoRelease");
        var autoReleaseAssets = oldScene && oldScene.autoReleaseAssets && oldScene.dependAssets;
        AutoReleaseUtils.autoRelease(autoReleaseAssets, scene.dependAssets, persistNodeList);
        (true, true) && console.timeEnd("AutoRelease");
        (true, true) && console.time("Destroy");
        cc.isValid(oldScene) && oldScene.destroy();
        this._scene = null;
        Obj._deferredDestroy();
        (true, true) && console.timeEnd("Destroy");
        onBeforeLoadScene && onBeforeLoadScene();
        this.emit(cc.Director.EVENT_BEFORE_SCENE_LAUNCH, scene);
        this._scene = scene;
        (true, true) && console.time("Activate");
        scene._activate();
        (true, true) && console.timeEnd("Activate");
        cc.game.resume();
        onLaunched && onLaunched(null, scene);
        this.emit(cc.Director.EVENT_AFTER_SCENE_LAUNCH, scene);
      },
      runScene: function runScene(scene, onBeforeLoadScene, onLaunched) {
        cc.assertID(scene, 1205);
        cc.assertID(scene instanceof cc.Scene, 1216);
        scene._load();
        this.once(cc.Director.EVENT_AFTER_UPDATE, (function() {
          this.runSceneImmediate(scene, onBeforeLoadScene, onLaunched);
        }), this);
      },
      _getSceneUuid: function _getSceneUuid(key) {
        var scenes = game._sceneInfos;
        if ("string" === typeof key) {
          key.endsWith(".fire") || (key += ".fire");
          "/" === key[0] || key.startsWith("db://") || (key = "/" + key);
          for (var i = 0; i < scenes.length; i++) {
            var info = scenes[i];
            if (info.url.endsWith(key)) return info;
          }
        } else if ("number" === typeof key) {
          if (0 <= key && key < scenes.length) return scenes[key];
          cc.errorID(1206, key);
        } else cc.errorID(1207, key);
        return null;
      },
      loadScene: function loadScene(sceneName, onLaunched, _onUnloaded) {
        if (this._loadingScene) {
          cc.warnID(1208, sceneName, this._loadingScene);
          return false;
        }
        var info = this._getSceneUuid(sceneName);
        if (info) {
          var uuid = info.uuid;
          this.emit(cc.Director.EVENT_BEFORE_SCENE_LOADING, sceneName);
          this._loadingScene = sceneName;
          this._loadSceneByUuid(uuid, onLaunched, _onUnloaded);
          return true;
        }
        cc.errorID(1209, sceneName);
        return false;
      },
      preloadScene: function preloadScene(sceneName, onProgress, onLoaded) {
        if (void 0 === onLoaded) {
          onLoaded = onProgress;
          onProgress = null;
        }
        var info = this._getSceneUuid(sceneName);
        if (info) {
          this.emit(cc.Director.EVENT_BEFORE_SCENE_LOADING, sceneName);
          cc.loader.load({
            uuid: info.uuid,
            type: "uuid"
          }, onProgress, (function(error, asset) {
            error && cc.errorID(1210, sceneName, error.message);
            onLoaded && onLoaded(error, asset);
          }));
        } else {
          var error = 'Can not preload the scene "' + sceneName + '" because it is not in the build settings.';
          onLoaded(new Error(error));
          cc.error("preloadScene: " + error);
        }
      },
      _loadSceneByUuid: function _loadSceneByUuid(uuid, onLaunched, onUnloaded, dontRunScene) {
        false;
        console.time("LoadScene " + uuid);
        cc.AssetLibrary.loadAsset(uuid, (function(error, sceneAsset) {
          console.timeEnd("LoadScene " + uuid);
          var self = cc.director;
          self._loadingScene = "";
          if (error) {
            error = "Failed to load scene: " + error;
            cc.error(error);
          } else {
            if (sceneAsset instanceof cc.SceneAsset) {
              var scene = sceneAsset.scene;
              scene._id = sceneAsset._uuid;
              scene._name = sceneAsset._name;
              false;
              self.runSceneImmediate(scene, onUnloaded, onLaunched);
              return;
            }
            error = "The asset " + uuid + " is not a scene";
            cc.error(error);
          }
          onLaunched && onLaunched(error);
        }));
      },
      resume: function resume() {
        if (!this._paused) return;
        this._lastUpdate = performance.now();
        this._lastUpdate || cc.logID(1200);
        this._paused = false;
        this._deltaTime = 0;
      },
      setDepthTest: function setDepthTest(value) {
        if (!cc.Camera.main) return;
        cc.Camera.main.depth = !!value;
      },
      setClearColor: function setClearColor(clearColor) {
        if (!cc.Camera.main) return;
        cc.Camera.main.backgroundColor = clearColor;
      },
      getRunningScene: function getRunningScene() {
        return this._scene;
      },
      getScene: function getScene() {
        return this._scene;
      },
      getAnimationInterval: function getAnimationInterval() {
        return 1e3 / game.getFrameRate();
      },
      setAnimationInterval: function setAnimationInterval(value) {
        game.setFrameRate(Math.round(1e3 / value));
      },
      getDeltaTime: function getDeltaTime() {
        return this._deltaTime;
      },
      getTotalTime: function getTotalTime() {
        return performance.now() - this._startTime;
      },
      getTotalFrames: function getTotalFrames() {
        return this._totalFrames;
      },
      isPaused: function isPaused() {
        return this._paused;
      },
      getScheduler: function getScheduler() {
        return this._scheduler;
      },
      setScheduler: function setScheduler(scheduler) {
        this._scheduler !== scheduler && (this._scheduler = scheduler);
      },
      getActionManager: function getActionManager() {
        return this._actionManager;
      },
      setActionManager: function setActionManager(actionManager) {
        if (this._actionManager !== actionManager) {
          this._actionManager && this._scheduler.unscheduleUpdate(this._actionManager);
          this._actionManager = actionManager;
          this._scheduler.scheduleUpdate(this._actionManager, cc.Scheduler.PRIORITY_SYSTEM, false);
        }
      },
      getAnimationManager: function getAnimationManager() {
        return this._animationManager;
      },
      getCollisionManager: function getCollisionManager() {
        return this._collisionManager;
      },
      getPhysicsManager: function getPhysicsManager() {
        return this._physicsManager;
      },
      startAnimation: function startAnimation() {
        cc.game.resume();
      },
      stopAnimation: function stopAnimation() {
        cc.game.pause();
      },
      _resetDeltaTime: function _resetDeltaTime() {
        this._lastUpdate = performance.now();
        this._deltaTime = 0;
      },
      mainLoop: function(now) {
        if (this._purgeDirectorInNextLoop) {
          this._purgeDirectorInNextLoop = false;
          this.purgeDirector();
        } else {
          this.calculateDeltaTime(now);
          if (!this._paused) {
            this.emit(cc.Director.EVENT_BEFORE_UPDATE);
            this._compScheduler.startPhase();
            this._compScheduler.updatePhase(this._deltaTime);
            this._scheduler.update(this._deltaTime);
            this._compScheduler.lateUpdatePhase(this._deltaTime);
            this.emit(cc.Director.EVENT_AFTER_UPDATE);
            Obj._deferredDestroy();
          }
          this.emit(cc.Director.EVENT_BEFORE_DRAW);
          renderer.render(this._scene, this._deltaTime);
          this.emit(cc.Director.EVENT_AFTER_DRAW);
          eventManager.frameUpdateListeners();
          this._totalFrames++;
        }
      },
      __fastOn: function __fastOn(type, callback, target) {
        this.on(type, callback, target);
      },
      __fastOff: function __fastOff(type, callback, target) {
        this.off(type, callback, target);
      }
    };
    cc.js.addon(cc.Director.prototype, EventTarget.prototype);
    cc.Director.EVENT_PROJECTION_CHANGED = "director_projection_changed";
    cc.Director.EVENT_BEFORE_SCENE_LOADING = "director_before_scene_loading";
    cc.Director.EVENT_BEFORE_SCENE_LAUNCH = "director_before_scene_launch";
    cc.Director.EVENT_AFTER_SCENE_LAUNCH = "director_after_scene_launch";
    cc.Director.EVENT_BEFORE_UPDATE = "director_before_update";
    cc.Director.EVENT_AFTER_UPDATE = "director_after_update";
    cc.Director.EVENT_BEFORE_VISIT = "director_before_draw";
    cc.Director.EVENT_AFTER_VISIT = "director_before_draw";
    cc.Director.EVENT_BEFORE_DRAW = "director_before_draw";
    cc.Director.EVENT_AFTER_DRAW = "director_after_draw";
    cc.Director.PROJECTION_2D = 0;
    cc.Director.PROJECTION_3D = 1;
    cc.Director.PROJECTION_CUSTOM = 3;
    cc.Director.PROJECTION_DEFAULT = cc.Director.PROJECTION_2D;
    cc.director = new cc.Director();
    module.exports = cc.director;
  }), {
    "./CCGame": 52,
    "./CCScheduler": 56,
    "./component-scheduler": 90,
    "./event-manager": 130,
    "./event/event-target": 132,
    "./load-pipeline/auto-release-utils": 150,
    "./node-activator": 171,
    "./platform/CCObject": 205,
    "./renderer": 248
  } ],
  52: [ (function(require, module, exports) {
    "use strict";
    var EventTarget = require("./event/event-target");
    require("../audio/CCAudioEngine");
    var debug = require("./CCDebug");
    var renderer = require("./renderer/index.js");
    var dynamicAtlasManager = require("../core/renderer/utils/dynamic-atlas/manager");
    var game = {
      EVENT_HIDE: "game_on_hide",
      EVENT_SHOW: "game_on_show",
      EVENT_RESTART: "game_on_restart",
      EVENT_GAME_INITED: "game_inited",
      EVENT_ENGINE_INITED: "engine_inited",
      EVENT_RENDERER_INITED: "engine_inited",
      RENDER_TYPE_CANVAS: 0,
      RENDER_TYPE_WEBGL: 1,
      RENDER_TYPE_OPENGL: 2,
      _persistRootNodes: {},
      _paused: true,
      _configLoaded: false,
      _isCloning: false,
      _prepared: false,
      _rendererInitialized: false,
      _renderContext: null,
      _intervalId: null,
      _lastTime: null,
      _frameTime: null,
      _sceneInfos: [],
      frame: null,
      container: null,
      canvas: null,
      renderType: -1,
      config: null,
      onStart: null,
      setFrameRate: function setFrameRate(frameRate) {
        var config = this.config;
        config.frameRate = frameRate;
        this._intervalId && window.cancelAnimFrame(this._intervalId);
        this._intervalId = 0;
        this._paused = true;
        this._setAnimFrame();
        this._runMainLoop();
      },
      getFrameRate: function getFrameRate() {
        return this.config.frameRate;
      },
      step: function step() {
        cc.director.mainLoop();
      },
      pause: function pause() {
        if (this._paused) return;
        this._paused = true;
        cc.audioEngine && cc.audioEngine._break();
        this._intervalId && window.cancelAnimFrame(this._intervalId);
        this._intervalId = 0;
      },
      resume: function resume() {
        if (!this._paused) return;
        this._paused = false;
        cc.audioEngine && cc.audioEngine._restore();
        cc.director._resetDeltaTime();
        this._runMainLoop();
      },
      isPaused: function isPaused() {
        return this._paused;
      },
      restart: function restart() {
        cc.director.once(cc.Director.EVENT_AFTER_DRAW, (function() {
          for (var id in game._persistRootNodes) game.removePersistRootNode(game._persistRootNodes[id]);
          cc.director.getScene().destroy();
          cc.Object._deferredDestroy();
          cc.audioEngine && cc.audioEngine.uncacheAll();
          cc.director.reset();
          game.pause();
          cc.AssetLibrary._loadBuiltins((function() {
            game.onStart();
            game.emit(game.EVENT_RESTART);
          }));
        }));
      },
      end: function end() {
        close();
      },
      _initEngine: function _initEngine() {
        if (this._rendererInitialized) return;
        this._initRenderer();
        true;
        this._initEvents();
        this.emit(this.EVENT_ENGINE_INITED);
      },
      _prepareFinished: function _prepareFinished(cb) {
        var _this = this;
        false;
        this._initEngine();
        this._setAnimFrame();
        cc.AssetLibrary._loadBuiltins((function() {
          console.log("Cocos Creator v" + cc.ENGINE_VERSION);
          _this._prepared = true;
          _this._runMainLoop();
          _this.emit(_this.EVENT_GAME_INITED);
          cb && cb();
        }));
      },
      eventTargetOn: EventTarget.prototype.on,
      eventTargetOnce: EventTarget.prototype.once,
      on: function on(type, callback, target) {
        this._prepared && type === this.EVENT_ENGINE_INITED || !this._paused && type === this.EVENT_GAME_INITED ? callback.call(target) : this.eventTargetOn(type, callback, target);
      },
      once: function once(type, callback, target) {
        this._prepared && type === this.EVENT_ENGINE_INITED || !this._paused && type === this.EVENT_GAME_INITED ? callback.call(target) : this.eventTargetOnce(type, callback, target);
      },
      prepare: function prepare(cb) {
        if (this._prepared) {
          cb && cb();
          return;
        }
        var jsList = this.config.jsList;
        if (jsList && jsList.length > 0) {
          var self = this;
          cc.loader.load(jsList, (function(err) {
            if (err) throw new Error(JSON.stringify(err));
            self._prepareFinished(cb);
          }));
        } else this._prepareFinished(cb);
      },
      run: function run(config, onStart) {
        this._initConfig(config);
        this.onStart = onStart;
        this.prepare(game.onStart && game.onStart.bind(game));
      },
      addPersistRootNode: function addPersistRootNode(node) {
        if (!cc.Node.isNode(node) || !node.uuid) {
          cc.warnID(3800);
          return;
        }
        var id = node.uuid;
        if (!this._persistRootNodes[id]) {
          var scene = cc.director._scene;
          if (cc.isValid(scene)) if (node.parent) {
            if (!(node.parent instanceof cc.Scene)) {
              cc.warnID(3801);
              return;
            }
            if (node.parent !== scene) {
              cc.warnID(3802);
              return;
            }
          } else node.parent = scene;
          this._persistRootNodes[id] = node;
          node._persistNode = true;
        }
      },
      removePersistRootNode: function removePersistRootNode(node) {
        var id = node.uuid || "";
        if (node === this._persistRootNodes[id]) {
          delete this._persistRootNodes[id];
          node._persistNode = false;
        }
      },
      isPersistRootNode: function isPersistRootNode(node) {
        return node._persistNode;
      },
      _setAnimFrame: function _setAnimFrame() {
        this._lastTime = performance.now();
        var frameRate = game.config.frameRate;
        this._frameTime = 1e3 / frameRate;
        true;
        jsb.setPreferredFramesPerSecond(frameRate);
        window.requestAnimFrame = window.requestAnimationFrame;
        window.cancelAnimFrame = window.cancelAnimationFrame;
      },
      _stTime: function _stTime(callback) {
        var currTime = performance.now();
        var timeToCall = Math.max(0, game._frameTime - (currTime - game._lastTime));
        var id = window.setTimeout((function() {
          callback();
        }), timeToCall);
        game._lastTime = currTime + timeToCall;
        return id;
      },
      _ctTime: function _ctTime(id) {
        window.clearTimeout(id);
      },
      _runMainLoop: function _runMainLoop() {
        false;
        if (!this._prepared) return;
        var self = this, _callback, config = self.config, director = cc.director, skip = true, frameRate = config.frameRate;
        debug.setDisplayStats(config.showFPS);
        _callback = function callback(now) {
          if (!self._paused) {
            self._intervalId = window.requestAnimFrame(_callback);
            false;
            director.mainLoop(now);
          }
        };
        self._intervalId = window.requestAnimFrame(_callback);
        self._paused = false;
      },
      _initConfig: function _initConfig(config) {
        "number" !== typeof config.debugMode && (config.debugMode = 0);
        config.exposeClassName = !!config.exposeClassName;
        "number" !== typeof config.frameRate && (config.frameRate = 60);
        var renderMode = config.renderMode;
        ("number" !== typeof renderMode || renderMode > 2 || renderMode < 0) && (config.renderMode = 0);
        "boolean" !== typeof config.registerSystemEvent && (config.registerSystemEvent = true);
        config.showFPS = !!config.showFPS;
        this._sceneInfos = config.scenes || [];
        this.collisionMatrix = config.collisionMatrix || [];
        this.groupList = config.groupList || [];
        debug._resetDebugSetting(config.debugMode);
        this.config = config;
        this._configLoaded = true;
      },
      _determineRenderType: function _determineRenderType() {
        var config = this.config, userRenderMode = parseInt(config.renderMode) || 0;
        this.renderType = this.RENDER_TYPE_CANVAS;
        var supportRender = false;
        if (0 === userRenderMode) {
          if (cc.sys.capabilities["opengl"]) {
            this.renderType = this.RENDER_TYPE_WEBGL;
            supportRender = true;
          } else if (cc.sys.capabilities["canvas"]) {
            this.renderType = this.RENDER_TYPE_CANVAS;
            supportRender = true;
          }
        } else if (1 === userRenderMode && cc.sys.capabilities["canvas"]) {
          this.renderType = this.RENDER_TYPE_CANVAS;
          supportRender = true;
        } else if (2 === userRenderMode && cc.sys.capabilities["opengl"]) {
          this.renderType = this.RENDER_TYPE_WEBGL;
          supportRender = true;
        }
        if (!supportRender) throw new Error(debug.getError(3820, userRenderMode));
      },
      _initRenderer: function _initRenderer() {
        if (this._rendererInitialized) return;
        var el = this.config.id, width = void 0, height = void 0, localCanvas = void 0, localContainer = void 0;
        var addClass;
        var element;
        true;
        this.container = localContainer = document.createElement("DIV");
        this.frame = localContainer.parentNode === document.body ? document.documentElement : localContainer.parentNode;
        localCanvas = window.__canvas;
        this.canvas = localCanvas;
        this._determineRenderType();
        if (this.renderType === this.RENDER_TYPE_WEBGL) {
          var opts = {
            stencil: true,
            antialias: cc.macro.ENABLE_WEBGL_ANTIALIAS,
            alpha: cc.macro.ENABLE_TRANSPARENT_CANVAS
          };
          renderer.initWebGL(localCanvas, opts);
          this._renderContext = renderer.device._gl;
          !cc.macro.CLEANUP_IMAGE_CACHE && dynamicAtlasManager && (dynamicAtlasManager.enabled = true);
        }
        if (!this._renderContext) {
          this.renderType = this.RENDER_TYPE_CANVAS;
          renderer.initCanvas(localCanvas);
          this._renderContext = renderer.device._ctx;
        }
        this.canvas.oncontextmenu = function() {
          if (!cc._isContextMenuEnable) return false;
        };
        this._rendererInitialized = true;
      },
      _initEvents: function _initEvents() {
        var win = window, hiddenPropName;
        this.config.registerSystemEvent && _cc.inputManager.registerSystemEvent(this.canvas);
        "undefined" !== typeof document.hidden ? hiddenPropName = "hidden" : "undefined" !== typeof document.mozHidden ? hiddenPropName = "mozHidden" : "undefined" !== typeof document.msHidden ? hiddenPropName = "msHidden" : "undefined" !== typeof document.webkitHidden && (hiddenPropName = "webkitHidden");
        var hidden = false;
        function onHidden() {
          if (!hidden) {
            hidden = true;
            game.emit(game.EVENT_HIDE);
          }
        }
        function onShown(arg0, arg1, arg2, arg3, arg4) {
          if (hidden) {
            hidden = false;
            game.emit(game.EVENT_SHOW, arg0, arg1, arg2, arg3, arg4);
          }
        }
        if (hiddenPropName) {
          var changeList = [ "visibilitychange", "mozvisibilitychange", "msvisibilitychange", "webkitvisibilitychange", "qbrowserVisibilityChange" ];
          for (var i = 0; i < changeList.length; i++) document.addEventListener(changeList[i], (function(event) {
            var visible = document[hiddenPropName];
            visible = visible || event["hidden"];
            visible ? onHidden() : onShown();
          }));
        } else {
          win.addEventListener("blur", onHidden);
          win.addEventListener("focus", onShown);
        }
        navigator.userAgent.indexOf("MicroMessenger") > -1 && (win.onfocus = onShown);
        if ("onpageshow" in window && "onpagehide" in window) {
          win.addEventListener("pagehide", onHidden);
          win.addEventListener("pageshow", onShown);
          document.addEventListener("pagehide", onHidden);
          document.addEventListener("pageshow", onShown);
        }
        this.on(game.EVENT_HIDE, (function() {
          game.pause();
        }));
        this.on(game.EVENT_SHOW, (function() {
          game.resume();
        }));
      }
    };
    EventTarget.call(game);
    cc.js.addon(game, EventTarget.prototype);
    cc.game = module.exports = game;
  }), {
    "../audio/CCAudioEngine": 22,
    "../core/renderer/utils/dynamic-atlas/manager": 251,
    "./CCDebug": 50,
    "./event/event-target": 132,
    "./renderer/index.js": 248
  } ],
  53: [ (function(require, module, exports) {
    "use strict";
    var _vmath = require("./vmath");
    var BaseNode = require("./utils/base-node");
    var PrefabHelper = require("./utils/prefab-helper");
    var nodeMemPool = require("./utils/trans-pool").NodeMemPool;
    var AffineTrans = require("./utils/affine-transform");
    var eventManager = require("./event-manager");
    var macro = require("./platform/CCMacro");
    var js = require("./platform/js");
    var Event = require("./event/event");
    var EventTarget = require("./event/event-target");
    var RenderFlow = require("./renderer/render-flow");
    var Flags = cc.Object.Flags;
    var Destroying = Flags.Destroying;
    var ERR_INVALID_NUMBER = false;
    var ONE_DEGREE = Math.PI / 180;
    var ActionManagerExist = !!cc.ActionManager;
    var emptyFunc = function emptyFunc() {};
    var _gwpVec3 = cc.v3();
    var _gwpQuat = cc.quat();
    var _tpVec3a = cc.v3();
    var _tpVec3b = cc.v3();
    var _tpQuata = cc.quat();
    var _tpQuatb = cc.quat();
    var _swpVec3 = cc.v3();
    var _gwsVec3 = cc.v3();
    var _swsVec3 = cc.v3();
    var _gwrtVec3a = cc.v3();
    var _gwrtVec3b = cc.v3();
    var _gwrtQuata = cc.quat();
    var _gwrtQuatb = cc.quat();
    var _laVec3 = cc.v3();
    var _laQuat = _vmath.quat.create();
    var _htVec3a = cc.v3();
    var _htVec3b = cc.v3();
    var _gwrQuat = cc.quat();
    var _swrQuat = cc.quat();
    var _quata = cc.quat();
    var _mat4_temp = _vmath.mat4.create();
    var _vec3_temp = _vmath.vec3.create();
    var _cachedArray = new Array(16);
    _cachedArray.length = 0;
    var POSITION_ON = 1;
    var SCALE_ON = 2;
    var ROTATION_ON = 4;
    var SIZE_ON = 8;
    var ANCHOR_ON = 16;
    var COLOR_ON = 32;
    var BuiltinGroupIndex = cc.Enum({
      DEBUG: 31
    });
    var LocalDirtyFlag = cc.Enum({
      POSITION: 1,
      SCALE: 2,
      ROTATION: 4,
      SKEW: 8,
      TRS: 7,
      RS: 6,
      ALL: 65535
    });
    var EventType = cc.Enum({
      TOUCH_START: "touchstart",
      TOUCH_MOVE: "touchmove",
      TOUCH_END: "touchend",
      TOUCH_CANCEL: "touchcancel",
      MOUSE_DOWN: "mousedown",
      MOUSE_MOVE: "mousemove",
      MOUSE_ENTER: "mouseenter",
      MOUSE_LEAVE: "mouseleave",
      MOUSE_UP: "mouseup",
      MOUSE_WHEEL: "mousewheel",
      POSITION_CHANGED: "position-changed",
      ROTATION_CHANGED: "rotation-changed",
      SCALE_CHANGED: "scale-changed",
      SIZE_CHANGED: "size-changed",
      ANCHOR_CHANGED: "anchor-changed",
      COLOR_CHANGED: "color-changed",
      CHILD_ADDED: "child-added",
      CHILD_REMOVED: "child-removed",
      CHILD_REORDER: "child-reorder",
      GROUP_CHANGED: "group-changed",
      SIBLING_ORDER_CHANGED: "sibling-order-changed"
    });
    var _touchEvents = [ EventType.TOUCH_START, EventType.TOUCH_MOVE, EventType.TOUCH_END, EventType.TOUCH_CANCEL ];
    var _mouseEvents = [ EventType.MOUSE_DOWN, EventType.MOUSE_ENTER, EventType.MOUSE_MOVE, EventType.MOUSE_LEAVE, EventType.MOUSE_UP, EventType.MOUSE_WHEEL ];
    var _skewNeedWarn = true;
    var _skewWarn = function _skewWarn(value, node) {
      if (0 !== value) {
        var nodePath = "";
        var NodeUtils;
        false;
        _skewNeedWarn && cc.warn("`cc.Node.skewX/Y` is deprecated since v2.2.1, please use 3D node instead.", nodePath);
        true, _skewNeedWarn = false;
      }
    };
    var _currentHovered = null;
    var _touchStartHandler = function _touchStartHandler(touch, event) {
      var pos = touch.getLocation();
      var node = this.owner;
      if (node._hitTest(pos, this)) {
        event.type = EventType.TOUCH_START;
        event.touch = touch;
        event.bubbles = true;
        node.dispatchEvent(event);
        return true;
      }
      return false;
    };
    var _touchMoveHandler = function _touchMoveHandler(touch, event) {
      var node = this.owner;
      event.type = EventType.TOUCH_MOVE;
      event.touch = touch;
      event.bubbles = true;
      node.dispatchEvent(event);
    };
    var _touchEndHandler = function _touchEndHandler(touch, event) {
      var pos = touch.getLocation();
      var node = this.owner;
      node._hitTest(pos, this) ? event.type = EventType.TOUCH_END : event.type = EventType.TOUCH_CANCEL;
      event.touch = touch;
      event.bubbles = true;
      node.dispatchEvent(event);
    };
    var _touchCancelHandler = function _touchCancelHandler(touch, event) {
      var pos = touch.getLocation();
      var node = this.owner;
      event.type = EventType.TOUCH_CANCEL;
      event.touch = touch;
      event.bubbles = true;
      node.dispatchEvent(event);
    };
    var _mouseDownHandler = function _mouseDownHandler(event) {
      var pos = event.getLocation();
      var node = this.owner;
      if (node._hitTest(pos, this)) {
        event.type = EventType.MOUSE_DOWN;
        event.bubbles = true;
        node.dispatchEvent(event);
      }
    };
    var _mouseMoveHandler = function _mouseMoveHandler(event) {
      var pos = event.getLocation();
      var node = this.owner;
      var hit = node._hitTest(pos, this);
      if (hit) {
        if (!this._previousIn) {
          if (_currentHovered && _currentHovered._mouseListener) {
            event.type = EventType.MOUSE_LEAVE;
            _currentHovered.dispatchEvent(event);
            _currentHovered._mouseListener._previousIn = false;
          }
          _currentHovered = this.owner;
          event.type = EventType.MOUSE_ENTER;
          node.dispatchEvent(event);
          this._previousIn = true;
        }
        event.type = EventType.MOUSE_MOVE;
        event.bubbles = true;
        node.dispatchEvent(event);
      } else {
        if (!this._previousIn) return;
        event.type = EventType.MOUSE_LEAVE;
        node.dispatchEvent(event);
        this._previousIn = false;
        _currentHovered = null;
      }
      event.stopPropagation();
    };
    var _mouseUpHandler = function _mouseUpHandler(event) {
      var pos = event.getLocation();
      var node = this.owner;
      if (node._hitTest(pos, this)) {
        event.type = EventType.MOUSE_UP;
        event.bubbles = true;
        node.dispatchEvent(event);
        event.stopPropagation();
      }
    };
    var _mouseWheelHandler = function _mouseWheelHandler(event) {
      var pos = event.getLocation();
      var node = this.owner;
      if (node._hitTest(pos, this)) {
        event.type = EventType.MOUSE_WHEEL;
        event.bubbles = true;
        node.dispatchEvent(event);
        event.stopPropagation();
      }
    };
    function _searchMaskInParent(node) {
      var Mask = cc.Mask;
      if (Mask) {
        var index = 0;
        for (var curr = node; curr && cc.Node.isNode(curr); curr = curr._parent, ++index) if (curr.getComponent(Mask)) return {
          index: index,
          node: curr
        };
      }
      return null;
    }
    function _checkListeners(node, events) {
      if (!(node._objFlags & Destroying)) {
        var i = 0;
        if (node._bubblingListeners) for (;i < events.length; ++i) if (node._bubblingListeners.hasEventListener(events[i])) return true;
        if (node._capturingListeners) for (;i < events.length; ++i) if (node._capturingListeners.hasEventListener(events[i])) return true;
        return false;
      }
      return true;
    }
    function _doDispatchEvent(owner, event) {
      var target, i;
      event.target = owner;
      _cachedArray.length = 0;
      owner._getCapturingTargets(event.type, _cachedArray);
      event.eventPhase = 1;
      for (i = _cachedArray.length - 1; i >= 0; --i) {
        target = _cachedArray[i];
        if (target._capturingListeners) {
          event.currentTarget = target;
          target._capturingListeners.emit(event.type, event, _cachedArray);
          if (event._propagationStopped) {
            _cachedArray.length = 0;
            return;
          }
        }
      }
      _cachedArray.length = 0;
      event.eventPhase = 2;
      event.currentTarget = owner;
      owner._capturingListeners && owner._capturingListeners.emit(event.type, event);
      !event._propagationImmediateStopped && owner._bubblingListeners && owner._bubblingListeners.emit(event.type, event);
      if (!event._propagationStopped && event.bubbles) {
        owner._getBubblingTargets(event.type, _cachedArray);
        event.eventPhase = 3;
        for (i = 0; i < _cachedArray.length; ++i) {
          target = _cachedArray[i];
          if (target._bubblingListeners) {
            event.currentTarget = target;
            target._bubblingListeners.emit(event.type, event);
            if (event._propagationStopped) {
              _cachedArray.length = 0;
              return;
            }
          }
        }
      }
      _cachedArray.length = 0;
    }
    function _getActualGroupIndex(node) {
      var groupIndex = node.groupIndex;
      0 === groupIndex && node.parent && (groupIndex = _getActualGroupIndex(node.parent));
      return groupIndex;
    }
    function _updateCullingMask(node) {
      var index = _getActualGroupIndex(node);
      node._cullingMask = 1 << index;
      true, true;
      node._proxy && node._proxy.updateCullingMask();
      for (var i = 0; i < node._children.length; i++) _updateCullingMask(node._children[i]);
    }
    var NodeDefines = {
      name: "cc.Node",
      extends: BaseNode,
      properties: {
        _opacity: 255,
        _color: cc.Color.WHITE,
        _contentSize: cc.Size,
        _anchorPoint: cc.v2(.5, .5),
        _position: void 0,
        _scale: void 0,
        _trs: null,
        _eulerAngles: cc.Vec3,
        _skewX: 0,
        _skewY: 0,
        _zIndex: {
          default: void 0,
          type: cc.Integer
        },
        _localZOrder: {
          default: 0,
          serializable: false
        },
        _is3DNode: false,
        _groupIndex: {
          default: 0,
          formerlySerializedAs: "groupIndex"
        },
        groupIndex: {
          get: function get() {
            return this._groupIndex;
          },
          set: function set(value) {
            this._groupIndex = value;
            _updateCullingMask(this);
            this.emit(EventType.GROUP_CHANGED, this);
          }
        },
        group: {
          get: function get() {
            return cc.game.groupList[this.groupIndex] || "";
          },
          set: function set(value) {
            this.groupIndex = cc.game.groupList.indexOf(value);
          }
        },
        x: {
          get: function get() {
            return this._trs[0];
          },
          set: function set(value) {
            var trs = this._trs;
            if (value !== trs[0]) {
              true;
              var oldValue = void 0;
              false;
              trs[0] = value;
              this.setLocalDirty(LocalDirtyFlag.POSITION);
              if (this._eventMask & POSITION_ON) {
                false;
                this.emit(EventType.POSITION_CHANGED);
              }
            }
          }
        },
        y: {
          get: function get() {
            return this._trs[1];
          },
          set: function set(value) {
            var trs = this._trs;
            if (value !== trs[1]) {
              true;
              var oldValue = void 0;
              false;
              trs[1] = value;
              this.setLocalDirty(LocalDirtyFlag.POSITION);
              if (this._eventMask & POSITION_ON) {
                false;
                this.emit(EventType.POSITION_CHANGED);
              }
            }
          }
        },
        rotation: {
          get: function get() {
            true;
            cc.warn("`cc.Node.rotation` is deprecated since v2.1.0, please use `-angle` instead. (`this.node.rotation` -> `-this.node.angle`)");
            return -this.angle;
          },
          set: function set(value) {
            true;
            cc.warn("`cc.Node.rotation` is deprecated since v2.1.0, please set `-angle` instead. (`this.node.rotation = x` -> `this.node.angle = -x`)");
            this.angle = -value;
          }
        },
        angle: {
          get: function get() {
            return this._eulerAngles.z;
          },
          set: function set(value) {
            _vmath.vec3.set(this._eulerAngles, 0, 0, value);
            _vmath.trs.fromAngleZ(this._trs, value);
            this.setLocalDirty(LocalDirtyFlag.ROTATION);
            this._eventMask & ROTATION_ON && this.emit(EventType.ROTATION_CHANGED);
          }
        },
        rotationX: {
          get: function get() {
            true;
            cc.warn("`cc.Node.rotationX` is deprecated since v2.1.0, please use `eulerAngles.x` instead. (`this.node.rotationX` -> `this.node.eulerAngles.x`)");
            return this._eulerAngles.x;
          },
          set: function set(value) {
            true;
            cc.warn("`cc.Node.rotationX` is deprecated since v2.1.0, please set `eulerAngles` instead. (`this.node.rotationX = x` -> `this.node.is3DNode = true; this.node.eulerAngles = cc.v3(x, 0, 0)`");
            if (this._eulerAngles.x !== value) {
              this._eulerAngles.x = value;
              this._eulerAngles.x === this._eulerAngles.y ? _vmath.trs.fromAngleZ(this._trs, -value) : _vmath.trs.fromEulerNumber(this._trs, value, this._eulerAngles.y, 0);
              this.setLocalDirty(LocalDirtyFlag.ROTATION);
              this._eventMask & ROTATION_ON && this.emit(EventType.ROTATION_CHANGED);
            }
          }
        },
        rotationY: {
          get: function get() {
            true;
            cc.warn("`cc.Node.rotationY` is deprecated since v2.1.0, please use `eulerAngles.y` instead. (`this.node.rotationY` -> `this.node.eulerAngles.y`)");
            return this._eulerAngles.y;
          },
          set: function set(value) {
            true;
            cc.warn("`cc.Node.rotationY` is deprecated since v2.1.0, please set `eulerAngles` instead. (`this.node.rotationY = y` -> `this.node.is3DNode = true; this.node.eulerAngles = cc.v3(0, y, 0)`");
            if (this._eulerAngles.y !== value) {
              this._eulerAngles.y = value;
              this._eulerAngles.x === this._eulerAngles.y ? _vmath.trs.fromAngleZ(this._trs, -value) : _vmath.trs.fromEulerNumber(this._trs, this._eulerAngles.x, value, 0);
              this.setLocalDirty(LocalDirtyFlag.ROTATION);
              this._eventMask & ROTATION_ON && this.emit(EventType.ROTATION_CHANGED);
            }
          }
        },
        scale: {
          get: function get() {
            return this._trs[7];
          },
          set: function set(v) {
            this.setScale(v);
          }
        },
        scaleX: {
          get: function get() {
            return this._trs[7];
          },
          set: function set(value) {
            if (this._trs[7] !== value) {
              this._trs[7] = value;
              this.setLocalDirty(LocalDirtyFlag.SCALE);
              this._eventMask & SCALE_ON && this.emit(EventType.SCALE_CHANGED);
            }
          }
        },
        scaleY: {
          get: function get() {
            return this._trs[8];
          },
          set: function set(value) {
            if (this._trs[8] !== value) {
              this._trs[8] = value;
              this.setLocalDirty(LocalDirtyFlag.SCALE);
              this._eventMask & SCALE_ON && this.emit(EventType.SCALE_CHANGED);
            }
          }
        },
        skewX: {
          get: function get() {
            return this._skewX;
          },
          set: function set(value) {
            _skewWarn(value, this);
            this._skewX = value;
            this.setLocalDirty(LocalDirtyFlag.SKEW);
            true, true;
            this._proxy.updateSkew();
          }
        },
        skewY: {
          get: function get() {
            return this._skewY;
          },
          set: function set(value) {
            _skewWarn(value, this);
            this._skewY = value;
            this.setLocalDirty(LocalDirtyFlag.SKEW);
            true, true;
            this._proxy.updateSkew();
          }
        },
        opacity: {
          get: function get() {
            return this._opacity;
          },
          set: function set(value) {
            value = cc.misc.clampf(value, 0, 255);
            if (this._opacity !== value) {
              this._opacity = value;
              true, true;
              this._proxy.updateOpacity();
              this._renderFlag |= RenderFlow.FLAG_OPACITY_COLOR;
            }
          },
          range: [ 0, 255 ]
        },
        color: {
          get: function get() {
            return this._color.clone();
          },
          set: function set(value) {
            if (!this._color.equals(value)) {
              this._color.set(value);
              false;
              this._renderFlag |= RenderFlow.FLAG_COLOR;
              this._eventMask & COLOR_ON && this.emit(EventType.COLOR_CHANGED, value);
            }
          }
        },
        anchorX: {
          get: function get() {
            return this._anchorPoint.x;
          },
          set: function set(value) {
            var anchorPoint = this._anchorPoint;
            if (anchorPoint.x !== value) {
              anchorPoint.x = value;
              this._eventMask & ANCHOR_ON && this.emit(EventType.ANCHOR_CHANGED);
            }
          }
        },
        anchorY: {
          get: function get() {
            return this._anchorPoint.y;
          },
          set: function set(value) {
            var anchorPoint = this._anchorPoint;
            if (anchorPoint.y !== value) {
              anchorPoint.y = value;
              this._eventMask & ANCHOR_ON && this.emit(EventType.ANCHOR_CHANGED);
            }
          }
        },
        width: {
          get: function get() {
            return this._contentSize.width;
          },
          set: function set(value) {
            if (value !== this._contentSize.width) {
              var clone;
              false;
              this._contentSize.width = value;
              if (this._eventMask & SIZE_ON) {
                false;
                this.emit(EventType.SIZE_CHANGED);
              }
            }
          }
        },
        height: {
          get: function get() {
            return this._contentSize.height;
          },
          set: function set(value) {
            if (value !== this._contentSize.height) {
              var clone;
              false;
              this._contentSize.height = value;
              if (this._eventMask & SIZE_ON) {
                false;
                this.emit(EventType.SIZE_CHANGED);
              }
            }
          }
        },
        zIndex: {
          get: function get() {
            return this._localZOrder >> 16;
          },
          set: function set(value) {
            if (value > macro.MAX_ZINDEX) {
              cc.warnID(1636);
              value = macro.MAX_ZINDEX;
            } else if (value < macro.MIN_ZINDEX) {
              cc.warnID(1637);
              value = macro.MIN_ZINDEX;
            }
            if (this.zIndex !== value) {
              this._localZOrder = 65535 & this._localZOrder | value << 16;
              this.emit(EventType.SIBLING_ORDER_CHANGED);
              this._parent && this._onSiblingIndexChanged();
            }
            true, true;
            this._proxy.updateZOrder();
          }
        }
      },
      ctor: function ctor() {
        this._reorderChildDirty = false;
        this._widget = null;
        this._renderComponent = null;
        this._capturingListeners = null;
        this._bubblingListeners = null;
        this._touchListener = null;
        this._mouseListener = null;
        this._initDataFromPool();
        this._eventMask = 0;
        this._cullingMask = 1;
        this._childArrivalOrder = 1;
        true, true;
        this._proxy = new renderer.NodeProxy(this._spaceInfo.unitID, this._spaceInfo.index, this._id, this._name);
        this._proxy.init(this);
      },
      statics: {
        EventType: EventType,
        _LocalDirtyFlag: LocalDirtyFlag,
        isNode: function isNode(obj) {
          return obj instanceof Node && (obj.constructor === Node || !(obj instanceof cc.Scene));
        },
        BuiltinGroupIndex: BuiltinGroupIndex
      },
      _onSiblingIndexChanged: function _onSiblingIndexChanged() {
        var parent = this._parent;
        var siblings = parent._children;
        var i = 0, len = siblings.length, sibling;
        for (;i < len; i++) {
          sibling = siblings[i];
          sibling._updateOrderOfArrival();
        }
        parent._delaySort();
      },
      _onPreDestroy: function _onPreDestroy() {
        var destroyByParent = this._onPreDestroyBase();
        ActionManagerExist && cc.director.getActionManager().removeAllActionsFromTarget(this);
        _currentHovered === this && (_currentHovered = null);
        if (this._touchListener || this._mouseListener) {
          eventManager.removeListeners(this);
          if (this._touchListener) {
            this._touchListener.owner = null;
            this._touchListener.mask = null;
            this._touchListener = null;
          }
          if (this._mouseListener) {
            this._mouseListener.owner = null;
            this._mouseListener.mask = null;
            this._mouseListener = null;
          }
        }
        true, true;
        this._proxy.destroy();
        this._proxy = null;
        this._backDataIntoPool();
        this._reorderChildDirty && cc.director.__fastOff(cc.Director.EVENT_AFTER_UPDATE, this.sortAllChildren, this);
        destroyByParent || false;
      },
      _onPostActivated: function _onPostActivated(active) {
        var actionManager = ActionManagerExist ? cc.director.getActionManager() : null;
        if (active) {
          this._renderFlag |= RenderFlow.FLAG_WORLD_TRANSFORM;
          actionManager && actionManager.resumeTarget(this);
          eventManager.resumeTarget(this);
          if (this._touchListener) {
            var mask = this._touchListener.mask = _searchMaskInParent(this);
            this._mouseListener && (this._mouseListener.mask = mask);
          } else this._mouseListener && (this._mouseListener.mask = _searchMaskInParent(this));
        } else {
          actionManager && actionManager.pauseTarget(this);
          eventManager.pauseTarget(this);
        }
      },
      _onHierarchyChanged: function _onHierarchyChanged(oldParent) {
        this._updateOrderOfArrival();
        _updateCullingMask(this);
        this._parent && this._parent._delaySort();
        this._renderFlag |= RenderFlow.FLAG_WORLD_TRANSFORM;
        this._onHierarchyChangedBase(oldParent);
        cc._widgetManager && (cc._widgetManager._nodesOrderDirty = true);
        true, true;
        this._proxy.updateParent();
      },
      _initDataFromPool: function _initDataFromPool() {
        if (!this._spaceInfo) {
          false, false;
          this._spaceInfo = nodeMemPool.pop();
        }
        var spaceInfo = this._spaceInfo;
        this._matrix = _vmath.mat4.create(spaceInfo.localMat);
        _vmath.mat4.identity(this._matrix);
        this._worldMatrix = _vmath.mat4.create(spaceInfo.worldMat);
        _vmath.mat4.identity(this._worldMatrix);
        this._localMatDirty = LocalDirtyFlag.ALL;
        this._worldMatDirty = true;
        var trs = this._trs = this._spaceInfo.trs;
        trs[0] = 0;
        trs[1] = 0;
        trs[2] = 0;
        trs[3] = 0;
        trs[4] = 0;
        trs[5] = 0;
        trs[6] = 1;
        trs[7] = 1;
        trs[8] = 1;
        trs[9] = 1;
      },
      _backDataIntoPool: function _backDataIntoPool() {
        if (!(false, false)) {
          nodeMemPool.push(this._spaceInfo);
          this._matrix = null;
          this._worldMatrix = null;
          this._trs = null;
          this._spaceInfo = null;
        }
      },
      _toEuler: function _toEuler() {
        if (this.is3DNode) _vmath.trs.toEuler(this._eulerAngles, this._trs); else {
          var z = Math.asin(this._trs[5]) / ONE_DEGREE * 2;
          _vmath.vec3.set(this._eulerAngles, 0, 0, z);
        }
      },
      _fromEuler: function _fromEuler() {
        this.is3DNode ? _vmath.trs.fromEuler(this._trs, this._eulerAngles) : _vmath.trs.fromAngleZ(this._trs, this._eulerAngles.z);
      },
      _upgrade_1x_to_2x: function _upgrade_1x_to_2x() {
        var trs = this._trs;
        if (trs) {
          var desTrs = trs;
          trs = this._trs = this._spaceInfo.trs;
          11 === desTrs.length ? trs.set(desTrs.subarray(1)) : trs.set(desTrs);
        } else trs = this._trs = this._spaceInfo.trs;
        if (void 0 !== this._zIndex) {
          this._localZOrder = this._zIndex << 16;
          this._zIndex = void 0;
        }
        var NodeUtils;
        false;
        this._fromEuler();
        0 !== this._localZOrder && (this._zIndex = (4294901760 & this._localZOrder) >> 16);
        if (this._color.a < 255 && 255 === this._opacity) {
          this._opacity = this._color.a;
          this._color.a = 255;
        }
        true, true;
        this._renderFlag |= RenderFlow.FLAG_TRANSFORM | RenderFlow.FLAG_OPACITY_COLOR;
      },
      _onBatchCreated: function _onBatchCreated() {
        var prefabInfo = this._prefab;
        if (prefabInfo && prefabInfo.sync && prefabInfo.root === this) {
          false;
          PrefabHelper.syncWithPrefab(this);
        }
        this._upgrade_1x_to_2x();
        this._updateOrderOfArrival();
        this._cullingMask = 1 << _getActualGroupIndex(this);
        true, true;
        this._proxy && this._proxy.updateCullingMask();
        if (!this._activeInHierarchy) {
          ActionManagerExist && cc.director.getActionManager().pauseTarget(this);
          eventManager.pauseTarget(this);
        }
        var children = this._children;
        for (var i = 0, len = children.length; i < len; i++) children[i]._onBatchCreated();
        children.length > 0 && (this._renderFlag |= RenderFlow.FLAG_CHILDREN);
        true, true;
        this._proxy.initNative();
      },
      _onBatchRestored: function _onBatchRestored() {
        this._upgrade_1x_to_2x();
        this._cullingMask = 1 << _getActualGroupIndex(this);
        true, true;
        this._proxy && this._proxy.updateCullingMask();
        if (!this._activeInHierarchy) {
          var manager = cc.director.getActionManager();
          manager && manager.pauseTarget(this);
          eventManager.pauseTarget(this);
        }
        var children = this._children;
        for (var i = 0, len = children.length; i < len; i++) children[i]._onBatchRestored();
        children.length > 0 && (this._renderFlag |= RenderFlow.FLAG_CHILDREN);
        true, true;
        this._proxy.initNative();
      },
      _checknSetupSysEvent: function _checknSetupSysEvent(type) {
        var newAdded = false;
        var forDispatch = false;
        if (-1 !== _touchEvents.indexOf(type)) {
          if (!this._touchListener) {
            this._touchListener = cc.EventListener.create({
              event: cc.EventListener.TOUCH_ONE_BY_ONE,
              swallowTouches: true,
              owner: this,
              mask: _searchMaskInParent(this),
              onTouchBegan: _touchStartHandler,
              onTouchMoved: _touchMoveHandler,
              onTouchEnded: _touchEndHandler,
              onTouchCancelled: _touchCancelHandler
            });
            eventManager.addListener(this._touchListener, this);
            newAdded = true;
          }
          forDispatch = true;
        } else if (-1 !== _mouseEvents.indexOf(type)) {
          if (!this._mouseListener) {
            this._mouseListener = cc.EventListener.create({
              event: cc.EventListener.MOUSE,
              _previousIn: false,
              owner: this,
              mask: _searchMaskInParent(this),
              onMouseDown: _mouseDownHandler,
              onMouseMove: _mouseMoveHandler,
              onMouseUp: _mouseUpHandler,
              onMouseScroll: _mouseWheelHandler
            });
            eventManager.addListener(this._mouseListener, this);
            newAdded = true;
          }
          forDispatch = true;
        }
        newAdded && !this._activeInHierarchy && cc.director.getScheduler().schedule((function() {
          this._activeInHierarchy || eventManager.pauseTarget(this);
        }), this, 0, 0, 0, false);
        return forDispatch;
      },
      on: function on(type, callback, target, useCapture) {
        var forDispatch = this._checknSetupSysEvent(type);
        if (forDispatch) return this._onDispatch(type, callback, target, useCapture);
        switch (type) {
         case EventType.POSITION_CHANGED:
          this._eventMask |= POSITION_ON;
          break;

         case EventType.SCALE_CHANGED:
          this._eventMask |= SCALE_ON;
          break;

         case EventType.ROTATION_CHANGED:
          this._eventMask |= ROTATION_ON;
          break;

         case EventType.SIZE_CHANGED:
          this._eventMask |= SIZE_ON;
          break;

         case EventType.ANCHOR_CHANGED:
          this._eventMask |= ANCHOR_ON;
          break;

         case EventType.COLOR_CHANGED:
          this._eventMask |= COLOR_ON;
        }
        this._bubblingListeners || (this._bubblingListeners = new EventTarget());
        return this._bubblingListeners.on(type, callback, target);
      },
      once: function once(type, callback, target, useCapture) {
        var forDispatch = this._checknSetupSysEvent(type);
        var listeners = null;
        listeners = forDispatch && useCapture ? this._capturingListeners = this._capturingListeners || new EventTarget() : this._bubblingListeners = this._bubblingListeners || new EventTarget();
        listeners.once(type, callback, target);
      },
      _onDispatch: function _onDispatch(type, callback, target, useCapture) {
        if ("boolean" === typeof target) {
          useCapture = target;
          target = void 0;
        } else useCapture = !!useCapture;
        if (!callback) {
          cc.errorID(6800);
          return;
        }
        var listeners = null;
        listeners = useCapture ? this._capturingListeners = this._capturingListeners || new EventTarget() : this._bubblingListeners = this._bubblingListeners || new EventTarget();
        if (!listeners.hasEventListener(type, callback, target)) {
          listeners.on(type, callback, target);
          target && target.__eventTargets && target.__eventTargets.push(this);
        }
        return callback;
      },
      off: function off(type, callback, target, useCapture) {
        var touchEvent = -1 !== _touchEvents.indexOf(type);
        var mouseEvent = !touchEvent && -1 !== _mouseEvents.indexOf(type);
        if (touchEvent || mouseEvent) {
          this._offDispatch(type, callback, target, useCapture);
          if (touchEvent) {
            if (this._touchListener && !_checkListeners(this, _touchEvents)) {
              eventManager.removeListener(this._touchListener);
              this._touchListener = null;
            }
          } else if (mouseEvent && this._mouseListener && !_checkListeners(this, _mouseEvents)) {
            eventManager.removeListener(this._mouseListener);
            this._mouseListener = null;
          }
        } else if (this._bubblingListeners) {
          this._bubblingListeners.off(type, callback, target);
          var hasListeners = this._bubblingListeners.hasEventListener(type);
          if (!hasListeners) switch (type) {
           case EventType.POSITION_CHANGED:
            this._eventMask &= ~POSITION_ON;
            break;

           case EventType.SCALE_CHANGED:
            this._eventMask &= ~SCALE_ON;
            break;

           case EventType.ROTATION_CHANGED:
            this._eventMask &= ~ROTATION_ON;
            break;

           case EventType.SIZE_CHANGED:
            this._eventMask &= ~SIZE_ON;
            break;

           case EventType.ANCHOR_CHANGED:
            this._eventMask &= ~ANCHOR_ON;
            break;

           case EventType.COLOR_CHANGED:
            this._eventMask &= ~COLOR_ON;
          }
        }
      },
      _offDispatch: function _offDispatch(type, callback, target, useCapture) {
        if ("boolean" === typeof target) {
          useCapture = target;
          target = void 0;
        } else useCapture = !!useCapture;
        if (callback) {
          var listeners = useCapture ? this._capturingListeners : this._bubblingListeners;
          if (listeners) {
            listeners.off(type, callback, target);
            target && target.__eventTargets && js.array.fastRemove(target.__eventTargets, this);
          }
        } else {
          this._capturingListeners && this._capturingListeners.removeAll(type);
          this._bubblingListeners && this._bubblingListeners.removeAll(type);
        }
      },
      targetOff: function targetOff(target) {
        var listeners = this._bubblingListeners;
        if (listeners) {
          listeners.targetOff(target);
          this._eventMask & POSITION_ON && !listeners.hasEventListener(EventType.POSITION_CHANGED) && (this._eventMask &= ~POSITION_ON);
          this._eventMask & SCALE_ON && !listeners.hasEventListener(EventType.SCALE_CHANGED) && (this._eventMask &= ~SCALE_ON);
          this._eventMask & ROTATION_ON && !listeners.hasEventListener(EventType.ROTATION_CHANGED) && (this._eventMask &= ~ROTATION_ON);
          this._eventMask & SIZE_ON && !listeners.hasEventListener(EventType.SIZE_CHANGED) && (this._eventMask &= ~SIZE_ON);
          this._eventMask & ANCHOR_ON && !listeners.hasEventListener(EventType.ANCHOR_CHANGED) && (this._eventMask &= ~ANCHOR_ON);
          this._eventMask & COLOR_ON && !listeners.hasEventListener(EventType.COLOR_CHANGED) && (this._eventMask &= ~COLOR_ON);
        }
        this._capturingListeners && this._capturingListeners.targetOff(target);
        target && target.__eventTargets && js.array.fastRemove(target.__eventTargets, this);
        if (this._touchListener && !_checkListeners(this, _touchEvents)) {
          eventManager.removeListener(this._touchListener);
          this._touchListener = null;
        }
        if (this._mouseListener && !_checkListeners(this, _mouseEvents)) {
          eventManager.removeListener(this._mouseListener);
          this._mouseListener = null;
        }
      },
      hasEventListener: function hasEventListener(type) {
        var has = false;
        this._bubblingListeners && (has = this._bubblingListeners.hasEventListener(type));
        !has && this._capturingListeners && (has = this._capturingListeners.hasEventListener(type));
        return has;
      },
      emit: function emit(type, arg1, arg2, arg3, arg4, arg5) {
        this._bubblingListeners && this._bubblingListeners.emit(type, arg1, arg2, arg3, arg4, arg5);
      },
      dispatchEvent: function dispatchEvent(event) {
        _doDispatchEvent(this, event);
        _cachedArray.length = 0;
      },
      pauseSystemEvents: function pauseSystemEvents(recursive) {
        eventManager.pauseTarget(this, recursive);
      },
      resumeSystemEvents: function resumeSystemEvents(recursive) {
        eventManager.resumeTarget(this, recursive);
      },
      _hitTest: function _hitTest(point, listener) {
        var w = this._contentSize.width, h = this._contentSize.height, cameraPt = _htVec3a, testPt = _htVec3b;
        var camera = cc.Camera.findCamera(this);
        camera ? camera.getScreenToWorldPoint(point, cameraPt) : cameraPt.set(point);
        this._updateWorldMatrix();
        if (!_vmath.mat4.invert(_mat4_temp, this._worldMatrix)) return false;
        _vmath.vec2.transformMat4(testPt, cameraPt, _mat4_temp);
        testPt.x += this._anchorPoint.x * w;
        testPt.y += this._anchorPoint.y * h;
        if (testPt.x >= 0 && testPt.y >= 0 && testPt.x <= w && testPt.y <= h) {
          if (listener && listener.mask) {
            var mask = listener.mask;
            var parent = this;
            for (var i = 0; parent && i < mask.index; ++i, parent = parent.parent) ;
            if (parent === mask.node) {
              var comp = parent.getComponent(cc.Mask);
              return !comp || !comp.enabledInHierarchy || comp._hitTest(cameraPt);
            }
            listener.mask = null;
            return true;
          }
          return true;
        }
        return false;
      },
      _getCapturingTargets: function _getCapturingTargets(type, array) {
        var parent = this.parent;
        while (parent) {
          parent._capturingListeners && parent._capturingListeners.hasEventListener(type) && array.push(parent);
          parent = parent.parent;
        }
      },
      _getBubblingTargets: function _getBubblingTargets(type, array) {
        var parent = this.parent;
        while (parent) {
          parent._bubblingListeners && parent._bubblingListeners.hasEventListener(type) && array.push(parent);
          parent = parent.parent;
        }
      },
      runAction: ActionManagerExist ? function(action) {
        if (!this.active) return;
        cc.assertID(action, 1618);
        cc.director.getActionManager().addAction(action, this, false);
        return action;
      } : emptyFunc,
      pauseAllActions: ActionManagerExist ? function() {
        cc.director.getActionManager().pauseTarget(this);
      } : emptyFunc,
      resumeAllActions: ActionManagerExist ? function() {
        cc.director.getActionManager().resumeTarget(this);
      } : emptyFunc,
      stopAllActions: ActionManagerExist ? function() {
        cc.director.getActionManager().removeAllActionsFromTarget(this);
      } : emptyFunc,
      stopAction: ActionManagerExist ? function(action) {
        cc.director.getActionManager().removeAction(action);
      } : emptyFunc,
      stopActionByTag: ActionManagerExist ? function(tag) {
        if (tag === cc.Action.TAG_INVALID) {
          cc.logID(1612);
          return;
        }
        cc.director.getActionManager().removeActionByTag(tag, this);
      } : emptyFunc,
      getActionByTag: ActionManagerExist ? function(tag) {
        if (tag === cc.Action.TAG_INVALID) {
          cc.logID(1613);
          return null;
        }
        return cc.director.getActionManager().getActionByTag(tag, this);
      } : function() {
        return null;
      },
      getNumberOfRunningActions: ActionManagerExist ? function() {
        return cc.director.getActionManager().getNumberOfRunningActionsInTarget(this);
      } : function() {
        return 0;
      },
      getPosition: function getPosition(out) {
        out = out || cc.v3();
        return _vmath.trs.toPosition(out, this._trs);
      },
      setPosition: function setPosition(newPosOrX, y) {
        var x;
        if (void 0 === y) {
          x = newPosOrX.x;
          y = newPosOrX.y;
        } else x = newPosOrX;
        var trs = this._trs;
        if (trs[0] === x && trs[1] === y) return;
        var oldPosition;
        false;
        true;
        trs[0] = x;
        true;
        trs[1] = y;
        this.setLocalDirty(LocalDirtyFlag.POSITION);
        if (this._eventMask & POSITION_ON) {
          false;
          this.emit(EventType.POSITION_CHANGED);
        }
      },
      getScale: function getScale(out) {
        if (void 0 !== out) return _vmath.trs.toScale(out, this._trs);
        cc.warnID(1400, "cc.Node.getScale", "cc.Node.scale or cc.Node.getScale(cc.Vec3)");
        return this._trs[7];
      },
      setScale: function setScale(x, y) {
        if (x && "number" !== typeof x) {
          y = x.y;
          x = x.x;
        } else void 0 === y && (y = x);
        var trs = this._trs;
        if (trs[7] !== x || trs[8] !== y) {
          trs[7] = x;
          trs[8] = y;
          this.setLocalDirty(LocalDirtyFlag.SCALE);
          this._eventMask & SCALE_ON && this.emit(EventType.SCALE_CHANGED);
        }
      },
      getRotation: function getRotation(out) {
        if (out instanceof cc.Quat) return _vmath.trs.toRotation(out, this._trs);
        true;
        cc.warn("`cc.Node.getRotation()` is deprecated since v2.1.0, please use `-cc.Node.angle` instead. (`this.node.getRotation()` -> `-this.node.angle`)");
        return -this.angle;
      },
      setRotation: function setRotation(quat, y, z, w) {
        if ("number" === typeof quat && void 0 === y) {
          true;
          cc.warn("`cc.Node.setRotation(degree)` is deprecated since v2.1.0, please set `-cc.Node.angle` instead. (`this.node.setRotation(x)` -> `this.node.angle = -x`)");
          this.angle = -quat;
        } else {
          var x = quat;
          if (void 0 === y) {
            x = quat.x;
            y = quat.y;
            z = quat.z;
            w = quat.w;
          }
          var _trs = this._trs;
          if (_trs[3] !== x || _trs[4] !== y || _trs[5] !== z || _trs[6] !== w) {
            _trs[3] = x;
            _trs[4] = y;
            _trs[5] = z;
            _trs[6] = w;
            this.setLocalDirty(LocalDirtyFlag.ROTATION);
            this._eventMask & ROTATION_ON && this.emit(EventType.ROTATION_CHANGED);
            false;
          }
        }
      },
      getContentSize: function getContentSize() {
        return cc.size(this._contentSize.width, this._contentSize.height);
      },
      setContentSize: function setContentSize(size, height) {
        var locContentSize = this._contentSize;
        var clone;
        if (void 0 === height) {
          if (size.width === locContentSize.width && size.height === locContentSize.height) return;
          false;
          locContentSize.width = size.width;
          locContentSize.height = size.height;
        } else {
          if (size === locContentSize.width && height === locContentSize.height) return;
          false;
          locContentSize.width = size;
          locContentSize.height = height;
        }
        if (this._eventMask & SIZE_ON) {
          false;
          this.emit(EventType.SIZE_CHANGED);
        }
      },
      getAnchorPoint: function getAnchorPoint() {
        return cc.v2(this._anchorPoint);
      },
      setAnchorPoint: function setAnchorPoint(point, y) {
        var locAnchorPoint = this._anchorPoint;
        if (void 0 === y) {
          if (point.x === locAnchorPoint.x && point.y === locAnchorPoint.y) return;
          locAnchorPoint.x = point.x;
          locAnchorPoint.y = point.y;
        } else {
          if (point === locAnchorPoint.x && y === locAnchorPoint.y) return;
          locAnchorPoint.x = point;
          locAnchorPoint.y = y;
        }
        this.setLocalDirty(LocalDirtyFlag.POSITION);
        this._eventMask & ANCHOR_ON && this.emit(EventType.ANCHOR_CHANGED);
      },
      _invTransformPoint: function _invTransformPoint(out, pos) {
        this._parent ? this._parent._invTransformPoint(out, pos) : _vmath.vec3.copy(out, pos);
        var ltrs = this._trs;
        _vmath.trs.toPosition(_tpVec3a, ltrs);
        _vmath.vec3.sub(out, out, _tpVec3a);
        _vmath.trs.toRotation(_tpQuata, ltrs);
        _vmath.quat.conjugate(_tpQuatb, _tpQuata);
        _vmath.vec3.transformQuat(out, out, _tpQuatb);
        _vmath.trs.toScale(_tpVec3a, ltrs);
        _vmath.vec3.inverseSafe(_tpVec3b, _tpVec3a);
        _vmath.vec3.mul(out, out, _tpVec3b);
        return out;
      },
      getWorldPosition: function getWorldPosition(out) {
        _vmath.trs.toPosition(out, this._trs);
        var curr = this._parent;
        var ltrs = void 0;
        while (curr) {
          ltrs = curr._trs;
          _vmath.trs.toScale(_gwpVec3, ltrs);
          _vmath.vec3.mul(out, out, _gwpVec3);
          _vmath.trs.toRotation(_gwpQuat, ltrs);
          _vmath.vec3.transformQuat(out, out, _gwpQuat);
          _vmath.trs.toPosition(_gwpVec3, ltrs);
          _vmath.vec3.add(out, out, _gwpVec3);
          curr = curr._parent;
        }
        return out;
      },
      setWorldPosition: function setWorldPosition(pos) {
        var ltrs = this._trs;
        var oldPosition;
        false;
        this._parent ? this._parent._invTransformPoint(_swpVec3, pos) : _vmath.vec3.copy(_swpVec3, pos);
        _vmath.trs.fromPosition(ltrs, _swpVec3);
        this.setLocalDirty(LocalDirtyFlag.POSITION);
        if (this._eventMask & POSITION_ON) {
          false;
          this.emit(EventType.POSITION_CHANGED);
        }
      },
      getWorldRotation: function getWorldRotation(out) {
        _vmath.trs.toRotation(_gwrQuat, this._trs);
        _vmath.quat.copy(out, _gwrQuat);
        var curr = this._parent;
        while (curr) {
          _vmath.trs.toRotation(_gwrQuat, curr._trs);
          _vmath.quat.mul(out, _gwrQuat, out);
          curr = curr._parent;
        }
        return out;
      },
      setWorldRotation: function setWorldRotation(val) {
        if (this._parent) {
          this._parent.getWorldRotation(_swrQuat);
          _vmath.quat.conjugate(_swrQuat, _swrQuat);
          _vmath.quat.mul(_swrQuat, _swrQuat, val);
        } else _vmath.quat.copy(_swrQuat, val);
        _vmath.trs.fromRotation(this._trs, _swrQuat);
        false;
        this.setLocalDirty(LocalDirtyFlag.ROTATION);
      },
      getWorldScale: function getWorldScale(out) {
        _vmath.trs.toScale(_gwsVec3, this._trs);
        _vmath.vec3.copy(out, _gwsVec3);
        var curr = this._parent;
        while (curr) {
          _vmath.trs.toScale(_gwsVec3, curr._trs);
          _vmath.vec3.mul(out, out, _gwsVec3);
          curr = curr._parent;
        }
        return out;
      },
      setWorldScale: function setWorldScale(scale) {
        if (this._parent) {
          this._parent.getWorldScale(_swsVec3);
          _vmath.vec3.div(_swsVec3, scale, _swsVec3);
        } else _vmath.vec3.copy(_swsVec3, scale);
        _vmath.trs.fromScale(this._trs, _swsVec3);
        this.setLocalDirty(LocalDirtyFlag.SCALE);
      },
      getWorldRT: function getWorldRT(out) {
        var opos = _gwrtVec3a;
        var orot = _gwrtQuata;
        var ltrs = this._trs;
        _vmath.trs.toPosition(opos, ltrs);
        _vmath.trs.toRotation(orot, ltrs);
        var curr = this._parent;
        while (curr) {
          ltrs = curr._trs;
          _vmath.trs.toScale(_gwrtVec3b, ltrs);
          _vmath.vec3.mul(opos, opos, _gwrtVec3b);
          _vmath.trs.toRotation(_gwrtQuatb, ltrs);
          _vmath.vec3.transformQuat(opos, opos, _gwrtQuatb);
          _vmath.trs.toPosition(_gwrtVec3b, ltrs);
          _vmath.vec3.add(opos, opos, _gwrtVec3b);
          _vmath.quat.mul(orot, _gwrtQuatb, orot);
          curr = curr._parent;
        }
        _vmath.mat4.fromRT(out, orot, opos);
        return out;
      },
      lookAt: function lookAt(pos, up) {
        this.getWorldPosition(_laVec3);
        _vmath.vec3.sub(_laVec3, _laVec3, pos);
        _vmath.vec3.normalize(_laVec3, _laVec3);
        _vmath.quat.fromViewUp(_laQuat, _laVec3, up);
        this.setWorldRotation(_laQuat);
      },
      _updateLocalMatrix: function _updateLocalMatrix() {
        var dirtyFlag = this._localMatDirty;
        if (!dirtyFlag) return;
        var t = this._matrix;
        var tm = t.m;
        var trs = this._trs;
        if (dirtyFlag & (LocalDirtyFlag.RS | LocalDirtyFlag.SKEW)) {
          var rotation = -this._eulerAngles.z;
          var hasSkew = this._skewX || this._skewY;
          var sx = trs[7], sy = trs[8];
          if (rotation || hasSkew) {
            var a = 1, b = 0, c = 0, d = 1;
            if (rotation) {
              var rotationRadians = rotation * ONE_DEGREE;
              c = Math.sin(rotationRadians);
              d = Math.cos(rotationRadians);
              a = d;
              b = -c;
            }
            tm[0] = a *= sx;
            tm[1] = b *= sx;
            tm[4] = c *= sy;
            tm[5] = d *= sy;
            if (hasSkew) {
              var _a = tm[0], _b = tm[1], _c = tm[4], _d = tm[5];
              var skx = Math.tan(this._skewX * ONE_DEGREE);
              var sky = Math.tan(this._skewY * ONE_DEGREE);
              Infinity === skx && (skx = 99999999);
              Infinity === sky && (sky = 99999999);
              tm[0] = _a + _c * sky;
              tm[1] = _b + _d * sky;
              tm[4] = _c + _a * skx;
              tm[5] = _d + _b * skx;
            }
          } else {
            tm[0] = sx;
            tm[1] = 0;
            tm[4] = 0;
            tm[5] = sy;
          }
        }
        tm[12] = trs[0];
        tm[13] = trs[1];
        this._localMatDirty = 0;
        this._worldMatDirty = true;
      },
      _calculWorldMatrix: function _calculWorldMatrix() {
        this._localMatDirty && this._updateLocalMatrix();
        var parent = this._parent;
        parent ? this._mulMat(this._worldMatrix, parent._worldMatrix, this._matrix) : _vmath.mat4.copy(this._worldMatrix, this._matrix);
        this._worldMatDirty = false;
      },
      _mulMat: function _mulMat(out, a, b) {
        var am = a.m, bm = b.m, outm = out.m;
        var aa = am[0], ab = am[1], ac = am[4], ad = am[5], atx = am[12], aty = am[13];
        var ba = bm[0], bb = bm[1], bc = bm[4], bd = bm[5], btx = bm[12], bty = bm[13];
        if (0 !== ab || 0 !== ac) {
          outm[0] = ba * aa + bb * ac;
          outm[1] = ba * ab + bb * ad;
          outm[4] = bc * aa + bd * ac;
          outm[5] = bc * ab + bd * ad;
          outm[12] = aa * btx + ac * bty + atx;
          outm[13] = ab * btx + ad * bty + aty;
        } else {
          outm[0] = ba * aa;
          outm[1] = bb * ad;
          outm[4] = bc * aa;
          outm[5] = bd * ad;
          outm[12] = aa * btx + atx;
          outm[13] = ad * bty + aty;
        }
      },
      _updateWorldMatrix: function _updateWorldMatrix() {
        this._parent && this._parent._updateWorldMatrix();
        if (this._worldMatDirty) {
          this._calculWorldMatrix();
          var children = this._children;
          for (var i = 0, l = children.length; i < l; i++) children[i]._worldMatDirty = true;
        }
      },
      setLocalDirty: function setLocalDirty(flag) {
        this._localMatDirty |= flag;
        this._worldMatDirty = true;
        flag === LocalDirtyFlag.POSITION ? this._renderFlag |= RenderFlow.FLAG_WORLD_TRANSFORM : this._renderFlag |= RenderFlow.FLAG_TRANSFORM;
      },
      setWorldDirty: function setWorldDirty() {
        this._worldMatDirty = true;
      },
      getLocalMatrix: function getLocalMatrix(out) {
        this._updateLocalMatrix();
        return _vmath.mat4.copy(out, this._matrix);
      },
      getWorldMatrix: function getWorldMatrix(out) {
        this._updateWorldMatrix();
        return _vmath.mat4.copy(out, this._worldMatrix);
      },
      convertToNodeSpaceAR: function convertToNodeSpaceAR(worldPoint, out) {
        this._updateWorldMatrix();
        _vmath.mat4.invert(_mat4_temp, this._worldMatrix);
        if (worldPoint instanceof cc.Vec2) {
          out = out || new cc.Vec2();
          return _vmath.vec2.transformMat4(out, worldPoint, _mat4_temp);
        }
        out = out || new cc.Vec3();
        return _vmath.vec3.transformMat4(out, worldPoint, _mat4_temp);
      },
      convertToWorldSpaceAR: function convertToWorldSpaceAR(nodePoint, out) {
        this._updateWorldMatrix();
        if (nodePoint instanceof cc.Vec2) {
          out = out || new cc.Vec2();
          return _vmath.vec2.transformMat4(out, nodePoint, this._worldMatrix);
        }
        out = out || new cc.Vec3();
        return _vmath.vec3.transformMat4(out, nodePoint, this._worldMatrix);
      },
      convertToNodeSpace: function convertToNodeSpace(worldPoint) {
        this._updateWorldMatrix();
        _vmath.mat4.invert(_mat4_temp, this._worldMatrix);
        var out = new cc.Vec2();
        _vmath.vec2.transformMat4(out, worldPoint, _mat4_temp);
        out.x += this._anchorPoint.x * this._contentSize.width;
        out.y += this._anchorPoint.y * this._contentSize.height;
        return out;
      },
      convertToWorldSpace: function convertToWorldSpace(nodePoint) {
        this._updateWorldMatrix();
        var out = new cc.Vec2(nodePoint.x - this._anchorPoint.x * this._contentSize.width, nodePoint.y - this._anchorPoint.y * this._contentSize.height);
        return _vmath.vec2.transformMat4(out, out, this._worldMatrix);
      },
      getNodeToParentTransform: function getNodeToParentTransform(out) {
        out || (out = AffineTrans.identity());
        this._updateLocalMatrix();
        var contentSize = this._contentSize;
        _vec3_temp.x = -this._anchorPoint.x * contentSize.width;
        _vec3_temp.y = -this._anchorPoint.y * contentSize.height;
        _vmath.mat4.copy(_mat4_temp, this._matrix);
        _vmath.mat4.translate(_mat4_temp, _mat4_temp, _vec3_temp);
        return AffineTrans.fromMat4(out, _mat4_temp);
      },
      getNodeToParentTransformAR: function getNodeToParentTransformAR(out) {
        out || (out = AffineTrans.identity());
        this._updateLocalMatrix();
        return AffineTrans.fromMat4(out, this._matrix);
      },
      getNodeToWorldTransform: function getNodeToWorldTransform(out) {
        out || (out = AffineTrans.identity());
        this._updateWorldMatrix();
        var contentSize = this._contentSize;
        _vec3_temp.x = -this._anchorPoint.x * contentSize.width;
        _vec3_temp.y = -this._anchorPoint.y * contentSize.height;
        _vmath.mat4.copy(_mat4_temp, this._worldMatrix);
        _vmath.mat4.translate(_mat4_temp, _mat4_temp, _vec3_temp);
        return AffineTrans.fromMat4(out, _mat4_temp);
      },
      getNodeToWorldTransformAR: function getNodeToWorldTransformAR(out) {
        out || (out = AffineTrans.identity());
        this._updateWorldMatrix();
        return AffineTrans.fromMat4(out, this._worldMatrix);
      },
      getParentToNodeTransform: function getParentToNodeTransform(out) {
        out || (out = AffineTrans.identity());
        this._updateLocalMatrix();
        _vmath.mat4.invert(_mat4_temp, this._matrix);
        return AffineTrans.fromMat4(out, _mat4_temp);
      },
      getWorldToNodeTransform: function getWorldToNodeTransform(out) {
        out || (out = AffineTrans.identity());
        this._updateWorldMatrix();
        _vmath.mat4.invert(_mat4_temp, this._worldMatrix);
        return AffineTrans.fromMat4(out, _mat4_temp);
      },
      convertTouchToNodeSpace: function convertTouchToNodeSpace(touch) {
        return this.convertToNodeSpace(touch.getLocation());
      },
      convertTouchToNodeSpaceAR: function convertTouchToNodeSpaceAR(touch) {
        return this.convertToNodeSpaceAR(touch.getLocation());
      },
      getBoundingBox: function getBoundingBox() {
        this._updateLocalMatrix();
        var width = this._contentSize.width;
        var height = this._contentSize.height;
        var rect = cc.rect(-this._anchorPoint.x * width, -this._anchorPoint.y * height, width, height);
        return rect.transformMat4(rect, this._matrix);
      },
      getBoundingBoxToWorld: function getBoundingBoxToWorld() {
        if (this._parent) {
          this._parent._updateWorldMatrix();
          return this._getBoundingBoxTo(this._parent._worldMatrix);
        }
        return this.getBoundingBox();
      },
      _getBoundingBoxTo: function _getBoundingBoxTo(parentMat) {
        this._updateLocalMatrix();
        var width = this._contentSize.width;
        var height = this._contentSize.height;
        var rect = cc.rect(-this._anchorPoint.x * width, -this._anchorPoint.y * height, width, height);
        var parentMat = _vmath.mat4.mul(this._worldMatrix, parentMat, this._matrix);
        rect.transformMat4(rect, parentMat);
        if (!this._children) return rect;
        var locChildren = this._children;
        for (var i = 0; i < locChildren.length; i++) {
          var child = locChildren[i];
          if (child && child.active) {
            var childRect = child._getBoundingBoxTo(parentMat);
            childRect && rect.union(rect, childRect);
          }
        }
        return rect;
      },
      _updateOrderOfArrival: function _updateOrderOfArrival() {
        var arrivalOrder = this._parent ? ++this._parent._childArrivalOrder : 0;
        this._localZOrder = 4294901760 & this._localZOrder | arrivalOrder;
        if (65535 === arrivalOrder) {
          var siblings = this._parent._children;
          siblings.forEach((function(node, index) {
            node._localZOrder = 4294901760 & node._localZOrder | index + 1;
          }));
          this._parent._childArrivalOrder = siblings.length;
        }
        this.emit(EventType.SIBLING_ORDER_CHANGED);
      },
      addChild: function addChild(child, zIndex, name) {
        false;
        cc.assertID(child, 1606);
        cc.assertID(null === child._parent, 1605);
        child.parent = this;
        void 0 !== zIndex && (child.zIndex = zIndex);
        void 0 !== name && (child.name = name);
      },
      cleanup: function cleanup() {
        ActionManagerExist && cc.director.getActionManager().removeAllActionsFromTarget(this);
        eventManager.removeListeners(this);
        var i, len = this._children.length, node;
        for (i = 0; i < len; ++i) {
          node = this._children[i];
          node && node.cleanup();
        }
      },
      sortAllChildren: function sortAllChildren() {
        if (this._reorderChildDirty) {
          eventManager._setDirtyForNode(this);
          this._reorderChildDirty = false;
          var _children = this._children;
          if (_children.length > 1) {
            var len = _children.length, i, j, child;
            for (i = 1; i < len; i++) {
              child = _children[i];
              j = i - 1;
              while (j >= 0) {
                if (!(child._localZOrder < _children[j]._localZOrder)) break;
                _children[j + 1] = _children[j];
                j--;
              }
              _children[j + 1] = child;
            }
            this.emit(EventType.CHILD_REORDER, this);
          }
          cc.director.__fastOff(cc.Director.EVENT_AFTER_UPDATE, this.sortAllChildren, this);
        }
      },
      _delaySort: function _delaySort() {
        if (!this._reorderChildDirty) {
          this._reorderChildDirty = true;
          cc.director.__fastOn(cc.Director.EVENT_AFTER_UPDATE, this.sortAllChildren, this);
        }
      },
      _restoreProperties: false,
      onRestore: false
    };
    false;
    var Node = cc.Class(NodeDefines);
    var _p = Node.prototype;
    js.getset(_p, "position", _p.getPosition, _p.setPosition, false, true);
    cc.Node = module.exports = Node;
  }), {
    "./event-manager": 130,
    "./event/event": 133,
    "./event/event-target": 132,
    "./platform/CCMacro": 204,
    "./platform/js": 219,
    "./renderer/render-flow": 249,
    "./utils/affine-transform": 289,
    "./utils/base-node": 290,
    "./utils/prefab-helper": 302,
    "./utils/trans-pool": 308,
    "./vmath": 325
  } ],
  54: [ (function(require, module, exports) {
    "use strict";
    var Node = require("./CCNode");
    var RenderFlow = require("./renderer/render-flow");
    var HideInHierarchy = cc.Object.Flags.HideInHierarchy;
    var LocalDirtyFlag = Node._LocalDirtyFlag;
    var POSITION_ON = 1;
    var PrivateNode = cc.Class({
      name: "cc.PrivateNode",
      extends: Node,
      properties: {
        x: {
          get: function get() {
            return this._originPos.x;
          },
          set: function set(value) {
            var localPosition = this._originPos;
            if (value !== localPosition.x) {
              localPosition.x = value;
              this._posDirty(true);
            }
          },
          override: true
        },
        y: {
          get: function get() {
            return this._originPos.y;
          },
          set: function set(value) {
            var localPosition = this._originPos;
            if (value !== localPosition.y) {
              localPosition.y = value;
              this._posDirty(true);
            }
          },
          override: true
        },
        zIndex: {
          get: function get() {
            return cc.macro.MIN_ZINDEX;
          },
          set: function set() {
            cc.warnID(1638);
          },
          override: true
        },
        showInEditor: {
          default: false,
          editorOnly: true,
          override: true
        }
      },
      ctor: function ctor(name) {
        this._localZOrder = cc.macro.MIN_ZINDEX << 16;
        this._originPos = cc.v2();
        false;
      },
      _posDirty: function _posDirty(sendEvent) {
        this.setLocalDirty(LocalDirtyFlag.POSITION);
        false;
        true === sendEvent && this._eventMask & POSITION_ON && this.emit(Node.EventType.POSITION_CHANGED);
      },
      _updateLocalMatrix: function _updateLocalMatrix() {
        if (!this._localMatDirty) return;
        var parent = this.parent;
        if (parent) {
          this._trs[0] = this._originPos.x - (parent._anchorPoint.x - .5) * parent._contentSize.width;
          this._trs[1] = this._originPos.y - (parent._anchorPoint.y - .5) * parent._contentSize.height;
        }
        this._super();
      },
      getPosition: function getPosition() {
        return new cc.Vec2(this._originPos);
      },
      setPosition: function setPosition(x, y) {
        if (void 0 === y) {
          x = x.x;
          y = x.y;
        }
        var pos = this._originPos;
        if (pos.x === x && pos.y === y) return;
        pos.x = x;
        pos.y = y;
        this._posDirty(true);
      },
      setParent: function setParent(value) {
        var oldParent = this._parent;
        this._super(value);
        if (oldParent !== value) {
          oldParent && oldParent.off(Node.EventType.ANCHOR_CHANGED, this._posDirty, this);
          value && value.on(Node.EventType.ANCHOR_CHANGED, this._posDirty, this);
        }
      },
      _updateOrderOfArrival: function _updateOrderOfArrival() {}
    });
    cc.js.getset(PrivateNode.prototype, "parent", PrivateNode.prototype.getParent, PrivateNode.prototype.setParent);
    cc.js.getset(PrivateNode.prototype, "position", PrivateNode.prototype.getPosition, PrivateNode.prototype.setPosition);
    cc.PrivateNode = module.exports = PrivateNode;
  }), {
    "./CCNode": 53,
    "./renderer/render-flow": 249
  } ],
  55: [ (function(require, module, exports) {
    "use strict";
    var NIL = function NIL() {};
    cc.Scene = cc.Class({
      name: "cc.Scene",
      extends: require("./CCNode"),
      properties: {
        _is3DNode: {
          default: true,
          override: true
        },
        autoReleaseAssets: {
          default: void 0,
          type: cc.Boolean
        }
      },
      ctor: function ctor() {
        this._anchorPoint.x = 0;
        this._anchorPoint.y = 0;
        this._activeInHierarchy = false;
        this._inited = !cc.game._isCloning;
        false;
        this.dependAssets = null;
      },
      destroy: function destroy() {
        if (cc.Object.prototype.destroy.call(this)) {
          var children = this._children;
          for (var i = 0; i < children.length; ++i) children[i].active = false;
        }
        this._active = false;
        this._activeInHierarchy = false;
      },
      _onHierarchyChanged: NIL,
      _instantiate: null,
      _load: function _load() {
        if (!this._inited) {
          false;
          false;
          this._onBatchCreated();
          this._inited = true;
        }
      },
      _activate: function _activate(active) {
        active = false !== active;
        false, false;
        cc.director._nodeActivator.activateNode(this, active);
      }
    });
    module.exports = cc.Scene;
  }), {
    "./CCNode": 53
  } ],
  56: [ (function(require, module, exports) {
    "use strict";
    var js = require("./platform/js");
    var IdGenerater = require("./platform/id-generater");
    var MAX_POOL_SIZE = 20;
    var idGenerater = new IdGenerater("Scheduler");
    var ListEntry = function ListEntry(target, priority, paused, markedForDeletion) {
      this.target = target;
      this.priority = priority;
      this.paused = paused;
      this.markedForDeletion = markedForDeletion;
    };
    var _listEntries = [];
    ListEntry.get = function(target, priority, paused, markedForDeletion) {
      var result = _listEntries.pop();
      if (result) {
        result.target = target;
        result.priority = priority;
        result.paused = paused;
        result.markedForDeletion = markedForDeletion;
      } else result = new ListEntry(target, priority, paused, markedForDeletion);
      return result;
    };
    ListEntry.put = function(entry) {
      if (_listEntries.length < MAX_POOL_SIZE) {
        entry.target = null;
        _listEntries.push(entry);
      }
    };
    var HashUpdateEntry = function HashUpdateEntry(list, entry, target, callback) {
      this.list = list;
      this.entry = entry;
      this.target = target;
      this.callback = callback;
    };
    var _hashUpdateEntries = [];
    HashUpdateEntry.get = function(list, entry, target, callback) {
      var result = _hashUpdateEntries.pop();
      if (result) {
        result.list = list;
        result.entry = entry;
        result.target = target;
        result.callback = callback;
      } else result = new HashUpdateEntry(list, entry, target, callback);
      return result;
    };
    HashUpdateEntry.put = function(entry) {
      if (_hashUpdateEntries.length < MAX_POOL_SIZE) {
        entry.list = entry.entry = entry.target = entry.callback = null;
        _hashUpdateEntries.push(entry);
      }
    };
    var HashTimerEntry = function HashTimerEntry(timers, target, timerIndex, currentTimer, currentTimerSalvaged, paused) {
      var _t = this;
      _t.timers = timers;
      _t.target = target;
      _t.timerIndex = timerIndex;
      _t.currentTimer = currentTimer;
      _t.currentTimerSalvaged = currentTimerSalvaged;
      _t.paused = paused;
    };
    var _hashTimerEntries = [];
    HashTimerEntry.get = function(timers, target, timerIndex, currentTimer, currentTimerSalvaged, paused) {
      var result = _hashTimerEntries.pop();
      if (result) {
        result.timers = timers;
        result.target = target;
        result.timerIndex = timerIndex;
        result.currentTimer = currentTimer;
        result.currentTimerSalvaged = currentTimerSalvaged;
        result.paused = paused;
      } else result = new HashTimerEntry(timers, target, timerIndex, currentTimer, currentTimerSalvaged, paused);
      return result;
    };
    HashTimerEntry.put = function(entry) {
      if (_hashTimerEntries.length < MAX_POOL_SIZE) {
        entry.timers = entry.target = entry.currentTimer = null;
        _hashTimerEntries.push(entry);
      }
    };
    function CallbackTimer() {
      this._lock = false;
      this._scheduler = null;
      this._elapsed = -1;
      this._runForever = false;
      this._useDelay = false;
      this._timesExecuted = 0;
      this._repeat = 0;
      this._delay = 0;
      this._interval = 0;
      this._target = null;
      this._callback = null;
    }
    var proto = CallbackTimer.prototype;
    proto.initWithCallback = function(scheduler, callback, target, seconds, repeat, delay) {
      this._lock = false;
      this._scheduler = scheduler;
      this._target = target;
      this._callback = callback;
      this._elapsed = -1;
      this._interval = seconds;
      this._delay = delay;
      this._useDelay = this._delay > 0;
      this._repeat = repeat;
      this._runForever = this._repeat === cc.macro.REPEAT_FOREVER;
      return true;
    };
    proto.getInterval = function() {
      return this._interval;
    };
    proto.setInterval = function(interval) {
      this._interval = interval;
    };
    proto.update = function(dt) {
      if (-1 === this._elapsed) {
        this._elapsed = 0;
        this._timesExecuted = 0;
      } else {
        this._elapsed += dt;
        if (this._runForever && !this._useDelay) {
          if (this._elapsed >= this._interval) {
            this.trigger();
            this._elapsed = 0;
          }
        } else {
          if (this._useDelay) {
            if (this._elapsed >= this._delay) {
              this.trigger();
              this._elapsed -= this._delay;
              this._timesExecuted += 1;
              this._useDelay = false;
            }
          } else if (this._elapsed >= this._interval) {
            this.trigger();
            this._elapsed = 0;
            this._timesExecuted += 1;
          }
          this._callback && !this._runForever && this._timesExecuted > this._repeat && this.cancel();
        }
      }
    };
    proto.getCallback = function() {
      return this._callback;
    };
    proto.trigger = function() {
      if (this._target && this._callback) {
        this._lock = true;
        this._callback.call(this._target, this._elapsed);
        this._lock = false;
      }
    };
    proto.cancel = function() {
      this._scheduler.unschedule(this._callback, this._target);
    };
    var _timers = [];
    CallbackTimer.get = function() {
      return _timers.pop() || new CallbackTimer();
    };
    CallbackTimer.put = function(timer) {
      if (_timers.length < MAX_POOL_SIZE && !timer._lock) {
        timer._scheduler = timer._target = timer._callback = null;
        _timers.push(timer);
      }
    };
    cc.Scheduler = function() {
      this._timeScale = 1;
      this._updatesNegList = [];
      this._updates0List = [];
      this._updatesPosList = [];
      this._hashForUpdates = js.createMap(true);
      this._hashForTimers = js.createMap(true);
      this._currentTarget = null;
      this._currentTargetSalvaged = false;
      this._updateHashLocked = false;
      this._arrayForTimers = [];
    };
    cc.Scheduler.prototype = {
      constructor: cc.Scheduler,
      _removeHashElement: function _removeHashElement(element) {
        delete this._hashForTimers[element.target._id];
        var arr = this._arrayForTimers;
        for (var i = 0, l = arr.length; i < l; i++) if (arr[i] === element) {
          arr.splice(i, 1);
          break;
        }
        HashTimerEntry.put(element);
      },
      _removeUpdateFromHash: function _removeUpdateFromHash(entry) {
        var targetId = entry.target._id;
        var self = this, element = self._hashForUpdates[targetId];
        if (element) {
          var list = element.list, listEntry = element.entry;
          for (var i = 0, l = list.length; i < l; i++) if (list[i] === listEntry) {
            list.splice(i, 1);
            break;
          }
          delete self._hashForUpdates[targetId];
          ListEntry.put(listEntry);
          HashUpdateEntry.put(element);
        }
      },
      _priorityIn: function _priorityIn(ppList, listElement, priority) {
        for (var i = 0; i < ppList.length; i++) if (priority < ppList[i].priority) {
          ppList.splice(i, 0, listElement);
          return;
        }
        ppList.push(listElement);
      },
      _appendIn: function _appendIn(ppList, listElement) {
        ppList.push(listElement);
      },
      enableForTarget: function enableForTarget(target) {
        target._id || (target.__instanceId ? cc.warnID(1513) : target._id = idGenerater.getNewId());
      },
      setTimeScale: function setTimeScale(timeScale) {
        this._timeScale = timeScale;
      },
      getTimeScale: function getTimeScale() {
        return this._timeScale;
      },
      update: function update(dt) {
        this._updateHashLocked = true;
        1 !== this._timeScale && (dt *= this._timeScale);
        var i, list, len, entry;
        for (i = 0, list = this._updatesNegList, len = list.length; i < len; i++) {
          entry = list[i];
          entry.paused || entry.markedForDeletion || entry.target.update(dt);
        }
        for (i = 0, list = this._updates0List, len = list.length; i < len; i++) {
          entry = list[i];
          entry.paused || entry.markedForDeletion || entry.target.update(dt);
        }
        for (i = 0, list = this._updatesPosList, len = list.length; i < len; i++) {
          entry = list[i];
          entry.paused || entry.markedForDeletion || entry.target.update(dt);
        }
        var elt, arr = this._arrayForTimers;
        for (i = 0; i < arr.length; i++) {
          elt = arr[i];
          this._currentTarget = elt;
          this._currentTargetSalvaged = false;
          if (!elt.paused) for (elt.timerIndex = 0; elt.timerIndex < elt.timers.length; ++elt.timerIndex) {
            elt.currentTimer = elt.timers[elt.timerIndex];
            elt.currentTimerSalvaged = false;
            elt.currentTimer.update(dt);
            elt.currentTimer = null;
          }
          if (this._currentTargetSalvaged && 0 === this._currentTarget.timers.length) {
            this._removeHashElement(this._currentTarget);
            --i;
          }
        }
        for (i = 0, list = this._updatesNegList; i < list.length; ) {
          entry = list[i];
          entry.markedForDeletion ? this._removeUpdateFromHash(entry) : i++;
        }
        for (i = 0, list = this._updates0List; i < list.length; ) {
          entry = list[i];
          entry.markedForDeletion ? this._removeUpdateFromHash(entry) : i++;
        }
        for (i = 0, list = this._updatesPosList; i < list.length; ) {
          entry = list[i];
          entry.markedForDeletion ? this._removeUpdateFromHash(entry) : i++;
        }
        this._updateHashLocked = false;
        this._currentTarget = null;
      },
      schedule: function schedule(callback, target, interval, repeat, delay, paused) {
        if ("function" !== typeof callback) {
          var tmp = callback;
          callback = target;
          target = tmp;
        }
        if (4 === arguments.length || 5 === arguments.length) {
          paused = !!repeat;
          repeat = cc.macro.REPEAT_FOREVER;
          delay = 0;
        }
        cc.assertID(target, 1502);
        var targetId = target._id;
        if (!targetId) if (target.__instanceId) {
          cc.warnID(1513);
          targetId = target._id = target.__instanceId;
        } else cc.errorID(1510);
        var element = this._hashForTimers[targetId];
        if (element) element.paused !== paused && cc.warnID(1511); else {
          element = HashTimerEntry.get(null, target, 0, null, null, paused);
          this._arrayForTimers.push(element);
          this._hashForTimers[targetId] = element;
        }
        var timer, i;
        if (null == element.timers) element.timers = []; else for (i = 0; i < element.timers.length; ++i) {
          timer = element.timers[i];
          if (timer && callback === timer._callback) {
            cc.logID(1507, timer.getInterval(), interval);
            timer._interval = interval;
            return;
          }
        }
        timer = CallbackTimer.get();
        timer.initWithCallback(this, callback, target, interval, repeat, delay);
        element.timers.push(timer);
        this._currentTarget === element && this._currentTargetSalvaged && (this._currentTargetSalvaged = false);
      },
      scheduleUpdate: function scheduleUpdate(target, priority, paused) {
        var targetId = target._id;
        if (!targetId) if (target.__instanceId) {
          cc.warnID(1513);
          targetId = target._id = target.__instanceId;
        } else cc.errorID(1510);
        var hashElement = this._hashForUpdates[targetId];
        if (hashElement && hashElement.entry) {
          if (hashElement.entry.priority === priority) {
            hashElement.entry.markedForDeletion = false;
            hashElement.entry.paused = paused;
            return;
          }
          if (this._updateHashLocked) {
            cc.logID(1506);
            hashElement.entry.markedForDeletion = false;
            hashElement.entry.paused = paused;
            return;
          }
          this.unscheduleUpdate(target);
        }
        var listElement = ListEntry.get(target, priority, paused, false);
        var ppList;
        if (0 === priority) {
          ppList = this._updates0List;
          this._appendIn(ppList, listElement);
        } else {
          ppList = priority < 0 ? this._updatesNegList : this._updatesPosList;
          this._priorityIn(ppList, listElement, priority);
        }
        this._hashForUpdates[targetId] = HashUpdateEntry.get(ppList, listElement, target, null);
      },
      unschedule: function unschedule(callback, target) {
        if (!target || !callback) return;
        var targetId = target._id;
        if (!targetId) if (target.__instanceId) {
          cc.warnID(1513);
          targetId = target._id = target.__instanceId;
        } else cc.errorID(1510);
        var self = this, element = self._hashForTimers[targetId];
        if (element) {
          var timers = element.timers;
          for (var i = 0, li = timers.length; i < li; i++) {
            var timer = timers[i];
            if (callback === timer._callback) {
              timer !== element.currentTimer || element.currentTimerSalvaged || (element.currentTimerSalvaged = true);
              timers.splice(i, 1);
              CallbackTimer.put(timer);
              element.timerIndex >= i && element.timerIndex--;
              0 === timers.length && (self._currentTarget === element ? self._currentTargetSalvaged = true : self._removeHashElement(element));
              return;
            }
          }
        }
      },
      unscheduleUpdate: function unscheduleUpdate(target) {
        if (!target) return;
        var targetId = target._id;
        if (!targetId) if (target.__instanceId) {
          cc.warnID(1513);
          targetId = target._id = target.__instanceId;
        } else cc.errorID(1510);
        var element = this._hashForUpdates[targetId];
        element && (this._updateHashLocked ? element.entry.markedForDeletion = true : this._removeUpdateFromHash(element.entry));
      },
      unscheduleAllForTarget: function unscheduleAllForTarget(target) {
        if (!target) return;
        var targetId = target._id;
        if (!targetId) if (target.__instanceId) {
          cc.warnID(1513);
          targetId = target._id = target.__instanceId;
        } else cc.errorID(1510);
        var element = this._hashForTimers[targetId];
        if (element) {
          var timers = element.timers;
          timers.indexOf(element.currentTimer) > -1 && !element.currentTimerSalvaged && (element.currentTimerSalvaged = true);
          for (var i = 0, l = timers.length; i < l; i++) CallbackTimer.put(timers[i]);
          timers.length = 0;
          this._currentTarget === element ? this._currentTargetSalvaged = true : this._removeHashElement(element);
        }
        this.unscheduleUpdate(target);
      },
      unscheduleAll: function unscheduleAll() {
        this.unscheduleAllWithMinPriority(cc.Scheduler.PRIORITY_SYSTEM);
      },
      unscheduleAllWithMinPriority: function unscheduleAllWithMinPriority(minPriority) {
        var i, element, arr = this._arrayForTimers;
        for (i = arr.length - 1; i >= 0; i--) {
          element = arr[i];
          this.unscheduleAllForTarget(element.target);
        }
        var entry;
        var temp_length = 0;
        if (minPriority < 0) for (i = 0; i < this._updatesNegList.length; ) {
          temp_length = this._updatesNegList.length;
          entry = this._updatesNegList[i];
          entry && entry.priority >= minPriority && this.unscheduleUpdate(entry.target);
          temp_length == this._updatesNegList.length && i++;
        }
        if (minPriority <= 0) for (i = 0; i < this._updates0List.length; ) {
          temp_length = this._updates0List.length;
          entry = this._updates0List[i];
          entry && this.unscheduleUpdate(entry.target);
          temp_length == this._updates0List.length && i++;
        }
        for (i = 0; i < this._updatesPosList.length; ) {
          temp_length = this._updatesPosList.length;
          entry = this._updatesPosList[i];
          entry && entry.priority >= minPriority && this.unscheduleUpdate(entry.target);
          temp_length == this._updatesPosList.length && i++;
        }
      },
      isScheduled: function isScheduled(callback, target) {
        cc.assertID(callback, 1508);
        cc.assertID(target, 1509);
        var targetId = target._id;
        if (!targetId) if (target.__instanceId) {
          cc.warnID(1513);
          targetId = target._id = target.__instanceId;
        } else cc.errorID(1510);
        var element = this._hashForTimers[targetId];
        if (!element) return false;
        if (null == element.timers) return false;
        var timers = element.timers;
        for (var i = 0; i < timers.length; ++i) {
          var timer = timers[i];
          if (callback === timer._callback) return true;
        }
        return false;
      },
      pauseAllTargets: function pauseAllTargets() {
        return this.pauseAllTargetsWithMinPriority(cc.Scheduler.PRIORITY_SYSTEM);
      },
      pauseAllTargetsWithMinPriority: function pauseAllTargetsWithMinPriority(minPriority) {
        var idsWithSelectors = [];
        var self = this, element, locArrayForTimers = self._arrayForTimers;
        var i, li;
        for (i = 0, li = locArrayForTimers.length; i < li; i++) {
          element = locArrayForTimers[i];
          if (element) {
            element.paused = true;
            idsWithSelectors.push(element.target);
          }
        }
        var entry;
        if (minPriority < 0) for (i = 0; i < this._updatesNegList.length; i++) {
          entry = this._updatesNegList[i];
          if (entry && entry.priority >= minPriority) {
            entry.paused = true;
            idsWithSelectors.push(entry.target);
          }
        }
        if (minPriority <= 0) for (i = 0; i < this._updates0List.length; i++) {
          entry = this._updates0List[i];
          if (entry) {
            entry.paused = true;
            idsWithSelectors.push(entry.target);
          }
        }
        for (i = 0; i < this._updatesPosList.length; i++) {
          entry = this._updatesPosList[i];
          if (entry && entry.priority >= minPriority) {
            entry.paused = true;
            idsWithSelectors.push(entry.target);
          }
        }
        return idsWithSelectors;
      },
      resumeTargets: function resumeTargets(targetsToResume) {
        if (!targetsToResume) return;
        for (var i = 0; i < targetsToResume.length; i++) this.resumeTarget(targetsToResume[i]);
      },
      pauseTarget: function pauseTarget(target) {
        cc.assertID(target, 1503);
        var targetId = target._id;
        if (!targetId) if (target.__instanceId) {
          cc.warnID(1513);
          targetId = target._id = target.__instanceId;
        } else cc.errorID(1510);
        var self = this, element = self._hashForTimers[targetId];
        element && (element.paused = true);
        var elementUpdate = self._hashForUpdates[targetId];
        elementUpdate && (elementUpdate.entry.paused = true);
      },
      resumeTarget: function resumeTarget(target) {
        cc.assertID(target, 1504);
        var targetId = target._id;
        if (!targetId) if (target.__instanceId) {
          cc.warnID(1513);
          targetId = target._id = target.__instanceId;
        } else cc.errorID(1510);
        var self = this, element = self._hashForTimers[targetId];
        element && (element.paused = false);
        var elementUpdate = self._hashForUpdates[targetId];
        elementUpdate && (elementUpdate.entry.paused = false);
      },
      isTargetPaused: function isTargetPaused(target) {
        cc.assertID(target, 1505);
        var targetId = target._id;
        if (!targetId) if (target.__instanceId) {
          cc.warnID(1513);
          targetId = target._id = target.__instanceId;
        } else cc.errorID(1510);
        var element = this._hashForTimers[targetId];
        if (element) return element.paused;
        var elementUpdate = this._hashForUpdates[targetId];
        if (elementUpdate) return elementUpdate.entry.paused;
        return false;
      }
    };
    cc.Scheduler.PRIORITY_SYSTEM = 1 << 31;
    cc.Scheduler.PRIORITY_NON_SYSTEM = cc.Scheduler.PRIORITY_SYSTEM + 1;
    module.exports = cc.Scheduler;
  }), {
    "./platform/id-generater": 215,
    "./platform/js": 219
  } ],
  57: [ (function(require, module, exports) {
    "use strict";
    var RawAsset = require("./CCRawAsset");
    cc.Asset = cc.Class({
      name: "cc.Asset",
      extends: RawAsset,
      ctor: function ctor() {
        this.loaded = true;
        this.url = "";
      },
      properties: {
        nativeUrl: {
          get: function get() {
            if (this._native) {
              var name = this._native;
              if (47 === name.charCodeAt(0)) return name.slice(1);
              if (cc.AssetLibrary) {
                var base = cc.AssetLibrary.getLibUrlNoExt(this._uuid, true);
                return 46 === name.charCodeAt(0) ? base + name : base + "/" + name;
              }
              cc.errorID(6400);
            }
            return "";
          },
          visible: false
        },
        _native: "",
        _nativeAsset: {
          get: function get() {
            return this._$nativeAsset;
          },
          set: function set(obj) {
            this._$nativeAsset = obj;
          }
        }
      },
      statics: {
        deserialize: false,
        preventDeferredLoadDependents: false,
        preventPreloadNativeObject: false
      },
      toString: function toString() {
        return this.nativeUrl;
      },
      serialize: false,
      createNode: null,
      _setRawAsset: function _setRawAsset(filename, inLibrary) {
        this._native = false !== inLibrary ? filename || void 0 : "/" + filename;
      }
    });
    module.exports = cc.Asset;
  }), {
    "./CCRawAsset": 66
  } ],
  58: [ (function(require, module, exports) {
    "use strict";
    var Asset = require("./CCAsset");
    var EventTarget = require("../event/event-target");
    var LoadMode = cc.Enum({
      WEB_AUDIO: 0,
      DOM_AUDIO: 1
    });
    var AudioClip = cc.Class({
      name: "cc.AudioClip",
      extends: Asset,
      mixins: [ EventTarget ],
      ctor: function ctor() {
        this.loaded = false;
        this._audio = null;
      },
      properties: {
        loadMode: {
          default: LoadMode.WEB_AUDIO,
          type: LoadMode
        },
        _nativeAsset: {
          get: function get() {
            return this._audio;
          },
          set: function set(value) {
            value instanceof cc.AudioClip ? this._audio = value._nativeAsset : this._audio = value;
            if (this._audio) {
              this.loaded = true;
              this.emit("load");
            }
          },
          override: true
        }
      },
      statics: {
        LoadMode: LoadMode,
        _loadByUrl: function _loadByUrl(url, callback) {
          var item = cc.loader.getItem(url) || cc.loader.getItem(url + "?useDom=1");
          item && item.complete ? item._owner instanceof AudioClip ? callback(null, item._owner) : callback(null, item.content) : cc.loader.load(url, (function(error, downloadUrl) {
            if (error) return callback(error);
            item = cc.loader.getItem(url) || cc.loader.getItem(url + "?useDom=1");
            callback(null, item.content);
          }));
        }
      },
      destroy: function destroy() {
        cc.audioEngine.uncache(this);
        this._super();
      }
    });
    cc.AudioClip = AudioClip;
    module.exports = AudioClip;
  }), {
    "../event/event-target": 132,
    "./CCAsset": 57
  } ],
  59: [ (function(require, module, exports) {
    "use strict";
    var FontLetterDefinition = function FontLetterDefinition() {
      this.u = 0;
      this.v = 0;
      this.w = 0;
      this.h = 0;
      this.offsetX = 0;
      this.offsetY = 0;
      this.textureID = 0;
      this.valid = false;
      this.xAdvance = 0;
    };
    var FontAtlas = function FontAtlas(texture) {
      this._letterDefinitions = {};
      this._texture = texture;
    };
    FontAtlas.prototype = {
      constructor: FontAtlas,
      addLetterDefinitions: function addLetterDefinitions(letter, letterDefinition) {
        this._letterDefinitions[letter] = letterDefinition;
      },
      cloneLetterDefinition: function cloneLetterDefinition() {
        var copyLetterDefinitions = {};
        for (var key in this._letterDefinitions) {
          var value = new FontLetterDefinition();
          cc.js.mixin(value, this._letterDefinitions[key]);
          copyLetterDefinitions[key] = value;
        }
        return copyLetterDefinitions;
      },
      getTexture: function getTexture() {
        return this._texture;
      },
      getLetter: function getLetter(key) {
        return this._letterDefinitions[key];
      },
      getLetterDefinitionForChar: function getLetterDefinitionForChar(char) {
        var key = char.charCodeAt(0);
        var hasKey = this._letterDefinitions.hasOwnProperty(key);
        var letter = void 0;
        letter = hasKey ? this._letterDefinitions[key] : null;
        return letter;
      },
      clear: function clear() {
        this._letterDefinitions = {};
      }
    };
    var BitmapFont = cc.Class({
      name: "cc.BitmapFont",
      extends: cc.Font,
      properties: {
        fntDataStr: {
          default: ""
        },
        spriteFrame: {
          default: null,
          type: cc.SpriteFrame
        },
        fontSize: {
          default: -1
        },
        _fntConfig: null,
        _fontDefDictionary: null
      },
      onLoad: function onLoad() {
        var spriteFrame = this.spriteFrame;
        !this._fontDefDictionary && spriteFrame && (this._fontDefDictionary = new FontAtlas(spriteFrame._texture));
        var fntConfig = this._fntConfig;
        if (!fntConfig) return;
        var fontDict = fntConfig.fontDefDictionary;
        for (var fontDef in fontDict) {
          var letter = new FontLetterDefinition();
          var rect = fontDict[fontDef].rect;
          letter.offsetX = fontDict[fontDef].xOffset;
          letter.offsetY = fontDict[fontDef].yOffset;
          letter.w = rect.width;
          letter.h = rect.height;
          letter.u = rect.x;
          letter.v = rect.y;
          letter.textureID = 0;
          letter.valid = true;
          letter.xAdvance = fontDict[fontDef].xAdvance;
          this._fontDefDictionary.addLetterDefinitions(fontDef, letter);
        }
      }
    });
    cc.BitmapFont = BitmapFont;
    cc.BitmapFont.FontLetterDefinition = FontLetterDefinition;
    cc.BitmapFont.FontAtlas = FontAtlas;
    module.exports = BitmapFont;
  }), {} ],
  60: [ (function(require, module, exports) {
    "use strict";
    var BufferAsset = cc.Class({
      name: "cc.BufferAsset",
      extends: cc.Asset,
      ctor: function ctor() {
        this._buffer = null;
      },
      properties: {
        _nativeAsset: {
          get: function get() {
            return this._buffer;
          },
          set: function set(bin) {
            this._buffer = bin.buffer || bin;
          },
          override: true
        },
        buffer: function buffer() {
          return this._buffer;
        }
      }
    });
    cc.BufferAsset = module.exports = BufferAsset;
  }), {} ],
  61: [ (function(require, module, exports) {
    "use strict";
    var Asset = require("./CCAsset");
    var Effect = require("../../renderer/core/effect");
    var EffectAsset = cc.Class({
      name: "cc.EffectAsset",
      extends: Asset,
      ctor: function ctor() {
        this._effect = null;
      },
      properties: {
        properties: Object,
        techniques: [],
        shaders: []
      },
      onLoad: function onLoad() {
        if (cc.game.renderType === cc.game.RENDER_TYPE_CANVAS) return;
        var lib = cc.renderer._forward._programLib;
        for (var i = 0; i < this.shaders.length; i++) lib.define(this.shaders[i]);
        this._initEffect();
      },
      _initEffect: function _initEffect() {
        if (this._effect) return;
        this._effect = Effect.parseEffect(this);
      },
      getInstantiatedEffect: function getInstantiatedEffect() {
        this._initEffect();
        return this._effect.clone();
      }
    });
    module.exports = cc.EffectAsset = EffectAsset;
  }), {
    "../../renderer/core/effect": 347,
    "./CCAsset": 57
  } ],
  62: [ (function(require, module, exports) {
    "use strict";
    var Font = cc.Class({
      name: "cc.Font",
      extends: cc.Asset
    });
    cc.Font = module.exports = Font;
  }), {} ],
  63: [ (function(require, module, exports) {
    "use strict";
    var JsonAsset = cc.Class({
      name: "cc.JsonAsset",
      extends: cc.Asset,
      properties: {
        json: null
      }
    });
    module.exports = cc.JsonAsset = JsonAsset;
  }), {} ],
  64: [ (function(require, module, exports) {
    "use strict";
    var LabelAtlas = cc.Class({
      name: "cc.LabelAtlas",
      extends: cc.BitmapFont,
      onLoad: function onLoad() {
        if (!this.spriteFrame) {
          cc.warnID(9100, this.name);
          return;
        }
        if (!this._fntConfig) {
          cc.warnID(9101, this.name);
          return;
        }
        this._super();
      }
    });
    cc.LabelAtlas = LabelAtlas;
    module.exports = LabelAtlas;
  }), {} ],
  65: [ (function(require, module, exports) {
    "use strict";
    var OptimizationPolicy = cc.Enum({
      AUTO: 0,
      SINGLE_INSTANCE: 1,
      MULTI_INSTANCE: 2
    });
    var Prefab = cc.Class({
      name: "cc.Prefab",
      extends: cc.Asset,
      ctor: function ctor() {
        this._createFunction = null;
        this._instantiatedTimes = 0;
      },
      properties: {
        data: null,
        optimizationPolicy: OptimizationPolicy.AUTO,
        asyncLoadAssets: false,
        readonly: {
          default: false,
          editorOnly: true
        }
      },
      statics: {
        OptimizationPolicy: OptimizationPolicy,
        OptimizationPolicyThreshold: 3
      },
      createNode: false,
      compileCreateFunction: function compileCreateFunction() {
        var jit = require("../platform/instantiate-jit");
        this._createFunction = jit.compile(this.data);
      },
      _doInstantiate: function _doInstantiate(rootToRedirect) {
        this.data._prefab ? this.data._prefab._synced = true : cc.warnID(3700);
        this._createFunction || this.compileCreateFunction();
        return this._createFunction(rootToRedirect);
      },
      _instantiate: function _instantiate() {
        var node, useJit = false;
        true;
        useJit = this.optimizationPolicy !== OptimizationPolicy.SINGLE_INSTANCE && (this.optimizationPolicy === OptimizationPolicy.MULTI_INSTANCE || this._instantiatedTimes + 1 >= Prefab.OptimizationPolicyThreshold);
        if (useJit) {
          node = this._doInstantiate();
          this.data._instantiate(node);
        } else {
          this.data._prefab._synced = true;
          node = this.data._instantiate();
        }
        ++this._instantiatedTimes;
        var PrefabUtils;
        false, false;
        return node;
      },
      destroy: function destroy() {
        this.data && this.data.destroy();
        this._super();
      }
    });
    cc.Prefab = module.exports = Prefab;
    cc.js.obsolete(cc, "cc._Prefab", "Prefab");
  }), {
    "../platform/instantiate-jit": 217
  } ],
  66: [ (function(require, module, exports) {
    "use strict";
    var CCObject = require("../platform/CCObject");
    var js = require("../platform/js");
    cc.RawAsset = cc.Class({
      name: "cc.RawAsset",
      extends: CCObject,
      ctor: function ctor() {
        Object.defineProperty(this, "_uuid", {
          value: "",
          writable: true
        });
      }
    });
    js.value(cc.RawAsset, "isRawAssetType", (function(ctor) {
      return js.isChildClassOf(ctor, cc.RawAsset) && !js.isChildClassOf(ctor, cc.Asset);
    }));
    js.value(cc.RawAsset, "wasRawAssetType", (function(ctor) {
      return ctor === cc.Texture2D || ctor === cc.AudioClip || ctor === cc.ParticleAsset || ctor === cc.Asset;
    }));
    module.exports = cc.RawAsset;
  }), {
    "../platform/CCObject": 205,
    "../platform/js": 219
  } ],
  67: [ (function(require, module, exports) {
    "use strict";
    var _gfx = require("../../renderer/gfx");
    var _gfx2 = _interopRequireDefault(_gfx);
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : {
        default: obj
      };
    }
    var renderer = require("../renderer");
    var Texture2D = require("./CCTexture2D");
    var RenderTexture = cc.Class({
      name: "cc.RenderTexture",
      extends: Texture2D,
      ctor: function ctor() {
        this._framebuffer = null;
      },
      initWithSize: function initWithSize(width, height, depthStencilFormat) {
        this.width = Math.floor(width || cc.visibleRect.width);
        this.height = Math.floor(height || cc.visibleRect.height);
        this._resetUnderlyingMipmaps();
        var opts = {
          colors: [ this._texture ]
        };
        this._depthStencilBuffer && this._depthStencilBuffer.destroy();
        var depthStencilBuffer = void 0;
        if (depthStencilFormat) {
          depthStencilBuffer = new _gfx2.default.RenderBuffer(renderer.device, depthStencilFormat, width, height);
          depthStencilFormat === _gfx2.default.RB_FMT_D24S8 ? opts.depthStencil = depthStencilBuffer : depthStencilFormat === _gfx2.default.RB_FMT_S8 ? opts.stencil = depthStencilBuffer : depthStencilFormat === _gfx2.default.RB_FMT_D16 && (opts.depth = depthStencilBuffer);
        }
        this._depthStencilBuffer = depthStencilBuffer;
        this._framebuffer && this._framebuffer.destroy();
        this._framebuffer = new _gfx2.default.FrameBuffer(renderer.device, width, height, opts);
        this._packable = false;
        this.loaded = true;
        this.emit("load");
      },
      updateSize: function updateSize(width, height) {
        this.width = Math.floor(width || cc.visibleRect.width);
        this.height = Math.floor(height || cc.visibleRect.height);
        this._resetUnderlyingMipmaps();
        var rbo = this._depthStencilBuffer;
        rbo && rbo.update(this.width, this.height);
        this._framebuffer._width = width;
        this._framebuffer._height = height;
      },
      drawTextureAt: function drawTextureAt(texture, x, y) {
        if (!texture._image) return;
        this._texture.updateSubImage({
          x: x,
          y: y,
          image: texture._image,
          width: texture.width,
          height: texture.height,
          level: 0,
          flipY: false,
          premultiplyAlpha: texture._premultiplyAlpha
        });
      },
      readPixels: function readPixels(data, x, y, w, h) {
        if (!this._framebuffer || !this._texture) return data;
        x = x || 0;
        y = y || 0;
        var width = w || this.width;
        var height = h || this.height;
        data = data || new Uint8Array(width * height * 4);
        var gl = cc.game._renderContext;
        var oldFBO = gl.getParameter(gl.FRAMEBUFFER_BINDING);
        gl.bindFramebuffer(gl.FRAMEBUFFER, this._framebuffer.getHandle());
        gl.readPixels(x, y, width, height, gl.RGBA, gl.UNSIGNED_BYTE, data);
        gl.bindFramebuffer(gl.FRAMEBUFFER, oldFBO);
        return data;
      },
      destroy: function destroy() {
        this._super();
        if (this._framebuffer) {
          this._framebuffer.destroy();
          this._framebuffer = null;
        }
      }
    });
    cc.RenderTexture = module.exports = RenderTexture;
  }), {
    "../../renderer/gfx": 352,
    "../renderer": 248,
    "./CCTexture2D": 74
  } ],
  68: [ (function(require, module, exports) {
    "use strict";
    var Scene = cc.Class({
      name: "cc.SceneAsset",
      extends: cc.Asset,
      properties: {
        scene: null,
        asyncLoadAssets: void 0
      }
    });
    cc.SceneAsset = Scene;
    module.exports = Scene;
  }), {} ],
  69: [ (function(require, module, exports) {
    "use strict";
    var Script = cc.Class({
      name: "cc.Script",
      extends: cc.Asset
    });
    cc._Script = Script;
    var JavaScript = cc.Class({
      name: "cc.JavaScript",
      extends: Script
    });
    cc._JavaScript = JavaScript;
    var CoffeeScript = cc.Class({
      name: "cc.CoffeeScript",
      extends: Script
    });
    cc._CoffeeScript = CoffeeScript;
    var TypeScript = cc.Class({
      name: "cc.TypeScript",
      extends: Script
    });
    cc._TypeScript = TypeScript;
  }), {} ],
  70: [ (function(require, module, exports) {
    "use strict";
    var SpriteAtlas = cc.Class({
      name: "cc.SpriteAtlas",
      extends: cc.Asset,
      properties: {
        _spriteFrames: {
          default: {}
        }
      },
      getTexture: function getTexture() {
        var keys = Object.keys(this._spriteFrames);
        if (keys.length > 0) {
          var spriteFrame = this._spriteFrames[keys[0]];
          return spriteFrame ? spriteFrame.getTexture() : null;
        }
        return null;
      },
      getSpriteFrame: function getSpriteFrame(key) {
        var sf = this._spriteFrames[key];
        if (!sf) return null;
        sf.name || (sf.name = key);
        return sf;
      },
      getSpriteFrames: function getSpriteFrames() {
        var frames = [];
        var spriteFrames = this._spriteFrames;
        for (var key in spriteFrames) frames.push(this.getSpriteFrame(key));
        return frames;
      }
    });
    cc.SpriteAtlas = SpriteAtlas;
    module.exports = SpriteAtlas;
  }), {} ],
  71: [ (function(require, module, exports) {
    "use strict";
    var EventTarget = require("../event/event-target");
    var textureUtil = require("../utils/texture-util");
    var INSET_LEFT = 0;
    var INSET_TOP = 1;
    var INSET_RIGHT = 2;
    var INSET_BOTTOM = 3;
    var temp_uvs = [ {
      u: 0,
      v: 0
    }, {
      u: 0,
      v: 0
    }, {
      u: 0,
      v: 0
    }, {
      u: 0,
      v: 0
    } ];
    var SpriteFrame = cc.Class({
      name: "cc.SpriteFrame",
      extends: require("../assets/CCAsset"),
      mixins: [ EventTarget ],
      properties: {
        _textureSetter: {
          set: function set(texture) {
            if (texture) {
              false;
              this._texture !== texture && this._refreshTexture(texture);
              this._textureFilename = texture.url;
            }
          }
        },
        insetTop: {
          get: function get() {
            return this._capInsets[INSET_TOP];
          },
          set: function set(value) {
            this._capInsets[INSET_TOP] = value;
            this._texture && this._calculateSlicedUV();
          }
        },
        insetBottom: {
          get: function get() {
            return this._capInsets[INSET_BOTTOM];
          },
          set: function set(value) {
            this._capInsets[INSET_BOTTOM] = value;
            this._texture && this._calculateSlicedUV();
          }
        },
        insetLeft: {
          get: function get() {
            return this._capInsets[INSET_LEFT];
          },
          set: function set(value) {
            this._capInsets[INSET_LEFT] = value;
            this._texture && this._calculateSlicedUV();
          }
        },
        insetRight: {
          get: function get() {
            return this._capInsets[INSET_RIGHT];
          },
          set: function set(value) {
            this._capInsets[INSET_RIGHT] = value;
            this._texture && this._calculateSlicedUV();
          }
        }
      },
      ctor: function ctor() {
        EventTarget.call(this);
        var filename = arguments[0];
        var rect = arguments[1];
        var rotated = arguments[2];
        var offset = arguments[3];
        var originalSize = arguments[4];
        this._rect = null;
        this.uv = [];
        this._texture = null;
        this._original = null;
        this._offset = null;
        this._originalSize = null;
        this._rotated = false;
        this.vertices = null;
        this._capInsets = [ 0, 0, 0, 0 ];
        this.uvSliced = [];
        this._textureFilename = "";
        false;
        void 0 !== filename && this.setTexture(filename, rect, rotated, offset, originalSize);
      },
      textureLoaded: function textureLoaded() {
        return this._texture && this._texture.loaded;
      },
      isRotated: function isRotated() {
        return this._rotated;
      },
      setRotated: function setRotated(bRotated) {
        this._rotated = bRotated;
        this._texture && this._calculateUV();
      },
      getRect: function getRect() {
        return cc.rect(this._rect);
      },
      setRect: function setRect(rect) {
        this._rect = rect;
        this._texture && this._calculateUV();
      },
      getOriginalSize: function getOriginalSize() {
        return cc.size(this._originalSize);
      },
      setOriginalSize: function setOriginalSize(size) {
        if (this._originalSize) {
          this._originalSize.width = size.width;
          this._originalSize.height = size.height;
        } else this._originalSize = cc.size(size);
      },
      getTexture: function getTexture() {
        return this._texture;
      },
      _textureLoadedCallback: function _textureLoadedCallback() {
        var self = this;
        var texture = this._texture;
        if (!texture) return;
        var w = texture.width, h = texture.height;
        self._rect ? self._checkRect(self._texture) : self._rect = cc.rect(0, 0, w, h);
        self._originalSize || self.setOriginalSize(cc.size(w, h));
        self._offset || self.setOffset(cc.v2(0, 0));
        self._calculateUV();
        self.emit("load");
      },
      _refreshTexture: function _refreshTexture(texture) {
        this._texture = texture;
        texture.loaded ? this._textureLoadedCallback() : texture.once("load", this._textureLoadedCallback, this);
      },
      getOffset: function getOffset() {
        return cc.v2(this._offset);
      },
      setOffset: function setOffset(offsets) {
        this._offset = cc.v2(offsets);
      },
      clone: function clone() {
        return new SpriteFrame(this._texture || this._textureFilename, this._rect, this._rotated, this._offset, this._originalSize);
      },
      setTexture: function setTexture(textureOrTextureFile, rect, rotated, offset, originalSize) {
        this._rect = rect || null;
        offset ? this.setOffset(offset) : this._offset = null;
        originalSize ? this.setOriginalSize(originalSize) : this._originalSize = null;
        this._rotated = rotated || false;
        var texture = textureOrTextureFile;
        if ("string" === typeof texture && texture) {
          this._textureFilename = texture;
          this._loadTexture();
        }
        texture instanceof cc.Texture2D && this._texture !== texture && this._refreshTexture(texture);
        return true;
      },
      _loadTexture: function _loadTexture() {
        if (this._textureFilename) {
          var texture = textureUtil.loadImage(this._textureFilename);
          this._refreshTexture(texture);
        }
      },
      ensureLoadTexture: function ensureLoadTexture() {
        if (this._texture) {
          if (!this._texture.loaded) {
            this._refreshTexture(this._texture);
            textureUtil.postLoadTexture(this._texture);
          }
        } else this._textureFilename && this._loadTexture();
      },
      _checkRect: function _checkRect(texture) {
        var rect = this._rect;
        var maxX = rect.x, maxY = rect.y;
        if (this._rotated) {
          maxX += rect.height;
          maxY += rect.width;
        } else {
          maxX += rect.width;
          maxY += rect.height;
        }
        maxX > texture.width && cc.errorID(3300, texture.url + "/" + this.name, maxX, texture.width);
        maxY > texture.height && cc.errorID(3400, texture.url + "/" + this.name, maxY, texture.height);
      },
      _calculateSlicedUV: function _calculateSlicedUV() {
        var rect = this._rect;
        var atlasWidth = this._texture.width;
        var atlasHeight = this._texture.height;
        var leftWidth = this._capInsets[INSET_LEFT];
        var rightWidth = this._capInsets[INSET_RIGHT];
        var centerWidth = rect.width - leftWidth - rightWidth;
        var topHeight = this._capInsets[INSET_TOP];
        var bottomHeight = this._capInsets[INSET_BOTTOM];
        var centerHeight = rect.height - topHeight - bottomHeight;
        var uvSliced = this.uvSliced;
        uvSliced.length = 0;
        if (this._rotated) {
          temp_uvs[0].u = rect.x / atlasWidth;
          temp_uvs[1].u = (rect.x + bottomHeight) / atlasWidth;
          temp_uvs[2].u = (rect.x + bottomHeight + centerHeight) / atlasWidth;
          temp_uvs[3].u = (rect.x + rect.height) / atlasWidth;
          temp_uvs[3].v = rect.y / atlasHeight;
          temp_uvs[2].v = (rect.y + leftWidth) / atlasHeight;
          temp_uvs[1].v = (rect.y + leftWidth + centerWidth) / atlasHeight;
          temp_uvs[0].v = (rect.y + rect.width) / atlasHeight;
          for (var row = 0; row < 4; ++row) {
            var rowD = temp_uvs[row];
            for (var col = 0; col < 4; ++col) {
              var colD = temp_uvs[3 - col];
              uvSliced.push({
                u: rowD.u,
                v: colD.v
              });
            }
          }
        } else {
          temp_uvs[0].u = rect.x / atlasWidth;
          temp_uvs[1].u = (rect.x + leftWidth) / atlasWidth;
          temp_uvs[2].u = (rect.x + leftWidth + centerWidth) / atlasWidth;
          temp_uvs[3].u = (rect.x + rect.width) / atlasWidth;
          temp_uvs[3].v = rect.y / atlasHeight;
          temp_uvs[2].v = (rect.y + topHeight) / atlasHeight;
          temp_uvs[1].v = (rect.y + topHeight + centerHeight) / atlasHeight;
          temp_uvs[0].v = (rect.y + rect.height) / atlasHeight;
          for (var _row = 0; _row < 4; ++_row) {
            var _rowD = temp_uvs[_row];
            for (var _col = 0; _col < 4; ++_col) {
              var _colD = temp_uvs[_col];
              uvSliced.push({
                u: _colD.u,
                v: _rowD.v
              });
            }
          }
        }
      },
      _setDynamicAtlasFrame: function _setDynamicAtlasFrame(frame) {
        if (!frame) return;
        this._original = {
          _texture: this._texture,
          _x: this._rect.x,
          _y: this._rect.y
        };
        this._texture = frame.texture;
        this._rect.x = frame.x;
        this._rect.y = frame.y;
        this._calculateUV();
      },
      _resetDynamicAtlasFrame: function _resetDynamicAtlasFrame() {
        if (!this._original) return;
        this._rect.x = this._original._x;
        this._rect.y = this._original._y;
        this._texture = this._original._texture;
        this._original = null;
        this._calculateUV();
      },
      _calculateUV: function _calculateUV() {
        var rect = this._rect, texture = this._texture, uv = this.uv, texw = texture.width, texh = texture.height;
        if (this._rotated) {
          var l = 0 === texw ? 0 : rect.x / texw;
          var r = 0 === texw ? 0 : (rect.x + rect.height) / texw;
          var b = 0 === texh ? 0 : (rect.y + rect.width) / texh;
          var t = 0 === texh ? 0 : rect.y / texh;
          uv[0] = l;
          uv[1] = t;
          uv[2] = l;
          uv[3] = b;
          uv[4] = r;
          uv[5] = t;
          uv[6] = r;
          uv[7] = b;
        } else {
          var _l = 0 === texw ? 0 : rect.x / texw;
          var _r = 0 === texw ? 0 : (rect.x + rect.width) / texw;
          var _b = 0 === texh ? 0 : (rect.y + rect.height) / texh;
          var _t = 0 === texh ? 0 : rect.y / texh;
          uv[0] = _l;
          uv[1] = _b;
          uv[2] = _r;
          uv[3] = _b;
          uv[4] = _l;
          uv[5] = _t;
          uv[6] = _r;
          uv[7] = _t;
        }
        var vertices = this.vertices;
        if (vertices) {
          vertices.nu.length = 0;
          vertices.nv.length = 0;
          for (var i = 0; i < vertices.u.length; i++) {
            vertices.nu[i] = vertices.u[i] / texw;
            vertices.nv[i] = vertices.v[i] / texh;
          }
        }
        this._calculateSlicedUV();
      },
      _serialize: false,
      _deserialize: function _deserialize(data, handle) {
        var rect = data.rect;
        rect && (this._rect = new cc.Rect(rect[0], rect[1], rect[2], rect[3]));
        data.offset && this.setOffset(new cc.Vec2(data.offset[0], data.offset[1]));
        data.originalSize && this.setOriginalSize(new cc.Size(data.originalSize[0], data.originalSize[1]));
        this._rotated = 1 === data.rotated;
        this._name = data.name;
        var capInsets = data.capInsets;
        if (capInsets) {
          this._capInsets[INSET_LEFT] = capInsets[INSET_LEFT];
          this._capInsets[INSET_TOP] = capInsets[INSET_TOP];
          this._capInsets[INSET_RIGHT] = capInsets[INSET_RIGHT];
          this._capInsets[INSET_BOTTOM] = capInsets[INSET_BOTTOM];
        }
        false;
        this.vertices = data.vertices;
        if (this.vertices) {
          this.vertices.nu = [];
          this.vertices.nv = [];
        }
        var textureUuid = data.texture;
        textureUuid && handle.result.push(this, "_textureSetter", textureUuid);
      }
    });
    var proto = SpriteFrame.prototype;
    proto.copyWithZone = proto.clone;
    proto.copy = proto.clone;
    proto.initWithTexture = proto.setTexture;
    cc.SpriteFrame = SpriteFrame;
    module.exports = SpriteFrame;
  }), {
    "../assets/CCAsset": 57,
    "../event/event-target": 132,
    "../utils/texture-util": 307
  } ],
  72: [ (function(require, module, exports) {
    "use strict";
    var Font = require("./CCFont");
    var TTFFont = cc.Class({
      name: "cc.TTFFont",
      extends: Font,
      properties: {
        _fontFamily: null,
        _nativeAsset: {
          type: cc.String,
          get: function get() {
            return this._fontFamily;
          },
          set: function set(value) {
            this._fontFamily = value || "Arial";
          },
          override: true
        }
      }
    });
    cc.TTFFont = module.exports = TTFFont;
  }), {
    "./CCFont": 62
  } ],
  73: [ (function(require, module, exports) {
    "use strict";
    var TextAsset = cc.Class({
      name: "cc.TextAsset",
      extends: cc.Asset,
      properties: {
        text: ""
      },
      toString: function toString() {
        return this.text;
      }
    });
    module.exports = cc.TextAsset = TextAsset;
  }), {} ],
  74: [ (function(require, module, exports) {
    "use strict";
    var _gfx = require("../../renderer/gfx");
    var _gfx2 = _interopRequireDefault(_gfx);
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : {
        default: obj
      };
    }
    var EventTarget = require("../event/event-target");
    var renderer = require("../renderer");
    require("../platform/CCClass");
    var GL_NEAREST = 9728;
    var GL_LINEAR = 9729;
    var GL_REPEAT = 10497;
    var GL_CLAMP_TO_EDGE = 33071;
    var GL_MIRRORED_REPEAT = 33648;
    var GL_RGBA = 6408;
    var CHAR_CODE_0 = 48;
    var CHAR_CODE_1 = 49;
    var idGenerater = new (require("../platform/id-generater"))("Tex");
    var CUSTOM_PIXEL_FORMAT = 1024;
    var PixelFormat = cc.Enum({
      RGB565: _gfx2.default.TEXTURE_FMT_R5_G6_B5,
      RGB5A1: _gfx2.default.TEXTURE_FMT_R5_G5_B5_A1,
      RGBA4444: _gfx2.default.TEXTURE_FMT_R4_G4_B4_A4,
      RGB888: _gfx2.default.TEXTURE_FMT_RGB8,
      RGBA8888: _gfx2.default.TEXTURE_FMT_RGBA8,
      RGBA32F: _gfx2.default.TEXTURE_FMT_RGBA32F,
      A8: _gfx2.default.TEXTURE_FMT_A8,
      I8: _gfx2.default.TEXTURE_FMT_L8,
      AI8: _gfx2.default.TEXTURE_FMT_L8_A8,
      RGB_PVRTC_2BPPV1: _gfx2.default.TEXTURE_FMT_RGB_PVRTC_2BPPV1,
      RGBA_PVRTC_2BPPV1: _gfx2.default.TEXTURE_FMT_RGBA_PVRTC_2BPPV1,
      RGB_A_PVRTC_2BPPV1: CUSTOM_PIXEL_FORMAT++,
      RGB_PVRTC_4BPPV1: _gfx2.default.TEXTURE_FMT_RGB_PVRTC_4BPPV1,
      RGBA_PVRTC_4BPPV1: _gfx2.default.TEXTURE_FMT_RGBA_PVRTC_4BPPV1,
      RGB_A_PVRTC_4BPPV1: CUSTOM_PIXEL_FORMAT++,
      RGB_ETC1: _gfx2.default.TEXTURE_FMT_RGB_ETC1,
      RGBA_ETC1: CUSTOM_PIXEL_FORMAT++,
      RGB_ETC2: _gfx2.default.TEXTURE_FMT_RGB_ETC2,
      RGBA_ETC2: _gfx2.default.TEXTURE_FMT_RGBA_ETC2
    });
    var WrapMode = cc.Enum({
      REPEAT: GL_REPEAT,
      CLAMP_TO_EDGE: GL_CLAMP_TO_EDGE,
      MIRRORED_REPEAT: GL_MIRRORED_REPEAT
    });
    var Filter = cc.Enum({
      LINEAR: GL_LINEAR,
      NEAREST: GL_NEAREST
    });
    var FilterIndex = {
      9728: 0,
      9729: 1
    };
    var _images = [];
    var _sharedOpts = {
      width: void 0,
      height: void 0,
      minFilter: void 0,
      magFilter: void 0,
      wrapS: void 0,
      wrapT: void 0,
      format: void 0,
      genMipmaps: void 0,
      images: void 0,
      image: void 0,
      flipY: void 0,
      premultiplyAlpha: void 0
    };
    function _getSharedOptions() {
      for (var key in _sharedOpts) _sharedOpts[key] = void 0;
      _images.length = 0;
      _sharedOpts.images = _images;
      _sharedOpts.flipY = false;
      return _sharedOpts;
    }
    var Texture2D = cc.Class({
      name: "cc.Texture2D",
      extends: require("../assets/CCAsset"),
      mixins: [ EventTarget ],
      properties: {
        _nativeAsset: {
          get: function get() {
            return this._image;
          },
          set: function set(data) {
            data._compressed && data._data ? this.initWithData(data._data, this._format, data.width, data.height) : this.initWithElement(data);
          },
          override: true
        },
        _format: PixelFormat.RGBA8888,
        _premultiplyAlpha: false,
        _flipY: false,
        _minFilter: Filter.LINEAR,
        _magFilter: Filter.LINEAR,
        _mipFilter: Filter.LINEAR,
        _wrapS: WrapMode.CLAMP_TO_EDGE,
        _wrapT: WrapMode.CLAMP_TO_EDGE,
        _genMipmaps: false,
        genMipmaps: {
          get: function get() {
            return this._genMipmaps;
          },
          set: function set(genMipmaps) {
            if (this._genMipmaps !== genMipmaps) {
              var opts = _getSharedOptions();
              opts.genMipmaps = genMipmaps;
              this.update(opts);
            }
          }
        },
        _packable: true,
        packable: {
          get: function get() {
            return this._packable;
          },
          set: function set(val) {
            this._packable = val;
          }
        }
      },
      statics: {
        PixelFormat: PixelFormat,
        WrapMode: WrapMode,
        Filter: Filter,
        _FilterIndex: FilterIndex,
        extnames: [ ".png", ".jpg", ".jpeg", ".bmp", ".webp", ".pvr", ".pkm" ]
      },
      ctor: function ctor() {
        this._id = idGenerater.getNewId();
        this.loaded = false;
        this.width = 0;
        this.height = 0;
        this._hashDirty = true;
        this._hash = 0;
        this._texture = null;
        false;
      },
      getImpl: function getImpl() {
        return this._texture;
      },
      getId: function getId() {
        return this._id;
      },
      toString: function toString() {
        return this.url || "";
      },
      update: function update(options) {
        if (options) {
          var updateImg = false;
          void 0 !== options.width && (this.width = options.width);
          void 0 !== options.height && (this.height = options.height);
          if (void 0 !== options.minFilter) {
            this._minFilter = options.minFilter;
            options.minFilter = FilterIndex[options.minFilter];
          }
          if (void 0 !== options.magFilter) {
            this._magFilter = options.magFilter;
            options.magFilter = FilterIndex[options.magFilter];
          }
          if (void 0 !== options.mipFilter) {
            this._mipFilter = options.mipFilter;
            options.mipFilter = FilterIndex[options.mipFilter];
          }
          void 0 !== options.wrapS && (this._wrapS = options.wrapS);
          void 0 !== options.wrapT && (this._wrapT = options.wrapT);
          void 0 !== options.format && (this._format = options.format);
          if (void 0 !== options.flipY) {
            this._flipY = options.flipY;
            updateImg = true;
          }
          if (void 0 !== options.premultiplyAlpha) {
            this._premultiplyAlpha = options.premultiplyAlpha;
            updateImg = true;
          }
          void 0 !== options.genMipmaps && (this._genMipmaps = options.genMipmaps);
          updateImg && this._image && (options.image = this._image);
          if (options.images && options.images.length > 0) this._image = options.images[0]; else if (void 0 !== options.image) {
            this._image = options.image;
            if (!options.images) {
              _images.length = 0;
              options.images = _images;
            }
            options.images.push(options.image);
          }
          options.images && options.images.length > 0 && this._texture.update(options);
          this._hashDirty = true;
        }
      },
      initWithElement: function initWithElement(element) {
        if (!element) return;
        this._image = element;
        if (element.complete || element instanceof HTMLCanvasElement) this.handleLoadedTexture(); else {
          var self = this;
          element.addEventListener("load", (function() {
            self.handleLoadedTexture();
          }));
          element.addEventListener("error", (function(err) {
            cc.warnID(3119, err.message);
          }));
        }
      },
      initWithData: function initWithData(data, pixelFormat, pixelsWidth, pixelsHeight) {
        var opts = _getSharedOptions();
        opts.image = data;
        opts.images = [ opts.image ];
        opts.genMipmaps = this._genMipmaps;
        opts.premultiplyAlpha = this._premultiplyAlpha;
        opts.flipY = this._flipY;
        opts.minFilter = FilterIndex[this._minFilter];
        opts.magFilter = FilterIndex[this._magFilter];
        opts.wrapS = this._wrapS;
        opts.wrapT = this._wrapT;
        opts.format = this._getGFXPixelFormat(pixelFormat);
        opts.width = pixelsWidth;
        opts.height = pixelsHeight;
        this._texture ? this._texture.update(opts) : this._texture = new renderer.Texture2D(renderer.device, opts);
        this.width = pixelsWidth;
        this.height = pixelsHeight;
        this._checkPackable();
        this.loaded = true;
        this.emit("load");
        return true;
      },
      getHtmlElementObj: function getHtmlElementObj() {
        return this._image;
      },
      destroy: function destroy() {
        this._image = null;
        this._texture && this._texture.destroy();
        this._super();
      },
      getPixelFormat: function getPixelFormat() {
        return this._format;
      },
      hasPremultipliedAlpha: function hasPremultipliedAlpha() {
        return this._premultiplyAlpha || false;
      },
      handleLoadedTexture: function handleLoadedTexture() {
        if (!this._image || !this._image.width || !this._image.height) return;
        this.width = this._image.width;
        this.height = this._image.height;
        var opts = _getSharedOptions();
        opts.image = this._image;
        opts.images = [ opts.image ];
        opts.width = this.width;
        opts.height = this.height;
        opts.genMipmaps = this._genMipmaps;
        opts.format = this._getGFXPixelFormat(this._format);
        opts.premultiplyAlpha = this._premultiplyAlpha;
        opts.flipY = this._flipY;
        opts.minFilter = FilterIndex[this._minFilter];
        opts.magFilter = FilterIndex[this._magFilter];
        opts.wrapS = this._wrapS;
        opts.wrapT = this._wrapT;
        this._texture ? this._texture.update(opts) : this._texture = new renderer.Texture2D(renderer.device, opts);
        this._checkPackable();
        this.loaded = true;
        this.emit("load");
        cc.macro.CLEANUP_IMAGE_CACHE && this._image instanceof HTMLImageElement && this._clearImage();
      },
      description: function description() {
        return "<cc.Texture2D | Name = " + this.url + " | Dimensions = " + this.width + " x " + this.height + ">";
      },
      releaseTexture: function releaseTexture() {
        this._image = null;
        this._texture && this._texture.destroy();
      },
      setWrapMode: function setWrapMode(wrapS, wrapT) {
        if (this._wrapS !== wrapS || this._wrapT !== wrapT) {
          var opts = _getSharedOptions();
          opts.wrapS = wrapS;
          opts.wrapT = wrapT;
          this.update(opts);
        }
      },
      setFilters: function setFilters(minFilter, magFilter) {
        if (this._minFilter !== minFilter || this._magFilter !== magFilter) {
          var opts = _getSharedOptions();
          opts.minFilter = minFilter;
          opts.magFilter = magFilter;
          this.update(opts);
        }
      },
      setFlipY: function setFlipY(flipY) {
        if (this._flipY !== flipY) {
          var opts = _getSharedOptions();
          opts.flipY = flipY;
          this.update(opts);
        }
      },
      setPremultiplyAlpha: function setPremultiplyAlpha(premultiply) {
        if (this._premultiplyAlpha !== premultiply) {
          var opts = _getSharedOptions();
          opts.premultiplyAlpha = premultiply;
          this.update(opts);
        }
      },
      _checkPackable: function _checkPackable() {
        var dynamicAtlas = cc.dynamicAtlasManager;
        if (!dynamicAtlas) return;
        if (this._isCompressed()) {
          this._packable = false;
          return;
        }
        var w = this.width, h = this.height;
        if (!this._image || w > dynamicAtlas.maxFrameSize || h > dynamicAtlas.maxFrameSize || w <= dynamicAtlas.minFrameSize || h <= dynamicAtlas.minFrameSize || this._getHash() !== dynamicAtlas.Atlas.DEFAULT_HASH) {
          this._packable = false;
          return;
        }
        this._image && this._image instanceof HTMLCanvasElement && (this._packable = true);
      },
      _getOpts: function _getOpts() {
        var opts = _getSharedOptions();
        opts.width = this.width;
        opts.height = this.height;
        opts.genMipmaps = this._genMipmaps;
        opts.format = this._format;
        opts.premultiplyAlpha = this._premultiplyAlpha;
        opts.anisotropy = this._anisotropy;
        opts.flipY = this._flipY;
        opts.minFilter = FilterIndex[this._minFilter];
        opts.magFilter = FilterIndex[this._magFilter];
        opts.mipFilter = FilterIndex[this._mipFilter];
        opts.wrapS = this._wrapS;
        opts.wrapT = this._wrapT;
        return opts;
      },
      _getGFXPixelFormat: function _getGFXPixelFormat(format) {
        format === PixelFormat.RGBA_ETC1 ? format = PixelFormat.RGB_ETC1 : format === PixelFormat.RGB_A_PVRTC_4BPPV1 ? format = PixelFormat.RGB_PVRTC_4BPPV1 : format === PixelFormat.RGB_A_PVRTC_2BPPV1 && (format = PixelFormat.RGB_PVRTC_2BPPV1);
        return format;
      },
      _resetUnderlyingMipmaps: function _resetUnderlyingMipmaps(mipmapSources) {
        var opts = this._getOpts();
        opts.images = mipmapSources || [ null ];
        this._texture ? this._texture.update(opts) : this._texture = new renderer.Texture2D(renderer.device, opts);
      },
      _serialize: (false, false) && function() {
        var extId = "";
        var exportedExts = this._exportedExts;
        !exportedExts && this._native && (exportedExts = [ this._native ]);
        if (exportedExts) {
          var exts = [];
          for (var i = 0; i < exportedExts.length; i++) {
            var _extId = "";
            var ext = exportedExts[i];
            if (ext) {
              var extFormat = ext.split("@");
              _extId = Texture2D.extnames.indexOf(extFormat[0]);
              _extId < 0 && (_extId = ext);
              extFormat[1] && (_extId += "@" + extFormat[1]);
            }
            exts.push(_extId);
          }
          extId = exts.join("_");
        }
        var asset = extId + "," + this._minFilter + "," + this._magFilter + "," + this._wrapS + "," + this._wrapT + "," + (this._premultiplyAlpha ? 1 : 0) + "," + (this._genMipmaps ? 1 : 0) + "," + (this._packable ? 1 : 0);
        return asset;
      },
      _deserialize: function _deserialize(data, handle) {
        var device = cc.renderer.device;
        var fields = data.split(",");
        var extIdStr = fields[0];
        if (extIdStr) {
          var extIds = extIdStr.split("_");
          var defaultExt = "";
          var bestExt = "";
          var bestIndex = 999;
          var bestFormat = this._format;
          var SupportTextureFormats = cc.macro.SUPPORT_TEXTURE_FORMATS;
          for (var i = 0; i < extIds.length; i++) {
            var extFormat = extIds[i].split("@");
            var tmpExt = extFormat[0];
            tmpExt = Texture2D.extnames[tmpExt.charCodeAt(0) - CHAR_CODE_0] || tmpExt;
            var index = SupportTextureFormats.indexOf(tmpExt);
            if (-1 !== index && index < bestIndex) {
              var tmpFormat = extFormat[1] ? parseInt(extFormat[1]) : this._format;
              if (".pvr" === tmpExt && !device.ext("WEBGL_compressed_texture_pvrtc")) continue;
              if (!(tmpFormat !== PixelFormat.RGB_ETC1 && tmpFormat !== PixelFormat.RGBA_ETC1 || device.ext("WEBGL_compressed_texture_etc1"))) continue;
              if (!(tmpFormat !== PixelFormat.RGB_ETC2 && tmpFormat !== PixelFormat.RGBA_ETC2 || device.ext("WEBGL_compressed_texture_etc"))) continue;
              if (".webp" === tmpExt && !cc.sys.capabilities.webp) continue;
              bestIndex = index;
              bestExt = tmpExt;
              bestFormat = tmpFormat;
            } else defaultExt || (defaultExt = tmpExt);
          }
          if (bestExt) {
            this._setRawAsset(bestExt);
            this._format = bestFormat;
          } else {
            this._setRawAsset(defaultExt);
            cc.warnID(3120, handle.customEnv.url, defaultExt, defaultExt);
          }
        }
        if (8 === fields.length) {
          this._minFilter = parseInt(fields[1]);
          this._magFilter = parseInt(fields[2]);
          this._wrapS = parseInt(fields[3]);
          this._wrapT = parseInt(fields[4]);
          this._premultiplyAlpha = fields[5].charCodeAt(0) === CHAR_CODE_1;
          this._genMipmaps = fields[6].charCodeAt(0) === CHAR_CODE_1;
          this._packable = fields[7].charCodeAt(0) === CHAR_CODE_1;
        }
      },
      _getHash: function _getHash() {
        if (!this._hashDirty) return this._hash;
        var genMipmaps = this._genMipmaps ? 1 : 0;
        var premultiplyAlpha = this._premultiplyAlpha ? 1 : 0;
        var flipY = this._flipY ? 1 : 0;
        var minFilter = this._minFilter === Filter.LINEAR ? 1 : 2;
        var magFilter = this._magFilter === Filter.LINEAR ? 1 : 2;
        var wrapS = this._wrapS === WrapMode.REPEAT ? 1 : this._wrapS === WrapMode.CLAMP_TO_EDGE ? 2 : 3;
        var wrapT = this._wrapT === WrapMode.REPEAT ? 1 : this._wrapT === WrapMode.CLAMP_TO_EDGE ? 2 : 3;
        var pixelFormat = this._format;
        var image = this._image;
        if (true, image) {
          image._glFormat !== GL_RGBA && (pixelFormat = 0);
          premultiplyAlpha = image._premultiplyAlpha;
        }
        this._hash = Number("" + minFilter + magFilter + pixelFormat + wrapS + wrapT + genMipmaps + premultiplyAlpha + flipY);
        this._hashDirty = false;
        return this._hash;
      },
      _isCompressed: function _isCompressed() {
        return this._texture && this._texture._compressed;
      },
      _clearImage: function _clearImage() {
        cc.loader.removeItem(this._image.id || this._image.src);
        this._image.src = "";
      }
    });
    cc.Texture2D = module.exports = Texture2D;
  }), {
    "../../renderer/gfx": 352,
    "../assets/CCAsset": 57,
    "../event/event-target": 132,
    "../platform/CCClass": 199,
    "../platform/id-generater": 215,
    "../renderer": 248
  } ],
  75: [ (function(require, module, exports) {
    "use strict";
    require("./CCRawAsset");
    require("./CCAsset");
    require("./CCFont");
    require("./CCPrefab");
    require("./CCAudioClip");
    require("./CCScripts");
    require("./CCSceneAsset");
    require("./CCSpriteFrame");
    require("./CCTexture2D");
    require("./CCRenderTexture");
    require("./CCTTFFont");
    require("./CCSpriteAtlas");
    require("./CCBitmapFont");
    require("./CCLabelAtlas");
    require("./CCTextAsset");
    require("./CCJsonAsset");
    require("./CCBufferAsset");
    require("./CCEffectAsset");
    require("./material/CCMaterial");
  }), {
    "./CCAsset": 57,
    "./CCAudioClip": 58,
    "./CCBitmapFont": 59,
    "./CCBufferAsset": 60,
    "./CCEffectAsset": 61,
    "./CCFont": 62,
    "./CCJsonAsset": 63,
    "./CCLabelAtlas": 64,
    "./CCPrefab": 65,
    "./CCRawAsset": 66,
    "./CCRenderTexture": 67,
    "./CCSceneAsset": 68,
    "./CCScripts": 69,
    "./CCSpriteAtlas": 70,
    "./CCSpriteFrame": 71,
    "./CCTTFFont": 72,
    "./CCTextAsset": 73,
    "./CCTexture2D": 74,
    "./material/CCMaterial": 76
  } ],
  76: [ (function(require, module, exports) {
    "use strict";
    var _murmurhash2_gc = require("../../../renderer/murmurhash2_gc");
    var _murmurhash2_gc2 = _interopRequireDefault(_murmurhash2_gc);
    var _utils = require("./utils");
    var _utils2 = _interopRequireDefault(_utils);
    var _materialPool = require("./material-pool");
    var _materialPool2 = _interopRequireDefault(_materialPool);
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : {
        default: obj
      };
    }
    var Asset = require("../CCAsset");
    var Texture = require("../CCTexture2D");
    var PixelFormat = Texture.PixelFormat;
    var EffectAsset = require("../CCEffectAsset");
    var textureUtil = require("../../utils/texture-util");
    var Material = cc.Class({
      name: "cc.Material",
      extends: Asset,
      ctor: function ctor() {
        this._manualHash = false;
        this._dirty = true;
        this._effect = null;
        this._owner = null;
        this._hash = 0;
      },
      properties: {
        _effectAsset: {
          type: EffectAsset,
          default: null
        },
        _defines: {
          default: {},
          type: Object
        },
        _props: {
          default: {},
          type: Object
        },
        effectName: void 0,
        effectAsset: {
          get: function get() {
            return this._effectAsset;
          },
          set: function set(asset) {
            if (cc.game.renderType === cc.game.RENDER_TYPE_CANVAS) return;
            this._effectAsset = asset;
            if (!asset) {
              cc.error("Can not set an empty effect asset.");
              return;
            }
            this._effect = this._effectAsset.getInstantiatedEffect();
          }
        },
        effect: {
          get: function get() {
            return this._effect;
          }
        },
        owner: {
          get: function get() {
            return this._owner;
          }
        }
      },
      statics: {
        getBuiltinMaterial: function getBuiltinMaterial(name) {
          return cc.AssetLibrary.getBuiltin("material", "builtin-" + name);
        },
        getInstantiatedBuiltinMaterial: function getInstantiatedBuiltinMaterial(name, renderComponent) {
          var builtinMaterial = this.getBuiltinMaterial(name);
          return Material.getInstantiatedMaterial(builtinMaterial, renderComponent);
        },
        getInstantiatedMaterial: function getInstantiatedMaterial(mat, renderComponent) {
          return mat._owner === renderComponent ? mat : _materialPool2.default.get(mat, renderComponent);
        }
      },
      copy: function copy(mat) {
        this.effectAsset = mat.effectAsset;
        for (var name in mat._defines) this.define(name, mat._defines[name]);
        for (var _name in mat._props) this.setProperty(_name, mat._props[_name]);
      },
      setProperty: function setProperty(name, val, force) {
        if (this._props[name] === val && !force) return;
        this._props[name] = val;
        this._dirty = true;
        if (this._effect) if (val instanceof Texture) {
          var loaded = function loaded() {
            this._effect.setProperty(name, val);
            var format = val.getPixelFormat();
            format !== PixelFormat.RGBA_ETC1 && format !== PixelFormat.RGB_A_PVRTC_4BPPV1 && format !== PixelFormat.RGB_A_PVRTC_2BPPV1 || this.define("CC_USE_ALPHA_ATLAS_" + name.toUpperCase(), true);
          };
          if (val.loaded) loaded.call(this); else {
            val.once("load", loaded, this);
            textureUtil.postLoadTexture(val);
          }
        } else this._effect.setProperty(name, val);
      },
      getProperty: function getProperty(name) {
        return this._props[name];
      },
      define: function define(name, val, force) {
        if (this._defines[name] === val && !force) return;
        this._defines[name] = val;
        this._dirty = true;
        this._effect && this._effect.define(name, val);
      },
      getDefine: function getDefine(name) {
        return this._defines[name];
      },
      setDirty: function setDirty(dirty) {
        this._dirty = dirty;
      },
      updateHash: function updateHash(hash) {
        void 0 === hash || null === hash ? hash = this.computeHash() : this._manualHash = true;
        this._dirty = false;
        this._hash = hash;
        this._effect && this._effect.updateHash(this._hash);
      },
      computeHash: function computeHash() {
        var effect = this._effect;
        var hashStr = "";
        if (effect) {
          hashStr += _utils2.default.serializeDefines(effect._defines);
          hashStr += _utils2.default.serializeTechniques(effect._techniques);
          hashStr += _utils2.default.serializeUniforms(effect._properties);
        }
        return (0, _murmurhash2_gc2.default)(hashStr, 666);
      },
      getHash: function getHash() {
        if (!this._dirty) return this._hash;
        this._manualHash || this.updateHash();
        this._dirty = false;
        return this._hash;
      },
      onLoad: function onLoad() {
        this.effectAsset = this._effectAsset;
        if (!this._effect) return;
        for (var def in this._defines) this.define(def, this._defines[def], true);
        for (var prop in this._props) this.setProperty(prop, this._props[prop], true);
      }
    });
    module.exports = cc.Material = Material;
  }), {
    "../../../renderer/murmurhash2_gc": 355,
    "../../utils/texture-util": 307,
    "../CCAsset": 57,
    "../CCEffectAsset": 61,
    "../CCTexture2D": 74,
    "./material-pool": 78,
    "./utils": 79
  } ],
  77: [ (function(require, module, exports) {
    "use strict";
    exports.__esModule = true;
    exports.default = void 0;
    var _murmurhash2_gc = require("../../../renderer/murmurhash2_gc");
    var _murmurhash2_gc2 = _interopRequireDefault(_murmurhash2_gc);
    var _utils = require("./utils");
    var _utils2 = _interopRequireDefault(_utils);
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : {
        default: obj
      };
    }
    function _classCallCheck(instance, Constructor) {
      if (!(instance instanceof Constructor)) throw new TypeError("Cannot call a class as a function");
    }
    var CustomProperties = (function() {
      function CustomProperties() {
        _classCallCheck(this, CustomProperties);
        this._properties = {};
        this._defines = {};
        this._dirty = false;
      }
      CustomProperties.prototype.setProperty = function setProperty(name, value, type, directly) {
        var uniform = this._properties[name];
        if (uniform) {
          if (uniform.value === value) return;
        } else {
          uniform = Object.create(null);
          uniform.name = name;
          uniform.type = type;
          uniform.directly = directly;
          this._properties[name] = uniform;
        }
        this._dirty = true;
        uniform.directly = directly;
        uniform.value = value;
      };
      CustomProperties.prototype.getProperty = function getProperty(name) {
        var prop = this._properties[name];
        if (prop) return prop.value;
        return null;
      };
      CustomProperties.prototype.define = function define(name, value) {
        if (this._defines[name] === value) return;
        this._dirty = true;
        this._defines[name] = value;
      };
      CustomProperties.prototype.getDefine = function getDefine(name) {
        return this._defines[name];
      };
      CustomProperties.prototype.extractProperties = function extractProperties() {
        var out = arguments.length > 0 && void 0 !== arguments[0] ? arguments[0] : {};
        Object.assign(out, this._properties);
        return out;
      };
      CustomProperties.prototype.extractDefines = function extractDefines() {
        var out = arguments.length > 0 && void 0 !== arguments[0] ? arguments[0] : {};
        Object.assign(out, this._defines);
        return out;
      };
      CustomProperties.prototype.getHash = function getHash() {
        if (!this._dirty) return this._hash;
        this._dirty = false;
        var hash = "";
        hash += _utils2.default.serializeDefines(this._defines);
        hash += _utils2.default.serializeUniforms(this._properties);
        return this._hash = (0, _murmurhash2_gc2.default)(hash, 666);
      };
      return CustomProperties;
    })();
    exports.default = CustomProperties;
    cc.CustomProperties = CustomProperties;
    module.exports = exports["default"];
  }), {
    "../../../renderer/murmurhash2_gc": 355,
    "./utils": 79
  } ],
  78: [ (function(require, module, exports) {
    "use strict";
    exports.__esModule = true;
    var _utils = require("./utils");
    var _utils2 = _interopRequireDefault(_utils);
    var _pool = require("../../utils/pool");
    var _pool2 = _interopRequireDefault(_pool);
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : {
        default: obj
      };
    }
    function _classCallCheck(instance, Constructor) {
      if (!(instance instanceof Constructor)) throw new TypeError("Cannot call a class as a function");
    }
    function _possibleConstructorReturn(self, call) {
      if (!self) throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
      return !call || "object" !== typeof call && "function" !== typeof call ? self : call;
    }
    function _inherits(subClass, superClass) {
      if ("function" !== typeof superClass && null !== superClass) throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
      subClass.prototype = Object.create(superClass && superClass.prototype, {
        constructor: {
          value: subClass,
          enumerable: false,
          writable: true,
          configurable: true
        }
      });
      superClass && (Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass);
    }
    var MaterialPool = (function(_Pool) {
      _inherits(MaterialPool, _Pool);
      function MaterialPool() {
        var _temp, _this, _ret;
        _classCallCheck(this, MaterialPool);
        for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) args[_key] = arguments[_key];
        return _ret = (_temp = (_this = _possibleConstructorReturn(this, _Pool.call.apply(_Pool, [ this ].concat(args))), 
        _this), _this.enabled = false, _this._pool = {}, _temp), _possibleConstructorReturn(_this, _ret);
      }
      MaterialPool.prototype.get = function get(exampleMat, renderComponent) {
        var pool = this._pool;
        var instance = void 0;
        if (this.enabled) {
          var uuid = exampleMat.effectAsset._uuid;
          if (pool[uuid]) {
            var key = _utils2.default.serializeDefines(exampleMat._effect._defines) + _utils2.default.serializeTechniques(exampleMat._effect._techniques);
            instance = pool[uuid][key] && pool[uuid][key].pop();
          }
        }
        if (instance) this.count--; else {
          instance = new cc.Material();
          instance.copy(exampleMat);
          instance._name = exampleMat._name + " (Instance)";
          instance._uuid = exampleMat._uuid;
        }
        instance._owner = renderComponent;
        return instance;
      };
      MaterialPool.prototype.put = function put(mat) {
        if (!this.enabled || !mat._owner) return;
        var pool = this._pool;
        var uuid = mat.effectAsset._uuid;
        pool[uuid] || (pool[uuid] = {});
        var key = _utils2.default.serializeDefines(mat._effect._defines) + _utils2.default.serializeTechniques(mat._effect._techniques);
        pool[uuid][key] || (pool[uuid][key] = []);
        if (this.count > this.maxSize) return;
        this._clean(mat);
        pool[uuid][key].push(mat);
        this.count++;
      };
      MaterialPool.prototype.clear = function clear() {
        this._pool = {};
        this.count = 0;
      };
      MaterialPool.prototype._clean = function _clean(mat) {
        mat._owner = null;
      };
      return MaterialPool;
    })(_pool2.default);
    var materialPool = new MaterialPool();
    _pool2.default.register("material", materialPool);
    exports.default = materialPool;
    module.exports = exports["default"];
  }), {
    "../../utils/pool": 301,
    "./utils": 79
  } ],
  79: [ (function(require, module, exports) {
    "use strict";
    exports.__esModule = true;
    var _enums = require("../../../renderer/enums");
    var _enums2 = _interopRequireDefault(_enums);
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : {
        default: obj
      };
    }
    function serializeDefines(defines) {
      var str = "";
      for (var name in defines) str += name + defines[name];
      return str;
    }
    function serializePass(pass) {
      var str = pass._programName + pass._cullMode;
      pass._blend && (str += pass._blendEq + pass._blendAlphaEq + pass._blendSrc + pass._blendDst + pass._blendSrcAlpha + pass._blendDstAlpha + pass._blendColor);
      pass._depthTest && (str += pass._depthWrite + pass._depthFunc);
      pass._stencilTest && (str += pass._stencilFuncFront + pass._stencilRefFront + pass._stencilMaskFront + pass._stencilFailOpFront + pass._stencilZFailOpFront + pass._stencilZPassOpFront + pass._stencilWriteMaskFront + pass._stencilFuncBack + pass._stencilRefBack + pass._stencilMaskBack + pass._stencilFailOpBack + pass._stencilZFailOpBack + pass._stencilZPassOpBack + pass._stencilWriteMaskBack);
      return str;
    }
    function serializeTechniques(techniques) {
      var hashData = "";
      for (var i = 0; i < techniques.length; i++) {
        var techData = techniques[i];
        hashData += techData.stageIDs;
        for (var j = 0; j < techData.passes.length; j++) hashData += serializePass(techData.passes[j]);
      }
      return hashData;
    }
    function serializeUniforms(uniforms) {
      var hashData = "";
      for (var name in uniforms) {
        var param = uniforms[name];
        var prop = param.value;
        if (!prop) continue;
        param.type === _enums2.default.PARAM_TEXTURE_2D || param.type === _enums2.default.PARAM_TEXTURE_CUBE ? hashData += prop._id + ";" : hashData += prop.toString() + ";";
      }
      return hashData;
    }
    exports.default = {
      serializeDefines: serializeDefines,
      serializeTechniques: serializeTechniques,
      serializeUniforms: serializeUniforms
    };
    module.exports = exports["default"];
  }), {
    "../../../renderer/enums": 351
  } ],
  80: [ (function(require, module, exports) {
    "use strict";
    var Event = require("../CCNode").EventType;
    var TOP = 1;
    var MID = 2;
    var BOT = 4;
    var LEFT = 8;
    var CENTER = 16;
    var RIGHT = 32;
    var HORIZONTAL = LEFT | CENTER | RIGHT;
    var VERTICAL = TOP | MID | BOT;
    var AlignMode = cc.Enum({
      ONCE: 0,
      ON_WINDOW_RESIZE: 1,
      ALWAYS: 2
    });
    function getReadonlyNodeSize(parent) {
      return parent instanceof cc.Scene ? cc.visibleRect : parent._contentSize;
    }
    function computeInverseTransForTarget(widgetNode, target, out_inverseTranslate, out_inverseScale) {
      var scaleX = widgetNode._parent.scaleX;
      var scaleY = widgetNode._parent.scaleY;
      var translateX = 0;
      var translateY = 0;
      for (var node = widgetNode._parent; ;) {
        translateX += node.x;
        translateY += node.y;
        node = node._parent;
        if (!node) {
          out_inverseTranslate.x = out_inverseTranslate.y = 0;
          out_inverseScale.x = out_inverseScale.y = 1;
          return;
        }
        if (node === target) break;
        var sx = node.scaleX;
        var sy = node.scaleY;
        translateX *= sx;
        translateY *= sy;
        scaleX *= sx;
        scaleY *= sy;
      }
      out_inverseScale.x = 0 !== scaleX ? 1 / scaleX : 1;
      out_inverseScale.y = 0 !== scaleY ? 1 / scaleY : 1;
      out_inverseTranslate.x = -translateX;
      out_inverseTranslate.y = -translateY;
    }
    var tInverseTranslate = cc.Vec2.ZERO;
    var tInverseScale = cc.Vec2.ONE;
    function align(node, widget) {
      var hasTarget = widget._target;
      var target;
      var inverseTranslate, inverseScale;
      if (hasTarget) {
        target = hasTarget;
        inverseTranslate = tInverseTranslate;
        inverseScale = tInverseScale;
        computeInverseTransForTarget(node, target, inverseTranslate, inverseScale);
      } else target = node._parent;
      var targetSize = getReadonlyNodeSize(target);
      var targetAnchor = target._anchorPoint;
      var isRoot = (true, target instanceof cc.Scene);
      var x = node.x, y = node.y;
      var anchor = node._anchorPoint;
      if (widget._alignFlags & HORIZONTAL) {
        var localLeft, localRight, targetWidth = targetSize.width;
        if (isRoot) {
          localLeft = cc.visibleRect.left.x;
          localRight = cc.visibleRect.right.x;
        } else {
          localLeft = -targetAnchor.x * targetWidth;
          localRight = localLeft + targetWidth;
        }
        localLeft += widget._isAbsLeft ? widget._left : widget._left * targetWidth;
        localRight -= widget._isAbsRight ? widget._right : widget._right * targetWidth;
        if (hasTarget) {
          localLeft += inverseTranslate.x;
          localLeft *= inverseScale.x;
          localRight += inverseTranslate.x;
          localRight *= inverseScale.x;
        }
        var width, anchorX = anchor.x, scaleX = node.scaleX;
        if (scaleX < 0) {
          anchorX = 1 - anchorX;
          scaleX = -scaleX;
        }
        if (widget.isStretchWidth) {
          width = localRight - localLeft;
          0 !== scaleX && (node.width = width / scaleX);
          x = localLeft + anchorX * width;
        } else {
          width = node.width * scaleX;
          if (widget.isAlignHorizontalCenter) {
            var localHorizontalCenter = widget._isAbsHorizontalCenter ? widget._horizontalCenter : widget._horizontalCenter * targetWidth;
            var targetCenter = (.5 - targetAnchor.x) * targetSize.width;
            if (hasTarget) {
              localHorizontalCenter *= inverseScale.x;
              targetCenter += inverseTranslate.x;
              targetCenter *= inverseScale.x;
            }
            x = targetCenter + (anchorX - .5) * width + localHorizontalCenter;
          } else x = widget.isAlignLeft ? localLeft + anchorX * width : localRight + (anchorX - 1) * width;
        }
      }
      if (widget._alignFlags & VERTICAL) {
        var localTop, localBottom, targetHeight = targetSize.height;
        if (isRoot) {
          localBottom = cc.visibleRect.bottom.y;
          localTop = cc.visibleRect.top.y;
        } else {
          localBottom = -targetAnchor.y * targetHeight;
          localTop = localBottom + targetHeight;
        }
        localBottom += widget._isAbsBottom ? widget._bottom : widget._bottom * targetHeight;
        localTop -= widget._isAbsTop ? widget._top : widget._top * targetHeight;
        if (hasTarget) {
          localBottom += inverseTranslate.y;
          localBottom *= inverseScale.y;
          localTop += inverseTranslate.y;
          localTop *= inverseScale.y;
        }
        var height, anchorY = anchor.y, scaleY = node.scaleY;
        if (scaleY < 0) {
          anchorY = 1 - anchorY;
          scaleY = -scaleY;
        }
        if (widget.isStretchHeight) {
          height = localTop - localBottom;
          0 !== scaleY && (node.height = height / scaleY);
          y = localBottom + anchorY * height;
        } else {
          height = node.height * scaleY;
          if (widget.isAlignVerticalCenter) {
            var localVerticalCenter = widget._isAbsVerticalCenter ? widget._verticalCenter : widget._verticalCenter * targetHeight;
            var targetMiddle = (.5 - targetAnchor.y) * targetSize.height;
            if (hasTarget) {
              localVerticalCenter *= inverseScale.y;
              targetMiddle += inverseTranslate.y;
              targetMiddle *= inverseScale.y;
            }
            y = targetMiddle + (anchorY - .5) * height + localVerticalCenter;
          } else y = widget.isAlignBottom ? localBottom + anchorY * height : localTop + (anchorY - 1) * height;
        }
      }
      node.setPosition(x, y);
    }
    function visitNode(node) {
      var widget = node._widget;
      if (widget) {
        false;
        align(node, widget);
        true, widget.alignMode !== AlignMode.ALWAYS ? widget.enabled = false : activeWidgets.push(widget);
      }
      var children = node._children;
      for (var i = 0; i < children.length; i++) {
        var child = children[i];
        child._active && visitNode(child);
      }
    }
    var animationState;
    false;
    function refreshScene() {
      var AnimUtils;
      var EditMode;
      var nowPreviewing;
      var component;
      var animation;
      var _component;
      var _animation;
      false;
      var scene = cc.director.getScene();
      if (scene) {
        widgetManager.isAligning = true;
        if (widgetManager._nodesOrderDirty) {
          activeWidgets.length = 0;
          visitNode(scene);
          widgetManager._nodesOrderDirty = false;
        } else {
          var i, widget, iterator = widgetManager._activeWidgetsIterator;
          var AnimUtils;
          var editingNode;
          var node;
          false;
          for (iterator.i = 0; iterator.i < activeWidgets.length; ++iterator.i) {
            widget = activeWidgets[iterator.i];
            align(widget.node, widget);
          }
        }
        widgetManager.isAligning = false;
      }
      false;
    }
    var adjustWidgetToAllowMovingInEditor = false;
    var adjustWidgetToAllowResizingInEditor = false;
    var activeWidgets = [];
    function updateAlignment(node) {
      var parent = node._parent;
      cc.Node.isNode(parent) && updateAlignment(parent);
      var widget = node._widget || node.getComponent(cc.Widget);
      widget && parent && align(node, widget);
    }
    var widgetManager = cc._widgetManager = module.exports = {
      _AlignFlags: {
        TOP: TOP,
        MID: MID,
        BOT: BOT,
        LEFT: LEFT,
        CENTER: CENTER,
        RIGHT: RIGHT
      },
      isAligning: false,
      _nodesOrderDirty: false,
      _activeWidgetsIterator: new cc.js.array.MutableForwardIterator(activeWidgets),
      init: function init(director) {
        director.on(cc.Director.EVENT_AFTER_UPDATE, refreshScene);
        false;
        cc.sys.isMobile ? window.addEventListener("resize", this.onResized.bind(this)) : cc.view.on("canvas-resize", this.onResized, this);
      },
      add: function add(widget) {
        widget.node._widget = widget;
        this._nodesOrderDirty = true;
        false;
      },
      remove: function remove(widget) {
        widget.node._widget = null;
        this._activeWidgetsIterator.remove(widget);
        false;
      },
      onResized: function onResized() {
        var scene = cc.director.getScene();
        scene && this.refreshWidgetOnResized(scene);
      },
      refreshWidgetOnResized: function refreshWidgetOnResized(node) {
        var widget = cc.Node.isNode(node) && node.getComponent(cc.Widget);
        widget && widget.alignMode === AlignMode.ON_WINDOW_RESIZE && (widget.enabled = true);
        var children = node._children;
        for (var i = 0; i < children.length; i++) {
          var child = children[i];
          this.refreshWidgetOnResized(child);
        }
      },
      updateAlignment: updateAlignment,
      AlignMode: AlignMode
    };
    false;
  }), {
    "../CCNode": 53
  } ],
  81: [ (function(require, module, exports) {
    "use strict";
    var _geomUtils = require("../geom-utils");
    var _geomUtils2 = _interopRequireDefault(_geomUtils);
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : {
        default: obj
      };
    }
    var AffineTrans = require("../utils/affine-transform");
    var renderer = require("../renderer/index");
    var RenderFlow = require("../renderer/render-flow");
    var game = require("../CCGame");
    var RendererCamera = null;
    true, true;
    RendererCamera = window.renderer.Camera;
    var mat4 = cc.vmath.mat4;
    var vec2 = cc.vmath.vec2;
    var vec3 = cc.vmath.vec3;
    var _mat4_temp_1 = mat4.create();
    var _mat4_temp_2 = mat4.create();
    var _v3_temp_1 = cc.v3();
    var _v3_temp_2 = cc.v3();
    var _v3_temp_3 = cc.v3();
    var _cameras = [];
    var _debugCamera = null;
    function repositionDebugCamera() {
      if (!_debugCamera) return;
      var node = _debugCamera.getNode();
      var canvas = cc.game.canvas;
      node.z = canvas.height / 1.1566;
      node.x = canvas.width / 2;
      node.y = canvas.height / 2;
    }
    var ClearFlags = cc.Enum({
      COLOR: 1,
      DEPTH: 2,
      STENCIL: 4
    });
    var StageFlags = cc.Enum({
      OPAQUE: 1,
      TRANSPARENT: 2
    });
    var Camera = cc.Class({
      name: "cc.Camera",
      extends: cc.Component,
      ctor: function ctor() {
        if (game.renderType !== game.RENDER_TYPE_CANVAS) {
          var camera = new RendererCamera();
          camera.setStages([ "opaque" ]);
          camera.dirty = true;
          this._inited = false;
          this._camera = camera;
        } else this._inited = true;
      },
      editor: false,
      properties: {
        _cullingMask: 4294967295,
        _clearFlags: ClearFlags.DEPTH | ClearFlags.STENCIL,
        _backgroundColor: cc.color(0, 0, 0, 255),
        _depth: 0,
        _zoomRatio: 1,
        _targetTexture: null,
        _fov: 60,
        _orthoSize: 10,
        _nearClip: 1,
        _farClip: 4096,
        _ortho: true,
        _rect: cc.rect(0, 0, 1, 1),
        _renderStages: 1,
        _alignWithScreen: true,
        zoomRatio: {
          get: function get() {
            return this._zoomRatio;
          },
          set: function set(value) {
            this._zoomRatio = value;
          },
          tooltip: false
        },
        fov: {
          get: function get() {
            return this._fov;
          },
          set: function set(v) {
            this._fov = v;
          },
          tooltip: false
        },
        orthoSize: {
          get: function get() {
            return this._orthoSize;
          },
          set: function set(v) {
            this._orthoSize = v;
          },
          tooltip: false
        },
        nearClip: {
          get: function get() {
            return this._nearClip;
          },
          set: function set(v) {
            this._nearClip = v;
            this._updateClippingpPlanes();
          },
          tooltip: false
        },
        farClip: {
          get: function get() {
            return this._farClip;
          },
          set: function set(v) {
            this._farClip = v;
            this._updateClippingpPlanes();
          },
          tooltip: false
        },
        ortho: {
          get: function get() {
            return this._ortho;
          },
          set: function set(v) {
            this._ortho = v;
            this._updateProjection();
          },
          tooltip: false
        },
        rect: {
          get: function get() {
            return this._rect;
          },
          set: function set(v) {
            this._rect = v;
            this._updateRect();
          },
          tooltip: false
        },
        cullingMask: {
          get: function get() {
            return this._cullingMask;
          },
          set: function set(value) {
            this._cullingMask = value;
            this._updateCameraMask();
          },
          tooltip: false
        },
        clearFlags: {
          get: function get() {
            return this._clearFlags;
          },
          set: function set(value) {
            this._clearFlags = value;
            this._camera && this._camera.setClearFlags(value);
          },
          tooltip: false
        },
        backgroundColor: {
          get: function get() {
            return this._backgroundColor;
          },
          set: function set(value) {
            this._backgroundColor = value;
            this._updateBackgroundColor();
          },
          tooltip: false
        },
        depth: {
          get: function get() {
            return this._depth;
          },
          set: function set(value) {
            this._depth = value;
            this._camera && this._camera.setPriority(value);
          },
          tooltip: false
        },
        targetTexture: {
          get: function get() {
            return this._targetTexture;
          },
          set: function set(value) {
            this._targetTexture = value;
            this._updateTargetTexture();
          },
          tooltip: false
        },
        renderStages: {
          get: function get() {
            return this._renderStages;
          },
          set: function set(val) {
            this._renderStages = val;
            this._updateStages();
          },
          tooltip: false
        },
        alignWithScreen: {
          get: function get() {
            return this._alignWithScreen;
          },
          set: function set(v) {
            this._alignWithScreen = v;
          }
        },
        _is3D: {
          get: function get() {
            return this.node && this.node._is3DNode;
          }
        }
      },
      statics: {
        main: null,
        cameras: _cameras,
        ClearFlags: ClearFlags,
        findCamera: function findCamera(node) {
          for (var i = 0, l = _cameras.length; i < l; i++) {
            var camera = _cameras[i];
            if (camera.containsNode(node)) return camera;
          }
          return null;
        },
        _findRendererCamera: function _findRendererCamera(node) {
          var cameras = renderer.scene._cameras;
          for (var i = 0; i < cameras._count; i++) if (cameras._data[i]._cullingMask & node._cullingMask) return cameras._data[i];
          return null;
        },
        _setupDebugCamera: function _setupDebugCamera() {
          if (_debugCamera) return;
          if (game.renderType === game.RENDER_TYPE_CANVAS) return;
          var camera = new RendererCamera();
          _debugCamera = camera;
          camera.setStages([ "opaque" ]);
          camera.setFov(60 * Math.PI / 180);
          camera.setNear(.1);
          camera.setFar(4096);
          camera.dirty = true;
          camera.cullingMask = 1 << cc.Node.BuiltinGroupIndex.DEBUG;
          camera.setPriority(cc.macro.MAX_ZINDEX);
          camera.setClearFlags(0);
          camera.setColor(0, 0, 0, 0);
          var node = new cc.Node();
          camera.setNode(node);
          repositionDebugCamera();
          cc.view.on("design-resolution-changed", repositionDebugCamera);
          renderer.scene.addCamera(camera);
        }
      },
      _updateCameraMask: function _updateCameraMask() {
        if (this._camera) {
          var mask = this._cullingMask & ~(1 << cc.Node.BuiltinGroupIndex.DEBUG);
          this._camera.cullingMask = mask;
        }
      },
      _updateBackgroundColor: function _updateBackgroundColor() {
        if (!this._camera) return;
        var color = this._backgroundColor;
        this._camera.setColor(color.r / 255, color.g / 255, color.b / 255, color.a / 255);
      },
      _updateTargetTexture: function _updateTargetTexture() {
        if (!this._camera) return;
        var texture = this._targetTexture;
        this._camera.setFrameBuffer(texture ? texture._framebuffer : null);
      },
      _updateClippingpPlanes: function _updateClippingpPlanes() {
        if (!this._camera) return;
        this._camera.setNear(this._nearClip);
        this._camera.setFar(this._farClip);
      },
      _updateProjection: function _updateProjection() {
        if (!this._camera) return;
        var type = this._ortho ? 1 : 0;
        this._camera.setType(type);
      },
      _updateRect: function _updateRect() {
        if (!this._camera) return;
        var rect = this._rect;
        this._camera.setRect(rect.x, rect.y, rect.width, rect.height);
      },
      _updateStages: function _updateStages() {
        var flags = this._renderStages;
        var stages = [];
        flags & StageFlags.OPAQUE && stages.push("opaque");
        flags & StageFlags.TRANSPARENT && stages.push("transparent");
        this._camera.setStages(stages);
      },
      _init: function _init() {
        if (this._inited) return;
        this._inited = true;
        var camera = this._camera;
        if (!camera) return;
        camera.setNode(this.node);
        camera.setClearFlags(this._clearFlags);
        camera.setPriority(this._depth);
        this._updateBackgroundColor();
        this._updateCameraMask();
        this._updateTargetTexture();
        this._updateClippingpPlanes();
        this._updateProjection();
        this._updateStages();
        this._updateRect();
        this.beforeDraw();
      },
      onLoad: function onLoad() {
        this._init();
      },
      onEnable: function onEnable() {
        if (true, game.renderType !== game.RENDER_TYPE_CANVAS) {
          cc.director.on(cc.Director.EVENT_BEFORE_DRAW, this.beforeDraw, this);
          renderer.scene.addCamera(this._camera);
        }
        _cameras.push(this);
      },
      onDisable: function onDisable() {
        if (true, game.renderType !== game.RENDER_TYPE_CANVAS) {
          cc.director.off(cc.Director.EVENT_BEFORE_DRAW, this.beforeDraw, this);
          renderer.scene.removeCamera(this._camera);
        }
        cc.js.array.remove(_cameras, this);
      },
      getScreenToWorldMatrix2D: function getScreenToWorldMatrix2D(out) {
        this.getWorldToScreenMatrix2D(out);
        mat4.invert(out, out);
        return out;
      },
      getWorldToScreenMatrix2D: function getWorldToScreenMatrix2D(out) {
        this.node.getWorldRT(_mat4_temp_1);
        var zoomRatio = this.zoomRatio;
        var _mat4_temp_1m = _mat4_temp_1.m;
        _mat4_temp_1m[0] *= zoomRatio;
        _mat4_temp_1m[1] *= zoomRatio;
        _mat4_temp_1m[4] *= zoomRatio;
        _mat4_temp_1m[5] *= zoomRatio;
        var m12 = _mat4_temp_1m[12];
        var m13 = _mat4_temp_1m[13];
        var center = cc.visibleRect.center;
        _mat4_temp_1m[12] = center.x - (_mat4_temp_1m[0] * m12 + _mat4_temp_1m[4] * m13);
        _mat4_temp_1m[13] = center.y - (_mat4_temp_1m[1] * m12 + _mat4_temp_1m[5] * m13);
        out !== _mat4_temp_1 && mat4.copy(out, _mat4_temp_1);
        return out;
      },
      getScreenToWorldPoint: function getScreenToWorldPoint(screenPosition, out) {
        if (this.node.is3DNode) {
          out = out || new cc.Vec3();
          this._camera.screenToWorld(out, screenPosition, cc.visibleRect.width, cc.visibleRect.height);
        } else {
          out = out || new cc.Vec2();
          this.getScreenToWorldMatrix2D(_mat4_temp_1);
          vec2.transformMat4(out, screenPosition, _mat4_temp_1);
        }
        return out;
      },
      getWorldToScreenPoint: function getWorldToScreenPoint(worldPosition, out) {
        if (this.node.is3DNode) {
          out = out || new cc.Vec3();
          this._camera.worldToScreen(out, worldPosition, cc.visibleRect.width, cc.visibleRect.height);
        } else {
          out = out || new cc.Vec2();
          this.getWorldToScreenMatrix2D(_mat4_temp_1);
          vec2.transformMat4(out, worldPosition, _mat4_temp_1);
        }
        return out;
      },
      getRay: function getRay(screenPos) {
        if (!_geomUtils2.default) return screenPos;
        vec3.set(_v3_temp_3, screenPos.x, screenPos.y, 1);
        this._camera.screenToWorld(_v3_temp_2, _v3_temp_3, cc.visibleRect.width, cc.visibleRect.height);
        if (this.ortho) {
          vec3.set(_v3_temp_3, screenPos.x, screenPos.y, -1);
          this._camera.screenToWorld(_v3_temp_1, _v3_temp_3, cc.visibleRect.width, cc.visibleRect.height);
        } else this.node.getWorldPosition(_v3_temp_1);
        return _geomUtils2.default.Ray.fromPoints(_geomUtils2.default.Ray.create(), _v3_temp_1, _v3_temp_2);
      },
      containsNode: function containsNode(node) {
        return node._cullingMask & this.cullingMask;
      },
      render: function render(root) {
        root = root || cc.director.getScene();
        if (!root) return null;
        this.node.getWorldMatrix(_mat4_temp_1);
        this.beforeDraw();
        RenderFlow.render(root);
        false;
      },
      _onAlignWithScreen: function _onAlignWithScreen() {
        var height = cc.game.canvas.height / cc.view._scaleY;
        var targetTexture = this._targetTexture;
        if (targetTexture) {
          false;
          height = cc.visibleRect.height;
        }
        var fov = this._fov * cc.macro.RAD;
        this.node.z = height / (2 * Math.tan(fov / 2));
        fov = 2 * Math.atan(Math.tan(fov / 2) / this.zoomRatio);
        this._camera.setFov(fov);
        this._camera.setOrthoHeight(height / 2 / this.zoomRatio);
        this.node.setRotation(0, 0, 0, 1);
      },
      beforeDraw: function beforeDraw() {
        if (!this._camera) return;
        if (this._alignWithScreen) this._onAlignWithScreen(); else {
          var fov = this._fov * cc.macro.RAD;
          fov = 2 * Math.atan(Math.tan(fov / 2) / this.zoomRatio);
          this._camera.setFov(fov);
          this._camera.setOrthoHeight(this._orthoSize * this.zoomRatio);
        }
        this._camera.dirty = true;
      }
    });
    cc.js.mixin(Camera.prototype, {
      getNodeToCameraTransform: function getNodeToCameraTransform(node) {
        var out = AffineTrans.identity();
        node.getWorldMatrix(_mat4_temp_2);
        if (this.containsNode(node)) {
          this.getWorldToCameraMatrix(_mat4_temp_1);
          mat4.mul(_mat4_temp_2, _mat4_temp_2, _mat4_temp_1);
        }
        AffineTrans.fromMat4(out, _mat4_temp_2);
        return out;
      },
      getCameraToWorldPoint: function getCameraToWorldPoint(point, out) {
        return this.getScreenToWorldPoint(point, out);
      },
      getWorldToCameraPoint: function getWorldToCameraPoint(point, out) {
        return this.getWorldToScreenPoint(point, out);
      },
      getCameraToWorldMatrix: function getCameraToWorldMatrix(out) {
        return this.getScreenToWorldMatrix2D(out);
      },
      getWorldToCameraMatrix: function getWorldToCameraMatrix(out) {
        return this.getWorldToScreenMatrix2D(out);
      }
    });
    module.exports = cc.Camera = Camera;
  }), {
    "../../renderer/scene/camera": void 0,
    "../CCGame": 52,
    "../geom-utils": 137,
    "../renderer/index": 248,
    "../renderer/render-flow": 249,
    "../utils/affine-transform": 289
  } ],
  82: [ (function(require, module, exports) {
    "use strict";
    cc.Collider.Box = cc.Class({
      properties: {
        _offset: cc.v2(0, 0),
        _size: cc.size(100, 100),
        offset: {
          tooltip: false,
          get: function get() {
            return this._offset;
          },
          set: function set(value) {
            this._offset = value;
          },
          type: cc.Vec2
        },
        size: {
          tooltip: false,
          get: function get() {
            return this._size;
          },
          set: function set(value) {
            this._size.width = value.width < 0 ? 0 : value.width;
            this._size.height = value.height < 0 ? 0 : value.height;
          },
          type: cc.Size
        }
      },
      resetInEditor: false
    });
    var BoxCollider = cc.Class({
      name: "cc.BoxCollider",
      extends: cc.Collider,
      mixins: [ cc.Collider.Box ],
      editor: false
    });
    cc.BoxCollider = module.exports = BoxCollider;
  }), {} ],
  83: [ (function(require, module, exports) {
    "use strict";
    cc.Collider.Circle = cc.Class({
      properties: {
        _offset: cc.v2(0, 0),
        _radius: 50,
        offset: {
          get: function get() {
            return this._offset;
          },
          set: function set(value) {
            this._offset = value;
          },
          type: cc.Vec2
        },
        radius: {
          tooltip: false,
          get: function get() {
            return this._radius;
          },
          set: function set(value) {
            this._radius = value < 0 ? 0 : value;
          }
        }
      },
      resetInEditor: false
    });
    var CircleCollider = cc.Class({
      name: "cc.CircleCollider",
      extends: cc.Collider,
      mixins: [ cc.Collider.Circle ],
      editor: false
    });
    cc.CircleCollider = module.exports = CircleCollider;
  }), {} ],
  84: [ (function(require, module, exports) {
    "use strict";
    var Collider = cc.Class({
      name: "cc.Collider",
      extends: cc.Component,
      properties: {
        editing: {
          default: false,
          serializable: false,
          tooltip: false
        },
        tag: {
          tooltip: false,
          default: 0,
          range: [ 0, 1e7 ],
          type: cc.Integer
        }
      },
      onDisable: function onDisable() {
        cc.director.getCollisionManager().removeCollider(this);
      },
      onEnable: function onEnable() {
        cc.director.getCollisionManager().addCollider(this);
      }
    });
    cc.Collider = module.exports = Collider;
  }), {} ],
  85: [ (function(require, module, exports) {
    "use strict";
    var Contact = require("./CCContact");
    var CollisionType = Contact.CollisionType;
    var NodeEvent = require("../CCNode").EventType;
    var math = cc.vmath;
    var _vec2 = cc.v2();
    function obbApplyMatrix(rect, mat4, out_bl, out_tl, out_tr, out_br) {
      var x = rect.x;
      var y = rect.y;
      var width = rect.width;
      var height = rect.height;
      var mat4m = mat4.m;
      var m00 = mat4m[0], m01 = mat4m[1], m04 = mat4m[4], m05 = mat4m[5];
      var m12 = mat4m[12], m13 = mat4m[13];
      var tx = m00 * x + m04 * y + m12;
      var ty = m01 * x + m05 * y + m13;
      var xa = m00 * width;
      var xb = m01 * width;
      var yc = m04 * height;
      var yd = m05 * height;
      out_tl.x = tx;
      out_tl.y = ty;
      out_tr.x = xa + tx;
      out_tr.y = xb + ty;
      out_bl.x = yc + tx;
      out_bl.y = yd + ty;
      out_br.x = xa + yc + tx;
      out_br.y = xb + yd + ty;
    }
    var CollisionManager = cc.Class({
      mixins: [ cc.EventTarget ],
      properties: {
        enabled: false,
        enabledDrawBoundingBox: false
      },
      ctor: function ctor() {
        this._contacts = [];
        this._colliders = [];
        this._debugDrawer = null;
        this._enabledDebugDraw = false;
        cc.director._scheduler && cc.director._scheduler.enableForTarget(this);
      },
      update: function update(dt) {
        if (!this.enabled) return;
        var i = void 0, l = void 0;
        var colliders = this._colliders;
        for (i = 0, l = colliders.length; i < l; i++) this.updateCollider(colliders[i]);
        var contacts = this._contacts;
        var results = [];
        for (i = 0, l = contacts.length; i < l; i++) {
          var collisionType = contacts[i].updateState();
          if (collisionType === CollisionType.None) continue;
          results.push([ collisionType, contacts[i] ]);
        }
        for (i = 0, l = results.length; i < l; i++) {
          var result = results[i];
          this._doCollide(result[0], result[1]);
        }
        this.drawColliders();
      },
      _doCollide: function _doCollide(collisionType, contact) {
        var contactFunc = void 0;
        switch (collisionType) {
         case CollisionType.CollisionEnter:
          contactFunc = "onCollisionEnter";
          break;

         case CollisionType.CollisionStay:
          contactFunc = "onCollisionStay";
          break;

         case CollisionType.CollisionExit:
          contactFunc = "onCollisionExit";
        }
        var collider1 = contact.collider1;
        var collider2 = contact.collider2;
        var comps1 = collider1.node._components;
        var comps2 = collider2.node._components;
        var i = void 0, l = void 0, comp = void 0;
        for (i = 0, l = comps1.length; i < l; i++) {
          comp = comps1[i];
          comp[contactFunc] && comp[contactFunc](collider2, collider1);
        }
        for (i = 0, l = comps2.length; i < l; i++) {
          comp = comps2[i];
          comp[contactFunc] && comp[contactFunc](collider1, collider2);
        }
      },
      shouldCollide: function shouldCollide(c1, c2) {
        var node1 = c1.node, node2 = c2.node;
        var collisionMatrix = cc.game.collisionMatrix;
        return node1 !== node2 && collisionMatrix[node1.groupIndex][node2.groupIndex];
      },
      initCollider: function initCollider(collider) {
        if (!collider.world) {
          var world = collider.world = {};
          world.aabb = cc.rect();
          world.preAabb = cc.rect();
          world.matrix = math.mat4.create();
          world.radius = 0;
          if (collider instanceof cc.BoxCollider) {
            world.position = null;
            world.points = [ cc.v2(), cc.v2(), cc.v2(), cc.v2() ];
          } else if (collider instanceof cc.PolygonCollider) {
            world.position = null;
            world.points = collider.points.map((function(p) {
              return cc.v2(p.x, p.y);
            }));
          } else if (collider instanceof cc.CircleCollider) {
            world.position = cc.v2();
            world.points = null;
          }
        }
      },
      updateCollider: function updateCollider(collider) {
        var offset = collider.offset;
        var world = collider.world;
        var aabb = world.aabb;
        var m = world.matrix;
        collider.node.getWorldMatrix(m);
        var preAabb = world.preAabb;
        preAabb.x = aabb.x;
        preAabb.y = aabb.y;
        preAabb.width = aabb.width;
        preAabb.height = aabb.height;
        if (collider instanceof cc.BoxCollider) {
          var size = collider.size;
          aabb.x = offset.x - size.width / 2;
          aabb.y = offset.y - size.height / 2;
          aabb.width = size.width;
          aabb.height = size.height;
          var wps = world.points;
          var wp0 = wps[0], wp1 = wps[1], wp2 = wps[2], wp3 = wps[3];
          obbApplyMatrix(aabb, m, wp0, wp1, wp2, wp3);
          var minx = Math.min(wp0.x, wp1.x, wp2.x, wp3.x);
          var miny = Math.min(wp0.y, wp1.y, wp2.y, wp3.y);
          var maxx = Math.max(wp0.x, wp1.x, wp2.x, wp3.x);
          var maxy = Math.max(wp0.y, wp1.y, wp2.y, wp3.y);
          aabb.x = minx;
          aabb.y = miny;
          aabb.width = maxx - minx;
          aabb.height = maxy - miny;
        } else if (collider instanceof cc.CircleCollider) {
          math.vec2.transformMat4(_vec2, collider.offset, m);
          world.position.x = _vec2.x;
          world.position.y = _vec2.y;
          var mm = m.m;
          var tempx = mm[12], tempy = mm[13];
          mm[12] = mm[13] = 0;
          _vec2.x = collider.radius;
          _vec2.y = 0;
          math.vec2.transformMat4(_vec2, _vec2, m);
          var d = Math.sqrt(_vec2.x * _vec2.x + _vec2.y * _vec2.y);
          world.radius = d;
          aabb.x = world.position.x - d;
          aabb.y = world.position.y - d;
          aabb.width = 2 * d;
          aabb.height = 2 * d;
          mm[12] = tempx;
          mm[13] = tempy;
        } else if (collider instanceof cc.PolygonCollider) {
          var points = collider.points;
          var worldPoints = world.points;
          worldPoints.length = points.length;
          var _minx = 1e6, _miny = 1e6, _maxx = -1e6, _maxy = -1e6;
          for (var i = 0, l = points.length; i < l; i++) {
            worldPoints[i] || (worldPoints[i] = cc.v2());
            _vec2.x = points[i].x + offset.x;
            _vec2.y = points[i].y + offset.y;
            math.vec2.transformMat4(_vec2, _vec2, m);
            var x = _vec2.x;
            var y = _vec2.y;
            worldPoints[i].x = x;
            worldPoints[i].y = y;
            x > _maxx && (_maxx = x);
            x < _minx && (_minx = x);
            y > _maxy && (_maxy = y);
            y < _miny && (_miny = y);
          }
          aabb.x = _minx;
          aabb.y = _miny;
          aabb.width = _maxx - _minx;
          aabb.height = _maxy - _miny;
        }
      },
      addCollider: function addCollider(collider) {
        var colliders = this._colliders;
        var index = colliders.indexOf(collider);
        if (-1 === index) {
          for (var i = 0, l = colliders.length; i < l; i++) {
            var other = colliders[i];
            if (this.shouldCollide(collider, other)) {
              var contact = new Contact(collider, other);
              this._contacts.push(contact);
            }
          }
          colliders.push(collider);
          this.initCollider(collider);
        }
        collider.node.on(NodeEvent.GROUP_CHANGED, this.onNodeGroupChanged, this);
      },
      removeCollider: function removeCollider(collider) {
        var colliders = this._colliders;
        var index = colliders.indexOf(collider);
        if (index >= 0) {
          colliders.splice(index, 1);
          var contacts = this._contacts;
          for (var i = contacts.length - 1; i >= 0; i--) {
            var contact = contacts[i];
            if (contact.collider1 === collider || contact.collider2 === collider) {
              contact.touching && this._doCollide(CollisionType.CollisionExit, contact);
              contacts.splice(i, 1);
            }
          }
          collider.node.off(NodeEvent.GROUP_CHANGED, this.onNodeGroupChanged, this);
        } else cc.errorID(6600);
      },
      onNodeGroupChanged: function onNodeGroupChanged(node) {
        var colliders = node.getComponents(cc.Collider);
        for (var i = 0, l = colliders.length; i < l; i++) {
          var collider = colliders[i];
          if (cc.PhysicsCollider && collider instanceof cc.PhysicsCollider) continue;
          this.removeCollider(collider);
          this.addCollider(collider);
        }
      },
      drawColliders: function drawColliders() {
        if (!this._enabledDebugDraw) return;
        this._checkDebugDrawValid();
        var debugDrawer = this._debugDrawer;
        debugDrawer.clear();
        var colliders = this._colliders;
        for (var i = 0, l = colliders.length; i < l; i++) {
          var collider = colliders[i];
          debugDrawer.strokeColor = cc.Color.WHITE;
          if (collider instanceof cc.BoxCollider || collider instanceof cc.PolygonCollider) {
            var ps = collider.world.points;
            if (ps.length > 0) {
              debugDrawer.moveTo(ps[0].x, ps[0].y);
              for (var j = 1; j < ps.length; j++) debugDrawer.lineTo(ps[j].x, ps[j].y);
              debugDrawer.close();
              debugDrawer.stroke();
            }
          } else if (collider instanceof cc.CircleCollider) {
            debugDrawer.circle(collider.world.position.x, collider.world.position.y, collider.world.radius);
            debugDrawer.stroke();
          }
          if (this.enabledDrawBoundingBox) {
            var aabb = collider.world.aabb;
            debugDrawer.strokeColor = cc.Color.BLUE;
            debugDrawer.moveTo(aabb.xMin, aabb.yMin);
            debugDrawer.lineTo(aabb.xMin, aabb.yMax);
            debugDrawer.lineTo(aabb.xMax, aabb.yMax);
            debugDrawer.lineTo(aabb.xMax, aabb.yMin);
            debugDrawer.close();
            debugDrawer.stroke();
          }
        }
      },
      _checkDebugDrawValid: function _checkDebugDrawValid() {
        if (!this._debugDrawer || !this._debugDrawer.isValid) {
          var node = new cc.Node("COLLISION_MANAGER_DEBUG_DRAW");
          node.zIndex = cc.macro.MAX_ZINDEX;
          cc.game.addPersistRootNode(node);
          this._debugDrawer = node.addComponent(cc.Graphics);
        }
      }
    });
    cc.js.getset(CollisionManager.prototype, "enabledDebugDraw", (function() {
      return this._enabledDebugDraw;
    }), (function(value) {
      if (value && !this._enabledDebugDraw) {
        this._checkDebugDrawValid();
        this._debugDrawer.node.active = true;
      } else if (!value && this._enabledDebugDraw) {
        this._debugDrawer.clear(true);
        this._debugDrawer.node.active = false;
      }
      this._enabledDebugDraw = value;
    }));
    cc.CollisionManager = module.exports = CollisionManager;
  }), {
    "../CCNode": 53,
    "./CCContact": 86
  } ],
  86: [ (function(require, module, exports) {
    "use strict";
    var Intersection = require("./CCIntersection");
    var CollisionType = cc.Enum({
      None: 0,
      CollisionEnter: 1,
      CollisionStay: 2,
      CollisionExit: 3
    });
    function Contact(collider1, collider2) {
      this.collider1 = collider1;
      this.collider2 = collider2;
      this.touching = false;
      var isCollider1Polygon = collider1 instanceof cc.BoxCollider || collider1 instanceof cc.PolygonCollider;
      var isCollider2Polygon = collider2 instanceof cc.BoxCollider || collider2 instanceof cc.PolygonCollider;
      var isCollider1Circle = collider1 instanceof cc.CircleCollider;
      var isCollider2Circle = collider2 instanceof cc.CircleCollider;
      if (isCollider1Polygon && isCollider2Polygon) this.testFunc = Intersection.polygonPolygon; else if (isCollider1Circle && isCollider2Circle) this.testFunc = Intersection.circleCircle; else if (isCollider1Polygon && isCollider2Circle) this.testFunc = Intersection.polygonCircle; else if (isCollider1Circle && isCollider2Polygon) {
        this.testFunc = Intersection.polygonCircle;
        this.collider1 = collider2;
        this.collider2 = collider1;
      } else cc.errorID(6601, cc.js.getClassName(collider1), cc.js.getClassName(collider2));
    }
    Contact.prototype.test = function() {
      var world1 = this.collider1.world;
      var world2 = this.collider2.world;
      if (!world1.aabb.intersects(world2.aabb)) return false;
      if (this.testFunc === Intersection.polygonPolygon) return this.testFunc(world1.points, world2.points);
      if (this.testFunc === Intersection.circleCircle) return this.testFunc(world1, world2);
      if (this.testFunc === Intersection.polygonCircle) return this.testFunc(world1.points, world2);
      return false;
    };
    Contact.prototype.updateState = function() {
      var result = this.test();
      var type = CollisionType.None;
      if (result && !this.touching) {
        this.touching = true;
        type = CollisionType.CollisionEnter;
      } else if (result && this.touching) type = CollisionType.CollisionStay; else if (!result && this.touching) {
        this.touching = false;
        type = CollisionType.CollisionExit;
      }
      return type;
    };
    Contact.CollisionType = CollisionType;
    module.exports = Contact;
  }), {
    "./CCIntersection": 87
  } ],
  87: [ (function(require, module, exports) {
    "use strict";
    var Intersection = {};
    function lineLine(a1, a2, b1, b2) {
      var ua_t = (b2.x - b1.x) * (a1.y - b1.y) - (b2.y - b1.y) * (a1.x - b1.x);
      var ub_t = (a2.x - a1.x) * (a1.y - b1.y) - (a2.y - a1.y) * (a1.x - b1.x);
      var u_b = (b2.y - b1.y) * (a2.x - a1.x) - (b2.x - b1.x) * (a2.y - a1.y);
      if (0 !== u_b) {
        var ua = ua_t / u_b;
        var ub = ub_t / u_b;
        if (0 <= ua && ua <= 1 && 0 <= ub && ub <= 1) return true;
      }
      return false;
    }
    Intersection.lineLine = lineLine;
    function lineRect(a1, a2, b) {
      var r0 = new cc.Vec2(b.x, b.y);
      var r1 = new cc.Vec2(b.x, b.yMax);
      var r2 = new cc.Vec2(b.xMax, b.yMax);
      var r3 = new cc.Vec2(b.xMax, b.y);
      if (lineLine(a1, a2, r0, r1)) return true;
      if (lineLine(a1, a2, r1, r2)) return true;
      if (lineLine(a1, a2, r2, r3)) return true;
      if (lineLine(a1, a2, r3, r0)) return true;
      return false;
    }
    Intersection.lineRect = lineRect;
    function linePolygon(a1, a2, b) {
      var length = b.length;
      for (var i = 0; i < length; ++i) {
        var b1 = b[i];
        var b2 = b[(i + 1) % length];
        if (lineLine(a1, a2, b1, b2)) return true;
      }
      return false;
    }
    Intersection.linePolygon = linePolygon;
    function rectRect(a, b) {
      var a_min_x = a.x;
      var a_min_y = a.y;
      var a_max_x = a.x + a.width;
      var a_max_y = a.y + a.height;
      var b_min_x = b.x;
      var b_min_y = b.y;
      var b_max_x = b.x + b.width;
      var b_max_y = b.y + b.height;
      return a_min_x <= b_max_x && a_max_x >= b_min_x && a_min_y <= b_max_y && a_max_y >= b_min_y;
    }
    Intersection.rectRect = rectRect;
    function rectPolygon(a, b) {
      var i, l;
      var r0 = new cc.Vec2(a.x, a.y);
      var r1 = new cc.Vec2(a.x, a.yMax);
      var r2 = new cc.Vec2(a.xMax, a.yMax);
      var r3 = new cc.Vec2(a.xMax, a.y);
      if (linePolygon(r0, r1, b)) return true;
      if (linePolygon(r1, r2, b)) return true;
      if (linePolygon(r2, r3, b)) return true;
      if (linePolygon(r3, r0, b)) return true;
      for (i = 0, l = b.length; i < l; ++i) if (pointInPolygon(b[i], a)) return true;
      if (pointInPolygon(r0, b)) return true;
      if (pointInPolygon(r1, b)) return true;
      if (pointInPolygon(r2, b)) return true;
      if (pointInPolygon(r3, b)) return true;
      return false;
    }
    Intersection.rectPolygon = rectPolygon;
    function polygonPolygon(a, b) {
      var i, l;
      for (i = 0, l = a.length; i < l; ++i) {
        var a1 = a[i];
        var a2 = a[(i + 1) % l];
        if (linePolygon(a1, a2, b)) return true;
      }
      for (i = 0, l = b.length; i < l; ++i) if (pointInPolygon(b[i], a)) return true;
      for (i = 0, l = a.length; i < l; ++i) if (pointInPolygon(a[i], b)) return true;
      return false;
    }
    Intersection.polygonPolygon = polygonPolygon;
    function circleCircle(a, b) {
      var distance = a.position.sub(b.position).mag();
      return distance < a.radius + b.radius;
    }
    Intersection.circleCircle = circleCircle;
    function polygonCircle(polygon, circle) {
      var position = circle.position;
      if (pointInPolygon(position, polygon)) return true;
      for (var i = 0, l = polygon.length; i < l; i++) {
        var start = 0 === i ? polygon[polygon.length - 1] : polygon[i - 1];
        var end = polygon[i];
        if (pointLineDistance(position, start, end, true) < circle.radius) return true;
      }
      return false;
    }
    Intersection.polygonCircle = polygonCircle;
    function pointInPolygon(point, polygon) {
      var inside = false;
      var x = point.x;
      var y = point.y;
      var length = polygon.length;
      for (var i = 0, j = length - 1; i < length; j = i++) {
        var xi = polygon[i].x, yi = polygon[i].y, xj = polygon[j].x, yj = polygon[j].y, intersect = yi > y !== yj > y && x < (xj - xi) * (y - yi) / (yj - yi) + xi;
        intersect && (inside = !inside);
      }
      return inside;
    }
    Intersection.pointInPolygon = pointInPolygon;
    function pointLineDistance(point, start, end, isSegment) {
      var dx = end.x - start.x;
      var dy = end.y - start.y;
      var d = dx * dx + dy * dy;
      var t = ((point.x - start.x) * dx + (point.y - start.y) * dy) / d;
      var p;
      p = isSegment ? d ? t < 0 ? start : t > 1 ? end : cc.v2(start.x + t * dx, start.y + t * dy) : start : cc.v2(start.x + t * dx, start.y + t * dy);
      dx = point.x - p.x;
      dy = point.y - p.y;
      return Math.sqrt(dx * dx + dy * dy);
    }
    Intersection.pointLineDistance = pointLineDistance;
    cc.Intersection = module.exports = Intersection;
  }), {} ],
  88: [ (function(require, module, exports) {
    "use strict";
    cc.Collider.Polygon = cc.Class({
      properties: {
        threshold: {
          default: 1,
          serializable: false,
          visible: false
        },
        _offset: cc.v2(0, 0),
        offset: {
          get: function get() {
            return this._offset;
          },
          set: function set(value) {
            this._offset = value;
          },
          type: cc.Vec2
        },
        points: {
          tooltip: false,
          default: function _default() {
            return [ cc.v2(-50, -50), cc.v2(50, -50), cc.v2(50, 50), cc.v2(-50, 50) ];
          },
          type: [ cc.Vec2 ]
        }
      },
      resetPointsByContour: false
    });
    var PolygonCollider = cc.Class({
      name: "cc.PolygonCollider",
      extends: cc.Collider,
      mixins: [ cc.Collider.Polygon ],
      editor: false
    });
    cc.PolygonCollider = module.exports = PolygonCollider;
  }), {} ],
  89: [ (function(require, module, exports) {
    "use strict";
    require("./CCCollisionManager");
    require("./CCCollider");
    require("./CCBoxCollider");
    require("./CCCircleCollider");
    require("./CCPolygonCollider");
  }), {
    "./CCBoxCollider": 82,
    "./CCCircleCollider": 83,
    "./CCCollider": 84,
    "./CCCollisionManager": 85,
    "./CCPolygonCollider": 88
  } ],
  90: [ (function(require, module, exports) {
    "use strict";
    require("./platform/CCClass");
    var Flags = require("./platform/CCObject").Flags;
    var jsArray = require("./platform/js").array;
    var IsStartCalled = Flags.IsStartCalled;
    var IsOnEnableCalled = Flags.IsOnEnableCalled;
    var IsEditorOnEnableCalled = Flags.IsEditorOnEnableCalled;
    var callerFunctor = false;
    var callOnEnableInTryCatch = false;
    var callOnDisableInTryCatch = false;
    function sortedIndex(array, comp) {
      var order = comp.constructor._executionOrder;
      var id = comp._id;
      for (var l = 0, h = array.length - 1, m = h >>> 1; l <= h; m = l + h >>> 1) {
        var test = array[m];
        var testOrder = test.constructor._executionOrder;
        if (testOrder > order) h = m - 1; else if (testOrder < order) l = m + 1; else {
          var testId = test._id;
          if (testId > id) h = m - 1; else {
            if (!(testId < id)) return m;
            l = m + 1;
          }
        }
      }
      return ~l;
    }
    function stableRemoveInactive(iterator, flagToClear) {
      var array = iterator.array;
      var next = iterator.i + 1;
      while (next < array.length) {
        var comp = array[next];
        if (comp._enabled && comp.node._activeInHierarchy) ++next; else {
          iterator.removeAt(next);
          flagToClear && (comp._objFlags &= ~flagToClear);
        }
      }
    }
    var LifeCycleInvoker = cc.Class({
      __ctor__: function __ctor__(invokeFunc) {
        var Iterator = jsArray.MutableForwardIterator;
        this._zero = new Iterator([]);
        this._neg = new Iterator([]);
        this._pos = new Iterator([]);
        false;
        this._invoke = invokeFunc;
      },
      statics: {
        stableRemoveInactive: stableRemoveInactive
      },
      add: null,
      remove: null,
      invoke: null
    });
    function compareOrder(a, b) {
      return a.constructor._executionOrder - b.constructor._executionOrder;
    }
    var OneOffInvoker = cc.Class({
      extends: LifeCycleInvoker,
      add: function add(comp) {
        var order = comp.constructor._executionOrder;
        (0 === order ? this._zero : order < 0 ? this._neg : this._pos).array.push(comp);
      },
      remove: function remove(comp) {
        var order = comp.constructor._executionOrder;
        (0 === order ? this._zero : order < 0 ? this._neg : this._pos).fastRemove(comp);
      },
      cancelInactive: function cancelInactive(flagToClear) {
        stableRemoveInactive(this._zero, flagToClear);
        stableRemoveInactive(this._neg, flagToClear);
        stableRemoveInactive(this._pos, flagToClear);
      },
      invoke: function invoke() {
        var compsNeg = this._neg;
        if (compsNeg.array.length > 0) {
          compsNeg.array.sort(compareOrder);
          this._invoke(compsNeg);
          compsNeg.array.length = 0;
        }
        this._invoke(this._zero);
        this._zero.array.length = 0;
        var compsPos = this._pos;
        if (compsPos.array.length > 0) {
          compsPos.array.sort(compareOrder);
          this._invoke(compsPos);
          compsPos.array.length = 0;
        }
      }
    });
    var ReusableInvoker = cc.Class({
      extends: LifeCycleInvoker,
      add: function add(comp) {
        var order = comp.constructor._executionOrder;
        if (0 === order) this._zero.array.push(comp); else {
          var array = order < 0 ? this._neg.array : this._pos.array;
          var i = sortedIndex(array, comp);
          i < 0 && array.splice(~i, 0, comp);
        }
      },
      remove: function remove(comp) {
        var order = comp.constructor._executionOrder;
        if (0 === order) this._zero.fastRemove(comp); else {
          var iterator = order < 0 ? this._neg : this._pos;
          var i = sortedIndex(iterator.array, comp);
          i >= 0 && iterator.removeAt(i);
        }
      },
      invoke: function invoke(dt) {
        this._neg.array.length > 0 && this._invoke(this._neg, dt);
        this._invoke(this._zero, dt);
        this._pos.array.length > 0 && this._invoke(this._pos, dt);
      }
    });
    function enableInEditor(comp) {
      if (!(comp._objFlags & IsEditorOnEnableCalled)) {
        cc.engine.emit("component-enabled", comp.uuid);
        comp._objFlags |= IsEditorOnEnableCalled;
      }
    }
    function createInvokeImpl(indiePath, useDt, ensureFlag, fastPath) {
      true;
      var body = "var a=it.array;for(it.i=0;it.i<a.length;++it.i){var c=a[it.i];" + indiePath + "}";
      fastPath = useDt ? Function("it", "dt", body) : Function("it", body);
      indiePath = Function("c", "dt", indiePath);
      return function(iterator, dt) {
        try {
          fastPath(iterator, dt);
        } catch (e) {
          cc._throw(e);
          var array = iterator.array;
          ensureFlag && (array[iterator.i]._objFlags |= ensureFlag);
          ++iterator.i;
          for (;iterator.i < array.length; ++iterator.i) try {
            indiePath(array[iterator.i], dt);
          } catch (e) {
            cc._throw(e);
            ensureFlag && (array[iterator.i]._objFlags |= ensureFlag);
          }
        }
      };
    }
    var invokeStart = createInvokeImpl("c.start();c._objFlags|=" + IsStartCalled, false, IsStartCalled);
    var invokeUpdate = createInvokeImpl("c.update(dt)", true);
    var invokeLateUpdate = createInvokeImpl("c.lateUpdate(dt)", true);
    function ctor() {
      this.startInvoker = new OneOffInvoker(invokeStart);
      this.updateInvoker = new ReusableInvoker(invokeUpdate);
      this.lateUpdateInvoker = new ReusableInvoker(invokeLateUpdate);
      this.scheduleInNextFrame = [];
      this._updating = false;
    }
    var ComponentScheduler = cc.Class({
      ctor: ctor,
      unscheduleAll: ctor,
      statics: {
        LifeCycleInvoker: LifeCycleInvoker,
        OneOffInvoker: OneOffInvoker,
        createInvokeImpl: createInvokeImpl,
        invokeOnEnable: function(iterator) {
          var compScheduler = cc.director._compScheduler;
          var array = iterator.array;
          for (iterator.i = 0; iterator.i < array.length; ++iterator.i) {
            var comp = array[iterator.i];
            if (comp._enabled) {
              comp.onEnable();
              var deactivatedDuringOnEnable = !comp.node._activeInHierarchy;
              deactivatedDuringOnEnable || compScheduler._onEnabled(comp);
            }
          }
        }
      },
      _onEnabled: function _onEnabled(comp) {
        cc.director.getScheduler().resumeTarget(comp);
        comp._objFlags |= IsOnEnableCalled;
        this._updating ? this.scheduleInNextFrame.push(comp) : this._scheduleImmediate(comp);
      },
      _onDisabled: function _onDisabled(comp) {
        cc.director.getScheduler().pauseTarget(comp);
        comp._objFlags &= ~IsOnEnableCalled;
        var index = this.scheduleInNextFrame.indexOf(comp);
        if (index >= 0) {
          jsArray.fastRemoveAt(this.scheduleInNextFrame, index);
          return;
        }
        !comp.start || comp._objFlags & IsStartCalled || this.startInvoker.remove(comp);
        comp.update && this.updateInvoker.remove(comp);
        comp.lateUpdate && this.lateUpdateInvoker.remove(comp);
      },
      enableComp: function(comp, invoker) {
        if (!(comp._objFlags & IsOnEnableCalled)) {
          if (comp.onEnable) {
            if (invoker) {
              invoker.add(comp);
              return;
            }
            comp.onEnable();
            var deactivatedDuringOnEnable = !comp.node._activeInHierarchy;
            if (deactivatedDuringOnEnable) return;
          }
          this._onEnabled(comp);
        }
      },
      disableComp: function(comp) {
        if (comp._objFlags & IsOnEnableCalled) {
          comp.onDisable && comp.onDisable();
          this._onDisabled(comp);
        }
      },
      _scheduleImmediate: function _scheduleImmediate(comp) {
        !comp.start || comp._objFlags & IsStartCalled || this.startInvoker.add(comp);
        comp.update && this.updateInvoker.add(comp);
        comp.lateUpdate && this.lateUpdateInvoker.add(comp);
      },
      _deferredSchedule: function _deferredSchedule() {
        var comps = this.scheduleInNextFrame;
        for (var i = 0, len = comps.length; i < len; i++) {
          var comp = comps[i];
          this._scheduleImmediate(comp);
        }
        comps.length = 0;
      },
      startPhase: function startPhase() {
        this._updating = true;
        this.scheduleInNextFrame.length > 0 && this._deferredSchedule();
        this.startInvoker.invoke();
      },
      updatePhase: function updatePhase(dt) {
        this.updateInvoker.invoke(dt);
      },
      lateUpdatePhase: function lateUpdatePhase(dt) {
        this.lateUpdateInvoker.invoke(dt);
        this._updating = false;
      }
    });
    module.exports = ComponentScheduler;
  }), {
    "./platform/CCClass": 199,
    "./platform/CCObject": 205,
    "./platform/js": 219,
    "./utils/misc": 299
  } ],
  91: [ (function(require, module, exports) {
    "use strict";
    var AnimationAnimator = require("../../animation/animation-animator");
    var AnimationClip = require("../../animation/animation-clip");
    var EventTarget = require("../event/event-target");
    var js = require("../platform/js");
    function equalClips(clip1, clip2) {
      if (clip1 === clip2) return true;
      return clip1 && clip2 && (clip1.name === clip2.name || clip1._uuid === clip2._uuid);
    }
    var EventType = cc.Enum({
      PLAY: "play",
      STOP: "stop",
      PAUSE: "pause",
      RESUME: "resume",
      LASTFRAME: "lastframe",
      FINISHED: "finished"
    });
    var Animation = cc.Class({
      name: "cc.Animation",
      extends: require("./CCComponent"),
      mixins: [ EventTarget ],
      editor: false,
      statics: {
        EventType: EventType
      },
      ctor: function ctor() {
        cc.EventTarget.call(this);
        this._animator = null;
        this._nameToState = js.createMap(true);
        this._didInit = false;
        this._currentClip = null;
      },
      properties: {
        _defaultClip: {
          default: null,
          type: AnimationClip
        },
        defaultClip: {
          type: AnimationClip,
          get: function get() {
            return this._defaultClip;
          },
          set: function set(value) {
            true;
            return;
            var clips;
            var i, l;
          },
          tooltip: false
        },
        currentClip: {
          get: function get() {
            return this._currentClip;
          },
          set: function set(value) {
            this._currentClip = value;
          },
          type: AnimationClip,
          visible: false
        },
        _writableClips: {
          get: function get() {
            return this._clips;
          },
          set: function set(val) {
            this._didInit = false;
            this._clips = val;
            this._init();
          },
          type: [ AnimationClip ]
        },
        _clips: {
          default: [],
          type: [ AnimationClip ],
          tooltip: false,
          visible: true
        },
        playOnLoad: {
          default: false,
          tooltip: false
        }
      },
      start: function start() {
        if ((true, this.playOnLoad) && this._defaultClip) {
          var isPlaying = this._animator && this._animator.isPlaying;
          if (!isPlaying) {
            var state = this.getAnimationState(this._defaultClip.name);
            this._animator.playState(state);
          }
        }
      },
      onEnable: function onEnable() {
        this._animator && this._animator.resume();
      },
      onDisable: function onDisable() {
        this._animator && this._animator.pause();
      },
      onDestroy: function onDestroy() {
        this.stop();
      },
      getClips: function getClips() {
        return this._clips;
      },
      play: function play(name, startTime) {
        var state = this.playAdditive(name, startTime);
        this._animator.stopStatesExcept(state);
        return state;
      },
      playAdditive: function playAdditive(name, startTime) {
        this._init();
        var state = this.getAnimationState(name || this._defaultClip && this._defaultClip.name);
        if (state) {
          this.enabled = true;
          var animator = this._animator;
          if (animator.isPlaying && state.isPlaying) if (state.isPaused) animator.resumeState(state); else {
            animator.stopState(state);
            animator.playState(state, startTime);
          } else animator.playState(state, startTime);
          this.enabledInHierarchy || animator.pause();
          this.currentClip = state.clip;
        }
        return state;
      },
      stop: function stop(name) {
        if (!this._didInit) return;
        if (name) {
          var state = this._nameToState[name];
          state && this._animator.stopState(state);
        } else this._animator.stop();
      },
      pause: function pause(name) {
        if (!this._didInit) return;
        if (name) {
          var state = this._nameToState[name];
          state && this._animator.pauseState(state);
        } else this.enabled = false;
      },
      resume: function resume(name) {
        if (!this._didInit) return;
        if (name) {
          var state = this._nameToState[name];
          state && this._animator.resumeState(state);
        } else this.enabled = true;
      },
      setCurrentTime: function setCurrentTime(time, name) {
        this._init();
        if (name) {
          var state = this._nameToState[name];
          state && this._animator.setStateTime(state, time);
        } else this._animator.setStateTime(time);
      },
      getAnimationState: function getAnimationState(name) {
        this._init();
        var state = this._nameToState[name];
        false;
        state && !state.curveLoaded && this._animator._reloadClip(state);
        return state || null;
      },
      addClip: function addClip(clip, newName) {
        if (!clip) {
          cc.warnID(3900);
          return;
        }
        this._init();
        cc.js.array.contains(this._clips, clip) || this._clips.push(clip);
        newName = newName || clip.name;
        var oldState = this._nameToState[newName];
        if (oldState) {
          if (oldState.clip === clip) return oldState;
          var index = this._clips.indexOf(oldState.clip);
          -1 !== index && this._clips.splice(index, 1);
        }
        var newState = new cc.AnimationState(clip, newName);
        this._nameToState[newName] = newState;
        return newState;
      },
      removeClip: function removeClip(clip, force) {
        if (!clip) {
          cc.warnID(3901);
          return;
        }
        this._init();
        var state = void 0;
        for (var name in this._nameToState) {
          state = this._nameToState[name];
          var stateClip = state.clip;
          if (stateClip === clip) break;
        }
        if (clip === this._defaultClip) {
          if (!force) {
            true;
            cc.warnID(3902);
            return;
          }
          this._defaultClip = null;
        }
        if (state && state.isPlaying) {
          if (!force) {
            true;
            cc.warnID(3903);
            return;
          }
          this.stop(state.name);
        }
        this._clips = this._clips.filter((function(item) {
          return item !== clip;
        }));
        state && delete this._nameToState[state.name];
      },
      sample: function sample(name) {
        this._init();
        if (name) {
          var state = this._nameToState[name];
          state && state.sample();
        } else this._animator.sample();
      },
      on: function on(type, callback, target, useCapture) {
        this._init();
        var ret = this._EventTargetOn(type, callback, target, useCapture);
        if ("lastframe" === type) {
          var states = this._nameToState;
          for (var name in states) states[name]._lastframeEventOn = true;
        }
        return ret;
      },
      off: function off(type, callback, target, useCapture) {
        this._init();
        if ("lastframe" === type) {
          var states = this._nameToState;
          for (var name in states) states[name]._lastframeEventOn = false;
        }
        this._EventTargetOff(type, callback, target, useCapture);
      },
      _init: function _init() {
        if (this._didInit) return;
        this._didInit = true;
        this._animator = new AnimationAnimator(this.node, this);
        this._createStates();
      },
      _createStates: function _createStates() {
        this._nameToState = js.createMap(true);
        var state = null;
        var defaultClipState = false;
        for (var i = 0; i < this._clips.length; ++i) {
          var clip = this._clips[i];
          if (clip) {
            state = new cc.AnimationState(clip);
            false;
            this._nameToState[state.name] = state;
            equalClips(this._defaultClip, clip) && (defaultClipState = state);
          }
        }
        if (this._defaultClip && !defaultClipState) {
          state = new cc.AnimationState(this._defaultClip);
          false;
          this._nameToState[state.name] = state;
        }
      }
    });
    Animation.prototype._EventTargetOn = EventTarget.prototype.on;
    Animation.prototype._EventTargetOff = EventTarget.prototype.off;
    cc.Animation = module.exports = Animation;
  }), {
    "../../animation/animation-animator": 10,
    "../../animation/animation-clip": 11,
    "../event/event-target": 132,
    "../platform/js": 219,
    "./CCComponent": 96
  } ],
  92: [ (function(require, module, exports) {
    "use strict";
    var misc = require("../utils/misc");
    var Component = require("./CCComponent");
    var AudioClip = require("../assets/CCAudioClip");
    var AudioSource = cc.Class({
      name: "cc.AudioSource",
      extends: Component,
      editor: false,
      ctor: function ctor() {
        this.audio = new cc.Audio();
      },
      properties: {
        _clip: {
          default: null,
          type: AudioClip
        },
        _volume: 1,
        _mute: false,
        _loop: false,
        _pausedFlag: {
          default: false,
          serializable: false
        },
        isPlaying: {
          get: function get() {
            var state = this.audio.getState();
            return state === cc.Audio.State.PLAYING;
          },
          visible: false
        },
        clip: {
          get: function get() {
            return this._clip;
          },
          set: function set(value) {
            if ("string" === typeof value) {
              cc.warnID(8401, "cc.AudioSource", "cc.AudioClip", "AudioClip", "cc.AudioClip", "audio");
              var self = this;
              AudioClip._loadByUrl(value, (function(err, clip) {
                clip && (self.clip = clip);
              }));
              return;
            }
            if (value === this._clip) return;
            this._clip = value;
            this.audio.stop();
            this.preload && (this.audio.src = this._clip);
          },
          type: AudioClip,
          tooltip: false,
          animatable: false
        },
        volume: {
          get: function get() {
            return this._volume;
          },
          set: function set(value) {
            value = misc.clamp01(value);
            this._volume = value;
            this._mute || this.audio.setVolume(value);
            return value;
          },
          tooltip: false
        },
        mute: {
          get: function get() {
            return this._mute;
          },
          set: function set(value) {
            this._mute = value;
            this.audio.setVolume(value ? 0 : this._volume);
            return value;
          },
          animatable: false,
          tooltip: false
        },
        loop: {
          get: function get() {
            return this._loop;
          },
          set: function set(value) {
            this._loop = value;
            this.audio.setLoop(value);
            return value;
          },
          animatable: false,
          tooltip: false
        },
        playOnLoad: {
          default: false,
          tooltip: false,
          animatable: false
        },
        preload: {
          default: false,
          animatable: false
        }
      },
      _ensureDataLoaded: function _ensureDataLoaded() {
        this.audio.src !== this._clip && (this.audio.src = this._clip);
      },
      _pausedCallback: function _pausedCallback() {
        var state = this.audio.getState();
        if (state === cc.Audio.State.PLAYING) {
          this.audio.pause();
          this._pausedFlag = true;
        }
      },
      _restoreCallback: function _restoreCallback() {
        this._pausedFlag && this.audio.resume();
        this._pausedFlag = false;
      },
      onLoad: function onLoad() {
        this.audio.setVolume(this._mute ? 0 : this._volume);
        this.audio.setLoop(this._loop);
      },
      onEnable: function onEnable() {
        this.preload && (this.audio.src = this._clip);
        this.playOnLoad && this.play();
        cc.game.on(cc.game.EVENT_HIDE, this._pausedCallback, this);
        cc.game.on(cc.game.EVENT_SHOW, this._restoreCallback, this);
      },
      onDisable: function onDisable() {
        this.stop();
        cc.game.off(cc.game.EVENT_HIDE, this._pausedCallback, this);
        cc.game.off(cc.game.EVENT_SHOW, this._restoreCallback, this);
      },
      onDestroy: function onDestroy() {
        this.stop();
        this.audio.destroy();
        cc.audioEngine.uncache(this._clip);
      },
      play: function play() {
        if (!this._clip) return;
        var audio = this.audio;
        this._clip.loaded && audio.stop();
        this._ensureDataLoaded();
        audio.setCurrentTime(0);
        audio.play();
      },
      stop: function stop() {
        this.audio.stop();
      },
      pause: function pause() {
        this.audio.pause();
      },
      resume: function resume() {
        this._ensureDataLoaded();
        this.audio.resume();
      },
      rewind: function rewind() {
        this.audio.setCurrentTime(0);
      },
      getCurrentTime: function getCurrentTime() {
        return this.audio.getCurrentTime();
      },
      setCurrentTime: function setCurrentTime(time) {
        this.audio.setCurrentTime(time);
        return time;
      },
      getDuration: function getDuration() {
        return this.audio.getDuration();
      }
    });
    cc.AudioSource = module.exports = AudioSource;
  }), {
    "../assets/CCAudioClip": 58,
    "../utils/misc": 299,
    "./CCComponent": 96
  } ],
  93: [ (function(require, module, exports) {
    "use strict";
    var BlockEvents = [ "touchstart", "touchmove", "touchend", "mousedown", "mousemove", "mouseup", "mouseenter", "mouseleave", "mousewheel" ];
    function stopPropagation(event) {
      event.stopPropagation();
    }
    var BlockInputEvents = cc.Class({
      name: "cc.BlockInputEvents",
      extends: require("./CCComponent"),
      editor: {
        menu: "i18n:MAIN_MENU.component.ui/Block Input Events",
        inspector: "packages://inspector/inspectors/comps/block-input-events.js",
        help: "i18n:COMPONENT.help_url.block_input_events"
      },
      onEnable: function onEnable() {
        for (var i = 0; i < BlockEvents.length; i++) this.node.on(BlockEvents[i], stopPropagation, this);
      },
      onDisable: function onDisable() {
        for (var i = 0; i < BlockEvents.length; i++) this.node.off(BlockEvents[i], stopPropagation, this);
      }
    });
    cc.BlockInputEvents = module.exports = BlockInputEvents;
  }), {
    "./CCComponent": 96
  } ],
  94: [ (function(require, module, exports) {
    "use strict";
    var Component = require("./CCComponent");
    var GraySpriteState = require("../utils/gray-sprite-state");
    var Transition = cc.Enum({
      NONE: 0,
      COLOR: 1,
      SPRITE: 2,
      SCALE: 3
    });
    var State = cc.Enum({
      NORMAL: 0,
      HOVER: 1,
      PRESSED: 2,
      DISABLED: 3
    });
    var Button = cc.Class({
      name: "cc.Button",
      extends: Component,
      mixins: [ GraySpriteState ],
      ctor: function ctor() {
        this._pressed = false;
        this._hovered = false;
        this._fromColor = null;
        this._toColor = null;
        this._time = 0;
        this._transitionFinished = true;
        this._fromScale = cc.Vec2.ZERO;
        this._toScale = cc.Vec2.ZERO;
        this._originalScale = null;
        this._graySpriteMaterial = null;
        this._spriteMaterial = null;
        this._sprite = null;
      },
      editor: false,
      properties: {
        interactable: {
          default: true,
          tooltip: false,
          notify: function notify() {
            this._updateState();
            this.interactable || this._resetState();
          },
          animatable: false
        },
        _resizeToTarget: {
          animatable: false,
          set: function set(value) {
            value && this._resizeNodeToTargetNode();
          }
        },
        enableAutoGrayEffect: {
          default: false,
          tooltip: false,
          notify: function notify() {
            this._updateDisabledState();
          }
        },
        transition: {
          default: Transition.NONE,
          tooltip: false,
          type: Transition,
          animatable: false,
          notify: function notify(oldValue) {
            this._updateTransition(oldValue);
          },
          formerlySerializedAs: "transition"
        },
        normalColor: {
          default: cc.Color.WHITE,
          displayName: "Normal",
          tooltip: false,
          notify: function notify() {
            this.transition === Transition.Color && this._getButtonState() === State.NORMAL && (this._getTarget().opacity = this.normalColor.a);
            this._updateState();
          }
        },
        pressedColor: {
          default: cc.color(211, 211, 211),
          displayName: "Pressed",
          tooltip: false,
          notify: function notify() {
            this.transition === Transition.Color && this._getButtonState() === State.PRESSED && (this._getTarget().opacity = this.pressedColor.a);
            this._updateState();
          },
          formerlySerializedAs: "pressedColor"
        },
        hoverColor: {
          default: cc.Color.WHITE,
          displayName: "Hover",
          tooltip: false,
          notify: function notify() {
            this.transition === Transition.Color && this._getButtonState() === State.HOVER && (this._getTarget().opacity = this.hoverColor.a);
            this._updateState();
          },
          formerlySerializedAs: "hoverColor"
        },
        disabledColor: {
          default: cc.color(124, 124, 124),
          displayName: "Disabled",
          tooltip: false,
          notify: function notify() {
            this.transition === Transition.Color && this._getButtonState() === State.DISABLED && (this._getTarget().opacity = this.disabledColor.a);
            this._updateState();
          }
        },
        duration: {
          default: .1,
          range: [ 0, 10 ],
          tooltip: false
        },
        zoomScale: {
          default: 1.2,
          tooltip: false
        },
        normalSprite: {
          default: null,
          type: cc.SpriteFrame,
          displayName: "Normal",
          tooltip: false,
          notify: function notify() {
            this._updateState();
          }
        },
        pressedSprite: {
          default: null,
          type: cc.SpriteFrame,
          displayName: "Pressed",
          tooltip: false,
          formerlySerializedAs: "pressedSprite",
          notify: function notify() {
            this._updateState();
          }
        },
        hoverSprite: {
          default: null,
          type: cc.SpriteFrame,
          displayName: "Hover",
          tooltip: false,
          formerlySerializedAs: "hoverSprite",
          notify: function notify() {
            this._updateState();
          }
        },
        disabledSprite: {
          default: null,
          type: cc.SpriteFrame,
          displayName: "Disabled",
          tooltip: false,
          notify: function notify() {
            this._updateState();
          }
        },
        target: {
          default: null,
          type: cc.Node,
          tooltip: false,
          notify: function notify(oldValue) {
            this._applyTarget();
            oldValue && this.target !== oldValue && this._unregisterTargetEvent(oldValue);
          }
        },
        clickEvents: {
          default: [],
          type: cc.Component.EventHandler,
          tooltip: false
        }
      },
      statics: {
        Transition: Transition
      },
      __preload: function __preload() {
        this._applyTarget();
        this._resetState();
      },
      _resetState: function _resetState() {
        this._pressed = false;
        this._hovered = false;
        var target = this._getTarget();
        var transition = this.transition;
        var originalScale = this._originalScale;
        transition === Transition.COLOR && this.interactable ? this._setTargetColor(this.normalColor) : transition === Transition.SCALE && originalScale && target.setScale(originalScale.x, originalScale.y);
        this._transitionFinished = true;
      },
      onEnable: function onEnable() {
        this.normalSprite && this.normalSprite.ensureLoadTexture();
        this.hoverSprite && this.hoverSprite.ensureLoadTexture();
        this.pressedSprite && this.pressedSprite.ensureLoadTexture();
        this.disabledSprite && this.disabledSprite.ensureLoadTexture();
        true;
        this._registerNodeEvent();
      },
      onDisable: function onDisable() {
        this._resetState();
        true;
        this._unregisterNodeEvent();
      },
      _getTarget: function _getTarget() {
        return this.target ? this.target : this.node;
      },
      _onTargetSpriteFrameChanged: function _onTargetSpriteFrameChanged(comp) {
        this.transition === Transition.SPRITE && this._setCurrentStateSprite(comp.spriteFrame);
      },
      _onTargetColorChanged: function _onTargetColorChanged(color) {
        this.transition === Transition.COLOR && this._setCurrentStateColor(color);
      },
      _onTargetScaleChanged: function _onTargetScaleChanged() {
        var target = this._getTarget();
        if (this._originalScale && (this.transition !== Transition.SCALE || this._transitionFinished)) {
          this._originalScale.x = target.scaleX;
          this._originalScale.y = target.scaleY;
        }
      },
      _setTargetColor: function _setTargetColor(color) {
        var target = this._getTarget();
        target.color = color;
        target.opacity = color.a;
      },
      _getStateColor: function _getStateColor(state) {
        switch (state) {
         case State.NORMAL:
          return this.normalColor;

         case State.HOVER:
          return this.hoverColor;

         case State.PRESSED:
          return this.pressedColor;

         case State.DISABLED:
          return this.disabledColor;
        }
      },
      _getStateSprite: function _getStateSprite(state) {
        switch (state) {
         case State.NORMAL:
          return this.normalSprite;

         case State.HOVER:
          return this.hoverSprite;

         case State.PRESSED:
          return this.pressedSprite;

         case State.DISABLED:
          return this.disabledSprite;
        }
      },
      _setCurrentStateColor: function _setCurrentStateColor(color) {
        switch (this._getButtonState()) {
         case State.NORMAL:
          this.normalColor = color;
          break;

         case State.HOVER:
          this.hoverColor = color;
          break;

         case State.PRESSED:
          this.pressedColor = color;
          break;

         case State.DISABLED:
          this.disabledColor = color;
        }
      },
      _setCurrentStateSprite: function _setCurrentStateSprite(spriteFrame) {
        switch (this._getButtonState()) {
         case State.NORMAL:
          this.normalSprite = spriteFrame;
          break;

         case State.HOVER:
          this.hoverSprite = spriteFrame;
          break;

         case State.PRESSED:
          this.pressedSprite = spriteFrame;
          break;

         case State.DISABLED:
          this.disabledSprite = spriteFrame;
        }
      },
      update: function update(dt) {
        var target = this._getTarget();
        if (this._transitionFinished) return;
        if (this.transition !== Transition.COLOR && this.transition !== Transition.SCALE) return;
        this.time += dt;
        var ratio = 1;
        this.duration > 0 && (ratio = this.time / this.duration);
        ratio >= 1 && (ratio = 1);
        if (this.transition === Transition.COLOR) {
          var color = this._fromColor.lerp(this._toColor, ratio);
          this._setTargetColor(color);
        } else this.transition === Transition.SCALE && this._originalScale && (target.scale = this._fromScale.lerp(this._toScale, ratio));
        1 === ratio && (this._transitionFinished = true);
      },
      _registerNodeEvent: function _registerNodeEvent() {
        this.node.on(cc.Node.EventType.TOUCH_START, this._onTouchBegan, this);
        this.node.on(cc.Node.EventType.TOUCH_MOVE, this._onTouchMove, this);
        this.node.on(cc.Node.EventType.TOUCH_END, this._onTouchEnded, this);
        this.node.on(cc.Node.EventType.TOUCH_CANCEL, this._onTouchCancel, this);
        this.node.on(cc.Node.EventType.MOUSE_ENTER, this._onMouseMoveIn, this);
        this.node.on(cc.Node.EventType.MOUSE_LEAVE, this._onMouseMoveOut, this);
      },
      _unregisterNodeEvent: function _unregisterNodeEvent() {
        this.node.off(cc.Node.EventType.TOUCH_START, this._onTouchBegan, this);
        this.node.off(cc.Node.EventType.TOUCH_MOVE, this._onTouchMove, this);
        this.node.off(cc.Node.EventType.TOUCH_END, this._onTouchEnded, this);
        this.node.off(cc.Node.EventType.TOUCH_CANCEL, this._onTouchCancel, this);
        this.node.off(cc.Node.EventType.MOUSE_ENTER, this._onMouseMoveIn, this);
        this.node.off(cc.Node.EventType.MOUSE_LEAVE, this._onMouseMoveOut, this);
      },
      _registerTargetEvent: function _registerTargetEvent(target) {
        false;
        target.on(cc.Node.EventType.SCALE_CHANGED, this._onTargetScaleChanged, this);
      },
      _unregisterTargetEvent: function _unregisterTargetEvent(target) {
        false;
        target.off(cc.Node.EventType.SCALE_CHANGED, this._onTargetScaleChanged, this);
      },
      _getTargetSprite: function _getTargetSprite(target) {
        var sprite = null;
        target && (sprite = target.getComponent(cc.Sprite));
        return sprite;
      },
      _applyTarget: function _applyTarget() {
        var target = this._getTarget();
        this._sprite = this._getTargetSprite(target);
        this._originalScale || (this._originalScale = cc.Vec2.ZERO);
        this._originalScale.x = target.scaleX;
        this._originalScale.y = target.scaleY;
        this._registerTargetEvent(target);
      },
      _onTouchBegan: function _onTouchBegan(event) {
        if (!this.interactable || !this.enabledInHierarchy) return;
        this._pressed = true;
        this._updateState();
        event.stopPropagation();
      },
      _onTouchMove: function _onTouchMove(event) {
        if (!this.interactable || !this.enabledInHierarchy || !this._pressed) return;
        var touch = event.touch;
        var hit = this.node._hitTest(touch.getLocation());
        var target = this._getTarget();
        var originalScale = this._originalScale;
        if (this.transition === Transition.SCALE && originalScale) if (hit) {
          this._fromScale.x = originalScale.x;
          this._fromScale.y = originalScale.y;
          this._toScale.x = originalScale.x * this.zoomScale;
          this._toScale.y = originalScale.y * this.zoomScale;
          this._transitionFinished = false;
        } else {
          this.time = 0;
          this._transitionFinished = true;
          target.setScale(originalScale.x, originalScale.y);
        } else {
          var state = void 0;
          state = hit ? State.PRESSED : State.NORMAL;
          this._applyTransition(state);
        }
        event.stopPropagation();
      },
      _onTouchEnded: function _onTouchEnded(event) {
        if (!this.interactable || !this.enabledInHierarchy) return;
        if (this._pressed) {
          cc.Component.EventHandler.emitEvents(this.clickEvents, event);
          this.node.emit("click", this);
        }
        this._pressed = false;
        this._updateState();
        event.stopPropagation();
      },
      _onTouchCancel: function _onTouchCancel() {
        if (!this.interactable || !this.enabledInHierarchy) return;
        this._pressed = false;
        this._updateState();
      },
      _onMouseMoveIn: function _onMouseMoveIn() {
        if (this._pressed || !this.interactable || !this.enabledInHierarchy) return;
        if (this.transition === Transition.SPRITE && !this.hoverSprite) return;
        if (!this._hovered) {
          this._hovered = true;
          this._updateState();
        }
      },
      _onMouseMoveOut: function _onMouseMoveOut() {
        if (this._hovered) {
          this._hovered = false;
          this._updateState();
        }
      },
      _updateState: function _updateState() {
        var state = this._getButtonState();
        this._applyTransition(state);
        this._updateDisabledState();
      },
      _getButtonState: function _getButtonState() {
        var state = void 0;
        state = this.interactable ? this._pressed ? State.PRESSED : this._hovered ? State.HOVER : State.NORMAL : State.DISABLED;
        return state;
      },
      _updateColorTransitionImmediately: function _updateColorTransitionImmediately(state) {
        var color = this._getStateColor(state);
        this._setTargetColor(color);
        this._fromColor = color.clone();
        this._toColor = color;
      },
      _updateColorTransition: function _updateColorTransition(state) {
        if (false, state === State.DISABLED) this._updateColorTransitionImmediately(state); else {
          var target = this._getTarget();
          var color = this._getStateColor(state);
          this._fromColor = target.color.clone();
          this._toColor = color;
          this.time = 0;
          this._transitionFinished = false;
        }
      },
      _updateSpriteTransition: function _updateSpriteTransition(state) {
        var sprite = this._getStateSprite(state);
        this._sprite && sprite && (this._sprite.spriteFrame = sprite);
      },
      _updateScaleTransition: function _updateScaleTransition(state) {
        state === State.PRESSED ? this._zoomUp() : this._zoomBack();
      },
      _zoomUp: function _zoomUp() {
        if (!this._originalScale) return;
        this._fromScale.x = this._originalScale.x;
        this._fromScale.y = this._originalScale.y;
        this._toScale.x = this._originalScale.x * this.zoomScale;
        this._toScale.y = this._originalScale.y * this.zoomScale;
        this.time = 0;
        this._transitionFinished = false;
      },
      _zoomBack: function _zoomBack() {
        if (!this._originalScale) return;
        var target = this._getTarget();
        this._fromScale.x = target.scaleX;
        this._fromScale.y = target.scaleY;
        this._toScale.x = this._originalScale.x;
        this._toScale.y = this._originalScale.y;
        this.time = 0;
        this._transitionFinished = false;
      },
      _updateTransition: function _updateTransition(oldTransition) {
        oldTransition === Transition.COLOR ? this._updateColorTransitionImmediately(State.NORMAL) : oldTransition === Transition.SPRITE && this._updateSpriteTransition(State.NORMAL);
        this._updateState();
      },
      _applyTransition: function _applyTransition(state) {
        var transition = this.transition;
        transition === Transition.COLOR ? this._updateColorTransition(state) : transition === Transition.SPRITE ? this._updateSpriteTransition(state) : transition === Transition.SCALE && this._updateScaleTransition(state);
      },
      _resizeNodeToTargetNode: false,
      _updateDisabledState: function _updateDisabledState() {
        if (this._sprite) {
          var useGrayMaterial = false;
          this.enableAutoGrayEffect && (this.transition === Transition.SPRITE && this.disabledSprite || this.interactable || (useGrayMaterial = true));
          this._switchGrayMaterial(useGrayMaterial, this._sprite);
        }
      }
    });
    cc.Button = module.exports = Button;
  }), {
    "../utils/gray-sprite-state": 295,
    "./CCComponent": 96
  } ],
  95: [ (function(require, module, exports) {
    "use strict";
    var Camera = require("../camera/CCCamera");
    var Component = require("./CCComponent");
    var Canvas = cc.Class({
      name: "cc.Canvas",
      extends: Component,
      editor: false,
      resetInEditor: false,
      statics: {
        instance: null
      },
      properties: {
        _designResolution: cc.size(960, 640),
        designResolution: {
          get: function get() {
            return cc.size(this._designResolution);
          },
          set: function set(value) {
            this._designResolution.width = value.width;
            this._designResolution.height = value.height;
            this.applySettings();
            this.alignWithScreen();
          },
          tooltip: false
        },
        _fitWidth: false,
        _fitHeight: true,
        fitHeight: {
          get: function get() {
            return this._fitHeight;
          },
          set: function set(value) {
            if (this._fitHeight !== value) {
              this._fitHeight = value;
              this.applySettings();
              this.alignWithScreen();
            }
          },
          tooltip: false
        },
        fitWidth: {
          get: function get() {
            return this._fitWidth;
          },
          set: function set(value) {
            if (this._fitWidth !== value) {
              this._fitWidth = value;
              this.applySettings();
              this.alignWithScreen();
            }
          },
          tooltip: false
        }
      },
      ctor: function ctor() {
        this._thisOnResized = this.alignWithScreen.bind(this);
      },
      __preload: function __preload() {
        var Flags;
        false;
        if (Canvas.instance) return cc.errorID(6700, this.node.name, Canvas.instance.node.name);
        Canvas.instance = this;
        false;
        cc.sys.isMobile ? window.addEventListener("resize", this._thisOnResized) : cc.view.on("canvas-resize", this._thisOnResized);
        this.applySettings();
        this.alignWithScreen();
        var cameraNode = cc.find("Main Camera", this.node);
        if (!cameraNode) {
          cameraNode = new cc.Node("Main Camera");
          cameraNode.parent = this.node;
          cameraNode.setSiblingIndex(0);
        }
        var camera = cameraNode.getComponent(Camera);
        if (!camera) {
          camera = cameraNode.addComponent(Camera);
          var ClearFlags = Camera.ClearFlags;
          camera.clearFlags = ClearFlags.COLOR | ClearFlags.DEPTH | ClearFlags.STENCIL;
          camera.depth = -1;
        }
        Camera.main = camera;
      },
      onDestroy: function onDestroy() {
        false;
        cc.sys.isMobile ? window.removeEventListener("resize", this._thisOnResized) : cc.view.off("canvas-resize", this._thisOnResized);
        Canvas.instance === this && (Canvas.instance = null);
      },
      alignWithScreen: function alignWithScreen() {
        var designSize, nodeSize;
        false;
        var canvasSize = nodeSize = cc.visibleRect;
        designSize = cc.view.getDesignResolutionSize();
        var clipTopRight = !this.fitHeight && !this.fitWidth;
        var offsetX = 0;
        var offsetY = 0;
        if (clipTopRight) {
          offsetX = .5 * (designSize.width - canvasSize.width);
          offsetY = .5 * (designSize.height - canvasSize.height);
        }
        this.node.setPosition(.5 * canvasSize.width + offsetX, .5 * canvasSize.height + offsetY);
        this.node.width = nodeSize.width;
        this.node.height = nodeSize.height;
      },
      applySettings: function applySettings() {
        var ResolutionPolicy = cc.ResolutionPolicy;
        var policy;
        policy = this.fitHeight && this.fitWidth ? ResolutionPolicy.SHOW_ALL : this.fitHeight || this.fitWidth ? this.fitWidth ? ResolutionPolicy.FIXED_WIDTH : ResolutionPolicy.FIXED_HEIGHT : ResolutionPolicy.NO_BORDER;
        var designRes = this._designResolution;
        false;
        cc.view.setDesignResolutionSize(designRes.width, designRes.height, policy);
      }
    });
    cc.Canvas = module.exports = Canvas;
  }), {
    "../camera/CCCamera": 81,
    "./CCComponent": 96
  } ],
  96: [ (function(require, module, exports) {
    "use strict";
    var CCObject = require("../platform/CCObject");
    var js = require("../platform/js");
    var idGenerater = new (require("../platform/id-generater"))("Comp");
    var IsOnEnableCalled = CCObject.Flags.IsOnEnableCalled;
    var IsOnLoadCalled = CCObject.Flags.IsOnLoadCalled;
    var Component = cc.Class({
      name: "cc.Component",
      extends: CCObject,
      ctor: function() {
        this._id = idGenerater.getNewId();
        this.__eventTargets = [];
      },
      properties: {
        node: {
          default: null,
          visible: false
        },
        name: {
          get: function get() {
            if (this._name) return this._name;
            var className = cc.js.getClassName(this);
            var trimLeft = className.lastIndexOf(".");
            trimLeft >= 0 && (className = className.slice(trimLeft + 1));
            return this.node.name + "<" + className + ">";
          },
          set: function set(value) {
            this._name = value;
          },
          visible: false
        },
        uuid: {
          get: function get() {
            return this._id;
          },
          visible: false
        },
        __scriptAsset: false,
        _enabled: true,
        enabled: {
          get: function get() {
            return this._enabled;
          },
          set: function set(value) {
            if (this._enabled !== value) {
              this._enabled = value;
              if (this.node._activeInHierarchy) {
                var compScheduler = cc.director._compScheduler;
                value ? compScheduler.enableComp(this) : compScheduler.disableComp(this);
              }
            }
          },
          visible: false,
          animatable: true
        },
        enabledInHierarchy: {
          get: function get() {
            return this._enabled && this.node._activeInHierarchy;
          },
          visible: false
        },
        _isOnLoadCalled: {
          get: function get() {
            return this._objFlags & IsOnLoadCalled;
          }
        }
      },
      update: null,
      lateUpdate: null,
      __preload: null,
      onLoad: null,
      start: null,
      onEnable: null,
      onDisable: null,
      onDestroy: null,
      onFocusInEditor: null,
      onLostFocusInEditor: null,
      resetInEditor: null,
      addComponent: function addComponent(typeOrClassName) {
        return this.node.addComponent(typeOrClassName);
      },
      getComponent: function getComponent(typeOrClassName) {
        return this.node.getComponent(typeOrClassName);
      },
      getComponents: function getComponents(typeOrClassName) {
        return this.node.getComponents(typeOrClassName);
      },
      getComponentInChildren: function getComponentInChildren(typeOrClassName) {
        return this.node.getComponentInChildren(typeOrClassName);
      },
      getComponentsInChildren: function getComponentsInChildren(typeOrClassName) {
        return this.node.getComponentsInChildren(typeOrClassName);
      },
      _getLocalBounds: null,
      onRestore: null,
      destroy: function destroy() {
        var depend;
        false;
        this._super() && this._enabled && this.node._activeInHierarchy && cc.director._compScheduler.disableComp(this);
      },
      _onPreDestroy: function _onPreDestroy() {
        this.unscheduleAllCallbacks();
        var eventTargets = this.__eventTargets;
        for (var i = 0, l = eventTargets.length; i < l; ++i) {
          var target = eventTargets[i];
          target && target.targetOff(this);
        }
        eventTargets.length = 0;
        false;
        cc.director._nodeActivator.destroyComp(this);
        this.node._removeComponent(this);
      },
      _instantiate: function _instantiate(cloned) {
        cloned || (cloned = cc.instantiate._clone(this, this));
        cloned.node = null;
        return cloned;
      },
      schedule: function schedule(callback, interval, repeat, delay) {
        cc.assertID(callback, 1619);
        cc.assertID(interval >= 0, 1620);
        interval = interval || 0;
        repeat = isNaN(repeat) ? cc.macro.REPEAT_FOREVER : repeat;
        delay = delay || 0;
        var scheduler = cc.director.getScheduler();
        var paused = scheduler.isTargetPaused(this);
        scheduler.schedule(callback, this, interval, repeat, delay, paused);
      },
      scheduleOnce: function scheduleOnce(callback, delay) {
        this.schedule(callback, 0, 0, delay);
      },
      unschedule: function unschedule(callback_fn) {
        if (!callback_fn) return;
        cc.director.getScheduler().unschedule(callback_fn, this);
      },
      unscheduleAllCallbacks: function unscheduleAllCallbacks() {
        cc.director.getScheduler().unscheduleAllForTarget(this);
      }
    });
    Component._requireComponent = null;
    Component._executionOrder = 0;
    false, false;
    js.value(Component, "_registerEditorProps", (function(cls, props) {
      var reqComp = props.requireComponent;
      reqComp && (cls._requireComponent = reqComp);
      var order = props.executionOrder;
      order && "number" === typeof order && (cls._executionOrder = order);
      var name;
      var key;
      var val;
      var willExecuteInEditMode;
      false, false;
    }));
    Component.prototype.__scriptUuid = "";
    cc.Component = module.exports = Component;
  }), {
    "../platform/CCObject": 205,
    "../platform/id-generater": 215,
    "../platform/js": 219
  } ],
  97: [ (function(require, module, exports) {
    "use strict";
    cc.Component.EventHandler = cc.Class({
      name: "cc.ClickEvent",
      properties: {
        target: {
          default: null,
          type: cc.Node
        },
        component: "",
        _componentId: "",
        _componentName: {
          get: function get() {
            this._genCompIdIfNeeded();
            return this._compId2Name(this._componentId);
          },
          set: function set(value) {
            this._componentId = this._compName2Id(value);
          }
        },
        handler: {
          default: ""
        },
        customEventData: {
          default: ""
        }
      },
      statics: {
        emitEvents: function emitEvents(events) {
          var args = void 0;
          if (arguments.length > 0) {
            args = new Array(arguments.length - 1);
            for (var i = 0, l = args.length; i < l; i++) args[i] = arguments[i + 1];
          }
          for (var _i = 0, _l = events.length; _i < _l; _i++) {
            var event = events[_i];
            if (!(event instanceof cc.Component.EventHandler)) continue;
            event.emit(args);
          }
        }
      },
      emit: function emit(params) {
        var target = this.target;
        if (!cc.isValid(target)) return;
        this._genCompIdIfNeeded();
        var compType = cc.js._getClassById(this._componentId);
        var comp = target.getComponent(compType);
        if (!cc.isValid(comp)) return;
        var handler = comp[this.handler];
        if ("function" !== typeof handler) return;
        if (null != this.customEventData && "" !== this.customEventData) {
          params = params.slice();
          params.push(this.customEventData);
        }
        handler.apply(comp, params);
      },
      _compName2Id: function _compName2Id(compName) {
        var comp = cc.js.getClassByName(compName);
        return cc.js._getClassId(comp);
      },
      _compId2Name: function _compId2Name(compId) {
        var comp = cc.js._getClassById(compId);
        return cc.js.getClassName(comp);
      },
      _genCompIdIfNeeded: function _genCompIdIfNeeded() {
        if (!this._componentId) {
          this._componentName = this.component;
          this.component = "";
        }
      }
    });
  }), {} ],
  98: [ (function(require, module, exports) {
    "use strict";
    var macro = require("../platform/CCMacro");
    var RenderComponent = require("./CCRenderComponent");
    var Material = require("../assets/material/CCMaterial");
    var LabelFrame = require("../renderer/utils/label/label-frame");
    var HorizontalAlign = macro.TextAlignment;
    var VerticalAlign = macro.VerticalTextAlignment;
    var Overflow = cc.Enum({
      NONE: 0,
      CLAMP: 1,
      SHRINK: 2,
      RESIZE_HEIGHT: 3
    });
    var CacheMode = cc.Enum({
      NONE: 0,
      BITMAP: 1,
      CHAR: 2
    });
    var Label = cc.Class({
      name: "cc.Label",
      extends: RenderComponent,
      ctor: function ctor() {
        false;
        this._actualFontSize = 0;
        this._assemblerData = null;
        this._frame = null;
        this._ttfTexture = null;
        this._letterTexture = null;
        cc.game.renderType === cc.game.RENDER_TYPE_CANVAS ? this._activateMaterial = this._activateMaterialCanvas : this._activateMaterial = this._activateMaterialWebgl;
      },
      editor: false,
      properties: {
        _useOriginalSize: true,
        _string: {
          default: "",
          formerlySerializedAs: "_N$string"
        },
        string: {
          get: function get() {
            return this._string;
          },
          set: function set(value) {
            var oldValue = this._string;
            this._string = "" + value;
            this.string !== oldValue && this._lazyUpdateRenderData();
            this._checkStringEmpty();
          },
          multiline: true,
          tooltip: false
        },
        horizontalAlign: {
          default: HorizontalAlign.LEFT,
          type: HorizontalAlign,
          tooltip: false,
          notify: function notify(oldValue) {
            if (this.horizontalAlign === oldValue) return;
            this._lazyUpdateRenderData();
          },
          animatable: false
        },
        verticalAlign: {
          default: VerticalAlign.TOP,
          type: VerticalAlign,
          tooltip: false,
          notify: function notify(oldValue) {
            if (this.verticalAlign === oldValue) return;
            this._lazyUpdateRenderData();
          },
          animatable: false
        },
        actualFontSize: {
          displayName: "Actual Font Size",
          animatable: false,
          readonly: true,
          get: function get() {
            return this._actualFontSize;
          },
          tooltip: false
        },
        _fontSize: 40,
        fontSize: {
          get: function get() {
            return this._fontSize;
          },
          set: function set(value) {
            if (this._fontSize === value) return;
            this._fontSize = value;
            this._lazyUpdateRenderData();
          },
          range: [ 0, 512 ],
          tooltip: false
        },
        fontFamily: {
          default: "Arial",
          tooltip: false,
          notify: function notify(oldValue) {
            if (this.fontFamily === oldValue) return;
            this._lazyUpdateRenderData();
          },
          animatable: false
        },
        _lineHeight: 40,
        lineHeight: {
          get: function get() {
            return this._lineHeight;
          },
          set: function set(value) {
            if (this._lineHeight === value) return;
            this._lineHeight = value;
            this._lazyUpdateRenderData();
          },
          tooltip: false
        },
        overflow: {
          default: Overflow.NONE,
          type: Overflow,
          tooltip: false,
          notify: function notify(oldValue) {
            if (this.overflow === oldValue) return;
            this._lazyUpdateRenderData();
          },
          animatable: false
        },
        _enableWrapText: true,
        enableWrapText: {
          get: function get() {
            return this._enableWrapText;
          },
          set: function set(value) {
            if (this._enableWrapText === value) return;
            this._enableWrapText = value;
            this._lazyUpdateRenderData();
          },
          animatable: false,
          tooltip: false
        },
        _N$file: null,
        font: {
          get: function get() {
            return this._N$file;
          },
          set: function set(value) {
            if (this.font === value) return;
            value || (this._isSystemFontUsed = true);
            false;
            this._N$file = value;
            value && this._isSystemFontUsed && (this._isSystemFontUsed = false);
            "string" === typeof value && cc.warnID(4e3);
            this._resetAssembler();
            this._applyFontTexture(true);
            this._lazyUpdateRenderData();
          },
          type: cc.Font,
          tooltip: false,
          animatable: false
        },
        _isSystemFontUsed: true,
        useSystemFont: {
          get: function get() {
            return this._isSystemFontUsed;
          },
          set: function set(value) {
            if (this._isSystemFontUsed === value) return;
            this._isSystemFontUsed = !!value;
            false;
            if (value) {
              this.font = null;
              this._resetAssembler();
              this._applyFontTexture(true);
              this._lazyUpdateRenderData();
              this._checkStringEmpty();
            }
          },
          animatable: false,
          tooltip: false
        },
        _bmFontOriginalSize: {
          displayName: "BMFont Original Size",
          get: function get() {
            return this._N$file instanceof cc.BitmapFont ? this._N$file.fontSize : -1;
          },
          visible: true,
          animatable: false
        },
        _spacingX: 0,
        spacingX: {
          get: function get() {
            return this._spacingX;
          },
          set: function set(value) {
            this._spacingX = value;
            this._lazyUpdateRenderData();
          },
          tooltip: false
        },
        _batchAsBitmap: false,
        cacheMode: {
          default: CacheMode.NONE,
          type: CacheMode,
          tooltip: false,
          notify: function notify(oldValue) {
            if (this.cacheMode === oldValue) return;
            oldValue !== CacheMode.BITMAP || this.font instanceof cc.BitmapFont || this._frame && this._frame._resetDynamicAtlasFrame();
            oldValue === CacheMode.CHAR && (this._ttfTexture = null);
            this._resetAssembler();
            this._applyFontTexture(true);
            this._lazyUpdateRenderData();
          },
          animatable: false
        },
        _isBold: {
          default: false,
          serializable: false
        },
        _isItalic: {
          default: false,
          serializable: false
        },
        _isUnderline: {
          default: false,
          serializable: false
        }
      },
      statics: {
        HorizontalAlign: HorizontalAlign,
        VerticalAlign: VerticalAlign,
        Overflow: Overflow,
        CacheMode: CacheMode,
        _shareAtlas: null,
        clearCharCache: function clearCharCache() {
          Label._shareAtlas && Label._shareAtlas.clearAllCache();
        }
      },
      onLoad: function onLoad() {
        if (this._batchAsBitmap && this.cacheMode === CacheMode.NONE) {
          this.cacheMode = CacheMode.BITMAP;
          this._batchAsBitmap = false;
        }
        cc.game.renderType === cc.game.RENDER_TYPE_CANVAS && (this.cacheMode = CacheMode.NONE);
      },
      onEnable: function onEnable() {
        this._super();
        this.node.on(cc.Node.EventType.SIZE_CHANGED, this._lazyUpdateRenderData, this);
        this.node.on(cc.Node.EventType.ANCHOR_CHANGED, this._lazyUpdateRenderData, this);
        this._forceUpdateRenderData();
        this._checkStringEmpty();
      },
      onDisable: function onDisable() {
        this._super();
        this.node.off(cc.Node.EventType.SIZE_CHANGED, this._lazyUpdateRenderData, this);
        this.node.off(cc.Node.EventType.ANCHOR_CHANGED, this._lazyUpdateRenderData, this);
      },
      onDestroy: function onDestroy() {
        this._assembler && this._assembler._resetAssemblerData && this._assembler._resetAssemblerData(this._assemblerData);
        this._assemblerData = null;
        this._letterTexture = null;
        if (this._ttfTexture) {
          this._ttfTexture.destroy();
          this._ttfTexture = null;
        }
        this._super();
      },
      _updateColor: function _updateColor() {
        this.font instanceof cc.BitmapFont || this._lazyUpdateRenderData();
        RenderComponent.prototype._updateColor.call(this);
      },
      _resetAssembler: function _resetAssembler() {
        this._frame = null;
        RenderComponent.prototype._resetAssembler.call(this);
      },
      _canRender: function _canRender() {
        var result = this._super();
        var font = this.font;
        if (font instanceof cc.BitmapFont) {
          var spriteFrame = font.spriteFrame;
          spriteFrame && spriteFrame.textureLoaded() || (result = false);
        }
        return result;
      },
      _checkStringEmpty: function _checkStringEmpty() {
        this.markForRender(!!this.string);
      },
      _on3DNodeChanged: function _on3DNodeChanged() {
        this._resetAssembler();
        this._applyFontTexture(true);
      },
      _applyFontTexture: function _applyFontTexture(force) {
        var font = this.font;
        if (font instanceof cc.BitmapFont) {
          var spriteFrame = font.spriteFrame;
          this._frame = spriteFrame;
          var self = this;
          var onBMFontTextureLoaded = function onBMFontTextureLoaded() {
            self._frame._texture = spriteFrame._texture;
            self._activateMaterial(force);
            force && self._assembler && self._assembler.updateRenderData(self);
          };
          if (spriteFrame && spriteFrame.textureLoaded()) onBMFontTextureLoaded(); else {
            this.disableRender();
            if (spriteFrame) {
              spriteFrame.once("load", onBMFontTextureLoaded, this);
              spriteFrame.ensureLoadTexture();
            }
          }
        } else {
          this._frame || (this._frame = new LabelFrame());
          if (this.cacheMode === CacheMode.CHAR) {
            this._letterTexture = this._assembler._getAssemblerData();
            this._frame._refreshTexture(this._letterTexture);
          } else if (!this._ttfTexture) {
            this._ttfTexture = new cc.Texture2D();
            this._assemblerData = this._assembler._getAssemblerData();
            this._ttfTexture.initWithElement(this._assemblerData.canvas);
          }
          if (this.cacheMode !== CacheMode.CHAR) {
            this._frame._resetDynamicAtlasFrame();
            this._frame._refreshTexture(this._ttfTexture);
          }
          this._activateMaterial(force);
          force && this._assembler && this._assembler.updateRenderData(this);
        }
      },
      _activateMaterialCanvas: function _activateMaterialCanvas(force) {
        if (!force) return;
        this._frame._texture.url = this.uuid + "_texture";
        this.markForUpdateRenderData(true);
        this.markForRender(true);
      },
      _activateMaterialWebgl: function _activateMaterialWebgl(force) {
        if (!force) return;
        if (!this._frame) {
          this.disableRender();
          return;
        }
        var material = this.sharedMaterials[0];
        material = material ? Material.getInstantiatedMaterial(material, this) : Material.getInstantiatedBuiltinMaterial("2d-sprite", this);
        material.setProperty("texture", this._frame._texture);
        this.setMaterial(0, material);
        this.markForUpdateRenderData(true);
        this.markForRender(true);
      },
      _lazyUpdateRenderData: function _lazyUpdateRenderData() {
        this.setVertsDirty();
        this.markForUpdateRenderData(true);
      },
      _forceUpdateRenderData: function _forceUpdateRenderData() {
        this.setVertsDirty();
        this._resetAssembler();
        this._applyFontTexture(true);
        this.markForUpdateRenderData(true);
      },
      _enableBold: function _enableBold(enabled) {
        this._isBold = !!enabled;
      },
      _enableItalics: function _enableItalics(enabled) {
        this._isItalic = !!enabled;
      },
      _enableUnderline: function _enableUnderline(enabled) {
        this._isUnderline = !!enabled;
      }
    });
    cc.Label = module.exports = Label;
  }), {
    "../assets/material/CCMaterial": 76,
    "../platform/CCMacro": 204,
    "../renderer/utils/label/label-frame": 253,
    "./CCRenderComponent": 107
  } ],
  99: [ (function(require, module, exports) {
    "use strict";
    var LabelOutline = cc.Class({
      name: "cc.LabelOutline",
      extends: require("./CCComponent"),
      editor: false,
      properties: {
        _color: cc.Color.WHITE,
        _width: 1,
        color: {
          tooltip: false,
          get: function get() {
            return this._color;
          },
          set: function set(value) {
            this._color = value;
            this._updateRenderData();
          }
        },
        width: {
          tooltip: false,
          get: function get() {
            return this._width;
          },
          set: function set(value) {
            if (this._width === value) return;
            this._width = value;
            this._updateRenderData();
          },
          range: [ 0, 512 ]
        }
      },
      onEnable: function onEnable() {
        this._updateRenderData();
      },
      onDisable: function onDisable() {
        this._updateRenderData();
      },
      _updateRenderData: function _updateRenderData() {
        var label = this.node.getComponent(cc.Label);
        label && label._lazyUpdateRenderData();
      }
    });
    cc.LabelOutline = module.exports = LabelOutline;
  }), {
    "./CCComponent": 96
  } ],
  100: [ (function(require, module, exports) {
    "use strict";
    var LabelShadow = cc.Class({
      name: "cc.LabelShadow",
      extends: require("./CCComponent"),
      editor: false,
      properties: {
        _color: cc.Color.WHITE,
        _offset: cc.v2(2, 2),
        _blur: 2,
        color: {
          tooltip: false,
          get: function get() {
            return this._color;
          },
          set: function set(value) {
            this._color = value;
            this._updateRenderData();
          }
        },
        offset: {
          tooltip: false,
          get: function get() {
            return this._offset;
          },
          set: function set(value) {
            this._offset = value;
            this._updateRenderData();
          }
        },
        blur: {
          tooltip: false,
          get: function get() {
            return this._blur;
          },
          set: function set(value) {
            this._blur = value;
            this._updateRenderData();
          },
          range: [ 0, 1024 ]
        }
      },
      onEnable: function onEnable() {
        this._updateRenderData();
      },
      onDisable: function onDisable() {
        this._updateRenderData();
      },
      _updateRenderData: function _updateRenderData() {
        var label = this.node.getComponent(cc.Label);
        label && label._lazyUpdateRenderData();
      }
    });
    cc.LabelShadow = module.exports = LabelShadow;
  }), {
    "./CCComponent": 96
  } ],
  101: [ (function(require, module, exports) {
    "use strict";
    var NodeEvent = require("../CCNode").EventType;
    var Type = cc.Enum({
      NONE: 0,
      HORIZONTAL: 1,
      VERTICAL: 2,
      GRID: 3
    });
    var ResizeMode = cc.Enum({
      NONE: 0,
      CONTAINER: 1,
      CHILDREN: 2
    });
    var AxisDirection = cc.Enum({
      HORIZONTAL: 0,
      VERTICAL: 1
    });
    var VerticalDirection = cc.Enum({
      BOTTOM_TO_TOP: 0,
      TOP_TO_BOTTOM: 1
    });
    var HorizontalDirection = cc.Enum({
      LEFT_TO_RIGHT: 0,
      RIGHT_TO_LEFT: 1
    });
    var Layout = cc.Class({
      name: "cc.Layout",
      extends: require("./CCComponent"),
      editor: false,
      properties: {
        _layoutSize: cc.size(300, 200),
        _layoutDirty: {
          default: true,
          serializable: false
        },
        _resize: ResizeMode.NONE,
        _N$layoutType: Type.NONE,
        type: {
          type: Type,
          get: function get() {
            return this._N$layoutType;
          },
          set: function set(value) {
            this._N$layoutType = value;
            var reLayouted;
            false;
            this._doLayoutDirty();
          },
          tooltip: false,
          animatable: false
        },
        resizeMode: {
          type: ResizeMode,
          tooltip: false,
          animatable: false,
          get: function get() {
            return this._resize;
          },
          set: function set(value) {
            if (this.type === Type.NONE && value === ResizeMode.CHILDREN) return;
            this._resize = value;
            var reLayouted;
            false;
            this._doLayoutDirty();
          }
        },
        cellSize: {
          default: cc.size(40, 40),
          tooltip: false,
          type: cc.Size,
          notify: function notify() {
            this._doLayoutDirty();
          }
        },
        startAxis: {
          default: AxisDirection.HORIZONTAL,
          tooltip: false,
          type: AxisDirection,
          notify: function notify() {
            var reLayouted;
            false;
            this._doLayoutDirty();
          },
          animatable: false
        },
        _N$padding: {
          default: 0
        },
        paddingLeft: {
          default: 0,
          tooltip: false,
          notify: function notify() {
            this._doLayoutDirty();
          }
        },
        paddingRight: {
          default: 0,
          tooltip: false,
          notify: function notify() {
            this._doLayoutDirty();
          }
        },
        paddingTop: {
          default: 0,
          tooltip: false,
          notify: function notify() {
            this._doLayoutDirty();
          }
        },
        paddingBottom: {
          default: 0,
          tooltip: false,
          notify: function notify() {
            this._doLayoutDirty();
          }
        },
        spacingX: {
          default: 0,
          notify: function notify() {
            this._doLayoutDirty();
          },
          tooltip: false
        },
        spacingY: {
          default: 0,
          notify: function notify() {
            this._doLayoutDirty();
          },
          tooltip: false
        },
        verticalDirection: {
          default: VerticalDirection.TOP_TO_BOTTOM,
          type: VerticalDirection,
          notify: function notify() {
            this._doLayoutDirty();
          },
          tooltip: false,
          animatable: false
        },
        horizontalDirection: {
          default: HorizontalDirection.LEFT_TO_RIGHT,
          type: HorizontalDirection,
          notify: function notify() {
            this._doLayoutDirty();
          },
          tooltip: false,
          animatable: false
        },
        affectedByScale: {
          default: false,
          notify: function notify() {
            this._doLayoutDirty();
          },
          animatable: false,
          tooltip: false
        }
      },
      statics: {
        Type: Type,
        VerticalDirection: VerticalDirection,
        HorizontalDirection: HorizontalDirection,
        ResizeMode: ResizeMode,
        AxisDirection: AxisDirection
      },
      _migratePaddingData: function _migratePaddingData() {
        this.paddingLeft = this._N$padding;
        this.paddingRight = this._N$padding;
        this.paddingTop = this._N$padding;
        this.paddingBottom = this._N$padding;
        this._N$padding = 0;
      },
      onEnable: function onEnable() {
        this._addEventListeners();
        this.node.getContentSize().equals(cc.size(0, 0)) && this.node.setContentSize(this._layoutSize);
        0 !== this._N$padding && this._migratePaddingData();
        this._doLayoutDirty();
      },
      onDisable: function onDisable() {
        this._removeEventListeners();
      },
      _doLayoutDirty: function _doLayoutDirty() {
        this._layoutDirty = true;
      },
      _doScaleDirty: function _doScaleDirty() {
        this._layoutDirty = this._layoutDirty || this.affectedByScale;
      },
      _addEventListeners: function _addEventListeners() {
        cc.director.on(cc.Director.EVENT_AFTER_UPDATE, this.updateLayout, this);
        this.node.on(NodeEvent.SIZE_CHANGED, this._resized, this);
        this.node.on(NodeEvent.ANCHOR_CHANGED, this._doLayoutDirty, this);
        this.node.on(NodeEvent.CHILD_ADDED, this._childAdded, this);
        this.node.on(NodeEvent.CHILD_REMOVED, this._childRemoved, this);
        this.node.on(NodeEvent.CHILD_REORDER, this._doLayoutDirty, this);
        this._addChildrenEventListeners();
      },
      _removeEventListeners: function _removeEventListeners() {
        cc.director.off(cc.Director.EVENT_AFTER_UPDATE, this.updateLayout, this);
        this.node.off(NodeEvent.SIZE_CHANGED, this._resized, this);
        this.node.off(NodeEvent.ANCHOR_CHANGED, this._doLayoutDirty, this);
        this.node.off(NodeEvent.CHILD_ADDED, this._childAdded, this);
        this.node.off(NodeEvent.CHILD_REMOVED, this._childRemoved, this);
        this.node.off(NodeEvent.CHILD_REORDER, this._doLayoutDirty, this);
        this._removeChildrenEventListeners();
      },
      _addChildrenEventListeners: function _addChildrenEventListeners() {
        var children = this.node.children;
        for (var i = 0; i < children.length; ++i) {
          var child = children[i];
          child.on(NodeEvent.SCALE_CHANGED, this._doScaleDirty, this);
          child.on(NodeEvent.SIZE_CHANGED, this._doLayoutDirty, this);
          child.on(NodeEvent.POSITION_CHANGED, this._doLayoutDirty, this);
          child.on(NodeEvent.ANCHOR_CHANGED, this._doLayoutDirty, this);
          child.on("active-in-hierarchy-changed", this._doLayoutDirty, this);
        }
      },
      _removeChildrenEventListeners: function _removeChildrenEventListeners() {
        var children = this.node.children;
        for (var i = 0; i < children.length; ++i) {
          var child = children[i];
          child.off(NodeEvent.SCALE_CHANGED, this._doScaleDirty, this);
          child.off(NodeEvent.SIZE_CHANGED, this._doLayoutDirty, this);
          child.off(NodeEvent.POSITION_CHANGED, this._doLayoutDirty, this);
          child.off(NodeEvent.ANCHOR_CHANGED, this._doLayoutDirty, this);
          child.off("active-in-hierarchy-changed", this._doLayoutDirty, this);
        }
      },
      _childAdded: function _childAdded(child) {
        child.on(NodeEvent.SCALE_CHANGED, this._doScaleDirty, this);
        child.on(NodeEvent.SIZE_CHANGED, this._doLayoutDirty, this);
        child.on(NodeEvent.POSITION_CHANGED, this._doLayoutDirty, this);
        child.on(NodeEvent.ANCHOR_CHANGED, this._doLayoutDirty, this);
        child.on("active-in-hierarchy-changed", this._doLayoutDirty, this);
        this._doLayoutDirty();
      },
      _childRemoved: function _childRemoved(child) {
        child.off(NodeEvent.SCALE_CHANGED, this._doScaleDirty, this);
        child.off(NodeEvent.SIZE_CHANGED, this._doLayoutDirty, this);
        child.off(NodeEvent.POSITION_CHANGED, this._doLayoutDirty, this);
        child.off(NodeEvent.ANCHOR_CHANGED, this._doLayoutDirty, this);
        child.off("active-in-hierarchy-changed", this._doLayoutDirty, this);
        this._doLayoutDirty();
      },
      _resized: function _resized() {
        this._layoutSize = this.node.getContentSize();
        this._doLayoutDirty();
      },
      _doLayoutHorizontally: function _doLayoutHorizontally(baseWidth, rowBreak, fnPositionY, applyChildren) {
        var layoutAnchor = this.node.getAnchorPoint();
        var children = this.node.children;
        var sign = 1;
        var paddingX = this.paddingLeft;
        var leftBoundaryOfLayout = -layoutAnchor.x * baseWidth;
        if (this.horizontalDirection === HorizontalDirection.RIGHT_TO_LEFT) {
          sign = -1;
          leftBoundaryOfLayout = (1 - layoutAnchor.x) * baseWidth;
          paddingX = this.paddingRight;
        }
        var nextX = leftBoundaryOfLayout + sign * paddingX - sign * this.spacingX;
        var rowMaxHeight = 0;
        var tempMaxHeight = 0;
        var secondMaxHeight = 0;
        var row = 0;
        var containerResizeBoundary = 0;
        var maxHeightChildAnchorY = 0;
        var activeChildCount = 0;
        for (var i = 0; i < children.length; ++i) {
          var child = children[i];
          child.activeInHierarchy && activeChildCount++;
        }
        var newChildWidth = this.cellSize.width;
        this.type !== Type.GRID && this.resizeMode === ResizeMode.CHILDREN && (newChildWidth = (baseWidth - (this.paddingLeft + this.paddingRight) - (activeChildCount - 1) * this.spacingX) / activeChildCount);
        for (var i = 0; i < children.length; ++i) {
          var child = children[i];
          var childScaleX = this._getUsedScaleValue(child.scaleX);
          var childScaleY = this._getUsedScaleValue(child.scaleY);
          if (!child.activeInHierarchy) continue;
          if (this._resize === ResizeMode.CHILDREN) {
            child.width = newChildWidth / childScaleX;
            this.type === Type.GRID && (child.height = this.cellSize.height / childScaleY);
          }
          var anchorX = child.anchorX;
          var childBoundingBoxWidth = child.width * childScaleX;
          var childBoundingBoxHeight = child.height * childScaleY;
          secondMaxHeight > tempMaxHeight && (tempMaxHeight = secondMaxHeight);
          if (childBoundingBoxHeight >= tempMaxHeight) {
            secondMaxHeight = tempMaxHeight;
            tempMaxHeight = childBoundingBoxHeight;
            maxHeightChildAnchorY = child.getAnchorPoint().y;
          }
          this.horizontalDirection === HorizontalDirection.RIGHT_TO_LEFT && (anchorX = 1 - child.anchorX);
          nextX = nextX + sign * anchorX * childBoundingBoxWidth + sign * this.spacingX;
          var rightBoundaryOfChild = sign * (1 - anchorX) * childBoundingBoxWidth;
          if (rowBreak) {
            var rowBreakBoundary = nextX + rightBoundaryOfChild + sign * (sign > 0 ? this.paddingRight : this.paddingLeft);
            var leftToRightRowBreak = this.horizontalDirection === HorizontalDirection.LEFT_TO_RIGHT && rowBreakBoundary > (1 - layoutAnchor.x) * baseWidth;
            var rightToLeftRowBreak = this.horizontalDirection === HorizontalDirection.RIGHT_TO_LEFT && rowBreakBoundary < -layoutAnchor.x * baseWidth;
            if (leftToRightRowBreak || rightToLeftRowBreak) {
              if (childBoundingBoxHeight >= tempMaxHeight) {
                0 === secondMaxHeight && (secondMaxHeight = tempMaxHeight);
                rowMaxHeight += secondMaxHeight;
                secondMaxHeight = tempMaxHeight;
              } else {
                rowMaxHeight += tempMaxHeight;
                secondMaxHeight = childBoundingBoxHeight;
                tempMaxHeight = 0;
              }
              nextX = leftBoundaryOfLayout + sign * (paddingX + anchorX * childBoundingBoxWidth);
              row++;
            }
          }
          var finalPositionY = fnPositionY(child, rowMaxHeight, row);
          baseWidth >= childBoundingBoxWidth + this.paddingLeft + this.paddingRight && applyChildren && child.setPosition(cc.v2(nextX, finalPositionY));
          var signX = 1;
          var tempFinalPositionY;
          var topMarign = 0 === tempMaxHeight ? childBoundingBoxHeight : tempMaxHeight;
          if (this.verticalDirection === VerticalDirection.TOP_TO_BOTTOM) {
            containerResizeBoundary = containerResizeBoundary || this.node._contentSize.height;
            signX = -1;
            tempFinalPositionY = finalPositionY + signX * (topMarign * maxHeightChildAnchorY + this.paddingBottom);
            tempFinalPositionY < containerResizeBoundary && (containerResizeBoundary = tempFinalPositionY);
          } else {
            containerResizeBoundary = containerResizeBoundary || -this.node._contentSize.height;
            tempFinalPositionY = finalPositionY + signX * (topMarign * maxHeightChildAnchorY + this.paddingTop);
            tempFinalPositionY > containerResizeBoundary && (containerResizeBoundary = tempFinalPositionY);
          }
          nextX += rightBoundaryOfChild;
        }
        return containerResizeBoundary;
      },
      _getVerticalBaseHeight: function _getVerticalBaseHeight(children) {
        var newHeight = 0;
        var activeChildCount = 0;
        if (this.resizeMode === ResizeMode.CONTAINER) {
          for (var i = 0; i < children.length; ++i) {
            var child = children[i];
            if (child.activeInHierarchy) {
              activeChildCount++;
              newHeight += child.height * this._getUsedScaleValue(child.scaleY);
            }
          }
          newHeight += (activeChildCount - 1) * this.spacingY + this.paddingBottom + this.paddingTop;
        } else newHeight = this.node.getContentSize().height;
        return newHeight;
      },
      _doLayoutVertically: function _doLayoutVertically(baseHeight, columnBreak, fnPositionX, applyChildren) {
        var layoutAnchor = this.node.getAnchorPoint();
        var children = this.node.children;
        var sign = 1;
        var paddingY = this.paddingBottom;
        var bottomBoundaryOfLayout = -layoutAnchor.y * baseHeight;
        if (this.verticalDirection === VerticalDirection.TOP_TO_BOTTOM) {
          sign = -1;
          bottomBoundaryOfLayout = (1 - layoutAnchor.y) * baseHeight;
          paddingY = this.paddingTop;
        }
        var nextY = bottomBoundaryOfLayout + sign * paddingY - sign * this.spacingY;
        var columnMaxWidth = 0;
        var tempMaxWidth = 0;
        var secondMaxWidth = 0;
        var column = 0;
        var containerResizeBoundary = 0;
        var maxWidthChildAnchorX = 0;
        var activeChildCount = 0;
        for (var i = 0; i < children.length; ++i) {
          var child = children[i];
          child.activeInHierarchy && activeChildCount++;
        }
        var newChildHeight = this.cellSize.height;
        this.type !== Type.GRID && this.resizeMode === ResizeMode.CHILDREN && (newChildHeight = (baseHeight - (this.paddingTop + this.paddingBottom) - (activeChildCount - 1) * this.spacingY) / activeChildCount);
        for (var i = 0; i < children.length; ++i) {
          var child = children[i];
          var childScaleX = this._getUsedScaleValue(child.scaleX);
          var childScaleY = this._getUsedScaleValue(child.scaleY);
          if (!child.activeInHierarchy) continue;
          if (this.resizeMode === ResizeMode.CHILDREN) {
            child.height = newChildHeight / childScaleY;
            this.type === Type.GRID && (child.width = this.cellSize.width / childScaleX);
          }
          var anchorY = child.anchorY;
          var childBoundingBoxWidth = child.width * childScaleX;
          var childBoundingBoxHeight = child.height * childScaleY;
          secondMaxWidth > tempMaxWidth && (tempMaxWidth = secondMaxWidth);
          if (childBoundingBoxWidth >= tempMaxWidth) {
            secondMaxWidth = tempMaxWidth;
            tempMaxWidth = childBoundingBoxWidth;
            maxWidthChildAnchorX = child.getAnchorPoint().x;
          }
          this.verticalDirection === VerticalDirection.TOP_TO_BOTTOM && (anchorY = 1 - child.anchorY);
          nextY = nextY + sign * anchorY * childBoundingBoxHeight + sign * this.spacingY;
          var topBoundaryOfChild = sign * (1 - anchorY) * childBoundingBoxHeight;
          if (columnBreak) {
            var columnBreakBoundary = nextY + topBoundaryOfChild + sign * (sign > 0 ? this.paddingTop : this.paddingBottom);
            var bottomToTopColumnBreak = this.verticalDirection === VerticalDirection.BOTTOM_TO_TOP && columnBreakBoundary > (1 - layoutAnchor.y) * baseHeight;
            var topToBottomColumnBreak = this.verticalDirection === VerticalDirection.TOP_TO_BOTTOM && columnBreakBoundary < -layoutAnchor.y * baseHeight;
            if (bottomToTopColumnBreak || topToBottomColumnBreak) {
              if (childBoundingBoxWidth >= tempMaxWidth) {
                0 === secondMaxWidth && (secondMaxWidth = tempMaxWidth);
                columnMaxWidth += secondMaxWidth;
                secondMaxWidth = tempMaxWidth;
              } else {
                columnMaxWidth += tempMaxWidth;
                secondMaxWidth = childBoundingBoxWidth;
                tempMaxWidth = 0;
              }
              nextY = bottomBoundaryOfLayout + sign * (paddingY + anchorY * childBoundingBoxHeight);
              column++;
            }
          }
          var finalPositionX = fnPositionX(child, columnMaxWidth, column);
          baseHeight >= childBoundingBoxHeight + (this.paddingTop + this.paddingBottom) && applyChildren && child.setPosition(cc.v2(finalPositionX, nextY));
          var signX = 1;
          var tempFinalPositionX;
          var rightMarign = 0 === tempMaxWidth ? childBoundingBoxWidth : tempMaxWidth;
          if (this.horizontalDirection === HorizontalDirection.RIGHT_TO_LEFT) {
            signX = -1;
            containerResizeBoundary = containerResizeBoundary || this.node._contentSize.width;
            tempFinalPositionX = finalPositionX + signX * (rightMarign * maxWidthChildAnchorX + this.paddingLeft);
            tempFinalPositionX < containerResizeBoundary && (containerResizeBoundary = tempFinalPositionX);
          } else {
            containerResizeBoundary = containerResizeBoundary || -this.node._contentSize.width;
            tempFinalPositionX = finalPositionX + signX * (rightMarign * maxWidthChildAnchorX + this.paddingRight);
            tempFinalPositionX > containerResizeBoundary && (containerResizeBoundary = tempFinalPositionX);
          }
          nextY += topBoundaryOfChild;
        }
        return containerResizeBoundary;
      },
      _doLayoutBasic: function _doLayoutBasic() {
        var children = this.node.children;
        var allChildrenBoundingBox = null;
        for (var i = 0; i < children.length; ++i) {
          var child = children[i];
          child.activeInHierarchy && (allChildrenBoundingBox ? allChildrenBoundingBox.union(allChildrenBoundingBox, child.getBoundingBoxToWorld()) : allChildrenBoundingBox = child.getBoundingBoxToWorld());
        }
        if (allChildrenBoundingBox) {
          var leftBottomSpace = this.node.convertToNodeSpaceAR(cc.v2(allChildrenBoundingBox.x, allChildrenBoundingBox.y));
          leftBottomSpace = cc.v2(leftBottomSpace.x - this.paddingLeft, leftBottomSpace.y - this.paddingBottom);
          var rightTopSpace = this.node.convertToNodeSpaceAR(cc.v2(allChildrenBoundingBox.xMax, allChildrenBoundingBox.yMax));
          rightTopSpace = cc.v2(rightTopSpace.x + this.paddingRight, rightTopSpace.y + this.paddingTop);
          var newSize = rightTopSpace.sub(leftBottomSpace);
          newSize = cc.size(parseFloat(newSize.x.toFixed(2)), parseFloat(newSize.y.toFixed(2)));
          if (0 !== newSize.width) {
            var newAnchorX = -leftBottomSpace.x / newSize.width;
            this.node.anchorX = parseFloat(newAnchorX.toFixed(2));
          }
          if (0 !== newSize.height) {
            var newAnchorY = -leftBottomSpace.y / newSize.height;
            this.node.anchorY = parseFloat(newAnchorY.toFixed(2));
          }
          this.node.setContentSize(newSize);
        }
      },
      _doLayoutGridAxisHorizontal: function _doLayoutGridAxisHorizontal(layoutAnchor, layoutSize) {
        var baseWidth = layoutSize.width;
        var sign = 1;
        var bottomBoundaryOfLayout = -layoutAnchor.y * layoutSize.height;
        var paddingY = this.paddingBottom;
        if (this.verticalDirection === VerticalDirection.TOP_TO_BOTTOM) {
          sign = -1;
          bottomBoundaryOfLayout = (1 - layoutAnchor.y) * layoutSize.height;
          paddingY = this.paddingTop;
        }
        var fnPositionY = function(child, topOffset, row) {
          return bottomBoundaryOfLayout + sign * (topOffset + child.anchorY * child.height * this._getUsedScaleValue(child.scaleY) + paddingY + row * this.spacingY);
        }.bind(this);
        var newHeight = 0;
        if (this.resizeMode === ResizeMode.CONTAINER) {
          var boundary = this._doLayoutHorizontally(baseWidth, true, fnPositionY, false);
          newHeight = bottomBoundaryOfLayout - boundary;
          newHeight < 0 && (newHeight *= -1);
          bottomBoundaryOfLayout = -layoutAnchor.y * newHeight;
          if (this.verticalDirection === VerticalDirection.TOP_TO_BOTTOM) {
            sign = -1;
            bottomBoundaryOfLayout = (1 - layoutAnchor.y) * newHeight;
          }
        }
        this._doLayoutHorizontally(baseWidth, true, fnPositionY, true);
        this.resizeMode === ResizeMode.CONTAINER && this.node.setContentSize(baseWidth, newHeight);
      },
      _doLayoutGridAxisVertical: function _doLayoutGridAxisVertical(layoutAnchor, layoutSize) {
        var baseHeight = layoutSize.height;
        var sign = 1;
        var leftBoundaryOfLayout = -layoutAnchor.x * layoutSize.width;
        var paddingX = this.paddingLeft;
        if (this.horizontalDirection === HorizontalDirection.RIGHT_TO_LEFT) {
          sign = -1;
          leftBoundaryOfLayout = (1 - layoutAnchor.x) * layoutSize.width;
          paddingX = this.paddingRight;
        }
        var fnPositionX = function(child, leftOffset, column) {
          return leftBoundaryOfLayout + sign * (leftOffset + child.anchorX * child.width * this._getUsedScaleValue(child.scaleX) + paddingX + column * this.spacingX);
        }.bind(this);
        var newWidth = 0;
        if (this.resizeMode === ResizeMode.CONTAINER) {
          var boundary = this._doLayoutVertically(baseHeight, true, fnPositionX, false);
          newWidth = leftBoundaryOfLayout - boundary;
          newWidth < 0 && (newWidth *= -1);
          leftBoundaryOfLayout = -layoutAnchor.x * newWidth;
          if (this.horizontalDirection === HorizontalDirection.RIGHT_TO_LEFT) {
            sign = -1;
            leftBoundaryOfLayout = (1 - layoutAnchor.x) * newWidth;
          }
        }
        this._doLayoutVertically(baseHeight, true, fnPositionX, true);
        this.resizeMode === ResizeMode.CONTAINER && this.node.setContentSize(newWidth, baseHeight);
      },
      _doLayoutGrid: function _doLayoutGrid() {
        var layoutAnchor = this.node.getAnchorPoint();
        var layoutSize = this.node.getContentSize();
        this.startAxis === AxisDirection.HORIZONTAL ? this._doLayoutGridAxisHorizontal(layoutAnchor, layoutSize) : this.startAxis === AxisDirection.VERTICAL && this._doLayoutGridAxisVertical(layoutAnchor, layoutSize);
      },
      _getHorizontalBaseWidth: function _getHorizontalBaseWidth(children) {
        var newWidth = 0;
        var activeChildCount = 0;
        if (this.resizeMode === ResizeMode.CONTAINER) {
          for (var i = 0; i < children.length; ++i) {
            var child = children[i];
            if (child.activeInHierarchy) {
              activeChildCount++;
              newWidth += child.width * this._getUsedScaleValue(child.scaleX);
            }
          }
          newWidth += (activeChildCount - 1) * this.spacingX + this.paddingLeft + this.paddingRight;
        } else newWidth = this.node.getContentSize().width;
        return newWidth;
      },
      _doLayout: function _doLayout() {
        if (this.type === Type.HORIZONTAL) {
          var newWidth = this._getHorizontalBaseWidth(this.node.children);
          var fnPositionY = function fnPositionY(child) {
            return child.y;
          };
          this._doLayoutHorizontally(newWidth, false, fnPositionY, true);
          this.node.width = newWidth;
        } else if (this.type === Type.VERTICAL) {
          var newHeight = this._getVerticalBaseHeight(this.node.children);
          var fnPositionX = function fnPositionX(child) {
            return child.x;
          };
          this._doLayoutVertically(newHeight, false, fnPositionX, true);
          this.node.height = newHeight;
        } else this.type === Type.NONE ? this.resizeMode === ResizeMode.CONTAINER && this._doLayoutBasic() : this.type === Type.GRID && this._doLayoutGrid();
      },
      _getUsedScaleValue: function _getUsedScaleValue(value) {
        return this.affectedByScale ? Math.abs(value) : 1;
      },
      updateLayout: function updateLayout() {
        if (this._layoutDirty && this.node.children.length > 0) {
          this._doLayout();
          this._layoutDirty = false;
        }
      }
    });
    Object.defineProperty(Layout.prototype, "padding", {
      get: function get() {
        cc.warnID(4100);
        return this.paddingLeft;
      },
      set: function set(value) {
        this._N$padding = value;
        this._migratePaddingData();
        this._doLayoutDirty();
      }
    });
    cc.Layout = module.exports = Layout;
  }), {
    "../CCNode": 53,
    "./CCComponent": 96
  } ],
  102: [ (function(require, module, exports) {
    "use strict";
    var _gfx = require("../../renderer/gfx");
    var _gfx2 = _interopRequireDefault(_gfx);
    var _vmath = require("../vmath");
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : {
        default: obj
      };
    }
    var misc = require("../utils/misc");
    var Material = require("../assets/material/CCMaterial");
    var RenderComponent = require("./CCRenderComponent");
    var RenderFlow = require("../renderer/render-flow");
    var Graphics = require("../graphics/graphics");
    var Node = require("../CCNode");
    var _vec2_temp = cc.v2();
    var _mat4_temp = _vmath.mat4.create();
    var _circlepoints = [];
    function _calculateCircle(center, radius, segements) {
      _circlepoints.length = 0;
      var anglePerStep = 2 * Math.PI / segements;
      for (var step = 0; step < segements; ++step) _circlepoints.push(cc.v2(radius.x * Math.cos(anglePerStep * step) + center.x, radius.y * Math.sin(anglePerStep * step) + center.y));
      return _circlepoints;
    }
    var MaskType = cc.Enum({
      RECT: 0,
      ELLIPSE: 1,
      IMAGE_STENCIL: 2
    });
    var SEGEMENTS_MIN = 3;
    var SEGEMENTS_MAX = 1e4;
    var Mask = cc.Class({
      name: "cc.Mask",
      extends: RenderComponent,
      editor: false,
      ctor: function ctor() {
        this._graphics = null;
        this._enableMaterial = null;
        this._exitMaterial = null;
        this._clearMaterial = null;
      },
      properties: {
        _spriteFrame: {
          default: null,
          type: cc.SpriteFrame
        },
        _type: MaskType.RECT,
        type: {
          get: function get() {
            return this._type;
          },
          set: function set(value) {
            this._type !== value && this._resetAssembler();
            this._type = value;
            if (this._type !== MaskType.IMAGE_STENCIL) {
              this.spriteFrame = null;
              this.alphaThreshold = 0;
              this._updateGraphics();
            }
            this._activateMaterial();
          },
          type: MaskType,
          tooltip: false
        },
        spriteFrame: {
          type: cc.SpriteFrame,
          tooltip: false,
          get: function get() {
            return this._spriteFrame;
          },
          set: function set(value) {
            var lastSprite = this._spriteFrame;
            false;
            if (lastSprite === value) return;
            this._spriteFrame = value;
            this._applySpriteFrame(lastSprite);
          }
        },
        alphaThreshold: {
          default: .1,
          type: cc.Float,
          range: [ 0, 1, .1 ],
          slide: true,
          tooltip: false,
          notify: function notify() {
            if (cc.game.renderType === cc.game.RENDER_TYPE_CANVAS) {
              cc.warnID(4201);
              return;
            }
            var material = this.sharedMaterials[0];
            material && material.setProperty("alphaThreshold", this.alphaThreshold);
          }
        },
        inverted: {
          default: false,
          type: cc.Boolean,
          tooltip: false,
          notify: function notify() {
            if (cc.game.renderType === cc.game.RENDER_TYPE_CANVAS) {
              cc.warnID(4202);
              return;
            }
          }
        },
        _segments: 64,
        segements: {
          get: function get() {
            return this._segments;
          },
          set: function set(value) {
            this._segments = misc.clampf(value, SEGEMENTS_MIN, SEGEMENTS_MAX);
            this._updateGraphics();
          },
          type: cc.Integer,
          tooltip: false
        },
        _resizeToTarget: {
          animatable: false,
          set: function set(value) {
            value && this._resizeNodeToTargetNode();
          }
        }
      },
      statics: {
        Type: MaskType
      },
      onLoad: function onLoad() {
        this._createGraphics();
      },
      onRestore: function onRestore() {
        this._createGraphics();
        this._type !== MaskType.IMAGE_STENCIL ? this._updateGraphics() : this._applySpriteFrame();
      },
      onEnable: function onEnable() {
        this._super();
        if (this._type === MaskType.IMAGE_STENCIL) {
          if (!this._spriteFrame || !this._spriteFrame.textureLoaded()) {
            this.markForRender(false);
            if (this._spriteFrame) {
              this.markForUpdateRenderData(false);
              this._spriteFrame.once("load", this._onTextureLoaded, this);
              this._spriteFrame.ensureLoadTexture();
            }
          }
        } else this._updateGraphics();
        this.node.on(cc.Node.EventType.POSITION_CHANGED, this._updateGraphics, this);
        this.node.on(cc.Node.EventType.ROTATION_CHANGED, this._updateGraphics, this);
        this.node.on(cc.Node.EventType.SCALE_CHANGED, this._updateGraphics, this);
        this.node.on(cc.Node.EventType.SIZE_CHANGED, this._updateGraphics, this);
        this.node.on(cc.Node.EventType.ANCHOR_CHANGED, this._updateGraphics, this);
        this.node._renderFlag |= RenderFlow.FLAG_POST_RENDER;
        this._activateMaterial();
      },
      onDisable: function onDisable() {
        this._super();
        this.node.off(cc.Node.EventType.POSITION_CHANGED, this._updateGraphics, this);
        this.node.off(cc.Node.EventType.ROTATION_CHANGED, this._updateGraphics, this);
        this.node.off(cc.Node.EventType.SCALE_CHANGED, this._updateGraphics, this);
        this.node.off(cc.Node.EventType.SIZE_CHANGED, this._updateGraphics, this);
        this.node.off(cc.Node.EventType.ANCHOR_CHANGED, this._updateGraphics, this);
        this.node._renderFlag &= ~RenderFlow.FLAG_POST_RENDER;
      },
      onDestroy: function onDestroy() {
        this._super();
        this._removeGraphics();
      },
      _resizeNodeToTargetNode: false,
      _onTextureLoaded: function _onTextureLoaded() {
        this.setVertsDirty();
        this._assembler && this._assembler._renderData && this.markForUpdateRenderData(true);
        this.enabledInHierarchy && this._activateMaterial();
      },
      _applySpriteFrame: function _applySpriteFrame(oldFrame) {
        oldFrame && oldFrame.off && oldFrame.off("load", this._onTextureLoaded, this);
        var spriteFrame = this._spriteFrame;
        if (spriteFrame) if (spriteFrame.textureLoaded()) this._onTextureLoaded(null); else {
          spriteFrame.once("load", this._onTextureLoaded, this);
          spriteFrame.ensureLoadTexture();
        } else this.disableRender();
      },
      _activateMaterial: function _activateMaterial() {
        if (this._type === MaskType.IMAGE_STENCIL && (!this.spriteFrame || !this.spriteFrame.textureLoaded())) {
          this.markForRender(false);
          return;
        }
        if (cc.game.renderType !== cc.game.RENDER_TYPE_CANVAS) {
          var material = this.sharedMaterials[0];
          material = material ? Material.getInstantiatedMaterial(material, this) : Material.getInstantiatedBuiltinMaterial("2d-sprite", this);
          material.define("USE_ALPHA_TEST", true);
          if (this._type === MaskType.IMAGE_STENCIL) {
            var texture = this.spriteFrame.getTexture();
            material.define("CC_USE_MODEL", false);
            material.define("USE_TEXTURE", true);
            material.setProperty("texture", texture);
            material.setProperty("alphaThreshold", this.alphaThreshold);
          } else {
            material.define("CC_USE_MODEL", true);
            material.define("USE_TEXTURE", false);
          }
          this._enableMaterial || (this._enableMaterial = Material.getInstantiatedBuiltinMaterial("2d-sprite", this));
          if (!this._exitMaterial) {
            this._exitMaterial = Material.getInstantiatedBuiltinMaterial("2d-sprite", this);
            this._exitMaterial.effect.setStencilEnabled(_gfx2.default.STENCIL_DISABLE);
          }
          this._clearMaterial || (this._clearMaterial = Material.getInstantiatedBuiltinMaterial("clear-stencil", this));
          this.setMaterial(0, material);
        }
        this.markForRender(true);
      },
      _createGraphics: function _createGraphics() {
        if (!this._graphics) {
          this._graphics = new Graphics();
          cc.Assembler.init(this._graphics);
          this._graphics.node = this.node;
          this._graphics.lineWidth = 0;
          this._graphics.strokeColor = cc.color(0, 0, 0, 0);
        }
        if (!this._clearGraphics) {
          this._clearGraphics = new Graphics();
          cc.Assembler.init(this._clearGraphics);
          this._clearGraphics.node = new Node();
          this._clearGraphics._activateMaterial();
          this._clearGraphics.lineWidth = 0;
          this._clearGraphics.rect(-1, -1, 2, 2);
          this._clearGraphics.fill();
        }
      },
      _updateGraphics: function _updateGraphics() {
        var node = this.node;
        var graphics = this._graphics;
        graphics.clear(false);
        var width = node._contentSize.width;
        var height = node._contentSize.height;
        var x = -width * node._anchorPoint.x;
        var y = -height * node._anchorPoint.y;
        if (this._type === MaskType.RECT) graphics.rect(x, y, width, height); else if (this._type === MaskType.ELLIPSE) {
          var center = cc.v2(x + width / 2, y + height / 2);
          var radius = {
            x: width / 2,
            y: height / 2
          };
          var points = _calculateCircle(center, radius, this._segments);
          for (var i = 0; i < points.length; ++i) {
            var point = points[i];
            0 === i ? graphics.moveTo(point.x, point.y) : graphics.lineTo(point.x, point.y);
          }
          graphics.close();
        }
        cc.game.renderType === cc.game.RENDER_TYPE_CANVAS ? graphics.stroke() : graphics.fill();
      },
      _removeGraphics: function _removeGraphics() {
        if (this._graphics) {
          this._graphics.destroy();
          this._graphics = null;
        }
        if (this._clearGraphics) {
          this._clearGraphics.destroy();
          this._clearGraphics = null;
        }
      },
      _hitTest: function _hitTest(cameraPt) {
        var node = this.node;
        var size = node.getContentSize(), w = size.width, h = size.height, testPt = _vec2_temp;
        node._updateWorldMatrix();
        if (!_vmath.mat4.invert(_mat4_temp, node._worldMatrix)) return false;
        _vmath.vec2.transformMat4(testPt, cameraPt, _mat4_temp);
        testPt.x += node._anchorPoint.x * w;
        testPt.y += node._anchorPoint.y * h;
        var result = false;
        if (this.type === MaskType.RECT || this.type === MaskType.IMAGE_STENCIL) result = testPt.x >= 0 && testPt.y >= 0 && testPt.x <= w && testPt.y <= h; else if (this.type === MaskType.ELLIPSE) {
          var rx = w / 2, ry = h / 2;
          var px = testPt.x - .5 * w, py = testPt.y - .5 * h;
          result = px * px / (rx * rx) + py * py / (ry * ry) < 1;
        }
        this.inverted && (result = !result);
        return result;
      },
      markForUpdateRenderData: function markForUpdateRenderData(enable) {
        enable && this.enabledInHierarchy ? this.node._renderFlag |= RenderFlow.FLAG_UPDATE_RENDER_DATA : enable || (this.node._renderFlag &= ~RenderFlow.FLAG_UPDATE_RENDER_DATA);
      },
      markForRender: function markForRender(enable) {
        enable && this.enabledInHierarchy ? this.node._renderFlag |= RenderFlow.FLAG_RENDER | RenderFlow.FLAG_UPDATE_RENDER_DATA | RenderFlow.FLAG_POST_RENDER : enable || (this.node._renderFlag &= ~(RenderFlow.FLAG_RENDER | RenderFlow.FLAG_POST_RENDER));
      },
      disableRender: function disableRender() {
        this.node._renderFlag &= ~(RenderFlow.FLAG_RENDER | RenderFlow.FLAG_UPDATE_RENDER_DATA | RenderFlow.FLAG_POST_RENDER);
      }
    });
    cc.Mask = module.exports = Mask;
  }), {
    "../../renderer/gfx": 352,
    "../CCNode": 53,
    "../assets/material/CCMaterial": 76,
    "../graphics/graphics": 141,
    "../renderer/render-flow": 249,
    "../utils/misc": 299,
    "../vmath": 325,
    "./CCRenderComponent": 107
  } ],
  103: [ (function(require, module, exports) {
    "use strict";
    var RenderComponent = require("../components/CCRenderComponent");
    var Material = require("../assets/material/CCMaterial");
    var textureUtil = require("../utils/texture-util");
    var BlendFunc = require("../../core/utils/blend-func");
    var MotionStreak = cc.Class({
      name: "cc.MotionStreak",
      extends: RenderComponent,
      mixins: [ BlendFunc ],
      editor: false,
      ctor: function ctor() {
        this._points = [];
      },
      properties: {
        preview: {
          default: false,
          editorOnly: true,
          notify: false,
          animatable: false
        },
        _fadeTime: 1,
        fadeTime: {
          get: function get() {
            return this._fadeTime;
          },
          set: function set(value) {
            this._fadeTime = value;
            this.reset();
          },
          animatable: false,
          tooltip: false
        },
        _minSeg: 1,
        minSeg: {
          get: function get() {
            return this._minSeg;
          },
          set: function set(value) {
            this._minSeg = value;
          },
          animatable: false,
          tooltip: false
        },
        _stroke: 64,
        stroke: {
          get: function get() {
            return this._stroke;
          },
          set: function set(value) {
            this._stroke = value;
          },
          animatable: false,
          tooltip: false
        },
        _texture: {
          default: null,
          type: cc.Texture2D
        },
        texture: {
          get: function get() {
            return this._texture;
          },
          set: function set(value) {
            if (this._texture === value) return;
            this._texture = value;
            if (value && value.loaded) this._activateMaterial(); else {
              this.disableRender();
              this._ensureLoadTexture();
            }
          },
          type: cc.Texture2D,
          animatable: false,
          tooltip: false
        },
        _color: cc.Color.WHITE,
        color: {
          get: function get() {
            return this._color;
          },
          set: function set(value) {
            this._color = value;
          },
          type: cc.Color,
          tooltip: false
        },
        _fastMode: false,
        fastMode: {
          get: function get() {
            return this._fastMode;
          },
          set: function set(value) {
            this._fastMode = value;
          },
          animatable: false,
          tooltip: false
        }
      },
      onEnable: function onEnable() {
        this._super();
        if (this._texture && this._texture.loaded) this._activateMaterial(); else {
          this.disableRender();
          this._ensureLoadTexture();
        }
        this.reset();
      },
      _ensureLoadTexture: function _ensureLoadTexture() {
        if (this._texture && !this._texture.loaded) {
          var self = this;
          textureUtil.postLoadTexture(this._texture, (function() {
            self._activateMaterial();
          }));
        }
      },
      _activateMaterial: function _activateMaterial() {
        if (!this._texture || !this._texture.loaded) {
          this.disableRender();
          return;
        }
        var material = this.sharedMaterials[0];
        material = material ? Material.getInstantiatedMaterial(material, this) : Material.getInstantiatedBuiltinMaterial("2d-sprite", this);
        material.setProperty("texture", this._texture);
        this.setMaterial(0, material);
        this.markForRender(true);
      },
      onFocusInEditor: false,
      onLostFocusInEditor: false,
      reset: function reset() {
        this._points.length = 0;
        this._assembler._renderData.clear();
        false;
      },
      update: function update(dt) {
        this._assembler.update(this, dt);
      }
    });
    cc.MotionStreak = module.exports = MotionStreak;
  }), {
    "../../core/utils/blend-func": 292,
    "../assets/material/CCMaterial": 76,
    "../components/CCRenderComponent": 107,
    "../utils/texture-util": 307
  } ],
  104: [ (function(require, module, exports) {
    "use strict";
    var SizeMode = cc.Enum({
      Unified: 0,
      Free: 1
    });
    var Direction = cc.Enum({
      Horizontal: 0,
      Vertical: 1
    });
    var EventType = cc.Enum({
      PAGE_TURNING: 0
    });
    var PageView = cc.Class({
      name: "cc.PageView",
      extends: cc.ScrollView,
      editor: false,
      ctor: function ctor() {
        this._curPageIdx = 0;
        this._lastPageIdx = 0;
        this._pages = [];
        this._initContentPos = cc.v2();
        this._scrollCenterOffsetX = [];
        this._scrollCenterOffsetY = [];
      },
      properties: {
        sizeMode: {
          default: SizeMode.Unified,
          type: SizeMode,
          tooltip: false,
          notify: function notify() {
            this._syncSizeMode();
          }
        },
        direction: {
          default: Direction.Horizontal,
          type: Direction,
          tooltip: false,
          notify: function notify() {
            this._syncScrollDirection();
          }
        },
        scrollThreshold: {
          default: .5,
          type: cc.Float,
          slide: true,
          range: [ 0, 1, .01 ],
          tooltip: false
        },
        autoPageTurningThreshold: {
          default: 100,
          type: cc.Float,
          tooltip: false
        },
        pageTurningEventTiming: {
          default: .1,
          type: cc.Float,
          range: [ 0, 1, .01 ],
          tooltip: false
        },
        indicator: {
          default: null,
          type: cc.PageViewIndicator,
          tooltip: false,
          notify: function notify() {
            this.indicator && this.indicator.setPageView(this);
          }
        },
        pageTurningSpeed: {
          default: .3,
          type: cc.Float,
          tooltip: false
        },
        pageEvents: {
          default: [],
          type: cc.Component.EventHandler,
          tooltip: false
        }
      },
      statics: {
        SizeMode: SizeMode,
        Direction: Direction,
        EventType: EventType
      },
      __preload: function __preload() {
        this.node.on(cc.Node.EventType.SIZE_CHANGED, this._updateAllPagesSize, this);
      },
      onEnable: function onEnable() {
        this._super();
        true;
        this.node.on("scroll-ended-with-threshold", this._dispatchPageTurningEvent, this);
      },
      onDisable: function onDisable() {
        this._super();
        true;
        this.node.off("scroll-ended-with-threshold", this._dispatchPageTurningEvent, this);
      },
      onLoad: function onLoad() {
        this._initPages();
        this.indicator && this.indicator.setPageView(this);
      },
      onDestroy: function onDestroy() {
        this.node.off(cc.Node.EventType.SIZE_CHANGED, this._updateAllPagesSize, this);
      },
      getCurrentPageIndex: function getCurrentPageIndex() {
        return this._curPageIdx;
      },
      setCurrentPageIndex: function setCurrentPageIndex(index) {
        this.scrollToPage(index, true);
      },
      getPages: function getPages() {
        return this._pages;
      },
      addPage: function addPage(page) {
        if (!page || -1 !== this._pages.indexOf(page) || !this.content) return;
        this.content.addChild(page);
        this._pages.push(page);
        this._updatePageView();
      },
      insertPage: function insertPage(page, index) {
        if (index < 0 || !page || -1 !== this._pages.indexOf(page) || !this.content) return;
        var pageCount = this._pages.length;
        if (index >= pageCount) this.addPage(page); else {
          this._pages.splice(index, 0, page);
          this.content.addChild(page);
          this._updatePageView();
        }
      },
      removePage: function removePage(page) {
        if (!page || !this.content) return;
        var index = this._pages.indexOf(page);
        if (-1 === index) {
          cc.warnID(4300, page.name);
          return;
        }
        this.removePageAtIndex(index);
      },
      removePageAtIndex: function removePageAtIndex(index) {
        var pageList = this._pages;
        if (index < 0 || index >= pageList.length) return;
        var page = pageList[index];
        if (!page) return;
        this.content.removeChild(page);
        pageList.splice(index, 1);
        this._updatePageView();
      },
      removeAllPages: function removeAllPages() {
        if (!this.content) return;
        var locPages = this._pages;
        for (var i = 0, len = locPages.length; i < len; i++) this.content.removeChild(locPages[i]);
        this._pages.length = 0;
        this._updatePageView();
      },
      scrollToPage: function scrollToPage(idx, timeInSecond) {
        if (idx < 0 || idx >= this._pages.length) return;
        timeInSecond = void 0 !== timeInSecond ? timeInSecond : .3;
        this._curPageIdx = idx;
        this.scrollToOffset(this._moveOffsetValue(idx), timeInSecond, true);
        this.indicator && this.indicator._changedState();
      },
      getScrollEndedEventTiming: function getScrollEndedEventTiming() {
        return this.pageTurningEventTiming;
      },
      _syncScrollDirection: function _syncScrollDirection() {
        this.horizontal = this.direction === Direction.Horizontal;
        this.vertical = this.direction === Direction.Vertical;
      },
      _syncSizeMode: function _syncSizeMode() {
        if (!this.content) return;
        var layout = this.content.getComponent(cc.Layout);
        if (layout) {
          if (this.sizeMode === SizeMode.Free && this._pages.length > 0) {
            var lastPage = this._pages[this._pages.length - 1];
            if (this.direction === Direction.Horizontal) {
              layout.paddingLeft = (this._view.width - this._pages[0].width) / 2;
              layout.paddingRight = (this._view.width - lastPage.width) / 2;
            } else if (this.direction === Direction.Vertical) {
              layout.paddingTop = (this._view.height - this._pages[0].height) / 2;
              layout.paddingBottom = (this._view.height - lastPage.height) / 2;
            }
          }
          layout.updateLayout();
        }
      },
      _updatePageView: function _updatePageView() {
        var layout = this.content.getComponent(cc.Layout);
        layout && layout.enabled && layout.updateLayout();
        var pageCount = this._pages.length;
        if (this._curPageIdx >= pageCount) {
          this._curPageIdx = 0 === pageCount ? 0 : pageCount - 1;
          this._lastPageIdx = this._curPageIdx;
        }
        var contentPos = this._initContentPos;
        for (var i = 0; i < pageCount; ++i) {
          var page = this._pages[i];
          page.setSiblingIndex(i);
          this.direction === Direction.Horizontal ? this._scrollCenterOffsetX[i] = Math.abs(contentPos.x + page.x) : this._scrollCenterOffsetY[i] = Math.abs(contentPos.y + page.y);
        }
        this.indicator && this.indicator._refresh();
      },
      _updateAllPagesSize: function _updateAllPagesSize() {
        if (this.sizeMode !== SizeMode.Unified) return;
        var locPages = this._pages;
        var selfSize = this._view.getContentSize();
        for (var i = 0, len = locPages.length; i < len; i++) locPages[i].setContentSize(selfSize);
      },
      _initPages: function _initPages() {
        if (!this.content) return;
        this._initContentPos = this.content.position;
        var children = this.content.children;
        for (var i = 0; i < children.length; ++i) {
          var page = children[i];
          if (this._pages.indexOf(page) >= 0) continue;
          this._pages.push(page);
        }
        this._syncScrollDirection();
        this._syncSizeMode();
        this._updatePageView();
      },
      _dispatchPageTurningEvent: function _dispatchPageTurningEvent() {
        if (this._lastPageIdx === this._curPageIdx) return;
        this._lastPageIdx = this._curPageIdx;
        cc.Component.EventHandler.emitEvents(this.pageEvents, this, EventType.PAGE_TURNING);
        this.node.emit("page-turning", this);
      },
      _isScrollable: function _isScrollable(offset, index, nextIndex) {
        if (this.sizeMode === SizeMode.Free) {
          var curPageCenter, nextPageCenter;
          if (this.direction === Direction.Horizontal) {
            curPageCenter = this._scrollCenterOffsetX[index];
            nextPageCenter = this._scrollCenterOffsetX[nextIndex];
            return Math.abs(offset.x) >= Math.abs(curPageCenter - nextPageCenter) * this.scrollThreshold;
          }
          if (this.direction === Direction.Vertical) {
            curPageCenter = this._scrollCenterOffsetY[index];
            nextPageCenter = this._scrollCenterOffsetY[nextIndex];
            return Math.abs(offset.y) >= Math.abs(curPageCenter - nextPageCenter) * this.scrollThreshold;
          }
        } else {
          if (this.direction === Direction.Horizontal) return Math.abs(offset.x) >= this._view.width * this.scrollThreshold;
          if (this.direction === Direction.Vertical) return Math.abs(offset.y) >= this._view.height * this.scrollThreshold;
        }
      },
      _isQuicklyScrollable: function _isQuicklyScrollable(touchMoveVelocity) {
        if (this.direction === Direction.Horizontal) {
          if (Math.abs(touchMoveVelocity.x) > this.autoPageTurningThreshold) return true;
        } else if (this.direction === Direction.Vertical && Math.abs(touchMoveVelocity.y) > this.autoPageTurningThreshold) return true;
        return false;
      },
      _moveOffsetValue: function _moveOffsetValue(idx) {
        var offset = cc.v2(0, 0);
        this.sizeMode === SizeMode.Free ? this.direction === Direction.Horizontal ? offset.x = this._scrollCenterOffsetX[idx] : this.direction === Direction.Vertical && (offset.y = this._scrollCenterOffsetY[idx]) : this.direction === Direction.Horizontal ? offset.x = idx * this._view.width : this.direction === Direction.Vertical && (offset.y = idx * this._view.height);
        return offset;
      },
      _getDragDirection: function _getDragDirection(moveOffset) {
        if (this.direction === Direction.Horizontal) {
          if (0 === moveOffset.x) return 0;
          return moveOffset.x > 0 ? 1 : -1;
        }
        if (this.direction === Direction.Vertical) {
          if (0 === moveOffset.y) return 0;
          return moveOffset.y < 0 ? 1 : -1;
        }
      },
      _handleReleaseLogic: function _handleReleaseLogic(touch) {
        this._autoScrollToPage();
        if (this._scrolling) {
          this._scrolling = false;
          this._autoScrolling || this._dispatchEvent("scroll-ended");
        }
      },
      _autoScrollToPage: function _autoScrollToPage() {
        var bounceBackStarted = this._startBounceBackIfNeeded();
        var moveOffset = this._touchBeganPosition.sub(this._touchEndPosition);
        if (bounceBackStarted) {
          var dragDirection = this._getDragDirection(moveOffset);
          if (0 === dragDirection) return;
          this._curPageIdx = dragDirection > 0 ? this._pages.length - 1 : 0;
          this.indicator && this.indicator._changedState();
        } else {
          var index = this._curPageIdx, nextIndex = index + this._getDragDirection(moveOffset);
          var timeInSecond = this.pageTurningSpeed * Math.abs(index - nextIndex);
          if (nextIndex < this._pages.length) {
            if (this._isScrollable(moveOffset, index, nextIndex)) {
              this.scrollToPage(nextIndex, timeInSecond);
              return;
            }
            var touchMoveVelocity = this._calculateTouchMoveVelocity();
            if (this._isQuicklyScrollable(touchMoveVelocity)) {
              this.scrollToPage(nextIndex, timeInSecond);
              return;
            }
          }
          this.scrollToPage(index, timeInSecond);
        }
      },
      _onTouchBegan: function _onTouchBegan(event, captureListeners) {
        this._touchBeganPosition = event.touch.getLocation();
        this._super(event, captureListeners);
      },
      _onTouchMoved: function _onTouchMoved(event, captureListeners) {
        this._super(event, captureListeners);
      },
      _onTouchEnded: function _onTouchEnded(event, captureListeners) {
        this._touchEndPosition = event.touch.getLocation();
        this._super(event, captureListeners);
      },
      _onTouchCancelled: function _onTouchCancelled(event, captureListeners) {
        this._touchEndPosition = event.touch.getLocation();
        this._super(event, captureListeners);
      },
      _onMouseWheel: function _onMouseWheel() {}
    });
    cc.PageView = module.exports = PageView;
  }), {} ],
  105: [ (function(require, module, exports) {
    "use strict";
    var Direction = cc.Enum({
      HORIZONTAL: 0,
      VERTICAL: 1
    });
    var PageViewIndicator = cc.Class({
      name: "cc.PageViewIndicator",
      extends: require("./CCComponent"),
      editor: false,
      properties: {
        _layout: null,
        _pageView: null,
        _indicators: [],
        spriteFrame: {
          default: null,
          type: cc.SpriteFrame,
          tooltip: false
        },
        direction: {
          default: Direction.HORIZONTAL,
          type: Direction,
          tooltip: false
        },
        cellSize: {
          default: cc.size(20, 20),
          tooltip: false
        },
        spacing: {
          default: 0,
          tooltip: false
        }
      },
      statics: {
        Direction: Direction
      },
      onLoad: function onLoad() {
        this._updateLayout();
      },
      setPageView: function setPageView(target) {
        this._pageView = target;
        this._refresh();
      },
      _updateLayout: function _updateLayout() {
        this._layout = this.getComponent(cc.Layout);
        this._layout || (this._layout = this.addComponent(cc.Layout));
        if (this.direction === Direction.HORIZONTAL) {
          this._layout.type = cc.Layout.Type.HORIZONTAL;
          this._layout.spacingX = this.spacing;
        } else if (this.direction === Direction.VERTICAL) {
          this._layout.type = cc.Layout.Type.VERTICAL;
          this._layout.spacingY = this.spacing;
        }
        this._layout.resizeMode = cc.Layout.ResizeMode.CONTAINER;
      },
      _createIndicator: function _createIndicator() {
        var node = new cc.Node();
        var sprite = node.addComponent(cc.Sprite);
        sprite.spriteFrame = this.spriteFrame;
        node.parent = this.node;
        node.width = this.cellSize.width;
        node.height = this.cellSize.height;
        return node;
      },
      _changedState: function _changedState() {
        var indicators = this._indicators;
        if (0 === indicators.length) return;
        var idx = this._pageView._curPageIdx;
        if (idx >= indicators.length) return;
        for (var i = 0; i < indicators.length; ++i) {
          var node = indicators[i];
          node.opacity = 127.5;
        }
        indicators[idx].opacity = 255;
      },
      _refresh: function _refresh() {
        if (!this._pageView) return;
        var indicators = this._indicators;
        var pages = this._pageView.getPages();
        if (pages.length === indicators.length) return;
        var i = 0;
        if (pages.length > indicators.length) for (i = 0; i < pages.length; ++i) indicators[i] || (indicators[i] = this._createIndicator()); else {
          var count = indicators.length - pages.length;
          for (i = count; i > 0; --i) {
            var node = indicators[i - 1];
            this.node.removeChild(node);
            indicators.splice(i - 1, 1);
          }
        }
        this._layout && this._layout.enabledInHierarchy && this._layout.updateLayout();
        this._changedState();
      }
    });
    cc.PageViewIndicator = module.exports = PageViewIndicator;
  }), {
    "./CCComponent": 96
  } ],
  106: [ (function(require, module, exports) {
    "use strict";
    var misc = require("../utils/misc");
    var Component = require("./CCComponent");
    var Mode = cc.Enum({
      HORIZONTAL: 0,
      VERTICAL: 1,
      FILLED: 2
    });
    var ProgressBar = cc.Class({
      name: "cc.ProgressBar",
      extends: Component,
      editor: false,
      _initBarSprite: function _initBarSprite() {
        if (this.barSprite) {
          var entity = this.barSprite.node;
          if (!entity) return;
          var nodeSize = this.node.getContentSize();
          var nodeAnchor = this.node.getAnchorPoint();
          var entitySize = entity.getContentSize();
          entity.parent === this.node && this.node.setContentSize(entitySize);
          this.barSprite.fillType === cc.Sprite.FillType.RADIAL && (this.mode = Mode.FILLED);
          var barSpriteSize = entity.getContentSize();
          this.mode === Mode.HORIZONTAL ? this.totalLength = barSpriteSize.width : this.mode === Mode.VERTICAL ? this.totalLength = barSpriteSize.height : this.totalLength = this.barSprite.fillRange;
          if (entity.parent === this.node) {
            var x = -nodeSize.width * nodeAnchor.x;
            var y = 0;
            entity.setPosition(cc.v2(x, y));
          }
        }
      },
      _updateBarStatus: function _updateBarStatus() {
        if (this.barSprite) {
          var entity = this.barSprite.node;
          if (!entity) return;
          var entityAnchorPoint = entity.getAnchorPoint();
          var entitySize = entity.getContentSize();
          var entityPosition = entity.getPosition();
          var anchorPoint = cc.v2(0, .5);
          var progress = misc.clamp01(this.progress);
          var actualLenth = this.totalLength * progress;
          var finalContentSize;
          var totalWidth;
          var totalHeight;
          switch (this.mode) {
           case Mode.HORIZONTAL:
            this.reverse && (anchorPoint = cc.v2(1, .5));
            finalContentSize = cc.size(actualLenth, entitySize.height);
            totalWidth = this.totalLength;
            totalHeight = entitySize.height;
            break;

           case Mode.VERTICAL:
            anchorPoint = this.reverse ? cc.v2(.5, 1) : cc.v2(.5, 0);
            finalContentSize = cc.size(entitySize.width, actualLenth);
            totalWidth = entitySize.width;
            totalHeight = this.totalLength;
          }
          if (this.mode === Mode.FILLED) if (this.barSprite.type !== cc.Sprite.Type.FILLED) cc.warn("ProgressBar FILLED mode only works when barSprite's Type is FILLED!"); else {
            this.reverse && (actualLenth *= -1);
            this.barSprite.fillRange = actualLenth;
          } else if (this.barSprite.type !== cc.Sprite.Type.FILLED) {
            var anchorOffsetX = anchorPoint.x - entityAnchorPoint.x;
            var anchorOffsetY = anchorPoint.y - entityAnchorPoint.y;
            var finalPosition = cc.v2(totalWidth * anchorOffsetX, totalHeight * anchorOffsetY);
            entity.setPosition(entityPosition.x + finalPosition.x, entityPosition.y + finalPosition.y);
            entity.setAnchorPoint(anchorPoint);
            entity.setContentSize(finalContentSize);
          } else cc.warn("ProgressBar non-FILLED mode only works when barSprite's Type is non-FILLED!");
        }
      },
      properties: {
        barSprite: {
          default: null,
          type: cc.Sprite,
          tooltip: false,
          notify: function notify() {
            this._initBarSprite();
          },
          animatable: false
        },
        mode: {
          default: Mode.HORIZONTAL,
          type: Mode,
          tooltip: false,
          notify: function notify() {
            if (this.barSprite) {
              var entity = this.barSprite.node;
              if (!entity) return;
              var entitySize = entity.getContentSize();
              this.mode === Mode.HORIZONTAL ? this.totalLength = entitySize.width : this.mode === Mode.VERTICAL ? this.totalLength = entitySize.height : this.mode === Mode.FILLED && (this.totalLength = this.barSprite.fillRange);
            }
          },
          animatable: false
        },
        _N$totalLength: 1,
        totalLength: {
          range: [ 0, Number.MAX_VALUE ],
          tooltip: false,
          get: function get() {
            return this._N$totalLength;
          },
          set: function set(value) {
            this.mode === Mode.FILLED && (value = misc.clamp01(value));
            this._N$totalLength = value;
            this._updateBarStatus();
          }
        },
        progress: {
          default: 1,
          type: cc.Float,
          range: [ 0, 1, .1 ],
          slide: true,
          tooltip: false,
          notify: function notify() {
            this._updateBarStatus();
          }
        },
        reverse: {
          default: false,
          tooltip: false,
          notify: function notify() {
            this.barSprite && (this.barSprite.fillStart = 1 - this.barSprite.fillStart);
            this._updateBarStatus();
          },
          animatable: false
        }
      },
      statics: {
        Mode: Mode
      }
    });
    cc.ProgressBar = module.exports = ProgressBar;
  }), {
    "../utils/misc": 299,
    "./CCComponent": 96
  } ],
  107: [ (function(require, module, exports) {
    "use strict";
    var _assembler = require("../renderer/assembler");
    var _assembler2 = _interopRequireDefault(_assembler);
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : {
        default: obj
      };
    }
    var Component = require("./CCComponent");
    var RenderFlow = require("../renderer/render-flow");
    var Material = require("../assets/material/CCMaterial");
    var RenderComponent = cc.Class({
      name: "RenderComponent",
      extends: Component,
      editor: false,
      properties: {
        _materials: {
          default: [],
          type: Material
        },
        sharedMaterials: {
          get: function get() {
            return this._materials;
          },
          set: function set(val) {
            this._materials = val;
            this._activateMaterial(true);
          },
          type: [ Material ],
          displayName: "Materials",
          animatable: false
        }
      },
      ctor: function ctor() {
        this._vertsDirty = true;
        this._material = null;
        this._assembler = null;
      },
      _resetAssembler: function _resetAssembler() {
        this.setVertsDirty(true);
        _assembler2.default.init(this);
        this._updateColor();
      },
      __preload: function __preload() {
        this._resetAssembler();
      },
      onEnable: function onEnable() {
        this.node._renderComponent && (this.node._renderComponent.enabled = false);
        this.node._renderComponent = this;
        this.node.on(cc.Node.EventType.SIZE_CHANGED, this._onNodeSizeDirty, this);
        this.node.on(cc.Node.EventType.ANCHOR_CHANGED, this._onNodeSizeDirty, this);
        this.node._renderFlag |= RenderFlow.FLAG_RENDER | RenderFlow.FLAG_UPDATE_RENDER_DATA | RenderFlow.FLAG_OPACITY_COLOR;
      },
      onDisable: function onDisable() {
        this.node._renderComponent = null;
        this.node.off(cc.Node.EventType.SIZE_CHANGED, this._onNodeSizeDirty, this);
        this.node.off(cc.Node.EventType.ANCHOR_CHANGED, this._onNodeSizeDirty, this);
        this.disableRender();
      },
      onDestroy: function onDestroy() {
        var materials = this._materials;
        for (var i = 0; i < materials.length; i++) cc.pool.material.put(materials[i]);
        materials.length = 0;
        cc.pool.assembler.put(this._assembler);
      },
      setVertsDirty: function setVertsDirty() {
        this._vertsDirty = true;
        this.markForUpdateRenderData(true);
      },
      _onNodeSizeDirty: function _onNodeSizeDirty() {
        this.setVertsDirty();
      },
      _on3DNodeChanged: function _on3DNodeChanged() {
        this.setVertsDirty();
      },
      _canRender: function _canRender() {
        return this._enabled && this.node._activeInHierarchy;
      },
      markForUpdateRenderData: function markForUpdateRenderData(enable) {
        enable && this._canRender() ? this.node._renderFlag |= RenderFlow.FLAG_UPDATE_RENDER_DATA : enable || (this.node._renderFlag &= ~RenderFlow.FLAG_UPDATE_RENDER_DATA);
      },
      markForRender: function markForRender(enable) {
        enable && this._canRender() ? this.node._renderFlag |= RenderFlow.FLAG_RENDER : enable || (this.node._renderFlag &= ~RenderFlow.FLAG_RENDER);
      },
      disableRender: function disableRender() {
        this.node._renderFlag &= ~(RenderFlow.FLAG_RENDER | RenderFlow.FLAG_UPDATE_RENDER_DATA);
      },
      getMaterial: function getMaterial(index) {
        if (index < 0 || index >= this._materials.length) return null;
        var material = this._materials[index];
        if (!material) return null;
        var instantiated = Material.getInstantiatedMaterial(material, this);
        instantiated !== material && this.setMaterial(index, instantiated);
        return this._materials[index];
      },
      setMaterial: function setMaterial(index, material) {
        this._materials[index] = material;
        material && this.markForUpdateRenderData(true);
      },
      _activateMaterial: function _activateMaterial(force) {},
      _updateColor: function _updateColor() {
        this._assembler.updateColor && this._assembler.updateColor(this);
      },
      _checkBacth: function _checkBacth(renderer, cullingMask) {
        var material = this.sharedMaterials[0];
        if (material && material.getHash() !== renderer.material.getHash() || renderer.cullingMask !== cullingMask) {
          renderer._flush();
          renderer.node = material.getDefine("CC_USE_MODEL") ? this.node : renderer._dummyNode;
          renderer.material = material;
          renderer.cullingMask = cullingMask;
        }
      }
    });
    cc.RenderComponent = module.exports = RenderComponent;
  }), {
    "../assets/material/CCMaterial": 76,
    "../renderer/assembler": 228,
    "../renderer/render-flow": 249,
    "./CCComponent": 96
  } ],
  108: [ (function(require, module, exports) {
    "use strict";
    var js = require("../platform/js");
    var macro = require("../platform/CCMacro");
    var textUtils = require("../utils/text-utils");
    var HtmlTextParser = require("../utils/html-text-parser");
    var _htmlTextParser = new HtmlTextParser();
    var HorizontalAlign = macro.TextAlignment;
    var VerticalAlign = macro.VerticalTextAlignment;
    var RichTextChildName = "RICHTEXT_CHILD";
    var RichTextChildImageName = "RICHTEXT_Image_CHILD";
    function debounce(func, wait, immediate) {
      var timeout = void 0;
      return function() {
        var context = this;
        var later = function later() {
          timeout = null;
          immediate || func.apply(context, arguments);
        };
        var callNow = immediate && !timeout;
        clearTimeout(timeout);
        timeout = setTimeout(later, wait);
        callNow && func.apply(context, arguments);
      };
    }
    var pool = new js.Pool(function(node) {
      false;
      false;
      if (!cc.isValid(node)) return false;
      var outline = node.getComponent(cc.LabelOutline);
      outline && (outline.width = 0);
      return true;
    }, 20);
    pool.get = function(string, richtext) {
      var labelNode = this._get();
      labelNode || (labelNode = new cc.PrivateNode(RichTextChildName));
      var labelComponent = labelNode.getComponent(cc.Label);
      labelComponent || (labelComponent = labelNode.addComponent(cc.Label));
      labelNode.setPosition(0, 0);
      labelNode.setAnchorPoint(.5, .5);
      labelNode.setContentSize(128, 128);
      labelNode.skewX = 0;
      "string" !== typeof string && (string = "" + string);
      var isAsset = richtext.font instanceof cc.Font;
      isAsset ? labelComponent.font = richtext.font : labelComponent.fontFamily = richtext.fontFamily;
      labelComponent.string = string;
      labelComponent.horizontalAlign = HorizontalAlign.LEFT;
      labelComponent.verticalAlign = VerticalAlign.TOP;
      labelComponent.fontSize = richtext.fontSize || 40;
      labelComponent.overflow = 0;
      labelComponent.enableWrapText = true;
      labelComponent.lineHeight = 40;
      labelComponent._enableBold(false);
      labelComponent._enableItalics(false);
      labelComponent._enableUnderline(false);
      return labelNode;
    };
    var RichText = cc.Class({
      name: "cc.RichText",
      extends: cc.Component,
      ctor: function ctor() {
        this._textArray = null;
        this._labelSegments = [];
        this._labelSegmentsCache = [];
        this._linesWidth = [];
        false;
        this._updateRichTextStatus = this._updateRichText;
      },
      editor: false,
      properties: {
        string: {
          default: "<color=#00ff00>Rich</c><color=#0fffff>Text</color>",
          multiline: true,
          tooltip: false,
          notify: function notify() {
            this._updateRichTextStatus();
          }
        },
        horizontalAlign: {
          default: HorizontalAlign.LEFT,
          type: HorizontalAlign,
          tooltip: false,
          animatable: false,
          notify: function notify(oldValue) {
            if (this.horizontalAlign === oldValue) return;
            this._layoutDirty = true;
            this._updateRichTextStatus();
          }
        },
        fontSize: {
          default: 40,
          tooltip: false,
          notify: function notify(oldValue) {
            if (this.fontSize === oldValue) return;
            this._layoutDirty = true;
            this._updateRichTextStatus();
          }
        },
        _fontFamily: "Arial",
        fontFamily: {
          tooltip: false,
          get: function get() {
            return this._fontFamily;
          },
          set: function set(value) {
            if (this._fontFamily === value) return;
            this._fontFamily = value;
            this._layoutDirty = true;
            this._updateRichTextStatus();
          },
          animatable: false
        },
        font: {
          default: null,
          type: cc.TTFFont,
          tooltip: false,
          notify: function notify(oldValue) {
            if (this.font === oldValue) return;
            this._layoutDirty = true;
            if (this.font) {
              false;
              this.useSystemFont = false;
              this._onTTFLoaded();
            } else this.useSystemFont = true;
            this._updateRichTextStatus();
          }
        },
        _isSystemFontUsed: true,
        useSystemFont: {
          get: function get() {
            return this._isSystemFontUsed;
          },
          set: function set(value) {
            if (this._isSystemFontUsed === value) return;
            this._isSystemFontUsed = value;
            false;
            this._layoutDirty = true;
            this._updateRichTextStatus();
          },
          animatable: false,
          tooltip: false
        },
        maxWidth: {
          default: 0,
          tooltip: false,
          notify: function notify(oldValue) {
            if (this.maxWidth === oldValue) return;
            this._layoutDirty = true;
            this._updateRichTextStatus();
          }
        },
        lineHeight: {
          default: 40,
          tooltip: false,
          notify: function notify(oldValue) {
            if (this.lineHeight === oldValue) return;
            this._layoutDirty = true;
            this._updateRichTextStatus();
          }
        },
        imageAtlas: {
          default: null,
          type: cc.SpriteAtlas,
          tooltip: false,
          notify: function notify(oldValue) {
            if (this.imageAtlas === oldValue) return;
            this._layoutDirty = true;
            this._updateRichTextStatus();
          }
        },
        handleTouchEvent: {
          default: true,
          tooltip: false,
          notify: function notify(oldValue) {
            if (this.handleTouchEvent === oldValue) return;
            this.enabledInHierarchy && (this.handleTouchEvent ? this._addEventListeners() : this._removeEventListeners());
          }
        }
      },
      statics: {
        HorizontalAlign: HorizontalAlign,
        VerticalAlign: VerticalAlign
      },
      onEnable: function onEnable() {
        this.handleTouchEvent && this._addEventListeners();
        this._updateRichText();
        this._activateChildren(true);
      },
      onDisable: function onDisable() {
        this.handleTouchEvent && this._removeEventListeners();
        this._activateChildren(false);
      },
      start: function start() {
        this._onTTFLoaded();
      },
      _onColorChanged: function _onColorChanged(parentColor) {
        var children = this.node.children;
        children.forEach((function(childNode) {
          childNode.color = parentColor;
        }));
      },
      _addEventListeners: function _addEventListeners() {
        this.node.on(cc.Node.EventType.TOUCH_END, this._onTouchEnded, this);
        this.node.on(cc.Node.EventType.COLOR_CHANGED, this._onColorChanged, this);
      },
      _removeEventListeners: function _removeEventListeners() {
        this.node.off(cc.Node.EventType.TOUCH_END, this._onTouchEnded, this);
        this.node.off(cc.Node.EventType.COLOR_CHANGED, this._onColorChanged, this);
      },
      _updateLabelSegmentTextAttributes: function _updateLabelSegmentTextAttributes() {
        this._labelSegments.forEach(function(item) {
          this._applyTextAttribute(item);
        }.bind(this));
      },
      _createFontLabel: function _createFontLabel(string) {
        return pool.get(string, this);
      },
      _onTTFLoaded: function _onTTFLoaded() {
        if (this.font instanceof cc.TTFFont) if (this.font._nativeAsset) {
          this._layoutDirty = true;
          this._updateRichText();
        } else {
          var self = this;
          cc.loader.load(this.font.nativeUrl, (function(err, fontFamily) {
            self._layoutDirty = true;
            self._updateRichText();
          }));
        } else {
          this._layoutDirty = true;
          this._updateRichText();
        }
      },
      _measureText: function _measureText(styleIndex, string) {
        var self = this;
        var func = function func(string) {
          var label = void 0;
          if (0 === self._labelSegmentsCache.length) {
            label = self._createFontLabel(string);
            self._labelSegmentsCache.push(label);
          } else {
            label = self._labelSegmentsCache[0];
            label.getComponent(cc.Label).string = string;
          }
          label._styleIndex = styleIndex;
          self._applyTextAttribute(label);
          var labelSize = label.getContentSize();
          return labelSize.width;
        };
        return string ? func(string) : func;
      },
      _onTouchEnded: function _onTouchEnded(event) {
        var _this = this;
        var components = this.node.getComponents(cc.Component);
        var _loop = function _loop(i) {
          var labelSegment = _this._labelSegments[i];
          var clickHandler = labelSegment._clickHandler;
          var clickParam = labelSegment._clickParam;
          if (clickHandler && _this._containsTouchLocation(labelSegment, event.touch.getLocation())) {
            components.forEach((function(component) {
              component.enabledInHierarchy && component[clickHandler] && component[clickHandler](event, clickParam);
            }));
            event.stopPropagation();
          }
        };
        for (var i = 0; i < this._labelSegments.length; ++i) _loop(i);
      },
      _containsTouchLocation: function _containsTouchLocation(label, point) {
        var myRect = label.getBoundingBoxToWorld();
        return myRect.contains(point);
      },
      _resetState: function _resetState() {
        var children = this.node.children;
        for (var i = children.length - 1; i >= 0; i--) {
          var child = children[i];
          if (child.name === RichTextChildName || child.name === RichTextChildImageName) {
            child.parent === this.node ? child.parent = null : children.splice(i, 1);
            child.name === RichTextChildName && pool.put(child);
          }
        }
        this._labelSegments.length = 0;
        this._labelSegmentsCache.length = 0;
        this._linesWidth.length = 0;
        this._lineOffsetX = 0;
        this._lineCount = 1;
        this._labelWidth = 0;
        this._labelHeight = 0;
        this._layoutDirty = true;
      },
      onRestore: false,
      _activateChildren: function _activateChildren(active) {
        for (var i = this.node.children.length - 1; i >= 0; i--) {
          var child = this.node.children[i];
          child.name !== RichTextChildName && child.name !== RichTextChildImageName || (child.active = active);
        }
      },
      _addLabelSegment: function _addLabelSegment(stringToken, styleIndex) {
        var labelSegment = void 0;
        if (0 === this._labelSegmentsCache.length) labelSegment = this._createFontLabel(stringToken); else {
          labelSegment = this._labelSegmentsCache.pop();
          labelSegment.getComponent(cc.Label).string = stringToken;
        }
        labelSegment._styleIndex = styleIndex;
        labelSegment._lineCount = this._lineCount;
        labelSegment.active = this.node.active;
        labelSegment.setAnchorPoint(0, 0);
        this._applyTextAttribute(labelSegment);
        this.node.addChild(labelSegment);
        this._labelSegments.push(labelSegment);
        return labelSegment;
      },
      _updateRichTextWithMaxWidth: function _updateRichTextWithMaxWidth(labelString, labelWidth, styleIndex) {
        var fragmentWidth = labelWidth;
        var labelSegment = void 0;
        if (this._lineOffsetX > 0 && fragmentWidth + this._lineOffsetX > this.maxWidth) {
          var checkStartIndex = 0;
          while (this._lineOffsetX <= this.maxWidth) {
            var checkEndIndex = this._getFirstWordLen(labelString, checkStartIndex, labelString.length);
            var checkString = labelString.substr(checkStartIndex, checkEndIndex);
            var checkStringWidth = this._measureText(styleIndex, checkString);
            if (!(this._lineOffsetX + checkStringWidth <= this.maxWidth)) {
              if (checkStartIndex > 0) {
                var remainingString = labelString.substr(0, checkStartIndex);
                this._addLabelSegment(remainingString, styleIndex);
                labelString = labelString.substr(checkStartIndex, labelString.length);
                fragmentWidth = this._measureText(styleIndex, labelString);
              }
              this._updateLineInfo();
              break;
            }
            this._lineOffsetX += checkStringWidth;
            checkStartIndex += checkEndIndex;
          }
        }
        if (fragmentWidth > this.maxWidth) {
          var fragments = textUtils.fragmentText(labelString, fragmentWidth, this.maxWidth, this._measureText(styleIndex));
          for (var k = 0; k < fragments.length; ++k) {
            var splitString = fragments[k];
            labelSegment = this._addLabelSegment(splitString, styleIndex);
            var labelSize = labelSegment.getContentSize();
            this._lineOffsetX += labelSize.width;
            fragments.length > 1 && k < fragments.length - 1 && this._updateLineInfo();
          }
        } else {
          this._lineOffsetX += fragmentWidth;
          this._addLabelSegment(labelString, styleIndex);
        }
      },
      _isLastComponentCR: function _isLastComponentCR(stringToken) {
        return stringToken.length - 1 === stringToken.lastIndexOf("\n");
      },
      _updateLineInfo: function _updateLineInfo() {
        this._linesWidth.push(this._lineOffsetX);
        this._lineOffsetX = 0;
        this._lineCount++;
      },
      _needsUpdateTextLayout: function _needsUpdateTextLayout(newTextArray) {
        if (this._layoutDirty || !this._textArray || !newTextArray) return true;
        if (this._textArray.length !== newTextArray.length) return true;
        for (var i = 0; i < this._textArray.length; ++i) {
          var oldItem = this._textArray[i];
          var newItem = newTextArray[i];
          if (oldItem.text !== newItem.text) return true;
          if (oldItem.style) {
            if (newItem.style) {
              if (!!newItem.style.outline !== !!oldItem.style.outline) return true;
              if (oldItem.style.size !== newItem.style.size || oldItem.style.italic !== newItem.style.italic || oldItem.style.isImage !== newItem.style.isImage) return true;
              if (oldItem.style.isImage === newItem.style.isImage && oldItem.style.src !== newItem.style.src) return true;
            } else if (oldItem.style.size || oldItem.style.italic || oldItem.style.isImage || oldItem.style.outline) return true;
          } else if (newItem.style && (newItem.style.size || newItem.style.italic || newItem.style.isImage || newItem.style.outline)) return true;
        }
        return false;
      },
      _addRichTextImageElement: function _addRichTextImageElement(richTextElement) {
        var spriteFrameName = richTextElement.style.src;
        var spriteFrame = this.imageAtlas.getSpriteFrame(spriteFrameName);
        if (spriteFrame) {
          var spriteNode = new cc.PrivateNode(RichTextChildImageName);
          var spriteComponent = spriteNode.addComponent(cc.Sprite);
          spriteNode.setAnchorPoint(0, 0);
          spriteComponent.type = cc.Sprite.Type.SLICED;
          spriteComponent.sizeMode = cc.Sprite.SizeMode.CUSTOM;
          this.node.addChild(spriteNode);
          this._labelSegments.push(spriteNode);
          var spriteRect = spriteFrame.getRect();
          var scaleFactor = 1;
          var spriteWidth = spriteRect.width;
          var spriteHeight = spriteRect.height;
          var expectWidth = richTextElement.style.imageWidth;
          var expectHeight = richTextElement.style.imageHeight;
          if (expectHeight > 0 && expectHeight < this.lineHeight) {
            scaleFactor = expectHeight / spriteHeight;
            spriteWidth *= scaleFactor;
            spriteHeight *= scaleFactor;
          } else {
            scaleFactor = this.lineHeight / spriteHeight;
            spriteWidth *= scaleFactor;
            spriteHeight *= scaleFactor;
          }
          expectWidth > 0 && (spriteWidth = expectWidth);
          if (this.maxWidth > 0) {
            this._lineOffsetX + spriteWidth > this.maxWidth && this._updateLineInfo();
            this._lineOffsetX += spriteWidth;
          } else {
            this._lineOffsetX += spriteWidth;
            this._lineOffsetX > this._labelWidth && (this._labelWidth = this._lineOffsetX);
          }
          spriteComponent.spriteFrame = spriteFrame;
          spriteNode.setContentSize(spriteWidth, spriteHeight);
          spriteNode._lineCount = this._lineCount;
          if (richTextElement.style.event) {
            richTextElement.style.event.click && (spriteNode._clickHandler = richTextElement.style.event.click);
            richTextElement.style.event.param ? spriteNode._clickParam = richTextElement.style.event.param : spriteNode._clickParam = "";
          } else spriteNode._clickHandler = null;
        } else cc.warnID(4400);
      },
      _updateRichText: function _updateRichText() {
        if (!this.enabled) return;
        var newTextArray = _htmlTextParser.parse(this.string);
        if (!this._needsUpdateTextLayout(newTextArray)) {
          this._textArray = newTextArray;
          this._updateLabelSegmentTextAttributes();
          return;
        }
        this._textArray = newTextArray;
        this._resetState();
        var lastEmptyLine = false;
        var label = void 0;
        var labelSize = void 0;
        for (var i = 0; i < this._textArray.length; ++i) {
          var richTextElement = this._textArray[i];
          var text = richTextElement.text;
          if ("" === text) {
            if (richTextElement.style && richTextElement.style.newline) {
              this._updateLineInfo();
              continue;
            }
            if (richTextElement.style && richTextElement.style.isImage && this.imageAtlas) {
              this._addRichTextImageElement(richTextElement);
              continue;
            }
          }
          var multilineTexts = text.split("\n");
          for (var j = 0; j < multilineTexts.length; ++j) {
            var labelString = multilineTexts[j];
            if ("" === labelString) {
              if (this._isLastComponentCR(text) && j === multilineTexts.length - 1) continue;
              this._updateLineInfo();
              lastEmptyLine = true;
              continue;
            }
            lastEmptyLine = false;
            if (this.maxWidth > 0) {
              var labelWidth = this._measureText(i, labelString);
              this._updateRichTextWithMaxWidth(labelString, labelWidth, i);
              multilineTexts.length > 1 && j < multilineTexts.length - 1 && this._updateLineInfo();
            } else {
              label = this._addLabelSegment(labelString, i);
              labelSize = label.getContentSize();
              this._lineOffsetX += labelSize.width;
              this._lineOffsetX > this._labelWidth && (this._labelWidth = this._lineOffsetX);
              multilineTexts.length > 1 && j < multilineTexts.length - 1 && this._updateLineInfo();
            }
          }
        }
        lastEmptyLine || this._linesWidth.push(this._lineOffsetX);
        this.maxWidth > 0 && (this._labelWidth = this.maxWidth);
        this._labelHeight = (this._lineCount + textUtils.BASELINE_RATIO) * this.lineHeight;
        this.node.setContentSize(this._labelWidth, this._labelHeight);
        this._updateRichTextPosition();
        this._layoutDirty = false;
      },
      _getFirstWordLen: function _getFirstWordLen(text, startIndex, textLen) {
        var character = text.charAt(startIndex);
        if (textUtils.isUnicodeCJK(character) || textUtils.isUnicodeSpace(character)) return 1;
        var len = 1;
        for (var index = startIndex + 1; index < textLen; ++index) {
          character = text.charAt(index);
          if (textUtils.isUnicodeSpace(character) || textUtils.isUnicodeCJK(character)) break;
          len++;
        }
        return len;
      },
      _updateRichTextPosition: function _updateRichTextPosition() {
        var nextTokenX = 0;
        var nextLineIndex = 1;
        var totalLineCount = this._lineCount;
        for (var i = 0; i < this._labelSegments.length; ++i) {
          var label = this._labelSegments[i];
          var lineCount = label._lineCount;
          if (lineCount > nextLineIndex) {
            nextTokenX = 0;
            nextLineIndex = lineCount;
          }
          var lineOffsetX = 0;
          switch (this.horizontalAlign) {
           case HorizontalAlign.LEFT:
            lineOffsetX = -this._labelWidth / 2;
            break;

           case HorizontalAlign.CENTER:
            lineOffsetX = -this._linesWidth[lineCount - 1] / 2;
            break;

           case HorizontalAlign.RIGHT:
            lineOffsetX = this._labelWidth / 2 - this._linesWidth[lineCount - 1];
          }
          label.x = nextTokenX + lineOffsetX;
          var labelSize = label.getContentSize();
          label.y = this.lineHeight * (totalLineCount - lineCount) - this._labelHeight / 2;
          lineCount === nextLineIndex && (nextTokenX += labelSize.width);
        }
      },
      _convertLiteralColorValue: function _convertLiteralColorValue(color) {
        var colorValue = color.toUpperCase();
        if (cc.Color[colorValue]) return cc.Color[colorValue];
        var out = cc.color();
        return out.fromHEX(color);
      },
      _applyTextAttribute: function _applyTextAttribute(labelNode) {
        var labelComponent = labelNode.getComponent(cc.Label);
        if (!labelComponent) return;
        var index = labelNode._styleIndex;
        this._isSystemFontUsed && (labelComponent.fontFamily = this._fontFamily);
        labelComponent.useSystemFont = this._isSystemFontUsed;
        labelComponent.lineHeight = this.lineHeight;
        labelComponent.horizontalAlign = HorizontalAlign.LEFT;
        labelComponent.verticalAlign = VerticalAlign.CENTER;
        var textStyle = null;
        this._textArray[index] && (textStyle = this._textArray[index].style);
        textStyle && textStyle.color ? labelNode.color = this._convertLiteralColorValue(textStyle.color) : labelNode.color = this.node.color;
        labelComponent._enableBold(textStyle && textStyle.bold);
        labelComponent._enableItalics(textStyle && textStyle.italic);
        textStyle && textStyle.italic && (labelNode.skewX = 12);
        labelComponent._enableUnderline(textStyle && textStyle.underline);
        if (textStyle && textStyle.outline) {
          var labelOutlineComponent = labelNode.getComponent(cc.LabelOutline);
          labelOutlineComponent || (labelOutlineComponent = labelNode.addComponent(cc.LabelOutline));
          labelOutlineComponent.color = this._convertLiteralColorValue(textStyle.outline.color);
          labelOutlineComponent.width = textStyle.outline.width;
        }
        textStyle && textStyle.size ? labelComponent.fontSize = textStyle.size : labelComponent.fontSize = this.fontSize;
        labelComponent._forceUpdateRenderData();
        if (textStyle && textStyle.event) {
          textStyle.event.click && (labelNode._clickHandler = textStyle.event.click);
          textStyle.event.param ? labelNode._clickParam = textStyle.event.param : labelNode._clickParam = "";
        } else labelNode._clickHandler = null;
      },
      onDestroy: function onDestroy() {
        for (var i = 0; i < this._labelSegments.length; ++i) {
          this._labelSegments[i].removeFromParent();
          pool.put(this._labelSegments[i]);
        }
      }
    });
    cc.RichText = module.exports = RichText;
  }), {
    "../platform/CCMacro": 204,
    "../platform/js": 219,
    "../utils/html-text-parser": 296,
    "../utils/text-utils": 306
  } ],
  109: [ (function(require, module, exports) {
    "use strict";
    var misc = require("../utils/misc");
    var Component = require("./CCComponent");
    var GETTINGSHORTERFACTOR = 20;
    var Direction = cc.Enum({
      HORIZONTAL: 0,
      VERTICAL: 1
    });
    var Scrollbar = cc.Class({
      name: "cc.Scrollbar",
      extends: require("./CCComponent"),
      editor: false,
      properties: {
        _scrollView: null,
        _touching: false,
        _autoHideRemainingTime: {
          default: 0,
          serializable: false
        },
        _opacity: 255,
        handle: {
          default: null,
          type: cc.Sprite,
          tooltip: false,
          notify: function notify() {
            this._onScroll(cc.v2(0, 0));
          },
          animatable: false
        },
        direction: {
          default: Direction.HORIZONTAL,
          type: Direction,
          tooltip: false,
          notify: function notify() {
            this._onScroll(cc.v2(0, 0));
          },
          animatable: false
        },
        enableAutoHide: {
          default: true,
          animatable: false,
          tooltip: false
        },
        autoHideTime: {
          default: 1,
          animatable: false,
          tooltip: false
        }
      },
      statics: {
        Direction: Direction
      },
      setTargetScrollView: function setTargetScrollView(scrollView) {
        this._scrollView = scrollView;
      },
      _convertToScrollViewSpace: function _convertToScrollViewSpace(content) {
        var scrollViewNode = this._scrollView.node;
        var worldSpacePos = content.convertToWorldSpaceAR(cc.v2(-content.anchorX * content.width, -content.anchorY * content.height));
        var scrollViewSpacePos = scrollViewNode.convertToNodeSpaceAR(worldSpacePos);
        scrollViewSpacePos.x += scrollViewNode.anchorX * scrollViewNode.width;
        scrollViewSpacePos.y += scrollViewNode.anchorY * scrollViewNode.height;
        return scrollViewSpacePos;
      },
      _setOpacity: function _setOpacity(opacity) {
        if (this.handle) {
          this.node.opacity = opacity;
          this.handle.node.opacity = opacity;
        }
      },
      _onScroll: function _onScroll(outOfBoundary) {
        if (this._scrollView) {
          var content = this._scrollView.content;
          if (content) {
            var contentSize = content.getContentSize();
            var scrollViewSize = this._scrollView.node.getContentSize();
            var handleNodeSize = this.node.getContentSize();
            if (this._conditionalDisableScrollBar(contentSize, scrollViewSize)) return;
            if (this.enableAutoHide) {
              this._autoHideRemainingTime = this.autoHideTime;
              this._setOpacity(this._opacity);
            }
            var contentMeasure = 0;
            var scrollViewMeasure = 0;
            var outOfBoundaryValue = 0;
            var contentPosition = 0;
            var handleNodeMeasure = 0;
            if (this.direction === Direction.HORIZONTAL) {
              contentMeasure = contentSize.width;
              scrollViewMeasure = scrollViewSize.width;
              handleNodeMeasure = handleNodeSize.width;
              outOfBoundaryValue = outOfBoundary.x;
              contentPosition = -this._convertToScrollViewSpace(content).x;
            } else if (this.direction === Direction.VERTICAL) {
              contentMeasure = contentSize.height;
              scrollViewMeasure = scrollViewSize.height;
              handleNodeMeasure = handleNodeSize.height;
              outOfBoundaryValue = outOfBoundary.y;
              contentPosition = -this._convertToScrollViewSpace(content).y;
            }
            var length = this._calculateLength(contentMeasure, scrollViewMeasure, handleNodeMeasure, outOfBoundaryValue);
            var position = this._calculatePosition(contentMeasure, scrollViewMeasure, handleNodeMeasure, contentPosition, outOfBoundaryValue, length);
            this._updateLength(length);
            this._updateHanlderPosition(position);
          }
        }
      },
      _updateHanlderPosition: function _updateHanlderPosition(position) {
        if (this.handle) {
          var oldPosition = this._fixupHandlerPosition();
          this.handle.node.setPosition(position.x + oldPosition.x, position.y + oldPosition.y);
        }
      },
      _fixupHandlerPosition: function _fixupHandlerPosition() {
        var barSize = this.node.getContentSize();
        var barAnchor = this.node.getAnchorPoint();
        var handleSize = this.handle.node.getContentSize();
        var handleParent = this.handle.node.parent;
        var leftBottomWorldPosition = this.node.convertToWorldSpaceAR(cc.v2(-barSize.width * barAnchor.x, -barSize.height * barAnchor.y));
        var fixupPosition = handleParent.convertToNodeSpaceAR(leftBottomWorldPosition);
        this.direction === Direction.HORIZONTAL ? fixupPosition = cc.v2(fixupPosition.x, fixupPosition.y + (barSize.height - handleSize.height) / 2) : this.direction === Direction.VERTICAL && (fixupPosition = cc.v2(fixupPosition.x + (barSize.width - handleSize.width) / 2, fixupPosition.y));
        this.handle.node.setPosition(fixupPosition);
        return fixupPosition;
      },
      _onTouchBegan: function _onTouchBegan() {
        if (!this.enableAutoHide) return;
        this._touching = true;
      },
      _conditionalDisableScrollBar: function _conditionalDisableScrollBar(contentSize, scrollViewSize) {
        if (contentSize.width <= scrollViewSize.width && this.direction === Direction.HORIZONTAL) return true;
        if (contentSize.height <= scrollViewSize.height && this.direction === Direction.VERTICAL) return true;
        return false;
      },
      _onTouchEnded: function _onTouchEnded() {
        if (!this.enableAutoHide) return;
        this._touching = false;
        if (this.autoHideTime <= 0) return;
        if (this._scrollView) {
          var content = this._scrollView.content;
          if (content) {
            var contentSize = content.getContentSize();
            var scrollViewSize = this._scrollView.node.getContentSize();
            if (this._conditionalDisableScrollBar(contentSize, scrollViewSize)) return;
          }
        }
        this._autoHideRemainingTime = this.autoHideTime;
      },
      _calculateLength: function _calculateLength(contentMeasure, scrollViewMeasure, handleNodeMeasure, outOfBoundary) {
        var denominatorValue = contentMeasure;
        outOfBoundary && (denominatorValue += (outOfBoundary > 0 ? outOfBoundary : -outOfBoundary) * GETTINGSHORTERFACTOR);
        var lengthRation = scrollViewMeasure / denominatorValue;
        return handleNodeMeasure * lengthRation;
      },
      _calculatePosition: function _calculatePosition(contentMeasure, scrollViewMeasure, handleNodeMeasure, contentPosition, outOfBoundary, actualLenth) {
        var denominatorValue = contentMeasure - scrollViewMeasure;
        outOfBoundary && (denominatorValue += Math.abs(outOfBoundary));
        var positionRatio = 0;
        if (denominatorValue) {
          positionRatio = contentPosition / denominatorValue;
          positionRatio = misc.clamp01(positionRatio);
        }
        var position = (handleNodeMeasure - actualLenth) * positionRatio;
        return this.direction === Direction.VERTICAL ? cc.v2(0, position) : cc.v2(position, 0);
      },
      _updateLength: function _updateLength(length) {
        if (this.handle) {
          var handleNode = this.handle.node;
          var handleNodeSize = handleNode.getContentSize();
          handleNode.setAnchorPoint(cc.v2(0, 0));
          this.direction === Direction.HORIZONTAL ? handleNode.setContentSize(length, handleNodeSize.height) : handleNode.setContentSize(handleNodeSize.width, length);
        }
      },
      _processAutoHide: function _processAutoHide(deltaTime) {
        if (!this.enableAutoHide || this._autoHideRemainingTime <= 0) return;
        if (this._touching) return;
        this._autoHideRemainingTime -= deltaTime;
        if (this._autoHideRemainingTime <= this.autoHideTime) {
          this._autoHideRemainingTime = Math.max(0, this._autoHideRemainingTime);
          var opacity = this._opacity * (this._autoHideRemainingTime / this.autoHideTime);
          this._setOpacity(opacity);
        }
      },
      start: function start() {
        this.enableAutoHide && this._setOpacity(0);
      },
      hide: function hide() {
        this._autoHideRemainingTime = 0;
        this._setOpacity(0);
      },
      show: function show() {
        this._autoHideRemainingTime = this.autoHideTime;
        this._setOpacity(this._opacity);
      },
      update: function update(dt) {
        this._processAutoHide(dt);
      }
    });
    cc.Scrollbar = module.exports = Scrollbar;
  }), {
    "../utils/misc": 299,
    "./CCComponent": 96
  } ],
  110: [ (function(require, module, exports) {
    "use strict";
    var NodeEvent = require("../CCNode").EventType;
    var NUMBER_OF_GATHERED_TOUCHES_FOR_MOVE_SPEED = 5;
    var OUT_OF_BOUNDARY_BREAKING_FACTOR = .05;
    var EPSILON = 1e-4;
    var MOVEMENT_FACTOR = .7;
    var quintEaseOut = function quintEaseOut(time) {
      time -= 1;
      return time * time * time * time * time + 1;
    };
    var getTimeInMilliseconds = function getTimeInMilliseconds() {
      var currentTime = new Date();
      return currentTime.getMilliseconds();
    };
    var EventType = cc.Enum({
      SCROLL_TO_TOP: 0,
      SCROLL_TO_BOTTOM: 1,
      SCROLL_TO_LEFT: 2,
      SCROLL_TO_RIGHT: 3,
      SCROLLING: 4,
      BOUNCE_TOP: 5,
      BOUNCE_BOTTOM: 6,
      BOUNCE_LEFT: 7,
      BOUNCE_RIGHT: 8,
      SCROLL_ENDED: 9,
      TOUCH_UP: 10,
      AUTOSCROLL_ENDED_WITH_THRESHOLD: 11,
      SCROLL_BEGAN: 12
    });
    var eventMap = {
      "scroll-to-top": EventType.SCROLL_TO_TOP,
      "scroll-to-bottom": EventType.SCROLL_TO_BOTTOM,
      "scroll-to-left": EventType.SCROLL_TO_LEFT,
      "scroll-to-right": EventType.SCROLL_TO_RIGHT,
      scrolling: EventType.SCROLLING,
      "bounce-bottom": EventType.BOUNCE_BOTTOM,
      "bounce-left": EventType.BOUNCE_LEFT,
      "bounce-right": EventType.BOUNCE_RIGHT,
      "bounce-top": EventType.BOUNCE_TOP,
      "scroll-ended": EventType.SCROLL_ENDED,
      "touch-up": EventType.TOUCH_UP,
      "scroll-ended-with-threshold": EventType.AUTOSCROLL_ENDED_WITH_THRESHOLD,
      "scroll-began": EventType.SCROLL_BEGAN
    };
    var ScrollView = cc.Class({
      name: "cc.ScrollView",
      extends: require("./CCViewGroup"),
      editor: false,
      ctor: function ctor() {
        this._topBoundary = 0;
        this._bottomBoundary = 0;
        this._leftBoundary = 0;
        this._rightBoundary = 0;
        this._touchMoveDisplacements = [];
        this._touchMoveTimeDeltas = [];
        this._touchMovePreviousTimestamp = 0;
        this._touchMoved = false;
        this._autoScrolling = false;
        this._autoScrollAttenuate = false;
        this._autoScrollStartPosition = cc.v2(0, 0);
        this._autoScrollTargetDelta = cc.v2(0, 0);
        this._autoScrollTotalTime = 0;
        this._autoScrollAccumulatedTime = 0;
        this._autoScrollCurrentlyOutOfBoundary = false;
        this._autoScrollBraking = false;
        this._autoScrollBrakingStartPosition = cc.v2(0, 0);
        this._outOfBoundaryAmount = cc.v2(0, 0);
        this._outOfBoundaryAmountDirty = true;
        this._stopMouseWheel = false;
        this._mouseWheelEventElapsedTime = 0;
        this._isScrollEndedWithThresholdEventFired = false;
        this._scrollEventEmitMask = 0;
        this._isBouncing = false;
        this._scrolling = false;
      },
      properties: {
        content: {
          default: void 0,
          type: cc.Node,
          tooltip: false,
          formerlySerializedAs: "content",
          notify: function notify(oldValue) {
            this._calculateBoundary();
          }
        },
        horizontal: {
          default: true,
          animatable: false,
          tooltip: false
        },
        vertical: {
          default: true,
          animatable: false,
          tooltip: false
        },
        inertia: {
          default: true,
          tooltip: false
        },
        brake: {
          default: .5,
          type: cc.Float,
          range: [ 0, 1, .1 ],
          tooltip: false
        },
        elastic: {
          default: true,
          animatable: false,
          tooltip: false
        },
        bounceDuration: {
          default: 1,
          range: [ 0, 10 ],
          tooltip: false
        },
        horizontalScrollBar: {
          default: void 0,
          type: cc.Scrollbar,
          tooltip: false,
          notify: function notify() {
            if (this.horizontalScrollBar) {
              this.horizontalScrollBar.setTargetScrollView(this);
              this._updateScrollBar(0);
            }
          },
          animatable: false
        },
        verticalScrollBar: {
          default: void 0,
          type: cc.Scrollbar,
          tooltip: false,
          notify: function notify() {
            if (this.verticalScrollBar) {
              this.verticalScrollBar.setTargetScrollView(this);
              this._updateScrollBar(0);
            }
          },
          animatable: false
        },
        scrollEvents: {
          default: [],
          type: cc.Component.EventHandler,
          tooltip: false
        },
        cancelInnerEvents: {
          default: true,
          animatable: false,
          tooltip: false
        },
        _view: {
          get: function get() {
            if (this.content) return this.content.parent;
          }
        }
      },
      statics: {
        EventType: EventType
      },
      scrollToBottom: function scrollToBottom(timeInSecond, attenuated) {
        var moveDelta = this._calculateMovePercentDelta({
          anchor: cc.v2(0, 0),
          applyToHorizontal: false,
          applyToVertical: true
        });
        timeInSecond ? this._startAutoScroll(moveDelta, timeInSecond, false !== attenuated) : this._moveContent(moveDelta, true);
      },
      scrollToTop: function scrollToTop(timeInSecond, attenuated) {
        var moveDelta = this._calculateMovePercentDelta({
          anchor: cc.v2(0, 1),
          applyToHorizontal: false,
          applyToVertical: true
        });
        timeInSecond ? this._startAutoScroll(moveDelta, timeInSecond, false !== attenuated) : this._moveContent(moveDelta);
      },
      scrollToLeft: function scrollToLeft(timeInSecond, attenuated) {
        var moveDelta = this._calculateMovePercentDelta({
          anchor: cc.v2(0, 0),
          applyToHorizontal: true,
          applyToVertical: false
        });
        timeInSecond ? this._startAutoScroll(moveDelta, timeInSecond, false !== attenuated) : this._moveContent(moveDelta);
      },
      scrollToRight: function scrollToRight(timeInSecond, attenuated) {
        var moveDelta = this._calculateMovePercentDelta({
          anchor: cc.v2(1, 0),
          applyToHorizontal: true,
          applyToVertical: false
        });
        timeInSecond ? this._startAutoScroll(moveDelta, timeInSecond, false !== attenuated) : this._moveContent(moveDelta);
      },
      scrollToTopLeft: function scrollToTopLeft(timeInSecond, attenuated) {
        var moveDelta = this._calculateMovePercentDelta({
          anchor: cc.v2(0, 1),
          applyToHorizontal: true,
          applyToVertical: true
        });
        timeInSecond ? this._startAutoScroll(moveDelta, timeInSecond, false !== attenuated) : this._moveContent(moveDelta);
      },
      scrollToTopRight: function scrollToTopRight(timeInSecond, attenuated) {
        var moveDelta = this._calculateMovePercentDelta({
          anchor: cc.v2(1, 1),
          applyToHorizontal: true,
          applyToVertical: true
        });
        timeInSecond ? this._startAutoScroll(moveDelta, timeInSecond, false !== attenuated) : this._moveContent(moveDelta);
      },
      scrollToBottomLeft: function scrollToBottomLeft(timeInSecond, attenuated) {
        var moveDelta = this._calculateMovePercentDelta({
          anchor: cc.v2(0, 0),
          applyToHorizontal: true,
          applyToVertical: true
        });
        timeInSecond ? this._startAutoScroll(moveDelta, timeInSecond, false !== attenuated) : this._moveContent(moveDelta);
      },
      scrollToBottomRight: function scrollToBottomRight(timeInSecond, attenuated) {
        var moveDelta = this._calculateMovePercentDelta({
          anchor: cc.v2(1, 0),
          applyToHorizontal: true,
          applyToVertical: true
        });
        timeInSecond ? this._startAutoScroll(moveDelta, timeInSecond, false !== attenuated) : this._moveContent(moveDelta);
      },
      scrollToOffset: function scrollToOffset(offset, timeInSecond, attenuated) {
        var maxScrollOffset = this.getMaxScrollOffset();
        var anchor = cc.v2(0, 0);
        0 === maxScrollOffset.x ? anchor.x = 0 : anchor.x = offset.x / maxScrollOffset.x;
        0 === maxScrollOffset.y ? anchor.y = 1 : anchor.y = (maxScrollOffset.y - offset.y) / maxScrollOffset.y;
        this.scrollTo(anchor, timeInSecond, attenuated);
      },
      getScrollOffset: function getScrollOffset() {
        var topDelta = this._getContentTopBoundary() - this._topBoundary;
        var leftDeta = this._getContentLeftBoundary() - this._leftBoundary;
        return cc.v2(leftDeta, topDelta);
      },
      getMaxScrollOffset: function getMaxScrollOffset() {
        var viewSize = this._view.getContentSize();
        var contentSize = this.content.getContentSize();
        var horizontalMaximizeOffset = contentSize.width - viewSize.width;
        var verticalMaximizeOffset = contentSize.height - viewSize.height;
        horizontalMaximizeOffset = horizontalMaximizeOffset >= 0 ? horizontalMaximizeOffset : 0;
        verticalMaximizeOffset = verticalMaximizeOffset >= 0 ? verticalMaximizeOffset : 0;
        return cc.v2(horizontalMaximizeOffset, verticalMaximizeOffset);
      },
      scrollToPercentHorizontal: function scrollToPercentHorizontal(percent, timeInSecond, attenuated) {
        var moveDelta = this._calculateMovePercentDelta({
          anchor: cc.v2(percent, 0),
          applyToHorizontal: true,
          applyToVertical: false
        });
        timeInSecond ? this._startAutoScroll(moveDelta, timeInSecond, false !== attenuated) : this._moveContent(moveDelta);
      },
      scrollTo: function scrollTo(anchor, timeInSecond, attenuated) {
        var moveDelta = this._calculateMovePercentDelta({
          anchor: cc.v2(anchor),
          applyToHorizontal: true,
          applyToVertical: true
        });
        timeInSecond ? this._startAutoScroll(moveDelta, timeInSecond, false !== attenuated) : this._moveContent(moveDelta);
      },
      scrollToPercentVertical: function scrollToPercentVertical(percent, timeInSecond, attenuated) {
        var moveDelta = this._calculateMovePercentDelta({
          anchor: cc.v2(0, percent),
          applyToHorizontal: false,
          applyToVertical: true
        });
        timeInSecond ? this._startAutoScroll(moveDelta, timeInSecond, false !== attenuated) : this._moveContent(moveDelta);
      },
      stopAutoScroll: function stopAutoScroll() {
        this._autoScrolling = false;
        this._autoScrollAccumulatedTime = this._autoScrollTotalTime;
      },
      setContentPosition: function setContentPosition(position) {
        if (position.fuzzyEquals(this.getContentPosition(), EPSILON)) return;
        this.content.setPosition(position);
        this._outOfBoundaryAmountDirty = true;
      },
      getContentPosition: function getContentPosition() {
        return this.content.getPosition();
      },
      isScrolling: function isScrolling() {
        return this._scrolling;
      },
      isAutoScrolling: function isAutoScrolling() {
        return this._autoScrolling;
      },
      _registerEvent: function _registerEvent() {
        this.node.on(cc.Node.EventType.TOUCH_START, this._onTouchBegan, this, true);
        this.node.on(cc.Node.EventType.TOUCH_MOVE, this._onTouchMoved, this, true);
        this.node.on(cc.Node.EventType.TOUCH_END, this._onTouchEnded, this, true);
        this.node.on(cc.Node.EventType.TOUCH_CANCEL, this._onTouchCancelled, this, true);
        this.node.on(cc.Node.EventType.MOUSE_WHEEL, this._onMouseWheel, this, true);
      },
      _unregisterEvent: function _unregisterEvent() {
        this.node.off(cc.Node.EventType.TOUCH_START, this._onTouchBegan, this, true);
        this.node.off(cc.Node.EventType.TOUCH_MOVE, this._onTouchMoved, this, true);
        this.node.off(cc.Node.EventType.TOUCH_END, this._onTouchEnded, this, true);
        this.node.off(cc.Node.EventType.TOUCH_CANCEL, this._onTouchCancelled, this, true);
        this.node.off(cc.Node.EventType.MOUSE_WHEEL, this._onMouseWheel, this, true);
      },
      _onMouseWheel: function _onMouseWheel(event, captureListeners) {
        if (!this.enabledInHierarchy) return;
        if (this._hasNestedViewGroup(event, captureListeners)) return;
        var deltaMove = cc.v2(0, 0);
        var wheelPrecision = -.1;
        true;
        wheelPrecision = -7;
        this.vertical ? deltaMove = cc.v2(0, event.getScrollY() * wheelPrecision) : this.horizontal && (deltaMove = cc.v2(event.getScrollY() * wheelPrecision, 0));
        this._mouseWheelEventElapsedTime = 0;
        this._processDeltaMove(deltaMove);
        if (!this._stopMouseWheel) {
          this._handlePressLogic();
          this.schedule(this._checkMouseWheel, 1 / 60);
          this._stopMouseWheel = true;
        }
        this._stopPropagationIfTargetIsMe(event);
      },
      _checkMouseWheel: function _checkMouseWheel(dt) {
        var currentOutOfBoundary = this._getHowMuchOutOfBoundary();
        var maxElapsedTime = .1;
        if (!currentOutOfBoundary.fuzzyEquals(cc.v2(0, 0), EPSILON)) {
          this._processInertiaScroll();
          this.unschedule(this._checkMouseWheel);
          this._stopMouseWheel = false;
          return;
        }
        this._mouseWheelEventElapsedTime += dt;
        if (this._mouseWheelEventElapsedTime > maxElapsedTime) {
          this._onScrollBarTouchEnded();
          this.unschedule(this._checkMouseWheel);
          this._stopMouseWheel = false;
        }
      },
      _calculateMovePercentDelta: function _calculateMovePercentDelta(options) {
        var anchor = options.anchor;
        var applyToHorizontal = options.applyToHorizontal;
        var applyToVertical = options.applyToVertical;
        this._calculateBoundary();
        anchor = anchor.clampf(cc.v2(0, 0), cc.v2(1, 1));
        var scrollSize = this._view.getContentSize();
        var contentSize = this.content.getContentSize();
        var bottomDeta = this._getContentBottomBoundary() - this._bottomBoundary;
        bottomDeta = -bottomDeta;
        var leftDeta = this._getContentLeftBoundary() - this._leftBoundary;
        leftDeta = -leftDeta;
        var moveDelta = cc.v2(0, 0);
        var totalScrollDelta = 0;
        if (applyToHorizontal) {
          totalScrollDelta = contentSize.width - scrollSize.width;
          moveDelta.x = leftDeta - totalScrollDelta * anchor.x;
        }
        if (applyToVertical) {
          totalScrollDelta = contentSize.height - scrollSize.height;
          moveDelta.y = bottomDeta - totalScrollDelta * anchor.y;
        }
        return moveDelta;
      },
      _moveContentToTopLeft: function _moveContentToTopLeft(scrollViewSize) {
        var contentSize = this.content.getContentSize();
        var bottomDeta = this._getContentBottomBoundary() - this._bottomBoundary;
        bottomDeta = -bottomDeta;
        var moveDelta = cc.v2(0, 0);
        var totalScrollDelta = 0;
        var leftDeta = this._getContentLeftBoundary() - this._leftBoundary;
        leftDeta = -leftDeta;
        if (contentSize.height < scrollViewSize.height) {
          totalScrollDelta = contentSize.height - scrollViewSize.height;
          moveDelta.y = bottomDeta - totalScrollDelta;
        }
        if (contentSize.width < scrollViewSize.width) {
          totalScrollDelta = contentSize.width - scrollViewSize.width;
          moveDelta.x = leftDeta;
        }
        this._updateScrollBarState();
        this._moveContent(moveDelta);
        this._adjustContentOutOfBoundary();
      },
      _calculateBoundary: function _calculateBoundary() {
        if (this.content) {
          var layout = this.content.getComponent(cc.Layout);
          layout && layout.enabledInHierarchy && layout.updateLayout();
          var viewSize = this._view.getContentSize();
          var anchorX = viewSize.width * this._view.anchorX;
          var anchorY = viewSize.height * this._view.anchorY;
          this._leftBoundary = -anchorX;
          this._bottomBoundary = -anchorY;
          this._rightBoundary = this._leftBoundary + viewSize.width;
          this._topBoundary = this._bottomBoundary + viewSize.height;
          this._moveContentToTopLeft(viewSize);
        }
      },
      _hasNestedViewGroup: function _hasNestedViewGroup(event, captureListeners) {
        if (event.eventPhase !== cc.Event.CAPTURING_PHASE) return;
        if (captureListeners) for (var i = 0; i < captureListeners.length; ++i) {
          var item = captureListeners[i];
          if (this.node === item) {
            if (event.target.getComponent(cc.ViewGroup)) return true;
            return false;
          }
          if (item.getComponent(cc.ViewGroup)) return true;
        }
        return false;
      },
      _stopPropagationIfTargetIsMe: function _stopPropagationIfTargetIsMe(event) {
        event.eventPhase === cc.Event.AT_TARGET && event.target === this.node && event.stopPropagation();
      },
      _onTouchBegan: function _onTouchBegan(event, captureListeners) {
        if (!this.enabledInHierarchy) return;
        if (this._hasNestedViewGroup(event, captureListeners)) return;
        var touch = event.touch;
        this.content && this._handlePressLogic(touch);
        this._touchMoved = false;
        this._stopPropagationIfTargetIsMe(event);
      },
      _onTouchMoved: function _onTouchMoved(event, captureListeners) {
        if (!this.enabledInHierarchy) return;
        if (this._hasNestedViewGroup(event, captureListeners)) return;
        var touch = event.touch;
        this.content && this._handleMoveLogic(touch);
        if (!this.cancelInnerEvents) return;
        var deltaMove = touch.getLocation().sub(touch.getStartLocation());
        if (deltaMove.mag() > 7 && !this._touchMoved && event.target !== this.node) {
          var cancelEvent = new cc.Event.EventTouch(event.getTouches(), event.bubbles);
          cancelEvent.type = cc.Node.EventType.TOUCH_CANCEL;
          cancelEvent.touch = event.touch;
          cancelEvent.simulate = true;
          event.target.dispatchEvent(cancelEvent);
          this._touchMoved = true;
        }
        this._stopPropagationIfTargetIsMe(event);
      },
      _onTouchEnded: function _onTouchEnded(event, captureListeners) {
        if (!this.enabledInHierarchy) return;
        if (this._hasNestedViewGroup(event, captureListeners)) return;
        this._dispatchEvent("touch-up");
        var touch = event.touch;
        this.content && this._handleReleaseLogic(touch);
        this._touchMoved ? event.stopPropagation() : this._stopPropagationIfTargetIsMe(event);
      },
      _onTouchCancelled: function _onTouchCancelled(event, captureListeners) {
        if (!this.enabledInHierarchy) return;
        if (this._hasNestedViewGroup(event, captureListeners)) return;
        if (!event.simulate) {
          var touch = event.touch;
          this.content && this._handleReleaseLogic(touch);
        }
        this._stopPropagationIfTargetIsMe(event);
      },
      _processDeltaMove: function _processDeltaMove(deltaMove) {
        this._scrollChildren(deltaMove);
        this._gatherTouchMove(deltaMove);
      },
      _handleMoveLogic: function _handleMoveLogic(touch) {
        var deltaMove = touch.getDelta();
        this._processDeltaMove(deltaMove);
      },
      _scrollChildren: function _scrollChildren(deltaMove) {
        deltaMove = this._clampDelta(deltaMove);
        var realMove = deltaMove;
        var outOfBoundary = void 0;
        if (this.elastic) {
          outOfBoundary = this._getHowMuchOutOfBoundary();
          realMove.x *= 0 === outOfBoundary.x ? 1 : .5;
          realMove.y *= 0 === outOfBoundary.y ? 1 : .5;
        }
        if (!this.elastic) {
          outOfBoundary = this._getHowMuchOutOfBoundary(realMove);
          realMove = realMove.add(outOfBoundary);
        }
        var scrollEventType = -1;
        if (realMove.y > 0) {
          var icBottomPos = this.content.y - this.content.anchorY * this.content.height;
          icBottomPos + realMove.y > this._bottomBoundary && (scrollEventType = "scroll-to-bottom");
        } else if (realMove.y < 0) {
          var icTopPos = this.content.y - this.content.anchorY * this.content.height + this.content.height;
          icTopPos + realMove.y <= this._topBoundary && (scrollEventType = "scroll-to-top");
        }
        if (realMove.x < 0) {
          var icRightPos = this.content.x - this.content.anchorX * this.content.width + this.content.width;
          icRightPos + realMove.x <= this._rightBoundary && (scrollEventType = "scroll-to-right");
        } else if (realMove.x > 0) {
          var icLeftPos = this.content.x - this.content.anchorX * this.content.width;
          icLeftPos + realMove.x >= this._leftBoundary && (scrollEventType = "scroll-to-left");
        }
        this._moveContent(realMove, false);
        if (0 !== realMove.x || 0 !== realMove.y) {
          if (!this._scrolling) {
            this._scrolling = true;
            this._dispatchEvent("scroll-began");
          }
          this._dispatchEvent("scrolling");
        }
        -1 !== scrollEventType && this._dispatchEvent(scrollEventType);
      },
      _handlePressLogic: function _handlePressLogic() {
        this._autoScrolling && this._dispatchEvent("scroll-ended");
        this._autoScrolling = false;
        this._isBouncing = false;
        this._touchMovePreviousTimestamp = getTimeInMilliseconds();
        this._touchMoveDisplacements.length = 0;
        this._touchMoveTimeDeltas.length = 0;
        this._onScrollBarTouchBegan();
      },
      _clampDelta: function _clampDelta(delta) {
        var contentSize = this.content.getContentSize();
        var scrollViewSize = this._view.getContentSize();
        contentSize.width < scrollViewSize.width && (delta.x = 0);
        contentSize.height < scrollViewSize.height && (delta.y = 0);
        return delta;
      },
      _gatherTouchMove: function _gatherTouchMove(delta) {
        delta = this._clampDelta(delta);
        while (this._touchMoveDisplacements.length >= NUMBER_OF_GATHERED_TOUCHES_FOR_MOVE_SPEED) {
          this._touchMoveDisplacements.shift();
          this._touchMoveTimeDeltas.shift();
        }
        this._touchMoveDisplacements.push(delta);
        var timeStamp = getTimeInMilliseconds();
        this._touchMoveTimeDeltas.push((timeStamp - this._touchMovePreviousTimestamp) / 1e3);
        this._touchMovePreviousTimestamp = timeStamp;
      },
      _startBounceBackIfNeeded: function _startBounceBackIfNeeded() {
        if (!this.elastic) return false;
        var bounceBackAmount = this._getHowMuchOutOfBoundary();
        bounceBackAmount = this._clampDelta(bounceBackAmount);
        if (bounceBackAmount.fuzzyEquals(cc.v2(0, 0), EPSILON)) return false;
        var bounceBackTime = Math.max(this.bounceDuration, 0);
        this._startAutoScroll(bounceBackAmount, bounceBackTime, true);
        if (!this._isBouncing) {
          bounceBackAmount.y > 0 && this._dispatchEvent("bounce-top");
          bounceBackAmount.y < 0 && this._dispatchEvent("bounce-bottom");
          bounceBackAmount.x > 0 && this._dispatchEvent("bounce-right");
          bounceBackAmount.x < 0 && this._dispatchEvent("bounce-left");
          this._isBouncing = true;
        }
        return true;
      },
      _processInertiaScroll: function _processInertiaScroll() {
        var bounceBackStarted = this._startBounceBackIfNeeded();
        if (!bounceBackStarted && this.inertia) {
          var touchMoveVelocity = this._calculateTouchMoveVelocity();
          !touchMoveVelocity.fuzzyEquals(cc.v2(0, 0), EPSILON) && this.brake < 1 && this._startInertiaScroll(touchMoveVelocity);
        }
        this._onScrollBarTouchEnded();
      },
      _handleReleaseLogic: function _handleReleaseLogic(touch) {
        var delta = touch.getDelta();
        this._gatherTouchMove(delta);
        this._processInertiaScroll();
        if (this._scrolling) {
          this._scrolling = false;
          this._autoScrolling || this._dispatchEvent("scroll-ended");
        }
      },
      _isOutOfBoundary: function _isOutOfBoundary() {
        var outOfBoundary = this._getHowMuchOutOfBoundary();
        return !outOfBoundary.fuzzyEquals(cc.v2(0, 0), EPSILON);
      },
      _isNecessaryAutoScrollBrake: function _isNecessaryAutoScrollBrake() {
        if (this._autoScrollBraking) return true;
        if (this._isOutOfBoundary()) {
          if (!this._autoScrollCurrentlyOutOfBoundary) {
            this._autoScrollCurrentlyOutOfBoundary = true;
            this._autoScrollBraking = true;
            this._autoScrollBrakingStartPosition = this.getContentPosition();
            return true;
          }
        } else this._autoScrollCurrentlyOutOfBoundary = false;
        return false;
      },
      getScrollEndedEventTiming: function getScrollEndedEventTiming() {
        return EPSILON;
      },
      _processAutoScrolling: function _processAutoScrolling(dt) {
        var isAutoScrollBrake = this._isNecessaryAutoScrollBrake();
        var brakingFactor = isAutoScrollBrake ? OUT_OF_BOUNDARY_BREAKING_FACTOR : 1;
        this._autoScrollAccumulatedTime += dt * (1 / brakingFactor);
        var percentage = Math.min(1, this._autoScrollAccumulatedTime / this._autoScrollTotalTime);
        this._autoScrollAttenuate && (percentage = quintEaseOut(percentage));
        var newPosition = this._autoScrollStartPosition.add(this._autoScrollTargetDelta.mul(percentage));
        var reachedEnd = Math.abs(percentage - 1) <= EPSILON;
        var fireEvent = Math.abs(percentage - 1) <= this.getScrollEndedEventTiming();
        if (fireEvent && !this._isScrollEndedWithThresholdEventFired) {
          this._dispatchEvent("scroll-ended-with-threshold");
          this._isScrollEndedWithThresholdEventFired = true;
        }
        if (this.elastic) {
          var brakeOffsetPosition = newPosition.sub(this._autoScrollBrakingStartPosition);
          isAutoScrollBrake && (brakeOffsetPosition = brakeOffsetPosition.mul(brakingFactor));
          newPosition = this._autoScrollBrakingStartPosition.add(brakeOffsetPosition);
        } else {
          var moveDelta = newPosition.sub(this.getContentPosition());
          var outOfBoundary = this._getHowMuchOutOfBoundary(moveDelta);
          if (!outOfBoundary.fuzzyEquals(cc.v2(0, 0), EPSILON)) {
            newPosition = newPosition.add(outOfBoundary);
            reachedEnd = true;
          }
        }
        reachedEnd && (this._autoScrolling = false);
        var deltaMove = newPosition.sub(this.getContentPosition());
        this._moveContent(this._clampDelta(deltaMove), reachedEnd);
        this._dispatchEvent("scrolling");
        if (!this._autoScrolling) {
          this._isBouncing = false;
          this._scrolling = false;
          this._dispatchEvent("scroll-ended");
        }
      },
      _startInertiaScroll: function _startInertiaScroll(touchMoveVelocity) {
        var inertiaTotalMovement = touchMoveVelocity.mul(MOVEMENT_FACTOR);
        this._startAttenuatingAutoScroll(inertiaTotalMovement, touchMoveVelocity);
      },
      _calculateAttenuatedFactor: function _calculateAttenuatedFactor(distance) {
        if (this.brake <= 0) return 1 - this.brake;
        return (1 - this.brake) * (1 / (1 + 14e-6 * distance + distance * distance * 8e-9));
      },
      _startAttenuatingAutoScroll: function _startAttenuatingAutoScroll(deltaMove, initialVelocity) {
        var time = this._calculateAutoScrollTimeByInitalSpeed(initialVelocity.mag());
        var targetDelta = deltaMove.normalize();
        var contentSize = this.content.getContentSize();
        var scrollviewSize = this._view.getContentSize();
        var totalMoveWidth = contentSize.width - scrollviewSize.width;
        var totalMoveHeight = contentSize.height - scrollviewSize.height;
        var attenuatedFactorX = this._calculateAttenuatedFactor(totalMoveWidth);
        var attenuatedFactorY = this._calculateAttenuatedFactor(totalMoveHeight);
        targetDelta = cc.v2(targetDelta.x * totalMoveWidth * (1 - this.brake) * attenuatedFactorX, targetDelta.y * totalMoveHeight * attenuatedFactorY * (1 - this.brake));
        var originalMoveLength = deltaMove.mag();
        var factor = targetDelta.mag() / originalMoveLength;
        targetDelta = targetDelta.add(deltaMove);
        if (this.brake > 0 && factor > 7) {
          factor = Math.sqrt(factor);
          targetDelta = deltaMove.mul(factor).add(deltaMove);
        }
        if (this.brake > 0 && factor > 3) {
          factor = 3;
          time *= factor;
        }
        0 === this.brake && factor > 1 && (time *= factor);
        this._startAutoScroll(targetDelta, time, true);
      },
      _calculateAutoScrollTimeByInitalSpeed: function _calculateAutoScrollTimeByInitalSpeed(initalSpeed) {
        return Math.sqrt(Math.sqrt(initalSpeed / 5));
      },
      _startAutoScroll: function _startAutoScroll(deltaMove, timeInSecond, attenuated) {
        var adjustedDeltaMove = this._flattenVectorByDirection(deltaMove);
        this._autoScrolling = true;
        this._autoScrollTargetDelta = adjustedDeltaMove;
        this._autoScrollAttenuate = attenuated;
        this._autoScrollStartPosition = this.getContentPosition();
        this._autoScrollTotalTime = timeInSecond;
        this._autoScrollAccumulatedTime = 0;
        this._autoScrollBraking = false;
        this._isScrollEndedWithThresholdEventFired = false;
        this._autoScrollBrakingStartPosition = cc.v2(0, 0);
        var currentOutOfBoundary = this._getHowMuchOutOfBoundary();
        currentOutOfBoundary.fuzzyEquals(cc.v2(0, 0), EPSILON) || (this._autoScrollCurrentlyOutOfBoundary = true);
      },
      _calculateTouchMoveVelocity: function _calculateTouchMoveVelocity() {
        var totalTime = 0;
        totalTime = this._touchMoveTimeDeltas.reduce((function(a, b) {
          return a + b;
        }), totalTime);
        if (totalTime <= 0 || totalTime >= .5) return cc.v2(0, 0);
        var totalMovement = cc.v2(0, 0);
        totalMovement = this._touchMoveDisplacements.reduce((function(a, b) {
          return a.add(b);
        }), totalMovement);
        return cc.v2(totalMovement.x * (1 - this.brake) / totalTime, totalMovement.y * (1 - this.brake) / totalTime);
      },
      _flattenVectorByDirection: function _flattenVectorByDirection(vector) {
        var result = vector;
        result.x = this.horizontal ? result.x : 0;
        result.y = this.vertical ? result.y : 0;
        return result;
      },
      _moveContent: function _moveContent(deltaMove, canStartBounceBack) {
        var adjustedMove = this._flattenVectorByDirection(deltaMove);
        var newPosition = this.getContentPosition().add(adjustedMove);
        this.setContentPosition(newPosition);
        var outOfBoundary = this._getHowMuchOutOfBoundary();
        this._updateScrollBar(outOfBoundary);
        this.elastic && canStartBounceBack && this._startBounceBackIfNeeded();
      },
      _getContentLeftBoundary: function _getContentLeftBoundary() {
        var contentPos = this.getContentPosition();
        return contentPos.x - this.content.getAnchorPoint().x * this.content.getContentSize().width;
      },
      _getContentRightBoundary: function _getContentRightBoundary() {
        var contentSize = this.content.getContentSize();
        return this._getContentLeftBoundary() + contentSize.width;
      },
      _getContentTopBoundary: function _getContentTopBoundary() {
        var contentSize = this.content.getContentSize();
        return this._getContentBottomBoundary() + contentSize.height;
      },
      _getContentBottomBoundary: function _getContentBottomBoundary() {
        var contentPos = this.getContentPosition();
        return contentPos.y - this.content.getAnchorPoint().y * this.content.getContentSize().height;
      },
      _getHowMuchOutOfBoundary: function _getHowMuchOutOfBoundary(addition) {
        addition = addition || cc.v2(0, 0);
        if (addition.fuzzyEquals(cc.v2(0, 0), EPSILON) && !this._outOfBoundaryAmountDirty) return this._outOfBoundaryAmount;
        var outOfBoundaryAmount = cc.v2(0, 0);
        this._getContentLeftBoundary() + addition.x > this._leftBoundary ? outOfBoundaryAmount.x = this._leftBoundary - (this._getContentLeftBoundary() + addition.x) : this._getContentRightBoundary() + addition.x < this._rightBoundary && (outOfBoundaryAmount.x = this._rightBoundary - (this._getContentRightBoundary() + addition.x));
        this._getContentTopBoundary() + addition.y < this._topBoundary ? outOfBoundaryAmount.y = this._topBoundary - (this._getContentTopBoundary() + addition.y) : this._getContentBottomBoundary() + addition.y > this._bottomBoundary && (outOfBoundaryAmount.y = this._bottomBoundary - (this._getContentBottomBoundary() + addition.y));
        if (addition.fuzzyEquals(cc.v2(0, 0), EPSILON)) {
          this._outOfBoundaryAmount = outOfBoundaryAmount;
          this._outOfBoundaryAmountDirty = false;
        }
        outOfBoundaryAmount = this._clampDelta(outOfBoundaryAmount);
        return outOfBoundaryAmount;
      },
      _updateScrollBarState: function _updateScrollBarState() {
        if (!this.content) return;
        var contentSize = this.content.getContentSize();
        var scrollViewSize = this._view.getContentSize();
        this.verticalScrollBar && (contentSize.height < scrollViewSize.height ? this.verticalScrollBar.hide() : this.verticalScrollBar.show());
        this.horizontalScrollBar && (contentSize.width < scrollViewSize.width ? this.horizontalScrollBar.hide() : this.horizontalScrollBar.show());
      },
      _updateScrollBar: function _updateScrollBar(outOfBoundary) {
        this.horizontalScrollBar && this.horizontalScrollBar._onScroll(outOfBoundary);
        this.verticalScrollBar && this.verticalScrollBar._onScroll(outOfBoundary);
      },
      _onScrollBarTouchBegan: function _onScrollBarTouchBegan() {
        this.horizontalScrollBar && this.horizontalScrollBar._onTouchBegan();
        this.verticalScrollBar && this.verticalScrollBar._onTouchBegan();
      },
      _onScrollBarTouchEnded: function _onScrollBarTouchEnded() {
        this.horizontalScrollBar && this.horizontalScrollBar._onTouchEnded();
        this.verticalScrollBar && this.verticalScrollBar._onTouchEnded();
      },
      _dispatchEvent: function _dispatchEvent(event) {
        if ("scroll-ended" === event) this._scrollEventEmitMask = 0; else if ("scroll-to-top" === event || "scroll-to-bottom" === event || "scroll-to-left" === event || "scroll-to-right" === event) {
          var flag = 1 << eventMap[event];
          if (this._scrollEventEmitMask & flag) return;
          this._scrollEventEmitMask |= flag;
        }
        cc.Component.EventHandler.emitEvents(this.scrollEvents, this, eventMap[event]);
        this.node.emit(event, this);
      },
      _adjustContentOutOfBoundary: function _adjustContentOutOfBoundary() {
        this._outOfBoundaryAmountDirty = true;
        if (this._isOutOfBoundary()) {
          var outOfBoundary = this._getHowMuchOutOfBoundary(cc.v2(0, 0));
          var newPosition = this.getContentPosition().add(outOfBoundary);
          if (this.content) {
            this.content.setPosition(newPosition);
            this._updateScrollBar(0);
          }
        }
      },
      start: function start() {
        this._calculateBoundary();
        this.content && cc.director.once(cc.Director.EVENT_BEFORE_DRAW, this._adjustContentOutOfBoundary, this);
      },
      _hideScrollbar: function _hideScrollbar() {
        this.horizontalScrollBar && this.horizontalScrollBar.hide();
        this.verticalScrollBar && this.verticalScrollBar.hide();
      },
      onDisable: function onDisable() {
        true;
        this._unregisterEvent();
        if (this.content) {
          this.content.off(NodeEvent.SIZE_CHANGED, this._calculateBoundary, this);
          this.content.off(NodeEvent.SCALE_CHANGED, this._calculateBoundary, this);
          if (this._view) {
            this._view.off(NodeEvent.POSITION_CHANGED, this._calculateBoundary, this);
            this._view.off(NodeEvent.SCALE_CHANGED, this._calculateBoundary, this);
            this._view.off(NodeEvent.SIZE_CHANGED, this._calculateBoundary, this);
          }
        }
        this._hideScrollbar();
        this.stopAutoScroll();
      },
      onEnable: function onEnable() {
        true;
        this._registerEvent();
        if (this.content) {
          this.content.on(NodeEvent.SIZE_CHANGED, this._calculateBoundary, this);
          this.content.on(NodeEvent.SCALE_CHANGED, this._calculateBoundary, this);
          if (this._view) {
            this._view.on(NodeEvent.POSITION_CHANGED, this._calculateBoundary, this);
            this._view.on(NodeEvent.SCALE_CHANGED, this._calculateBoundary, this);
            this._view.on(NodeEvent.SIZE_CHANGED, this._calculateBoundary, this);
          }
        }
        this._updateScrollBarState();
      },
      update: function update(dt) {
        this._autoScrolling && this._processAutoScrolling(dt);
      }
    });
    cc.ScrollView = module.exports = ScrollView;
  }), {
    "../CCNode": 53,
    "./CCViewGroup": 117
  } ],
  111: [ (function(require, module, exports) {
    "use strict";
    var misc = require("../utils/misc");
    var Component = require("./CCComponent");
    var Direction = cc.Enum({
      Horizontal: 0,
      Vertical: 1
    });
    var Slider = cc.Class({
      name: "cc.Slider",
      extends: Component,
      editor: false,
      ctor: function ctor() {
        this._offset = cc.v2();
        this._touchHandle = false;
        this._dragging = false;
      },
      properties: {
        handle: {
          default: null,
          type: cc.Button,
          tooltip: false,
          notify: function notify() {
            false;
          }
        },
        direction: {
          default: Direction.Horizontal,
          type: Direction,
          tooltip: false
        },
        progress: {
          default: .5,
          type: cc.Float,
          range: [ 0, 1, .1 ],
          slide: true,
          tooltip: false,
          notify: function notify() {
            this._updateHandlePosition();
          }
        },
        slideEvents: {
          default: [],
          type: cc.Component.EventHandler,
          tooltip: false
        }
      },
      statics: {
        Direction: Direction
      },
      __preload: function __preload() {
        this._updateHandlePosition();
      },
      onEnable: function onEnable() {
        this.node.on(cc.Node.EventType.TOUCH_START, this._onTouchBegan, this);
        this.node.on(cc.Node.EventType.TOUCH_MOVE, this._onTouchMoved, this);
        this.node.on(cc.Node.EventType.TOUCH_END, this._onTouchEnded, this);
        this.node.on(cc.Node.EventType.TOUCH_CANCEL, this._onTouchCancelled, this);
        if (this.handle && this.handle.isValid) {
          this.handle.node.on(cc.Node.EventType.TOUCH_START, this._onHandleDragStart, this);
          this.handle.node.on(cc.Node.EventType.TOUCH_MOVE, this._onTouchMoved, this);
          this.handle.node.on(cc.Node.EventType.TOUCH_END, this._onTouchEnded, this);
        }
      },
      onDisable: function onDisable() {
        this.node.off(cc.Node.EventType.TOUCH_START, this._onTouchBegan, this);
        this.node.off(cc.Node.EventType.TOUCH_MOVE, this._onTouchMoved, this);
        this.node.off(cc.Node.EventType.TOUCH_END, this._onTouchEnded, this);
        this.node.off(cc.Node.EventType.TOUCH_CANCEL, this._onTouchCancelled, this);
        if (this.handle && this.handle.isValid) {
          this.handle.node.off(cc.Node.EventType.TOUCH_START, this._onHandleDragStart, this);
          this.handle.node.off(cc.Node.EventType.TOUCH_MOVE, this._onTouchMoved, this);
          this.handle.node.off(cc.Node.EventType.TOUCH_END, this._onTouchEnded, this);
        }
      },
      _onHandleDragStart: function _onHandleDragStart(event) {
        this._dragging = true;
        this._touchHandle = true;
        this._offset = this.handle.node.convertToNodeSpaceAR(event.touch.getLocation());
        event.stopPropagation();
      },
      _onTouchBegan: function _onTouchBegan(event) {
        if (!this.handle) return;
        this._dragging = true;
        this._touchHandle || this._handleSliderLogic(event.touch);
        event.stopPropagation();
      },
      _onTouchMoved: function _onTouchMoved(event) {
        if (!this._dragging) return;
        this._handleSliderLogic(event.touch);
        event.stopPropagation();
      },
      _onTouchEnded: function _onTouchEnded(event) {
        this._dragging = false;
        this._touchHandle = false;
        this._offset = cc.v2();
        event.stopPropagation();
      },
      _onTouchCancelled: function _onTouchCancelled(event) {
        this._dragging = false;
        event.stopPropagation();
      },
      _handleSliderLogic: function _handleSliderLogic(touch) {
        this._updateProgress(touch);
        this._emitSlideEvent();
      },
      _emitSlideEvent: function _emitSlideEvent() {
        cc.Component.EventHandler.emitEvents(this.slideEvents, this);
        this.node.emit("slide", this);
      },
      _updateProgress: function _updateProgress(touch) {
        if (!this.handle) return;
        var node = this.node;
        var localTouchPos = node.convertToNodeSpaceAR(touch.getLocation());
        this.direction === Direction.Horizontal ? this.progress = misc.clamp01((localTouchPos.x - this._offset.x + node.anchorX * node.width) / node.width) : this.progress = misc.clamp01((localTouchPos.y - this._offset.y + node.anchorY * node.height) / node.height);
      },
      _updateHandlePosition: function _updateHandlePosition() {
        if (!this.handle) return;
        var handlelocalPos;
        handlelocalPos = this.direction === Direction.Horizontal ? cc.v2(-this.node.width * this.node.anchorX + this.progress * this.node.width, 0) : cc.v2(0, -this.node.height * this.node.anchorY + this.progress * this.node.height);
        var worldSpacePos = this.node.convertToWorldSpaceAR(handlelocalPos);
        this.handle.node.position = this.handle.node.parent.convertToNodeSpaceAR(worldSpacePos);
      }
    });
    cc.Slider = module.exports = Slider;
  }), {
    "../utils/misc": 299,
    "./CCComponent": 96
  } ],
  112: [ (function(require, module, exports) {
    "use strict";
    var misc = require("../utils/misc");
    var NodeEvent = require("../CCNode").EventType;
    var RenderComponent = require("./CCRenderComponent");
    var BlendFunc = require("../utils/blend-func");
    var RenderFlow = require("../renderer/render-flow");
    var Material = require("../assets/material/CCMaterial");
    var SpriteType = cc.Enum({
      SIMPLE: 0,
      SLICED: 1,
      TILED: 2,
      FILLED: 3,
      MESH: 4
    });
    var FillType = cc.Enum({
      HORIZONTAL: 0,
      VERTICAL: 1,
      RADIAL: 2
    });
    var SizeMode = cc.Enum({
      CUSTOM: 0,
      TRIMMED: 1,
      RAW: 2
    });
    var State = cc.Enum({
      NORMAL: 0,
      GRAY: 1
    });
    var Sprite = cc.Class({
      name: "cc.Sprite",
      extends: RenderComponent,
      mixins: [ BlendFunc ],
      editor: false,
      ctor: function ctor() {
        cc.game.renderType === cc.game.RENDER_TYPE_CANVAS ? this._activateMaterial = this._activateMaterialCanvas : this._activateMaterial = this._activateMaterialWebgl;
      },
      properties: {
        _spriteFrame: {
          default: null,
          type: cc.SpriteFrame
        },
        _type: SpriteType.SIMPLE,
        _sizeMode: SizeMode.TRIMMED,
        _fillType: 0,
        _fillCenter: cc.v2(0, 0),
        _fillStart: 0,
        _fillRange: 0,
        _isTrimmedMode: true,
        _atlas: {
          default: null,
          type: cc.SpriteAtlas,
          tooltip: false,
          editorOnly: true,
          visible: true,
          animatable: false
        },
        spriteFrame: {
          get: function get() {
            return this._spriteFrame;
          },
          set: function set(value, force) {
            var lastSprite = this._spriteFrame;
            false;
            if (lastSprite === value) return;
            this._spriteFrame = value;
            this.markForUpdateRenderData(false);
            this._applySpriteFrame(lastSprite);
            false;
          },
          type: cc.SpriteFrame
        },
        type: {
          get: function get() {
            return this._type;
          },
          set: function set(value) {
            if (this._type !== value) {
              this._type = value;
              this._resetAssembler();
            }
          },
          type: SpriteType,
          animatable: false,
          tooltip: false
        },
        fillType: {
          get: function get() {
            return this._fillType;
          },
          set: function set(value) {
            if (value !== this._fillType) {
              this._fillType = value;
              this._resetAssembler();
            }
          },
          type: FillType,
          tooltip: false
        },
        fillCenter: {
          get: function get() {
            return this._fillCenter;
          },
          set: function set(value) {
            this._fillCenter.x = value.x;
            this._fillCenter.y = value.y;
            this._type === SpriteType.FILLED && this.setVertsDirty();
          },
          tooltip: false
        },
        fillStart: {
          get: function get() {
            return this._fillStart;
          },
          set: function set(value) {
            this._fillStart = misc.clampf(value, -1, 1);
            this._type === SpriteType.FILLED && this.setVertsDirty();
          },
          tooltip: false
        },
        fillRange: {
          get: function get() {
            return this._fillRange;
          },
          set: function set(value) {
            this._fillRange = misc.clampf(value, -1, 1);
            this._type === SpriteType.FILLED && this.setVertsDirty();
          },
          tooltip: false
        },
        trim: {
          get: function get() {
            return this._isTrimmedMode;
          },
          set: function set(value) {
            if (this._isTrimmedMode !== value) {
              this._isTrimmedMode = value;
              this._type !== SpriteType.SIMPLE && this._type !== SpriteType.MESH || this.setVertsDirty();
            }
          },
          animatable: false,
          tooltip: false
        },
        sizeMode: {
          get: function get() {
            return this._sizeMode;
          },
          set: function set(value) {
            this._sizeMode = value;
            value !== SizeMode.CUSTOM && this._applySpriteSize();
          },
          animatable: false,
          type: SizeMode,
          tooltip: false
        }
      },
      statics: {
        FillType: FillType,
        Type: SpriteType,
        SizeMode: SizeMode,
        State: State
      },
      setVisible: function setVisible(visible) {
        this.enabled = visible;
      },
      setState: function setState() {},
      getState: function getState() {},
      onEnable: function onEnable() {
        this._super();
        if (this._spriteFrame && this._spriteFrame.textureLoaded()) this._activateMaterial(); else {
          this.disableRender();
          if (this._spriteFrame) {
            this._spriteFrame.once("load", this._onTextureLoaded, this);
            this._spriteFrame.ensureLoadTexture();
          }
        }
      },
      _on3DNodeChanged: function _on3DNodeChanged() {
        this._resetAssembler();
      },
      _activateMaterialCanvas: function _activateMaterialCanvas() {
        this.setVertsDirty();
        this.markForUpdateRenderData(true);
        this.markForRender(true);
      },
      _activateMaterialWebgl: function _activateMaterialWebgl() {
        var spriteFrame = this._spriteFrame;
        if (!spriteFrame || !spriteFrame.textureLoaded()) {
          this.disableRender();
          return;
        }
        var material = this.sharedMaterials[0];
        material = material ? Material.getInstantiatedMaterial(material, this) : Material.getInstantiatedBuiltinMaterial("2d-sprite", this);
        material.setProperty("texture", spriteFrame.getTexture());
        this.setVertsDirty();
        this.setMaterial(0, material);
        this.markForRender(true);
      },
      _applyAtlas: false,
      _canRender: function _canRender() {
        if (cc.game.renderType === cc.game.RENDER_TYPE_CANVAS) {
          if (!this._enabled) return false;
        } else if (!this._enabled || !this.sharedMaterials[0] || !this.node._activeInHierarchy) return false;
        var spriteFrame = this._spriteFrame;
        if (!spriteFrame || !spriteFrame.textureLoaded()) return false;
        return true;
      },
      _applySpriteSize: function _applySpriteSize() {
        if (this._spriteFrame) {
          if (SizeMode.RAW === this._sizeMode) {
            var size = this._spriteFrame._originalSize;
            this.node.setContentSize(size);
          } else if (SizeMode.TRIMMED === this._sizeMode) {
            var rect = this._spriteFrame._rect;
            this.node.setContentSize(rect.width, rect.height);
          }
          this.setVertsDirty();
          this._activateMaterial();
        }
      },
      _onTextureLoaded: function _onTextureLoaded() {
        if (!this.isValid) return;
        this._applySpriteSize();
      },
      _applySpriteFrame: function _applySpriteFrame(oldFrame) {
        oldFrame && !oldFrame.textureLoaded() && oldFrame.off("load", this._onTextureLoaded, this);
        var spriteFrame = this._spriteFrame;
        if (spriteFrame) if (spriteFrame.textureLoaded()) this._applySpriteSize(); else {
          this.markForRender(false);
          spriteFrame.once("load", this._onTextureLoaded, this);
          spriteFrame.ensureLoadTexture();
        } else this.markForRender(false);
        false;
      },
      _resized: false
    });
    false;
    cc.Sprite = module.exports = Sprite;
  }), {
    "../CCNode": 53,
    "../assets/material/CCMaterial": 76,
    "../renderer/render-flow": 249,
    "../utils/blend-func": 292,
    "../utils/misc": 299,
    "./CCRenderComponent": 107
  } ],
  113: [ (function(require, module, exports) {
    "use strict";
    var ComponentType = cc.Enum({
      NONE: 0,
      CHECKBOX: 1,
      TEXT_ATLAS: 2,
      SLIDER_BAR: 3,
      LIST_VIEW: 4,
      PAGE_VIEW: 5
    });
    var ListDirection = cc.Enum({
      VERTICAL: 0,
      HORIZONTAL: 1
    });
    var VerticalAlign = cc.Enum({
      TOP: 0,
      CENTER: 1,
      BOTTOM: 2
    });
    var HorizontalAlign = cc.Enum({
      LEFT: 0,
      CENTER: 1,
      RIGHT: 2
    });
    var StudioComponent = cc.Class({
      name: "cc.StudioComponent",
      extends: cc.Component,
      editor: false,
      properties: false,
      statics: {
        ComponentType: ComponentType,
        ListDirection: ListDirection,
        VerticalAlign: VerticalAlign,
        HorizontalAlign: HorizontalAlign
      }
    });
    var PrefabHelper = require("../utils/prefab-helper");
    StudioComponent.PlaceHolder = cc.Class({
      name: "cc.StudioComponent.PlaceHolder",
      extends: cc.Component,
      properties: {
        _baseUrl: "",
        nestedPrefab: cc.Prefab
      },
      onLoad: function onLoad() {
        if (!this.nestedPrefab) {
          false;
          return;
        }
        this._replaceWithNestedPrefab();
      },
      _replaceWithNestedPrefab: function _replaceWithNestedPrefab() {
        var node = this.node;
        var _prefab = node._prefab;
        _prefab.root = node;
        _prefab.asset = this.nestedPrefab;
        PrefabHelper.syncWithPrefab(node);
      }
    });
    cc.StudioComponent = module.exports = StudioComponent;
    var StudioWidget = cc.Class({
      name: "cc.StudioWidget",
      extends: cc.Widget,
      editor: false,
      _validateTargetInDEV: function _validateTargetInDEV() {}
    });
    cc.StudioWidget = module.exports = StudioWidget;
  }), {
    "../utils/prefab-helper": 302
  } ],
  114: [ (function(require, module, exports) {
    "use strict";
    var GraySpriteState = require("../utils/gray-sprite-state");
    var Toggle = cc.Class({
      name: "cc.Toggle",
      extends: require("./CCButton"),
      mixins: [ GraySpriteState ],
      editor: false,
      properties: {
        _N$isChecked: true,
        isChecked: {
          get: function get() {
            return this._N$isChecked;
          },
          set: function set(value) {
            if (value === this._N$isChecked) return;
            var group = this.toggleGroup || this._toggleContainer;
            if (group && group.enabled && this._N$isChecked && !group.allowSwitchOff) return;
            this._N$isChecked = value;
            this._updateCheckMark();
            group && group.enabled && group.updateToggles(this);
            this._emitToggleEvents();
          },
          tooltip: false
        },
        toggleGroup: {
          default: null,
          tooltip: false,
          type: require("./CCToggleGroup")
        },
        checkMark: {
          default: null,
          type: cc.Sprite,
          tooltip: false
        },
        checkEvents: {
          default: [],
          type: cc.Component.EventHandler
        },
        _resizeToTarget: {
          animatable: false,
          set: function set(value) {
            value && this._resizeNodeToTargetNode();
          }
        }
      },
      onEnable: function onEnable() {
        this._super();
        true;
        this._registerToggleEvent();
        this.toggleGroup && this.toggleGroup.enabledInHierarchy && this.toggleGroup.addToggle(this);
      },
      onDisable: function onDisable() {
        this._super();
        true;
        this._unregisterToggleEvent();
        this.toggleGroup && this.toggleGroup.enabledInHierarchy && this.toggleGroup.removeToggle(this);
      },
      _hideCheckMark: function _hideCheckMark() {
        this._N$isChecked = false;
        this._updateCheckMark();
      },
      toggle: function toggle(event) {
        this.isChecked = !this.isChecked;
      },
      check: function check() {
        this.isChecked = true;
      },
      uncheck: function uncheck() {
        this.isChecked = false;
      },
      _updateCheckMark: function _updateCheckMark() {
        this.checkMark && (this.checkMark.node.active = !!this.isChecked);
      },
      _updateDisabledState: function _updateDisabledState() {
        this._super();
        if (this.enableAutoGrayEffect && this.checkMark) {
          var useGrayMaterial = !this.interactable;
          this._switchGrayMaterial(useGrayMaterial, this.checkMark);
        }
      },
      _registerToggleEvent: function _registerToggleEvent() {
        this.node.on("click", this.toggle, this);
      },
      _unregisterToggleEvent: function _unregisterToggleEvent() {
        this.node.off("click", this.toggle, this);
      },
      _emitToggleEvents: function _emitToggleEvents() {
        this.node.emit("toggle", this);
        this.checkEvents && cc.Component.EventHandler.emitEvents(this.checkEvents, this);
      }
    });
    cc.Toggle = module.exports = Toggle;
    var js = require("../platform/js");
    js.get(Toggle.prototype, "_toggleContainer", (function() {
      var parent = this.node.parent;
      if (cc.Node.isNode(parent)) return parent.getComponent(cc.ToggleContainer);
      return null;
    }));
  }), {
    "../platform/js": 219,
    "../utils/gray-sprite-state": 295,
    "./CCButton": 94,
    "./CCToggleGroup": 116
  } ],
  115: [ (function(require, module, exports) {
    "use strict";
    var ToggleContainer = cc.Class({
      name: "cc.ToggleContainer",
      extends: cc.Component,
      editor: false,
      properties: {
        allowSwitchOff: {
          tooltip: false,
          default: false
        },
        checkEvents: {
          default: [],
          type: cc.Component.EventHandler
        }
      },
      updateToggles: function updateToggles(toggle) {
        if (!this.enabledInHierarchy) return;
        if (toggle.isChecked) {
          this.toggleItems.forEach((function(item) {
            item !== toggle && item.isChecked && item.enabled && item._hideCheckMark();
          }));
          this.checkEvents && cc.Component.EventHandler.emitEvents(this.checkEvents, toggle);
        }
      },
      _allowOnlyOneToggleChecked: function _allowOnlyOneToggleChecked() {
        var isChecked = false;
        this.toggleItems.forEach((function(item) {
          isChecked ? item._hideCheckMark() : item.isChecked && (isChecked = true);
        }));
        return isChecked;
      },
      _makeAtLeastOneToggleChecked: function _makeAtLeastOneToggleChecked() {
        var isChecked = this._allowOnlyOneToggleChecked();
        if (!isChecked && !this.allowSwitchOff) {
          var toggleItems = this.toggleItems;
          toggleItems.length > 0 && toggleItems[0].check();
        }
      },
      onEnable: function onEnable() {
        this.node.on("child-added", this._allowOnlyOneToggleChecked, this);
        this.node.on("child-removed", this._makeAtLeastOneToggleChecked, this);
      },
      onDisable: function onDisable() {
        this.node.off("child-added", this._allowOnlyOneToggleChecked, this);
        this.node.off("child-removed", this._makeAtLeastOneToggleChecked, this);
      },
      start: function start() {
        this._makeAtLeastOneToggleChecked();
      }
    });
    var js = require("../platform/js");
    js.get(ToggleContainer.prototype, "toggleItems", (function() {
      return this.node.getComponentsInChildren(cc.Toggle);
    }));
    cc.ToggleContainer = module.exports = ToggleContainer;
  }), {
    "../platform/js": 219
  } ],
  116: [ (function(require, module, exports) {
    "use strict";
    var ToggleGroup = cc.Class({
      name: "cc.ToggleGroup",
      extends: cc.Component,
      ctor: function ctor() {
        this._toggleItems = [];
      },
      editor: false,
      properties: {
        allowSwitchOff: {
          tooltip: false,
          default: false
        },
        toggleItems: {
          get: function get() {
            return this._toggleItems;
          }
        }
      },
      updateToggles: function updateToggles(toggle) {
        if (!this.enabledInHierarchy) return;
        this._toggleItems.forEach((function(item) {
          toggle.isChecked && item !== toggle && item.isChecked && item.enabled && item._hideCheckMark();
        }));
      },
      addToggle: function addToggle(toggle) {
        var index = this._toggleItems.indexOf(toggle);
        -1 === index && this._toggleItems.push(toggle);
        this._allowOnlyOneToggleChecked();
      },
      removeToggle: function removeToggle(toggle) {
        var index = this._toggleItems.indexOf(toggle);
        index > -1 && this._toggleItems.splice(index, 1);
        this._makeAtLeastOneToggleChecked();
      },
      _allowOnlyOneToggleChecked: function _allowOnlyOneToggleChecked() {
        var isChecked = false;
        this._toggleItems.forEach((function(item) {
          isChecked && item.enabled && item._hideCheckMark();
          item.isChecked && item.enabled && (isChecked = true);
        }));
        return isChecked;
      },
      _makeAtLeastOneToggleChecked: function _makeAtLeastOneToggleChecked() {
        var isChecked = this._allowOnlyOneToggleChecked();
        isChecked || this.allowSwitchOff || this._toggleItems.length > 0 && (this._toggleItems[0].isChecked = true);
      },
      start: function start() {
        this._makeAtLeastOneToggleChecked();
      }
    });
    var js = require("../platform/js");
    var showed = false;
    js.get(cc, "ToggleGroup", (function() {
      if (!showed) {
        cc.logID(1405, "cc.ToggleGroup", "cc.ToggleContainer");
        showed = true;
      }
      return ToggleGroup;
    }));
    module.exports = ToggleGroup;
  }), {
    "../platform/js": 219
  } ],
  117: [ (function(require, module, exports) {
    "use strict";
    var ViewGroup = cc.Class({
      name: "cc.ViewGroup",
      extends: require("./CCComponent")
    });
    cc.ViewGroup = module.exports = ViewGroup;
  }), {
    "./CCComponent": 96
  } ],
  118: [ (function(require, module, exports) {
    "use strict";
    var WidgetManager = require("../base-ui/CCWidgetManager");
    var AlignMode = WidgetManager.AlignMode;
    var AlignFlags = WidgetManager._AlignFlags;
    var TOP = AlignFlags.TOP;
    var MID = AlignFlags.MID;
    var BOT = AlignFlags.BOT;
    var LEFT = AlignFlags.LEFT;
    var CENTER = AlignFlags.CENTER;
    var RIGHT = AlignFlags.RIGHT;
    var TOP_BOT = TOP | BOT;
    var LEFT_RIGHT = LEFT | RIGHT;
    var Widget = cc.Class({
      name: "cc.Widget",
      extends: require("./CCComponent"),
      editor: false,
      properties: {
        target: {
          get: function get() {
            return this._target;
          },
          set: function set(value) {
            this._target = value;
            false;
          },
          type: cc.Node,
          tooltip: false
        },
        isAlignTop: {
          get: function get() {
            return (this._alignFlags & TOP) > 0;
          },
          set: function set(value) {
            this._setAlign(TOP, value);
          },
          animatable: false,
          tooltip: false
        },
        isAlignVerticalCenter: {
          get: function get() {
            return (this._alignFlags & MID) > 0;
          },
          set: function set(value) {
            if (value) {
              this.isAlignTop = false;
              this.isAlignBottom = false;
              this._alignFlags |= MID;
            } else this._alignFlags &= ~MID;
          },
          animatable: false,
          tooltip: false
        },
        isAlignBottom: {
          get: function get() {
            return (this._alignFlags & BOT) > 0;
          },
          set: function set(value) {
            this._setAlign(BOT, value);
          },
          animatable: false,
          tooltip: false
        },
        isAlignLeft: {
          get: function get() {
            return (this._alignFlags & LEFT) > 0;
          },
          set: function set(value) {
            this._setAlign(LEFT, value);
          },
          animatable: false,
          tooltip: false
        },
        isAlignHorizontalCenter: {
          get: function get() {
            return (this._alignFlags & CENTER) > 0;
          },
          set: function set(value) {
            if (value) {
              this.isAlignLeft = false;
              this.isAlignRight = false;
              this._alignFlags |= CENTER;
            } else this._alignFlags &= ~CENTER;
          },
          animatable: false,
          tooltip: false
        },
        isAlignRight: {
          get: function get() {
            return (this._alignFlags & RIGHT) > 0;
          },
          set: function set(value) {
            this._setAlign(RIGHT, value);
          },
          animatable: false,
          tooltip: false
        },
        isStretchWidth: {
          get: function get() {
            return (this._alignFlags & LEFT_RIGHT) === LEFT_RIGHT;
          },
          visible: false
        },
        isStretchHeight: {
          get: function get() {
            return (this._alignFlags & TOP_BOT) === TOP_BOT;
          },
          visible: false
        },
        top: {
          get: function get() {
            return this._top;
          },
          set: function set(value) {
            this._top = value;
          },
          tooltip: false
        },
        bottom: {
          get: function get() {
            return this._bottom;
          },
          set: function set(value) {
            this._bottom = value;
          },
          tooltip: false
        },
        left: {
          get: function get() {
            return this._left;
          },
          set: function set(value) {
            this._left = value;
          },
          tooltip: false
        },
        right: {
          get: function get() {
            return this._right;
          },
          set: function set(value) {
            this._right = value;
          },
          tooltip: false
        },
        horizontalCenter: {
          get: function get() {
            return this._horizontalCenter;
          },
          set: function set(value) {
            this._horizontalCenter = value;
          },
          tooltip: false
        },
        verticalCenter: {
          get: function get() {
            return this._verticalCenter;
          },
          set: function set(value) {
            this._verticalCenter = value;
          },
          tooltip: false
        },
        isAbsoluteHorizontalCenter: {
          get: function get() {
            return this._isAbsHorizontalCenter;
          },
          set: function set(value) {
            this._isAbsHorizontalCenter = value;
          },
          animatable: false
        },
        isAbsoluteVerticalCenter: {
          get: function get() {
            return this._isAbsVerticalCenter;
          },
          set: function set(value) {
            this._isAbsVerticalCenter = value;
          },
          animatable: false
        },
        isAbsoluteTop: {
          get: function get() {
            return this._isAbsTop;
          },
          set: function set(value) {
            this._isAbsTop = value;
          },
          animatable: false
        },
        isAbsoluteBottom: {
          get: function get() {
            return this._isAbsBottom;
          },
          set: function set(value) {
            this._isAbsBottom = value;
          },
          animatable: false
        },
        isAbsoluteLeft: {
          get: function get() {
            return this._isAbsLeft;
          },
          set: function set(value) {
            this._isAbsLeft = value;
          },
          animatable: false
        },
        isAbsoluteRight: {
          get: function get() {
            return this._isAbsRight;
          },
          set: function set(value) {
            this._isAbsRight = value;
          },
          animatable: false
        },
        alignMode: {
          default: AlignMode.ON_WINDOW_RESIZE,
          type: AlignMode,
          tooltip: false
        },
        _wasAlignOnce: {
          default: void 0,
          formerlySerializedAs: "isAlignOnce"
        },
        _target: null,
        _alignFlags: 0,
        _left: 0,
        _right: 0,
        _top: 0,
        _bottom: 0,
        _verticalCenter: 0,
        _horizontalCenter: 0,
        _isAbsLeft: true,
        _isAbsRight: true,
        _isAbsTop: true,
        _isAbsBottom: true,
        _isAbsHorizontalCenter: true,
        _isAbsVerticalCenter: true,
        _originalWidth: 0,
        _originalHeight: 0
      },
      statics: {
        AlignMode: AlignMode
      },
      onLoad: function onLoad() {
        if (void 0 !== this._wasAlignOnce) {
          this.alignMode = this._wasAlignOnce ? AlignMode.ONCE : AlignMode.ALWAYS;
          this._wasAlignOnce = void 0;
        }
      },
      onEnable: function onEnable() {
        WidgetManager.add(this);
      },
      onDisable: function onDisable() {
        WidgetManager.remove(this);
      },
      _validateTargetInDEV: false,
      _setAlign: function _setAlign(flag, isAlign) {
        var current = (this._alignFlags & flag) > 0;
        if (isAlign === current) return;
        var isHorizontal = (flag & LEFT_RIGHT) > 0;
        if (isAlign) {
          this._alignFlags |= flag;
          if (isHorizontal) {
            this.isAlignHorizontalCenter = false;
            if (this.isStretchWidth) {
              this._originalWidth = this.node.width;
              false;
            }
          } else {
            this.isAlignVerticalCenter = false;
            if (this.isStretchHeight) {
              this._originalHeight = this.node.height;
              false;
            }
          }
          false;
        } else {
          isHorizontal ? this.isStretchWidth && (this.node.width = this._originalWidth) : this.isStretchHeight && (this.node.height = this._originalHeight);
          this._alignFlags &= ~flag;
        }
      },
      updateAlignment: function updateAlignment() {
        WidgetManager.updateAlignment(this.node);
      }
    });
    Object.defineProperty(Widget.prototype, "isAlignOnce", {
      get: function get() {
        true;
        cc.warn("`widget.isAlignOnce` is deprecated, use `widget.alignMode === cc.Widget.AlignMode.ONCE` instead please.");
        return this.alignMode === AlignMode.ONCE;
      },
      set: function set(value) {
        true;
        cc.warn("`widget.isAlignOnce` is deprecated, use `widget.alignMode = cc.Widget.AlignMode.*` instead please.");
        this.alignMode = value ? AlignMode.ONCE : AlignMode.ALWAYS;
      }
    });
    cc.Widget = module.exports = Widget;
  }), {
    "../base-ui/CCWidgetManager": 80,
    "./CCComponent": 96
  } ],
  119: [ (function(require, module, exports) {
    "use strict";
    var macro = require("../../platform/CCMacro");
    var EditBoxImplBase = require("../editbox/EditBoxImplBase");
    var Label = require("../CCLabel");
    var Types = require("./types");
    var InputMode = Types.InputMode;
    var InputFlag = Types.InputFlag;
    var KeyboardReturnType = Types.KeyboardReturnType;
    function capitalize(string) {
      return string.replace(/(?:^|\s)\S/g, (function(a) {
        return a.toUpperCase();
      }));
    }
    function capitalizeFirstLetter(string) {
      return string.charAt(0).toUpperCase() + string.slice(1);
    }
    var EditBox = cc.Class({
      name: "cc.EditBox",
      extends: cc.Component,
      editor: false,
      properties: {
        _useOriginalSize: true,
        _string: "",
        string: {
          tooltip: false,
          get: function get() {
            return this._string;
          },
          set: function set(value) {
            value = "" + value;
            this.maxLength >= 0 && value.length >= this.maxLength && (value = value.slice(0, this.maxLength));
            this._string = value;
            this._updateString(value);
          }
        },
        textLabel: {
          tooltip: false,
          default: null,
          type: Label,
          notify: function notify(oldValue) {
            if (this.textLabel && this.textLabel !== oldValue) {
              this._updateTextLabel();
              this._updateLabels();
            }
          }
        },
        placeholderLabel: {
          tooltip: false,
          default: null,
          type: Label,
          notify: function notify(oldValue) {
            if (this.placeholderLabel && this.placeholderLabel !== oldValue) {
              this._updatePlaceholderLabel();
              this._updateLabels();
            }
          }
        },
        background: {
          tooltip: false,
          default: null,
          type: cc.Sprite,
          notify: function notify(oldValue) {
            this.background && this.background !== oldValue && this._updateBackgroundSprite();
          }
        },
        _N$backgroundImage: {
          default: void 0,
          type: cc.SpriteFrame
        },
        backgroundImage: {
          get: function get() {
            if (!this.background) return null;
            return this.background.spriteFrame;
          },
          set: function set(value) {
            this.background && (this.background.spriteFrame = value);
          }
        },
        returnType: {
          default: KeyboardReturnType.DEFAULT,
          tooltip: false,
          displayName: "KeyboardReturnType",
          type: KeyboardReturnType
        },
        _N$returnType: {
          default: void 0,
          type: cc.Float
        },
        inputFlag: {
          tooltip: false,
          default: InputFlag.DEFAULT,
          type: InputFlag,
          notify: function notify() {
            this._updateString(this._string);
          }
        },
        inputMode: {
          tooltip: false,
          default: InputMode.ANY,
          type: InputMode,
          notify: function notify(oldValue) {
            if (this.inputMode !== oldValue) {
              this._updateTextLabel();
              this._updatePlaceholderLabel();
            }
          }
        },
        fontSize: {
          get: function get() {
            if (!this.textLabel) return null;
            return this.textLabel.fontSize;
          },
          set: function set(value) {
            this.textLabel && (this.textLabel.fontSize = value);
          }
        },
        _N$fontSize: {
          default: void 0,
          type: cc.Float
        },
        lineHeight: {
          get: function get() {
            if (!this.textLabel) return null;
            return this.textLabel.lineHeight;
          },
          set: function set(value) {
            this.textLabel && (this.textLabel.lineHeight = value);
          }
        },
        _N$lineHeight: {
          default: void 0,
          type: cc.Float
        },
        fontColor: {
          get: function get() {
            if (!this.textLabel) return null;
            return this.textLabel.node.color;
          },
          set: function set(value) {
            if (this.textLabel) {
              this.textLabel.node.color = value;
              this.textLabel.node.opacity = value.a;
            }
          }
        },
        _N$fontColor: void 0,
        placeholder: {
          tooltip: false,
          get: function get() {
            if (!this.placeholderLabel) return "";
            return this.placeholderLabel.string;
          },
          set: function set(value) {
            this.placeholderLabel && (this.placeholderLabel.string = value);
          }
        },
        _N$placeholder: {
          default: void 0,
          type: cc.String
        },
        placeholderFontSize: {
          get: function get() {
            if (!this.placeholderLabel) return null;
            return this.placeholderLabel.fontSize;
          },
          set: function set(value) {
            this.placeholderLabel && (this.placeholderLabel.fontSize = value);
          }
        },
        _N$placeholderFontSize: {
          default: void 0,
          type: cc.Float
        },
        placeholderFontColor: {
          get: function get() {
            if (!this.placeholderLabel) return null;
            return this.placeholderLabel.node.color;
          },
          set: function set(value) {
            if (this.placeholderLabel) {
              this.placeholderLabel.node.color = value;
              this.placeholderLabel.node.opacity = value.a;
            }
          }
        },
        _N$placeholderFontColor: void 0,
        maxLength: {
          tooltip: false,
          default: 20
        },
        _N$maxLength: {
          default: void 0,
          type: cc.Float
        },
        stayOnTop: {
          default: false,
          notify: function notify() {
            cc.warn("editBox.stayOnTop is removed since v2.1.");
          }
        },
        _tabIndex: 0,
        tabIndex: {
          tooltip: false,
          get: function get() {
            return this._tabIndex;
          },
          set: function set(value) {
            if (this._tabIndex !== value) {
              this._tabIndex = value;
              this._impl && this._impl.setTabIndex(value);
            }
          }
        },
        editingDidBegan: {
          default: [],
          type: cc.Component.EventHandler
        },
        textChanged: {
          default: [],
          type: cc.Component.EventHandler
        },
        editingDidEnded: {
          default: [],
          type: cc.Component.EventHandler
        },
        editingReturn: {
          default: [],
          type: cc.Component.EventHandler
        }
      },
      statics: {
        _ImplClass: EditBoxImplBase,
        KeyboardReturnType: KeyboardReturnType,
        InputFlag: InputFlag,
        InputMode: InputMode
      },
      _init: function _init() {
        this._upgradeComp();
        this._isLabelVisible = true;
        this.node.on(cc.Node.EventType.SIZE_CHANGED, this._syncSize, this);
        var impl = this._impl = new EditBox._ImplClass();
        impl.init(this);
        this._updateString(this._string);
        this._syncSize();
      },
      _updateBackgroundSprite: function _updateBackgroundSprite() {
        var background = this.background;
        if (!background) {
          var node = this.node.getChildByName("BACKGROUND_SPRITE");
          node || (node = new cc.Node("BACKGROUND_SPRITE"));
          background = node.getComponent(cc.Sprite);
          background || (background = node.addComponent(cc.Sprite));
          node.parent = this.node;
          this.background = background;
        }
        background.type = cc.Sprite.Type.SLICED;
        if (void 0 !== this._N$backgroundImage) {
          background.spriteFrame = this._N$backgroundImage;
          this._N$backgroundImage = void 0;
        }
      },
      _updateTextLabel: function _updateTextLabel() {
        var textLabel = this.textLabel;
        if (!textLabel) {
          var node = this.node.getChildByName("TEXT_LABEL");
          node || (node = new cc.Node("TEXT_LABEL"));
          textLabel = node.getComponent(Label);
          textLabel || (textLabel = node.addComponent(Label));
          node.parent = this.node;
          this.textLabel = textLabel;
        }
        textLabel.node.setAnchorPoint(0, 1);
        textLabel.overflow = Label.Overflow.CLAMP;
        if (this.inputMode === InputMode.ANY) {
          textLabel.verticalAlign = macro.VerticalTextAlignment.TOP;
          textLabel.enableWrapText = true;
        } else {
          textLabel.verticalAlign = macro.VerticalTextAlignment.CENTER;
          textLabel.enableWrapText = false;
        }
        textLabel.string = this._updateLabelStringStyle(this._string);
        if (void 0 !== this._N$fontColor) {
          textLabel.node.color = this._N$fontColor;
          textLabel.node.opacity = this._N$fontColor.a;
          this._N$fontColor = void 0;
        }
        if (void 0 !== this._N$fontSize) {
          textLabel.fontSize = this._N$fontSize;
          this._N$fontSize = void 0;
        }
        if (void 0 !== this._N$lineHeight) {
          textLabel.lineHeight = this._N$lineHeight;
          this._N$lineHeight = void 0;
        }
      },
      _updatePlaceholderLabel: function _updatePlaceholderLabel() {
        var placeholderLabel = this.placeholderLabel;
        if (!placeholderLabel) {
          var node = this.node.getChildByName("PLACEHOLDER_LABEL");
          node || (node = new cc.Node("PLACEHOLDER_LABEL"));
          placeholderLabel = node.getComponent(Label);
          placeholderLabel || (placeholderLabel = node.addComponent(Label));
          node.parent = this.node;
          this.placeholderLabel = placeholderLabel;
        }
        placeholderLabel.node.setAnchorPoint(0, 1);
        placeholderLabel.overflow = Label.Overflow.CLAMP;
        if (this.inputMode === InputMode.ANY) {
          placeholderLabel.verticalAlign = macro.VerticalTextAlignment.TOP;
          placeholderLabel.enableWrapText = true;
        } else {
          placeholderLabel.verticalAlign = macro.VerticalTextAlignment.CENTER;
          placeholderLabel.enableWrapText = false;
        }
        placeholderLabel.string = this.placeholder;
        if (void 0 !== this._N$placeholderFontColor) {
          placeholderLabel.node.color = this._N$placeholderFontColor;
          placeholderLabel.node.opacity = this._N$placeholderFontColor.a;
          this._N$placeholderFontColor = void 0;
        }
        if (void 0 !== this._N$placeholderFontSize) {
          placeholderLabel.fontSize = this._N$placeholderFontSize;
          this._N$placeholderFontSize = void 0;
        }
      },
      _upgradeComp: function _upgradeComp() {
        if (void 0 !== this._N$returnType) {
          this.returnType = this._N$returnType;
          this._N$returnType = void 0;
        }
        if (void 0 !== this._N$maxLength) {
          this.maxLength = this._N$maxLength;
          this._N$maxLength = void 0;
        }
        void 0 !== this._N$backgroundImage && this._updateBackgroundSprite();
        void 0 === this._N$fontColor && void 0 === this._N$fontSize && void 0 === this._N$lineHeight || this._updateTextLabel();
        void 0 === this._N$placeholderFontColor && void 0 === this._N$placeholderFontSize || this._updatePlaceholderLabel();
        if (void 0 !== this._N$placeholder) {
          this.placeholder = this._N$placeholder;
          this._N$placeholder = void 0;
        }
      },
      _syncSize: function _syncSize() {
        if (this._impl) {
          var size = this.node.getContentSize();
          this._impl.setSize(size.width, size.height);
        }
      },
      _showLabels: function _showLabels() {
        this._isLabelVisible = true;
        this._updateLabels();
      },
      _hideLabels: function _hideLabels() {
        this._isLabelVisible = false;
        this.textLabel && (this.textLabel.node.active = false);
        this.placeholderLabel && (this.placeholderLabel.node.active = false);
      },
      _updateLabels: function _updateLabels() {
        if (this._isLabelVisible) {
          var content = this._string;
          this.textLabel && (this.textLabel.node.active = "" !== content);
          this.placeholderLabel && (this.placeholderLabel.node.active = "" === content);
        }
      },
      _updateString: function _updateString(text) {
        var textLabel = this.textLabel;
        if (!textLabel) return;
        var displayText = text;
        displayText && (displayText = this._updateLabelStringStyle(displayText));
        textLabel.string = displayText;
        this._updateLabels();
      },
      _updateLabelStringStyle: function _updateLabelStringStyle(text, ignorePassword) {
        var inputFlag = this.inputFlag;
        if (ignorePassword || inputFlag !== InputFlag.PASSWORD) inputFlag === InputFlag.INITIAL_CAPS_ALL_CHARACTERS ? text = text.toUpperCase() : inputFlag === InputFlag.INITIAL_CAPS_WORD ? text = capitalize(text) : inputFlag === InputFlag.INITIAL_CAPS_SENTENCE && (text = capitalizeFirstLetter(text)); else {
          var passwordString = "";
          var len = text.length;
          for (var i = 0; i < len; ++i) passwordString += "\u25cf";
          text = passwordString;
        }
        return text;
      },
      editBoxEditingDidBegan: function editBoxEditingDidBegan() {
        cc.Component.EventHandler.emitEvents(this.editingDidBegan, this);
        this.node.emit("editing-did-began", this);
      },
      editBoxEditingDidEnded: function editBoxEditingDidEnded() {
        cc.Component.EventHandler.emitEvents(this.editingDidEnded, this);
        this.node.emit("editing-did-ended", this);
      },
      editBoxTextChanged: function editBoxTextChanged(text) {
        text = this._updateLabelStringStyle(text, true);
        this.string = text;
        cc.Component.EventHandler.emitEvents(this.textChanged, text, this);
        this.node.emit("text-changed", this);
      },
      editBoxEditingReturn: function editBoxEditingReturn() {
        cc.Component.EventHandler.emitEvents(this.editingReturn, this);
        this.node.emit("editing-return", this);
      },
      onEnable: function onEnable() {
        true;
        this._registerEvent();
        this._impl && this._impl.enable();
      },
      onDisable: function onDisable() {
        true;
        this._unregisterEvent();
        this._impl && this._impl.disable();
      },
      onDestroy: function onDestroy() {
        this._impl && this._impl.clear();
      },
      __preload: function __preload() {
        this._init();
      },
      _registerEvent: function _registerEvent() {
        this.node.on(cc.Node.EventType.TOUCH_START, this._onTouchBegan, this);
        this.node.on(cc.Node.EventType.TOUCH_END, this._onTouchEnded, this);
      },
      _unregisterEvent: function _unregisterEvent() {
        this.node.off(cc.Node.EventType.TOUCH_START, this._onTouchBegan, this);
        this.node.off(cc.Node.EventType.TOUCH_END, this._onTouchEnded, this);
      },
      _onTouchBegan: function _onTouchBegan(event) {
        event.stopPropagation();
      },
      _onTouchCancel: function _onTouchCancel(event) {
        event.stopPropagation();
      },
      _onTouchEnded: function _onTouchEnded(event) {
        this._impl && this._impl.beginEditing();
        event.stopPropagation();
      },
      setFocus: function setFocus() {
        cc.warnID(1400, "setFocus()", "focus()");
        this._impl && this._impl.setFocus(true);
      },
      focus: function focus() {
        this._impl && this._impl.setFocus(true);
      },
      blur: function blur() {
        this._impl && this._impl.setFocus(false);
      },
      isFocused: function isFocused() {
        return !!this._impl && this._impl.isFocused();
      },
      update: function update() {
        this._impl && this._impl.update();
      }
    });
    cc.EditBox = module.exports = EditBox;
    cc.sys.isBrowser && require("./WebEditBoxImpl");
  }), {
    "../../platform/CCMacro": 204,
    "../CCLabel": 98,
    "../editbox/EditBoxImplBase": 120,
    "./WebEditBoxImpl": 121,
    "./types": 123
  } ],
  120: [ (function(require, module, exports) {
    "use strict";
    var EditBoxImplBase = cc.Class({
      ctor: function ctor() {
        this._delegate = null;
        this._editing = false;
      },
      init: function init(delegate) {},
      enable: function enable() {},
      disable: function disable() {
        this._editing && this.endEditing();
      },
      clear: function clear() {},
      update: function update() {},
      setTabIndex: function setTabIndex(index) {},
      setSize: function setSize(width, height) {},
      setFocus: function setFocus(value) {
        value ? this.beginEditing() : this.endEditing();
      },
      isFocused: function isFocused() {
        return this._editing;
      },
      beginEditing: function beginEditing() {},
      endEditing: function endEditing() {}
    });
    module.exports = EditBoxImplBase;
  }), {} ],
  121: [ (function(require, module, exports) {
    "use strict";
    var utils = require("../../platform/utils");
    var macro = require("../../platform/CCMacro");
    var Types = require("./types");
    var Label = require("../CCLabel");
    var tabIndexUtil = require("./tabIndexUtil");
    var EditBox = cc.EditBox;
    var js = cc.js;
    var InputMode = Types.InputMode;
    var InputFlag = Types.InputFlag;
    var KeyboardReturnType = Types.KeyboardReturnType;
    var math = cc.vmath;
    var polyfill = {
      zoomInvalid: false
    };
    cc.sys.OS_ANDROID !== cc.sys.os || cc.sys.browserType !== cc.sys.BROWSER_TYPE_SOUGOU && cc.sys.browserType !== cc.sys.BROWSER_TYPE_360 || (polyfill.zoomInvalid = true);
    var DELAY_TIME = 800;
    var SCROLLY = 100;
    var LEFT_PADDING = 2;
    var _domCount = 0;
    var _vec3 = cc.v3();
    var _currentEditBoxImpl = null;
    var _fullscreen = false;
    var _autoResize = false;
    var BaseClass = EditBox._ImplClass;
    function WebEditBoxImpl() {
      BaseClass.call(this);
      this._domId = "EditBoxId_" + ++_domCount;
      this._placeholderStyleSheet = null;
      this._elem = null;
      this._isTextArea = false;
      this._worldMat = math.mat4.create();
      this._cameraMat = math.mat4.create();
      this._m00 = 0;
      this._m01 = 0;
      this._m04 = 0;
      this._m05 = 0;
      this._m12 = 0;
      this._m13 = 0;
      this._w = 0;
      this._h = 0;
      this._inputMode = null;
      this._inputFlag = null;
      this._returnType = null;
      this._eventListeners = {};
      this._textLabelFont = null;
      this._textLabelFontSize = null;
      this._textLabelFontColor = null;
      this._textLabelAlign = null;
      this._placeholderLabelFont = null;
      this._placeholderLabelFontSize = null;
      this._placeholderLabelFontColor = null;
      this._placeholderLabelAlign = null;
      this._placeholderLineHeight = null;
    }
    js.extend(WebEditBoxImpl, BaseClass);
    EditBox._ImplClass = WebEditBoxImpl;
    Object.assign(WebEditBoxImpl.prototype, {
      init: function init(delegate) {
        if (!delegate) return;
        this._delegate = delegate;
        delegate.inputMode === InputMode.ANY ? this._createTextArea() : this._createInput();
        tabIndexUtil.add(this);
        this.setTabIndex(delegate.tabIndex);
        this._initStyleSheet();
        this._registerEventListeners();
        this._addDomToGameContainer();
        _fullscreen = cc.view.isAutoFullScreenEnabled();
        _autoResize = cc.view._resizeWithBrowserSize;
      },
      clear: function clear() {
        this._removeEventListeners();
        this._removeDomFromGameContainer();
        tabIndexUtil.remove(this);
        _currentEditBoxImpl === this && (_currentEditBoxImpl = null);
      },
      update: function update() {
        this._updateMatrix();
      },
      setTabIndex: function setTabIndex(index) {
        this._elem.tabIndex = index;
        tabIndexUtil.resort();
      },
      setSize: function setSize(width, height) {
        var elem = this._elem;
        elem.style.width = width + "px";
        elem.style.height = height + "px";
      },
      beginEditing: function beginEditing() {
        _currentEditBoxImpl && _currentEditBoxImpl !== this && _currentEditBoxImpl.setFocus(false);
        this._editing = true;
        _currentEditBoxImpl = this;
        this._delegate.editBoxEditingDidBegan();
        this._showDom();
        this._elem.focus();
      },
      endEditing: function endEditing() {
        this._elem && this._elem.blur();
      },
      _createInput: function _createInput() {
        this._isTextArea = false;
        this._elem = document.createElement("input");
      },
      _createTextArea: function _createTextArea() {
        this._isTextArea = true;
        this._elem = document.createElement("textarea");
      },
      _addDomToGameContainer: function _addDomToGameContainer() {
        cc.game.container.appendChild(this._elem);
        document.head.appendChild(this._placeholderStyleSheet);
      },
      _removeDomFromGameContainer: function _removeDomFromGameContainer() {
        var hasElem = utils.contains(cc.game.container, this._elem);
        hasElem && cc.game.container.removeChild(this._elem);
        var hasStyleSheet = utils.contains(document.head, this._placeholderStyleSheet);
        hasStyleSheet && document.head.removeChild(this._placeholderStyleSheet);
        delete this._elem;
        delete this._placeholderStyleSheet;
      },
      _showDom: function _showDom() {
        this._updateMaxLength();
        this._updateInputType();
        this._updateStyleSheet();
        this._elem.style.display = "";
        this._delegate._hideLabels();
        cc.sys.isMobile && this._showDomOnMobile();
      },
      _hideDom: function _hideDom() {
        var elem = this._elem;
        elem.style.display = "none";
        this._delegate._showLabels();
        cc.sys.isMobile && this._hideDomOnMobile();
      },
      _showDomOnMobile: function _showDomOnMobile() {
        if (cc.sys.os !== cc.sys.OS_ANDROID) return;
        if (_fullscreen) {
          cc.view.enableAutoFullScreen(false);
          cc.screen.exitFullScreen();
        }
        _autoResize && cc.view.resizeWithBrowserSize(false);
        this._adjustWindowScroll();
      },
      _hideDomOnMobile: function _hideDomOnMobile() {
        cc.sys.os === cc.sys.OS_ANDROID && setTimeout((function() {
          if (!_currentEditBoxImpl) {
            _fullscreen && cc.view.enableAutoFullScreen(true);
            _autoResize && cc.view.resizeWithBrowserSize(true);
          }
        }), DELAY_TIME);
        this._scrollBackWindow();
      },
      _adjustWindowScroll: function _adjustWindowScroll() {
        var self = this;
        setTimeout((function() {
          window.scrollY < SCROLLY && self._elem.scrollIntoView({
            block: "start",
            inline: "nearest",
            behavior: "smooth"
          });
        }), DELAY_TIME);
      },
      _scrollBackWindow: function _scrollBackWindow() {
        setTimeout((function() {
          var sys = cc.sys;
          if (sys.browserType === sys.BROWSER_TYPE_WECHAT && sys.os === sys.OS_IOS) {
            window.top && window.top.scrollTo(0, 0);
            return;
          }
          window.scrollTo(0, 0);
        }), DELAY_TIME);
      },
      _updateMatrix: function _updateMatrix() {
        var node = this._delegate.node;
        node.getWorldMatrix(this._worldMat);
        var worldMat = this._worldMat;
        var worldMatm = worldMat.m;
        if (this._m00 === worldMatm[0] && this._m01 === worldMatm[1] && this._m04 === worldMatm[4] && this._m05 === worldMatm[5] && this._m12 === worldMatm[12] && this._m13 === worldMatm[13] && this._w === node._contentSize.width && this._h === node._contentSize.height) return;
        this._m00 = worldMatm[0];
        this._m01 = worldMatm[1];
        this._m04 = worldMatm[4];
        this._m05 = worldMatm[5];
        this._m12 = worldMatm[12];
        this._m13 = worldMatm[13];
        this._w = node._contentSize.width;
        this._h = node._contentSize.height;
        var scaleX = cc.view._scaleX, scaleY = cc.view._scaleY, viewport = cc.view._viewportRect, dpr = cc.view._devicePixelRatio;
        _vec3.x = -node._anchorPoint.x * this._w;
        _vec3.y = -node._anchorPoint.y * this._h;
        math.mat4.translate(worldMat, worldMat, _vec3);
        var cameraMat = void 0;
        false;
        var camera = cc.Camera.findCamera(node);
        camera.getWorldToScreenMatrix2D(this._cameraMat);
        cameraMat = this._cameraMat;
        math.mat4.mul(cameraMat, cameraMat, worldMat);
        scaleX /= dpr;
        scaleY /= dpr;
        var container = cc.game.container;
        var cameraMatm = cameraMat.m;
        var a = cameraMatm[0] * scaleX, b = cameraMatm[1], c = cameraMatm[4], d = cameraMatm[5] * scaleY;
        var offsetX = container && container.style.paddingLeft && parseInt(container.style.paddingLeft);
        offsetX += viewport.x / dpr;
        var offsetY = container && container.style.paddingBottom && parseInt(container.style.paddingBottom);
        offsetY += viewport.y / dpr;
        var tx = cameraMatm[12] * scaleX + offsetX, ty = cameraMatm[13] * scaleY + offsetY;
        if (polyfill.zoomInvalid) {
          this.setSize(node.width * a, node.height * d);
          a = 1;
          d = 1;
        }
        var elem = this._elem;
        var matrix = "matrix(" + a + "," + -b + "," + -c + "," + d + "," + tx + "," + -ty + ")";
        elem.style["transform"] = matrix;
        elem.style["-webkit-transform"] = matrix;
        elem.style["transform-origin"] = "0px 100% 0px";
        elem.style["-webkit-transform-origin"] = "0px 100% 0px";
      },
      _updateInputType: function _updateInputType() {
        var delegate = this._delegate, inputMode = delegate.inputMode, inputFlag = delegate.inputFlag, returnType = delegate.returnType, elem = this._elem;
        if (this._inputMode === inputMode && this._inputFlag === inputFlag && this._returnType === returnType) return;
        this._inputMode = inputMode;
        this._inputFlag = inputFlag;
        this._returnType = returnType;
        if (this._isTextArea) {
          var _textTransform = "none";
          inputFlag === InputFlag.INITIAL_CAPS_ALL_CHARACTERS ? _textTransform = "uppercase" : inputFlag === InputFlag.INITIAL_CAPS_WORD && (_textTransform = "capitalize");
          elem.style.textTransform = _textTransform;
          return;
        }
        if (inputFlag === InputFlag.PASSWORD) {
          elem.type = "password";
          return;
        }
        var type = elem.type;
        if (inputMode === InputMode.EMAIL_ADDR) type = "email"; else if (inputMode === InputMode.NUMERIC || inputMode === InputMode.DECIMAL) type = "number"; else if (inputMode === InputMode.PHONE_NUMBER) {
          type = "number";
          elem.pattern = "[0-9]*";
        } else if (inputMode === InputMode.URL) type = "url"; else {
          type = "text";
          returnType === KeyboardReturnType.SEARCH && (type = "search");
        }
        elem.type = type;
        var textTransform = "none";
        inputFlag === InputFlag.INITIAL_CAPS_ALL_CHARACTERS ? textTransform = "uppercase" : inputFlag === InputFlag.INITIAL_CAPS_WORD && (textTransform = "capitalize");
        elem.style.textTransform = textTransform;
      },
      _updateMaxLength: function _updateMaxLength() {
        var maxLength = this._delegate.maxLength;
        maxLength < 0 && (maxLength = 65535);
        this._elem.maxLength = maxLength;
      },
      _initStyleSheet: function _initStyleSheet() {
        var elem = this._elem;
        elem.style.display = "none";
        elem.style.border = 0;
        elem.style.background = "transparent";
        elem.style.width = "100%";
        elem.style.height = "100%";
        elem.style.active = 0;
        elem.style.outline = "medium";
        elem.style.padding = "0";
        elem.style.textTransform = "uppercase";
        elem.style.position = "absolute";
        elem.style.bottom = "0px";
        elem.style.left = LEFT_PADDING + "px";
        elem.className = "cocosEditBox";
        elem.id = this._domId;
        if (this._isTextArea) {
          elem.style.resize = "none";
          elem.style.overflow_y = "scroll";
        } else {
          elem.type = "text";
          elem.style["-moz-appearance"] = "textfield";
        }
        this._placeholderStyleSheet = document.createElement("style");
      },
      _updateStyleSheet: function _updateStyleSheet() {
        var delegate = this._delegate, elem = this._elem;
        elem.value = delegate.string;
        elem.placeholder = delegate.placeholder;
        this._updateTextLabel(delegate.textLabel);
        this._updatePlaceholderLabel(delegate.placeholderLabel);
      },
      _updateTextLabel: function _updateTextLabel(textLabel) {
        if (!textLabel) return;
        var font = textLabel.font;
        font = !font || font instanceof cc.BitmapFont ? textLabel.fontFamily : font._fontFamily;
        var fontSize = textLabel.fontSize * textLabel.node.scaleY;
        if (this._textLabelFont === font && this._textLabelFontSize === fontSize && this._textLabelFontColor === textLabel.fontColor && this._textLabelAlign === textLabel.horizontalAlign) return;
        this._textLabelFont = font;
        this._textLabelFontSize = fontSize;
        this._textLabelFontColor = textLabel.fontColor;
        this._textLabelAlign = textLabel.horizontalAlign;
        var elem = this._elem;
        elem.style.fontSize = fontSize + "px";
        elem.style.color = textLabel.node.color.toCSS("rgba");
        elem.style.fontFamily = font;
        switch (textLabel.horizontalAlign) {
         case Label.HorizontalAlign.LEFT:
          elem.style.textAlign = "left";
          break;

         case Label.HorizontalAlign.CENTER:
          elem.style.textAlign = "center";
          break;

         case Label.HorizontalAlign.RIGHT:
          elem.style.textAlign = "right";
        }
      },
      _updatePlaceholderLabel: function _updatePlaceholderLabel(placeholderLabel) {
        if (!placeholderLabel) return;
        var font = placeholderLabel.font;
        font = !font || font instanceof cc.BitmapFont ? placeholderLabel.fontFamily : placeholderLabel.font._fontFamily;
        var fontSize = placeholderLabel.fontSize * placeholderLabel.node.scaleY;
        if (this._placeholderLabelFont === font && this._placeholderLabelFontSize === fontSize && this._placeholderLabelFontColor === placeholderLabel.fontColor && this._placeholderLabelAlign === placeholderLabel.horizontalAlign && this._placeholderLineHeight === placeholderLabel.fontSize) return;
        this._placeholderLabelFont = font;
        this._placeholderLabelFontSize = fontSize;
        this._placeholderLabelFontColor = placeholderLabel.fontColor;
        this._placeholderLabelAlign = placeholderLabel.horizontalAlign;
        this._placeholderLineHeight = placeholderLabel.fontSize;
        var styleEl = this._placeholderStyleSheet;
        var fontColor = placeholderLabel.node.color.toCSS("rgba");
        var lineHeight = placeholderLabel.fontSize;
        var horizontalAlign = void 0;
        switch (placeholderLabel.horizontalAlign) {
         case Label.HorizontalAlign.LEFT:
          horizontalAlign = "left";
          break;

         case Label.HorizontalAlign.CENTER:
          horizontalAlign = "center";
          break;

         case Label.HorizontalAlign.RIGHT:
          horizontalAlign = "right";
        }
        styleEl.innerHTML = "#" + this._domId + "::-webkit-input-placeholder,#" + this._domId + "::-moz-placeholder,#" + this._domId + ":-ms-input-placeholder{text-transform: initial; font-family: " + font + "; font-size: " + fontSize + "px; color: " + fontColor + "; line-height: " + lineHeight + "px; text-align: " + horizontalAlign + ";}";
        cc.sys.browserType === cc.sys.BROWSER_TYPE_EDGE && (styleEl.innerHTML += "#" + this._domId + "::-ms-clear{display: none;}");
      },
      _registerEventListeners: function _registerEventListeners() {
        var impl = this, elem = this._elem, inputLock = false, cbs = this._eventListeners;
        cbs.compositionStart = function() {
          inputLock = true;
        };
        cbs.compositionEnd = function() {
          inputLock = false;
          impl._delegate.editBoxTextChanged(elem.value);
        };
        cbs.onInput = function() {
          if (inputLock) return;
          impl._delegate.editBoxTextChanged(elem.value);
        };
        cbs.onClick = function(e) {
          impl._editing && cc.sys.isMobile && impl._adjustWindowScroll();
        };
        cbs.onKeydown = function(e) {
          if (e.keyCode === macro.KEY.enter) {
            e.stopPropagation();
            impl._delegate.editBoxEditingReturn();
            impl._isTextArea || elem.blur();
          } else if (e.keyCode === macro.KEY.tab) {
            e.stopPropagation();
            e.preventDefault();
            tabIndexUtil.next(impl);
          }
        };
        cbs.onBlur = function() {
          impl._editing = false;
          _currentEditBoxImpl = null;
          impl._hideDom();
          impl._delegate.editBoxEditingDidEnded();
        };
        elem.addEventListener("compositionstart", cbs.compositionStart);
        elem.addEventListener("compositionend", cbs.compositionEnd);
        elem.addEventListener("input", cbs.onInput);
        elem.addEventListener("keydown", cbs.onKeydown);
        elem.addEventListener("blur", cbs.onBlur);
        elem.addEventListener("touchstart", cbs.onClick);
      },
      _removeEventListeners: function _removeEventListeners() {
        var elem = this._elem, cbs = this._eventListeners;
        elem.removeEventListener("compositionstart", cbs.compositionStart);
        elem.removeEventListener("compositionend", cbs.compositionEnd);
        elem.removeEventListener("input", cbs.onInput);
        elem.removeEventListener("keydown", cbs.onKeydown);
        elem.removeEventListener("blur", cbs.onBlur);
        elem.removeEventListener("touchstart", cbs.onClick);
        cbs.compositionStart = null;
        cbs.compositionEnd = null;
        cbs.onInput = null;
        cbs.onKeydown = null;
        cbs.onBlur = null;
        cbs.onClick = null;
      }
    });
  }), {
    "../../platform/CCMacro": 204,
    "../../platform/utils": 223,
    "../CCLabel": 98,
    "./tabIndexUtil": 122,
    "./types": 123
  } ],
  122: [ (function(require, module, exports) {
    "use strict";
    var tabIndexUtil = {
      _tabIndexList: [],
      add: function add(editBoxImpl) {
        var list = this._tabIndexList;
        var index = list.indexOf(editBoxImpl);
        -1 === index && list.push(editBoxImpl);
      },
      remove: function remove(editBoxImpl) {
        var list = this._tabIndexList;
        var index = list.indexOf(editBoxImpl);
        -1 !== index && list.splice(index, 1);
      },
      resort: function resort() {
        this._tabIndexList.sort((function(a, b) {
          return a._delegate._tabIndex - b._delegate._tabIndex;
        }));
      },
      next: function next(editBoxImpl) {
        var list = this._tabIndexList;
        var index = list.indexOf(editBoxImpl);
        editBoxImpl.setFocus(false);
        if (-1 !== index) {
          var nextImpl = list[index + 1];
          nextImpl && nextImpl._delegate._tabIndex >= 0 && nextImpl.setFocus(true);
        }
      }
    };
    module.exports = tabIndexUtil;
  }), {} ],
  123: [ (function(require, module, exports) {
    "use strict";
    var KeyboardReturnType = cc.Enum({
      DEFAULT: 0,
      DONE: 1,
      SEND: 2,
      SEARCH: 3,
      GO: 4,
      NEXT: 5
    });
    var InputMode = cc.Enum({
      ANY: 0,
      EMAIL_ADDR: 1,
      NUMERIC: 2,
      PHONE_NUMBER: 3,
      URL: 4,
      DECIMAL: 5,
      SINGLE_LINE: 6
    });
    var InputFlag = cc.Enum({
      PASSWORD: 0,
      SENSITIVE: 1,
      INITIAL_CAPS_WORD: 2,
      INITIAL_CAPS_SENTENCE: 3,
      INITIAL_CAPS_ALL_CHARACTERS: 4,
      DEFAULT: 5
    });
    module.exports = {
      KeyboardReturnType: KeyboardReturnType,
      InputMode: InputMode,
      InputFlag: InputFlag
    };
  }), {} ],
  124: [ (function(require, module, exports) {
    "use strict";
    require("./CCComponent");
    require("./CCComponentEventHandler");
    require("./missing-script");
    var WXSubContextView = require("./WXSubContextView");
    var SwanSubContextView = require("./SwanSubContextView");
    WXSubContextView || (WXSubContextView = cc.Class({
      name: "cc.WXSubContextView",
      extends: cc.Component
    }));
    SwanSubContextView || (SwanSubContextView = cc.Class({
      name: "cc.SwanSubContextView",
      extends: cc.Component
    }));
    var components = [ require("./CCSprite"), require("./CCWidget"), require("./CCCanvas"), require("./CCAudioSource"), require("./CCAnimation"), require("./CCButton"), require("./CCLabel"), require("./CCProgressBar"), require("./CCMask"), require("./CCScrollBar"), require("./CCScrollView"), require("./CCPageViewIndicator"), require("./CCPageView"), require("./CCSlider"), require("./CCLayout"), require("./editbox/CCEditBox"), require("./CCLabelOutline"), require("./CCLabelShadow"), require("./CCRichText"), require("./CCToggleContainer"), require("./CCToggleGroup"), require("./CCToggle"), require("./CCBlockInputEvents"), require("./CCMotionStreak"), WXSubContextView, SwanSubContextView ];
    module.exports = components;
  }), {
    "./CCAnimation": 91,
    "./CCAudioSource": 92,
    "./CCBlockInputEvents": 93,
    "./CCButton": 94,
    "./CCCanvas": 95,
    "./CCComponent": 96,
    "./CCComponentEventHandler": 97,
    "./CCLabel": 98,
    "./CCLabelOutline": 99,
    "./CCLabelShadow": 100,
    "./CCLayout": 101,
    "./CCMask": 102,
    "./CCMotionStreak": 103,
    "./CCPageView": 104,
    "./CCPageViewIndicator": 105,
    "./CCProgressBar": 106,
    "./CCRichText": 108,
    "./CCScrollBar": 109,
    "./CCScrollView": 110,
    "./CCSlider": 111,
    "./CCSprite": 112,
    "./CCToggle": 114,
    "./CCToggleContainer": 115,
    "./CCToggleGroup": 116,
    "./CCWidget": 118,
    "./SwanSubContextView": void 0,
    "./WXSubContextView": void 0,
    "./editbox/CCEditBox": 119,
    "./missing-script": 125
  } ],
  125: [ (function(require, module, exports) {
    "use strict";
    var js = cc.js;
    var BUILTIN_CLASSID_RE = require("../utils/misc").BUILTIN_CLASSID_RE;
    var MissingClass = cc.Class({
      name: "cc.MissingClass",
      properties: {
        _$erialized: {
          default: null,
          visible: false,
          editorOnly: true
        }
      }
    });
    var MissingScript = cc.Class({
      name: "cc.MissingScript",
      extends: cc.Component,
      editor: {
        inspector: "packages://inspector/inspectors/comps/missing-script.js"
      },
      properties: {
        compiled: {
          default: false,
          serializable: false
        },
        _$erialized: {
          default: null,
          visible: false,
          editorOnly: true
        }
      },
      ctor: false,
      statics: {
        safeFindClass: function safeFindClass(id, data) {
          var cls = js._getClassById(id);
          if (cls) return cls;
          if (id) {
            cc.deserialize.reportMissingClass(id);
            return MissingScript.getMissingWrapper(id, data);
          }
          return null;
        },
        getMissingWrapper: function getMissingWrapper(id, data) {
          return data.node && (/^[0-9a-zA-Z+/]{23}$/.test(id) || BUILTIN_CLASSID_RE.test(id)) ? MissingScript : MissingClass;
        }
      },
      onLoad: function onLoad() {
        cc.warnID(4600, this.node.name);
      }
    });
    cc._MissingScript = module.exports = MissingScript;
  }), {
    "../utils/misc": 299
  } ],
  126: [ (function(require, module, exports) {
    "use strict";
    var js = cc.js;
    require("../event/event");
    var EventMouse = function EventMouse(eventType, bubbles) {
      cc.Event.call(this, cc.Event.MOUSE, bubbles);
      this._eventType = eventType;
      this._button = 0;
      this._x = 0;
      this._y = 0;
      this._prevX = 0;
      this._prevY = 0;
      this._scrollX = 0;
      this._scrollY = 0;
    };
    js.extend(EventMouse, cc.Event);
    var proto = EventMouse.prototype;
    proto.setScrollData = function(scrollX, scrollY) {
      this._scrollX = scrollX;
      this._scrollY = scrollY;
    };
    proto.getScrollX = function() {
      return this._scrollX;
    };
    proto.getScrollY = function() {
      return this._scrollY;
    };
    proto.setLocation = function(x, y) {
      this._x = x;
      this._y = y;
    };
    proto.getLocation = function() {
      return cc.v2(this._x, this._y);
    };
    proto.getLocationInView = function() {
      return cc.v2(this._x, cc.view._designResolutionSize.height - this._y);
    };
    proto._setPrevCursor = function(x, y) {
      this._prevX = x;
      this._prevY = y;
    };
    proto.getPreviousLocation = function() {
      return cc.v2(this._prevX, this._prevY);
    };
    proto.getDelta = function() {
      return cc.v2(this._x - this._prevX, this._y - this._prevY);
    };
    proto.getDeltaX = function() {
      return this._x - this._prevX;
    };
    proto.getDeltaY = function() {
      return this._y - this._prevY;
    };
    proto.setButton = function(button) {
      this._button = button;
    };
    proto.getButton = function() {
      return this._button;
    };
    proto.getLocationX = function() {
      return this._x;
    };
    proto.getLocationY = function() {
      return this._y;
    };
    EventMouse.NONE = 0;
    EventMouse.DOWN = 1;
    EventMouse.UP = 2;
    EventMouse.MOVE = 3;
    EventMouse.SCROLL = 4;
    EventMouse.BUTTON_LEFT = 0;
    EventMouse.BUTTON_RIGHT = 2;
    EventMouse.BUTTON_MIDDLE = 1;
    EventMouse.BUTTON_4 = 3;
    EventMouse.BUTTON_5 = 4;
    EventMouse.BUTTON_6 = 5;
    EventMouse.BUTTON_7 = 6;
    EventMouse.BUTTON_8 = 7;
    var EventTouch = function EventTouch(touchArr, bubbles) {
      cc.Event.call(this, cc.Event.TOUCH, bubbles);
      this._eventCode = 0;
      this._touches = touchArr || [];
      this.touch = null;
      this.currentTouch = null;
    };
    js.extend(EventTouch, cc.Event);
    proto = EventTouch.prototype;
    proto.getEventCode = function() {
      return this._eventCode;
    };
    proto.getTouches = function() {
      return this._touches;
    };
    proto._setEventCode = function(eventCode) {
      this._eventCode = eventCode;
    };
    proto._setTouches = function(touches) {
      this._touches = touches;
    };
    proto.setLocation = function(x, y) {
      this.touch && this.touch.setTouchInfo(this.touch.getID(), x, y);
    };
    proto.getLocation = function() {
      return this.touch ? this.touch.getLocation() : cc.v2();
    };
    proto.getLocationInView = function() {
      return this.touch ? this.touch.getLocationInView() : cc.v2();
    };
    proto.getPreviousLocation = function() {
      return this.touch ? this.touch.getPreviousLocation() : cc.v2();
    };
    proto.getStartLocation = function() {
      return this.touch ? this.touch.getStartLocation() : cc.v2();
    };
    proto.getID = function() {
      return this.touch ? this.touch.getID() : null;
    };
    proto.getDelta = function() {
      return this.touch ? this.touch.getDelta() : cc.v2();
    };
    proto.getDeltaX = function() {
      return this.touch ? this.touch.getDelta().x : 0;
    };
    proto.getDeltaY = function() {
      return this.touch ? this.touch.getDelta().y : 0;
    };
    proto.getLocationX = function() {
      return this.touch ? this.touch.getLocationX() : 0;
    };
    proto.getLocationY = function() {
      return this.touch ? this.touch.getLocationY() : 0;
    };
    EventTouch.MAX_TOUCHES = 5;
    EventTouch.BEGAN = 0;
    EventTouch.MOVED = 1;
    EventTouch.ENDED = 2;
    EventTouch.CANCELED = 3;
    var EventAcceleration = function EventAcceleration(acc, bubbles) {
      cc.Event.call(this, cc.Event.ACCELERATION, bubbles);
      this.acc = acc;
    };
    js.extend(EventAcceleration, cc.Event);
    var EventKeyboard = function EventKeyboard(keyCode, isPressed, bubbles) {
      cc.Event.call(this, cc.Event.KEYBOARD, bubbles);
      this.keyCode = keyCode;
      this.isPressed = isPressed;
    };
    js.extend(EventKeyboard, cc.Event);
    cc.Event.EventMouse = EventMouse;
    cc.Event.EventTouch = EventTouch;
    cc.Event.EventAcceleration = EventAcceleration;
    cc.Event.EventKeyboard = EventKeyboard;
    module.exports = cc.Event;
  }), {
    "../event/event": 133
  } ],
  127: [ (function(require, module, exports) {
    "use strict";
    var js = require("../platform/js");
    cc.EventListener = function(type, listenerID, callback) {
      this._onEvent = callback;
      this._type = type || 0;
      this._listenerID = listenerID || "";
      this._registered = false;
      this._fixedPriority = 0;
      this._node = null;
      this._target = null;
      this._paused = true;
      this._isEnabled = true;
    };
    cc.EventListener.prototype = {
      constructor: cc.EventListener,
      _setPaused: function _setPaused(paused) {
        this._paused = paused;
      },
      _isPaused: function _isPaused() {
        return this._paused;
      },
      _setRegistered: function _setRegistered(registered) {
        this._registered = registered;
      },
      _isRegistered: function _isRegistered() {
        return this._registered;
      },
      _getType: function _getType() {
        return this._type;
      },
      _getListenerID: function _getListenerID() {
        return this._listenerID;
      },
      _setFixedPriority: function _setFixedPriority(fixedPriority) {
        this._fixedPriority = fixedPriority;
      },
      _getFixedPriority: function _getFixedPriority() {
        return this._fixedPriority;
      },
      _setSceneGraphPriority: function _setSceneGraphPriority(node) {
        this._target = node;
        this._node = node;
      },
      _getSceneGraphPriority: function _getSceneGraphPriority() {
        return this._node;
      },
      checkAvailable: function checkAvailable() {
        return null !== this._onEvent;
      },
      clone: function clone() {
        return null;
      },
      setEnabled: function setEnabled(enabled) {
        this._isEnabled = enabled;
      },
      isEnabled: function isEnabled() {
        return this._isEnabled;
      },
      retain: function retain() {},
      release: function release() {}
    };
    cc.EventListener.UNKNOWN = 0;
    cc.EventListener.TOUCH_ONE_BY_ONE = 1;
    cc.EventListener.TOUCH_ALL_AT_ONCE = 2;
    cc.EventListener.KEYBOARD = 3;
    cc.EventListener.MOUSE = 4;
    cc.EventListener.ACCELERATION = 6;
    cc.EventListener.CUSTOM = 8;
    var ListenerID = cc.EventListener.ListenerID = {
      MOUSE: "__cc_mouse",
      TOUCH_ONE_BY_ONE: "__cc_touch_one_by_one",
      TOUCH_ALL_AT_ONCE: "__cc_touch_all_at_once",
      KEYBOARD: "__cc_keyboard",
      ACCELERATION: "__cc_acceleration"
    };
    var Custom = function Custom(listenerId, callback) {
      this._onCustomEvent = callback;
      cc.EventListener.call(this, cc.EventListener.CUSTOM, listenerId, this._callback);
    };
    js.extend(Custom, cc.EventListener);
    js.mixin(Custom.prototype, {
      _onCustomEvent: null,
      _callback: function _callback(event) {
        null !== this._onCustomEvent && this._onCustomEvent(event);
      },
      checkAvailable: function checkAvailable() {
        return cc.EventListener.prototype.checkAvailable.call(this) && null !== this._onCustomEvent;
      },
      clone: function clone() {
        return new Custom(this._listenerID, this._onCustomEvent);
      }
    });
    var Mouse = function Mouse() {
      cc.EventListener.call(this, cc.EventListener.MOUSE, ListenerID.MOUSE, this._callback);
    };
    js.extend(Mouse, cc.EventListener);
    js.mixin(Mouse.prototype, {
      onMouseDown: null,
      onMouseUp: null,
      onMouseMove: null,
      onMouseScroll: null,
      _callback: function _callback(event) {
        var eventType = cc.Event.EventMouse;
        switch (event._eventType) {
         case eventType.DOWN:
          this.onMouseDown && this.onMouseDown(event);
          break;

         case eventType.UP:
          this.onMouseUp && this.onMouseUp(event);
          break;

         case eventType.MOVE:
          this.onMouseMove && this.onMouseMove(event);
          break;

         case eventType.SCROLL:
          this.onMouseScroll && this.onMouseScroll(event);
        }
      },
      clone: function clone() {
        var eventListener = new Mouse();
        eventListener.onMouseDown = this.onMouseDown;
        eventListener.onMouseUp = this.onMouseUp;
        eventListener.onMouseMove = this.onMouseMove;
        eventListener.onMouseScroll = this.onMouseScroll;
        return eventListener;
      },
      checkAvailable: function checkAvailable() {
        return true;
      }
    });
    var TouchOneByOne = function TouchOneByOne() {
      cc.EventListener.call(this, cc.EventListener.TOUCH_ONE_BY_ONE, ListenerID.TOUCH_ONE_BY_ONE, null);
      this._claimedTouches = [];
    };
    js.extend(TouchOneByOne, cc.EventListener);
    js.mixin(TouchOneByOne.prototype, {
      constructor: TouchOneByOne,
      _claimedTouches: null,
      swallowTouches: false,
      onTouchBegan: null,
      onTouchMoved: null,
      onTouchEnded: null,
      onTouchCancelled: null,
      setSwallowTouches: function setSwallowTouches(needSwallow) {
        this.swallowTouches = needSwallow;
      },
      isSwallowTouches: function isSwallowTouches() {
        return this.swallowTouches;
      },
      clone: function clone() {
        var eventListener = new TouchOneByOne();
        eventListener.onTouchBegan = this.onTouchBegan;
        eventListener.onTouchMoved = this.onTouchMoved;
        eventListener.onTouchEnded = this.onTouchEnded;
        eventListener.onTouchCancelled = this.onTouchCancelled;
        eventListener.swallowTouches = this.swallowTouches;
        return eventListener;
      },
      checkAvailable: function checkAvailable() {
        if (!this.onTouchBegan) {
          cc.logID(1801);
          return false;
        }
        return true;
      }
    });
    var TouchAllAtOnce = function TouchAllAtOnce() {
      cc.EventListener.call(this, cc.EventListener.TOUCH_ALL_AT_ONCE, ListenerID.TOUCH_ALL_AT_ONCE, null);
    };
    js.extend(TouchAllAtOnce, cc.EventListener);
    js.mixin(TouchAllAtOnce.prototype, {
      constructor: TouchAllAtOnce,
      onTouchesBegan: null,
      onTouchesMoved: null,
      onTouchesEnded: null,
      onTouchesCancelled: null,
      clone: function clone() {
        var eventListener = new TouchAllAtOnce();
        eventListener.onTouchesBegan = this.onTouchesBegan;
        eventListener.onTouchesMoved = this.onTouchesMoved;
        eventListener.onTouchesEnded = this.onTouchesEnded;
        eventListener.onTouchesCancelled = this.onTouchesCancelled;
        return eventListener;
      },
      checkAvailable: function checkAvailable() {
        if (null === this.onTouchesBegan && null === this.onTouchesMoved && null === this.onTouchesEnded && null === this.onTouchesCancelled) {
          cc.logID(1802);
          return false;
        }
        return true;
      }
    });
    var Acceleration = function Acceleration(callback) {
      this._onAccelerationEvent = callback;
      cc.EventListener.call(this, cc.EventListener.ACCELERATION, ListenerID.ACCELERATION, this._callback);
    };
    js.extend(Acceleration, cc.EventListener);
    js.mixin(Acceleration.prototype, {
      constructor: Acceleration,
      _onAccelerationEvent: null,
      _callback: function _callback(event) {
        this._onAccelerationEvent(event.acc, event);
      },
      checkAvailable: function checkAvailable() {
        cc.assertID(this._onAccelerationEvent, 1803);
        return true;
      },
      clone: function clone() {
        return new Acceleration(this._onAccelerationEvent);
      }
    });
    var Keyboard = function Keyboard() {
      cc.EventListener.call(this, cc.EventListener.KEYBOARD, ListenerID.KEYBOARD, this._callback);
    };
    js.extend(Keyboard, cc.EventListener);
    js.mixin(Keyboard.prototype, {
      constructor: Keyboard,
      onKeyPressed: null,
      onKeyReleased: null,
      _callback: function _callback(event) {
        event.isPressed ? this.onKeyPressed && this.onKeyPressed(event.keyCode, event) : this.onKeyReleased && this.onKeyReleased(event.keyCode, event);
      },
      clone: function clone() {
        var eventListener = new Keyboard();
        eventListener.onKeyPressed = this.onKeyPressed;
        eventListener.onKeyReleased = this.onKeyReleased;
        return eventListener;
      },
      checkAvailable: function checkAvailable() {
        if (null === this.onKeyPressed && null === this.onKeyReleased) {
          cc.logID(1800);
          return false;
        }
        return true;
      }
    });
    cc.EventListener.create = function(argObj) {
      cc.assertID(argObj && argObj.event, 1900);
      var listenerType = argObj.event;
      delete argObj.event;
      var listener = null;
      if (listenerType === cc.EventListener.TOUCH_ONE_BY_ONE) listener = new TouchOneByOne(); else if (listenerType === cc.EventListener.TOUCH_ALL_AT_ONCE) listener = new TouchAllAtOnce(); else if (listenerType === cc.EventListener.MOUSE) listener = new Mouse(); else if (listenerType === cc.EventListener.CUSTOM) {
        listener = new Custom(argObj.eventName, argObj.callback);
        delete argObj.eventName;
        delete argObj.callback;
      } else if (listenerType === cc.EventListener.KEYBOARD) listener = new Keyboard(); else if (listenerType === cc.EventListener.ACCELERATION) {
        listener = new Acceleration(argObj.callback);
        delete argObj.callback;
      }
      for (var key in argObj) listener[key] = argObj[key];
      return listener;
    };
    module.exports = cc.EventListener;
  }), {
    "../platform/js": 219
  } ],
  128: [ (function(require, module, exports) {
    "use strict";
    var js = require("../platform/js");
    require("./CCEventListener");
    var ListenerID = cc.EventListener.ListenerID;
    var _EventListenerVector = function _EventListenerVector() {
      this._fixedListeners = [];
      this._sceneGraphListeners = [];
      this.gt0Index = 0;
    };
    _EventListenerVector.prototype = {
      constructor: _EventListenerVector,
      size: function size() {
        return this._fixedListeners.length + this._sceneGraphListeners.length;
      },
      empty: function empty() {
        return 0 === this._fixedListeners.length && 0 === this._sceneGraphListeners.length;
      },
      push: function push(listener) {
        0 === listener._getFixedPriority() ? this._sceneGraphListeners.push(listener) : this._fixedListeners.push(listener);
      },
      clearSceneGraphListeners: function clearSceneGraphListeners() {
        this._sceneGraphListeners.length = 0;
      },
      clearFixedListeners: function clearFixedListeners() {
        this._fixedListeners.length = 0;
      },
      clear: function clear() {
        this._sceneGraphListeners.length = 0;
        this._fixedListeners.length = 0;
      },
      getFixedPriorityListeners: function getFixedPriorityListeners() {
        return this._fixedListeners;
      },
      getSceneGraphPriorityListeners: function getSceneGraphPriorityListeners() {
        return this._sceneGraphListeners;
      }
    };
    var __getListenerID = function __getListenerID(event) {
      var eventType = cc.Event, type = event.type;
      if (type === eventType.ACCELERATION) return ListenerID.ACCELERATION;
      if (type === eventType.KEYBOARD) return ListenerID.KEYBOARD;
      if (type.startsWith(eventType.MOUSE)) return ListenerID.MOUSE;
      type.startsWith(eventType.TOUCH) && cc.logID(2e3);
      return "";
    };
    var eventManager = {
      DIRTY_NONE: 0,
      DIRTY_FIXED_PRIORITY: 1,
      DIRTY_SCENE_GRAPH_PRIORITY: 2,
      DIRTY_ALL: 3,
      _listenersMap: {},
      _priorityDirtyFlagMap: {},
      _nodeListenersMap: {},
      _toAddedListeners: [],
      _toRemovedListeners: [],
      _dirtyListeners: {},
      _inDispatch: 0,
      _isEnabled: false,
      _internalCustomListenerIDs: [],
      _setDirtyForNode: function _setDirtyForNode(node) {
        var selListeners = this._nodeListenersMap[node._id];
        if (void 0 !== selListeners) for (var j = 0, len = selListeners.length; j < len; j++) {
          var selListener = selListeners[j];
          var listenerID = selListener._getListenerID();
          null == this._dirtyListeners[listenerID] && (this._dirtyListeners[listenerID] = true);
        }
        if (node.getChildren) {
          var _children = node.getChildren();
          for (var i = 0, len = _children ? _children.length : 0; i < len; i++) this._setDirtyForNode(_children[i]);
        }
      },
      pauseTarget: function pauseTarget(node, recursive) {
        if (!(node instanceof cc._BaseNode)) {
          cc.warnID(3506);
          return;
        }
        var listeners = this._nodeListenersMap[node._id], i, len;
        if (listeners) for (i = 0, len = listeners.length; i < len; i++) listeners[i]._setPaused(true);
        if (true === recursive) {
          var locChildren = node.getChildren();
          for (i = 0, len = locChildren ? locChildren.length : 0; i < len; i++) this.pauseTarget(locChildren[i], true);
        }
      },
      resumeTarget: function resumeTarget(node, recursive) {
        if (!(node instanceof cc._BaseNode)) {
          cc.warnID(3506);
          return;
        }
        var listeners = this._nodeListenersMap[node._id], i, len;
        if (listeners) for (i = 0, len = listeners.length; i < len; i++) listeners[i]._setPaused(false);
        this._setDirtyForNode(node);
        if (true === recursive && node.getChildren) {
          var locChildren = node.getChildren();
          for (i = 0, len = locChildren ? locChildren.length : 0; i < len; i++) this.resumeTarget(locChildren[i], true);
        }
      },
      _addListener: function _addListener(listener) {
        0 === this._inDispatch ? this._forceAddEventListener(listener) : this._toAddedListeners.push(listener);
      },
      _forceAddEventListener: function _forceAddEventListener(listener) {
        var listenerID = listener._getListenerID();
        var listeners = this._listenersMap[listenerID];
        if (!listeners) {
          listeners = new _EventListenerVector();
          this._listenersMap[listenerID] = listeners;
        }
        listeners.push(listener);
        if (0 === listener._getFixedPriority()) {
          this._setDirty(listenerID, this.DIRTY_SCENE_GRAPH_PRIORITY);
          var node = listener._getSceneGraphPriority();
          null === node && cc.logID(3507);
          this._associateNodeAndEventListener(node, listener);
          node.activeInHierarchy && this.resumeTarget(node);
        } else this._setDirty(listenerID, this.DIRTY_FIXED_PRIORITY);
      },
      _getListeners: function _getListeners(listenerID) {
        return this._listenersMap[listenerID];
      },
      _updateDirtyFlagForSceneGraph: function _updateDirtyFlagForSceneGraph() {
        var locDirtyListeners = this._dirtyListeners;
        for (var selKey in locDirtyListeners) this._setDirty(selKey, this.DIRTY_SCENE_GRAPH_PRIORITY);
        this._dirtyListeners = {};
      },
      _removeAllListenersInVector: function _removeAllListenersInVector(listenerVector) {
        if (!listenerVector) return;
        var selListener;
        for (var i = listenerVector.length - 1; i >= 0; i--) {
          selListener = listenerVector[i];
          selListener._setRegistered(false);
          if (null != selListener._getSceneGraphPriority()) {
            this._dissociateNodeAndEventListener(selListener._getSceneGraphPriority(), selListener);
            selListener._setSceneGraphPriority(null);
          }
          0 === this._inDispatch && cc.js.array.removeAt(listenerVector, i);
        }
      },
      _removeListenersForListenerID: function _removeListenersForListenerID(listenerID) {
        var listeners = this._listenersMap[listenerID], i;
        if (listeners) {
          var fixedPriorityListeners = listeners.getFixedPriorityListeners();
          var sceneGraphPriorityListeners = listeners.getSceneGraphPriorityListeners();
          this._removeAllListenersInVector(sceneGraphPriorityListeners);
          this._removeAllListenersInVector(fixedPriorityListeners);
          delete this._priorityDirtyFlagMap[listenerID];
          if (!this._inDispatch) {
            listeners.clear();
            delete this._listenersMap[listenerID];
          }
        }
        var locToAddedListeners = this._toAddedListeners, listener;
        for (i = locToAddedListeners.length - 1; i >= 0; i--) {
          listener = locToAddedListeners[i];
          listener && listener._getListenerID() === listenerID && cc.js.array.removeAt(locToAddedListeners, i);
        }
      },
      _sortEventListeners: function _sortEventListeners(listenerID) {
        var dirtyFlag = this.DIRTY_NONE, locFlagMap = this._priorityDirtyFlagMap;
        locFlagMap[listenerID] && (dirtyFlag = locFlagMap[listenerID]);
        if (dirtyFlag !== this.DIRTY_NONE) {
          locFlagMap[listenerID] = this.DIRTY_NONE;
          dirtyFlag & this.DIRTY_FIXED_PRIORITY && this._sortListenersOfFixedPriority(listenerID);
          if (dirtyFlag & this.DIRTY_SCENE_GRAPH_PRIORITY) {
            var rootEntity = cc.director.getScene();
            rootEntity && this._sortListenersOfSceneGraphPriority(listenerID);
          }
        }
      },
      _sortListenersOfSceneGraphPriority: function _sortListenersOfSceneGraphPriority(listenerID) {
        var listeners = this._getListeners(listenerID);
        if (!listeners) return;
        var sceneGraphListener = listeners.getSceneGraphPriorityListeners();
        if (!sceneGraphListener || 0 === sceneGraphListener.length) return;
        listeners.getSceneGraphPriorityListeners().sort(this._sortEventListenersOfSceneGraphPriorityDes);
      },
      _sortEventListenersOfSceneGraphPriorityDes: function _sortEventListenersOfSceneGraphPriorityDes(l1, l2) {
        var node1 = l1._getSceneGraphPriority(), node2 = l2._getSceneGraphPriority();
        if (!(l2 && node2 && node2._activeInHierarchy && null !== node2._parent)) return -1;
        if (!l1 || !node1 || !node1._activeInHierarchy || null === node1._parent) return 1;
        var p1 = node1, p2 = node2, ex = false;
        while (p1._parent._id !== p2._parent._id) {
          p1 = null === p1._parent._parent ? (ex = true) && node2 : p1._parent;
          p2 = null === p2._parent._parent ? (ex = true) && node1 : p2._parent;
        }
        if (p1._id === p2._id) {
          if (p1._id === node2._id) return -1;
          if (p1._id === node1._id) return 1;
        }
        return ex ? p1._localZOrder - p2._localZOrder : p2._localZOrder - p1._localZOrder;
      },
      _sortListenersOfFixedPriority: function _sortListenersOfFixedPriority(listenerID) {
        var listeners = this._listenersMap[listenerID];
        if (!listeners) return;
        var fixedListeners = listeners.getFixedPriorityListeners();
        if (!fixedListeners || 0 === fixedListeners.length) return;
        fixedListeners.sort(this._sortListenersOfFixedPriorityAsc);
        var index = 0;
        for (var len = fixedListeners.length; index < len; ) {
          if (fixedListeners[index]._getFixedPriority() >= 0) break;
          ++index;
        }
        listeners.gt0Index = index;
      },
      _sortListenersOfFixedPriorityAsc: function _sortListenersOfFixedPriorityAsc(l1, l2) {
        return l1._getFixedPriority() - l2._getFixedPriority();
      },
      _onUpdateListeners: function _onUpdateListeners(listeners) {
        var fixedPriorityListeners = listeners.getFixedPriorityListeners();
        var sceneGraphPriorityListeners = listeners.getSceneGraphPriorityListeners();
        var i, selListener, idx, toRemovedListeners = this._toRemovedListeners;
        if (sceneGraphPriorityListeners) for (i = sceneGraphPriorityListeners.length - 1; i >= 0; i--) {
          selListener = sceneGraphPriorityListeners[i];
          if (!selListener._isRegistered()) {
            cc.js.array.removeAt(sceneGraphPriorityListeners, i);
            idx = toRemovedListeners.indexOf(selListener);
            -1 !== idx && toRemovedListeners.splice(idx, 1);
          }
        }
        if (fixedPriorityListeners) for (i = fixedPriorityListeners.length - 1; i >= 0; i--) {
          selListener = fixedPriorityListeners[i];
          if (!selListener._isRegistered()) {
            cc.js.array.removeAt(fixedPriorityListeners, i);
            idx = toRemovedListeners.indexOf(selListener);
            -1 !== idx && toRemovedListeners.splice(idx, 1);
          }
        }
        sceneGraphPriorityListeners && 0 === sceneGraphPriorityListeners.length && listeners.clearSceneGraphListeners();
        fixedPriorityListeners && 0 === fixedPriorityListeners.length && listeners.clearFixedListeners();
      },
      frameUpdateListeners: function frameUpdateListeners() {
        var locListenersMap = this._listenersMap, locPriorityDirtyFlagMap = this._priorityDirtyFlagMap;
        for (var selKey in locListenersMap) if (locListenersMap[selKey].empty()) {
          delete locPriorityDirtyFlagMap[selKey];
          delete locListenersMap[selKey];
        }
        var locToAddedListeners = this._toAddedListeners;
        if (0 !== locToAddedListeners.length) {
          for (var i = 0, len = locToAddedListeners.length; i < len; i++) this._forceAddEventListener(locToAddedListeners[i]);
          locToAddedListeners.length = 0;
        }
        0 !== this._toRemovedListeners.length && this._cleanToRemovedListeners();
      },
      _updateTouchListeners: function _updateTouchListeners(event) {
        var locInDispatch = this._inDispatch;
        cc.assertID(locInDispatch > 0, 3508);
        if (locInDispatch > 1) return;
        var listeners;
        listeners = this._listenersMap[ListenerID.TOUCH_ONE_BY_ONE];
        listeners && this._onUpdateListeners(listeners);
        listeners = this._listenersMap[ListenerID.TOUCH_ALL_AT_ONCE];
        listeners && this._onUpdateListeners(listeners);
        cc.assertID(1 === locInDispatch, 3509);
        var locToAddedListeners = this._toAddedListeners;
        if (0 !== locToAddedListeners.length) {
          for (var i = 0, len = locToAddedListeners.length; i < len; i++) this._forceAddEventListener(locToAddedListeners[i]);
          this._toAddedListeners.length = 0;
        }
        0 !== this._toRemovedListeners.length && this._cleanToRemovedListeners();
      },
      _cleanToRemovedListeners: function _cleanToRemovedListeners() {
        var toRemovedListeners = this._toRemovedListeners;
        for (var i = 0; i < toRemovedListeners.length; i++) {
          var selListener = toRemovedListeners[i];
          var listeners = this._listenersMap[selListener._getListenerID()];
          if (!listeners) continue;
          var idx, fixedPriorityListeners = listeners.getFixedPriorityListeners(), sceneGraphPriorityListeners = listeners.getSceneGraphPriorityListeners();
          if (sceneGraphPriorityListeners) {
            idx = sceneGraphPriorityListeners.indexOf(selListener);
            -1 !== idx && sceneGraphPriorityListeners.splice(idx, 1);
          }
          if (fixedPriorityListeners) {
            idx = fixedPriorityListeners.indexOf(selListener);
            -1 !== idx && fixedPriorityListeners.splice(idx, 1);
          }
        }
        toRemovedListeners.length = 0;
      },
      _onTouchEventCallback: function _onTouchEventCallback(listener, argsObj) {
        if (!listener._isRegistered()) return false;
        var event = argsObj.event, selTouch = event.currentTouch;
        event.currentTarget = listener._node;
        var isClaimed = false, removedIdx;
        var getCode = event.getEventCode(), EventTouch = cc.Event.EventTouch;
        if (getCode === EventTouch.BEGAN) {
          if (listener.onTouchBegan) {
            isClaimed = listener.onTouchBegan(selTouch, event);
            isClaimed && listener._registered && listener._claimedTouches.push(selTouch);
          }
        } else if (listener._claimedTouches.length > 0 && -1 !== (removedIdx = listener._claimedTouches.indexOf(selTouch))) {
          isClaimed = true;
          if (getCode === EventTouch.MOVED && listener.onTouchMoved) listener.onTouchMoved(selTouch, event); else if (getCode === EventTouch.ENDED) {
            listener.onTouchEnded && listener.onTouchEnded(selTouch, event);
            listener._registered && listener._claimedTouches.splice(removedIdx, 1);
          } else if (getCode === EventTouch.CANCELLED) {
            listener.onTouchCancelled && listener.onTouchCancelled(selTouch, event);
            listener._registered && listener._claimedTouches.splice(removedIdx, 1);
          }
        }
        if (event.isStopped()) {
          eventManager._updateTouchListeners(event);
          return true;
        }
        if (isClaimed && listener.swallowTouches) {
          argsObj.needsMutableSet && argsObj.touches.splice(selTouch, 1);
          return true;
        }
        return false;
      },
      _dispatchTouchEvent: function _dispatchTouchEvent(event) {
        this._sortEventListeners(ListenerID.TOUCH_ONE_BY_ONE);
        this._sortEventListeners(ListenerID.TOUCH_ALL_AT_ONCE);
        var oneByOneListeners = this._getListeners(ListenerID.TOUCH_ONE_BY_ONE);
        var allAtOnceListeners = this._getListeners(ListenerID.TOUCH_ALL_AT_ONCE);
        if (null === oneByOneListeners && null === allAtOnceListeners) return;
        var originalTouches = event.getTouches(), mutableTouches = cc.js.array.copy(originalTouches);
        var oneByOneArgsObj = {
          event: event,
          needsMutableSet: oneByOneListeners && allAtOnceListeners,
          touches: mutableTouches,
          selTouch: null
        };
        if (oneByOneListeners) for (var i = 0; i < originalTouches.length; i++) {
          event.currentTouch = originalTouches[i];
          event._propagationStopped = event._propagationImmediateStopped = false;
          this._dispatchEventToListeners(oneByOneListeners, this._onTouchEventCallback, oneByOneArgsObj);
        }
        if (allAtOnceListeners && mutableTouches.length > 0) {
          this._dispatchEventToListeners(allAtOnceListeners, this._onTouchesEventCallback, {
            event: event,
            touches: mutableTouches
          });
          if (event.isStopped()) return;
        }
        this._updateTouchListeners(event);
      },
      _onTouchesEventCallback: function _onTouchesEventCallback(listener, callbackParams) {
        if (!listener._registered) return false;
        var EventTouch = cc.Event.EventTouch, event = callbackParams.event, touches = callbackParams.touches, getCode = event.getEventCode();
        event.currentTarget = listener._node;
        getCode === EventTouch.BEGAN && listener.onTouchesBegan ? listener.onTouchesBegan(touches, event) : getCode === EventTouch.MOVED && listener.onTouchesMoved ? listener.onTouchesMoved(touches, event) : getCode === EventTouch.ENDED && listener.onTouchesEnded ? listener.onTouchesEnded(touches, event) : getCode === EventTouch.CANCELLED && listener.onTouchesCancelled && listener.onTouchesCancelled(touches, event);
        if (event.isStopped()) {
          eventManager._updateTouchListeners(event);
          return true;
        }
        return false;
      },
      _associateNodeAndEventListener: function _associateNodeAndEventListener(node, listener) {
        var listeners = this._nodeListenersMap[node._id];
        if (!listeners) {
          listeners = [];
          this._nodeListenersMap[node._id] = listeners;
        }
        listeners.push(listener);
      },
      _dissociateNodeAndEventListener: function _dissociateNodeAndEventListener(node, listener) {
        var listeners = this._nodeListenersMap[node._id];
        if (listeners) {
          cc.js.array.remove(listeners, listener);
          0 === listeners.length && delete this._nodeListenersMap[node._id];
        }
      },
      _dispatchEventToListeners: function _dispatchEventToListeners(listeners, onEvent, eventOrArgs) {
        var shouldStopPropagation = false;
        var fixedPriorityListeners = listeners.getFixedPriorityListeners();
        var sceneGraphPriorityListeners = listeners.getSceneGraphPriorityListeners();
        var i = 0, j, selListener;
        if (fixedPriorityListeners && 0 !== fixedPriorityListeners.length) for (;i < listeners.gt0Index; ++i) {
          selListener = fixedPriorityListeners[i];
          if (selListener.isEnabled() && !selListener._isPaused() && selListener._isRegistered() && onEvent(selListener, eventOrArgs)) {
            shouldStopPropagation = true;
            break;
          }
        }
        if (sceneGraphPriorityListeners && !shouldStopPropagation) for (j = 0; j < sceneGraphPriorityListeners.length; j++) {
          selListener = sceneGraphPriorityListeners[j];
          if (selListener.isEnabled() && !selListener._isPaused() && selListener._isRegistered() && onEvent(selListener, eventOrArgs)) {
            shouldStopPropagation = true;
            break;
          }
        }
        if (fixedPriorityListeners && !shouldStopPropagation) for (;i < fixedPriorityListeners.length; ++i) {
          selListener = fixedPriorityListeners[i];
          if (selListener.isEnabled() && !selListener._isPaused() && selListener._isRegistered() && onEvent(selListener, eventOrArgs)) {
            shouldStopPropagation = true;
            break;
          }
        }
      },
      _setDirty: function _setDirty(listenerID, flag) {
        var locDirtyFlagMap = this._priorityDirtyFlagMap;
        null == locDirtyFlagMap[listenerID] ? locDirtyFlagMap[listenerID] = flag : locDirtyFlagMap[listenerID] = flag | locDirtyFlagMap[listenerID];
      },
      _sortNumberAsc: function _sortNumberAsc(a, b) {
        return a - b;
      },
      hasEventListener: function hasEventListener(listenerID) {
        return !!this._getListeners(listenerID);
      },
      addListener: function addListener(listener, nodeOrPriority) {
        cc.assertID(listener && nodeOrPriority, 3503);
        if (!(cc.js.isNumber(nodeOrPriority) || nodeOrPriority instanceof cc._BaseNode)) {
          cc.warnID(3506);
          return;
        }
        if (listener instanceof cc.EventListener) {
          if (listener._isRegistered()) {
            cc.logID(3505);
            return;
          }
        } else {
          cc.assertID(!cc.js.isNumber(nodeOrPriority), 3504);
          listener = cc.EventListener.create(listener);
        }
        if (!listener.checkAvailable()) return;
        if (cc.js.isNumber(nodeOrPriority)) {
          if (0 === nodeOrPriority) {
            cc.logID(3500);
            return;
          }
          listener._setSceneGraphPriority(null);
          listener._setFixedPriority(nodeOrPriority);
          listener._setRegistered(true);
          listener._setPaused(false);
          this._addListener(listener);
        } else {
          listener._setSceneGraphPriority(nodeOrPriority);
          listener._setFixedPriority(0);
          listener._setRegistered(true);
          this._addListener(listener);
        }
        return listener;
      },
      addCustomListener: function addCustomListener(eventName, callback) {
        var listener = new cc.EventListener.create({
          event: cc.EventListener.CUSTOM,
          eventName: eventName,
          callback: callback
        });
        this.addListener(listener, 1);
        return listener;
      },
      removeListener: function removeListener(listener) {
        if (null == listener) return;
        var isFound, locListener = this._listenersMap;
        for (var selKey in locListener) {
          var listeners = locListener[selKey];
          var fixedPriorityListeners = listeners.getFixedPriorityListeners(), sceneGraphPriorityListeners = listeners.getSceneGraphPriorityListeners();
          isFound = this._removeListenerInVector(sceneGraphPriorityListeners, listener);
          if (isFound) this._setDirty(listener._getListenerID(), this.DIRTY_SCENE_GRAPH_PRIORITY); else {
            isFound = this._removeListenerInVector(fixedPriorityListeners, listener);
            isFound && this._setDirty(listener._getListenerID(), this.DIRTY_FIXED_PRIORITY);
          }
          if (listeners.empty()) {
            delete this._priorityDirtyFlagMap[listener._getListenerID()];
            delete locListener[selKey];
          }
          if (isFound) break;
        }
        if (!isFound) {
          var locToAddedListeners = this._toAddedListeners;
          for (var i = locToAddedListeners.length - 1; i >= 0; i--) {
            var selListener = locToAddedListeners[i];
            if (selListener === listener) {
              cc.js.array.removeAt(locToAddedListeners, i);
              selListener._setRegistered(false);
              break;
            }
          }
        }
      },
      _removeListenerInCallback: function _removeListenerInCallback(listeners, callback) {
        if (null == listeners) return false;
        for (var i = listeners.length - 1; i >= 0; i--) {
          var selListener = listeners[i];
          if (selListener._onCustomEvent === callback || selListener._onEvent === callback) {
            selListener._setRegistered(false);
            if (null != selListener._getSceneGraphPriority()) {
              this._dissociateNodeAndEventListener(selListener._getSceneGraphPriority(), selListener);
              selListener._setSceneGraphPriority(null);
            }
            0 === this._inDispatch ? cc.js.array.removeAt(listeners, i) : this._toRemovedListeners.push(selListener);
            return true;
          }
        }
        return false;
      },
      _removeListenerInVector: function _removeListenerInVector(listeners, listener) {
        if (null == listeners) return false;
        for (var i = listeners.length - 1; i >= 0; i--) {
          var selListener = listeners[i];
          if (selListener === listener) {
            selListener._setRegistered(false);
            if (null != selListener._getSceneGraphPriority()) {
              this._dissociateNodeAndEventListener(selListener._getSceneGraphPriority(), selListener);
              selListener._setSceneGraphPriority(null);
            }
            0 === this._inDispatch ? cc.js.array.removeAt(listeners, i) : this._toRemovedListeners.push(selListener);
            return true;
          }
        }
        return false;
      },
      removeListeners: function removeListeners(listenerType, recursive) {
        var i, _t = this;
        if (!(cc.js.isNumber(listenerType) || listenerType instanceof cc._BaseNode)) {
          cc.warnID(3506);
          return;
        }
        if (void 0 !== listenerType._id) {
          var listeners = _t._nodeListenersMap[listenerType._id], i;
          if (listeners) {
            var listenersCopy = cc.js.array.copy(listeners);
            for (i = 0; i < listenersCopy.length; i++) _t.removeListener(listenersCopy[i]);
            delete _t._nodeListenersMap[listenerType._id];
          }
          var locToAddedListeners = _t._toAddedListeners;
          for (i = 0; i < locToAddedListeners.length; ) {
            var listener = locToAddedListeners[i];
            if (listener._getSceneGraphPriority() === listenerType) {
              listener._setSceneGraphPriority(null);
              listener._setRegistered(false);
              locToAddedListeners.splice(i, 1);
            } else ++i;
          }
          if (true === recursive) {
            var locChildren = listenerType.getChildren(), len;
            for (i = 0, len = locChildren.length; i < len; i++) _t.removeListeners(locChildren[i], true);
          }
        } else listenerType === cc.EventListener.TOUCH_ONE_BY_ONE ? _t._removeListenersForListenerID(ListenerID.TOUCH_ONE_BY_ONE) : listenerType === cc.EventListener.TOUCH_ALL_AT_ONCE ? _t._removeListenersForListenerID(ListenerID.TOUCH_ALL_AT_ONCE) : listenerType === cc.EventListener.MOUSE ? _t._removeListenersForListenerID(ListenerID.MOUSE) : listenerType === cc.EventListener.ACCELERATION ? _t._removeListenersForListenerID(ListenerID.ACCELERATION) : listenerType === cc.EventListener.KEYBOARD ? _t._removeListenersForListenerID(ListenerID.KEYBOARD) : cc.logID(3501);
      },
      removeCustomListeners: function removeCustomListeners(customEventName) {
        this._removeListenersForListenerID(customEventName);
      },
      removeAllListeners: function removeAllListeners() {
        var locListeners = this._listenersMap, locInternalCustomEventIDs = this._internalCustomListenerIDs;
        for (var selKey in locListeners) -1 === locInternalCustomEventIDs.indexOf(selKey) && this._removeListenersForListenerID(selKey);
      },
      setPriority: function setPriority(listener, fixedPriority) {
        if (null == listener) return;
        var locListeners = this._listenersMap;
        for (var selKey in locListeners) {
          var selListeners = locListeners[selKey];
          var fixedPriorityListeners = selListeners.getFixedPriorityListeners();
          if (fixedPriorityListeners) {
            var found = fixedPriorityListeners.indexOf(listener);
            if (-1 !== found) {
              null != listener._getSceneGraphPriority() && cc.logID(3502);
              if (listener._getFixedPriority() !== fixedPriority) {
                listener._setFixedPriority(fixedPriority);
                this._setDirty(listener._getListenerID(), this.DIRTY_FIXED_PRIORITY);
              }
              return;
            }
          }
        }
      },
      setEnabled: function setEnabled(enabled) {
        this._isEnabled = enabled;
      },
      isEnabled: function isEnabled() {
        return this._isEnabled;
      },
      dispatchEvent: function dispatchEvent(event) {
        if (!this._isEnabled) return;
        this._updateDirtyFlagForSceneGraph();
        this._inDispatch++;
        if (!event || !event.getType) {
          cc.errorID(3511);
          return;
        }
        if (event.getType().startsWith(cc.Event.TOUCH)) {
          this._dispatchTouchEvent(event);
          this._inDispatch--;
          return;
        }
        var listenerID = __getListenerID(event);
        this._sortEventListeners(listenerID);
        var selListeners = this._listenersMap[listenerID];
        if (null != selListeners) {
          this._dispatchEventToListeners(selListeners, this._onListenerCallback, event);
          this._onUpdateListeners(selListeners);
        }
        this._inDispatch--;
      },
      _onListenerCallback: function _onListenerCallback(listener, event) {
        event.currentTarget = listener._target;
        listener._onEvent(event);
        return event.isStopped();
      },
      dispatchCustomEvent: function dispatchCustomEvent(eventName, optionalUserData) {
        var ev = new cc.Event.EventCustom(eventName);
        ev.setUserData(optionalUserData);
        this.dispatchEvent(ev);
      }
    };
    js.get(cc, "eventManager", (function() {
      cc.warnID(1405, "cc.eventManager", "cc.EventTarget or cc.systemEvent");
      return eventManager;
    }));
    module.exports = eventManager;
  }), {
    "../platform/js": 219,
    "./CCEventListener": 127
  } ],
  129: [ (function(require, module, exports) {
    "use strict";
    cc.Touch = function(x, y, id) {
      this._lastModified = 0;
      this.setTouchInfo(id, x, y);
    };
    cc.Touch.prototype = {
      constructor: cc.Touch,
      getLocation: function getLocation() {
        return cc.v2(this._point.x, this._point.y);
      },
      getLocationX: function getLocationX() {
        return this._point.x;
      },
      getLocationY: function getLocationY() {
        return this._point.y;
      },
      getPreviousLocation: function getPreviousLocation() {
        return cc.v2(this._prevPoint.x, this._prevPoint.y);
      },
      getStartLocation: function getStartLocation() {
        return cc.v2(this._startPoint.x, this._startPoint.y);
      },
      getDelta: function getDelta() {
        return this._point.sub(this._prevPoint);
      },
      getLocationInView: function getLocationInView() {
        return cc.v2(this._point.x, cc.view._designResolutionSize.height - this._point.y);
      },
      getPreviousLocationInView: function getPreviousLocationInView() {
        return cc.v2(this._prevPoint.x, cc.view._designResolutionSize.height - this._prevPoint.y);
      },
      getStartLocationInView: function getStartLocationInView() {
        return cc.v2(this._startPoint.x, cc.view._designResolutionSize.height - this._startPoint.y);
      },
      getID: function getID() {
        return this._id;
      },
      setTouchInfo: function setTouchInfo(id, x, y) {
        this._prevPoint = this._point;
        this._point = cc.v2(x || 0, y || 0);
        this._id = id;
        if (!this._startPointCaptured) {
          this._startPoint = cc.v2(this._point);
          cc.view._convertPointWithScale(this._startPoint);
          this._startPointCaptured = true;
        }
      },
      _setPoint: function _setPoint(x, y) {
        if (void 0 === y) {
          this._point.x = x.x;
          this._point.y = x.y;
        } else {
          this._point.x = x;
          this._point.y = y;
        }
      },
      _setPrevPoint: function _setPrevPoint(x, y) {
        this._prevPoint = void 0 === y ? cc.v2(x.x, x.y) : cc.v2(x || 0, y || 0);
      }
    };
  }), {} ],
  130: [ (function(require, module, exports) {
    "use strict";
    require("./CCEvent");
    require("./CCTouch");
    require("./CCEventListener");
    var eventManager = require("./CCEventManager");
    module.exports = eventManager;
    false;
  }), {
    "./CCEvent": 126,
    "./CCEventListener": 127,
    "./CCEventManager": 128,
    "./CCTouch": 129
  } ],
  131: [ (function(require, module, exports) {
    "use strict";
    var js = cc.js;
    var CallbacksInvoker = require("../platform/callbacks-invoker");
    function EventListeners() {
      CallbacksInvoker.call(this);
    }
    js.extend(EventListeners, CallbacksInvoker);
    EventListeners.prototype.emit = function(event, captureListeners) {
      var key = event.type;
      var list = this._callbackTable[key];
      if (list) {
        var rootInvoker = !list.isInvoking;
        list.isInvoking = true;
        var infos = list.callbackInfos;
        for (var i = 0, len = infos.length; i < len; ++i) {
          var info = infos[i];
          if (info && info.callback) {
            info.callback.call(info.target, event, captureListeners);
            if (event._propagationImmediateStopped) break;
          }
        }
        if (rootInvoker) {
          list.isInvoking = false;
          list.containCanceled && list.purgeCanceled();
        }
      }
    };
    module.exports = EventListeners;
    false;
  }), {
    "../platform/callbacks-invoker": 212
  } ],
  132: [ (function(require, module, exports) {
    "use strict";
    var js = require("../platform/js");
    var CallbacksInvoker = require("../platform/callbacks-invoker");
    var fastRemove = js.array.fastRemove;
    function EventTarget() {
      CallbacksInvoker.call(this);
    }
    js.extend(EventTarget, CallbacksInvoker);
    var proto = EventTarget.prototype;
    proto.__on = proto.on;
    proto.on = function(type, callback, target, once) {
      if (!callback) {
        cc.errorID(6800);
        return;
      }
      if (!this.hasEventListener(type, callback, target)) {
        this.__on(type, callback, target, once);
        target && target.__eventTargets && target.__eventTargets.push(this);
      }
      return callback;
    };
    proto.__off = proto.off;
    proto.off = function(type, callback, target) {
      if (callback) {
        this.__off(type, callback, target);
        target && target.__eventTargets && fastRemove(target.__eventTargets, this);
      } else {
        var list = this._callbackTable[type];
        if (!list) return;
        var infos = list.callbackInfos;
        for (var i = 0; i < infos.length; ++i) {
          var _target = infos[i] && infos[i].target;
          _target && _target.__eventTargets && fastRemove(_target.__eventTargets, this);
        }
        this.removeAll(type);
      }
    };
    proto.targetOff = function(target) {
      this.removeAll(target);
      target && target.__eventTargets && fastRemove(target.__eventTargets, this);
    };
    proto.once = function(type, callback, target) {
      this.on(type, callback, target, true);
    };
    proto.dispatchEvent = function(event) {
      this.emit(event.type, event);
    };
    cc.EventTarget = module.exports = EventTarget;
  }), {
    "../platform/callbacks-invoker": 212,
    "../platform/js": 219
  } ],
  133: [ (function(require, module, exports) {
    "use strict";
    var js = require("../platform/js");
    cc.Event = function(type, bubbles) {
      this.type = type;
      this.bubbles = !!bubbles;
      this.target = null;
      this.currentTarget = null;
      this.eventPhase = 0;
      this._propagationStopped = false;
      this._propagationImmediateStopped = false;
    };
    cc.Event.prototype = {
      constructor: cc.Event,
      unuse: function unuse() {
        this.type = cc.Event.NO_TYPE;
        this.target = null;
        this.currentTarget = null;
        this.eventPhase = cc.Event.NONE;
        this._propagationStopped = false;
        this._propagationImmediateStopped = false;
      },
      reuse: function reuse(type, bubbles) {
        this.type = type;
        this.bubbles = bubbles || false;
      },
      stopPropagation: function stopPropagation() {
        this._propagationStopped = true;
      },
      stopPropagationImmediate: function stopPropagationImmediate() {
        this._propagationImmediateStopped = true;
      },
      isStopped: function isStopped() {
        return this._propagationStopped || this._propagationImmediateStopped;
      },
      getCurrentTarget: function getCurrentTarget() {
        return this.currentTarget;
      },
      getType: function getType() {
        return this.type;
      }
    };
    cc.Event.NO_TYPE = "no_type";
    cc.Event.TOUCH = "touch";
    cc.Event.MOUSE = "mouse";
    cc.Event.KEYBOARD = "keyboard";
    cc.Event.ACCELERATION = "acceleration";
    cc.Event.NONE = 0;
    cc.Event.CAPTURING_PHASE = 1;
    cc.Event.AT_TARGET = 2;
    cc.Event.BUBBLING_PHASE = 3;
    var EventCustom = function EventCustom(type, bubbles) {
      cc.Event.call(this, type, bubbles);
      this.detail = null;
    };
    js.extend(EventCustom, cc.Event);
    EventCustom.prototype.reset = EventCustom;
    EventCustom.prototype.setUserData = function(data) {
      this.detail = data;
    };
    EventCustom.prototype.getUserData = function() {
      return this.detail;
    };
    EventCustom.prototype.getEventName = cc.Event.prototype.getType;
    var MAX_POOL_SIZE = 10;
    var _eventPool = new js.Pool(MAX_POOL_SIZE);
    EventCustom.put = function(event) {
      _eventPool.put(event);
    };
    EventCustom.get = function(type, bubbles) {
      var event = _eventPool._get();
      event ? event.reset(type, bubbles) : event = new EventCustom(type, bubbles);
      return event;
    };
    cc.Event.EventCustom = EventCustom;
    module.exports = cc.Event;
  }), {
    "../platform/js": 219
  } ],
  134: [ (function(require, module, exports) {
    "use strict";
    require("./event");
    require("./event-listeners");
    require("./event-target");
    require("./system-event");
  }), {
    "./event": 133,
    "./event-listeners": 131,
    "./event-target": 132,
    "./system-event": 135
  } ],
  135: [ (function(require, module, exports) {
    "use strict";
    var EventTarget = require("../event/event-target");
    var eventManager = require("../event-manager");
    var inputManger = require("../platform/CCInputManager");
    var EventType = cc.Enum({
      KEY_DOWN: "keydown",
      KEY_UP: "keyup",
      DEVICEMOTION: "devicemotion"
    });
    var keyboardListener = null;
    var accelerationListener = null;
    var SystemEvent = cc.Class({
      name: "SystemEvent",
      extends: EventTarget,
      statics: {
        EventType: EventType
      },
      setAccelerometerEnabled: function setAccelerometerEnabled(isEnable) {
        false;
        isEnable && window.DeviceMotionEvent && "function" === typeof DeviceMotionEvent.requestPermission ? DeviceMotionEvent.requestPermission().then((function(response) {
          console.log("Device Motion Event request permission: " + response);
          inputManger.setAccelerometerEnabled("granted" === response);
        })) : inputManger.setAccelerometerEnabled(isEnable);
      },
      setAccelerometerInterval: function setAccelerometerInterval(interval) {
        false;
        inputManger.setAccelerometerInterval(interval);
      },
      on: function on(type, callback, target, once) {
        false;
        this._super(type, callback, target, once);
        if (type === EventType.KEY_DOWN || type === EventType.KEY_UP) {
          keyboardListener || (keyboardListener = cc.EventListener.create({
            event: cc.EventListener.KEYBOARD,
            onKeyPressed: function onKeyPressed(keyCode, event) {
              event.type = EventType.KEY_DOWN;
              cc.systemEvent.dispatchEvent(event);
            },
            onKeyReleased: function onKeyReleased(keyCode, event) {
              event.type = EventType.KEY_UP;
              cc.systemEvent.dispatchEvent(event);
            }
          }));
          eventManager.hasEventListener(cc.EventListener.ListenerID.KEYBOARD) || eventManager.addListener(keyboardListener, 1);
        }
        if (type === EventType.DEVICEMOTION) {
          accelerationListener || (accelerationListener = cc.EventListener.create({
            event: cc.EventListener.ACCELERATION,
            callback: function callback(acc, event) {
              event.type = EventType.DEVICEMOTION;
              cc.systemEvent.dispatchEvent(event);
            }
          }));
          eventManager.hasEventListener(cc.EventListener.ListenerID.ACCELERATION) || eventManager.addListener(accelerationListener, 1);
        }
      },
      off: function off(type, callback, target) {
        false;
        this._super(type, callback, target);
        if (keyboardListener && (type === EventType.KEY_DOWN || type === EventType.KEY_UP)) {
          var hasKeyDownEventListener = this.hasEventListener(EventType.KEY_DOWN);
          var hasKeyUpEventListener = this.hasEventListener(EventType.KEY_UP);
          hasKeyDownEventListener || hasKeyUpEventListener || eventManager.removeListener(keyboardListener);
        }
        accelerationListener && type === EventType.DEVICEMOTION && eventManager.removeListener(accelerationListener);
      }
    });
    cc.SystemEvent = module.exports = SystemEvent;
    cc.systemEvent = new cc.SystemEvent();
  }), {
    "../event-manager": 130,
    "../event/event-target": 132,
    "../platform/CCInputManager": 203
  } ],
  136: [ (function(require, module, exports) {
    "use strict";
    var vec3 = cc.vmath.vec3;
    var mat3 = cc.vmath.mat3;
    var _v3_tmp = vec3.create();
    var _v3_tmp2 = vec3.create();
    var _m3_tmp = mat3.create();
    var transform_extent_m4 = function transform_extent_m4(out, extent, m4) {
      var _m3_tmpm = _m3_tmp.m, m4m = m4.m;
      _m3_tmpm[0] = Math.abs(m4m[0]);
      _m3_tmpm[1] = Math.abs(m4m[1]);
      _m3_tmpm[2] = Math.abs(m4m[2]);
      _m3_tmpm[3] = Math.abs(m4m[4]);
      _m3_tmpm[4] = Math.abs(m4m[5]);
      _m3_tmpm[5] = Math.abs(m4m[6]);
      _m3_tmpm[6] = Math.abs(m4m[8]);
      _m3_tmpm[7] = Math.abs(m4m[9]);
      _m3_tmpm[8] = Math.abs(m4m[10]);
      vec3.transformMat3(out, extent, _m3_tmp);
    };
    function aabb(px, py, pz, w, h, l) {
      this.center = cc.v3(px, py, pz);
      this.halfExtents = cc.v3(w, h, l);
    }
    var proto = aabb.prototype;
    proto.getBoundary = function(minPos, maxPos) {
      vec3.sub(minPos, this.center, this.halfExtents);
      vec3.add(maxPos, this.center, this.halfExtents);
    };
    proto.transform = function(m, pos, rot, scale, out) {
      out || (out = this);
      vec3.transformMat4(out.center, this.center, m);
      transform_extent_m4(out.halfExtents, this.halfExtents, m);
    };
    aabb.create = function(px, py, pz, w, h, l) {
      return new aabb(px, py, pz, w, h, l);
    };
    aabb.clone = function(a) {
      return new aabb(a.center.x, a.center.y, a.center.z, a.halfExtents.x, a.halfExtents.y, a.halfExtents.z);
    };
    aabb.copy = function(out, a) {
      vec3.copy(out.center, a.center);
      vec3.copy(out.halfExtents, a.halfExtents);
      return out;
    };
    aabb.fromPoints = function(out, minPos, maxPos) {
      vec3.scale(out.center, vec3.add(_v3_tmp, minPos, maxPos), .5);
      vec3.scale(out.halfExtents, vec3.sub(_v3_tmp2, maxPos, minPos), .5);
      return out;
    };
    aabb.set = function(out, px, py, pz, w, h, l) {
      vec3.set(out.center, px, py, pz);
      vec3.set(out.halfExtents, w, h, l);
      return out;
    };
    module.exports = aabb;
  }), {} ],
  137: [ (function(require, module, exports) {
    "use strict";
    exports.__esModule = true;
    cc.geomUtils = {
      Triangle: require("./triangle"),
      Aabb: require("./aabb"),
      Ray: require("./ray"),
      intersect: require("./intersect")
    };
    exports.default = cc.geomUtils;
    module.exports = exports["default"];
  }), {
    "./aabb": 136,
    "./intersect": 138,
    "./ray": 139,
    "./triangle": 140
  } ],
  138: [ (function(require, module, exports) {
    "use strict";
    var _gfx = require("../../renderer/gfx");
    var _gfx2 = _interopRequireDefault(_gfx);
    var _recyclePool = require("../../renderer/memop/recycle-pool");
    var _recyclePool2 = _interopRequireDefault(_recyclePool);
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : {
        default: obj
      };
    }
    var Aabb = require("./aabb");
    var Ray = require("./ray");
    var Triangle = require("./triangle");
    var mat4 = cc.vmath.mat4;
    var vec3 = cc.vmath.vec3;
    var intersect = {};
    intersect.rayAabb = (function() {
      var min = vec3.create();
      var max = vec3.create();
      return function(ray, aabb) {
        var o = ray.o, d = ray.d;
        var ix = 1 / d.x, iy = 1 / d.y, iz = 1 / d.z;
        vec3.sub(min, aabb.center, aabb.halfExtents);
        vec3.add(max, aabb.center, aabb.halfExtents);
        var t1 = (min.x - o.x) * ix;
        var t2 = (max.x - o.x) * ix;
        var t3 = (min.y - o.y) * iy;
        var t4 = (max.y - o.y) * iy;
        var t5 = (min.z - o.z) * iz;
        var t6 = (max.z - o.z) * iz;
        var tmin = Math.max(Math.max(Math.min(t1, t2), Math.min(t3, t4)), Math.min(t5, t6));
        var tmax = Math.min(Math.min(Math.max(t1, t2), Math.max(t3, t4)), Math.max(t5, t6));
        if (tmax < 0 || tmin > tmax) return 0;
        return tmin;
      };
    })();
    intersect.rayTriangle = (function() {
      var ab = vec3.create(0, 0, 0);
      var ac = vec3.create(0, 0, 0);
      var pvec = vec3.create(0, 0, 0);
      var tvec = vec3.create(0, 0, 0);
      var qvec = vec3.create(0, 0, 0);
      return function(ray, triangle) {
        vec3.sub(ab, triangle.b, triangle.a);
        vec3.sub(ac, triangle.c, triangle.a);
        vec3.cross(pvec, ray.d, ac);
        var det = vec3.dot(ab, pvec);
        if (det <= 0) return 0;
        vec3.sub(tvec, ray.o, triangle.a);
        var u = vec3.dot(tvec, pvec);
        if (u < 0 || u > det) return 0;
        vec3.cross(qvec, tvec, ab);
        var v = vec3.dot(ray.d, qvec);
        if (v < 0 || u + v > det) return 0;
        var t = vec3.dot(ac, qvec) / det;
        if (t < 0) return 0;
        return t;
      };
    })();
    intersect.rayMesh = (function() {
      var tri = Triangle.create();
      var minDist = Infinity;
      var _compType2fn = {
        5120: "getInt8",
        5121: "getUint8",
        5122: "getInt16",
        5123: "getUint16",
        5124: "getInt32",
        5125: "getUint32",
        5126: "getFloat32"
      };
      var littleEndian = (function() {
        var buffer = new ArrayBuffer(2);
        new DataView(buffer).setInt16(0, 256, true);
        return 256 === new Int16Array(buffer)[0];
      })();
      function getVec3(out, dv, fn, step, idx) {
        vec3.set(out, dv[fn](idx, littleEndian), dv[fn](idx += step, littleEndian), dv[fn](idx += step, littleEndian));
      }
      return function(ray, mesh) {
        minDist = Infinity;
        var subMeshes = mesh._subMeshes;
        for (var i = 0; i < subMeshes.length; i++) {
          if (subMeshes[i]._primitiveType !== _gfx2.default.PT_TRIANGLES) continue;
          var subData = mesh._subDatas[i] || mesh._subDatas[0];
          var vbData = subData.vData;
          var dv = new DataView(vbData.buffer, vbData.byteOffset, vbData.byteLength);
          var iData = subData.getIData(Uint16Array);
          var format = subData.vfm;
          var fmt = format.element(_gfx2.default.ATTR_POSITION);
          var offset = fmt.offset, stride = fmt.stride;
          var fn = _compType2fn[fmt.type];
          for (var _i = 0; _i < iData.length; _i += 3) {
            getVec3(tri.a, dv, fn, 4, iData[_i] * stride + offset);
            getVec3(tri.b, dv, fn, 4, iData[_i + 1] * stride + offset);
            getVec3(tri.c, dv, fn, 4, iData[_i + 2] * stride + offset);
            var dist = intersect.rayTriangle(ray, tri);
            dist > 0 && dist < minDist && (minDist = dist);
          }
        }
        return minDist;
      };
    })();
    intersect.raycast = (function() {
      function traversal(node, cb) {
        var children = node.children;
        for (var i = children.length - 1; i >= 0; i--) {
          var child = children[i];
          traversal(child, cb);
        }
        cb(node);
      }
      function cmp(a, b) {
        return a.distance - b.distance;
      }
      function transformMat4Normal(out, a, m) {
        var mm = m.m;
        var x = a.x, y = a.y, z = a.z, rhw = mm[3] * x + mm[7] * y + mm[11] * z;
        rhw = rhw ? 1 / rhw : 1;
        out.x = (mm[0] * x + mm[4] * y + mm[8] * z) * rhw;
        out.y = (mm[1] * x + mm[5] * y + mm[9] * z) * rhw;
        out.z = (mm[2] * x + mm[6] * y + mm[10] * z) * rhw;
        return out;
      }
      var resultsPool = new _recyclePool2.default(function() {
        return {
          distance: 0,
          node: null
        };
      }, 1);
      var results = [];
      var nodeAabb = Aabb.create();
      var minPos = vec3.create();
      var maxPos = vec3.create();
      var modelRay = Ray.create();
      var m4_1 = mat4.create();
      var m4_2 = mat4.create();
      var d = vec3.create();
      function distanceValid(distance) {
        return distance > 0 && distance < Infinity;
      }
      return function(root, worldRay, handler, filter) {
        resultsPool.reset();
        results.length = 0;
        root = root || cc.director.getScene();
        traversal(root, (function(node) {
          if (filter && !filter(node)) return;
          mat4.invert(m4_2, node.getWorldMatrix(m4_1));
          vec3.transformMat4(modelRay.o, worldRay.o, m4_2);
          vec3.normalize(modelRay.d, transformMat4Normal(modelRay.d, worldRay.d, m4_2));
          var distance = Infinity;
          var component = node._renderComponent;
          if (component instanceof cc.MeshRenderer) distance = intersect.rayAabb(modelRay, component._boundingBox); else if (node.width && node.height) {
            vec3.set(minPos, -node.width * node.anchorX, -node.height * node.anchorY, node.z);
            vec3.set(maxPos, node.width * (1 - node.anchorX), node.height * (1 - node.anchorY), node.z);
            Aabb.fromPoints(nodeAabb, minPos, maxPos);
            distance = intersect.rayAabb(modelRay, nodeAabb);
          }
          if (!distanceValid(distance)) return;
          handler && (distance = handler(modelRay, node, distance));
          if (distanceValid(distance)) {
            vec3.scale(d, modelRay.d, distance);
            transformMat4Normal(d, d, m4_1);
            var res = resultsPool.add();
            res.node = node;
            res.distance = cc.vmath.vec3.mag(d);
            results.push(res);
          }
        }));
        results.sort(cmp);
        return results;
      };
    })();
    module.exports = intersect;
  }), {
    "../../renderer/gfx": 352,
    "../../renderer/memop/recycle-pool": 353,
    "./aabb": 136,
    "./ray": 139,
    "./triangle": 140
  } ],
  139: [ (function(require, module, exports) {
    "use strict";
    var vec3 = cc.vmath.vec3;
    function ray(ox, oy, oz, dx, dy, dz) {
      this.o = cc.v3(ox, oy, oz);
      this.d = cc.v3(dx, dy, dz);
    }
    ray.create = function(ox, oy, oz, dx, dy, dz) {
      return new ray(ox, oy, oz, dx, dy, dz);
    };
    ray.clone = function(a) {
      return new ray(a.o.x, a.o.y, a.o.z, a.d.x, a.d.y, a.d.z);
    };
    ray.copy = function(out, a) {
      out.o.x = a.o.x;
      out.o.y = a.o.y;
      out.o.z = a.o.z;
      out.d.x = a.d.x;
      out.d.y = a.d.y;
      out.d.z = a.d.z;
      return out;
    };
    ray.set = function(out, ox, oy, oz, dx, dy, dz) {
      out.o.x = ox;
      out.o.y = oy;
      out.o.z = oz;
      out.d.x = dx;
      out.d.y = dy;
      out.d.z = dz;
      return out;
    };
    ray.fromPoints = function(out, origin, lookAt) {
      vec3.copy(out.o, origin);
      vec3.normalize(out.d, vec3.sub(out.d, lookAt, origin));
      return out;
    };
    module.exports = ray;
  }), {} ],
  140: [ (function(require, module, exports) {
    "use strict";
    var vec3 = cc.vmath.vec3;
    function triangle(ax, ay, az, bx, by, bz, cx, cy, cz) {
      this.a = cc.v3(ax, ay, az);
      this.b = cc.v3(bx, by, bz);
      this.c = cc.v3(cx, cy, cz);
    }
    triangle.create = function(ax, ay, az, bx, by, bz, cx, cy, cz) {
      return new triangle(ax, ay, az, bx, by, bz, cx, cy, cz);
    };
    triangle.clone = function(t) {
      return new triangle(t.a.x, t.a.y, t.a.z, t.b.x, t.b.y, t.b.z, t.c.x, t.c.y, t.c.z);
    };
    triangle.copy = function(out, t) {
      vec3.copy(out.a, t.a);
      vec3.copy(out.b, t.b);
      vec3.copy(out.c, t.c);
      return out;
    };
    triangle.fromPoints = function(out, a, b, c) {
      vec3.copy(out.a, a);
      vec3.copy(out.b, b);
      vec3.copy(out.c, c);
      return out;
    };
    triangle.set = function(out, ax, ay, az, bx, by, bz, cx, cy, cz) {
      out.a.x = ax;
      out.a.y = ay;
      out.a.z = az;
      out.b.x = bx;
      out.b.y = by;
      out.b.z = bz;
      out.c.x = cx;
      out.c.y = cy;
      out.c.z = cz;
      return out;
    };
    module.exports = triangle;
  }), {} ],
  141: [ (function(require, module, exports) {
    "use strict";
    var RenderComponent = require("../components/CCRenderComponent");
    var Material = require("../assets/material/CCMaterial");
    var Types = require("./types");
    var LineCap = Types.LineCap;
    var LineJoin = Types.LineJoin;
    var Graphics = cc.Class({
      name: "cc.Graphics",
      extends: RenderComponent,
      editor: false,
      ctor: function ctor() {
        this._impl = new Graphics._Impl(this);
      },
      properties: {
        _lineWidth: 1,
        _strokeColor: cc.Color.BLACK,
        _lineJoin: LineJoin.MITER,
        _lineCap: LineCap.BUTT,
        _fillColor: cc.Color.WHITE,
        _miterLimit: 10,
        lineWidth: {
          get: function get() {
            return this._lineWidth;
          },
          set: function set(value) {
            this._lineWidth = value;
            this._impl.lineWidth = value;
          }
        },
        lineJoin: {
          get: function get() {
            return this._lineJoin;
          },
          set: function set(value) {
            this._lineJoin = value;
            this._impl.lineJoin = value;
          },
          type: LineJoin
        },
        lineCap: {
          get: function get() {
            return this._lineCap;
          },
          set: function set(value) {
            this._lineCap = value;
            this._impl.lineCap = value;
          },
          type: LineCap
        },
        strokeColor: {
          get: function get() {
            return this._strokeColor;
          },
          set: function set(value) {
            this._impl.strokeColor = this._strokeColor = cc.color(value);
          }
        },
        fillColor: {
          get: function get() {
            return this._fillColor;
          },
          set: function set(value) {
            this._impl.fillColor = this._fillColor = cc.color(value);
          }
        },
        miterLimit: {
          get: function get() {
            return this._miterLimit;
          },
          set: function set(value) {
            this._miterLimit = value;
            this._impl.miterLimit = value;
          }
        }
      },
      statics: {
        LineJoin: LineJoin,
        LineCap: LineCap
      },
      onRestore: function onRestore() {
        this._impl || (this._impl = new Graphics._Impl(this));
      },
      onEnable: function onEnable() {
        this._super();
        this._activateMaterial();
      },
      onDestroy: function onDestroy() {
        this.clear(true);
        this._super();
        this._impl = null;
      },
      _activateMaterial: function _activateMaterial() {
        if (cc.game.renderType === cc.game.RENDER_TYPE_CANVAS) {
          this.disableRender();
          return;
        }
        var material = this.sharedMaterials[0];
        material = material ? Material.getInstantiatedMaterial(material, this) : Material.getInstantiatedBuiltinMaterial("2d-base", this);
        material.define("CC_USE_MODEL", true);
        this.setMaterial(0, material);
      },
      moveTo: function moveTo(x, y) {
        if (true, x instanceof cc.Vec2) {
          cc.warn("[moveTo] : Can not pass Vec2 as [x, y] value, please check it.");
          return;
        }
        this._impl.moveTo(x, y);
      },
      lineTo: function lineTo(x, y) {
        if (true, x instanceof cc.Vec2) {
          cc.warn("[moveTo] : Can not pass Vec2 as [x, y] value, please check it.");
          return;
        }
        this._impl.lineTo(x, y);
      },
      bezierCurveTo: function bezierCurveTo(c1x, c1y, c2x, c2y, x, y) {
        this._impl.bezierCurveTo(c1x, c1y, c2x, c2y, x, y);
      },
      quadraticCurveTo: function quadraticCurveTo(cx, cy, x, y) {
        this._impl.quadraticCurveTo(cx, cy, x, y);
      },
      arc: function arc(cx, cy, r, startAngle, endAngle, counterclockwise) {
        this._impl.arc(cx, cy, r, startAngle, endAngle, counterclockwise);
      },
      ellipse: function ellipse(cx, cy, rx, ry) {
        this._impl.ellipse(cx, cy, rx, ry);
      },
      circle: function circle(cx, cy, r) {
        this._impl.circle(cx, cy, r);
      },
      rect: function rect(x, y, w, h) {
        this._impl.rect(x, y, w, h);
      },
      roundRect: function roundRect(x, y, w, h, r) {
        this._impl.roundRect(x, y, w, h, r);
      },
      fillRect: function fillRect(x, y, w, h) {
        this.rect(x, y, w, h);
        this.fill();
      },
      clear: function clear(clean) {
        this._impl.clear(clean);
        this._assembler && this._assembler.clear(clean);
      },
      close: function close() {
        this._impl.close();
      },
      stroke: function stroke() {
        this._assembler || this._resetAssembler();
        this._assembler.stroke(this);
      },
      fill: function fill() {
        this._assembler || this._resetAssembler();
        this._assembler.fill(this);
      }
    });
    cc.Graphics = module.exports = Graphics;
    cc.Graphics.Types = Types;
    cc.Graphics.Helper = require("./helper");
  }), {
    "../assets/material/CCMaterial": 76,
    "../components/CCRenderComponent": 107,
    "./helper": 142,
    "./types": 144
  } ],
  142: [ (function(require, module, exports) {
    "use strict";
    var PointFlags = require("./types").PointFlags;
    var PI = Math.PI;
    var min = Math.min;
    var max = Math.max;
    var cos = Math.cos;
    var sin = Math.sin;
    var abs = Math.abs;
    var sign = Math.sign;
    var KAPPA90 = .5522847493;
    function arc(ctx, cx, cy, r, startAngle, endAngle, counterclockwise) {
      counterclockwise = counterclockwise || false;
      var a = 0, da = 0, hda = 0, kappa = 0;
      var dx = 0, dy = 0, x = 0, y = 0, tanx = 0, tany = 0;
      var px = 0, py = 0, ptanx = 0, ptany = 0;
      var i, ndivs;
      da = endAngle - startAngle;
      if (counterclockwise) if (abs(da) >= 2 * PI) da = 2 * PI; else while (da < 0) da += 2 * PI; else if (abs(da) >= 2 * PI) da = 2 * -PI; else while (da > 0) da -= 2 * PI;
      ndivs = 0 | max(1, min(abs(da) / (.5 * PI) + .5, 5));
      hda = da / ndivs / 2;
      kappa = abs(4 / 3 * (1 - cos(hda)) / sin(hda));
      counterclockwise || (kappa = -kappa);
      for (i = 0; i <= ndivs; i++) {
        a = startAngle + da * (i / ndivs);
        dx = cos(a);
        dy = sin(a);
        x = cx + dx * r;
        y = cy + dy * r;
        tanx = -dy * r * kappa;
        tany = dx * r * kappa;
        0 === i ? ctx.moveTo(x, y) : ctx.bezierCurveTo(px + ptanx, py + ptany, x - tanx, y - tany, x, y);
        px = x;
        py = y;
        ptanx = tanx;
        ptany = tany;
      }
    }
    function ellipse(ctx, cx, cy, rx, ry) {
      ctx.moveTo(cx - rx, cy);
      ctx.bezierCurveTo(cx - rx, cy + ry * KAPPA90, cx - rx * KAPPA90, cy + ry, cx, cy + ry);
      ctx.bezierCurveTo(cx + rx * KAPPA90, cy + ry, cx + rx, cy + ry * KAPPA90, cx + rx, cy);
      ctx.bezierCurveTo(cx + rx, cy - ry * KAPPA90, cx + rx * KAPPA90, cy - ry, cx, cy - ry);
      ctx.bezierCurveTo(cx - rx * KAPPA90, cy - ry, cx - rx, cy - ry * KAPPA90, cx - rx, cy);
      ctx.close();
    }
    function roundRect(ctx, x, y, w, h, r) {
      if (r < .1) {
        ctx.rect(x, y, w, h);
        return;
      }
      var rx = min(r, .5 * abs(w)) * sign(w), ry = min(r, .5 * abs(h)) * sign(h);
      ctx.moveTo(x, y + ry);
      ctx.lineTo(x, y + h - ry);
      ctx.bezierCurveTo(x, y + h - ry * (1 - KAPPA90), x + rx * (1 - KAPPA90), y + h, x + rx, y + h);
      ctx.lineTo(x + w - rx, y + h);
      ctx.bezierCurveTo(x + w - rx * (1 - KAPPA90), y + h, x + w, y + h - ry * (1 - KAPPA90), x + w, y + h - ry);
      ctx.lineTo(x + w, y + ry);
      ctx.bezierCurveTo(x + w, y + ry * (1 - KAPPA90), x + w - rx * (1 - KAPPA90), y, x + w - rx, y);
      ctx.lineTo(x + rx, y);
      ctx.bezierCurveTo(x + rx * (1 - KAPPA90), y, x, y + ry * (1 - KAPPA90), x, y + ry);
      ctx.close();
    }
    function tesselateBezier(ctx, x1, y1, x2, y2, x3, y3, x4, y4, level, type) {
      var x12, y12, x23, y23, x34, y34, x123, y123, x234, y234, x1234, y1234;
      var dx, dy, d2, d3;
      if (level > 10) return;
      x12 = .5 * (x1 + x2);
      y12 = .5 * (y1 + y2);
      x23 = .5 * (x2 + x3);
      y23 = .5 * (y2 + y3);
      x34 = .5 * (x3 + x4);
      y34 = .5 * (y3 + y4);
      x123 = .5 * (x12 + x23);
      y123 = .5 * (y12 + y23);
      dx = x4 - x1;
      dy = y4 - y1;
      d2 = abs((x2 - x4) * dy - (y2 - y4) * dx);
      d3 = abs((x3 - x4) * dy - (y3 - y4) * dx);
      if ((d2 + d3) * (d2 + d3) < ctx._tessTol * (dx * dx + dy * dy)) {
        ctx._addPoint(x4, y4, 0 === type ? type | PointFlags.PT_BEVEL : type);
        return;
      }
      x234 = .5 * (x23 + x34);
      y234 = .5 * (y23 + y34);
      x1234 = .5 * (x123 + x234);
      y1234 = .5 * (y123 + y234);
      tesselateBezier(ctx, x1, y1, x12, y12, x123, y123, x1234, y1234, level + 1, 0);
      tesselateBezier(ctx, x1234, y1234, x234, y234, x34, y34, x4, y4, level + 1, type);
    }
    module.exports = {
      arc: arc,
      ellipse: ellipse,
      roundRect: roundRect,
      tesselateBezier: tesselateBezier
    };
  }), {
    "./types": 144
  } ],
  143: [ (function(require, module, exports) {
    "use strict";
    require("./graphics");
  }), {
    "./graphics": 141
  } ],
  144: [ (function(require, module, exports) {
    "use strict";
    var LineCap = cc.Enum({
      BUTT: 0,
      ROUND: 1,
      SQUARE: 2
    });
    var LineJoin = cc.Enum({
      BEVEL: 0,
      ROUND: 1,
      MITER: 2
    });
    var PointFlags = cc.Enum({
      PT_CORNER: 1,
      PT_LEFT: 2,
      PT_BEVEL: 4,
      PT_INNERBEVEL: 8
    });
    module.exports = {
      LineCap: LineCap,
      LineJoin: LineJoin,
      PointFlags: PointFlags
    };
  }), {} ],
  145: [ (function(require, module, exports) {
    "use strict";
    require("./platform");
    require("./assets");
    true;
    require("./CCNode");
    require("./CCPrivateNode");
    require("./CCScene");
    require("./components");
    require("./graphics");
    require("./collider");
    require("./collider/CCIntersection");
    require("./physics");
    require("./camera/CCCamera");
    require("./geom-utils");
    require("./mesh");
    require("./3d");
    require("./3d/polyfill-3d");
    require("./base-ui/CCWidgetManager");
  }), {
    "./3d": 30,
    "./3d/polyfill-3d": 31,
    "./CCNode": 53,
    "./CCPrivateNode": 54,
    "./CCScene": 55,
    "./assets": 75,
    "./base-ui/CCWidgetManager": 80,
    "./camera/CCCamera": 81,
    "./collider": 89,
    "./collider/CCIntersection": 87,
    "./components": 124,
    "./geom-utils": 137,
    "./graphics": 143,
    "./mesh": 168,
    "./physics": 183,
    "./platform": 216
  } ],
  146: [ (function(require, module, exports) {
    "use strict";
    var js = require("../platform/js");
    var Pipeline = require("./pipeline");
    var LoadingItems = require("./loading-items");
    var AssetLoader = require("./asset-loader");
    var Downloader = require("./downloader");
    var Loader = require("./loader");
    var AssetTable = require("./asset-table");
    var callInNextTick = require("../platform/utils").callInNextTick;
    var AutoReleaseUtils = require("./auto-release-utils");
    var ReleasedAssetChecker = (true, require("./released-asset-checker"));
    var assetTables = Object.create(null);
    assetTables.assets = new AssetTable();
    assetTables.internal = new AssetTable();
    function getXMLHttpRequest() {
      return window.XMLHttpRequest ? new window.XMLHttpRequest() : new ActiveXObject("MSXML2.XMLHTTP");
    }
    var _info = {
      url: null,
      raw: false
    };
    function getResWithUrl(res) {
      var id, result, isUuid;
      if ("object" === typeof res) {
        result = res;
        if (res.url) return result;
        id = res.uuid;
      } else {
        result = {};
        id = res;
      }
      isUuid = result.type ? "uuid" === result.type : cc.AssetLibrary._uuidInSettings(id);
      cc.AssetLibrary._getAssetInfoInRuntime(id, _info);
      result.url = isUuid ? _info.url : id;
      if (_info.url && "uuid" === result.type && _info.raw) {
        result.type = null;
        result.isRawAsset = true;
      } else isUuid || (result.isRawAsset = true);
      return result;
    }
    var _sharedResources = [];
    var _sharedList = [];
    function CCLoader() {
      var assetLoader = new AssetLoader();
      var downloader = new Downloader();
      var loader = new Loader();
      Pipeline.call(this, [ assetLoader, downloader, loader ]);
      this.assetLoader = assetLoader;
      this.md5Pipe = null;
      this.downloader = downloader;
      this.loader = loader;
      this.onProgress = null;
      this._autoReleaseSetting = js.createMap(true);
      true;
      this._releasedAssetChecker_DEBUG = new ReleasedAssetChecker();
    }
    js.extend(CCLoader, Pipeline);
    var proto = CCLoader.prototype;
    proto.init = function(director) {
      true;
      var self = this;
      director.on(cc.Director.EVENT_AFTER_UPDATE, (function() {
        self._releasedAssetChecker_DEBUG.checkCouldRelease(self._cache);
      }));
    };
    proto.getXMLHttpRequest = getXMLHttpRequest;
    proto.addDownloadHandlers = function(extMap) {
      this.downloader.addHandlers(extMap);
    };
    proto.addLoadHandlers = function(extMap) {
      this.loader.addHandlers(extMap);
    };
    proto.load = function(resources, progressCallback, completeCallback) {
      false;
      if (void 0 === completeCallback) {
        completeCallback = progressCallback;
        progressCallback = this.onProgress || null;
      }
      var self = this;
      var singleRes = false;
      var res;
      if (!(resources instanceof Array)) if (resources) {
        singleRes = true;
        resources = [ resources ];
      } else resources = [];
      _sharedResources.length = 0;
      for (var i = 0; i < resources.length; ++i) {
        var resource = resources[i];
        if (resource && resource.id) {
          cc.warnID(4920, resource.id);
          resource.uuid || resource.url || (resource.url = resource.id);
        }
        res = getResWithUrl(resource);
        if (!res.url && !res.uuid) continue;
        var item = this._cache[res.url];
        _sharedResources.push(item || res);
      }
      var queue = LoadingItems.create(this, progressCallback, (function(errors, items) {
        callInNextTick((function() {
          if (completeCallback) {
            if (singleRes) {
              var id = res.url;
              completeCallback.call(self, errors, items.getContent(id));
            } else completeCallback.call(self, errors, items);
            completeCallback = null;
          }
          var _id;
          false;
          items.destroy();
        }));
      }));
      LoadingItems.initQueueDeps(queue);
      queue.append(_sharedResources);
      _sharedResources.length = 0;
    };
    proto.flowInDeps = function(owner, urlList, callback) {
      _sharedList.length = 0;
      for (var i = 0; i < urlList.length; ++i) {
        var res = getResWithUrl(urlList[i]);
        if (!res.url && !res.uuid) continue;
        var item = this._cache[res.url];
        item ? _sharedList.push(item) : _sharedList.push(res);
      }
      var queue = LoadingItems.create(this, owner ? function(completedCount, totalCount, item) {
        this._ownerQueue && this._ownerQueue.onProgress && this._ownerQueue._childOnProgress(item);
      } : null, (function(errors, items) {
        callback(errors, items);
        owner && owner.deps && (owner.deps.length = 0);
        items.destroy();
      }));
      if (owner) {
        var ownerQueue = LoadingItems.getQueue(owner);
        queue._ownerQueue = ownerQueue._ownerQueue || ownerQueue;
      }
      var accepted = queue.append(_sharedList, owner);
      _sharedList.length = 0;
      return accepted;
    };
    proto._assetTables = assetTables;
    proto._getResUuid = function(url, type, mount, quiet) {
      mount = mount || "assets";
      var assetTable = assetTables[mount];
      if (!url || !assetTable) return null;
      var index = url.indexOf("?");
      -1 !== index && (url = url.substr(0, index));
      var uuid = assetTable.getUuid(url, type);
      if (!uuid) {
        var extname = cc.path.extname(url);
        if (extname) {
          url = url.slice(0, -extname.length);
          uuid = assetTable.getUuid(url, type);
          uuid && !quiet && cc.warnID(4901, url, extname);
        }
      }
      return uuid;
    };
    proto._getReferenceKey = function(assetOrUrlOrUuid) {
      var key;
      "object" === typeof assetOrUrlOrUuid ? key = assetOrUrlOrUuid._uuid || null : "string" === typeof assetOrUrlOrUuid && (key = this._getResUuid(assetOrUrlOrUuid, null, null, true) || assetOrUrlOrUuid);
      if (!key) {
        cc.warnID(4800, assetOrUrlOrUuid);
        return key;
      }
      cc.AssetLibrary._getAssetInfoInRuntime(key, _info);
      return this._cache[_info.url] ? _info.url : key;
    };
    proto._urlNotFound = function(url, type, completeCallback) {
      callInNextTick((function() {
        url = cc.url.normalize(url);
        var info = (type ? js.getClassName(type) : "Asset") + ' in "resources/' + url + '" does not exist.';
        completeCallback && completeCallback(new Error(info), []);
      }));
    };
    proto._parseLoadResArgs = function(type, onProgress, onComplete) {
      if (void 0 === onComplete) {
        var isValidType = type instanceof Array || js.isChildClassOf(type, cc.RawAsset);
        if (onProgress) {
          onComplete = onProgress;
          isValidType && (onProgress = this.onProgress || null);
        } else if (void 0 === onProgress && !isValidType) {
          onComplete = type;
          onProgress = this.onProgress || null;
          type = null;
        }
        if (void 0 !== onProgress && !isValidType) {
          onProgress = type;
          type = null;
        }
      }
      return {
        type: type,
        onProgress: onProgress,
        onComplete: onComplete
      };
    };
    proto.loadRes = function(url, type, mount, progressCallback, completeCallback) {
      if (5 !== arguments.length) {
        completeCallback = progressCallback;
        progressCallback = mount;
        mount = "assets";
      }
      var args = this._parseLoadResArgs(type, progressCallback, completeCallback);
      type = args.type;
      progressCallback = args.onProgress;
      completeCallback = args.onComplete;
      var self = this;
      var uuid = self._getResUuid(url, type, mount);
      uuid ? this.load({
        type: "uuid",
        uuid: uuid
      }, progressCallback, (function(err, asset) {
        asset && self.setAutoReleaseRecursively(uuid, false);
        completeCallback && completeCallback(err, asset);
      })) : self._urlNotFound(url, type, completeCallback);
    };
    proto._loadResUuids = function(uuids, progressCallback, completeCallback, urls) {
      if (uuids.length > 0) {
        var self = this;
        var res = uuids.map((function(uuid) {
          return {
            type: "uuid",
            uuid: uuid
          };
        }));
        this.load(res, progressCallback, (function(errors, items) {
          if (completeCallback) {
            var assetRes = [];
            var urlRes = urls && [];
            for (var i = 0; i < res.length; ++i) {
              var uuid = res[i].uuid;
              var id = this._getReferenceKey(uuid);
              var item = items.getContent(id);
              if (item) {
                self.setAutoReleaseRecursively(uuid, false);
                assetRes.push(item);
                urlRes && urlRes.push(urls[i]);
              }
            }
            urls ? completeCallback(errors, assetRes, urlRes) : completeCallback(errors, assetRes);
          }
        }));
      } else completeCallback && callInNextTick((function() {
        urls ? completeCallback(null, [], []) : completeCallback(null, []);
      }));
    };
    proto.loadResArray = function(urls, type, mount, progressCallback, completeCallback) {
      if (5 !== arguments.length) {
        completeCallback = progressCallback;
        progressCallback = mount;
        mount = "assets";
      }
      var args = this._parseLoadResArgs(type, progressCallback, completeCallback);
      type = args.type;
      progressCallback = args.onProgress;
      completeCallback = args.onComplete;
      var uuids = [];
      var isTypesArray = type instanceof Array;
      for (var i = 0; i < urls.length; i++) {
        var url = urls[i];
        var assetType = isTypesArray ? type[i] : type;
        var uuid = this._getResUuid(url, assetType, mount);
        if (!uuid) {
          this._urlNotFound(url, assetType, completeCallback);
          return;
        }
        uuids.push(uuid);
      }
      this._loadResUuids(uuids, progressCallback, completeCallback);
    };
    proto.loadResDir = function(url, type, mount, progressCallback, completeCallback) {
      if (5 !== arguments.length) {
        completeCallback = progressCallback;
        progressCallback = mount;
        mount = "assets";
      }
      if (!assetTables[mount]) return;
      var args = this._parseLoadResArgs(type, progressCallback, completeCallback);
      type = args.type;
      progressCallback = args.onProgress;
      completeCallback = args.onComplete;
      var urls = [];
      var uuids = assetTables[mount].getUuidArray(url, type, urls);
      this._loadResUuids(uuids, progressCallback, completeCallback, urls);
    };
    proto.getRes = function(url, type) {
      var item = this._cache[url];
      if (!item) {
        var uuid = this._getResUuid(url, type, null, true);
        if (!uuid) return null;
        var ref = this._getReferenceKey(uuid);
        item = this._cache[ref];
      }
      item && item.alias && (item = item.alias);
      return item && item.complete ? item.content : null;
    };
    proto.getResCount = function() {
      return Object.keys(this._cache).length;
    };
    proto.getDependsRecursively = function(owner) {
      if (owner) {
        var key = this._getReferenceKey(owner);
        var assets = AutoReleaseUtils.getDependsRecursively(key);
        assets.push(key);
        return assets;
      }
      return [];
    };
    proto.release = function(asset) {
      if (Array.isArray(asset)) for (var i = 0; i < asset.length; i++) {
        var key = asset[i];
        this.release(key);
      } else if (asset) {
        var id = this._getReferenceKey(asset);
        if ((true, id) && id in cc.AssetLibrary.getBuiltinDeps()) return;
        var item = this.getItem(id);
        if (item) {
          var removed = this.removeItem(id);
          asset = item.content;
          (true, removed) && this._releasedAssetChecker_DEBUG.setReleased(item, id);
        }
        if (asset instanceof cc.Asset) {
          var nativeUrl = asset.nativeUrl;
          nativeUrl && this.release(nativeUrl);
          asset.destroy();
        }
      }
    };
    proto.releaseAsset = function(asset) {
      var uuid = asset._uuid;
      uuid && this.release(uuid);
    };
    proto.releaseRes = function(url, type, mount) {
      var uuid = this._getResUuid(url, type, mount);
      uuid ? this.release(uuid) : cc.errorID(4914, url);
    };
    proto.releaseResDir = function(url, type, mount) {
      mount = mount || "assets";
      if (!assetTables[mount]) return;
      var uuids = assetTables[mount].getUuidArray(url, type);
      for (var i = 0; i < uuids.length; i++) {
        var uuid = uuids[i];
        this.release(uuid);
      }
    };
    proto.releaseAll = function() {
      for (var id in this._cache) this.release(id);
    };
    proto.removeItem = function(key) {
      var removed = Pipeline.prototype.removeItem.call(this, key);
      delete this._autoReleaseSetting[key];
      return removed;
    };
    proto.setAutoRelease = function(assetOrUrlOrUuid, autoRelease) {
      var key = this._getReferenceKey(assetOrUrlOrUuid);
      !!key && (this._autoReleaseSetting[key] = !!autoRelease);
    };
    proto.setAutoReleaseRecursively = function(assetOrUrlOrUuid, autoRelease) {
      autoRelease = !!autoRelease;
      var key = this._getReferenceKey(assetOrUrlOrUuid);
      if (key) {
        this._autoReleaseSetting[key] = autoRelease;
        var depends = AutoReleaseUtils.getDependsRecursively(key);
        for (var i = 0; i < depends.length; i++) {
          var depend = depends[i];
          this._autoReleaseSetting[depend] = autoRelease;
        }
      } else false;
    };
    proto.isAutoRelease = function(assetOrUrl) {
      var key = this._getReferenceKey(assetOrUrl);
      if (key) return !!this._autoReleaseSetting[key];
      return false;
    };
    cc.loader = new CCLoader();
    false;
    module.exports = cc.loader;
  }), {
    "../platform/js": 219,
    "../platform/utils": 223,
    "./asset-loader": 147,
    "./asset-table": 148,
    "./auto-release-utils": 150,
    "./downloader": 152,
    "./loader": 155,
    "./loading-items": 156,
    "./pipeline": 159,
    "./released-asset-checker": 160
  } ],
  147: [ (function(require, module, exports) {
    "use strict";
    require("../utils/CCPath");
    var debug = require("../CCDebug");
    var Pipeline = require("./pipeline");
    var LoadingItems = require("./loading-items");
    var ID = "AssetLoader";
    var AssetLoader = function AssetLoader(extMap) {
      this.id = ID;
      this.async = true;
      this.pipeline = null;
    };
    AssetLoader.ID = ID;
    var reusedArray = [];
    AssetLoader.prototype.handle = function(item, callback) {
      var uuid = item.uuid;
      if (!uuid) return item.content || null;
      var self = this;
      cc.AssetLibrary.queryAssetInfo(uuid, (function(error, url, isRawAsset) {
        if (error) callback(error); else {
          item.url = item.rawUrl = url;
          item.isRawAsset = isRawAsset;
          if (isRawAsset) {
            var ext = cc.path.extname(url).toLowerCase();
            if (!ext) {
              callback(new Error(debug.getError(4931, uuid, url)));
              return;
            }
            ext = ext.substr(1);
            var queue = LoadingItems.getQueue(item);
            reusedArray[0] = {
              queueId: item.queueId,
              id: url,
              url: url,
              type: ext,
              error: null,
              alias: item,
              complete: true
            };
            false;
            queue.append(reusedArray);
            item.type = ext;
            callback(null, item.content);
          } else {
            item.type = "uuid";
            callback(null, item.content);
          }
        }
      }));
    };
    Pipeline.AssetLoader = module.exports = AssetLoader;
  }), {
    "../CCDebug": 50,
    "../utils/CCPath": 288,
    "./loading-items": 156,
    "./pipeline": 159
  } ],
  148: [ (function(require, module, exports) {
    "use strict";
    var pushToMap = require("../utils/misc").pushToMap;
    var js = require("../platform/js");
    function Entry(uuid, type) {
      this.uuid = uuid;
      this.type = type;
    }
    function AssetTable() {
      this._pathToUuid = js.createMap(true);
    }
    function isMatchByWord(path, test) {
      if (path.length > test.length) {
        var nextAscii = path.charCodeAt(test.length);
        return 46 === nextAscii || 47 === nextAscii;
      }
      return true;
    }
    var proto = AssetTable.prototype;
    proto.getUuid = function(path, type) {
      path = cc.url.normalize(path);
      var item = this._pathToUuid[path];
      if (item) if (Array.isArray(item)) {
        if (!type) return item[0].uuid;
        for (var i = 0; i < item.length; i++) {
          var entry = item[i];
          if (js.isChildClassOf(entry.type, type)) return entry.uuid;
        }
        if (true, js.isChildClassOf(type, cc.SpriteFrame)) for (var _i = 0; _i < item.length; _i++) {
          var _entry = item[_i];
          if (js.isChildClassOf(_entry.type, cc.SpriteAtlas)) {
            cc.errorID(4932, path);
            break;
          }
        }
      } else {
        if (!type || js.isChildClassOf(item.type, type)) return item.uuid;
        (true, js.isChildClassOf(type, cc.SpriteFrame)) && js.isChildClassOf(item.type, cc.SpriteAtlas) && cc.errorID(4932, path);
      }
      return "";
    };
    proto.getUuidArray = function(path, type, out_urls) {
      path = cc.url.normalize(path);
      "/" === path[path.length - 1] && (path = path.slice(0, -1));
      var path2uuid = this._pathToUuid;
      var uuids = [];
      var isChildClassOf = js.isChildClassOf;
      var _foundAtlasUrl;
      for (var p in path2uuid) if (p.startsWith(path) && isMatchByWord(p, path) || !path) {
        var item = path2uuid[p];
        if (Array.isArray(item)) for (var i = 0; i < item.length; i++) {
          var entry = item[i];
          if (!type || isChildClassOf(entry.type, type)) {
            uuids.push(entry.uuid);
            out_urls && out_urls.push(p);
          } else (true, entry.type === cc.SpriteAtlas) && (_foundAtlasUrl = p);
        } else if (!type || isChildClassOf(item.type, type)) {
          uuids.push(item.uuid);
          out_urls && out_urls.push(p);
        } else (true, item.type === cc.SpriteAtlas) && (_foundAtlasUrl = p);
      }
      (true, 0 === uuids.length) && _foundAtlasUrl && js.isChildClassOf(type, cc.SpriteFrame) && cc.errorID(4932, _foundAtlasUrl);
      return uuids;
    };
    proto.add = function(path, uuid, type, isMainAsset) {
      path = path.substring(0, path.length - cc.path.extname(path).length);
      var newEntry = new Entry(uuid, type);
      pushToMap(this._pathToUuid, path, newEntry, isMainAsset);
    };
    proto._getInfo_DEBUG = (true, function(uuid, out_info) {
      var path2uuid = this._pathToUuid;
      var paths = Object.keys(path2uuid);
      for (var p = 0; p < paths.length; ++p) {
        var path = paths[p];
        var item = path2uuid[path];
        if (Array.isArray(item)) for (var i = 0; i < item.length; i++) {
          var entry = item[i];
          if (entry.uuid === uuid) {
            out_info.path = path;
            out_info.type = entry.type;
            return true;
          }
        } else if (item.uuid === uuid) {
          out_info.path = path;
          out_info.type = item.type;
          return true;
        }
      }
      return false;
    });
    proto.reset = function() {
      this._pathToUuid = js.createMap(true);
    };
    module.exports = AssetTable;
  }), {
    "../platform/js": 219,
    "../utils/misc": 299
  } ],
  149: [ (function(require, module, exports) {
    "use strict";
    var sys = require("../platform/CCSys");
    var debug = require("../CCDebug");
    var __audioSupport = sys.__audioSupport;
    var formatSupport = __audioSupport.format;
    var context = __audioSupport.context;
    function loadDomAudio(item, callback) {
      var dom = document.createElement("audio");
      dom.src = item.url;
      var clearEvent = function clearEvent() {
        clearTimeout(timer);
        dom.removeEventListener("canplaythrough", success, false);
        dom.removeEventListener("error", failure, false);
        __audioSupport.USE_LOADER_EVENT && dom.removeEventListener(__audioSupport.USE_LOADER_EVENT, success, false);
      };
      var timer = setTimeout((function() {
        0 === dom.readyState ? failure() : success();
      }), 8e3);
      var success = function success() {
        clearEvent();
        callback(null, dom);
      };
      var failure = function failure() {
        clearEvent();
        var message = "load audio failure - " + item.url;
        cc.log(message);
        callback(message);
      };
      dom.addEventListener("canplaythrough", success, false);
      dom.addEventListener("error", failure, false);
      __audioSupport.USE_LOADER_EVENT && dom.addEventListener(__audioSupport.USE_LOADER_EVENT, success, false);
    }
    function loadWebAudio(item, callback) {
      context || callback(new Error(debug.getError(4926)));
      var request = cc.loader.getXMLHttpRequest();
      request.open("GET", item.url, true);
      request.responseType = "arraybuffer";
      request.onload = function() {
        context["decodeAudioData"](request.response, (function(buffer) {
          callback(null, buffer);
        }), (function() {
          callback("decode error - " + item.id, null);
        }));
      };
      request.onerror = function() {
        callback("request error - " + item.id, null);
      };
      request.send();
    }
    function downloadAudio(item, callback) {
      if (0 === formatSupport.length) return new Error(debug.getError(4927));
      var loader;
      if (__audioSupport.WEB_AUDIO) {
        var loadByDeserializedAudio = item._owner instanceof cc.AudioClip;
        loader = loadByDeserializedAudio ? item._owner.loadMode === cc.AudioClip.LoadMode.WEB_AUDIO ? loadWebAudio : loadDomAudio : item.urlParam && item.urlParam["useDom"] ? loadDomAudio : loadWebAudio;
      } else loader = loadDomAudio;
      loader(item, callback);
    }
    module.exports = downloadAudio;
  }), {
    "../CCDebug": 50,
    "../platform/CCSys": 208
  } ],
  150: [ (function(require, module, exports) {
    "use strict";
    var js = require("../platform/js");
    function parseDepends(key, parsed) {
      var item = cc.loader.getItem(key);
      if (item) {
        var depends = item.dependKeys;
        if (depends) for (var i = 0; i < depends.length; i++) {
          var depend = depends[i];
          if (!parsed[depend]) {
            parsed[depend] = true;
            parseDepends(depend, parsed);
          }
        }
      }
    }
    function visitAsset(asset, excludeMap) {
      if (!asset._uuid) return;
      var key = cc.loader._getReferenceKey(asset);
      if (!excludeMap[key]) {
        excludeMap[key] = true;
        parseDepends(key, excludeMap);
      }
    }
    function visitComponent(comp, excludeMap) {
      var props = Object.getOwnPropertyNames(comp);
      for (var i = 0; i < props.length; i++) {
        var value = comp[props[i]];
        if ("object" === typeof value && value) if (Array.isArray(value)) for (var j = 0; j < value.length; j++) {
          var val = value[j];
          val instanceof cc.RawAsset && visitAsset(val, excludeMap);
        } else if (value.constructor && value.constructor !== Object) value instanceof cc.RawAsset && visitAsset(value, excludeMap); else {
          var keys = Object.getOwnPropertyNames(value);
          for (var _j = 0; _j < keys.length; _j++) {
            var _val = value[keys[_j]];
            _val instanceof cc.RawAsset && visitAsset(_val, excludeMap);
          }
        }
      }
    }
    function visitNode(node, excludeMap) {
      for (var i = 0; i < node._components.length; i++) visitComponent(node._components[i], excludeMap);
      for (var _i = 0; _i < node._children.length; _i++) visitNode(node._children[_i], excludeMap);
    }
    module.exports = {
      autoRelease: function autoRelease(oldSceneAssets, nextSceneAssets, persistNodes) {
        var releaseSettings = cc.loader._autoReleaseSetting;
        var excludeMap = js.createMap();
        if (nextSceneAssets) for (var i = 0; i < nextSceneAssets.length; i++) excludeMap[nextSceneAssets[i]] = true;
        for (var _i2 = 0; _i2 < persistNodes.length; _i2++) visitNode(persistNodes[_i2], excludeMap);
        if (oldSceneAssets) for (var _i3 = 0; _i3 < oldSceneAssets.length; _i3++) {
          var key = oldSceneAssets[_i3];
          false === releaseSettings[key] || excludeMap[key] || cc.loader.release(key);
        }
        var keys = Object.keys(releaseSettings);
        for (var _i4 = 0; _i4 < keys.length; _i4++) {
          var _key = keys[_i4];
          true !== releaseSettings[_key] || excludeMap[_key] || cc.loader.release(_key);
        }
      },
      getDependsRecursively: function getDependsRecursively(key) {
        var depends = {};
        parseDepends(key, depends);
        return Object.keys(depends);
      }
    };
  }), {
    "../platform/js": 219
  } ],
  151: [ (function(require, module, exports) {
    "use strict";
    function downloadBinary(item, callback) {
      var url = item.url;
      var xhr = cc.loader.getXMLHttpRequest(), errInfo = "Load binary data failed: " + url;
      xhr.open("GET", url, true);
      xhr.responseType = "arraybuffer";
      xhr.onload = function() {
        var arrayBuffer = xhr.response;
        if (arrayBuffer) {
          var result = new Uint8Array(arrayBuffer);
          callback(null, result);
        } else callback({
          status: xhr.status,
          errorMessage: errInfo + "(no response)"
        });
      };
      xhr.onerror = function() {
        callback({
          status: xhr.status,
          errorMessage: errInfo + "(error)"
        });
      };
      xhr.ontimeout = function() {
        callback({
          status: xhr.status,
          errorMessage: errInfo + "(time out)"
        });
      };
      xhr.send(null);
    }
    module.exports = downloadBinary;
  }), {} ],
  152: [ (function(require, module, exports) {
    "use strict";
    var js = require("../platform/js");
    var debug = require("../CCDebug");
    require("../utils/CCPath");
    var Pipeline = require("./pipeline");
    var PackDownloader = require("./pack-downloader");
    var downloadBinary = require("./binary-downloader");
    var downloadText = require("./text-downloader");
    var urlAppendTimestamp = require("./utils").urlAppendTimestamp;
    var downloadAudio;
    true;
    downloadAudio = require("./audio-downloader");
    function skip() {
      return null;
    }
    function downloadScript(item, callback, isAsync) {
      var url = item.url, d = document, s = document.createElement("script");
      "file:" !== window.location.protocol && (s.crossOrigin = "anonymous");
      s.async = isAsync;
      s.src = urlAppendTimestamp(url);
      function loadHandler() {
        s.parentNode.removeChild(s);
        s.removeEventListener("load", loadHandler, false);
        s.removeEventListener("error", errorHandler, false);
        callback(null, url);
      }
      function errorHandler() {
        s.parentNode.removeChild(s);
        s.removeEventListener("load", loadHandler, false);
        s.removeEventListener("error", errorHandler, false);
        callback(new Error(debug.getError(4928, url)));
      }
      s.addEventListener("load", loadHandler, false);
      s.addEventListener("error", errorHandler, false);
      d.body.appendChild(s);
    }
    function downloadImage(item, callback, isCrossOrigin, img) {
      void 0 === isCrossOrigin && (isCrossOrigin = true);
      var url = urlAppendTimestamp(item.url);
      img = img || new Image();
      isCrossOrigin && "file:" !== window.location.protocol ? img.crossOrigin = "anonymous" : img.crossOrigin = null;
      if (img.complete && img.naturalWidth > 0 && img.src === url) return img;
      var loadCallback = function loadCallback() {
        img.removeEventListener("load", loadCallback);
        img.removeEventListener("error", errorCallback);
        img.id = item.id;
        callback(null, img);
      };
      var errorCallback = function errorCallback() {
        img.removeEventListener("load", loadCallback);
        img.removeEventListener("error", errorCallback);
        "https:" !== window.location.protocol && img.crossOrigin && "anonymous" === img.crossOrigin.toLowerCase() ? downloadImage(item, callback, false, img) : callback(new Error(debug.getError(4930, url)));
      };
      img.addEventListener("load", loadCallback);
      img.addEventListener("error", errorCallback);
      img.src = url;
    }
    function downloadUuid(item, callback) {
      var result = PackDownloader.load(item, callback);
      if (void 0 === result) return this.extMap["json"](item, callback);
      return result || void 0;
    }
    var defaultMap = {
      js: downloadScript,
      png: downloadImage,
      jpg: downloadImage,
      bmp: downloadImage,
      jpeg: downloadImage,
      gif: downloadImage,
      ico: downloadImage,
      tiff: downloadImage,
      webp: downloadImage,
      image: downloadImage,
      pvr: downloadBinary,
      pkm: downloadBinary,
      mp3: downloadAudio,
      ogg: downloadAudio,
      wav: downloadAudio,
      m4a: downloadAudio,
      txt: downloadText,
      xml: downloadText,
      vsh: downloadText,
      fsh: downloadText,
      atlas: downloadText,
      tmx: downloadText,
      tsx: downloadText,
      json: downloadText,
      ExportJson: downloadText,
      plist: downloadText,
      fnt: downloadText,
      font: skip,
      eot: skip,
      ttf: skip,
      woff: skip,
      svg: skip,
      ttc: skip,
      uuid: downloadUuid,
      binary: downloadBinary,
      bin: downloadBinary,
      dbbin: downloadBinary,
      default: downloadText
    };
    var ID = "Downloader";
    var Downloader = function Downloader(extMap) {
      this.id = ID;
      this.async = true;
      this.pipeline = null;
      this._curConcurrent = 0;
      this._loadQueue = [];
      this._subpackages = {};
      this.extMap = js.mixin(extMap, defaultMap);
    };
    Downloader.ID = ID;
    Downloader.PackDownloader = PackDownloader;
    Downloader.prototype.addHandlers = function(extMap) {
      js.mixin(this.extMap, extMap);
    };
    Downloader.prototype._handleLoadQueue = function() {
      while (this._curConcurrent < cc.macro.DOWNLOAD_MAX_CONCURRENT) {
        var nextOne = this._loadQueue.shift();
        if (!nextOne) break;
        var syncRet = this.handle(nextOne.item, nextOne.callback);
        void 0 !== syncRet && (syncRet instanceof Error ? nextOne.callback(syncRet) : nextOne.callback(null, syncRet));
      }
    };
    Downloader.prototype.handle = function(item, callback) {
      var self = this;
      var downloadFunc = this.extMap[item.type] || this.extMap["default"];
      var syncRet = void 0;
      if (this._curConcurrent < cc.macro.DOWNLOAD_MAX_CONCURRENT) {
        this._curConcurrent++;
        syncRet = downloadFunc.call(this, item, (function(err, result) {
          self._curConcurrent = Math.max(0, self._curConcurrent - 1);
          self._handleLoadQueue();
          callback && callback(err, result);
        }));
        if (void 0 !== syncRet) {
          this._curConcurrent = Math.max(0, this._curConcurrent - 1);
          this._handleLoadQueue();
          return syncRet;
        }
      } else if (item.ignoreMaxConcurrency) {
        syncRet = downloadFunc.call(this, item, callback);
        if (void 0 !== syncRet) return syncRet;
      } else this._loadQueue.push({
        item: item,
        callback: callback
      });
    };
    Downloader.prototype.loadSubpackage = function(name, completeCallback) {
      var pac = this._subpackages[name];
      pac ? pac.loaded ? completeCallback && completeCallback() : downloadScript({
        url: pac.path + "index.js"
      }, (function(err) {
        err || (pac.loaded = true);
        completeCallback && completeCallback(err);
      })) : completeCallback && completeCallback(new Error("Can't find subpackage " + name));
    };
    Pipeline.Downloader = module.exports = Downloader;
  }), {
    "../CCDebug": 50,
    "../platform/js": 219,
    "../utils/CCPath": 288,
    "./audio-downloader": 149,
    "./binary-downloader": 151,
    "./pack-downloader": 158,
    "./pipeline": 159,
    "./text-downloader": 162,
    "./utils": 164
  } ],
  153: [ (function(require, module, exports) {
    "use strict";
    var textUtils = require("../utils/text-utils");
    var _canvasContext = null;
    var _testString = "BES bswy:->@123\u4e01\u3041\u1101";
    var _fontFaces = {};
    var _intervalId = -1;
    var _loadingFonts = [];
    var _timeout = 3e3;
    var useNativeCheck = (function() {
      var nativeCheck = void 0;
      return function() {
        if (void 0 === nativeCheck) if (!window.FontFace) nativeCheck = false; else {
          var match = /Gecko.*Firefox\/(\d+)/.exec(window.navigator.userAgent);
          var safari10Match = /OS X.*Version\/10\..*Safari/.exec(window.navigator.userAgent) && /Apple/.exec(window.navigator.vendor);
          nativeCheck = match ? parseInt(match[1], 10) > 42 : !safari10Match;
        }
        return nativeCheck;
      };
    })();
    function _checkFontLoaded() {
      var allFontsLoaded = true;
      var now = Date.now();
      for (var i = _loadingFonts.length - 1; i >= 0; i--) {
        var fontLoadHandle = _loadingFonts[i];
        var fontFamily = fontLoadHandle.fontFamilyName;
        if (now - fontLoadHandle.startTime > _timeout) {
          cc.warnID(4933, fontFamily);
          fontLoadHandle.callback(null, fontFamily);
          _loadingFonts.splice(i, 1);
          continue;
        }
        var oldWidth = fontLoadHandle.refWidth;
        _canvasContext.font = "40px " + fontFamily;
        var newWidth = textUtils.safeMeasureText(_canvasContext, _testString);
        if (oldWidth !== newWidth) {
          _loadingFonts.splice(i, 1);
          fontLoadHandle.callback(null, fontFamily);
        } else allFontsLoaded = false;
      }
      if (allFontsLoaded) {
        clearInterval(_intervalId);
        _intervalId = -1;
      }
    }
    function nativeCheckFontLoaded(start, font, callback) {
      var loader = new Promise(function(resolve, reject) {
        var check = function check() {
          var now = Date.now();
          now - start >= _timeout ? reject() : document.fonts.load("40px " + font).then((function(fonts) {
            fonts.length >= 1 ? resolve() : setTimeout(check, 100);
          }), (function() {
            reject();
          }));
        };
        check();
      });
      var timeoutId = null, timer = new Promise(function(resolve, reject) {
        timeoutId = setTimeout(reject, _timeout);
      });
      Promise.race([ timer, loader ]).then((function() {
        if (timeoutId) {
          clearTimeout(timeoutId);
          timeoutId = null;
        }
        callback(null, font);
      }), (function() {
        cc.warnID(4933, font);
        callback(null, font);
      }));
    }
    var fontLoader = {
      loadFont: function loadFont(item, callback) {
        var url = item.url;
        var fontFamilyName = fontLoader._getFontFamily(url);
        if (_fontFaces[fontFamilyName]) return fontFamilyName;
        if (!_canvasContext) {
          var labelCanvas = document.createElement("canvas");
          labelCanvas.width = 100;
          labelCanvas.height = 100;
          _canvasContext = labelCanvas.getContext("2d");
        }
        var fontDesc = "40px " + fontFamilyName;
        _canvasContext.font = fontDesc;
        var refWidth = textUtils.safeMeasureText(_canvasContext, _testString);
        var fontStyle = document.createElement("style");
        fontStyle.type = "text/css";
        var fontStr = "";
        isNaN(fontFamilyName - 0) ? fontStr += "@font-face { font-family:" + fontFamilyName + "; src:" : fontStr += "@font-face { font-family:'" + fontFamilyName + "'; src:";
        fontStr += "url('" + url + "');";
        fontStyle.textContent = fontStr + "}";
        document.body.appendChild(fontStyle);
        var preloadDiv = document.createElement("div");
        var divStyle = preloadDiv.style;
        divStyle.fontFamily = fontFamilyName;
        preloadDiv.innerHTML = ".";
        divStyle.position = "absolute";
        divStyle.left = "-100px";
        divStyle.top = "-100px";
        document.body.appendChild(preloadDiv);
        if (useNativeCheck()) nativeCheckFontLoaded(Date.now(), fontFamilyName, callback); else {
          var fontLoadHandle = {
            fontFamilyName: fontFamilyName,
            refWidth: refWidth,
            callback: callback,
            startTime: Date.now()
          };
          _loadingFonts.push(fontLoadHandle);
          -1 === _intervalId && (_intervalId = setInterval(_checkFontLoaded, 100));
        }
        _fontFaces[fontFamilyName] = fontStyle;
      },
      _getFontFamily: function _getFontFamily(fontHandle) {
        var ttfIndex = fontHandle.lastIndexOf(".ttf");
        if (-1 === ttfIndex) return fontHandle;
        var slashPos = fontHandle.lastIndexOf("/");
        var fontFamilyName;
        fontFamilyName = -1 === slashPos ? fontHandle.substring(0, ttfIndex) + "_LABEL" : fontHandle.substring(slashPos + 1, ttfIndex) + "_LABEL";
        -1 !== fontFamilyName.indexOf(" ") && (fontFamilyName = '"' + fontFamilyName + '"');
        return fontFamilyName;
      }
    };
    module.exports = fontLoader;
  }), {
    "../utils/text-utils": 306
  } ],
  154: [ (function(require, module, exports) {
    "use strict";
    require("./downloader");
    require("./loader");
    require("./loading-items");
    require("./pipeline");
    require("./CCLoader");
  }), {
    "./CCLoader": 146,
    "./downloader": 152,
    "./loader": 155,
    "./loading-items": 156,
    "./pipeline": 159
  } ],
  155: [ (function(require, module, exports) {
    "use strict";
    var js = require("../platform/js");
    var plistParser = require("../platform/CCSAXParser").plistParser;
    var Pipeline = require("./pipeline");
    var Texture2D = require("../assets/CCTexture2D");
    var loadUuid = require("./uuid-loader");
    var fontLoader = require("./font-loader");
    function loadNothing() {
      return null;
    }
    function loadJSON(item) {
      if ("string" !== typeof item.content) return new Error("JSON Loader: Input item doesn't contain string content");
      try {
        var result = JSON.parse(item.content);
        return result;
      } catch (e) {
        return new Error("JSON Loader: Parse json [" + item.id + "] failed : " + e);
      }
    }
    function loadImage(item) {
      var loadByDeserializedAsset = item._owner instanceof cc.Asset;
      if (loadByDeserializedAsset) return null;
      var image = item.content;
      if (cc.sys.platform !== cc.sys.FB_PLAYABLE_ADS && !(image instanceof Image)) return new Error("Image Loader: Input item doesn't contain Image content");
      var tex = item.texture || new Texture2D();
      tex._uuid = item.uuid;
      tex.url = item.url;
      tex._setRawAsset(item.rawUrl, false);
      tex._nativeAsset = image;
      return tex;
    }
    function loadAudioAsAsset(item, callback) {
      var loadByDeserializedAsset = item._owner instanceof cc.Asset;
      if (loadByDeserializedAsset) return null;
      var audioClip = new cc.AudioClip();
      audioClip._setRawAsset(item.rawUrl, false);
      audioClip._nativeAsset = item.content;
      audioClip.url = item.url;
      return audioClip;
    }
    function loadPlist(item) {
      if ("string" !== typeof item.content) return new Error("Plist Loader: Input item doesn't contain string content");
      var result = plistParser.parse(item.content);
      return result || new Error("Plist Loader: Parse [" + item.id + "] failed");
    }
    function loadBinary(item) {
      return item.load ? item.load(item.content) : null;
    }
    var PVR_HEADER_LENGTH = 13;
    var PVR_MAGIC = 55727696;
    var PVR_HEADER_MAGIC = 0;
    var PVR_HEADER_FORMAT = 2;
    var PVR_HEADER_HEIGHT = 6;
    var PVR_HEADER_WIDTH = 7;
    var PVR_HEADER_MIPMAPCOUNT = 11;
    var PVR_HEADER_METADATA = 12;
    function loadPVRTex(item) {
      var buffer = item.content instanceof ArrayBuffer ? item.content : item.content.buffer;
      var header = new Int32Array(buffer, 0, PVR_HEADER_LENGTH);
      if (header[PVR_HEADER_MAGIC] != PVR_MAGIC) return new Error("Invalid magic number in PVR header");
      var width = header[PVR_HEADER_WIDTH];
      var height = header[PVR_HEADER_HEIGHT];
      var dataOffset = header[PVR_HEADER_METADATA] + 52;
      var pvrtcData = new Uint8Array(buffer, dataOffset);
      var pvrAsset = {
        _data: pvrtcData,
        _compressed: true,
        width: width,
        height: height
      };
      return pvrAsset;
    }
    var ETC_PKM_HEADER_SIZE = 16;
    var ETC_PKM_FORMAT_OFFSET = 6;
    var ETC_PKM_ENCODED_WIDTH_OFFSET = 8;
    var ETC_PKM_ENCODED_HEIGHT_OFFSET = 10;
    var ETC_PKM_WIDTH_OFFSET = 12;
    var ETC_PKM_HEIGHT_OFFSET = 14;
    var ETC1_RGB_NO_MIPMAPS = 0;
    var ETC2_RGB_NO_MIPMAPS = 1;
    var ETC2_RGBA_NO_MIPMAPS = 3;
    function readBEUint16(header, offset) {
      return header[offset] << 8 | header[offset + 1];
    }
    function loadPKMTex(item) {
      var buffer = item.content instanceof ArrayBuffer ? item.content : item.content.buffer;
      var header = new Uint8Array(buffer);
      var format = readBEUint16(header, ETC_PKM_FORMAT_OFFSET);
      if (format !== ETC1_RGB_NO_MIPMAPS && format !== ETC2_RGB_NO_MIPMAPS && format !== ETC2_RGBA_NO_MIPMAPS) return new Error("Invalid magic number in ETC header");
      var width = readBEUint16(header, ETC_PKM_WIDTH_OFFSET);
      var height = readBEUint16(header, ETC_PKM_HEIGHT_OFFSET);
      var encodedWidth = readBEUint16(header, ETC_PKM_ENCODED_WIDTH_OFFSET);
      var encodedHeight = readBEUint16(header, ETC_PKM_ENCODED_HEIGHT_OFFSET);
      var etcData = new Uint8Array(buffer, ETC_PKM_HEADER_SIZE);
      var etcAsset = {
        _data: etcData,
        _compressed: true,
        width: width,
        height: height
      };
      return etcAsset;
    }
    var defaultMap = {
      png: loadImage,
      jpg: loadImage,
      bmp: loadImage,
      jpeg: loadImage,
      gif: loadImage,
      ico: loadImage,
      tiff: loadImage,
      webp: loadImage,
      image: loadImage,
      pvr: loadPVRTex,
      pkm: loadPKMTex,
      mp3: loadAudioAsAsset,
      ogg: loadAudioAsAsset,
      wav: loadAudioAsAsset,
      m4a: loadAudioAsAsset,
      json: loadJSON,
      ExportJson: loadJSON,
      plist: loadPlist,
      uuid: loadUuid,
      prefab: loadUuid,
      fire: loadUuid,
      scene: loadUuid,
      binary: loadBinary,
      dbbin: loadBinary,
      bin: loadBinary,
      font: fontLoader.loadFont,
      eot: fontLoader.loadFont,
      ttf: fontLoader.loadFont,
      woff: fontLoader.loadFont,
      svg: fontLoader.loadFont,
      ttc: fontLoader.loadFont,
      default: loadNothing
    };
    var ID = "Loader";
    var Loader = function Loader(extMap) {
      this.id = ID;
      this.async = true;
      this.pipeline = null;
      this.extMap = js.mixin(extMap, defaultMap);
    };
    Loader.ID = ID;
    Loader.prototype.addHandlers = function(extMap) {
      this.extMap = js.mixin(this.extMap, extMap);
    };
    Loader.prototype.handle = function(item, callback) {
      var loadFunc = this.extMap[item.type] || this.extMap["default"];
      return loadFunc.call(this, item, callback);
    };
    Pipeline.Loader = module.exports = Loader;
  }), {
    "../assets/CCTexture2D": 74,
    "../platform/CCSAXParser": 206,
    "../platform/js": 219,
    "./font-loader": 153,
    "./pipeline": 159,
    "./uuid-loader": 165
  } ],
  156: [ (function(require, module, exports) {
    "use strict";
    var CallbacksInvoker = require("../platform/callbacks-invoker");
    require("../utils/CCPath");
    var js = require("../platform/js");
    var _qid = 0 | 998 * Math.random();
    var _queues = js.createMap(true);
    var _pool = [];
    var _POOL_MAX_LENGTH = 10;
    var ItemState = {
      WORKING: 1,
      COMPLETE: 2,
      ERROR: 3
    };
    var _queueDeps = js.createMap(true);
    function isIdValid(id) {
      var realId = id.url || id;
      return "string" === typeof realId;
    }
    function _parseUrlParam(url) {
      if (!url) return;
      var split = url.split("?");
      if (!split || !split[0] || !split[1]) return;
      var urlParam = {};
      var queries = split[1].split("&");
      queries.forEach((function(item) {
        var itemSplit = item.split("=");
        urlParam[itemSplit[0]] = itemSplit[1];
      }));
      return urlParam;
    }
    function createItem(id, queueId) {
      var url = "object" === typeof id ? id.url : id;
      var result = {
        queueId: queueId,
        id: url,
        url: url,
        rawUrl: void 0,
        urlParam: _parseUrlParam(url),
        type: "",
        error: null,
        content: null,
        complete: false,
        states: {},
        deps: null
      };
      if ("object" === typeof id) {
        js.mixin(result, id);
        if (id.skips) for (var i = 0; i < id.skips.length; i++) {
          var skip = id.skips[i];
          result.states[skip] = ItemState.COMPLETE;
        }
      }
      result.rawUrl = result.url;
      url && !result.type && (result.type = cc.path.extname(url).toLowerCase().substr(1));
      return result;
    }
    var checkedIds = [];
    function checkCircleReference(owner, item, recursiveCall) {
      if (!owner || !item) return false;
      var result = false;
      checkedIds.push(item.id);
      if (item.deps) {
        var i, deps = item.deps, subDep;
        for (i = 0; i < deps.length; i++) {
          subDep = deps[i];
          if (subDep.id === owner.id) {
            result = true;
            break;
          }
          if (checkedIds.indexOf(subDep.id) >= 0) continue;
          if (subDep.deps && checkCircleReference(owner, subDep, true)) {
            result = true;
            break;
          }
        }
      }
      recursiveCall || (checkedIds.length = 0);
      return result;
    }
    var LoadingItems = function LoadingItems(pipeline, urlList, onProgress, onComplete) {
      CallbacksInvoker.call(this);
      this._id = ++_qid;
      _queues[this._id] = this;
      this._pipeline = pipeline;
      this._errorUrls = js.createMap(true);
      this._appending = false;
      this._ownerQueue = null;
      this.onProgress = onProgress;
      this.onComplete = onComplete;
      this.map = js.createMap(true);
      this.completed = {};
      this.totalCount = 0;
      this.completedCount = 0;
      this._pipeline ? this.active = true : this.active = false;
      urlList && (urlList.length > 0 ? this.append(urlList) : this.allComplete());
    };
    LoadingItems.ItemState = new cc.Enum(ItemState);
    LoadingItems.create = function(pipeline, urlList, onProgress, onComplete) {
      if (void 0 === onProgress) {
        if ("function" === typeof urlList) {
          onComplete = urlList;
          urlList = onProgress = null;
        }
      } else if (void 0 === onComplete) if ("function" === typeof urlList) {
        onComplete = onProgress;
        onProgress = urlList;
        urlList = null;
      } else {
        onComplete = onProgress;
        onProgress = null;
      }
      var queue = _pool.pop();
      if (queue) {
        queue._pipeline = pipeline;
        queue.onProgress = onProgress;
        queue.onComplete = onComplete;
        _queues[queue._id] = queue;
        queue._pipeline && (queue.active = true);
        urlList && queue.append(urlList);
      } else queue = new LoadingItems(pipeline, urlList, onProgress, onComplete);
      return queue;
    };
    LoadingItems.getQueue = function(item) {
      return item.queueId ? _queues[item.queueId] : null;
    };
    LoadingItems.itemComplete = function(item) {
      var queue = _queues[item.queueId];
      queue && queue.itemComplete(item.id);
    };
    LoadingItems.initQueueDeps = function(queue) {
      var dep = _queueDeps[queue._id];
      if (dep) {
        dep.completed.length = 0;
        dep.deps.length = 0;
      } else dep = _queueDeps[queue._id] = {
        completed: [],
        deps: []
      };
    };
    LoadingItems.registerQueueDep = function(owner, depId) {
      var queueId = owner.queueId || owner;
      if (!queueId) return false;
      var queueDepList = _queueDeps[queueId];
      if (queueDepList) -1 === queueDepList.deps.indexOf(depId) && queueDepList.deps.push(depId); else if (owner.id) for (var id in _queueDeps) {
        var queue = _queueDeps[id];
        -1 !== queue.deps.indexOf(owner.id) && -1 === queue.deps.indexOf(depId) && queue.deps.push(depId);
      }
    };
    LoadingItems.finishDep = function(depId) {
      for (var id in _queueDeps) {
        var queue = _queueDeps[id];
        -1 !== queue.deps.indexOf(depId) && -1 === queue.completed.indexOf(depId) && queue.completed.push(depId);
      }
    };
    var proto = LoadingItems.prototype;
    js.mixin(proto, CallbacksInvoker.prototype);
    proto.append = function(urlList, owner) {
      if (!this.active) return [];
      owner && !owner.deps && (owner.deps = []);
      this._appending = true;
      var accepted = [], i, url, item;
      for (i = 0; i < urlList.length; ++i) {
        url = urlList[i];
        if (url.queueId && !this.map[url.id]) {
          this.map[url.id] = url;
          owner && owner.deps.push(url);
          if (url.complete || checkCircleReference(owner, url)) {
            this.totalCount++;
            this.itemComplete(url.id);
            continue;
          }
          var self = this;
          var queue = _queues[url.queueId];
          if (queue) {
            this.totalCount++;
            LoadingItems.registerQueueDep(owner || this._id, url.id);
            queue.addListener(url.id, (function(item) {
              self.itemComplete(item.id);
            }));
          }
          continue;
        }
        if (isIdValid(url)) {
          item = createItem(url, this._id);
          var key = item.id;
          if (!this.map[key]) {
            this.map[key] = item;
            this.totalCount++;
            owner && owner.deps.push(item);
            LoadingItems.registerQueueDep(owner || this._id, key);
            accepted.push(item);
          }
        }
      }
      this._appending = false;
      this.completedCount === this.totalCount ? this.allComplete() : this._pipeline.flowIn(accepted);
      return accepted;
    };
    proto._childOnProgress = function(item) {
      if (this.onProgress) {
        var dep = _queueDeps[this._id];
        this.onProgress(dep ? dep.completed.length : this.completedCount, dep ? dep.deps.length : this.totalCount, item);
      }
    };
    proto.allComplete = function() {
      var errors = js.isEmptyObject(this._errorUrls) ? null : this._errorUrls;
      this.onComplete && this.onComplete(errors, this);
    };
    proto.isCompleted = function() {
      return this.completedCount >= this.totalCount;
    };
    proto.isItemCompleted = function(id) {
      return !!this.completed[id];
    };
    proto.exists = function(id) {
      return !!this.map[id];
    };
    proto.getContent = function(id) {
      var item = this.map[id];
      var ret = null;
      item && (item.content ? ret = item.content : item.alias && (ret = item.alias.content));
      return ret;
    };
    proto.getError = function(id) {
      var item = this.map[id];
      var ret = null;
      item && (item.error ? ret = item.error : item.alias && (ret = item.alias.error));
      return ret;
    };
    proto.addListener = CallbacksInvoker.prototype.on;
    proto.hasListener = CallbacksInvoker.prototype.hasEventListener;
    proto.removeListener = CallbacksInvoker.prototype.off;
    proto.removeAllListeners = CallbacksInvoker.prototype.removeAll;
    proto.removeItem = function(url) {
      var item = this.map[url];
      if (!item) return;
      if (!this.completed[item.alias || url]) return;
      delete this.completed[url];
      delete this.map[url];
      if (item.alias) {
        delete this.completed[item.alias.id];
        delete this.map[item.alias.id];
      }
      this.completedCount--;
      this.totalCount--;
    };
    proto.itemComplete = function(id) {
      var item = this.map[id];
      if (!item) return;
      var errorListId = id in this._errorUrls;
      item.error instanceof Error || js.isString(item.error) ? this._errorUrls[id] = item.error : item.error ? js.mixin(this._errorUrls, item.error) : !item.error && errorListId && delete this._errorUrls[id];
      this.completed[id] = item;
      this.completedCount++;
      LoadingItems.finishDep(item.id);
      if (this.onProgress) {
        var dep = _queueDeps[this._id];
        this.onProgress(dep ? dep.completed.length : this.completedCount, dep ? dep.deps.length : this.totalCount, item);
      }
      this.emit(id, item);
      this.removeAll(id);
      !this._appending && this.completedCount >= this.totalCount && this.allComplete();
    };
    proto.destroy = function() {
      this.active = false;
      this._appending = false;
      this._pipeline = null;
      this._ownerQueue = null;
      js.clear(this._errorUrls);
      this.onProgress = null;
      this.onComplete = null;
      this.map = js.createMap(true);
      this.completed = {};
      this.totalCount = 0;
      this.completedCount = 0;
      CallbacksInvoker.call(this);
      if (_queueDeps[this._id]) {
        _queueDeps[this._id].completed.length = 0;
        _queueDeps[this._id].deps.length = 0;
      }
      delete _queues[this._id];
      delete _queueDeps[this._id];
      -1 === _pool.indexOf(this) && _pool.length < _POOL_MAX_LENGTH && _pool.push(this);
    };
    cc.LoadingItems = module.exports = LoadingItems;
  }), {
    "../platform/callbacks-invoker": 212,
    "../platform/js": 219,
    "../utils/CCPath": 288
  } ],
  157: [ (function(require, module, exports) {
    "use strict";
    var Pipeline = require("./pipeline");
    var ID = "MD5Pipe";
    var UuidRegex = /.*[/\\][0-9a-fA-F]{2}[/\\]([0-9a-fA-F-]{8,})/;
    var MD5Pipe = function MD5Pipe(md5AssetsMap, md5NativeAssetsMap, libraryBase) {
      this.id = ID;
      this.async = false;
      this.pipeline = null;
      this.md5AssetsMap = md5AssetsMap;
      this.md5NativeAssetsMap = md5NativeAssetsMap;
      this.libraryBase = libraryBase;
    };
    MD5Pipe.ID = ID;
    MD5Pipe.prototype.handle = function(item) {
      item.url = this.transformURL(item.url);
      return null;
    };
    MD5Pipe.prototype.transformURL = function(url) {
      var isNativeAsset = !url.startsWith(this.libraryBase);
      var map = isNativeAsset ? this.md5NativeAssetsMap : this.md5AssetsMap;
      url = url.replace(UuidRegex, (function(match, uuid) {
        var hashValue = map[uuid];
        return hashValue ? match + "." + hashValue : match;
      }));
      return url;
    };
    Pipeline.MD5Pipe = module.exports = MD5Pipe;
  }), {
    "./pipeline": 159
  } ],
  158: [ (function(require, module, exports) {
    "use strict";
    var Unpackers = require("./unpackers");
    var pushToMap = require("../utils/misc").pushToMap;
    var PackState = {
      Invalid: 0,
      Removed: 1,
      Downloading: 2,
      Loaded: 3
    };
    function UnpackerData() {
      this.unpacker = null;
      this.state = PackState.Invalid;
      this.duration = 0;
    }
    var uuidToPack = {};
    var packIndices = {};
    var globalUnpackers = {};
    var toBeChecked = [];
    var timer = null;
    var checkPeriod = 5e3;
    function error(uuid, packUuid) {
      return new Error("Can not retrieve " + uuid + " from packer " + packUuid);
    }
    module.exports = {
      msToRelease: 12e4,
      initPacks: function initPacks(packs) {
        packIndices = packs;
        uuidToPack = {};
        for (var packUuid in packs) {
          var uuids = packs[packUuid];
          for (var i = 0; i < uuids.length; i++) {
            var uuid = uuids[i];
            var pushFront = 1 === uuids.length;
            pushToMap(uuidToPack, uuid, packUuid, pushFront);
          }
        }
      },
      _loadNewPack: function _loadNewPack(uuid, packUuid, callback) {
        var self = this;
        var packUrl = cc.AssetLibrary.getLibUrlNoExt(packUuid) + ".json";
        cc.loader.load({
          url: packUrl,
          ignoreMaxConcurrency: true
        }, (function(err, packJson) {
          if (err) {
            cc.errorID(4916, uuid);
            return callback(err);
          }
          globalUnpackers[packUuid].url = packUrl;
          var res = self._doLoadNewPack(uuid, packUuid, packJson);
          res ? callback(null, res) : callback(error(uuid, packUuid));
        }));
      },
      _doPreload: function _doPreload(packUuid, packJson) {
        var unpackerData = globalUnpackers[packUuid];
        if (!unpackerData) {
          unpackerData = globalUnpackers[packUuid] = new UnpackerData();
          unpackerData.state = PackState.Downloading;
        }
        if (unpackerData.state !== PackState.Loaded) {
          unpackerData.unpacker = new Unpackers.JsonUnpacker();
          unpackerData.unpacker.load(packIndices[packUuid], packJson);
          unpackerData.state = PackState.Loaded;
        }
      },
      _doLoadNewPack: function _doLoadNewPack(uuid, packUuid, packedJson) {
        var unpackerData = globalUnpackers[packUuid];
        if (unpackerData.state !== PackState.Loaded) {
          "string" === typeof packedJson && (packedJson = JSON.parse(packedJson));
          Array.isArray(packedJson) ? unpackerData.unpacker = new Unpackers.JsonUnpacker() : packedJson.type === Unpackers.TextureUnpacker.ID && (unpackerData.unpacker = new Unpacker