/**
 * 事件类型
 */
export enum EventType {
    //通用
    ResLoadComplete,

    //角色系统
    Fall,
}

class EventManager {

    onEvent(type: EventType, callBack: Function, target: any) {
        cc.systemEvent.on(type.toString(), callBack, target);
    }

    sendEvent(type: EventType, date?: any) {
        cc.systemEvent.emit(type.toString(), date);
    }

    /**
     * 删除指定目标的所有事件监听
     */
    targetOff(tarfet: any) {
        cc.systemEvent.targetOff(tarfet);
    }

}

let eventMgr: EventManager = new EventManager();
export { eventMgr };