const { ccclass, property } = cc._decorator;

@ccclass
export default class FrameAnimation extends cc.Component {

    @property({
        displayName: "播放速度",
        tooltip: "多少秒播放一帧"
    })
    private playSpeed: number = 0.1;

    @property(cc.SpriteAtlas)
    private spriteAtlas: cc.SpriteAtlas = null;

    private sprite: cc.Sprite = null;
    private isPlay: boolean = false;
    /**
     * 帧动画接下来播放哪一帧
     */
    private nextIndex: number = 0;
    /**
     * 当前播放时间
     */
    private timeSum = 0;
    /**
     * 是否循环播放
     */
    private isLoop: boolean = false;
    private spriteFrames: cc.SpriteFrame[] = null;

    onLoad() {
        this.sprite = this.node.getComponent(cc.Sprite);

        if (this.spriteAtlas)
            this.spriteFrames = this.spriteAtlas.getSpriteFrames();
    }

    start() {
    }

    isPlayer(): boolean {
        return this.isPlay;
    }

    /**
     * 设置播放速度
     * @param t 多少秒一帧
     */
    setSpeed(t: number) {
        this.playSpeed = t;
    }

    setSpriteAtlas(atlas: cc.SpriteAtlas) {
        this.spriteAtlas = atlas;
        this.spriteFrames = this.spriteAtlas.getSpriteFrames();
    }

    /**
     * 播放帧动画
     * @param isLoop 是否循环播放
     */
    play(isLoop: boolean = false) {
        this.isLoop = isLoop;

        this.setSpriteFrame(this.spriteFrames[this.nextIndex++]);
        this.isPlay = true;
    }

    /**
     * 停止播放
     */
    stop() {
        this.isPlay = false;
        this.nextIndex = 0;
        this.timeSum = 0;
    }

    /**
     * 暂停播放
     */
    puase() {
        this.isPlay = false;
    }

    /**
     * 继续播放
     */
    continue() {
        this.isPlay = true;
    }

    setSpriteFrame(img: cc.SpriteFrame) {
        this.sprite.spriteFrame = img;
    }

    update(dt) {
        if (this.isPlay) {
            this.timeSum += dt;
            if (this.timeSum >= this.playSpeed) {
                this.sprite.spriteFrame = this.spriteFrames[this.nextIndex++];
                this.timeSum = 0;

                if (this.nextIndex >= this.spriteFrames.length) { //一轮播放完毕
                    if (this.isLoop) //要循环播放
                        this.nextIndex = 0;
                    else {
                        this.isPlay = false;
                        this.nextIndex = 0;
                        this.timeSum = 0;
                    }
                }
            }
        }
    }
}
