import PlayerState from "./playerState";
import Player from "./player";

export class ClimbState extends PlayerState {

    moveBut(dir: number) {
        //爬墙时是按着墙方向的键的
    }

    releaseMoveBut() {
        this.exit();
        this.player.setState(PlayerState.fallState);
        this.player.getState().enter();
    }

    jumpBut() {
        this.exit();
        if (this.player.getClickJumpButCount() === 2)
            this.player.setState(PlayerState.doubleJumpState);
        else
            this.player.setState(PlayerState.jumpState);

        this.player.getState().enter();
    }

    land() {
        this.exit();
        this.player.setState(PlayerState.idleState);
        this.player.getState().enter();
    }

    downSpeed() {

    }

    upSpeed() {
        this.exit();
        this.player.setState(PlayerState.upState);
        this.player.getState().enter();
    }

    enter() {
        this.player.getAnim().climbWall();
        this.player.getRigid().linearVelocity.y = -this.player.climbWallSpeed;
    }

    exit() {
        this.player.getAnim().stop();
        this.player.getRigid().linearVelocity.y = 0;
    }
}