import PlayerState from "./playerState";

export class DoubleJumpState extends PlayerState {

    moveBut(dir: number) {
        this.player.move(dir, this.player.speedInAir);
    }

    releaseMoveBut() {
        this.player.getRigid().linearVelocity.x = 0;
    }

    jumpBut() {

    }

    land() {

    }

    downSpeed() {
        this.exit();
        this.player.setState(PlayerState.fallState);
        this.player.getState().enter();
    }

    upSpeed() {
        if (!this.player.getAnim().isPlay()) {
            //二段跳动画播完了
            this.exit();
            this.player.setState(PlayerState.upState);
            this.player.getState().enter();
        }
    }

    enter() {
        this.player.getAnim().doubleJump();
        this.player.addForce(cc.v2(0, this.player.jumpForce));
    }

    exit() {
        this.player.getAnim().stop();
    }
}