import FrameAnimation from "../common/frameAnim";

const { ccclass, property } = cc._decorator;

@ccclass
export default class PlayerAnim extends cc.Component {

    @property(FrameAnimation)
    private frameAnim: FrameAnimation = null;

    private doubleJumpAtlas: cc.SpriteAtlas = null;
    private hitAtlas: cc.SpriteAtlas = null;
    private idleAtlas: cc.SpriteAtlas = null;
    private runAtlas: cc.SpriteAtlas = null;
    private walkWallAtlas: cc.SpriteAtlas = null;
    private fallImg: cc.SpriteFrame = null;
    private jumpImg: cc.SpriteFrame = null;

    /**
     * 加载动画资源
     */
    init() {
        this.doubleJumpAtlas = cc.loader.getRes("characters/maskDude/doubleJump");
        this.hitAtlas = cc.loader.getRes("characters/maskDude/hit");
        this.idleAtlas = cc.loader.getRes("characters/maskDude/idle");
        this.runAtlas = cc.loader.getRes("characters/maskDude/run");
        this.walkWallAtlas = cc.loader.getRes("characters/maskDude/wallJump");
        this.fallImg = cc.loader.getRes("characters/maskDude/fall");
        this.jumpImg = cc.loader.getRes("characters/maskDude/jump");
    }

    /**
     * 播放行走动画
     * @param dir 1为向右
     */
    run(dir: number) {
        this.node.scaleX = dir;
        this.frameAnim.setSpriteAtlas(this.runAtlas);
        this.frameAnim.play(true);
    }

    jump() {
        this.frameAnim.setSpriteFrame(this.jumpImg);
    }

    doubleJump() {
        this.frameAnim.setSpriteAtlas(this.doubleJumpAtlas);
        this.frameAnim.play();
    }

    fall() {
        this.frameAnim.setSpriteFrame(this.fallImg);
    }

    idle() {
        this.frameAnim.setSpriteAtlas(this.idleAtlas);
        this.frameAnim.play(true);
    }

    climbWall() {
        this.frameAnim.setSpriteAtlas(this.walkWallAtlas);
        this.frameAnim.play(true);
    }

    up() {
        this.frameAnim.setSpriteFrame(this.jumpImg);
    }

    dead() {

    }

    /**
     * 是否在播放动画
     */
    isPlay(): boolean {
        return this.frameAnim.isPlayer();
    }

    /**
     * 停止播放动画
     */
    stop() {
        this.frameAnim.stop();
    }
}
