import Player from "./player";
import { ClimbState } from "./climbState";
import { DeadState } from "./deadState";
import { DoubleJumpState } from "./doubleJump";
import { FallState } from "./fallState";
import { IdleState } from "./idleState";
import { JumpState } from "./jumpState";
import { RunState } from "./runState";
import { UpState } from "./upState";

/**
 * 角色状态抽象类
 */
export default abstract class PlayerState {

    static climbState: ClimbState = new ClimbState();
    static deadState: DeadState = new DeadState();
    static doubleJumpState: DoubleJumpState = new DoubleJumpState();
    static fallState: FallState = new FallState();
    static idleState: IdleState = new IdleState();
    static jumpState: JumpState = new JumpState();
    static runState: RunState = new RunState();
    static upState: UpState = new UpState();

    protected player: Player;

    setPlayer(player: Player) {
        this.player = player;
    }

    /**
     * 移动键被点击
     * @param dir 1为右
     */
    abstract moveBut(dir: number);

    /**
     * 移动键被释放
     */
    abstract releaseMoveBut();

    /**
     * 跳跃键被点击
     */
    abstract jumpBut();

    /**
     * 落地
     */
    abstract land();

    /**
     * 速度向下
     */
    abstract downSpeed();

    /**
     * 速度向上
     */
    abstract upSpeed();

    /**
     * 死亡
     */
    dead() {
        this.player.setState(PlayerState.deadState);
    };

    /**
     * 进入该状态
     */
    abstract enter()

    /**
     * 退出该状态
     */
    abstract exit()
}