import {
    _decorator, Component, systemEvent, SystemEvent, EventMouse, AnimationComponent, Node,
    Vec2, Vec3, SystemEventType, Touch, ColliderComponent, RigidBodyComponent, ICollisionEvent
} from "cc";
const { ccclass, property } = _decorator;

import{ColCtrl} from "./ColCtrl"
import { GameRoot } from "./GameRoot";

@ccclass("playerController")

export class playerController extends Component {

    @property({ type: Node })
    public playerPos: Node = null;

    @property({ type: Node })
    public rotaTarget: Node = null;

    @property({ type: false })
    public isMoving = false;

    @property({ type: Vec2 })
    public startPos: Vec2;

    @property
    public touchState = 1;

    @property({ type: Vec2 })
    public endPos: Vec2;

    @property
    public moveSpeed = 100;

    @property
    public RotaValue = 0;

    @property
    public alreadyStay: boolean = false;

    //@property(ColCtrl)
  //  public colctrl:ColCtrl=null;

    // private game:GameRoot;

    start() {
         console.log("开始时小球的位置为：" + this.playerPos.position);

        let collider = this.getComponent(ColliderComponent);
        if (collider) {
            collider.on('onCollisionEnter', this.onCollision, this);
            collider.on('onCollisionStay', this.onCollision, this);
            collider.on('onCollisionExit', this.onCollision, this);
        }

        // this.colctrl.player=this;

       
      
    }

    onLoad() {
        this.touchState = 0;
        this.startPos = cc.v2(0, 0);
        this.endPos = cc.v2(0, 0);
        this.isMoving = false;

        systemEvent.on(SystemEventType.TOUCH_MOVE, this.TouchController, this);
        //方法一
        systemEvent.on(SystemEventType.TOUCH_END, function () {
            //当touch结束时，马上还原为初始值
            this.RotaValue = 0;
        }, this);

        //方法二
        // systemEvent.on(SystemEventType.TOUCH_END, this.TouchEnd, this);
        //方法三lamda表达式

        // if (this.playerPos.position.y == 1)
        //     return
    }

    update() {
       //if (this.playerPos.position.y <= 1.15) {
            //this.playerPos.getComponent(RigidBodyComponent).linearFactor.y = 1;
            console.log("当前小球的位置为：" + this.playerPos.position);

            let Rig =this.getComponent(RigidBodyComponent);
            console.log("当前小球的刚体的LinearDamping为：" + Rig.linearDamping);
            console.log("当前小球的刚体的LinearFactor为：" + Rig.linearFactor.x+"  "+Rig.linearFactor.y+" "+Rig.linearFactor.z);

            //控制小球来回运动
            let elasticForce=2;
            //定时回调
            Rig.applyImpulse(new Vec3(0,1,0));
            
        //}
    }


    TouchController(event) {
        // console.log("手指移动了");
        //获取当前触碰点的世界坐标
        let currentPos: Vec2 = event.getLocation();
        // console.log("当前触碰点的世界坐标是：" + currentPos);
        //获取当前触碰点的UI坐标
        let currTouchPos: Vec2 = event.getUILocation();
        // console.log("当前触碰点的UI坐标是：" + currTouchPos);

        //获取旋转的方向
        let pos: Vec2 = event.getUIDelta();
        // console.log("获取触点距离上一次事件移动的距离对象：" + pos);
        //每次touch都加一个角度
        if (pos.x < 0)//向左
        {
            this.RotaValue -= 10;
        }
        else //向右
        {
            this.RotaValue += 10;
        }

        //旋转目标物体
        this.rotaTarget.eulerAngles = new Vec3(0, this.RotaValue, 0);
        //console.log("当前目标物体的欧拉角：" + this.rotaTarget.eulerAngles);
    }

    TouchEnd(event) {
        this.RotaValue = 0;
    }

    onCollision(event: ICollisionEvent) {
        if (event.type == 'onCollisionStay') {
            if (!this.alreadyStay) {
                this.alreadyStay = true;
               // console.log("碰撞中自己的碰撞器：" + event.selfCollider.node.name + " *** " + "碰撞类型：" + event.type + " *** " + "碰撞中另一个碰撞器：" + event.otherCollider.node.name);
            } else {
                return;
            }
        } else if (event.type == 'onCollisionExit') {
            this.alreadyStay = false;
        }

    }

    /**
     * 游戏结束
     */
    public GameOver() {
        console.log("游戏结束");
    }
}
