import { _decorator, Component, Node, Label, Color, Vec2, UITransform } from 'cc';
import * as cc from 'cc';
const { ccclass, property, requireComponent, executeInEditMode } = _decorator;

@ccclass('LabelShadowComponent')
@requireComponent(Label)
@executeInEditMode
export class LabelShadow extends Component {

    @property({ type: Color })
    private _color: Color = cc.color(75, 75, 75, 255);

    @property({ type: Color })
    set color(value: Color) {
        this._color.set(value);
        this._labelComp.material.setProperty('shadowColor', this._color);
    }
    get color() {return this._color;}

    @property({ type: Vec2 })
    private _offset: Vec2 = cc.v2(4, -4);

    @property({ type: Vec2 })
    set offset(value: Vec2) {
        this._offset.set(value);
        this._labelComp.material.setProperty('shadowOffset', this._offset);
    }
    get offset() {return this._offset;}

    private _labelComp: Label;

    start () {
        this._labelComp = this.getComponent(Label);

        this._labelComp.material.setProperty('shadowColor', this._color);
        this._labelComp.material.setProperty('shadowOffset', this._offset);
    }
}
