// Learn cc.Class:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/class.html
//  - [English] http://docs.cocos2d-x.org/creator/manual/en/scripting/class.html
// Learn Attribute:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/reference/attributes.html
//  - [English] http://docs.cocos2d-x.org/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/life-cycle-callbacks.html
//  - [English] https://www.cocos2d-x.org/docs/creator/manual/en/scripting/life-cycle-callbacks.html

cc.Class({
    extends: cc.Component,

    properties: {
        // foo: {
        //     // ATTRIBUTES:
        //     default: null,        // The default value will be used only when the component attaching
        //                           // to a node for the first time
        //     type: cc.SpriteFrame, // optional, default is typeof default
        //     serializable: true,   // optional, default is true
        // },
        // bar: {
        //     get () {
        //         return this._bar;
        //     },
        //     set (value) {
        //         this._bar = value;
        //     }
        // },
        root: {
            default: null,
            type: cc.Node
        }
    },

    // LIFE-CYCLE CALLBACKS:

    onLoad() {
        cc.game.addPersistRootNode(this.node)

        this.node.active = false
        this.node.runAction(cc.sequence(cc.delayTime(0), cc.callFunc(function () {
            this.node.active = false
        }.bind(this))))

        this.node.on(cc.Node.EventType.TOUCH_START, function (event, touch) {
            if (event.stopProgagation != undefined) {
                event.stopPropagation()
            }
        })

        this.node.on(cc.Node.EventType.TOUCH_MOVE, function (event, touch) {
            if (event.stopProgagation != undefined) {
                event.stopPropagation()
            }
        })

        this.node.on(cc.Node.EventType.TOUCH_END, function (event, touch) {
            if (event.stopProgagation != undefined) {
                event.stopPropagation()
            }
        })

        this.node.on(cc.Node.EventType.TOUCH_CANCEL, function (event, touch) {
            if (event.stopProgagation != undefined) {
                event.stopProgagation()
            }
        })

        this.timeoutCallback = null
    },

    start() {

    },

    show(time, timeoutCallback) {
        this.node.active = true
        this.node.runAction(cc.sequence(cc.delayTime(0), cc.callFunc(function () {
            this.node.active = true
        }.bind(this))))

        let animationComponent = this.root.getComponent(cc.Animation)
        animationComponent.play("loading")

        let t = 7
        if (time != null) {
            t = time
        }

        if (this.timeoutCallback != null) {
            this.unschedule(this.timeoutCallback)
            this.timeoutCallback = null
            this.close()
        }

        let self = this
        this.timeoutCallback = function (dt) {
            if (timeoutCallback != null) {
                timeoutCallback(dt)
            }
            this.timeoutCallback = null
            self.close()
        }

        this.scheduleOnce(this.timeoutCallback, t)
    },

    close() {
        this.node.active = false
        this.node.runAction(cc.sequence(cc.delayTime(0), cc.callFunc(function () {
            this.node.active = false
        }.bind(this))))
        let animationComponent = this.root.getComponent(cc.Animation)
        let animState = animationComponent.getAnimationState('loading')
        if (animState.isPlaying) {
            animationComponent.stop()
        }
        if (this.timeoutCallback != null) {
            this.unschedule(this.timeoutCallback)
            this.timeoutCallback = null
        }
    }

    // update (dt) {},
});
