// Learn cc.Class:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/class.html
//  - [English] http://docs.cocos2d-x.org/creator/manual/en/scripting/class.html
// Learn Attribute:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/reference/attributes.html
//  - [English] http://docs.cocos2d-x.org/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/life-cycle-callbacks.html
//  - [English] https://www.cocos2d-x.org/docs/creator/manual/en/scripting/life-cycle-callbacks.html
let App = require("App")

cc.Class({
    extends: cc.Component,

    properties: {
        // foo: {
        //     // ATTRIBUTES:
        //     default: null,        // The default value will be used only when the component attaching
        //                           // to a node for the first time
        //     type: cc.SpriteFrame, // optional, default is typeof default
        //     serializable: true,   // optional, default is true
        // },
        // bar: {
        //     get () {
        //         return this._bar;
        //     },
        //     set (value) {
        //         this._bar = value;
        //     }
        // },
        account: {
            default: null,
            type: cc.EditBox
        },
        password: {
            default: null,
            type: cc.EditBox
        },
        rememberPassword: {
            default: null,
            type: cc.Toggle
        },
        security: {
            default: null,
            type: cc.EditBox
        },
        bgSecurity: {
            default: null,
            type: cc.Sprite
        },
        getSecurityCode: {
            default: null,
            type: cc.Button
        }
    },

    // LIFE-CYCLE CALLBACKS:

    onLoad() {
        cc.debug.setDisplayStats(false)

        cc.view.setOrientation(cc.macro.ORIENTATION_LANDSCAPE)

        let localAccount = cc.sys.localStorage.getItem("account")
        let account = this.account.getComponent(cc.EditBox)
        if (localAccount != null) {
            account.string = localAccount
        }

        this.bgSecurity.node.active = false
    },

    start() {
        cc.find('Loading').getComponent("Loading").close()
    },

    tapGetSecurityCode(sender, customEventData) {

    },


    tapLogin(sender, customEventData) {
        let account = this.account.getComponent(cc.EditBox)
        let password = this.password.getComponent(cc.EditBox)
        
        cc.find('Loading').getComponent("Loading").show()
    },

    tapRegister(sender, customEventData) {
        cc.director.loadScene("RegisterScene")
    },

    checkRemberPassword(sender, customEventData) {

    },

    tapForgetPassword(sender, customEventData) {
        cc.director.loadScene("ResetPasswordScene")
    }

    // update (dt) {},
});
