/**
 * 声音管理
 * @author
 */
export default class SoundManager extends cc.Component {

    /**
     * 设置音乐是否静音 setter 
     */
    set soundMute(v) {
        this._soundMute = v;
        cc.audioEngine.setMusicVolume(v ? 0 :
            this._soundVol);
    }

    /** 获取音乐是否静音 getter */
    get soundMute() {
        return this._soundMute;
    }

    /** 
     * 设置音效是否静音 setter
     */
    set seMute(v) {
        this._seMute = v;
        cc.audioEngine.setEffectsVolume(v ? 0 :
            this._seVol);
    }

    /** 获取音效是否静音 getter */
    get seMute() {
        return this._seMute;
    }

    /** 
     * 设置音乐的音量 setter
     */
    set soundVol(v) {
        this._soundVol = v;

        if (this.soundMute) return;

        cc.audioEngine.setMusicVolume(v);
    }

    /** 获取包含静音判断的音乐的音量 */
    get soundVol() {
        return this.soundMute ? 0 : this._soundVol;
    }

    /** 
     * 设置音效的音量 setter 
     */
    set seVol(v) {
        this._seVol = v;

        if (this.seMute) return;

        cc.audioEngine.setEffectsVolume(v);
    }

    /** 获取包含静音判断的音效的音量 */
    get seVol() {
        return this.soundMute ? 0 : this._seVol;
    }


    /** 当前是否音乐静音 */
    private _soundMute = false;
    /** 当前是否音效静音 */
    private _seMute = false;
    /** 当前的音乐音量 */
    private _soundVol = 1;
    /** 当前的音效音量 */
    private _seVol = 1;

    // /** 缓存实现 */
    // private _cacheImp: CacheModelImp;
    /** 背景音乐迭代 */
    private _iMusic = -1;
    /** 背景音乐地址列表 */
    private _musicUrls: string[] = [];
    /** 当前播放背景音乐id */
    private _musicID = -1;
    /** 当前播放audio */
    private _musicAudio = null;
    /** 音效在加载超过一定时间后不播放 */
    private _playTimeout = 500;

    /** 停止播放所有音效 */
    stopSe() {
        cc.audioEngine.stopAllEffects();
    }

    /** 停止音乐播放 */
    stopSound() {
        cc.audioEngine.stopMusic();
        // this._musicAudio && this._musicAudio.stop();
    }

    /** 停止所有 */
    stopAll() {
        this.stopSe();
        this.stopSound();
    }

    private _url = '';

    /**
     * 播放背景音乐
     */
    music(url: string) {
        this._url = url;
        this._playCurMusic();
    }

    /**
     * 播放当前音乐
     */
    private _playCurMusic() {
        let url = this._url,
            audio: cc.AudioClip =
                cc.loader.getRes(url);

        if (!audio) {
            cc.loader.loadRes(url, cc.AudioClip, (err, res: cc.AudioClip) => {
                if (err) {
                    cc.error('load error');
                    this.scheduleOnce(
                        () => {
                            this._playCurMusic
                        }, 3
                    );

                    return;
                }

                cc.error('music loaded');
                this._playMusic(res);
            });
        } else {
            this._playMusic(audio);
        }
    }

    /**
     * 播放音乐
     * @param audio 
     */
    private _playMusic(audio: cc.AudioClip) {
        cc.audioEngine.stopMusic();
        this.unscheduleAllCallbacks();
        this._musicID = cc.audioEngine.playMusic(
            audio, false);
        cc.error('play', this._musicID);

    }

}