cc.Class({
    extends: cc.Component,

    properties: {
        label: {
            default: null,
            type: cc.Label
        },
        Sprite: { default:null, type: cc.Sprite},
        // defaults, set visually when attaching this script to the Canvas
        text: 'Hello, World!'
    },

    // use this for initialization
    onLoad: function ()
    {
        let root = this;
        this.label.string = this.text;

        //color warning
        this._anime_forever = cc.repeatForever( cc.sequence( [ cc.tintTo( 1.2, 111,111,111 ), cc.tintTo( 1.2, 255,255,255 ) ] ) );
        this.Sprite.node.runAction( this._anime_forever );


        cc.find( 'Canvas/btn.jsb' ).on( 'touchend', () =>
        {
            let node = root.Sprite.node;
            node.active = true;
            let callActive = function(){ node.opacity = 0; };
            let acts =
            [
                cc.callFunc( callActive ),
                cc.fadeIn( 0.3 )
            ];
            node.runAction( cc.sequence( acts ) );
        } );


        cc.find( 'Canvas/btn.mask' ).on( 'touchend', ()=>
        {
            root.CreatePrefab();
        } );


    },

    CreatePrefab: function()
    {

        cc.loader.loadRes( 'prefab', cc.Prefab, (error, prefab) =>
        {
            if( error ) { cc.error('[LoadRes] Error: ' + error ); return; }
            let node = cc.instantiate( prefab );

            cc.find( 'Canvas' ).addChild( node );

            node.x = 100; node.y = 100;
        } );
    }
});
