"use strict";
cc._RF.push(module, '280c3rsZJJKnZ9RqbALVwtK', 'HelloWorld');
// Script/HelloWorld.js

'use strict';

cc.Class({
    extends: cc.Component,

    properties: {
        label: {
            default: null,
            type: cc.Label
        },
        Sprite: { default: null, type: cc.Sprite },
        // defaults, set visually when attaching this script to the Canvas
        text: 'Hello, World!'
    },

    // use this for initialization
    onLoad: function onLoad() {
        var root = this;
        this.label.string = this.text;

        //color warning
        this._anime_forever = cc.repeatForever(cc.sequence([cc.tintTo(1.2, 111, 111, 111), cc.tintTo(1.2, 255, 255, 255)]));
        this.Sprite.node.runAction(this._anime_forever);

        cc.find('Canvas/btn.jsb').on('touchend', function () {
            var node = root.Sprite.node;
            node.active = true;
            var callActive = function callActive() {
                node.opacity = 0;
            };
            var acts = [cc.callFunc(callActive), cc.fadeIn(0.3)];
            node.runAction(cc.sequence(acts));
        });

        cc.find('Canvas/btn.mask').on('touchend', function () {
            root.CreatePrefab();
        });
    },

    CreatePrefab: function CreatePrefab() {

        cc.loader.loadRes('prefab', cc.Prefab, function (error, prefab) {
            if (error) {
                cc.error('[LoadRes] Error: ' + error);return;
            }
            var node = cc.instantiate(prefab);

            cc.find('Canvas').addChild(node);

            node.x = 100;node.y = 100;
        });
    }
});

cc._RF.pop();