const {ccclass, property} = cc._decorator;

@ccclass
export default class Helloworld extends cc.Component {

    @property(cc.Label)
    label: cc.Label = null;

    @property
    text: string = 'hello';
    @property(cc.Node)
    layoutNode:cc.Node=null;
    @property({
        type: cc.Prefab,
    })
    tmpPrefab: cc.Prefab = null;

    private _showDebug:boolean = false;

    onLoad(){
        cc.game.on(cc.game.EVENT_HIDE, ()=>{
            this.onHide();
        });
        cc.game.on(cc.game.EVENT_SHOW, ()=> {
            this.onShow();
        });
		cc.macro.CLEANUP_IMAGE_CACHE = false;
        cc.dynamicAtlasManager.enabled = true;
        cc.dynamicAtlasManager.maxFrameSize = 600;
    }

    start () {
        // init logic
        this.label.string = this.text;
        let sprites = this.layoutNode.getComponentsInChildren(cc.Sprite);
        cc.resources.loadDir("carArmet",cc.Texture2D, (error:Error,assets:cc.Asset[])=> {
            for(let i =0;i<assets.length;i++){
                let tex = cc.resources.get("carArmet/Armet-"+i);
                sprites[i].spriteFrame = new cc.SpriteFrame(<cc.Texture2D>tex);
            }
        })
    }

    onHide(){
     }
     /**
      * 游戏切换回前台
      */
     onShow(){

        this._showDebug = !this._showDebug;
        cc.dynamicAtlasManager.showDebug(this._showDebug);

     }
}
