/*
 * @Description: 
 * @Author: xxx
 * @Date: 2020-05-11 14:03:43
 * @LastEditor: xxx
 * @LastEditTime: 2020-07-24 17:57:45
 */ 

const { ccclass, property } = cc._decorator;

@ccclass
export default class Helloworld extends cc.Component {
    @property(cc.Label)
    label: cc.Label = null;

    @property
    text: string = "hello";

    _icons: cc.Node[] = [];

    start() {
        // init logic
        // this.label.string = this.text;

        cc.macro.CLEANUP_IMAGE_CACHE = true;

        this.node.on(cc.Node.EventType.TOUCH_END, this.onClick, this);
    }

    onClick() {
        this._icons.forEach((icon) => {
            icon.destroy();
            icon.removeFromParent();
        });
        this._icons = [];

        const count = 1;
        for (let i = 1; i <= count; i++) {
            cc.resources.load("icon_" + i, cc.SpriteFrame, (err, sf: cc.SpriteFrame) => {
                if (err) return;

                const node: cc.Node = new cc.Node();
                node.addComponent(cc.Sprite).spriteFrame = sf;

                this.node.addChild(node);
                this._icons.push(node);

                console.log("add icon success!");
            });
        }
    }
}
