//提供远程资源加载
(function () {
    var RemoteRes = {};

    var MD5 = require('md5');

    RemoteRes.setSpriteFrame = function (url, spriteOrFunc) {
        if (!url) {
            return;
        }

        if (typeof spriteOrFunc === 'undefined')
            return;

        if (!url.startsWith('http')) {
            url = C.CDN_ROOT + "resource/headicon/" + url + '.png';
        }

        var self = this;
        function _setSpriteFrame(spriteFrame, isSetTexture) {
            try {
                if (spriteOrFunc instanceof cc.SpriteFrame) {
                    spriteOrFunc.setTexture(spriteFrame);
                } else {
                    var sprite = null;
                    if (spriteOrFunc instanceof cc.Sprite) {
                        sprite = spriteOrFunc;
                    } else if (spriteOrFunc instanceof cc.Node) {
                        sprite = spriteOrFunc.getComponent(cc.Sprite);
                    }

                    if (sprite && cc.isValid(sprite)) {
                        if (isSetTexture) {
                            sprite.spriteFrame.setTexture(spriteFrame);
                        } else {
                            sprite.spriteFrame = spriteFrame;
                        }
                    }
                }
            } catch (error) {
                cc.warn(error);
            }
        }

        try {
            if (cc.sys.isBrowser) {
                this.loadBrowser(url, _setSpriteFrame);
            } else if (cc.sys.isNative) {
                this.loadNative(url, _setSpriteFrame);
            }
        } catch (error) {
            cc.error('Remote res load failed. ' + url);
            cc.error(error);
        }

    };

    RemoteRes.loadBrowser = function (url, callback) {
        if (url.endsWith(".gif") === false &&
            url.endsWith(".jpg") === false &&
            url.endsWith(".png") === false) {
            url += ".jpg";
        }
        //url = C.ROMOTE_URL + url;
        cc.loader.load(url, function (err, tex) {
            if (err) {
                cc.error(err);
            } else {
                var spriteFrame = new cc.SpriteFrame(tex);
                if (spriteFrame) {
                    callback(spriteFrame);
                }
            }
        });
    };

    RemoteRes.loadNative = function (url, callback) {
        var dirpath = jsb.fileUtils.getWritablePath() + 'img/';
        var filepath = dirpath + MD5(url) + '.png';

        function loadEnd() {
            cc.loader.load(filepath, function (err, tex) {
                if (err) {
                    cc.error(err);
                } else {
                    var spriteFrame = new cc.SpriteFrame(tex);
                    if (spriteFrame) {
                        spriteFrame.retain();
                        callback(spriteFrame);
                    }
                }
            });

        }

        if (jsb.fileUtils.isFileExist(filepath)) {
            cc.log('Remote is find' + filepath);
            loadEnd();
            return;
        }

        var saveFile = function (data) {
            if (data) {
                if (!jsb.fileUtils.isDirectoryExist(dirpath)) {
                    jsb.fileUtils.createDirectory(dirpath);
                }

                if (jsb.fileUtils.writeDataToFile(new Uint8Array(data), filepath)) {
                    cc.log('Remote write file succeed.');
                    loadEnd();
                } else {
                    cc.log('Remote write file failed.');
                }
            } else {
                cc.log('Remote download file failed.' + url);
            }
        };

        var xhr = new XMLHttpRequest();

        xhr.onreadystatechange = function () {
            cc.log("xhr.readyState  " + xhr.readyState);
            cc.log("xhr.status  " + xhr.status);
            if (xhr.readyState === 4) {
                if (xhr.status === 200) {
                    xhr.responseType = 'arraybuffer';
                    saveFile(xhr.response);
                } else {
                    saveFile(null);
                }
            }
        }.bind(this);
        xhr.open("GET", url, true);
        xhr.send();
    };

    module["exports"] = RemoteRes;
})();