// Learn cc.Class:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/class.html
//  - [English] http://docs.cocos2d-x.org/creator/manual/en/scripting/class.html
// Learn Attribute:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/reference/attributes.html
//  - [English] http://docs.cocos2d-x.org/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/life-cycle-callbacks.html
//  - [English] https://www.cocos2d-x.org/docs/creator/manual/en/scripting/life-cycle-callbacks.html

var eSpeed = {
    farBg: 100,
    nearBg: 500
}

var typePrefabsInGame = cc.Class({
    name:'typePrefabsInGame',
    properties:{
        pref_mapCoin: cc.Node
    }
})


var typeNodesParent = cc.Class({
    name:'typeNodesParent',
    properties:{
        nodeParentTiledMap: cc.Node,
        nodeParentCoin: cc.Node,
    }
});

var typeCarmers = cc.Class({
    name:'typeCarmers',
    properties:{
        cameraFar: cc.Camera,
        cameraNear: cc.Camera,
        cameraAvatar: cc.Camera
    }
});

var createTiledMap = function( name, next ) {
    console.log( name );
    cc.loader.loadRes(name, cc.TiledMapAsset, function (err, tmxAsset) {
        if (err) {
            console.log("加载错误" + err);
        } else {
            next( tmxAsset );
        }
    });
}

cc.Class({ 
    extends: cc.Component,

    properties: {
        nodesFarBg: [ cc.Node ],
        nodesNearBg: [ cc.Node ],
        
        avatar: require('avatar'),
        nodesParent: typeNodesParent,
        carmers: typeCarmers,
        prefabs: typePrefabsInGame 
    },

    onLoad () {
        this.init();
    },

    init () {
        this.initData();
        this.initUI();
        this.startGame();
    },

    initData () {
        this.cameraFar = this.carmers.cameraFar,
        this.cameraNear = this.carmers.cameraNear;
        this.cameraAvatar = this.carmers.cameraAvatar;
        this.nodesTiled = [];

        this.tiledSize = cc.size(640/480 * 1620, 640);

        this.curRolePathName = 'road1';
        this.curTiledIdx = 0;
    },

    initUI () {
        cc.find('prefabs-un-show', this.node ).active = false;
    },
    startGame () {
        this._isStart = true;

        // this.curTiledIdx = 0;
        // this.createMapStart( tiledNode => {
        //     this.nodesTiled[0] = tiledNode;
        //     tiledNode.parent = this.nodesParent.nodeParentTiledMap;
        //     tiledNode.x = 0 * this.tiledSize.width;
        // });

        // ++ this.curTiledIdx;
        // this.createMap(tiledNode => {
        //     this.nodesTiled[1] = tiledNode;
        //     tiledNode.parent = this.nodesParent.nodeParentTiledMap;
        //     tiledNode.x = 2 * this.tiledSize.width;
        // });

        // ++ this.curTiledIdx;
        // this.createMap(tiledNode => {
        //     this.nodesTiled[2] = tiledNode;
        //     tiledNode.parent = this.nodesParent.nodeParentTiledMap;
        //     tiledNode.x = 1 * this.tiledSize.width;
        // });
    },

    createMapStart( next ) {
        this.createMapWithName( 'mapAttack33' , next );
    },

    createMap( next ) {
        this.createMapWithName( 'mapPass' + this.curTiledIdx, next );
    },

    createMapWithName( name, next ){
        createTiledMap('map/' + this.curRolePathName + '/' + name, tmxAsset => {
            let node = new cc.Node();
            let map = node.addComponent( cc.TiledMap );
            map.tmxAsset = tmxAsset
            node.width = this.tiledSize.width;
            node.height = this.tiledSize.height;

            let temp = cc.instantiate( this.prefabs.pref_mapCoin );
            temp.parent = node;
            temp.x = Math.random() * 200;

            next && next( node );
        });
    },

    update ( dt ) {
        if( !this._isStart ){
            return;
        }
        this.updateFar( dt );
        this.updateNear( dt );
        this.updateAvatar( dt );
    },

    updateFar ( dt ) {
        this.cameraFar.node.x += dt * eSpeed.farBg;

        let end = this.nodesFarBg[1];
        if( end.x < this.cameraFar.node.x ){
            var first = this.nodesFarBg.shift();
            first.x += 2 * first.width;
            this.nodesFarBg.push( first );
        }
    },

    updateNear( dt ){
        // this.nodesParent.nodeParentTiledMap.children.forEach( node => {
        //     node.x -= dt * 500;
        // })
        // this.cameraNear.node.x += dt * eSpeed.nearBg;

        // let end = this.nodesNearBg[1];
        // if( end.x < this.cameraNear.node.x ){
        //     var first = this.nodesNearBg.shift();
        //     first.x += 2 * first.width;
        //     this.nodesNearBg.push( first );
        // }
    },

    updateAvatar( dt ){
        this.avatar.node.x += dt * eSpeed.nearBg;
        this.cameraAvatar.node.x += dt * eSpeed.nearBg;
    }
});
