(function outer(modules, cache, entry) {
  function newRequire(name, jumped) {
    var module = cache[name];
    if (!module) {
      var moduleData = modules[name];
      if (!moduleData) return;
      var exports = {};
      module = cache[name] = {
        exports: exports
      };
      moduleData[0]((function(x) {
        return newRequire(moduleData[1][x] || x);
      }), module, exports);
    }
    return module.exports;
  }
  for (var i = 0; i < entry.length; i++) newRequire(entry[i]);
  return newRequire;
})({
  1: [ (function(require, module, exports) {
    module.exports = {
      1001: "cocos2d: removeAction: Target not found",
      1002: "cc.ActionManager.removeActionByTag(): an invalid tag",
      1003: "cc.ActionManager.removeActionByTag(): target must be non-null",
      1004: "cc.ActionManager.getActionByTag(): an invalid tag",
      1005: "cocos2d : getActionByTag(tag = %s): Action not found",
      1006: "[Action step]. override me",
      1007: "[Action update]. override me",
      1008: "cocos2d: FiniteTimeAction#reverse: Implement me",
      1009: "cc.EaseElastic.reverse(): it should be overridden in subclass.",
      1010: "cc.IntervalAction: reverse not implemented.",
      1011: "cc.ActionInterval.setAmplitudeRate(): it should be overridden in subclass.",
      1012: "cc.ActionInterval.getAmplitudeRate(): it should be overridden in subclass.",
      1013: "The speed parameter error",
      1014: "The repeat parameter error",
      1015: "parameters should not be ending with null in Javascript",
      1016: "cc.RotateTo.reverse(): it should be overridden in subclass.",
      1019: "Failed to construct, Sequence construction needs two or more actions.",
      1020: "Failed to construct, Spawn construction needs two or more actions.",
      1021: "cc.Speed.initWithAction(): action must be non nil",
      1022: "cc.Follow.initWithAction(): followedNode must be non nil",
      1023: "cc.ActionEase.initWithAction(): action must be non nil",
      1024: "Invalid configuration. It must at least have one control point",
      1025: "cc.Sequence.initWithTwoActions(): arguments must all be non nil",
      1026: "cc.RepeatForever.initWithAction(): action must be non null",
      1027: "cc.Spawn.initWithTwoActions(): arguments must all be non null",
      1028: "cc.ReverseTime.initWithAction(): action must be non null",
      1029: "cc.ReverseTime.initWithAction(): the action was already passed in.",
      1030: "cc.Animate.initWithAnimation(): animation must be non-NULL",
      1100: "Expected 'data' dict, but not found. Config file: %s",
      1101: "Please load the resource first : %s",
      1200: "cocos2d: Director: Error in gettimeofday",
      1201: "cocos2d: Director: unrecognized projection",
      1203: "cocos2d: Director: Error in gettimeofday",
      1204: "running scene should not null",
      1205: "the scene should not null",
      1206: "loadScene: The scene index to load (%s) is out of range.",
      1207: "loadScene: Unknown name type to load: '%s'",
      1208: "loadScene: Failed to load scene '%s' because '%s' is already loading",
      1209: "loadScene: Can not load the scene '%s' because it was not in the build settings before playing.",
      1210: "Failed to preload '%s', %s",
      1211: "loadScene: The scene index to load (%s) is out of range.",
      1212: "loadScene: Unknown name type to load: '%s'",
      1213: "loadScene: Failed to load scene '%s' because '%s' is already loading",
      1214: "loadScene: Can not load the scene '%s' because it was not in the build settings before playing.",
      1215: "Failed to preload '%s', %s",
      1216: "Director.runSceneImmediate: scene is not valid",
      1300: "element type is wrong!",
      1400: "'%s' is deprecated, please use '%s' instead.",
      1401: "The first argument should be the destination object",
      1402: "The 'visible' property of %s is deprecated, use 'enabled' instead please.",
      1403: "Sorry, cc.audioEngine.willPlayMusic is removed.",
      1404: "cc.spriteFrameCache is removed, please use cc.loader to load and cache sprite frames of atlas format.",
      1405: "The '%s' will be removed in v2.0, please use '%s' instead. \ud83d\ude25",
      1406: "'%s.%s' is removed",
      1407: "cc.pool is being removed from v2.0, you are getting cc.js.Pool instead",
      1502: "cc.scheduler.scheduleCallbackForTarget(): target should be non-null.",
      1503: "cc.Scheduler.pauseTarget():target should be non-null",
      1504: "cc.Scheduler.resumeTarget():target should be non-null",
      1505: "cc.Scheduler.isTargetPaused():target should be non-null",
      1506: "warning: you CANNOT change update priority in scheduled function",
      1507: "CCScheduler#scheduleSelector. Selector already scheduled. Updating interval from: %.4f to %.4f",
      1508: "Argument callback must not be empty",
      1509: "Argument target must be non-nullptr",
      1510: "cc.Scheduler: Illegal target which doesn't have uuid or instanceId.",
      1511: "cc.Scheduler: pause state of the scheduled task doesn't match the element pause state in Scheduler, the given paused state will be ignored.",
      1512: "cc.Scheduler: updateFunc parameter is deprecated in scheduleUpdate function, and will be removed in v2.0",
      1513: "cc.Scheduler: scheduler stopped using `__instanceId` as id since v2.0, you should do scheduler.enableForTarget(target) before all scheduler API usage on target",
      1600: "getZOrder is deprecated. Please use getLocalZOrder instead.",
      1601: "setZOrder is deprecated. Please use setLocalZOrder instead.",
      1602: "RotationX != RotationY. Don't know which one to return",
      1603: "ScaleX != ScaleY. Don't know which one to return",
      1605: "child already added. It can't be added again",
      1606: "child must be non-null",
      1607: "removeFromParentAndCleanup is deprecated. Use removeFromParent instead",
      1608: "boundingBox is deprecated. Use getBoundingBox instead",
      1609: "argument tag is an invalid tag",
      1610: "cocos2d: removeChildByTag(tag = %s): child not found!",
      1612: "cc.Node.stopActionBy(): argument tag an invalid tag",
      1613: "cc.Node.getActionByTag(): argument tag is an invalid tag",
      1614: "resumeSchedulerAndActions is deprecated, please use resume instead.",
      1615: "pauseSchedulerAndActions is deprecated, please use pause instead.",
      1617: "child must be non-null",
      1618: "cc.Node.runAction(): action must be non-null",
      1619: "callback function must be non-null",
      1620: "interval must be positive",
      1623: "Set '%s' to normal node (not persist root node).",
      1624: "Replacing with the same sgNode",
      1625: "The replacement sgNode should not contain any child.",
      1626: "Should not set alpha via 'color', set 'opacity' please.",
      1627: "Not support for asynchronous creating node in SG",
      1632: "Node name can not include '/'.",
      1633: "Internal error, should not remove unknown node from parent.",
      1634: "addChild: The child to add must be instance of cc.Node, not %s.",
      1635: "reorderChild: this child is not in children list.",
      1636: "Node's zIndex value can't be greater than cc.macro.MAX_ZINDEX, setting to the maximum value",
      1637: "Node's zIndex value can't be smaller than cc.macro.MIN_ZINDEX, setting to the minimum value",
      1638: "Private node's zIndex can't be set, it will keep cc.macro.MIN_ZINDEX as its value",
      1800: "cc._EventListenerKeyboard.checkAvailable(): Invalid EventListenerKeyboard!",
      1801: "cc._EventListenerTouchOneByOne.checkAvailable(): Invalid EventListenerTouchOneByOne!",
      1802: "cc._EventListenerTouchAllAtOnce.checkAvailable(): Invalid EventListenerTouchAllAtOnce!",
      1803: "cc._EventListenerAcceleration.checkAvailable(): _onAccelerationEvent must be non-nil",
      1900: "Invalid parameter.",
      2000: "Don't call this method if the event is for touch.",
      2200: "Resolution not valid",
      2201: "should set resolutionPolicy",
      2300: "The touches is more than MAX_TOUCHES, nUnusedIndex = %s",
      2400: "WebGL error %s",
      2602: "cc.Sprite.setDisplayFrameWithAnimationName(): Frame not found",
      2603: "cc.Sprite.setDisplayFrameWithAnimationName(): Invalid frame index",
      2604: "setDisplayFrame is deprecated, please use setSpriteFrame instead.",
      2606: "cc.Sprite.initWithSpriteFrame(): spriteFrame should be non-null",
      2607: "cc.Sprite.initWithSpriteFrameName(): spriteFrameName should be non-null",
      2608: "%s is null, please check.",
      2609: "cc.Sprite.initWithFile(): filename should be non-null",
      2610: "cc.Sprite.setDisplayFrameWithAnimationName(): animationName must be non-null",
      2614: "cc.Sprite.addChild(): child should be non-null",
      2616: "cc.SpriteBatchNode.updateQuadFromSprite(): cc.SpriteBatchNode only supports cc.Sprites as children",
      2617: "cc.SpriteBatchNode.insertQuadFromSprite(): cc.SpriteBatchNode only supports cc.Sprites as children",
      2618: "cc.SpriteBatchNode.addChild(): cc.SpriteBatchNode only supports cc.Sprites as children",
      2619: "cc.SpriteBatchNode.addChild(): cc.Sprite is not using the same texture",
      2623: "cc.SpriteBatchNode.updateQuadFromSprite(): sprite should be non-null",
      2625: "too many tiles, only 16384 tiles will be show",
      2626: "Unrecognized fill type in bar fill",
      2627: "Can not generate quad",
      2628: "%s does not exist",
      2710: "Sprite.initWithTexture(): Argument must be non-nil",
      2712: "Invalid spriteFrameName",
      3002: "textureForKey is deprecated. Please use getTextureForKey instead.",
      3005: "cocos2d: '%s' id=%s %s x %s",
      3006: "cocos2d: '%s' id= HTMLCanvasElement %s x %s",
      3007: "cocos2d: TextureCache dumpDebugInfo: %s textures, HTMLCanvasElement for %s KB (%s MB)",
      3103: "cc.Texture.addImage(): path should be non-null",
      3112: "cc.Texture.addImage(): path should be non-null",
      3113: "NSInternalInconsistencyException",
      3116: "WebGLRenderingContext.CLAMP_TO_EDGE should be used in NPOT textures",
      3117: "Mimpap texture only works in POT textures",
      3118: "contentSize parameter is deprecated and ignored for cc.Texture2D initWithData function.",
      3119: "Lazy init texture with image element failed due to image loading failure: %s",
      3300: "Rect width exceeds maximum margin: %s",
      3400: "Rect height exceeds maximum margin: %s",
      3500: "0 priority is forbidden for fixed priority since it's used for scene graph based priority.",
      3501: "Invalid listener type!",
      3502: "Can't set fixed priority with scene graph based listener.",
      3503: "Invalid parameters.",
      3504: "listener must be a cc.EventListener object when adding a fixed priority listener",
      3505: "The listener has been registered, please don't register it again.",
      3506: "Unsupported listener target.",
      3507: "Invalid scene graph priority!",
      3508: "If program goes here, there should be event in dispatch.",
      3509: "_inDispatch should be 1 here.",
      3510: "%s's scene graph node not contains in the parent's children",
      3511: "event is undefined",
      3600: "cc.Class will automatically call super constructor of %s, you should not call it manually.",
      3601: "The editor property 'playOnFocus' should be used with 'executeInEditMode' in class '%s'",
      3602: "Unknown editor property '%s' in class '%s'.",
      3603: "Use 'cc.Float' or 'cc.Integer' instead of 'cc.Number' please. \ud83d\ude02",
      3604: "Can only indicate one type attribute for %s.",
      3605: "The default value of %s is not instance of %s.",
      3606: "No needs to indicate the '%s' attribute for %s, which its default value is type of %s.",
      3607: "The default value of %s must be an empty string.",
      3608: "The type of %s must be cc.String, not String.",
      3609: "The type of %s must be cc.Boolean, not Boolean.",
      3610: "The type of %s must be cc.Float or cc.Integer, not Number.",
      3611: "Can not indicate the '%s' attribute for %s, which its default value is type of %s.",
      3612: "%s Just set the default value to 'new %s()' and it will be handled properly.",
      3613: "'No need to use 'serializable: false' or 'editorOnly: true' for the getter of '%s.%s', every getter is actually non-serialized.",
      3614: "Should not define constructor for cc.Component %s.",
      3615: "Each script can have at most one Component.",
      3616: "Should not specify class name %s for Component which defines in project.",
      3617: "Can not instantiate CCClass '%s' with arguments.",
      3618: "ctor of '%s' can not be another CCClass",
      3619: "ctor of '%s' must be function type",
      3620: "this._super declared in '%s.%s' but no super method defined",
      3621: "Unknown type of %s.%s, maybe you want is '%s'.",
      3622: "Unknown type of %s.%s, property should be defined in 'properties' or 'ctor'",
      3623: "Can not use 'editor' attribute, '%s' not inherits from Components.",
      3624: "'%s' overrided '%s' but '%s' is defined as 'false' so the super method will not be called. You can set '%s' to null to disable this warning.",
      3625: "[isChildClassOf] superclass should be function type, not",
      3626: "Can't remove '%s' because '%s' depends on it.",
      3627: "Should not add renderer component (%s) to a Canvas node.",
      3628: "Should not add %s to a node which size is already used by its other component.",
      3629: "attribute must be type object",
      3633: "Properties function of '%s' should return an object!",
      3634: "Disallow to use '.' in property name",
      3635: "Default array must be empty, set default value of %s.%s to [], and initialize in 'onLoad' or 'ctor' please. (just like 'this.%s = [...];')",
      3636: "Do not set default value to non-empty object, unless the object defines its own 'clone' function. Set default value of %s.%s to null or {}, and initialize in 'onLoad' or 'ctor' please. (just like 'this.%s = {foo: bar};')",
      3637: "Can not declare %s.%s, it is already defined in the prototype of %s",
      3638: "'%s': the getter of '%s' is already defined!",
      3639: "Can not apply the specified attribute to the getter of '%s.%s', attribute index: %s",
      3640: "'%s': the setter of '%s' is already defined!",
      3641: "Can not construct %s because it contains object property.",
      3642: "Cannot define %s.%s because static member name can not be '%s'.",
      3643: "Can not define a member called 'constructor' in the class '%s', please use 'ctor' instead.",
      3644: "Please define 'type' parameter of %s.%s as the actual constructor.",
      3645: "Please define 'type' parameter of %s.%s as the constructor of %s.",
      3646: "Unknown 'type' parameter of %s.%s\uff1a%s",
      3647: "The length of range array must be equal or greater than 2",
      3648: "Can not declare %s.%s method, it is already defined in the properties of %s.",
      3649: "CCClass %s have conflict between its ctor and __ctor__.",
      3651: 'Can not call `_super` or `prototype.ctor` in ES6 Classes "%s", use `super` instead please.',
      3652: 'Failed to construct a dummy instance of the "%s" class using `new` behind the scenes. This is for getting default values declared in TypeScript. Please ensure the class will be able to construct during script\'s initialization. %s.',
      3653: 'Please do not specifiy "default" attribute in decorator of "%s" property in "%s" class.  \nDefault value must be initialized at their declaration: \ud83d\ude30\n \n// Before:\n@property({\n  type: cc.Integer\n  default: 0  // <--\n})\nvalue;\n// After:\n@property({\n  type: cc.Integer\n})\nvalue = 0;    // <--',
      3654: 'Please specifiy a default value for "%s" property at its declaration: \ud83d\ude30\n \n// Before:\n@property(...)\nvalue; \n// After:\n@property(...)\nvalue = 0',
      3655: 'Can not specifiy "get" or "set"  attribute in decorator for "%s" property in "%s" class.  \nPlease use:\n \n@property(...)\nget %s () {\n    ...\n}\n@property\nset %s (value) {\n    ...\n}',
      3656: "The default value of %s.%s must be an empty string. (changed since 1.8)",
      3657: "The value assigned to %s should be Texture2D object, not url string. Since 1.8,  \nyou can declare a texture object directly in properties by using:  \n \n{\n    default: null,\n    type: cc.Texture2D  // use 'type:' instead of 'url:'\n}",
      3658: "browser does not support getters",
      3700: "internal error: _prefab is undefined",
      3701: "Failed to load prefab asset for node '%s'",
      3800: "The target can not be made persist because it's not a cc.Node or it doesn't have _id property.",
      3801: "The node can not be made persist because it's not under root node.",
      3802: "The node can not be made persist because it's not in current scene.",
      3803: "The target can not be made persist because it's not a cc.Node or it doesn't have _id property.",
      3804: "getComponent: Type must be non-nil",
      3805: "Can't add component '%s' because %s already contains the same component.",
      3806: "Can't add component '%s' to %s because it conflicts with the existing '%s' derived component.",
      3807: "addComponent: Failed to get class '%s'",
      3808: "addComponent: Should not add component ('%s') when the scripts are still loading.",
      3809: "addComponent: The component to add must be a constructor",
      3810: "addComponent: The component to add must be child class of cc.Component",
      3811: "_addComponentAt: The component to add must be a constructor",
      3812: "_addComponentAt: Index out of range",
      3813: "removeComponent: Component must be non-nil",
      3814: "Argument must be non-nil",
      3815: "Component not owned by this entity",
      3816: "Node '%s' is already activating",
      3817: "Sorry, the component of '%s' which with an index of %s is corrupted! It has been removed.",
      3818: "Failed to read or parse project.json",
      3819: "Warning: target element is not a DIV or CANVAS",
      3820: "The renderer doesn't support the renderMode %s",
      3821: "Cannot change hierarchy while activating or deactivating the parent.",
      3900: "Invalid clip to add",
      3901: "Invalid clip to remove",
      3902: "clip is defaultClip, set force to true to force remove clip and animation state",
      3903: "animation state is playing, set force to true to force stop and remove clip and animation state",
      3904: "motion path of target [%s] in prop [%s] frame [%s] is not valid",
      3905: "sprite frames must be an Array.",
      3906: "Can't find easing type [%s]",
      3907: "animator not added or already removed",
      3908: "animation not added or already removed",
      3912: "already-playing",
      4000: "Sorry, the cc.Font has been modified from Raw Asset to Asset. Please load the font asset before using.",
      4003: "Label font size can't be shirnked less than 0!",
      4004: "force notify all fonts loaded!",
      4011: "Property spriteFrame of Font '%s' is invalid. Using system font instead.",
      4012: "The texture of Font '%s' must be already loaded on JSB. Using system font instead.",
      4013: "Sorry, lineHeight of system font not supported on JSB.",
      4100: "Property padding is deprecated, please use paddingLeft, paddingRight, paddingTop and paddingBottom instead",
      4200: "MaskType: IMAGE_STENCIL only support WebGL mode.",
      4201: "The alphaThreshold invalid in Canvas Mode.",
      4202: "The inverted invalid in Canvas Mode.",
      4300: "can not found the %s page.",
      4400: "Invalid RichText img tag! The sprite frame name can't be found in the ImageAtlas!",
      4600: "Script attached to '%s' is missing or invalid.",
      4700: "The dom control is not created!",
      4800: "unknown asset type",
      4901: "loadRes: should not specify the extname in %s %s",
      4902: "No need to release non-cached asset.",
      4903: "Can not get class '%s'",
      4914: "Resources url '%s' does not exist.",
      4915: "Pack indices and data do not match in size",
      4916: "Failed to download package for %s",
      4920: "Sorry, you shouldn't use id as item identity any more, please use url or uuid instead, the current id is being set as url: (%s)",
      4921: "Invalid pipe or invalid index provided!",
      4922: "The pipe to be inserted is already in the pipeline!",
      4923: "Uuid Loader: Parse asset [ %s ] failed : %s",
      4924: "JSON Loader: Input item doesn't contain string content",
      4925: "Uuid Loader: Deserialize asset [ %s ] failed : %s",
      4926: "Audio Downloader: no web audio context.",
      4927: "Audio Downloader: audio not supported on this browser!",
      4928: "Load %s failed!",
      4929: "Load Webp ( %s ) failed",
      4930: "Load image ( %s ) failed",
      4931: "Download Uuid: can not find type of raw asset[ %s ]: %s",
      4932: 'Since v1.10, for any atlas ("%s") in the "resources" directory, it is not possible to find the contained SpriteFrames via `loadRes`, `getRes` or `releaseRes`. Load the SpriteAtlas first and then use `spriteAtlas.getSpriteFrame(name)` instead please.',
      5000: "object already destroyed",
      5001: "object not yet destroyed",
      5100: "Not a plist file!",
      5200: "Warning: localStorage isn't enabled. Please confirm browser cookie or privacy option",
      5201: "browser don't support web audio",
      5202: "This feature supports WebGL render mode only.",
      5300: "Type of target to deserialize not matched with data: target is %s, data is %s",
      5301: "Can not find script '%s'",
      5302: "Can not find class '%s'",
      5400: "'%s' is deprecated, use '%s' instead please.",
      5401: "'%s' is deprecated, use '%s' instead please.",
      5402: "cc.js.addon called on non-object:",
      5403: "cc.js.mixin: arguments must be type object:",
      5404: "The base class to extend from must be non-nil",
      5405: "The class to extend must be non-nil",
      5406: "Class should be extended before assigning any prototype members.",
      5500: "'notify' can't work with 'get/set' !",
      5501: "'notify' must work with 'default' !",
      5502: "Invalid url of %s.%s",
      5503: "The 'url' attribute of '%s.%s' is undefined when loading script.",
      5504: "The 'url' type of '%s.%s' must be child class of cc.RawAsset.",
      5505: "The 'url' type of '%s.%s' must not be child class of cc.Asset, otherwise you should use 'type: %s' instead.",
      5506: "Can not specify 'type' attribute for '%s.%s', because its 'url' is already defined.",
      5507: "The 'default' attribute of '%s.%s' must be an array",
      5508: "Invalid type of %s.%s",
      5510: "The 'type' attribute of '%s.%s' can not be 'Number', use 'Float' or 'Integer' instead please.",
      5511: "The 'type' attribute of '%s.%s' is undefined when loading script",
      5512: "Can not serialize '%s.%s' because the specified type is anonymous, please provide a class name or set the 'serializable' attribute of '%s.%s' to 'false'.",
      5513: "The 'default' value of '%s.%s' should not be used with a 'get' function.",
      5514: "The 'default' value of '%s.%s' should not be used with a 'set' function.",
      5515: "The 'default' value of '%s.%s' can not be an constructor. Set default to null please.",
      5516: "Property '%s.%s' must define at least one of 'default', 'get' or 'set'.",
      5517: "'%s.%s' hides inherited property '%s.%s'. To make the current property override that implementation, add the `override: true` attribute please.",
      5600: "Argument must be non-nil",
      5601: "Can not get current scene.",
      5602: "Scene is destroyed",
      5603: "reference node is destroyed",
      5700: "no %s or %s on %s",
      5800: "%s.lerp not yet implemented.",
      5801: "%s.clone not yet implemented.",
      5802: "%s.equals not yet implemented.",
      5900: "MotionStreak only support WebGL mode.",
      5901: "cc.MotionStreak.getOpacity has not been supported.",
      5902: "cc.MotionStreak.setOpacity has not been supported.",
      6000: "Custom should not be false if file is not specified.",
      6001: "The new %s must not be NaN",
      6017: "Incomplete or corrupt PNG file",
      6018: "Invalid filter algorithm: %s",
      6019: "Invalid byte order value.",
      6020: "You forgot your towel!",
      6021: "Unknown Field Tag: %s",
      6022: "Too many bits requested",
      6023: "No bits requested",
      6024: "Cannot recover from missing StripByteCounts",
      6025: "Cannot handle sub-byte bits per sample",
      6026: "Cannot handle sub-byte bits per pixel",
      6027: "Palette image missing color map",
      6028: "Unknown Photometric Interpretation: %s",
      6029: "Unkown error",
      6030: "cc.ParticleSystem: error decoding or ungzipping textureImageData",
      6031: "cc.ParticleSystem: unknown image format with Data",
      6032: "cc.ParticleSystem.initWithDictionary() : error loading the texture",
      6200: "Canvas doesn't support mesh slot!",
      6300: "only cc.DrawNode is accepted as stencil",
      6301: "Stencil buffer is not enabled.",
      6302: "Nesting more than %d stencils is not supported. Everything will be drawn without stencil for this node and its children.",
      6400: "asset.url is not usable in core process",
      6401: "asset.urls is not usable in core process",
      6402: "AssetLibrary has already been initialized!",
      6500: "Widget target must be one of the parent nodes of it",
      6600: "collider not added or already removed",
      6601: "Can't find testFunc for (%s, $s).",
      6700: "Can't init canvas '%s' because it conflicts with the existing '%s', the scene should only have one active canvas at the same time",
      6701: "Should not add Canvas to a node which already contains a renderer component (%s).",
      6702: "Should not add Canvas to a node which size is already used by its other component.",
      6703: "Can't initialise DrawingPrimitiveWebGL. context need is WebGLRenderingContext",
      6704: "Polygon's point must greater than 2",
      6705: "Argument must be non-nil",
      6800: "Callback of event must be non-nil",
      6801: "The message must be provided",
      6900: "The thing you want to instantiate must be an object",
      6901: "The thing you want to instantiate is nil",
      6902: "The thing you want to instantiate is destroyed",
      6903: "The instantiate method for given asset do not implemented",
      6904: "Can not instantiate array",
      6905: "Can not instantiate DOM element",
      7000: "Failed to init asset's raw path.",
      7001: "Should not load '%s' from script dynamically, unless it is placed in the 'resources' folder.",
      7002: "Sorry can not load '%s' because it is not placed in the 'resources' folder.",
      7003: "Failed to init builtin asset's raw path.",
      7100: "%s already defined in Enum.",
      7101: "Sorry, 'cc.Enum' not available on this platform, please report this error here: https://github.com/cocos-creator/engine/issues/new",
      7200: "Method 'initWithTMXFile' is no effect now, please set property 'tmxAsset' instead.",
      7201: "Method 'initWithXML' is no effect now, please set property 'tmxAsset' instead.",
      7202: "Add component TiledLayer into node failed.",
      7203: "Property 'mapLoaded' is unused now. Please write the logic to the callback 'start'.",
      7210: "TMX Hexa zOrder not supported",
      7211: "TMX invalid value",
      7214: "propertiesForGID is deprecated. Please use getPropertiesForGID instead.",
      7215: "cocos2d: Warning: TMX Layer %s has no tiles",
      7216: "cocos2d: TMXFormat: Unsupported TMX version: %s",
      7217: "cocos2d: TMXFomat: Unsupported orientation: %s",
      7218: "cc.TMXMapInfo.parseXMLFile(): unsupported compression method",
      7219: "cc.TMXMapInfo.parseXMLFile(): Only base64 and/or gzip/zlib maps are supported",
      7221: "cc.TMXMapInfo.parseXMLFile(): Texture '%s' not found.",
      7222: "Parse %s failed.",
      7236: "cc.TMXLayer.getTileAt(): TMXLayer: the tiles map has been released",
      7237: "cc.TMXLayer.getTileGIDAt(): TMXLayer: the tiles map has been released",
      7238: "cc.TMXLayer.setTileGID(): TMXLayer: the tiles map has been released",
      7239: "cc.TMXLayer.setTileGID(): invalid gid: %s",
      7240: "cc.TMXLayer.getTileFlagsAt(): TMXLayer: the tiles map has been released",
      7241: "cc.TiledMap.initWithXML(): Map not found. Please check the filename.",
      7401: "Failed to set _defaultArmatureIndex for '%s' because the index is out of range.",
      7402: "Failed to set _animationIndex for '%s' because the index is out of range.",
      7501: "Failed to set _defaultSkinIndex for '%s' because the index is out of range.",
      7502: "Failed to set _animationIndex for '%s' because its skeletonData is invalid.",
      7503: "Failed to set _animationIndex for '%s' because the index is out of range.",
      7504: "Can not render dynamic created SkeletonData",
      7505: "Invalid type of atlasFile, atlas should be registered as raw asset.",
      7506: "Failed to load spine atlas '$s'",
      7507: "Please re-import '%s' because its textures is not initialized! (This workflow will be improved in the future.)",
      7508: "The atlas asset of '%s' is not exists!",
      7509: "Spine: Animation not found: %s",
      7510: "Spine: Animation not found: %s",
      7600: "The context of RenderTexture is invalid.",
      7601: "cc.RenderTexture._initWithWidthAndHeightForWebGL() : only RGB and RGBA formats are valid for a render texture;",
      7602: "Could not attach texture to the framebuffer",
      7603: "clearDepth isn't supported on Cocos2d-Html5",
      7604: "saveToFile isn't supported on Cocos2d-Html5",
      7605: "newCCImage isn't supported on Cocos2d-Html5",
      7700: "On the web is always keep the aspect ratio",
      7701: "Can't know status",
      7702: "Video player's duration is not ready to get now!",
      7800: "Web does not support loading",
      7801: "Web does not support query history",
      7802: "Web does not support query history",
      7803: "The current browser does not support the GoBack",
      7804: "The current browser does not support the GoForward",
      7805: "Web does not support zoom",
      7900: "cc.math.Matrix3.assign(): current matrix equals matIn",
      7901: "cc.math.mat4Assign(): pOut equals pIn",
      7902: "cc.mat.Matrix4.assignFrom(): mat4 equals current matrix",
      7903: "cc.math.Matrix4 equal: pMat1 and pMat2 are same object.",
      7904: "cc.math.Matrix4.extractPlane: Invalid plane index",
      7905: "cc.math.mat4Assign(): pOut equals pIn",
      7906: "cc.mat.Matrix4.assignFrom(): mat4 equals current matrix",
      7907: "cc.math.Matrix4 equals: pMat1 and pMat2 are same object.",
      7908: "Invalid matrix mode specified",
      7909: "current quaternion is an invalid value",
      8000: "Can't handle this field type or size",
      8001: "No bytes requested",
      8002: "Too many bytes requested",
      8003: "Missing StripByteCounts!",
      8100: "cocos2d: ERROR: Failed to compile shader:\n %s",
      8101: "cocos2d: ERROR: Failed to compile vertex shader",
      8102: "cocos2d: ERROR: Failed to compile fragment shader",
      8103: "cc.GLProgram.link(): Cannot link invalid program",
      8104: "cocos2d: ERROR: Failed to link program: %s",
      8105: "cocos2d: cc.shaderCache._loadDefaultShader, error shader type",
      8106: "Please load the resource firset : %s",
      8107: "cc.GLProgram.getUniformLocationForName(): uniform name should be non-null",
      8108: "cc.GLProgram.getUniformLocationForName(): Invalid operation. Cannot get uniform location when program is not initialized",
      8109: "modelView matrix is undefined.",
      8200: "Please set node's active instead of rigidbody's enabled.",
      8300: "Should only one camera exists, please check your project.",
      8301: "Camera does not support Canvas Mode.",
      8400: "Wrong type arguments, 'filePath' must be a String.",
      8401: "Since 1.10, `%s` accept %s instance directly, not a URL string. Please directly reference the %s object in your script, or load %s by loader first. Don't use %s's URL anymore.",
      9000: "Stencil manager does not support level bigger than %d in this device.",
      9001: "Stencil manager is already empty, cannot pop any mask",
      "0100": "%s not yet implemented."
    };
  }), {} ],
  2: [ (function(require, module, exports) {
    require("../core/platform/CCClass");
    var misc = require("../core/utils/misc");
    cc.Action = cc.Class({
      name: "cc.Action",
      ctor: function() {
        this.originalTarget = null;
        this.target = null;
        this.tag = cc.Action.TAG_INVALID;
      },
      clone: function() {
        var action = new cc.Action();
        action.originalTarget = null;
        action.target = null;
        action.tag = this.tag;
        return action;
      },
      isDone: function() {
        return true;
      },
      startWithTarget: function(target) {
        this.originalTarget = target;
        this.target = target;
      },
      stop: function() {
        this.target = null;
      },
      step: function(dt) {
        cc.logID(1006);
      },
      update: function(dt) {
        cc.logID(1007);
      },
      getTarget: function() {
        return this.target;
      },
      setTarget: function(target) {
        this.target = target;
      },
      getOriginalTarget: function() {
        return this.originalTarget;
      },
      setOriginalTarget: function(originalTarget) {
        this.originalTarget = originalTarget;
      },
      getTag: function() {
        return this.tag;
      },
      setTag: function(tag) {
        this.tag = tag;
      },
      retain: function() {},
      release: function() {}
    });
    cc.Action.TAG_INVALID = -1;
    cc.FiniteTimeAction = cc.Class({
      name: "cc.FiniteTimeAction",
      extends: cc.Action,
      ctor: function() {
        this._duration = 0;
      },
      getDuration: function() {
        return this._duration * (this._timesForRepeat || 1);
      },
      setDuration: function(duration) {
        this._duration = duration;
      },
      reverse: function() {
        cc.logID(1008);
        return null;
      },
      clone: function() {
        return new cc.FiniteTimeAction();
      }
    });
    cc.Speed = cc.Class({
      name: "cc.Speed",
      extends: cc.Action,
      ctor: function(action, speed) {
        this._speed = 0;
        this._innerAction = null;
        action && this.initWithAction(action, speed);
      },
      getSpeed: function() {
        return this._speed;
      },
      setSpeed: function(speed) {
        this._speed = speed;
      },
      initWithAction: function(action, speed) {
        if (!action) {
          cc.errorID(1021);
          return false;
        }
        this._innerAction = action;
        this._speed = speed;
        return true;
      },
      clone: function() {
        var action = new cc.Speed();
        action.initWithAction(this._innerAction.clone(), this._speed);
        return action;
      },
      startWithTarget: function(target) {
        cc.Action.prototype.startWithTarget.call(this, target);
        this._innerAction.startWithTarget(target);
      },
      stop: function() {
        this._innerAction.stop();
        cc.Action.prototype.stop.call(this);
      },
      step: function(dt) {
        this._innerAction.step(dt * this._speed);
      },
      isDone: function() {
        return this._innerAction.isDone();
      },
      reverse: function() {
        return new cc.Speed(this._innerAction.reverse(), this._speed);
      },
      setInnerAction: function(action) {
        this._innerAction !== action && (this._innerAction = action);
      },
      getInnerAction: function() {
        return this._innerAction;
      }
    });
    cc.speed = function(action, speed) {
      return new cc.Speed(action, speed);
    };
    cc.Follow = cc.Class({
      name: "cc.Follow",
      extends: cc.Action,
      ctor: function(followedNode, rect) {
        this._followedNode = null;
        this._boundarySet = false;
        this._boundaryFullyCovered = false;
        this._halfScreenSize = null;
        this._fullScreenSize = null;
        this.leftBoundary = 0;
        this.rightBoundary = 0;
        this.topBoundary = 0;
        this.bottomBoundary = 0;
        this._worldRect = cc.rect(0, 0, 0, 0);
        followedNode && (rect ? this.initWithTarget(followedNode, rect) : this.initWithTarget(followedNode));
      },
      clone: function() {
        var action = new cc.Follow();
        var locRect = this._worldRect;
        var rect = new cc.Rect(locRect.x, locRect.y, locRect.width, locRect.height);
        action.initWithTarget(this._followedNode, rect);
        return action;
      },
      isBoundarySet: function() {
        return this._boundarySet;
      },
      setBoudarySet: function(value) {
        this._boundarySet = value;
      },
      initWithTarget: function(followedNode, rect) {
        if (!followedNode) {
          cc.errorID(1022);
          return false;
        }
        var _this = this;
        rect = rect || cc.rect(0, 0, 0, 0);
        _this._followedNode = followedNode;
        _this._worldRect = rect;
        _this._boundarySet = !(0 === rect.width && 0 === rect.height);
        _this._boundaryFullyCovered = false;
        var winSize = cc.winSize;
        _this._fullScreenSize = cc.v2(winSize.width, winSize.height);
        _this._halfScreenSize = _this._fullScreenSize.mul(.5);
        if (_this._boundarySet) {
          _this.leftBoundary = -(rect.x + rect.width - _this._fullScreenSize.x);
          _this.rightBoundary = -rect.x;
          _this.topBoundary = -rect.y;
          _this.bottomBoundary = -(rect.y + rect.height - _this._fullScreenSize.y);
          _this.rightBoundary < _this.leftBoundary && (_this.rightBoundary = _this.leftBoundary = (_this.leftBoundary + _this.rightBoundary) / 2);
          _this.topBoundary < _this.bottomBoundary && (_this.topBoundary = _this.bottomBoundary = (_this.topBoundary + _this.bottomBoundary) / 2);
          _this.topBoundary === _this.bottomBoundary && _this.leftBoundary === _this.rightBoundary && (_this._boundaryFullyCovered = true);
        }
        return true;
      },
      step: function(dt) {
        var targetWorldPos = this.target.convertToWorldSpaceAR(cc.Vec2.ZERO);
        var followedWorldPos = this._followedNode.convertToWorldSpaceAR(cc.Vec2.ZERO);
        var delta = targetWorldPos.sub(followedWorldPos);
        var tempPos = this.target.parent.convertToNodeSpaceAR(delta.add(this._halfScreenSize));
        if (this._boundarySet) {
          if (this._boundaryFullyCovered) return;
          this.target.setPosition(misc.clampf(tempPos.x, this.leftBoundary, this.rightBoundary), misc.clampf(tempPos.y, this.bottomBoundary, this.topBoundary));
        } else this.target.setPosition(tempPos.x, tempPos.y);
      },
      isDone: function() {
        return !this._followedNode.activeInHierarchy;
      },
      stop: function() {
        this.target = null;
        cc.Action.prototype.stop.call(this);
      }
    });
    cc.follow = function(followedNode, rect) {
      return new cc.Follow(followedNode, rect);
    };
  }), {
    "../core/platform/CCClass": 147,
    "../core/utils/misc": 208
  } ],
  3: [ (function(require, module, exports) {
    function cardinalSplineAt(p0, p1, p2, p3, tension, t) {
      var t2 = t * t;
      var t3 = t2 * t;
      var s = (1 - tension) / 2;
      var b1 = s * (2 * t2 - t3 - t);
      var b2 = s * (-t3 + t2) + (2 * t3 - 3 * t2 + 1);
      var b3 = s * (t3 - 2 * t2 + t) + (-2 * t3 + 3 * t2);
      var b4 = s * (t3 - t2);
      var x = p0.x * b1 + p1.x * b2 + p2.x * b3 + p3.x * b4;
      var y = p0.y * b1 + p1.y * b2 + p2.y * b3 + p3.y * b4;
      return cc.v2(x, y);
    }
    function getControlPointAt(controlPoints, pos) {
      var p = Math.min(controlPoints.length - 1, Math.max(pos, 0));
      return controlPoints[p];
    }
    function reverseControlPoints(controlPoints) {
      var newArray = [];
      for (var i = controlPoints.length - 1; i >= 0; i--) newArray.push(cc.v2(controlPoints[i].x, controlPoints[i].y));
      return newArray;
    }
    function cloneControlPoints(controlPoints) {
      var newArray = [];
      for (var i = 0; i < controlPoints.length; i++) newArray.push(cc.v2(controlPoints[i].x, controlPoints[i].y));
      return newArray;
    }
    cc.CardinalSplineTo = cc.Class({
      name: "cc.CardinalSplineTo",
      extends: cc.ActionInterval,
      ctor: function(duration, points, tension) {
        this._points = [];
        this._deltaT = 0;
        this._tension = 0;
        this._previousPosition = null;
        this._accumulatedDiff = null;
        void 0 !== tension && cc.CardinalSplineTo.prototype.initWithDuration.call(this, duration, points, tension);
      },
      initWithDuration: function(duration, points, tension) {
        if (!points || 0 === points.length) {
          cc.errorID(1024);
          return false;
        }
        if (cc.ActionInterval.prototype.initWithDuration.call(this, duration)) {
          this.setPoints(points);
          this._tension = tension;
          return true;
        }
        return false;
      },
      clone: function() {
        var action = new cc.CardinalSplineTo();
        action.initWithDuration(this._duration, cloneControlPoints(this._points), this._tension);
        return action;
      },
      startWithTarget: function(target) {
        cc.ActionInterval.prototype.startWithTarget.call(this, target);
        this._deltaT = 1 / (this._points.length - 1);
        this._previousPosition = cc.v2(this.target.x, this.target.y);
        this._accumulatedDiff = cc.v2(0, 0);
      },
      update: function(dt) {
        dt = this._computeEaseTime(dt);
        var p, lt;
        var ps = this._points;
        if (1 === dt) {
          p = ps.length - 1;
          lt = 1;
        } else {
          var locDT = this._deltaT;
          p = 0 | dt / locDT;
          lt = (dt - locDT * p) / locDT;
        }
        var newPos = cardinalSplineAt(getControlPointAt(ps, p - 1), getControlPointAt(ps, p - 0), getControlPointAt(ps, p + 1), getControlPointAt(ps, p + 2), this._tension, lt);
        if (cc.macro.ENABLE_STACKABLE_ACTIONS) {
          var tempX, tempY;
          tempX = this.target.x - this._previousPosition.x;
          tempY = this.target.y - this._previousPosition.y;
          if (0 !== tempX || 0 !== tempY) {
            var locAccDiff = this._accumulatedDiff;
            tempX = locAccDiff.x + tempX;
            tempY = locAccDiff.y + tempY;
            locAccDiff.x = tempX;
            locAccDiff.y = tempY;
            newPos.x += tempX;
            newPos.y += tempY;
          }
        }
        this.updatePosition(newPos);
      },
      reverse: function() {
        var reversePoints = reverseControlPoints(this._points);
        return cc.cardinalSplineTo(this._duration, reversePoints, this._tension);
      },
      updatePosition: function(newPos) {
        this.target.setPosition(newPos);
        this._previousPosition = newPos;
      },
      getPoints: function() {
        return this._points;
      },
      setPoints: function(points) {
        this._points = points;
      }
    });
    cc.cardinalSplineTo = function(duration, points, tension) {
      return new cc.CardinalSplineTo(duration, points, tension);
    };
    cc.CardinalSplineBy = cc.Class({
      name: "cc.CardinalSplineBy",
      extends: cc.CardinalSplineTo,
      ctor: function(duration, points, tension) {
        this._startPosition = cc.v2(0, 0);
        void 0 !== tension && this.initWithDuration(duration, points, tension);
      },
      startWithTarget: function(target) {
        cc.CardinalSplineTo.prototype.startWithTarget.call(this, target);
        this._startPosition.x = target.x;
        this._startPosition.y = target.y;
      },
      reverse: function() {
        var copyConfig = this._points.slice();
        var current;
        var p = copyConfig[0];
        for (var i = 1; i < copyConfig.length; ++i) {
          current = copyConfig[i];
          copyConfig[i] = current.sub(p);
          p = current;
        }
        var reverseArray = reverseControlPoints(copyConfig);
        p = reverseArray[reverseArray.length - 1];
        reverseArray.pop();
        p.x = -p.x;
        p.y = -p.y;
        reverseArray.unshift(p);
        for (var i = 1; i < reverseArray.length; ++i) {
          current = reverseArray[i];
          current.x = -current.x;
          current.y = -current.y;
          current.x += p.x;
          current.y += p.y;
          reverseArray[i] = current;
          p = current;
        }
        return cc.cardinalSplineBy(this._duration, reverseArray, this._tension);
      },
      updatePosition: function(newPos) {
        var pos = this._startPosition;
        var posX = newPos.x + pos.x;
        var posY = newPos.y + pos.y;
        this._previousPosition.x = posX;
        this._previousPosition.y = posY;
        this.target.setPosition(posX, posY);
      },
      clone: function() {
        var a = new cc.CardinalSplineBy();
        a.initWithDuration(this._duration, cloneControlPoints(this._points), this._tension);
        return a;
      }
    });
    cc.cardinalSplineBy = function(duration, points, tension) {
      return new cc.CardinalSplineBy(duration, points, tension);
    };
    cc.CatmullRomTo = cc.Class({
      name: "cc.CatmullRomTo",
      extends: cc.CardinalSplineTo,
      ctor: function(dt, points) {
        points && this.initWithDuration(dt, points);
      },
      initWithDuration: function(dt, points) {
        return cc.CardinalSplineTo.prototype.initWithDuration.call(this, dt, points, .5);
      },
      clone: function() {
        var action = new cc.CatmullRomTo();
        action.initWithDuration(this._duration, cloneControlPoints(this._points));
        return action;
      }
    });
    cc.catmullRomTo = function(dt, points) {
      return new cc.CatmullRomTo(dt, points);
    };
    cc.CatmullRomBy = cc.Class({
      name: "cc.CatmullRomBy",
      extends: cc.CardinalSplineBy,
      ctor: function(dt, points) {
        points && this.initWithDuration(dt, points);
      },
      initWithDuration: function(dt, points) {
        return cc.CardinalSplineTo.prototype.initWithDuration.call(this, dt, points, .5);
      },
      clone: function() {
        var action = new cc.CatmullRomBy();
        action.initWithDuration(this._duration, cloneControlPoints(this._points));
        return action;
      }
    });
    cc.catmullRomBy = function(dt, points) {
      return new cc.CatmullRomBy(dt, points);
    };
  }), {} ],
  4: [ (function(require, module, exports) {
    cc.easeIn = function(rate) {
      return {
        _rate: rate,
        easing: function(dt) {
          return Math.pow(dt, this._rate);
        },
        reverse: function() {
          return cc.easeIn(1 / this._rate);
        }
      };
    };
    cc.easeOut = function(rate) {
      return {
        _rate: rate,
        easing: function(dt) {
          return Math.pow(dt, 1 / this._rate);
        },
        reverse: function() {
          return cc.easeOut(1 / this._rate);
        }
      };
    };
    cc.easeInOut = function(rate) {
      return {
        _rate: rate,
        easing: function(dt) {
          dt *= 2;
          return dt < 1 ? .5 * Math.pow(dt, this._rate) : 1 - .5 * Math.pow(2 - dt, this._rate);
        },
        reverse: function() {
          return cc.easeInOut(this._rate);
        }
      };
    };
    var _easeExponentialInObj = {
      easing: function(dt) {
        return 0 === dt ? 0 : Math.pow(2, 10 * (dt - 1));
      },
      reverse: function() {
        return _easeExponentialOutObj;
      }
    };
    cc.easeExponentialIn = function() {
      return _easeExponentialInObj;
    };
    var _easeExponentialOutObj = {
      easing: function(dt) {
        return 1 === dt ? 1 : 1 - Math.pow(2, -10 * dt);
      },
      reverse: function() {
        return _easeExponentialInObj;
      }
    };
    cc.easeExponentialOut = function() {
      return _easeExponentialOutObj;
    };
    var _easeExponentialInOutObj = {
      easing: function(dt) {
        if (1 !== dt && 0 !== dt) {
          dt *= 2;
          return dt < 1 ? .5 * Math.pow(2, 10 * (dt - 1)) : .5 * (2 - Math.pow(2, -10 * (dt - 1)));
        }
        return dt;
      },
      reverse: function() {
        return _easeExponentialInOutObj;
      }
    };
    cc.easeExponentialInOut = function() {
      return _easeExponentialInOutObj;
    };
    var _easeSineInObj = {
      easing: function(dt) {
        return 0 === dt || 1 === dt ? dt : -1 * Math.cos(dt * Math.PI / 2) + 1;
      },
      reverse: function() {
        return _easeSineOutObj;
      }
    };
    cc.easeSineIn = function() {
      return _easeSineInObj;
    };
    var _easeSineOutObj = {
      easing: function(dt) {
        return 0 === dt || 1 === dt ? dt : Math.sin(dt * Math.PI / 2);
      },
      reverse: function() {
        return _easeSineInObj;
      }
    };
    cc.easeSineOut = function() {
      return _easeSineOutObj;
    };
    var _easeSineInOutObj = {
      easing: function(dt) {
        return 0 === dt || 1 === dt ? dt : -.5 * (Math.cos(Math.PI * dt) - 1);
      },
      reverse: function() {
        return _easeSineInOutObj;
      }
    };
    cc.easeSineInOut = function() {
      return _easeSineInOutObj;
    };
    var _easeElasticInObj = {
      easing: function(dt) {
        if (0 === dt || 1 === dt) return dt;
        dt -= 1;
        return -Math.pow(2, 10 * dt) * Math.sin((dt - .075) * Math.PI * 2 / .3);
      },
      reverse: function() {
        return _easeElasticOutObj;
      }
    };
    cc.easeElasticIn = function(period) {
      if (period && .3 !== period) return {
        _period: period,
        easing: function(dt) {
          if (0 === dt || 1 === dt) return dt;
          dt -= 1;
          return -Math.pow(2, 10 * dt) * Math.sin((dt - this._period / 4) * Math.PI * 2 / this._period);
        },
        reverse: function() {
          return cc.easeElasticOut(this._period);
        }
      };
      return _easeElasticInObj;
    };
    var _easeElasticOutObj = {
      easing: function(dt) {
        return 0 === dt || 1 === dt ? dt : Math.pow(2, -10 * dt) * Math.sin((dt - .075) * Math.PI * 2 / .3) + 1;
      },
      reverse: function() {
        return _easeElasticInObj;
      }
    };
    cc.easeElasticOut = function(period) {
      if (period && .3 !== period) return {
        _period: period,
        easing: function(dt) {
          return 0 === dt || 1 === dt ? dt : Math.pow(2, -10 * dt) * Math.sin((dt - this._period / 4) * Math.PI * 2 / this._period) + 1;
        },
        reverse: function() {
          return cc.easeElasticIn(this._period);
        }
      };
      return _easeElasticOutObj;
    };
    cc.easeElasticInOut = function(period) {
      period = period || .3;
      return {
        _period: period,
        easing: function(dt) {
          var newT = 0;
          var locPeriod = this._period;
          if (0 === dt || 1 === dt) newT = dt; else {
            dt *= 2;
            locPeriod || (locPeriod = this._period = .3 * 1.5);
            var s = locPeriod / 4;
            dt -= 1;
            newT = dt < 0 ? -.5 * Math.pow(2, 10 * dt) * Math.sin((dt - s) * Math.PI * 2 / locPeriod) : Math.pow(2, -10 * dt) * Math.sin((dt - s) * Math.PI * 2 / locPeriod) * .5 + 1;
          }
          return newT;
        },
        reverse: function() {
          return cc.easeElasticInOut(this._period);
        }
      };
    };
    function _bounceTime(time1) {
      if (time1 < 1 / 2.75) return 7.5625 * time1 * time1;
      if (time1 < 2 / 2.75) {
        time1 -= 1.5 / 2.75;
        return 7.5625 * time1 * time1 + .75;
      }
      if (time1 < 2.5 / 2.75) {
        time1 -= 2.25 / 2.75;
        return 7.5625 * time1 * time1 + .9375;
      }
      time1 -= 2.625 / 2.75;
      return 7.5625 * time1 * time1 + .984375;
    }
    var _easeBounceInObj = {
      easing: function(dt) {
        return 1 - _bounceTime(1 - dt);
      },
      reverse: function() {
        return _easeBounceOutObj;
      }
    };
    cc.easeBounceIn = function() {
      return _easeBounceInObj;
    };
    var _easeBounceOutObj = {
      easing: function(dt) {
        return _bounceTime(dt);
      },
      reverse: function() {
        return _easeBounceInObj;
      }
    };
    cc.easeBounceOut = function() {
      return _easeBounceOutObj;
    };
    var _easeBounceInOutObj = {
      easing: function(time1) {
        var newT;
        if (time1 < .5) {
          time1 *= 2;
          newT = .5 * (1 - _bounceTime(1 - time1));
        } else newT = .5 * _bounceTime(2 * time1 - 1) + .5;
        return newT;
      },
      reverse: function() {
        return _easeBounceInOutObj;
      }
    };
    cc.easeBounceInOut = function() {
      return _easeBounceInOutObj;
    };
    var _easeBackInObj = {
      easing: function(time1) {
        var overshoot = 1.70158;
        return 0 === time1 || 1 === time1 ? time1 : time1 * time1 * ((overshoot + 1) * time1 - overshoot);
      },
      reverse: function() {
        return _easeBackOutObj;
      }
    };
    cc.easeBackIn = function() {
      return _easeBackInObj;
    };
    var _easeBackOutObj = {
      easing: function(time1) {
        var overshoot = 1.70158;
        time1 -= 1;
        return time1 * time1 * ((overshoot + 1) * time1 + overshoot) + 1;
      },
      reverse: function() {
        return _easeBackInObj;
      }
    };
    cc.easeBackOut = function() {
      return _easeBackOutObj;
    };
    var _easeBackInOutObj = {
      easing: function(time1) {
        var overshoot = 2.5949095;
        time1 *= 2;
        if (time1 < 1) return time1 * time1 * ((overshoot + 1) * time1 - overshoot) / 2;
        time1 -= 2;
        return time1 * time1 * ((overshoot + 1) * time1 + overshoot) / 2 + 1;
      },
      reverse: function() {
        return _easeBackInOutObj;
      }
    };
    cc.easeBackInOut = function() {
      return _easeBackInOutObj;
    };
    cc.easeBezierAction = function(a, b, c, d) {
      return {
        easing: function(t) {
          return Math.pow(1 - t, 3) * a + 3 * t * Math.pow(1 - t, 2) * b + 3 * Math.pow(t, 2) * (1 - t) * c + Math.pow(t, 3) * d;
        },
        reverse: function() {
          return cc.easeBezierAction(d, c, b, a);
        }
      };
    };
    var _easeQuadraticActionIn = {
      easing: function(time) {
        return Math.pow(time, 2);
      },
      reverse: function() {
        return _easeQuadraticActionIn;
      }
    };
    cc.easeQuadraticActionIn = function() {
      return _easeQuadraticActionIn;
    };
    var _easeQuadraticActionOut = {
      easing: function(time) {
        return -time * (time - 2);
      },
      reverse: function() {
        return _easeQuadraticActionOut;
      }
    };
    cc.easeQuadraticActionOut = function() {
      return _easeQuadraticActionOut;
    };
    var _easeQuadraticActionInOut = {
      easing: function(time) {
        var resultTime = time;
        time *= 2;
        if (time < 1) resultTime = time * time * .5; else {
          --time;
          resultTime = -.5 * (time * (time - 2) - 1);
        }
        return resultTime;
      },
      reverse: function() {
        return _easeQuadraticActionInOut;
      }
    };
    cc.easeQuadraticActionInOut = function() {
      return _easeQuadraticActionInOut;
    };
    var _easeQuarticActionIn = {
      easing: function(time) {
        return time * time * time * time;
      },
      reverse: function() {
        return _easeQuarticActionIn;
      }
    };
    cc.easeQuarticActionIn = function() {
      return _easeQuarticActionIn;
    };
    var _easeQuarticActionOut = {
      easing: function(time) {
        time -= 1;
        return -(time * time * time * time - 1);
      },
      reverse: function() {
        return _easeQuarticActionOut;
      }
    };
    cc.easeQuarticActionOut = function() {
      return _easeQuarticActionOut;
    };
    var _easeQuarticActionInOut = {
      easing: function(time) {
        time *= 2;
        if (time < 1) return .5 * time * time * time * time;
        time -= 2;
        return -.5 * (time * time * time * time - 2);
      },
      reverse: function() {
        return _easeQuarticActionInOut;
      }
    };
    cc.easeQuarticActionInOut = function() {
      return _easeQuarticActionInOut;
    };
    var _easeQuinticActionIn = {
      easing: function(time) {
        return time * time * time * time * time;
      },
      reverse: function() {
        return _easeQuinticActionIn;
      }
    };
    cc.easeQuinticActionIn = function() {
      return _easeQuinticActionIn;
    };
    var _easeQuinticActionOut = {
      easing: function(time) {
        time -= 1;
        return time * time * time * time * time + 1;
      },
      reverse: function() {
        return _easeQuinticActionOut;
      }
    };
    cc.easeQuinticActionOut = function() {
      return _easeQuinticActionOut;
    };
    var _easeQuinticActionInOut = {
      easing: function(time) {
        time *= 2;
        if (time < 1) return .5 * time * time * time * time * time;
        time -= 2;
        return .5 * (time * time * time * time * time + 2);
      },
      reverse: function() {
        return _easeQuinticActionInOut;
      }
    };
    cc.easeQuinticActionInOut = function() {
      return _easeQuinticActionInOut;
    };
    var _easeCircleActionIn = {
      easing: function(time) {
        return -1 * (Math.sqrt(1 - time * time) - 1);
      },
      reverse: function() {
        return _easeCircleActionIn;
      }
    };
    cc.easeCircleActionIn = function() {
      return _easeCircleActionIn;
    };
    var _easeCircleActionOut = {
      easing: function(time) {
        time -= 1;
        return Math.sqrt(1 - time * time);
      },
      reverse: function() {
        return _easeCircleActionOut;
      }
    };
    cc.easeCircleActionOut = function() {
      return _easeCircleActionOut;
    };
    var _easeCircleActionInOut = {
      easing: function(time) {
        time *= 2;
        if (time < 1) return -.5 * (Math.sqrt(1 - time * time) - 1);
        time -= 2;
        return .5 * (Math.sqrt(1 - time * time) + 1);
      },
      reverse: function() {
        return _easeCircleActionInOut;
      }
    };
    cc.easeCircleActionInOut = function() {
      return _easeCircleActionInOut;
    };
    var _easeCubicActionIn = {
      easing: function(time) {
        return time * time * time;
      },
      reverse: function() {
        return _easeCubicActionIn;
      }
    };
    cc.easeCubicActionIn = function() {
      return _easeCubicActionIn;
    };
    var _easeCubicActionOut = {
      easing: function(time) {
        time -= 1;
        return time * time * time + 1;
      },
      reverse: function() {
        return _easeCubicActionOut;
      }
    };
    cc.easeCubicActionOut = function() {
      return _easeCubicActionOut;
    };
    var _easeCubicActionInOut = {
      easing: function(time) {
        time *= 2;
        if (time < 1) return .5 * time * time * time;
        time -= 2;
        return .5 * (time * time * time + 2);
      },
      reverse: function() {
        return _easeCubicActionInOut;
      }
    };
    cc.easeCubicActionInOut = function() {
      return _easeCubicActionInOut;
    };
  }), {} ],
  5: [ (function(require, module, exports) {
    cc.ActionInstant = cc.Class({
      name: "cc.ActionInstant",
      extends: cc.FiniteTimeAction,
      isDone: function() {
        return true;
      },
      step: function(dt) {
        this.update(1);
      },
      update: function(dt) {},
      reverse: function() {
        return this.clone();
      },
      clone: function() {
        return new cc.ActionInstant();
      }
    });
    cc.Show = cc.Class({
      name: "cc.Show",
      extends: cc.ActionInstant,
      update: function(dt) {
        var _renderComps = this.target.getComponentsInChildren(cc.RenderComponent);
        for (var i = 0; i < _renderComps.length; ++i) {
          var render = _renderComps[i];
          render.enabled = true;
        }
      },
      reverse: function() {
        return new cc.Hide();
      },
      clone: function() {
        return new cc.Show();
      }
    });
    cc.show = function() {
      return new cc.Show();
    };
    cc.Hide = cc.Class({
      name: "cc.Hide",
      extends: cc.ActionInstant,
      update: function(dt) {
        var _renderComps = this.target.getComponentsInChildren(cc.RenderComponent);
        for (var i = 0; i < _renderComps.length; ++i) {
          var render = _renderComps[i];
          render.enabled = false;
        }
      },
      reverse: function() {
        return new cc.Show();
      },
      clone: function() {
        return new cc.Hide();
      }
    });
    cc.hide = function() {
      return new cc.Hide();
    };
    cc.ToggleVisibility = cc.Class({
      name: "cc.ToggleVisibility",
      extends: cc.ActionInstant,
      update: function(dt) {
        var _renderComps = this.target.getComponentsInChildren(cc.RenderComponent);
        for (var i = 0; i < _renderComps.length; ++i) {
          var render = _renderComps[i];
          render.enabled = !render.enabled;
        }
      },
      reverse: function() {
        return new cc.ToggleVisibility();
      },
      clone: function() {
        return new cc.ToggleVisibility();
      }
    });
    cc.toggleVisibility = function() {
      return new cc.ToggleVisibility();
    };
    cc.RemoveSelf = cc.Class({
      name: "cc.RemoveSelf",
      extends: cc.ActionInstant,
      ctor: function(isNeedCleanUp) {
        this._isNeedCleanUp = true;
        void 0 !== isNeedCleanUp && this.init(isNeedCleanUp);
      },
      update: function(dt) {
        this.target.removeFromParent(this._isNeedCleanUp);
      },
      init: function(isNeedCleanUp) {
        this._isNeedCleanUp = isNeedCleanUp;
        return true;
      },
      reverse: function() {
        return new cc.RemoveSelf(this._isNeedCleanUp);
      },
      clone: function() {
        return new cc.RemoveSelf(this._isNeedCleanUp);
      }
    });
    cc.removeSelf = function(isNeedCleanUp) {
      return new cc.RemoveSelf(isNeedCleanUp);
    };
    cc.FlipX = cc.Class({
      name: "cc.FlipX",
      extends: cc.ActionInstant,
      ctor: function(flip) {
        this._flippedX = false;
        void 0 !== flip && this.initWithFlipX(flip);
      },
      initWithFlipX: function(flip) {
        this._flippedX = flip;
        return true;
      },
      update: function(dt) {
        this.target.scaleX = Math.abs(this.target.scaleX) * (this._flippedX ? -1 : 1);
      },
      reverse: function() {
        return new cc.FlipX(!this._flippedX);
      },
      clone: function() {
        var action = new cc.FlipX();
        action.initWithFlipX(this._flippedX);
        return action;
      }
    });
    cc.flipX = function(flip) {
      return new cc.FlipX(flip);
    };
    cc.FlipY = cc.Class({
      name: "cc.FlipY",
      extends: cc.ActionInstant,
      ctor: function(flip) {
        this._flippedY = false;
        void 0 !== flip && this.initWithFlipY(flip);
      },
      initWithFlipY: function(flip) {
        this._flippedY = flip;
        return true;
      },
      update: function(dt) {
        this.target.scaleY = Math.abs(this.target.scaleY) * (this._flippedY ? -1 : 1);
      },
      reverse: function() {
        return new cc.FlipY(!this._flippedY);
      },
      clone: function() {
        var action = new cc.FlipY();
        action.initWithFlipY(this._flippedY);
        return action;
      }
    });
    cc.flipY = function(flip) {
      return new cc.FlipY(flip);
    };
    cc.Place = cc.Class({
      name: "cc.Place",
      extends: cc.ActionInstant,
      ctor: function(pos, y) {
        this._x = 0;
        this._y = 0;
        if (void 0 !== pos) {
          if (void 0 !== pos.x) {
            y = pos.y;
            pos = pos.x;
          }
          this.initWithPosition(pos, y);
        }
      },
      initWithPosition: function(x, y) {
        this._x = x;
        this._y = y;
        return true;
      },
      update: function(dt) {
        this.target.setPosition(this._x, this._y);
      },
      clone: function() {
        var action = new cc.Place();
        action.initWithPosition(this._x, this._y);
        return action;
      }
    });
    cc.place = function(pos, y) {
      return new cc.Place(pos, y);
    };
    cc.CallFunc = cc.Class({
      name: "cc.CallFunc",
      extends: cc.ActionInstant,
      ctor: function(selector, selectorTarget, data) {
        this._selectorTarget = null;
        this._function = null;
        this._data = null;
        this.initWithFunction(selector, selectorTarget, data);
      },
      initWithFunction: function(selector, selectorTarget, data) {
        selector && (this._function = selector);
        selectorTarget && (this._selectorTarget = selectorTarget);
        void 0 !== data && (this._data = data);
        return true;
      },
      execute: function() {
        this._function && this._function.call(this._selectorTarget, this.target, this._data);
      },
      update: function(dt) {
        this.execute();
      },
      getTargetCallback: function() {
        return this._selectorTarget;
      },
      setTargetCallback: function(sel) {
        if (sel !== this._selectorTarget) {
          this._selectorTarget && (this._selectorTarget = null);
          this._selectorTarget = sel;
        }
      },
      clone: function() {
        var action = new cc.CallFunc();
        action.initWithFunction(this._function, this._selectorTarget, this._data);
        return action;
      }
    });
    cc.callFunc = function(selector, selectorTarget, data) {
      return new cc.CallFunc(selector, selectorTarget, data);
    };
  }), {} ],
  6: [ (function(require, module, exports) {
    cc.ActionInterval = cc.Class({
      name: "cc.ActionInterval",
      extends: cc.FiniteTimeAction,
      ctor: function(d) {
        this.MAX_VALUE = 2;
        this._elapsed = 0;
        this._firstTick = false;
        this._easeList = null;
        this._speed = 1;
        this._timesForRepeat = 1;
        this._repeatForever = false;
        this._repeatMethod = false;
        this._speedMethod = false;
        void 0 !== d && cc.ActionInterval.prototype.initWithDuration.call(this, d);
      },
      getElapsed: function() {
        return this._elapsed;
      },
      initWithDuration: function(d) {
        this._duration = 0 === d ? cc.macro.FLT_EPSILON : d;
        this._elapsed = 0;
        this._firstTick = true;
        return true;
      },
      isDone: function() {
        return this._elapsed >= this._duration;
      },
      _cloneDecoration: function(action) {
        action._repeatForever = this._repeatForever;
        action._speed = this._speed;
        action._timesForRepeat = this._timesForRepeat;
        action._easeList = this._easeList;
        action._speedMethod = this._speedMethod;
        action._repeatMethod = this._repeatMethod;
      },
      _reverseEaseList: function(action) {
        if (this._easeList) {
          action._easeList = [];
          for (var i = 0; i < this._easeList.length; i++) action._easeList.push(this._easeList[i].reverse());
        }
      },
      clone: function() {
        var action = new cc.ActionInterval(this._duration);
        this._cloneDecoration(action);
        return action;
      },
      easing: function(easeObj) {
        this._easeList ? this._easeList.length = 0 : this._easeList = [];
        for (var i = 0; i < arguments.length; i++) this._easeList.push(arguments[i]);
        return this;
      },
      _computeEaseTime: function(dt) {
        var locList = this._easeList;
        if (!locList || 0 === locList.length) return dt;
        for (var i = 0, n = locList.length; i < n; i++) dt = locList[i].easing(dt);
        return dt;
      },
      step: function(dt) {
        if (this._firstTick) {
          this._firstTick = false;
          this._elapsed = 0;
        } else this._elapsed += dt;
        var t = this._elapsed / (this._duration > 1.192092896e-7 ? this._duration : 1.192092896e-7);
        t = 1 > t ? t : 1;
        this.update(t > 0 ? t : 0);
        if (this._repeatMethod && this._timesForRepeat > 1 && this.isDone()) {
          this._repeatForever || this._timesForRepeat--;
          this.startWithTarget(this.target);
          this.step(this._elapsed - this._duration);
        }
      },
      startWithTarget: function(target) {
        cc.Action.prototype.startWithTarget.call(this, target);
        this._elapsed = 0;
        this._firstTick = true;
      },
      reverse: function() {
        cc.logID(1010);
        return null;
      },
      setAmplitudeRate: function(amp) {
        cc.logID(1011);
      },
      getAmplitudeRate: function() {
        cc.logID(1012);
        return 0;
      },
      speed: function(speed) {
        if (speed <= 0) {
          cc.logID(1013);
          return this;
        }
        this._speedMethod = true;
        this._speed *= speed;
        return this;
      },
      getSpeed: function() {
        return this._speed;
      },
      setSpeed: function(speed) {
        this._speed = speed;
        return this;
      },
      repeat: function(times) {
        times = Math.round(times);
        if (isNaN(times) || times < 1) {
          cc.logID(1014);
          return this;
        }
        this._repeatMethod = true;
        this._timesForRepeat *= times;
        return this;
      },
      repeatForever: function() {
        this._repeatMethod = true;
        this._timesForRepeat = this.MAX_VALUE;
        this._repeatForever = true;
        return this;
      }
    });
    cc.actionInterval = function(d) {
      return new cc.ActionInterval(d);
    };
    cc.Sequence = cc.Class({
      name: "cc.Sequence",
      extends: cc.ActionInterval,
      ctor: function(tempArray) {
        this._actions = [];
        this._split = null;
        this._last = 0;
        this._reversed = false;
        var paramArray = tempArray instanceof Array ? tempArray : arguments;
        if (1 === paramArray.length) {
          cc.errorID(1019);
          return;
        }
        var last = paramArray.length - 1;
        last >= 0 && null == paramArray[last] && cc.logID(1015);
        if (last >= 0) {
          var prev = paramArray[0], action1;
          for (var i = 1; i < last; i++) if (paramArray[i]) {
            action1 = prev;
            prev = cc.Sequence._actionOneTwo(action1, paramArray[i]);
          }
          this.initWithTwoActions(prev, paramArray[last]);
        }
      },
      initWithTwoActions: function(actionOne, actionTwo) {
        if (!actionOne || !actionTwo) {
          cc.errorID(1025);
          return false;
        }
        var durationOne = actionOne._duration, durationTwo = actionTwo._duration;
        durationOne *= actionOne._repeatMethod ? actionOne._timesForRepeat : 1;
        durationTwo *= actionTwo._repeatMethod ? actionTwo._timesForRepeat : 1;
        var d = durationOne + durationTwo;
        this.initWithDuration(d);
        this._actions[0] = actionOne;
        this._actions[1] = actionTwo;
        return true;
      },
      clone: function() {
        var action = new cc.Sequence();
        this._cloneDecoration(action);
        action.initWithTwoActions(this._actions[0].clone(), this._actions[1].clone());
        return action;
      },
      startWithTarget: function(target) {
        cc.ActionInterval.prototype.startWithTarget.call(this, target);
        this._split = this._actions[0]._duration / this._duration;
        this._split *= this._actions[0]._repeatMethod ? this._actions[0]._timesForRepeat : 1;
        this._last = -1;
      },
      stop: function() {
        -1 !== this._last && this._actions[this._last].stop();
        cc.Action.prototype.stop.call(this);
      },
      update: function(dt) {
        var new_t, found = 0;
        var locSplit = this._split, locActions = this._actions, locLast = this._last, actionFound;
        dt = this._computeEaseTime(dt);
        if (dt < locSplit) {
          new_t = 0 !== locSplit ? dt / locSplit : 1;
          if (0 === found && 1 === locLast && this._reversed) {
            locActions[1].update(0);
            locActions[1].stop();
          }
        } else {
          found = 1;
          new_t = 1 === locSplit ? 1 : (dt - locSplit) / (1 - locSplit);
          if (-1 === locLast) {
            locActions[0].startWithTarget(this.target);
            locActions[0].update(1);
            locActions[0].stop();
          }
          if (0 === locLast) {
            locActions[0].update(1);
            locActions[0].stop();
          }
        }
        actionFound = locActions[found];
        if (locLast === found && actionFound.isDone()) return;
        locLast !== found && actionFound.startWithTarget(this.target);
        new_t *= actionFound._timesForRepeat;
        actionFound.update(new_t > 1 ? new_t % 1 : new_t);
        this._last = found;
      },
      reverse: function() {
        var action = cc.Sequence._actionOneTwo(this._actions[1].reverse(), this._actions[0].reverse());
        this._cloneDecoration(action);
        this._reverseEaseList(action);
        action._reversed = true;
        return action;
      }
    });
    cc.sequence = function(tempArray) {
      var paramArray = tempArray instanceof Array ? tempArray : arguments;
      if (1 === paramArray.length) {
        cc.errorID(1019);
        return null;
      }
      var last = paramArray.length - 1;
      last >= 0 && null == paramArray[last] && cc.logID(1015);
      var result = null;
      if (last >= 0) {
        result = paramArray[0];
        for (var i = 1; i <= last; i++) paramArray[i] && (result = cc.Sequence._actionOneTwo(result, paramArray[i]));
      }
      return result;
    };
    cc.Sequence._actionOneTwo = function(actionOne, actionTwo) {
      var sequence = new cc.Sequence();
      sequence.initWithTwoActions(actionOne, actionTwo);
      return sequence;
    };
    cc.Repeat = cc.Class({
      name: "cc.Repeat",
      extends: cc.ActionInterval,
      ctor: function(action, times) {
        this._times = 0;
        this._total = 0;
        this._nextDt = 0;
        this._actionInstant = false;
        this._innerAction = null;
        void 0 !== times && this.initWithAction(action, times);
      },
      initWithAction: function(action, times) {
        var duration = action._duration * times;
        if (this.initWithDuration(duration)) {
          this._times = times;
          this._innerAction = action;
          if (action instanceof cc.ActionInstant) {
            this._actionInstant = true;
            this._times -= 1;
          }
          this._total = 0;
          return true;
        }
        return false;
      },
      clone: function() {
        var action = new cc.Repeat();
        this._cloneDecoration(action);
        action.initWithAction(this._innerAction.clone(), this._times);
        return action;
      },
      startWithTarget: function(target) {
        this._total = 0;
        this._nextDt = this._innerAction._duration / this._duration;
        cc.ActionInterval.prototype.startWithTarget.call(this, target);
        this._innerAction.startWithTarget(target);
      },
      stop: function() {
        this._innerAction.stop();
        cc.Action.prototype.stop.call(this);
      },
      update: function(dt) {
        dt = this._computeEaseTime(dt);
        var locInnerAction = this._innerAction;
        var locDuration = this._duration;
        var locTimes = this._times;
        var locNextDt = this._nextDt;
        if (dt >= locNextDt) {
          while (dt > locNextDt && this._total < locTimes) {
            locInnerAction.update(1);
            this._total++;
            locInnerAction.stop();
            locInnerAction.startWithTarget(this.target);
            locNextDt += locInnerAction._duration / locDuration;
            this._nextDt = locNextDt > 1 ? 1 : locNextDt;
          }
          if (dt >= 1 && this._total < locTimes) {
            locInnerAction.update(1);
            this._total++;
          }
          this._actionInstant || (this._total === locTimes ? locInnerAction.stop() : locInnerAction.update(dt - (locNextDt - locInnerAction._duration / locDuration)));
        } else locInnerAction.update(dt * locTimes % 1);
      },
      isDone: function() {
        return this._total === this._times;
      },
      reverse: function() {
        var action = new cc.Repeat(this._innerAction.reverse(), this._times);
        this._cloneDecoration(action);
        this._reverseEaseList(action);
        return action;
      },
      setInnerAction: function(action) {
        this._innerAction !== action && (this._innerAction = action);
      },
      getInnerAction: function() {
        return this._innerAction;
      }
    });
    cc.repeat = function(action, times) {
      return new cc.Repeat(action, times);
    };
    cc.RepeatForever = cc.Class({
      name: "cc.RepeatForever",
      extends: cc.ActionInterval,
      ctor: function(action) {
        this._innerAction = null;
        action && this.initWithAction(action);
      },
      initWithAction: function(action) {
        if (!action) {
          cc.errorID(1026);
          return false;
        }
        this._innerAction = action;
        return true;
      },
      clone: function() {
        var action = new cc.RepeatForever();
        this._cloneDecoration(action);
        action.initWithAction(this._innerAction.clone());
        return action;
      },
      startWithTarget: function(target) {
        cc.ActionInterval.prototype.startWithTarget.call(this, target);
        this._innerAction.startWithTarget(target);
      },
      step: function(dt) {
        var locInnerAction = this._innerAction;
        locInnerAction.step(dt);
        if (locInnerAction.isDone()) {
          locInnerAction.startWithTarget(this.target);
          locInnerAction.step(locInnerAction.getElapsed() - locInnerAction._duration);
        }
      },
      isDone: function() {
        return false;
      },
      reverse: function() {
        var action = new cc.RepeatForever(this._innerAction.reverse());
        this._cloneDecoration(action);
        this._reverseEaseList(action);
        return action;
      },
      setInnerAction: function(action) {
        this._innerAction !== action && (this._innerAction = action);
      },
      getInnerAction: function() {
        return this._innerAction;
      }
    });
    cc.repeatForever = function(action) {
      return new cc.RepeatForever(action);
    };
    cc.Spawn = cc.Class({
      name: "cc.Spawn",
      extends: cc.ActionInterval,
      ctor: function(tempArray) {
        this._one = null;
        this._two = null;
        var paramArray = tempArray instanceof Array ? tempArray : arguments;
        if (1 === paramArray.length) {
          cc.errorID(1020);
          return;
        }
        var last = paramArray.length - 1;
        last >= 0 && null == paramArray[last] && cc.logID(1015);
        if (last >= 0) {
          var prev = paramArray[0], action1;
          for (var i = 1; i < last; i++) if (paramArray[i]) {
            action1 = prev;
            prev = cc.Spawn._actionOneTwo(action1, paramArray[i]);
          }
          this.initWithTwoActions(prev, paramArray[last]);
        }
      },
      initWithTwoActions: function(action1, action2) {
        if (!action1 || !action2) {
          cc.errorID(1027);
          return false;
        }
        var ret = false;
        var d1 = action1._duration;
        var d2 = action2._duration;
        if (this.initWithDuration(Math.max(d1, d2))) {
          this._one = action1;
          this._two = action2;
          d1 > d2 ? this._two = cc.Sequence._actionOneTwo(action2, cc.delayTime(d1 - d2)) : d1 < d2 && (this._one = cc.Sequence._actionOneTwo(action1, cc.delayTime(d2 - d1)));
          ret = true;
        }
        return ret;
      },
      clone: function() {
        var action = new cc.Spawn();
        this._cloneDecoration(action);
        action.initWithTwoActions(this._one.clone(), this._two.clone());
        return action;
      },
      startWithTarget: function(target) {
        cc.ActionInterval.prototype.startWithTarget.call(this, target);
        this._one.startWithTarget(target);
        this._two.startWithTarget(target);
      },
      stop: function() {
        this._one.stop();
        this._two.stop();
        cc.Action.prototype.stop.call(this);
      },
      update: function(dt) {
        dt = this._computeEaseTime(dt);
        this._one && this._one.update(dt);
        this._two && this._two.update(dt);
      },
      reverse: function() {
        var action = cc.Spawn._actionOneTwo(this._one.reverse(), this._two.reverse());
        this._cloneDecoration(action);
        this._reverseEaseList(action);
        return action;
      }
    });
    cc.spawn = function(tempArray) {
      var paramArray = tempArray instanceof Array ? tempArray : arguments;
      if (1 === paramArray.length) {
        cc.errorID(1020);
        return null;
      }
      paramArray.length > 0 && null == paramArray[paramArray.length - 1] && cc.logID(1015);
      var prev = paramArray[0];
      for (var i = 1; i < paramArray.length; i++) null != paramArray[i] && (prev = cc.Spawn._actionOneTwo(prev, paramArray[i]));
      return prev;
    };
    cc.Spawn._actionOneTwo = function(action1, action2) {
      var pSpawn = new cc.Spawn();
      pSpawn.initWithTwoActions(action1, action2);
      return pSpawn;
    };
    cc.RotateTo = cc.Class({
      name: "cc.RotateTo",
      extends: cc.ActionInterval,
      ctor: function(duration, deltaAngleX, deltaAngleY) {
        this._dstAngleX = 0;
        this._startAngleX = 0;
        this._diffAngleX = 0;
        this._dstAngleY = 0;
        this._startAngleY = 0;
        this._diffAngleY = 0;
        void 0 !== deltaAngleX && this.initWithDuration(duration, deltaAngleX, deltaAngleY);
      },
      initWithDuration: function(duration, deltaAngleX, deltaAngleY) {
        if (cc.ActionInterval.prototype.initWithDuration.call(this, duration)) {
          this._dstAngleX = deltaAngleX || 0;
          this._dstAngleY = void 0 !== deltaAngleY ? deltaAngleY : this._dstAngleX;
          return true;
        }
        return false;
      },
      clone: function() {
        var action = new cc.RotateTo();
        this._cloneDecoration(action);
        action.initWithDuration(this._duration, this._dstAngleX, this._dstAngleY);
        return action;
      },
      startWithTarget: function(target) {
        cc.ActionInterval.prototype.startWithTarget.call(this, target);
        var locStartAngleX = target.rotationX % 360;
        var locDiffAngleX = this._dstAngleX - locStartAngleX;
        locDiffAngleX > 180 && (locDiffAngleX -= 360);
        locDiffAngleX < -180 && (locDiffAngleX += 360);
        this._startAngleX = locStartAngleX;
        this._diffAngleX = locDiffAngleX;
        this._startAngleY = target.rotationY % 360;
        var locDiffAngleY = this._dstAngleY - this._startAngleY;
        locDiffAngleY > 180 && (locDiffAngleY -= 360);
        locDiffAngleY < -180 && (locDiffAngleY += 360);
        this._diffAngleY = locDiffAngleY;
      },
      reverse: function() {
        cc.logID(1016);
      },
      update: function(dt) {
        dt = this._computeEaseTime(dt);
        if (this.target) {
          this.target.rotationX = this._startAngleX + this._diffAngleX * dt;
          this.target.rotationY = this._startAngleY + this._diffAngleY * dt;
        }
      }
    });
    cc.rotateTo = function(duration, deltaAngleX, deltaAngleY) {
      return new cc.RotateTo(duration, deltaAngleX, deltaAngleY);
    };
    cc.RotateBy = cc.Class({
      name: "cc.RotateBy",
      extends: cc.ActionInterval,
      ctor: function(duration, deltaAngleX, deltaAngleY) {
        this._angleX = 0;
        this._startAngleX = 0;
        this._angleY = 0;
        this._startAngleY = 0;
        void 0 !== deltaAngleX && this.initWithDuration(duration, deltaAngleX, deltaAngleY);
      },
      initWithDuration: function(duration, deltaAngleX, deltaAngleY) {
        if (cc.ActionInterval.prototype.initWithDuration.call(this, duration)) {
          this._angleX = deltaAngleX || 0;
          this._angleY = void 0 !== deltaAngleY ? deltaAngleY : this._angleX;
          return true;
        }
        return false;
      },
      clone: function() {
        var action = new cc.RotateBy();
        this._cloneDecoration(action);
        action.initWithDuration(this._duration, this._angleX, this._angleY);
        return action;
      },
      startWithTarget: function(target) {
        cc.ActionInterval.prototype.startWithTarget.call(this, target);
        this._startAngleX = target.rotationX;
        this._startAngleY = target.rotationY;
      },
      update: function(dt) {
        dt = this._computeEaseTime(dt);
        if (this.target) {
          this.target.rotationX = this._startAngleX + this._angleX * dt;
          this.target.rotationY = this._startAngleY + this._angleY * dt;
        }
      },
      reverse: function() {
        var action = new cc.RotateBy(this._duration, -this._angleX, -this._angleY);
        this._cloneDecoration(action);
        this._reverseEaseList(action);
        return action;
      }
    });
    cc.rotateBy = function(duration, deltaAngleX, deltaAngleY) {
      return new cc.RotateBy(duration, deltaAngleX, deltaAngleY);
    };
    cc.MoveBy = cc.Class({
      name: "cc.MoveBy",
      extends: cc.ActionInterval,
      ctor: function(duration, deltaPos, deltaY) {
        this._positionDelta = cc.v2(0, 0);
        this._startPosition = cc.v2(0, 0);
        this._previousPosition = cc.v2(0, 0);
        void 0 !== deltaPos && cc.MoveBy.prototype.initWithDuration.call(this, duration, deltaPos, deltaY);
      },
      initWithDuration: function(duration, position, y) {
        if (cc.ActionInterval.prototype.initWithDuration.call(this, duration)) {
          if (void 0 !== position.x) {
            y = position.y;
            position = position.x;
          }
          this._positionDelta.x = position;
          this._positionDelta.y = y;
          return true;
        }
        return false;
      },
      clone: function() {
        var action = new cc.MoveBy();
        this._cloneDecoration(action);
        action.initWithDuration(this._duration, this._positionDelta);
        return action;
      },
      startWithTarget: function(target) {
        cc.ActionInterval.prototype.startWithTarget.call(this, target);
        var locPosX = target.x;
        var locPosY = target.y;
        this._previousPosition.x = locPosX;
        this._previousPosition.y = locPosY;
        this._startPosition.x = locPosX;
        this._startPosition.y = locPosY;
      },
      update: function(dt) {
        dt = this._computeEaseTime(dt);
        if (this.target) {
          var x = this._positionDelta.x * dt;
          var y = this._positionDelta.y * dt;
          var locStartPosition = this._startPosition;
          if (cc.macro.ENABLE_STACKABLE_ACTIONS) {
            var targetX = this.target.x;
            var targetY = this.target.y;
            var locPreviousPosition = this._previousPosition;
            locStartPosition.x = locStartPosition.x + targetX - locPreviousPosition.x;
            locStartPosition.y = locStartPosition.y + targetY - locPreviousPosition.y;
            x += locStartPosition.x;
            y += locStartPosition.y;
            locPreviousPosition.x = x;
            locPreviousPosition.y = y;
            this.target.setPosition(x, y);
          } else this.target.setPosition(locStartPosition.x + x, locStartPosition.y + y);
        }
      },
      reverse: function() {
        var action = new cc.MoveBy(this._duration, cc.v2(-this._positionDelta.x, -this._positionDelta.y));
        this._cloneDecoration(action);
        this._reverseEaseList(action);
        return action;
      }
    });
    cc.moveBy = function(duration, deltaPos, deltaY) {
      return new cc.MoveBy(duration, deltaPos, deltaY);
    };
    cc.MoveTo = cc.Class({
      name: "cc.MoveTo",
      extends: cc.MoveBy,
      ctor: function(duration, position, y) {
        this._endPosition = cc.v2(0, 0);
        void 0 !== position && this.initWithDuration(duration, position, y);
      },
      initWithDuration: function(duration, position, y) {
        if (cc.MoveBy.prototype.initWithDuration.call(this, duration, position, y)) {
          if (void 0 !== position.x) {
            y = position.y;
            position = position.x;
          }
          this._endPosition.x = position;
          this._endPosition.y = y;
          return true;
        }
        return false;
      },
      clone: function() {
        var action = new cc.MoveTo();
        this._cloneDecoration(action);
        action.initWithDuration(this._duration, this._endPosition);
        return action;
      },
      startWithTarget: function(target) {
        cc.MoveBy.prototype.startWithTarget.call(this, target);
        this._positionDelta.x = this._endPosition.x - target.x;
        this._positionDelta.y = this._endPosition.y - target.y;
      }
    });
    cc.moveTo = function(duration, position, y) {
      return new cc.MoveTo(duration, position, y);
    };
    cc.SkewTo = cc.Class({
      name: "cc.SkewTo",
      extends: cc.ActionInterval,
      ctor: function(t, sx, sy) {
        this._skewX = 0;
        this._skewY = 0;
        this._startSkewX = 0;
        this._startSkewY = 0;
        this._endSkewX = 0;
        this._endSkewY = 0;
        this._deltaX = 0;
        this._deltaY = 0;
        void 0 !== sy && cc.SkewTo.prototype.initWithDuration.call(this, t, sx, sy);
      },
      initWithDuration: function(t, sx, sy) {
        var ret = false;
        if (cc.ActionInterval.prototype.initWithDuration.call(this, t)) {
          this._endSkewX = sx;
          this._endSkewY = sy;
          ret = true;
        }
        return ret;
      },
      clone: function() {
        var action = new cc.SkewTo();
        this._cloneDecoration(action);
        action.initWithDuration(this._duration, this._endSkewX, this._endSkewY);
        return action;
      },
      startWithTarget: function(target) {
        cc.ActionInterval.prototype.startWithTarget.call(this, target);
        this._startSkewX = target.skewX % 180;
        this._deltaX = this._endSkewX - this._startSkewX;
        this._deltaX > 180 && (this._deltaX -= 360);
        this._deltaX < -180 && (this._deltaX += 360);
        this._startSkewY = target.skewY % 360;
        this._deltaY = this._endSkewY - this._startSkewY;
        this._deltaY > 180 && (this._deltaY -= 360);
        this._deltaY < -180 && (this._deltaY += 360);
      },
      update: function(dt) {
        dt = this._computeEaseTime(dt);
        this.target.skewX = this._startSkewX + this._deltaX * dt;
        this.target.skewY = this._startSkewY + this._deltaY * dt;
      }
    });
    cc.skewTo = function(t, sx, sy) {
      return new cc.SkewTo(t, sx, sy);
    };
    cc.SkewBy = cc.Class({
      name: "cc.SkewBy",
      extends: cc.SkewTo,
      ctor: function(t, sx, sy) {
        void 0 !== sy && this.initWithDuration(t, sx, sy);
      },
      initWithDuration: function(t, deltaSkewX, deltaSkewY) {
        var ret = false;
        if (cc.SkewTo.prototype.initWithDuration.call(this, t, deltaSkewX, deltaSkewY)) {
          this._skewX = deltaSkewX;
          this._skewY = deltaSkewY;
          ret = true;
        }
        return ret;
      },
      clone: function() {
        var action = new cc.SkewBy();
        this._cloneDecoration(action);
        action.initWithDuration(this._duration, this._skewX, this._skewY);
        return action;
      },
      startWithTarget: function(target) {
        cc.SkewTo.prototype.startWithTarget.call(this, target);
        this._deltaX = this._skewX;
        this._deltaY = this._skewY;
        this._endSkewX = this._startSkewX + this._deltaX;
        this._endSkewY = this._startSkewY + this._deltaY;
      },
      reverse: function() {
        var action = new cc.SkewBy(this._duration, -this._skewX, -this._skewY);
        this._cloneDecoration(action);
        this._reverseEaseList(action);
        return action;
      }
    });
    cc.skewBy = function(t, sx, sy) {
      return new cc.SkewBy(t, sx, sy);
    };
    cc.JumpBy = cc.Class({
      name: "cc.JumpBy",
      extends: cc.ActionInterval,
      ctor: function(duration, position, y, height, jumps) {
        this._startPosition = cc.v2(0, 0);
        this._previousPosition = cc.v2(0, 0);
        this._delta = cc.v2(0, 0);
        this._height = 0;
        this._jumps = 0;
        void 0 !== height && cc.JumpBy.prototype.initWithDuration.call(this, duration, position, y, height, jumps);
      },
      initWithDuration: function(duration, position, y, height, jumps) {
        if (cc.ActionInterval.prototype.initWithDuration.call(this, duration)) {
          if (void 0 === jumps) {
            jumps = height;
            height = y;
            y = position.y;
            position = position.x;
          }
          this._delta.x = position;
          this._delta.y = y;
          this._height = height;
          this._jumps = jumps;
          return true;
        }
        return false;
      },
      clone: function() {
        var action = new cc.JumpBy();
        this._cloneDecoration(action);
        action.initWithDuration(this._duration, this._delta, this._height, this._jumps);
        return action;
      },
      startWithTarget: function(target) {
        cc.ActionInterval.prototype.startWithTarget.call(this, target);
        var locPosX = target.x;
        var locPosY = target.y;
        this._previousPosition.x = locPosX;
        this._previousPosition.y = locPosY;
        this._startPosition.x = locPosX;
        this._startPosition.y = locPosY;
      },
      update: function(dt) {
        dt = this._computeEaseTime(dt);
        if (this.target) {
          var frac = dt * this._jumps % 1;
          var y = 4 * this._height * frac * (1 - frac);
          y += this._delta.y * dt;
          var x = this._delta.x * dt;
          var locStartPosition = this._startPosition;
          if (cc.macro.ENABLE_STACKABLE_ACTIONS) {
            var targetX = this.target.x;
            var targetY = this.target.y;
            var locPreviousPosition = this._previousPosition;
            locStartPosition.x = locStartPosition.x + targetX - locPreviousPosition.x;
            locStartPosition.y = locStartPosition.y + targetY - locPreviousPosition.y;
            x += locStartPosition.x;
            y += locStartPosition.y;
            locPreviousPosition.x = x;
            locPreviousPosition.y = y;
            this.target.setPosition(x, y);
          } else this.target.setPosition(locStartPosition.x + x, locStartPosition.y + y);
        }
      },
      reverse: function() {
        var action = new cc.JumpBy(this._duration, cc.v2(-this._delta.x, -this._delta.y), this._height, this._jumps);
        this._cloneDecoration(action);
        this._reverseEaseList(action);
        return action;
      }
    });
    cc.jumpBy = function(duration, position, y, height, jumps) {
      return new cc.JumpBy(duration, position, y, height, jumps);
    };
    cc.JumpTo = cc.Class({
      name: "cc.JumpTo",
      extends: cc.JumpBy,
      ctor: function(duration, position, y, height, jumps) {
        this._endPosition = cc.v2(0, 0);
        void 0 !== height && this.initWithDuration(duration, position, y, height, jumps);
      },
      initWithDuration: function(duration, position, y, height, jumps) {
        if (cc.JumpBy.prototype.initWithDuration.call(this, duration, position, y, height, jumps)) {
          if (void 0 === jumps) {
            y = position.y;
            position = position.x;
          }
          this._endPosition.x = position;
          this._endPosition.y = y;
          return true;
        }
        return false;
      },
      startWithTarget: function(target) {
        cc.JumpBy.prototype.startWithTarget.call(this, target);
        this._delta.x = this._endPosition.x - this._startPosition.x;
        this._delta.y = this._endPosition.y - this._startPosition.y;
      },
      clone: function() {
        var action = new cc.JumpTo();
        this._cloneDecoration(action);
        action.initWithDuration(this._duration, this._endPosition, this._height, this._jumps);
        return action;
      }
    });
    cc.jumpTo = function(duration, position, y, height, jumps) {
      return new cc.JumpTo(duration, position, y, height, jumps);
    };
    function bezierAt(a, b, c, d, t) {
      return Math.pow(1 - t, 3) * a + 3 * t * Math.pow(1 - t, 2) * b + 3 * Math.pow(t, 2) * (1 - t) * c + Math.pow(t, 3) * d;
    }
    cc.BezierBy = cc.Class({
      name: "cc.BezierBy",
      extends: cc.ActionInterval,
      ctor: function(t, c) {
        this._config = [];
        this._startPosition = cc.v2(0, 0);
        this._previousPosition = cc.v2(0, 0);
        c && cc.BezierBy.prototype.initWithDuration.call(this, t, c);
      },
      initWithDuration: function(t, c) {
        if (cc.ActionInterval.prototype.initWithDuration.call(this, t)) {
          this._config = c;
          return true;
        }
        return false;
      },
      clone: function() {
        var action = new cc.BezierBy();
        this._cloneDecoration(action);
        var newConfigs = [];
        for (var i = 0; i < this._config.length; i++) {
          var selConf = this._config[i];
          newConfigs.push(cc.v2(selConf.x, selConf.y));
        }
        action.initWithDuration(this._duration, newConfigs);
        return action;
      },
      startWithTarget: function(target) {
        cc.ActionInterval.prototype.startWithTarget.call(this, target);
        var locPosX = target.x;
        var locPosY = target.y;
        this._previousPosition.x = locPosX;
        this._previousPosition.y = locPosY;
        this._startPosition.x = locPosX;
        this._startPosition.y = locPosY;
      },
      update: function(dt) {
        dt = this._computeEaseTime(dt);
        if (this.target) {
          var locConfig = this._config;
          var xa = 0;
          var xb = locConfig[0].x;
          var xc = locConfig[1].x;
          var xd = locConfig[2].x;
          var ya = 0;
          var yb = locConfig[0].y;
          var yc = locConfig[1].y;
          var yd = locConfig[2].y;
          var x = bezierAt(xa, xb, xc, xd, dt);
          var y = bezierAt(ya, yb, yc, yd, dt);
          var locStartPosition = this._startPosition;
          if (cc.macro.ENABLE_STACKABLE_ACTIONS) {
            var targetX = this.target.x;
            var targetY = this.target.y;
            var locPreviousPosition = this._previousPosition;
            locStartPosition.x = locStartPosition.x + targetX - locPreviousPosition.x;
            locStartPosition.y = locStartPosition.y + targetY - locPreviousPosition.y;
            x += locStartPosition.x;
            y += locStartPosition.y;
            locPreviousPosition.x = x;
            locPreviousPosition.y = y;
            this.target.setPosition(x, y);
          } else this.target.setPosition(locStartPosition.x + x, locStartPosition.y + y);
        }
      },
      reverse: function() {
        var locConfig = this._config;
        var x0 = locConfig[0].x, y0 = locConfig[0].y;
        var x1 = locConfig[1].x, y1 = locConfig[1].y;
        var x2 = locConfig[2].x, y2 = locConfig[2].y;
        var r = [ cc.v2(x1 - x2, y1 - y2), cc.v2(x0 - x2, y0 - y2), cc.v2(-x2, -y2) ];
        var action = new cc.BezierBy(this._duration, r);
        this._cloneDecoration(action);
        this._reverseEaseList(action);
        return action;
      }
    });
    cc.bezierBy = function(t, c) {
      return new cc.BezierBy(t, c);
    };
    cc.BezierTo = cc.Class({
      name: "cc.BezierTo",
      extends: cc.BezierBy,
      ctor: function(t, c) {
        this._toConfig = [];
        c && this.initWithDuration(t, c);
      },
      initWithDuration: function(t, c) {
        if (cc.ActionInterval.prototype.initWithDuration.call(this, t)) {
          this._toConfig = c;
          return true;
        }
        return false;
      },
      clone: function() {
        var action = new cc.BezierTo();
        this._cloneDecoration(action);
        action.initWithDuration(this._duration, this._toConfig);
        return action;
      },
      startWithTarget: function(target) {
        cc.BezierBy.prototype.startWithTarget.call(this, target);
        var locStartPos = this._startPosition;
        var locToConfig = this._toConfig;
        var locConfig = this._config;
        locConfig[0] = locToConfig[0].sub(locStartPos);
        locConfig[1] = locToConfig[1].sub(locStartPos);
        locConfig[2] = locToConfig[2].sub(locStartPos);
      }
    });
    cc.bezierTo = function(t, c) {
      return new cc.BezierTo(t, c);
    };
    cc.ScaleTo = cc.Class({
      name: "cc.ScaleTo",
      extends: cc.ActionInterval,
      ctor: function(duration, sx, sy) {
        this._scaleX = 1;
        this._scaleY = 1;
        this._startScaleX = 1;
        this._startScaleY = 1;
        this._endScaleX = 0;
        this._endScaleY = 0;
        this._deltaX = 0;
        this._deltaY = 0;
        void 0 !== sx && cc.ScaleTo.prototype.initWithDuration.call(this, duration, sx, sy);
      },
      initWithDuration: function(duration, sx, sy) {
        if (cc.ActionInterval.prototype.initWithDuration.call(this, duration)) {
          this._endScaleX = sx;
          this._endScaleY = null != sy ? sy : sx;
          return true;
        }
        return false;
      },
      clone: function() {
        var action = new cc.ScaleTo();
        this._cloneDecoration(action);
        action.initWithDuration(this._duration, this._endScaleX, this._endScaleY);
        return action;
      },
      startWithTarget: function(target) {
        cc.ActionInterval.prototype.startWithTarget.call(this, target);
        this._startScaleX = target.scaleX;
        this._startScaleY = target.scaleY;
        this._deltaX = this._endScaleX - this._startScaleX;
        this._deltaY = this._endScaleY - this._startScaleY;
      },
      update: function(dt) {
        dt = this._computeEaseTime(dt);
        if (this.target) {
          this.target.scaleX = this._startScaleX + this._deltaX * dt;
          this.target.scaleY = this._startScaleY + this._deltaY * dt;
        }
      }
    });
    cc.scaleTo = function(duration, sx, sy) {
      return new cc.ScaleTo(duration, sx, sy);
    };
    cc.ScaleBy = cc.Class({
      name: "cc.ScaleBy",
      extends: cc.ScaleTo,
      startWithTarget: function(target) {
        cc.ScaleTo.prototype.startWithTarget.call(this, target);
        this._deltaX = this._startScaleX * this._endScaleX - this._startScaleX;
        this._deltaY = this._startScaleY * this._endScaleY - this._startScaleY;
      },
      reverse: function() {
        var action = new cc.ScaleBy(this._duration, 1 / this._endScaleX, 1 / this._endScaleY);
        this._cloneDecoration(action);
        this._reverseEaseList(action);
        return action;
      },
      clone: function() {
        var action = new cc.ScaleBy();
        this._cloneDecoration(action);
        action.initWithDuration(this._duration, this._endScaleX, this._endScaleY);
        return action;
      }
    });
    cc.scaleBy = function(duration, sx, sy) {
      return new cc.ScaleBy(duration, sx, sy);
    };
    cc.Blink = cc.Class({
      name: "cc.Blink",
      extends: cc.ActionInterval,
      ctor: function(duration, blinks) {
        this._times = 0;
        this._originalState = false;
        void 0 !== blinks && this.initWithDuration(duration, blinks);
      },
      initWithDuration: function(duration, blinks) {
        if (cc.ActionInterval.prototype.initWithDuration.call(this, duration)) {
          this._times = blinks;
          return true;
        }
        return false;
      },
      clone: function() {
        var action = new cc.Blink();
        this._cloneDecoration(action);
        action.initWithDuration(this._duration, this._times);
        return action;
      },
      update: function(dt) {
        dt = this._computeEaseTime(dt);
        if (this.target && !this.isDone()) {
          var slice = 1 / this._times;
          var m = dt % slice;
          this.target.opacity = m > slice / 2 ? 255 : 0;
        }
      },
      startWithTarget: function(target) {
        cc.ActionInterval.prototype.startWithTarget.call(this, target);
        this._originalState = target.opacity;
      },
      stop: function() {
        this.target.opacity = this._originalState;
        cc.ActionInterval.prototype.stop.call(this);
      },
      reverse: function() {
        var action = new cc.Blink(this._duration, this._times);
        this._cloneDecoration(action);
        this._reverseEaseList(action);
        return action;
      }
    });
    cc.blink = function(duration, blinks) {
      return new cc.Blink(duration, blinks);
    };
    cc.FadeTo = cc.Class({
      name: "cc.FadeTo",
      extends: cc.ActionInterval,
      ctor: function(duration, opacity) {
        this._toOpacity = 0;
        this._fromOpacity = 0;
        void 0 !== opacity && cc.FadeTo.prototype.initWithDuration.call(this, duration, opacity);
      },
      initWithDuration: function(duration, opacity) {
        if (cc.ActionInterval.prototype.initWithDuration.call(this, duration)) {
          this._toOpacity = opacity;
          return true;
        }
        return false;
      },
      clone: function() {
        var action = new cc.FadeTo();
        this._cloneDecoration(action);
        action.initWithDuration(this._duration, this._toOpacity);
        return action;
      },
      update: function(time) {
        time = this._computeEaseTime(time);
        var fromOpacity = void 0 !== this._fromOpacity ? this._fromOpacity : 255;
        this.target.opacity = fromOpacity + (this._toOpacity - fromOpacity) * time;
      },
      startWithTarget: function(target) {
        cc.ActionInterval.prototype.startWithTarget.call(this, target);
        this._fromOpacity = target.opacity;
      }
    });
    cc.fadeTo = function(duration, opacity) {
      return new cc.FadeTo(duration, opacity);
    };
    cc.FadeIn = cc.Class({
      name: "cc.FadeIn",
      extends: cc.FadeTo,
      ctor: function(duration) {
        null == duration && (duration = 0);
        this._reverseAction = null;
        this.initWithDuration(duration, 255);
      },
      reverse: function() {
        var action = new cc.FadeOut();
        action.initWithDuration(this._duration, 0);
        this._cloneDecoration(action);
        this._reverseEaseList(action);
        return action;
      },
      clone: function() {
        var action = new cc.FadeIn();
        this._cloneDecoration(action);
        action.initWithDuration(this._duration, this._toOpacity);
        return action;
      },
      startWithTarget: function(target) {
        this._reverseAction && (this._toOpacity = this._reverseAction._fromOpacity);
        cc.FadeTo.prototype.startWithTarget.call(this, target);
      }
    });
    cc.fadeIn = function(duration) {
      return new cc.FadeIn(duration);
    };
    cc.FadeOut = cc.Class({
      name: "cc.FadeOut",
      extends: cc.FadeTo,
      ctor: function(duration) {
        null == duration && (duration = 0);
        this._reverseAction = null;
        this.initWithDuration(duration, 0);
      },
      reverse: function() {
        var action = new cc.FadeIn();
        action._reverseAction = this;
        action.initWithDuration(this._duration, 255);
        this._cloneDecoration(action);
        this._reverseEaseList(action);
        return action;
      },
      clone: function() {
        var action = new cc.FadeOut();
        this._cloneDecoration(action);
        action.initWithDuration(this._duration, this._toOpacity);
        return action;
      }
    });
    cc.fadeOut = function(d) {
      return new cc.FadeOut(d);
    };
    cc.TintTo = cc.Class({
      name: "cc.TintTo",
      extends: cc.ActionInterval,
      ctor: function(duration, red, green, blue) {
        this._to = cc.color(0, 0, 0);
        this._from = cc.color(0, 0, 0);
        if (red instanceof cc.Color) {
          blue = red.b;
          green = red.g;
          red = red.r;
        }
        void 0 !== blue && this.initWithDuration(duration, red, green, blue);
      },
      initWithDuration: function(duration, red, green, blue) {
        if (cc.ActionInterval.prototype.initWithDuration.call(this, duration)) {
          this._to = cc.color(red, green, blue);
          return true;
        }
        return false;
      },
      clone: function() {
        var action = new cc.TintTo();
        this._cloneDecoration(action);
        var locTo = this._to;
        action.initWithDuration(this._duration, locTo.r, locTo.g, locTo.b);
        return action;
      },
      startWithTarget: function(target) {
        cc.ActionInterval.prototype.startWithTarget.call(this, target);
        this._from = this.target.color;
      },
      update: function(dt) {
        dt = this._computeEaseTime(dt);
        var locFrom = this._from, locTo = this._to;
        locFrom && (this.target.color = cc.color(locFrom.r + (locTo.r - locFrom.r) * dt, locFrom.g + (locTo.g - locFrom.g) * dt, locFrom.b + (locTo.b - locFrom.b) * dt));
      }
    });
    cc.tintTo = function(duration, red, green, blue) {
      return new cc.TintTo(duration, red, green, blue);
    };
    cc.TintBy = cc.Class({
      name: "cc.TintBy",
      extends: cc.ActionInterval,
      ctor: function(duration, deltaRed, deltaGreen, deltaBlue) {
        this._deltaR = 0;
        this._deltaG = 0;
        this._deltaB = 0;
        this._fromR = 0;
        this._fromG = 0;
        this._fromB = 0;
        void 0 !== deltaBlue && this.initWithDuration(duration, deltaRed, deltaGreen, deltaBlue);
      },
      initWithDuration: function(duration, deltaRed, deltaGreen, deltaBlue) {
        if (cc.ActionInterval.prototype.initWithDuration.call(this, duration)) {
          this._deltaR = deltaRed;
          this._deltaG = deltaGreen;
          this._deltaB = deltaBlue;
          return true;
        }
        return false;
      },
      clone: function() {
        var action = new cc.TintBy();
        this._cloneDecoration(action);
        action.initWithDuration(this._duration, this._deltaR, this._deltaG, this._deltaB);
        return action;
      },
      startWithTarget: function(target) {
        cc.ActionInterval.prototype.startWithTarget.call(this, target);
        var color = target.color;
        this._fromR = color.r;
        this._fromG = color.g;
        this._fromB = color.b;
      },
      update: function(dt) {
        dt = this._computeEaseTime(dt);
        this.target.color = cc.color(this._fromR + this._deltaR * dt, this._fromG + this._deltaG * dt, this._fromB + this._deltaB * dt);
      },
      reverse: function() {
        var action = new cc.TintBy(this._duration, -this._deltaR, -this._deltaG, -this._deltaB);
        this._cloneDecoration(action);
        this._reverseEaseList(action);
        return action;
      }
    });
    cc.tintBy = function(duration, deltaRed, deltaGreen, deltaBlue) {
      return new cc.TintBy(duration, deltaRed, deltaGreen, deltaBlue);
    };
    cc.DelayTime = cc.Class({
      name: "cc.DelayTime",
      extends: cc.ActionInterval,
      update: function(dt) {},
      reverse: function() {
        var action = new cc.DelayTime(this._duration);
        this._cloneDecoration(action);
        this._reverseEaseList(action);
        return action;
      },
      clone: function() {
        var action = new cc.DelayTime();
        this._cloneDecoration(action);
        action.initWithDuration(this._duration);
        return action;
      }
    });
    cc.delayTime = function(d) {
      return new cc.DelayTime(d);
    };
    cc.ReverseTime = cc.Class({
      name: "cc.ReverseTime",
      extends: cc.ActionInterval,
      ctor: function(action) {
        this._other = null;
        action && this.initWithAction(action);
      },
      initWithAction: function(action) {
        if (!action) {
          cc.errorID(1028);
          return false;
        }
        if (action === this._other) {
          cc.errorID(1029);
          return false;
        }
        if (cc.ActionInterval.prototype.initWithDuration.call(this, action._duration)) {
          this._other = action;
          return true;
        }
        return false;
      },
      clone: function() {
        var action = new cc.ReverseTime();
        this._cloneDecoration(action);
        action.initWithAction(this._other.clone());
        return action;
      },
      startWithTarget: function(target) {
        cc.ActionInterval.prototype.startWithTarget.call(this, target);
        this._other.startWithTarget(target);
      },
      update: function(dt) {
        dt = this._computeEaseTime(dt);
        this._other && this._other.update(1 - dt);
      },
      reverse: function() {
        return this._other.clone();
      },
      stop: function() {
        this._other.stop();
        cc.Action.prototype.stop.call(this);
      }
    });
    cc.reverseTime = function(action) {
      return new cc.ReverseTime(action);
    };
    cc.TargetedAction = cc.Class({
      name: "cc.TargetedAction",
      extends: cc.ActionInterval,
      ctor: function(target, action) {
        this._action = null;
        this._forcedTarget = null;
        action && this.initWithTarget(target, action);
      },
      initWithTarget: function(target, action) {
        if (this.initWithDuration(action._duration)) {
          this._forcedTarget = target;
          this._action = action;
          return true;
        }
        return false;
      },
      clone: function() {
        var action = new cc.TargetedAction();
        this._cloneDecoration(action);
        action.initWithTarget(this._forcedTarget, this._action.clone());
        return action;
      },
      startWithTarget: function(target) {
        cc.ActionInterval.prototype.startWithTarget.call(this, target);
        this._action.startWithTarget(this._forcedTarget);
      },
      stop: function() {
        this._action.stop();
      },
      update: function(dt) {
        dt = this._computeEaseTime(dt);
        this._action.update(dt);
      },
      getForcedTarget: function() {
        return this._forcedTarget;
      },
      setForcedTarget: function(forcedTarget) {
        this._forcedTarget !== forcedTarget && (this._forcedTarget = forcedTarget);
      }
    });
    cc.targetedAction = function(target, action) {
      return new cc.TargetedAction(target, action);
    };
  }), {} ],
  7: [ (function(require, module, exports) {
    require("../core/platform/CCClass");
    var js = require("../core/platform/js");
    var HashElement = function() {
      this.actions = [];
      this.target = null;
      this.actionIndex = 0;
      this.currentAction = null;
      this.paused = false;
      this.lock = false;
    };
    cc.ActionManager = function() {
      this._hashTargets = js.createMap(true);
      this._arrayTargets = [];
      this._currentTarget = null;
      cc.director._scheduler && cc.director._scheduler.enableForTarget(this);
    };
    cc.ActionManager.prototype = {
      constructor: cc.ActionManager,
      _elementPool: [],
      _searchElementByTarget: function(arr, target) {
        for (var k = 0; k < arr.length; k++) if (target === arr[k].target) return arr[k];
        return null;
      },
      _getElement: function(target, paused) {
        var element = this._elementPool.pop();
        element || (element = new HashElement());
        element.target = target;
        element.paused = !!paused;
        return element;
      },
      _putElement: function(element) {
        element.actions.length = 0;
        element.actionIndex = 0;
        element.currentAction = null;
        element.paused = false;
        element.target = null;
        element.lock = false;
        this._elementPool.push(element);
      },
      addAction: function(action, target, paused) {
        if (!action || !target) {
          cc.errorID(1e3);
          return;
        }
        var element = this._hashTargets[target._id];
        if (element) element.actions || (element.actions = []); else {
          element = this._getElement(target, paused);
          this._hashTargets[target._id] = element;
          this._arrayTargets.push(element);
        }
        element.actions.push(action);
        action.startWithTarget(target);
      },
      removeAllActions: function() {
        var locTargets = this._arrayTargets;
        for (var i = 0; i < locTargets.length; i++) {
          var element = locTargets[i];
          element && this.removeAllActionsFromTarget(element.target, true);
        }
      },
      removeAllActionsFromTarget: function(target, forceDelete) {
        if (null == target) return;
        var element = this._hashTargets[target._id];
        if (element) {
          element.actions.length = 0;
          this._deleteHashElement(element);
        }
      },
      removeAction: function(action) {
        if (null == action) return;
        var target = action.getOriginalTarget();
        var element = this._hashTargets[target._id];
        if (element) {
          for (var i = 0; i < element.actions.length; i++) if (element.actions[i] === action) {
            element.actions.splice(i, 1);
            element.actionIndex >= i && element.actionIndex--;
            break;
          }
        } else cc.logID(1001);
      },
      removeActionByTag: function(tag, target) {
        tag === cc.Action.TAG_INVALID && cc.logID(1002);
        cc.assertID(target, 1003);
        var element = this._hashTargets[target._id];
        if (element) {
          var limit = element.actions.length;
          for (var i = 0; i < limit; ++i) {
            var action = element.actions[i];
            if (action && action.getTag() === tag && action.getOriginalTarget() === target) {
              this._removeActionAtIndex(i, element);
              break;
            }
          }
        }
      },
      getActionByTag: function(tag, target) {
        tag === cc.Action.TAG_INVALID && cc.logID(1004);
        var element = this._hashTargets[target._id];
        if (element) {
          if (null != element.actions) for (var i = 0; i < element.actions.length; ++i) {
            var action = element.actions[i];
            if (action && action.getTag() === tag) return action;
          }
          cc.logID(1005, tag);
        }
        return null;
      },
      getNumberOfRunningActionsInTarget: function(target) {
        var element = this._hashTargets[target._id];
        if (element) return element.actions ? element.actions.length : 0;
        return 0;
      },
      pauseTarget: function(target) {
        var element = this._hashTargets[target._id];
        element && (element.paused = true);
      },
      resumeTarget: function(target) {
        var element = this._hashTargets[target._id];
        element && (element.paused = false);
      },
      pauseAllRunningActions: function() {
        var idsWithActions = [];
        var locTargets = this._arrayTargets;
        for (var i = 0; i < locTargets.length; i++) {
          var element = locTargets[i];
          if (element && !element.paused) {
            element.paused = true;
            idsWithActions.push(element.target);
          }
        }
        return idsWithActions;
      },
      resumeTargets: function(targetsToResume) {
        if (!targetsToResume) return;
        for (var i = 0; i < targetsToResume.length; i++) targetsToResume[i] && this.resumeTarget(targetsToResume[i]);
      },
      pauseTargets: function(targetsToPause) {
        if (!targetsToPause) return;
        for (var i = 0; i < targetsToPause.length; i++) targetsToPause[i] && this.pauseTarget(targetsToPause[i]);
      },
      purgeSharedManager: function() {
        cc.director.getScheduler().unscheduleUpdate(this);
      },
      _removeActionAtIndex: function(index, element) {
        var action = element.actions[index];
        element.actions.splice(index, 1);
        element.actionIndex >= index && element.actionIndex--;
        0 === element.actions.length && this._deleteHashElement(element);
      },
      _deleteHashElement: function(element) {
        var ret = false;
        if (element && !element.lock && this._hashTargets[element.target._id]) {
          delete this._hashTargets[element.target._id];
          var targets = this._arrayTargets;
          for (var i = 0, l = targets.length; i < l; i++) if (targets[i] === element) {
            targets.splice(i, 1);
            break;
          }
          this._putElement(element);
          ret = true;
        }
        return ret;
      },
      update: function(dt) {
        var locTargets = this._arrayTargets, locCurrTarget;
        for (var elt = 0; elt < locTargets.length; elt++) {
          this._currentTarget = locTargets[elt];
          locCurrTarget = this._currentTarget;
          if (!locCurrTarget.paused && locCurrTarget.actions) {
            locCurrTarget.lock = true;
            for (locCurrTarget.actionIndex = 0; locCurrTarget.actionIndex < locCurrTarget.actions.length; locCurrTarget.actionIndex++) {
              locCurrTarget.currentAction = locCurrTarget.actions[locCurrTarget.actionIndex];
              if (!locCurrTarget.currentAction) continue;
              locCurrTarget.currentAction.step(dt * (locCurrTarget.currentAction._speedMethod ? locCurrTarget.currentAction._speed : 1));
              if (locCurrTarget.currentAction && locCurrTarget.currentAction.isDone()) {
                locCurrTarget.currentAction.stop();
                var action = locCurrTarget.currentAction;
                locCurrTarget.currentAction = null;
                this.removeAction(action);
              }
              locCurrTarget.currentAction = null;
            }
            locCurrTarget.lock = false;
          }
          0 === locCurrTarget.actions.length && this._deleteHashElement(locCurrTarget) && elt--;
        }
      }
    };
    false;
  }), {
    "../core/platform/CCClass": 147,
    "../core/platform/js": 167
  } ],
  8: [ (function(require, module, exports) {
    require("./CCActionManager");
    require("./CCAction");
    require("./CCActionInterval");
    require("./CCActionInstant");
    require("./CCActionEase");
    require("./CCActionCatmullRom");
  }), {
    "./CCAction": 2,
    "./CCActionCatmullRom": 3,
    "./CCActionEase": 4,
    "./CCActionInstant": 5,
    "./CCActionInterval": 6,
    "./CCActionManager": 7
  } ],
  9: [ (function(require, module, exports) {
    var js = cc.js;
    var Playable = require("./playable");
    var DynamicAnimCurve = require("./animation-curves").DynamicAnimCurve;
    var quickFindIndex = require("./animation-curves").quickFindIndex;
    var sampleMotionPaths = require("./motion-path-helper").sampleMotionPaths;
    var EventAnimCurve = require("./animation-curves").EventAnimCurve;
    var EventInfo = require("./animation-curves").EventInfo;
    var WrapModeMask = require("./types").WrapModeMask;
    var binarySearch = require("../core/utils/binary-search").binarySearchEpsilon;
    function AnimationAnimator(target, animation) {
      Playable.call(this);
      this.target = target;
      this.animation = animation;
      this._anims = new js.array.MutableForwardIterator([]);
    }
    js.extend(AnimationAnimator, Playable);
    var p = AnimationAnimator.prototype;
    p.playState = function(state, startTime) {
      if (!state.clip) return;
      state.curveLoaded || initClipData(this.target, state);
      state.animator = this;
      state.play();
      "number" === typeof startTime && state.setTime(startTime);
      this.play();
    };
    p.stopStatesExcept = function(state) {
      var iterator = this._anims;
      var array = iterator.array;
      for (iterator.i = 0; iterator.i < array.length; ++iterator.i) {
        var anim = array[iterator.i];
        if (anim === state) continue;
        this.stopState(anim);
      }
    };
    p.addAnimation = function(anim) {
      var index = this._anims.array.indexOf(anim);
      -1 === index && this._anims.push(anim);
      anim._setListeners(this.animation);
    };
    p.removeAnimation = function(anim) {
      var index = this._anims.array.indexOf(anim);
      if (index >= 0) {
        this._anims.fastRemoveAt(index);
        0 === this._anims.array.length && this.stop();
      } else cc.errorID(3908);
      anim.animator = null;
    };
    p.sample = function() {
      var iterator = this._anims;
      var array = iterator.array;
      for (iterator.i = 0; iterator.i < array.length; ++iterator.i) {
        var anim = array[iterator.i];
        anim.sample();
      }
    };
    p.stopState = function(state) {
      state && state.stop();
    };
    p.pauseState = function(state) {
      state && state.pause();
    };
    p.resumeState = function(state) {
      state && state.resume();
      this.isPaused && this.resume();
    };
    p.setStateTime = function(state, time) {
      if (void 0 !== time) {
        if (state) {
          state.setTime(time);
          state.sample();
        }
      } else {
        time = state;
        var array = this._anims.array;
        for (var i = 0; i < array.length; ++i) {
          var anim = array[i];
          anim.setTime(time);
          anim.sample();
        }
      }
    };
    p.onStop = function() {
      var iterator = this._anims;
      var array = iterator.array;
      for (iterator.i = 0; iterator.i < array.length; ++iterator.i) {
        var anim = array[iterator.i];
        anim.stop();
      }
    };
    p.onPause = function() {
      var array = this._anims.array;
      for (var i = 0; i < array.length; ++i) {
        var anim = array[i];
        anim.pause();
        anim.animator = null;
      }
    };
    p.onResume = function() {
      var array = this._anims.array;
      for (var i = 0; i < array.length; ++i) {
        var anim = array[i];
        anim.animator = this;
        anim.resume();
      }
    };
    p._reloadClip = function(state) {
      initClipData(this.target, state);
    };
    function createBatchedProperty(propPath, firstDotIndex, mainValue, animValue) {
      mainValue = mainValue.clone();
      var nextValue = mainValue;
      var leftIndex = firstDotIndex + 1;
      var rightIndex = propPath.indexOf(".", leftIndex);
      while (-1 !== rightIndex) {
        var nextName = propPath.slice(leftIndex, rightIndex);
        nextValue = nextValue[nextName];
        leftIndex = rightIndex + 1;
        rightIndex = propPath.indexOf(".", leftIndex);
      }
      var lastPropName = propPath.slice(leftIndex);
      nextValue[lastPropName] = animValue;
      return mainValue;
    }
    false;
    function splitPropPath(propPath) {
      var array = propPath.split(".");
      array.shift();
      return array.length > 0 ? array : null;
    }
    function initClipData(root, state) {
      var clip = state.clip;
      var curves = state.curves;
      curves.length = 0;
      state.duration = clip.duration;
      state.speed = clip.speed;
      state.wrapMode = clip.wrapMode;
      state.frameRate = clip.sample;
      (state.wrapMode & WrapModeMask.Loop) === WrapModeMask.Loop ? state.repeatCount = Infinity : state.repeatCount = 1;
      function checkMotionPath(motionPath) {
        if (!Array.isArray(motionPath)) return false;
        for (var i = 0, l = motionPath.length; i < l; i++) {
          var controls = motionPath[i];
          if (!Array.isArray(controls) || 6 !== controls.length) return false;
        }
        return true;
      }
      function createPropCurve(target, propPath, keyframes) {
        var isMotionPathProp = target instanceof cc.Node && "position" === propPath;
        var motionPaths = [];
        var curve = new DynamicAnimCurve();
        curve.target = target;
        var propName, propValue;
        var dotIndex = propPath.indexOf(".");
        var hasSubProp = -1 !== dotIndex;
        if (hasSubProp) {
          propName = propPath.slice(0, dotIndex);
          propValue = target[propName];
        } else propName = propPath;
        curve.prop = propName;
        curve.subProps = splitPropPath(propPath);
        for (var i = 0, l = keyframes.length; i < l; i++) {
          var keyframe = keyframes[i];
          var ratio = keyframe.frame / state.duration;
          curve.ratios.push(ratio);
          if (isMotionPathProp) {
            var motionPath = keyframe.motionPath;
            if (motionPath && !checkMotionPath(motionPath)) {
              cc.errorID(3904, target.name, propPath, i);
              motionPath = null;
            }
            motionPaths.push(motionPath);
          }
          var curveValue = keyframe.value;
          curve.values.push(curveValue);
          var curveTypes = keyframe.curve;
          if (curveTypes) {
            if ("string" === typeof curveTypes) {
              curve.types.push(curveTypes);
              continue;
            }
            if (Array.isArray(curveTypes)) {
              curveTypes[0] === curveTypes[1] && curveTypes[2] === curveTypes[3] ? curve.types.push(DynamicAnimCurve.Linear) : curve.types.push(DynamicAnimCurve.Bezier(curveTypes));
              continue;
            }
          }
          curve.types.push(DynamicAnimCurve.Linear);
        }
        isMotionPathProp && sampleMotionPaths(motionPaths, curve, clip.duration, clip.sample);
        var ratios = curve.ratios;
        var currRatioDif, lastRatioDif;
        var canOptimize = true;
        var EPSILON = 1e-6;
        for (var _i = 1, _l = ratios.length; _i < _l; _i++) {
          currRatioDif = ratios[_i] - ratios[_i - 1];
          if (1 === _i) lastRatioDif = currRatioDif; else if (Math.abs(currRatioDif - lastRatioDif) > EPSILON) {
            canOptimize = false;
            break;
          }
        }
        curve._findFrameIndex = canOptimize ? quickFindIndex : binarySearch;
        return curve;
      }
      function createTargetCurves(target, curveData) {
        var propsData = curveData.props;
        var compsData = curveData.comps;
        if (propsData) for (var propPath in propsData) {
          var data = propsData[propPath];
          var curve = createPropCurve(target, propPath, data);
          curves.push(curve);
        }
        if (compsData) for (var compName in compsData) {
          var comp = target.getComponent(compName);
          if (!comp) continue;
          var compData = compsData[compName];
          for (var propPath in compData) {
            var data = compData[propPath];
            var curve = createPropCurve(comp, propPath, data);
            curves.push(curve);
          }
        }
      }
      var curveData = clip.curveData;
      var childrenCurveDatas = curveData.paths;
      createTargetCurves(root, curveData);
      for (var namePath in childrenCurveDatas) {
        var target = cc.find(namePath, root);
        if (!target) continue;
        var childCurveDatas = childrenCurveDatas[namePath];
        createTargetCurves(target, childCurveDatas);
      }
      var events = clip.events;
      if (true, events) {
        var curve;
        for (var i = 0, l = events.length; i < l; i++) {
          if (!curve) {
            curve = new EventAnimCurve();
            curve.target = root;
            curves.push(curve);
          }
          var eventData = events[i];
          var ratio = eventData.frame / state.duration;
          var eventInfo;
          var index = binarySearch(curve.ratios, ratio);
          if (index >= 0) eventInfo = curve.events[index]; else {
            eventInfo = new EventInfo();
            curve.ratios.push(ratio);
            curve.events.push(eventInfo);
          }
          eventInfo.add(eventData.func, eventData.params);
        }
      }
    }
    false;
    module.exports = AnimationAnimator;
  }), {
    "../core/utils/binary-search": 202,
    "./animation-curves": 11,
    "./motion-path-helper": 17,
    "./playable": 18,
    "./types": 19
  } ],
  10: [ (function(require, module, exports) {
    var AnimationClip = cc.Class({
      name: "cc.AnimationClip",
      extends: cc.Asset,
      properties: {
        _duration: {
          default: 0,
          type: "Float"
        },
        duration: {
          get: function() {
            return this._duration;
          }
        },
        sample: {
          default: 60
        },
        speed: {
          default: 1
        },
        wrapMode: {
          default: cc.WrapMode.Normal
        },
        curveData: {
          default: {},
          visible: false
        },
        events: {
          default: [],
          visible: false
        }
      },
      statics: {
        createWithSpriteFrames: function(spriteFrames, sample) {
          if (!Array.isArray(spriteFrames)) {
            cc.errorID(3905);
            return null;
          }
          var clip = new AnimationClip();
          clip.sample = sample || clip.sample;
          clip._duration = spriteFrames.length / clip.sample;
          var frames = [];
          var step = 1 / clip.sample;
          for (var i = 0, l = spriteFrames.length; i < l; i++) frames[i] = {
            frame: i * step,
            value: spriteFrames[i]
          };
          clip.curveData = {
            comps: {
              "cc.Sprite": {
                spriteFrame: frames
              }
            }
          };
          return clip;
        }
      }
    });
    cc.AnimationClip = module.exports = AnimationClip;
  }), {} ],
  11: [ (function(require, module, exports) {
    var bezierByTime = require("./bezier").bezierByTime;
    var binarySearch = require("../core/utils/binary-search").binarySearchEpsilon;
    var WrapModeMask = require("./types").WrapModeMask;
    var WrappedInfo = require("./types").WrappedInfo;
    function computeRatioByType(ratio, type) {
      if ("string" === typeof type) {
        var func = cc.Easing[type];
        func ? ratio = func(ratio) : cc.errorID(3906, type);
      } else Array.isArray(type) && (ratio = bezierByTime(type, ratio));
      return ratio;
    }
    var AnimCurve = cc.Class({
      name: "cc.AnimCurve",
      sample: function(time, ratio, state) {},
      onTimeChangedManually: void 0
    });
    function quickFindIndex(ratios, ratio) {
      var length = ratios.length - 1;
      if (0 === length) return 0;
      var start = ratios[0];
      if (ratio < start) return 0;
      var end = ratios[length];
      if (ratio > end) return length;
      ratio = (ratio - start) / (end - start);
      var eachLength = 1 / length;
      var index = ratio / eachLength;
      var floorIndex = 0 | index;
      var EPSILON = 1e-6;
      if (index - floorIndex < EPSILON) return floorIndex;
      return ~(floorIndex + 1);
    }
    var DynamicAnimCurve = cc.Class({
      name: "cc.DynamicAnimCurve",
      extends: AnimCurve,
      properties: {
        target: null,
        prop: "",
        values: [],
        ratios: [],
        types: [],
        subProps: null
      },
      _findFrameIndex: binarySearch,
      sample: function(time, ratio, state) {
        var values = this.values;
        var ratios = this.ratios;
        var frameCount = ratios.length;
        if (0 === frameCount) return;
        var value;
        var index = this._findFrameIndex(ratios, ratio);
        if (index < 0) {
          index = ~index;
          if (index <= 0) value = values[0]; else if (index >= frameCount) value = values[frameCount - 1]; else {
            var fromVal = values[index - 1];
            var isNumber = "number" === typeof fromVal;
            var canLerp = fromVal && fromVal.lerp;
            if (isNumber || canLerp) {
              var fromRatio = ratios[index - 1];
              var toRatio = ratios[index];
              var type = this.types[index - 1];
              var ratioBetweenFrames = (ratio - fromRatio) / (toRatio - fromRatio);
              type && (ratioBetweenFrames = computeRatioByType(ratioBetweenFrames, type));
              var toVal = values[index];
              isNumber ? value = fromVal + (toVal - fromVal) * ratioBetweenFrames : canLerp && (value = fromVal.lerp(toVal, ratioBetweenFrames));
            } else value = fromVal;
          }
        } else value = values[index];
        var subProps = this.subProps;
        if (subProps) {
          var mainProp = this.target[this.prop];
          var subProp = mainProp;
          for (var i = 0; i < subProps.length - 1; i++) {
            var subPropName = subProps[i];
            if (!subProp) return;
            subProp = subProp[subPropName];
          }
          var propName = subProps[subProps.length - 1];
          if (!subProp) return;
          subProp[propName] = value;
          value = mainProp;
        }
        this.target[this.prop] = value;
      }
    });
    DynamicAnimCurve.Linear = null;
    DynamicAnimCurve.Bezier = function(controlPoints) {
      return controlPoints;
    };
    var EventInfo = function() {
      this.events = [];
    };
    EventInfo.prototype.add = function(func, params) {
      this.events.push({
        func: func || "",
        params: params || []
      });
    };
    var EventAnimCurve = cc.Class({
      name: "cc.EventAnimCurve",
      extends: AnimCurve,
      properties: {
        target: null,
        ratios: [],
        events: [],
        _wrappedInfo: {
          default: function() {
            return new WrappedInfo();
          }
        },
        _lastWrappedInfo: null,
        _ignoreIndex: NaN
      },
      _wrapIterations: function(iterations) {
        iterations - (0 | iterations) === 0 && (iterations -= 1);
        return 0 | iterations;
      },
      sample: function(time, ratio, state) {
        var length = this.ratios.length;
        var currentWrappedInfo = state.getWrappedInfo(state.time, this._wrappedInfo);
        var direction = currentWrappedInfo.direction;
        var currentIndex = binarySearch(this.ratios, currentWrappedInfo.ratio);
        if (currentIndex < 0) {
          currentIndex = ~currentIndex - 1;
          direction < 0 && (currentIndex += 1);
        }
        this._ignoreIndex !== currentIndex && (this._ignoreIndex = NaN);
        currentWrappedInfo.frameIndex = currentIndex;
        if (!this._lastWrappedInfo) {
          this._fireEvent(currentIndex);
          this._lastWrappedInfo = new WrappedInfo(currentWrappedInfo);
          return;
        }
        var wrapMode = state.wrapMode;
        var currentIterations = this._wrapIterations(currentWrappedInfo.iterations);
        var lastWrappedInfo = this._lastWrappedInfo;
        var lastIterations = this._wrapIterations(lastWrappedInfo.iterations);
        var lastIndex = lastWrappedInfo.frameIndex;
        var lastDirection = lastWrappedInfo.direction;
        var interationsChanged = -1 !== lastIterations && currentIterations !== lastIterations;
        if (lastIndex === currentIndex && interationsChanged && 1 === length) this._fireEvent(0); else if (lastIndex !== currentIndex || interationsChanged) {
          direction = lastDirection;
          do {
            if (lastIndex !== currentIndex) {
              if (-1 === direction && 0 === lastIndex && currentIndex > 0) {
                (wrapMode & WrapModeMask.PingPong) === WrapModeMask.PingPong ? direction *= -1 : lastIndex = length;
                lastIterations++;
              } else if (1 === direction && lastIndex === length - 1 && currentIndex < length - 1) {
                (wrapMode & WrapModeMask.PingPong) === WrapModeMask.PingPong ? direction *= -1 : lastIndex = -1;
                lastIterations++;
              }
              if (lastIndex === currentIndex) break;
              if (lastIterations > currentIterations) break;
            }
            lastIndex += direction;
            cc.director.getAnimationManager().pushDelayEvent(this, "_fireEvent", [ lastIndex ]);
          } while (lastIndex !== currentIndex && lastIndex > -1 && lastIndex < length);
        }
        this._lastWrappedInfo.set(currentWrappedInfo);
      },
      _fireEvent: function(index) {
        if (index < 0 || index >= this.events.length || this._ignoreIndex === index) return;
        var eventInfo = this.events[index];
        var events = eventInfo.events;
        if (!this.target.isValid) return;
        var components = this.target._components;
        for (var i = 0; i < events.length; i++) {
          var event = events[i];
          var funcName = event.func;
          for (var j = 0; j < components.length; j++) {
            var component = components[j];
            var func = component[funcName];
            func && func.apply(component, event.params);
          }
        }
      },
      onTimeChangedManually: function(time, state) {
        this._lastWrappedInfo = null;
        this._ignoreIndex = NaN;
        var info = state.getWrappedInfo(time, this._wrappedInfo);
        var direction = info.direction;
        var frameIndex = binarySearch(this.ratios, info.ratio);
        if (frameIndex < 0) {
          frameIndex = ~frameIndex - 1;
          direction < 0 && (frameIndex += 1);
          this._ignoreIndex = frameIndex;
        }
      }
    });
    false;
    module.exports = {
      AnimCurve: AnimCurve,
      DynamicAnimCurve: DynamicAnimCurve,
      EventAnimCurve: EventAnimCurve,
      EventInfo: EventInfo,
      computeRatioByType: computeRatioByType,
      quickFindIndex: quickFindIndex
    };
  }), {
    "../core/utils/binary-search": 202,
    "./bezier": 14,
    "./types": 19
  } ],
  12: [ (function(require, module, exports) {
    var js = cc.js;
    var AnimationManager = cc.Class({
      ctor: function() {
        this._anims = new js.array.MutableForwardIterator([]);
        this._delayEvents = [];
        cc.director._scheduler && cc.director._scheduler.enableForTarget(this);
      },
      update: function(dt) {
        var iterator = this._anims;
        var array = iterator.array;
        for (iterator.i = 0; iterator.i < array.length; ++iterator.i) {
          var anim = array[iterator.i];
          anim._isPlaying && !anim._isPaused && anim.update(dt);
        }
        var events = this._delayEvents;
        for (var i = 0, l = events.length; i < l; i++) {
          var event = events[i];
          event.target[event.func].apply(event.target, event.args);
        }
        events.length = 0;
      },
      destruct: function() {},
      addAnimation: function(anim) {
        var index = this._anims.array.indexOf(anim);
        -1 === index && this._anims.push(anim);
      },
      removeAnimation: function(anim) {
        var index = this._anims.array.indexOf(anim);
        index >= 0 ? this._anims.fastRemoveAt(index) : cc.errorID(3907);
      },
      pushDelayEvent: function(target, func, args) {
        this._delayEvents.push({
          target: target,
          func: func,
          args: args
        });
      }
    });
    cc.AnimationManager = module.exports = AnimationManager;
  }), {} ],
  13: [ (function(require, module, exports) {
    var js = cc.js;
    var Playable = require("./playable");
    var Types = require("./types");
    var WrappedInfo = Types.WrappedInfo;
    var WrapMode = Types.WrapMode;
    var WrapModeMask = Types.WrapModeMask;
    function AnimationState(clip, name) {
      Playable.call(this);
      this._currentFramePlayed = false;
      this._delay = 0;
      this._delayTime = 0;
      this._wrappedInfo = new WrappedInfo();
      this._lastWrappedInfo = null;
      this._process = process;
      this._clip = clip;
      this._name = name || clip && clip.name;
      this.animator = null;
      this.curves = [];
      this.delay = 0;
      this.repeatCount = 1;
      this.duration = 1;
      this.speed = 1;
      this.wrapMode = WrapMode.Normal;
      this.time = 0;
      this._target = null;
      this._lastframeEventOn = false;
      this.emit = function() {
        var args = new Array(arguments.length);
        for (var i = 0, l = args.length; i < l; i++) args[i] = arguments[i];
        cc.director.getAnimationManager().pushDelayEvent(this, "_emit", args);
      };
    }
    js.extend(AnimationState, Playable);
    var proto = AnimationState.prototype;
    proto._emit = function(type, state) {
      this._target && this._target.isValid && this._target.emit(type, type, state);
    };
    proto.on = function(type, callback, target) {
      if (this._target && this._target.isValid) {
        "lastframe" === type && (this._lastframeEventOn = true);
        return this._target.on(type, callback, target);
      }
      return null;
    };
    proto.once = function(type, callback, target) {
      var _this = this;
      if (!this._target || !this._target.isValid) return null;
      var _ret = (function() {
        "lastframe" === type && (_this._lastframeEventOn = true);
        var self = _this;
        return {
          v: _this._target.once(type, (function(event) {
            callback.call(target, event);
            self._lastframeEventOn = false;
          }))
        };
      })();
      if ("object" === typeof _ret) return _ret.v;
    };
    proto.off = function(type, callback, target) {
      if (this._target && this._target.isValid) {
        "lastframe" === type && (this._target.hasEventListener(type) || (this._lastframeEventOn = false));
        this._target.off(type, callback, target);
      }
    };
    proto._setListeners = function(target) {
      this._target = target;
    };
    proto.onPlay = function() {
      this.setTime(0);
      this._delayTime = this._delay;
      cc.director.getAnimationManager().addAnimation(this);
      this.animator && this.animator.addAnimation(this);
      this.emit("play", this);
    };
    proto.onStop = function() {
      this.isPaused || cc.director.getAnimationManager().removeAnimation(this);
      this.animator && this.animator.removeAnimation(this);
      this.emit("stop", this);
    };
    proto.onResume = function() {
      cc.director.getAnimationManager().addAnimation(this);
      this.emit("resume", this);
    };
    proto.onPause = function() {
      cc.director.getAnimationManager().removeAnimation(this);
      this.emit("pause", this);
    };
    proto.setTime = function(time) {
      this._currentFramePlayed = false;
      this.time = time || 0;
      var curves = this.curves;
      for (var i = 0, l = curves.length; i < l; i++) {
        var curve = curves[i];
        curve.onTimeChangedManually && curve.onTimeChangedManually(time, this);
      }
    };
    function process() {
      var info = this.sample();
      if (this._lastframeEventOn) {
        var lastInfo;
        lastInfo = this._lastWrappedInfo ? this._lastWrappedInfo : this._lastWrappedInfo = new WrappedInfo(info);
        this.repeatCount > 1 && (0 | info.iterations) > (0 | lastInfo.iterations) && this.emit("lastframe", this);
        lastInfo.set(info);
      }
      if (info.stopped) {
        this.stop();
        this.emit("finished", this);
      }
    }
    function simpleProcess() {
      var time = this.time;
      var duration = this.duration;
      if (time > duration) {
        time %= duration;
        0 === time && (time = duration);
      } else if (time < 0) {
        time %= duration;
        0 !== time && (time += duration);
      }
      var ratio = time / duration;
      var curves = this.curves;
      for (var i = 0, len = curves.length; i < len; i++) {
        var curve = curves[i];
        curve.sample(time, ratio, this);
      }
      if (this._lastframeEventOn) {
        void 0 === this._lastIterations && (this._lastIterations = ratio);
        (this.time > 0 && this._lastIterations > ratio || this.time < 0 && this._lastIterations < ratio) && this.emit("lastframe", this);
        this._lastIterations = ratio;
      }
    }
    proto.update = function(delta) {
      if (this._delayTime > 0) {
        this._delayTime -= delta;
        if (this._delayTime > 0) return;
      }
      this._currentFramePlayed ? this.time += delta * this.speed : this._currentFramePlayed = true;
      this._process();
    };
    proto._needRevers = function(currentIterations) {
      var wrapMode = this.wrapMode;
      var needRevers = false;
      if ((wrapMode & WrapModeMask.PingPong) === WrapModeMask.PingPong) {
        var isEnd = currentIterations - (0 | currentIterations) === 0;
        isEnd && currentIterations > 0 && (currentIterations -= 1);
        var isOddIteration = 1 & currentIterations;
        isOddIteration && (needRevers = !needRevers);
      }
      (wrapMode & WrapModeMask.Reverse) === WrapModeMask.Reverse && (needRevers = !needRevers);
      return needRevers;
    };
    proto.getWrappedInfo = function(time, info) {
      info = info || new WrappedInfo();
      var stopped = false;
      var duration = this.duration;
      var repeatCount = this.repeatCount;
      var currentIterations = time > 0 ? time / duration : -time / duration;
      if (currentIterations >= repeatCount) {
        currentIterations = repeatCount;
        stopped = true;
        var tempRatio = repeatCount - (0 | repeatCount);
        0 === tempRatio && (tempRatio = 1);
        time = tempRatio * duration * (time > 0 ? 1 : -1);
      }
      if (time > duration) {
        var tempTime = time % duration;
        time = 0 === tempTime ? duration : tempTime;
      } else if (time < 0) {
        time %= duration;
        0 !== time && (time += duration);
      }
      var needRevers = false;
      var shouldWrap = this._wrapMode & WrapModeMask.ShouldWrap;
      shouldWrap && (needRevers = this._needRevers(currentIterations));
      var direction = needRevers ? -1 : 1;
      this.speed < 0 && (direction *= -1);
      shouldWrap && needRevers && (time = duration - time);
      info.ratio = time / duration;
      info.time = time;
      info.direction = direction;
      info.stopped = stopped;
      info.iterations = currentIterations;
      return info;
    };
    proto.sample = function() {
      var info = this.getWrappedInfo(this.time, this._wrappedInfo);
      var curves = this.curves;
      for (var i = 0, len = curves.length; i < len; i++) {
        var curve = curves[i];
        curve.sample(info.time, info.ratio, this);
      }
      return info;
    };
    js.get(proto, "clip", (function() {
      return this._clip;
    }));
    js.get(proto, "name", (function() {
      return this._name;
    }));
    js.obsolete(proto, "AnimationState.length", "duration");
    js.getset(proto, "curveLoaded", (function() {
      return this.curves.length > 0;
    }), (function() {
      this.curves.length = 0;
    }));
    js.getset(proto, "wrapMode", (function() {
      return this._wrapMode;
    }), (function(value) {
      this._wrapMode = value;
      false;
      this.time = 0;
      value & WrapModeMask.Loop ? this.repeatCount = Infinity : this.repeatCount = 1;
    }));
    js.getset(proto, "repeatCount", (function() {
      return this._repeatCount;
    }), (function(value) {
      this._repeatCount = value;
      var shouldWrap = this._wrapMode & WrapModeMask.ShouldWrap;
      var reverse = (this.wrapMode & WrapModeMask.Reverse) === WrapModeMask.Reverse;
      this._process = Infinity !== value || shouldWrap || reverse ? process : simpleProcess;
    }));
    js.getset(proto, "delay", (function() {
      return this._delay;
    }), (function(value) {
      this._delayTime = this._delay = value;
    }));
    cc.AnimationState = module.exports = AnimationState;
  }), {
    "./playable": 18,
    "./types": 19
  } ],
  14: [ (function(require, module, exports) {
    function bezier(C1, C2, C3, C4, t) {
      var t1 = 1 - t;
      return C1 * t1 * t1 * t1 + 3 * C2 * t1 * t1 * t + 3 * C3 * t1 * t * t + C4 * t * t * t;
    }
    var cos = Math.cos, acos = Math.acos, max = Math.max, pi = Math.PI, tau = 2 * pi, sqrt = Math.sqrt;
    function crt(v) {
      return v < 0 ? -Math.pow(-v, 1 / 3) : Math.pow(v, 1 / 3);
    }
    function cardano(curve, x) {
      var pa = x - 0;
      var pb = x - curve[0];
      var pc = x - curve[2];
      var pd = x - 1;
      var pa3 = 3 * pa;
      var pb3 = 3 * pb;
      var pc3 = 3 * pc;
      var d = -pa + pb3 - pc3 + pd, rd = 1 / d, r3 = 1 / 3, a = (pa3 - 6 * pb + pc3) * rd, a3 = a * r3, b = (-pa3 + pb3) * rd, c = pa * rd, p = (3 * b - a * a) * r3, p3 = p * r3, q = (2 * a * a * a - 9 * a * b + 27 * c) / 27, q2 = q / 2, discriminant = q2 * q2 + p3 * p3 * p3, u1, v1, x1, x2, x3;
      if (discriminant < 0) {
        var mp3 = -p * r3, mp33 = mp3 * mp3 * mp3, r = sqrt(mp33), t = -q / (2 * r), cosphi = t < -1 ? -1 : t > 1 ? 1 : t, phi = acos(cosphi), crtr = crt(r), t1 = 2 * crtr;
        x1 = t1 * cos(phi * r3) - a3;
        x2 = t1 * cos((phi + tau) * r3) - a3;
        x3 = t1 * cos((phi + 2 * tau) * r3) - a3;
        return 0 <= x1 && x1 <= 1 ? 0 <= x2 && x2 <= 1 ? 0 <= x3 && x3 <= 1 ? max(x1, x2, x3) : max(x1, x2) : 0 <= x3 && x3 <= 1 ? max(x1, x3) : x1 : 0 <= x2 && x2 <= 1 ? 0 <= x3 && x3 <= 1 ? max(x2, x3) : x2 : x3;
      }
      if (0 === discriminant) {
        u1 = q2 < 0 ? crt(-q2) : -crt(q2);
        x1 = 2 * u1 - a3;
        x2 = -u1 - a3;
        return 0 <= x1 && x1 <= 1 ? 0 <= x2 && x2 <= 1 ? max(x1, x2) : x1 : x2;
      }
      var sd = sqrt(discriminant);
      u1 = crt(-q2 + sd);
      v1 = crt(q2 + sd);
      x1 = u1 - v1 - a3;
      return x1;
    }
    function bezierByTime(controlPoints, x) {
      var percent = cardano(controlPoints, x);
      var p0y = 0;
      var p1y = controlPoints[1];
      var p2y = controlPoints[3];
      var p3y = 1;
      var t1 = 1 - percent;
      return p0y * t1 * t1 * t1 + 3 * p1y * percent * t1 * t1 + 3 * p2y * percent * percent * t1 + p3y * percent * percent * percent;
    }
    false;
    module.exports = {
      bezier: bezier,
      bezierByTime: bezierByTime
    };
  }), {} ],
  15: [ (function(require, module, exports) {
    var Easing = {
      constant: function() {
        return 0;
      },
      linear: function(k) {
        return k;
      },
      quadIn: function(k) {
        return k * k;
      },
      quadOut: function(k) {
        return k * (2 - k);
      },
      quadInOut: function(k) {
        if ((k *= 2) < 1) return .5 * k * k;
        return -.5 * (--k * (k - 2) - 1);
      },
      cubicIn: function(k) {
        return k * k * k;
      },
      cubicOut: function(k) {
        return --k * k * k + 1;
      },
      cubicInOut: function(k) {
        if ((k *= 2) < 1) return .5 * k * k * k;
        return .5 * ((k -= 2) * k * k + 2);
      },
      quartIn: function(k) {
        return k * k * k * k;
      },
      quartOut: function(k) {
        return 1 - --k * k * k * k;
      },
      quartInOut: function(k) {
        if ((k *= 2) < 1) return .5 * k * k * k * k;
        return -.5 * ((k -= 2) * k * k * k - 2);
      },
      quintIn: function(k) {
        return k * k * k * k * k;
      },
      quintOut: function(k) {
        return --k * k * k * k * k + 1;
      },
      quintInOut: function(k) {
        if ((k *= 2) < 1) return .5 * k * k * k * k * k;
        return .5 * ((k -= 2) * k * k * k * k + 2);
      },
      sineIn: function(k) {
        return 1 - Math.cos(k * Math.PI / 2);
      },
      sineOut: function(k) {
        return Math.sin(k * Math.PI / 2);
      },
      sineInOut: function(k) {
        return .5 * (1 - Math.cos(Math.PI * k));
      },
      expoIn: function(k) {
        return 0 === k ? 0 : Math.pow(1024, k - 1);
      },
      expoOut: function(k) {
        return 1 === k ? 1 : 1 - Math.pow(2, -10 * k);
      },
      expoInOut: function(k) {
        if (0 === k) return 0;
        if (1 === k) return 1;
        if ((k *= 2) < 1) return .5 * Math.pow(1024, k - 1);
        return .5 * (2 - Math.pow(2, -10 * (k - 1)));
      },
      circIn: function(k) {
        return 1 - Math.sqrt(1 - k * k);
      },
      circOut: function(k) {
        return Math.sqrt(1 - --k * k);
      },
      circInOut: function(k) {
        if ((k *= 2) < 1) return -.5 * (Math.sqrt(1 - k * k) - 1);
        return .5 * (Math.sqrt(1 - (k -= 2) * k) + 1);
      },
      elasticIn: function(k) {
        var s, a = .1, p = .4;
        if (0 === k) return 0;
        if (1 === k) return 1;
        if (!a || a < 1) {
          a = 1;
          s = p / 4;
        } else s = p * Math.asin(1 / a) / (2 * Math.PI);
        return -a * Math.pow(2, 10 * (k -= 1)) * Math.sin((k - s) * (2 * Math.PI) / p);
      },
      elasticOut: function(k) {
        var s, a = .1, p = .4;
        if (0 === k) return 0;
        if (1 === k) return 1;
        if (!a || a < 1) {
          a = 1;
          s = p / 4;
        } else s = p * Math.asin(1 / a) / (2 * Math.PI);
        return a * Math.pow(2, -10 * k) * Math.sin((k - s) * (2 * Math.PI) / p) + 1;
      },
      elasticInOut: function(k) {
        var s, a = .1, p = .4;
        if (0 === k) return 0;
        if (1 === k) return 1;
        if (!a || a < 1) {
          a = 1;
          s = p / 4;
        } else s = p * Math.asin(1 / a) / (2 * Math.PI);
        if ((k *= 2) < 1) return a * Math.pow(2, 10 * (k -= 1)) * Math.sin((k - s) * (2 * Math.PI) / p) * -.5;
        return a * Math.pow(2, -10 * (k -= 1)) * Math.sin((k - s) * (2 * Math.PI) / p) * .5 + 1;
      },
      backIn: function(k) {
        var s = 1.70158;
        return k * k * ((s + 1) * k - s);
      },
      backOut: function(k) {
        var s = 1.70158;
        return --k * k * ((s + 1) * k + s) + 1;
      },
      backInOut: function(k) {
        var s = 2.5949095;
        if ((k *= 2) < 1) return k * k * ((s + 1) * k - s) * .5;
        return .5 * ((k -= 2) * k * ((s + 1) * k + s) + 2);
      },
      bounceOut: function(k) {
        return k < 1 / 2.75 ? 7.5625 * k * k : k < 2 / 2.75 ? 7.5625 * (k -= 1.5 / 2.75) * k + .75 : k < 2.5 / 2.75 ? 7.5625 * (k -= 2.25 / 2.75) * k + .9375 : 7.5625 * (k -= 2.625 / 2.75) * k + .984375;
      },
      smooth: function(t) {
        if (t <= 0) return 0;
        if (t >= 1) return 1;
        return t * t * (3 - 2 * t);
      },
      fade: function(t) {
        if (t <= 0) return 0;
        if (t >= 1) return 1;
        return t * t * t * (t * (6 * t - 15) + 10);
      }
    };
    function _makeOutIn(fnIn, fnOut) {
      return function(k) {
        if (k < .5) return fnOut(2 * k) / 2;
        return fnIn(2 * k - 1) / 2 + .5;
      };
    }
    Easing.quadOutIn = _makeOutIn(Easing.quadIn, Easing.quadOut);
    Easing.cubicOutIn = _makeOutIn(Easing.cubicIn, Easing.cubicOut);
    Easing.quartOutIn = _makeOutIn(Easing.quartIn, Easing.quartOut);
    Easing.quintOutIn = _makeOutIn(Easing.quintIn, Easing.quintOut);
    Easing.sineOutIn = _makeOutIn(Easing.sineIn, Easing.sineOut);
    Easing.expoOutIn = _makeOutIn(Easing.expoIn, Easing.expoOut);
    Easing.circOutIn = _makeOutIn(Easing.circIn, Easing.circOut);
    Easing.backOutIn = _makeOutIn(Easing.backIn, Easing.backOut);
    Easing.backOutIn = _makeOutIn(Easing.backIn, Easing.backOut);
    Easing.bounceIn = function(k) {
      return 1 - Easing.bounceOut(1 - k);
    };
    Easing.bounceInOut = function(k) {
      if (k < .5) return .5 * Easing.bounceIn(2 * k);
      return .5 * Easing.bounceOut(2 * k - 1) + .5;
    };
    Easing.bounceOutIn = _makeOutIn(Easing.bounceIn, Easing.bounceOut);
    cc.Easing = module.exports = Easing;
  }), {} ],
  16: [ (function(require, module, exports) {
    require("./bezier");
    require("./easing");
    require("./types");
    require("./motion-path-helper");
    require("./animation-curves");
    require("./animation-clip");
    require("./animation-manager");
    require("./animation-state");
    require("./animation-animator");
  }), {
    "./animation-animator": 9,
    "./animation-clip": 10,
    "./animation-curves": 11,
    "./animation-manager": 12,
    "./animation-state": 13,
    "./bezier": 14,
    "./easing": 15,
    "./motion-path-helper": 17,
    "./types": 19
  } ],
  17: [ (function(require, module, exports) {
    var DynamicAnimCurve = require("./animation-curves").DynamicAnimCurve;
    var computeRatioByType = require("./animation-curves").computeRatioByType;
    var bezier = require("./bezier").bezier;
    var binarySearch = require("../core/utils/binary-search").binarySearchEpsilon;
    var v2 = cc.v2;
    function Curve(points) {
      this.points = points || [];
      this.beziers = [];
      this.ratios = [];
      this.progresses = [];
      this.length = 0;
      this.computeBeziers();
    }
    Curve.prototype.computeBeziers = function() {
      this.beziers.length = 0;
      this.ratios.length = 0;
      this.progresses.length = 0;
      this.length = 0;
      var bezier;
      for (var i = 1; i < this.points.length; i++) {
        var startPoint = this.points[i - 1];
        var endPoint = this.points[i];
        bezier = new Bezier();
        bezier.start = startPoint.pos;
        bezier.startCtrlPoint = startPoint.out;
        bezier.end = endPoint.pos;
        bezier.endCtrlPoint = endPoint.in;
        this.beziers.push(bezier);
        this.length += bezier.getLength();
      }
      var current = 0;
      for (var i = 0; i < this.beziers.length; i++) {
        bezier = this.beziers[i];
        this.ratios[i] = bezier.getLength() / this.length;
        this.progresses[i] = current += this.ratios[i];
      }
      return this.beziers;
    };
    function Bezier() {
      this.start = v2();
      this.end = v2();
      this.startCtrlPoint = v2();
      this.endCtrlPoint = v2();
    }
    Bezier.prototype.getPointAt = function(u) {
      var t = this.getUtoTmapping(u);
      return this.getPoint(t);
    };
    Bezier.prototype.getPoint = function(t) {
      var x = bezier(this.start.x, this.startCtrlPoint.x, this.endCtrlPoint.x, this.end.x, t);
      var y = bezier(this.start.y, this.startCtrlPoint.y, this.endCtrlPoint.y, this.end.y, t);
      return new v2(x, y);
    };
    Bezier.prototype.getLength = function() {
      var lengths = this.getLengths();
      return lengths[lengths.length - 1];
    };
    Bezier.prototype.getLengths = function(divisions) {
      divisions || (divisions = this.__arcLengthDivisions ? this.__arcLengthDivisions : 200);
      if (this.cacheArcLengths && this.cacheArcLengths.length === divisions + 1) return this.cacheArcLengths;
      var cache = [];
      var current, last = this.getPoint(0), vector = v2();
      var p, sum = 0;
      cache.push(0);
      for (p = 1; p <= divisions; p++) {
        current = this.getPoint(p / divisions);
        vector.x = last.x - current.x;
        vector.y = last.y - current.y;
        sum += vector.mag();
        cache.push(sum);
        last = current;
      }
      this.cacheArcLengths = cache;
      return cache;
    };
    Bezier.prototype.getUtoTmapping = function(u, distance) {
      var arcLengths = this.getLengths();
      var i = 0, il = arcLengths.length;
      var targetArcLength;
      targetArcLength = distance || u * arcLengths[il - 1];
      var low = 0, high = il - 1, comparison;
      while (low <= high) {
        i = Math.floor(low + (high - low) / 2);
        comparison = arcLengths[i] - targetArcLength;
        if (comparison < 0) {
          low = i + 1;
          continue;
        }
        if (comparison > 0) {
          high = i - 1;
          continue;
        }
        high = i;
        break;
      }
      i = high;
      if (arcLengths[i] === targetArcLength) {
        var t = i / (il - 1);
        return t;
      }
      var lengthBefore = arcLengths[i];
      var lengthAfter = arcLengths[i + 1];
      var segmentLength = lengthAfter - lengthBefore;
      var segmentFraction = (targetArcLength - lengthBefore) / segmentLength;
      var t = (i + segmentFraction) / (il - 1);
      return t;
    };
    function sampleMotionPaths(motionPaths, data, duration, fps) {
      function createControlPoints(array) {
        if (array instanceof cc.Vec2) return {
          in: array,
          pos: array,
          out: array
        };
        if (Array.isArray(array) && 6 === array.length) return {
          in: v2(array[2], array[3]),
          pos: v2(array[0], array[1]),
          out: v2(array[4], array[5])
        };
        return {
          in: cc.Vec2.ZERO,
          pos: cc.Vec2.ZERO,
          out: cc.Vec2.ZERO
        };
      }
      var values = data.values;
      if (0 === motionPaths.length || 0 === values.length) return;
      values = values.map((function(value) {
        return v2(value[0], value[1]);
      }));
      if (1 === values.length) {
        data.values = values;
        return;
      }
      var types = data.types;
      var ratios = data.ratios;
      var newValues = data.values = [];
      var newTypes = data.types = [];
      var newRatios = data.ratios = [];
      function addNewDatas(value, type, ratio) {
        newValues.push(value);
        newTypes.push(type);
        newRatios.push(ratio);
      }
      var startRatioOffset = 0;
      var EPSILON = 1e-6;
      var newType = DynamicAnimCurve.Linear;
      for (var i = 0, l = motionPaths.length; i < l - 1; i++) {
        var motionPath = motionPaths[i];
        var ratio = ratios[i];
        var nextRatio = ratios[i + 1];
        var betweenRatio = nextRatio - ratio;
        var value = values[i];
        var nextValue = values[i + 1];
        var type = types[i];
        var results = [];
        var progress = startRatioOffset / betweenRatio;
        var speed = 1 / (betweenRatio * duration * fps);
        var finalProgress;
        if (motionPath && motionPath.length > 0) {
          var points = [];
          points.push(createControlPoints(value));
          for (var j = 0, l2 = motionPath.length; j < l2; j++) {
            var controlPoints = createControlPoints(motionPath[j]);
            points.push(controlPoints);
          }
          points.push(createControlPoints(nextValue));
          var curve = new Curve(points);
          curve.computeBeziers();
          var progresses = curve.progresses;
          while (1 - progress > EPSILON) {
            finalProgress = progress;
            finalProgress = computeRatioByType(finalProgress, type);
            var pos, bezier, normal, length;
            if (finalProgress < 0) {
              bezier = curve.beziers[0];
              length = (0 - finalProgress) * bezier.getLength();
              normal = bezier.start.sub(bezier.endCtrlPoint).normalize();
              pos = bezier.start.add(normal.mul(length));
            } else if (finalProgress > 1) {
              bezier = curve.beziers[curve.beziers.length - 1];
              length = (finalProgress - 1) * bezier.getLength();
              normal = bezier.end.sub(bezier.startCtrlPoint).normalize();
              pos = bezier.end.add(normal.mul(length));
            } else {
              var bezierIndex = binarySearch(progresses, finalProgress);
              bezierIndex < 0 && (bezierIndex = ~bezierIndex);
              finalProgress -= bezierIndex > 0 ? progresses[bezierIndex - 1] : 0;
              finalProgress /= curve.ratios[bezierIndex];
              pos = curve.beziers[bezierIndex].getPointAt(finalProgress);
            }
            results.push(pos);
            progress += speed;
          }
        } else while (1 - progress > EPSILON) {
          finalProgress = progress;
          finalProgress = computeRatioByType(finalProgress, type);
          results.push(value.lerp(nextValue, finalProgress));
          progress += speed;
        }
        newType = "constant" === type ? type : DynamicAnimCurve.Linear;
        for (var j = 0, l2 = results.length; j < l2; j++) {
          var newRatio = ratio + startRatioOffset + speed * j * betweenRatio;
          addNewDatas(results[j], newType, newRatio);
        }
        startRatioOffset = Math.abs(progress - 1) > EPSILON ? (progress - 1) * betweenRatio : 0;
      }
      ratios[ratios.length - 1] !== newRatios[newRatios.length - 1] && addNewDatas(values[values.length - 1], newType, ratios[ratios.length - 1]);
    }
    false;
    module.exports = {
      sampleMotionPaths: sampleMotionPaths,
      Curve: Curve,
      Bezier: Bezier
    };
  }), {
    "../core/utils/binary-search": 202,
    "./animation-curves": 11,
    "./bezier": 14
  } ],
  18: [ (function(require, module, exports) {
    var js = cc.js;
    var debug = require("../core/CCDebug");
    function Playable() {
      this._isPlaying = false;
      this._isPaused = false;
      this._stepOnce = false;
    }
    var prototype = Playable.prototype;
    js.get(prototype, "isPlaying", (function() {
      return this._isPlaying;
    }), true);
    js.get(prototype, "isPaused", (function() {
      return this._isPaused;
    }), true);
    var virtual = function() {};
    prototype.onPlay = virtual;
    prototype.onPause = virtual;
    prototype.onResume = virtual;
    prototype.onStop = virtual;
    prototype.onError = virtual;
    prototype.play = function() {
      if (this._isPlaying) if (this._isPaused) {
        this._isPaused = false;
        this.onResume();
      } else this.onError(debug.getError(3912)); else {
        this._isPlaying = true;
        this.onPlay();
      }
    };
    prototype.stop = function() {
      if (this._isPlaying) {
        this._isPlaying = false;
        this.onStop();
        this._isPaused = false;
      }
    };
    prototype.pause = function() {
      if (this._isPlaying && !this._isPaused) {
        this._isPaused = true;
        this.onPause();
      }
    };
    prototype.resume = function() {
      if (this._isPlaying && this._isPaused) {
        this._isPaused = false;
        this.onResume();
      }
    };
    prototype.step = function() {
      this.pause();
      this._stepOnce = true;
      this._isPlaying || this.play();
    };
    module.exports = Playable;
  }), {
    "../core/CCDebug": 22
  } ],
  19: [ (function(require, module, exports) {
    var WrapModeMask = {
      Loop: 2,
      ShouldWrap: 4,
      PingPong: 22,
      Reverse: 36
    };
    var WrapMode = cc.Enum({
      Default: 0,
      Normal: 1,
      Reverse: WrapModeMask.Reverse,
      Loop: WrapModeMask.Loop,
      LoopReverse: WrapModeMask.Loop | WrapModeMask.Reverse,
      PingPong: WrapModeMask.PingPong,
      PingPongReverse: WrapModeMask.PingPong | WrapModeMask.Reverse
    });
    cc.WrapMode = WrapMode;
    function WrappedInfo(info) {
      if (info) {
        this.set(info);
        return;
      }
      this.ratio = 0;
      this.time = 0;
      this.direction = 1;
      this.stopped = true;
      this.iterations = 0;
      this.frameIndex = void 0;
    }
    WrappedInfo.prototype.set = function(info) {
      this.ratio = info.ratio;
      this.time = info.time;
      this.direction = info.direction;
      this.stopped = info.stopped;
      this.iterations = info.iterations;
      this.frameIndex = info.frameIndex;
    };
    module.exports = {
      WrapModeMask: WrapModeMask,
      WrapMode: WrapMode,
      WrappedInfo: WrappedInfo
    };
  }), {} ],
  20: [ (function(require, module, exports) {
    var EventTarget = require("../core/event/event-target");
    var sys = require("../core/platform/CCSys");
    var LoadMode = require("../core/assets/CCAudioClip").LoadMode;
    var touchBinded = false;
    var touchPlayList = [];
    var Audio = function(src) {
      EventTarget.call(this);
      this._src = src;
      this._element = null;
      this.id = 0;
      this._volume = 1;
      this._loop = false;
      this._nextTime = 0;
      this._state = Audio.State.INITIALZING;
      this._onended = function() {
        this.emit("ended");
      }.bind(this);
    };
    cc.js.extend(Audio, EventTarget);
    Audio.State = {
      ERROR: -1,
      INITIALZING: 0,
      PLAYING: 1,
      PAUSED: 2,
      STOPPED: 3
    };
    (function(proto) {
      proto._bindEnded = function(callback) {
        callback = callback || this._onended;
        var elem = this._element;
        this._src && elem instanceof HTMLAudioElement ? elem.addEventListener("ended", callback) : elem.onended = callback;
      };
      proto._unbindEnded = function() {
        var elem = this._element;
        elem instanceof HTMLAudioElement ? elem.removeEventListener("ended", this._onended) : elem && (elem.onended = null);
      };
      proto._onLoaded = function() {
        var elem = this._src._nativeAsset;
        if (elem instanceof HTMLAudioElement) {
          this._element || (this._element = document.createElement("audio"));
          this._element.src = elem.src;
        } else this._element = new WebAudioElement(elem, this);
        this.setVolume(this._volume);
        this.setLoop(this._loop);
        0 !== this._nextTime && this.setCurrentTime(this._nextTime);
        this._state === Audio.State.PLAYING ? this.play() : this._state = Audio.State.INITIALZING;
      };
      proto.play = function() {
        this._state = Audio.State.PLAYING;
        if (!this._element) return;
        this._bindEnded();
        this._element.play();
        true, false;
      };
      proto.destroy = function() {
        true;
        this._element && this._element.destroy();
        this._element = null;
      };
      proto.pause = function() {
        if (!this._element || this._state !== Audio.State.PLAYING) return;
        this._unbindEnded();
        this._element.pause();
        this._state = Audio.State.PAUSED;
      };
      proto.resume = function() {
        if (!this._element || this._state !== Audio.State.PAUSED) return;
        this._bindEnded();
        this._element.play();
        this._state = Audio.State.PLAYING;
      };
      proto.stop = function() {
        if (!this._element) return;
        this._element.pause();
        try {
          this._element.currentTime = 0;
        } catch (error) {}
        for (var i = 0; i < touchPlayList.length; i++) if (touchPlayList[i].instance === this) {
          touchPlayList.splice(i, 1);
          break;
        }
        this._unbindEnded();
        this.emit("stop");
        this._state = Audio.State.STOPPED;
      };
      proto.setLoop = function(loop) {
        this._loop = loop;
        this._element && (this._element.loop = loop);
      };
      proto.getLoop = function() {
        return this._loop;
      };
      proto.setVolume = function(num) {
        this._volume = num;
        this._element && (this._element.volume = num);
      };
      proto.getVolume = function() {
        return this._volume;
      };
      proto.setCurrentTime = function(num) {
        var _this = this;
        if (!this._element) {
          this._nextTime = num;
          return;
        }
        this._nextTime = 0;
        this._unbindEnded();
        (false, true) || this._bindEnded(function() {
          this._bindEnded();
        }.bind(this));
        try {
          this._element.currentTime = num;
        } catch (err) {
          (function() {
            var _element = _this._element;
            _element.addEventListener && (function() {
              var func = function() {
                _element.removeEventListener("loadedmetadata", func);
                _element.currentTime = num;
              };
              _element.addEventListener("loadedmetadata", func);
            })();
          })();
        }
      };
      proto.getCurrentTime = function() {
        return this._element ? this._element.currentTime : 0;
      };
      proto.getDuration = function() {
        return this._element ? this._element.duration : 0;
      };
      proto.getState = function() {
        var elem;
        false;
        return this._state;
      };
      proto.__defineGetter__("src", (function() {
        return this._src;
      }));
      proto.__defineSetter__("src", (function(clip) {
        var _this2 = this;
        this._unbindEnded();
        if (clip) {
          this._src = clip;
          clip.loaded ? this._onLoaded() : (function() {
            var self = _this2;
            clip.once("load", (function() {
              clip === self._src && self._onLoaded();
            }));
            cc.loader.load({
              url: clip.nativeUrl,
              skips: [ "Loader" ]
            }, (function(err, audioNativeAsset) {
              if (err) {
                cc.error(err);
                return;
              }
              clip.loaded || (clip._nativeAsset = audioNativeAsset);
            }));
          })();
        } else {
          this._src = null;
          this._element instanceof HTMLAudioElement ? this._element.src = "" : this._element = null;
          this._state = Audio.State.INITIALZING;
        }
        return clip;
      }));
      proto.__defineGetter__("paused", (function() {
        return !this._element || this._element.paused;
      }));
    })(Audio.prototype);
    var WebAudioElement = function(buffer, audio) {
      this._audio = audio;
      this._context = sys.__audioSupport.context;
      this._buffer = buffer;
      this._gainObj = this._context["createGain"]();
      this._volume = 1;
      this._gainObj["gain"].setTargetAtTime ? this._gainObj["gain"].setTargetAtTime(this._volume, this._context.currentTime, .01) : this._gainObj["gain"].value = 1;
      this._gainObj["connect"](this._context["destination"]);
      this._loop = false;
      this._startTime = -1;
      this._currentSource = null;
      this.playedLength = 0;
      this._currextTimer = null;
      this._endCallback = function() {
        this.onended && this.onended(this);
      }.bind(this);
    };
    (function(proto) {
      proto.play = function(offset) {
        var _this3 = this;
        if (this._currentSource && !this.paused) {
          this._currentSource.onended = null;
          this._currentSource.stop(0);
          this.playedLength = 0;
        }
        var audio = this._context["createBufferSource"]();
        audio.buffer = this._buffer;
        audio["connect"](this._gainObj);
        audio.loop = this._loop;
        this._startTime = this._context.currentTime;
        offset = offset || this.playedLength;
        offset && (this._startTime -= offset);
        var duration = this._buffer.duration;
        var startTime = offset;
        var endTime = void 0;
        if (this._loop) audio.start ? audio.start(0, startTime) : audio["notoGrainOn"] ? audio["noteGrainOn"](0, startTime) : audio["noteOn"](0, startTime); else {
          endTime = duration - offset;
          audio.start ? audio.start(0, startTime, endTime) : audio["notoGrainOn"] ? audio["noteGrainOn"](0, startTime, endTime) : audio["noteOn"](0, startTime, endTime);
        }
        this._currentSource = audio;
        audio.onended = this._endCallback;
        audio.context.state && "suspended" !== audio.context.state || 0 !== this._context.currentTime || (function() {
          var self = _this3;
          clearTimeout(_this3._currextTimer);
          _this3._currextTimer = setTimeout((function() {
            (false, true) || 0 !== self._context.currentTime || touchPlayList.push({
              instance: self._audio,
              offset: offset,
              audio: self
            });
          }), 10);
        })();
      };
      proto.pause = function() {
        clearTimeout(this._currextTimer);
        if (this.paused) return;
        this.playedLength = this._context.currentTime - this._startTime;
        this.playedLength %= this._buffer.duration;
        var audio = this._currentSource;
        this._currentSource = null;
        this._startTime = -1;
        audio && audio.stop(0);
      };
      proto.__defineGetter__("paused", (function() {
        if (this._currentSource && this._currentSource.loop) return false;
        if (-1 === this._startTime) return true;
        return this._context.currentTime - this._startTime > this._buffer.duration;
      }));
      proto.__defineGetter__("loop", (function() {
        return this._loop;
      }));
      proto.__defineSetter__("loop", (function(bool) {
        this._currentSource && (this._currentSource.loop = bool);
        return this._loop = bool;
      }));
      proto.__defineGetter__("volume", (function() {
        return this._volume;
      }));
      proto.__defineSetter__("volume", (function(num) {
        this._volume = num;
        this._gainObj["gain"].setTargetAtTime ? this._gainObj["gain"].setTargetAtTime(this._volume, this._context.currentTime, .01) : this._volume["gain"].value = num;
        if (sys.os === sys.OS_IOS && !this.paused && this._currentSource) {
          this._currentSource.onended = null;
          this.pause();
          this.play();
        }
        return num;
      }));
      proto.__defineGetter__("currentTime", (function() {
        if (this.paused) return this.playedLength;
        this.playedLength = this._context.currentTime - this._startTime;
        this.playedLength %= this._buffer.duration;
        return this.playedLength;
      }));
      proto.__defineSetter__("currentTime", (function(num) {
        if (this.paused) this.playedLength = num; else {
          this.pause();
          this.playedLength = num;
          this.play();
        }
        return num;
      }));
      proto.__defineGetter__("duration", (function() {
        return this._buffer.duration;
      }));
    })(WebAudioElement.prototype);
    module.exports = cc.Audio = Audio;
  }), {
    "../core/assets/CCAudioClip": 30,
    "../core/event/event-target": 91,
    "../core/platform/CCSys": 156
  } ],
  21: [ (function(require, module, exports) {
    var Audio = require("./CCAudio");
    var AudioClip = require("../core/assets/CCAudioClip");
    var js = cc.js;
    var _instanceId = 0;
    var _id2audio = js.createMap(true);
    var _url2id = {};
    var _audioPool = [];
    var recycleAudio = function(audio) {
      if (_audioPool.length < 32) {
        audio.off("ended");
        audio.off("stop");
        audio.src = null;
        _audioPool.push(audio);
      } else audio.destroy();
    };
    var getAudioFromPath = function(path) {
      var id = _instanceId++;
      var list = _url2id[path];
      list || (list = _url2id[path] = []);
      if (audioEngine._maxAudioInstance <= list.length) {
        var oldId = list.shift();
        var oldAudio = getAudioFromId(oldId);
        oldAudio.stop();
      }
      var audio = _audioPool.pop() || new Audio();
      var callback = function() {
        audio._finishCallback && audio._finishCallback();
        var audioInList = getAudioFromId(this.id);
        if (audioInList) {
          delete _id2audio[this.id];
          var index = list.indexOf(this.id);
          cc.js.array.fastRemoveAt(list, index);
        }
        recycleAudio(this);
      };
      audio.on("ended", callback, audio);
      audio.on("stop", callback, audio);
      audio.id = id;
      _id2audio[id] = audio;
      list.push(id);
      return audio;
    };
    var getAudioFromId = function(id) {
      return _id2audio[id];
    };
    var audioEngine = {
      AudioState: Audio.State,
      _maxWebAudioSize: 2097152,
      _maxAudioInstance: 24,
      _id2audio: _id2audio,
      play: function(clip, loop, volume) {
        var path = clip;
        var audio;
        if ("string" === typeof clip) {
          cc.warnID(8401, "cc.audioEngine", "cc.AudioClip", "AudioClip", "cc.AudioClip", "audio");
          path = clip;
          audio = getAudioFromPath(path);
          AudioClip._loadByUrl(path, (function(err, clip) {
            clip && (audio.src = clip);
          }));
        } else {
          if (!clip) return;
          path = clip.nativeUrl;
          audio = getAudioFromPath(path);
          audio.src = clip;
        }
        audio.setLoop(loop || false);
        "number" !== typeof volume && (volume = 1);
        audio.setVolume(volume);
        audio.play();
        return audio.id;
      },
      setLoop: function(audioID, loop) {
        var audio = getAudioFromId(audioID);
        if (!audio || !audio.setLoop) return;
        audio.setLoop(loop);
      },
      isLoop: function(audioID) {
        var audio = getAudioFromId(audioID);
        if (!audio || !audio.getLoop) return false;
        return audio.getLoop();
      },
      setVolume: function(audioID, volume) {
        var audio = getAudioFromId(audioID);
        audio && audio.setVolume(volume);
      },
      getVolume: function(audioID) {
        var audio = getAudioFromId(audioID);
        return audio ? audio.getVolume() : 1;
      },
      setCurrentTime: function(audioID, sec) {
        var audio = getAudioFromId(audioID);
        if (audio) {
          audio.setCurrentTime(sec);
          return true;
        }
        return false;
      },
      getCurrentTime: function(audioID) {
        var audio = getAudioFromId(audioID);
        return audio ? audio.getCurrentTime() : 0;
      },
      getDuration: function(audioID) {
        var audio = getAudioFromId(audioID);
        return audio ? audio.getDuration() : 0;
      },
      getState: function(audioID) {
        var audio = getAudioFromId(audioID);
        return audio ? audio.getState() : this.AudioState.ERROR;
      },
      setFinishCallback: function(audioID, callback) {
        var audio = getAudioFromId(audioID);
        if (!audio) return;
        audio._finishCallback = callback;
      },
      pause: function(audioID) {
        var audio = getAudioFromId(audioID);
        if (audio) {
          audio.pause();
          return true;
        }
        return false;
      },
      _pauseIDCache: [],
      pauseAll: function() {
        for (var id in _id2audio) {
          var audio = _id2audio[id];
          var state = audio.getState();
          if (state === Audio.State.PLAYING) {
            this._pauseIDCache.push(id);
            audio.pause();
          }
        }
      },
      resume: function(audioID) {
        var audio = getAudioFromId(audioID);
        audio && audio.resume();
      },
      resumeAll: function() {
        for (var i = 0; i < this._pauseIDCache.length; ++i) {
          var id = this._pauseIDCache[i];
          var audio = getAudioFromId(id);
          audio && audio.resume();
        }
        this._pauseIDCache.length = 0;
      },
      stop: function(audioID) {
        var audio = getAudioFromId(audioID);
        if (audio) {
          audio.stop();
          return true;
        }
        return false;
      },
      stopAll: function() {
        for (var id in _id2audio) {
          var audio = _id2audio[id];
          audio && audio.stop();
        }
      },
      setMaxAudioInstance: function(num) {
        this._maxAudioInstance = num;
      },
      getMaxAudioInstance: function() {
        return this._maxAudioInstance;
      },
      uncache: function(clip) {
        var filePath = clip;
        if ("string" === typeof clip) {
          cc.warnID(8401, "cc.audioEngine", "cc.AudioClip", "AudioClip", "cc.AudioClip", "audio");
          filePath = clip;
        } else {
          if (!clip) return;
          filePath = clip.nativeUrl;
        }
        var list = _url2id[filePath];
        if (!list) return;
        while (list.length > 0) {
          var id = list.pop();
          var audio = _id2audio[id];
          if (audio) {
            audio.stop();
            delete _id2audio[id];
          }
        }
      },
      uncacheAll: function() {
        this.stopAll();
        var audio = void 0;
        for (var id in _id2audio) {
          audio = _id2audio[id];
          audio && audio.destroy();
        }
        while (audio = _audioPool.pop()) audio.destroy();
        _id2audio = js.createMap(true);
        _url2id = {};
      },
      getProfile: function(profileName) {},
      preload: function(filePath, callback) {
        true;
        cc.warn("`cc.audioEngine.preload` is deprecated, use `cc.loader.loadRes(url, cc.AudioClip)` instead please.");
        cc.loader.load(filePath, callback && function(error) {
          error || callback();
        });
      },
      setMaxWebAudioSize: function(kb) {
        this._maxWebAudioSize = 1024 * kb;
      },
      _breakCache: null,
      _break: function() {
        this._breakCache = [];
        for (var id in _id2audio) {
          var audio = _id2audio[id];
          var state = audio.getState();
          if (state === Audio.State.PLAYING) {
            this._breakCache.push(id);
            audio.pause();
          }
        }
      },
      _restore: function() {
        if (!this._breakCache) return;
        while (this._breakCache.length > 0) {
          var id = this._breakCache.pop();
          var audio = getAudioFromId(id);
          audio && audio.resume && audio.resume();
        }
        this._breakCache = null;
      },
      _music: {
        id: -1,
        loop: false,
        volume: 1
      },
      _effect: {
        volume: 1,
        pauseCache: []
      },
      playMusic: function(clip, loop) {
        var music = this._music;
        this.stop(music.id);
        music.id = this.play(clip, loop, music.volume);
        music.loop = loop;
        return music.id;
      },
      stopMusic: function() {
        this.stop(this._music.id);
      },
      pauseMusic: function() {
        this.pause(this._music.id);
        return this._music.id;
      },
      resumeMusic: function() {
        this.resume(this._music.id);
        return this._music.id;
      },
      getMusicVolume: function() {
        return this._music.volume;
      },
      setMusicVolume: function(volume) {
        var music = this._music;
        music.volume = volume;
        this.setVolume(music.id, music.volume);
        return music.volume;
      },
      isMusicPlaying: function() {
        return this.getState(this._music.id) === this.AudioState.PLAYING;
      },
      playEffect: function(clip, loop) {
        return this.play(clip, loop || false, this._effect.volume);
      },
      setEffectsVolume: function(volume) {
        var musicId = this._music.id;
        this._effect.volume = volume;
        for (var id in _id2audio) {
          if (id === musicId) continue;
          audioEngine.setVolume(id, volume);
        }
      },
      getEffectsVolume: function() {
        return this._effect.volume;
      },
      pauseEffect: function(audioID) {
        return this.pause(audioID);
      },
      pauseAllEffects: function() {
        var musicId = this._music.id;
        var effect = this._effect;
        effect.pauseCache.length = 0;
        for (var id in _id2audio) {
          if (id === musicId) continue;
          var audio = _id2audio[id];
          var state = audio.getState();
          if (state === this.AudioState.PLAYING) {
            effect.pauseCache.push(id);
            audio.pause();
          }
        }
      },
      resumeEffect: function(id) {
        this.resume(id);
      },
      resumeAllEffects: function() {
        var pauseIDCache = this._effect.pauseCache;
        for (var i = 0; i < pauseIDCache.length; ++i) {
          var id = pauseIDCache[i];
          var audio = _id2audio[id];
          audio && audio.resume();
        }
      },
      stopEffect: function(audioID) {
        return this.stop(audioID);
      },
      stopAllEffects: function() {
        var musicId = this._music.id;
        for (var id in _id2audio) {
          if (id === musicId) continue;
          var audio = _id2audio[id];
          var state = audio.getState();
          state === audioEngine.AudioState.PLAYING && audio.stop();
        }
      }
    };
    module.exports = cc.audioEngine = audioEngine;
  }), {
    "../core/assets/CCAudioClip": 30,
    "./CCAudio": 20
  } ],
  22: [ (function(require, module, exports) {
    var debugInfos = require("../../DebugInfos") || {};
    var ERROR_MAP_URL = "https://github.com/cocos-creator/engine/blob/master/EngineErrorMap.md";
    var logList = void 0;
    var resetDebugSetting = function(mode) {
      cc.log = cc.warn = cc.error = cc.assert = function() {};
      if (mode === DebugMode.NONE) return;
      if (mode > DebugMode.ERROR) (function() {
        function logToWebPage(msg) {
          if (!cc.game.canvas) return;
          if (!logList) {
            var logDiv = document.createElement("Div");
            logDiv.setAttribute("id", "logInfoDiv");
            logDiv.setAttribute("width", "200");
            logDiv.setAttribute("height", cc.game.canvas.height);
            var logDivStyle = logDiv.style;
            logDivStyle.zIndex = "99999";
            logDivStyle.position = "absolute";
            logDivStyle.top = logDivStyle.left = "0";
            logList = document.createElement("textarea");
            logList.setAttribute("rows", "20");
            logList.setAttribute("cols", "30");
            logList.setAttribute("disabled", "true");
            var logListStyle = logList.style;
            logListStyle.backgroundColor = "transparent";
            logListStyle.borderBottom = "1px solid #cccccc";
            logListStyle.borderTopWidth = logListStyle.borderLeftWidth = logListStyle.borderRightWidth = "0px";
            logListStyle.borderTopStyle = logListStyle.borderLeftStyle = logListStyle.borderRightStyle = "none";
            logListStyle.padding = "0px";
            logListStyle.margin = 0;
            logDiv.appendChild(logList);
            cc.game.canvas.parentNode.appendChild(logDiv);
          }
          logList.value = logList.value + msg + "\r\n";
          logList.scrollTop = logList.scrollHeight;
        }
        cc.error = function() {
          logToWebPage("ERROR :  " + cc.js.formatStr.apply(null, arguments));
        };
        cc.assert = function(cond, msg) {
          "use strict";
          if (!cond && msg) {
            msg = cc.js.formatStr.apply(null, cc.js.shiftArguments.apply(null, arguments));
            logToWebPage("ASSERT: " + msg);
          }
        };
        mode !== DebugMode.ERROR_FOR_WEB_PAGE && (cc.warn = function() {
          logToWebPage("WARN :  " + cc.js.formatStr.apply(null, arguments));
        });
        mode === DebugMode.INFO_FOR_WEB_PAGE && (cc.log = function() {
          logToWebPage(cc.js.formatStr.apply(null, arguments));
        });
      })(); else if (console && console.log.apply) {
        console.error || (console.error = console.log);
        console.warn || (console.warn = console.log);
        false;
        console.error.bind ? cc.error = console.error.bind(console) : cc.error = function() {
          return console.error.apply(console, arguments);
        };
        cc.assert = function(cond, msg) {
          if (!cond) {
            msg && (msg = cc.js.formatStr.apply(null, cc.js.shiftArguments.apply(null, arguments)));
            false;
            false;
            throw new Error(msg);
          }
        };
      }
      if (mode !== DebugMode.ERROR) {
        false;
        console.warn.bind ? cc.warn = console.warn.bind(console) : cc.warn = function() {
          return console.warn.apply(console, arguments);
        };
      }
      false;
      if (mode === DebugMode.INFO) {
        false;
        console.log.bind ? cc.log = console.log.bind(console) : cc.log = function() {
          return console.log.apply(console, arguments);
        };
      }
    };
    cc._throw = function(error) {
      var stack = error.stack;
      stack ? cc.error(stack) : cc.error(error);
    };
    function getTypedFormatter(type) {
      return function() {
        var id = arguments[0];
        var msg = debugInfos[id] || "unknown id";
        if (1 === arguments.length) return msg;
        if (2 === arguments.length) return cc.js.formatStr(msg, arguments[1]);
        var argsArray = cc.js.shiftArguments.apply(null, arguments);
        return cc.js.formatStr.apply(null, [ msg ].concat(argsArray));
      };
    }
    var logFormatter = getTypedFormatter("Log");
    cc.logID = function() {
      cc.log(logFormatter.apply(null, arguments));
    };
    var warnFormatter = getTypedFormatter("Warning");
    cc.warnID = function() {
      cc.warn(warnFormatter.apply(null, arguments));
    };
    var errorFormatter = getTypedFormatter("Error");
    cc.errorID = function() {
      cc.error(errorFormatter.apply(null, arguments));
    };
    var assertFormatter = getTypedFormatter("Assert");
    cc.assertID = function(cond) {
      "use strict";
      if (cond) return;
      cc.assert(false, assertFormatter.apply(null, cc.js.shiftArguments.apply(null, arguments)));
    };
    var DebugMode = cc.Enum({
      NONE: 0,
      INFO: 1,
      WARN: 2,
      ERROR: 3,
      INFO_FOR_WEB_PAGE: 4,
      WARN_FOR_WEB_PAGE: 5,
      ERROR_FOR_WEB_PAGE: 6
    });
    module.exports = cc.debug = {
      DebugMode: DebugMode,
      _resetDebugSetting: resetDebugSetting,
      getError: getTypedFormatter("ERROR"),
      isDisplayStats: function() {
        return !!cc.profiler && cc.profiler.isShowingStats();
      },
      setDisplayStats: function(displayStats) {
        if (cc.profiler) {
          displayStats ? cc.profiler.showStats() : cc.profiler.hideStats();
          cc.game.config.showFPS = !!displayStats;
        }
      }
    };
  }), {
    "../../DebugInfos": 1
  } ],
  23: [ (function(require, module, exports) {
    var EventTarget = require("./event/event-target");
    var AutoReleaseUtils = require("./load-pipeline/auto-release-utils");
    var ComponentScheduler = require("./component-scheduler");
    var NodeActivator = require("./node-activator");
    var Obj = require("./platform/CCObject");
    var game = require("./CCGame");
    var renderer = require("./renderer");
    var eventManager = require("./event-manager");
    var Scheduler = require("./CCScheduler");
    cc.Director = function() {
      EventTarget.call(this);
      this.invalid = false;
      this._paused = false;
      this._purgeDirectorInNextLoop = false;
      this._winSizeInPoints = null;
      this._loadingScene = "";
      this._scene = null;
      this._totalFrames = 0;
      this._lastUpdate = 0;
      this._deltaTime = 0;
      this._scheduler = null;
      this._compScheduler = null;
      this._nodeActivator = null;
      this._actionManager = null;
      var self = this;
      game.on(game.EVENT_SHOW, (function() {
        self._lastUpdate = performance.now();
      }));
      game.once(game.EVENT_ENGINE_INITED, this.init, this);
    };
    cc.Director.prototype = {
      constructor: cc.Director,
      init: function() {
        this._totalFrames = 0;
        this._lastUpdate = performance.now();
        this._paused = false;
        this._purgeDirectorInNextLoop = false;
        this._winSizeInPoints = cc.size(0, 0);
        this._scheduler = new Scheduler();
        if (cc.ActionManager) {
          this._actionManager = new cc.ActionManager();
          this._scheduler.scheduleUpdate(this._actionManager, Scheduler.PRIORITY_SYSTEM, false);
        } else this._actionManager = null;
        this.sharedInit();
        return true;
      },
      sharedInit: function() {
        this._compScheduler = new ComponentScheduler();
        this._nodeActivator = new NodeActivator();
        eventManager && eventManager.setEnabled(true);
        if (cc.AnimationManager) {
          this._animationManager = new cc.AnimationManager();
          this._scheduler.scheduleUpdate(this._animationManager, Scheduler.PRIORITY_SYSTEM, false);
        } else this._animationManager = null;
        if (cc.CollisionManager) {
          this._collisionManager = new cc.CollisionManager();
          this._scheduler.scheduleUpdate(this._collisionManager, Scheduler.PRIORITY_SYSTEM, false);
        } else this._collisionManager = null;
        if (cc.PhysicsManager) {
          this._physicsManager = new cc.PhysicsManager();
          this._scheduler.scheduleUpdate(this._physicsManager, Scheduler.PRIORITY_SYSTEM, false);
        } else this._physicsManager = null;
        cc._widgetManager && cc._widgetManager.init(this);
        cc.loader.init(this);
      },
      calculateDeltaTime: function() {
        var now = performance.now();
        this._deltaTime = (now - this._lastUpdate) / 1e3;
        (true, this._deltaTime > 1) && (this._deltaTime = 1 / 60);
        this._lastUpdate = now;
      },
      convertToGL: function(uiPoint) {
        var container = game.container;
        var view = cc.view;
        var box = container.getBoundingClientRect();
        var left = box.left + window.pageXOffset - container.clientLeft;
        var top = box.top + window.pageYOffset - container.clientTop;
        var x = view._devicePixelRatio * (uiPoint.x - left);
        var y = view._devicePixelRatio * (top + box.height - uiPoint.y);
        return view._isRotated ? cc.v2(view._viewportRect.width - y, x) : cc.v2(x, y);
      },
      convertToUI: function(glPoint) {
        var container = game.container;
        var view = cc.view;
        var box = container.getBoundingClientRect();
        var left = box.left + window.pageXOffset - container.clientLeft;
        var top = box.top + window.pageYOffset - container.clientTop;
        var uiPoint = cc.v2(0, 0);
        if (view._isRotated) {
          uiPoint.x = left + glPoint.y / view._devicePixelRatio;
          uiPoint.y = top + box.height - (view._viewportRect.width - glPoint.x) / view._devicePixelRatio;
        } else {
          uiPoint.x = left + glPoint.x * view._devicePixelRatio;
          uiPoint.y = top + box.height - glPoint.y * view._devicePixelRatio;
        }
        return uiPoint;
      },
      end: function() {
        this._purgeDirectorInNextLoop = true;
      },
      getWinSize: function() {
        return cc.size(cc.winSize);
      },
      getWinSizeInPixels: function() {
        return cc.size(cc.winSize);
      },
      pause: function() {
        if (this._paused) return;
        this._paused = true;
      },
      purgeCachedData: function() {
        cc.loader.releaseAll();
      },
      purgeDirector: function() {
        this._scheduler.unscheduleAll();
        this._compScheduler.unscheduleAll();
        this._nodeActivator.reset();
        eventManager && eventManager.setEnabled(false);
        cc.renderer.clear();
        true;
        cc.isValid(this._scene) && this._scene.destroy();
        this._scene = null;
        this.stopAnimation();
        cc.loader.releaseAll();
      },
      reset: function() {
        this.purgeDirector();
        eventManager && eventManager.setEnabled(true);
        this._actionManager && this._scheduler.scheduleUpdate(this._actionManager, cc.Scheduler.PRIORITY_SYSTEM, false);
        this._animationManager && this._scheduler.scheduleUpdate(this._animationManager, cc.Scheduler.PRIORITY_SYSTEM, false);
        this._collisionManager && this._scheduler.scheduleUpdate(this._collisionManager, cc.Scheduler.PRIORITY_SYSTEM, false);
        this._physicsManager && this._scheduler.scheduleUpdate(this._physicsManager, cc.Scheduler.PRIORITY_SYSTEM, false);
        this.startAnimation();
      },
      runSceneImmediate: function(scene, onBeforeLoadScene, onLaunched) {
        cc.assertID(scene instanceof cc.Scene, 1216);
        (true, true) && console.time("InitScene");
        scene._load();
        (true, true) && console.timeEnd("InitScene");
        (true, true) && console.time("AttachPersist");
        var persistNodeList = Object.keys(game._persistRootNodes).map((function(x) {
          return game._persistRootNodes[x];
        }));
        for (var i = 0; i < persistNodeList.length; i++) {
          var node = persistNodeList[i];
          var existNode = scene.getChildByUuid(node.uuid);
          if (existNode) {
            var index = existNode.getSiblingIndex();
            existNode._destroyImmediate();
            scene.insertChild(node, index);
          } else node.parent = scene;
        }
        (true, true) && console.timeEnd("AttachPersist");
        var oldScene = this._scene;
        true;
        (true, true) && console.time("AutoRelease");
        var autoReleaseAssets = oldScene && oldScene.autoReleaseAssets && oldScene.dependAssets;
        AutoReleaseUtils.autoRelease(autoReleaseAssets, scene.dependAssets, persistNodeList);
        (true, true) && console.timeEnd("AutoRelease");
        (true, true) && console.time("Destroy");
        cc.isValid(oldScene) && oldScene.destroy();
        this._scene = null;
        Obj._deferredDestroy();
        (true, true) && console.timeEnd("Destroy");
        onBeforeLoadScene && onBeforeLoadScene();
        this.emit(cc.Director.EVENT_BEFORE_SCENE_LAUNCH, scene);
        this._scene = scene;
        (true, true) && console.time("Activate");
        scene._activate();
        (true, true) && console.timeEnd("Activate");
        this.startAnimation();
        onLaunched && onLaunched(null, scene);
        this.emit(cc.Director.EVENT_AFTER_SCENE_LAUNCH, scene);
      },
      runScene: function(scene, onBeforeLoadScene, onLaunched) {
        cc.assertID(scene, 1205);
        cc.assertID(scene instanceof cc.Scene, 1216);
        scene._load();
        this.once(cc.Director.EVENT_AFTER_UPDATE, (function() {
          this.runSceneImmediate(scene, onBeforeLoadScene, onLaunched);
        }), this);
      },
      _getSceneUuid: function(key) {
        var scenes = game._sceneInfos;
        if ("string" === typeof key) {
          key.endsWith(".fire") || (key += ".fire");
          "/" === key[0] || key.startsWith("db://assets/") || (key = "/" + key);
          for (var i = 0; i < scenes.length; i++) {
            var info = scenes[i];
            if (info.url.endsWith(key)) return info;
          }
        } else if ("number" === typeof key) {
          if (0 <= key && key < scenes.length) return scenes[key];
          cc.errorID(1206, key);
        } else cc.errorID(1207, key);
        return null;
      },
      loadScene: function(sceneName, onLaunched, _onUnloaded) {
        if (this._loadingScene) {
          cc.errorID(1208, sceneName, this._loadingScene);
          return false;
        }
        var info = this._getSceneUuid(sceneName);
        if (info) {
          var uuid = info.uuid;
          this.emit(cc.Director.EVENT_BEFORE_SCENE_LOADING, sceneName);
          this._loadingScene = sceneName;
          this._loadSceneByUuid(uuid, onLaunched, _onUnloaded);
          return true;
        }
        cc.errorID(1209, sceneName);
        return false;
      },
      preloadScene: function(sceneName, onProgress, onLoaded) {
        if (void 0 === onLoaded) {
          onLoaded = onProgress;
          onProgress = null;
        }
        var info = this._getSceneUuid(sceneName);
        if (info) {
          this.emit(cc.Director.EVENT_BEFORE_SCENE_LOADING, sceneName);
          cc.loader.load({
            uuid: info.uuid,
            type: "uuid"
          }, onProgress, (function(error, asset) {
            error && cc.errorID(1210, sceneName, error.message);
            onLoaded && onLoaded(error, asset);
          }));
        } else {
          var error = 'Can not preload the scene "' + sceneName + '" because it is not in the build settings.';
          onLoaded(new Error(error));
          cc.error("preloadScene: " + error);
        }
      },
      _loadSceneByUuid: function(uuid, onLaunched, onUnloaded, dontRunScene) {
        false;
        console.time("LoadScene " + uuid);
        cc.AssetLibrary.loadAsset(uuid, (function(error, sceneAsset) {
          console.timeEnd("LoadScene " + uuid);
          var self = cc.director;
          self._loadingScene = "";
          if (error) {
            error = "Failed to load scene: " + error;
            cc.error(error);
          } else {
            if (sceneAsset instanceof cc.SceneAsset) {
              var scene = sceneAsset.scene;
              scene._id = sceneAsset._uuid;
              scene._name = sceneAsset._name;
              false;
              self.runSceneImmediate(scene, onUnloaded, onLaunched);
              return;
            }
            error = "The asset " + uuid + " is not a scene";
            cc.error(error);
          }
          onLaunched && onLaunched(error);
        }));
      },
      resume: function() {
        if (!this._paused) return;
        this._lastUpdate = performance.now();
        this._lastUpdate || cc.logID(1200);
        this._paused = false;
        this._deltaTime = 0;
      },
      setDepthTest: function(value) {
        if (!cc.Camera.main) return;
        cc.Camera.main.depth = !!value;
      },
      setClearColor: function(clearColor) {
        if (!cc.Camera.main) return;
        cc.Camera.main.backgroundColor = clearColor;
      },
      getRunningScene: function() {
        return this._scene;
      },
      getScene: function() {
        return this._scene;
      },
      getAnimationInterval: function() {
        return 1e3 / game.getFrameRate();
      },
      setAnimationInterval: function(value) {
        game.setFrameRate(Math.round(1e3 / value));
      },
      getDeltaTime: function() {
        return this._deltaTime;
      },
      getTotalFrames: function() {
        return this._totalFrames;
      },
      isPaused: function() {
        return this._paused;
      },
      getScheduler: function() {
        return this._scheduler;
      },
      setScheduler: function(scheduler) {
        this._scheduler !== scheduler && (this._scheduler = scheduler);
      },
      getActionManager: function() {
        return this._actionManager;
      },
      setActionManager: function(actionManager) {
        if (this._actionManager !== actionManager) {
          this._actionManager && this._scheduler.unscheduleUpdate(this._actionManager);
          this._actionManager = actionManager;
          this._scheduler.scheduleUpdate(this._actionManager, cc.Scheduler.PRIORITY_SYSTEM, false);
        }
      },
      getAnimationManager: function() {
        return this._animationManager;
      },
      getCollisionManager: function() {
        return this._collisionManager;
      },
      getPhysicsManager: function() {
        return this._physicsManager;
      },
      startAnimation: function() {
        this.invalid = false;
        this._lastUpdate = performance.now();
      },
      stopAnimation: function() {
        this.invalid = true;
      },
      mainLoop: function() {
        if (this._purgeDirectorInNextLoop) {
          this._purgeDirectorInNextLoop = false;
          this.purgeDirector();
        } else if (!this.invalid) {
          this.calculateDeltaTime();
          if (!this._paused) {
            this.emit(cc.Director.EVENT_BEFORE_UPDATE);
            this._compScheduler.startPhase();
            this._compScheduler.updatePhase(this._deltaTime);
            this._scheduler.update(this._deltaTime);
            this._compScheduler.lateUpdatePhase(this._deltaTime);
            this.emit(cc.Director.EVENT_AFTER_UPDATE);
            Obj._deferredDestroy();
          }
          this.emit(cc.Director.EVENT_BEFORE_DRAW);
          renderer.render(this._scene);
          this.emit(cc.Director.EVENT_AFTER_DRAW);
          eventManager.frameUpdateListeners();
          this._totalFrames++;
        }
      },
      __fastOn: function(type, callback, target) {
        this.add(type, callback, target);
      },
      __fastOff: function(type, callback, target) {
        this.remove(type, callback, target);
      }
    };
    cc.js.addon(cc.Director.prototype, EventTarget.prototype);
    cc.Director.EVENT_PROJECTION_CHANGED = "director_projection_changed";
    cc.Director.EVENT_BEFORE_SCENE_LOADING = "director_before_scene_loading";
    cc.Director.EVENT_BEFORE_SCENE_LAUNCH = "director_before_scene_launch";
    cc.Director.EVENT_AFTER_SCENE_LAUNCH = "director_after_scene_launch";
    cc.Director.EVENT_BEFORE_UPDATE = "director_before_update";
    cc.Director.EVENT_AFTER_UPDATE = "director_after_update";
    cc.Director.EVENT_BEFORE_VISIT = "director_before_draw";
    cc.Director.EVENT_AFTER_VISIT = "director_before_draw";
    cc.Director.EVENT_BEFORE_DRAW = "director_before_draw";
    cc.Director.EVENT_AFTER_DRAW = "director_after_draw";
    cc.Director.PROJECTION_2D = 0;
    cc.Director.PROJECTION_3D = 1;
    cc.Director.PROJECTION_CUSTOM = 3;
    cc.Director.PROJECTION_DEFAULT = cc.Director.PROJECTION_2D;
    cc.director = new cc.Director();
    module.exports = cc.director;
  }), {
    "./CCGame": 24,
    "./CCScheduler": 28,
    "./component-scheduler": 54,
    "./event-manager": 89,
    "./event/event-target": 91,
    "./load-pipeline/auto-release-utils": 104,
    "./node-activator": 118,
    "./platform/CCObject": 153,
    "./renderer": 173
  } ],
  24: [ (function(require, module, exports) {
    var EventTarget = require("./event/event-target");
    require("../audio/CCAudioEngine");
    var debug = require("./CCDebug");
    var renderer = require("./renderer/index.js");
    var inputManager = require("./platform/CCInputManager");
    var dynamicAtlasManager = require("../core/renderer/utils/dynamic-atlas/manager");
    var game = {
      EVENT_HIDE: "game_on_hide",
      EVENT_SHOW: "game_on_show",
      EVENT_GAME_INITED: "game_inited",
      EVENT_ENGINE_INITED: "engine_inited",
      EVENT_RENDERER_INITED: "engine_inited",
      RENDER_TYPE_CANVAS: 0,
      RENDER_TYPE_WEBGL: 1,
      RENDER_TYPE_OPENGL: 2,
      _persistRootNodes: {},
      _paused: true,
      _configLoaded: false,
      _isCloning: false,
      _prepared: false,
      _rendererInitialized: false,
      _renderContext: null,
      _intervalId: null,
      _lastTime: null,
      _frameTime: null,
      _sceneInfos: [],
      frame: null,
      container: null,
      canvas: null,
      renderType: -1,
      config: null,
      onStart: null,
      setFrameRate: function(frameRate) {
        var config = this.config;
        config.frameRate = frameRate;
        this._intervalId && window.cancelAnimFrame(this._intervalId);
        this._intervalId = 0;
        this._paused = true;
        this._setAnimFrame();
        this._runMainLoop();
      },
      getFrameRate: function() {
        return this.config.frameRate;
      },
      step: function() {
        cc.director.mainLoop();
      },
      pause: function() {
        if (this._paused) return;
        this._paused = true;
        cc.audioEngine && cc.audioEngine._break();
        this._intervalId && window.cancelAnimFrame(this._intervalId);
        this._intervalId = 0;
      },
      resume: function() {
        if (!this._paused) return;
        this._paused = false;
        cc.audioEngine && cc.audioEngine._restore();
        this._runMainLoop();
      },
      isPaused: function() {
        return this._paused;
      },
      restart: function() {
        cc.director.once(cc.Director.EVENT_AFTER_DRAW, (function() {
          for (var id in game._persistRootNodes) game.removePersistRootNode(game._persistRootNodes[id]);
          cc.director.getScene().destroy();
          cc.Object._deferredDestroy();
          cc.director.purgeDirector();
          cc.audioEngine && cc.audioEngine.uncacheAll();
          cc.director.reset();
          game.onStart();
        }));
      },
      end: function() {
        close();
      },
      _initEngine: function() {
        if (this._rendererInitialized) return;
        this._initRenderer();
        true;
        this._initEvents();
        this.emit(this.EVENT_ENGINE_INITED);
      },
      _prepareFinished: function(cb) {
        this._prepared = true;
        this._initEngine();
        console.log("Cocos Creator v" + cc.ENGINE_VERSION);
        this._setAnimFrame();
        this._runMainLoop();
        this.emit(this.EVENT_GAME_INITED);
        cb && cb();
      },
      eventTargetOn: EventTarget.prototype.on,
      eventTargetOnce: EventTarget.prototype.once,
      on: function(type, callback, target) {
        this._prepared && type === this.EVENT_ENGINE_INITED ? callback.call(target) : this.eventTargetOn(type, callback, target);
      },
      once: function(type, callback, target) {
        this._prepared && type === this.EVENT_ENGINE_INITED ? callback.call(target) : this.eventTargetOnce(type, callback, target);
      },
      prepare: function(cb) {
        if (this._prepared) {
          cb && cb();
          return;
        }
        var jsList = this.config.jsList;
        if (jsList && jsList.length > 0) {
          var self = this;
          cc.loader.load(jsList, (function(err) {
            if (err) throw new Error(JSON.stringify(err));
            self._prepareFinished(cb);
          }));
        } else this._prepareFinished(cb);
      },
      run: function(config, onStart) {
        this._initConfig(config);
        this.onStart = onStart;
        this.prepare(game.onStart && game.onStart.bind(game));
      },
      addPersistRootNode: function(node) {
        if (!cc.Node.isNode(node) || !node.uuid) {
          cc.warnID(3800);
          return;
        }
        var id = node.uuid;
        if (!this._persistRootNodes[id]) {
          var scene = cc.director._scene;
          if (cc.isValid(scene)) if (node.parent) {
            if (!(node.parent instanceof cc.Scene)) {
              cc.warnID(3801);
              return;
            }
            if (node.parent !== scene) {
              cc.warnID(3802);
              return;
            }
          } else node.parent = scene;
          this._persistRootNodes[id] = node;
          node._persistNode = true;
        }
      },
      removePersistRootNode: function(node) {
        var id = node.uuid || "";
        if (node === this._persistRootNodes[id]) {
          delete this._persistRootNodes[id];
          node._persistNode = false;
        }
      },
      isPersistRootNode: function(node) {
        return node._persistNode;
      },
      _setAnimFrame: function() {
        this._lastTime = new Date();
        var frameRate = game.config.frameRate;
        this._frameTime = 1e3 / frameRate;
        false;
        if (60 !== frameRate && 30 !== frameRate) {
          window.requestAnimFrame = this._stTime;
          window.cancelAnimFrame = this._ctTime;
        } else {
          window.requestAnimFrame = window.requestAnimationFrame || window.webkitRequestAnimationFrame || window.mozRequestAnimationFrame || window.oRequestAnimationFrame || window.msRequestAnimationFrame || this._stTime;
          window.cancelAnimFrame = window.cancelAnimationFrame || window.cancelRequestAnimationFrame || window.msCancelRequestAnimationFrame || window.mozCancelRequestAnimationFrame || window.oCancelRequestAnimationFrame || window.webkitCancelRequestAnimationFrame || window.msCancelAnimationFrame || window.mozCancelAnimationFrame || window.webkitCancelAnimationFrame || window.oCancelAnimationFrame || this._ctTime;
        }
      },
      _stTime: function(callback) {
        var currTime = new Date().getTime();
        var timeToCall = Math.max(0, game._frameTime - (currTime - game._lastTime));
        var id = window.setTimeout((function() {
          callback();
        }), timeToCall);
        game._lastTime = currTime + timeToCall;
        return id;
      },
      _ctTime: function(id) {
        window.clearTimeout(id);
      },
      _runMainLoop: function() {
        var self = this, callback, config = self.config, director = cc.director, skip = true, frameRate = config.frameRate;
        debug.setDisplayStats(config.showFPS);
        callback = function() {
          if (!self._paused) {
            self._intervalId = window.requestAnimFrame(callback);
            if (30 === frameRate && (skip = !skip)) return;
            director.mainLoop();
          }
        };
        self._intervalId = window.requestAnimFrame(callback);
        self._paused = false;
      },
      _initConfig: function(config) {
        "number" !== typeof config.debugMode && (config.debugMode = 0);
        config.exposeClassName = !!config.exposeClassName;
        "number" !== typeof config.frameRate && (config.frameRate = 60);
        var renderMode = config.renderMode;
        ("number" !== typeof renderMode || renderMode > 2 || renderMode < 0) && (config.renderMode = 0);
        "boolean" !== typeof config.registerSystemEvent && (config.registerSystemEvent = true);
        config.showFPS = !!config.showFPS;
        this._sceneInfos = config.scenes || [];
        this.collisionMatrix = config.collisionMatrix || [];
        this.groupList = config.groupList || [];
        debug._resetDebugSetting(config.debugMode);
        this.config = config;
        this._configLoaded = true;
      },
      _determineRenderType: function() {
        var config = this.config, userRenderMode = parseInt(config.renderMode) || 0;
        this.renderType = this.RENDER_TYPE_CANVAS;
        var supportRender = false;
        if (0 === userRenderMode) {
          if (cc.sys.capabilities["opengl"]) {
            this.renderType = this.RENDER_TYPE_WEBGL;
            supportRender = true;
          } else if (cc.sys.capabilities["canvas"]) {
            this.renderType = this.RENDER_TYPE_CANVAS;
            supportRender = true;
          }
        } else if (1 === userRenderMode && cc.sys.capabilities["canvas"]) {
          this.renderType = this.RENDER_TYPE_CANVAS;
          supportRender = true;
        } else if (2 === userRenderMode && cc.sys.capabilities["opengl"]) {
          this.renderType = this.RENDER_TYPE_WEBGL;
          supportRender = true;
        }
        if (!supportRender) throw new Error(debug.getError(3820, userRenderMode));
      },
      _initRenderer: function() {
        if (this._rendererInitialized) return;
        var el = this.config.id, width = void 0, height = void 0, localCanvas = void 0, localContainer = void 0, isWeChatGame = cc.sys.platform === cc.sys.WECHAT_GAME, isQQPlay = cc.sys.platform === cc.sys.QQ_PLAY;
        if (isWeChatGame || false) {
          this.container = localContainer = document.createElement("DIV");
          this.frame = localContainer.parentNode === document.body ? document.documentElement : localContainer.parentNode;
          if (cc.sys.browserType === cc.sys.BROWSER_TYPE_WECHAT_GAME_SUB) localCanvas = window.sharedCanvas || wx.getSharedCanvas(); else {
            false;
            localCanvas = canvas;
          }
          this.canvas = localCanvas;
        } else if (isQQPlay) {
          this.container = cc.container = document.createElement("DIV");
          this.frame = document.documentElement;
          this.canvas = localCanvas = canvas;
        } else {
          var element = el instanceof HTMLElement ? el : document.querySelector(el) || document.querySelector("#" + el);
          if ("CANVAS" === element.tagName) {
            width = element.width;
            height = element.height;
            this.canvas = localCanvas = element;
            this.container = localContainer = document.createElement("DIV");
            localCanvas.parentNode && localCanvas.parentNode.insertBefore(localContainer, localCanvas);
          } else {
            "DIV" !== element.tagName && cc.warnID(3819);
            width = element.clientWidth;
            height = element.clientHeight;
            this.canvas = localCanvas = document.createElement("CANVAS");
            this.container = localContainer = document.createElement("DIV");
            element.appendChild(localContainer);
          }
          localContainer.setAttribute("id", "Cocos2dGameContainer");
          localContainer.appendChild(localCanvas);
          this.frame = localContainer.parentNode === document.body ? document.documentElement : localContainer.parentNode;
          function addClass(element, name) {
            var hasClass = (" " + element.className + " ").indexOf(" " + name + " ") > -1;
            if (!hasClass) {
              element.className && (element.className += " ");
              element.className += name;
            }
          }
          addClass(localCanvas, "gameCanvas");
          localCanvas.setAttribute("width", width || 480);
          localCanvas.setAttribute("height", height || 320);
          localCanvas.setAttribute("tabindex", 99);
        }
        this._determineRenderType();
        if (this.renderType === this.RENDER_TYPE_WEBGL) {
          var opts = {
            stencil: true,
            antialias: cc.macro.ENABLE_WEBGL_ANTIALIAS,
            alpha: cc.macro.ENABLE_TRANSPARENT_CANVAS
          };
          (isWeChatGame || isQQPlay) && (opts["preserveDrawingBuffer"] = true);
          renderer.initWebGL(localCanvas, opts);
          this._renderContext = renderer.device._gl;
          !cc.macro.CLEANUP_IMAGE_CACHE && dynamicAtlasManager && (dynamicAtlasManager.enabled = true);
        }
        if (!this._renderContext) {
          this.renderType = this.RENDER_TYPE_CANVAS;
          renderer.initCanvas(localCanvas);
          this._renderContext = renderer.device._ctx;
        }
        this.canvas.oncontextmenu = function() {
          if (!cc._isContextMenuEnable) return false;
        };
        this._rendererInitialized = true;
      },
      _initEvents: function() {
        var win = window, hiddenPropName;
        this.config.registerSystemEvent && inputManager.registerSystemEvent(this.canvas);
        "undefined" !== typeof document.hidden ? hiddenPropName = "hidden" : "undefined" !== typeof document.mozHidden ? hiddenPropName = "mozHidden" : "undefined" !== typeof document.msHidden ? hiddenPropName = "msHidden" : "undefined" !== typeof document.webkitHidden && (hiddenPropName = "webkitHidden");
        var hidden = false;
        function onHidden() {
          if (!hidden) {
            hidden = true;
            game.emit(game.EVENT_HIDE);
          }
        }
        function onShown() {
          if (hidden) {
            hidden = false;
            game.emit(game.EVENT_SHOW);
          }
        }
        if (hiddenPropName) {
          var changeList = [ "visibilitychange", "mozvisibilitychange", "msvisibilitychange", "webkitvisibilitychange", "qbrowserVisibilityChange" ];
          for (var i = 0; i < changeList.length; i++) document.addEventListener(changeList[i], (function(event) {
            var visible = document[hiddenPropName];
            visible = visible || event["hidden"];
            visible ? onHidden() : onShown();
          }));
        } else {
          win.addEventListener("blur", onHidden);
          win.addEventListener("focus", onShown);
        }
        navigator.userAgent.indexOf("MicroMessenger") > -1 && (win.onfocus = onShown);
        if (true, cc.sys.browserType !== cc.sys.BROWSER_TYPE_WECHAT_GAME_SUB) {
          wx.onShow && wx.onShow(onShown);
          wx.onHide && wx.onHide(onHidden);
        }
        if ("onpageshow" in window && "onpagehide" in window) {
          win.addEventListener("pagehide", onHidden);
          win.addEventListener("pageshow", onShown);
          document.addEventListener("pagehide", onHidden);
          document.addEventListener("pageshow", onShown);
        }
        this.on(game.EVENT_HIDE, (function() {
          game.pause();
        }));
        this.on(game.EVENT_SHOW, (function() {
          game.resume();
        }));
      }
    };
    EventTarget.call(game);
    cc.js.addon(game, EventTarget.prototype);
    cc.game = module.exports = game;
  }), {
    "../audio/CCAudioEngine": 21,
    "../core/renderer/utils/dynamic-atlas/manager": void 0,
    "./CCDebug": 22,
    "./event/event-target": 91,
    "./platform/BKInputManager": 145,
    "./platform/CCInputManager": 151,
    "./renderer/index.js": 173
  } ],
  25: [ (function(require, module, exports) {
    "use strict";
    var BaseNode = require("./utils/base-node");
    var PrefabHelper = require("./utils/prefab-helper");
    var mathPools = require("./utils/math-pools");
    var math = require("./renderer/render-engine").math;
    var AffineTrans = require("./utils/affine-transform");
    var eventManager = require("./event-manager");
    var macro = require("./platform/CCMacro");
    var misc = require("./utils/misc");
    var js = require("./platform/js");
    var Event = require("./event/event");
    var EventTarget = require("./event/event-target");
    var RenderFlow = require("./renderer/render-flow");
    var Flags = cc.Object.Flags;
    var Destroying = Flags.Destroying;
    var ERR_INVALID_NUMBER = false;
    var ONE_DEGREE = Math.PI / 180;
    var ActionManagerExist = !!cc.ActionManager;
    var emptyFunc = function() {};
    var _vec2a = cc.v2();
    var _vec2b = cc.v2();
    var _mat4_temp = math.mat4.create();
    var _vec3_temp = math.vec3.create();
    var _quat_temp = math.quat.create();
    var _globalOrderOfArrival = 1;
    var _cachedArray = new Array(16);
    _cachedArray.length = 0;
    var POSITION_ON = 1;
    var SCALE_ON = 2;
    var ROTATION_ON = 4;
    var SIZE_ON = 8;
    var ANCHOR_ON = 16;
    var BuiltinGroupIndex = cc.Enum({
      DEBUG: 31
    });
    var LocalDirtyFlag = cc.Enum({
      POSITION: 1,
      SCALE: 2,
      ROTATION: 4,
      SKEW: 8,
      RT: 7,
      ALL: 65535
    });
    var EventType = cc.Enum({
      TOUCH_START: "touchstart",
      TOUCH_MOVE: "touchmove",
      TOUCH_END: "touchend",
      TOUCH_CANCEL: "touchcancel",
      MOUSE_DOWN: "mousedown",
      MOUSE_MOVE: "mousemove",
      MOUSE_ENTER: "mouseenter",
      MOUSE_LEAVE: "mouseleave",
      MOUSE_UP: "mouseup",
      MOUSE_WHEEL: "mousewheel",
      POSITION_CHANGED: "position-changed",
      ROTATION_CHANGED: "rotation-changed",
      SCALE_CHANGED: "scale-changed",
      SIZE_CHANGED: "size-changed",
      ANCHOR_CHANGED: "anchor-changed",
      CHILD_ADDED: "child-added",
      CHILD_REMOVED: "child-removed",
      CHILD_REORDER: "child-reorder",
      GROUP_CHANGED: "group-changed"
    });
    var _touchEvents = [ EventType.TOUCH_START, EventType.TOUCH_MOVE, EventType.TOUCH_END, EventType.TOUCH_CANCEL ];
    var _mouseEvents = [ EventType.MOUSE_DOWN, EventType.MOUSE_ENTER, EventType.MOUSE_MOVE, EventType.MOUSE_LEAVE, EventType.MOUSE_UP, EventType.MOUSE_WHEEL ];
    var _currentHovered = null;
    var _touchStartHandler = function(touch, event) {
      var pos = touch.getLocation();
      var node = this.owner;
      if (node._hitTest(pos, this)) {
        event.type = EventType.TOUCH_START;
        event.touch = touch;
        event.bubbles = true;
        node.dispatchEvent(event);
        return true;
      }
      return false;
    };
    var _touchMoveHandler = function(touch, event) {
      var node = this.owner;
      event.type = EventType.TOUCH_MOVE;
      event.touch = touch;
      event.bubbles = true;
      node.dispatchEvent(event);
    };
    var _touchEndHandler = function(touch, event) {
      var pos = touch.getLocation();
      var node = this.owner;
      node._hitTest(pos, this) ? event.type = EventType.TOUCH_END : event.type = EventType.TOUCH_CANCEL;
      event.touch = touch;
      event.bubbles = true;
      node.dispatchEvent(event);
    };
    var _touchCancelHandler = function(touch, event) {
      var pos = touch.getLocation();
      var node = this.owner;
      event.type = EventType.TOUCH_CANCEL;
      event.touch = touch;
      event.bubbles = true;
      node.dispatchEvent(event);
    };
    var _mouseDownHandler = function(event) {
      var pos = event.getLocation();
      var node = this.owner;
      if (node._hitTest(pos, this)) {
        event.type = EventType.MOUSE_DOWN;
        event.bubbles = true;
        node.dispatchEvent(event);
      }
    };
    var _mouseMoveHandler = function(event) {
      var pos = event.getLocation();
      var node = this.owner;
      var hit = node._hitTest(pos, this);
      if (hit) {
        if (!this._previousIn) {
          if (_currentHovered && _currentHovered._mouseListener) {
            event.type = EventType.MOUSE_LEAVE;
            _currentHovered.dispatchEvent(event);
            _currentHovered._mouseListener._previousIn = false;
          }
          _currentHovered = this.owner;
          event.type = EventType.MOUSE_ENTER;
          node.dispatchEvent(event);
          this._previousIn = true;
        }
        event.type = EventType.MOUSE_MOVE;
        event.bubbles = true;
        node.dispatchEvent(event);
      } else {
        if (!this._previousIn) return;
        event.type = EventType.MOUSE_LEAVE;
        node.dispatchEvent(event);
        this._previousIn = false;
        _currentHovered = null;
      }
      event.stopPropagation();
    };
    var _mouseUpHandler = function(event) {
      var pos = event.getLocation();
      var node = this.owner;
      if (node._hitTest(pos, this)) {
        event.type = EventType.MOUSE_UP;
        event.bubbles = true;
        node.dispatchEvent(event);
        event.stopPropagation();
      }
    };
    var _mouseWheelHandler = function(event) {
      var pos = event.getLocation();
      var node = this.owner;
      if (node._hitTest(pos, this)) {
        event.type = EventType.MOUSE_WHEEL;
        event.bubbles = true;
        node.dispatchEvent(event);
        event.stopPropagation();
      }
    };
    function _searchMaskInParent(node) {
      var Mask = cc.Mask;
      if (Mask) {
        var index = 0;
        for (var curr = node; curr && cc.Node.isNode(curr); curr = curr._parent, ++index) if (curr.getComponent(Mask)) return {
          index: index,
          node: curr
        };
      }
      return null;
    }
    function _checkListeners(node, events) {
      if (!(node._objFlags & Destroying)) {
        var i = 0;
        if (node._bubblingListeners) for (;i < events.length; ++i) if (node._bubblingListeners.hasEventListener(events[i])) return true;
        if (node._capturingListeners) for (;i < events.length; ++i) if (node._capturingListeners.hasEventListener(events[i])) return true;
        return false;
      }
      return true;
    }
    function _doDispatchEvent(owner, event) {
      var target, i;
      event.target = owner;
      _cachedArray.length = 0;
      owner._getCapturingTargets(event.type, _cachedArray);
      event.eventPhase = 1;
      for (i = _cachedArray.length - 1; i >= 0; --i) {
        target = _cachedArray[i];
        if (target._capturingListeners) {
          event.currentTarget = target;
          target._capturingListeners.emit(event.type, event, _cachedArray);
          if (event._propagationStopped) {
            _cachedArray.length = 0;
            return;
          }
        }
      }
      _cachedArray.length = 0;
      event.eventPhase = 2;
      event.currentTarget = owner;
      owner._capturingListeners && owner._capturingListeners.emit(event.type, event);
      !event._propagationImmediateStopped && owner._bubblingListeners && owner._bubblingListeners.emit(event.type, event);
      if (!event._propagationStopped && event.bubbles) {
        owner._getBubblingTargets(event.type, _cachedArray);
        event.eventPhase = 3;
        for (i = 0; i < _cachedArray.length; ++i) {
          target = _cachedArray[i];
          if (target._bubblingListeners) {
            event.currentTarget = target;
            target._bubblingListeners.emit(event.type, event);
            if (event._propagationStopped) {
              _cachedArray.length = 0;
              return;
            }
          }
        }
      }
      _cachedArray.length = 0;
    }
    var Node = cc.Class({
      name: "cc.Node",
      extends: BaseNode,
      properties: {
        _opacity: 255,
        _color: cc.Color.WHITE,
        _contentSize: cc.Size,
        _anchorPoint: cc.v2(.5, .5),
        _position: cc.Vec3,
        _scaleX: {
          default: void 0,
          type: cc.Float
        },
        _scaleY: {
          default: void 0,
          type: cc.Float
        },
        _scale: cc.Vec3,
        _rotationX: 0,
        _rotationY: 0,
        _quat: cc.Quat,
        _skewX: 0,
        _skewY: 0,
        _localZOrder: {
          default: 0,
          serializable: false
        },
        _zIndex: 0,
        groupIndex: {
          default: 0,
          type: cc.Integer
        },
        group: {
          get: function() {
            return cc.game.groupList[this.groupIndex] || "";
          },
          set: function(value) {
            this.groupIndex = cc.game.groupList.indexOf(value);
            this.emit(EventType.GROUP_CHANGED, this);
          }
        },
        x: {
          get: function() {
            return this._position.x;
          },
          set: function(value) {
            var localPosition = this._position;
            if (value !== localPosition.x) {
              true;
              var oldValue;
              false;
              localPosition.x = value;
              this.setLocalDirty(LocalDirtyFlag.POSITION);
              this._renderFlag |= RenderFlow.FLAG_WORLD_TRANSFORM;
              if (this._eventMask & POSITION_ON) {
                false;
                this.emit(EventType.POSITION_CHANGED);
              }
            }
          }
        },
        y: {
          get: function() {
            return this._position.y;
          },
          set: function(value) {
            var localPosition = this._position;
            if (value !== localPosition.y) {
              true;
              var oldValue;
              false;
              localPosition.y = value;
              this.setLocalDirty(LocalDirtyFlag.POSITION);
              this._renderFlag |= RenderFlow.FLAG_WORLD_TRANSFORM;
              if (this._eventMask & POSITION_ON) {
                false;
                this.emit(EventType.POSITION_CHANGED);
              }
            }
          }
        },
        z: {
          get: function() {
            return this._position.z;
          },
          set: function(value) {
            var localPosition = this._position;
            if (value !== localPosition.z) {
              true;
              localPosition.z = value;
              this.setLocalDirty(LocalDirtyFlag.POSITION);
              this._renderFlag |= RenderFlow.FLAG_WORLD_TRANSFORM;
              this._eventMask & POSITION_ON && this.emit(EventType.POSITION_CHANGED);
            }
          }
        },
        rotation: {
          get: function() {
            return this._rotationX;
          },
          set: function(value) {
            if (this._rotationX !== value || this._rotationY !== value) {
              this._rotationX = this._rotationY = value;
              math.quat.fromEuler(this._quat, 0, 0, -value);
              this.setLocalDirty(LocalDirtyFlag.ROTATION);
              this._renderFlag |= RenderFlow.FLAG_TRANSFORM;
              this._eventMask & ROTATION_ON && this.emit(EventType.ROTATION_CHANGED);
            }
          }
        },
        rotationX: {
          get: function() {
            return this._rotationX;
          },
          set: function(value) {
            if (this._rotationX !== value) {
              this._rotationX = value;
              this._rotationX === this._rotationY ? math.quat.fromEuler(this._quat, 0, 0, -value) : math.quat.fromEuler(this._quat, value, this._rotationY, 0);
              this.setLocalDirty(LocalDirtyFlag.ROTATION);
              this._renderFlag |= RenderFlow.FLAG_TRANSFORM;
              this._eventMask & ROTATION_ON && this.emit(EventType.ROTATION_CHANGED);
            }
          }
        },
        rotationY: {
          get: function() {
            return this._rotationY;
          },
          set: function(value) {
            if (this._rotationY !== value) {
              this._rotationY = value;
              this._rotationX === this._rotationY ? math.quat.fromEuler(this._quat, 0, 0, -value) : math.quat.fromEuler(this._quat, this._rotationX, value, 0);
              this.setLocalDirty(LocalDirtyFlag.ROTATION);
              this._renderFlag |= RenderFlow.FLAG_TRANSFORM;
              this._eventMask & ROTATION_ON && this.emit(EventType.ROTATION_CHANGED);
            }
          }
        },
        scaleX: {
          get: function() {
            return this._scale.x;
          },
          set: function(value) {
            if (this._scale.x !== value) {
              this._scale.x = value;
              this.setLocalDirty(LocalDirtyFlag.SCALE);
              this._renderFlag |= RenderFlow.FLAG_TRANSFORM;
              this._eventMask & SCALE_ON && this.emit(EventType.SCALE_CHANGED);
            }
          }
        },
        scaleY: {
          get: function() {
            return this._scale.y;
          },
          set: function(value) {
            if (this._scale.y !== value) {
              this._scale.y = value;
              this.setLocalDirty(LocalDirtyFlag.SCALE);
              this._renderFlag |= RenderFlow.FLAG_TRANSFORM;
              this._eventMask & SCALE_ON && this.emit(EventType.SCALE_CHANGED);
            }
          }
        },
        skewX: {
          get: function() {
            return this._skewX;
          },
          set: function(value) {
            this._skewX = value;
            this.setLocalDirty(LocalDirtyFlag.SKEW);
            this._renderFlag |= RenderFlow.FLAG_TRANSFORM;
          }
        },
        skewY: {
          get: function() {
            return this._skewY;
          },
          set: function(value) {
            this._skewY = value;
            this.setLocalDirty(LocalDirtyFlag.SKEW);
            this._renderFlag |= RenderFlow.FLAG_TRANSFORM;
          }
        },
        opacity: {
          get: function() {
            return this._opacity;
          },
          set: function(value) {
            if (this._opacity !== value) {
              this._opacity = value;
              this._renderFlag |= RenderFlow.FLAG_OPACITY | RenderFlow.FLAG_COLOR;
            }
          },
          range: [ 0, 255 ]
        },
        color: {
          get: function() {
            return this._color.clone();
          },
          set: function(value) {
            if (!this._color.equals(value)) {
              this._color.set(value);
              false;
              this._renderComponent && (this._renderFlag |= RenderFlow.FLAG_COLOR);
            }
          }
        },
        anchorX: {
          get: function() {
            return this._anchorPoint.x;
          },
          set: function(value) {
            var anchorPoint = this._anchorPoint;
            if (anchorPoint.x !== value) {
              anchorPoint.x = value;
              this._eventMask & ANCHOR_ON && this.emit(EventType.ANCHOR_CHANGED);
            }
          }
        },
        anchorY: {
          get: function() {
            return this._anchorPoint.y;
          },
          set: function(value) {
            var anchorPoint = this._anchorPoint;
            if (anchorPoint.y !== value) {
              anchorPoint.y = value;
              this._eventMask & ANCHOR_ON && this.emit(EventType.ANCHOR_CHANGED);
            }
          }
        },
        width: {
          get: function() {
            return this._contentSize.width;
          },
          set: function(value) {
            if (value !== this._contentSize.width) {
              var clone;
              false;
              this._contentSize.width = value;
              if (this._eventMask & SIZE_ON) {
                false;
                this.emit(EventType.SIZE_CHANGED);
              }
            }
          }
        },
        height: {
          get: function() {
            return this._contentSize.height;
          },
          set: function(value) {
            if (value !== this._contentSize.height) {
              var clone;
              false;
              this._contentSize.height = value;
              if (this._eventMask & SIZE_ON) {
                false;
                this.emit(EventType.SIZE_CHANGED);
              }
            }
          }
        },
        zIndex: {
          get: function() {
            return this._zIndex;
          },
          set: function(value) {
            if (value > macro.MAX_ZINDEX) {
              cc.warnID(1636);
              value = macro.MAX_ZINDEX;
            } else if (value < macro.MIN_ZINDEX) {
              cc.warnID(1637);
              value = macro.MIN_ZINDEX;
            }
            if (this._zIndex !== value) {
              this._zIndex = value;
              this._localZOrder = 65535 & this._localZOrder | value << 16;
              this._parent && this._parent._delaySort();
            }
          }
        }
      },
      ctor: function() {
        this._reorderChildDirty = false;
        this._widget = null;
        this._renderComponent = null;
        this._capturingListeners = null;
        this._bubblingListeners = null;
        this._touchListener = null;
        this._mouseListener = null;
        this._scale.x = 1;
        this._scale.y = 1;
        this._scale.z = 1;
        this._matrix = mathPools.mat4.get();
        this._worldMatrix = mathPools.mat4.get();
        this._localMatDirty = LocalDirtyFlag.ALL;
        this._worldMatDirty = true;
        this._eventMask = 0;
        this._cullingMask = 1 << this.groupIndex;
      },
      statics: {
        EventType: EventType,
        _LocalDirtyFlag: LocalDirtyFlag,
        isNode: function(obj) {
          return obj instanceof Node && (obj.constructor === Node || !(obj instanceof cc.Scene));
        },
        BuiltinGroupIndex: BuiltinGroupIndex
      },
      _onSiblingIndexChanged: function(index) {
        var parent = this._parent;
        var siblings = parent._children;
        var i = 0, len = siblings.length, sibling;
        for (;i < len; i++) {
          sibling = siblings[i];
          sibling._updateOrderOfArrival();
          eventManager._setDirtyForNode(sibling);
        }
        parent._delaySort();
      },
      _onPreDestroy: function() {
        var destroyByParent = this._onPreDestroyBase();
        ActionManagerExist && cc.director.getActionManager().removeAllActionsFromTarget(this);
        _currentHovered === this && (_currentHovered = null);
        if (this._touchListener || this._mouseListener) {
          eventManager.removeListeners(this);
          if (this._touchListener) {
            this._touchListener.owner = null;
            this._touchListener.mask = null;
            this._touchListener = null;
          }
          if (this._mouseListener) {
            this._mouseListener.owner = null;
            this._mouseListener.mask = null;
            this._mouseListener = null;
          }
        }
        mathPools.mat4.put(this._matrix);
        mathPools.mat4.put(this._worldMatrix);
        this._matrix = this._worldMatrix = null;
        this._reorderChildDirty && cc.director.__fastOff(cc.Director.EVENT_AFTER_UPDATE, this.sortAllChildren, this);
        destroyByParent || false;
      },
      _onPostActivated: function(active) {
        var actionManager = ActionManagerExist ? cc.director.getActionManager() : null;
        if (active) {
          this._renderFlag |= RenderFlow.FLAG_WORLD_TRANSFORM;
          actionManager && actionManager.resumeTarget(this);
          eventManager.resumeTarget(this);
          if (this._touchListener) {
            var mask = this._touchListener.mask = _searchMaskInParent(this);
            this._mouseListener && (this._mouseListener.mask = mask);
          } else this._mouseListener && (this._mouseListener.mask = _searchMaskInParent(this));
        } else {
          actionManager && actionManager.pauseTarget(this);
          eventManager.pauseTarget(this);
        }
      },
      _onHierarchyChanged: function(oldParent) {
        this._updateOrderOfArrival();
        this._parent && this._parent._delaySort();
        this._renderFlag |= RenderFlow.FLAG_WORLD_TRANSFORM;
        this._onHierarchyChangedBase(oldParent);
        cc._widgetManager && (cc._widgetManager._nodesOrderDirty = true);
      },
      _upgrade_1x_to_2x: function() {
        if (void 0 !== this._scaleX) {
          this._scale.x = this._scaleX;
          this._scaleX = void 0;
        }
        if (void 0 !== this._scaleY) {
          this._scale.y = this._scaleY;
          this._scaleY = void 0;
        }
        0 !== this._localZOrder && (this._zIndex = (4294901760 & this._localZOrder) >> 16);
        if (0 !== this._rotationX || 0 !== this._rotationY) this._rotationX === this._rotationY ? math.quat.fromEuler(this._quat, 0, 0, -this._rotationX) : math.quat.fromEuler(this._quat, this._rotationX, this._rotationY, 0); else {
          var rotx = this._quat.getRoll();
          var roty = this._quat.getPitch();
          if (0 === rotx && 0 === roty) this._rotationX = this._rotationY = -this._quat.getYaw(); else {
            this._rotationX = rotx;
            this._rotationY = roty;
          }
        }
        if (this._color.a < 255 && 255 === this._opacity) {
          this._opacity = this._color.a;
          this._color.a = 255;
        }
      },
      _onBatchCreated: function() {
        this._upgrade_1x_to_2x();
        this._updateOrderOfArrival();
        var prefabInfo = this._prefab;
        if (prefabInfo && prefabInfo.sync && prefabInfo.root === this) {
          false;
          PrefabHelper.syncWithPrefab(this);
        }
        if (!this._activeInHierarchy) {
          ActionManagerExist && cc.director.getActionManager().pauseTarget(this);
          eventManager.pauseTarget(this);
        }
        var children = this._children;
        for (var i = 0, len = children.length; i < len; i++) children[i]._onBatchCreated();
        children.length > 0 && (this._renderFlag |= RenderFlow.FLAG_CHILDREN);
      },
      _onBatchRestored: function() {
        this._upgrade_1x_to_2x();
        if (!this._activeInHierarchy) {
          ActionManagerExist && cc.director.getActionManager().pauseTarget(this);
          eventManager.pauseTarget(this);
        }
        var children = this._children;
        for (var i = 0, len = children.length; i < len; i++) children[i]._onBatchRestored();
        children.length > 0 && (this._renderFlag |= RenderFlow.FLAG_CHILDREN);
      },
      _checknSetupSysEvent: function(type) {
        var newAdded = false;
        var forDispatch = false;
        if (-1 !== _touchEvents.indexOf(type)) {
          if (!this._touchListener) {
            this._touchListener = cc.EventListener.create({
              event: cc.EventListener.TOUCH_ONE_BY_ONE,
              swallowTouches: true,
              owner: this,
              mask: _searchMaskInParent(this),
              onTouchBegan: _touchStartHandler,
              onTouchMoved: _touchMoveHandler,
              onTouchEnded: _touchEndHandler,
              onTouchCancelled: _touchCancelHandler
            });
            eventManager.addListener(this._touchListener, this);
            newAdded = true;
          }
          forDispatch = true;
        } else if (-1 !== _mouseEvents.indexOf(type)) {
          if (!this._mouseListener) {
            this._mouseListener = cc.EventListener.create({
              event: cc.EventListener.MOUSE,
              _previousIn: false,
              owner: this,
              mask: _searchMaskInParent(this),
              onMouseDown: _mouseDownHandler,
              onMouseMove: _mouseMoveHandler,
              onMouseUp: _mouseUpHandler,
              onMouseScroll: _mouseWheelHandler
            });
            eventManager.addListener(this._mouseListener, this);
            newAdded = true;
          }
          forDispatch = true;
        }
        newAdded && !this._activeInHierarchy && cc.director.getScheduler().schedule((function() {
          this._activeInHierarchy || eventManager.pauseTarget(this);
        }), this, 0, 0, 0, false);
        return forDispatch;
      },
      on: function(type, callback, target, useCapture) {
        var forDispatch = this._checknSetupSysEvent(type);
        if (forDispatch) return this._onDispatch(type, callback, target, useCapture);
        switch (type) {
         case EventType.POSITION_CHANGED:
          this._eventMask |= POSITION_ON;
          break;

         case EventType.SCALE_CHANGED:
          this._eventMask |= SCALE_ON;
          break;

         case EventType.ROTATION_CHANGED:
          this._eventMask |= ROTATION_ON;
          break;

         case EventType.SIZE_CHANGED:
          this._eventMask |= SIZE_ON;
          break;

         case EventType.ANCHOR_CHANGED:
          this._eventMask |= ANCHOR_ON;
        }
        this._bubblingListeners || (this._bubblingListeners = new EventTarget());
        return this._bubblingListeners.on(type, callback, target);
      },
      once: function(type, callback, target, useCapture) {
        var _this = this;
        var forDispatch = this._checknSetupSysEvent(type);
        var eventType_hasOnceListener = "__ONCE_FLAG:" + type;
        var listeners = null;
        listeners = forDispatch && useCapture ? this._capturingListeners = this._capturingListeners || new EventTarget() : this._bubblingListeners = this._bubblingListeners || new EventTarget();
        var hasOnceListener = listeners.hasEventListener(eventType_hasOnceListener, callback, target);
        hasOnceListener || (function() {
          var self = _this;
          var onceWrapper = function(arg1, arg2, arg3, arg4, arg5) {
            self.off(type, onceWrapper, target);
            listeners.remove(eventType_hasOnceListener, callback, target);
            callback.call(this, arg1, arg2, arg3, arg4, arg5);
          };
          _this.on(type, onceWrapper, target);
          listeners.add(eventType_hasOnceListener, callback, target);
        })();
      },
      _onDispatch: function(type, callback, target, useCapture) {
        if ("boolean" === typeof target) {
          useCapture = target;
          target = void 0;
        } else useCapture = !!useCapture;
        if (!callback) {
          cc.errorID(6800);
          return;
        }
        var listeners = null;
        listeners = useCapture ? this._capturingListeners = this._capturingListeners || new EventTarget() : this._bubblingListeners = this._bubblingListeners || new EventTarget();
        if (!listeners.hasEventListener(type, callback, target)) {
          listeners.add(type, callback, target);
          target && target.__eventTargets && target.__eventTargets.push(this);
        }
        return callback;
      },
      off: function(type, callback, target, useCapture) {
        var touchEvent = -1 !== _touchEvents.indexOf(type);
        var mouseEvent = !touchEvent && -1 !== _mouseEvents.indexOf(type);
        if (touchEvent || mouseEvent) {
          this._offDispatch(type, callback, target, useCapture);
          if (touchEvent) {
            if (this._touchListener && !_checkListeners(this, _touchEvents)) {
              eventManager.removeListener(this._touchListener);
              this._touchListener = null;
            }
          } else if (mouseEvent && this._mouseListener && !_checkListeners(this, _mouseEvents)) {
            eventManager.removeListener(this._mouseListener);
            this._mouseListener = null;
          }
        } else if (this._bubblingListeners) {
          this._bubblingListeners.off(type, callback, target);
          var hasListeners = this._bubblingListeners.hasEventListener(type);
          if (!hasListeners) switch (type) {
           case EventType.POSITION_CHANGED:
            this._eventMask &= ~POSITION_ON;
            break;

           case EventType.SCALE_CHANGED:
            this._eventMask &= ~SCALE_ON;
            break;

           case EventType.ROTATION_CHANGED:
            this._eventMask &= ~ROTATION_ON;
            break;

           case EventType.SIZE_CHANGED:
            this._eventMask &= ~SIZE_ON;
            break;

           case EventType.ANCHOR_CHANGED:
            this._eventMask &= ~ANCHOR_ON;
          }
        }
      },
      _offDispatch: function(type, callback, target, useCapture) {
        if ("boolean" === typeof target) {
          useCapture = target;
          target = void 0;
        } else useCapture = !!useCapture;
        if (callback) {
          var listeners = useCapture ? this._capturingListeners : this._bubblingListeners;
          if (listeners) {
            listeners.remove(type, callback, target);
            target && target.__eventTargets && js.array.fastRemove(target.__eventTargets, this);
          }
        } else {
          this._capturingListeners && this._capturingListeners.removeAll(type);
          this._bubblingListeners && this._bubblingListeners.removeAll(type);
        }
      },
      targetOff: function(target) {
        var listeners = this._bubblingListeners;
        if (listeners) {
          listeners.targetOff(target);
          this._eventMask & POSITION_ON && !listeners.hasEventListener(EventType.POSITION_CHANGED) && (this._eventMask &= ~POSITION_ON);
          this._eventMask & SCALE_ON && !listeners.hasEventListener(EventType.SCALE_CHANGED) && (this._eventMask &= ~SCALE_ON);
          this._eventMask & ROTATION_ON && !listeners.hasEventListener(EventType.ROTATION_CHANGED) && (this._eventMask &= ~ROTATION_ON);
          this._eventMask & SIZE_ON && !listeners.hasEventListener(EventType.SIZE_CHANGED) && (this._eventMask &= ~SIZE_ON);
          this._eventMask & ANCHOR_ON && !listeners.hasEventListener(EventType.ANCHOR_CHANGED) && (this._eventMask &= ~ANCHOR_ON);
        }
        this._capturingListeners && this._capturingListeners.targetOff(target);
        if (this._touchListener && !_checkListeners(this, _touchEvents)) {
          eventManager.removeListener(this._touchListener);
          this._touchListener = null;
        }
        if (this._mouseListener && !_checkListeners(this, _mouseEvents)) {
          eventManager.removeListener(this._mouseListener);
          this._mouseListener = null;
        }
      },
      hasEventListener: function(type) {
        var has = false;
        this._bubblingListeners && (has = this._bubblingListeners.hasEventListener(type));
        !has && this._capturingListeners && (has = this._capturingListeners.hasEventListener(type));
        return has;
      },
      emit: function(type, arg1, arg2, arg3, arg4, arg5) {
        this._bubblingListeners && this._bubblingListeners.emit(type, arg1, arg2, arg3, arg4, arg5);
      },
      dispatchEvent: function(event) {
        _doDispatchEvent(this, event);
        _cachedArray.length = 0;
      },
      pauseSystemEvents: function(recursive) {
        eventManager.pauseTarget(this, recursive);
      },
      resumeSystemEvents: function(recursive) {
        eventManager.resumeTarget(this, recursive);
      },
      _hitTest: function(point, listener) {
        var w = this._contentSize.width, h = this._contentSize.height, cameraPt = _vec2a, testPt = _vec2b;
        var camera = cc.Camera.findCamera(this);
        camera ? camera.getCameraToWorldPoint(point, cameraPt) : cameraPt.set(point);
        this._updateWorldMatrix();
        math.mat4.invert(_mat4_temp, this._worldMatrix);
        math.vec2.transformMat4(testPt, cameraPt, _mat4_temp);
        testPt.x += this._anchorPoint.x * w;
        testPt.y += this._anchorPoint.y * h;
        if (testPt.x >= 0 && testPt.y >= 0 && testPt.x <= w && testPt.y <= h) {
          if (listener && listener.mask) {
            var mask = listener.mask;
            var parent = this;
            for (var i = 0; parent && i < mask.index; ++i, parent = parent.parent) ;
            if (parent === mask.node) {
              var comp = parent.getComponent(cc.Mask);
              return !comp || !comp.enabledInHierarchy || comp._hitTest(cameraPt);
            }
            listener.mask = null;
            return true;
          }
          return true;
        }
        return false;
      },
      _getCapturingTargets: function(type, array) {
        var parent = this.parent;
        while (parent) {
          parent._capturingListeners && parent._capturingListeners.hasEventListener(type) && array.push(parent);
          parent = parent.parent;
        }
      },
      _getBubblingTargets: function(type, array) {
        var parent = this.parent;
        while (parent) {
          parent._bubblingListeners && parent._bubblingListeners.hasEventListener(type) && array.push(parent);
          parent = parent.parent;
        }
      },
      runAction: ActionManagerExist ? function(action) {
        if (!this.active) return;
        cc.assertID(action, 1618);
        cc.director.getActionManager().addAction(action, this, false);
        return action;
      } : emptyFunc,
      pauseAllActions: ActionManagerExist ? function() {
        cc.director.getActionManager().pauseTarget(this);
      } : emptyFunc,
      resumeAllActions: ActionManagerExist ? function() {
        cc.director.getActionManager().resumeTarget(this);
      } : emptyFunc,
      stopAllActions: ActionManagerExist ? function() {
        cc.director.getActionManager().removeAllActionsFromTarget(this);
      } : emptyFunc,
      stopAction: ActionManagerExist ? function(action) {
        cc.director.getActionManager().removeAction(action);
      } : emptyFunc,
      stopActionByTag: ActionManagerExist ? function(tag) {
        if (tag === cc.Action.TAG_INVALID) {
          cc.logID(1612);
          return;
        }
        cc.director.getActionManager().removeActionByTag(tag, this);
      } : emptyFunc,
      getActionByTag: ActionManagerExist ? function(tag) {
        if (tag === cc.Action.TAG_INVALID) {
          cc.logID(1613);
          return null;
        }
        return cc.director.getActionManager().getActionByTag(tag, this);
      } : function() {
        return null;
      },
      getNumberOfRunningActions: ActionManagerExist ? function() {
        return cc.director.getActionManager().getNumberOfRunningActionsInTarget(this);
      } : function() {
        return 0;
      },
      getPosition: function() {
        return new cc.Vec2(this._position);
      },
      setPosition: function(newPosOrX, y) {
        var x;
        if (void 0 === y) {
          x = newPosOrX.x;
          y = newPosOrX.y;
        } else x = newPosOrX;
        var locPosition = this._position;
        if (locPosition.x === x && locPosition.y === y) return;
        var oldPosition;
        false;
        true;
        locPosition.x = x;
        true;
        locPosition.y = y;
        this.setLocalDirty(LocalDirtyFlag.POSITION);
        this._renderFlag |= RenderFlow.FLAG_WORLD_TRANSFORM;
        if (this._eventMask & POSITION_ON) {
          false;
          this.emit(EventType.POSITION_CHANGED);
        }
      },
      getScale: function() {
        this._scale.x !== this._scale.y && cc.logID(1603);
        return this._scale.x;
      },
      setScale: function(x, y) {
        if (x && "number" !== typeof x) {
          y = x.y;
          x = x.x;
        } else void 0 === y && (y = x);
        if (this._scale.x !== x || this._scale.y !== y) {
          this._scale.x = x;
          this._scale.y = y;
          this.setLocalDirty(LocalDirtyFlag.SCALE);
          this._renderFlag |= RenderFlow.FLAG_TRANSFORM;
          this._eventMask & SCALE_ON && this.emit(EventType.SCALE_CHANGED);
        }
      },
      getContentSize: function() {
        return cc.size(this._contentSize.width, this._contentSize.height);
      },
      setContentSize: function(size, height) {
        var locContentSize = this._contentSize;
        var clone;
        if (void 0 === height) {
          if (size.width === locContentSize.width && size.height === locContentSize.height) return;
          false;
          locContentSize.width = size.width;
          locContentSize.height = size.height;
        } else {
          if (size === locContentSize.width && height === locContentSize.height) return;
          false;
          locContentSize.width = size;
          locContentSize.height = height;
        }
        if (this._eventMask & SIZE_ON) {
          false;
          this.emit(EventType.SIZE_CHANGED);
        }
      },
      getAnchorPoint: function() {
        return cc.v2(this._anchorPoint);
      },
      setAnchorPoint: function(point, y) {
        var locAnchorPoint = this._anchorPoint;
        if (void 0 === y) {
          if (point.x === locAnchorPoint.x && point.y === locAnchorPoint.y) return;
          locAnchorPoint.x = point.x;
          locAnchorPoint.y = point.y;
        } else {
          if (point === locAnchorPoint.x && y === locAnchorPoint.y) return;
          locAnchorPoint.x = point;
          locAnchorPoint.y = y;
        }
        this.setLocalDirty(LocalDirtyFlag.POSITION);
        this._eventMask & ANCHOR_ON && this.emit(EventType.ANCHOR_CHANGED);
      },
      _invTransformPoint: function(out, pos) {
        this._parent ? this._parent._invTransformPoint(out, pos) : math.vec3.copy(out, pos);
        math.vec3.sub(out, out, this._position);
        math.quat.conjugate(_quat_temp, this._quat);
        math.vec3.transformQuat(out, out, _quat_temp);
        math.vec3.inverseSafe(_vec3_temp, this._scale);
        math.vec3.mul(out, out, _vec3_temp);
        return out;
      },
      getWorldPos: function(out) {
        math.vec3.copy(out, this._position);
        var curr = this._parent;
        while (curr) {
          math.vec3.mul(out, out, curr._scale);
          math.vec3.transformQuat(out, out, curr._quat);
          math.vec3.add(out, out, curr._position);
          curr = curr._parent;
        }
        return out;
      },
      setWorldPos: function(pos) {
        this._parent ? this._parent._invTransformPoint(this._position, pos) : math.vec3.copy(this._position, pos);
        this.setLocalDirty(LocalDirtyFlag.POSITION);
        if (this._eventMask & POSITION_ON) {
          false;
          this.emit(EventType.POSITION_CHANGED);
        }
      },
      getWorldRot: function(out) {
        math.quat.copy(out, this._quat);
        var curr = this._parent;
        while (curr) {
          math.quat.mul(out, curr._quat, out);
          curr = curr._parent;
        }
        return out;
      },
      setWorldRot: function(quat) {
        if (this._parent) {
          this._parent.getWorldRot(this._quat);
          math.quat.conjugate(this._quat, this._quat);
          math.quat.mul(this._quat, this._quat, quat);
        } else math.quat.copy(this._quat, quat);
        this.setLocalDirty(LocalDirtyFlag.ROTATION);
      },
      getWorldRT: function(out) {
        var opos = _vec3_temp;
        var orot = _quat_temp;
        math.vec3.copy(opos, this._position);
        math.quat.copy(orot, this._quat);
        var curr = this._parent;
        while (curr) {
          math.vec3.mul(opos, opos, curr._scale);
          math.vec3.transformQuat(opos, opos, curr._quat);
          math.vec3.add(opos, opos, curr._position);
          math.quat.mul(orot, curr._quat, orot);
          curr = curr._parent;
        }
        math.mat4.fromRT(out, orot, opos);
        return out;
      },
      lookAt: function(pos, up) {
        this.getWorldPos(_vec3_temp);
        math.vec3.sub(_vec3_temp, _vec3_temp, pos);
        math.vec3.normalize(_vec3_temp, _vec3_temp);
        math.quat.fromViewUp(_quat_temp, _vec3_temp, up);
        this.setWorldRot(_quat_temp);
      },
      _updateLocalMatrix: function() {
        var dirtyFlag = this._localMatDirty;
        if (!dirtyFlag) return;
        var t = this._matrix;
        if (dirtyFlag & (LocalDirtyFlag.RT | LocalDirtyFlag.SKEW)) {
          var hasRotation = this._rotationX || this._rotationY;
          var hasSkew = this._skewX || this._skewY;
          var sx = this._scale.x, sy = this._scale.y;
          if (hasRotation || hasSkew) {
            var a = 1, b = 0, c = 0, d = 1;
            if (hasRotation) {
              var rotationRadiansX = this._rotationX * ONE_DEGREE;
              c = Math.sin(rotationRadiansX);
              d = Math.cos(rotationRadiansX);
              if (this._rotationY === this._rotationX) {
                a = d;
                b = -c;
              } else {
                var rotationRadiansY = this._rotationY * ONE_DEGREE;
                a = Math.cos(rotationRadiansY);
                b = -Math.sin(rotationRadiansY);
              }
            }
            t.m00 = a *= sx;
            t.m01 = b *= sx;
            t.m04 = c *= sy;
            t.m05 = d *= sy;
            if (hasSkew) {
              var _a = t.m00, _b = t.m01, _c = t.m04, _d = t.m05;
              var skx = Math.tan(this._skewX * ONE_DEGREE);
              var sky = Math.tan(this._skewY * ONE_DEGREE);
              Infinity === skx && (skx = 99999999);
              Infinity === sky && (sky = 99999999);
              t.m00 = _a + _c * sky;
              t.m01 = _b + _d * sky;
              t.m04 = _c + _a * skx;
              t.m05 = _d + _b * skx;
            }
          } else {
            t.m00 = sx;
            t.m01 = 0;
            t.m04 = 0;
            t.m05 = sy;
          }
        }
        t.m12 = this._position.x;
        t.m13 = this._position.y;
        this._localMatDirty = 0;
        this._worldMatDirty = true;
      },
      _calculWorldMatrix: function() {
        this._localMatDirty && this._updateLocalMatrix();
        var parent = this._parent;
        if (parent) {
          var pt = parent._worldMatrix;
          var t = this._matrix;
          var wt = this._worldMatrix;
          var aa = t.m00, ab = t.m01, ac = t.m04, ad = t.m05, atx = t.m12, aty = t.m13;
          var ba = pt.m00, bb = pt.m01, bc = pt.m04, bd = pt.m05, btx = pt.m12, bty = pt.m13;
          if (0 !== bb || 0 !== bc) {
            wt.m00 = aa * ba + ab * bc;
            wt.m01 = aa * bb + ab * bd;
            wt.m04 = ac * ba + ad * bc;
            wt.m05 = ac * bb + ad * bd;
            wt.m12 = ba * atx + bc * aty + btx;
            wt.m13 = bb * atx + bd * aty + bty;
          } else {
            wt.m00 = aa * ba;
            wt.m01 = ab * bd;
            wt.m04 = ac * ba;
            wt.m05 = ad * bd;
            wt.m12 = ba * atx + btx;
            wt.m13 = bd * aty + bty;
          }
        } else math.mat4.copy(this._worldMatrix, this._matrix);
        this._worldMatDirty = false;
      },
      _updateWorldMatrix: function() {
        this._parent && this._parent._updateWorldMatrix();
        if (this._worldMatDirty) {
          this._calculWorldMatrix();
          var children = this._children;
          for (var i = 0, l = children.length; i < l; i++) children[i]._worldMatDirty = true;
        }
      },
      setLocalDirty: function(flag) {
        this._localMatDirty = this._localMatDirty | flag;
        this._worldMatDirty = true;
      },
      setWorldDirty: function() {
        this._worldMatDirty = true;
      },
      getLocalMatrix: function(out) {
        this._updateLocalMatrix();
        return math.mat4.copy(out, this._matrix);
      },
      getWorldMatrix: function(out) {
        this._updateWorldMatrix();
        return math.mat4.copy(out, this._worldMatrix);
      },
      convertToNodeSpace: function(worldPoint) {
        this._updateWorldMatrix();
        math.mat4.invert(_mat4_temp, this._worldMatrix);
        var out = new cc.Vec2();
        math.vec2.transformMat4(out, worldPoint, _mat4_temp);
        out.x += this._anchorPoint.x * this._contentSize.width;
        out.y += this._anchorPoint.y * this._contentSize.height;
        return out;
      },
      convertToWorldSpace: function(nodePoint) {
        this._updateWorldMatrix();
        var out = new cc.Vec2(nodePoint.x - this._anchorPoint.x * this._contentSize.width, nodePoint.y - this._anchorPoint.y * this._contentSize.height);
        return math.vec2.transformMat4(out, out, this._worldMatrix);
      },
      convertToNodeSpaceAR: function(worldPoint) {
        this._updateWorldMatrix();
        math.mat4.invert(_mat4_temp, this._worldMatrix);
        var out = new cc.Vec2();
        return math.vec2.transformMat4(out, worldPoint, _mat4_temp);
      },
      convertToWorldSpaceAR: function(nodePoint) {
        this._updateWorldMatrix();
        var out = new cc.Vec2();
        return math.vec2.transformMat4(out, nodePoint, this._worldMatrix);
      },
      getNodeToParentTransform: function(out) {
        out || (out = AffineTrans.identity());
        this._updateLocalMatrix();
        var contentSize = this._contentSize;
        _vec3_temp.x = -this._anchorPoint.x * contentSize.width;
        _vec3_temp.y = -this._anchorPoint.y * contentSize.height;
        math.mat4.copy(_mat4_temp, this._matrix);
        math.mat4.translate(_mat4_temp, _mat4_temp, _vec3_temp);
        return AffineTrans.fromMat4(out, _mat4_temp);
      },
      getNodeToParentTransformAR: function(out) {
        out || (out = AffineTrans.identity());
        this._updateLocalMatrix();
        return AffineTrans.fromMat4(out, this._matrix);
      },
      getNodeToWorldTransform: function(out) {
        out || (out = AffineTrans.identity());
        this._updateWorldMatrix();
        var contentSize = this._contentSize;
        _vec3_temp.x = -this._anchorPoint.x * contentSize.width;
        _vec3_temp.y = -this._anchorPoint.y * contentSize.height;
        math.mat4.copy(_mat4_temp, this._worldMatrix);
        math.mat4.translate(_mat4_temp, _mat4_temp, _vec3_temp);
        return AffineTrans.fromMat4(out, _mat4_temp);
      },
      getNodeToWorldTransformAR: function(out) {
        out || (out = AffineTrans.identity());
        this._updateWorldMatrix();
        return AffineTrans.fromMat4(out, this._worldMatrix);
      },
      getParentToNodeTransform: function(out) {
        out || (out = AffineTrans.identity());
        this._updateLocalMatrix();
        math.mat4.invert(_mat4_temp, this._matrix);
        return AffineTrans.fromMat4(out, _mat4_temp);
      },
      getWorldToNodeTransform: function(out) {
        out || (out = AffineTrans.identity());
        this._updateWorldMatrix();
        math.mat4.invert(_mat4_temp, this._worldMatrix);
        return AffineTrans.fromMat4(out, _mat4_temp);
      },
      convertTouchToNodeSpace: function(touch) {
        return this.convertToNodeSpace(touch.getLocation());
      },
      convertTouchToNodeSpaceAR: function(touch) {
        return this.convertToNodeSpaceAR(touch.getLocation());
      },
      getBoundingBox: function() {
        this._updateLocalMatrix();
        var width = this._contentSize.width;
        var height = this._contentSize.height;
        var rect = cc.rect(-this._anchorPoint.x * width, -this._anchorPoint.y * height, width, height);
        return rect.transformMat4(rect, this._matrix);
      },
      getBoundingBoxToWorld: function() {
        if (this._parent) {
          this._parent._updateWorldMatrix();
          return this._getBoundingBoxTo(this._parent._worldMatrix);
        }
        return this.getBoundingBox();
      },
      _getBoundingBoxTo: function(parentMat) {
        this._updateLocalMatrix();
        var width = this._contentSize.width;
        var height = this._contentSize.height;
        var rect = cc.rect(-this._anchorPoint.x * width, -this._anchorPoint.y * height, width, height);
        var parentMat = math.mat4.mul(this._worldMatrix, parentMat, this._matrix);
        rect.transformMat4(rect, parentMat);
        if (!this._children) return rect;
        var locChildren = this._children;
        for (var i = 0; i < locChildren.length; i++) {
          var child = locChildren[i];
          if (child && child.active) {
            var childRect = child._getBoundingBoxTo(parentMat);
            childRect && rect.union(rect, childRect);
          }
        }
        return rect;
      },
      _updateOrderOfArrival: function() {
        var arrivalOrder = ++_globalOrderOfArrival;
        this._localZOrder = 4294901760 & this._localZOrder | arrivalOrder;
      },
      addChild: function(child, zIndex, name) {
        false;
        cc.assertID(child, 1606);
        cc.assertID(null === child._parent, 1605);
        child.parent = this;
        void 0 !== zIndex && (child.zIndex = zIndex);
        void 0 !== name && (child.name = name);
      },
      cleanup: function() {
        ActionManagerExist && cc.director.getActionManager().removeAllActionsFromTarget(this);
        eventManager.removeListeners(this);
        var i, len = this._children.length, node;
        for (i = 0; i < len; ++i) {
          node = this._children[i];
          node && node.cleanup();
        }
      },
      sortAllChildren: function() {
        if (this._reorderChildDirty) {
          this._reorderChildDirty = false;
          var _children = this._children;
          if (_children.length > 1) {
            var len = _children.length, i, j, child;
            for (i = 1; i < len; i++) {
              child = _children[i];
              j = i - 1;
              while (j >= 0) {
                if (!(child._localZOrder < _children[j]._localZOrder)) break;
                _children[j + 1] = _children[j];
                j--;
              }
              _children[j + 1] = child;
            }
            this.emit(EventType.CHILD_REORDER, this);
          }
          cc.director.__fastOff(cc.Director.EVENT_AFTER_UPDATE, this.sortAllChildren, this);
        }
      },
      _delaySort: function() {
        if (!this._reorderChildDirty) {
          this._reorderChildDirty = true;
          cc.director.__fastOn(cc.Director.EVENT_AFTER_UPDATE, this.sortAllChildren, this);
        }
      },
      _restoreProperties: function() {
        this._matrix || (this._matrix = mathPools.mat4.get());
        this._worldMatrix || (this._worldMatrix = mathPools.mat4.get());
        this._localMatDirty = LocalDirtyFlag.ALL;
        this._worldMatDirty = true;
        this._renderFlag |= RenderFlow.FLAG_TRANSFORM;
        if (this._renderComponent) if (this._renderComponent.enabled) {
          this._renderFlag |= RenderFlow.FLAG_COLOR;
          this._renderComponent.markForUpdateRenderData(true);
        } else this._renderComponent.disableRender();
      },
      onRestore: false
    });
    var SameNameGetSets = [ "parent", "position", "scale", "rotation" ];
    misc.propertyDefine(Node, SameNameGetSets);
    cc.Node = module.exports = Node;
  }), {
    "./event-manager": 89,
    "./event/event": 92,
    "./event/event-target": 91,
    "./platform/CCMacro": 152,
    "./platform/js": 167,
    "./renderer/render-engine": 174,
    "./renderer/render-flow": 175,
    "./utils/affine-transform": 200,
    "./utils/base-node": 201,
    "./utils/math-pools": 207,
    "./utils/misc": 208,
    "./utils/prefab-helper": 211
  } ],
  26: [ (function(require, module, exports) {
    "use strict";
    var Node = require("./CCNode");
    var RenderFlow = require("./renderer/render-flow");
    var math = require("./renderer/render-engine").math;
    var LocalDirtyFlag = Node._LocalDirtyFlag;
    var POSITION_ON = 1;
    var _vec3_temp = math.vec3.create();
    var PrivateNode = cc.Class({
      name: "cc.PrivateNode",
      extends: Node,
      properties: {
        x: {
          get: function() {
            return this._originPos.x;
          },
          set: function(value) {
            var localPosition = this._originPos;
            if (value !== localPosition.x) {
              localPosition.x = value;
              this._posDirty(true);
            }
          },
          override: true
        },
        y: {
          get: function() {
            return this._originPos.y;
          },
          set: function(value) {
            var localPosition = this._originPos;
            if (value !== localPosition.y) {
              localPosition.y = value;
              this._posDirty(true);
            }
          },
          override: true
        },
        zIndex: {
          get: function() {
            return cc.macro.MIN_ZINDEX;
          },
          set: function() {
            cc.warnID(1638);
          },
          override: true
        }
      },
      ctor: function(name) {
        this._localZOrder = cc.macro.MIN_ZINDEX << 16;
        this._originPos = cc.v2();
      },
      _posDirty: function(sendEvent) {
        this.setLocalDirty(LocalDirtyFlag.POSITION);
        this._renderFlag |= RenderFlow.FLAG_LOCAL_TRANSFORM;
        true === sendEvent && this._eventMask & POSITION_ON && this.emit(Node.EventType.POSITION_CHANGED);
      },
      _updateLocalMatrix: function() {
        if (!this._localMatDirty) return;
        var parent = this.parent;
        if (parent) {
          this._position.x = this._originPos.x - (parent._anchorPoint.x - .5) * parent._contentSize.width;
          this._position.y = this._originPos.y - (parent._anchorPoint.y - .5) * parent._contentSize.height;
        }
        this._super();
      },
      getPosition: function() {
        return new cc.Vec2(this._originPos);
      },
      setPosition: function(x, y) {
        if (void 0 === y) {
          x = x.x;
          y = x.y;
        }
        var pos = this._originPos;
        if (pos.x === x && pos.y === y) return;
        pos.x = x;
        pos.y = y;
        this._posDirty(true);
      },
      setParent: function(value) {
        var oldParent = this._parent;
        this._super(value);
        if (oldParent !== value) {
          oldParent && oldParent.off(Node.EventType.ANCHOR_CHANGED, this._posDirty, this);
          value && value.on(Node.EventType.ANCHOR_CHANGED, this._posDirty, this);
        }
      },
      _updateOrderOfArrival: function() {}
    });
    cc.js.getset(PrivateNode.prototype, "parent", PrivateNode.prototype.getParent, PrivateNode.prototype.setParent);
    cc.js.getset(PrivateNode.prototype, "position", PrivateNode.prototype.getPosition, PrivateNode.prototype.setPosition);
    cc.PrivateNode = module.exports = PrivateNode;
  }), {
    "./CCNode": 25,
    "./renderer/render-engine": 174,
    "./renderer/render-flow": 175
  } ],
  27: [ (function(require, module, exports) {
    var NIL = function() {};
    cc.Scene = cc.Class({
      name: "cc.Scene",
      extends: require("./CCNode"),
      properties: {
        autoReleaseAssets: {
          default: void 0,
          type: cc.Boolean
        }
      },
      ctor: function() {
        this._anchorPoint.x = 0;
        this._anchorPoint.y = 0;
        this._activeInHierarchy = false;
        this._inited = !cc.game._isCloning;
        false;
        this.dependAssets = null;
      },
      destroy: function() {
        this._super();
        this._activeInHierarchy = false;
      },
      _onHierarchyChanged: NIL,
      _instantiate: null,
      _load: function() {
        if (!this._inited) {
          false;
          false;
          this._onBatchCreated();
          this._inited = true;
        }
      },
      _activate: function(active) {
        active = false !== active;
        false, false;
        cc.director._nodeActivator.activateNode(this, active);
      }
    });
    module.exports = cc.Scene;
  }), {
    "./CCNode": 25
  } ],
  28: [ (function(require, module, exports) {
    var js = require("./platform/js");
    var IdGenerater = require("./platform/id-generater");
    var MAX_POOL_SIZE = 20;
    var idGenerater = new IdGenerater("Scheduler");
    var ListEntry = function(target, priority, paused, markedForDeletion) {
      this.target = target;
      this.priority = priority;
      this.paused = paused;
      this.markedForDeletion = markedForDeletion;
    };
    var _listEntries = [];
    ListEntry.get = function(target, priority, paused, markedForDeletion) {
      var result = _listEntries.pop();
      if (result) {
        result.target = target;
        result.priority = priority;
        result.paused = paused;
        result.markedForDeletion = markedForDeletion;
      } else result = new ListEntry(target, priority, paused, markedForDeletion);
      return result;
    };
    ListEntry.put = function(entry) {
      if (_listEntries.length < MAX_POOL_SIZE) {
        entry.target = null;
        _listEntries.push(entry);
      }
    };
    var HashUpdateEntry = function(list, entry, target, callback) {
      this.list = list;
      this.entry = entry;
      this.target = target;
      this.callback = callback;
    };
    var _hashUpdateEntries = [];
    HashUpdateEntry.get = function(list, entry, target, callback) {
      var result = _hashUpdateEntries.pop();
      if (result) {
        result.list = list;
        result.entry = entry;
        result.target = target;
        result.callback = callback;
      } else result = new HashUpdateEntry(list, entry, target, callback);
      return result;
    };
    HashUpdateEntry.put = function(entry) {
      if (_hashUpdateEntries.length < MAX_POOL_SIZE) {
        entry.list = entry.entry = entry.target = entry.callback = null;
        _hashUpdateEntries.push(entry);
      }
    };
    var HashTimerEntry = function(timers, target, timerIndex, currentTimer, currentTimerSalvaged, paused) {
      var _t = this;
      _t.timers = timers;
      _t.target = target;
      _t.timerIndex = timerIndex;
      _t.currentTimer = currentTimer;
      _t.currentTimerSalvaged = currentTimerSalvaged;
      _t.paused = paused;
    };
    var _hashTimerEntries = [];
    HashTimerEntry.get = function(timers, target, timerIndex, currentTimer, currentTimerSalvaged, paused) {
      var result = _hashTimerEntries.pop();
      if (result) {
        result.timers = timers;
        result.target = target;
        result.timerIndex = timerIndex;
        result.currentTimer = currentTimer;
        result.currentTimerSalvaged = currentTimerSalvaged;
        result.paused = paused;
      } else result = new HashTimerEntry(timers, target, timerIndex, currentTimer, currentTimerSalvaged, paused);
      return result;
    };
    HashTimerEntry.put = function(entry) {
      if (_hashTimerEntries.length < MAX_POOL_SIZE) {
        entry.timers = entry.target = entry.currentTimer = null;
        _hashTimerEntries.push(entry);
      }
    };
    function CallbackTimer() {
      this._lock = false;
      this._scheduler = null;
      this._elapsed = -1;
      this._runForever = false;
      this._useDelay = false;
      this._timesExecuted = 0;
      this._repeat = 0;
      this._delay = 0;
      this._interval = 0;
      this._target = null;
      this._callback = null;
    }
    var proto = CallbackTimer.prototype;
    proto.initWithCallback = function(scheduler, callback, target, seconds, repeat, delay) {
      this._lock = false;
      this._scheduler = scheduler;
      this._target = target;
      this._callback = callback;
      this._elapsed = -1;
      this._interval = seconds;
      this._delay = delay;
      this._useDelay = this._delay > 0;
      this._repeat = repeat;
      this._runForever = this._repeat === cc.macro.REPEAT_FOREVER;
      return true;
    };
    proto.getInterval = function() {
      return this._interval;
    };
    proto.setInterval = function(interval) {
      this._interval = interval;
    };
    proto.update = function(dt) {
      if (-1 === this._elapsed) {
        this._elapsed = 0;
        this._timesExecuted = 0;
      } else {
        this._elapsed += dt;
        if (this._runForever && !this._useDelay) {
          if (this._elapsed >= this._interval) {
            this.trigger();
            this._elapsed = 0;
          }
        } else {
          if (this._useDelay) {
            if (this._elapsed >= this._delay) {
              this.trigger();
              this._elapsed -= this._delay;
              this._timesExecuted += 1;
              this._useDelay = false;
            }
          } else if (this._elapsed >= this._interval) {
            this.trigger();
            this._elapsed = 0;
            this._timesExecuted += 1;
          }
          this._callback && !this._runForever && this._timesExecuted > this._repeat && this.cancel();
        }
      }
    };
    proto.getCallback = function() {
      return this._callback;
    };
    proto.trigger = function() {
      if (this._target && this._callback) {
        this._lock = true;
        this._callback.call(this._target, this._elapsed);
        this._lock = false;
      }
    };
    proto.cancel = function() {
      this._scheduler.unschedule(this._callback, this._target);
    };
    var _timers = [];
    CallbackTimer.get = function() {
      return _timers.pop() || new CallbackTimer();
    };
    CallbackTimer.put = function(timer) {
      if (_timers.length < MAX_POOL_SIZE && !timer._lock) {
        timer._scheduler = timer._target = timer._callback = null;
        _timers.push(timer);
      }
    };
    cc.Scheduler = function() {
      this._timeScale = 1;
      this._updatesNegList = [];
      this._updates0List = [];
      this._updatesPosList = [];
      this._hashForUpdates = js.createMap(true);
      this._hashForTimers = js.createMap(true);
      this._currentTarget = null;
      this._currentTargetSalvaged = false;
      this._updateHashLocked = false;
      this._arrayForTimers = [];
    };
    cc.Scheduler.prototype = {
      constructor: cc.Scheduler,
      _removeHashElement: function(element) {
        delete this._hashForTimers[element.target._id];
        var arr = this._arrayForTimers;
        for (var i = 0, l = arr.length; i < l; i++) if (arr[i] === element) {
          arr.splice(i, 1);
          break;
        }
        HashTimerEntry.put(element);
      },
      _removeUpdateFromHash: function(entry) {
        var targetId = entry.target._id;
        var self = this, element = self._hashForUpdates[targetId];
        if (element) {
          var list = element.list, listEntry = element.entry;
          for (var i = 0, l = list.length; i < l; i++) if (list[i] === listEntry) {
            list.splice(i, 1);
            break;
          }
          delete self._hashForUpdates[targetId];
          ListEntry.put(listEntry);
          HashUpdateEntry.put(element);
        }
      },
      _priorityIn: function(ppList, listElement, priority) {
        for (var i = 0; i < ppList.length; i++) if (priority < ppList[i].priority) {
          ppList.splice(i, 0, listElement);
          return;
        }
        ppList.push(listElement);
      },
      _appendIn: function(ppList, listElement) {
        ppList.push(listElement);
      },
      enableForTarget: function(target) {
        target._id || (target.__instanceId ? cc.warnID(1513) : target._id = idGenerater.getNewId());
      },
      setTimeScale: function(timeScale) {
        this._timeScale = timeScale;
      },
      getTimeScale: function() {
        return this._timeScale;
      },
      update: function(dt) {
        this._updateHashLocked = true;
        1 !== this._timeScale && (dt *= this._timeScale);
        var i, list, len, entry;
        for (i = 0, list = this._updatesNegList, len = list.length; i < len; i++) {
          entry = list[i];
          entry.paused || entry.markedForDeletion || entry.target.update(dt);
        }
        for (i = 0, list = this._updates0List, len = list.length; i < len; i++) {
          entry = list[i];
          entry.paused || entry.markedForDeletion || entry.target.update(dt);
        }
        for (i = 0, list = this._updatesPosList, len = list.length; i < len; i++) {
          entry = list[i];
          entry.paused || entry.markedForDeletion || entry.target.update(dt);
        }
        var elt, arr = this._arrayForTimers;
        for (i = 0; i < arr.length; i++) {
          elt = arr[i];
          this._currentTarget = elt;
          this._currentTargetSalvaged = false;
          if (!elt.paused) for (elt.timerIndex = 0; elt.timerIndex < elt.timers.length; ++elt.timerIndex) {
            elt.currentTimer = elt.timers[elt.timerIndex];
            elt.currentTimerSalvaged = false;
            elt.currentTimer.update(dt);
            elt.currentTimer = null;
          }
          if (this._currentTargetSalvaged && 0 === this._currentTarget.timers.length) {
            this._removeHashElement(this._currentTarget);
            --i;
          }
        }
        for (i = 0, list = this._updatesNegList; i < list.length; ) {
          entry = list[i];
          entry.markedForDeletion ? this._removeUpdateFromHash(entry) : i++;
        }
        for (i = 0, list = this._updates0List; i < list.length; ) {
          entry = list[i];
          entry.markedForDeletion ? this._removeUpdateFromHash(entry) : i++;
        }
        for (i = 0, list = this._updatesPosList; i < list.length; ) {
          entry = list[i];
          entry.markedForDeletion ? this._removeUpdateFromHash(entry) : i++;
        }
        this._updateHashLocked = false;
        this._currentTarget = null;
      },
      schedule: function(callback, target, interval, repeat, delay, paused) {
        "use strict";
        if ("function" !== typeof callback) {
          var tmp = callback;
          callback = target;
          target = tmp;
        }
        if (4 === arguments.length || 5 === arguments.length) {
          paused = !!repeat;
          repeat = cc.macro.REPEAT_FOREVER;
          delay = 0;
        }
        cc.assertID(target, 1502);
        var targetId = target._id;
        if (!targetId) if (target.__instanceId) {
          cc.warnID(1513);
          targetId = target._id = target.__instanceId;
        } else cc.errorID(1510);
        var element = this._hashForTimers[targetId];
        if (element) element.paused !== paused && cc.warnID(1511); else {
          element = HashTimerEntry.get(null, target, 0, null, null, paused);
          this._arrayForTimers.push(element);
          this._hashForTimers[targetId] = element;
        }
        var timer, i;
        if (null == element.timers) element.timers = []; else for (i = 0; i < element.timers.length; ++i) {
          timer = element.timers[i];
          if (timer && callback === timer._callback) {
            cc.logID(1507, timer.getInterval(), interval);
            timer._interval = interval;
            return;
          }
        }
        timer = CallbackTimer.get();
        timer.initWithCallback(this, callback, target, interval, repeat, delay);
        element.timers.push(timer);
        this._currentTarget === element && this._currentTargetSalvaged && (this._currentTargetSalvaged = false);
      },
      scheduleUpdate: function(target, priority, paused) {
        var targetId = target._id;
        if (!targetId) if (target.__instanceId) {
          cc.warnID(1513);
          targetId = target._id = target.__instanceId;
        } else cc.errorID(1510);
        var hashElement = this._hashForUpdates[targetId];
        if (hashElement && hashElement.entry) {
          if (hashElement.entry.priority === priority) {
            hashElement.entry.markedForDeletion = false;
            hashElement.entry.paused = paused;
            return;
          }
          if (this._updateHashLocked) {
            cc.logID(1506);
            hashElement.entry.markedForDeletion = false;
            hashElement.entry.paused = paused;
            return;
          }
          this.unscheduleUpdate(target);
        }
        var listElement = ListEntry.get(target, priority, paused, false);
        var ppList;
        if (0 === priority) {
          ppList = this._updates0List;
          this._appendIn(ppList, listElement);
        } else {
          ppList = priority < 0 ? this._updatesNegList : this._updatesPosList;
          this._priorityIn(ppList, listElement, priority);
        }
        this._hashForUpdates[targetId] = HashUpdateEntry.get(ppList, listElement, target, null);
      },
      unschedule: function(callback, target) {
        if (!target || !callback) return;
        var targetId = target._id;
        if (!targetId) if (target.__instanceId) {
          cc.warnID(1513);
          targetId = target._id = target.__instanceId;
        } else cc.errorID(1510);
        var self = this, element = self._hashForTimers[targetId];
        if (element) {
          var timers = element.timers;
          for (var i = 0, li = timers.length; i < li; i++) {
            var timer = timers[i];
            if (callback === timer._callback) {
              timer !== element.currentTimer || element.currentTimerSalvaged || (element.currentTimerSalvaged = true);
              timers.splice(i, 1);
              CallbackTimer.put(timer);
              element.timerIndex >= i && element.timerIndex--;
              0 === timers.length && (self._currentTarget === element ? self._currentTargetSalvaged = true : self._removeHashElement(element));
              return;
            }
          }
        }
      },
      unscheduleUpdate: function(target) {
        if (!target) return;
        var targetId = target._id;
        if (!targetId) if (target.__instanceId) {
          cc.warnID(1513);
          targetId = target._id = target.__instanceId;
        } else cc.errorID(1510);
        var element = this._hashForUpdates[targetId];
        element && (this._updateHashLocked ? element.entry.markedForDeletion = true : this._removeUpdateFromHash(element.entry));
      },
      unscheduleAllForTarget: function(target) {
        if (!target) return;
        var targetId = target._id;
        if (!targetId) if (target.__instanceId) {
          cc.warnID(1513);
          targetId = target._id = target.__instanceId;
        } else cc.errorID(1510);
        var element = this._hashForTimers[targetId];
        if (element) {
          var timers = element.timers;
          timers.indexOf(element.currentTimer) > -1 && !element.currentTimerSalvaged && (element.currentTimerSalvaged = true);
          for (var i = 0, l = timers.length; i < l; i++) CallbackTimer.put(timers[i]);
          timers.length = 0;
          this._currentTarget === element ? this._currentTargetSalvaged = true : this._removeHashElement(element);
        }
        this.unscheduleUpdate(target);
      },
      unscheduleAll: function() {
        this.unscheduleAllWithMinPriority(cc.Scheduler.PRIORITY_SYSTEM);
      },
      unscheduleAllWithMinPriority: function(minPriority) {
        var i, element, arr = this._arrayForTimers;
        for (i = arr.length - 1; i >= 0; i--) {
          element = arr[i];
          this.unscheduleAllForTarget(element.target);
        }
        var entry;
        var temp_length = 0;
        if (minPriority < 0) for (i = 0; i < this._updatesNegList.length; ) {
          temp_length = this._updatesNegList.length;
          entry = this._updatesNegList[i];
          entry && entry.priority >= minPriority && this.unscheduleUpdate(entry.target);
          temp_length == this._updatesNegList.length && i++;
        }
        if (minPriority <= 0) for (i = 0; i < this._updates0List.length; ) {
          temp_length = this._updates0List.length;
          entry = this._updates0List[i];
          entry && this.unscheduleUpdate(entry.target);
          temp_length == this._updates0List.length && i++;
        }
        for (i = 0; i < this._updatesPosList.length; ) {
          temp_length = this._updatesPosList.length;
          entry = this._updatesPosList[i];
          entry && entry.priority >= minPriority && this.unscheduleUpdate(entry.target);
          temp_length == this._updatesPosList.length && i++;
        }
      },
      isScheduled: function(callback, target) {
        cc.assertID(callback, 1508);
        cc.assertID(target, 1509);
        var targetId = target._id;
        if (!targetId) if (target.__instanceId) {
          cc.warnID(1513);
          targetId = target._id = target.__instanceId;
        } else cc.errorID(1510);
        var element = this._hashForTimers[targetId];
        if (!element) return false;
        if (null == element.timers) return false;
        var timers = element.timers;
        for (var i = 0; i < timers.length; ++i) {
          var timer = timers[i];
          if (callback === timer._callback) return true;
        }
        return false;
      },
      pauseAllTargets: function() {
        return this.pauseAllTargetsWithMinPriority(cc.Scheduler.PRIORITY_SYSTEM);
      },
      pauseAllTargetsWithMinPriority: function(minPriority) {
        var idsWithSelectors = [];
        var self = this, element, locArrayForTimers = self._arrayForTimers;
        var i, li;
        for (i = 0, li = locArrayForTimers.length; i < li; i++) {
          element = locArrayForTimers[i];
          if (element) {
            element.paused = true;
            idsWithSelectors.push(element.target);
          }
        }
        var entry;
        if (minPriority < 0) for (i = 0; i < this._updatesNegList.length; i++) {
          entry = this._updatesNegList[i];
          if (entry && entry.priority >= minPriority) {
            entry.paused = true;
            idsWithSelectors.push(entry.target);
          }
        }
        if (minPriority <= 0) for (i = 0; i < this._updates0List.length; i++) {
          entry = this._updates0List[i];
          if (entry) {
            entry.paused = true;
            idsWithSelectors.push(entry.target);
          }
        }
        for (i = 0; i < this._updatesPosList.length; i++) {
          entry = this._updatesPosList[i];
          if (entry && entry.priority >= minPriority) {
            entry.paused = true;
            idsWithSelectors.push(entry.target);
          }
        }
        return idsWithSelectors;
      },
      resumeTargets: function(targetsToResume) {
        if (!targetsToResume) return;
        for (var i = 0; i < targetsToResume.length; i++) this.resumeTarget(targetsToResume[i]);
      },
      pauseTarget: function(target) {
        cc.assertID(target, 1503);
        var targetId = target._id;
        if (!targetId) if (target.__instanceId) {
          cc.warnID(1513);
          targetId = target._id = target.__instanceId;
        } else cc.errorID(1510);
        var self = this, element = self._hashForTimers[targetId];
        element && (element.paused = true);
        var elementUpdate = self._hashForUpdates[targetId];
        elementUpdate && (elementUpdate.entry.paused = true);
      },
      resumeTarget: function(target) {
        cc.assertID(target, 1504);
        var targetId = target._id;
        if (!targetId) if (target.__instanceId) {
          cc.warnID(1513);
          targetId = target._id = target.__instanceId;
        } else cc.errorID(1510);
        var self = this, element = self._hashForTimers[targetId];
        element && (element.paused = false);
        var elementUpdate = self._hashForUpdates[targetId];
        elementUpdate && (elementUpdate.entry.paused = false);
      },
      isTargetPaused: function(target) {
        cc.assertID(target, 1505);
        var targetId = target._id;
        if (!targetId) if (target.__instanceId) {
          cc.warnID(1513);
          targetId = target._id = target.__instanceId;
        } else cc.errorID(1510);
        var element = this._hashForTimers[targetId];
        if (element) return element.paused;
        var elementUpdate = this._hashForUpdates[targetId];
        if (elementUpdate) return elementUpdate.entry.paused;
        return false;
      }
    };
    cc.Scheduler.PRIORITY_SYSTEM = 1 << 31;
    cc.Scheduler.PRIORITY_NON_SYSTEM = cc.Scheduler.PRIORITY_SYSTEM + 1;
    module.exports = cc.Scheduler;
  }), {
    "./platform/id-generater": 163,
    "./platform/js": 167
  } ],
  29: [ (function(require, module, exports) {
    var RawAsset = require("./CCRawAsset");
    cc.Asset = cc.Class({
      name: "cc.Asset",
      extends: RawAsset,
      ctor: function() {
        this.loaded = true;
      },
      properties: {
        nativeUrl: {
          get: function() {
            if (this._native) {
              var name = this._native;
              if (47 === name.charCodeAt(0)) return name.slice(1);
              if (cc.AssetLibrary) {
                var base = cc.AssetLibrary.getLibUrlNoExt(this._uuid, true);
                return 46 === name.charCodeAt(0) ? base + name : base + "/" + name;
              }
              cc.errorID(6400);
            }
            return "";
          },
          visible: false
        },
        _native: "",
        _nativeAsset: {
          get: function() {},
          set: function(obj) {}
        }
      },
      statics: {
        deserialize: false,
        preventDeferredLoadDependents: false,
        preventPreloadNativeObject: false
      },
      toString: function() {
        return this.nativeUrl;
      },
      serialize: false,
      createNode: null,
      _setRawAsset: function(filename, inLibrary) {
        this._native = false !== inLibrary ? filename || void 0 : "/" + filename;
      }
    });
    module.exports = cc.Asset;
  }), {
    "./CCRawAsset": 36
  } ],
  30: [ (function(require, module, exports) {
    var Asset = require("./CCAsset");
    var EventTarget = require("../event/event-target");
    var LoadMode = cc.Enum({
      WEB_AUDIO: 0,
      DOM_AUDIO: 1
    });
    var AudioClip = cc.Class({
      name: "cc.AudioClip",
      extends: Asset,
      mixins: [ EventTarget ],
      ctor: function() {
        this.loaded = false;
        this._audio = null;
      },
      properties: {
        loadMode: {
          default: LoadMode.WEB_AUDIO,
          type: LoadMode
        },
        _nativeAsset: {
          get: function() {
            return this._audio;
          },
          set: function(value) {
            this._audio = value;
            if (value) {
              this.loaded = true;
              this.emit("load");
            }
          },
          override: true
        }
      },
      statics: {
        LoadMode: LoadMode,
        _loadByUrl: function(url, callback) {
          var item = cc.loader.getItem(url) || cc.loader.getItem(url + "?useDom=1");
          item && item.complete ? item._owner instanceof AudioClip ? callback(null, item._owner) : callback(null, item.content) : cc.loader.load(url, (function(error, downloadUrl) {
            if (error) return callback(error);
            item = cc.loader.getItem(url) || cc.loader.getItem(url + "?useDom=1");
            callback(null, item.content);
          }));
        }
      },
      destroy: function() {
        cc.audioEngine.uncache(this);
        this._super();
      }
    });
    cc.AudioClip = AudioClip;
    module.exports = AudioClip;
  }), {
    "../event/event-target": 91,
    "./CCAsset": 29
  } ],
  31: [ (function(require, module, exports) {
    var BitmapFont = cc.Class({
      name: "cc.BitmapFont",
      extends: cc.Font,
      properties: {
        fntDataStr: {
          default: ""
        },
        spriteFrame: {
          default: null,
          type: cc.SpriteFrame
        },
        fontSize: {
          default: -1
        },
        _fntConfig: null
      }
    });
    cc.BitmapFont = BitmapFont;
    module.exports = BitmapFont;
  }), {} ],
  32: [ (function(require, module, exports) {
    var Font = cc.Class({
      name: "cc.Font",
      extends: cc.Asset
    });
    cc.Font = module.exports = Font;
  }), {} ],
  33: [ (function(require, module, exports) {
    var JsonAsset = cc.Class({
      name: "cc.JsonAsset",
      extends: cc.Asset,
      properties: {
        json: null
      }
    });
    module.exports = cc.JsonAsset = JsonAsset;
  }), {} ],
  34: [ (function(require, module, exports) {
    var LabelAtlas = cc.Class({
      name: "cc.LabelAtlas",
      extends: cc.BitmapFont
    });
    cc.LabelAtlas = LabelAtlas;
    module.exports = LabelAtlas;
  }), {} ],
  35: [ (function(require, module, exports) {
    var OptimizationPolicy = cc.Enum({
      AUTO: 0,
      SINGLE_INSTANCE: 1,
      MULTI_INSTANCE: 2
    });
    var Prefab = cc.Class({
      name: "cc.Prefab",
      extends: cc.Asset,
      ctor: function() {
        this._createFunction = null;
        this._instantiatedTimes = 0;
      },
      properties: {
        data: null,
        optimizationPolicy: OptimizationPolicy.AUTO,
        asyncLoadAssets: false
      },
      statics: {
        OptimizationPolicy: OptimizationPolicy,
        OptimizationPolicyThreshold: 3
      },
      createNode: false,
      compileCreateFunction: function() {
        var jit = require("../platform/instantiate-jit");
        this._createFunction = jit.compile(this.data);
      },
      _doInstantiate: function(rootToRedirect) {
        this.data._prefab ? this.data._prefab._synced = true : cc.warnID(3700);
        this._createFunction || this.compileCreateFunction();
        return this._createFunction(rootToRedirect);
      },
      _instantiate: function() {
        var node, useJit = false;
        false;
        if (useJit) {
          node = this._doInstantiate();
          this.data._instantiate(node);
        } else {
          this.data._prefab._synced = true;
          node = this.data._instantiate();
        }
        ++this._instantiatedTimes;
        var PrefabUtils;
        false, false;
        return node;
      }
    });
    cc.Prefab = module.exports = Prefab;
    cc.js.obsolete(cc, "cc._Prefab", "Prefab");
  }), {
    "../platform/instantiate-jit": 165
  } ],
  36: [ (function(require, module, exports) {
    var CCObject = require("../platform/CCObject");
    var js = require("../platform/js");
    cc.RawAsset = cc.Class({
      name: "cc.RawAsset",
      extends: CCObject,
      ctor: function() {
        Object.defineProperty(this, "_uuid", {
          value: "",
          writable: true
        });
      }
    });
    js.value(cc.RawAsset, "isRawAssetType", (function(ctor) {
      return js.isChildClassOf(ctor, cc.RawAsset) && !js.isChildClassOf(ctor, cc.Asset);
    }));
    js.value(cc.RawAsset, "wasRawAssetType", (function(ctor) {
      return ctor === cc.Texture2D || ctor === cc.AudioClip || ctor === cc.ParticleAsset || ctor === cc.Asset;
    }));
    module.exports = cc.RawAsset;
  }), {
    "../platform/CCObject": 153,
    "../platform/js": 167
  } ],
  37: [ (function(require, module, exports) {
    var Scene = cc.Class({
      name: "cc.SceneAsset",
      extends: cc.Asset,
      properties: {
        scene: null,
        asyncLoadAssets: void 0
      }
    });
    cc.SceneAsset = Scene;
    module.exports = Scene;
  }), {} ],
  38: [ (function(require, module, exports) {
    var Script = cc.Class({
      name: "cc.Script",
      extends: cc.Asset
    });
    cc._Script = Script;
    var JavaScript = cc.Class({
      name: "cc.JavaScript",
      extends: Script
    });
    cc._JavaScript = JavaScript;
    var CoffeeScript = cc.Class({
      name: "cc.CoffeeScript",
      extends: Script
    });
    cc._CoffeeScript = CoffeeScript;
    var TypeScript = cc.Class({
      name: "cc.TypeScript",
      extends: Script
    });
    cc._TypeScript = TypeScript;
  }), {} ],
  39: [ (function(require, module, exports) {
    var SpriteAtlas = cc.Class({
      name: "cc.SpriteAtlas",
      extends: cc.Asset,
      properties: {
        _spriteFrames: {
          default: {}
        }
      },
      getTexture: function() {
        var keys = Object.keys(this._spriteFrames);
        if (keys.length > 0) {
          var spriteFrame = this._spriteFrames[keys[0]];
          return spriteFrame ? spriteFrame.getTexture() : null;
        }
        return null;
      },
      getSpriteFrame: function(key) {
        var sf = this._spriteFrames[key];
        if (!sf) return null;
        sf.name || (sf.name = key);
        return sf;
      },
      getSpriteFrames: function() {
        var frames = [];
        var spriteFrames = this._spriteFrames;
        for (var key in spriteFrames) frames.push(this.getSpriteFrame(key));
        return frames;
      }
    });
    cc.SpriteAtlas = SpriteAtlas;
    module.exports = SpriteAtlas;
  }), {} ],
  40: [ (function(require, module, exports) {
    var EventTarget = require("../event/event-target");
    var textureUtil = require("../utils/texture-util");
    var temp_uvs = [ {
      u: 0,
      v: 0
    }, {
      u: 0,
      v: 0
    }, {
      u: 0,
      v: 0
    }, {
      u: 0,
      v: 0
    } ];
    var SpriteFrame = cc.Class({
      name: "cc.SpriteFrame",
      extends: require("../assets/CCAsset"),
      mixins: [ EventTarget ],
      properties: {
        _textureSetter: {
          set: function(texture) {
            if (texture) {
              false;
              this._texture !== texture && this._refreshTexture(texture);
              this._textureFilename = texture.url;
            }
          }
        }
      },
      ctor: function() {
        EventTarget.call(this);
        var filename = arguments[0];
        var rect = arguments[1];
        var rotated = arguments[2];
        var offset = arguments[3];
        var originalSize = arguments[4];
        this._rect = null;
        this._offset = null;
        this._originalSize = null;
        this._rotated = false;
        this.insetTop = 0;
        this.insetBottom = 0;
        this.insetLeft = 0;
        this.insetRight = 0;
        this.vertices = null;
        this.uv = [];
        this.uvSliced = [];
        this._texture = null;
        this._textureFilename = "";
        this._original = null;
        false;
        void 0 !== filename && this.setTexture(filename, rect, rotated, offset, originalSize);
      },
      textureLoaded: function() {
        return this._texture && this._texture.loaded;
      },
      isRotated: function() {
        return this._rotated;
      },
      setRotated: function(bRotated) {
        this._rotated = bRotated;
      },
      getRect: function() {
        return cc.rect(this._rect);
      },
      setRect: function(rect) {
        this._rect = rect;
      },
      getOriginalSize: function() {
        return cc.size(this._originalSize);
      },
      setOriginalSize: function(size) {
        if (this._originalSize) {
          this._originalSize.width = size.width;
          this._originalSize.height = size.height;
        } else this._originalSize = cc.size(size);
      },
      getTexture: function() {
        return this._texture;
      },
      _textureLoadedCallback: function() {
        var self = this;
        var texture = this._texture;
        if (!texture) return;
        var w = texture.width, h = texture.height;
        if (self._rotated && cc.game.renderType === cc.game.RENDER_TYPE_CANVAS) {
          self._rotated = false;
          w = self._texture.width;
          h = self._texture.height;
          self.setRect(cc.rect(0, 0, w, h));
        }
        self._rect ? self._checkRect(self._texture) : self.setRect(cc.rect(0, 0, w, h));
        self._originalSize || self.setOriginalSize(cc.size(w, h));
        self._offset || self.setOffset(cc.v2(0, 0));
        self._calculateUV();
        self.emit("load");
      },
      _refreshTexture: function(texture) {
        this._texture = texture;
        texture.loaded ? this._textureLoadedCallback() : texture.once("load", this._textureLoadedCallback, this);
      },
      getOffset: function() {
        return cc.v2(this._offset);
      },
      setOffset: function(offsets) {
        this._offset = cc.v2(offsets);
      },
      clone: function() {
        return new SpriteFrame(this._texture || this._textureFilename, this._rect, this._rotated, this._offset, this._originalSize);
      },
      setTexture: function(textureOrTextureFile, rect, rotated, offset, originalSize) {
        rect ? this.setRect(rect) : this._rect = null;
        offset ? this.setOffset(offset) : this._offset = null;
        originalSize ? this.setOriginalSize(originalSize) : this._originalSize = null;
        this._rotated = rotated || false;
        var texture = textureOrTextureFile;
        if ("string" === typeof texture && texture) {
          this._textureFilename = texture;
          this._loadTexture();
        }
        texture instanceof cc.Texture2D && this._texture !== texture && this._refreshTexture(texture);
        return true;
      },
      _loadTexture: function() {
        if (this._textureFilename) {
          var texture = textureUtil.loadImage(this._textureFilename);
          this._refreshTexture(texture);
        }
      },
      ensureLoadTexture: function() {
        if (this._texture) {
          if (!this._texture.loaded) {
            this._refreshTexture(this._texture);
            textureUtil.postLoadTexture(this._texture);
          }
        } else this._textureFilename && this._loadTexture();
      },
      clearTexture: function() {
        this._texture = null;
      },
      _checkRect: function(texture) {
        var rect = this._rect;
        var maxX = rect.x, maxY = rect.y;
        if (this._rotated) {
          maxX += rect.height;
          maxY += rect.width;
        } else {
          maxX += rect.width;
          maxY += rect.height;
        }
        maxX > texture.width && cc.errorID(3300, texture.url + "/" + this.name, maxX, texture.width);
        maxY > texture.height && cc.errorID(3400, texture.url + "/" + this.name, maxY, texture.height);
      },
      _calculateSlicedUV: function() {
        var rect = this._rect;
        var atlasWidth = this._texture.width;
        var atlasHeight = this._texture.height;
        var leftWidth = this.insetLeft;
        var rightWidth = this.insetRight;
        var centerWidth = rect.width - leftWidth - rightWidth;
        var topHeight = this.insetTop;
        var bottomHeight = this.insetBottom;
        var centerHeight = rect.height - topHeight - bottomHeight;
        var uvSliced = this.uvSliced;
        uvSliced.length = 0;
        if (this._rotated) {
          temp_uvs[0].u = rect.x / atlasWidth;
          temp_uvs[1].u = (rect.x + bottomHeight) / atlasWidth;
          temp_uvs[2].u = (rect.x + bottomHeight + centerHeight) / atlasWidth;
          temp_uvs[3].u = (rect.x + rect.height) / atlasWidth;
          temp_uvs[3].v = rect.y / atlasHeight;
          temp_uvs[2].v = (rect.y + leftWidth) / atlasHeight;
          temp_uvs[1].v = (rect.y + leftWidth + centerWidth) / atlasHeight;
          temp_uvs[0].v = (rect.y + rect.width) / atlasHeight;
          for (var row = 0; row < 4; ++row) {
            var rowD = temp_uvs[row];
            for (var col = 0; col < 4; ++col) {
              var colD = temp_uvs[3 - col];
              uvSliced.push({
                u: rowD.u,
                v: colD.v
              });
            }
          }
        } else {
          temp_uvs[0].u = rect.x / atlasWidth;
          temp_uvs[1].u = (rect.x + leftWidth) / atlasWidth;
          temp_uvs[2].u = (rect.x + leftWidth + centerWidth) / atlasWidth;
          temp_uvs[3].u = (rect.x + rect.width) / atlasWidth;
          temp_uvs[3].v = rect.y / atlasHeight;
          temp_uvs[2].v = (rect.y + topHeight) / atlasHeight;
          temp_uvs[1].v = (rect.y + topHeight + centerHeight) / atlasHeight;
          temp_uvs[0].v = (rect.y + rect.height) / atlasHeight;
          for (var _row = 0; _row < 4; ++_row) {
            var _rowD = temp_uvs[_row];
            for (var _col = 0; _col < 4; ++_col) {
              var _colD = temp_uvs[_col];
              uvSliced.push({
                u: _colD.u,
                v: _rowD.v
              });
            }
          }
        }
      },
      _calculateUV: function() {
        var rect = this._rect, texture = this._texture, uv = this.uv, texw = texture.width, texh = texture.height;
        if (this._rotated) {
          var l = 0 === texw ? 0 : rect.x / texw;
          var r = 0 === texw ? 0 : (rect.x + rect.height) / texw;
          var b = 0 === texh ? 0 : (rect.y + rect.width) / texh;
          var t = 0 === texh ? 0 : rect.y / texh;
          uv[0] = l;
          uv[1] = t;
          uv[2] = l;
          uv[3] = b;
          uv[4] = r;
          uv[5] = t;
          uv[6] = r;
          uv[7] = b;
        } else {
          var _l = 0 === texw ? 0 : rect.x / texw;
          var _r = 0 === texw ? 0 : (rect.x + rect.width) / texw;
          var _b = 0 === texh ? 0 : (rect.y + rect.height) / texh;
          var _t = 0 === texh ? 0 : rect.y / texh;
          uv[0] = _l;
          uv[1] = _b;
          uv[2] = _r;
          uv[3] = _b;
          uv[4] = _l;
          uv[5] = _t;
          uv[6] = _r;
          uv[7] = _t;
        }
        var vertices = this.vertices;
        if (vertices) {
          vertices.nu.length = 0;
          vertices.nv.length = 0;
          for (var i = 0; i < vertices.u.length; i++) {
            vertices.nu[i] = vertices.u[i] / texw;
            vertices.nv[i] = vertices.v[i] / texh;
          }
        }
        this._calculateSlicedUV();
      },
      _serialize: false,
      _deserialize: function(data, handle) {
        var rect = data.rect;
        rect && this.setRect(new cc.Rect(rect[0], rect[1], rect[2], rect[3]));
        data.offset && this.setOffset(new cc.Vec2(data.offset[0], data.offset[1]));
        data.originalSize && this.setOriginalSize(new cc.Size(data.originalSize[0], data.originalSize[1]));
        this._rotated = 1 === data.rotated;
        this._name = data.name;
        var capInsets = data.capInsets;
        if (capInsets) {
          this.insetLeft = capInsets[0];
          this.insetTop = capInsets[1];
          this.insetRight = capInsets[2];
          this.insetBottom = capInsets[3];
        }
        false;
        this.vertices = data.vertices;
        if (this.vertices) {
          this.vertices.nu = [];
          this.vertices.nv = [];
        }
        var textureUuid = data.texture;
        textureUuid && handle.result.push(this, "_textureSetter", textureUuid);
      }
    });
    var proto = SpriteFrame.prototype;
    proto.copyWithZone = proto.clone;
    proto.copy = proto.clone;
    proto.initWithTexture = proto.setTexture;
    cc.SpriteFrame = SpriteFrame;
    module.exports = SpriteFrame;
  }), {
    "../assets/CCAsset": 29,
    "../event/event-target": 91,
    "../utils/texture-util": 216
  } ],
  41: [ (function(require, module, exports) {
    var TTFFont = cc.Class({
      name: "cc.TTFFont",
      extends: cc.Font,
      statics: {
        preventPreloadNativeObject: true
      }
    });
    cc.TTFFont = module.exports = TTFFont;
  }), {} ],
  42: [ (function(require, module, exports) {
    var TextAsset = cc.Class({
      name: "cc.TextAsset",
      extends: cc.Asset,
      properties: {
        text: ""
      },
      toString: function() {
        return this.text;
      }
    });
    module.exports = cc.TextAsset = TextAsset;
  }), {} ],
  43: [ (function(require, module, exports) {
    var EventTarget = require("../event/event-target");
    var renderEngine = require("../renderer/render-engine");
    var renderer = require("../renderer");
    require("../platform/CCClass");
    var gfx = renderEngine.gfx;
    var GL_NEAREST = 9728;
    var GL_LINEAR = 9729;
    var GL_REPEAT = 10497;
    var GL_CLAMP_TO_EDGE = 33071;
    var GL_MIRRORED_REPEAT = 33648;
    var CHAR_CODE_0 = 48;
    var CHAR_CODE_1 = 49;
    var idGenerater = new (require("../platform/id-generater"))("Tex");
    var PixelFormat = cc.Enum({
      RGB565: gfx.TEXTURE_FMT_R5_G6_B5,
      RGB5A1: gfx.TEXTURE_FMT_R5_G5_B5_A1,
      RGBA4444: gfx.TEXTURE_FMT_R4_G4_B4_A4,
      RGB888: gfx.TEXTURE_FMT_RGB8,
      RGBA8888: gfx.TEXTURE_FMT_RGBA8,
      A8: gfx.TEXTURE_FMT_A8,
      I8: gfx.TEXTURE_FMT_L8,
      AI8: gfx.TEXTURE_FMT_L8_A8
    });
    var WrapMode = cc.Enum({
      REPEAT: GL_REPEAT,
      CLAMP_TO_EDGE: GL_CLAMP_TO_EDGE,
      MIRRORED_REPEAT: GL_MIRRORED_REPEAT
    });
    var Filter = cc.Enum({
      LINEAR: GL_LINEAR,
      NEAREST: GL_NEAREST
    });
    var FilterIndex = {
      9728: 0,
      9729: 1
    };
    var _images = [];
    var _sharedOpts = {
      width: void 0,
      height: void 0,
      minFilter: void 0,
      magFilter: void 0,
      wrapS: void 0,
      wrapT: void 0,
      format: void 0,
      mipmap: void 0,
      images: void 0,
      image: void 0,
      flipY: void 0,
      premultiplyAlpha: void 0
    };
    function _getSharedOptions() {
      for (var key in _sharedOpts) _sharedOpts[key] = void 0;
      _images.length = 0;
      _sharedOpts.images = _images;
      _sharedOpts.flipY = false;
      return _sharedOpts;
    }
    var Texture2D = cc.Class({
      name: "cc.Texture2D",
      extends: require("../assets/CCAsset"),
      mixins: [ EventTarget ],
      properties: {
        _nativeAsset: {
          get: function() {
            return this._image;
          },
          set: function(image) {
            this.initWithElement(image);
          },
          override: true
        },
        _hasMipmap: false,
        _format: PixelFormat.RGBA8888,
        _premultiplyAlpha: false,
        _flipY: false,
        _minFilter: Filter.LINEAR,
        _magFilter: Filter.LINEAR,
        _wrapS: WrapMode.CLAMP_TO_EDGE,
        _wrapT: WrapMode.CLAMP_TO_EDGE
      },
      statics: {
        PixelFormat: PixelFormat,
        WrapMode: WrapMode,
        Filter: Filter,
        extnames: [ ".png", ".jpg", ".jpeg", ".bmp", ".webp" ]
      },
      ctor: function() {
        this._id = idGenerater.getNewId();
        this.url = "";
        this.loaded = false;
        this.width = 0;
        this.height = 0;
        this._texture = null;
      },
      getImpl: function() {
        return this._texture;
      },
      getId: function() {
        return this._id;
      },
      toString: function() {
        return this.url || "";
      },
      update: function(options) {
        if (options) {
          var updateImg = false;
          void 0 !== options.width && (this.width = options.width);
          void 0 !== options.height && (this.height = options.height);
          if (void 0 !== options.minFilter) {
            this._minFilter = options.minFilter;
            options.minFilter = FilterIndex[options.minFilter];
          }
          if (void 0 !== options.magFilter) {
            this._magFilter = options.magFilter;
            options.magFilter = FilterIndex[options.magFilter];
          }
          void 0 !== options.wrapS && (this._wrapS = options.wrapS);
          void 0 !== options.wrapT && (this._wrapT = options.wrapT);
          void 0 !== options.format && (this._format = options.format);
          if (void 0 !== options.flipY) {
            this._flipY = options.flipY;
            updateImg = true;
          }
          if (void 0 !== options.premultiplyAlpha) {
            this._premultiplyAlpha = options.premultiplyAlpha;
            updateImg = true;
          }
          void 0 !== options.mipmap && (this._hasMipmap = options.mipmap);
          updateImg && this._image && (options.image = this._image);
          if (options.images && options.images.length > 0) this._image = options.images[0]; else if (void 0 !== options.image) {
            this._image = options.image;
            if (!options.images) {
              _images.length = 0;
              options.images = _images;
            }
            options.images.push(options.image);
          }
          options.images && options.images.length > 0 && this._texture.update(options);
        }
      },
      initWithElement: function(element) {
        if (!element) return;
        this._image = element;
        var self;
        true;
        this.handleLoadedTexture();
      },
      initWithData: function(data, pixelFormat, pixelsWidth, pixelsHeight) {
        var opts = _getSharedOptions();
        opts.image = data;
        opts.format = pixelFormat;
        opts.width = pixelsWidth;
        opts.height = pixelsHeight;
        this.update(opts);
        this.width = pixelsWidth;
        this.height = pixelsHeight;
        this.loaded = true;
        this.emit("load");
        return true;
      },
      getHtmlElementObj: function() {
        return this._image;
      },
      destroy: function() {
        this._image = null;
        this._texture && this._texture.destroy();
        this._super();
      },
      getPixelFormat: function() {
        return this._format;
      },
      hasPremultipliedAlpha: function() {
        return this._premultiplyAlpha || false;
      },
      hasMipmap: function() {
        return this._hasMipmap || false;
      },
      handleLoadedTexture: function() {
        if (!this._image || !this._image.width || !this._image.height) return;
        this.width = this._image.width;
        this.height = this._image.height;
        var opts = _getSharedOptions();
        opts.image = this._image;
        opts.images = [ opts.image ];
        opts.width = this.width;
        opts.height = this.height;
        opts.hasMipmap = this._hasMipmap;
        opts.format = this._format;
        opts.premultiplyAlpha = this._premultiplyAlpha;
        opts.flipY = this._flipY;
        opts.minFilter = FilterIndex[this._minFilter];
        opts.magFilter = FilterIndex[this._magFilter];
        opts.wrapS = this._wrapS;
        opts.wrapT = this._wrapT;
        this._texture ? this._texture.update(opts) : this._texture = new renderer.Texture2D(renderer.device, opts);
        this.loaded = true;
        this.emit("load");
        if (cc.macro.CLEANUP_IMAGE_CACHE && this._image instanceof HTMLImageElement) {
          this._image.src = "";
          cc.loader.removeItem(this._image.id);
        }
      },
      description: function() {
        return "<cc.Texture2D | Name = " + this.url + " | Dimensions = " + this.width + " x " + this.height + ">";
      },
      releaseTexture: function() {
        this._image = null;
        this._texture && this._texture.destroy();
      },
      setWrapMode: function(wrapS, wrapT) {
        if (this._wrapS !== wrapS || this._wrapT !== wrapT) {
          var opts = _getSharedOptions();
          opts.wrapS = wrapS;
          opts.wrapT = wrapT;
          this.update(opts);
        }
      },
      setFilters: function(minFilter, magFilter) {
        if (this._minFilter !== minFilter || this._magFilter !== magFilter) {
          var opts = _getSharedOptions();
          opts.minFilter = minFilter;
          opts.magFilter = magFilter;
          this.update(opts);
        }
      },
      setFlipY: function(flipY) {
        if (this._flipY !== flipY) {
          var opts = _getSharedOptions();
          opts.flipY = flipY;
          this.update(opts);
        }
      },
      setPremultiplyAlpha: function(premultiply) {
        if (this._premultiplyAlpha !== premultiply) {
          var opts = _getSharedOptions();
          opts.premultiplyAlpha = premultiply;
          this.update(opts);
        }
      },
      setMipmap: function(mipmap) {
        if (this._hasMipmap !== mipmap) {
          var opts = _getSharedOptions();
          opts.hasMipmap = mipmap;
          this.update(opts);
        }
      },
      _serialize: (false, false) && function() {
        var extId = "";
        if (this._native) {
          var ext = cc.path.extname(this._native);
          if (ext) {
            extId = Texture2D.extnames.indexOf(ext);
            extId < 0 && (extId = ext);
          }
        }
        var asset = extId + "," + this._minFilter + "," + this._magFilter + "," + this._wrapS + "," + this._wrapT + "," + (this._premultiplyAlpha ? 1 : 0);
        return asset;
      },
      _deserialize: function(data, handle) {
        var fields = data.split(",");
        var extIdStr = fields[0];
        if (extIdStr) {
          var extId = extIdStr.charCodeAt(0) - CHAR_CODE_0;
          var ext = Texture2D.extnames[extId];
          this._setRawAsset(ext || extIdStr);
          var loadingItem = handle.customEnv;
          var uuid = loadingItem && loadingItem.uuid;
          if (uuid) {
            this._uuid = uuid;
            var url = this.nativeUrl;
            this.url = url;
          }
        }
        if (6 === fields.length) {
          this._minFilter = parseInt(fields[1]);
          this._magFilter = parseInt(fields[2]);
          this._wrapS = parseInt(fields[3]);
          this._wrapT = parseInt(fields[4]);
          this._premultiplyAlpha = fields[5].charCodeAt(0) === CHAR_CODE_1;
        }
      }
    });
    cc.Texture2D = module.exports = Texture2D;
  }), {
    "../assets/CCAsset": 29,
    "../event/event-target": 91,
    "../platform/CCClass": 147,
    "../platform/id-generater": 163,
    "../renderer": 173,
    "../renderer/render-engine": 174
  } ],
  44: [ (function(require, module, exports) {
    require("./CCRawAsset");
    require("./CCAsset");
    require("./CCFont");
    require("./CCPrefab");
    require("./CCAudioClip");
    require("./CCScripts");
    require("./CCSceneAsset");
    require("./CCSpriteFrame");
    require("./CCTexture2D");
    require("./CCRenderTexture");
    require("./CCTTFFont");
    require("./CCSpriteAtlas");
    require("./CCBitmapFont");
    require("./CCLabelAtlas");
    require("./CCTextAsset");
    require("./CCJsonAsset");
  }), {
    "./CCAsset": 29,
    "./CCAudioClip": 30,
    "./CCBitmapFont": 31,
    "./CCFont": 32,
    "./CCJsonAsset": 33,
    "./CCLabelAtlas": 34,
    "./CCPrefab": 35,
    "./CCRawAsset": 36,
    "./CCRenderTexture": void 0,
    "./CCSceneAsset": 37,
    "./CCScripts": 38,
    "./CCSpriteAtlas": 39,
    "./CCSpriteFrame": 40,
    "./CCTTFFont": 41,
    "./CCTextAsset": 42,
    "./CCTexture2D": 43
  } ],
  45: [ (function(require, module, exports) {
    var Event = require("../CCNode").EventType;
    var TOP = 1;
    var MID = 2;
    var BOT = 4;
    var LEFT = 8;
    var CENTER = 16;
    var RIGHT = 32;
    var HORIZONTAL = LEFT | CENTER | RIGHT;
    var VERTICAL = TOP | MID | BOT;
    var AlignMode = cc.Enum({
      ONCE: 0,
      ON_WINDOW_RESIZE: 1,
      ALWAYS: 2
    });
    function getReadonlyNodeSize(parent) {
      return parent instanceof cc.Scene ? cc.visibleRect : parent._contentSize;
    }
    function computeInverseTransForTarget(widgetNode, target, out_inverseTranslate, out_inverseScale) {
      var scaleX = widgetNode._parent._scale.x;
      var scaleY = widgetNode._parent._scale.y;
      var translateX = 0;
      var translateY = 0;
      for (var node = widgetNode._parent; ;) {
        var pos = node._position;
        translateX += pos.x;
        translateY += pos.y;
        node = node._parent;
        if (!node) {
          out_inverseTranslate.x = out_inverseTranslate.y = 0;
          out_inverseScale.x = out_inverseScale.y = 1;
          return;
        }
        if (node === target) break;
        var sx = node._scale.x;
        var sy = node._scale.y;
        translateX *= sx;
        translateY *= sy;
        scaleX *= sx;
        scaleY *= sy;
      }
      out_inverseScale.x = 0 !== scaleX ? 1 / scaleX : 1;
      out_inverseScale.y = 0 !== scaleY ? 1 / scaleY : 1;
      out_inverseTranslate.x = -translateX;
      out_inverseTranslate.y = -translateY;
    }
    var tInverseTranslate = cc.Vec2.ZERO;
    var tInverseScale = cc.Vec2.ONE;
    function align(node, widget) {
      var hasTarget = widget._target;
      var target;
      var inverseTranslate, inverseScale;
      if (hasTarget) {
        target = hasTarget;
        inverseTranslate = tInverseTranslate;
        inverseScale = tInverseScale;
        computeInverseTransForTarget(node, target, inverseTranslate, inverseScale);
      } else target = node._parent;
      var targetSize = getReadonlyNodeSize(target);
      var targetAnchor = target._anchorPoint;
      var isRoot = (true, target instanceof cc.Scene);
      var x = node._position.x, y = node._position.y;
      var anchor = node._anchorPoint;
      if (widget._alignFlags & HORIZONTAL) {
        var localLeft, localRight, targetWidth = targetSize.width;
        if (isRoot) {
          localLeft = cc.visibleRect.left.x;
          localRight = cc.visibleRect.right.x;
        } else {
          localLeft = -targetAnchor.x * targetWidth;
          localRight = localLeft + targetWidth;
        }
        localLeft += widget._isAbsLeft ? widget._left : widget._left * targetWidth;
        localRight -= widget._isAbsRight ? widget._right : widget._right * targetWidth;
        if (hasTarget) {
          localLeft += inverseTranslate.x;
          localLeft *= inverseScale.x;
          localRight += inverseTranslate.x;
          localRight *= inverseScale.x;
        }
        var width, anchorX = anchor.x, scaleX = node._scale.x;
        if (scaleX < 0) {
          anchorX = 1 - anchorX;
          scaleX = -scaleX;
        }
        if (widget.isStretchWidth) {
          width = localRight - localLeft;
          0 !== scaleX && (node.width = width / scaleX);
          x = localLeft + anchorX * width;
        } else {
          width = node.width * scaleX;
          if (widget.isAlignHorizontalCenter) {
            var localHorizontalCenter = widget._isAbsHorizontalCenter ? widget._horizontalCenter : widget._horizontalCenter * targetWidth;
            var targetCenter = (.5 - targetAnchor.x) * targetSize.width;
            if (hasTarget) {
              localHorizontalCenter *= inverseScale.x;
              targetCenter += inverseTranslate.x;
              targetCenter *= inverseScale.x;
            }
            x = targetCenter + (anchorX - .5) * width + localHorizontalCenter;
          } else x = widget.isAlignLeft ? localLeft + anchorX * width : localRight + (anchorX - 1) * width;
        }
      }
      if (widget._alignFlags & VERTICAL) {
        var localTop, localBottom, targetHeight = targetSize.height;
        if (isRoot) {
          localBottom = cc.visibleRect.bottom.y;
          localTop = cc.visibleRect.top.y;
        } else {
          localBottom = -targetAnchor.y * targetHeight;
          localTop = localBottom + targetHeight;
        }
        localBottom += widget._isAbsBottom ? widget._bottom : widget._bottom * targetHeight;
        localTop -= widget._isAbsTop ? widget._top : widget._top * targetHeight;
        if (hasTarget) {
          localBottom += inverseTranslate.y;
          localBottom *= inverseScale.y;
          localTop += inverseTranslate.y;
          localTop *= inverseScale.y;
        }
        var height, anchorY = anchor.y, scaleY = node._scale.y;
        if (scaleY < 0) {
          anchorY = 1 - anchorY;
          scaleY = -scaleY;
        }
        if (widget.isStretchHeight) {
          height = localTop - localBottom;
          0 !== scaleY && (node.height = height / scaleY);
          y = localBottom + anchorY * height;
        } else {
          height = node.height * scaleY;
          if (widget.isAlignVerticalCenter) {
            var localVerticalCenter = widget._isAbsVerticalCenter ? widget._verticalCenter : widget._verticalCenter * targetHeight;
            var targetMiddle = (.5 - targetAnchor.y) * targetSize.height;
            if (hasTarget) {
              localVerticalCenter *= inverseScale.y;
              targetMiddle += inverseTranslate.y;
              targetMiddle *= inverseScale.y;
            }
            y = targetMiddle + (anchorY - .5) * height + localVerticalCenter;
          } else y = widget.isAlignBottom ? localBottom + anchorY * height : localTop + (anchorY - 1) * height;
        }
      }
      node.setPosition(x, y);
    }
    function visitNode(node) {
      var widget = node._widget;
      if (widget) {
        var target;
        var isParent;
        false;
        align(node, widget);
        true, widget.alignMode !== AlignMode.ALWAYS ? widget.enabled = false : activeWidgets.push(widget);
      }
      var children = node._children;
      for (var i = 0; i < children.length; i++) {
        var child = children[i];
        child._active && visitNode(child);
      }
    }
    var animationState;
    false;
    function refreshScene() {
      var AnimUtils;
      var nowPreviewing;
      var component;
      var animation;
      var _component;
      var _animation;
      false;
      var scene = cc.director.getScene();
      if (scene) {
        widgetManager.isAligning = true;
        if (widgetManager._nodesOrderDirty) {
          activeWidgets.length = 0;
          visitNode(scene);
          widgetManager._nodesOrderDirty = false;
        } else {
          var i, widget, iterator = widgetManager._activeWidgetsIterator;
          var AnimUtils;
          var editingNode;
          var node;
          false;
          for (iterator.i = 0; iterator.i < activeWidgets.length; ++iterator.i) {
            widget = activeWidgets[iterator.i];
            align(widget.node, widget);
          }
        }
        widgetManager.isAligning = false;
      }
      false;
    }
    var adjustWidgetToAllowMovingInEditor = false;
    var adjustWidgetToAllowResizingInEditor = false;
    var activeWidgets = [];
    function updateAlignment(node) {
      var parent = node._parent;
      cc.Node.isNode(parent) && updateAlignment(parent);
      var widget = node._widget || node.getComponent(cc.Widget);
      widget && align(node, widget);
    }
    var widgetManager = cc._widgetManager = module.exports = {
      _AlignFlags: {
        TOP: TOP,
        MID: MID,
        BOT: BOT,
        LEFT: LEFT,
        CENTER: CENTER,
        RIGHT: RIGHT
      },
      isAligning: false,
      _nodesOrderDirty: false,
      _activeWidgetsIterator: new cc.js.array.MutableForwardIterator(activeWidgets),
      init: function(director) {
        director.on(cc.Director.EVENT_AFTER_UPDATE, refreshScene);
        false;
        cc.sys.isMobile ? window.addEventListener("resize", this.onResized.bind(this)) : cc.view.on("canvas-resize", this.onResized, this);
      },
      add: function(widget) {
        widget.node._widget = widget;
        this._nodesOrderDirty = true;
        false;
      },
      remove: function(widget) {
        widget.node._widget = null;
        this._activeWidgetsIterator.remove(widget);
        false;
      },
      onResized: function() {
        var scene = cc.director.getScene();
        scene && this.refreshWidgetOnResized(scene);
      },
      refreshWidgetOnResized: function(node) {
        var widget = cc.Node.isNode(node) && node.getComponent(cc.Widget);
        widget && widget.alignMode === AlignMode.ON_WINDOW_RESIZE && (widget.enabled = true);
        var children = node._children;
        for (var i = 0; i < children.length; i++) {
          var child = children[i];
          this.refreshWidgetOnResized(child);
        }
      },
      updateAlignment: updateAlignment,
      AlignMode: AlignMode
    };
    false;
  }), {
    "../CCNode": 25
  } ],
  46: [ (function(require, module, exports) {
    var AffineTrans = require("../utils/affine-transform");
    var renderEngine = require("../renderer/render-engine");
    var renderer = require("../renderer/index");
    var game = require("../CCGame");
    var mat4 = cc.vmath.mat4;
    var vec2 = cc.vmath.vec2;
    var vec3 = cc.vmath.vec3;
    var _mat4_temp_1 = mat4.create();
    var _mat4_temp_2 = mat4.create();
    var _vec3_temp_1 = vec3.create();
    var _cameras = [];
    var _debugCamera = null;
    function repositionDebugCamera() {
      if (!_debugCamera) return;
      var node = _debugCamera._node;
      var visibleRect = cc.visibleRect;
      node.z = visibleRect.height / 1.1566;
      node.x = _vec3_temp_1.x = visibleRect.width / 2;
      node.y = _vec3_temp_1.y = visibleRect.height / 2;
      _vec3_temp_1.z = 0;
      node.lookAt(_vec3_temp_1);
    }
    var ClearFlags = cc.Enum({
      COLOR: 1,
      DEPTH: 2,
      STENCIL: 4
    });
    var Camera = cc.Class({
      name: "cc.Camera",
      extends: cc.Component,
      ctor: function() {
        if (game.renderType !== game.RENDER_TYPE_CANVAS) {
          var camera = new renderEngine.Camera();
          camera.setStages([ "transparent" ]);
          this._fov = 60 * Math.PI / 180;
          camera.setFov(this._fov);
          camera.setNear(.1);
          camera.setFar(4096);
          var view = new renderEngine.View();
          camera.view = view;
          camera.dirty = true;
          this._matrixDirty = true;
          this._inited = false;
          this._camera = camera;
        } else this._inited = true;
      },
      editor: false,
      properties: {
        _cullingMask: 4294967295,
        _clearFlags: 0,
        _backgroundColor: cc.color(0, 0, 0, 255),
        _depth: 0,
        _zoomRatio: 1,
        _targetTexture: null,
        zoomRatio: {
          get: function() {
            return this._zoomRatio;
          },
          set: function(value) {
            this._zoomRatio = value;
            this._matrixDirty = true;
          }
        },
        cullingMask: {
          get: function() {
            return this._cullingMask;
          },
          set: function(value) {
            this._cullingMask = value;
            this._updateCameraMask();
          }
        },
        clearFlags: {
          get: function() {
            return this._clearFlags;
          },
          set: function(value) {
            this._clearFlags = value;
            this._camera && this._camera.setClearFlags(value);
          }
        },
        backgroundColor: {
          get: function() {
            return this._backgroundColor;
          },
          set: function(value) {
            this._backgroundColor = value;
            this._updateBackgroundColor();
          }
        },
        depth: {
          get: function() {
            return this._depth;
          },
          set: function(value) {
            this._depth = value;
            this._camera && this._camera.setDepth(value);
          }
        },
        targetTexture: {
          get: function() {
            return this._targetTexture;
          },
          set: function(value) {
            this._targetTexture = value;
            this._updateTargetTexture();
          }
        }
      },
      statics: {
        main: null,
        cameras: _cameras,
        ClearFlags: ClearFlags,
        findCamera: function(node) {
          for (var i = 0, l = _cameras.length; i < l; i++) {
            var camera = _cameras[i];
            if (camera.containsNode(node)) return camera;
          }
          return null;
        },
        _setupDebugCamera: function() {
          if (_debugCamera) return;
          if (game.renderType === game.RENDER_TYPE_CANVAS) return;
          var camera = new renderEngine.Camera();
          _debugCamera = camera;
          camera.setStages([ "transparent" ]);
          camera.setFov(60 * Math.PI / 180);
          camera.setNear(.1);
          camera.setFar(4096);
          var view = new renderEngine.View();
          camera.view = view;
          camera.dirty = true;
          camera._cullingMask = camera.view._cullingMask = 1 << cc.Node.BuiltinGroupIndex.DEBUG;
          camera.setDepth(cc.macro.MAX_ZINDEX);
          camera.setClearFlags(0);
          camera.setColor(0, 0, 0, 0);
          var node = new cc.Node();
          camera.setNode(node);
          repositionDebugCamera();
          cc.view.on("design-resolution-changed", repositionDebugCamera);
          renderer.scene.addCamera(camera);
        }
      },
      _updateCameraMask: function() {
        if (this._camera) {
          var mask = this._cullingMask & ~(1 << cc.Node.BuiltinGroupIndex.DEBUG);
          this._camera._cullingMask = mask;
          this._camera.view._cullingMask = mask;
        }
      },
      _updateBackgroundColor: function() {
        if (this._camera) {
          var color = this._backgroundColor;
          this._camera.setColor(color.r / 255, color.g / 255, color.b / 255, color.a / 255);
        }
      },
      _updateTargetTexture: function() {
        var texture = this._targetTexture;
        this._camera && (this._camera._framebuffer = texture ? texture._framebuffer : null);
      },
      _onMatrixDirty: function() {
        this._matrixDirty = true;
      },
      _init: function() {
        if (this._inited) return;
        this._inited = true;
        if (this._camera) {
          this._camera.setNode(this.node);
          this._camera.setClearFlags(this._clearFlags);
          this._camera.setDepth(this._depth);
          this._updateBackgroundColor();
          this._updateCameraMask();
          this._updateTargetTexture();
        }
      },
      onLoad: function() {
        this._init();
      },
      onEnable: function() {
        this._matrixDirty = true;
        if (game.renderType !== game.RENDER_TYPE_CANVAS) {
          cc.director.on(cc.Director.EVENT_BEFORE_DRAW, this.beforeDraw, this);
          renderer.scene.addCamera(this._camera);
        }
        _cameras.push(this);
      },
      onDisable: function() {
        if (game.renderType !== game.RENDER_TYPE_CANVAS) {
          cc.director.off(cc.Director.EVENT_BEFORE_DRAW, this.beforeDraw, this);
          renderer.scene.removeCamera(this._camera);
        }
        cc.js.array.remove(_cameras, this);
      },
      getNodeToCameraTransform: function(node) {
        var out = AffineTrans.identity();
        node.getWorldMatrix(_mat4_temp_2);
        if (this.containsNode(node)) {
          this.getWorldToCameraMatrix(_mat4_temp_1);
          mat4.mul(_mat4_temp_2, _mat4_temp_2, _mat4_temp_1);
        }
        AffineTrans.fromMat4(out, _mat4_temp_2);
        return out;
      },
      getCameraToWorldPoint: function(point, out) {
        out = out || cc.v2();
        this.getCameraToWorldMatrix(_mat4_temp_1);
        vec2.transformMat4(out, point, _mat4_temp_1);
        return out;
      },
      getWorldToCameraPoint: function(point, out) {
        out = out || cc.v2();
        this.getWorldToCameraMatrix(_mat4_temp_1);
        vec2.transformMat4(out, point, _mat4_temp_1);
        return out;
      },
      getCameraToWorldMatrix: function(out) {
        this.getWorldToCameraMatrix(out);
        mat4.invert(out, out);
        return out;
      },
      getWorldToCameraMatrix: function(out) {
        this.node.getWorldRT(_mat4_temp_1);
        var zoomRatio = this.zoomRatio;
        _mat4_temp_1.m00 *= zoomRatio;
        _mat4_temp_1.m01 *= zoomRatio;
        _mat4_temp_1.m04 *= zoomRatio;
        _mat4_temp_1.m05 *= zoomRatio;
        var m12 = _mat4_temp_1.m12;
        var m13 = _mat4_temp_1.m13;
        var center = cc.visibleRect.center;
        _mat4_temp_1.m12 = center.x - (_mat4_temp_1.m00 * m12 + _mat4_temp_1.m04 * m13);
        _mat4_temp_1.m13 = center.y - (_mat4_temp_1.m01 * m12 + _mat4_temp_1.m05 * m13);
        out !== _mat4_temp_1 && mat4.copy(out, _mat4_temp_1);
        return out;
      },
      containsNode: function(node) {
        return node._cullingMask & this.cullingMask;
      },
      render: function(root) {
        root = root || cc.director.getScene();
        if (!root) return null;
        this.node.getWorldMatrix(_mat4_temp_1);
        this.beforeDraw();
        renderer._walker.visit(root);
        renderer._forward.renderCamera(this._camera, renderer.scene);
      },
      beforeDraw: function() {
        var node = this.node;
        if (!this._matrixDirty && !node._worldMatDirty) return;
        var camera = this._camera;
        var fov = 2 * Math.atan(Math.tan(this._fov / 2) / this.zoomRatio);
        camera.setFov(fov);
        var height = cc.game.canvas.height / cc.view._scaleY;
        var targetTexture = this._targetTexture;
        targetTexture && (height = targetTexture.height);
        node._updateWorldMatrix();
        _vec3_temp_1.x = node._worldMatrix.m12;
        _vec3_temp_1.y = node._worldMatrix.m13;
        _vec3_temp_1.z = 0;
        node.z = height / 1.1566;
        node.lookAt(_vec3_temp_1);
        this._matrixDirty = false;
        camera.dirty = true;
      }
    });
    module.exports = cc.Camera = Camera;
  }), {
    "../CCGame": 24,
    "../renderer/index": 173,
    "../renderer/render-engine": 174,
    "../utils/affine-transform": 200
  } ],
  47: [ (function(require, module, exports) {
    cc.Collider.Box = cc.Class({
      properties: {
        _offset: cc.v2(0, 0),
        _size: cc.size(100, 100),
        offset: {
          tooltip: false,
          get: function() {
            return this._offset;
          },
          set: function(value) {
            this._offset = value;
          },
          type: cc.Vec2
        },
        size: {
          tooltip: false,
          get: function() {
            return this._size;
          },
          set: function(value) {
            this._size.width = value.width < 0 ? 0 : value.width;
            this._size.height = value.height < 0 ? 0 : value.height;
          },
          type: cc.Size
        }
      },
      resetInEditor: false
    });
    var BoxCollider = cc.Class({
      name: "cc.BoxCollider",
      extends: cc.Collider,
      mixins: [ cc.Collider.Box ],
      editor: false
    });
    cc.BoxCollider = module.exports = BoxCollider;
  }), {} ],
  48: [ (function(require, module, exports) {
    cc.Collider.Circle = cc.Class({
      properties: {
        _offset: cc.v2(0, 0),
        _radius: 50,
        offset: {
          get: function() {
            return this._offset;
          },
          set: function(value) {
            this._offset = value;
          },
          type: cc.Vec2
        },
        radius: {
          tooltip: false,
          get: function() {
            return this._radius;
          },
          set: function(value) {
            this._radius = value < 0 ? 0 : value;
          }
        }
      },
      resetInEditor: false
    });
    var CircleCollider = cc.Class({
      name: "cc.CircleCollider",
      extends: cc.Collider,
      mixins: [ cc.Collider.Circle ],
      editor: false
    });
    cc.CircleCollider = module.exports = CircleCollider;
  }), {} ],
  49: [ (function(require, module, exports) {
    var Collider = cc.Class({
      name: "cc.Collider",
      extends: cc.Component,
      properties: {
        editing: {
          default: false,
          serializable: false,
          tooltip: false
        },
        tag: {
          tooltip: false,
          default: 0,
          range: [ 0, 1e7 ],
          type: cc.Integer
        }
      },
      onDisable: function() {
        cc.director.getCollisionManager().removeCollider(this);
      },
      onEnable: function() {
        cc.director.getCollisionManager().addCollider(this);
      }
    });
    cc.Collider = module.exports = Collider;
  }), {} ],
  50: [ (function(require, module, exports) {
    var Contact = require("./CCContact");
    var CollisionType = Contact.CollisionType;
    var NodeEvent = require("../CCNode").EventType;
    var math = cc.vmath;
    var _vec2 = cc.v2();
    function obbApplyMatrix(rect, mat4, out_bl, out_tl, out_tr, out_br) {
      var x = rect.x;
      var y = rect.y;
      var width = rect.width;
      var height = rect.height;
      var m00 = mat4.m00, m01 = mat4.m01, m04 = mat4.m04, m05 = mat4.m05;
      var m12 = mat4.m12, m13 = mat4.m13;
      var tx = m00 * x + m04 * y + m12;
      var ty = m01 * x + m05 * y + m13;
      var xa = m00 * width;
      var xb = m01 * width;
      var yc = m04 * height;
      var yd = m05 * height;
      out_tl.x = tx;
      out_tl.y = ty;
      out_tr.x = xa + tx;
      out_tr.y = xb + ty;
      out_bl.x = yc + tx;
      out_bl.y = yd + ty;
      out_br.x = xa + yc + tx;
      out_br.y = xb + yd + ty;
    }
    var CollisionManager = cc.Class({
      mixins: [ cc.EventTarget ],
      properties: {
        enabled: false,
        enabledDrawBoundingBox: false
      },
      ctor: function() {
        this._contacts = [];
        this._colliders = [];
        this._debugDrawer = null;
        this._enabledDebugDraw = false;
        cc.director._scheduler && cc.director._scheduler.enableForTarget(this);
      },
      update: function(dt) {
        if (!this.enabled) return;
        var i = void 0, l = void 0;
        var colliders = this._colliders;
        for (i = 0, l = colliders.length; i < l; i++) this.updateCollider(colliders[i]);
        var contacts = this._contacts;
        var results = [];
        for (i = 0, l = contacts.length; i < l; i++) {
          var collisionType = contacts[i].updateState();
          if (collisionType === CollisionType.None) continue;
          results.push([ collisionType, contacts[i] ]);
        }
        for (i = 0, l = results.length; i < l; i++) {
          var result = results[i];
          this._doCollide(result[0], result[1]);
        }
        this.drawColliders();
      },
      _doCollide: function(collisionType, contact) {
        var contactFunc = void 0;
        switch (collisionType) {
         case CollisionType.CollisionEnter:
          contactFunc = "onCollisionEnter";
          break;

         case CollisionType.CollisionStay:
          contactFunc = "onCollisionStay";
          break;

         case CollisionType.CollisionExit:
          contactFunc = "onCollisionExit";
        }
        var collider1 = contact.collider1;
        var collider2 = contact.collider2;
        var comps1 = collider1.node._components;
        var comps2 = collider2.node._components;
        var i = void 0, l = void 0, comp = void 0;
        for (i = 0, l = comps1.length; i < l; i++) {
          comp = comps1[i];
          comp[contactFunc] && comp[contactFunc](collider2, collider1);
        }
        for (i = 0, l = comps2.length; i < l; i++) {
          comp = comps2[i];
          comp[contactFunc] && comp[contactFunc](collider1, collider2);
        }
      },
      shouldCollide: function(c1, c2) {
        var node1 = c1.node, node2 = c2.node;
        var collisionMatrix = cc.game.collisionMatrix;
        return node1 !== node2 && collisionMatrix[node1.groupIndex][node2.groupIndex];
      },
      initCollider: function(collider) {
        if (!collider.world) {
          var world = collider.world = {};
          world.aabb = cc.rect();
          world.preAabb = cc.rect();
          world.matrix = math.mat4.create();
          world.radius = 0;
          if (collider instanceof cc.BoxCollider) {
            world.position = null;
            world.points = [ cc.v2(), cc.v2(), cc.v2(), cc.v2() ];
          } else if (collider instanceof cc.PolygonCollider) {
            world.position = null;
            world.points = collider.points.map((function(p) {
              return cc.v2(p.x, p.y);
            }));
          } else if (collider instanceof cc.CircleCollider) {
            world.position = cc.v2();
            world.points = null;
          }
        }
      },
      updateCollider: function(collider) {
        var offset = collider.offset;
        var world = collider.world;
        var aabb = world.aabb;
        var m = world.matrix;
        collider.node.getWorldMatrix(m);
        var preAabb = world.preAabb;
        preAabb.x = aabb.x;
        preAabb.y = aabb.y;
        preAabb.width = aabb.width;
        preAabb.height = aabb.height;
        if (collider instanceof cc.BoxCollider) {
          var size = collider.size;
          aabb.x = offset.x - size.width / 2;
          aabb.y = offset.y - size.height / 2;
          aabb.width = size.width;
          aabb.height = size.height;
          var wps = world.points;
          var wp0 = wps[0], wp1 = wps[1], wp2 = wps[2], wp3 = wps[3];
          obbApplyMatrix(aabb, m, wp0, wp1, wp2, wp3);
          var minx = Math.min(wp0.x, wp1.x, wp2.x, wp3.x);
          var miny = Math.min(wp0.y, wp1.y, wp2.y, wp3.y);
          var maxx = Math.max(wp0.x, wp1.x, wp2.x, wp3.x);
          var maxy = Math.max(wp0.y, wp1.y, wp2.y, wp3.y);
          aabb.x = minx;
          aabb.y = miny;
          aabb.width = maxx - minx;
          aabb.height = maxy - miny;
        } else if (collider instanceof cc.CircleCollider) {
          math.vec2.transformMat4(_vec2, collider.offset, m);
          world.position.x = _vec2.x;
          world.position.y = _vec2.y;
          var tempx = m.m12, tempy = m.m13;
          m.m12 = m.m13 = 0;
          _vec2.x = collider.radius;
          _vec2.y = 0;
          math.vec2.transformMat4(_vec2, _vec2, m);
          var d = Math.sqrt(_vec2.x * _vec2.x + _vec2.y * _vec2.y);
          world.radius = d;
          aabb.x = world.position.x - d;
          aabb.y = world.position.y - d;
          aabb.width = 2 * d;
          aabb.height = 2 * d;
          m.m12 = tempx;
          m.m13 = tempy;
        } else if (collider instanceof cc.PolygonCollider) {
          var points = collider.points;
          var worldPoints = world.points;
          worldPoints.length = points.length;
          var _minx = 1e6, _miny = 1e6, _maxx = -1e6, _maxy = -1e6;
          for (var i = 0, l = points.length; i < l; i++) {
            worldPoints[i] || (worldPoints[i] = cc.v2());
            _vec2.x = points[i].x + offset.x;
            _vec2.y = points[i].y + offset.y;
            math.vec2.transformMat4(_vec2, _vec2, m);
            var x = _vec2.x;
            var y = _vec2.y;
            worldPoints[i].x = x;
            worldPoints[i].y = y;
            x > _maxx && (_maxx = x);
            x < _minx && (_minx = x);
            y > _maxy && (_maxy = y);
            y < _miny && (_miny = y);
          }
          aabb.x = _minx;
          aabb.y = _miny;
          aabb.width = _maxx - _minx;
          aabb.height = _maxy - _miny;
        }
      },
      addCollider: function(collider) {
        var colliders = this._colliders;
        var index = colliders.indexOf(collider);
        if (-1 === index) {
          for (var i = 0, l = colliders.length; i < l; i++) {
            var other = colliders[i];
            if (this.shouldCollide(collider, other)) {
              var contact = new Contact(collider, other);
              this._contacts.push(contact);
            }
          }
          colliders.push(collider);
          this.initCollider(collider);
        }
        collider.node.on(NodeEvent.GROUP_CHANGED, this.onNodeGroupChanged, this);
      },
      removeCollider: function(collider) {
        var colliders = this._colliders;
        var index = colliders.indexOf(collider);
        if (index >= 0) {
          colliders.splice(index, 1);
          var contacts = this._contacts;
          for (var i = contacts.length - 1; i >= 0; i--) {
            var contact = contacts[i];
            if (contact.collider1 === collider || contact.collider2 === collider) {
              contact.touching && this._doCollide(CollisionType.CollisionExit, contact);
              contacts.splice(i, 1);
            }
          }
          collider.node.off(NodeEvent.GROUP_CHANGED, this.onNodeGroupChanged, this);
        } else cc.errorID(6600);
      },
      onNodeGroupChanged: function(node) {
        var colliders = node.getComponents(cc.Collider);
        for (var i = 0, l = colliders.length; i < l; i++) {
          this.removeCollider(colliders[i]);
          this.addCollider(colliders[i]);
        }
      },
      drawColliders: function() {
        if (!this._enabledDebugDraw) return;
        this._checkDebugDrawValid();
        var debugDrawer = this._debugDrawer;
        debugDrawer.clear();
        var colliders = this._colliders;
        for (var i = 0, l = colliders.length; i < l; i++) {
          var collider = colliders[i];
          debugDrawer.strokeColor = cc.Color.WHITE;
          if (collider instanceof cc.BoxCollider || collider instanceof cc.PolygonCollider) {
            var ps = collider.world.points;
            if (ps.length > 0) {
              debugDrawer.moveTo(ps[0].x, ps[0].y);
              for (var j = 1; j < ps.length; j++) debugDrawer.lineTo(ps[j].x, ps[j].y);
              debugDrawer.close();
              debugDrawer.stroke();
            }
          } else if (collider instanceof cc.CircleCollider) {
            debugDrawer.circle(collider.world.position.x, collider.world.position.y, collider.world.radius);
            debugDrawer.stroke();
          }
          if (this.enabledDrawBoundingBox) {
            var aabb = collider.world.aabb;
            debugDrawer.strokeColor = cc.Color.BLUE;
            debugDrawer.moveTo(aabb.xMin, aabb.yMin);
            debugDrawer.lineTo(aabb.xMin, aabb.yMax);
            debugDrawer.lineTo(aabb.xMax, aabb.yMax);
            debugDrawer.lineTo(aabb.xMax, aabb.yMin);
            debugDrawer.close();
            debugDrawer.stroke();
          }
        }
      },
      _checkDebugDrawValid: function() {
        if (!this._debugDrawer || !this._debugDrawer.isValid) {
          var node = new cc.Node("COLLISION_MANAGER_DEBUG_DRAW");
          node.zIndex = cc.macro.MAX_ZINDEX;
          cc.game.addPersistRootNode(node);
          this._debugDrawer = node.addComponent(cc.Graphics);
        }
      }
    });
    cc.js.getset(CollisionManager.prototype, "enabledDebugDraw", (function() {
      return this._enabledDebugDraw;
    }), (function(value) {
      if (value && !this._enabledDebugDraw) {
        this._checkDebugDrawValid();
        this._debugDrawer.node.active = true;
      } else if (!value && this._enabledDebugDraw) {
        this._debugDrawer.clear(true);
        this._debugDrawer.node.active = false;
      }
      this._enabledDebugDraw = value;
    }));
    cc.CollisionManager = module.exports = CollisionManager;
  }), {
    "../CCNode": 25,
    "./CCContact": 51
  } ],
  51: [ (function(require, module, exports) {
    var Intersection = require("./CCIntersection");
    var CollisionType = cc.Enum({
      None: 0,
      CollisionEnter: 1,
      CollisionStay: 2,
      CollisionExit: 3
    });
    function Contact(collider1, collider2) {
      this.collider1 = collider1;
      this.collider2 = collider2;
      this.touching = false;
      var isCollider1Polygon = collider1 instanceof cc.BoxCollider || collider1 instanceof cc.PolygonCollider;
      var isCollider2Polygon = collider2 instanceof cc.BoxCollider || collider2 instanceof cc.PolygonCollider;
      var isCollider1Circle = collider1 instanceof cc.CircleCollider;
      var isCollider2Circle = collider2 instanceof cc.CircleCollider;
      if (isCollider1Polygon && isCollider2Polygon) this.testFunc = Intersection.polygonPolygon; else if (isCollider1Circle && isCollider2Circle) this.testFunc = Intersection.circleCircle; else if (isCollider1Polygon && isCollider2Circle) this.testFunc = Intersection.polygonCircle; else if (isCollider1Circle && isCollider2Polygon) {
        this.testFunc = Intersection.polygonCircle;
        this.collider1 = collider2;
        this.collider2 = collider1;
      } else cc.errorID(6601, cc.js.getClassName(collider1), cc.js.getClassName(collider2));
    }
    Contact.prototype.test = function() {
      var world1 = this.collider1.world;
      var world2 = this.collider2.world;
      if (!world1.aabb.intersects(world2.aabb)) return false;
      if (this.testFunc === Intersection.polygonPolygon) return this.testFunc(world1.points, world2.points);
      if (this.testFunc === Intersection.circleCircle) return this.testFunc(world1, world2);
      if (this.testFunc === Intersection.polygonCircle) return this.testFunc(world1.points, world2);
      return false;
    };
    Contact.prototype.updateState = function() {
      var result = this.test();
      var type = CollisionType.None;
      if (result && !this.touching) {
        this.touching = true;
        type = CollisionType.CollisionEnter;
      } else if (result && this.touching) type = CollisionType.CollisionStay; else if (!result && this.touching) {
        this.touching = false;
        type = CollisionType.CollisionExit;
      }
      return type;
    };
    Contact.CollisionType = CollisionType;
    module.exports = Contact;
  }), {
    "./CCIntersection": void 0
  } ],
  52: [ (function(require, module, exports) {
    cc.Collider.Polygon = cc.Class({
      properties: {
        threshold: {
          default: 1,
          serializable: false,
          visible: false
        },
        _offset: cc.v2(0, 0),
        offset: {
          get: function() {
            return this._offset;
          },
          set: function(value) {
            this._offset = value;
          },
          type: cc.Vec2
        },
        points: {
          tooltip: false,
          default: function() {
            return [ cc.v2(-50, -50), cc.v2(50, -50), cc.v2(50, 50), cc.v2(-50, 50) ];
          },
          type: [ cc.Vec2 ]
        }
      },
      resetPointsByContour: false
    });
    var PolygonCollider = cc.Class({
      name: "cc.PolygonCollider",
      extends: cc.Collider,
      mixins: [ cc.Collider.Polygon ],
      editor: false
    });
    cc.PolygonCollider = module.exports = PolygonCollider;
  }), {} ],
  53: [ (function(require, module, exports) {
    require("./CCCollisionManager");
    require("./CCCollider");
    require("./CCBoxCollider");
    require("./CCCircleCollider");
    require("./CCPolygonCollider");
  }), {
    "./CCBoxCollider": 47,
    "./CCCircleCollider": 48,
    "./CCCollider": 49,
    "./CCCollisionManager": 50,
    "./CCPolygonCollider": 52
  } ],
  54: [ (function(require, module, exports) {
    require("./platform/CCClass");
    var Flags = require("./platform/CCObject").Flags;
    var jsArray = require("./platform/js").array;
    var IsStartCalled = Flags.IsStartCalled;
    var IsOnEnableCalled = Flags.IsOnEnableCalled;
    var IsEditorOnEnableCalled = Flags.IsEditorOnEnableCalled;
    var callerFunctor = false;
    var callOnEnableInTryCatch = false;
    var callStartInTryCatch = false;
    var callUpdateInTryCatch = false;
    var callLateUpdateInTryCatch = false;
    var callOnDisableInTryCatch = false;
    var callStart = function(c) {
      c.start();
      c._objFlags |= IsStartCalled;
    };
    var callUpdate = function(c, dt) {
      c.update(dt);
    };
    var callLateUpdate = function(c, dt) {
      c.lateUpdate(dt);
    };
    function sortedIndex(array, comp) {
      var order = comp.constructor._executionOrder;
      var id = comp._id;
      for (var l = 0, h = array.length - 1, m = h >>> 1; l <= h; m = l + h >>> 1) {
        var test = array[m];
        var testOrder = test.constructor._executionOrder;
        if (testOrder > order) h = m - 1; else if (testOrder < order) l = m + 1; else {
          var testId = test._id;
          if (testId > id) h = m - 1; else {
            if (!(testId < id)) return m;
            l = m + 1;
          }
        }
      }
      return ~l;
    }
    function stableRemoveInactive(iterator, flagToClear) {
      var array = iterator.array;
      var next = iterator.i + 1;
      while (next < array.length) {
        var comp = array[next];
        if (comp._enabled && comp.node._activeInHierarchy) ++next; else {
          iterator.removeAt(next);
          flagToClear && (comp._objFlags &= ~flagToClear);
        }
      }
    }
    var LifeCycleInvoker = cc.Class({
      __ctor__: function(invokeFunc) {
        var Iterator = jsArray.MutableForwardIterator;
        this._zero = new Iterator([]);
        this._neg = new Iterator([]);
        this._pos = new Iterator([]);
        false;
        this._invoke = invokeFunc;
      },
      statics: {
        stableRemoveInactive: stableRemoveInactive
      },
      add: null,
      remove: null,
      invoke: null
    });
    function compareOrder(a, b) {
      return a.constructor._executionOrder - b.constructor._executionOrder;
    }
    var OneOffInvoker = cc.Class({
      extends: LifeCycleInvoker,
      add: function(comp) {
        var order = comp.constructor._executionOrder;
        (0 === order ? this._zero : order < 0 ? this._neg : this._pos).array.push(comp);
      },
      remove: function(comp) {
        var order = comp.constructor._executionOrder;
        (0 === order ? this._zero : order < 0 ? this._neg : this._pos).fastRemove(comp);
      },
      cancelInactive: function(flagToClear) {
        stableRemoveInactive(this._zero, flagToClear);
        stableRemoveInactive(this._neg, flagToClear);
        stableRemoveInactive(this._pos, flagToClear);
      },
      invoke: function() {
        var compsNeg = this._neg;
        if (compsNeg.array.length > 0) {
          compsNeg.array.sort(compareOrder);
          this._invoke(compsNeg);
          compsNeg.array.length = 0;
        }
        this._invoke(this._zero);
        this._zero.array.length = 0;
        var compsPos = this._pos;
        if (compsPos.array.length > 0) {
          compsPos.array.sort(compareOrder);
          this._invoke(compsPos);
          compsPos.array.length = 0;
        }
      }
    });
    var ReusableInvoker = cc.Class({
      extends: LifeCycleInvoker,
      add: function(comp) {
        var order = comp.constructor._executionOrder;
        if (0 === order) this._zero.array.push(comp); else {
          var array = order < 0 ? this._neg.array : this._pos.array;
          var i = sortedIndex(array, comp);
          i < 0 && array.splice(~i, 0, comp);
        }
      },
      remove: function(comp) {
        var order = comp.constructor._executionOrder;
        if (0 === order) this._zero.fastRemove(comp); else {
          var iterator = order < 0 ? this._neg : this._pos;
          var i = sortedIndex(iterator.array, comp);
          i >= 0 && iterator.removeAt(i);
        }
      },
      invoke: function(dt) {
        this._neg.array.length > 0 && this._invoke(this._neg, dt);
        this._invoke(this._zero, dt);
        this._pos.array.length > 0 && this._invoke(this._pos, dt);
      }
    });
    function enableInEditor(comp) {
      if (!(comp._objFlags & IsEditorOnEnableCalled)) {
        cc.engine.emit("component-enabled", comp.uuid);
        comp._objFlags |= IsEditorOnEnableCalled;
      }
    }
    function createInvokeImpl(funcOrCode, useDt) {
      if ("function" === typeof funcOrCode) return useDt ? function(iterator, dt) {
        var array = iterator.array;
        for (iterator.i = 0; iterator.i < array.length; ++iterator.i) {
          var comp = array[iterator.i];
          funcOrCode(comp, dt);
        }
      } : function(iterator) {
        var array = iterator.array;
        for (iterator.i = 0; iterator.i < array.length; ++iterator.i) {
          var comp = array[iterator.i];
          funcOrCode(comp);
        }
      };
      var body = "var a=it.array;for(it.i=0;it.i<a.length;++it.i){var c=a[it.i];" + funcOrCode + "}";
      return useDt ? Function("it", "dt", body) : Function("it", body);
    }
    function ctor() {
      this.startInvoker = new OneOffInvoker(createInvokeImpl(callStart));
      this.updateInvoker = new ReusableInvoker(createInvokeImpl(callUpdate, true));
      this.lateUpdateInvoker = new ReusableInvoker(createInvokeImpl(callLateUpdate, true));
      this.scheduleInNextFrame = [];
      this._updating = false;
    }
    var ComponentScheduler = cc.Class({
      ctor: ctor,
      unscheduleAll: ctor,
      statics: {
        LifeCycleInvoker: LifeCycleInvoker,
        OneOffInvoker: OneOffInvoker,
        createInvokeImpl: createInvokeImpl,
        invokeOnEnable: function(iterator) {
          var compScheduler = cc.director._compScheduler;
          var array = iterator.array;
          for (iterator.i = 0; iterator.i < array.length; ++iterator.i) {
            var comp = array[iterator.i];
            if (comp._enabled) {
              comp.onEnable();
              var deactivatedDuringOnEnable = !comp.node._activeInHierarchy;
              deactivatedDuringOnEnable || compScheduler._onEnabled(comp);
            }
          }
        }
      },
      _onEnabled: function(comp) {
        cc.director.getScheduler().resumeTarget(comp);
        comp._objFlags |= IsOnEnableCalled;
        this._updating ? this.scheduleInNextFrame.push(comp) : this._scheduleImmediate(comp);
      },
      _onDisabled: function(comp) {
        cc.director.getScheduler().pauseTarget(comp);
        comp._objFlags &= ~IsOnEnableCalled;
        var index = this.scheduleInNextFrame.indexOf(comp);
        if (index >= 0) {
          jsArray.fastRemoveAt(this.scheduleInNextFrame, index);
          return;
        }
        !comp.start || comp._objFlags & IsStartCalled || this.startInvoker.remove(comp);
        comp.update && this.updateInvoker.remove(comp);
        comp.lateUpdate && this.lateUpdateInvoker.remove(comp);
      },
      enableComp: function(comp, invoker) {
        if (!(comp._objFlags & IsOnEnableCalled)) {
          if (comp.onEnable) {
            if (invoker) {
              invoker.add(comp);
              return;
            }
            comp.onEnable();
            var deactivatedDuringOnEnable = !comp.node._activeInHierarchy;
            if (deactivatedDuringOnEnable) return;
          }
          this._onEnabled(comp);
        }
      },
      disableComp: function(comp) {
        if (comp._objFlags & IsOnEnableCalled) {
          comp.onDisable && comp.onDisable();
          this._onDisabled(comp);
        }
      },
      _scheduleImmediate: function(comp) {
        !comp.start || comp._objFlags & IsStartCalled || this.startInvoker.add(comp);
        comp.update && this.updateInvoker.add(comp);
        comp.lateUpdate && this.lateUpdateInvoker.add(comp);
      },
      _deferredSchedule: function() {
        var comps = this.scheduleInNextFrame;
        for (var i = 0, len = comps.length; i < len; i++) {
          var comp = comps[i];
          this._scheduleImmediate(comp);
        }
        comps.length = 0;
      },
      startPhase: function() {
        this._updating = true;
        this.scheduleInNextFrame.length > 0 && this._deferredSchedule();
        this.startInvoker.invoke();
      },
      updatePhase: function(dt) {
        this.updateInvoker.invoke(dt);
      },
      lateUpdatePhase: function(dt) {
        this.lateUpdateInvoker.invoke(dt);
        this._updating = false;
      }
    });
    module.exports = ComponentScheduler;
  }), {
    "./platform/CCClass": 147,
    "./platform/CCObject": 153,
    "./platform/js": 167,
    "./utils/misc": 208
  } ],
  55: [ (function(require, module, exports) {
    var AnimationAnimator = require("../../animation/animation-animator");
    var AnimationClip = require("../../animation/animation-clip");
    var EventTarget = require("../event/event-target");
    var js = require("../platform/js");
    function equalClips(clip1, clip2) {
      if (clip1 === clip2) return true;
      return clip1 && clip2 && (clip1.name === clip2.name || clip1._uuid === clip2._uuid);
    }
    var EventType = cc.Enum({
      PLAY: "play",
      STOP: "stop",
      PAUSE: "pause",
      RESUME: "resume",
      LASTFRAME: "lastframe",
      FINISHED: "finished"
    });
    var Animation = cc.Class({
      name: "cc.Animation",
      extends: require("./CCComponent"),
      mixins: [ EventTarget ],
      editor: false,
      statics: {
        EventType: EventType
      },
      ctor: function() {
        cc.EventTarget.call(this);
        this._animator = null;
        this._nameToState = js.createMap(true);
        this._didInit = false;
        this._currentClip = null;
      },
      properties: {
        _defaultClip: {
          default: null,
          type: AnimationClip
        },
        defaultClip: {
          type: AnimationClip,
          get: function() {
            return this._defaultClip;
          },
          set: function(value) {
            true;
            return;
            var clips;
            var i, l;
          },
          tooltip: false
        },
        currentClip: {
          get: function() {
            return this._currentClip;
          },
          set: function(value) {
            this._currentClip = value;
          },
          type: AnimationClip,
          visible: false
        },
        _clips: {
          default: [],
          type: [ AnimationClip ],
          tooltip: false,
          visible: true
        },
        playOnLoad: {
          default: false,
          tooltip: false
        }
      },
      start: function() {
        if ((true, this.playOnLoad) && this._defaultClip) {
          var isPlaying = this._animator && this._animator.isPlaying;
          if (!isPlaying) {
            var state = this.getAnimationState(this._defaultClip.name);
            this._animator.playState(state);
          }
        }
      },
      onEnable: function() {
        this._animator && this._animator.resume();
      },
      onDisable: function() {
        this._animator && this._animator.pause();
      },
      onDestroy: function() {
        this.stop();
      },
      getClips: function() {
        return this._clips;
      },
      play: function(name, startTime) {
        var state = this.playAdditive(name, startTime);
        this._animator.stopStatesExcept(state);
        return state;
      },
      playAdditive: function(name, startTime) {
        this._init();
        var state = this.getAnimationState(name || this._defaultClip && this._defaultClip.name);
        if (state) {
          this.enabled = true;
          var animator = this._animator;
          if (animator.isPlaying && state.isPlaying) if (state.isPaused) animator.resumeState(state); else {
            animator.stopState(state);
            animator.playState(state, startTime);
          } else animator.playState(state, startTime);
          this.enabledInHierarchy || animator.pause();
          this.currentClip = state.clip;
        }
        return state;
      },
      stop: function(name) {
        if (!this._didInit) return;
        if (name) {
          var state = this._nameToState[name];
          state && this._animator.stopState(state);
        } else this._animator.stop();
      },
      pause: function(name) {
        if (!this._didInit) return;
        if (name) {
          var state = this._nameToState[name];
          state && this._animator.pauseState(state);
        } else this.enabled = false;
      },
      resume: function(name) {
        if (!this._didInit) return;
        if (name) {
          var state = this._nameToState[name];
          state && this._animator.resumeState(state);
        } else this.enabled = true;
      },
      setCurrentTime: function(time, name) {
        this._init();
        if (name) {
          var state = this._nameToState[name];
          state && this._animator.setStateTime(state, time);
        } else this._animator.setStateTime(time);
      },
      getAnimationState: function(name) {
        this._init();
        var state = this._nameToState[name];
        false;
        state && !state.curveLoaded && this._animator._reloadClip(state);
        return state || null;
      },
      addClip: function(clip, newName) {
        if (!clip) {
          cc.warnID(3900);
          return;
        }
        this._init();
        cc.js.array.contains(this._clips, clip) || this._clips.push(clip);
        newName = newName || clip.name;
        var oldState = this._nameToState[newName];
        if (oldState) {
          if (oldState.clip === clip) return oldState;
          var index = this._clips.indexOf(oldState.clip);
          -1 !== index && this._clips.splice(index, 1);
        }
        var newState = new cc.AnimationState(clip, newName);
        this._nameToState[newName] = newState;
        return newState;
      },
      removeClip: function(clip, force) {
        if (!clip) {
          cc.warnID(3901);
          return;
        }
        this._init();
        var state;
        for (var name in this._nameToState) {
          state = this._nameToState[name];
          var stateClip = state.clip;
          if (stateClip === clip) break;
        }
        if (clip === this._defaultClip) {
          if (!force) {
            true;
            cc.warnID(3902);
            return;
          }
          this._defaultClip = null;
        }
        if (state && state.isPlaying) {
          if (!force) {
            true;
            cc.warnID(3903);
            return;
          }
          this.stop(state.name);
        }
        this._clips = this._clips.filter((function(item) {
          return item !== clip;
        }));
        state && delete this._nameToState[state.name];
      },
      sample: function(name) {
        this._init();
        if (name) {
          var state = this._nameToState[name];
          state && state.sample();
        } else this._animator.sample();
      },
      on: function(type, callback, target, useCapture) {
        this._init();
        var ret = this._EventTargetOn(type, callback, target, useCapture);
        var array = this._animator._anims.array;
        for (var i = 0; i < array.length; ++i) array[i]._setListeners(this);
        return ret;
      },
      off: function(type, callback, target, useCapture) {
        this._init();
        this._EventTargetOff(type, callback, target, useCapture);
        var nameToState = this._nameToState;
        for (var name in nameToState) {
          var state = nameToState[name];
          state._setListeners(null);
        }
      },
      _init: function() {
        if (this._didInit) return;
        this._didInit = true;
        this._animator = new AnimationAnimator(this.node, this);
        this._createStates();
      },
      _createStates: function() {
        this._nameToState = js.createMap(true);
        var state = null;
        var defaultClipState = false;
        for (var i = 0; i < this._clips.length; ++i) {
          var clip = this._clips[i];
          if (clip) {
            state = new cc.AnimationState(clip);
            false;
            this._nameToState[state.name] = state;
            equalClips(this._defaultClip, clip) && (defaultClipState = state);
          }
        }
        if (this._defaultClip && !defaultClipState) {
          state = new cc.AnimationState(this._defaultClip);
          false;
          this._nameToState[state.name] = state;
        }
      }
    });
    Animation.prototype._EventTargetOn = EventTarget.prototype.on;
    Animation.prototype._EventTargetOff = EventTarget.prototype.off;
    cc.Animation = module.exports = Animation;
  }), {
    "../../animation/animation-animator": 9,
    "../../animation/animation-clip": 10,
    "../event/event-target": 91,
    "../platform/js": 167,
    "./CCComponent": 59
  } ],
  56: [ (function(require, module, exports) {
    var BlockEvents = [ "touchstart", "touchmove", "touchend", "mousedown", "mousemove", "mouseup", "mouseenter", "mouseleave", "mousewheel" ];
    function stopPropagation(event) {
      event.stopPropagation();
    }
    var BlockInputEvents = cc.Class({
      name: "cc.BlockInputEvents",
      extends: require("./CCComponent"),
      editor: {
        menu: "i18n:MAIN_MENU.component.ui/Block Input Events",
        inspector: "packages://inspector/inspectors/comps/block-input-events.js",
        help: "i18n:COMPONENT.help_url.block-input-events"
      },
      onEnable: function() {
        for (var i = 0; i < BlockEvents.length; i++) this.node.on(BlockEvents[i], stopPropagation, this);
      },
      onDisable: function() {
        for (var i = 0; i < BlockEvents.length; i++) this.node.off(BlockEvents[i], stopPropagation, this);
      }
    });
    cc.BlockInputEvents = module.exports = BlockInputEvents;
  }), {
    "./CCComponent": 59
  } ],
  57: [ (function(require, module, exports) {
    var Component = require("./CCComponent");
    var misc = require("../utils/misc");
    var Transition = cc.Enum({
      NONE: 0,
      COLOR: 1,
      SPRITE: 2,
      SCALE: 3
    });
    var Button = cc.Class({
      name: "cc.Button",
      extends: Component,
      ctor: function() {
        this._pressed = false;
        this._hovered = false;
        this._fromColor = null;
        this._toColor = null;
        this._time = 0;
        this._transitionFinished = true;
        this._fromScale = 1;
        this._toScale = 1;
        this._originalScale = 1;
        this._sprite = null;
        false;
      },
      editor: false,
      properties: {
        interactable: {
          default: true,
          tooltip: false,
          notify: function(oldValue) {
            false;
            this._updateState();
            this.interactable || this._resetState();
          },
          animatable: false
        },
        _resizeToTarget: {
          animatable: false,
          set: function(value) {
            value && this._resizeNodeToTargetNode();
          }
        },
        enableAutoGrayEffect: {
          default: false,
          tooltip: false,
          notify: function() {
            this._updateDisabledState();
          }
        },
        transition: {
          default: Transition.NONE,
          tooltip: false,
          type: Transition,
          animatable: false
        },
        normalColor: {
          default: cc.color(214, 214, 214),
          displayName: "Normal",
          tooltip: false,
          notify: function() {
            this._updateState();
          }
        },
        pressedColor: {
          default: cc.color(211, 211, 211),
          displayName: "Pressed",
          tooltip: false
        },
        hoverColor: {
          default: cc.Color.WHITE,
          displayName: "Hover",
          tooltip: false
        },
        disabledColor: {
          default: cc.color(124, 124, 124),
          displayName: "Disabled",
          tooltip: false,
          notify: function() {
            this._updateState();
          }
        },
        duration: {
          default: .1,
          range: [ 0, 10 ],
          tooltip: false
        },
        zoomScale: {
          default: 1.2,
          tooltip: false
        },
        normalSprite: {
          default: null,
          type: cc.SpriteFrame,
          displayName: "Normal",
          tooltip: false,
          notify: function() {
            this._updateState();
          }
        },
        pressedSprite: {
          default: null,
          type: cc.SpriteFrame,
          displayName: "Pressed",
          tooltip: false,
          formerlySerializedAs: "pressedSprite",
          notify: function() {
            this._updateState();
          }
        },
        hoverSprite: {
          default: null,
          type: cc.SpriteFrame,
          displayName: "Hover",
          tooltip: false,
          formerlySerializedAs: "hoverSprite",
          notify: function() {
            this._updateState();
          }
        },
        disabledSprite: {
          default: null,
          type: cc.SpriteFrame,
          displayName: "Disabled",
          tooltip: false,
          notify: function() {
            this._updateState();
          }
        },
        target: {
          default: null,
          type: cc.Node,
          tooltip: false,
          notify: function() {
            this._applyTarget();
          }
        },
        clickEvents: {
          default: [],
          type: cc.Component.EventHandler,
          tooltip: false
        }
      },
      statics: {
        Transition: Transition
      },
      __preload: function() {
        this.target || (this.target = this.node);
        this._applyTarget();
        this._updateState();
      },
      _resetState: function() {
        this._pressed = false;
        this._hovered = false;
        var target = this.target;
        var transition = this.transition;
        transition === Transition.COLOR && this.interactable ? target.color = this.normalColor : transition === Transition.SCALE && (target.scale = this._originalScale);
        this._transitionFinished = true;
      },
      onEnable: function() {
        this.normalSprite && this.normalSprite.ensureLoadTexture();
        this.hoverSprite && this.hoverSprite.ensureLoadTexture();
        this.pressedSprite && this.pressedSprite.ensureLoadTexture();
        this.disabledSprite && this.disabledSprite.ensureLoadTexture();
        true;
        this._registerEvent();
      },
      onDisable: function() {
        this._resetState();
        true;
        this.node.off(cc.Node.EventType.TOUCH_START, this._onTouchBegan, this);
        this.node.off(cc.Node.EventType.TOUCH_MOVE, this._onTouchMove, this);
        this.node.off(cc.Node.EventType.TOUCH_END, this._onTouchEnded, this);
        this.node.off(cc.Node.EventType.TOUCH_CANCEL, this._onTouchCancel, this);
        this.node.off(cc.Node.EventType.MOUSE_ENTER, this._onMouseMoveIn, this);
        this.node.off(cc.Node.EventType.MOUSE_LEAVE, this._onMouseMoveOut, this);
      },
      update: function(dt) {
        var target = this.target;
        if (this._transitionFinished) return;
        if (this.transition !== Transition.COLOR && this.transition !== Transition.SCALE) return;
        this.time += dt;
        var ratio = 1;
        this.duration > 0 && (ratio = this.time / this.duration);
        if (ratio >= 1) {
          ratio = 1;
          this._transitionFinished = true;
        }
        this.transition === Transition.COLOR ? target.color = this._fromColor.lerp(this._toColor, ratio) : this.transition === Transition.SCALE && (target.scale = misc.lerp(this._fromScale, this._toScale, ratio));
      },
      _registerEvent: function() {
        this.node.on(cc.Node.EventType.TOUCH_START, this._onTouchBegan, this);
        this.node.on(cc.Node.EventType.TOUCH_MOVE, this._onTouchMove, this);
        this.node.on(cc.Node.EventType.TOUCH_END, this._onTouchEnded, this);
        this.node.on(cc.Node.EventType.TOUCH_CANCEL, this._onTouchCancel, this);
        this.node.on(cc.Node.EventType.MOUSE_ENTER, this._onMouseMoveIn, this);
        this.node.on(cc.Node.EventType.MOUSE_LEAVE, this._onMouseMoveOut, this);
      },
      _getTargetSprite: function(target) {
        var sprite = null;
        target && (sprite = target.getComponent(cc.Sprite));
        return sprite;
      },
      _applyTarget: function() {
        this._sprite = this._getTargetSprite(this.target);
        this.target && (this._originalScale = this.target.scale);
      },
      _onTouchBegan: function(event) {
        if (!this.interactable || !this.enabledInHierarchy) return;
        this._pressed = true;
        this._updateState();
        event.stopPropagation();
      },
      _onTouchMove: function(event) {
        if (!this.interactable || !this.enabledInHierarchy || !this._pressed) return;
        var touch = event.touch;
        var hit = this.node._hitTest(touch.getLocation());
        if (this.transition === Transition.SCALE && this.target) if (hit) {
          this._fromScale = this._originalScale;
          this._toScale = this._originalScale * this.zoomScale;
          this._transitionFinished = false;
        } else {
          this.time = 0;
          this._transitionFinished = true;
          this.target.scale = this._originalScale;
        } else {
          var state = void 0;
          state = hit ? "pressed" : "normal";
          this._applyTransition(state);
        }
        event.stopPropagation();
      },
      _onTouchEnded: function(event) {
        if (!this.interactable || !this.enabledInHierarchy) return;
        if (this._pressed) {
          cc.Component.EventHandler.emitEvents(this.clickEvents, event);
          this.node.emit("click", this);
        }
        this._pressed = false;
        this._updateState();
        event.stopPropagation();
      },
      _onTouchCancel: function() {
        if (!this.interactable || !this.enabledInHierarchy) return;
        this._pressed = false;
        this._updateState();
      },
      _onMouseMoveIn: function() {
        if (this._pressed || !this.interactable || !this.enabledInHierarchy) return;
        if (this.transition === Transition.SPRITE && !this.hoverSprite) return;
        if (!this._hovered) {
          this._hovered = true;
          this._updateState();
        }
      },
      _onMouseMoveOut: function() {
        if (this._hovered) {
          this._hovered = false;
          this._updateState();
        }
      },
      _updateState: function() {
        var state = this._getButtonState();
        this._applyTransition(state);
        this._updateDisabledState();
      },
      _getButtonState: function() {
        var state = void 0;
        state = this.interactable ? this._pressed ? "pressed" : this._hovered ? "hover" : "normal" : "disabled";
        return state;
      },
      _updateColorTransition: function(state) {
        var color = this[state + "Color"];
        var target = this.target;
        false;
        this._fromColor = target.color.clone();
        this._toColor = color;
        this.time = 0;
        this._transitionFinished = false;
      },
      _updateSpriteTransition: function(state) {
        var sprite = this[state + "Sprite"];
        this._sprite && sprite && (this._sprite.spriteFrame = sprite);
      },
      _updateScaleTransition: function(state) {
        "pressed" === state ? this._zoomUp() : this._zoomBack();
      },
      _zoomUp: function() {
        this._fromScale = this._originalScale;
        this._toScale = this._originalScale * this.zoomScale;
        this.time = 0;
        this._transitionFinished = false;
      },
      _zoomBack: function() {
        this._fromScale = this.target.scale;
        this._toScale = this._originalScale;
        this.time = 0;
        this._transitionFinished = false;
      },
      _applyTransition: function(state) {
        var transition = this.transition;
        transition === Transition.COLOR ? this._updateColorTransition(state) : transition === Transition.SPRITE ? this._updateSpriteTransition(state) : transition === Transition.SCALE && this._updateScaleTransition(state);
      },
      _resizeNodeToTargetNode: false,
      _updateDisabledState: function() {
        this._sprite && this._sprite.setState(cc.Sprite.State.NORMAL);
        this.enableAutoGrayEffect && this.transition !== Transition.COLOR && (this.transition === Transition.SPRITE && this.disabledSprite || this._sprite && !this.interactable && this._sprite.setState(cc.Sprite.State.GRAY));
      }
    });
    cc.Button = module.exports = Button;
  }), {
    "../utils/misc": 208,
    "./CCComponent": 59
  } ],
  58: [ (function(require, module, exports) {
    var Camera = require("../camera/CCCamera");
    var Component = require("./CCComponent");
    var Canvas = cc.Class({
      name: "cc.Canvas",
      extends: Component,
      editor: false,
      resetInEditor: false,
      statics: {
        instance: null
      },
      properties: {
        _designResolution: cc.size(960, 640),
        designResolution: {
          get: function() {
            return cc.size(this._designResolution);
          },
          set: function(value) {
            this._designResolution.width = value.width;
            this._designResolution.height = value.height;
            this.applySettings();
          },
          tooltip: false
        },
        _fitWidth: false,
        _fitHeight: true,
        fitHeight: {
          get: function() {
            return this._fitHeight;
          },
          set: function(value) {
            if (this._fitHeight !== value) {
              this._fitHeight = value;
              this.applySettings();
            }
          },
          tooltip: false
        },
        fitWidth: {
          get: function() {
            return this._fitWidth;
          },
          set: function(value) {
            if (this._fitWidth !== value) {
              this._fitWidth = value;
              this.applySettings();
            }
          },
          tooltip: false
        }
      },
      ctor: function() {
        this._thisOnResized = this.onResized.bind(this);
      },
      __preload: function() {
        var Flags;
        false;
        if (Canvas.instance) return cc.errorID(6700, this.node.name, Canvas.instance.node.name);
        Canvas.instance = this;
        cc.director.on(cc.Director.EVENT_AFTER_UPDATE, this.alignWithScreen, this);
        false;
        cc.sys.isMobile ? window.addEventListener("resize", this._thisOnResized) : cc.view.on("canvas-resize", this._thisOnResized);
        this.applySettings();
        this.onResized();
        var cameraNode = cc.find("Main Camera", this.node);
        if (!cameraNode) {
          cameraNode = new cc.Node("Main Camera");
          cameraNode.parent = this.node;
          cameraNode.setSiblingIndex(0);
        }
        var camera = cameraNode.getComponent(Camera);
        if (!camera) {
          camera = cameraNode.addComponent(Camera);
          var ClearFlags = Camera.ClearFlags;
          camera.clearFlags = ClearFlags.COLOR | ClearFlags.DEPTH | ClearFlags.STENCIL;
          camera.depth = -1;
        }
        Camera.main = camera;
      },
      onDestroy: function() {
        cc.director.off(cc.Director.EVENT_AFTER_UPDATE, this.alignWithScreen, this);
        false;
        cc.sys.isMobile ? window.removeEventListener("resize", this._thisOnResized) : cc.view.off("canvas-resize", this._thisOnResized);
        Canvas.instance === this && (Canvas.instance = null);
      },
      alignWithScreen: function() {
        var designSize, nodeSize;
        false;
        var canvasSize = nodeSize = cc.visibleRect;
        designSize = cc.view.getDesignResolutionSize();
        var clipTopRight = !this.fitHeight && !this.fitWidth;
        var offsetX = 0;
        var offsetY = 0;
        if (clipTopRight) {
          offsetX = .5 * (designSize.width - canvasSize.width);
          offsetY = .5 * (designSize.height - canvasSize.height);
        }
        this.node.setPosition(.5 * canvasSize.width + offsetX, .5 * canvasSize.height + offsetY);
        this.node.width = nodeSize.width;
        this.node.height = nodeSize.height;
      },
      onResized: function() {
        this.alignWithScreen();
      },
      applySettings: function() {
        var ResolutionPolicy = cc.ResolutionPolicy;
        var policy;
        policy = this.fitHeight && this.fitWidth ? ResolutionPolicy.SHOW_ALL : this.fitHeight || this.fitWidth ? this.fitWidth ? ResolutionPolicy.FIXED_WIDTH : ResolutionPolicy.FIXED_HEIGHT : ResolutionPolicy.NO_BORDER;
        var designRes = this._designResolution;
        false;
        cc.view.setDesignResolutionSize(designRes.width, designRes.height, policy);
      }
    });
    cc.Canvas = module.exports = Canvas;
  }), {
    "../camera/CCCamera": 46,
    "./CCComponent": 59
  } ],
  59: [ (function(require, module, exports) {
    var CCObject = require("../platform/CCObject");
    var js = require("../platform/js");
    var idGenerater = new (require("../platform/id-generater"))("Comp");
    var IsOnEnableCalled = CCObject.Flags.IsOnEnableCalled;
    var IsOnLoadCalled = CCObject.Flags.IsOnLoadCalled;
    var Component = cc.Class({
      name: "cc.Component",
      extends: CCObject,
      ctor: function() {
        this._id = idGenerater.getNewId();
        this.__eventTargets = [];
      },
      properties: {
        node: {
          default: null,
          visible: false
        },
        name: {
          get: function() {
            if (this._name) return this._name;
            var className = cc.js.getClassName(this);
            var trimLeft = className.lastIndexOf(".");
            trimLeft >= 0 && (className = className.slice(trimLeft + 1));
            return this.node.name + "<" + className + ">";
          },
          set: function(value) {
            this._name = value;
          },
          visible: false
        },
        uuid: {
          get: function() {
            return this._id;
          },
          visible: false
        },
        __scriptAsset: false,
        _enabled: true,
        enabled: {
          get: function() {
            return this._enabled;
          },
          set: function(value) {
            if (this._enabled !== value) {
              this._enabled = value;
              if (this.node._activeInHierarchy) {
                var compScheduler = cc.director._compScheduler;
                value ? compScheduler.enableComp(this) : compScheduler.disableComp(this);
              }
            }
          },
          visible: false
        },
        enabledInHierarchy: {
          get: function() {
            return (this._objFlags & IsOnEnableCalled) > 0;
          },
          visible: false
        },
        _isOnLoadCalled: {
          get: function() {
            return this._objFlags & IsOnLoadCalled;
          }
        }
      },
      update: null,
      lateUpdate: null,
      __preload: null,
      onLoad: null,
      start: null,
      onEnable: null,
      onDisable: null,
      onDestroy: null,
      onFocusInEditor: null,
      onLostFocusInEditor: null,
      resetInEditor: null,
      addComponent: function(typeOrClassName) {
        return this.node.addComponent(typeOrClassName);
      },
      getComponent: function(typeOrClassName) {
        return this.node.getComponent(typeOrClassName);
      },
      getComponents: function(typeOrClassName) {
        return this.node.getComponents(typeOrClassName);
      },
      getComponentInChildren: function(typeOrClassName) {
        return this.node.getComponentInChildren(typeOrClassName);
      },
      getComponentsInChildren: function(typeOrClassName) {
        return this.node.getComponentsInChildren(typeOrClassName);
      },
      _getLocalBounds: null,
      onRestore: null,
      destroy: function() {
        var depend;
        false;
        this._super() && this._enabled && this.node._activeInHierarchy && cc.director._compScheduler.disableComp(this);
      },
      _onPreDestroy: function() {
        this.unscheduleAllCallbacks();
        var eventTargets = this.__eventTargets;
        for (var i = 0, l = eventTargets.length; i < l; ++i) {
          var target = eventTargets[i];
          target && target.targetOff(this);
        }
        eventTargets.length = 0;
        false;
        cc.director._nodeActivator.destroyComp(this);
        this.node._removeComponent(this);
      },
      _instantiate: function(cloned) {
        cloned || (cloned = cc.instantiate._clone(this, this));
        cloned.node = null;
        return cloned;
      },
      schedule: function(callback, interval, repeat, delay) {
        cc.assertID(callback, 1619);
        cc.assertID(interval >= 0, 1620);
        interval = interval || 0;
        repeat = isNaN(repeat) ? cc.macro.REPEAT_FOREVER : repeat;
        delay = delay || 0;
        var scheduler = cc.director.getScheduler();
        var paused = scheduler.isTargetPaused(this);
        scheduler.schedule(callback, this, interval, repeat, delay, paused);
      },
      scheduleOnce: function(callback, delay) {
        this.schedule(callback, 0, 0, delay);
      },
      unschedule: function(callback_fn) {
        if (!callback_fn) return;
        cc.director.getScheduler().unschedule(callback_fn, this);
      },
      unscheduleAllCallbacks: function() {
        cc.director.getScheduler().unscheduleAllForTarget(this);
      }
    });
    Component._requireComponent = null;
    Component._executionOrder = 0;
    false, false;
    js.value(Component, "_registerEditorProps", (function(cls, props) {
      var reqComp = props.requireComponent;
      reqComp && (cls._requireComponent = reqComp);
      var order = props.executionOrder;
      order && "number" === typeof order && (cls._executionOrder = order);
      var name;
      var key;
      var val;
      var willExecuteInEditMode;
      false, false;
    }));
    Component.prototype.__scriptUuid = "";
    cc.Component = module.exports = Component;
  }), {
    "../platform/CCObject": 153,
    "../platform/id-generater": 163,
    "../platform/js": 167
  } ],
  60: [ (function(require, module, exports) {
    cc.Component.EventHandler = cc.Class({
      name: "cc.ClickEvent",
      properties: {
        target: {
          default: null,
          type: cc.Node
        },
        component: {
          default: ""
        },
        handler: {
          default: ""
        },
        customEventData: {
          default: ""
        }
      },
      statics: {
        emitEvents: function(events) {
          "use strict";
          var args = void 0;
          if (arguments.length > 0) {
            args = new Array(arguments.length - 1);
            for (var i = 0, l = args.length; i < l; i++) args[i] = arguments[i + 1];
          }
          for (var _i = 0, _l = events.length; _i < _l; _i++) {
            var event = events[_i];
            if (!(event instanceof cc.Component.EventHandler)) continue;
            event.emit(args);
          }
        }
      },
      emit: function(params) {
        var target = this.target;
        if (!cc.isValid(target)) return;
        var comp = target.getComponent(this.component);
        if (!cc.isValid(comp)) return;
        var handler = comp[this.handler];
        if ("function" !== typeof handler) return;
        if (null != this.customEventData && "" !== this.customEventData) {
          params = params.slice();
          params.push(this.customEventData);
        }
        handler.apply(comp, params);
      }
    });
  }), {} ],
  61: [ (function(require, module, exports) {
    var macro = require("../platform/CCMacro");
    var RenderComponent = require("./CCRenderComponent");
    var renderEngine = require("../renderer/render-engine");
    var RenderFlow = require("../renderer/render-flow");
    var SpriteMaterial = renderEngine.SpriteMaterial;
    var HorizontalAlign = macro.TextAlignment;
    var VerticalAlign = macro.VerticalTextAlignment;
    var Overflow = cc.Enum({
      NONE: 0,
      CLAMP: 1,
      SHRINK: 2,
      RESIZE_HEIGHT: 3
    });
    var Label = cc.Class({
      name: "cc.Label",
      extends: RenderComponent,
      ctor: function() {
        false;
        this._actualFontSize = 0;
        this._assemblerData = null;
        this._ttfTexture = null;
      },
      editor: false,
      properties: {
        _useOriginalSize: true,
        _string: {
          default: "",
          formerlySerializedAs: "_N$string"
        },
        string: {
          get: function() {
            return this._string;
          },
          set: function(value) {
            var oldValue = this._string;
            this._string = value.toString();
            this.string !== oldValue && this._updateRenderData();
            this._checkStringEmpty();
          },
          multiline: true,
          tooltip: false
        },
        horizontalAlign: {
          default: HorizontalAlign.LEFT,
          type: HorizontalAlign,
          tooltip: false,
          notify: function(oldValue) {
            if (this.horizontalAlign === oldValue) return;
            this._updateRenderData();
          },
          animatable: false
        },
        verticalAlign: {
          default: VerticalAlign.TOP,
          type: VerticalAlign,
          tooltip: false,
          notify: function(oldValue) {
            if (this.verticalAlign === oldValue) return;
            this._updateRenderData();
          },
          animatable: false
        },
        actualFontSize: {
          displayName: "Actual Font Size",
          animatable: false,
          readonly: true,
          get: function() {
            return this._actualFontSize;
          }
        },
        _fontSize: 40,
        fontSize: {
          get: function() {
            return this._fontSize;
          },
          set: function(value) {
            if (this._fontSize === value) return;
            this._fontSize = value;
            this._updateRenderData();
          },
          tooltip: false
        },
        fontFamily: {
          default: "Arial",
          tooltip: false,
          notify: function(oldValue) {
            if (this.fontFamily === oldValue) return;
            this._updateRenderData();
          },
          animatable: false
        },
        _lineHeight: 40,
        lineHeight: {
          get: function() {
            return this._lineHeight;
          },
          set: function(value) {
            if (this._lineHeight === value) return;
            this._lineHeight = value;
            this._updateRenderData();
          },
          tooltip: false
        },
        overflow: {
          default: Overflow.NONE,
          type: Overflow,
          tooltip: false,
          notify: function(oldValue) {
            if (this.overflow === oldValue) return;
            this._updateRenderData();
          },
          animatable: false
        },
        _enableWrapText: true,
        enableWrapText: {
          get: function() {
            return this._enableWrapText;
          },
          set: function(value) {
            if (this._enableWrapText === value) return;
            this._enableWrapText = value;
            this._updateRenderData();
          },
          animatable: false,
          tooltip: false
        },
        _N$file: null,
        font: {
          get: function() {
            return this._N$file;
          },
          set: function(value) {
            if (this.font === value) return;
            value || (this._isSystemFontUsed = true);
            false;
            this._N$file = value;
            this._bmFontOriginalSize = -1;
            value && this._isSystemFontUsed && (this._isSystemFontUsed = false);
            "string" === typeof value && cc.warnID(4e3);
            value instanceof cc.BitmapFont && (this._bmFontOriginalSize = value.fontSize);
            if (this._renderData) {
              this.destroyRenderData(this._renderData);
              this._renderData = null;
            }
            this._fontAtlas = null;
            this._updateAssembler();
            this._activateMaterial(true);
            this._updateRenderData();
          },
          type: cc.Font,
          tooltip: false,
          animatable: false
        },
        _isSystemFontUsed: true,
        useSystemFont: {
          get: function() {
            return this._isSystemFontUsed;
          },
          set: function(value) {
            if (this._isSystemFontUsed === value) return;
            this.destroyRenderData(this._renderData);
            this._renderData = null;
            false;
            this._isSystemFontUsed = !!value;
            if (value) {
              this.font = null;
              this._updateAssembler();
              this._updateRenderData();
              this._checkStringEmpty();
            } else this._userDefinedFont || this.disableRender();
          },
          animatable: false,
          tooltip: false
        },
        _bmFontOriginalSize: {
          displayName: "BMFont Original Size",
          default: -1,
          serializable: false,
          readonly: true,
          visible: true,
          animatable: false
        },
        _spacingX: 0,
        spacingX: {
          get: function() {
            return this._spacingX;
          },
          set: function(value) {
            this._spacingX = value;
            this._updateRenderData();
          }
        },
        _isBold: {
          default: false,
          serializable: false
        },
        _isItalic: {
          default: false,
          serializable: false
        },
        _isUnderline: {
          default: false,
          serializable: false
        }
      },
      statics: {
        HorizontalAlign: HorizontalAlign,
        VerticalAlign: VerticalAlign,
        Overflow: Overflow
      },
      onEnable: function() {
        this._super();
        this.font || this._isSystemFontUsed || (this.useSystemFont = true);
        this.useSystemFont && !this.fontFamily && (this.fontFamily = "Arial");
        this.node.on(cc.Node.EventType.SIZE_CHANGED, this._updateRenderData, this);
        this.node.on(cc.Node.EventType.ANCHOR_CHANGED, this._updateRenderData, this);
        this._checkStringEmpty();
        this._updateAssembler();
        this._activateMaterial();
      },
      onDisable: function() {
        this._super();
        this.node.off(cc.Node.EventType.SIZE_CHANGED, this._updateRenderData, this);
        this.node.off(cc.Node.EventType.ANCHOR_CHANGED, this._updateRenderData, this);
      },
      onDestroy: function() {
        this._assembler._resetAssemblerData && this._assembler._resetAssemblerData(this._assemblerData);
        this._assemblerData = null;
        if (this._ttfTexture) {
          this._ttfTexture.destroy();
          this._ttfTexture = null;
        }
        this._super();
      },
      _canRender: function() {
        var result = this._super();
        var font = this.font;
        if (font instanceof cc.BitmapFont) {
          var spriteFrame = font.spriteFrame;
          spriteFrame && spriteFrame.textureLoaded() || (result = false);
        }
        return result;
      },
      _checkStringEmpty: function() {
        this.markForRender(!!this.string);
      },
      _updateAssembler: function() {
        var assembler = Label._assembler.getAssembler(this);
        if (this._assembler !== assembler) {
          this._assembler = assembler;
          this._renderData = null;
        }
        this._renderData || (this._renderData = this._assembler.createData(this));
      },
      _activateMaterial: function(force) {
        var material = this._material;
        if (material && !force) return;
        var font = this.font;
        if (font instanceof cc.BitmapFont) {
          var spriteFrame = font.spriteFrame;
          if (!spriteFrame || !spriteFrame.textureLoaded()) {
            this.disableRender();
            if (spriteFrame) {
              spriteFrame.once("load", this._activateMaterial, this);
              spriteFrame.ensureLoadTexture();
            }
            return;
          }
          this._texture = spriteFrame._texture;
        } else {
          if (!this._ttfTexture) {
            this._ttfTexture = new cc.Texture2D();
            true;
            this._ttfTexture.setPremultiplyAlpha(true);
            this._assemblerData = this._assembler._getAssemblerData();
            this._ttfTexture.initWithElement(this._assemblerData.canvas);
          }
          this._texture = this._ttfTexture;
        }
        if (cc.game.renderType === cc.game.RENDER_TYPE_CANVAS) this._texture.url = this.uuid + "_texture"; else {
          material || (material = new SpriteMaterial());
          this._texture === this._ttfTexture ? this._srcBlendFactor = cc.macro.BlendFactor.ONE : this._srcBlendFactor = cc.macro.BlendFactor.SRC_ALPHA;
          material.texture = this._texture;
          this._updateMaterial(material);
        }
        this.markForUpdateRenderData(true);
        this.markForRender(true);
      },
      _updateColor: function() {
        var font = this.font;
        if (font instanceof cc.BitmapFont) this._super(); else {
          this._updateRenderData();
          this.node._renderFlag &= ~RenderFlow.FLAG_COLOR;
        }
      },
      _updateRenderData: function(force) {
        var renderData = this._renderData;
        if (renderData) {
          renderData.vertDirty = true;
          renderData.uvDirty = true;
          this.markForUpdateRenderData(true);
        }
        if (false, force) {
          this._updateAssembler();
          this._activateMaterial(force);
          this._assembler.updateRenderData(this);
        }
      },
      _enableBold: function(enabled) {
        this._isBold = !!enabled;
      },
      _enableItalics: function(enabled) {
        this._isItalic = !!enabled;
      },
      _enableUnderline: function(enabled) {
        this._isUnderline = !!enabled;
      }
    });
    cc.Label = module.exports = Label;
  }), {
    "../platform/CCMacro": 152,
    "../renderer/render-engine": 174,
    "../renderer/render-flow": 175,
    "./CCRenderComponent": 68
  } ],
  62: [ (function(require, module, exports) {
    var NodeEvent = require("../CCNode").EventType;
    var Type = cc.Enum({
      NONE: 0,
      HORIZONTAL: 1,
      VERTICAL: 2,
      GRID: 3
    });
    var ResizeMode = cc.Enum({
      NONE: 0,
      CONTAINER: 1,
      CHILDREN: 2
    });
    var AxisDirection = cc.Enum({
      HORIZONTAL: 0,
      VERTICAL: 1
    });
    var VerticalDirection = cc.Enum({
      BOTTOM_TO_TOP: 0,
      TOP_TO_BOTTOM: 1
    });
    var HorizontalDirection = cc.Enum({
      LEFT_TO_RIGHT: 0,
      RIGHT_TO_LEFT: 1
    });
    var Layout = cc.Class({
      name: "cc.Layout",
      extends: require("./CCComponent"),
      editor: false,
      properties: {
        _layoutSize: cc.size(300, 200),
        _layoutDirty: {
          default: true,
          serializable: false
        },
        _resize: ResizeMode.NONE,
        _N$layoutType: Type.NONE,
        type: {
          type: Type,
          get: function() {
            return this._N$layoutType;
          },
          set: function(value) {
            this._N$layoutType = value;
            var reLayouted;
            false;
            this._doLayoutDirty();
          },
          tooltip: false,
          animatable: false
        },
        resizeMode: {
          type: ResizeMode,
          tooltip: false,
          animatable: false,
          get: function() {
            return this._resize;
          },
          set: function(value) {
            if (this.type === Type.NONE && value === ResizeMode.CHILDREN) return;
            this._resize = value;
            var reLayouted;
            false;
            this._doLayoutDirty();
          }
        },
        cellSize: {
          default: cc.size(40, 40),
          tooltip: false,
          type: cc.Size,
          notify: function() {
            this._doLayoutDirty();
          }
        },
        startAxis: {
          default: AxisDirection.HORIZONTAL,
          tooltip: false,
          type: AxisDirection,
          notify: function() {
            var reLayouted;
            false;
            this._doLayoutDirty();
          },
          animatable: false
        },
        _N$padding: {
          default: 0
        },
        paddingLeft: {
          default: 0,
          tooltip: false,
          notify: function() {
            this._doLayoutDirty();
          }
        },
        paddingRight: {
          default: 0,
          tooltip: false,
          notify: function() {
            this._doLayoutDirty();
          }
        },
        paddingTop: {
          default: 0,
          tooltip: false,
          notify: function() {
            this._doLayoutDirty();
          }
        },
        paddingBottom: {
          default: 0,
          tooltip: false,
          notify: function() {
            this._doLayoutDirty();
          }
        },
        spacingX: {
          default: 0,
          notify: function() {
            this._doLayoutDirty();
          },
          tooltip: false
        },
        spacingY: {
          default: 0,
          notify: function() {
            this._doLayoutDirty();
          },
          tooltip: false
        },
        verticalDirection: {
          default: VerticalDirection.TOP_TO_BOTTOM,
          type: VerticalDirection,
          notify: function() {
            this._doLayoutDirty();
          },
          tooltip: false,
          animatable: false
        },
        horizontalDirection: {
          default: HorizontalDirection.LEFT_TO_RIGHT,
          type: HorizontalDirection,
          notify: function() {
            this._doLayoutDirty();
          },
          tooltip: false,
          animatable: false
        }
      },
      statics: {
        Type: Type,
        VerticalDirection: VerticalDirection,
        HorizontalDirection: HorizontalDirection,
        ResizeMode: ResizeMode,
        AxisDirection: AxisDirection
      },
      _migratePaddingData: function() {
        this.paddingLeft = this._N$padding;
        this.paddingRight = this._N$padding;
        this.paddingTop = this._N$padding;
        this.paddingBottom = this._N$padding;
        this._N$padding = 0;
      },
      onEnable: function() {
        this._addEventListeners();
        this.node.getContentSize().equals(cc.size(0, 0)) && this.node.setContentSize(this._layoutSize);
        0 !== this._N$padding && this._migratePaddingData();
        this._doLayoutDirty();
      },
      onDisable: function() {
        this._removeEventListeners();
      },
      _doLayoutDirty: function() {
        this._layoutDirty = true;
      },
      _addEventListeners: function() {
        cc.director.on(cc.Director.EVENT_AFTER_UPDATE, this.updateLayout, this);
        this.node.on(NodeEvent.SIZE_CHANGED, this._resized, this);
        this.node.on(NodeEvent.ANCHOR_CHANGED, this._doLayoutDirty, this);
        this.node.on(NodeEvent.CHILD_ADDED, this._childAdded, this);
        this.node.on(NodeEvent.CHILD_REMOVED, this._childRemoved, this);
        this.node.on(NodeEvent.CHILD_REORDER, this._doLayoutDirty, this);
        this._addChildrenEventListeners();
      },
      _removeEventListeners: function() {
        cc.director.off(cc.Director.EVENT_AFTER_UPDATE, this.updateLayout, this);
        this.node.off(NodeEvent.SIZE_CHANGED, this._resized, this);
        this.node.off(NodeEvent.ANCHOR_CHANGED, this._doLayoutDirty, this);
        this.node.off(NodeEvent.CHILD_ADDED, this._childAdded, this);
        this.node.off(NodeEvent.CHILD_REMOVED, this._childRemoved, this);
        this.node.off(NodeEvent.CHILD_REORDER, this._doLayoutDirty, this);
        this._removeChildrenEventListeners();
      },
      _addChildrenEventListeners: function() {
        var children = this.node.children;
        for (var i = 0; i < children.length; ++i) {
          var child = children[i];
          child.on(NodeEvent.SIZE_CHANGED, this._doLayoutDirty, this);
          child.on(NodeEvent.POSITION_CHANGED, this._doLayoutDirty, this);
          child.on(NodeEvent.ANCHOR_CHANGED, this._doLayoutDirty, this);
          child.on("active-in-hierarchy-changed", this._doLayoutDirty, this);
        }
      },
      _removeChildrenEventListeners: function() {
        var children = this.node.children;
        for (var i = 0; i < children.length; ++i) {
          var child = children[i];
          child.off(NodeEvent.SIZE_CHANGED, this._doLayoutDirty, this);
          child.off(NodeEvent.POSITION_CHANGED, this._doLayoutDirty, this);
          child.off(NodeEvent.ANCHOR_CHANGED, this._doLayoutDirty, this);
          child.off("active-in-hierarchy-changed", this._doLayoutDirty, this);
        }
      },
      _childAdded: function(child) {
        child.on(NodeEvent.SIZE_CHANGED, this._doLayoutDirty, this);
        child.on(NodeEvent.POSITION_CHANGED, this._doLayoutDirty, this);
        child.on(NodeEvent.ANCHOR_CHANGED, this._doLayoutDirty, this);
        child.on("active-in-hierarchy-changed", this._doLayoutDirty, this);
        this._doLayoutDirty();
      },
      _childRemoved: function(child) {
        child.off(NodeEvent.SIZE_CHANGED, this._doLayoutDirty, this);
        child.off(NodeEvent.POSITION_CHANGED, this._doLayoutDirty, this);
        child.off(NodeEvent.ANCHOR_CHANGED, this._doLayoutDirty, this);
        child.off("active-in-hierarchy-changed", this._doLayoutDirty, this);
        this._doLayoutDirty();
      },
      _resized: function() {
        this._layoutSize = this.node.getContentSize();
        this._doLayoutDirty();
      },
      _doLayoutHorizontally: function(baseWidth, rowBreak, fnPositionY, applyChildren) {
        var layoutAnchor = this.node.getAnchorPoint();
        var children = this.node.children;
        var sign = 1;
        var paddingX = this.paddingLeft;
        var leftBoundaryOfLayout = -layoutAnchor.x * baseWidth;
        if (this.horizontalDirection === HorizontalDirection.RIGHT_TO_LEFT) {
          sign = -1;
          leftBoundaryOfLayout = (1 - layoutAnchor.x) * baseWidth;
          paddingX = this.paddingRight;
        }
        var nextX = leftBoundaryOfLayout + sign * paddingX - sign * this.spacingX;
        var rowMaxHeight = 0;
        var tempMaxHeight = 0;
        var secondMaxHeight = 0;
        var row = 0;
        var containerResizeBoundary = 0;
        var maxHeightChildAnchorY = 0;
        var activeChildCount = 0;
        for (var i = 0; i < children.length; ++i) {
          var child = children[i];
          child.activeInHierarchy && activeChildCount++;
        }
        var newChildWidth = this.cellSize.width;
        this.type !== Type.GRID && this.resizeMode === ResizeMode.CHILDREN && (newChildWidth = (baseWidth - (this.paddingLeft + this.paddingRight) - (activeChildCount - 1) * this.spacingX) / activeChildCount);
        for (var i = 0; i < children.length; ++i) {
          var child = children[i];
          if (!child.activeInHierarchy) continue;
          if (this._resize === ResizeMode.CHILDREN) {
            child.width = newChildWidth / child.scaleX;
            this.type === Type.GRID && (child.height = this.cellSize.height / child.scaleY);
          }
          var anchorX = child.anchorX;
          var childBoundingBoxWidth = child.width * child.scaleX;
          var childBoundingBoxHeight = child.height * child.scaleY;
          secondMaxHeight > tempMaxHeight && (tempMaxHeight = secondMaxHeight);
          if (childBoundingBoxHeight >= tempMaxHeight) {
            secondMaxHeight = tempMaxHeight;
            tempMaxHeight = childBoundingBoxHeight;
            maxHeightChildAnchorY = child.getAnchorPoint().y;
          }
          this.horizontalDirection === HorizontalDirection.RIGHT_TO_LEFT && (anchorX = 1 - child.anchorX);
          nextX = nextX + sign * anchorX * childBoundingBoxWidth + sign * this.spacingX;
          var rightBoundaryOfChild = sign * (1 - anchorX) * childBoundingBoxWidth;
          if (rowBreak) {
            var rowBreakBoundary = nextX + rightBoundaryOfChild + sign * (sign > 0 ? this.paddingRight : this.paddingLeft);
            var leftToRightRowBreak = this.horizontalDirection === HorizontalDirection.LEFT_TO_RIGHT && rowBreakBoundary > (1 - layoutAnchor.x) * baseWidth;
            var rightToLeftRowBreak = this.horizontalDirection === HorizontalDirection.RIGHT_TO_LEFT && rowBreakBoundary < -layoutAnchor.x * baseWidth;
            if (leftToRightRowBreak || rightToLeftRowBreak) {
              if (childBoundingBoxHeight >= tempMaxHeight) {
                0 === secondMaxHeight && (secondMaxHeight = tempMaxHeight);
                rowMaxHeight += secondMaxHeight;
                secondMaxHeight = tempMaxHeight;
              } else {
                rowMaxHeight += tempMaxHeight;
                secondMaxHeight = childBoundingBoxHeight;
                tempMaxHeight = 0;
              }
              nextX = leftBoundaryOfLayout + sign * (paddingX + anchorX * childBoundingBoxWidth);
              row++;
            }
          }
          var finalPositionY = fnPositionY(child, rowMaxHeight, row);
          baseWidth >= childBoundingBoxWidth + this.paddingLeft + this.paddingRight && applyChildren && child.setPosition(cc.v2(nextX, finalPositionY));
          var signX = 1;
          var tempFinalPositionY;
          var topMarign = 0 === tempMaxHeight ? childBoundingBoxHeight : tempMaxHeight;
          if (this.verticalDirection === VerticalDirection.TOP_TO_BOTTOM) {
            containerResizeBoundary = containerResizeBoundary || this.node._contentSize.height;
            signX = -1;
            tempFinalPositionY = finalPositionY + signX * (topMarign * maxHeightChildAnchorY + this.paddingBottom);
            tempFinalPositionY < containerResizeBoundary && (containerResizeBoundary = tempFinalPositionY);
          } else {
            containerResizeBoundary = containerResizeBoundary || -this.node._contentSize.height;
            tempFinalPositionY = finalPositionY + signX * (topMarign * maxHeightChildAnchorY + this.paddingTop);
            tempFinalPositionY > containerResizeBoundary && (containerResizeBoundary = tempFinalPositionY);
          }
          nextX += rightBoundaryOfChild;
        }
        return containerResizeBoundary;
      },
      _getVerticalBaseHeight: function(children) {
        var newHeight = 0;
        var activeChildCount = 0;
        if (this.resizeMode === ResizeMode.CONTAINER) {
          for (var i = 0; i < children.length; ++i) {
            var child = children[i];
            if (child.activeInHierarchy) {
              activeChildCount++;
              newHeight += child.height * child.scaleY;
            }
          }
          newHeight += (activeChildCount - 1) * this.spacingY + this.paddingBottom + this.paddingTop;
        } else newHeight = this.node.getContentSize().height;
        return newHeight;
      },
      _doLayoutVertically: function(baseHeight, columnBreak, fnPositionX, applyChildren) {
        var layoutAnchor = this.node.getAnchorPoint();
        var children = this.node.children;
        var sign = 1;
        var paddingY = this.paddingBottom;
        var bottomBoundaryOfLayout = -layoutAnchor.y * baseHeight;
        if (this.verticalDirection === VerticalDirection.TOP_TO_BOTTOM) {
          sign = -1;
          bottomBoundaryOfLayout = (1 - layoutAnchor.y) * baseHeight;
          paddingY = this.paddingTop;
        }
        var nextY = bottomBoundaryOfLayout + sign * paddingY - sign * this.spacingY;
        var columnMaxWidth = 0;
        var tempMaxWidth = 0;
        var secondMaxWidth = 0;
        var column = 0;
        var containerResizeBoundary = 0;
        var maxWidthChildAnchorX = 0;
        var activeChildCount = 0;
        for (var i = 0; i < children.length; ++i) {
          var child = children[i];
          child.activeInHierarchy && activeChildCount++;
        }
        var newChildHeight = this.cellSize.height;
        this.type !== Type.GRID && this.resizeMode === ResizeMode.CHILDREN && (newChildHeight = (baseHeight - (this.paddingTop + this.paddingBottom) - (activeChildCount - 1) * this.spacingY) / activeChildCount);
        for (var i = 0; i < children.length; ++i) {
          var child = children[i];
          if (!child.activeInHierarchy) continue;
          if (this.resizeMode === ResizeMode.CHILDREN) {
            child.height = newChildHeight / child.scaleY;
            this.type === Type.GRID && (child.width = this.cellSize.width / child.scaleX);
          }
          var anchorY = child.anchorY;
          var childBoundingBoxWidth = child.width * child.scaleX;
          var childBoundingBoxHeight = child.height * child.scaleY;
          secondMaxWidth > tempMaxWidth && (tempMaxWidth = secondMaxWidth);
          if (childBoundingBoxWidth >= tempMaxWidth) {
            secondMaxWidth = tempMaxWidth;
            tempMaxWidth = childBoundingBoxWidth;
            maxWidthChildAnchorX = child.getAnchorPoint().x;
          }
          this.verticalDirection === VerticalDirection.TOP_TO_BOTTOM && (anchorY = 1 - child.anchorY);
          nextY = nextY + sign * anchorY * childBoundingBoxHeight + sign * this.spacingY;
          var topBoundaryOfChild = sign * (1 - anchorY) * childBoundingBoxHeight;
          if (columnBreak) {
            var columnBreakBoundary = nextY + topBoundaryOfChild + sign * (sign > 0 ? this.paddingTop : this.paddingBottom);
            var bottomToTopColumnBreak = this.verticalDirection === VerticalDirection.BOTTOM_TO_TOP && columnBreakBoundary > (1 - layoutAnchor.y) * baseHeight;
            var topToBottomColumnBreak = this.verticalDirection === VerticalDirection.TOP_TO_BOTTOM && columnBreakBoundary < -layoutAnchor.y * baseHeight;
            if (bottomToTopColumnBreak || topToBottomColumnBreak) {
              if (childBoundingBoxWidth >= tempMaxWidth) {
                0 === secondMaxWidth && (secondMaxWidth = tempMaxWidth);
                columnMaxWidth += secondMaxWidth;
                secondMaxWidth = tempMaxWidth;
              } else {
                columnMaxWidth += tempMaxWidth;
                secondMaxWidth = childBoundingBoxWidth;
                tempMaxWidth = 0;
              }
              nextY = bottomBoundaryOfLayout + sign * (paddingY + anchorY * childBoundingBoxHeight);
              column++;
            }
          }
          var finalPositionX = fnPositionX(child, columnMaxWidth, column);
          baseHeight >= childBoundingBoxHeight + (this.paddingTop + this.paddingBottom) && applyChildren && child.setPosition(cc.v2(finalPositionX, nextY));
          var signX = 1;
          var tempFinalPositionX;
          var rightMarign = 0 === tempMaxWidth ? childBoundingBoxWidth : tempMaxWidth;
          if (this.horizontalDirection === HorizontalDirection.RIGHT_TO_LEFT) {
            signX = -1;
            containerResizeBoundary = containerResizeBoundary || this.node._contentSize.width;
            tempFinalPositionX = finalPositionX + signX * (rightMarign * maxWidthChildAnchorX + this.paddingLeft);
            tempFinalPositionX < containerResizeBoundary && (containerResizeBoundary = tempFinalPositionX);
          } else {
            containerResizeBoundary = containerResizeBoundary || -this.node._contentSize.width;
            tempFinalPositionX = finalPositionX + signX * (rightMarign * maxWidthChildAnchorX + this.paddingRight);
            tempFinalPositionX > containerResizeBoundary && (containerResizeBoundary = tempFinalPositionX);
          }
          nextY += topBoundaryOfChild;
        }
        return containerResizeBoundary;
      },
      _doLayoutBasic: function() {
        var children = this.node.children;
        var allChildrenBoundingBox = null;
        for (var i = 0; i < children.length; ++i) {
          var child = children[i];
          child.activeInHierarchy && (allChildrenBoundingBox ? allChildrenBoundingBox.union(allChildrenBoundingBox, child.getBoundingBoxToWorld()) : allChildrenBoundingBox = child.getBoundingBoxToWorld());
        }
        if (allChildrenBoundingBox) {
          var leftBottomInParentSpace = this.node.parent.convertToNodeSpaceAR(cc.v2(allChildrenBoundingBox.x, allChildrenBoundingBox.y));
          leftBottomInParentSpace = cc.v2(leftBottomInParentSpace.x - this.paddingLeft, leftBottomInParentSpace.y - this.paddingBottom);
          var rightTopInParentSpace = this.node.parent.convertToNodeSpaceAR(cc.v2(allChildrenBoundingBox.x + allChildrenBoundingBox.width, allChildrenBoundingBox.y + allChildrenBoundingBox.height));
          rightTopInParentSpace = cc.v2(rightTopInParentSpace.x + this.paddingRight, rightTopInParentSpace.y + this.paddingTop);
          var newSize = cc.size(parseFloat((rightTopInParentSpace.x - leftBottomInParentSpace.x).toFixed(2)), parseFloat((rightTopInParentSpace.y - leftBottomInParentSpace.y).toFixed(2)));
          var layoutPosition = this.node.getPosition();
          var newAnchorX = (layoutPosition.x - leftBottomInParentSpace.x) / newSize.width;
          var newAnchorY = (layoutPosition.y - leftBottomInParentSpace.y) / newSize.height;
          var newAnchor = cc.v2(parseFloat(newAnchorX.toFixed(2)), parseFloat(newAnchorY.toFixed(2)));
          this.node.setAnchorPoint(newAnchor);
          this.node.setContentSize(newSize);
        }
      },
      _doLayoutGridAxisHorizontal: function(layoutAnchor, layoutSize) {
        var baseWidth = layoutSize.width;
        var sign = 1;
        var bottomBoundaryOfLayout = -layoutAnchor.y * layoutSize.height;
        var paddingY = this.paddingBottom;
        if (this.verticalDirection === VerticalDirection.TOP_TO_BOTTOM) {
          sign = -1;
          bottomBoundaryOfLayout = (1 - layoutAnchor.y) * layoutSize.height;
          paddingY = this.paddingTop;
        }
        var fnPositionY = function(child, topOffset, row) {
          return bottomBoundaryOfLayout + sign * (topOffset + child.anchorY * child.height * child.scaleY + paddingY + row * this.spacingY);
        }.bind(this);
        var newHeight = 0;
        if (this.resizeMode === ResizeMode.CONTAINER) {
          var boundary = this._doLayoutHorizontally(baseWidth, true, fnPositionY, false);
          newHeight = bottomBoundaryOfLayout - boundary;
          newHeight < 0 && (newHeight *= -1);
          bottomBoundaryOfLayout = -layoutAnchor.y * newHeight;
          if (this.verticalDirection === VerticalDirection.TOP_TO_BOTTOM) {
            sign = -1;
            bottomBoundaryOfLayout = (1 - layoutAnchor.y) * newHeight;
          }
        }
        this._doLayoutHorizontally(baseWidth, true, fnPositionY, true);
        this.resizeMode === ResizeMode.CONTAINER && this.node.setContentSize(baseWidth, newHeight);
      },
      _doLayoutGridAxisVertical: function(layoutAnchor, layoutSize) {
        var baseHeight = layoutSize.height;
        var sign = 1;
        var leftBoundaryOfLayout = -layoutAnchor.x * layoutSize.width;
        var paddingX = this.paddingLeft;
        if (this.horizontalDirection === HorizontalDirection.RIGHT_TO_LEFT) {
          sign = -1;
          leftBoundaryOfLayout = (1 - layoutAnchor.x) * layoutSize.width;
          paddingX = this.paddingRight;
        }
        var fnPositionX = function(child, leftOffset, column) {
          return leftBoundaryOfLayout + sign * (leftOffset + child.anchorX * child.width * child.scaleX + paddingX + column * this.spacingX);
        }.bind(this);
        var newWidth = 0;
        if (this.resizeMode === ResizeMode.CONTAINER) {
          var boundary = this._doLayoutVertically(baseHeight, true, fnPositionX, false);
          newWidth = leftBoundaryOfLayout - boundary;
          newWidth < 0 && (newWidth *= -1);
          leftBoundaryOfLayout = -layoutAnchor.x * newWidth;
          if (this.horizontalDirection === HorizontalDirection.RIGHT_TO_LEFT) {
            sign = -1;
            leftBoundaryOfLayout = (1 - layoutAnchor.x) * newWidth;
          }
        }
        this._doLayoutVertically(baseHeight, true, fnPositionX, true);
        this.resizeMode === ResizeMode.CONTAINER && this.node.setContentSize(newWidth, baseHeight);
      },
      _doLayoutGrid: function() {
        var layoutAnchor = this.node.getAnchorPoint();
        var layoutSize = this.node.getContentSize();
        this.startAxis === AxisDirection.HORIZONTAL ? this._doLayoutGridAxisHorizontal(layoutAnchor, layoutSize) : this.startAxis === AxisDirection.VERTICAL && this._doLayoutGridAxisVertical(layoutAnchor, layoutSize);
      },
      _getHorizontalBaseWidth: function(children) {
        var newWidth = 0;
        var activeChildCount = 0;
        if (this.resizeMode === ResizeMode.CONTAINER) {
          for (var i = 0; i < children.length; ++i) {
            var child = children[i];
            if (child.activeInHierarchy) {
              activeChildCount++;
              newWidth += child.width * child.scaleX;
            }
          }
          newWidth += (activeChildCount - 1) * this.spacingX + this.paddingLeft + this.paddingRight;
        } else newWidth = this.node.getContentSize().width;
        return newWidth;
      },
      _doLayout: function() {
        if (this.type === Type.HORIZONTAL) {
          var newWidth = this._getHorizontalBaseWidth(this.node.children);
          var fnPositionY = function(child) {
            return child.y;
          };
          this._doLayoutHorizontally(newWidth, false, fnPositionY, true);
          this.node.width = newWidth;
        } else if (this.type === Type.VERTICAL) {
          var newHeight = this._getVerticalBaseHeight(this.node.children);
          var fnPositionX = function(child) {
            return child.x;
          };
          this._doLayoutVertically(newHeight, false, fnPositionX, true);
          this.node.height = newHeight;
        } else this.type === Type.NONE ? this.resizeMode === ResizeMode.CONTAINER && this._doLayoutBasic() : this.type === Type.GRID && this._doLayoutGrid();
      },
      updateLayout: function() {
        if (this._layoutDirty && this.node.children.length > 0) {
          this._doLayout();
          this._layoutDirty = false;
        }
      }
    });
    Object.defineProperty(Layout.prototype, "padding", {
      get: function() {
        cc.warnID(4100);
        return this.paddingLeft;
      },
      set: function(value) {
        this._N$padding = value;
        this._migratePaddingData();
        this._doLayoutDirty();
      }
    });
    cc.Layout = module.exports = Layout;
  }), {
    "../CCNode": 25,
    "./CCComponent": 59
  } ],
  63: [ (function(require, module, exports) {
    var misc = require("../utils/misc");
    var renderEngine = require("../renderer/render-engine");
    var math = renderEngine.math;
    var StencilMaterial = renderEngine.StencilMaterial;
    var RenderComponent = require("./CCRenderComponent");
    var RenderFlow = require("../renderer/render-flow");
    var Graphics = require("../graphics/graphics");
    var _vec2_temp = cc.v2();
    var _mat4_temp = math.mat4.create();
    var MaskType = cc.Enum({
      RECT: 0,
      ELLIPSE: 1,
      IMAGE_STENCIL: 2
    });
    var SEGEMENTS_MIN = 3;
    var SEGEMENTS_MAX = 1e4;
    var Mask = cc.Class({
      name: "cc.Mask",
      extends: RenderComponent,
      editor: false,
      properties: {
        _spriteFrame: {
          default: null,
          type: cc.SpriteFrame
        },
        _type: MaskType.RECT,
        type: {
          get: function() {
            return this._type;
          },
          set: function(value) {
            this._type = value;
            if (this._type !== MaskType.IMAGE_STENCIL) {
              this.spriteFrame = null;
              this.alphaThreshold = 0;
              this._updateGraphics();
            }
            if (this._renderData) {
              this.destroyRenderData(this._renderData);
              this._renderData = null;
            }
            this._activateMaterial();
          },
          type: MaskType,
          tooltip: false
        },
        spriteFrame: {
          type: cc.SpriteFrame,
          tooltip: false,
          get: function() {
            return this._spriteFrame;
          },
          set: function(value) {
            var lastSprite = this._spriteFrame;
            false;
            if (lastSprite === value) return;
            this._spriteFrame = value;
            this._applySpriteFrame(lastSprite);
          }
        },
        alphaThreshold: {
          default: 0,
          type: cc.Float,
          range: [ 0, 1, .1 ],
          slide: true,
          tooltip: false,
          notify: function() {
            if (cc.game.renderType === cc.game.RENDER_TYPE_CANVAS) {
              cc.warnID(4201);
              return;
            }
            if (this._frontMaterial) {
              this._frontMaterial.alphaThreshold = this.alphaThreshold;
              this._endMaterial.alphaThreshold = this.alphaThreshold;
              this._frontMaterial.updateHash();
              this._endMaterial._hash = -this._frontMaterial._hash;
            }
          }
        },
        inverted: {
          default: false,
          type: cc.Boolean,
          tooltip: false,
          notify: function() {
            if (cc.game.renderType === cc.game.RENDER_TYPE_CANVAS) {
              cc.warnID(4202);
              return;
            }
          }
        },
        _segments: 64,
        segements: {
          get: function() {
            return this._segments;
          },
          set: function(value) {
            this._segments = misc.clampf(value, SEGEMENTS_MIN, SEGEMENTS_MAX);
          },
          tooltip: false
        },
        _resizeToTarget: {
          animatable: false,
          set: function(value) {
            value && this._resizeNodeToTargetNode();
          }
        }
      },
      statics: {
        Type: MaskType
      },
      onLoad: function() {
        this._graphics = new Graphics();
        this._graphics.node = this.node;
        this._graphics.lineWidth = 0;
        this._graphics.strokeColor = cc.color(0, 0, 0, 0);
      },
      onRestore: function() {
        if (!this._graphics) {
          this._graphics = new Graphics();
          this._graphics.node = this.node;
          this._graphics.lineWidth = 0;
        }
        this._type !== MaskType.IMAGE_STENCIL && this._updateGraphics();
      },
      onEnable: function() {
        this._super();
        if (this._type === MaskType.IMAGE_STENCIL) {
          if (!this._spriteFrame || !this._spriteFrame.textureLoaded()) {
            this.markForRender(false);
            if (this._spriteFrame) {
              this._spriteFrame.once("load", this._onTextureLoaded, this);
              this._spriteFrame.ensureLoadTexture();
            }
          }
        } else this._updateGraphics();
        this.node.on(cc.Node.EventType.POSITION_CHANGED, this._updateGraphics, this);
        this.node.on(cc.Node.EventType.ROTATION_CHANGED, this._updateGraphics, this);
        this.node.on(cc.Node.EventType.SCALE_CHANGED, this._updateGraphics, this);
        this.node.on(cc.Node.EventType.SIZE_CHANGED, this._updateGraphics, this);
        this.node.on(cc.Node.EventType.ANCHOR_CHANGED, this._updateGraphics, this);
        this.node._renderFlag |= RenderFlow.FLAG_POST_RENDER | RenderFlow.FLAG_POST_UPDATE_RENDER_DATA;
        this._activateMaterial();
      },
      onDisable: function() {
        this._super();
        this.node.off(cc.Node.EventType.POSITION_CHANGED, this._updateGraphics, this);
        this.node.off(cc.Node.EventType.ROTATION_CHANGED, this._updateGraphics, this);
        this.node.off(cc.Node.EventType.SCALE_CHANGED, this._updateGraphics, this);
        this.node.off(cc.Node.EventType.SIZE_CHANGED, this._updateGraphics, this);
        this.node.off(cc.Node.EventType.ANCHOR_CHANGED, this._updateGraphics, this);
        this.node._renderFlag &= ~(RenderFlow.FLAG_POST_RENDER | RenderFlow.FLAG_POST_UPDATE_RENDER_DATA);
      },
      onDestroy: function() {
        this._super();
        this._graphics.destroy();
        this._frontMaterial = null;
        this._endMaterial = null;
      },
      _resizeNodeToTargetNode: false,
      _onTextureLoaded: function() {
        if (this._renderData) {
          this._renderData.uvDirty = true;
          this._renderData.vertDirty = true;
          this.markForUpdateRenderData(true);
        }
        this.enabledInHierarchy && this._activateMaterial();
      },
      _applySpriteFrame: function(oldFrame) {
        oldFrame && oldFrame.off && oldFrame.off("load", this._onTextureLoaded, this);
        var spriteFrame = this._spriteFrame;
        if (spriteFrame) if (spriteFrame.textureLoaded()) this._onTextureLoaded(null); else {
          spriteFrame.once("load", this._onTextureLoaded, this);
          spriteFrame.ensureLoadTexture();
        }
      },
      _activateMaterial: function() {
        if (this._type === MaskType.IMAGE_STENCIL && (!this.spriteFrame || !this.spriteFrame.textureLoaded())) {
          this.markForRender(false);
          return;
        }
        if (cc.game.renderType !== cc.game.RENDER_TYPE_CANVAS) {
          if (!this._frontMaterial) {
            this._frontMaterial = new StencilMaterial();
            this._endMaterial = new StencilMaterial();
          }
          if (this._type === MaskType.IMAGE_STENCIL) {
            var texture = this.spriteFrame.getTexture();
            this._frontMaterial.useModel = false;
            this._frontMaterial.useTexture = true;
            this._frontMaterial.useColor = true;
            this._frontMaterial.texture = texture;
            this._frontMaterial.alphaThreshold = this.alphaThreshold;
            this._endMaterial.useModel = false;
            this._endMaterial.useTexture = true;
            this._endMaterial.useColor = true;
            this._endMaterial.texture = texture;
            this._endMaterial.alphaThreshold = this.alphaThreshold;
          } else {
            this._frontMaterial.useModel = true;
            this._frontMaterial.useTexture = false;
            this._frontMaterial.useColor = false;
            this._endMaterial.useModel = true;
            this._endMaterial.useTexture = false;
            this._endMaterial.useColor = false;
          }
          this._material || this._updateMaterial(this._frontMaterial);
          this._endMaterial._hash = -this._frontMaterial._hash;
        }
        this.markForRender(true);
      },
      _updateGraphics: function() {
        var node = this.node;
        var graphics = this._graphics;
        graphics.clear(false);
        var width = node._contentSize.width;
        var height = node._contentSize.height;
        var x = -width * node._anchorPoint.x;
        var y = -height * node._anchorPoint.y;
        if (this._type === MaskType.RECT) graphics.rect(x, y, width, height); else if (this._type === MaskType.ELLIPSE) {
          var cx = x + width / 2, cy = y + height / 2, rx = width / 2, ry = height / 2;
          graphics.ellipse(cx, cy, rx, ry);
        }
        cc.game.renderType === cc.game.RENDER_TYPE_CANVAS ? graphics.stroke() : graphics.fill();
      },
      _hitTest: function(cameraPt) {
        var node = this.node;
        var size = node.getContentSize(), w = size.width, h = size.height, testPt = _vec2_temp;
        node._updateWorldMatrix();
        math.mat4.invert(_mat4_temp, node._worldMatrix);
        math.vec2.transformMat4(testPt, cameraPt, _mat4_temp);
        testPt.x += node._anchorPoint.x * w;
        testPt.y += node._anchorPoint.y * h;
        if (this.type === MaskType.RECT || this.type === MaskType.IMAGE_STENCIL) return testPt.x >= 0 && testPt.y >= 0 && testPt.x <= w && testPt.y <= h;
        if (this.type === MaskType.ELLIPSE) {
          var rx = w / 2, ry = h / 2;
          var px = testPt.x - .5 * w, py = testPt.y - .5 * h;
          return px * px / (rx * rx) + py * py / (ry * ry) < 1;
        }
      },
      markForUpdateRenderData: function(enable) {
        enable && this.enabledInHierarchy ? this.node._renderFlag |= RenderFlow.FLAG_UPDATE_RENDER_DATA | RenderFlow.FLAG_POST_UPDATE_RENDER_DATA : enable || (this.node._renderFlag &= ~(RenderFlow.FLAG_UPDATE_RENDER_DATA | RenderFlow.FLAG_POST_UPDATE_RENDER_DATA));
      },
      markForRender: function(enable) {
        enable && this.enabledInHierarchy ? this.node._renderFlag |= RenderFlow.FLAG_RENDER | RenderFlow.FLAG_UPDATE_RENDER_DATA | RenderFlow.FLAG_POST_RENDER | RenderFlow.FLAG_POST_UPDATE_RENDER_DATA : enable || (this.node._renderFlag &= ~(RenderFlow.FLAG_RENDER | RenderFlow.FLAG_POST_RENDER));
      },
      disableRender: function() {
        this.node._renderFlag &= ~(RenderFlow.FLAG_RENDER | RenderFlow.FLAG_UPDATE_RENDER_DATA | RenderFlow.FLAG_POST_RENDER | RenderFlow.FLAG_POST_UPDATE_RENDER_DATA);
      }
    });
    cc.Mask = module.exports = Mask;
  }), {
    "../graphics/graphics": 95,
    "../renderer/render-engine": 174,
    "../renderer/render-flow": 175,
    "../utils/misc": 208,
    "./CCRenderComponent": 68
  } ],
  64: [ (function(require, module, exports) {
    var RenderComponent = require("../components/CCRenderComponent");
    var SpriteMaterial = require("../renderer/render-engine").SpriteMaterial;
    var MotionStreak = cc.Class({
      name: "cc.MotionStreak",
      extends: RenderComponent,
      editor: false,
      ctor: function() {
        this._points = [];
      },
      properties: {
        preview: {
          default: false,
          editorOnly: true,
          notify: false,
          animatable: false
        },
        _fadeTime: 1,
        fadeTime: {
          get: function() {
            return this._fadeTime;
          },
          set: function(value) {
            this._fadeTime = value;
            this.reset();
          },
          animatable: false,
          tooltip: false
        },
        _minSeg: 1,
        minSeg: {
          get: function() {
            return this._minSeg;
          },
          set: function(value) {
            this._minSeg = value;
          },
          animatable: false,
          tooltip: false
        },
        _stroke: 64,
        stroke: {
          get: function() {
            return this._stroke;
          },
          set: function(value) {
            this._stroke = value;
          },
          animatable: false,
          tooltip: false
        },
        _texture: {
          default: null,
          type: cc.Texture2D
        },
        texture: {
          get: function() {
            return this._texture;
          },
          set: function(value) {
            if (this._texture === value) return;
            this._texture = value;
            if (value) {
              this.markForRender(true);
              this.markForUpdateRenderData(true);
              this._activateMaterial(true);
            } else this.disableRender();
          },
          type: cc.Texture2D,
          animatable: false,
          tooltip: false
        },
        _color: cc.Color.WHITE,
        color: {
          get: function() {
            return this._color;
          },
          set: function(value) {
            this._color = value;
          },
          tooltip: false
        },
        _fastMode: false,
        fastMode: {
          get: function() {
            return this._fastMode;
          },
          set: function(value) {
            this._fastMode = value;
          },
          animatable: false,
          tooltip: false
        }
      },
      onEnable: function() {
        this._super();
        this._texture && this._texture.loaded ? this._activateMaterial() : this.disableRender();
        this.reset();
      },
      _activateMaterial: function(force) {
        var material = this._material;
        if (material) {
          if (!force) return;
        } else {
          material = this._material = new SpriteMaterial();
          material.useColor = false;
        }
        material.texture = this._texture;
        this._updateMaterial(material);
      },
      onFocusInEditor: false,
      onLostFocusInEditor: false,
      reset: function() {
        this._points.length = 0;
        var renderData = this._renderData;
        if (renderData) {
          renderData.dataLength = 0;
          renderData.vertexCount = 0;
          renderData.indiceCount = 0;
        }
        false;
      }
    });
    cc.MotionStreak = module.exports = MotionStreak;
  }), {
    "../components/CCRenderComponent": 68,
    "../renderer/render-engine": 174
  } ],
  65: [ (function(require, module, exports) {
    var SizeMode = cc.Enum({
      Unified: 0,
      Free: 1
    });
    var Direction = cc.Enum({
      Horizontal: 0,
      Vertical: 1
    });
    var EventType = cc.Enum({
      PAGE_TURNING: 0
    });
    var PageView = cc.Class({
      name: "cc.PageView",
      extends: cc.ScrollView,
      editor: false,
      ctor: function() {
        this._curPageIdx = 0;
        this._lastPageIdx = 0;
        this._pages = [];
        this._scrollCenterOffsetX = [];
        this._scrollCenterOffsetY = [];
      },
      properties: {
        sizeMode: {
          default: SizeMode.Unified,
          type: SizeMode,
          tooltip: false,
          notify: function() {
            this._syncSizeMode();
          }
        },
        direction: {
          default: Direction.Horizontal,
          type: Direction,
          tooltip: false,
          notify: function() {
            this._syncScrollDirection();
          }
        },
        scrollThreshold: {
          default: .5,
          type: cc.Float,
          slide: true,
          range: [ 0, 1, .01 ],
          tooltip: false
        },
        autoPageTurningThreshold: {
          default: 100,
          type: cc.Float,
          tooltip: false
        },
        pageTurningEventTiming: {
          default: .1,
          type: cc.Float,
          range: [ 0, 1, .01 ],
          tooltip: false
        },
        indicator: {
          default: null,
          type: cc.PageViewIndicator,
          tooltip: false,
          notify: function() {
            this.indicator && this.indicator.setPageView(this);
          }
        },
        pageTurningSpeed: {
          default: .3,
          type: cc.Float,
          tooltip: false
        },
        pageEvents: {
          default: [],
          type: cc.Component.EventHandler,
          tooltip: false
        }
      },
      statics: {
        SizeMode: SizeMode,
        Direction: Direction,
        EventType: EventType
      },
      __preload: function() {
        this.node.on(cc.Node.EventType.SIZE_CHANGED, this._updateAllPagesSize, this);
      },
      onEnable: function() {
        this._super();
        true;
        this.node.on("scroll-ended-with-threshold", this._dispatchPageTurningEvent, this);
      },
      onDisable: function() {
        this._super();
        true;
        this.node.off("scroll-ended-with-threshold", this._dispatchPageTurningEvent, this);
      },
      onLoad: function() {
        this._initPages();
        this.indicator && this.indicator.setPageView(this);
      },
      onDestroy: function() {
        this.node.off(cc.Node.EventType.SIZE_CHANGED, this._updateAllPagesSize, this);
      },
      getCurrentPageIndex: function() {
        return this._curPageIdx;
      },
      setCurrentPageIndex: function(index) {
        this.scrollToPage(index, true);
      },
      getPages: function() {
        return this._pages;
      },
      addPage: function(page) {
        if (!page || -1 !== this._pages.indexOf(page) || !this.content) return;
        this.content.addChild(page);
        this._pages.push(page);
        this._updatePageView();
      },
      insertPage: function(page, index) {
        if (index < 0 || !page || -1 !== this._pages.indexOf(page) || !this.content) return;
        var pageCount = this._pages.length;
        if (index >= pageCount) this.addPage(page); else {
          this._pages.splice(index, 0, page);
          this.content.addChild(page);
          this._updatePageView();
        }
      },
      removePage: function(page) {
        if (!page || !this.content) return;
        var index = this._pages.indexOf(page);
        if (-1 === index) {
          cc.warnID(4300, page.name);
          return;
        }
        this.removePageAtIndex(index);
      },
      removePageAtIndex: function(index) {
        var pageList = this._pages;
        if (index < 0 || index >= pageList.length) return;
        var page = pageList[index];
        if (!page) return;
        this.content.removeChild(page);
        pageList.splice(index, 1);
        this._updatePageView();
      },
      removeAllPages: function() {
        if (!this.content) return;
        var locPages = this._pages;
        for (var i = 0, len = locPages.length; i < len; i++) this.content.removeChild(locPages[i]);
        this._pages.length = 0;
        this._updatePageView();
      },
      scrollToPage: function(idx, timeInSecond) {
        if (idx < 0 || idx >= this._pages.length) return;
        timeInSecond = void 0 !== timeInSecond ? timeInSecond : .3;
        this._curPageIdx = idx;
        this.scrollToOffset(this._moveOffsetValue(idx), timeInSecond, true);
        this.indicator && this.indicator._changedState();
      },
      getScrollEndedEventTiming: function() {
        return this.pageTurningEventTiming;
      },
      _syncScrollDirection: function() {
        this.horizontal = this.direction === Direction.Horizontal;
        this.vertical = this.direction === Direction.Vertical;
      },
      _syncSizeMode: function() {
        if (!this.content) return;
        var layout = this.content.getComponent(cc.Layout);
        if (layout) {
          if (0 === this._pages.length) layout.padding = 0; else {
            var lastPage = this._pages[this._pages.length - 1];
            if (this.sizeMode === SizeMode.Free) if (this.direction === Direction.Horizontal) {
              layout.paddingLeft = (this.node.width - this._pages[0].width) / 2;
              layout.paddingRight = (this.node.width - lastPage.width) / 2;
            } else if (this.direction === Direction.Vertical) {
              layout.paddingTop = (this.node.height - this._pages[0].height) / 2;
              layout.paddingBottom = (this.node.height - lastPage.height) / 2;
            }
          }
          layout.updateLayout();
        }
      },
      _updatePageView: function() {
        var pageCount = this._pages.length;
        if (this._curPageIdx >= pageCount) {
          this._curPageIdx = 0 === pageCount ? 0 : pageCount - 1;
          this._lastPageIdx = this._curPageIdx;
        }
        for (var i = 0; i < pageCount; ++i) {
          this._pages[i].setSiblingIndex(i);
          this.direction === Direction.Horizontal ? this._scrollCenterOffsetX[i] = Math.abs(this.content.x + this._pages[i].x) : this._scrollCenterOffsetY[i] = Math.abs(this.content.y + this._pages[i].y);
        }
        var layout = this.content.getComponent(cc.Layout);
        layout && layout.enabled && layout.updateLayout();
        this.indicator && this.indicator._refresh();
      },
      _updateAllPagesSize: function() {
        if (this.sizeMode !== SizeMode.Unified) return;
        var locPages = this._pages;
        var selfSize = this.node.getContentSize();
        for (var i = 0, len = locPages.length; i < len; i++) locPages[i].setContentSize(selfSize);
      },
      _initPages: function() {
        if (!this.content) return;
        var children = this.content.children;
        for (var i = 0; i < children.length; ++i) {
          var page = children[i];
          if (this._pages.indexOf(page) >= 0) continue;
          this._pages.push(page);
        }
        this._syncScrollDirection();
        this._syncSizeMode();
        this._updatePageView();
      },
      _dispatchPageTurningEvent: function() {
        if (this._lastPageIdx === this._curPageIdx) return;
        this._lastPageIdx = this._curPageIdx;
        cc.Component.EventHandler.emitEvents(this.pageEvents, this, EventType.PAGE_TURNING);
        this.node.emit("page-turning", this);
      },
      _isScrollable: function(offset, index, nextIndex) {
        if (this.sizeMode === SizeMode.Free) {
          var curPageCenter, nextPageCenter;
          if (this.direction === Direction.Horizontal) {
            curPageCenter = this._scrollCenterOffsetX[index];
            nextPageCenter = this._scrollCenterOffsetX[nextIndex];
            return Math.abs(offset.x) >= Math.abs(curPageCenter - nextPageCenter) * this.scrollThreshold;
          }
          if (this.direction === Direction.Vertical) {
            curPageCenter = this._scrollCenterOffsetY[index];
            nextPageCenter = this._scrollCenterOffsetY[nextIndex];
            return Math.abs(offset.y) >= Math.abs(curPageCenter - nextPageCenter) * this.scrollThreshold;
          }
        } else {
          if (this.direction === Direction.Horizontal) return Math.abs(offset.x) >= this.node.width * this.scrollThreshold;
          if (this.direction === Direction.Vertical) return Math.abs(offset.y) >= this.node.height * this.scrollThreshold;
        }
      },
      _isQuicklyScrollable: function(touchMoveVelocity) {
        if (this.direction === Direction.Horizontal) {
          if (Math.abs(touchMoveVelocity.x) > this.autoPageTurningThreshold) return true;
        } else if (this.direction === Direction.Vertical && Math.abs(touchMoveVelocity.y) > this.autoPageTurningThreshold) return true;
        return false;
      },
      _moveOffsetValue: function(idx) {
        var offset = cc.v2(0, 0);
        this.sizeMode === SizeMode.Free ? this.direction === Direction.Horizontal ? offset.x = this._scrollCenterOffsetX[idx] : this.direction === Direction.Vertical && (offset.y = this._scrollCenterOffsetY[idx]) : this.direction === Direction.Horizontal ? offset.x = idx * this.node.width : this.direction === Direction.Vertical && (offset.y = idx * this.node.height);
        return offset;
      },
      _getDragDirection: function(moveOffset) {
        if (this.direction === Direction.Horizontal) {
          if (0 === moveOffset.x) return 0;
          return moveOffset.x > 0 ? 1 : -1;
        }
        if (this.direction === Direction.Vertical) {
          if (0 === moveOffset.y) return 0;
          return moveOffset.y < 0 ? 1 : -1;
        }
      },
      _handleReleaseLogic: function(touch) {
        var bounceBackStarted = this._startBounceBackIfNeeded();
        var moveOffset = this._touchBeganPosition.sub(this._touchEndPosition);
        if (bounceBackStarted) {
          var dragDirection = this._getDragDirection(moveOffset);
          if (0 === dragDirection) return;
          this._curPageIdx = dragDirection > 0 ? this._pages.length - 1 : 0;
          this.indicator && this.indicator._changedState();
        } else {
          var index = this._curPageIdx, nextIndex = index + this._getDragDirection(moveOffset);
          var timeInSecond = this.pageTurningSpeed * Math.abs(index - nextIndex);
          if (nextIndex < this._pages.length) {
            if (this._isScrollable(moveOffset, index, nextIndex)) {
              this.scrollToPage(nextIndex, timeInSecond);
              return;
            }
            var touchMoveVelocity = this._calculateTouchMoveVelocity();
            if (this._isQuicklyScrollable(touchMoveVelocity)) {
              this.scrollToPage(nextIndex, timeInSecond);
              return;
            }
          }
          this.scrollToPage(index, timeInSecond);
        }
      },
      _onTouchBegan: function(event, captureListeners) {
        this._touchBeganPosition = event.touch.getLocation();
        this._super(event, captureListeners);
      },
      _onTouchMoved: function(event, captureListeners) {
        this._super(event, captureListeners);
      },
      _onTouchEnded: function(event, captureListeners) {
        this._touchEndPosition = event.touch.getLocation();
        this._super(event, captureListeners);
      },
      _onTouchCancelled: function(event, captureListeners) {
        this._touchEndPosition = event.touch.getLocation();
        this._super(event, captureListeners);
      },
      _onMouseWheel: function() {}
    });
    cc.PageView = module.exports = PageView;
  }), {} ],
  66: [ (function(require, module, exports) {
    var Direction = cc.Enum({
      HORIZONTAL: 0,
      VERTICAL: 1
    });
    var PageViewIndicator = cc.Class({
      name: "cc.PageViewIndicator",
      extends: require("./CCComponent"),
      editor: false,
      properties: {
        _layout: null,
        _pageView: null,
        _indicators: [],
        spriteFrame: {
          default: null,
          type: cc.SpriteFrame,
          tooltip: false
        },
        direction: {
          default: Direction.HORIZONTAL,
          type: Direction,
          tooltip: false
        },
        cellSize: {
          default: cc.size(20, 20),
          tooltip: false
        },
        spacing: {
          default: 0,
          tooltip: false
        }
      },
      statics: {
        Direction: Direction
      },
      onLoad: function() {
        this._updateLayout();
      },
      setPageView: function(target) {
        this._pageView = target;
        this._refresh();
      },
      _updateLayout: function() {
        this._layout = this.getComponent(cc.Layout);
        this._layout || (this._layout = this.addComponent(cc.Layout));
        if (this.direction === Direction.HORIZONTAL) {
          this._layout.type = cc.Layout.Type.HORIZONTAL;
          this._layout.spacingX = this.spacing;
        } else if (this.direction === Direction.VERTICAL) {
          this._layout.type = cc.Layout.Type.VERTICAL;
          this._layout.spacingY = this.spacing;
        }
        this._layout.resizeMode = cc.Layout.ResizeMode.CONTAINER;
      },
      _createIndicator: function() {
        var node = new cc.Node();
        var sprite = node.addComponent(cc.Sprite);
        sprite.spriteFrame = this.spriteFrame;
        node.parent = this.node;
        node.width = this.cellSize.width;
        node.height = this.cellSize.height;
        return node;
      },
      _changedState: function() {
        var indicators = this._indicators;
        if (0 === indicators.length) return;
        var idx = this._pageView._curPageIdx;
        if (idx >= indicators.length) return;
        for (var i = 0; i < indicators.length; ++i) {
          var node = indicators[i];
          node.opacity = 127.5;
        }
        indicators[idx].opacity = 255;
      },
      _refresh: function() {
        if (!this._pageView) return;
        var indicators = this._indicators;
        var pages = this._pageView.getPages();
        if (pages.length === indicators.length) return;
        var i = 0;
        if (pages.length > indicators.length) for (i = 0; i < pages.length; ++i) indicators[i] || (indicators[i] = this._createIndicator()); else {
          var count = indicators.length - pages.length;
          for (i = count; i > 0; --i) {
            var node = indicators[i - 1];
            this.node.removeChild(node);
            indicators.splice(i - 1, 1);
          }
        }
        this._layout && this._layout.enabledInHierarchy && this._layout.updateLayout();
        this._changedState();
      }
    });
    cc.PageViewIndicator = module.exports = PageViewIndicator;
  }), {
    "./CCComponent": 59
  } ],
  67: [ (function(require, module, exports) {
    var misc = require("../utils/misc");
    var Component = require("./CCComponent");
    var Mode = cc.Enum({
      HORIZONTAL: 0,
      VERTICAL: 1,
      FILLED: 2
    });
    var ProgressBar = cc.Class({
      name: "cc.ProgressBar",
      extends: Component,
      editor: false,
      _initBarSprite: function() {
        if (this.barSprite) {
          var entity = this.barSprite.node;
          if (!entity) return;
          var nodeSize = this.node.getContentSize();
          var nodeAnchor = this.node.getAnchorPoint();
          var entitySize = entity.getContentSize();
          entity.parent === this.node && this.node.setContentSize(entitySize);
          this.barSprite.fillType === cc.Sprite.FillType.RADIAL && (this.mode = Mode.FILLED);
          var barSpriteSize = entity.getContentSize();
          this.mode === Mode.HORIZONTAL ? this.totalLength = barSpriteSize.width : this.mode === Mode.VERTICAL ? this.totalLength = barSpriteSize.height : this.totalLength = this.barSprite.fillRange;
          if (entity.parent === this.node) {
            var x = -nodeSize.width * nodeAnchor.x;
            var y = 0;
            entity.setPosition(cc.v2(x, y));
          }
        }
      },
      _updateBarStatus: function() {
        if (this.barSprite) {
          var entity = this.barSprite.node;
          if (!entity) return;
          var entityAnchorPoint = entity.getAnchorPoint();
          var entitySize = entity.getContentSize();
          var entityPosition = entity.getPosition();
          var anchorPoint = cc.v2(0, .5);
          var progress = misc.clamp01(this.progress);
          var actualLenth = this.totalLength * progress;
          var finalContentSize;
          var totalWidth;
          var totalHeight;
          switch (this.mode) {
           case Mode.HORIZONTAL:
            this.reverse && (anchorPoint = cc.v2(1, .5));
            finalContentSize = cc.size(actualLenth, entitySize.height);
            totalWidth = this.totalLength;
            totalHeight = entitySize.height;
            break;

           case Mode.VERTICAL:
            anchorPoint = this.reverse ? cc.v2(.5, 1) : cc.v2(.5, 0);
            finalContentSize = cc.size(entitySize.width, actualLenth);
            totalWidth = entitySize.width;
            totalHeight = this.totalLength;
          }
          if (this.mode === Mode.FILLED) if (this.barSprite.type !== cc.Sprite.Type.FILLED) cc.warn("ProgressBar FILLED mode only works when barSprite's Type is FILLED!"); else {
            this.reverse && (actualLenth *= -1);
            this.barSprite.fillRange = actualLenth;
          } else if (this.barSprite.type !== cc.Sprite.Type.FILLED) {
            var anchorOffsetX = anchorPoint.x - entityAnchorPoint.x;
            var anchorOffsetY = anchorPoint.y - entityAnchorPoint.y;
            var finalPosition = cc.v2(totalWidth * anchorOffsetX, totalHeight * anchorOffsetY);
            entity.setPosition(entityPosition.x + finalPosition.x, entityPosition.y + finalPosition.y);
            entity.setAnchorPoint(anchorPoint);
            entity.setContentSize(finalContentSize);
          } else cc.warn("ProgressBar non-FILLED mode only works when barSprite's Type is non-FILLED!");
        }
      },
      properties: {
        barSprite: {
          default: null,
          type: cc.Sprite,
          tooltip: false,
          notify: function() {
            this._initBarSprite();
          },
          animatable: false
        },
        mode: {
          default: Mode.HORIZONTAL,
          type: Mode,
          tooltip: false,
          notify: function() {
            if (this.barSprite) {
              var entity = this.barSprite.node;
              if (!entity) return;
              var entitySize = entity.getContentSize();
              this.mode === Mode.HORIZONTAL ? this.totalLength = entitySize.width : this.mode === Mode.VERTICAL ? this.totalLength = entitySize.height : this.mode === Mode.FILLED && (this.totalLength = this.barSprite.fillRange);
            }
          },
          animatable: false
        },
        _N$totalLength: 1,
        totalLength: {
          range: [ 0, Number.MAX_VALUE ],
          tooltip: false,
          get: function() {
            return this._N$totalLength;
          },
          set: function(value) {
            this.mode === Mode.FILLED && (value = misc.clamp01(value));
            this._N$totalLength = value;
            this._updateBarStatus();
          }
        },
        progress: {
          default: 1,
          type: "Float",
          range: [ 0, 1, .1 ],
          slide: true,
          tooltip: false,
          notify: function() {
            this._updateBarStatus();
          }
        },
        reverse: {
          default: false,
          tooltip: false,
          notify: function() {
            this.barSprite && (this.barSprite.fillStart = 1 - this.barSprite.fillStart);
            this._updateBarStatus();
          },
          animatable: false
        }
      },
      statics: {
        Mode: Mode
      }
    });
    cc.ProgressBar = module.exports = ProgressBar;
  }), {
    "../utils/misc": 208,
    "./CCComponent": 59
  } ],
  68: [ (function(require, module, exports) {
    var Component = require("./CCComponent");
    var renderEngine = require("../renderer/render-engine");
    var RenderFlow = require("../renderer/render-flow");
    var BlendFactor = require("../platform/CCMacro").BlendFactor;
    var RenderData = renderEngine.RenderData;
    var gfx = renderEngine.gfx;
    var RenderComponent = cc.Class({
      name: "RenderComponent",
      extends: Component,
      editor: false,
      properties: {
        _srcBlendFactor: BlendFactor.SRC_ALPHA,
        _dstBlendFactor: BlendFactor.ONE_MINUS_SRC_ALPHA,
        srcBlendFactor: {
          get: function() {
            return this._srcBlendFactor;
          },
          set: function(value) {
            if (this._srcBlendFactor === value) return;
            this._srcBlendFactor = value;
            this._updateBlendFunc(true);
          },
          animatable: false,
          type: BlendFactor,
          tooltip: false
        },
        dstBlendFactor: {
          get: function() {
            return this._dstBlendFactor;
          },
          set: function(value) {
            if (this._dstBlendFactor === value) return;
            this._dstBlendFactor = value;
            this._updateBlendFunc(true);
          },
          animatable: false,
          type: BlendFactor,
          tooltip: false
        }
      },
      ctor: function() {
        this._material = null;
        this._renderData = null;
        this.__allocedDatas = [];
        this._vertexFormat = null;
        this._toPostHandle = false;
        this._assembler = this.constructor._assembler;
        this._postAssembler = this.constructor._postAssembler;
      },
      onEnable: function() {
        this.node._renderComponent && (this.node._renderComponent.enabled = false);
        this.node._renderComponent = this;
        this.node._renderFlag |= RenderFlow.FLAG_RENDER | RenderFlow.FLAG_UPDATE_RENDER_DATA | RenderFlow.FLAG_COLOR;
      },
      onDisable: function() {
        this.node._renderComponent = null;
        this.disableRender();
      },
      onDestroy: function() {
        for (var i = 0, l = this.__allocedDatas.length; i < l; i++) RenderData.free(this.__allocedDatas[i]);
        this.__allocedDatas.length = 0;
        this._material = null;
        this._renderData = null;
      },
      _canRender: function() {
        return this._enabled;
      },
      markForUpdateRenderData: function(enable) {
        enable && this._canRender() ? this.node._renderFlag |= RenderFlow.FLAG_UPDATE_RENDER_DATA : enable || (this.node._renderFlag &= ~RenderFlow.FLAG_UPDATE_RENDER_DATA);
      },
      markForRender: function(enable) {
        enable && this._canRender() ? this.node._renderFlag |= RenderFlow.FLAG_RENDER : enable || (this.node._renderFlag &= ~RenderFlow.FLAG_RENDER);
      },
      markForCustomIARender: function(enable) {
        enable && this._canRender() ? this.node._renderFlag |= RenderFlow.FLAG_CUSTOM_IA_RENDER : enable || (this.node._renderFlag &= ~RenderFlow.FLAG_CUSTOM_IA_RENDER);
      },
      disableRender: function() {
        this.node._renderFlag &= ~(RenderFlow.FLAG_RENDER | RenderFlow.FLAG_CUSTOM_IA_RENDER | RenderFlow.FLAG_UPDATE_RENDER_DATA | RenderFlow.FLAG_COLOR);
      },
      requestRenderData: function() {
        var data = RenderData.alloc();
        this.__allocedDatas.push(data);
        return data;
      },
      destroyRenderData: function(data) {
        var index = this.__allocedDatas.indexOf(data);
        if (-1 !== index) {
          this.__allocedDatas.splice(index, 1);
          RenderData.free(data);
        }
      },
      _updateColor: function() {
        var material = this._material;
        if (material) {
          material.color = this.node.color;
          material.updateHash();
          this.node._renderFlag &= ~RenderFlow.FLAG_COLOR;
        }
      },
      getMaterial: function() {
        return this._material;
      },
      _updateMaterial: function(material) {
        this._material = material;
        this._updateBlendFunc();
        material.updateHash();
      },
      _updateBlendFunc: function(updateHash) {
        if (!this._material) return;
        var pass = this._material._mainTech.passes[0];
        pass.setBlend(gfx.BLEND_FUNC_ADD, this._srcBlendFactor, this._dstBlendFactor, gfx.BLEND_FUNC_ADD, this._srcBlendFactor, this._dstBlendFactor);
        updateHash && this._material.updateHash();
      }
    });
    RenderComponent._assembler = null;
    RenderComponent._postAssembler = null;
    cc.RenderComponent = module.exports = RenderComponent;
  }), {
    "../platform/CCMacro": 152,
    "../renderer/render-engine": 174,
    "../renderer/render-flow": 175,
    "./CCComponent": 59
  } ],
  69: [ (function(require, module, exports) {
    var js = require("../platform/js");
    var macro = require("../platform/CCMacro");
    var utils = require("../utils/text-utils");
    var HtmlTextParser = utils.HtmlTextParser;
    var TextUtils = utils.TextUtils;
    var CustomFontLoader = utils.CustomFontLoader;
    var HorizontalAlign = macro.TextAlignment;
    var VerticalAlign = macro.VerticalTextAlignment;
    var RichTextChildName = "RICHTEXT_CHILD";
    var RichTextChildImageName = "RICHTEXT_Image_CHILD";
    var _htmlTextParser = new HtmlTextParser();
    function debounce(func, wait, immediate) {
      var timeout = void 0;
      return function() {
        var context = this;
        var later = function() {
          timeout = null;
          immediate || func.apply(context, arguments);
        };
        var callNow = immediate && !timeout;
        clearTimeout(timeout);
        timeout = setTimeout(later, wait);
        callNow && func.apply(context, arguments);
      };
    }
    var pool = new js.Pool(function(node) {
      false;
      false;
      if (!cc.isValid(node)) return false;
      if (node.getComponent(cc.LabelOutline)) return false;
      return true;
    }, 20);
    pool.get = function(string, fontAsset, fontSize) {
      var labelNode = this._get();
      labelNode || (labelNode = new cc.PrivateNode(RichTextChildName));
      var labelComponent = labelNode.getComponent(cc.Label);
      labelComponent || (labelComponent = labelNode.addComponent(cc.Label));
      labelNode.setPosition(0, 0);
      labelNode.setAnchorPoint(.5, .5);
      labelNode.setContentSize(128, 128);
      labelNode.skewX = 0;
      "string" !== typeof string && (string = "" + string);
      var isAsset = fontAsset instanceof cc.Font;
      isAsset ? labelComponent.font = fontAsset : labelComponent.fontFamily = "Arial";
      labelComponent.string = string;
      labelComponent.horizontalAlign = HorizontalAlign.LEFT;
      labelComponent.verticalAlign = VerticalAlign.TOP;
      labelComponent.fontSize = fontSize || 40;
      labelComponent.overflow = 0;
      labelComponent.enableWrapText = true;
      labelComponent.lineHeight = 40;
      labelComponent._enableBold(false);
      labelComponent._enableItalics(false);
      labelComponent._enableUnderline(false);
      return labelNode;
    };
    var RichText = cc.Class({
      name: "cc.RichText",
      extends: cc.Component,
      ctor: function() {
        this._textArray = null;
        this._labelSegments = [];
        this._labelSegmentsCache = [];
        this._linesWidth = [];
        false;
        this._updateRichTextStatus = this._updateRichText;
      },
      editor: false,
      properties: {
        string: {
          default: "<color=#00ff00>Rich</c><color=#0fffff>Text</color>",
          multiline: true,
          tooltip: false,
          notify: function() {
            this._updateRichTextStatus();
          }
        },
        horizontalAlign: {
          default: HorizontalAlign.LEFT,
          type: HorizontalAlign,
          tooltip: false,
          animatable: false,
          notify: function(oldValue) {
            if (this.horizontalAlign === oldValue) return;
            this._layoutDirty = true;
            this._updateRichTextStatus();
          }
        },
        fontSize: {
          default: 40,
          tooltip: false,
          notify: function(oldValue) {
            if (this.fontSize === oldValue) return;
            this._layoutDirty = true;
            this._updateRichTextStatus();
          }
        },
        font: {
          default: null,
          type: cc.TTFFont,
          tooltip: false,
          notify: function(oldValue) {
            if (this.font === oldValue) return;
            this._layoutDirty = true;
            this.font && this._onTTFLoaded();
            this._updateRichTextStatus();
          }
        },
        maxWidth: {
          default: 0,
          tooltip: false,
          notify: function(oldValue) {
            if (this.maxWidth === oldValue) return;
            this._layoutDirty = true;
            this._updateRichTextStatus();
          }
        },
        lineHeight: {
          default: 40,
          tooltip: false,
          notify: function(oldValue) {
            if (this.lineHeight === oldValue) return;
            this._layoutDirty = true;
            this._updateRichTextStatus();
          }
        },
        imageAtlas: {
          default: null,
          type: cc.SpriteAtlas,
          tooltip: false,
          notify: function(oldValue) {
            if (this.imageAtlas === oldValue) return;
            this._layoutDirty = true;
            this._updateRichTextStatus();
          }
        },
        handleTouchEvent: {
          default: true,
          tooltip: false,
          notify: function(oldValue) {
            if (this.handleTouchEvent === oldValue) return;
            this.enabledInHierarchy && (this.handleTouchEvent ? this._addEventListeners() : this._removeEventListeners());
          }
        }
      },
      statics: {
        HorizontalAlign: HorizontalAlign,
        VerticalAlign: VerticalAlign
      },
      onEnable: function() {
        this.handleTouchEvent && this._addEventListeners();
        this._updateRichText();
        this._activateChildren(true);
      },
      onDisable: function() {
        this.handleTouchEvent && this._removeEventListeners();
        this._activateChildren(false);
      },
      start: function() {
        this._onTTFLoaded();
      },
      _addEventListeners: function() {
        this.node.on(cc.Node.EventType.TOUCH_END, this._onTouchEnded, this);
      },
      _removeEventListeners: function() {
        this.node.off(cc.Node.EventType.TOUCH_END, this._onTouchEnded, this);
      },
      _updateLabelSegmentTextAttributes: function() {
        this._labelSegments.forEach(function(item) {
          this._applyTextAttribute(item);
        }.bind(this));
      },
      _createFontLabel: function(string) {
        return pool.get(string, this.font, this.fontSize);
      },
      _getFontRawUrl: function() {
        var isAsset = this.font instanceof cc.TTFFont;
        return isAsset ? this.font.nativeUrl : "";
      },
      _onTTFLoaded: function() {
        var rawUrl = this._getFontRawUrl();
        if (!rawUrl) return;
        var self = this;
        var callback = function() {
          self._layoutDirty = true;
          self._updateRichText();
        };
        CustomFontLoader.loadTTF(rawUrl, callback);
      },
      _measureText: function(styleIndex, string) {
        var self = this;
        var func = function(string) {
          var label = void 0;
          if (0 === self._labelSegmentsCache.length) {
            label = self._createFontLabel(string);
            self._labelSegmentsCache.push(label);
          } else {
            label = self._labelSegmentsCache[0];
            label.getComponent(cc.Label).string = string;
          }
          label._styleIndex = styleIndex;
          self._applyTextAttribute(label);
          var labelSize = label.getContentSize();
          return labelSize.width;
        };
        return string ? func(string) : func;
      },
      _onTouchEnded: function(event) {
        var _this = this;
        var components = this.node.getComponents(cc.Component);
        var _loop = function(i) {
          var labelSegment = _this._labelSegments[i];
          var clickHandler = labelSegment._clickHandler;
          if (clickHandler && _this._containsTouchLocation(labelSegment, event.touch.getLocation())) {
            components.forEach((function(component) {
              component.enabledInHierarchy && component[clickHandler] && component[clickHandler](event);
            }));
            event.stopPropagation();
          }
        };
        for (var i = 0; i < this._labelSegments.length; ++i) _loop(i);
      },
      _containsTouchLocation: function(label, point) {
        var myRect = label.getBoundingBoxToWorld();
        return myRect.contains(point);
      },
      _resetState: function() {
        var children = this.node.children;
        for (var i = children.length - 1; i >= 0; i--) {
          var child = children[i];
          if (child.name === RichTextChildName) {
            child.parent = null;
            pool.put(child);
          } else child.name === RichTextChildImageName && (child.parent = null);
        }
        children.length = 0;
        this._labelSegments.length = 0;
        this._labelSegmentsCache.length = 0;
        this._linesWidth.length = 0;
        this._lineOffsetX = 0;
        this._lineCount = 1;
        this._labelWidth = 0;
        this._labelHeight = 0;
        this._layoutDirty = true;
      },
      onRestore: false,
      _activateChildren: function(active) {
        for (var i = this.node.children.length - 1; i >= 0; i--) {
          var child = this.node.children[i];
          child.name !== RichTextChildName && child.name !== RichTextChildImageName || (child.active = active);
        }
      },
      _addLabelSegment: function(stringToken, styleIndex) {
        var labelSegment = void 0;
        if (0 === this._labelSegmentsCache.length) labelSegment = this._createFontLabel(stringToken); else {
          labelSegment = this._labelSegmentsCache.pop();
          labelSegment.getComponent(cc.Label).string = stringToken;
        }
        labelSegment._styleIndex = styleIndex;
        labelSegment._lineCount = this._lineCount;
        labelSegment.setAnchorPoint(0, 0);
        this._applyTextAttribute(labelSegment);
        this.node.addChild(labelSegment);
        this._labelSegments.push(labelSegment);
        return labelSegment;
      },
      _updateRichTextWithMaxWidth: function(labelString, labelWidth, styleIndex) {
        var fragmentWidth = labelWidth;
        var labelSegment = void 0;
        if (this._lineOffsetX > 0 && fragmentWidth + this._lineOffsetX > this.maxWidth) {
          var checkStartIndex = 0;
          while (this._lineOffsetX <= this.maxWidth) {
            var checkEndIndex = this._getFirstWordLen(labelString, checkStartIndex, labelString.length);
            var checkString = labelString.substr(checkStartIndex, checkEndIndex);
            var checkStringWidth = this._measureText(styleIndex, checkString);
            if (!(this._lineOffsetX + checkStringWidth <= this.maxWidth)) {
              if (checkStartIndex > 0) {
                var remainingString = labelString.substr(0, checkStartIndex);
                this._addLabelSegment(remainingString, styleIndex);
                labelString = labelString.substr(checkStartIndex, labelString.length);
                fragmentWidth = this._measureText(styleIndex, labelString);
              }
              this._updateLineInfo();
              break;
            }
            this._lineOffsetX += checkStringWidth;
            checkStartIndex += checkEndIndex;
          }
        }
        if (fragmentWidth > this.maxWidth) {
          var fragments = TextUtils.fragmentText(labelString, fragmentWidth, this.maxWidth, this._measureText(styleIndex));
          for (var k = 0; k < fragments.length; ++k) {
            var splitString = fragments[k];
            labelSegment = this._addLabelSegment(splitString, styleIndex);
            var labelSize = labelSegment.getContentSize();
            this._lineOffsetX += labelSize.width;
            fragments.length > 1 && k < fragments.length - 1 && this._updateLineInfo();
          }
        } else {
          this._lineOffsetX += fragmentWidth;
          this._addLabelSegment(labelString, styleIndex);
        }
      },
      _isLastComponentCR: function(stringToken) {
        return stringToken.length - 1 === stringToken.lastIndexOf("\n");
      },
      _updateLineInfo: function() {
        this._linesWidth.push(this._lineOffsetX);
        this._lineOffsetX = 0;
        this._lineCount++;
      },
      _needsUpdateTextLayout: function(newTextArray) {
        if (this._layoutDirty || !this._textArray || !newTextArray) return true;
        if (this._textArray.length !== newTextArray.length) return true;
        for (var i = 0; i < this._textArray.length; ++i) {
          var oldItem = this._textArray[i];
          var newItem = newTextArray[i];
          if (oldItem.text !== newItem.text) return true;
          if (oldItem.style) {
            if (newItem.style) {
              if (!!newItem.style.outline !== !!oldItem.style.outline) return true;
              if (oldItem.style.size !== newItem.style.size || oldItem.style.italic !== newItem.style.italic || oldItem.style.isImage !== newItem.style.isImage) return true;
              if (oldItem.style.isImage === newItem.style.isImage && oldItem.style.src !== newItem.style.src) return true;
            } else if (oldItem.style.size || oldItem.style.italic || oldItem.style.isImage || oldItem.style.outline) return true;
          } else if (newItem.style && (newItem.style.size || newItem.style.italic || newItem.style.isImage || newItem.style.outline)) return true;
        }
        return false;
      },
      _addRichTextImageElement: function(richTextElement) {
        var spriteFrameName = richTextElement.style.src;
        var spriteFrame = this.imageAtlas.getSpriteFrame(spriteFrameName);
        if (spriteFrame) {
          var spriteNode = new cc.PrivateNode(RichTextChildImageName);
          var spriteComponent = spriteNode.addComponent(cc.Sprite);
          spriteNode.setAnchorPoint(0, 0);
          spriteComponent.type = cc.Sprite.Type.SLICED;
          spriteComponent.sizeMode = cc.Sprite.SizeMode.CUSTOM;
          this.node.addChild(spriteNode);
          this._labelSegments.push(spriteNode);
          var spriteRect = spriteFrame.getRect();
          var scaleFactor = 1;
          var spriteWidth = spriteRect.width;
          var spriteHeight = spriteRect.height;
          var expectWidth = richTextElement.style.imageWidth;
          var expectHeight = richTextElement.style.imageHeight;
          if (expectHeight > 0 && expectHeight < this.lineHeight) {
            scaleFactor = expectHeight / spriteHeight;
            spriteWidth *= scaleFactor;
            spriteHeight *= scaleFactor;
          } else {
            scaleFactor = this.lineHeight / spriteHeight;
            spriteWidth *= scaleFactor;
            spriteHeight *= scaleFactor;
          }
          expectWidth > 0 && (spriteWidth = expectWidth);
          if (this.maxWidth > 0) {
            this._lineOffsetX + spriteWidth > this.maxWidth && this._updateLineInfo();
            this._lineOffsetX += spriteWidth;
          } else {
            this._lineOffsetX += spriteWidth;
            this._lineOffsetX > this._labelWidth && (this._labelWidth = this._lineOffsetX);
          }
          spriteComponent.spriteFrame = spriteFrame;
          spriteNode.setContentSize(spriteWidth, spriteHeight);
          spriteNode._lineCount = this._lineCount;
          richTextElement.style.event && richTextElement.style.event.click && (spriteNode._clickHandler = richTextElement.style.event.click);
        } else cc.warnID(4400);
      },
      _updateRichText: function() {
        if (!this.enabled) return;
        var newTextArray = _htmlTextParser.parse(this.string);
        if (!this._needsUpdateTextLayout(newTextArray)) {
          this._textArray = newTextArray;
          this._updateLabelSegmentTextAttributes();
          return;
        }
        this._textArray = newTextArray;
        this._resetState();
        var lastEmptyLine = false;
        var label = void 0;
        var labelSize = void 0;
        for (var i = 0; i < this._textArray.length; ++i) {
          var richTextElement = this._textArray[i];
          var text = richTextElement.text;
          if ("" === text) {
            if (richTextElement.style && richTextElement.style.newline) {
              this._updateLineInfo();
              continue;
            }
            if (richTextElement.style && richTextElement.style.isImage && this.imageAtlas) {
              this._addRichTextImageElement(richTextElement);
              continue;
            }
          }
          var multilineTexts = text.split("\n");
          for (var j = 0; j < multilineTexts.length; ++j) {
            var labelString = multilineTexts[j];
            if ("" === labelString) {
              if (this._isLastComponentCR(text) && j === multilineTexts.length - 1) continue;
              this._updateLineInfo();
              lastEmptyLine = true;
              continue;
            }
            lastEmptyLine = false;
            if (this.maxWidth > 0) {
              var labelWidth = this._measureText(i, labelString);
              this._updateRichTextWithMaxWidth(labelString, labelWidth, i);
              multilineTexts.length > 1 && j < multilineTexts.length - 1 && this._updateLineInfo();
            } else {
              label = this._addLabelSegment(labelString, i);
              labelSize = label.getContentSize();
              this._lineOffsetX += labelSize.width;
              this._lineOffsetX > this._labelWidth && (this._labelWidth = this._lineOffsetX);
              multilineTexts.length > 1 && j < multilineTexts.length - 1 && this._updateLineInfo();
            }
          }
        }
        lastEmptyLine || this._linesWidth.push(this._lineOffsetX);
        this.maxWidth > 0 && (this._labelWidth = this.maxWidth);
        this._labelHeight = this._lineCount * this.lineHeight;
        this.node.setContentSize(this._labelWidth, this._labelHeight);
        this._updateRichTextPosition();
        this._layoutDirty = false;
      },
      _getFirstWordLen: function(text, startIndex, textLen) {
        var character = text.charAt(startIndex);
        if (TextUtils.isUnicodeCJK(character) || TextUtils.isUnicodeSpace(character)) return 1;
        var len = 1;
        for (var index = startIndex + 1; index < textLen; ++index) {
          character = text.charAt(index);
          if (TextUtils.isUnicodeSpace(character) || TextUtils.isUnicodeCJK(character)) break;
          len++;
        }
        return len;
      },
      _updateRichTextPosition: function() {
        var nextTokenX = 0;
        var nextLineIndex = 1;
        var totalLineCount = this._lineCount;
        for (var i = 0; i < this._labelSegments.length; ++i) {
          var label = this._labelSegments[i];
          var lineCount = label._lineCount;
          if (lineCount > nextLineIndex) {
            nextTokenX = 0;
            nextLineIndex = lineCount;
          }
          var lineOffsetX = 0;
          switch (this.horizontalAlign) {
           case HorizontalAlign.LEFT:
            lineOffsetX = -this._labelWidth / 2;
            break;

           case HorizontalAlign.CENTER:
            lineOffsetX = -this._linesWidth[lineCount - 1] / 2;
            break;

           case HorizontalAlign.RIGHT:
            lineOffsetX = this._labelWidth / 2 - this._linesWidth[lineCount - 1];
          }
          label.x = nextTokenX + lineOffsetX;
          var labelSize = label.getContentSize();
          label.y = this.lineHeight * (totalLineCount - lineCount) - this._labelHeight / 2;
          lineCount === nextLineIndex && (nextTokenX += labelSize.width);
        }
      },
      _convertLiteralColorValue: function(color) {
        var colorValue = color.toUpperCase();
        if (cc.Color[colorValue]) return cc.Color[colorValue];
        var out = cc.color();
        return out.fromHEX(color);
      },
      _applyTextAttribute: function(labelNode) {
        var labelComponent = labelNode.getComponent(cc.Label);
        if (!labelComponent) return;
        var index = labelNode._styleIndex;
        labelComponent.lineHeight = this.lineHeight;
        labelComponent.horizontalAlign = HorizontalAlign.LEFT;
        labelComponent.verticalAlign = VerticalAlign.CENTER;
        var textStyle = null;
        this._textArray[index] && (textStyle = this._textArray[index].style);
        textStyle && textStyle.color ? labelNode.color = this._convertLiteralColorValue(textStyle.color) : labelNode.color = this._convertLiteralColorValue("white");
        labelComponent._enableBold(textStyle && textStyle.bold);
        labelComponent._enableItalics(textStyle && textStyle.italic);
        textStyle && textStyle.italic && (labelNode.skewX = 12);
        labelComponent._enableUnderline(textStyle && textStyle.underline);
        if (textStyle && textStyle.outline) {
          var labelOutlineComponent = labelNode.getComponent(cc.LabelOutline);
          labelOutlineComponent || (labelOutlineComponent = labelNode.addComponent(cc.LabelOutline));
          labelOutlineComponent.color = this._convertLiteralColorValue(textStyle.outline.color);
          labelOutlineComponent.width = textStyle.outline.width;
        }
        textStyle && textStyle.size ? labelComponent.fontSize = textStyle.size : labelComponent.fontSize = this.fontSize;
        labelComponent._updateRenderData(true);
        textStyle && textStyle.event && textStyle.event.click && (labelNode._clickHandler = textStyle.event.click);
      },
      onDestroy: function() {
        for (var i = 0; i < this._labelSegments.length; ++i) {
          this._labelSegments[i].removeFromParent();
          pool.put(this._labelSegments[i]);
        }
      }
    });
    cc.RichText = module.exports = RichText;
  }), {
    "../platform/CCMacro": 152,
    "../platform/js": 167,
    "../utils/text-utils": 215
  } ],
  70: [ (function(require, module, exports) {
    var misc = require("../utils/misc");
    var Component = require("./CCComponent");
    var GETTINGSHORTERFACTOR = 20;
    var Direction = cc.Enum({
      HORIZONTAL: 0,
      VERTICAL: 1
    });
    var Scrollbar = cc.Class({
      name: "cc.Scrollbar",
      extends: require("./CCComponent"),
      editor: false,
      properties: {
        _scrollView: null,
        _touching: false,
        _autoHideRemainingTime: {
          default: 0,
          serializable: false
        },
        _opacity: 255,
        handle: {
          default: null,
          type: cc.Sprite,
          tooltip: false,
          notify: function() {
            this._onScroll(cc.v2(0, 0));
          },
          animatable: false
        },
        direction: {
          default: Direction.HORIZONTAL,
          type: Direction,
          tooltip: false,
          notify: function() {
            this._onScroll(cc.v2(0, 0));
          },
          animatable: false
        },
        enableAutoHide: {
          default: true,
          animatable: false,
          tooltip: false
        },
        autoHideTime: {
          default: 1,
          animatable: false,
          tooltip: false
        }
      },
      statics: {
        Direction: Direction
      },
      setTargetScrollView: function(scrollView) {
        this._scrollView = scrollView;
      },
      _convertToScrollViewSpace: function(content) {
        var worldSpacePos = content.convertToWorldSpace(cc.v2(0, 0));
        var scrollViewSpacePos = this._scrollView.node.convertToNodeSpace(worldSpacePos);
        return scrollViewSpacePos;
      },
      _setOpacity: function(opacity) {
        if (this.handle) {
          this.node.opacity = opacity;
          this.handle.node.opacity = opacity;
        }
      },
      _onScroll: function(outOfBoundary) {
        if (this._scrollView) {
          var content = this._scrollView.content;
          if (content) {
            var contentSize = content.getContentSize();
            var scrollViewSize = this._scrollView.node.getContentSize();
            var handleNodeSize = this.node.getContentSize();
            if (this._conditionalDisableScrollBar(contentSize, scrollViewSize)) return;
            if (this.enableAutoHide) {
              this._autoHideRemainingTime = this.autoHideTime;
              this._setOpacity(this._opacity);
            }
            var contentMeasure = 0;
            var scrollViewMeasure = 0;
            var outOfBoundaryValue = 0;
            var contentPosition = 0;
            var handleNodeMeasure = 0;
            if (this.direction === Direction.HORIZONTAL) {
              contentMeasure = contentSize.width;
              scrollViewMeasure = scrollViewSize.width;
              handleNodeMeasure = handleNodeSize.width;
              outOfBoundaryValue = outOfBoundary.x;
              contentPosition = -this._convertToScrollViewSpace(content).x;
            } else if (this.direction === Direction.VERTICAL) {
              contentMeasure = contentSize.height;
              scrollViewMeasure = scrollViewSize.height;
              handleNodeMeasure = handleNodeSize.height;
              outOfBoundaryValue = outOfBoundary.y;
              contentPosition = -this._convertToScrollViewSpace(content).y;
            }
            var length = this._calculateLength(contentMeasure, scrollViewMeasure, handleNodeMeasure, outOfBoundaryValue);
            var position = this._calculatePosition(contentMeasure, scrollViewMeasure, handleNodeMeasure, contentPosition, outOfBoundaryValue, length);
            this._updateLength(length);
            this._updateHanlderPosition(position);
          }
        }
      },
      _updateHanlderPosition: function(position) {
        if (this.handle) {
          var oldPosition = this._fixupHandlerPosition();
          this.handle.node.setPosition(position.x + oldPosition.x, position.y + oldPosition.y);
        }
      },
      _fixupHandlerPosition: function() {
        var barSize = this.node.getContentSize();
        var barAnchor = this.node.getAnchorPoint();
        var handleSize = this.handle.node.getContentSize();
        var handleParent = this.handle.node.parent;
        var leftBottomWorldPosition = this.node.convertToWorldSpaceAR(cc.v2(-barSize.width * barAnchor.x, -barSize.height * barAnchor.y));
        var fixupPosition = handleParent.convertToNodeSpaceAR(leftBottomWorldPosition);
        this.direction === Direction.HORIZONTAL ? fixupPosition = cc.v2(fixupPosition.x, fixupPosition.y + (barSize.height - handleSize.height) / 2) : this.direction === Direction.VERTICAL && (fixupPosition = cc.v2(fixupPosition.x + (barSize.width - handleSize.width) / 2, fixupPosition.y));
        this.handle.node.setPosition(fixupPosition);
        return fixupPosition;
      },
      _onTouchBegan: function() {
        if (!this.enableAutoHide) return;
        this._touching = true;
      },
      _conditionalDisableScrollBar: function(contentSize, scrollViewSize) {
        if (contentSize.width <= scrollViewSize.width && this.direction === Direction.HORIZONTAL) return true;
        if (contentSize.height <= scrollViewSize.height && this.direction === Direction.VERTICAL) return true;
        return false;
      },
      _onTouchEnded: function() {
        if (!this.enableAutoHide) return;
        this._touching = false;
        if (this.autoHideTime <= 0) return;
        if (this._scrollView) {
          var content = this._scrollView.content;
          if (content) {
            var contentSize = content.getContentSize();
            var scrollViewSize = this._scrollView.node.getContentSize();
            if (this._conditionalDisableScrollBar(contentSize, scrollViewSize)) return;
          }
        }
        this._autoHideRemainingTime = this.autoHideTime;
      },
      _calculateLength: function(contentMeasure, scrollViewMeasure, handleNodeMeasure, outOfBoundary) {
        var denominatorValue = contentMeasure;
        outOfBoundary && (denominatorValue += (outOfBoundary > 0 ? outOfBoundary : -outOfBoundary) * GETTINGSHORTERFACTOR);
        var lengthRation = scrollViewMeasure / denominatorValue;
        return handleNodeMeasure * lengthRation;
      },
      _calculatePosition: function(contentMeasure, scrollViewMeasure, handleNodeMeasure, contentPosition, outOfBoundary, actualLenth) {
        var denominatorValue = contentMeasure - scrollViewMeasure;
        outOfBoundary && (denominatorValue += Math.abs(outOfBoundary));
        var positionRatio = 0;
        if (denominatorValue) {
          positionRatio = contentPosition / denominatorValue;
          positionRatio = misc.clamp01(positionRatio);
        }
        var position = (handleNodeMeasure - actualLenth) * positionRatio;
        return this.direction === Direction.VERTICAL ? cc.v2(0, position) : cc.v2(position, 0);
      },
      _updateLength: function(length) {
        if (this.handle) {
          var handleNode = this.handle.node;
          var handleNodeSize = handleNode.getContentSize();
          handleNode.setAnchorPoint(cc.v2(0, 0));
          this.direction === Direction.HORIZONTAL ? handleNode.setContentSize(length, handleNodeSize.height) : handleNode.setContentSize(handleNodeSize.width, length);
        }
      },
      _processAutoHide: function(deltaTime) {
        if (!this.enableAutoHide || this._autoHideRemainingTime <= 0) return;
        if (this._touching) return;
        this._autoHideRemainingTime -= deltaTime;
        if (this._autoHideRemainingTime <= this.autoHideTime) {
          this._autoHideRemainingTime = Math.max(0, this._autoHideRemainingTime);
          var opacity = this._opacity * (this._autoHideRemainingTime / this.autoHideTime);
          this._setOpacity(opacity);
        }
      },
      start: function() {
        this.enableAutoHide && this._setOpacity(0);
      },
      hide: function() {
        this._autoHideRemainingTime = 0;
        this._setOpacity(0);
      },
      show: function() {
        this._autoHideRemainingTime = this.autoHideTime;
        this._setOpacity(this._opacity);
      },
      update: function(dt) {
        this._processAutoHide(dt);
      }
    });
    cc.Scrollbar = module.exports = Scrollbar;
  }), {
    "../utils/misc": 208,
    "./CCComponent": 59
  } ],
  71: [ (function(require, module, exports) {
    var NodeEvent = require("../CCNode").EventType;
    var NUMBER_OF_GATHERED_TOUCHES_FOR_MOVE_SPEED = 5;
    var OUT_OF_BOUNDARY_BREAKING_FACTOR = .05;
    var EPSILON = 1e-4;
    var MOVEMENT_FACTOR = .7;
    var quintEaseOut = function(time) {
      time -= 1;
      return time * time * time * time * time + 1;
    };
    var getTimeInMilliseconds = function() {
      var currentTime = new Date();
      return currentTime.getMilliseconds();
    };
    var EventType = cc.Enum({
      SCROLL_TO_TOP: 0,
      SCROLL_TO_BOTTOM: 1,
      SCROLL_TO_LEFT: 2,
      SCROLL_TO_RIGHT: 3,
      SCROLLING: 4,
      BOUNCE_TOP: 5,
      BOUNCE_BOTTOM: 6,
      BOUNCE_LEFT: 7,
      BOUNCE_RIGHT: 8,
      SCROLL_ENDED: 9,
      TOUCH_UP: 10,
      AUTOSCROLL_ENDED_WITH_THRESHOLD: 11,
      SCROLL_BEGAN: 12
    });
    var eventMap = {
      "scroll-to-top": EventType.SCROLL_TO_TOP,
      "scroll-to-bottom": EventType.SCROLL_TO_BOTTOM,
      "scroll-to-left": EventType.SCROLL_TO_LEFT,
      "scroll-to-right": EventType.SCROLL_TO_RIGHT,
      scrolling: EventType.SCROLLING,
      "bounce-bottom": EventType.BOUNCE_BOTTOM,
      "bounce-left": EventType.BOUNCE_LEFT,
      "bounce-right": EventType.BOUNCE_RIGHT,
      "bounce-top": EventType.BOUNCE_TOP,
      "scroll-ended": EventType.SCROLL_ENDED,
      "touch-up": EventType.TOUCH_UP,
      "scroll-ended-with-threshold": EventType.AUTOSCROLL_ENDED_WITH_THRESHOLD,
      "scroll-began": EventType.SCROLL_BEGAN
    };
    var ScrollView = cc.Class({
      name: "cc.ScrollView",
      extends: require("./CCViewGroup"),
      editor: false,
      ctor: function() {
        this._topBoundary = 0;
        this._bottomBoundary = 0;
        this._leftBoundary = 0;
        this._rightBoundary = 0;
        this._touchMoveDisplacements = [];
        this._touchMoveTimeDeltas = [];
        this._touchMovePreviousTimestamp = 0;
        this._touchMoved = false;
        this._autoScrolling = false;
        this._autoScrollAttenuate = false;
        this._autoScrollStartPosition = cc.v2(0, 0);
        this._autoScrollTargetDelta = cc.v2(0, 0);
        this._autoScrollTotalTime = 0;
        this._autoScrollAccumulatedTime = 0;
        this._autoScrollCurrentlyOutOfBoundary = false;
        this._autoScrollBraking = false;
        this._autoScrollBrakingStartPosition = cc.v2(0, 0);
        this._outOfBoundaryAmount = cc.v2(0, 0);
        this._outOfBoundaryAmountDirty = true;
        this._stopMouseWheel = false;
        this._mouseWheelEventElapsedTime = 0;
        this._isScrollEndedWithThresholdEventFired = false;
        this._scrollEventEmitMask = 0;
        this._isBouncing = false;
        this._scrolling = false;
      },
      properties: {
        content: {
          default: void 0,
          type: cc.Node,
          tooltip: false
        },
        horizontal: {
          default: true,
          animatable: false,
          tooltip: false
        },
        vertical: {
          default: true,
          animatable: false,
          tooltip: false
        },
        inertia: {
          default: true,
          tooltip: false
        },
        brake: {
          default: .5,
          type: "Float",
          range: [ 0, 1, .1 ],
          tooltip: false
        },
        elastic: {
          default: true,
          animatable: false,
          tooltip: false
        },
        bounceDuration: {
          default: 1,
          range: [ 0, 10 ],
          tooltip: false
        },
        horizontalScrollBar: {
          default: void 0,
          type: cc.Scrollbar,
          tooltip: false,
          notify: function() {
            if (this.horizontalScrollBar) {
              this.horizontalScrollBar.setTargetScrollView(this);
              this._updateScrollBar(0);
            }
          },
          animatable: false
        },
        verticalScrollBar: {
          default: void 0,
          type: cc.Scrollbar,
          tooltip: false,
          notify: function() {
            if (this.verticalScrollBar) {
              this.verticalScrollBar.setTargetScrollView(this);
              this._updateScrollBar(0);
            }
          },
          animatable: false
        },
        scrollEvents: {
          default: [],
          type: cc.Component.EventHandler,
          tooltip: false
        },
        cancelInnerEvents: {
          default: true,
          animatable: false,
          tooltip: false
        }
      },
      statics: {
        EventType: EventType
      },
      scrollToBottom: function(timeInSecond, attenuated) {
        var moveDelta = this._calculateMovePercentDelta({
          anchor: cc.v2(0, 0),
          applyToHorizontal: false,
          applyToVertical: true
        });
        timeInSecond ? this._startAutoScroll(moveDelta, timeInSecond, false !== attenuated) : this._moveContent(moveDelta, true);
      },
      scrollToTop: function(timeInSecond, attenuated) {
        var moveDelta = this._calculateMovePercentDelta({
          anchor: cc.v2(0, 1),
          applyToHorizontal: false,
          applyToVertical: true
        });
        timeInSecond ? this._startAutoScroll(moveDelta, timeInSecond, false !== attenuated) : this._moveContent(moveDelta);
      },
      scrollToLeft: function(timeInSecond, attenuated) {
        var moveDelta = this._calculateMovePercentDelta({
          anchor: cc.v2(0, 0),
          applyToHorizontal: true,
          applyToVertical: false
        });
        timeInSecond ? this._startAutoScroll(moveDelta, timeInSecond, false !== attenuated) : this._moveContent(moveDelta);
      },
      scrollToRight: function(timeInSecond, attenuated) {
        var moveDelta = this._calculateMovePercentDelta({
          anchor: cc.v2(1, 0),
          applyToHorizontal: true,
          applyToVertical: false
        });
        timeInSecond ? this._startAutoScroll(moveDelta, timeInSecond, false !== attenuated) : this._moveContent(moveDelta);
      },
      scrollToTopLeft: function(timeInSecond, attenuated) {
        var moveDelta = this._calculateMovePercentDelta({
          anchor: cc.v2(0, 1),
          applyToHorizontal: true,
          applyToVertical: true
        });
        timeInSecond ? this._startAutoScroll(moveDelta, timeInSecond, false !== attenuated) : this._moveContent(moveDelta);
      },
      scrollToTopRight: function(timeInSecond, attenuated) {
        var moveDelta = this._calculateMovePercentDelta({
          anchor: cc.v2(1, 1),
          applyToHorizontal: true,
          applyToVertical: true
        });
        timeInSecond ? this._startAutoScroll(moveDelta, timeInSecond, false !== attenuated) : this._moveContent(moveDelta);
      },
      scrollToBottomLeft: function(timeInSecond, attenuated) {
        var moveDelta = this._calculateMovePercentDelta({
          anchor: cc.v2(0, 0),
          applyToHorizontal: true,
          applyToVertical: true
        });
        timeInSecond ? this._startAutoScroll(moveDelta, timeInSecond, false !== attenuated) : this._moveContent(moveDelta);
      },
      scrollToBottomRight: function(timeInSecond, attenuated) {
        var moveDelta = this._calculateMovePercentDelta({
          anchor: cc.v2(1, 0),
          applyToHorizontal: true,
          applyToVertical: true
        });
        timeInSecond ? this._startAutoScroll(moveDelta, timeInSecond, false !== attenuated) : this._moveContent(moveDelta);
      },
      scrollToOffset: function(offset, timeInSecond, attenuated) {
        var maxScrollOffset = this.getMaxScrollOffset();
        var anchor = cc.v2(0, 0);
        0 === maxScrollOffset.x ? anchor.x = 0 : anchor.x = offset.x / maxScrollOffset.x;
        0 === maxScrollOffset.y ? anchor.y = 1 : anchor.y = (maxScrollOffset.y - offset.y) / maxScrollOffset.y;
        this.scrollTo(anchor, timeInSecond, attenuated);
      },
      getScrollOffset: function() {
        var topDelta = this._getContentTopBoundary() - this._topBoundary;
        var leftDeta = this._getContentLeftBoundary() - this._leftBoundary;
        return cc.v2(leftDeta, topDelta);
      },
      getMaxScrollOffset: function() {
        var scrollSize = this.node.getContentSize();
        var contentSize = this.content.getContentSize();
        var horizontalMaximizeOffset = contentSize.width - scrollSize.width;
        var verticalMaximizeOffset = contentSize.height - scrollSize.height;
        horizontalMaximizeOffset = horizontalMaximizeOffset >= 0 ? horizontalMaximizeOffset : 0;
        verticalMaximizeOffset = verticalMaximizeOffset >= 0 ? verticalMaximizeOffset : 0;
        return cc.v2(horizontalMaximizeOffset, verticalMaximizeOffset);
      },
      scrollToPercentHorizontal: function(percent, timeInSecond, attenuated) {
        var moveDelta = this._calculateMovePercentDelta({
          anchor: cc.v2(percent, 0),
          applyToHorizontal: true,
          applyToVertical: false
        });
        timeInSecond ? this._startAutoScroll(moveDelta, timeInSecond, false !== attenuated) : this._moveContent(moveDelta);
      },
      scrollTo: function(anchor, timeInSecond, attenuated) {
        var moveDelta = this._calculateMovePercentDelta({
          anchor: cc.v2(anchor),
          applyToHorizontal: true,
          applyToVertical: true
        });
        timeInSecond ? this._startAutoScroll(moveDelta, timeInSecond, false !== attenuated) : this._moveContent(moveDelta);
      },
      scrollToPercentVertical: function(percent, timeInSecond, attenuated) {
        var moveDelta = this._calculateMovePercentDelta({
          anchor: cc.v2(0, percent),
          applyToHorizontal: false,
          applyToVertical: true
        });
        timeInSecond ? this._startAutoScroll(moveDelta, timeInSecond, false !== attenuated) : this._moveContent(moveDelta);
      },
      stopAutoScroll: function() {
        this._autoScrolling = false;
        this._autoScrollAccumulatedTime = this._autoScrollTotalTime;
      },
      setContentPosition: function(position) {
        if (position.fuzzyEquals(this.getContentPosition(), EPSILON)) return;
        this.content.setPosition(position);
        this._outOfBoundaryAmountDirty = true;
      },
      getContentPosition: function() {
        return this.content.getPosition();
      },
      isScrolling: function() {
        return this._scrolling;
      },
      isAutoScrolling: function() {
        return this._autoScrolling;
      },
      _registerEvent: function() {
        this.node.on(cc.Node.EventType.TOUCH_START, this._onTouchBegan, this, true);
        this.node.on(cc.Node.EventType.TOUCH_MOVE, this._onTouchMoved, this, true);
        this.node.on(cc.Node.EventType.TOUCH_END, this._onTouchEnded, this, true);
        this.node.on(cc.Node.EventType.TOUCH_CANCEL, this._onTouchCancelled, this, true);
        this.node.on(cc.Node.EventType.MOUSE_WHEEL, this._onMouseWheel, this, true);
      },
      _unregisterEvent: function() {
        this.node.off(cc.Node.EventType.TOUCH_START, this._onTouchBegan, this, true);
        this.node.off(cc.Node.EventType.TOUCH_MOVE, this._onTouchMoved, this, true);
        this.node.off(cc.Node.EventType.TOUCH_END, this._onTouchEnded, this, true);
        this.node.off(cc.Node.EventType.TOUCH_CANCEL, this._onTouchCancelled, this, true);
        this.node.off(cc.Node.EventType.MOUSE_WHEEL, this._onMouseWheel, this, true);
      },
      _onMouseWheel: function(event, captureListeners) {
        if (!this.enabledInHierarchy) return;
        if (this._hasNestedViewGroup(event, captureListeners)) return;
        var deltaMove = cc.v2(0, 0);
        var wheelPrecision = -.1;
        false;
        this.vertical ? deltaMove = cc.v2(0, event.getScrollY() * wheelPrecision) : this.horizontal && (deltaMove = cc.v2(event.getScrollY() * wheelPrecision, 0));
        this._mouseWheelEventElapsedTime = 0;
        this._processDeltaMove(deltaMove);
        if (!this._stopMouseWheel) {
          this._handlePressLogic();
          this.schedule(this._checkMouseWheel, 1 / 60);
          this._stopMouseWheel = true;
        }
        this._stopPropagationIfTargetIsMe(event);
      },
      _checkMouseWheel: function(dt) {
        var currentOutOfBoundary = this._getHowMuchOutOfBoundary();
        var maxElapsedTime = .1;
        if (!currentOutOfBoundary.fuzzyEquals(cc.v2(0, 0), EPSILON)) {
          this._processInertiaScroll();
          this.unschedule(this._checkMouseWheel);
          this._stopMouseWheel = false;
          return;
        }
        this._mouseWheelEventElapsedTime += dt;
        if (this._mouseWheelEventElapsedTime > maxElapsedTime) {
          this._onScrollBarTouchEnded();
          this.unschedule(this._checkMouseWheel);
          this._stopMouseWheel = false;
        }
      },
      _calculateMovePercentDelta: function(options) {
        var anchor = options.anchor;
        var applyToHorizontal = options.applyToHorizontal;
        var applyToVertical = options.applyToVertical;
        this._calculateBoundary();
        anchor = anchor.clampf(cc.v2(0, 0), cc.v2(1, 1));
        var scrollSize = this.node.getContentSize();
        var contentSize = this.content.getContentSize();
        var bottomDeta = this._getContentBottomBoundary() - this._bottomBoundary;
        bottomDeta = -bottomDeta;
        var leftDeta = this._getContentLeftBoundary() - this._leftBoundary;
        leftDeta = -leftDeta;
        var moveDelta = cc.v2(0, 0);
        var totalScrollDelta = 0;
        if (applyToHorizontal) {
          totalScrollDelta = contentSize.width - scrollSize.width;
          moveDelta.x = leftDeta - totalScrollDelta * anchor.x;
        }
        if (applyToVertical) {
          totalScrollDelta = contentSize.height - scrollSize.height;
          moveDelta.y = bottomDeta - totalScrollDelta * anchor.y;
        }
        return moveDelta;
      },
      _moveContentToTopLeft: function(scrollViewSize) {
        var contentSize = this.content.getContentSize();
        var bottomDeta = this._getContentBottomBoundary() - this._bottomBoundary;
        bottomDeta = -bottomDeta;
        var moveDelta = cc.v2(0, 0);
        var totalScrollDelta = 0;
        var leftDeta = this._getContentLeftBoundary() - this._leftBoundary;
        leftDeta = -leftDeta;
        if (contentSize.height < scrollViewSize.height) {
          totalScrollDelta = contentSize.height - scrollViewSize.height;
          moveDelta.y = bottomDeta - totalScrollDelta;
          this.verticalScrollBar && this.verticalScrollBar.hide();
        } else this.verticalScrollBar && this.verticalScrollBar.show();
        if (contentSize.width < scrollViewSize.width) {
          totalScrollDelta = contentSize.width - scrollViewSize.width;
          moveDelta.x = leftDeta;
          this.horizontalScrollBar && this.horizontalScrollBar.hide();
        } else this.horizontalScrollBar && this.horizontalScrollBar.show();
        this._moveContent(moveDelta);
        this._adjustContentOutOfBoundary();
      },
      _calculateBoundary: function() {
        if (this.content) {
          var layout = this.content.getComponent(cc.Layout);
          layout && layout.enabledInHierarchy && layout.updateLayout();
          var viewSize = this.content.parent.getContentSize();
          var leftBottomPosition = this._convertToContentParentSpace(cc.v2(0, 0));
          this._leftBoundary = leftBottomPosition.x;
          this._bottomBoundary = leftBottomPosition.y;
          var topRightPosition = this._convertToContentParentSpace(cc.v2(viewSize.width, viewSize.height));
          this._rightBoundary = topRightPosition.x;
          this._topBoundary = topRightPosition.y;
          true;
          this._moveContentToTopLeft(viewSize);
        }
      },
      _convertToContentParentSpace: function(position) {
        var contentParent = this.content.parent;
        var viewPositionInWorldSpace = contentParent.convertToWorldSpace(position);
        return contentParent.convertToNodeSpaceAR(viewPositionInWorldSpace);
      },
      _hasNestedViewGroup: function(event, captureListeners) {
        if (event.eventPhase !== cc.Event.CAPTURING_PHASE) return;
        if (captureListeners) for (var i = 0; i < captureListeners.length; ++i) {
          var item = captureListeners[i];
          if (this.node === item) {
            if (event.target.getComponent(cc.ViewGroup)) return true;
            return false;
          }
          if (item.getComponent(cc.ViewGroup)) return true;
        }
        return false;
      },
      _stopPropagationIfTargetIsMe: function(event) {
        event.eventPhase === cc.Event.AT_TARGET && event.target === this.node && event.stopPropagation();
      },
      _onTouchBegan: function(event, captureListeners) {
        if (!this.enabledInHierarchy) return;
        if (this._hasNestedViewGroup(event, captureListeners)) return;
        var touch = event.touch;
        this.content && this._handlePressLogic(touch);
        this._touchMoved = false;
        this._stopPropagationIfTargetIsMe(event);
      },
      _onTouchMoved: function(event, captureListeners) {
        if (!this.enabledInHierarchy) return;
        if (this._hasNestedViewGroup(event, captureListeners)) return;
        var touch = event.touch;
        this.content && this._handleMoveLogic(touch);
        if (!this.cancelInnerEvents) return;
        var deltaMove = touch.getLocation().sub(touch.getStartLocation());
        if (deltaMove.mag() > 7 && !this._touchMoved && event.target !== this.node) {
          var cancelEvent = new cc.Event.EventTouch(event.getTouches(), event.bubbles);
          cancelEvent.type = cc.Node.EventType.TOUCH_CANCEL;
          cancelEvent.touch = event.touch;
          cancelEvent.simulate = true;
          event.target.dispatchEvent(cancelEvent);
          this._touchMoved = true;
        }
        this._stopPropagationIfTargetIsMe(event);
      },
      _onTouchEnded: function(event, captureListeners) {
        if (!this.enabledInHierarchy) return;
        if (this._hasNestedViewGroup(event, captureListeners)) return;
        this._dispatchEvent("touch-up");
        var touch = event.touch;
        this.content && this._handleReleaseLogic(touch);
        this._touchMoved ? event.stopPropagation() : this._stopPropagationIfTargetIsMe(event);
      },
      _onTouchCancelled: function(event, captureListeners) {
        if (!this.enabledInHierarchy) return;
        if (this._hasNestedViewGroup(event, captureListeners)) return;
        if (!event.simulate) {
          var touch = event.touch;
          this.content && this._handleReleaseLogic(touch);
        }
        this._stopPropagationIfTargetIsMe(event);
      },
      _processDeltaMove: function(deltaMove) {
        this._scrollChildren(deltaMove);
        this._gatherTouchMove(deltaMove);
      },
      _handleMoveLogic: function(touch) {
        var deltaMove = touch.getDelta();
        this._processDeltaMove(deltaMove);
      },
      _scrollChildren: function(deltaMove) {
        deltaMove = this._clampDelta(deltaMove);
        var realMove = deltaMove;
        var outOfBoundary = void 0;
        if (this.elastic) {
          outOfBoundary = this._getHowMuchOutOfBoundary();
          realMove.x *= 0 === outOfBoundary.x ? 1 : .5;
          realMove.y *= 0 === outOfBoundary.y ? 1 : .5;
        }
        if (!this.elastic) {
          outOfBoundary = this._getHowMuchOutOfBoundary(realMove);
          realMove = realMove.add(outOfBoundary);
        }
        var scrollEventType = -1;
        if (realMove.y > 0) {
          var icBottomPos = this.content.y - this.content.anchorY * this.content.height;
          icBottomPos + realMove.y > this._bottomBoundary && (scrollEventType = "scroll-to-bottom");
        } else if (realMove.y < 0) {
          var icTopPos = this.content.y - this.content.anchorY * this.content.height + this.content.height;
          icTopPos + realMove.y <= this._topBoundary && (scrollEventType = "scroll-to-top");
        } else if (realMove.x < 0) {
          var icRightPos = this.content.x - this.content.anchorX * this.content.width + this.content.width;
          icRightPos + realMove.x <= this._rightBoundary && (scrollEventType = "scroll-to-right");
        } else if (realMove.x > 0) {
          var icLeftPos = this.content.x - this.content.anchorX * this.content.width;
          icLeftPos + realMove.x >= this._leftBoundary && (scrollEventType = "scroll-to-left");
        }
        this._moveContent(realMove, false);
        if (0 !== realMove.x || 0 !== realMove.y) {
          if (!this._scrolling) {
            this._scrolling = true;
            this._dispatchEvent("scroll-began");
          }
          this._dispatchEvent("scrolling");
        }
        -1 !== scrollEventType && this._dispatchEvent(scrollEventType);
      },
      _handlePressLogic: function() {
        this._autoScrolling && this._dispatchEvent("scroll-ended");
        this._autoScrolling = false;
        this._isBouncing = false;
        this._touchMovePreviousTimestamp = getTimeInMilliseconds();
        this._touchMoveDisplacements.length = 0;
        this._touchMoveTimeDeltas.length = 0;
        this._onScrollBarTouchBegan();
      },
      _clampDelta: function(delta) {
        var contentSize = this.content.getContentSize();
        var scrollViewSize = this.node.getContentSize();
        contentSize.width < scrollViewSize.width && (delta.x = 0);
        contentSize.height < scrollViewSize.height && (delta.y = 0);
        return delta;
      },
      _gatherTouchMove: function(delta) {
        delta = this._clampDelta(delta);
        while (this._touchMoveDisplacements.length >= NUMBER_OF_GATHERED_TOUCHES_FOR_MOVE_SPEED) {
          this._touchMoveDisplacements.shift();
          this._touchMoveTimeDeltas.shift();
        }
        this._touchMoveDisplacements.push(delta);
        var timeStamp = getTimeInMilliseconds();
        this._touchMoveTimeDeltas.push((timeStamp - this._touchMovePreviousTimestamp) / 1e3);
        this._touchMovePreviousTimestamp = timeStamp;
      },
      _startBounceBackIfNeeded: function() {
        if (!this.elastic) return false;
        var bounceBackAmount = this._getHowMuchOutOfBoundary();
        bounceBackAmount = this._clampDelta(bounceBackAmount);
        if (bounceBackAmount.fuzzyEquals(cc.v2(0, 0), EPSILON)) return false;
        var bounceBackTime = Math.max(this.bounceDuration, 0);
        this._startAutoScroll(bounceBackAmount, bounceBackTime, true);
        if (!this._isBouncing) {
          bounceBackAmount.y > 0 && this._dispatchEvent("bounce-top");
          bounceBackAmount.y < 0 && this._dispatchEvent("bounce-bottom");
          bounceBackAmount.x > 0 && this._dispatchEvent("bounce-right");
          bounceBackAmount.x < 0 && this._dispatchEvent("bounce-left");
          this._isBouncing = true;
        }
        return true;
      },
      _processInertiaScroll: function() {
        var bounceBackStarted = this._startBounceBackIfNeeded();
        if (!bounceBackStarted && this.inertia) {
          var touchMoveVelocity = this._calculateTouchMoveVelocity();
          !touchMoveVelocity.fuzzyEquals(cc.v2(0, 0), EPSILON) && this.brake < 1 && this._startInertiaScroll(touchMoveVelocity);
        }
        this._onScrollBarTouchEnded();
      },
      _handleReleaseLogic: function(touch) {
        var delta = touch.getDelta();
        this._gatherTouchMove(delta);
        this._processInertiaScroll();
        if (this._scrolling) {
          this._scrolling = false;
          this._autoScrolling || this._dispatchEvent("scroll-ended");
        }
      },
      _isOutOfBoundary: function() {
        var outOfBoundary = this._getHowMuchOutOfBoundary();
        return !outOfBoundary.fuzzyEquals(cc.v2(0, 0), EPSILON);
      },
      _isNecessaryAutoScrollBrake: function() {
        if (this._autoScrollBraking) return true;
        if (this._isOutOfBoundary()) {
          if (!this._autoScrollCurrentlyOutOfBoundary) {
            this._autoScrollCurrentlyOutOfBoundary = true;
            this._autoScrollBraking = true;
            this._autoScrollBrakingStartPosition = this.getContentPosition();
            return true;
          }
        } else this._autoScrollCurrentlyOutOfBoundary = false;
        return false;
      },
      getScrollEndedEventTiming: function() {
        return EPSILON;
      },
      _processAutoScrolling: function(dt) {
        var isAutoScrollBrake = this._isNecessaryAutoScrollBrake();
        var brakingFactor = isAutoScrollBrake ? OUT_OF_BOUNDARY_BREAKING_FACTOR : 1;
        this._autoScrollAccumulatedTime += dt * (1 / brakingFactor);
        var percentage = Math.min(1, this._autoScrollAccumulatedTime / this._autoScrollTotalTime);
        this._autoScrollAttenuate && (percentage = quintEaseOut(percentage));
        var newPosition = this._autoScrollStartPosition.add(this._autoScrollTargetDelta.mul(percentage));
        var reachedEnd = Math.abs(percentage - 1) <= EPSILON;
        var fireEvent = Math.abs(percentage - 1) <= this.getScrollEndedEventTiming();
        if (fireEvent && !this._isScrollEndedWithThresholdEventFired) {
          this._dispatchEvent("scroll-ended-with-threshold");
          this._isScrollEndedWithThresholdEventFired = true;
        }
        if (this.elastic) {
          var brakeOffsetPosition = newPosition.sub(this._autoScrollBrakingStartPosition);
          isAutoScrollBrake && (brakeOffsetPosition = brakeOffsetPosition.mul(brakingFactor));
          newPosition = this._autoScrollBrakingStartPosition.add(brakeOffsetPosition);
        } else {
          var moveDelta = newPosition.sub(this.getContentPosition());
          var outOfBoundary = this._getHowMuchOutOfBoundary(moveDelta);
          if (!outOfBoundary.fuzzyEquals(cc.v2(0, 0), EPSILON)) {
            newPosition = newPosition.add(outOfBoundary);
            reachedEnd = true;
          }
        }
        reachedEnd && (this._autoScrolling = false);
        var deltaMove = newPosition.sub(this.getContentPosition());
        this._moveContent(this._clampDelta(deltaMove), reachedEnd);
        this._dispatchEvent("scrolling");
        if (!this._autoScrolling) {
          this._isBouncing = false;
          this._dispatchEvent("scroll-ended");
        }
      },
      _startInertiaScroll: function(touchMoveVelocity) {
        var inertiaTotalMovement = touchMoveVelocity.mul(MOVEMENT_FACTOR);
        this._startAttenuatingAutoScroll(inertiaTotalMovement, touchMoveVelocity);
      },
      _calculateAttenuatedFactor: function(distance) {
        if (this.brake <= 0) return 1 - this.brake;
        return (1 - this.brake) * (1 / (1 + 14e-6 * distance + distance * distance * 8e-9));
      },
      _startAttenuatingAutoScroll: function(deltaMove, initialVelocity) {
        var time = this._calculateAutoScrollTimeByInitalSpeed(initialVelocity.mag());
        var targetDelta = deltaMove.normalize();
        var contentSize = this.content.getContentSize();
        var scrollviewSize = this.node.getContentSize();
        var totalMoveWidth = contentSize.width - scrollviewSize.width;
        var totalMoveHeight = contentSize.height - scrollviewSize.height;
        var attenuatedFactorX = this._calculateAttenuatedFactor(totalMoveWidth);
        var attenuatedFactorY = this._calculateAttenuatedFactor(totalMoveHeight);
        targetDelta = cc.v2(targetDelta.x * totalMoveWidth * (1 - this.brake) * attenuatedFactorX, targetDelta.y * totalMoveHeight * attenuatedFactorY * (1 - this.brake));
        var originalMoveLength = deltaMove.mag();
        var factor = targetDelta.mag() / originalMoveLength;
        targetDelta = targetDelta.add(deltaMove);
        if (this.brake > 0 && factor > 7) {
          factor = Math.sqrt(factor);
          targetDelta = deltaMove.mul(factor).add(deltaMove);
        }
        if (this.brake > 0 && factor > 3) {
          factor = 3;
          time *= factor;
        }
        0 === this.brake && factor > 1 && (time *= factor);
        this._startAutoScroll(targetDelta, time, true);
      },
      _calculateAutoScrollTimeByInitalSpeed: function(initalSpeed) {
        return Math.sqrt(Math.sqrt(initalSpeed / 5));
      },
      _startAutoScroll: function(deltaMove, timeInSecond, attenuated) {
        var adjustedDeltaMove = this._flattenVectorByDirection(deltaMove);
        this._autoScrolling = true;
        this._autoScrollTargetDelta = adjustedDeltaMove;
        this._autoScrollAttenuate = attenuated;
        this._autoScrollStartPosition = this.getContentPosition();
        this._autoScrollTotalTime = timeInSecond;
        this._autoScrollAccumulatedTime = 0;
        this._autoScrollBraking = false;
        this._isScrollEndedWithThresholdEventFired = false;
        this._autoScrollBrakingStartPosition = cc.v2(0, 0);
        var currentOutOfBoundary = this._getHowMuchOutOfBoundary();
        currentOutOfBoundary.fuzzyEquals(cc.v2(0, 0), EPSILON) || (this._autoScrollCurrentlyOutOfBoundary = true);
      },
      _calculateTouchMoveVelocity: function() {
        var totalTime = 0;
        totalTime = this._touchMoveTimeDeltas.reduce((function(a, b) {
          return a + b;
        }), totalTime);
        if (totalTime <= 0 || totalTime >= .5) return cc.v2(0, 0);
        var totalMovement = cc.v2(0, 0);
        totalMovement = this._touchMoveDisplacements.reduce((function(a, b) {
          return a.add(b);
        }), totalMovement);
        return cc.v2(totalMovement.x * (1 - this.brake) / totalTime, totalMovement.y * (1 - this.brake) / totalTime);
      },
      _flattenVectorByDirection: function(vector) {
        var result = vector;
        result.x = this.horizontal ? result.x : 0;
        result.y = this.vertical ? result.y : 0;
        return result;
      },
      _moveContent: function(deltaMove, canStartBounceBack) {
        var adjustedMove = this._flattenVectorByDirection(deltaMove);
        var newPosition = this.getContentPosition().add(adjustedMove);
        this.setContentPosition(newPosition);
        var outOfBoundary = this._getHowMuchOutOfBoundary();
        this._updateScrollBar(outOfBoundary);
        this.elastic && canStartBounceBack && this._startBounceBackIfNeeded();
      },
      _getContentLeftBoundary: function() {
        var contentPos = this.getContentPosition();
        return contentPos.x - this.content.getAnchorPoint().x * this.content.getContentSize().width;
      },
      _getContentRightBoundary: function() {
        var contentSize = this.content.getContentSize();
        return this._getContentLeftBoundary() + contentSize.width;
      },
      _getContentTopBoundary: function() {
        var contentSize = this.content.getContentSize();
        return this._getContentBottomBoundary() + contentSize.height;
      },
      _getContentBottomBoundary: function() {
        var contentPos = this.getContentPosition();
        return contentPos.y - this.content.getAnchorPoint().y * this.content.getContentSize().height;
      },
      _getHowMuchOutOfBoundary: function(addition) {
        addition = addition || cc.v2(0, 0);
        if (addition.fuzzyEquals(cc.v2(0, 0), EPSILON) && !this._outOfBoundaryAmountDirty) return this._outOfBoundaryAmount;
        var outOfBoundaryAmount = cc.v2(0, 0);
        this._getContentLeftBoundary() + addition.x > this._leftBoundary ? outOfBoundaryAmount.x = this._leftBoundary - (this._getContentLeftBoundary() + addition.x) : this._getContentRightBoundary() + addition.x < this._rightBoundary && (outOfBoundaryAmount.x = this._rightBoundary - (this._getContentRightBoundary() + addition.x));
        this._getContentTopBoundary() + addition.y < this._topBoundary ? outOfBoundaryAmount.y = this._topBoundary - (this._getContentTopBoundary() + addition.y) : this._getContentBottomBoundary() + addition.y > this._bottomBoundary && (outOfBoundaryAmount.y = this._bottomBoundary - (this._getContentBottomBoundary() + addition.y));
        if (addition.fuzzyEquals(cc.v2(0, 0), EPSILON)) {
          this._outOfBoundaryAmount = outOfBoundaryAmount;
          this._outOfBoundaryAmountDirty = false;
        }
        outOfBoundaryAmount = this._clampDelta(outOfBoundaryAmount);
        return outOfBoundaryAmount;
      },
      _updateScrollBar: function(outOfBoundary) {
        this.horizontalScrollBar && this.horizontalScrollBar._onScroll(outOfBoundary);
        this.verticalScrollBar && this.verticalScrollBar._onScroll(outOfBoundary);
      },
      _onScrollBarTouchBegan: function() {
        this.horizontalScrollBar && this.horizontalScrollBar._onTouchBegan();
        this.verticalScrollBar && this.verticalScrollBar._onTouchBegan();
      },
      _onScrollBarTouchEnded: function() {
        this.horizontalScrollBar && this.horizontalScrollBar._onTouchEnded();
        this.verticalScrollBar && this.verticalScrollBar._onTouchEnded();
      },
      _dispatchEvent: function(event) {
        if ("scroll-ended" === event) this._scrollEventEmitMask = 0; else if ("scroll-to-top" === event || "scroll-to-bottom" === event || "scroll-to-left" === event || "scroll-to-right" === event) {
          var flag = 1 << eventMap[event];
          if (this._scrollEventEmitMask & flag) return;
          this._scrollEventEmitMask |= flag;
        }
        cc.Component.EventHandler.emitEvents(this.scrollEvents, this, eventMap[event]);
        this.node.emit(event, this);
      },
      _adjustContentOutOfBoundary: function() {
        this._outOfBoundaryAmountDirty = true;
        if (this._isOutOfBoundary()) {
          var outOfBoundary = this._getHowMuchOutOfBoundary(cc.v2(0, 0));
          var newPosition = this.getContentPosition().add(outOfBoundary);
          if (this.content) {
            this.content.setPosition(newPosition);
            this._updateScrollBar(0);
          }
        }
      },
      start: function() {
        this._calculateBoundary();
        this.content && cc.director.once(cc.Director.EVENT_BEFORE_DRAW, this._adjustContentOutOfBoundary, this);
      },
      _hideScrollbar: function() {
        this.horizontalScrollBar && this.horizontalScrollBar.hide();
        this.verticalScrollBar && this.verticalScrollBar.hide();
      },
      _showScrollbar: function() {
        this.horizontalScrollBar && this.horizontalScrollBar.show();
        this.verticalScrollBar && this.verticalScrollBar.show();
      },
      onDisable: function() {
        true;
        this._unregisterEvent();
        this.node.off(NodeEvent.SIZE_CHANGED, this._calculateBoundary, this);
        this.node.off(NodeEvent.SCALE_CHANGED, this._calculateBoundary, this);
        if (this.content) {
          this.content.off(NodeEvent.SIZE_CHANGED, this._calculateBoundary, this);
          this.content.off(NodeEvent.SCALE_CHANGED, this._calculateBoundary, this);
          if (this.content.parent) {
            this.content.parent.off(NodeEvent.POSITION_CHANGED, this._calculateBoundary, this);
            this.content.parent.off(NodeEvent.SCALE_CHANGED, this._calculateBoundary, this);
            this.content.parent.off(NodeEvent.SIZE_CHANGED, this._calculateBoundary, this);
          }
        }
        this._hideScrollbar();
        this.stopAutoScroll();
      },
      onEnable: function() {
        true;
        this._registerEvent();
        this.node.on(NodeEvent.SIZE_CHANGED, this._calculateBoundary, this);
        this.node.on(NodeEvent.SCALE_CHANGED, this._calculateBoundary, this);
        if (this.content) {
          this.content.on(NodeEvent.SIZE_CHANGED, this._calculateBoundary, this);
          this.content.on(NodeEvent.SCALE_CHANGED, this._calculateBoundary, this);
          if (this.content.parent) {
            this.content.parent.on(NodeEvent.POSITION_CHANGED, this._calculateBoundary, this);
            this.content.parent.on(NodeEvent.SCALE_CHANGED, this._calculateBoundary, this);
            this.content.parent.on(NodeEvent.SIZE_CHANGED, this._calculateBoundary, this);
          }
        }
        this._showScrollbar();
      },
      update: function(dt) {
        this._autoScrolling && this._processAutoScrolling(dt);
      }
    });
    cc.ScrollView = module.exports = ScrollView;
  }), {
    "../CCNode": 25,
    "./CCViewGroup": 77
  } ],
  72: [ (function(require, module, exports) {
    var misc = require("../utils/misc");
    var Component = require("./CCComponent");
    var Direction = cc.Enum({
      Horizontal: 0,
      Vertical: 1
    });
    var Slider = cc.Class({
      name: "cc.Slider",
      extends: Component,
      editor: false,
      ctor: function() {
        this._offset = cc.v2();
        this._touchHandle = false;
        this._dragging = false;
      },
      properties: {
        handle: {
          default: null,
          type: cc.Button,
          tooltip: false,
          notify: function() {
            false;
          }
        },
        direction: {
          default: Direction.Horizontal,
          type: Direction,
          tooltip: false
        },
        progress: {
          default: .5,
          type: cc.Float,
          range: [ 0, 1, .1 ],
          slide: true,
          tooltip: false,
          notify: function() {
            this._updateHandlePosition();
          }
        },
        slideEvents: {
          default: [],
          type: cc.Component.EventHandler,
          tooltip: false
        }
      },
      statics: {
        Direction: Direction
      },
      __preload: function() {
        this._updateHandlePosition();
      },
      onEnable: function() {
        this.node.on(cc.Node.EventType.TOUCH_START, this._onTouchBegan, this);
        this.node.on(cc.Node.EventType.TOUCH_MOVE, this._onTouchMoved, this);
        this.node.on(cc.Node.EventType.TOUCH_END, this._onTouchEnded, this);
        this.node.on(cc.Node.EventType.TOUCH_CANCEL, this._onTouchCancelled, this);
        if (this.handle && this.handle.isValid) {
          this.handle.node.on(cc.Node.EventType.TOUCH_START, this._onHandleDragStart, this);
          this.handle.node.on(cc.Node.EventType.TOUCH_MOVE, this._onTouchMoved, this);
          this.handle.node.on(cc.Node.EventType.TOUCH_END, this._onTouchEnded, this);
        }
      },
      onDisable: function() {
        this.node.off(cc.Node.EventType.TOUCH_START, this._onTouchBegan, this);
        this.node.off(cc.Node.EventType.TOUCH_MOVE, this._onTouchMoved, this);
        this.node.off(cc.Node.EventType.TOUCH_END, this._onTouchEnded, this);
        this.node.off(cc.Node.EventType.TOUCH_CANCEL, this._onTouchCancelled, this);
        if (this.handle && this.handle.isValid) {
          this.handle.node.off(cc.Node.EventType.TOUCH_START, this._onHandleDragStart, this);
          this.handle.node.off(cc.Node.EventType.TOUCH_MOVE, this._onTouchMoved, this);
          this.handle.node.off(cc.Node.EventType.TOUCH_END, this._onTouchEnded, this);
        }
      },
      _onHandleDragStart: function(event) {
        this._dragging = true;
        this._touchHandle = true;
        this._offset = this.handle.node.convertToNodeSpaceAR(event.touch.getLocation());
        event.stopPropagation();
      },
      _onTouchBegan: function(event) {
        if (!this.handle) return;
        this._dragging = true;
        this._touchHandle || this._handleSliderLogic(event.touch);
        event.stopPropagation();
      },
      _onTouchMoved: function(event) {
        if (!this._dragging) return;
        this._handleSliderLogic(event.touch);
        event.stopPropagation();
      },
      _onTouchEnded: function(event) {
        this._dragging = false;
        this._touchHandle = false;
        this._offset = cc.v2();
        event.stopPropagation();
      },
      _onTouchCancelled: function(event) {
        this._dragging = false;
        event.stopPropagation();
      },
      _handleSliderLogic: function(touch) {
        this._updateProgress(touch);
        this._emitSlideEvent();
      },
      _emitSlideEvent: function() {
        cc.Component.EventHandler.emitEvents(this.slideEvents, this);
        this.node.emit("slide", this);
      },
      _updateProgress: function(touch) {
        if (!this.handle) return;
        var localTouchPos = this.node.convertToNodeSpaceAR(touch.getLocation());
        this.direction === Direction.Horizontal ? this.progress = misc.clamp01(.5 + (localTouchPos.x - this._offset.x) / this.node.width) : this.progress = misc.clamp01(.5 + (localTouchPos.y - this._offset.y) / this.node.height);
      },
      _updateHandlePosition: function() {
        if (!this.handle) return;
        var handlelocalPos;
        handlelocalPos = this.direction === Direction.Horizontal ? cc.v2(-this.node.width * this.node.anchorX + this.progress * this.node.width, 0) : cc.v2(0, -this.node.height * this.node.anchorY + this.progress * this.node.height);
        var worldSpacePos = this.node.convertToWorldSpaceAR(handlelocalPos);
        this.handle.node.position = this.handle.node.parent.convertToNodeSpaceAR(worldSpacePos);
      }
    });
    cc.Slider = module.exports = Slider;
  }), {
    "../utils/misc": 208,
    "./CCComponent": 59
  } ],
  73: [ (function(require, module, exports) {
    var misc = require("../utils/misc");
    var NodeEvent = require("../CCNode").EventType;
    var RenderComponent = require("./CCRenderComponent");
    var RenderFlow = require("../renderer/render-flow");
    var renderEngine = require("../renderer/render-engine");
    var SpriteMaterial = renderEngine.SpriteMaterial;
    var GraySpriteMaterial = renderEngine.GraySpriteMaterial;
    var SpriteType = cc.Enum({
      SIMPLE: 0,
      SLICED: 1,
      TILED: 2,
      FILLED: 3,
      MESH: 4
    });
    var FillType = cc.Enum({
      HORIZONTAL: 0,
      VERTICAL: 1,
      RADIAL: 2
    });
    var SizeMode = cc.Enum({
      CUSTOM: 0,
      TRIMMED: 1,
      RAW: 2
    });
    var State = cc.Enum({
      NORMAL: 0,
      GRAY: 1
    });
    var Sprite = cc.Class({
      name: "cc.Sprite",
      extends: RenderComponent,
      ctor: function() {
        this._assembler = null;
        this._graySpriteMaterial = null;
        this._spriteMaterial = null;
      },
      editor: false,
      properties: {
        _spriteFrame: {
          default: null,
          type: cc.SpriteFrame
        },
        _type: SpriteType.SIMPLE,
        _sizeMode: SizeMode.TRIMMED,
        _fillType: 0,
        _fillCenter: cc.v2(0, 0),
        _fillStart: 0,
        _fillRange: 0,
        _isTrimmedMode: true,
        _state: 0,
        _atlas: {
          default: null,
          type: cc.SpriteAtlas,
          tooltip: false,
          editorOnly: true,
          visible: true,
          animatable: false
        },
        spriteFrame: {
          get: function() {
            return this._spriteFrame;
          },
          set: function(value, force) {
            var lastSprite = this._spriteFrame;
            false;
            if (lastSprite === value) return;
            this._spriteFrame = value;
            this.markForUpdateRenderData(false);
            this._applySpriteFrame(lastSprite);
            false;
          },
          type: cc.SpriteFrame
        },
        type: {
          get: function() {
            return this._type;
          },
          set: function(value) {
            if (this._type !== value) {
              this.destroyRenderData(this._renderData);
              this._renderData = null;
              this._type = value;
              this._updateAssembler();
            }
          },
          type: SpriteType,
          animatable: false,
          tooltip: false
        },
        fillType: {
          get: function() {
            return this._fillType;
          },
          set: function(value) {
            if (value !== this._fillType) {
              if (value === FillType.RADIAL || this._fillType === FillType.RADIAL) {
                this.destroyRenderData(this._renderData);
                this._renderData = null;
              } else this._renderData && this.markForUpdateRenderData(true);
              this._fillType = value;
              this._updateAssembler();
            }
          },
          type: FillType,
          tooltip: false
        },
        fillCenter: {
          get: function() {
            return this._fillCenter;
          },
          set: function(value) {
            this._fillCenter.x = value.x;
            this._fillCenter.y = value.y;
            this._type === SpriteType.FILLED && this._renderData && this.markForUpdateRenderData(true);
          },
          tooltip: false
        },
        fillStart: {
          get: function() {
            return this._fillStart;
          },
          set: function(value) {
            this._fillStart = misc.clampf(value, -1, 1);
            this._type === SpriteType.FILLED && this._renderData && this.markForUpdateRenderData(true);
          },
          tooltip: false
        },
        fillRange: {
          get: function() {
            return this._fillRange;
          },
          set: function(value) {
            this._fillRange = misc.clampf(value, -1, 1);
            this._type === SpriteType.FILLED && this._renderData && this.markForUpdateRenderData(true);
          },
          tooltip: false
        },
        trim: {
          get: function() {
            return this._isTrimmedMode;
          },
          set: function(value) {
            if (this._isTrimmedMode !== value) {
              this._isTrimmedMode = value;
              this._type !== SpriteType.SIMPLE && this._type !== SpriteType.MESH || !this._renderData || this.markForUpdateRenderData(true);
            }
          },
          animatable: false,
          tooltip: false
        },
        sizeMode: {
          get: function() {
            return this._sizeMode;
          },
          set: function(value) {
            this._sizeMode = value;
            value !== SizeMode.CUSTOM && this._applySpriteSize();
          },
          animatable: false,
          type: SizeMode,
          tooltip: false
        }
      },
      statics: {
        FillType: FillType,
        Type: SpriteType,
        SizeMode: SizeMode,
        State: State
      },
      setVisible: function(visible) {
        this.enabled = visible;
      },
      setState: function(state) {
        if (this._state === state) return;
        this._state = state;
        this._activateMaterial();
      },
      getState: function() {
        return this._state;
      },
      onEnable: function() {
        this._super();
        if (!this._spriteFrame || !this._spriteFrame.textureLoaded()) {
          this.disableRender();
          if (this._spriteFrame) {
            this._spriteFrame.once("load", this._onTextureLoaded, this);
            this._spriteFrame.ensureLoadTexture();
          }
        }
        this._updateAssembler();
        this.markForUpdateRenderData(true);
        this.node.on(NodeEvent.SIZE_CHANGED, this._onNodeSizeDirty, this);
        this.node.on(NodeEvent.ANCHOR_CHANGED, this._onNodeSizeDirty, this);
      },
      onDisable: function() {
        this._super();
        this.node.off(NodeEvent.SIZE_CHANGED, this._onNodeSizeDirty, this);
        this.node.off(NodeEvent.ANCHOR_CHANGED, this._onNodeSizeDirty, this);
      },
      _onNodeSizeDirty: function() {
        if (!this._renderData) return;
        this.markForUpdateRenderData(true);
      },
      _updateAssembler: function() {
        var assembler = Sprite._assembler.getAssembler(this);
        if (this._assembler !== assembler) {
          this._assembler = assembler;
          this._renderData = null;
        }
        if (!this._renderData) {
          this._renderData = this._assembler.createData(this);
          this._renderData.material = this._material;
          this.markForUpdateRenderData(true);
        }
      },
      _activateMaterial: function() {
        if (!this.enabledInHierarchy) {
          this.disableRender();
          return;
        }
        var spriteFrame = this._spriteFrame;
        if (!spriteFrame || !spriteFrame.textureLoaded()) {
          this.disableRender();
          return;
        }
        if (cc.game.renderType !== cc.game.RENDER_TYPE_CANVAS) {
          var texture = spriteFrame.getTexture();
          var material = void 0;
          if (this._state === State.GRAY) {
            if (!this._graySpriteMaterial) {
              this._graySpriteMaterial = new GraySpriteMaterial();
              this.node._renderFlag |= RenderFlow.FLAG_COLOR;
            }
            material = this._graySpriteMaterial;
          } else {
            if (!this._spriteMaterial) {
              this._spriteMaterial = new SpriteMaterial();
              this.node._renderFlag |= RenderFlow.FLAG_COLOR;
            }
            material = this._spriteMaterial;
          }
          if (material.texture !== texture) {
            material.texture = texture;
            this._updateMaterial(material);
          } else material !== this._material && this._updateMaterial(material);
          this._renderData && (this._renderData.material = material);
        }
        this.markForUpdateRenderData(true);
        this.markForRender(true);
      },
      _applyAtlas: false,
      _canRender: function() {
        if (cc.game.renderType === cc.game.RENDER_TYPE_CANVAS) {
          if (!this._enabled) return false;
        } else if (!this._enabled || !this._material) return false;
        var spriteFrame = this._spriteFrame;
        if (!spriteFrame || !spriteFrame.textureLoaded()) return false;
        return true;
      },
      markForUpdateRenderData: function(enable) {
        if (enable && this._canRender()) {
          this.node._renderFlag |= RenderFlow.FLAG_UPDATE_RENDER_DATA;
          var renderData = this._renderData;
          if (renderData) {
            renderData.uvDirty = true;
            renderData.vertDirty = true;
          }
        } else enable || (this.node._renderFlag &= ~RenderFlow.FLAG_UPDATE_RENDER_DATA);
      },
      _applySpriteSize: function() {
        if (this._spriteFrame) {
          if (SizeMode.RAW === this._sizeMode) {
            var size = this._spriteFrame.getOriginalSize();
            this.node.setContentSize(size);
          } else if (SizeMode.TRIMMED === this._sizeMode) {
            var rect = this._spriteFrame.getRect();
            this.node.setContentSize(rect.width, rect.height);
          }
          this._activateMaterial();
        }
      },
      _onTextureLoaded: function() {
        if (!this.isValid) return;
        this._applySpriteSize();
      },
      _applySpriteFrame: function(oldFrame) {
        oldFrame && oldFrame.off && oldFrame.off("load", this._onTextureLoaded, this);
        var spriteFrame = this._spriteFrame;
        spriteFrame && (this._material && this._material._texture) === (spriteFrame && spriteFrame._texture) || this.markForRender(false);
        if (spriteFrame) if (oldFrame && spriteFrame._texture === oldFrame._texture) this._applySpriteSize(); else if (spriteFrame.textureLoaded()) this._onTextureLoaded(null); else {
          spriteFrame.once("load", this._onTextureLoaded, this);
          spriteFrame.ensureLoadTexture();
        }
        false;
      },
      _resized: false
    });
    false;
    cc.Sprite = module.exports = Sprite;
  }), {
    "../CCNode": 25,
    "../renderer/render-engine": 174,
    "../renderer/render-flow": 175,
    "../utils/misc": 208,
    "./CCRenderComponent": 68
  } ],
  74: [ (function(require, module, exports) {
    var Toggle = cc.Class({
      name: "cc.Toggle",
      extends: require("./CCButton"),
      editor: false,
      properties: {
        isChecked: {
          default: true,
          tooltip: false,
          notify: function() {
            this._updateCheckMark();
          }
        },
        toggleGroup: {
          default: null,
          tooltip: false,
          type: require("./CCToggleGroup")
        },
        checkMark: {
          default: null,
          type: cc.Sprite,
          tooltip: false
        },
        checkEvents: {
          default: [],
          type: cc.Component.EventHandler
        },
        _resizeToTarget: {
          animatable: false,
          set: function(value) {
            value && this._resizeNodeToTargetNode();
          }
        }
      },
      onEnable: function() {
        this._super();
        true;
        this._registerToggleEvent();
        this.toggleGroup && this.toggleGroup.enabled && this.toggleGroup.addToggle(this);
      },
      onDisable: function() {
        this._super();
        true;
        this._unregisterToggleEvent();
        this.toggleGroup && this.toggleGroup.enabled && this.toggleGroup.removeToggle(this);
      },
      _updateCheckMark: function() {
        this.checkMark && (this.checkMark.node.active = !!this.isChecked);
      },
      _updateDisabledState: function() {
        this._super();
        this.checkMark && this.checkMark.setState(0);
        this.enableAutoGrayEffect && this.checkMark && !this.interactable && this.checkMark.setState(1);
      },
      _registerToggleEvent: function() {
        this.node.on("click", this.toggle, this);
      },
      _unregisterToggleEvent: function() {
        this.node.off("click", this.toggle, this);
      },
      toggle: function(event) {
        var group = this.toggleGroup || this._toggleContainer;
        if (group && group.enabled && this.isChecked && !group.allowSwitchOff) return;
        this.isChecked = !this.isChecked;
        this._updateCheckMark();
        group && group.enabled && group.updateToggles(this);
        this._emitToggleEvents(event);
      },
      _emitToggleEvents: function() {
        this.node.emit("toggle", this);
        this.checkEvents && cc.Component.EventHandler.emitEvents(this.checkEvents, this);
      },
      check: function() {
        var group = this.toggleGroup || this._toggleContainer;
        if (group && group.enabled && this.isChecked && !group.allowSwitchOff) return;
        this.isChecked = true;
        group && group.enabled && group.updateToggles(this);
        this._emitToggleEvents();
      },
      uncheck: function() {
        var group = this.toggleGroup || this._toggleContainer;
        if (group && group.enabled && this.isChecked && !group.allowSwitchOff) return;
        this.isChecked = false;
        this._emitToggleEvents();
      }
    });
    cc.Toggle = module.exports = Toggle;
    var js = require("../platform/js");
    js.get(Toggle.prototype, "_toggleContainer", (function() {
      var parent = this.node.parent;
      if (cc.Node.isNode(parent)) return parent.getComponent(cc.ToggleContainer);
      return null;
    }));
  }), {
    "../platform/js": 167,
    "./CCButton": 57,
    "./CCToggleGroup": 76
  } ],
  75: [ (function(require, module, exports) {
    var ToggleContainer = cc.Class({
      name: "cc.ToggleContainer",
      extends: cc.Component,
      editor: false,
      properties: {
        allowSwitchOff: {
          tooltip: false,
          default: false
        }
      },
      updateToggles: function(toggle) {
        this.toggleItems.forEach((function(item) {
          toggle.isChecked && item !== toggle && (item.isChecked = false);
        }));
      },
      _allowOnlyOneToggleChecked: function() {
        var isChecked = false;
        this.toggleItems.forEach((function(item) {
          isChecked ? item.isChecked = false : item.isChecked && (isChecked = true);
        }));
        return isChecked;
      },
      _makeAtLeastOneToggleChecked: function() {
        var isChecked = this._allowOnlyOneToggleChecked();
        if (!isChecked && !this.allowSwitchOff) {
          var toggleItems = this.toggleItems;
          toggleItems.length > 0 && toggleItems[0].check();
        }
      },
      onEnable: function() {
        this.node.on("child-added", this._allowOnlyOneToggleChecked, this);
        this.node.on("child-removed", this._makeAtLeastOneToggleChecked, this);
      },
      onDisable: function() {
        this.node.off("child-added", this._allowOnlyOneToggleChecked, this);
        this.node.off("child-removed", this._makeAtLeastOneToggleChecked, this);
      },
      start: function() {
        this._makeAtLeastOneToggleChecked();
      }
    });
    var js = require("../platform/js");
    js.get(ToggleContainer.prototype, "toggleItems", (function() {
      return this.node.getComponentsInChildren(cc.Toggle);
    }));
    cc.ToggleContainer = module.exports = ToggleContainer;
  }), {
    "../platform/js": 167
  } ],
  76: [ (function(require, module, exports) {
    var ToggleGroup = cc.Class({
      name: "cc.ToggleGroup",
      extends: cc.Component,
      ctor: function() {
        this._toggleItems = [];
      },
      editor: false,
      properties: {
        allowSwitchOff: {
          tooltip: false,
          default: false
        },
        toggleItems: {
          get: function() {
            return this._toggleItems;
          }
        }
      },
      updateToggles: function(toggle) {
        if (!this.enabledInHierarchy) return;
        this._toggleItems.forEach((function(item) {
          toggle.isChecked && item !== toggle && item.isChecked && item.enabled && (item.isChecked = false);
        }));
      },
      addToggle: function(toggle) {
        var index = this._toggleItems.indexOf(toggle);
        -1 === index && this._toggleItems.push(toggle);
        this._allowOnlyOneToggleChecked();
      },
      removeToggle: function(toggle) {
        var index = this._toggleItems.indexOf(toggle);
        index > -1 && this._toggleItems.splice(index, 1);
        this._makeAtLeastOneToggleChecked();
      },
      _allowOnlyOneToggleChecked: function() {
        var isChecked = false;
        this._toggleItems.forEach((function(item) {
          isChecked && item.enabled && (item.isChecked = false);
          item.isChecked && item.enabled && (isChecked = true);
        }));
        return isChecked;
      },
      _makeAtLeastOneToggleChecked: function() {
        var isChecked = this._allowOnlyOneToggleChecked();
        isChecked || this.allowSwitchOff || this._toggleItems.length > 0 && (this._toggleItems[0].isChecked = true);
      },
      start: function() {
        this._makeAtLeastOneToggleChecked();
      }
    });
    var js = require("../platform/js");
    var showed = false;
    js.get(cc, "ToggleGroup", (function() {
      if (!showed) {
        cc.logID(1405, "cc.ToggleGroup", "cc.ToggleContainer");
        showed = true;
      }
      return ToggleGroup;
    }));
    module.exports = ToggleGroup;
  }), {
    "../platform/js": 167
  } ],
  77: [ (function(require, module, exports) {
    var ViewGroup = cc.Class({
      name: "cc.ViewGroup",
      extends: require("./CCComponent")
    });
    cc.ViewGroup = module.exports = ViewGroup;
  }), {
    "./CCComponent": 59
  } ],
  78: [ (function(require, module, exports) {
    var WidgetManager = require("../base-ui/CCWidgetManager");
    var AlignMode = WidgetManager.AlignMode;
    var AlignFlags = WidgetManager._AlignFlags;
    var TOP = AlignFlags.TOP;
    var MID = AlignFlags.MID;
    var BOT = AlignFlags.BOT;
    var LEFT = AlignFlags.LEFT;
    var CENTER = AlignFlags.CENTER;
    var RIGHT = AlignFlags.RIGHT;
    var TOP_BOT = TOP | BOT;
    var LEFT_RIGHT = LEFT | RIGHT;
    var Widget = cc.Class({
      name: "cc.Widget",
      extends: require("./CCComponent"),
      editor: false,
      properties: {
        target: {
          get: function() {
            return this._target;
          },
          set: function(value) {
            this._target = value;
            false;
          },
          type: cc.Node,
          tooltip: false
        },
        isAlignTop: {
          get: function() {
            return (this._alignFlags & TOP) > 0;
          },
          set: function(value) {
            this._setAlign(TOP, value);
          },
          animatable: false,
          tooltip: false
        },
        isAlignVerticalCenter: {
          get: function() {
            return (this._alignFlags & MID) > 0;
          },
          set: function(value) {
            if (value) {
              this.isAlignTop = false;
              this.isAlignBottom = false;
              this._alignFlags |= MID;
            } else this._alignFlags &= ~MID;
          },
          animatable: false,
          tooltip: false
        },
        isAlignBottom: {
          get: function() {
            return (this._alignFlags & BOT) > 0;
          },
          set: function(value) {
            this._setAlign(BOT, value);
          },
          animatable: false,
          tooltip: false
        },
        isAlignLeft: {
          get: function() {
            return (this._alignFlags & LEFT) > 0;
          },
          set: function(value) {
            this._setAlign(LEFT, value);
          },
          animatable: false,
          tooltip: false
        },
        isAlignHorizontalCenter: {
          get: function() {
            return (this._alignFlags & CENTER) > 0;
          },
          set: function(value) {
            if (value) {
              this.isAlignLeft = false;
              this.isAlignRight = false;
              this._alignFlags |= CENTER;
            } else this._alignFlags &= ~CENTER;
          },
          animatable: false,
          tooltip: false
        },
        isAlignRight: {
          get: function() {
            return (this._alignFlags & RIGHT) > 0;
          },
          set: function(value) {
            this._setAlign(RIGHT, value);
          },
          animatable: false,
          tooltip: false
        },
        isStretchWidth: {
          get: function() {
            return (this._alignFlags & LEFT_RIGHT) === LEFT_RIGHT;
          },
          visible: false
        },
        isStretchHeight: {
          get: function() {
            return (this._alignFlags & TOP_BOT) === TOP_BOT;
          },
          visible: false
        },
        top: {
          get: function() {
            return this._top;
          },
          set: function(value) {
            this._top = value;
          },
          tooltip: false
        },
        bottom: {
          get: function() {
            return this._bottom;
          },
          set: function(value) {
            this._bottom = value;
          },
          tooltip: false
        },
        left: {
          get: function() {
            return this._left;
          },
          set: function(value) {
            this._left = value;
          },
          tooltip: false
        },
        right: {
          get: function() {
            return this._right;
          },
          set: function(value) {
            this._right = value;
          },
          tooltip: false
        },
        horizontalCenter: {
          get: function() {
            return this._horizontalCenter;
          },
          set: function(value) {
            this._horizontalCenter = value;
          },
          tooltip: false
        },
        verticalCenter: {
          get: function() {
            return this._verticalCenter;
          },
          set: function(value) {
            this._verticalCenter = value;
          },
          tooltip: false
        },
        isAbsoluteHorizontalCenter: {
          get: function() {
            return this._isAbsHorizontalCenter;
          },
          set: function(value) {
            this._isAbsHorizontalCenter = value;
          },
          animatable: false
        },
        isAbsoluteVerticalCenter: {
          get: function() {
            return this._isAbsVerticalCenter;
          },
          set: function(value) {
            this._isAbsVerticalCenter = value;
          },
          animatable: false
        },
        isAbsoluteTop: {
          get: function() {
            return this._isAbsTop;
          },
          set: function(value) {
            this._isAbsTop = value;
          },
          animatable: false
        },
        isAbsoluteBottom: {
          get: function() {
            return this._isAbsBottom;
          },
          set: function(value) {
            this._isAbsBottom = value;
          },
          animatable: false
        },
        isAbsoluteLeft: {
          get: function() {
            return this._isAbsLeft;
          },
          set: function(value) {
            this._isAbsLeft = value;
          },
          animatable: false
        },
        isAbsoluteRight: {
          get: function() {
            return this._isAbsRight;
          },
          set: function(value) {
            this._isAbsRight = value;
          },
          animatable: false
        },
        alignMode: {
          default: AlignMode.ON_WINDOW_RESIZE,
          type: AlignMode,
          tooltip: false
        },
        _wasAlignOnce: {
          default: void 0,
          formerlySerializedAs: "isAlignOnce"
        },
        _target: null,
        _alignFlags: 0,
        _left: 0,
        _right: 0,
        _top: 0,
        _bottom: 0,
        _verticalCenter: 0,
        _horizontalCenter: 0,
        _isAbsLeft: true,
        _isAbsRight: true,
        _isAbsTop: true,
        _isAbsBottom: true,
        _isAbsHorizontalCenter: true,
        _isAbsVerticalCenter: true,
        _originalWidth: 0,
        _originalHeight: 0
      },
      statics: {
        AlignMode: AlignMode
      },
      onLoad: function() {
        if (void 0 !== this._wasAlignOnce) {
          this.alignMode = this._wasAlignOnce ? AlignMode.ONCE : AlignMode.ALWAYS;
          this._wasAlignOnce = void 0;
        }
      },
      onEnable: function() {
        WidgetManager.add(this);
      },
      onDisable: function() {
        WidgetManager.remove(this);
      },
      _setAlign: function(flag, isAlign) {
        var current = (this._alignFlags & flag) > 0;
        if (isAlign == current) return;
        var isHorizontal = (flag & LEFT_RIGHT) > 0;
        if (isAlign) {
          this._alignFlags |= flag;
          if (isHorizontal) {
            this.isAlignHorizontalCenter = false;
            if (this.isStretchWidth) {
              this._originalWidth = this.node.width;
              false;
            }
          } else {
            this.isAlignVerticalCenter = false;
            if (this.isStretchHeight) {
              this._originalHeight = this.node.height;
              false;
            }
          }
          false;
        } else {
          isHorizontal ? this.isStretchWidth && (this.node.width = this._originalWidth) : this.isStretchHeight && (this.node.height = this._originalHeight);
          this._alignFlags &= ~flag;
        }
      },
      updateAlignment: function() {
        WidgetManager.updateAlignment(this.node);
      }
    });
    Object.defineProperty(Widget.prototype, "isAlignOnce", {
      get: function() {
        true;
        cc.warn("`widget.isAlignOnce` is deprecated, use `widget.alignMode === cc.Widget.AlignMode.ONCE` instead please.");
        return this.alignMode === AlignMode.ONCE;
      },
      set: function(value) {
        true;
        cc.warn("`widget.isAlignOnce` is deprecated, use `widget.alignMode = cc.Widget.AlignMode.*` instead please.");
        this.alignMode = value ? AlignMode.ONCE : AlignMode.ALWAYS;
      }
    });
    cc.Widget = module.exports = Widget;
  }), {
    "../base-ui/CCWidgetManager": 45,
    "./CCComponent": 59
  } ],
  79: [ (function(require, module, exports) {
    var Component = require("./CCComponent");
    var WXSubContextView = void 0;
    true, false;
    WXSubContextView = cc.Class({
      name: "cc.WXSubContextView",
      extends: Component,
      editor: false,
      ctor: function() {
        this._sprite = null;
        this._tex = new cc.Texture2D();
        this._context = null;
      },
      onLoad: function() {
        if (wx.getOpenDataContext) {
          this._context = wx.getOpenDataContext();
          var sharedCanvas = this._context.canvas;
          if (sharedCanvas) {
            sharedCanvas.width = this.node.width;
            sharedCanvas.height = this.node.height;
          }
          this._tex.setPremultiplyAlpha(true);
          this._tex.initWithElement(sharedCanvas);
          this._sprite = this.node.getComponent(cc.Sprite);
          if (!this._sprite) {
            this._sprite = this.node.addComponent(cc.Sprite);
            this._sprite.srcBlendFactor = cc.macro.BlendFactor.ONE;
          }
          this._sprite.spriteFrame = new cc.SpriteFrame(this._tex);
        } else this.enabled = false;
      },
      onEnable: function() {
        this.updateSubContextViewport();
      },
      update: function() {
        if (!this._tex || !this._context) return;
        this._tex.initWithElement(this._context.canvas);
        this._sprite._activateMaterial();
      },
      updateSubContextViewport: function() {
        if (this._context) {
          var box = this.node.getBoundingBoxToWorld();
          var sx = cc.view._scaleX;
          var sy = cc.view._scaleY;
          this._context.postMessage({
            fromEngine: true,
            event: "viewport",
            x: box.x * sx + cc.view._viewportRect.x,
            y: box.y * sy + cc.view._viewportRect.y,
            width: box.width * sx,
            height: box.height * sy
          });
        }
      }
    });
    cc.WXSubContextView = module.exports = WXSubContextView;
  }), {
    "./CCComponent": 59
  } ],
  80: [ (function(require, module, exports) {
    var macro = require("../../platform/CCMacro");
    var EditBoxImpl = require("../editbox/CCEditBoxImpl");
    var Label = require("../CCLabel");
    var Types = require("./types");
    var InputMode = Types.InputMode;
    var InputFlag = Types.InputFlag;
    var KeyboardReturnType = Types.KeyboardReturnType;
    var LEFT_PADDING = 2;
    function capitalize(string) {
      return string.replace(/(?:^|\s)\S/g, (function(a) {
        return a.toUpperCase();
      }));
    }
    function capitalizeFirstLetter(string) {
      return string.charAt(0).toUpperCase() + string.slice(1);
    }
    var EditBox = cc.Class({
      name: "cc.EditBox",
      extends: cc.Component,
      editor: false,
      properties: {
        _useOriginalSize: true,
        _string: "",
        string: {
          tooltip: false,
          get: function() {
            return this._string;
          },
          set: function(value) {
            value.length >= this.maxLength && (value = value.slice(0, this.maxLength));
            this._string = value;
            this._impl && this._updateString(value);
          }
        },
        backgroundImage: {
          tooltip: false,
          default: null,
          type: cc.SpriteFrame,
          notify: function() {
            this._createBackgroundSprite();
          }
        },
        returnType: {
          default: KeyboardReturnType.DEFAULT,
          tooltip: false,
          displayName: "KeyboardReturnType",
          type: KeyboardReturnType,
          notify: function() {
            this._impl && (this._impl.returnType = this.returnType);
          }
        },
        inputFlag: {
          tooltip: false,
          default: InputFlag.DEFAULT,
          type: InputFlag,
          notify: function() {
            if (this._impl) {
              this._impl.setInputFlag(this.inputFlag);
              this._updateString(this._string);
            }
          }
        },
        inputMode: {
          tooltip: false,
          default: InputMode.ANY,
          type: InputMode,
          notify: function() {
            this._impl && this._impl.setInputMode(this.inputMode);
          }
        },
        fontSize: {
          tooltip: false,
          default: 20,
          notify: function() {
            this._textLabel && (this._textLabel.fontSize = this.fontSize);
            this._impl && this._impl.setFontSize(this.fontSize);
          }
        },
        lineHeight: {
          tooltip: false,
          default: 40,
          notify: function() {
            this._textLabel && (this._textLabel.lineHeight = this.lineHeight);
          }
        },
        fontColor: {
          tooltip: false,
          default: cc.Color.WHITE,
          notify: function() {
            if (this._textLabel) {
              this._textLabel.node.opacity = this.fontColor.a;
              this._textLabel.node.color = this.fontColor;
            }
            this._impl && this._impl.setFontColor(this.fontColor);
          }
        },
        placeholder: {
          tooltip: false,
          default: "Enter text here...",
          notify: function() {
            this._placeholderLabel && (this._placeholderLabel.string = this.placeholder);
            this._impl && this._impl.setPlaceholderText(this.placeholder);
          }
        },
        placeholderFontSize: {
          tooltip: false,
          default: 20,
          notify: function() {
            this._placeholderLabel && (this._placeholderLabel.fontSize = this.placeholderFontSize);
          }
        },
        placeholderFontColor: {
          tooltip: false,
          default: cc.Color.GRAY,
          notify: function() {
            if (this._placeholderLabel) {
              this._placeholderLabel.node.color = this.placeholderFontColor;
              this._placeholderLabel.node.opacity = this.placeholderFontColor.a;
            }
          }
        },
        maxLength: {
          tooltip: false,
          default: 20,
          notify: function() {
            this._impl && this._impl.setMaxLength(this.maxLength);
          }
        },
        stayOnTop: {
          tooltip: false,
          default: false,
          notify: function() {
            this._impl && this._updateStayOnTop();
          }
        },
        _tabIndex: 0,
        tabIndex: {
          tooltip: false,
          get: function() {
            return this._tabIndex;
          },
          set: function(value) {
            this._tabIndex = value;
            this._impl && this._impl.setTabIndex(value);
          }
        },
        editingDidBegan: {
          default: [],
          type: cc.Component.EventHandler
        },
        textChanged: {
          default: [],
          type: cc.Component.EventHandler
        },
        editingDidEnded: {
          default: [],
          type: cc.Component.EventHandler
        },
        editingReturn: {
          default: [],
          type: cc.Component.EventHandler
        }
      },
      statics: {
        _EditBoxImpl: EditBoxImpl,
        KeyboardReturnType: KeyboardReturnType,
        InputFlag: InputFlag,
        InputMode: InputMode
      },
      _init: function() {
        this._createBackgroundSprite();
        this._createLabels();
        var impl = this._impl = new EditBoxImpl();
        impl.setDelegate(this);
        impl.setNode(this.node);
        impl.setInputMode(this.inputMode);
        impl.setMaxLength(this.maxLength);
        impl.setInputFlag(this.inputFlag);
        impl.setReturnType(this.returnType);
        impl.setTabIndex(this.tabIndex);
        impl.setFontColor(this.fontColor);
        impl.setFontSize(this.fontSize);
        impl.setPlaceholderText(this.placeholder);
        this._updateStayOnTop();
        this._updateString(this.string);
        this._syncSize();
      },
      _updateStayOnTop: function() {
        this.stayOnTop ? this._hideLabels() : this._showLabels();
        this._impl.stayOnTop(this.stayOnTop);
      },
      _syncSize: function() {
        var size = this.node.getContentSize();
        this._background.node.setAnchorPoint(this.node.getAnchorPoint());
        this._background.node.setContentSize(size);
        this._updateLabelPosition(size);
        this._impl.setSize(size.width, size.height);
      },
      _updateLabelPosition: function(size) {
        var node = this.node;
        var offx = -node.anchorX * node.width;
        var offy = -node.anchorY * node.height;
        var placeholderLabel = this._placeholderLabel;
        var textLabel = this._textLabel;
        textLabel.node.setContentSize(size.width - LEFT_PADDING, size.height);
        placeholderLabel.node.setContentSize(size.width - LEFT_PADDING, size.height);
        placeholderLabel.lineHeight = size.height;
        placeholderLabel.node.setPosition(offx + LEFT_PADDING, offy + size.height);
        textLabel.node.setPosition(offx + LEFT_PADDING, offy + size.height);
        if (this.inputMode === InputMode.ANY) {
          placeholderLabel.verticalAlign = macro.VerticalTextAlignment.TOP;
          placeholderLabel.enableWrapText = true;
          textLabel.verticalAlign = macro.VerticalTextAlignment.TOP;
          textLabel.enableWrapText = true;
        } else {
          placeholderLabel.verticalAlign = macro.VerticalTextAlignment.CENTER;
          placeholderLabel.enableWrapText = false;
          textLabel.verticalAlign = macro.VerticalTextAlignment.CENTER;
          textLabel.enableWrapText = false;
        }
      },
      _createBackgroundSprite: function() {
        var background = this._background;
        if (!background) {
          var node = this.node.getChildByName("BACKGROUND_SPRITE");
          node || (node = new cc.Node("BACKGROUND_SPRITE"));
          background = node.getComponent(cc.Sprite);
          background || (background = node.addComponent(cc.Sprite));
          background.type = cc.Sprite.Type.SLICED;
          node.parent = this.node;
          this._background = background;
        }
        background.spriteFrame = this.backgroundImage;
      },
      _createLabels: function() {
        if (!this._textLabel) {
          var node = this.node.getChildByName("TEXT_LABEL");
          node || (node = new cc.Node("TEXT_LABEL"));
          node.color = this.fontColor;
          node.parent = this.node;
          node.setAnchorPoint(0, 1);
          var textLabel = node.getComponent(Label);
          textLabel || (textLabel = node.addComponent(Label));
          textLabel.overflow = Label.Overflow.CLAMP;
          textLabel.fontSize = this.fontSize;
          textLabel.lineHeight = this.lineHeight;
          this._textLabel = textLabel;
        }
        if (!this._placeholderLabel) {
          var _node = this.node.getChildByName("PLACEHOLDER_LABEL");
          _node || (_node = new cc.Node("PLACEHOLDER_LABEL"));
          _node.color = this.placeholderFontColor;
          _node.parent = this.node;
          _node.setAnchorPoint(0, 1);
          var placeholderLabel = _node.getComponent(Label);
          placeholderLabel || (placeholderLabel = _node.addComponent(Label));
          placeholderLabel.overflow = Label.Overflow.CLAMP;
          placeholderLabel.fontSize = this.placeholderFontSize;
          placeholderLabel.string = this.placeholder;
          this._placeholderLabel = placeholderLabel;
        }
      },
      _showLabels: function() {
        var displayText = this._textLabel.string;
        this._textLabel.node.active = "" !== displayText;
        this._placeholderLabel.node.active = "" === displayText;
      },
      _hideLabels: function() {
        this._textLabel.node.active = false;
        this._placeholderLabel.node.active = false;
      },
      _updateString: function(text) {
        var textLabel = this._textLabel;
        if (!textLabel) return;
        var displayText = text;
        displayText && (displayText = this._updateLabelStringStyle(displayText));
        textLabel.string = displayText;
        this._impl.setString(text);
        this._impl._editing || this.stayOnTop || this._showLabels();
      },
      _updateLabelStringStyle: function(text, ignorePassword) {
        var inputFlag = this.inputFlag;
        if (ignorePassword || inputFlag !== InputFlag.PASSWORD) inputFlag === InputFlag.INITIAL_CAPS_ALL_CHARACTERS ? text = text.toUpperCase() : inputFlag === InputFlag.INITIAL_CAPS_WORD ? text = capitalize(text) : inputFlag === InputFlag.INITIAL_CAPS_SENTENCE && (text = capitalizeFirstLetter(text)); else {
          var passwordString = "";
          var len = text.length;
          for (var i = 0; i < len; ++i) passwordString += "\u25cf";
          text = passwordString;
        }
        return text;
      },
      editBoxEditingDidBegan: function() {
        this._hideLabels();
        cc.Component.EventHandler.emitEvents(this.editingDidBegan, this);
        this.node.emit("editing-did-began", this);
      },
      editBoxEditingDidEnded: function() {
        this.stayOnTop || this._showLabels();
        cc.Component.EventHandler.emitEvents(this.editingDidEnded, this);
        this.node.emit("editing-did-ended", this);
      },
      editBoxTextChanged: function(text) {
        text = this._updateLabelStringStyle(text, true);
        this.string = text;
        cc.Component.EventHandler.emitEvents(this.textChanged, text, this);
        this.node.emit("text-changed", this);
      },
      editBoxEditingReturn: function() {
        cc.Component.EventHandler.emitEvents(this.editingReturn, this);
        this.node.emit("editing-return", this);
      },
      onDestroy: function() {
        this._impl.clear();
      },
      onEnable: function() {
        this._impl && this._impl.onEnable();
      },
      onDisable: function() {
        this._impl && this._impl.onDisable();
      },
      __preload: function() {
        true;
        this._registerEvent();
        this._init();
      },
      _registerEvent: function() {
        this.node.on(cc.Node.EventType.TOUCH_START, this._onTouchBegan, this);
        this.node.on(cc.Node.EventType.TOUCH_END, this._onTouchEnded, this);
      },
      _onTouchBegan: function(event) {
        this._impl && this._impl._onTouchBegan(event.touch);
        event.stopPropagation();
      },
      _onTouchCancel: function(event) {
        this._impl && this._impl._onTouchCancel();
        event.stopPropagation();
      },
      _onTouchEnded: function(event) {
        this._impl && this._impl._onTouchEnded();
        event.stopPropagation();
      },
      setFocus: function() {
        this._impl && this._impl.setFocus();
      },
      isFocused: function() {
        var isFocused = false;
        this._impl && (isFocused = this._impl.isFocused());
        return isFocused;
      },
      update: function() {
        this._impl && this._impl.update();
      }
    });
    cc.EditBox = module.exports = EditBox;
  }), {
    "../../platform/CCMacro": 152,
    "../CCLabel": 61,
    "../editbox/CCEditBoxImpl": 81,
    "./types": 82
  } ],
  81: [ (function(require, module, exports) {
    var utils = require("../../platform/utils");
    var macro = require("../../platform/CCMacro");
    var Types = require("./types");
    var InputMode = Types.InputMode;
    var InputFlag = Types.InputFlag;
    var KeyboardReturnType = Types.KeyboardReturnType;
    var SCROLLY = 40;
    var LEFT_PADDING = 2;
    var DELAY_TIME = 400;
    var FOCUS_DELAY_UC = 400;
    var FOCUS_DELAY_FIREFOX = 0;
    var math = cc.vmath;
    var _matrix = math.mat4.create();
    var _vec3 = cc.v3();
    var polyfill = {
      zoomInvalid: false
    };
    cc.sys.OS_ANDROID !== cc.sys.os || cc.sys.browserType !== cc.sys.BROWSER_TYPE_SOUGOU && cc.sys.browserType !== cc.sys.BROWSER_TYPE_360 || (polyfill.zoomInvalid = true);
    function getKeyboardReturnType(type) {
      switch (type) {
       case KeyboardReturnType.DEFAULT:
       case KeyboardReturnType.DONE:
        return "done";

       case KeyboardReturnType.SEND:
        return "send";

       case KeyboardReturnType.SEARCH:
        return "search";

       case KeyboardReturnType.GO:
        return "go";

       case KeyboardReturnType.NEXT:
        return "next";
      }
      return "done";
    }
    var EditBoxImpl = cc.Class({
      ctor: function() {
        this._delegate = null;
        this._inputMode = -1;
        this._inputFlag = -1;
        this._returnType = KeyboardReturnType.DEFAULT;
        this._maxLength = 50;
        this._text = "";
        this._placeholderText = "";
        this._alwaysOnTop = false;
        this._size = cc.size();
        this._node = null;
        this._editing = false;
        this.__eventListeners = {};
        this.__fullscreen = false;
        this.__autoResize = false;
        this.__rotateScreen = false;
        this.__orientationChanged = null;
      },
      onEnable: function() {
        if (!this._edTxt) return;
        this._alwaysOnTop ? this._edTxt.style.display = "" : this._edTxt.style.display = "none";
      },
      onDisable: function() {
        if (!this._edTxt) return;
        this._edTxt.style.display = "none";
      },
      setTabIndex: function(index) {
        this._edTxt && (this._edTxt.tabIndex = index);
      },
      setFocus: function() {
        this._edTxt && this._edTxt.focus();
      },
      isFocused: function() {
        if (this._edTxt) return document.activeElement === this._edTxt;
        cc.warnID(4700);
        return false;
      },
      stayOnTop: function(flag) {
        if (this._alwaysOnTop === flag) return;
        this._alwaysOnTop = flag;
        this._edTxt.style.display = flag ? "" : "none";
      },
      setMaxLength: function(maxLength) {
        if (!isNaN(maxLength)) {
          maxLength < 0 && (maxLength = 65535);
          this._maxLength = maxLength;
          this._edTxt.maxLength = maxLength;
        }
      },
      setString: function(text) {
        this._text = text;
        this._edTxt.value = text;
      },
      getString: function() {
        return this._text;
      },
      setPlaceholderText: function(text) {
        this._placeholderText = text;
      },
      getPlaceholderText: function() {
        return this._placeholderText;
      },
      setDelegate: function(delegate) {
        this._delegate = delegate;
      },
      setInputMode: function(inputMode) {
        if (this._inputMode === inputMode) return;
        this._inputMode = inputMode;
        this.createInput();
        this._updateDomInputType();
        this._updateSize(this._size.width, this._size.height);
      },
      setInputFlag: function(inputFlag) {
        if (this._inputFlag === inputFlag) return;
        this._inputFlag = inputFlag;
        this._updateDomInputType();
        var textTransform = "none";
        inputFlag === InputFlag.INITIAL_CAPS_ALL_CHARACTERS ? textTransform = "uppercase" : inputFlag === InputFlag.INITIAL_CAPS_WORD && (textTransform = "capitalize");
        if (this._edTxt) {
          this._edTxt.style.textTransform = textTransform;
          this._edTxt.value = this._text;
        }
      },
      setReturnType: function(returnType) {
        this._returnType = returnType;
        this._updateDomInputType();
      },
      setFontSize: function(fontSize) {
        this._edFontSize = fontSize || this._edFontSize;
        this._edTxt.style.fontSize = this._edFontSize + "px";
      },
      setFontColor: function(color) {
        this._textColor = color;
        this._edTxt.style.color = color.toCSS("rgba");
      },
      setSize: function(width, height) {
        this._size.width = width;
        this._size.height = height;
        this._updateSize(width, height);
      },
      setNode: function(node) {
        this._node = node;
      },
      update: function() {
        this._updateMatrix();
      },
      clear: function() {
        this._node = null;
        this.setDelegate(null);
        this.removeDom();
      },
      _onTouchBegan: function(touch) {},
      _onTouchEnded: function() {
        this._beginEditing();
      },
      _beginEditing: function() {
        var _this = this;
        this._alwaysOnTop || "none" === this._edTxt.style.display && (function() {
          _this._edTxt.style.display = "";
          var self = _this;
          function startFocus() {
            self._edTxt.focus();
          }
          cc.sys.browserType === cc.sys.BROWSER_TYPE_UC ? setTimeout(startFocus, FOCUS_DELAY_UC) : cc.sys.browserType === cc.sys.BROWSER_TYPE_FIREFOX ? setTimeout(startFocus, FOCUS_DELAY_FIREFOX) : startFocus();
        })();
        cc.sys.isMobile && !this._editing && this._beginEditingOnMobile();
        this._editing = true;
      },
      _endEditing: function() {
        var self = this;
        var hideDomInputAndShowLabel = function() {
          !self._alwaysOnTop && self._edTxt && (self._edTxt.style.display = "none");
          self._delegate && self._delegate.editBoxEditingDidEnded && self._delegate.editBoxEditingDidEnded();
        };
        this._editing && (cc.sys.isMobile ? setTimeout((function() {
          self._endEditingOnMobile();
          hideDomInputAndShowLabel();
        }), DELAY_TIME) : hideDomInputAndShowLabel());
        this._editing = false;
      },
      _updateDomInputType: function() {
        var inputMode = this._inputMode;
        var edTxt = this._edTxt;
        if (this._inputFlag === InputFlag.PASSWORD) {
          edTxt.type = "password";
          return;
        }
        var type = edTxt.type;
        if (inputMode === InputMode.EMAIL_ADDR) type = "email"; else if (inputMode === InputMode.NUMERIC || inputMode === InputMode.DECIMAL) type = "number"; else if (inputMode === InputMode.PHONE_NUMBER) {
          type = "number";
          edTxt.pattern = "[0-9]*";
        } else if (inputMode === InputMode.URL) type = "url"; else {
          type = "text";
          this._returnType === KeyboardReturnType.SEARCH && (type = "search");
        }
        edTxt.type = type;
      },
      _updateSize: function(newWidth, newHeight) {
        var edTxt = this._edTxt;
        if (!edTxt) return;
        edTxt.style.width = newWidth + "px";
        edTxt.style.height = newHeight + "px";
      },
      _updateMatrix: function() {
        if (!this._edTxt) return;
        var node = this._node, scaleX = cc.view._scaleX, scaleY = cc.view._scaleY, viewport = cc.view._viewportRect, dpr = cc.view._devicePixelRatio;
        node.getWorldMatrix(_matrix);
        var contentSize = node._contentSize;
        _vec3.x = -node._anchorPoint.x * contentSize.width;
        _vec3.y = -node._anchorPoint.y * contentSize.height;
        math.mat4.translate(_matrix, _matrix, _vec3);
        scaleX /= dpr;
        scaleY /= dpr;
        var container = cc.game.container;
        var a = _matrix.m00 * scaleX, b = _matrix.m01, c = _matrix.m04, d = _matrix.m05 * scaleY;
        var offsetX = container && container.style.paddingLeft && parseInt(container.style.paddingLeft);
        offsetX += viewport.x / dpr;
        var offsetY = container && container.style.paddingBottom && parseInt(container.style.paddingBottom);
        offsetY += viewport.y / dpr;
        var tx = _matrix.m12 * scaleX + offsetX, ty = _matrix.m13 * scaleY + offsetY;
        if (polyfill.zoomInvalid) {
          this._updateSize(this._size.width * a, this._size.height * d);
          a = 1;
          d = 1;
        }
        var matrix = "matrix(" + a + "," + -b + "," + -c + "," + d + "," + tx + "," + -ty + ")";
        this._edTxt.style["transform"] = matrix;
        this._edTxt.style["-webkit-transform"] = matrix;
        this._edTxt.style["transform-origin"] = "0px 100% 0px";
        this._edTxt.style["-webkit-transform-origin"] = "0px 100% 0px";
      },
      _adjustEditBoxPosition: function() {
        this._node.getWorldMatrix(_matrix);
        var y = _matrix.m13;
        var windowHeight = cc.visibleRect.height;
        var windowWidth = cc.visibleRect.width;
        var factor = .5;
        windowWidth > windowHeight && (factor = .7);
        setTimeout((function() {
          if (window.scrollY < SCROLLY && y < windowHeight * factor) {
            var scrollOffset = windowHeight * factor - y - window.scrollY;
            scrollOffset < 35 && (scrollOffset = 35);
            scrollOffset > 320 && (scrollOffset = 320);
            window.scrollTo(0, scrollOffset);
          }
        }), DELAY_TIME);
      }
    });
    var _p = EditBoxImpl.prototype;
    _p.createInput = function() {
      this._inputMode === InputMode.ANY ? this._createDomTextArea() : this._createDomInput();
    };
    _p._beginEditingOnMobile = function() {
      var self = this;
      this.__orientationChanged = function() {
        self._adjustEditBoxPosition();
      };
      window.addEventListener("orientationchange", this.__orientationChanged);
      if (cc.view.isAutoFullScreenEnabled()) {
        this.__fullscreen = true;
        cc.view.enableAutoFullScreen(false);
        cc.screen.exitFullScreen();
      } else this.__fullscreen = false;
      this.__autoResize = cc.view._resizeWithBrowserSize;
      cc.view.resizeWithBrowserSize(false);
    };
    _p._endEditingOnMobile = function() {
      if (this.__rotateScreen) {
        cc.game.container.style["-webkit-transform"] = "rotate(90deg)";
        cc.game.container.style.transform = "rotate(90deg)";
        var view = cc.view;
        var width = view._originalDesignResolutionSize.width;
        var height = view._originalDesignResolutionSize.height;
        width > 0 && view.setDesignResolutionSize(width, height, view._resolutionPolicy);
        this.__rotateScreen = false;
      }
      window.removeEventListener("orientationchange", this.__orientationChanged);
      window.scrollTo && window.scrollTo(0, 0);
      this.__fullscreen && cc.view.enableAutoFullScreen(true);
      this.__autoResize && cc.view.resizeWithBrowserSize(true);
    };
    function _inputValueHandle(input, editBoxImpl) {
      input.value.length > editBoxImpl._maxLength && (input.value = input.value.slice(0, editBoxImpl._maxLength));
      if (editBoxImpl._delegate && editBoxImpl._delegate.editBoxTextChanged && editBoxImpl._text !== input.value) {
        editBoxImpl._text = input.value;
        editBoxImpl._delegate.editBoxTextChanged(editBoxImpl._text);
      }
    }
    function registerInputEventListener(tmpEdTxt, editBoxImpl, isTextarea) {
      var inputLock = false;
      var cbs = editBoxImpl.__eventListeners;
      cbs.compositionstart = function() {
        inputLock = true;
      };
      tmpEdTxt.addEventListener("compositionstart", cbs.compositionstart);
      cbs.compositionend = function() {
        inputLock = false;
        _inputValueHandle(this, editBoxImpl);
      };
      tmpEdTxt.addEventListener("compositionend", cbs.compositionend);
      cbs.input = function() {
        if (inputLock) return;
        _inputValueHandle(this, editBoxImpl);
      };
      tmpEdTxt.addEventListener("input", cbs.input);
      cbs.focus = function() {
        this.style.fontSize = editBoxImpl._edFontSize + "px";
        this.style.color = editBoxImpl._textColor.toCSS("rgba");
        editBoxImpl._alwaysOnTop && (editBoxImpl._editing = true);
        cc.sys.isMobile && editBoxImpl._onFocusOnMobile();
        editBoxImpl._delegate && editBoxImpl._delegate.editBoxEditingDidBegan && editBoxImpl._delegate.editBoxEditingDidBegan();
      };
      tmpEdTxt.addEventListener("focus", cbs.focus);
      cbs.keypress = function(e) {
        if (e.keyCode === macro.KEY.enter) {
          e.stopPropagation();
          editBoxImpl._delegate && editBoxImpl._delegate.editBoxEditingReturn && editBoxImpl._delegate.editBoxEditingReturn();
          if (!isTextarea) {
            editBoxImpl._text = this.value;
            editBoxImpl._endEditing();
            cc.game.canvas.focus();
          }
        }
      };
      tmpEdTxt.addEventListener("keypress", cbs.keypress);
      cbs.blur = function() {
        editBoxImpl._text = this.value;
        editBoxImpl._endEditing();
      };
      tmpEdTxt.addEventListener("blur", cbs.blur);
      editBoxImpl._addDomToGameContainer();
    }
    _p._onFocusOnMobile = function(editBox) {
      if (cc.view._isRotated) {
        cc.game.container.style["-webkit-transform"] = "rotate(0deg)";
        cc.game.container.style.transform = "rotate(0deg)";
        cc.view._isRotated = false;
        var policy = cc.view.getResolutionPolicy();
        policy.apply(cc.view, cc.view.getDesignResolutionSize());
        cc.view._isRotated = true;
        window.scrollTo(35, 35);
        this.__rotateScreen = true;
      } else this.__rotateScreen = false;
      this._adjustEditBoxPosition();
    };
    _p._createDomInput = function() {
      this.removeDom();
      var tmpEdTxt = this._edTxt = document.createElement("input");
      tmpEdTxt.type = "text";
      tmpEdTxt.style.fontSize = this._edFontSize + "px";
      tmpEdTxt.style.color = "#000000";
      tmpEdTxt.style.border = 0;
      tmpEdTxt.style.background = "transparent";
      tmpEdTxt.style.width = "100%";
      tmpEdTxt.style.height = "100%";
      tmpEdTxt.style.active = 0;
      tmpEdTxt.style.outline = "medium";
      tmpEdTxt.style.padding = "0";
      tmpEdTxt.style.textTransform = "uppercase";
      tmpEdTxt.style.display = "none";
      tmpEdTxt.style.position = "absolute";
      tmpEdTxt.style.bottom = "0px";
      tmpEdTxt.style.left = LEFT_PADDING + "px";
      tmpEdTxt.style["-moz-appearance"] = "textfield";
      tmpEdTxt.style.className = "cocosEditBox";
      tmpEdTxt.style.fontFamily = "Arial";
      registerInputEventListener(tmpEdTxt, this);
      return tmpEdTxt;
    };
    _p._createDomTextArea = function() {
      this.removeDom();
      var tmpEdTxt = this._edTxt = document.createElement("textarea");
      tmpEdTxt.type = "text";
      tmpEdTxt.style.fontSize = this._edFontSize + "px";
      tmpEdTxt.style.color = "#000000";
      tmpEdTxt.style.border = 0;
      tmpEdTxt.style.background = "transparent";
      tmpEdTxt.style.width = "100%";
      tmpEdTxt.style.height = "100%";
      tmpEdTxt.style.active = 0;
      tmpEdTxt.style.outline = "medium";
      tmpEdTxt.style.padding = "0";
      tmpEdTxt.style.resize = "none";
      tmpEdTxt.style.textTransform = "uppercase";
      tmpEdTxt.style.overflow_y = "scroll";
      tmpEdTxt.style.display = "none";
      tmpEdTxt.style.position = "absolute";
      tmpEdTxt.style.bottom = "0px";
      tmpEdTxt.style.left = LEFT_PADDING + "px";
      tmpEdTxt.style.className = "cocosEditBox";
      tmpEdTxt.style.fontFamily = "Arial";
      registerInputEventListener(tmpEdTxt, this, true);
      return tmpEdTxt;
    };
    _p._addDomToGameContainer = function() {
      cc.game.container.appendChild(this._edTxt);
    };
    _p.removeDom = function() {
      var edTxt = this._edTxt;
      if (edTxt) {
        var cbs = this.__eventListeners;
        edTxt.removeEventListener("compositionstart", cbs.compositionstart);
        edTxt.removeEventListener("compositionend", cbs.compositionend);
        edTxt.removeEventListener("input", cbs.input);
        edTxt.removeEventListener("focus", cbs.focus);
        edTxt.removeEventListener("keypress", cbs.keypress);
        edTxt.removeEventListener("blur", cbs.blur);
        cbs.compositionstart = null;
        cbs.compositionend = null;
        cbs.input = null;
        cbs.focus = null;
        cbs.keypress = null;
        cbs.blur = null;
        var hasChild = utils.contains(cc.game.container, edTxt);
        hasChild && cc.game.container.removeChild(edTxt);
      }
      this._edTxt = null;
    };
    module.exports = EditBoxImpl;
  }), {
    "../../platform/CCMacro": 152,
    "../../platform/utils": 171,
    "./types": 82
  } ],
  82: [ (function(require, module, exports) {
    var KeyboardReturnType = cc.Enum({
      DEFAULT: 0,
      DONE: 1,
      SEND: 2,
      SEARCH: 3,
      GO: 4,
      NEXT: 5
    });
    var InputMode = cc.Enum({
      ANY: 0,
      EMAIL_ADDR: 1,
      NUMERIC: 2,
      PHONE_NUMBER: 3,
      URL: 4,
      DECIMAL: 5,
      SINGLE_LINE: 6
    });
    var InputFlag = cc.Enum({
      PASSWORD: 0,
      SENSITIVE: 1,
      INITIAL_CAPS_WORD: 2,
      INITIAL_CAPS_SENTENCE: 3,
      INITIAL_CAPS_ALL_CHARACTERS: 4,
      DEFAULT: 5
    });
    module.exports = {
      KeyboardReturnType: KeyboardReturnType,
      InputMode: InputMode,
      InputFlag: InputFlag
    };
  }), {} ],
  83: [ (function(require, module, exports) {
    require("./CCComponent");
    require("./CCComponentEventHandler");
    require("./missing-script");
    var components = [ require("./CCSprite"), require("./CCWidget"), require("./CCCanvas"), require("./CCAudioSource"), require("./CCAnimation"), require("./CCButton"), require("./CCLabel"), require("./CCProgressBar"), require("./CCMask"), require("./CCScrollBar"), require("./CCScrollView"), require("./CCPageViewIndicator"), require("./CCPageView"), require("./CCSlider"), require("./CCLayout"), require("./editbox/CCEditBox"), require("./CCLabelOutline"), require("./CCRichText"), require("./CCToggleContainer"), require("./CCToggleGroup"), require("./CCToggle"), require("./CCBlockInputEvents"), require("./CCMotionStreak"), require("./WXSubContextView") ];
    module.exports = components;
  }), {
    "./CCAnimation": 55,
    "./CCAudioSource": void 0,
    "./CCBlockInputEvents": 56,
    "./CCButton": 57,
    "./CCCanvas": 58,
    "./CCComponent": 59,
    "./CCComponentEventHandler": 60,
    "./CCLabel": 61,
    "./CCLabelOutline": void 0,
    "./CCLayout": 62,
    "./CCMask": 63,
    "./CCMotionStreak": 64,
    "./CCPageView": 65,
    "./CCPageViewIndicator": 66,
    "./CCProgressBar": 67,
    "./CCRichText": 69,
    "./CCScrollBar": 70,
    "./CCScrollView": 71,
    "./CCSlider": 72,
    "./CCSprite": 73,
    "./CCToggle": 74,
    "./CCToggleContainer": 75,
    "./CCToggleGroup": 76,
    "./CCWidget": 78,
    "./WXSubContextView": 79,
    "./editbox/CCEditBox": 80,
    "./missing-script": 84
  } ],
  84: [ (function(require, module, exports) {
    var js = cc.js;
    var BUILTIN_CLASSID_RE = require("../utils/misc").BUILTIN_CLASSID_RE;
    var MissingClass = cc.Class({
      name: "cc.MissingClass",
      properties: {
        _$erialized: {
          default: null,
          visible: false,
          editorOnly: true
        }
      }
    });
    var MissingScript = cc.Class({
      name: "cc.MissingScript",
      extends: cc.Component,
      editor: {
        inspector: "packages://inspector/inspectors/comps/missing-script.js"
      },
      properties: {
        compiled: {
          default: false,
          serializable: false
        },
        _$erialized: {
          default: null,
          visible: false,
          editorOnly: true
        }
      },
      ctor: false,
      statics: {
        safeFindClass: function(id, data) {
          var cls = js._getClassById(id);
          if (cls) return cls;
          if (id) {
            cc.deserialize.reportMissingClass(id);
            return MissingScript.getMissingWrapper(id, data);
          }
          return null;
        },
        getMissingWrapper: function(id, data) {
          return data.node && (/^[0-9a-zA-Z+/]{23}$/.test(id) || BUILTIN_CLASSID_RE.test(id)) ? MissingScript : MissingClass;
        }
      },
      onLoad: function() {
        cc.warnID(4600, this.node.name);
      }
    });
    cc._MissingScript = module.exports = MissingScript;
  }), {
    "../utils/misc": 208
  } ],
  85: [ (function(require, module, exports) {
    var js = cc.js;
    require("../event/event");
    var EventMouse = function(eventType, bubbles) {
      cc.Event.call(this, cc.Event.MOUSE, bubbles);
      this._eventType = eventType;
      this._button = 0;
      this._x = 0;
      this._y = 0;
      this._prevX = 0;
      this._prevY = 0;
      this._scrollX = 0;
      this._scrollY = 0;
    };
    js.extend(EventMouse, cc.Event);
    var proto = EventMouse.prototype;
    proto.setScrollData = function(scrollX, scrollY) {
      this._scrollX = scrollX;
      this._scrollY = scrollY;
    };
    proto.getScrollX = function() {
      return this._scrollX;
    };
    proto.getScrollY = function() {
      return this._scrollY;
    };
    proto.setLocation = function(x, y) {
      this._x = x;
      this._y = y;
    };
    proto.getLocation = function() {
      return cc.v2(this._x, this._y);
    };
    proto.getLocationInView = function() {
      return cc.v2(this._x, cc.view._designResolutionSize.height - this._y);
    };
    proto._setPrevCursor = function(x, y) {
      this._prevX = x;
      this._prevY = y;
    };
    proto.getPreviousLocation = function() {
      return cc.v2(this._prevX, this._prevY);
    };
    proto.getDelta = function() {
      return cc.v2(this._x - this._prevX, this._y - this._prevY);
    };
    proto.getDeltaX = function() {
      return this._x - this._prevX;
    };
    proto.getDeltaY = function() {
      return this._y - this._prevY;
    };
    proto.setButton = function(button) {
      this._button = button;
    };
    proto.getButton = function() {
      return this._button;
    };
    proto.getLocationX = function() {
      return this._x;
    };
    proto.getLocationY = function() {
      return this._y;
    };
    EventMouse.NONE = 0;
    EventMouse.DOWN = 1;
    EventMouse.UP = 2;
    EventMouse.MOVE = 3;
    EventMouse.SCROLL = 4;
    EventMouse.BUTTON_LEFT = 0;
    EventMouse.BUTTON_RIGHT = 2;
    EventMouse.BUTTON_MIDDLE = 1;
    EventMouse.BUTTON_4 = 3;
    EventMouse.BUTTON_5 = 4;
    EventMouse.BUTTON_6 = 5;
    EventMouse.BUTTON_7 = 6;
    EventMouse.BUTTON_8 = 7;
    var EventTouch = function(touchArr, bubbles) {
      cc.Event.call(this, cc.Event.TOUCH, bubbles);
      this._eventCode = 0;
      this._touches = touchArr || [];
      this.touch = null;
      this.currentTouch = null;
    };
    js.extend(EventTouch, cc.Event);
    proto = EventTouch.prototype;
    proto.getEventCode = function() {
      return this._eventCode;
    };
    proto.getTouches = function() {
      return this._touches;
    };
    proto._setEventCode = function(eventCode) {
      this._eventCode = eventCode;
    };
    proto._setTouches = function(touches) {
      this._touches = touches;
    };
    proto.setLocation = function(x, y) {
      this.touch && this.touch.setTouchInfo(this.touch.getID(), x, y);
    };
    proto.getLocation = function() {
      return this.touch ? this.touch.getLocation() : cc.v2();
    };
    proto.getLocationInView = function() {
      return this.touch ? this.touch.getLocationInView() : cc.v2();
    };
    proto.getPreviousLocation = function() {
      return this.touch ? this.touch.getPreviousLocation() : cc.v2();
    };
    proto.getStartLocation = function() {
      return this.touch ? this.touch.getStartLocation() : cc.v2();
    };
    proto.getID = function() {
      return this.touch ? this.touch.getID() : null;
    };
    proto.getDelta = function() {
      return this.touch ? this.touch.getDelta() : cc.v2();
    };
    proto.getDeltaX = function() {
      return this.touch ? this.touch.getDelta().x : 0;
    };
    proto.getDeltaY = function() {
      return this.touch ? this.touch.getDelta().y : 0;
    };
    proto.getLocationX = function() {
      return this.touch ? this.touch.getLocationX() : 0;
    };
    proto.getLocationY = function() {
      return this.touch ? this.touch.getLocationY() : 0;
    };
    EventTouch.MAX_TOUCHES = 5;
    EventTouch.BEGAN = 0;
    EventTouch.MOVED = 1;
    EventTouch.ENDED = 2;
    EventTouch.CANCELED = 3;
    var EventAcceleration = function(acc, bubbles) {
      cc.Event.call(this, cc.Event.ACCELERATION, bubbles);
      this.acc = acc;
    };
    js.extend(EventAcceleration, cc.Event);
    var EventKeyboard = function(keyCode, isPressed, bubbles) {
      cc.Event.call(this, cc.Event.KEYBOARD, bubbles);
      this.keyCode = keyCode;
      this.isPressed = isPressed;
    };
    js.extend(EventKeyboard, cc.Event);
    cc.Event.EventMouse = EventMouse;
    cc.Event.EventTouch = EventTouch;
    cc.Event.EventAcceleration = EventAcceleration;
    cc.Event.EventKeyboard = EventKeyboard;
    module.exports = cc.Event;
  }), {
    "../event/event": 92
  } ],
  86: [ (function(require, module, exports) {
    var js = require("../platform/js");
    cc.EventListener = function(type, listenerID, callback) {
      this._onEvent = callback;
      this._type = type || 0;
      this._listenerID = listenerID || "";
      this._registered = false;
      this._fixedPriority = 0;
      this._node = null;
      this._target = null;
      this._paused = true;
      this._isEnabled = true;
    };
    cc.EventListener.prototype = {
      constructor: cc.EventListener,
      _setPaused: function(paused) {
        this._paused = paused;
      },
      _isPaused: function() {
        return this._paused;
      },
      _setRegistered: function(registered) {
        this._registered = registered;
      },
      _isRegistered: function() {
        return this._registered;
      },
      _getType: function() {
        return this._type;
      },
      _getListenerID: function() {
        return this._listenerID;
      },
      _setFixedPriority: function(fixedPriority) {
        this._fixedPriority = fixedPriority;
      },
      _getFixedPriority: function() {
        return this._fixedPriority;
      },
      _setSceneGraphPriority: function(node) {
        this._target = node;
        this._node = node;
      },
      _getSceneGraphPriority: function() {
        return this._node;
      },
      checkAvailable: function() {
        return null !== this._onEvent;
      },
      clone: function() {
        return null;
      },
      setEnabled: function(enabled) {
        this._isEnabled = enabled;
      },
      isEnabled: function() {
        return this._isEnabled;
      },
      retain: function() {},
      release: function() {}
    };
    cc.EventListener.UNKNOWN = 0;
    cc.EventListener.TOUCH_ONE_BY_ONE = 1;
    cc.EventListener.TOUCH_ALL_AT_ONCE = 2;
    cc.EventListener.KEYBOARD = 3;
    cc.EventListener.MOUSE = 4;
    cc.EventListener.ACCELERATION = 6;
    cc.EventListener.CUSTOM = 8;
    var ListenerID = cc.EventListener.ListenerID = {
      MOUSE: "__cc_mouse",
      TOUCH_ONE_BY_ONE: "__cc_touch_one_by_one",
      TOUCH_ALL_AT_ONCE: "__cc_touch_all_at_once",
      KEYBOARD: "__cc_keyboard",
      ACCELERATION: "__cc_acceleration"
    };
    var Custom = function(listenerId, callback) {
      this._onCustomEvent = callback;
      cc.EventListener.call(this, cc.EventListener.CUSTOM, listenerId, this._callback);
    };
    js.extend(Custom, cc.EventListener);
    js.mixin(Custom.prototype, {
      _onCustomEvent: null,
      _callback: function(event) {
        null !== this._onCustomEvent && this._onCustomEvent(event);
      },
      checkAvailable: function() {
        return cc.EventListener.prototype.checkAvailable.call(this) && null !== this._onCustomEvent;
      },
      clone: function() {
        return new Custom(this._listenerID, this._onCustomEvent);
      }
    });
    var Mouse = function() {
      cc.EventListener.call(this, cc.EventListener.MOUSE, ListenerID.MOUSE, this._callback);
    };
    js.extend(Mouse, cc.EventListener);
    js.mixin(Mouse.prototype, {
      onMouseDown: null,
      onMouseUp: null,
      onMouseMove: null,
      onMouseScroll: null,
      _callback: function(event) {
        var eventType = cc.Event.EventMouse;
        switch (event._eventType) {
         case eventType.DOWN:
          this.onMouseDown && this.onMouseDown(event);
          break;

         case eventType.UP:
          this.onMouseUp && this.onMouseUp(event);
          break;

         case eventType.MOVE:
          this.onMouseMove && this.onMouseMove(event);
          break;

         case eventType.SCROLL:
          this.onMouseScroll && this.onMouseScroll(event);
        }
      },
      clone: function() {
        var eventListener = new Mouse();
        eventListener.onMouseDown = this.onMouseDown;
        eventListener.onMouseUp = this.onMouseUp;
        eventListener.onMouseMove = this.onMouseMove;
        eventListener.onMouseScroll = this.onMouseScroll;
        return eventListener;
      },
      checkAvailable: function() {
        return true;
      }
    });
    var TouchOneByOne = function() {
      cc.EventListener.call(this, cc.EventListener.TOUCH_ONE_BY_ONE, ListenerID.TOUCH_ONE_BY_ONE, null);
      this._claimedTouches = [];
    };
    js.extend(TouchOneByOne, cc.EventListener);
    js.mixin(TouchOneByOne.prototype, {
      constructor: TouchOneByOne,
      _claimedTouches: null,
      swallowTouches: false,
      onTouchBegan: null,
      onTouchMoved: null,
      onTouchEnded: null,
      onTouchCancelled: null,
      setSwallowTouches: function(needSwallow) {
        this.swallowTouches = needSwallow;
      },
      isSwallowTouches: function() {
        return this.swallowTouches;
      },
      clone: function() {
        var eventListener = new TouchOneByOne();
        eventListener.onTouchBegan = this.onTouchBegan;
        eventListener.onTouchMoved = this.onTouchMoved;
        eventListener.onTouchEnded = this.onTouchEnded;
        eventListener.onTouchCancelled = this.onTouchCancelled;
        eventListener.swallowTouches = this.swallowTouches;
        return eventListener;
      },
      checkAvailable: function() {
        if (!this.onTouchBegan) {
          cc.logID(1801);
          return false;
        }
        return true;
      }
    });
    var TouchAllAtOnce = function() {
      cc.EventListener.call(this, cc.EventListener.TOUCH_ALL_AT_ONCE, ListenerID.TOUCH_ALL_AT_ONCE, null);
    };
    js.extend(TouchAllAtOnce, cc.EventListener);
    js.mixin(TouchAllAtOnce.prototype, {
      constructor: TouchAllAtOnce,
      onTouchesBegan: null,
      onTouchesMoved: null,
      onTouchesEnded: null,
      onTouchesCancelled: null,
      clone: function() {
        var eventListener = new TouchAllAtOnce();
        eventListener.onTouchesBegan = this.onTouchesBegan;
        eventListener.onTouchesMoved = this.onTouchesMoved;
        eventListener.onTouchesEnded = this.onTouchesEnded;
        eventListener.onTouchesCancelled = this.onTouchesCancelled;
        return eventListener;
      },
      checkAvailable: function() {
        if (null === this.onTouchesBegan && null === this.onTouchesMoved && null === this.onTouchesEnded && null === this.onTouchesCancelled) {
          cc.logID(1802);
          return false;
        }
        return true;
      }
    });
    var Acceleration = function(callback) {
      this._onAccelerationEvent = callback;
      cc.EventListener.call(this, cc.EventListener.ACCELERATION, ListenerID.ACCELERATION, this._callback);
    };
    js.extend(Acceleration, cc.EventListener);
    js.mixin(Acceleration.prototype, {
      constructor: Acceleration,
      _onAccelerationEvent: null,
      _callback: function(event) {
        this._onAccelerationEvent(event.acc, event);
      },
      checkAvailable: function() {
        cc.assertID(this._onAccelerationEvent, 1803);
        return true;
      },
      clone: function() {
        return new Acceleration(this._onAccelerationEvent);
      }
    });
    var Keyboard = function() {
      cc.EventListener.call(this, cc.EventListener.KEYBOARD, ListenerID.KEYBOARD, this._callback);
    };
    js.extend(Keyboard, cc.EventListener);
    js.mixin(Keyboard.prototype, {
      constructor: Keyboard,
      onKeyPressed: null,
      onKeyReleased: null,
      _callback: function(event) {
        event.isPressed ? this.onKeyPressed && this.onKeyPressed(event.keyCode, event) : this.onKeyReleased && this.onKeyReleased(event.keyCode, event);
      },
      clone: function() {
        var eventListener = new Keyboard();
        eventListener.onKeyPressed = this.onKeyPressed;
        eventListener.onKeyReleased = this.onKeyReleased;
        return eventListener;
      },
      checkAvailable: function() {
        if (null === this.onKeyPressed && null === this.onKeyReleased) {
          cc.logID(1800);
          return false;
        }
        return true;
      }
    });
    cc.EventListener.create = function(argObj) {
      cc.assertID(argObj && argObj.event, 1900);
      var listenerType = argObj.event;
      delete argObj.event;
      var listener = null;
      if (listenerType === cc.EventListener.TOUCH_ONE_BY_ONE) listener = new TouchOneByOne(); else if (listenerType === cc.EventListener.TOUCH_ALL_AT_ONCE) listener = new TouchAllAtOnce(); else if (listenerType === cc.EventListener.MOUSE) listener = new Mouse(); else if (listenerType === cc.EventListener.CUSTOM) {
        listener = new Custom(argObj.eventName, argObj.callback);
        delete argObj.eventName;
        delete argObj.callback;
      } else if (listenerType === cc.EventListener.KEYBOARD) listener = new Keyboard(); else if (listenerType === cc.EventListener.ACCELERATION) {
        listener = new Acceleration(argObj.callback);
        delete argObj.callback;
      }
      for (var key in argObj) listener[key] = argObj[key];
      return listener;
    };
    module.exports = cc.EventListener;
  }), {
    "../platform/js": 167
  } ],
  87: [ (function(require, module, exports) {
    var js = require("../platform/js");
    require("./CCEventListener");
    var ListenerID = cc.EventListener.ListenerID;
    var _EventListenerVector = function() {
      this._fixedListeners = [];
      this._sceneGraphListeners = [];
      this.gt0Index = 0;
    };
    _EventListenerVector.prototype = {
      constructor: _EventListenerVector,
      size: function() {
        return this._fixedListeners.length + this._sceneGraphListeners.length;
      },
      empty: function() {
        return 0 === this._fixedListeners.length && 0 === this._sceneGraphListeners.length;
      },
      push: function(listener) {
        0 === listener._getFixedPriority() ? this._sceneGraphListeners.push(listener) : this._fixedListeners.push(listener);
      },
      clearSceneGraphListeners: function() {
        this._sceneGraphListeners.length = 0;
      },
      clearFixedListeners: function() {
        this._fixedListeners.length = 0;
      },
      clear: function() {
        this._sceneGraphListeners.length = 0;
        this._fixedListeners.length = 0;
      },
      getFixedPriorityListeners: function() {
        return this._fixedListeners;
      },
      getSceneGraphPriorityListeners: function() {
        return this._sceneGraphListeners;
      }
    };
    var __getListenerID = function(event) {
      var eventType = cc.Event, type = event.type;
      if (type === eventType.ACCELERATION) return ListenerID.ACCELERATION;
      if (type === eventType.KEYBOARD) return ListenerID.KEYBOARD;
      if (type.startsWith(eventType.MOUSE)) return ListenerID.MOUSE;
      type.startsWith(eventType.TOUCH) && cc.logID(2e3);
      return "";
    };
    var eventManager = {
      DIRTY_NONE: 0,
      DIRTY_FIXED_PRIORITY: 1,
      DIRTY_SCENE_GRAPH_PRIORITY: 2,
      DIRTY_ALL: 3,
      _listenersMap: {},
      _priorityDirtyFlagMap: {},
      _nodeListenersMap: {},
      _nodePriorityMap: js.createMap(true),
      _globalZOrderNodeMap: [],
      _toAddedListeners: [],
      _toRemovedListeners: [],
      _dirtyNodes: [],
      _inDispatch: 0,
      _isEnabled: false,
      _nodePriorityIndex: 0,
      _internalCustomListenerIDs: [],
      _setDirtyForNode: function(node) {
        void 0 !== this._nodeListenersMap[node._id] && this._dirtyNodes.push(node);
        if (node.getChildren) {
          var _children = node.getChildren();
          for (var i = 0, len = _children ? _children.length : 0; i < len; i++) this._setDirtyForNode(_children[i]);
        }
      },
      pauseTarget: function(node, recursive) {
        if (!(node instanceof cc._BaseNode)) {
          cc.warnID(3506);
          return;
        }
        var listeners = this._nodeListenersMap[node._id], i, len;
        if (listeners) for (i = 0, len = listeners.length; i < len; i++) listeners[i]._setPaused(true);
        if (true === recursive) {
          var locChildren = node.getChildren();
          for (i = 0, len = locChildren ? locChildren.length : 0; i < len; i++) this.pauseTarget(locChildren[i], true);
        }
      },
      resumeTarget: function(node, recursive) {
        if (!(node instanceof cc._BaseNode)) {
          cc.warnID(3506);
          return;
        }
        var listeners = this._nodeListenersMap[node._id], i, len;
        if (listeners) for (i = 0, len = listeners.length; i < len; i++) listeners[i]._setPaused(false);
        this._setDirtyForNode(node);
        if (true === recursive && node.getChildren) {
          var locChildren = node.getChildren();
          for (i = 0, len = locChildren ? locChildren.length : 0; i < len; i++) this.resumeTarget(locChildren[i], true);
        }
      },
      _addListener: function(listener) {
        0 === this._inDispatch ? this._forceAddEventListener(listener) : this._toAddedListeners.push(listener);
      },
      _forceAddEventListener: function(listener) {
        var listenerID = listener._getListenerID();
        var listeners = this._listenersMap[listenerID];
        if (!listeners) {
          listeners = new _EventListenerVector();
          this._listenersMap[listenerID] = listeners;
        }
        listeners.push(listener);
        if (0 === listener._getFixedPriority()) {
          this._setDirty(listenerID, this.DIRTY_SCENE_GRAPH_PRIORITY);
          var node = listener._getSceneGraphPriority();
          null === node && cc.logID(3507);
          this._associateNodeAndEventListener(node, listener);
          node.activeInHierarchy && this.resumeTarget(node);
        } else this._setDirty(listenerID, this.DIRTY_FIXED_PRIORITY);
      },
      _getListeners: function(listenerID) {
        return this._listenersMap[listenerID];
      },
      _updateDirtyFlagForSceneGraph: function() {
        if (0 === this._dirtyNodes.length) return;
        var locDirtyNodes = this._dirtyNodes, selListeners, selListener, locNodeListenersMap = this._nodeListenersMap;
        for (var i = 0, len = locDirtyNodes.length; i < len; i++) {
          selListeners = locNodeListenersMap[locDirtyNodes[i]._id];
          if (selListeners) for (var j = 0, listenersLen = selListeners.length; j < listenersLen; j++) {
            selListener = selListeners[j];
            selListener && this._setDirty(selListener._getListenerID(), this.DIRTY_SCENE_GRAPH_PRIORITY);
          }
        }
        this._dirtyNodes.length = 0;
      },
      _removeAllListenersInVector: function(listenerVector) {
        if (!listenerVector) return;
        var selListener;
        for (var i = 0; i < listenerVector.length; ) {
          selListener = listenerVector[i];
          selListener._setRegistered(false);
          if (null != selListener._getSceneGraphPriority()) {
            this._dissociateNodeAndEventListener(selListener._getSceneGraphPriority(), selListener);
            selListener._setSceneGraphPriority(null);
          }
          0 === this._inDispatch ? cc.js.array.remove(listenerVector, selListener) : ++i;
        }
      },
      _removeListenersForListenerID: function(listenerID) {
        var listeners = this._listenersMap[listenerID], i;
        if (listeners) {
          var fixedPriorityListeners = listeners.getFixedPriorityListeners();
          var sceneGraphPriorityListeners = listeners.getSceneGraphPriorityListeners();
          this._removeAllListenersInVector(sceneGraphPriorityListeners);
          this._removeAllListenersInVector(fixedPriorityListeners);
          delete this._priorityDirtyFlagMap[listenerID];
          if (!this._inDispatch) {
            listeners.clear();
            delete this._listenersMap[listenerID];
          }
        }
        var locToAddedListeners = this._toAddedListeners, listener;
        for (i = 0; i < locToAddedListeners.length; ) {
          listener = locToAddedListeners[i];
          listener && listener._getListenerID() === listenerID ? cc.js.array.remove(locToAddedListeners, listener) : ++i;
        }
      },
      _sortEventListeners: function(listenerID) {
        var dirtyFlag = this.DIRTY_NONE, locFlagMap = this._priorityDirtyFlagMap;
        locFlagMap[listenerID] && (dirtyFlag = locFlagMap[listenerID]);
        if (dirtyFlag !== this.DIRTY_NONE) {
          locFlagMap[listenerID] = this.DIRTY_NONE;
          dirtyFlag & this.DIRTY_FIXED_PRIORITY && this._sortListenersOfFixedPriority(listenerID);
          if (dirtyFlag & this.DIRTY_SCENE_GRAPH_PRIORITY) {
            var rootEntity = cc.director.getScene();
            rootEntity && this._sortListenersOfSceneGraphPriority(listenerID, rootEntity);
          }
        }
      },
      _sortListenersOfSceneGraphPriority: function(listenerID, rootNode) {
        var listeners = this._getListeners(listenerID);
        if (!listeners) return;
        var sceneGraphListener = listeners.getSceneGraphPriorityListeners();
        if (!sceneGraphListener || 0 === sceneGraphListener.length) return;
        this._nodePriorityIndex = 0;
        this._nodePriorityMap = js.createMap(true);
        this._visitTarget(rootNode, true);
        listeners.getSceneGraphPriorityListeners().sort(this._sortEventListenersOfSceneGraphPriorityDes);
      },
      _sortEventListenersOfSceneGraphPriorityDes: function(l1, l2) {
        var locNodePriorityMap = eventManager._nodePriorityMap, node1 = l1._getSceneGraphPriority(), node2 = l2._getSceneGraphPriority();
        if (!(l2 && node2 && locNodePriorityMap[node2._id])) return -1;
        if (!l1 || !node1 || !locNodePriorityMap[node1._id]) return 1;
        return locNodePriorityMap[node2._id] - locNodePriorityMap[node1._id];
      },
      _sortListenersOfFixedPriority: function(listenerID) {
        var listeners = this._listenersMap[listenerID];
        if (!listeners) return;
        var fixedListeners = listeners.getFixedPriorityListeners();
        if (!fixedListeners || 0 === fixedListeners.length) return;
        fixedListeners.sort(this._sortListenersOfFixedPriorityAsc);
        var index = 0;
        for (var len = fixedListeners.length; index < len; ) {
          if (fixedListeners[index]._getFixedPriority() >= 0) break;
          ++index;
        }
        listeners.gt0Index = index;
      },
      _sortListenersOfFixedPriorityAsc: function(l1, l2) {
        return l1._getFixedPriority() - l2._getFixedPriority();
      },
      _onUpdateListeners: function(listeners) {
        var fixedPriorityListeners = listeners.getFixedPriorityListeners();
        var sceneGraphPriorityListeners = listeners.getSceneGraphPriorityListeners();
        var i, selListener, idx, toRemovedListeners = this._toRemovedListeners;
        if (sceneGraphPriorityListeners) for (i = 0; i < sceneGraphPriorityListeners.length; ) {
          selListener = sceneGraphPriorityListeners[i];
          if (selListener._isRegistered()) ++i; else {
            cc.js.array.remove(sceneGraphPriorityListeners, selListener);
            idx = toRemovedListeners.indexOf(selListener);
            -1 !== idx && toRemovedListeners.splice(idx, 1);
          }
        }
        if (fixedPriorityListeners) for (i = 0; i < fixedPriorityListeners.length; ) {
          selListener = fixedPriorityListeners[i];
          if (selListener._isRegistered()) ++i; else {
            cc.js.array.remove(fixedPriorityListeners, selListener);
            idx = toRemovedListeners.indexOf(selListener);
            -1 !== idx && toRemovedListeners.splice(idx, 1);
          }
        }
        sceneGraphPriorityListeners && 0 === sceneGraphPriorityListeners.length && listeners.clearSceneGraphListeners();
        fixedPriorityListeners && 0 === fixedPriorityListeners.length && listeners.clearFixedListeners();
      },
      frameUpdateListeners: function() {
        var locListenersMap = this._listenersMap, locPriorityDirtyFlagMap = this._priorityDirtyFlagMap;
        for (var selKey in locListenersMap) if (locListenersMap[selKey].empty()) {
          delete locPriorityDirtyFlagMap[selKey];
          delete locListenersMap[selKey];
        }
        var locToAddedListeners = this._toAddedListeners;
        if (0 !== locToAddedListeners.length) {
          for (var i = 0, len = locToAddedListeners.length; i < len; i++) this._forceAddEventListener(locToAddedListeners[i]);
          locToAddedListeners.length = 0;
        }
        0 !== this._toRemovedListeners.length && this._cleanToRemovedListeners();
      },
      _updateTouchListeners: function(event) {
        var locInDispatch = this._inDispatch;
        cc.assertID(locInDispatch > 0, 3508);
        if (locInDispatch > 1) return;
        var listeners;
        listeners = this._listenersMap[ListenerID.TOUCH_ONE_BY_ONE];
        listeners && this._onUpdateListeners(listeners);
        listeners = this._listenersMap[ListenerID.TOUCH_ALL_AT_ONCE];
        listeners && this._onUpdateListeners(listeners);
        cc.assertID(1 === locInDispatch, 3509);
        var locToAddedListeners = this._toAddedListeners;
        if (0 !== locToAddedListeners.length) {
          for (var i = 0, len = locToAddedListeners.length; i < len; i++) this._forceAddEventListener(locToAddedListeners[i]);
          this._toAddedListeners.length = 0;
        }
        0 !== this._toRemovedListeners.length && this._cleanToRemovedListeners();
      },
      _cleanToRemovedListeners: function() {
        var toRemovedListeners = this._toRemovedListeners;
        for (var i = 0; i < toRemovedListeners.length; i++) {
          var selListener = toRemovedListeners[i];
          var listeners = this._listenersMap[selListener._getListenerID()];
          if (!listeners) continue;
          var idx, fixedPriorityListeners = listeners.getFixedPriorityListeners(), sceneGraphPriorityListeners = listeners.getSceneGraphPriorityListeners();
          if (sceneGraphPriorityListeners) {
            idx = sceneGraphPriorityListeners.indexOf(selListener);
            -1 !== idx && sceneGraphPriorityListeners.splice(idx, 1);
          }
          if (fixedPriorityListeners) {
            idx = fixedPriorityListeners.indexOf(selListener);
            -1 !== idx && fixedPriorityListeners.splice(idx, 1);
          }
        }
        toRemovedListeners.length = 0;
      },
      _onTouchEventCallback: function(listener, argsObj) {
        if (!listener._isRegistered) return false;
        var event = argsObj.event, selTouch = event.currentTouch;
        event.currentTarget = listener._node;
        var isClaimed = false, removedIdx;
        var getCode = event.getEventCode(), EventTouch = cc.Event.EventTouch;
        if (getCode === EventTouch.BEGAN) {
          if (listener.onTouchBegan) {
            isClaimed = listener.onTouchBegan(selTouch, event);
            isClaimed && listener._registered && listener._claimedTouches.push(selTouch);
          }
        } else if (listener._claimedTouches.length > 0 && -1 !== (removedIdx = listener._claimedTouches.indexOf(selTouch))) {
          isClaimed = true;
          if (getCode === EventTouch.MOVED && listener.onTouchMoved) listener.onTouchMoved(selTouch, event); else if (getCode === EventTouch.ENDED) {
            listener.onTouchEnded && listener.onTouchEnded(selTouch, event);
            listener._registered && listener._claimedTouches.splice(removedIdx, 1);
          } else if (getCode === EventTouch.CANCELLED) {
            listener.onTouchCancelled && listener.onTouchCancelled(selTouch, event);
            listener._registered && listener._claimedTouches.splice(removedIdx, 1);
          }
        }
        if (event.isStopped()) {
          eventManager._updateTouchListeners(event);
          return true;
        }
        if (isClaimed && listener._registered && listener.swallowTouches) {
          argsObj.needsMutableSet && argsObj.touches.splice(selTouch, 1);
          return true;
        }
        return false;
      },
      _dispatchTouchEvent: function(event) {
        this._sortEventListeners(ListenerID.TOUCH_ONE_BY_ONE);
        this._sortEventListeners(ListenerID.TOUCH_ALL_AT_ONCE);
        var oneByOneListeners = this._getListeners(ListenerID.TOUCH_ONE_BY_ONE);
        var allAtOnceListeners = this._getListeners(ListenerID.TOUCH_ALL_AT_ONCE);
        if (null === oneByOneListeners && null === allAtOnceListeners) return;
        var originalTouches = event.getTouches(), mutableTouches = cc.js.array.copy(originalTouches);
        var oneByOneArgsObj = {
          event: event,
          needsMutableSet: oneByOneListeners && allAtOnceListeners,
          touches: mutableTouches,
          selTouch: null
        };
        if (oneByOneListeners) for (var i = 0; i < originalTouches.length; i++) {
          event.currentTouch = originalTouches[i];
          event._propagationStopped = event._propagationImmediateStopped = false;
          this._dispatchEventToListeners(oneByOneListeners, this._onTouchEventCallback, oneByOneArgsObj);
        }
        if (allAtOnceListeners && mutableTouches.length > 0) {
          this._dispatchEventToListeners(allAtOnceListeners, this._onTouchesEventCallback, {
            event: event,
            touches: mutableTouches
          });
          if (event.isStopped()) return;
        }
        this._updateTouchListeners(event);
      },
      _onTouchesEventCallback: function(listener, callbackParams) {
        if (!listener._registered) return false;
        var EventTouch = cc.Event.EventTouch, event = callbackParams.event, touches = callbackParams.touches, getCode = event.getEventCode();
        event.currentTarget = listener._node;
        getCode === EventTouch.BEGAN && listener.onTouchesBegan ? listener.onTouchesBegan(touches, event) : getCode === EventTouch.MOVED && listener.onTouchesMoved ? listener.onTouchesMoved(touches, event) : getCode === EventTouch.ENDED && listener.onTouchesEnded ? listener.onTouchesEnded(touches, event) : getCode === EventTouch.CANCELLED && listener.onTouchesCancelled && listener.onTouchesCancelled(touches, event);
        if (event.isStopped()) {
          eventManager._updateTouchListeners(event);
          return true;
        }
        return false;
      },
      _associateNodeAndEventListener: function(node, listener) {
        var listeners = this._nodeListenersMap[node._id];
        if (!listeners) {
          listeners = [];
          this._nodeListenersMap[node._id] = listeners;
        }
        listeners.push(listener);
      },
      _dissociateNodeAndEventListener: function(node, listener) {
        var listeners = this._nodeListenersMap[node._id];
        if (listeners) {
          cc.js.array.remove(listeners, listener);
          0 === listeners.length && delete this._nodeListenersMap[node._id];
        }
      },
      _dispatchEventToListeners: function(listeners, onEvent, eventOrArgs) {
        var shouldStopPropagation = false;
        var fixedPriorityListeners = listeners.getFixedPriorityListeners();
        var sceneGraphPriorityListeners = listeners.getSceneGraphPriorityListeners();
        var i = 0, j, selListener;
        if (fixedPriorityListeners && 0 !== fixedPriorityListeners.length) for (;i < listeners.gt0Index; ++i) {
          selListener = fixedPriorityListeners[i];
          if (selListener.isEnabled() && !selListener._isPaused() && selListener._isRegistered() && onEvent(selListener, eventOrArgs)) {
            shouldStopPropagation = true;
            break;
          }
        }
        if (sceneGraphPriorityListeners && !shouldStopPropagation) for (j = 0; j < sceneGraphPriorityListeners.length; j++) {
          selListener = sceneGraphPriorityListeners[j];
          if (selListener.isEnabled() && !selListener._isPaused() && selListener._isRegistered() && onEvent(selListener, eventOrArgs)) {
            shouldStopPropagation = true;
            break;
          }
        }
        if (fixedPriorityListeners && !shouldStopPropagation) for (;i < fixedPriorityListeners.length; ++i) {
          selListener = fixedPriorityListeners[i];
          if (selListener.isEnabled() && !selListener._isPaused() && selListener._isRegistered() && onEvent(selListener, eventOrArgs)) {
            shouldStopPropagation = true;
            break;
          }
        }
      },
      _setDirty: function(listenerID, flag) {
        var locDirtyFlagMap = this._priorityDirtyFlagMap;
        null == locDirtyFlagMap[listenerID] ? locDirtyFlagMap[listenerID] = flag : locDirtyFlagMap[listenerID] = flag | locDirtyFlagMap[listenerID];
      },
      _visitTarget: function(node, isRootNode) {
        node._reorderChildDirty && node.sortAllChildren();
        var children = node.getChildren(), i = 0;
        var childrenCount = children.length, locGlobalZOrderNodeMap = this._globalZOrderNodeMap, locNodeListenersMap = this._nodeListenersMap;
        if (childrenCount > 0) {
          if (void 0 !== locNodeListenersMap[node._id]) {
            locGlobalZOrderNodeMap || (locGlobalZOrderNodeMap = []);
            locGlobalZOrderNodeMap.push(node._id);
          }
          var child;
          for (;i < childrenCount; i++) {
            child = children[i];
            child && this._visitTarget(child, false);
          }
        } else if (void 0 !== locNodeListenersMap[node._id]) {
          locGlobalZOrderNodeMap || (locGlobalZOrderNodeMap = []);
          locGlobalZOrderNodeMap.push(node._id);
        }
        if (isRootNode) {
          var locNodePriorityMap = this._nodePriorityMap;
          for (var j = 0; j < locGlobalZOrderNodeMap.length; j++) locNodePriorityMap[locGlobalZOrderNodeMap[j]] = ++this._nodePriorityIndex;
          this._globalZOrderNodeMap.length = 0;
        }
      },
      _sortNumberAsc: function(a, b) {
        return a - b;
      },
      hasEventListener: function(listenerID) {
        return !!this._getListeners(listenerID);
      },
      addListener: function(listener, nodeOrPriority) {
        cc.assertID(listener && nodeOrPriority, 3503);
        if (!(cc.js.isNumber(nodeOrPriority) || nodeOrPriority instanceof cc._BaseNode)) {
          cc.warnID(3506);
          return;
        }
        if (listener instanceof cc.EventListener) {
          if (listener._isRegistered()) {
            cc.logID(3505);
            return;
          }
        } else {
          cc.assertID(!cc.js.isNumber(nodeOrPriority), 3504);
          listener = cc.EventListener.create(listener);
        }
        if (!listener.checkAvailable()) return;
        if (cc.js.isNumber(nodeOrPriority)) {
          if (0 === nodeOrPriority) {
            cc.logID(3500);
            return;
          }
          listener._setSceneGraphPriority(null);
          listener._setFixedPriority(nodeOrPriority);
          listener._setRegistered(true);
          listener._setPaused(false);
          this._addListener(listener);
        } else {
          listener._setSceneGraphPriority(nodeOrPriority);
          listener._setFixedPriority(0);
          listener._setRegistered(true);
          this._addListener(listener);
        }
        return listener;
      },
      addCustomListener: function(eventName, callback) {
        var listener = new cc.EventListener.create({
          event: cc.EventListener.CUSTOM,
          eventName: eventName,
          callback: callback
        });
        this.addListener(listener, 1);
        return listener;
      },
      removeListener: function(listener) {
        if (null == listener) return;
        var isFound, locListener = this._listenersMap;
        for (var selKey in locListener) {
          var listeners = locListener[selKey];
          var fixedPriorityListeners = listeners.getFixedPriorityListeners(), sceneGraphPriorityListeners = listeners.getSceneGraphPriorityListeners();
          isFound = this._removeListenerInVector(sceneGraphPriorityListeners, listener);
          if (isFound) this._setDirty(listener._getListenerID(), this.DIRTY_SCENE_GRAPH_PRIORITY); else {
            isFound = this._removeListenerInVector(fixedPriorityListeners, listener);
            isFound && this._setDirty(listener._getListenerID(), this.DIRTY_FIXED_PRIORITY);
          }
          if (listeners.empty()) {
            delete this._priorityDirtyFlagMap[listener._getListenerID()];
            delete locListener[selKey];
          }
          if (isFound) break;
        }
        if (!isFound) {
          var locToAddedListeners = this._toAddedListeners;
          for (var i = 0, len = locToAddedListeners.length; i < len; i++) {
            var selListener = locToAddedListeners[i];
            if (selListener === listener) {
              cc.js.array.remove(locToAddedListeners, selListener);
              selListener._setRegistered(false);
              break;
            }
          }
        }
      },
      _removeListenerInCallback: function(listeners, callback) {
        if (null == listeners) return false;
        for (var i = 0, len = listeners.length; i < len; i++) {
          var selListener = listeners[i];
          if (selListener._onCustomEvent === callback || selListener._onEvent === callback) {
            selListener._setRegistered(false);
            if (null != selListener._getSceneGraphPriority()) {
              this._dissociateNodeAndEventListener(selListener._getSceneGraphPriority(), selListener);
              selListener._setSceneGraphPriority(null);
            }
            0 === this._inDispatch ? cc.js.array.remove(listeners, selListener) : this._toRemovedListeners.push(selListener);
            return true;
          }
        }
        return false;
      },
      _removeListenerInVector: function(listeners, listener) {
        if (null == listeners) return false;
        for (var i = 0, len = listeners.length; i < len; i++) {
          var selListener = listeners[i];
          if (selListener === listener) {
            selListener._setRegistered(false);
            if (null != selListener._getSceneGraphPriority()) {
              this._dissociateNodeAndEventListener(selListener._getSceneGraphPriority(), selListener);
              selListener._setSceneGraphPriority(null);
            }
            0 === this._inDispatch ? cc.js.array.remove(listeners, selListener) : this._toRemovedListeners.push(selListener);
            return true;
          }
        }
        return false;
      },
      removeListeners: function(listenerType, recursive) {
        var i, _t = this;
        if (!(cc.js.isNumber(listenerType) || listenerType instanceof cc._BaseNode)) {
          cc.warnID(3506);
          return;
        }
        if (void 0 !== listenerType._id) {
          delete _t._nodePriorityMap[listenerType._id];
          cc.js.array.remove(_t._dirtyNodes, listenerType);
          var listeners = _t._nodeListenersMap[listenerType._id], i;
          if (listeners) {
            var listenersCopy = cc.js.array.copy(listeners);
            for (i = 0; i < listenersCopy.length; i++) _t.removeListener(listenersCopy[i]);
            delete _t._nodeListenersMap[listenerType._id];
          }
          var locToAddedListeners = _t._toAddedListeners;
          for (i = 0; i < locToAddedListeners.length; ) {
            var listener = locToAddedListeners[i];
            if (listener._getSceneGraphPriority() === listenerType) {
              listener._setSceneGraphPriority(null);
              listener._setRegistered(false);
              locToAddedListeners.splice(i, 1);
            } else ++i;
          }
          if (true === recursive) {
            var locChildren = listenerType.getChildren(), len;
            for (i = 0, len = locChildren.length; i < len; i++) _t.removeListeners(locChildren[i], true);
          }
        } else listenerType === cc.EventListener.TOUCH_ONE_BY_ONE ? _t._removeListenersForListenerID(ListenerID.TOUCH_ONE_BY_ONE) : listenerType === cc.EventListener.TOUCH_ALL_AT_ONCE ? _t._removeListenersForListenerID(ListenerID.TOUCH_ALL_AT_ONCE) : listenerType === cc.EventListener.MOUSE ? _t._removeListenersForListenerID(ListenerID.MOUSE) : listenerType === cc.EventListener.ACCELERATION ? _t._removeListenersForListenerID(ListenerID.ACCELERATION) : listenerType === cc.EventListener.KEYBOARD ? _t._removeListenersForListenerID(ListenerID.KEYBOARD) : cc.logID(3501);
      },
      removeCustomListeners: function(customEventName) {
        this._removeListenersForListenerID(customEventName);
      },
      removeAllListeners: function() {
        var locListeners = this._listenersMap, locInternalCustomEventIDs = this._internalCustomListenerIDs;
        for (var selKey in locListeners) -1 === locInternalCustomEventIDs.indexOf(selKey) && this._removeListenersForListenerID(selKey);
      },
      setPriority: function(listener, fixedPriority) {
        if (null == listener) return;
        var locListeners = this._listenersMap;
        for (var selKey in locListeners) {
          var selListeners = locListeners[selKey];
          var fixedPriorityListeners = selListeners.getFixedPriorityListeners();
          if (fixedPriorityListeners) {
            var found = fixedPriorityListeners.indexOf(listener);
            if (-1 !== found) {
              null != listener._getSceneGraphPriority() && cc.logID(3502);
              if (listener._getFixedPriority() !== fixedPriority) {
                listener._setFixedPriority(fixedPriority);
                this._setDirty(listener._getListenerID(), this.DIRTY_FIXED_PRIORITY);
              }
              return;
            }
          }
        }
      },
      setEnabled: function(enabled) {
        this._isEnabled = enabled;
      },
      isEnabled: function() {
        return this._isEnabled;
      },
      dispatchEvent: function(event) {
        if (!this._isEnabled) return;
        this._updateDirtyFlagForSceneGraph();
        this._inDispatch++;
        if (!event || !event.getType) {
          cc.errorID(3511);
          return;
        }
        if (event.getType().startsWith(cc.Event.TOUCH)) {
          this._dispatchTouchEvent(event);
          this._inDispatch--;
          return;
        }
        var listenerID = __getListenerID(event);
        this._sortEventListeners(listenerID);
        var selListeners = this._listenersMap[listenerID];
        if (null != selListeners) {
          this._dispatchEventToListeners(selListeners, this._onListenerCallback, event);
          this._onUpdateListeners(selListeners);
        }
        this._inDispatch--;
      },
      _onListenerCallback: function(listener, event) {
        event.currentTarget = listener._target;
        listener._onEvent(event);
        return event.isStopped();
      },
      dispatchCustomEvent: function(eventName, optionalUserData) {
        var ev = new cc.Event.EventCustom(eventName);
        ev.setUserData(optionalUserData);
        this.dispatchEvent(ev);
      }
    };
    js.get(cc, "eventManager", (function() {
      cc.warnID(1405, "cc.eventManager", "cc.EventTarget or cc.systemEvent");
      return eventManager;
    }));
    module.exports = eventManager;
  }), {
    "../platform/js": 167,
    "./CCEventListener": 86
  } ],
  88: [ (function(require, module, exports) {
    cc.Touch = function(x, y, id) {
      this._lastModified = 0;
      this.setTouchInfo(id, x, y);
    };
    cc.Touch.prototype = {
      constructor: cc.Touch,
      getLocation: function() {
        return cc.v2(this._point.x, this._point.y);
      },
      getLocationX: function() {
        return this._point.x;
      },
      getLocationY: function() {
        return this._point.y;
      },
      getPreviousLocation: function() {
        return cc.v2(this._prevPoint.x, this._prevPoint.y);
      },
      getStartLocation: function() {
        return cc.v2(this._startPoint.x, this._startPoint.y);
      },
      getDelta: function() {
        return this._point.sub(this._prevPoint);
      },
      getLocationInView: function() {
        return cc.v2(this._point.x, cc.view._designResolutionSize.height - this._point.y);
      },
      getPreviousLocationInView: function() {
        return cc.v2(this._prevPoint.x, cc.view._designResolutionSize.height - this._prevPoint.y);
      },
      getStartLocationInView: function() {
        return cc.v2(this._startPoint.x, cc.view._designResolutionSize.height - this._startPoint.y);
      },
      getID: function() {
        return this._id;
      },
      setTouchInfo: function(id, x, y) {
        this._prevPoint = this._point;
        this._point = cc.v2(x || 0, y || 0);
        this._id = id;
        if (!this._startPointCaptured) {
          this._startPoint = cc.v2(this._point);
          cc.view._convertPointWithScale(this._startPoint);
          this._startPointCaptured = true;
        }
      },
      _setPoint: function(x, y) {
        if (void 0 === y) {
          this._point.x = x.x;
          this._point.y = x.y;
        } else {
          this._point.x = x;
          this._point.y = y;
        }
      },
      _setPrevPoint: function(x, y) {
        this._prevPoint = void 0 === y ? cc.v2(x.x, x.y) : cc.v2(x || 0, y || 0);
      }
    };
  }), {} ],
  89: [ (function(require, module, exports) {
    require("./CCEvent");
    require("./CCTouch");
    require("./CCEventListener");
    var eventManager = require("./CCEventManager");
    module.exports = eventManager;
    false;
  }), {
    "./CCEvent": 85,
    "./CCEventListener": 86,
    "./CCEventManager": 87,
    "./CCTouch": 88
  } ],
  90: [ (function(require, module, exports) {
    var js = cc.js;
    var CallbacksHandler = require("../platform/callbacks-invoker").CallbacksHandler;
    function EventListeners() {
      CallbacksHandler.call(this);
    }
    js.extend(EventListeners, CallbacksHandler);
    EventListeners.prototype.invoke = function(event, captureListeners) {
      var key = event.type;
      var list = this._callbackTable[key];
      if (list) {
        var rootInvoker = !list.isInvoking;
        list.isInvoking = true;
        var callbacks = list.callbacks;
        var targets = list.targets;
        for (var i = 0, len = callbacks.length; i < len; ++i) {
          var callback = callbacks[i];
          if (callback) {
            var target = targets[i] || event.currentTarget;
            callback.call(target, event, captureListeners);
            if (event._propagationImmediateStopped) break;
          }
        }
        if (rootInvoker) {
          list.isInvoking = false;
          list.containCanceled && list.purgeCanceled();
        }
      }
    };
    module.exports = EventListeners;
    false;
  }), {
    "../platform/callbacks-invoker": 160
  } ],
  91: [ (function(require, module, exports) {
    var js = require("../platform/js");
    var CallbacksInvoker = require("../platform/callbacks-invoker");
    var fastRemove = js.array.fastRemove;
    function EventTarget() {
      CallbacksInvoker.call(this);
    }
    js.extend(EventTarget, CallbacksInvoker);
    var proto = EventTarget.prototype;
    proto.on = function(type, callback, target) {
      if (!callback) {
        cc.errorID(6800);
        return;
      }
      if (!this.hasEventListener(type, callback, target)) {
        this.add(type, callback, target);
        target && target.__eventTargets && target.__eventTargets.push(this);
      }
      return callback;
    };
    proto.off = function(type, callback, target) {
      if (callback) {
        this.remove(type, callback, target);
        target && target.__eventTargets && fastRemove(target.__eventTargets, this);
      } else this.removeAll(type);
    };
    proto.targetOff = proto.removeAll;
    proto.once = function(type, callback, target) {
      var eventType_hasOnceListener = "__ONCE_FLAG:" + type;
      var hasOnceListener = this.hasEventListener(eventType_hasOnceListener, callback, target);
      if (!hasOnceListener) {
        var self = this;
        var onceWrapper = function(arg1, arg2, arg3, arg4, arg5) {
          self.off(type, onceWrapper, target);
          self.remove(eventType_hasOnceListener, callback, target);
          callback.call(this, arg1, arg2, arg3, arg4, arg5);
        };
        this.on(type, onceWrapper, target);
        this.add(eventType_hasOnceListener, callback, target);
      }
    };
    proto.emit = CallbacksInvoker.prototype.invoke;
    proto.dispatchEvent = function(event) {
      this.invoke(event.type, event);
    };
    cc.EventTarget = module.exports = EventTarget;
  }), {
    "../platform/callbacks-invoker": 160,
    "../platform/js": 167
  } ],
  92: [ (function(require, module, exports) {
    var js = require("../platform/js");
    cc.Event = function(type, bubbles) {
      this.type = type;
      this.bubbles = !!bubbles;
      this.target = null;
      this.currentTarget = null;
      this.eventPhase = 0;
      this._propagationStopped = false;
      this._propagationImmediateStopped = false;
    };
    cc.Event.prototype = {
      constructor: cc.Event,
      unuse: function() {
        this.type = cc.Event.NO_TYPE;
        this.target = null;
        this.currentTarget = null;
        this.eventPhase = cc.Event.NONE;
        this._propagationStopped = false;
        this._propagationImmediateStopped = false;
      },
      reuse: function(type, bubbles) {
        this.type = type;
        this.bubbles = bubbles || false;
      },
      stopPropagation: function() {
        this._propagationStopped = true;
      },
      stopPropagationImmediate: function() {
        this._propagationImmediateStopped = true;
      },
      isStopped: function() {
        return this._propagationStopped || this._propagationImmediateStopped;
      },
      getCurrentTarget: function() {
        return this.currentTarget;
      },
      getType: function() {
        return this.type;
      }
    };
    cc.Event.NO_TYPE = "no_type";
    cc.Event.TOUCH = "touch";
    cc.Event.MOUSE = "mouse";
    cc.Event.KEYBOARD = "keyboard";
    cc.Event.ACCELERATION = "acceleration";
    cc.Event.NONE = 0;
    cc.Event.CAPTURING_PHASE = 1;
    cc.Event.AT_TARGET = 2;
    cc.Event.BUBBLING_PHASE = 3;
    var EventCustom = function(type, bubbles) {
      cc.Event.call(this, type, bubbles);
      this.detail = null;
    };
    js.extend(EventCustom, cc.Event);
    EventCustom.prototype.reset = EventCustom;
    EventCustom.prototype.setUserData = function(data) {
      this.detail = data;
    };
    EventCustom.prototype.getUserData = function() {
      return this.detail;
    };
    EventCustom.prototype.getEventName = cc.Event.prototype.getType;
    var MAX_POOL_SIZE = 10;
    var _eventPool = new js.Pool(MAX_POOL_SIZE);
    EventCustom.put = function(event) {
      _eventPool.put(event);
    };
    EventCustom.get = function(type, bubbles) {
      var event = _eventPool._get();
      event ? event.reset(type, bubbles) : event = new EventCustom(type, bubbles);
      return event;
    };
    cc.Event.EventCustom = EventCustom;
    module.exports = cc.Event;
  }), {
    "../platform/js": 167
  } ],
  93: [ (function(require, module, exports) {
    require("./event");
    require("./event-listeners");
    require("./event-target");
    require("./system-event");
  }), {
    "./event": 92,
    "./event-listeners": 90,
    "./event-target": 91,
    "./system-event": 94
  } ],
  94: [ (function(require, module, exports) {
    var EventTarget = require("../event/event-target");
    var eventManager = require("../event-manager");
    var inputManger = require("../platform/CCInputManager");
    var EventType = cc.Enum({
      KEY_DOWN: "keydown",
      KEY_UP: "keyup",
      DEVICEMOTION: "devicemotion"
    });
    var keyboardListener = null;
    var accelerationListener = null;
    var SystemEvent = cc.Class({
      name: "SystemEvent",
      extends: EventTarget,
      statics: {
        EventType: EventType
      },
      setAccelerometerEnabled: function(isEnable) {
        inputManger.setAccelerometerEnabled(isEnable);
      },
      setAccelerometerInterval: function(interval) {
        inputManger.setAccelerometerInterval(interval);
      },
      on: function(type, callback, target) {
        this._super(type, callback, target);
        if (type === EventType.KEY_DOWN || type === EventType.KEY_UP) {
          keyboardListener || (keyboardListener = cc.EventListener.create({
            event: cc.EventListener.KEYBOARD,
            onKeyPressed: function(keyCode, event) {
              event.type = EventType.KEY_DOWN;
              cc.systemEvent.dispatchEvent(event);
            },
            onKeyReleased: function(keyCode, event) {
              event.type = EventType.KEY_UP;
              cc.systemEvent.dispatchEvent(event);
            }
          }));
          eventManager.hasEventListener(cc.EventListener.ListenerID.KEYBOARD) || eventManager.addListener(keyboardListener, 1);
        }
        if (type === EventType.DEVICEMOTION) {
          accelerationListener || (accelerationListener = cc.EventListener.create({
            event: cc.EventListener.ACCELERATION,
            callback: function(acc, event) {
              event.type = EventType.DEVICEMOTION;
              cc.systemEvent.dispatchEvent(event);
            }
          }));
          eventManager.hasEventListener(cc.EventListener.ListenerID.ACCELERATION) || eventManager.addListener(accelerationListener, 1);
        }
      },
      off: function(type, callback, target) {
        this._super(type, callback, target);
        if (keyboardListener && (type === EventType.KEY_DOWN || type === EventType.KEY_UP)) {
          var hasKeyDownEventListener = this.hasEventListener(EventType.KEY_DOWN);
          var hasKeyUpEventListener = this.hasEventListener(EventType.KEY_UP);
          hasKeyDownEventListener || hasKeyUpEventListener || eventManager.removeListener(keyboardListener);
        }
        accelerationListener && type === EventType.DEVICEMOTION && eventManager.removeListener(accelerationListener);
      }
    });
    cc.SystemEvent = module.exports = SystemEvent;
    true;
    cc.systemEvent = new cc.SystemEvent();
  }), {
    "../event-manager": 89,
    "../event/event-target": 91,
    "../platform/CCInputManager": 151
  } ],
  95: [ (function(require, module, exports) {
    var RenderComponent = require("../components/CCRenderComponent");
    var SpriteMaterial = require("../renderer/render-engine").SpriteMaterial;
    var Types = require("./types");
    var LineCap = Types.LineCap;
    var LineJoin = Types.LineJoin;
    var Graphics = cc.Class({
      name: "cc.Graphics",
      extends: RenderComponent,
      editor: false,
      ctor: function() {
        this._impl = Graphics._assembler.createImpl(this);
      },
      properties: {
        _lineWidth: 1,
        _strokeColor: cc.Color.BLACK,
        _lineJoin: LineJoin.MITER,
        _lineCap: LineCap.BUTT,
        _fillColor: cc.Color.WHITE,
        _miterLimit: 10,
        lineWidth: {
          get: function() {
            return this._lineWidth;
          },
          set: function(value) {
            this._lineWidth = value;
            this._impl.lineWidth = value;
          }
        },
        lineJoin: {
          get: function() {
            return this._lineJoin;
          },
          set: function(value) {
            this._lineJoin = value;
            this._impl.lineJoin = value;
          },
          type: LineJoin
        },
        lineCap: {
          get: function() {
            return this._lineCap;
          },
          set: function(value) {
            this._lineCap = value;
            this._impl.lineCap = value;
          },
          type: LineCap
        },
        strokeColor: {
          get: function() {
            return this._strokeColor;
          },
          set: function(value) {
            this._impl.strokeColor = this._strokeColor = cc.color(value);
          }
        },
        fillColor: {
          get: function() {
            return this._fillColor;
          },
          set: function(value) {
            this._impl.fillColor = this._fillColor = cc.color(value);
          }
        },
        miterLimit: {
          get: function() {
            return this._miterLimit;
          },
          set: function(value) {
            this._miterLimit = value;
            this._impl.miterLimit = value;
          }
        }
      },
      statics: {
        LineJoin: LineJoin,
        LineCap: LineCap
      },
      onRestore: function() {
        this._impl || (this._impl = Graphics._assembler.createImpl());
      },
      onEnable: function() {
        this._super();
        this._activateMaterial();
      },
      onDestroy: function() {
        this._super();
        this._impl.clear(this, true);
        this._impl = null;
      },
      _activateMaterial: function() {
        if (cc.game.renderType === cc.game.RENDER_TYPE_CANVAS) return;
        this.node._renderFlag &= ~cc.RenderFlow.FLAG_RENDER;
        this.node._renderFlag |= cc.RenderFlow.FLAG_CUSTOM_IA_RENDER;
        if (this._material) return;
        var material = new SpriteMaterial();
        material.useColor = false;
        material.useTexture = false;
        material.useModel = true;
        this._updateMaterial(material);
      },
      moveTo: function(x, y) {
        if (true, x instanceof cc.Vec2) {
          cc.warn("[moveTo] : Can not pass Vec2 as [x, y] value, please check it.");
          return;
        }
        this._impl.moveTo(x, y);
      },
      lineTo: function(x, y) {
        if (true, x instanceof cc.Vec2) {
          cc.warn("[moveTo] : Can not pass Vec2 as [x, y] value, please check it.");
          return;
        }
        this._impl.lineTo(x, y);
      },
      bezierCurveTo: function(c1x, c1y, c2x, c2y, x, y) {
        this._impl.bezierCurveTo(c1x, c1y, c2x, c2y, x, y);
      },
      quadraticCurveTo: function(cx, cy, x, y) {
        this._impl.quadraticCurveTo(cx, cy, x, y);
      },
      arc: function(cx, cy, r, startAngle, endAngle, counterclockwise) {
        this._impl.arc(cx, cy, r, startAngle, endAngle, counterclockwise);
      },
      ellipse: function(cx, cy, rx, ry) {
        this._impl.ellipse(cx, cy, rx, ry);
      },
      circle: function(cx, cy, r) {
        this._impl.circle(cx, cy, r);
      },
      rect: function(x, y, w, h) {
        this._impl.rect(x, y, w, h);
      },
      roundRect: function(x, y, w, h, r) {
        this._impl.roundRect(x, y, w, h, r);
      },
      fillRect: function(x, y, w, h) {
        this.rect(x, y, w, h);
        this.fill();
      },
      clear: function(clean) {
        this._impl.clear(this, clean);
      },
      close: function() {
        this._impl.close();
      },
      stroke: function() {
        Graphics._assembler.stroke(this);
      },
      fill: function() {
        Graphics._assembler.fill(this);
      }
    });
    cc.Graphics = module.exports = Graphics;
  }), {
    "../components/CCRenderComponent": 68,
    "../renderer/render-engine": 174,
    "./types": 98
  } ],
  96: [ (function(require, module, exports) {
    var PointFlags = require("./types").PointFlags;
    var PI = Math.PI;
    var min = Math.min;
    var max = Math.max;
    var cos = Math.cos;
    var sin = Math.sin;
    var abs = Math.abs;
    var sign = Math.sign;
    var KAPPA90 = .5522847493;
    function arc(ctx, cx, cy, r, startAngle, endAngle, counterclockwise) {
      counterclockwise = counterclockwise || false;
      var a = 0, da = 0, hda = 0, kappa = 0;
      var dx = 0, dy = 0, x = 0, y = 0, tanx = 0, tany = 0;
      var px = 0, py = 0, ptanx = 0, ptany = 0;
      var i, ndivs;
      da = endAngle - startAngle;
      if (counterclockwise) if (abs(da) >= 2 * PI) da = 2 * PI; else while (da < 0) da += 2 * PI; else if (abs(da) >= 2 * PI) da = 2 * -PI; else while (da > 0) da -= 2 * PI;
      ndivs = 0 | max(1, min(abs(da) / (.5 * PI) + .5, 5));
      hda = da / ndivs / 2;
      kappa = abs(4 / 3 * (1 - cos(hda)) / sin(hda));
      counterclockwise || (kappa = -kappa);
      for (i = 0; i <= ndivs; i++) {
        a = startAngle + da * (i / ndivs);
        dx = cos(a);
        dy = sin(a);
        x = cx + dx * r;
        y = cy + dy * r;
        tanx = -dy * r * kappa;
        tany = dx * r * kappa;
        0 === i ? ctx.moveTo(x, y) : ctx.bezierCurveTo(px + ptanx, py + ptany, x - tanx, y - tany, x, y);
        px = x;
        py = y;
        ptanx = tanx;
        ptany = tany;
      }
    }
    function ellipse(ctx, cx, cy, rx, ry) {
      ctx.moveTo(cx - rx, cy);
      ctx.bezierCurveTo(cx - rx, cy + ry * KAPPA90, cx - rx * KAPPA90, cy + ry, cx, cy + ry);
      ctx.bezierCurveTo(cx + rx * KAPPA90, cy + ry, cx + rx, cy + ry * KAPPA90, cx + rx, cy);
      ctx.bezierCurveTo(cx + rx, cy - ry * KAPPA90, cx + rx * KAPPA90, cy - ry, cx, cy - ry);
      ctx.bezierCurveTo(cx - rx * KAPPA90, cy - ry, cx - rx, cy - ry * KAPPA90, cx - rx, cy);
      ctx.close();
    }
    function roundRect(ctx, x, y, w, h, r) {
      if (r < .1) {
        ctx.rect(x, y, w, h);
        return;
      }
      var rx = min(r, .5 * abs(w)) * sign(w), ry = min(r, .5 * abs(h)) * sign(h);
      ctx.moveTo(x, y + ry);
      ctx.lineTo(x, y + h - ry);
      ctx.bezierCurveTo(x, y + h - ry * (1 - KAPPA90), x + rx * (1 - KAPPA90), y + h, x + rx, y + h);
      ctx.lineTo(x + w - rx, y + h);
      ctx.bezierCurveTo(x + w - rx * (1 - KAPPA90), y + h, x + w, y + h - ry * (1 - KAPPA90), x + w, y + h - ry);
      ctx.lineTo(x + w, y + ry);
      ctx.bezierCurveTo(x + w, y + ry * (1 - KAPPA90), x + w - rx * (1 - KAPPA90), y, x + w - rx, y);
      ctx.lineTo(x + rx, y);
      ctx.bezierCurveTo(x + rx * (1 - KAPPA90), y, x, y + ry * (1 - KAPPA90), x, y + ry);
      ctx.close();
    }
    function tesselateBezier(ctx, x1, y1, x2, y2, x3, y3, x4, y4, level, type) {
      var x12, y12, x23, y23, x34, y34, x123, y123, x234, y234, x1234, y1234;
      var dx, dy, d2, d3;
      if (level > 10) return;
      x12 = .5 * (x1 + x2);
      y12 = .5 * (y1 + y2);
      x23 = .5 * (x2 + x3);
      y23 = .5 * (y2 + y3);
      x34 = .5 * (x3 + x4);
      y34 = .5 * (y3 + y4);
      x123 = .5 * (x12 + x23);
      y123 = .5 * (y12 + y23);
      dx = x4 - x1;
      dy = y4 - y1;
      d2 = abs((x2 - x4) * dy - (y2 - y4) * dx);
      d3 = abs((x3 - x4) * dy - (y3 - y4) * dx);
      if ((d2 + d3) * (d2 + d3) < ctx._tessTol * (dx * dx + dy * dy)) {
        ctx._addPoint(x4, y4, 0 === type ? type | PointFlags.PT_BEVEL : type);
        return;
      }
      x234 = .5 * (x23 + x34);
      y234 = .5 * (y23 + y34);
      x1234 = .5 * (x123 + x234);
      y1234 = .5 * (y123 + y234);
      tesselateBezier(ctx, x1, y1, x12, y12, x123, y123, x1234, y1234, level + 1, 0);
      tesselateBezier(ctx, x1234, y1234, x234, y234, x34, y34, x4, y4, level + 1, type);
    }
    module.exports = {
      arc: arc,
      ellipse: ellipse,
      roundRect: roundRect,
      tesselateBezier: tesselateBezier
    };
  }), {
    "./types": 98
  } ],
  97: [ (function(require, module, exports) {
    "use strict";
    require("./graphics");
  }), {
    "./graphics": 95
  } ],
  98: [ (function(require, module, exports) {
    "use strict";
    var LineCap = cc.Enum({
      BUTT: 0,
      ROUND: 1,
      SQUARE: 2
    });
    var LineJoin = cc.Enum({
      BEVEL: 0,
      ROUND: 1,
      MITER: 2
    });
    var PointFlags = cc.Enum({
      PT_CORNER: 1,
      PT_LEFT: 2,
      PT_BEVEL: 4,
      PT_INNERBEVEL: 8
    });
    module.exports = {
      LineCap: LineCap,
      LineJoin: LineJoin,
      PointFlags: PointFlags
    };
  }), {} ],
  99: [ (function(require, module, exports) {
    require("./platform");
    require("./assets");
    true;
    require("./CCNode");
    require("./CCPrivateNode");
    require("./CCScene");
    require("./components");
    require("./graphics");
    require("./collider");
    require("./collider/CCIntersection");
    require("./physics");
    require("./camera/CCCamera");
    require("./utils/polyfill-3d");
    require("./base-ui/CCWidgetManager");
  }), {
    "./CCNode": 25,
    "./CCPrivateNode": 26,
    "./CCScene": 27,
    "./assets": 44,
    "./base-ui/CCWidgetManager": 45,
    "./camera/CCCamera": 46,
    "./collider": 53,
    "./collider/CCIntersection": void 0,
    "./components": 83,
    "./graphics": 97,
    "./physics": 130,
    "./platform": 164,
    "./utils/polyfill-3d": 210
  } ],
  100: [ (function(require, module, exports) {
    var js = require("../platform/js");
    var Pipeline = require("./pipeline");
    var LoadingItems = require("./loading-items");
    var AssetLoader = require("./asset-loader");
    var Downloader = require("./downloader");
    var Loader = require("./loader");
    var AssetTable = require("./asset-table");
    var callInNextTick = require("../platform/utils").callInNextTick;
    var AutoReleaseUtils = require("./auto-release-utils");
    var ReleasedAssetChecker = (true, require("./released-asset-checker"));
    var resources = new AssetTable();
    function getXMLHttpRequest() {
      return window.XMLHttpRequest ? new window.XMLHttpRequest() : new ActiveXObject("MSXML2.XMLHTTP");
    }
    var _info = {
      url: null,
      raw: false
    };
    function getResWithUrl(res) {
      var id, result, isUuid;
      if ("object" === typeof res) {
        result = res;
        if (res.url) return result;
        id = res.uuid;
      } else {
        result = {};
        id = res;
      }
      isUuid = result.type ? "uuid" === result.type : cc.AssetLibrary._uuidInSettings(id);
      cc.AssetLibrary._getAssetInfoInRuntime(id, _info);
      result.url = isUuid ? _info.url : id;
      if (_info.url && "uuid" === result.type && _info.raw) {
        result.type = null;
        result.isRawAsset = true;
      } else isUuid || (result.isRawAsset = true);
      return result;
    }
    var _sharedResources = [];
    var _sharedList = [];
    function CCLoader() {
      var assetLoader = new AssetLoader();
      var downloader = new Downloader();
      var loader = new Loader();
      Pipeline.call(this, [ assetLoader, downloader, loader ]);
      this.assetLoader = assetLoader;
      this.downloader = downloader;
      this.loader = loader;
      this.onProgress = null;
      this._autoReleaseSetting = js.createMap(true);
      true;
      this._releasedAssetChecker_DEBUG = new ReleasedAssetChecker();
    }
    js.extend(CCLoader, Pipeline);
    var proto = CCLoader.prototype;
    proto.init = function(director) {
      true;
      var self = this;
      director.on(cc.Director.EVENT_AFTER_UPDATE, (function() {
        self._releasedAssetChecker_DEBUG.checkCouldRelease(self._cache);
      }));
    };
    proto.getXMLHttpRequest = getXMLHttpRequest;
    proto.addDownloadHandlers = function(extMap) {
      this.downloader.addHandlers(extMap);
    };
    proto.addLoadHandlers = function(extMap) {
      this.loader.addHandlers(extMap);
    };
    proto.load = function(resources, progressCallback, completeCallback) {
      false;
      if (void 0 === completeCallback) {
        completeCallback = progressCallback;
        progressCallback = this.onProgress || null;
      }
      var self = this;
      var singleRes = false;
      var res;
      if (!(resources instanceof Array)) {
        singleRes = true;
        resources = resources ? [ resources ] : [];
      }
      _sharedResources.length = 0;
      for (var i = 0; i < resources.length; ++i) {
        var resource = resources[i];
        if (resource && resource.id) {
          cc.warnID(4920, resource.id);
          resource.uuid || resource.url || (resource.url = resource.id);
        }
        res = getResWithUrl(resource);
        if (!res.url && !res.uuid) continue;
        var item = this._cache[res.url];
        _sharedResources.push(item || res);
      }
      var queue = LoadingItems.create(this, progressCallback, (function(errors, items) {
        callInNextTick((function() {
          if (completeCallback) {
            if (singleRes) {
              var id = res.url;
              completeCallback.call(self, items.getError(id), items.getContent(id));
            } else completeCallback.call(self, errors, items);
            completeCallback = null;
          }
          var _id;
          false;
          items.destroy();
        }));
      }));
      LoadingItems.initQueueDeps(queue);
      queue.append(_sharedResources);
      _sharedResources.length = 0;
    };
    proto.flowInDeps = function(owner, urlList, callback) {
      _sharedList.length = 0;
      for (var i = 0; i < urlList.length; ++i) {
        var res = getResWithUrl(urlList[i]);
        if (!res.url && !res.uuid) continue;
        var item = this._cache[res.url];
        item ? _sharedList.push(item) : _sharedList.push(res);
      }
      var queue = LoadingItems.create(this, owner ? function(completedCount, totalCount, item) {
        this._ownerQueue && this._ownerQueue.onProgress && this._ownerQueue._childOnProgress(item);
      } : null, (function(errors, items) {
        callback(errors, items);
        owner && owner.deps && (owner.deps.length = 0);
        items.destroy();
      }));
      if (owner) {
        var ownerQueue = LoadingItems.getQueue(owner);
        queue._ownerQueue = ownerQueue._ownerQueue || ownerQueue;
      }
      var accepted = queue.append(_sharedList, owner);
      _sharedList.length = 0;
      return accepted;
    };
    proto._resources = resources;
    proto._getResUuid = function(url, type, quiet) {
      if (!url) return null;
      var index = url.indexOf("?");
      -1 !== index && (url = url.substr(0, index));
      var uuid = resources.getUuid(url, type);
      if (!uuid) {
        var extname = cc.path.extname(url);
        if (extname) {
          url = url.slice(0, -extname.length);
          uuid = resources.getUuid(url, type);
          uuid && !quiet && cc.warnID(4901, url, extname);
        }
      }
      return uuid;
    };
    proto._getReferenceKey = function(assetOrUrlOrUuid) {
      var key;
      "object" === typeof assetOrUrlOrUuid ? key = assetOrUrlOrUuid._uuid || null : "string" === typeof assetOrUrlOrUuid && (key = this._getResUuid(assetOrUrlOrUuid, null, true) || assetOrUrlOrUuid);
      if (!key) {
        cc.warnID(4800, assetOrUrlOrUuid);
        return key;
      }
      cc.AssetLibrary._getAssetInfoInRuntime(key, _info);
      return this._cache[_info.url] ? _info.url : key;
    };
    proto._urlNotFound = function(url, type, completeCallback) {
      callInNextTick((function() {
        url = cc.url.normalize(url);
        var info = (type ? js.getClassName(type) : "Asset") + ' in "resources/' + url + '" does not exist.';
        completeCallback && completeCallback(new Error(info), []);
      }));
    };
    proto._parseLoadResArgs = function(type, onProgress, onComplete) {
      if (void 0 === onComplete) {
        var isValidType = js.isChildClassOf(type, cc.RawAsset);
        if (onProgress) {
          onComplete = onProgress;
          isValidType && (onProgress = this.onProgress || null);
        } else if (void 0 === onProgress && !isValidType) {
          onComplete = type;
          onProgress = this.onProgress || null;
          type = null;
        }
        if (void 0 !== onProgress && !isValidType) {
          onProgress = type;
          type = null;
        }
      }
      return {
        type: type,
        onProgress: onProgress,
        onComplete: onComplete
      };
    };
    proto.loadRes = function(url, type, progressCallback, completeCallback) {
      var args = this._parseLoadResArgs(type, progressCallback, completeCallback);
      type = args.type;
      progressCallback = args.onProgress;
      completeCallback = args.onComplete;
      var self = this;
      var uuid = self._getResUuid(url, type);
      uuid ? this.load({
        type: "uuid",
        uuid: uuid
      }, progressCallback, (function(err, asset) {
        asset && self.setAutoReleaseRecursively(uuid, false);
        completeCallback && completeCallback(err, asset);
      })) : self._urlNotFound(url, type, completeCallback);
    };
    proto._loadResUuids = function(uuids, progressCallback, completeCallback, urls) {
      if (uuids.length > 0) {
        var self = this;
        var res = uuids.map((function(uuid) {
          return {
            type: "uuid",
            uuid: uuid
          };
        }));
        this.load(res, progressCallback, (function(errors, items) {
          if (completeCallback) {
            var assetRes = [];
            var urlRes = urls && [];
            for (var i = 0; i < res.length; ++i) {
              var uuid = res[i].uuid;
              var id = this._getReferenceKey(uuid);
              var item = items.getContent(id);
              if (item) {
                self.setAutoReleaseRecursively(uuid, false);
                assetRes.push(item);
                urlRes && urlRes.push(urls[i]);
              }
            }
            urls ? completeCallback(errors, assetRes, urlRes) : completeCallback(errors, assetRes);
          }
        }));
      } else completeCallback && callInNextTick((function() {
        urls ? completeCallback(null, [], []) : completeCallback(null, []);
      }));
    };
    proto.loadResArray = function(urls, type, progressCallback, completeCallback) {
      var args = this._parseLoadResArgs(type, progressCallback, completeCallback);
      type = args.type;
      progressCallback = args.onProgress;
      completeCallback = args.onComplete;
      var uuids = [];
      for (var i = 0; i < urls.length; i++) {
        var url = urls[i];
        var uuid = this._getResUuid(url, type);
        if (!uuid) {
          this._urlNotFound(url, type, completeCallback);
          return;
        }
        uuids.push(uuid);
      }
      this._loadResUuids(uuids, progressCallback, completeCallback);
    };
    proto.loadResDir = function(url, type, progressCallback, completeCallback) {
      var args = this._parseLoadResArgs(type, progressCallback, completeCallback);
      type = args.type;
      progressCallback = args.onProgress;
      completeCallback = args.onComplete;
      var urls = [];
      var uuids = resources.getUuidArray(url, type, urls);
      this._loadResUuids(uuids, progressCallback, (function(errors, assetRes, urlRes) {
        var assetResLength = assetRes.length;
        for (var i = 0; i < assetResLength; ++i) if (assetRes[i] instanceof cc.SpriteAtlas) {
          var spriteFrames = assetRes[i].getSpriteFrames();
          for (var k in spriteFrames) {
            var sf = spriteFrames[k];
            assetRes.push(sf);
            urlRes && urlRes.push(urlRes[i] + "/" + sf.name);
          }
        }
        completeCallback && completeCallback(errors, assetRes, urlRes);
      }), urls);
    };
    proto.getRes = function(url, type) {
      var item = this._cache[url];
      if (!item) {
        var uuid = this._getResUuid(url, type, true);
        if (!uuid) return null;
        var ref = this._getReferenceKey(uuid);
        item = this._cache[ref];
      }
      item && item.alias && (item = item.alias);
      return item && item.complete ? item.content : null;
    };
    proto.getResCount = function() {
      return Object.keys(this._cache).length;
    };
    proto.getDependsRecursively = function(owner) {
      if (owner) {
        var key = this._getReferenceKey(owner);
        var assets = AutoReleaseUtils.getDependsRecursively(key);
        assets.push(key);
        return assets;
      }
      return [];
    };
    proto.release = function(asset) {
      if (Array.isArray(asset)) for (var i = 0; i < asset.length; i++) {
        var key = asset[i];
        this.release(key);
      } else if (asset) {
        var id = this._getReferenceKey(asset);
        var item = this.getItem(id);
        if (item) {
          var removed = this.removeItem(id);
          asset = item.content;
          if (asset instanceof cc.Asset) {
            var nativeUrl = asset.nativeUrl;
            nativeUrl && this.release(nativeUrl);
            asset.destroy();
          }
          (true, removed) && this._releasedAssetChecker_DEBUG.setReleased(item, id);
        }
      }
    };
    proto.releaseAsset = function(asset) {
      var uuid = asset._uuid;
      uuid && this.release(uuid);
    };
    proto.releaseRes = function(url, type) {
      var uuid = this._getResUuid(url, type);
      uuid ? this.release(uuid) : cc.errorID(4914, url);
    };
    proto.releaseResDir = function(url, type) {
      var uuids = resources.getUuidArray(url, type);
      for (var i = 0; i < uuids.length; i++) {
        var uuid = uuids[i];
        this.release(uuid);
      }
    };
    proto.releaseAll = function() {
      for (var id in this._cache) this.release(id);
    };
    proto.removeItem = function(key) {
      var removed = Pipeline.prototype.removeItem.call(this, key);
      delete this._autoReleaseSetting[key];
      return removed;
    };
    proto.setAutoRelease = function(assetOrUrlOrUuid, autoRelease) {
      var key = this._getReferenceKey(assetOrUrlOrUuid);
      !!key && (this._autoReleaseSetting[key] = !!autoRelease);
    };
    proto.setAutoReleaseRecursively = function(assetOrUrlOrUuid, autoRelease) {
      autoRelease = !!autoRelease;
      var key = this._getReferenceKey(assetOrUrlOrUuid);
      if (key) {
        this._autoReleaseSetting[key] = autoRelease;
        var depends = AutoReleaseUtils.getDependsRecursively(key);
        for (var i = 0; i < depends.length; i++) {
          var depend = depends[i];
          this._autoReleaseSetting[depend] = autoRelease;
        }
      } else false;
    };
    proto.isAutoRelease = function(assetOrUrl) {
      var key = this._getReferenceKey(assetOrUrl);
      if (key) return !!this._autoReleaseSetting[key];
      return false;
    };
    cc.loader = new CCLoader();
    false;
    module.exports = cc.loader;
  }), {
    "../platform/js": 167,
    "../platform/utils": 171,
    "./asset-loader": 101,
    "./asset-table": 102,
    "./auto-release-utils": 104,
    "./downloader": 106,
    "./loader": 108,
    "./loading-items": 109,
    "./pipeline": 112,
    "./released-asset-checker": 113
  } ],
  101: [ (function(require, module, exports) {
    require("../utils/CCPath");
    var debug = require("../CCDebug");
    var Pipeline = require("./pipeline");
    var LoadingItems = require("./loading-items");
    var ID = "AssetLoader";
    var AssetLoader = function(extMap) {
      this.id = ID;
      this.async = true;
      this.pipeline = null;
    };
    AssetLoader.ID = ID;
    var reusedArray = [];
    AssetLoader.prototype.handle = function(item, callback) {
      var uuid = item.uuid;
      if (!uuid) return item.content || null;
      var self = this;
      cc.AssetLibrary.queryAssetInfo(uuid, (function(error, url, isRawAsset) {
        if (error) callback(error); else {
          item.url = item.rawUrl = url;
          item.isRawAsset = isRawAsset;
          if (isRawAsset) {
            var ext = cc.path.extname(url).toLowerCase();
            if (!ext) {
              callback(new Error(debug.getError(4931, uuid, url)));
              return;
            }
            ext = ext.substr(1);
            var queue = LoadingItems.getQueue(item);
            reusedArray[0] = {
              queueId: item.queueId,
              id: url,
              url: url,
              type: ext,
              error: null,
              alias: item,
              complete: true
            };
            false;
            queue.append(reusedArray);
            item.type = ext;
            callback(null, item.content);
          } else {
            item.type = "uuid";
            callback(null, item.content);
          }
        }
      }));
    };
    Pipeline.AssetLoader = module.exports = AssetLoader;
  }), {
    "../CCDebug": 22,
    "../utils/CCPath": 199,
    "./loading-items": 109,
    "./pipeline": 112
  } ],
  102: [ (function(require, module, exports) {
    var pushToMap = require("../utils/misc").pushToMap;
    var js = require("../platform/js");
    function Entry(uuid, type) {
      this.uuid = uuid;
      this.type = type;
    }
    function AssetTable() {
      this._pathToUuid = js.createMap(true);
    }
    function isMatchByWord(path, test) {
      if (path.length > test.length) {
        var nextAscii = path.charCodeAt(test.length);
        return 46 === nextAscii || 47 === nextAscii;
      }
      return true;
    }
    var proto = AssetTable.prototype;
    proto.getUuid = function(path, type) {
      path = cc.url.normalize(path);
      var item = this._pathToUuid[path];
      if (item) if (Array.isArray(item)) {
        if (!type) return item[0].uuid;
        for (var i = 0; i < item.length; i++) {
          var entry = item[i];
          if (js.isChildClassOf(entry.type, type)) return entry.uuid;
        }
        if (true, js.isChildClassOf(type, cc.SpriteFrame)) for (var _i = 0; _i < item.length; _i++) {
          var _entry = item[_i];
          if (js.isChildClassOf(_entry.type, cc.SpriteAtlas)) {
            cc.errorID(4932, path);
            break;
          }
        }
      } else {
        if (!type || js.isChildClassOf(item.type, type)) return item.uuid;
        (true, js.isChildClassOf(type, cc.SpriteFrame)) && js.isChildClassOf(item.type, cc.SpriteAtlas) && cc.errorID(4932, path);
      }
      return "";
    };
    proto.getUuidArray = function(path, type, out_urls) {
      path = cc.url.normalize(path);
      "/" === path[path.length - 1] && (path = path.slice(0, -1));
      var path2uuid = this._pathToUuid;
      var uuids = [];
      var isChildClassOf = js.isChildClassOf;
      var _foundAtlasUrl;
      for (var p in path2uuid) if (p.startsWith(path) && isMatchByWord(p, path) || !path) {
        var item = path2uuid[p];
        if (Array.isArray(item)) for (var i = 0; i < item.length; i++) {
          var entry = item[i];
          if (!type || isChildClassOf(entry.type, type)) {
            uuids.push(entry.uuid);
            out_urls && out_urls.push(p);
          } else (true, entry.type === cc.SpriteAtlas) && (_foundAtlasUrl = p);
        } else if (!type || isChildClassOf(item.type, type)) {
          uuids.push(item.uuid);
          out_urls && out_urls.push(p);
        } else (true, item.type === cc.SpriteAtlas) && (_foundAtlasUrl = p);
      }
      (true, 0 === uuids.length) && _foundAtlasUrl && js.isChildClassOf(type, cc.SpriteFrame) && cc.errorID(4932, _foundAtlasUrl);
      return uuids;
    };
    proto.add = function(path, uuid, type, isMainAsset) {
      path = path.substring(0, path.length - cc.path.extname(path).length);
      var newEntry = new Entry(uuid, type);
      pushToMap(this._pathToUuid, path, newEntry, isMainAsset);
    };
    proto._getInfo_DEBUG = (true, function(uuid, out_info) {
      var path2uuid = this._pathToUuid;
      var paths = Object.keys(path2uuid);
      for (var p = 0; p < paths.length; ++p) {
        var path = paths[p];
        var item = path2uuid[path];
        if (Array.isArray(item)) for (var i = 0; i < item.length; i++) {
          var entry = item[i];
          if (entry.uuid === uuid) {
            out_info.path = path;
            out_info.type = entry.type;
            return true;
          }
        } else if (item.uuid === uuid) {
          out_info.path = path;
          out_info.type = item.type;
          return true;
        }
      }
      return false;
    });
    proto.reset = function() {
      this._pathToUuid = js.createMap(true);
    };
    module.exports = AssetTable;
  }), {
    "../platform/js": 167,
    "../utils/misc": 208
  } ],
  103: [ (function(require, module, exports) {
    var sys = require("../platform/CCSys");
    var debug = require("../CCDebug");
    var __audioSupport = sys.__audioSupport;
    var formatSupport = __audioSupport.format;
    var context = __audioSupport.context;
    function loadDomAudio(item, callback) {
      var dom = document.createElement("audio");
      dom.src = item.url;
      true;
      callback(null, dom);
      return;
      var clearEvent;
      var timer;
      var success;
      var failure;
    }
    function loadWebAudio(item, callback) {
      context || callback(new Error(debug.getError(4926)));
      var request = cc.loader.getXMLHttpRequest();
      request.open("GET", item.url, true);
      request.responseType = "arraybuffer";
      request.onload = function() {
        context["decodeAudioData"](request.response, (function(buffer) {
          callback(null, buffer);
        }), (function() {
          callback("decode error - " + item.id, null);
        }));
      };
      request.onerror = function() {
        callback("request error - " + item.id, null);
      };
      request.send();
    }
    function downloadAudio(item, callback) {
      if (0 === formatSupport.length) return new Error(debug.getError(4927));
      var loader;
      if (__audioSupport.WEB_AUDIO) {
        var loadByDeserializedAudio = item._owner instanceof cc.AudioClip;
        loader = loadByDeserializedAudio ? item._owner.loadMode === cc.AudioClip.LoadMode.WEB_AUDIO ? loadWebAudio : loadDomAudio : item.urlParam && item.urlParam["useDom"] ? loadDomAudio : loadWebAudio;
      } else loader = loadDomAudio;
      loader(item, callback);
    }
    module.exports = downloadAudio;
  }), {
    "../CCDebug": 22,
    "../platform/CCSys": 156
  } ],
  104: [ (function(require, module, exports) {
    var js = require("../platform/js");
    function parseDepends(key, parsed) {
      var item = cc.loader.getItem(key);
      if (item) {
        var depends = item.dependKeys;
        if (depends) for (var i = 0; i < depends.length; i++) {
          var depend = depends[i];
          if (!parsed[depend]) {
            parsed[depend] = true;
            parseDepends(depend, parsed);
          }
        }
      }
    }
    function visitAsset(asset, excludeMap) {
      if (!asset._uuid) return;
      var key = cc.loader._getReferenceKey(asset);
      if (!excludeMap[key]) {
        excludeMap[key] = true;
        parseDepends(key, excludeMap);
      }
    }
    function visitComponent(comp, excludeMap) {
      var props = Object.getOwnPropertyNames(comp);
      for (var i = 0; i < props.length; i++) {
        var value = comp[props[i]];
        if ("object" === typeof value && value) if (Array.isArray(value)) for (var j = 0; j < value.length; j++) {
          var val = value[j];
          val instanceof cc.RawAsset && visitAsset(val, excludeMap);
        } else if (value.constructor && value.constructor !== Object) value instanceof cc.RawAsset && visitAsset(value, excludeMap); else {
          var keys = Object.getOwnPropertyNames(value);
          for (var _j = 0; _j < keys.length; _j++) {
            var _val = value[keys[_j]];
            _val instanceof cc.RawAsset && visitAsset(_val, excludeMap);
          }
        }
      }
    }
    function visitNode(node, excludeMap) {
      for (var i = 0; i < node._components.length; i++) visitComponent(node._components[i], excludeMap);
      for (var _i = 0; _i < node._children.length; _i++) visitNode(node._children[_i], excludeMap);
    }
    module.exports = {
      autoRelease: function(oldSceneAssets, nextSceneAssets, persistNodes) {
        var releaseSettings = cc.loader._autoReleaseSetting;
        var excludeMap = js.createMap();
        if (nextSceneAssets) for (var i = 0; i < nextSceneAssets.length; i++) excludeMap[nextSceneAssets[i]] = true;
        for (var _i2 = 0; _i2 < persistNodes.length; _i2++) visitNode(persistNodes[_i2], excludeMap);
        if (oldSceneAssets) for (var _i3 = 0; _i3 < oldSceneAssets.length; _i3++) {
          var key = oldSceneAssets[_i3];
          false === releaseSettings[key] || excludeMap[key] || cc.loader.release(key);
        }
        var keys = Object.keys(releaseSettings);
        for (var _i4 = 0; _i4 < keys.length; _i4++) {
          var _key = keys[_i4];
          true !== releaseSettings[_key] || excludeMap[_key] || cc.loader.release(_key);
        }
      },
      getDependsRecursively: function(key) {
        var depends = {};
        parseDepends(key, depends);
        return Object.keys(depends);
      }
    };
  }), {
    "../platform/js": 167
  } ],
  105: [ (function(require, module, exports) {
    false;
    {
      function downloadBinary(item, callback) {
        var url = item.url;
        var self = this;
        var xhr = cc.loader.getXMLHttpRequest(), errInfo = "Load binary data failed: " + url;
        xhr.open("GET", url, true);
        xhr.responseType = "arraybuffer";
        xhr.onload = function() {
          var arrayBuffer = xhr.response;
          if (arrayBuffer) {
            var result = new Uint8Array(arrayBuffer);
            callback(null, result);
          } else callback({
            status: xhr.status,
            errorMessage: errInfo + "(no response)"
          });
        };
        xhr.onerror = function() {
          callback({
            status: xhr.status,
            errorMessage: errInfo + "(error)"
          });
        };
        xhr.ontimeout = function() {
          callback({
            status: xhr.status,
            errorMessage: errInfo + "(time out)"
          });
        };
        xhr.send(null);
      }
      module.exports = downloadBinary;
    }
  }), {} ],
  106: [ (function(require, module, exports) {
    var js = require("../platform/js");
    var sys = require("../platform/CCSys");
    var debug = require("../CCDebug");
    require("../utils/CCPath");
    var Pipeline = require("./pipeline");
    var PackDownloader = require("./pack-downloader");
    var downloadBinary = require("./binary-downloader");
    var downloadText = require("./text-downloader");
    var urlAppendTimestamp = require("./utils").urlAppendTimestamp;
    var downloadAudio;
    true;
    downloadAudio = require("./audio-downloader");
    function downloadScript(item, callback, isAsync) {
      var url = item.url, d = document, s = document.createElement("script");
      s.async = isAsync;
      s.src = urlAppendTimestamp(url);
      function loadHandler() {
        s.parentNode.removeChild(s);
        s.removeEventListener("load", loadHandler, false);
        s.removeEventListener("error", errorHandler, false);
        callback(null, url);
      }
      function errorHandler() {
        s.parentNode.removeChild(s);
        s.removeEventListener("load", loadHandler, false);
        s.removeEventListener("error", errorHandler, false);
        callback(new Error(debug.getError(4928, url)));
      }
      s.addEventListener("load", loadHandler, false);
      s.addEventListener("error", errorHandler, false);
      d.body.appendChild(s);
    }
    function downloadWebp(item, callback, isCrossOrigin, img) {
      if (!cc.sys.capabilities.webp) return new Error(debug.getError(4929, item.url));
      return downloadImage(item, callback, isCrossOrigin, img);
    }
    function downloadImage(item, callback, isCrossOrigin, img) {
      void 0 === isCrossOrigin && (isCrossOrigin = true);
      var url = urlAppendTimestamp(item.url);
      img = img || new Image();
      isCrossOrigin && "file:" !== window.location.protocol ? img.crossOrigin = "anonymous" : img.crossOrigin = null;
      if (img.complete && img.naturalWidth > 0 && img.src === url) return img;
      (function() {
        function loadCallback() {
          img.removeEventListener("load", loadCallback);
          img.removeEventListener("error", errorCallback);
          img.id = item.id;
          callback(null, img);
        }
        function errorCallback() {
          img.removeEventListener("load", loadCallback);
          img.removeEventListener("error", errorCallback);
          "https:" !== window.location.protocol && img.crossOrigin && "anonymous" === img.crossOrigin.toLowerCase() ? downloadImage(item, callback, false, img) : callback(new Error(debug.getError(4930, url)));
        }
        img.addEventListener("load", loadCallback);
        img.addEventListener("error", errorCallback);
        img.src = url;
      })();
    }
    var FONT_TYPE = {
      ".eot": "embedded-opentype",
      ".ttf": "truetype",
      ".ttc": "truetype",
      ".woff": "woff",
      ".svg": "svg"
    };
    function _loadFont(name, srcs, type) {
      var doc = document, fontStyle = document.createElement("style");
      fontStyle.type = "text/css";
      doc.body.appendChild(fontStyle);
      var fontStr = "";
      isNaN(name - 0) ? fontStr += "@font-face { font-family:" + name + "; src:" : fontStr += "@font-face { font-family:'" + name + "'; src:";
      if (srcs instanceof Array) for (var i = 0, li = srcs.length; i < li; i++) {
        var src = srcs[i];
        type = cc.path.extname(src).toLowerCase();
        fontStr += "url('" + srcs[i] + "') format('" + FONT_TYPE[type] + "')";
        fontStr += i === li - 1 ? ";" : ",";
      } else {
        type = type.toLowerCase();
        fontStr += "url('" + srcs + "') format('" + FONT_TYPE[type] + "');";
      }
      fontStyle.textContent += fontStr + "}";
      var preloadDiv = document.createElement("div");
      var _divStyle = preloadDiv.style;
      _divStyle.fontFamily = name;
      preloadDiv.innerHTML = ".";
      _divStyle.position = "absolute";
      _divStyle.left = "-100px";
      _divStyle.top = "-100px";
      doc.body.appendChild(preloadDiv);
    }
    function downloadFont(item, callback) {
      var url = item.url, type = item.type, name = item.name, srcs = item.srcs;
      if (name && srcs) {
        -1 === srcs.indexOf(url) && srcs.push(url);
        _loadFont(name, srcs);
      } else {
        type = cc.path.extname(url);
        name = cc.path.basename(url, type);
        _loadFont(name, url, type);
      }
      if (!document.fonts) return null;
      document.fonts.load("1em " + name).then((function() {
        callback(null, null);
      }), (function(err) {
        callback(err);
      }));
    }
    function downloadUuid(item, callback) {
      var result = PackDownloader.load(item, callback);
      if (void 0 === result) return this.extMap["json"](item, callback);
      return result || void 0;
    }
    var defaultMap = {
      js: downloadScript,
      png: downloadImage,
      jpg: downloadImage,
      bmp: downloadImage,
      jpeg: downloadImage,
      gif: downloadImage,
      ico: downloadImage,
      tiff: downloadImage,
      webp: downloadWebp,
      image: downloadImage,
      mp3: downloadAudio,
      ogg: downloadAudio,
      wav: downloadAudio,
      m4a: downloadAudio,
      txt: downloadText,
      xml: downloadText,
      vsh: downloadText,
      fsh: downloadText,
      atlas: downloadText,
      tmx: downloadText,
      tsx: downloadText,
      json: downloadText,
      ExportJson: downloadText,
      plist: downloadText,
      fnt: downloadText,
      font: downloadFont,
      eot: downloadFont,
      ttf: downloadFont,
      woff: downloadFont,
      svg: downloadFont,
      ttc: downloadFont,
      uuid: downloadUuid,
      binary: downloadBinary,
      default: downloadText
    };
    var ID = "Downloader";
    var Downloader = function(extMap) {
      this.id = ID;
      this.async = true;
      this.pipeline = null;
      this._curConcurrent = 0;
      this._loadQueue = [];
      this._subpackages = {};
      this.extMap = js.mixin(extMap, defaultMap);
    };
    Downloader.ID = ID;
    Downloader.PackDownloader = PackDownloader;
    Downloader.prototype.addHandlers = function(extMap) {
      js.mixin(this.extMap, extMap);
    };
    Downloader.prototype._handleLoadQueue = function() {
      while (this._curConcurrent < cc.macro.DOWNLOAD_MAX_CONCURRENT) {
        var nextOne = this._loadQueue.shift();
        if (!nextOne) break;
        var syncRet = this.handle(nextOne.item, nextOne.callback);
        void 0 !== syncRet && (syncRet instanceof Error ? nextOne.callback(syncRet) : nextOne.callback(null, syncRet));
      }
    };
    Downloader.prototype.handle = function(item, callback) {
      var self = this;
      var downloadFunc = this.extMap[item.type] || this.extMap["default"];
      var syncRet = void 0;
      if (this._curConcurrent < cc.macro.DOWNLOAD_MAX_CONCURRENT) {
        this._curConcurrent++;
        syncRet = downloadFunc.call(this, item, (function(err, result) {
          self._curConcurrent = Math.max(0, self._curConcurrent - 1);
          self._handleLoadQueue();
          callback && callback(err, result);
        }));
        if (void 0 !== syncRet) {
          this._curConcurrent = Math.max(0, this._curConcurrent - 1);
          this._handleLoadQueue();
          return syncRet;
        }
      } else if (item.ignoreMaxConcurrency) {
        syncRet = downloadFunc.call(this, item, callback);
        if (void 0 !== syncRet) return syncRet;
      } else this._loadQueue.push({
        item: item,
        callback: callback
      });
    };
    Downloader.prototype.loadSubpackage = function(name, completeCallback) {
      var pac = this._subpackages[name];
      pac ? pac.loaded ? completeCallback && completeCallback() : downloadScript({
        url: pac.path
      }, (function(err) {
        err || (pac.loaded = true);
        completeCallback && completeCallback(err);
      })) : completeCallback && completeCallback(new Error("Can't find subpackage " + name));
    };
    Pipeline.Downloader = module.exports = Downloader;
  }), {
    "../CCDebug": 22,
    "../platform/CCSys": 156,
    "../platform/js": 167,
    "../utils/CCPath": 199,
    "./audio-downloader": 103,
    "./binary-downloader": 105,
    "./pack-downloader": 111,
    "./pipeline": 112,
    "./text-downloader": 114,
    "./utils": 116
  } ],
  107: [ (function(require, module, exports) {
    require("./downloader");
    require("./loader");
    require("./loading-items");
    require("./pipeline");
    require("./CCLoader");
  }), {
    "./CCLoader": 100,
    "./downloader": 106,
    "./loader": 108,
    "./loading-items": 109,
    "./pipeline": 112
  } ],
  108: [ (function(require, module, exports) {
    var js = require("../platform/js");
    var plistParser = require("../platform/CCSAXParser").plistParser;
    var Pipeline = require("./pipeline");
    var Texture2D = require("../assets/CCTexture2D");
    var loadUuid = require("./uuid-loader");
    function loadNothing() {
      return null;
    }
    function loadJSON(item) {
      if ("string" !== typeof item.content) return new Error("JSON Loader: Input item doesn't contain string content");
      try {
        var result = JSON.parse(item.content);
        return result;
      } catch (e) {
        return new Error("JSON Loader: Parse json [" + item.id + "] failed : " + e);
      }
    }
    function loadImage(item) {
      var loadByDeserializedAsset = item._owner instanceof cc.Asset;
      if (loadByDeserializedAsset) return null;
      var image = item.content;
      false;
      var rawUrl = item.rawUrl;
      var tex = item.texture || new Texture2D();
      tex._uuid = item.uuid;
      tex.url = rawUrl;
      tex._setRawAsset(rawUrl, false);
      tex._nativeAsset = image;
      return tex;
    }
    function loadAudioAsAsset(item, callback) {
      var loadByDeserializedAsset = item._owner instanceof cc.Asset;
      if (loadByDeserializedAsset) return null;
      var audioClip = new cc.AudioClip();
      audioClip._setRawAsset(item.rawUrl, false);
      audioClip._nativeAsset = item.content;
      return audioClip;
    }
    function loadPlist(item) {
      if ("string" !== typeof item.content) return new Error("Plist Loader: Input item doesn't contain string content");
      var result = plistParser.parse(item.content);
      return result || new Error("Plist Loader: Parse [" + item.id + "] failed");
    }
    function loadBinary(item) {
      return item.load ? item.load(item.content) : null;
    }
    var defaultMap = {
      png: loadImage,
      jpg: loadImage,
      bmp: loadImage,
      jpeg: loadImage,
      gif: loadImage,
      ico: loadImage,
      tiff: loadImage,
      webp: loadImage,
      image: loadImage,
      mp3: loadAudioAsAsset,
      ogg: loadAudioAsAsset,
      wav: loadAudioAsAsset,
      m4a: loadAudioAsAsset,
      json: loadJSON,
      ExportJson: loadJSON,
      plist: loadPlist,
      uuid: loadUuid,
      prefab: loadUuid,
      fire: loadUuid,
      scene: loadUuid,
      binary: loadBinary,
      default: loadNothing
    };
    var ID = "Loader";
    var Loader = function(extMap) {
      this.id = ID;
      this.async = true;
      this.pipeline = null;
      this.extMap = js.mixin(extMap, defaultMap);
    };
    Loader.ID = ID;
    Loader.prototype.addHandlers = function(extMap) {
      this.extMap = js.mixin(this.extMap, extMap);
    };
    Loader.prototype.handle = function(item, callback) {
      var loadFunc = this.extMap[item.type] || this.extMap["default"];
      return loadFunc.call(this, item, callback);
    };
    Pipeline.Loader = module.exports = Loader;
  }), {
    "../assets/CCTexture2D": 43,
    "../platform/CCSAXParser": 154,
    "../platform/js": 167,
    "./pipeline": 112,
    "./uuid-loader": 117
  } ],
  109: [ (function(require, module, exports) {
    var CallbacksInvoker = require("../platform/callbacks-invoker");
    require("../utils/CCPath");
    var js = require("../platform/js");
    var _qid = 0 | 998 * Math.random();
    var _queues = js.createMap(true);
    var _pool = [];
    var _POOL_MAX_LENGTH = 10;
    var ItemState = {
      WORKING: 1,
      COMPLETE: 2,
      ERROR: 3
    };
    var _queueDeps = js.createMap(true);
    function isIdValid(id) {
      var realId = id.url || id;
      return "string" === typeof realId;
    }
    function _parseUrlParam(url) {
      if (!url) return;
      var split = url.split("?");
      if (!split || !split[0] || !split[1]) return;
      var urlParam = {};
      var queries = split[1].split("&");
      queries.forEach((function(item) {
        var itemSplit = item.split("=");
        urlParam[itemSplit[0]] = itemSplit[1];
      }));
      return urlParam;
    }
    function createItem(id, queueId) {
      var url = "object" === typeof id ? id.url : id;
      var result = {
        queueId: queueId,
        id: url,
        url: url,
        rawUrl: void 0,
        urlParam: _parseUrlParam(url),
        type: "",
        error: null,
        content: null,
        complete: false,
        states: {},
        deps: null
      };
      if ("object" === typeof id) {
        js.mixin(result, id);
        if (id.skips) for (var i = 0; i < id.skips.length; i++) {
          var skip = id.skips[i];
          result.states[skip] = ItemState.COMPLETE;
        }
      }
      result.rawUrl = result.url;
      url && !result.type && (result.type = cc.path.extname(url).toLowerCase().substr(1));
      return result;
    }
    var checkedIds = [];
    function checkCircleReference(owner, item, recursiveCall) {
      if (!owner || !item) return false;
      var result = false;
      checkedIds.push(item.id);
      if (item.deps) {
        var i, deps = item.deps, subDep;
        for (i = 0; i < deps.length; i++) {
          subDep = deps[i];
          if (subDep.id === owner.id) {
            result = true;
            break;
          }
          if (checkedIds.indexOf(subDep.id) >= 0) continue;
          if (subDep.deps && checkCircleReference(owner, subDep, true)) {
            result = true;
            break;
          }
        }
      }
      recursiveCall || (checkedIds.length = 0);
      return result;
    }
    var LoadingItems = function(pipeline, urlList, onProgress, onComplete) {
      CallbacksInvoker.call(this);
      this._id = ++_qid;
      _queues[this._id] = this;
      this._pipeline = pipeline;
      this._errorUrls = [];
      this._appending = false;
      this._ownerQueue = null;
      this.onProgress = onProgress;
      this.onComplete = onComplete;
      this.map = js.createMap(true);
      this.completed = {};
      this.totalCount = 0;
      this.completedCount = 0;
      this._pipeline ? this.active = true : this.active = false;
      urlList && (urlList.length > 0 ? this.append(urlList) : this.allComplete());
    };
    LoadingItems.ItemState = new cc.Enum(ItemState);
    LoadingItems.create = function(pipeline, urlList, onProgress, onComplete) {
      if (void 0 === onProgress) {
        if ("function" === typeof urlList) {
          onComplete = urlList;
          urlList = onProgress = null;
        }
      } else if (void 0 === onComplete) if ("function" === typeof urlList) {
        onComplete = onProgress;
        onProgress = urlList;
        urlList = null;
      } else {
        onComplete = onProgress;
        onProgress = null;
      }
      var queue = _pool.pop();
      if (queue) {
        queue._pipeline = pipeline;
        queue.onProgress = onProgress;
        queue.onComplete = onComplete;
        _queues[queue._id] = queue;
        queue._pipeline && (queue.active = true);
        urlList && queue.append(urlList);
      } else queue = new LoadingItems(pipeline, urlList, onProgress, onComplete);
      return queue;
    };
    LoadingItems.getQueue = function(item) {
      return item.queueId ? _queues[item.queueId] : null;
    };
    LoadingItems.itemComplete = function(item) {
      var queue = _queues[item.queueId];
      queue && queue.itemComplete(item.id);
    };
    LoadingItems.initQueueDeps = function(queue) {
      var dep = _queueDeps[queue._id];
      if (dep) {
        dep.completed.length = 0;
        dep.deps.length = 0;
      } else dep = _queueDeps[queue._id] = {
        completed: [],
        deps: []
      };
    };
    LoadingItems.registerQueueDep = function(owner, depId) {
      var queueId = owner.queueId || owner;
      if (!queueId) return false;
      var queueDepList = _queueDeps[queueId];
      if (queueDepList) -1 === queueDepList.deps.indexOf(depId) && queueDepList.deps.push(depId); else if (owner.id) for (var id in _queueDeps) {
        var queue = _queueDeps[id];
        -1 !== queue.deps.indexOf(owner.id) && -1 === queue.deps.indexOf(depId) && queue.deps.push(depId);
      }
    };
    LoadingItems.finishDep = function(depId) {
      for (var id in _queueDeps) {
        var queue = _queueDeps[id];
        -1 !== queue.deps.indexOf(depId) && -1 === queue.completed.indexOf(depId) && queue.completed.push(depId);
      }
    };
    var proto = LoadingItems.prototype;
    js.mixin(proto, CallbacksInvoker.prototype);
    proto.append = function(urlList, owner) {
      if (!this.active) return [];
      owner && !owner.deps && (owner.deps = []);
      this._appending = true;
      var accepted = [], i, url, item;
      for (i = 0; i < urlList.length; ++i) {
        url = urlList[i];
        if (url.queueId && !this.map[url.id]) {
          this.map[url.id] = url;
          owner && owner.deps.push(url);
          if (url.complete || checkCircleReference(owner, url)) {
            this.totalCount++;
            this.itemComplete(url.id);
            continue;
          }
          var self = this;
          var queue = _queues[url.queueId];
          if (queue) {
            this.totalCount++;
            LoadingItems.registerQueueDep(owner || this._id, url.id);
            queue.addListener(url.id, (function(item) {
              self.itemComplete(item.id);
            }));
          }
          continue;
        }
        if (isIdValid(url)) {
          item = createItem(url, this._id);
          var key = item.id;
          if (!this.map[key]) {
            this.map[key] = item;
            this.totalCount++;
            owner && owner.deps.push(item);
            LoadingItems.registerQueueDep(owner || this._id, key);
            accepted.push(item);
          }
        }
      }
      this._appending = false;
      this.completedCount === this.totalCount ? this.allComplete() : this._pipeline.flowIn(accepted);
      return accepted;
    };
    proto._childOnProgress = function(item) {
      if (this.onProgress) {
        var dep = _queueDeps[this._id];
        this.onProgress(dep ? dep.completed.length : this.completedCount, dep ? dep.deps.length : this.totalCount, item);
      }
    };
    proto.allComplete = function() {
      var errors = 0 === this._errorUrls.length ? null : this._errorUrls;
      this.onComplete && this.onComplete(errors, this);
    };
    proto.isCompleted = function() {
      return this.completedCount >= this.totalCount;
    };
    proto.isItemCompleted = function(id) {
      return !!this.completed[id];
    };
    proto.exists = function(id) {
      return !!this.map[id];
    };
    proto.getContent = function(id) {
      var item = this.map[id];
      var ret = null;
      item && (item.content ? ret = item.content : item.alias && (ret = item.alias.content));
      return ret;
    };
    proto.getError = function(id) {
      var item = this.map[id];
      var ret = null;
      item && (item.error ? ret = item.error : item.alias && (ret = item.alias.error));
      return ret;
    };
    proto.addListener = CallbacksInvoker.prototype.add;
    proto.hasListener = CallbacksInvoker.prototype.has;
    proto.removeListener = CallbacksInvoker.prototype.remove;
    proto.removeAllListeners = CallbacksInvoker.prototype.removeAll;
    proto.removeItem = function(url) {
      var item = this.map[url];
      if (!item) return;
      if (!this.completed[item.alias || url]) return;
      delete this.completed[url];
      delete this.map[url];
      if (item.alias) {
        delete this.completed[item.alias.id];
        delete this.map[item.alias.id];
      }
      this.completedCount--;
      this.totalCount--;
    };
    proto.itemComplete = function(id) {
      var item = this.map[id];
      if (!item) return;
      var errorListId = this._errorUrls.indexOf(id);
      item.error && -1 === errorListId ? this._errorUrls.push(id) : item.error || -1 === errorListId || this._errorUrls.splice(errorListId, 1);
      this.completed[id] = item;
      this.completedCount++;
      LoadingItems.finishDep(item.id);
      if (this.onProgress) {
        var dep = _queueDeps[this._id];
        this.onProgress(dep ? dep.completed.length : this.completedCount, dep ? dep.deps.length : this.totalCount, item);
      }
      this.invoke(id, item);
      this.removeAll(id);
      !this._appending && this.completedCount >= this.totalCount && this.allComplete();
    };
    proto.destroy = function() {
      this.active = false;
      this._appending = false;
      this._pipeline = null;
      this._ownerQueue = null;
      this._errorUrls.length = 0;
      this.onProgress = null;
      this.onComplete = null;
      this.map = js.createMap(true);
      this.completed = {};
      this.totalCount = 0;
      this.completedCount = 0;
      CallbacksInvoker.call(this);
      _queues[this._id] = null;
      if (_queueDeps[this._id]) {
        _queueDeps[this._id].completed.length = 0;
        _queueDeps[this._id].deps.length = 0;
      }
      -1 === _pool.indexOf(this) && _pool.length < _POOL_MAX_LENGTH && _pool.push(this);
    };
    cc.LoadingItems = module.exports = LoadingItems;
  }), {
    "../platform/callbacks-invoker": 160,
    "../platform/js": 167,
    "../utils/CCPath": 199
  } ],
  110: [ (function(require, module, exports) {
    var Pipeline = require("./pipeline");
    var ID = "MD5Pipe";
    var ExtnameRegex = /(\.[^.\n\\/]*)$/;
    var UuidRegex = /.*[/\\][0-9a-fA-F]{2}[/\\]([0-9a-fA-F-]{8,})/;
    function getUuidFromURL(url) {
      var matches = url.match(UuidRegex);
      if (matches) return matches[1];
      return "";
    }
    var MD5Pipe = function(md5AssetsMap, md5NativeAssetsMap, libraryBase) {
      this.id = ID;
      this.async = false;
      this.pipeline = null;
      this.md5AssetsMap = md5AssetsMap;
      this.md5NativeAssetsMap = md5NativeAssetsMap;
      this.libraryBase = libraryBase;
    };
    MD5Pipe.ID = ID;
    MD5Pipe.prototype.handle = function(item) {
      item.url = this.transformURL(item.url, false);
      return item;
    };
    MD5Pipe.prototype.transformURL = function(url, hashPatchInFolder) {
      var _this = this;
      var uuid = getUuidFromURL(url);
      if (uuid) {
        var isNativeAsset;
        var map;
        var dirname;
        var basename;
        var matched;
        (function() {
          isNativeAsset = !url.startsWith(_this.libraryBase);
          map = isNativeAsset ? _this.md5NativeAssetsMap : _this.md5AssetsMap;
          var hashValue = map[uuid];
          if (hashValue) if (hashPatchInFolder) {
            dirname = cc.path.dirname(url);
            basename = cc.path.basename(url);
            url = dirname + "." + hashValue + "/" + basename;
          } else {
            matched = false;
            url = url.replace(ExtnameRegex, (function(match, p1) {
              matched = true;
              return "." + hashValue + p1;
            }));
            matched || (url = url + "." + hashValue);
          }
        })();
      }
      return url;
    };
    Pipeline.MD5Pipe = module.exports = MD5Pipe;
  }), {
    "./pipeline": 112
  } ],
  111: [ (function(require, module, exports) {
    var Unpackers = require("./unpackers");
    var pushToMap = require("../utils/misc").pushToMap;
    var PackState = {
      Invalid: 0,
      Removed: 1,
      Downloading: 2,
      Loaded: 3
    };
    function UnpackerData() {
      this.unpacker = null;
      this.state = PackState.Invalid;
    }
    var uuidToPack = {};
    var packIndices = {};
    var globalUnpackers = {};
    function error(uuid, packUuid) {
      return new Error("Can not retrieve " + uuid + " from packer " + packUuid);
    }
    module.exports = {
      initPacks: function(packs) {
        packIndices = packs;
        for (var packUuid in packs) {
          var uuids = packs[packUuid];
          for (var i = 0; i < uuids.length; i++) {
            var uuid = uuids[i];
            var pushFront = 1 === uuids.length;
            pushToMap(uuidToPack, uuid, packUuid, pushFront);
          }
        }
      },
      _loadNewPack: function(uuid, packUuid, callback) {
        var self = this;
        var packUrl = cc.AssetLibrary.getLibUrlNoExt(packUuid) + ".json";
        cc.loader.load({
          url: packUrl,
          ignoreMaxConcurrency: true
        }, (function(err, packJson) {
          if (err) {
            cc.errorID(4916, uuid);
            return callback(err);
          }
          var res = self._doLoadNewPack(uuid, packUuid, packJson);
          res ? callback(null, res) : callback(error(uuid, packUuid));
        }));
      },
      _doPreload: function(packUuid, packJson) {
        var unpackerData = globalUnpackers[packUuid];
        if (!unpackerData) {
          unpackerData = globalUnpackers[packUuid] = new UnpackerData();
          unpackerData.state = PackState.Downloading;
        }
        if (unpackerData.state !== PackState.Loaded) {
          unpackerData.unpacker = new Unpackers.JsonUnpacker();
          unpackerData.unpacker.load(packIndices[packUuid], packJson);
          unpackerData.state = PackState.Loaded;
        }
      },
      _doLoadNewPack: function(uuid, packUuid, packedJson) {
        var unpackerData = globalUnpackers[packUuid];
        if (unpackerData.state !== PackState.Loaded) {
          "string" === typeof packedJson && (packedJson = JSON.parse(packedJson));
          Array.isArray(packedJson) ? unpackerData.unpacker = new Unpackers.JsonUnpacker() : packedJson.type === Unpackers.TextureUnpacker.ID && (unpackerData.unpacker = new Unpackers.TextureUnpacker());
          unpackerData.unpacker.load(packIndices[packUuid], packedJson);
          unpackerData.state = PackState.Loaded;
        }
        return unpackerData.unpacker.retrieve(uuid);
      },
      _selectLoadedPack: function(packUuids) {
        var existsPackState = PackState.Invalid;
        var existsPackUuid = "";
        for (var i = 0; i < packUuids.length; i++) {
          var packUuid = packUuids[i];
          var unpackerData = globalUnpackers[packUuid];
          if (unpackerData) {
            var state = unpackerData.state;
            if (state === PackState.Loaded) return packUuid;
            if (state > existsPackState) {
              existsPackState = state;
              existsPackUuid = packUuid;
            }
          }
        }
        return existsPackState !== PackState.Invalid ? existsPackUuid : packUuids[0];
      },
      load: function(item, callback) {
        var uuid = item.uuid;
        var packUuid = uuidToPack[uuid];
        if (!packUuid) return;
        Array.isArray(packUuid) && (packUuid = this._selectLoadedPack(packUuid));
        var unpackerData = globalUnpackers[packUuid];
        if (unpackerData && unpackerData.state === PackState.Loaded) {
          var json = unpackerData.unpacker.retrieve(uuid);
          return json || error(uuid, packUuid);
        }
        if (!unpackerData) {
          true;
          console.log("Create unpacker %s for %s", packUuid, uuid);
          unpackerData = globalUnpackers[packUuid] = new UnpackerData();
          unpackerData.state = PackState.Downloading;
        }
        this._loadNewPack(uuid, packUuid, callback);
        return null;
      }
    };
    false;
  }), {
    "../utils/misc": 208,
    "./unpackers": 115
  } ],
  112: [ (function(require, module, exports) {
    var js = require("../platform/js");
    var LoadingItems = require("./loading-items");
    var ItemState = LoadingItems.ItemState;
    function flow(pipe, item) {
      var pipeId = pipe.id;
      var itemState = item.states[pipeId];
      var next = pipe.next;
      var pipeline = pipe.pipeline;
      if (item.error || itemState === ItemState.WORKING || itemState === ItemState.ERROR) return;
      if (itemState === ItemState.COMPLETE) next ? flow(next, item) : pipeline.flowOut(item); else {
        item.states[pipeId] = ItemState.WORKING;
        var result = pipe.handle(item, (function(err, result) {
          if (err) {
            item.error = err;
            item.states[pipeId] = ItemState.ERROR;
            pipeline.flowOut(item);
          } else {
            result && (item.content = result);
            item.states[pipeId] = ItemState.COMPLETE;
            next ? flow(next, item) : pipeline.flowOut(item);
          }
        }));
        if (result instanceof Error) {
          item.error = result;
          item.states[pipeId] = ItemState.ERROR;
          pipeline.flowOut(item);
        } else if (void 0 !== result) {
          null !== result && (item.content = result);
          item.states[pipeId] = ItemState.COMPLETE;
          next ? flow(next, item) : pipeline.flowOut(item);
        }
      }
    }
    var Pipeline = function(pipes) {
      this._pipes = pipes;
      this._cache = js.createMap(true);
      for (var i = 0; i < pipes.length; ++i) {
        var pipe = pipes[i];
        if (!pipe.handle || !pipe.id) continue;
        pipe.pipeline = this;
        pipe.next = i < pipes.length - 1 ? pipes[i + 1] : null;
      }
    };
    Pipeline.ItemState = ItemState;
    var proto = Pipeline.prototype;
    proto.insertPipe = function(pipe, index) {
      if (!pipe.handle || !pipe.id || index > this._pipes.length) {
        cc.warnID(4921);
        return;
      }
      if (this._pipes.indexOf(pipe) > 0) {
        cc.warnID(4922);
        return;
      }
      pipe.pipeline = this;
      var nextPipe = null;
      index < this._pipes.length && (nextPipe = this._pipes[index]);
      var previousPipe = null;
      index > 0 && (previousPipe = this._pipes[index - 1]);
      previousPipe && (previousPipe.next = pipe);
      pipe.next = nextPipe;
      this._pipes.splice(index, 0, pipe);
    };
    proto.insertPipeAfter = function(refPipe, newPipe) {
      var index = this._pipes.indexOf(refPipe);
      if (index < 0) return;
      this.insertPipe(newPipe, index + 1);
    };
    proto.appendPipe = function(pipe) {
      if (!pipe.handle || !pipe.id) return;
      pipe.pipeline = this;
      pipe.next = null;
      this._pipes.length > 0 && (this._pipes[this._pipes.length - 1].next = pipe);
      this._pipes.push(pipe);
    };
    proto.flowIn = function(items) {
      var i, pipe = this._pipes[0], item;
      if (pipe) {
        for (i = 0; i < items.length; i++) {
          item = items[i];
          this._cache[item.id] = item;
        }
        for (i = 0; i < items.length; i++) {
          item = items[i];
          flow(pipe, item);
        }
      } else for (i = 0; i < items.length; i++) this.flowOut(items[i]);
    };
    proto.flowInDeps = function(owner, urlList, callback) {
      var deps = LoadingItems.create(this, (function(errors, items) {
        callback(errors, items);
        items.destroy();
      }));
      return deps.append(urlList, owner);
    };
    proto.flowOut = function(item) {
      item.error ? delete this._cache[item.id] : this._cache[item.id] || (this._cache[item.id] = item);
      item.complete = true;
      LoadingItems.itemComplete(item);
    };
    proto.copyItemStates = function(srcItem, dstItems) {
      if (!(dstItems instanceof Array)) {
        dstItems.states = srcItem.states;
        return;
      }
      for (var i = 0; i < dstItems.length; ++i) dstItems[i].states = srcItem.states;
    };
    proto.getItem = function(id) {
      var item = this._cache[id];
      if (!item) return item;
      item.alias && (item = item.alias);
      return item;
    };
    proto.removeItem = function(id) {
      var removed = this._cache[id];
      removed && removed.complete && delete this._cache[id];
      return removed;
    };
    proto.clear = function() {
      for (var id in this._cache) {
        var item = this._cache[id];
        delete this._cache[id];
        if (!item.complete) {
          item.error = new Error("Canceled manually");
          this.flowOut(item);
        }
      }
    };
    cc.Pipeline = module.exports = Pipeline;
  }), {
    "../platform/js": 167,
    "./loading-items": 109
  } ],
  113: [ (function(require, module, exports) {
    true;
    var js;
    var tmpInfo;
    (function() {
      js = require("../platform/js");
      function ReleasedAssetChecker() {
        this._releasedKeys = js.createMap(true);
        this._dirty = false;
      }
      ReleasedAssetChecker.prototype.setReleased = function(item, releasedKey) {
        this._releasedKeys[releasedKey] = true;
        this._dirty = true;
      };
      tmpInfo = null;
      function getItemDesc(item) {
        if (item.uuid) {
          tmpInfo || (tmpInfo = {
            path: "",
            type: null
          });
          if (cc.loader._resources._getInfo_DEBUG(item.uuid, tmpInfo)) {
            tmpInfo.path = "resources/" + tmpInfo.path;
            return '"' + tmpInfo.path + '" (type: ' + js.getClassName(tmpInfo.type) + ", uuid: " + item.uuid + ")";
          }
          return '"' + item.rawUrl + '" (' + item.uuid + ")";
        }
        return '"' + item.rawUrl + '"';
      }
      function doCheckCouldRelease(releasedKey, refOwnerItem, caches) {
        var loadedAgain = caches[releasedKey];
        loadedAgain || cc.log('"' + releasedKey + '" was released but maybe still referenced by ' + getItemDesc(refOwnerItem));
      }
      ReleasedAssetChecker.prototype.checkCouldRelease = function(caches) {
        if (!this._dirty) return;
        this._dirty = false;
        var released = this._releasedKeys;
        for (var id in caches) {
          var item = caches[id];
          item.alias && (item = item.alias);
          var depends = item.dependKeys;
          if (depends) for (var i = 0; i < depends.length; ++i) {
            var depend = depends[i];
            if (released[depend]) {
              doCheckCouldRelease(depend, item, caches);
              delete released[depend];
            }
          }
        }
        js.clear(released);
      };
      module.exports = ReleasedAssetChecker;
    })();
  }), {
    "../platform/js": 167
  } ],
  114: [ (function(require, module, exports) {
    false;
    var urlAppendTimestamp = require("./utils").urlAppendTimestamp;
    module.exports = function(item, callback) {
      var url = item.url;
      url = urlAppendTimestamp(url);
      var xhr = cc.loader.getXMLHttpRequest(), errInfo = "Load text file failed: " + url;
      xhr.open("GET", url, true);
      xhr.overrideMimeType && xhr.overrideMimeType("text/plain; charset=utf-8");
      xhr.onload = function() {
        4 === xhr.readyState ? 200 === xhr.status || 0 === xhr.status ? callback(null, xhr.responseText) : callback({
          status: xhr.status,
          errorMessage: errInfo + "(wrong status)"
        }) : callback({
          status: xhr.status,
          errorMessage: errInfo + "(wrong readyState)"
        });
      };
      xhr.onerror = function() {
        callback({
          status: xhr.status,
          errorMessage: errInfo + "(error)"
        });
      };
      xhr.ontimeout = function() {
        callback({
          status: xhr.status,
          errorMessage: errInfo + "(time out)"
        });
      };
      xhr.send(null);
    };
  }), {
    "./utils": 116
  } ],
  115: [ (function(require, module, exports) {
    var Texture2D = require("../assets/CCTexture2D");
    var js = require("../platform/js");
    function JsonUnpacker() {
      this.jsons = {};
    }
    JsonUnpacker.prototype.load = function(indices, packedJson) {
      packedJson.length !== indices.length && cc.errorID(4915);
      for (var i = 0; i < indices.length; i++) {
        var key = indices[i];
        var json = packedJson[i];
        this.jsons[key] = json;
      }
    };
    JsonUnpacker.prototype.retrieve = function(key) {
      return this.jsons[key] || null;
    };
    function TextureUnpacker() {
      this.contents = {};
    }
    TextureUnpacker.ID = js._getClassId(Texture2D);
    TextureUnpacker.prototype.load = function(indices, packedJson) {
      var datas = packedJson.data.split("|");
      datas.length !== indices.length && cc.errorID(4915);
      for (var i = 0; i < indices.length; i++) this.contents[indices[i]] = datas[i];
    };
    TextureUnpacker.prototype.retrieve = function(key) {
      var content = this.contents[key];
      return content ? {
        __type__: TextureUnpacker.ID,
        content: content
      } : null;
    };
    false;
    module.exports = {
      JsonUnpacker: JsonUnpacker,
      TextureUnpacker: TextureUnpacker
    };
  }), {
    "../assets/CCTexture2D": 43,
    "../platform/js": 167
  } ],
  116: [ (function(require, module, exports) {
    var _noCacheRex = /\?/;
    module.exports = {
      urlAppendTimestamp: function(url) {
        cc.game.config["noCache"] && "string" === typeof url && (_noCacheRex.test(url) ? url += "&_t=" + (new Date() - 0) : url += "?_t=" + (new Date() - 0));
        return url;
      }
    };
  }), {} ],
  117: [ (function(require, module, exports) {
    var js = require("../platform/js");
    var debug = require("../CCDebug");
    require("../platform/deserialize");
    var LoadingItems = require("./loading-items");
    function isSceneObj(json) {
      var SCENE_ID = "cc.Scene";
      var PREFAB_ID = "cc.Prefab";
      return json && (json[0] && json[0].__type__ === SCENE_ID || json[1] && json[1].__type__ === SCENE_ID || json[0] && json[0].__type__ === PREFAB_ID);
    }
    function parseDepends(item, asset, tdInfo, deferredLoadRawAssetsInRuntime) {
      var uuidList = tdInfo.uuidList;
      var objList = tdInfo.uuidObjList;
      var propList = tdInfo.uuidPropList;
      var stillUseUrl = tdInfo._stillUseUrl;
      var depends;
      var i, dependUuid;
      var dependKeys = item.dependKeys = [];
      if (deferredLoadRawAssetsInRuntime) {
        depends = [];
        for (i = 0; i < uuidList.length; i++) {
          dependUuid = uuidList[i];
          var obj = objList[i];
          var prop = propList[i];
          var info = cc.AssetLibrary._getAssetInfoInRuntime(dependUuid);
          if (info.raw) {
            var url = info.url;
            obj[prop] = url;
            dependKeys.push(url);
          } else depends.push({
            type: "uuid",
            uuid: dependUuid,
            deferredLoadRaw: true,
            _owner: obj,
            _ownerProp: prop,
            _stillUseUrl: stillUseUrl[i]
          });
        }
      } else {
        depends = new Array(uuidList.length);
        for (i = 0; i < uuidList.length; i++) {
          dependUuid = uuidList[i];
          depends[i] = {
            type: "uuid",
            uuid: dependUuid,
            _owner: objList[i],
            _ownerProp: propList[i],
            _stillUseUrl: stillUseUrl[i]
          };
        }
        asset._native && !asset.constructor.preventPreloadNativeObject && depends.push({
          url: asset.nativeUrl,
          _owner: asset,
          _ownerProp: "_nativeAsset"
        });
      }
      return depends;
    }
    function loadDepends(pipeline, item, asset, depends, callback) {
      item.content = asset;
      var dependKeys = item.dependKeys;
      pipeline.flowInDeps(item, depends, (function(errors, items) {
        var item, missingAssetReporter;
        var itemsMap = items.map;
        for (var src in itemsMap) {
          item = itemsMap[src];
          item.uuid && item.content && (item.content._uuid = item.uuid);
        }
        for (var i = 0; i < depends.length; i++) {
          var dep = depends[i];
          var dependSrc = dep.uuid;
          var dependUrl = dep.url;
          var dependObj = dep._owner;
          var dependProp = dep._ownerProp;
          item = itemsMap[dependUrl];
          if (!item) continue;
          var loadCallbackCtx = dep;
          function loadCallback(item) {
            var value = item.content;
            this._stillUseUrl && (value = value && cc.RawAsset.wasRawAssetType(value.constructor) ? value.nativeUrl : item.rawUrl);
            this._owner[this._ownerProp] = value;
            item.uuid !== asset._uuid && dependKeys.indexOf(item.id) < 0 && dependKeys.push(item.id);
          }
          if (item.complete || item.content) if (item.error) {
            var MissingObjectReporter;
            false;
            cc._throw(item.error);
          } else loadCallback.call(loadCallbackCtx, item); else {
            var queue = LoadingItems.getQueue(item);
            var list = queue._callbackTable[dependSrc];
            list ? list.unshift(loadCallback, loadCallbackCtx) : queue.addListener(dependSrc, loadCallback, loadCallbackCtx);
          }
        }
        false;
        callback(errors, asset);
      }));
    }
    function canDeferredLoad(asset, item, isScene) {
      false;
      var res = item.deferredLoadRaw;
      res ? asset instanceof cc.Asset && asset.constructor.preventDeferredLoadDependents && (res = false) : isScene && (asset instanceof cc.SceneAsset || asset instanceof cc.Prefab) && (res = asset.asyncLoadAssets);
      return res;
    }
    var MissingClass;
    function loadUuid(item, callback) {
      false;
      var json;
      if ("string" === typeof item.content) try {
        json = JSON.parse(item.content);
      } catch (e) {
        return new Error(debug.getError(4923, item.id, e.stack));
      } else {
        if ("object" !== typeof item.content) return new Error(debug.getError(4924));
        json = item.content;
      }
      var classFinder;
      var isScene = isSceneObj(json);
      if (isScene) {
        false;
        classFinder = cc._MissingScript.safeFindClass;
      } else classFinder = function(id) {
        var cls = js._getClassById(id);
        if (cls) return cls;
        cc.warnID(4903, id);
        return Object;
      };
      var tdInfo = cc.deserialize.Details.pool.get();
      var asset;
      try {
        asset = cc.deserialize(json, tdInfo, {
          classFinder: classFinder,
          target: item.existingAsset,
          customEnv: item
        });
      } catch (e) {
        cc.deserialize.Details.pool.put(tdInfo);
        var err = e.stack;
        return new Error(debug.getError(4925, item.id, err));
      }
      asset._uuid = item.uuid;
      false;
      var deferredLoad = canDeferredLoad(asset, item, isScene);
      var depends = parseDepends(item, asset, tdInfo, deferredLoad);
      cc.deserialize.Details.pool.put(tdInfo);
      if (0 === depends.length) return callback(null, asset);
      loadDepends(this.pipeline, item, asset, depends, callback);
    }
    module.exports = loadUuid;
    loadUuid.isSceneObj = isSceneObj;
  }), {
    "../CCDebug": 22,
    "../platform/deserialize": 162,
    "../platform/js": 167,
    "./loading-items": 109
  } ],
  118: [ (function(require, module, exports) {
    var CompScheduler = require("./component-scheduler");
    var Flags = require("./platform/CCObject").Flags;
    var js = require("./platform/js");
    var callerFunctor = false;
    var MAX_POOL_SIZE = 4;
    var IsPreloadStarted = Flags.IsPreloadStarted;
    var IsOnLoadStarted = Flags.IsOnLoadStarted;
    var IsOnLoadCalled = Flags.IsOnLoadCalled;
    var Deactivating = Flags.Deactivating;
    var callPreloadInTryCatch = false;
    var callOnLoadInTryCatch = false;
    var callOnDestroyInTryCatch = false;
    var callResetInTryCatch = false;
    var callOnFocusInTryCatch = false;
    var callOnLostFocusInTryCatch = false;
    var callPreload = function(c) {
      c.__preload();
    };
    var callOnLoad = function(c) {
      c.onLoad();
      c._objFlags |= IsOnLoadCalled;
    };
    var UnsortedInvoker = cc.Class({
      extends: CompScheduler.LifeCycleInvoker,
      add: function(comp) {
        this._zero.array.push(comp);
      },
      remove: function(comp) {
        this._zero.fastRemove(comp);
      },
      cancelInactive: function(flagToClear) {
        CompScheduler.LifeCycleInvoker.stableRemoveInactive(this._zero, flagToClear);
      },
      invoke: function() {
        this._invoke(this._zero);
        this._zero.array.length = 0;
      }
    });
    var invokePreload = CompScheduler.createInvokeImpl(callPreload);
    var invokeOnLoad = CompScheduler.createInvokeImpl(callOnLoad);
    var activateTasksPool = new js.Pool(MAX_POOL_SIZE);
    activateTasksPool.get = function getActivateTask() {
      var task = this._get() || {
        preload: new UnsortedInvoker(invokePreload),
        onLoad: new CompScheduler.OneOffInvoker(invokeOnLoad),
        onEnable: new CompScheduler.OneOffInvoker(CompScheduler.invokeOnEnable)
      };
      task.preload._zero.i = -1;
      var invoker = task.onLoad;
      invoker._zero.i = -1;
      invoker._neg.i = -1;
      invoker._pos.i = -1;
      invoker = task.onEnable;
      invoker._zero.i = -1;
      invoker._neg.i = -1;
      invoker._pos.i = -1;
      return task;
    };
    function _componentCorrupted(node, comp, index) {
      false;
      comp ? node._removeComponent(comp) : js.array.removeAt(node._components, index);
    }
    function _onLoadInEditor(comp) {
      if (comp.onLoad && !cc.engine._isPlaying) {
        var focused = Editor.Selection.curActivate("node") === comp.node.uuid;
        focused ? comp.onFocusInEditor && callOnFocusInTryCatch(comp) : comp.onLostFocusInEditor && callOnLostFocusInTryCatch(comp);
      }
      true;
      _Scene.AssetsWatcher.start(comp);
    }
    function ctor() {
      this._activatingStack = [];
    }
    var NodeActivator = cc.Class({
      ctor: ctor,
      reset: ctor,
      _activateNodeRecursively: function(node, preloadInvoker, onLoadInvoker, onEnableInvoker) {
        if (node._objFlags & Deactivating) {
          cc.errorID(3816, node.name);
          return;
        }
        node._activeInHierarchy = true;
        var originCount = node._components.length;
        for (var i = 0; i < originCount; ++i) {
          var component = node._components[i];
          if (component instanceof cc.Component) this.activateComp(component, preloadInvoker, onLoadInvoker, onEnableInvoker); else {
            _componentCorrupted(node, component, i);
            --i;
            --originCount;
          }
        }
        for (var _i = 0, len = node._children.length; _i < len; ++_i) {
          var child = node._children[_i];
          child._active && this._activateNodeRecursively(child, preloadInvoker, onLoadInvoker, onEnableInvoker);
        }
        node._onPostActivated(true);
      },
      _deactivateNodeRecursively: function(node) {
        false;
        node._objFlags |= Deactivating;
        node._activeInHierarchy = false;
        var originCount = node._components.length;
        for (var c = 0; c < originCount; ++c) {
          var component = node._components[c];
          if (component._enabled) {
            cc.director._compScheduler.disableComp(component);
            if (node._activeInHierarchy) {
              node._objFlags &= ~Deactivating;
              return;
            }
          }
        }
        for (var i = 0, len = node._children.length; i < len; ++i) {
          var child = node._children[i];
          if (child._activeInHierarchy) {
            this._deactivateNodeRecursively(child);
            if (node._activeInHierarchy) {
              node._objFlags &= ~Deactivating;
              return;
            }
          }
        }
        node._onPostActivated(false);
        node._objFlags &= ~Deactivating;
      },
      activateNode: function(node, active) {
        if (active) {
          var task = activateTasksPool.get();
          this._activatingStack.push(task);
          this._activateNodeRecursively(node, task.preload, task.onLoad, task.onEnable);
          task.preload.invoke();
          task.onLoad.invoke();
          task.onEnable.invoke();
          this._activatingStack.pop();
          activateTasksPool.put(task);
        } else {
          this._deactivateNodeRecursively(node);
          var stack = this._activatingStack;
          for (var i = 0; i < stack.length; i++) {
            var lastTask = stack[i];
            lastTask.preload.cancelInactive(IsPreloadStarted);
            lastTask.onLoad.cancelInactive(IsOnLoadStarted);
            lastTask.onEnable.cancelInactive();
          }
        }
        node.emit("active-in-hierarchy-changed", node);
      },
      activateComp: function(comp, preloadInvoker, onLoadInvoker, onEnableInvoker) {
        if (!(comp._objFlags & IsPreloadStarted)) {
          comp._objFlags |= IsPreloadStarted;
          comp.__preload && (preloadInvoker ? preloadInvoker.add(comp) : comp.__preload());
        }
        if (!(comp._objFlags & IsOnLoadStarted)) {
          comp._objFlags |= IsOnLoadStarted;
          if (comp.onLoad) if (onLoadInvoker) onLoadInvoker.add(comp); else {
            comp.onLoad();
            comp._objFlags |= IsOnLoadCalled;
          } else comp._objFlags |= IsOnLoadCalled;
        }
        if (comp._enabled) {
          var deactivatedOnLoading = !comp.node._activeInHierarchy;
          if (deactivatedOnLoading) return;
          cc.director._compScheduler.enableComp(comp, onEnableInvoker);
        }
      },
      destroyComp: function(comp) {
        cc.director._compScheduler.disableComp(comp);
        comp.onDestroy && comp._objFlags & IsOnLoadCalled && comp.onDestroy();
      },
      resetComp: false
    });
    module.exports = NodeActivator;
  }), {
    "./component-scheduler": 54,
    "./platform/CCObject": 153,
    "./platform/js": 167,
    "./utils/misc": 208
  } ],
  119: [ (function(require, module, exports) {
    var PTM_RATIO = require("./CCPhysicsTypes").PTM_RATIO;
    var ContactType = require("./CCPhysicsTypes").ContactType;
    var pools = [];
    var pointCache = [ cc.v2(), cc.v2() ];
    var b2worldmanifold = new b2.WorldManifold();
    var worldmanifold = {
      points: [],
      separations: [],
      normal: cc.v2()
    };
    function ManifoldPoint() {
      this.localPoint = cc.v2();
      this.normalImpulse = 0;
      this.tangentImpulse = 0;
    }
    var manifoldPointCache = [ new ManifoldPoint(), new ManifoldPoint() ];
    var b2manifold = new b2.Manifold();
    var manifold = {
      type: 0,
      localPoint: cc.v2(),
      localNormal: cc.v2(),
      points: []
    };
    var impulse = {
      normalImpulses: [],
      tangentImpulses: []
    };
    function PhysicsContact() {}
    PhysicsContact.prototype.init = function(b2contact) {
      this.colliderA = b2contact.GetFixtureA().collider;
      this.colliderB = b2contact.GetFixtureB().collider;
      this.disabled = false;
      this.disabledOnce = false;
      this._impulse = null;
      this._inverted = false;
      this._b2contact = b2contact;
      b2contact._contact = this;
    };
    PhysicsContact.prototype.reset = function() {
      this.setTangentSpeed(0);
      this.resetFriction();
      this.resetRestitution();
      this.colliderA = null;
      this.colliderB = null;
      this.disabled = false;
      this._impulse = null;
      this._b2contact._contact = null;
      this._b2contact = null;
    };
    PhysicsContact.prototype.getWorldManifold = function() {
      var points = worldmanifold.points;
      var separations = worldmanifold.separations;
      var normal = worldmanifold.normal;
      this._b2contact.GetWorldManifold(b2worldmanifold);
      var b2points = b2worldmanifold.points;
      var b2separations = b2worldmanifold.separations;
      var count = this._b2contact.GetManifold().pointCount;
      points.length = separations.length = count;
      for (var i = 0; i < count; i++) {
        var p = pointCache[i];
        p.x = b2points[i].x * PTM_RATIO;
        p.y = b2points[i].y * PTM_RATIO;
        points[i] = p;
        separations[i] = b2separations[i] * PTM_RATIO;
      }
      normal.x = b2worldmanifold.normal.x;
      normal.y = b2worldmanifold.normal.y;
      if (this._inverted) {
        normal.x *= -1;
        normal.y *= -1;
      }
      return worldmanifold;
    };
    PhysicsContact.prototype.getManifold = function() {
      var points = manifold.points;
      var localNormal = manifold.localNormal;
      var localPoint = manifold.localPoint;
      var b2manifold = this._b2contact.GetManifold();
      var b2points = b2manifold.points;
      var count = points.length = b2manifold.pointCount;
      for (var i = 0; i < count; i++) {
        var p = manifoldPointCache[i];
        var b2p = b2points[i];
        p.localPoint.x = b2p.localPoint.x * PTM_RATIO;
        p.localPoint.Y = b2p.localPoint.Y * PTM_RATIO;
        p.normalImpulse = b2p.normalImpulse * PTM_RATIO;
        p.tangentImpulse = b2p.tangentImpulse;
        points[i] = p;
      }
      localPoint.x = b2manifold.localPoint.x * PTM_RATIO;
      localPoint.y = b2manifold.localPoint.y * PTM_RATIO;
      localNormal.x = b2manifold.localNormal.x;
      localNormal.y = b2manifold.localNormal.y;
      manifold.type = b2manifold.type;
      if (this._inverted) {
        localNormal.x *= -1;
        localNormal.y *= -1;
      }
      return manifold;
    };
    PhysicsContact.prototype.getImpulse = function() {
      var b2impulse = this._impulse;
      if (!b2impulse) return null;
      var normalImpulses = impulse.normalImpulses;
      var tangentImpulses = impulse.tangentImpulses;
      var count = b2impulse.count;
      for (var i = 0; i < count; i++) {
        normalImpulses[i] = b2impulse.normalImpulses[i] * PTM_RATIO;
        tangentImpulses[i] = b2impulse.tangentImpulses[i];
      }
      tangentImpulses.length = normalImpulses.length = count;
      return impulse;
    };
    PhysicsContact.prototype.emit = function(contactType) {
      var func;
      switch (contactType) {
       case ContactType.BEGIN_CONTACT:
        func = "onBeginContact";
        break;

       case ContactType.END_CONTACT:
        func = "onEndContact";
        break;

       case ContactType.PRE_SOLVE:
        func = "onPreSolve";
        break;

       case ContactType.POST_SOLVE:
        func = "onPostSolve";
      }
      var colliderA = this.colliderA;
      var colliderB = this.colliderB;
      var bodyA = colliderA.body;
      var bodyB = colliderB.body;
      var comps;
      var i, l, comp;
      if (bodyA.enabledContactListener) {
        comps = bodyA.node._components;
        this._inverted = false;
        for (i = 0, l = comps.length; i < l; i++) {
          comp = comps[i];
          comp[func] && comp[func](this, colliderA, colliderB);
        }
      }
      if (bodyB.enabledContactListener) {
        comps = bodyB.node._components;
        this._inverted = true;
        for (i = 0, l = comps.length; i < l; i++) {
          comp = comps[i];
          comp[func] && comp[func](this, colliderB, colliderA);
        }
      }
      if (this.disabled || this.disabledOnce) {
        this.setEnabled(false);
        this.disabledOnce = false;
      }
    };
    PhysicsContact.get = function(b2contact) {
      var c;
      c = 0 === pools.length ? new cc.PhysicsContact() : pools.pop();
      c.init(b2contact);
      return c;
    };
    PhysicsContact.put = function(b2contact) {
      var c = b2contact._contact;
      if (!c) return;
      pools.push(c);
      c.reset();
    };
    var _p = PhysicsContact.prototype;
    _p.setEnabled = function(value) {
      this._b2contact.SetEnabled(value);
    };
    _p.isTouching = function() {
      return this._b2contact.IsTouching();
    };
    _p.setTangentSpeed = function(value) {
      this._b2contact.SetTangentSpeed(value / PTM_RATIO);
    };
    _p.getTangentSpeed = function() {
      return this._b2contact.GetTangentSpeed() * PTM_RATIO;
    };
    _p.setFriction = function(value) {
      this._b2contact.SetFriction(value);
    };
    _p.getFriction = function() {
      return this._b2contact.GetFriction();
    };
    _p.resetFriction = function() {
      return this._b2contact.ResetFriction();
    };
    _p.setRestitution = function(value) {
      this._b2contact.SetRestitution(value);
    };
    _p.getRestitution = function() {
      return this._b2contact.GetRestitution();
    };
    _p.resetRestitution = function() {
      return this._b2contact.ResetRestitution();
    };
    PhysicsContact.ContactType = ContactType;
    cc.PhysicsContact = module.exports = PhysicsContact;
  }), {
    "./CCPhysicsTypes": 121
  } ],
  120: [ (function(require, module, exports) {
    var PhysicsTypes = require("./CCPhysicsTypes");
    var ContactType = PhysicsTypes.ContactType;
    var BodyType = PhysicsTypes.BodyType;
    var RayCastType = PhysicsTypes.RayCastType;
    var DrawBits = PhysicsTypes.DrawBits;
    var PTM_RATIO = PhysicsTypes.PTM_RATIO;
    var ANGLE_TO_PHYSICS_ANGLE = PhysicsTypes.ANGLE_TO_PHYSICS_ANGLE;
    var PHYSICS_ANGLE_TO_ANGLE = PhysicsTypes.PHYSICS_ANGLE_TO_ANGLE;
    var convertToNodeRotation = require("./utils").convertToNodeRotation;
    var DebugDraw = require("./platform/CCPhysicsDebugDraw");
    var b2_aabb_tmp = new b2.AABB();
    var b2_vec2_tmp1 = new b2.Vec2();
    var b2_vec2_tmp2 = new b2.Vec2();
    var vec2_tmp = cc.v2();
    var PhysicsManager = cc.Class({
      mixins: [ cc.EventTarget ],
      statics: {
        DrawBits: DrawBits,
        PTM_RATIO: PTM_RATIO,
        VELOCITY_ITERATIONS: 10,
        POSITION_ITERATIONS: 10,
        FIXED_TIME_STEP: 1 / 60,
        MAX_ACCUMULATOR: .2
      },
      ctor: function() {
        this._debugDrawFlags = 0;
        this._debugDrawer = null;
        this._world = null;
        this._bodies = [];
        this._joints = [];
        this._contactMap = {};
        this._contactID = 0;
        this._delayEvents = [];
        this._accumulator = 0;
        cc.director._scheduler && cc.director._scheduler.enableForTarget(this);
        this.enabledAccumulator = false;
      },
      pushDelayEvent: function(target, func, args) {
        this._steping ? this._delayEvents.push({
          target: target,
          func: func,
          args: args
        }) : target[func].apply(target, args);
      },
      update: function(dt) {
        var world = this._world;
        if (!world || !this.enabled) return;
        this.emit("before-step");
        this._steping = true;
        var velocityIterations = PhysicsManager.VELOCITY_ITERATIONS;
        var positionIterations = PhysicsManager.POSITION_ITERATIONS;
        if (this.enabledAccumulator) {
          this._accumulator += dt;
          var FIXED_TIME_STEP = PhysicsManager.FIXED_TIME_STEP;
          var MAX_ACCUMULATOR = PhysicsManager.MAX_ACCUMULATOR;
          this._accumulator > MAX_ACCUMULATOR && (this._accumulator = MAX_ACCUMULATOR);
          while (this._accumulator > FIXED_TIME_STEP) {
            world.Step(FIXED_TIME_STEP, velocityIterations, positionIterations);
            this._accumulator -= FIXED_TIME_STEP;
          }
        } else {
          var timeStep = 1 / cc.game.config["frameRate"];
          world.Step(timeStep, velocityIterations, positionIterations);
        }
        if (this.debugDrawFlags) {
          this._checkDebugDrawValid();
          this._debugDrawer.clear();
          world.DrawDebugData();
        }
        this._steping = false;
        var events = this._delayEvents;
        for (var i = 0, l = events.length; i < l; i++) {
          var event = events[i];
          event.target[event.func].apply(event.target, event.args);
        }
        events.length = 0;
        this._syncNode();
      },
      testPoint: function(point) {
        var x = b2_vec2_tmp1.x = point.x / PTM_RATIO;
        var y = b2_vec2_tmp1.y = point.y / PTM_RATIO;
        var d = .2 / PTM_RATIO;
        b2_aabb_tmp.lowerBound.x = x - d;
        b2_aabb_tmp.lowerBound.y = y - d;
        b2_aabb_tmp.upperBound.x = x + d;
        b2_aabb_tmp.upperBound.y = y + d;
        var callback = this._aabbQueryCallback;
        callback.init(b2_vec2_tmp1);
        this._world.QueryAABB(callback, b2_aabb_tmp);
        var fixture = callback.getFixture();
        if (fixture) return fixture.collider;
        return null;
      },
      testAABB: function(rect) {
        b2_aabb_tmp.lowerBound.x = rect.xMin / PTM_RATIO;
        b2_aabb_tmp.lowerBound.y = rect.yMin / PTM_RATIO;
        b2_aabb_tmp.upperBound.x = rect.xMax / PTM_RATIO;
        b2_aabb_tmp.upperBound.y = rect.yMax / PTM_RATIO;
        var callback = this._aabbQueryCallback;
        callback.init();
        this._world.QueryAABB(callback, b2_aabb_tmp);
        var fixtures = callback.getFixtures();
        var colliders = fixtures.map((function(fixture) {
          return fixture.collider;
        }));
        return colliders;
      },
      rayCast: function(p1, p2, type) {
        if (p1.equals(p2)) return [];
        type = type || RayCastType.Closest;
        b2_vec2_tmp1.x = p1.x / PTM_RATIO;
        b2_vec2_tmp1.y = p1.y / PTM_RATIO;
        b2_vec2_tmp2.x = p2.x / PTM_RATIO;
        b2_vec2_tmp2.y = p2.y / PTM_RATIO;
        var callback = this._raycastQueryCallback;
        callback.init(type);
        this._world.RayCast(callback, b2_vec2_tmp1, b2_vec2_tmp2);
        var fixtures = callback.getFixtures();
        if (fixtures.length > 0) {
          var points = callback.getPoints();
          var normals = callback.getNormals();
          var fractions = callback.getFractions();
          var results = [];
          for (var i = 0, l = fixtures.length; i < l; i++) {
            var fixture = fixtures[i];
            var collider = fixture.collider;
            if (type === RayCastType.AllClosest) {
              var result = results.find((function(result) {
                return result.collider === collider;
              }));
              if (result) {
                if (fractions[i] < result.fraction) {
                  result.fixtureIndex = collider._getFixtureIndex(fixture);
                  result.point.x = points[i].x * PTM_RATIO;
                  result.point.y = points[i].y * PTM_RATIO;
                  result.normal.x = normals[i].x;
                  result.normal.y = normals[i].y;
                  result.fraction = fractions[i];
                }
                continue;
              }
            }
            results.push({
              collider: collider,
              fixtureIndex: collider._getFixtureIndex(fixture),
              point: cc.v2(points[i].x * PTM_RATIO, points[i].y * PTM_RATIO),
              normal: cc.v2(normals[i]),
              fraction: fractions[i]
            });
          }
          return results;
        }
        return [];
      },
      syncPosition: function() {
        var bodies = this._bodies;
        for (var i = 0; i < bodies.length; i++) bodies[i].syncPosition();
      },
      syncRotation: function() {
        var bodies = this._bodies;
        for (var i = 0; i < bodies.length; i++) bodies[i].syncRotation();
      },
      _registerContactFixture: function(fixture) {
        this._contactListener.registerContactFixture(fixture);
      },
      _unregisterContactFixture: function(fixture) {
        this._contactListener.unregisterContactFixture(fixture);
      },
      _addBody: function(body, bodyDef) {
        var world = this._world;
        var node = body.node;
        if (!world || !node) return;
        body._b2Body = world.CreateBody(bodyDef);
        body._b2Body.body = body;
        this._bodies.push(body);
      },
      _removeBody: function(body) {
        var world = this._world;
        if (!world) return;
        body._b2Body.body = null;
        world.DestroyBody(body._b2Body);
        body._b2Body = null;
        cc.js.array.remove(this._bodies, body);
      },
      _addJoint: function(joint, jointDef) {
        var b2joint = this._world.CreateJoint(jointDef);
        if (!b2joint) return;
        b2joint._joint = joint;
        joint._joint = b2joint;
        this._joints.push(joint);
      },
      _removeJoint: function(joint) {
        joint._isValid() && this._world.DestroyJoint(joint._joint);
        joint._joint && (joint._joint._joint = null);
        cc.js.array.remove(this._joints, joint);
      },
      _initCallback: function() {
        if (!this._world) {
          cc.warn("Please init PhysicsManager first");
          return;
        }
        if (this._contactListener) return;
        var listener = new cc.PhysicsContactListener();
        listener.setBeginContact(this._onBeginContact);
        listener.setEndContact(this._onEndContact);
        listener.setPreSolve(this._onPreSolve);
        listener.setPostSolve(this._onPostSolve);
        this._world.SetContactListener(listener);
        this._contactListener = listener;
        this._aabbQueryCallback = new cc.PhysicsAABBQueryCallback();
        this._raycastQueryCallback = new cc.PhysicsRayCastCallback();
      },
      _init: function() {
        this.enabled = true;
        this.debugDrawFlags = DrawBits.e_shapeBit;
      },
      _getWorld: function() {
        return this._world;
      },
      _syncNode: function() {
        var bodies = this._bodies;
        for (var i = 0, l = bodies.length; i < l; i++) {
          var body = bodies[i];
          var node = body.node;
          var b2body = body._b2Body;
          var pos = b2body.GetPosition();
          vec2_tmp.x = pos.x * PTM_RATIO;
          vec2_tmp.y = pos.y * PTM_RATIO;
          var angle = b2body.GetAngle() * PHYSICS_ANGLE_TO_ANGLE;
          if (null !== node.parent.parent) {
            vec2_tmp = node.parent.convertToNodeSpaceAR(vec2_tmp);
            angle = convertToNodeRotation(node.parent, angle);
          }
          var tempMask = node._eventMask;
          node._eventMask = 0;
          node.position = vec2_tmp;
          node.rotation = angle;
          node._eventMask = tempMask;
          body.type === BodyType.Animated && body.resetVelocity();
        }
      },
      _onBeginContact: function(b2contact) {
        var c = cc.PhysicsContact.get(b2contact);
        c.emit(ContactType.BEGIN_CONTACT);
      },
      _onEndContact: function(b2contact) {
        var c = b2contact._contact;
        if (!c) return;
        c.emit(ContactType.END_CONTACT);
        cc.PhysicsContact.put(b2contact);
      },
      _onPreSolve: function(b2contact) {
        var c = b2contact._contact;
        if (!c) return;
        c.emit(ContactType.PRE_SOLVE);
      },
      _onPostSolve: function(b2contact, impulse) {
        var c = b2contact._contact;
        if (!c) return;
        c._impulse = impulse;
        c.emit(ContactType.POST_SOLVE);
        c._impulse = null;
      },
      _checkDebugDrawValid: function() {
        if (!this._debugDrawer || !this._debugDrawer.isValid) {
          var node = new cc.Node("PHYSICS_MANAGER_DEBUG_DRAW");
          node.zIndex = cc.macro.MAX_ZINDEX;
          cc.game.addPersistRootNode(node);
          this._debugDrawer = node.addComponent(cc.Graphics);
          var debugDraw = new DebugDraw(this._debugDrawer);
          debugDraw.SetFlags(this.debugDrawFlags);
          this._world.SetDebugDraw(debugDraw);
        }
      }
    });
    cc.js.getset(PhysicsManager.prototype, "enabled", (function() {
      return this._enabled;
    }), (function(value) {
      false;
      if (value && !this._world) {
        var world = new b2.World(new b2.Vec2(0, -10));
        world.SetAllowSleeping(true);
        this._world = world;
        this._initCallback();
      }
      this._enabled = value;
    }));
    cc.js.getset(PhysicsManager.prototype, "debugDrawFlags", (function() {
      return this._debugDrawFlags;
    }), (function(value) {
      false;
      value && !this._debugDrawFlags ? this._debugDrawer && this._debugDrawer.node && (this._debugDrawer.node.active = true) : !value && this._debugDrawFlags && this._debugDrawer && this._debugDrawer.node && (this._debugDrawer.node.active = false);
      if (value) {
        this._checkDebugDrawValid();
        this._world.m_debugDraw.SetFlags(value);
      }
      this._debugDrawFlags = value;
      if (value) {
        this._checkDebugDrawValid();
        this._world.m_debugDraw.SetFlags(value);
      }
    }));
    cc.js.getset(PhysicsManager.prototype, "gravity", (function() {
      if (this._world) {
        var g = this._world.GetGravity();
        return cc.v2(g.x * PTM_RATIO, g.y * PTM_RATIO);
      }
      return cc.v2();
    }), (function(value) {
      this._world && this._world.SetGravity(new b2.Vec2(value.x / PTM_RATIO, value.y / PTM_RATIO));
    }));
    cc.PhysicsManager = module.exports = PhysicsManager;
  }), {
    "./CCPhysicsTypes": 121,
    "./platform/CCPhysicsDebugDraw": 142,
    "./utils": 144
  } ],
  121: [ (function(require, module, exports) {
    var ContactType = {
      BEGIN_CONTACT: "begin-contact",
      END_CONTACT: "end-contact",
      PRE_SOLVE: "pre-solve",
      POST_SOLVE: "post-solve"
    };
    var BodyType = cc.Enum({
      Static: 0,
      Kinematic: 1,
      Dynamic: 2,
      Animated: 3
    });
    cc.RigidBodyType = BodyType;
    var RayCastType = cc.Enum({
      Closest: 0,
      Any: 1,
      AllClosest: 2,
      All: 3
    });
    cc.RayCastType = RayCastType;
    module.exports = {
      BodyType: BodyType,
      ContactType: ContactType,
      RayCastType: RayCastType,
      DrawBits: b2.DrawFlags,
      PTM_RATIO: 32,
      ANGLE_TO_PHYSICS_ANGLE: -Math.PI / 180,
      PHYSICS_ANGLE_TO_ANGLE: -180 / Math.PI
    };
  }), {} ],
  122: [ (function(require, module, exports) {
    function At(i, vertices) {
      var s = vertices.length;
      return vertices[i < 0 ? s - -i % s : i % s];
    }
    function Copy(i, j, vertices) {
      var p = [];
      while (j < i) j += vertices.length;
      for (;i <= j; ++i) p.push(At(i, vertices));
      return p;
    }
    function ConvexPartition(vertices) {
      ForceCounterClockWise(vertices);
      var list = [];
      var d, lowerDist, upperDist;
      var p;
      var lowerInt = cc.v2();
      var upperInt = cc.v2();
      var lowerIndex = 0, upperIndex = 0;
      var lowerPoly, upperPoly;
      for (var i = 0; i < vertices.length; ++i) if (Reflex(i, vertices)) {
        lowerDist = upperDist = 1e8;
        for (var j = 0; j < vertices.length; ++j) {
          if (Left(At(i - 1, vertices), At(i, vertices), At(j, vertices)) && RightOn(At(i - 1, vertices), At(i, vertices), At(j - 1, vertices))) {
            p = LineIntersect(At(i - 1, vertices), At(i, vertices), At(j, vertices), At(j - 1, vertices));
            if (Right(At(i + 1, vertices), At(i, vertices), p)) {
              d = SquareDist(At(i, vertices), p);
              if (d < lowerDist) {
                lowerDist = d;
                lowerInt = p;
                lowerIndex = j;
              }
            }
          }
          if (Left(At(i + 1, vertices), At(i, vertices), At(j + 1, vertices)) && RightOn(At(i + 1, vertices), At(i, vertices), At(j, vertices))) {
            p = LineIntersect(At(i + 1, vertices), At(i, vertices), At(j, vertices), At(j + 1, vertices));
            if (Left(At(i - 1, vertices), At(i, vertices), p)) {
              d = SquareDist(At(i, vertices), p);
              if (d < upperDist) {
                upperDist = d;
                upperIndex = j;
                upperInt = p;
              }
            }
          }
        }
        if (lowerIndex == (upperIndex + 1) % vertices.length) {
          var sp = lowerInt.add(upperInt).div(2);
          lowerPoly = Copy(i, upperIndex, vertices);
          lowerPoly.push(sp);
          upperPoly = Copy(lowerIndex, i, vertices);
          upperPoly.push(sp);
        } else {
          var highestScore = 0, bestIndex = lowerIndex;
          while (upperIndex < lowerIndex) upperIndex += vertices.length;
          for (var j = lowerIndex; j <= upperIndex; ++j) if (CanSee(i, j, vertices)) {
            var score = 1 / (SquareDist(At(i, vertices), At(j, vertices)) + 1);
            Reflex(j, vertices) ? RightOn(At(j - 1, vertices), At(j, vertices), At(i, vertices)) && LeftOn(At(j + 1, vertices), At(j, vertices), At(i, vertices)) ? score += 3 : score += 2 : score += 1;
            if (score > highestScore) {
              bestIndex = j;
              highestScore = score;
            }
          }
          lowerPoly = Copy(i, bestIndex, vertices);
          upperPoly = Copy(bestIndex, i, vertices);
        }
        list = list.concat(ConvexPartition(lowerPoly));
        list = list.concat(ConvexPartition(upperPoly));
        return list;
      }
      list.push(vertices);
      for (var i = list.length - 1; i >= 0; i--) 0 == list[i].length && list.splice(i, 0);
      return list;
    }
    function CanSee(i, j, vertices) {
      if (Reflex(i, vertices)) {
        if (LeftOn(At(i, vertices), At(i - 1, vertices), At(j, vertices)) && RightOn(At(i, vertices), At(i + 1, vertices), At(j, vertices))) return false;
      } else if (RightOn(At(i, vertices), At(i + 1, vertices), At(j, vertices)) || LeftOn(At(i, vertices), At(i - 1, vertices), At(j, vertices))) return false;
      if (Reflex(j, vertices)) {
        if (LeftOn(At(j, vertices), At(j - 1, vertices), At(i, vertices)) && RightOn(At(j, vertices), At(j + 1, vertices), At(i, vertices))) return false;
      } else if (RightOn(At(j, vertices), At(j + 1, vertices), At(i, vertices)) || LeftOn(At(j, vertices), At(j - 1, vertices), At(i, vertices))) return false;
      for (var k = 0; k < vertices.length; ++k) {
        if ((k + 1) % vertices.length == i || k == i || (k + 1) % vertices.length == j || k == j) continue;
        var intersectionPoint = cc.v2();
        if (LineIntersect2(At(i, vertices), At(j, vertices), At(k, vertices), At(k + 1, vertices), intersectionPoint)) return false;
      }
      return true;
    }
    function Reflex(i, vertices) {
      return Right(i, vertices);
    }
    function Right(a, b, c) {
      if ("undefined" === typeof c) {
        var i = a, vertices = b;
        a = At(i - 1, vertices);
        b = At(i, vertices);
        c = At(i + 1, vertices);
      }
      return Area(a, b, c) < 0;
    }
    function Left(a, b, c) {
      return Area(a, b, c) > 0;
    }
    function LeftOn(a, b, c) {
      return Area(a, b, c) >= 0;
    }
    function RightOn(a, b, c) {
      return Area(a, b, c) <= 0;
    }
    function SquareDist(a, b) {
      var dx = b.x - a.x;
      var dy = b.y - a.y;
      return dx * dx + dy * dy;
    }
    function ForceCounterClockWise(vertices) {
      IsCounterClockWise(vertices) || vertices.reverse();
    }
    function IsCounterClockWise(vertices) {
      if (vertices.length < 3) return true;
      return GetSignedArea(vertices) > 0;
    }
    function GetSignedArea(vertices) {
      var i;
      var area = 0;
      for (i = 0; i < vertices.length; i++) {
        var j = (i + 1) % vertices.length;
        area += vertices[i].x * vertices[j].y;
        area -= vertices[i].y * vertices[j].x;
      }
      area /= 2;
      return area;
    }
    function LineIntersect(p1, p2, q1, q2) {
      var i = cc.v2();
      var a1 = p2.y - p1.y;
      var b1 = p1.x - p2.x;
      var c1 = a1 * p1.x + b1 * p1.y;
      var a2 = q2.y - q1.y;
      var b2 = q1.x - q2.x;
      var c2 = a2 * q1.x + b2 * q1.y;
      var det = a1 * b2 - a2 * b1;
      if (!FloatEquals(det, 0)) {
        i.x = (b2 * c1 - b1 * c2) / det;
        i.y = (a1 * c2 - a2 * c1) / det;
      }
      return i;
    }
    function LineIntersect2(a0, a1, b0, b1, intersectionPoint) {
      if (a0 == b0 || a0 == b1 || a1 == b0 || a1 == b1) return false;
      var x1 = a0.x;
      var y1 = a0.y;
      var x2 = a1.x;
      var y2 = a1.y;
      var x3 = b0.x;
      var y3 = b0.y;
      var x4 = b1.x;
      var y4 = b1.y;
      if (Math.max(x1, x2) < Math.min(x3, x4) || Math.max(x3, x4) < Math.min(x1, x2)) return false;
      if (Math.max(y1, y2) < Math.min(y3, y4) || Math.max(y3, y4) < Math.min(y1, y2)) return false;
      var ua = (x4 - x3) * (y1 - y3) - (y4 - y3) * (x1 - x3);
      var ub = (x2 - x1) * (y1 - y3) - (y2 - y1) * (x1 - x3);
      var denom = (y4 - y3) * (x2 - x1) - (x4 - x3) * (y2 - y1);
      if (Math.abs(denom) < 1e-6) return false;
      ua /= denom;
      ub /= denom;
      if (0 < ua && ua < 1 && 0 < ub && ub < 1) {
        intersectionPoint.x = x1 + ua * (x2 - x1);
        intersectionPoint.y = y1 + ua * (y2 - y1);
        return true;
      }
      return false;
    }
    function FloatEquals(value1, value2) {
      return Math.abs(value1 - value2) <= 1e-6;
    }
    function Area(a, b, c) {
      return a.x * (b.y - c.y) + b.x * (c.y - a.y) + c.x * (a.y - b.y);
    }
    module.exports = {
      ConvexPartition: ConvexPartition,
      ForceCounterClockWise: ForceCounterClockWise,
      IsCounterClockWise: IsCounterClockWise
    };
  }), {} ],
  123: [ (function(require, module, exports) {
    var NodeEvent = require("../CCNode").EventType;
    var PTM_RATIO = require("./CCPhysicsTypes").PTM_RATIO;
    var ANGLE_TO_PHYSICS_ANGLE = require("./CCPhysicsTypes").ANGLE_TO_PHYSICS_ANGLE;
    var PHYSICS_ANGLE_TO_ANGLE = require("./CCPhysicsTypes").PHYSICS_ANGLE_TO_ANGLE;
    var getWorldRotation = require("./utils").getWorldRotation;
    var BodyType = require("./CCPhysicsTypes").BodyType;
    var tempb2Vec21 = new b2.Vec2();
    var tempb2Vec22 = new b2.Vec2();
    var VEC2_ZERO = cc.Vec2.ZERO;
    var RigidBody = cc.Class({
      name: "cc.RigidBody",
      extends: cc.Component,
      editor: false,
      properties: {
        _type: BodyType.Dynamic,
        _allowSleep: true,
        _gravityScale: 1,
        _linearDamping: 0,
        _angularDamping: 0,
        _linearVelocity: cc.v2(0, 0),
        _angularVelocity: 0,
        _fixedRotation: false,
        enabled: {
          get: function() {
            return this._enabled;
          },
          set: function() {
            cc.warnID(8200);
          },
          visible: false,
          override: true
        },
        enabledContactListener: {
          default: false,
          tooltip: false
        },
        bullet: {
          default: false,
          tooltip: false
        },
        type: {
          type: BodyType,
          tooltip: false,
          get: function() {
            return this._type;
          },
          set: function(value) {
            this._type = value;
            this._b2Body && (value === BodyType.Animated ? this._b2Body.SetType(BodyType.Kinematic) : this._b2Body.SetType(value));
          }
        },
        allowSleep: {
          tooltip: false,
          get: function() {
            if (this._b2Body) return this._b2Body.IsSleepingAllowed();
            return this._allowSleep;
          },
          set: function(value) {
            this._allowSleep = value;
            this._b2Body && this._b2Body.SetSleepingAllowed(value);
          }
        },
        gravityScale: {
          tooltip: false,
          get: function() {
            return this._gravityScale;
          },
          set: function(value) {
            this._gravityScale = value;
            this._b2Body && this._b2Body.SetGravityScale(value);
          }
        },
        linearDamping: {
          tooltip: false,
          get: function() {
            return this._linearDamping;
          },
          set: function(value) {
            this._linearDamping = value;
            this._b2Body && this._b2Body.SetLinearDamping(this._linearDamping);
          }
        },
        angularDamping: {
          tooltip: false,
          get: function() {
            return this._angularDamping;
          },
          set: function(value) {
            this._angularDamping = value;
            this._b2Body && this._b2Body.SetAngularDamping(value);
          }
        },
        linearVelocity: {
          tooltip: false,
          type: cc.Vec2,
          get: function() {
            var lv = this._linearVelocity;
            if (this._b2Body) {
              var velocity = this._b2Body.GetLinearVelocity();
              lv.x = velocity.x * PTM_RATIO;
              lv.y = velocity.y * PTM_RATIO;
            }
            return lv;
          },
          set: function(value) {
            this._linearVelocity = value;
            var b2body = this._b2Body;
            if (b2body) {
              var temp = b2body.m_linearVelocity;
              temp.Set(value.x / PTM_RATIO, value.y / PTM_RATIO);
              b2body.SetLinearVelocity(temp);
            }
          }
        },
        angularVelocity: {
          tooltip: false,
          get: function() {
            if (this._b2Body) return this._b2Body.GetAngularVelocity() * PHYSICS_ANGLE_TO_ANGLE;
            return this._angularVelocity;
          },
          set: function(value) {
            this._angularVelocity = value;
            this._b2Body && this._b2Body.SetAngularVelocity(value * ANGLE_TO_PHYSICS_ANGLE);
          }
        },
        fixedRotation: {
          tooltip: false,
          get: function() {
            return this._fixedRotation;
          },
          set: function(value) {
            this._fixedRotation = value;
            this._b2Body && this._b2Body.SetFixedRotation(value);
          }
        },
        awake: {
          tooltip: false,
          get: function() {
            return !!this._b2Body && this._b2Body.IsAwake();
          },
          set: function(value) {
            this._b2Body && this._b2Body.SetAwake(value);
          }
        },
        active: {
          visible: false,
          get: function() {
            return !!this._b2Body && this._b2Body.IsActive();
          },
          set: function(value) {
            this._b2Body && this._b2Body.SetActive(value);
          }
        }
      },
      getLocalPoint: function(worldPoint, out) {
        out = out || cc.v2();
        if (this._b2Body) {
          tempb2Vec21.Set(worldPoint.x / PTM_RATIO, worldPoint.y / PTM_RATIO);
          var pos = this._b2Body.GetLocalPoint(tempb2Vec21, out);
          out.x = pos.x * PTM_RATIO;
          out.y = pos.y * PTM_RATIO;
        }
        return out;
      },
      getWorldPoint: function(localPoint, out) {
        out = out || cc.v2();
        if (this._b2Body) {
          tempb2Vec21.Set(localPoint.x / PTM_RATIO, localPoint.y / PTM_RATIO);
          var pos = this._b2Body.GetWorldPoint(tempb2Vec21, out);
          out.x = pos.x * PTM_RATIO;
          out.y = pos.y * PTM_RATIO;
        }
        return out;
      },
      getWorldVector: function(localVector, out) {
        out = out || cc.v2();
        if (this._b2Body) {
          tempb2Vec21.Set(localVector.x / PTM_RATIO, localVector.y / PTM_RATIO);
          var vector = this._b2Body.GetWorldVector(tempb2Vec21, out);
          out.x = vector.x * PTM_RATIO;
          out.y = vector.y * PTM_RATIO;
        }
        return out;
      },
      getLocalVector: function(worldVector, out) {
        out = out || cc.v2();
        if (this._b2Body) {
          tempb2Vec21.Set(worldVector.x / PTM_RATIO, worldVector.y / PTM_RATIO);
          var vector = this._b2Body.GetLocalVector(tempb2Vec21, out);
          out.x = vector.x * PTM_RATIO;
          out.y = vector.y * PTM_RATIO;
        }
        return out;
      },
      getWorldPosition: function(out) {
        out = out || cc.v2();
        if (this._b2Body) {
          var pos = this._b2Body.GetPosition();
          out.x = pos.x * PTM_RATIO;
          out.y = pos.y * PTM_RATIO;
        }
        return out;
      },
      getWorldRotation: function() {
        if (this._b2Body) return this._b2Body.GetAngle() * PHYSICS_ANGLE_TO_ANGLE;
        return 0;
      },
      getLocalCenter: function(out) {
        out = out || cc.v2();
        if (this._b2Body) {
          var pos = this._b2Body.GetLocalCenter();
          out.x = pos.x * PTM_RATIO;
          out.y = pos.y * PTM_RATIO;
        }
        return out;
      },
      getWorldCenter: function(out) {
        out = out || cc.v2();
        if (this._b2Body) {
          var pos = this._b2Body.GetWorldCenter();
          out.x = pos.x * PTM_RATIO;
          out.y = pos.y * PTM_RATIO;
        }
        return out;
      },
      getLinearVelocityFromWorldPoint: function(worldPoint, out) {
        out = out || cc.v2();
        if (this._b2Body) {
          tempb2Vec21.Set(worldPoint.x / PTM_RATIO, worldPoint.y / PTM_RATIO);
          var velocity = this._b2Body.GetLinearVelocityFromWorldPoint(tempb2Vec21, out);
          out.x = velocity.x * PTM_RATIO;
          out.y = velocity.y * PTM_RATIO;
        }
        return out;
      },
      getMass: function() {
        return this._b2Body ? this._b2Body.GetMass() : 0;
      },
      getInertia: function() {
        return this._b2Body ? this._b2Body.GetInertia() * PTM_RATIO * PTM_RATIO : 0;
      },
      getJointList: function() {
        if (!this._b2Body) return [];
        var joints = [];
        var list = this._b2Body.GetJointList();
        if (!list) return [];
        joints.push(list.joint._joint);
        var prev = list.prev;
        while (prev) {
          joints.push(prev.joint._joint);
          prev = prev.prev;
        }
        var next = list.next;
        while (next) {
          joints.push(next.joint._joint);
          next = next.next;
        }
        return joints;
      },
      applyForce: function(force, point, wake) {
        if (this._b2Body) {
          tempb2Vec21.Set(force.x / PTM_RATIO, force.y / PTM_RATIO);
          tempb2Vec22.Set(point.x / PTM_RATIO, point.y / PTM_RATIO);
          this._b2Body.ApplyForce(tempb2Vec21, tempb2Vec22, wake);
        }
      },
      applyForceToCenter: function(force, wake) {
        if (this._b2Body) {
          tempb2Vec21.Set(force.x / PTM_RATIO, force.y / PTM_RATIO);
          this._b2Body.ApplyForceToCenter(tempb2Vec21, wake);
        }
      },
      applyTorque: function(torque, wake) {
        this._b2Body && this._b2Body.ApplyTorque(torque / PTM_RATIO, wake);
      },
      applyLinearImpulse: function(impulse, point, wake) {
        if (this._b2Body) {
          tempb2Vec21.Set(impulse.x / PTM_RATIO, impulse.y / PTM_RATIO);
          tempb2Vec22.Set(point.x / PTM_RATIO, point.y / PTM_RATIO);
          this._b2Body.ApplyLinearImpulse(tempb2Vec21, tempb2Vec22, wake);
        }
      },
      applyAngularImpulse: function(impulse, wake) {
        this._b2Body && this._b2Body.ApplyAngularImpulse(impulse / PTM_RATIO / PTM_RATIO, wake);
      },
      syncPosition: function(enableAnimated) {
        var b2body = this._b2Body;
        if (!b2body) return;
        var pos = this.node.convertToWorldSpaceAR(VEC2_ZERO);
        var temp;
        temp = this.type === BodyType.Animated ? b2body.GetLinearVelocity() : b2body.GetPosition();
        temp.x = pos.x / PTM_RATIO;
        temp.y = pos.y / PTM_RATIO;
        if (this.type === BodyType.Animated && enableAnimated) {
          var b2Pos = b2body.GetPosition();
          var timeStep = cc.game.config["frameRate"];
          temp.x = (temp.x - b2Pos.x) * timeStep;
          temp.y = (temp.y - b2Pos.y) * timeStep;
          b2body.SetAwake(true);
          b2body.SetLinearVelocity(temp);
        } else b2body.SetTransformVec(temp, b2body.GetAngle());
      },
      syncRotation: function(enableAnimated) {
        var b2body = this._b2Body;
        if (!b2body) return;
        var rotation = ANGLE_TO_PHYSICS_ANGLE * getWorldRotation(this.node);
        if (this.type === BodyType.Animated && enableAnimated) {
          var b2Rotation = b2body.GetAngle();
          var timeStep = cc.game.config["frameRate"];
          b2body.SetAwake(true);
          b2body.SetAngularVelocity((rotation - b2Rotation) * timeStep);
        } else b2body.SetTransformVec(b2body.GetPosition(), rotation);
      },
      resetVelocity: function() {
        var b2body = this._b2Body;
        if (!b2body) return;
        var temp = b2body.m_linearVelocity;
        temp.Set(0, 0);
        b2body.SetLinearVelocity(temp);
        b2body.SetAngularVelocity(0);
      },
      onEnable: function() {
        this._init();
      },
      onDisable: function() {
        this._destroy();
      },
      _registerNodeEvents: function() {
        var node = this.node;
        node.on(NodeEvent.POSITION_CHANGED, this._onNodePositionChanged, this);
        node.on(NodeEvent.ROTATION_CHANGED, this._onNodeRotationChanged, this);
        node.on(NodeEvent.SCALE_CHANGED, this._onNodeScaleChanged, this);
      },
      _unregisterNodeEvents: function() {
        var node = this.node;
        node.off(NodeEvent.POSITION_CHANGED, this._onNodePositionChanged, this);
        node.off(NodeEvent.ROTATION_CHANGED, this._onNodeRotationChanged, this);
        node.off(NodeEvent.SCALE_CHANGED, this._onNodeScaleChanged, this);
      },
      _onNodePositionChanged: function() {
        this.syncPosition(true);
      },
      _onNodeRotationChanged: function(event) {
        this.syncRotation(true);
      },
      _onNodeScaleChanged: function(event) {
        if (this._b2Body) {
          var colliders = this.getComponents(cc.PhysicsCollider);
          for (var i = 0; i < colliders.length; i++) colliders[i].apply();
        }
      },
      _init: function() {
        cc.director.getPhysicsManager().pushDelayEvent(this, "__init", []);
      },
      _destroy: function() {
        cc.director.getPhysicsManager().pushDelayEvent(this, "__destroy", []);
      },
      __init: function() {
        if (this._inited) return;
        this._registerNodeEvents();
        var bodyDef = new b2.BodyDef();
        this.type === BodyType.Animated ? bodyDef.type = BodyType.Kinematic : bodyDef.type = this.type;
        bodyDef.allowSleep = this.allowSleep;
        bodyDef.gravityScale = this.gravityScale;
        bodyDef.linearDamping = this.linearDamping;
        bodyDef.angularDamping = this.angularDamping;
        var linearVelocity = this.linearVelocity;
        bodyDef.linearVelocity = new b2.Vec2(linearVelocity.x / PTM_RATIO, linearVelocity.y / PTM_RATIO);
        bodyDef.angularVelocity = this.angularVelocity * ANGLE_TO_PHYSICS_ANGLE;
        bodyDef.fixedRotation = this.fixedRotation;
        bodyDef.bullet = this.bullet;
        var node = this.node;
        var pos = node.convertToWorldSpaceAR(VEC2_ZERO);
        bodyDef.position = new b2.Vec2(pos.x / PTM_RATIO, pos.y / PTM_RATIO);
        bodyDef.angle = -Math.PI / 180 * getWorldRotation(node);
        cc.director.getPhysicsManager()._addBody(this, bodyDef);
        this._inited = true;
      },
      __destroy: function() {
        if (!this._inited) return;
        cc.director.getPhysicsManager()._removeBody(this);
        this._unregisterNodeEvents();
        this._inited = false;
      },
      _getBody: function() {
        return this._b2Body;
      }
    });
    cc.RigidBody = module.exports = RigidBody;
  }), {
    "../CCNode": 25,
    "./CCPhysicsTypes": 121,
    "./utils": 144
  } ],
  124: [ (function(require, module, exports) {
    var box2d = require("../../../external/box2d/box2d");
    window.b2 = {};
    false;
    for (var key in box2d) {
      if (-1 !== key.indexOf("b2_")) continue;
      var newKey = key.replace("b2", "");
      b2[newKey] = box2d[key];
    }
    b2.maxPolygonVertices = 8;
  }), {
    "../../../external/box2d/box2d": 240
  } ],
  125: [ (function(require, module, exports) {
    var PTM_RATIO = require("../CCPhysicsTypes").PTM_RATIO;
    var PhysicsBoxCollider = cc.Class({
      name: "cc.PhysicsBoxCollider",
      extends: cc.PhysicsCollider,
      mixins: [ cc.Collider.Box ],
      editor: {
        menu: false,
        requireComponent: cc.RigidBody
      },
      _createShape: function(scale) {
        var scaleX = Math.abs(scale.x);
        var scaleY = Math.abs(scale.y);
        var width = this.size.width / 2 / PTM_RATIO * scaleX;
        var height = this.size.height / 2 / PTM_RATIO * scaleY;
        var offsetX = this.offset.x / PTM_RATIO * scaleX;
        var offsetY = this.offset.y / PTM_RATIO * scaleY;
        var shape = new b2.PolygonShape();
        shape.SetAsBox(width, height, new b2.Vec2(offsetX, offsetY), 0);
        return shape;
      }
    });
    cc.PhysicsBoxCollider = module.exports = PhysicsBoxCollider;
  }), {
    "../CCPhysicsTypes": 121
  } ],
  126: [ (function(require, module, exports) {
    var PTM_RATIO = require("../CCPhysicsTypes").PTM_RATIO;
    var PhysicsChainCollider = cc.Class({
      name: "cc.PhysicsChainCollider",
      extends: cc.PhysicsCollider,
      editor: {
        menu: false,
        inspector: false,
        requireComponent: cc.RigidBody
      },
      properties: {
        loop: false,
        points: {
          default: function() {
            return [ cc.v2(-50, 0), cc.v2(50, 0) ];
          },
          type: [ cc.Vec2 ]
        },
        threshold: {
          default: 1,
          serializable: false,
          visible: false
        }
      },
      _createShape: function(scale) {
        var shape = new b2.ChainShape();
        var points = this.points;
        var vertices = [];
        for (var i = 0; i < points.length; i++) {
          var p = points[i];
          vertices.push(new b2.Vec2(p.x / PTM_RATIO * scale.x, p.y / PTM_RATIO * scale.y));
        }
        this.loop ? shape.CreateLoop(vertices, vertices.length) : shape.CreateChain(vertices, vertices.length);
        return shape;
      },
      resetInEditor: false,
      resetPointsByContour: false
    });
    cc.PhysicsChainCollider = module.exports = PhysicsChainCollider;
  }), {
    "../CCPhysicsTypes": 121
  } ],
  127: [ (function(require, module, exports) {
    var PTM_RATIO = require("../CCPhysicsTypes").PTM_RATIO;
    var PhysicsCircleCollider = cc.Class({
      name: "cc.PhysicsCircleCollider",
      extends: cc.PhysicsCollider,
      mixins: [ cc.Collider.Circle ],
      editor: {
        menu: false,
        requireComponent: cc.RigidBody
      },
      _createShape: function(scale) {
        var scaleX = Math.abs(scale.x);
        var scaleY = Math.abs(scale.y);
        var offsetX = this.offset.x / PTM_RATIO * scaleX;
        var offsetY = this.offset.y / PTM_RATIO * scaleY;
        var shape = new b2.CircleShape();
        shape.m_radius = this.radius / PTM_RATIO * scaleX;
        shape.m_p = new b2.Vec2(offsetX, offsetY);
        return shape;
      }
    });
    cc.PhysicsCircleCollider = module.exports = PhysicsCircleCollider;
  }), {
    "../CCPhysicsTypes": 121
  } ],
  128: [ (function(require, module, exports) {
    var PTM_RATIO = require("../CCPhysicsTypes").PTM_RATIO;
    var getWorldScale = require("../utils").getWorldScale;
    var PhysicsCollider = cc.Class({
      name: "cc.PhysicsCollider",
      extends: cc.Collider,
      ctor: function() {
        this._fixtures = [];
        this._shapes = [];
        this._inited = false;
        this._rect = cc.rect();
      },
      properties: {
        _density: 1,
        _sensor: false,
        _friction: .2,
        _restitution: 0,
        density: {
          tooltip: false,
          get: function() {
            return this._density;
          },
          set: function(value) {
            this._density = value;
          }
        },
        sensor: {
          tooltip: false,
          get: function() {
            return this._sensor;
          },
          set: function(value) {
            this._sensor = value;
          }
        },
        friction: {
          tooltip: false,
          get: function() {
            return this._friction;
          },
          set: function(value) {
            this._friction = value;
          }
        },
        restitution: {
          tooltip: false,
          get: function() {
            return this._restitution;
          },
          set: function(value) {
            this._restitution = value;
          }
        },
        body: {
          default: null,
          type: cc.RigidBody,
          visible: false
        }
      },
      onDisable: function() {
        this._destroy();
      },
      onEnable: function() {
        this._init();
      },
      start: function() {
        this._init();
      },
      _getFixtureIndex: function(fixture) {
        return this._fixtures.indexOf(fixture);
      },
      _init: function() {
        cc.director.getPhysicsManager().pushDelayEvent(this, "__init", []);
      },
      _destroy: function() {
        cc.director.getPhysicsManager().pushDelayEvent(this, "__destroy", []);
      },
      __init: function() {
        if (this._inited) return;
        var body = this.body || this.getComponent(cc.RigidBody);
        if (!body) return;
        var innerBody = body._getBody();
        if (!innerBody) return;
        var node = body.node;
        var scale = getWorldScale(node);
        this._scale = scale;
        var shapes = 0 === scale.x && 0 === scale.y ? [] : this._createShape(scale);
        shapes instanceof Array || (shapes = [ shapes ]);
        var categoryBits = 1 << node.groupIndex;
        var maskBits = 0;
        var bits = cc.game.collisionMatrix[node.groupIndex];
        for (var i = 0; i < bits.length; i++) {
          if (!bits[i]) continue;
          maskBits |= 1 << i;
        }
        var filter = {
          categoryBits: categoryBits,
          maskBits: maskBits,
          groupIndex: 0
        };
        var manager = cc.director.getPhysicsManager();
        for (var _i = 0; _i < shapes.length; _i++) {
          var shape = shapes[_i];
          var fixDef = new b2.FixtureDef();
          fixDef.density = this.density;
          fixDef.isSensor = this.sensor;
          fixDef.friction = this.friction;
          fixDef.restitution = this.restitution;
          fixDef.shape = shape;
          fixDef.filter = filter;
          var fixture = innerBody.CreateFixture(fixDef);
          fixture.collider = this;
          body.enabledContactListener && manager._registerContactFixture(fixture);
          this._shapes.push(shape);
          this._fixtures.push(fixture);
        }
        this.body = body;
        this._inited = true;
      },
      __destroy: function() {
        if (!this._inited) return;
        var fixtures = this._fixtures;
        var body = this.body._getBody();
        var manager = cc.director.getPhysicsManager();
        for (var i = fixtures.length - 1; i >= 0; i--) {
          var fixture = fixtures[i];
          fixture.collider = null;
          manager._unregisterContactFixture(fixture);
          body && body.DestroyFixture(fixture);
        }
        this.body = null;
        this._fixtures.length = 0;
        this._shapes.length = 0;
        this._inited = false;
      },
      _createShape: function() {},
      apply: function() {
        this._destroy();
        this._init();
      },
      getAABB: function() {
        var MAX = 1e7;
        var minX = MAX, minY = MAX;
        var maxX = -MAX, maxY = -MAX;
        var fixtures = this._fixtures;
        for (var i = 0; i < fixtures.length; i++) {
          var fixture = fixtures[i];
          var count = fixture.GetShape().GetChildCount();
          for (var j = 0; j < count; j++) {
            var aabb = fixture.GetAABB(j);
            aabb.lowerBound.x < minX && (minX = aabb.lowerBound.x);
            aabb.lowerBound.y < minY && (minY = aabb.lowerBound.y);
            aabb.upperBound.x > maxX && (maxX = aabb.upperBound.x);
            aabb.upperBound.y > maxY && (maxY = aabb.upperBound.y);
          }
        }
        minX *= PTM_RATIO;
        minY *= PTM_RATIO;
        maxX *= PTM_RATIO;
        maxY *= PTM_RATIO;
        var r = this._rect;
        r.x = minX;
        r.y = minY;
        r.width = maxX - minX;
        r.height = maxY - minY;
        return r;
      }
    });
    cc.PhysicsCollider = module.exports = PhysicsCollider;
  }), {
    "../CCPhysicsTypes": 121,
    "../utils": 144
  } ],
  129: [ (function(require, module, exports) {
    var PTM_RATIO = require("../CCPhysicsTypes").PTM_RATIO;
    var PolygonSeparator = require("../CCPolygonSeparator");
    var PhysicsPolygonCollider = cc.Class({
      name: "cc.PhysicsPolygonCollider",
      extends: cc.PhysicsCollider,
      mixins: [ cc.Collider.Polygon ],
      editor: {
        menu: false,
        inspector: false,
        requireComponent: cc.RigidBody
      },
      _createShape: function(scale) {
        var shapes = [];
        var points = this.points;
        points.length > 0 && points[0].equals(points[points.length - 1]) && (points.length -= 1);
        var polys = PolygonSeparator.ConvexPartition(points);
        var offset = this.offset;
        for (var i = 0; i < polys.length; i++) {
          var poly = polys[i];
          var shape = null, vertices = [];
          var firstVertice = null;
          for (var j = 0, l = poly.length; j < l; j++) {
            shape || (shape = new b2.PolygonShape());
            var p = poly[j];
            var x = (p.x + offset.x) / PTM_RATIO * scale.x;
            var y = (p.y + offset.y) / PTM_RATIO * scale.y;
            var v = new b2.Vec2(x, y);
            vertices.push(v);
            firstVertice || (firstVertice = v);
            if (vertices.length === b2.maxPolygonVertices) {
              shape.Set(vertices, vertices.length);
              shapes.push(shape);
              shape = null;
              j < l - 1 && (vertices = [ firstVertice, vertices[vertices.length - 1] ]);
            }
          }
          if (shape) {
            shape.Set(vertices, vertices.length);
            shapes.push(shape);
          }
        }
        return shapes;
      }
    });
    cc.PhysicsPolygonCollider = module.exports = PhysicsPolygonCollider;
  }), {
    "../CCPhysicsTypes": 121,
    "../CCPolygonSeparator": 122
  } ],
  130: [ (function(require, module, exports) {
    require("./box2d-adapter");
    require("./CCPhysicsManager");
    require("./CCRigidBody");
    require("./CCPhysicsContact");
    require("./collider/CCPhysicsCollider");
    require("./collider/CCPhysicsChainCollider");
    require("./collider/CCPhysicsCircleCollider");
    require("./collider/CCPhysicsBoxCollider");
    require("./collider/CCPhysicsPolygonCollider");
    require("./joint/CCJoint");
    require("./joint/CCDistanceJoint");
    require("./joint/CCRevoluteJoint");
    require("./joint/CCMouseJoint");
    require("./joint/CCMotorJoint");
    require("./joint/CCPrismaticJoint");
    require("./joint/CCWeldJoint");
    require("./joint/CCWheelJoint");
    require("./joint/CCRopeJoint");
    require("./platform/CCPhysicsContactListner");
    require("./platform/CCPhysicsAABBQueryCallback");
    require("./platform/CCPhysicsRayCastCallback");
  }), {
    "./CCPhysicsContact": 119,
    "./CCPhysicsManager": 120,
    "./CCRigidBody": 123,
    "./box2d-adapter": 124,
    "./collider/CCPhysicsBoxCollider": 125,
    "./collider/CCPhysicsChainCollider": 126,
    "./collider/CCPhysicsCircleCollider": 127,
    "./collider/CCPhysicsCollider": 128,
    "./collider/CCPhysicsPolygonCollider": 129,
    "./joint/CCDistanceJoint": 131,
    "./joint/CCJoint": 132,
    "./joint/CCMotorJoint": 133,
    "./joint/CCMouseJoint": 134,
    "./joint/CCPrismaticJoint": 135,
    "./joint/CCRevoluteJoint": 136,
    "./joint/CCRopeJoint": 137,
    "./joint/CCWeldJoint": 138,
    "./joint/CCWheelJoint": 139,
    "./platform/CCPhysicsAABBQueryCallback": 140,
    "./platform/CCPhysicsContactListner": 141,
    "./platform/CCPhysicsRayCastCallback": 143
  } ],
  131: [ (function(require, module, exports) {
    var PTM_RATIO = require("../CCPhysicsTypes").PTM_RATIO;
    var DistanceJoint = cc.Class({
      name: "cc.DistanceJoint",
      extends: cc.Joint,
      editor: false,
      properties: {
        _distance: 1,
        _frequency: 0,
        _dampingRatio: 0,
        distance: {
          tooltip: false,
          get: function() {
            return this._distance;
          },
          set: function(value) {
            this._distance = value;
            this._joint && this._joint.SetLength(value);
          }
        },
        frequency: {
          tooltip: false,
          get: function() {
            return this._frequency;
          },
          set: function(value) {
            this._frequency = value;
            this._joint && this._joint.SetFrequency(value);
          }
        },
        dampingRatio: {
          tooltip: false,
          get: function() {
            return this._dampingRatio;
          },
          set: function(value) {
            this._dampingRatio = value;
            this._joint && this._joint.SetDampingRatio(value);
          }
        }
      },
      _createJointDef: function() {
        var def = new b2.DistanceJointDef();
        def.localAnchorA = new b2.Vec2(this.anchor.x / PTM_RATIO, this.anchor.y / PTM_RATIO);
        def.localAnchorB = new b2.Vec2(this.connectedAnchor.x / PTM_RATIO, this.connectedAnchor.y / PTM_RATIO);
        def.length = this.distance / PTM_RATIO;
        def.dampingRatio = this.dampingRatio;
        def.frequencyHz = this.frequency;
        return def;
      }
    });
    cc.DistanceJoint = module.exports = DistanceJoint;
  }), {
    "../CCPhysicsTypes": 121
  } ],
  132: [ (function(require, module, exports) {
    var PTM_RATIO = require("../CCPhysicsTypes").PTM_RATIO;
    var Joint = cc.Class({
      name: "cc.Joint",
      extends: cc.Component,
      editor: {
        requireComponent: cc.RigidBody
      },
      properties: {
        anchor: {
          default: cc.v2(0, 0),
          tooltip: false
        },
        connectedAnchor: {
          default: cc.v2(0, 0),
          tooltip: false
        },
        connectedBody: {
          default: null,
          type: cc.RigidBody,
          tooltip: false
        },
        collideConnected: {
          default: false,
          tooltip: false
        }
      },
      onDisable: function() {
        this._destroy();
      },
      onEnable: function() {
        this._init();
      },
      start: function() {
        this._init();
      },
      apply: function() {
        this._destroy();
        this._init();
      },
      getWorldAnchor: function() {
        if (this._joint) {
          var anchor = this._joint.GetAnchorA();
          return cc.v2(anchor.x * PTM_RATIO, anchor.y * PTM_RATIO);
        }
        return cc.Vec2.ZERO;
      },
      getWorldConnectedAnchor: function() {
        if (this._joint) {
          var anchor = this._joint.GetAnchorB();
          return cc.v2(anchor.x * PTM_RATIO, anchor.y * PTM_RATIO);
        }
        return cc.Vec2.ZERO;
      },
      getReactionForce: function(timeStep) {
        var out = cc.v2();
        if (this._joint) return this._joint.GetReactionForce(timeStep, out);
        return out;
      },
      getReactionTorque: function(timeStep) {
        if (this._joint) return this._joint.GetReactionTorque(timeStep);
        return 0;
      },
      _init: function() {
        cc.director.getPhysicsManager().pushDelayEvent(this, "__init", []);
      },
      _destroy: function() {
        cc.director.getPhysicsManager().pushDelayEvent(this, "__destroy", []);
      },
      __init: function() {
        if (this._inited) return;
        this.body = this.getComponent(cc.RigidBody);
        if (this._isValid()) {
          var def = this._createJointDef();
          if (!def) return;
          def.bodyA = this.body._getBody();
          def.bodyB = this.connectedBody._getBody();
          def.collideConnected = this.collideConnected;
          cc.director.getPhysicsManager()._addJoint(this, def);
          this._inited = true;
        }
      },
      __destroy: function() {
        if (!this._inited) return;
        cc.director.getPhysicsManager()._removeJoint(this);
        this._joint = null;
        this._inited = false;
      },
      _createJointDef: function() {
        return null;
      },
      _isValid: function() {
        return this.body && this.body._getBody() && this.connectedBody && this.connectedBody._getBody();
      }
    });
    cc.Joint = module.exports = Joint;
  }), {
    "../CCPhysicsTypes": 121
  } ],
  133: [ (function(require, module, exports) {
    var PTM_RATIO = require("../CCPhysicsTypes").PTM_RATIO;
    var ANGLE_TO_PHYSICS_ANGLE = require("../CCPhysicsTypes").ANGLE_TO_PHYSICS_ANGLE;
    var MotorJoint = cc.Class({
      name: "cc.MotorJoint",
      extends: cc.Joint,
      editor: false,
      properties: {
        _linearOffset: cc.v2(0, 0),
        _angularOffset: 0,
        _maxForce: 1,
        _maxTorque: 1,
        _correctionFactor: .3,
        anchor: {
          tooltip: false,
          default: cc.v2(0, 0),
          override: true,
          visible: false
        },
        connectedAnchor: {
          tooltip: false,
          default: cc.v2(0, 0),
          override: true,
          visible: false
        },
        linearOffset: {
          tooltip: false,
          get: function() {
            return this._linearOffset;
          },
          set: function(value) {
            this._linearOffset = value;
            this._joint && this._joint.SetLinearOffset(new b2.Vec2(value.x / PTM_RATIO, value.y / PTM_RATIO));
          }
        },
        angularOffset: {
          tooltip: false,
          get: function() {
            return this._angularOffset;
          },
          set: function(value) {
            this._angularOffset = value;
            this._joint && this._joint.SetAngularOffset(value);
          }
        },
        maxForce: {
          tooltip: false,
          get: function() {
            return this._maxForce;
          },
          set: function(value) {
            this._maxForce = value;
            this._joint && this._joint.SetMaxForce(value);
          }
        },
        maxTorque: {
          tooltip: false,
          get: function() {
            return this._maxTorque;
          },
          set: function(value) {
            this._maxTorque = value;
            this._joint && this._joint.SetMaxTorque(value);
          }
        },
        correctionFactor: {
          tooltip: false,
          get: function() {
            return this._correctionFactor;
          },
          set: function(value) {
            this._correctionFactor = value;
            this._joint && this._joint.SetCorrectionFactor(value);
          }
        }
      },
      _createJointDef: function() {
        var def = new b2.MotorJointDef();
        def.linearOffset = new b2.Vec2(this.linearOffset.x / PTM_RATIO, this.linearOffset.y / PTM_RATIO);
        def.angularOffset = this.angularOffset * ANGLE_TO_PHYSICS_ANGLE;
        def.maxForce = this.maxForce;
        def.maxTorque = this.maxTorque;
        def.correctionFactor = this.correctionFactor;
        return def;
      }
    });
    cc.MotorJoint = module.exports = MotorJoint;
  }), {
    "../CCPhysicsTypes": 121
  } ],
  134: [ (function(require, module, exports) {
    var PTM_RATIO = require("../CCPhysicsTypes").PTM_RATIO;
    var tempB2Vec2 = new b2.Vec2();
    var MouseJoint = cc.Class({
      name: "cc.MouseJoint",
      extends: cc.Joint,
      editor: false,
      properties: {
        _target: 1,
        _frequency: 5,
        _dampingRatio: .7,
        _maxForce: 0,
        connectedBody: {
          default: null,
          type: cc.RigidBody,
          visible: false,
          override: true
        },
        collideConnected: {
          default: true,
          visible: false,
          override: true
        },
        anchor: {
          tooltip: false,
          default: cc.v2(0, 0),
          override: true,
          visible: false
        },
        connectedAnchor: {
          tooltip: false,
          default: cc.v2(0, 0),
          override: true,
          visible: false
        },
        mouseRegion: {
          tooltip: false,
          default: null,
          type: cc.Node
        },
        target: {
          tooltip: false,
          visible: false,
          get: function() {
            return this._target;
          },
          set: function(value) {
            this._target = value;
            if (this._joint) {
              tempB2Vec2.x = value.x / PTM_RATIO;
              tempB2Vec2.y = value.y / PTM_RATIO;
              this._joint.SetTarget(tempB2Vec2);
            }
          }
        },
        frequency: {
          tooltip: false,
          get: function() {
            return this._frequency;
          },
          set: function(value) {
            this._frequency = value;
            this._joint && this._joint.SetFrequency(value);
          }
        },
        dampingRatio: {
          tooltip: false,
          get: function() {
            return this._dampingRatio;
          },
          set: function(value) {
            this._dampingRatio = value;
            this._joint && this._joint.SetDampingRatio(value);
          }
        },
        maxForce: {
          tooltip: false,
          visible: false,
          get: function() {
            return this._maxForce;
          },
          set: function(value) {
            this._maxForce = value;
            this._joint && this._joint.SetMaxForce(value);
          }
        }
      },
      onLoad: function() {
        var mouseRegion = this.mouseRegion || this.node;
        mouseRegion.on(cc.Node.EventType.TOUCH_START, this.onTouchBegan, this);
        mouseRegion.on(cc.Node.EventType.TOUCH_MOVE, this.onTouchMove, this);
        mouseRegion.on(cc.Node.EventType.TOUCH_END, this.onTouchEnd, this);
      },
      onEnable: function() {},
      start: function() {},
      onTouchBegan: function(event) {
        var manager = cc.director.getPhysicsManager();
        var target = this._pressPoint = event.touch.getLocation();
        cc.Camera && cc.Camera.main && (target = cc.Camera.main.getCameraToWorldPoint(target));
        var collider = manager.testPoint(target);
        if (!collider) return;
        var body = this.connectedBody = collider.body;
        body.awake = true;
        this.maxForce = 1e3 * this.connectedBody.getMass();
        this.target = target;
        this._init();
      },
      onTouchMove: function(event) {
        this._pressPoint = event.touch.getLocation();
      },
      onTouchEnd: function(event) {
        this._destroy();
        this._pressPoint = null;
      },
      _createJointDef: function() {
        var def = new b2.MouseJointDef();
        tempB2Vec2.x = this.target.x / PTM_RATIO;
        tempB2Vec2.y = this.target.y / PTM_RATIO;
        def.target = tempB2Vec2;
        def.maxForce = this.maxForce;
        def.dampingRatio = this.dampingRatio;
        def.frequencyHz = this.frequency;
        return def;
      },
      update: function() {
        if (!this._pressPoint || !this._isValid()) return;
        var camera = cc.Camera.findCamera(this.node);
        this.target = camera ? camera.getCameraToWorldPoint(this._pressPoint) : this._pressPoint;
      }
    });
    cc.MouseJoint = module.exports = MouseJoint;
  }), {
    "../CCPhysicsTypes": 121
  } ],
  135: [ (function(require, module, exports) {
    var PTM_RATIO = require("../CCPhysicsTypes").PTM_RATIO;
    var ANGLE_TO_PHYSICS_ANGLE = require("../CCPhysicsTypes").ANGLE_TO_PHYSICS_ANGLE;
    var PrismaticJoint = cc.Class({
      name: "cc.PrismaticJoint",
      extends: cc.Joint,
      editor: false,
      properties: {
        localAxisA: {
          default: cc.v2(1, 0),
          tooltip: false
        },
        referenceAngle: {
          default: 0,
          tooltip: false
        },
        enableLimit: {
          default: false,
          tooltip: false
        },
        enableMotor: {
          default: false,
          tooltip: false
        },
        lowerLimit: {
          default: 0,
          tooltip: false
        },
        upperLimit: {
          default: 0,
          tooltip: false
        },
        _maxMotorForce: 0,
        _motorSpeed: 0,
        maxMotorForce: {
          tooltip: false,
          get: function() {
            return this._maxMotorForce;
          },
          set: function(value) {
            this._maxMotorForce = value;
            this._joint && this._joint.SetMaxMotorForce(value);
          }
        },
        motorSpeed: {
          tooltip: false,
          get: function() {
            return this._motorSpeed;
          },
          set: function(value) {
            this._motorSpeed = value;
            this._joint && this._joint.SetMotorSpeed(value);
          }
        }
      },
      _createJointDef: function() {
        var def = new b2.PrismaticJointDef();
        def.localAnchorA = new b2.Vec2(this.anchor.x / PTM_RATIO, this.anchor.y / PTM_RATIO);
        def.localAnchorB = new b2.Vec2(this.connectedAnchor.x / PTM_RATIO, this.connectedAnchor.y / PTM_RATIO);
        def.localAxisA = new b2.Vec2(this.localAxisA.x, this.localAxisA.y);
        def.referenceAngle = this.referenceAngle * ANGLE_TO_PHYSICS_ANGLE;
        def.enableLimit = this.enableLimit;
        def.lowerTranslation = this.lowerLimit / PTM_RATIO;
        def.upperTranslation = this.upperLimit / PTM_RATIO;
        def.enableMotor = this.enableMotor;
        def.maxMotorForce = this.maxMotorForce;
        def.motorSpeed = this.motorSpeed;
        return def;
      }
    });
    cc.PrismaticJoint = module.exports = PrismaticJoint;
  }), {
    "../CCPhysicsTypes": 121
  } ],
  136: [ (function(require, module, exports) {
    var PTM_RATIO = require("../CCPhysicsTypes").PTM_RATIO;
    var ANGLE_TO_PHYSICS_ANGLE = require("../CCPhysicsTypes").ANGLE_TO_PHYSICS_ANGLE;
    var PHYSICS_ANGLE_TO_ANGLE = require("../CCPhysicsTypes").PHYSICS_ANGLE_TO_ANGLE;
    var RevoluteJoint = cc.Class({
      name: "cc.RevoluteJoint",
      extends: cc.Joint,
      editor: false,
      properties: {
        _maxMotorTorque: 0,
        _motorSpeed: 0,
        _enableLimit: false,
        _enableMotor: false,
        referenceAngle: {
          default: 0,
          tooltip: false
        },
        lowerAngle: {
          default: 0,
          tooltip: false
        },
        upperAngle: {
          default: 0,
          tooltip: false
        },
        maxMotorTorque: {
          tooltip: false,
          get: function() {
            return this._maxMotorTorque;
          },
          set: function(value) {
            this._maxMotorTorque = value;
            this._joint && this._joint.SetMaxMotorTorque(value);
          }
        },
        motorSpeed: {
          tooltip: false,
          get: function() {
            return this._motorSpeed;
          },
          set: function(value) {
            this._motorSpeed = value;
            this._joint && this._joint.SetMotorSpeed(value * ANGLE_TO_PHYSICS_ANGLE);
          }
        },
        enableLimit: {
          tooltip: false,
          get: function() {
            return this._enableLimit;
          },
          set: function(value) {
            this._enableLimit = value;
            this._joint && this._joint.EnableLimit(value);
          }
        },
        enableMotor: {
          tooltip: false,
          get: function() {
            return this._enableMotor;
          },
          set: function(value) {
            this._enableMotor = value;
            this._joint && this._joint.EnableMotor(value);
          }
        }
      },
      getJointAngle: function() {
        if (this._joint) return this._joint.GetJointAngle() * PHYSICS_ANGLE_TO_ANGLE;
        return 0;
      },
      setLimits: function(lower, upper) {
        if (this._joint) return this._joint.SetLimits(lower * ANGLE_TO_PHYSICS_ANGLE, upper * ANGLE_TO_PHYSICS_ANGLE);
      },
      _createJointDef: function() {
        var def = new b2.RevoluteJointDef();
        def.localAnchorA = new b2.Vec2(this.anchor.x / PTM_RATIO, this.anchor.y / PTM_RATIO);
        def.localAnchorB = new b2.Vec2(this.connectedAnchor.x / PTM_RATIO, this.connectedAnchor.y / PTM_RATIO);
        def.lowerAngle = this.upperAngle * ANGLE_TO_PHYSICS_ANGLE;
        def.upperAngle = this.lowerAngle * ANGLE_TO_PHYSICS_ANGLE;
        def.maxMotorTorque = this.maxMotorTorque;
        def.motorSpeed = this.motorSpeed * ANGLE_TO_PHYSICS_ANGLE;
        def.enableLimit = this.enableLimit;
        def.enableMotor = this.enableMotor;
        def.referenceAngle = this.referenceAngle * ANGLE_TO_PHYSICS_ANGLE;
        return def;
      }
    });
    cc.RevoluteJoint = module.exports = RevoluteJoint;
  }), {
    "../CCPhysicsTypes": 121
  } ],
  137: [ (function(require, module, exports) {
    var PTM_RATIO = require("../CCPhysicsTypes").PTM_RATIO;
    var RopeJoint = cc.Class({
      name: "cc.RopeJoint",
      extends: cc.Joint,
      editor: false,
      properties: {
        _maxLength: 1,
        maxLength: {
          tooltip: false,
          get: function() {
            return this._maxLength;
          },
          set: function(value) {
            this._maxLength = value;
            this._joint && this._joint.SetMaxLength(value);
          }
        }
      },
      _createJointDef: function() {
        var def = new b2.RopeJointDef();
        def.localAnchorA = new b2.Vec2(this.anchor.x / PTM_RATIO, this.anchor.y / PTM_RATIO);
        def.localAnchorB = new b2.Vec2(this.connectedAnchor.x / PTM_RATIO, this.connectedAnchor.y / PTM_RATIO);
        def.maxLength = this.maxLength / PTM_RATIO;
        return def;
      }
    });
    cc.RopeJoint = module.exports = RopeJoint;
  }), {
    "../CCPhysicsTypes": 121
  } ],
  138: [ (function(require, module, exports) {
    var PTM_RATIO = require("../CCPhysicsTypes").PTM_RATIO;
    var ANGLE_TO_PHYSICS_ANGLE = require("../CCPhysicsTypes").ANGLE_TO_PHYSICS_ANGLE;
    var WeldJoint = cc.Class({
      name: "cc.WeldJoint",
      extends: cc.Joint,
      editor: false,
      properties: {
        referenceAngle: {
          default: 0,
          tooltip: false
        },
        _frequency: 0,
        _dampingRatio: 0,
        frequency: {
          tooltip: false,
          get: function() {
            return this._frequency;
          },
          set: function(value) {
            this._frequency = value;
            this._joint && this._joint.SetFrequency(value);
          }
        },
        dampingRatio: {
          tooltip: false,
          get: function() {
            return this._dampingRatio;
          },
          set: function(value) {
            this._dampingRatio = value;
            this._joint && this._joint.SetDampingRatio(value);
          }
        }
      },
      _createJointDef: function() {
        var def = new b2.WeldJointDef();
        def.localAnchorA = new b2.Vec2(this.anchor.x / PTM_RATIO, this.anchor.y / PTM_RATIO);
        def.localAnchorB = new b2.Vec2(this.connectedAnchor.x / PTM_RATIO, this.connectedAnchor.y / PTM_RATIO);
        def.referenceAngle = this.referenceAngle * ANGLE_TO_PHYSICS_ANGLE;
        def.frequencyHz = this.frequency;
        def.dampingRatio = this.dampingRatio;
        return def;
      }
    });
    cc.WeldJoint = module.exports = WeldJoint;
  }), {
    "../CCPhysicsTypes": 121
  } ],
  139: [ (function(require, module, exports) {
    var PTM_RATIO = require("../CCPhysicsTypes").PTM_RATIO;
    var ANGLE_TO_PHYSICS_ANGLE = require("../CCPhysicsTypes").ANGLE_TO_PHYSICS_ANGLE;
    var WheelJoint = cc.Class({
      name: "cc.WheelJoint",
      extends: cc.Joint,
      editor: false,
      properties: {
        _maxMotorTorque: 0,
        _motorSpeed: 0,
        _enableMotor: false,
        _frequency: 2,
        _dampingRatio: .7,
        localAxisA: {
          default: cc.v2(1, 0),
          tooltip: false
        },
        maxMotorTorque: {
          tooltip: false,
          get: function() {
            return this._maxMotorTorque;
          },
          set: function(value) {
            this._maxMotorTorque = value;
            this._joint && this._joint.SetMaxMotorTorque(value);
          }
        },
        motorSpeed: {
          tooltip: false,
          get: function() {
            return this._motorSpeed;
          },
          set: function(value) {
            this._motorSpeed = value;
            this._joint && this._joint.SetMotorSpeed(value * ANGLE_TO_PHYSICS_ANGLE);
          }
        },
        enableMotor: {
          tooltip: false,
          get: function() {
            return this._enableMotor;
          },
          set: function(value) {
            this._enableMotor = value;
            this._joint && this._joint.EnableMotor(value);
          }
        },
        frequency: {
          tooltip: false,
          get: function() {
            return this._frequency;
          },
          set: function(value) {
            this._frequency = value;
            this._joint && this._joint.SetFrequency(value);
          }
        },
        dampingRatio: {
          tooltip: false,
          get: function() {
            return this._dampingRatio;
          },
          set: function(value) {
            this._dampingRatio = value;
            this._joint && this._joint.SetDampingRatio(value);
          }
        }
      },
      _createJointDef: function() {
        var def = new b2.WheelJointDef();
        def.localAnchorA = new b2.Vec2(this.anchor.x / PTM_RATIO, this.anchor.y / PTM_RATIO);
        def.localAnchorB = new b2.Vec2(this.connectedAnchor.x / PTM_RATIO, this.connectedAnchor.y / PTM_RATIO);
        def.localAxisA = new b2.Vec2(this.localAxisA.x, this.localAxisA.y);
        def.maxMotorTorque = this.maxMotorTorque;
        def.motorSpeed = this.motorSpeed * ANGLE_TO_PHYSICS_ANGLE;
        def.enableMotor = this.enableMotor;
        def.dampingRatio = this.dampingRatio;
        def.frequencyHz = this.frequency;
        return def;
      }
    });
    cc.WheelJoint = module.exports = WheelJoint;
  }), {
    "../CCPhysicsTypes": 121
  } ],
  140: [ (function(require, module, exports) {
    var BodyType = require("../CCPhysicsTypes").BodyType;
    function PhysicsAABBQueryCallback() {
      this._point = new b2.Vec2();
      this._isPoint = false;
      this._fixtures = [];
    }
    PhysicsAABBQueryCallback.prototype.init = function(point) {
      if (point) {
        this._isPoint = true;
        this._point.x = point.x;
        this._point.y = point.y;
      } else this._isPoint = false;
      this._fixtures.length = 0;
    };
    PhysicsAABBQueryCallback.prototype.ReportFixture = function(fixture) {
      var body = fixture.GetBody();
      if (body.GetType() === BodyType.Dynamic) if (this._isPoint) {
        if (fixture.TestPoint(this._point)) {
          this._fixtures.push(fixture);
          return false;
        }
      } else this._fixtures.push(fixture);
      return true;
    };
    PhysicsAABBQueryCallback.prototype.getFixture = function() {
      return this._fixtures[0];
    };
    PhysicsAABBQueryCallback.prototype.getFixtures = function() {
      return this._fixtures;
    };
    cc.PhysicsAABBQueryCallback = module.exports = PhysicsAABBQueryCallback;
  }), {
    "../CCPhysicsTypes": 121
  } ],
  141: [ (function(require, module, exports) {
    function PhysicsContactListener() {
      this._contactFixtures = [];
    }
    PhysicsContactListener.prototype.setBeginContact = function(cb) {
      this._BeginContact = cb;
    };
    PhysicsContactListener.prototype.setEndContact = function(cb) {
      this._EndContact = cb;
    };
    PhysicsContactListener.prototype.setPreSolve = function(cb) {
      this._PreSolve = cb;
    };
    PhysicsContactListener.prototype.setPostSolve = function(cb) {
      this._PostSolve = cb;
    };
    PhysicsContactListener.prototype.BeginContact = function(contact) {
      if (!this._BeginContact) return;
      var fixtureA = contact.GetFixtureA();
      var fixtureB = contact.GetFixtureB();
      var fixtures = this._contactFixtures;
      contact._shouldReport = false;
      if (-1 !== fixtures.indexOf(fixtureA) || -1 !== fixtures.indexOf(fixtureB)) {
        contact._shouldReport = true;
        this._BeginContact(contact);
      }
    };
    PhysicsContactListener.prototype.EndContact = function(contact) {
      if (this._EndContact && contact._shouldReport) {
        contact._shouldReport = false;
        this._EndContact(contact);
      }
    };
    PhysicsContactListener.prototype.PreSolve = function(contact, oldManifold) {
      this._PreSolve && contact._shouldReport && this._PreSolve(contact, oldManifold);
    };
    PhysicsContactListener.prototype.PostSolve = function(contact, impulse) {
      this._PostSolve && contact._shouldReport && this._PostSolve(contact, impulse);
    };
    PhysicsContactListener.prototype.registerContactFixture = function(fixture) {
      this._contactFixtures.push(fixture);
    };
    PhysicsContactListener.prototype.unregisterContactFixture = function(fixture) {
      cc.js.array.remove(this._contactFixtures, fixture);
    };
    cc.PhysicsContactListener = module.exports = PhysicsContactListener;
  }), {} ],
  142: [ (function(require, module, exports) {
    var PTM_RATIO = require("../CCPhysicsTypes").PTM_RATIO;
    var _tmp_vec2 = cc.v2();
    var GREEN_COLOR = cc.Color.GREEN;
    var RED_COLOR = cc.Color.RED;
    function PhysicsDebugDraw(drawer) {
      b2.Draw.call(this);
      this._drawer = drawer;
      this._xf = this._dxf = new b2.Transform();
    }
    cc.js.extend(PhysicsDebugDraw, b2.Draw);
    cc.js.mixin(PhysicsDebugDraw.prototype, {
      _DrawPolygon: function(vertices, vertexCount) {
        var drawer = this._drawer;
        for (var i = 0; i < vertexCount; i++) {
          b2.Transform.MulXV(this._xf, vertices[i], _tmp_vec2);
          var x = _tmp_vec2.x * PTM_RATIO, y = _tmp_vec2.y * PTM_RATIO;
          0 === i ? drawer.moveTo(x, y) : drawer.lineTo(x, y);
        }
        drawer.close();
      },
      DrawPolygon: function(vertices, vertexCount, color) {
        this._applyStrokeColor(color);
        this._DrawPolygon(vertices, vertexCount);
        this._drawer.stroke();
      },
      DrawSolidPolygon: function(vertices, vertexCount, color) {
        this._applyFillColor(color);
        this._DrawPolygon(vertices, vertexCount);
        this._drawer.fill();
        this._drawer.stroke();
      },
      _DrawCircle: function(center, radius) {
        var p = this._xf.p;
        this._drawer.circle((center.x + p.x) * PTM_RATIO, (center.y + p.y) * PTM_RATIO, radius * PTM_RATIO);
      },
      DrawCircle: function(center, radius, color) {
        this._applyStrokeColor(color);
        this._DrawCircle(center, radius);
        this._drawer.stroke();
      },
      DrawSolidCircle: function(center, radius, axis, color) {
        this._applyFillColor(color);
        this._DrawCircle(center, radius);
        this._drawer.fill();
      },
      DrawSegment: function(p1, p2, color) {
        var drawer = this._drawer;
        if (p1.x === p2.x && p1.y === p2.y) {
          this._applyFillColor(color);
          this._DrawCircle(p1, 2 / PTM_RATIO);
          drawer.fill();
          return;
        }
        this._applyStrokeColor(color);
        b2.Transform.MulXV(this._xf, p1, _tmp_vec2);
        drawer.moveTo(_tmp_vec2.x * PTM_RATIO, _tmp_vec2.y * PTM_RATIO);
        b2.Transform.MulXV(this._xf, p2, _tmp_vec2);
        drawer.lineTo(_tmp_vec2.x * PTM_RATIO, _tmp_vec2.y * PTM_RATIO);
        drawer.stroke();
      },
      DrawTransform: function(xf) {
        var drawer = this._drawer;
        drawer.strokeColor = RED_COLOR;
        _tmp_vec2.x = _tmp_vec2.y = 0;
        b2.Transform.MulXV(xf, _tmp_vec2, _tmp_vec2);
        drawer.moveTo(_tmp_vec2.x * PTM_RATIO, _tmp_vec2.y * PTM_RATIO);
        _tmp_vec2.x = 1;
        _tmp_vec2.y = 0;
        b2.Transform.MulXV(xf, _tmp_vec2, _tmp_vec2);
        drawer.lineTo(_tmp_vec2.x * PTM_RATIO, _tmp_vec2.y * PTM_RATIO);
        drawer.stroke();
        drawer.strokeColor = GREEN_COLOR;
        _tmp_vec2.x = _tmp_vec2.y = 0;
        b2.Transform.MulXV(xf, _tmp_vec2, _tmp_vec2);
        drawer.moveTo(_tmp_vec2.x * PTM_RATIO, _tmp_vec2.y * PTM_RATIO);
        _tmp_vec2.x = 0;
        _tmp_vec2.y = 1;
        b2.Transform.MulXV(xf, _tmp_vec2, _tmp_vec2);
        drawer.lineTo(_tmp_vec2.x * PTM_RATIO, _tmp_vec2.y * PTM_RATIO);
        drawer.stroke();
      },
      DrawPoint: function(center, radius, color) {},
      _applyStrokeColor: function(color) {
        var strokeColor = this._drawer.strokeColor;
        strokeColor.r = 255 * color.r;
        strokeColor.g = 255 * color.g;
        strokeColor.b = 255 * color.b;
        strokeColor.a = 150;
        this._drawer.strokeColor = strokeColor;
      },
      _applyFillColor: function(color) {
        var fillColor = this._drawer.fillColor;
        fillColor.r = 255 * color.r;
        fillColor.g = 255 * color.g;
        fillColor.b = 255 * color.b;
        fillColor.a = 150;
        this._drawer.fillColor = fillColor;
      },
      PushTransform: function(xf) {
        this._xf = xf;
      },
      PopTransform: function() {
        this._xf = this._dxf;
      }
    });
    module.exports = PhysicsDebugDraw;
  }), {
    "../CCPhysicsTypes": 121
  } ],
  143: [ (function(require, module, exports) {
    function PhysicsRayCastCallback() {
      this._type = 0;
      this._fixtures = [];
      this._points = [];
      this._normals = [];
      this._fractions = [];
    }
    PhysicsRayCastCallback.prototype.init = function(type) {
      this._type = type;
      this._fixtures.length = 0;
      this._points.length = 0;
      this._normals.length = 0;
      this._fractions.length = 0;
    };
    PhysicsRayCastCallback.prototype.ReportFixture = function(fixture, point, normal, fraction) {
      if (0 === this._type) {
        this._fixtures[0] = fixture;
        this._points[0] = point;
        this._normals[0] = normal;
        this._fractions[0] = fraction;
        return fraction;
      }
      this._fixtures.push(fixture);
      this._points.push(cc.v2(point));
      this._normals.push(cc.v2(normal));
      this._fractions.push(fraction);
      if (1 === this._type) return 0;
      if (this._type >= 2) return 1;
      return fraction;
    };
    PhysicsRayCastCallback.prototype.getFixtures = function() {
      return this._fixtures;
    };
    PhysicsRayCastCallback.prototype.getPoints = function() {
      return this._points;
    };
    PhysicsRayCastCallback.prototype.getNormals = function() {
      return this._normals;
    };
    PhysicsRayCastCallback.prototype.getFractions = function() {
      return this._fractions;
    };
    cc.PhysicsRayCastCallback = module.exports = PhysicsRayCastCallback;
  }), {} ],
  144: [ (function(require, module, exports) {
    function getWorldRotation(node) {
      var rot = node.rotationX;
      var parent = node.parent;
      while (parent.parent) {
        rot += parent.rotationX;
        parent = parent.parent;
      }
      return rot;
    }
    function getWorldScale(node) {
      var scaleX = node.scaleX;
      var scaleY = node.scaleY;
      var parent = node.parent;
      while (parent.parent) {
        scaleX *= parent.scaleX;
        scaleY *= parent.scaleY;
        parent = parent.parent;
      }
      return cc.v2(scaleX, scaleY);
    }
    function convertToNodeRotation(node, rotation) {
      rotation -= node.rotationX;
      var parent = node.parent;
      while (parent.parent) {
        rotation -= parent.rotationX;
        parent = parent.parent;
      }
      return rotation;
    }
    module.exports = {
      getWorldRotation: getWorldRotation,
      getWorldScale: getWorldScale,
      convertToNodeRotation: convertToNodeRotation
    };
  }), {} ],
  145: [ (function(require, module, exports) {
    var js;
    var macro;
    var sys;
    var eventManager;
    var TOUCH_TIMEOUT;
    var bkInputManager;
    false;
  }), {
    "../event-manager": 89,
    "../platform/js": 167,
    "./CCMacro": 152,
    "./CCSys": 156
  } ],
  146: [ (function(require, module, exports) {
    var Asset = require("../assets/CCAsset");
    var callInNextTick = require("./utils").callInNextTick;
    var Loader = require("../load-pipeline/CCLoader");
    var PackDownloader = require("../load-pipeline/pack-downloader");
    var AutoReleaseUtils = require("../load-pipeline/auto-release-utils");
    var decodeUuid = require("../utils/decode-uuid");
    var MD5Pipe = require("../load-pipeline/md5-pipe");
    var js = require("./js");
    var _libraryBase = "";
    var _rawAssetsBase = "";
    var _uuidToRawAsset = js.createMap(true);
    function isScene(asset) {
      return asset && (asset.constructor === cc.SceneAsset || asset instanceof cc.Scene);
    }
    function RawAssetEntry(url, type) {
      this.url = url;
      this.type = type;
    }
    var AssetLibrary = {
      loadAsset: function(uuid, callback, options) {
        if ("string" !== typeof uuid) return callInNextTick(callback, new Error("[AssetLibrary] uuid must be string"), null);
        var item = {
          uuid: uuid,
          type: "uuid"
        };
        options && options.existingAsset && (item.existingAsset = options.existingAsset);
        Loader.load(item, (function(error, asset) {
          if (error || !asset) error = new Error("[AssetLibrary] loading JSON or dependencies failed: " + (error ? error.message : "Unknown error")); else {
            if (asset.constructor === cc.SceneAsset) {
              false;
              var key = cc.loader._getReferenceKey(uuid);
              asset.scene.dependAssets = AutoReleaseUtils.getDependsRecursively(key);
            }
            if (false, isScene(asset)) {
              var id = cc.loader._getReferenceKey(uuid);
              Loader.removeItem(id);
            }
          }
          callback && callback(error, asset);
        }));
      },
      getLibUrlNoExt: function(uuid, inRawAssetsDir) {
        true;
        uuid = decodeUuid(uuid);
        var base = (true, inRawAssetsDir ? _rawAssetsBase + "assets/" : _libraryBase);
        return base + uuid.slice(0, 2) + "/" + uuid;
      },
      _queryAssetInfoInEditor: function(uuid, callback) {
        false;
      },
      _getAssetInfoInRuntime: function(uuid, result) {
        result = result || {
          url: null,
          raw: false
        };
        var info = _uuidToRawAsset[uuid];
        if (info && !js.isChildClassOf(info.type, cc.Asset)) {
          result.url = _rawAssetsBase + info.url;
          result.raw = true;
        } else {
          result.url = this.getLibUrlNoExt(uuid) + ".json";
          result.raw = false;
        }
        return result;
      },
      _uuidInSettings: function(uuid) {
        return uuid in _uuidToRawAsset;
      },
      queryAssetInfo: function(uuid, callback) {
        false;
        var info = this._getAssetInfoInRuntime(uuid);
        callback(null, info.url, info.raw);
      },
      parseUuidInEditor: function(url) {
        var uuid;
        var isImported;
        var dir;
        var dirBasename;
        var isAssetUrl;
        var index;
        false;
      },
      loadJson: function(json, callback) {
        var randomUuid = "" + (new Date().getTime() + Math.random());
        var item = {
          uuid: randomUuid,
          type: "uuid",
          content: json,
          skips: [ Loader.assetLoader.id, Loader.downloader.id ]
        };
        Loader.load(item, (function(error, asset) {
          if (error) error = new Error("[AssetLibrary] loading JSON or dependencies failed: " + error.message); else {
            if (asset.constructor === cc.SceneAsset) {
              var key = cc.loader._getReferenceKey(randomUuid);
              asset.scene.dependAssets = AutoReleaseUtils.getDependsRecursively(key);
            }
            if (false, isScene(asset)) {
              var id = cc.loader._getReferenceKey(randomUuid);
              Loader.removeItem(id);
            }
          }
          asset._uuid = "";
          callback && callback(error, asset);
        }));
      },
      getAssetByUuid: function(uuid) {
        return AssetLibrary._uuidToAsset[uuid] || null;
      },
      init: function(options) {
        false;
        var libraryPath = options.libraryPath;
        libraryPath = libraryPath.replace(/\\/g, "/");
        _libraryBase = cc.path.stripSep(libraryPath) + "/";
        _rawAssetsBase = options.rawAssetsBase;
        var md5AssetsMap = options.md5AssetsMap;
        if (md5AssetsMap && md5AssetsMap.import) {
          var i = 0, uuid = 0;
          var md5ImportMap = js.createMap(true);
          var md5Entries = md5AssetsMap.import;
          for (i = 0; i < md5Entries.length; i += 2) {
            uuid = decodeUuid(md5Entries[i]);
            md5ImportMap[uuid] = md5Entries[i + 1];
          }
          var md5RawAssetsMap = js.createMap(true);
          md5Entries = md5AssetsMap["raw-assets"];
          for (i = 0; i < md5Entries.length; i += 2) {
            uuid = decodeUuid(md5Entries[i]);
            md5RawAssetsMap[uuid] = md5Entries[i + 1];
          }
          var md5Pipe = new MD5Pipe(md5ImportMap, md5RawAssetsMap, _libraryBase);
          cc.loader.insertPipeAfter(cc.loader.assetLoader, md5Pipe);
          cc.loader.md5Pipe = md5Pipe;
        }
        var resources = Loader._resources;
        resources.reset();
        var rawAssets = options.rawAssets;
        if (rawAssets) for (var mountPoint in rawAssets) {
          var assets = rawAssets[mountPoint];
          for (var uuid in assets) {
            var info = assets[uuid];
            var url = info[0];
            var typeId = info[1];
            var type = cc.js._getClassById(typeId);
            if (!type) {
              cc.error("Cannot get", typeId);
              continue;
            }
            _uuidToRawAsset[uuid] = new RawAssetEntry(mountPoint + "/" + url, type);
            if ("assets" === mountPoint) {
              var ext = cc.path.extname(url);
              ext && (url = url.slice(0, -ext.length));
              var isSubAsset = 1 === info[2];
              resources.add(url, uuid, type, !isSubAsset);
            }
          }
        }
        options.packedAssets && PackDownloader.initPacks(options.packedAssets);
        cc.url._init(options.mountPaths && options.mountPaths.assets || _rawAssetsBase + "assets");
      }
    };
    AssetLibrary._uuidToAsset = {};
    module.exports = cc.AssetLibrary = AssetLibrary;
  }), {
    "../assets/CCAsset": 29,
    "../load-pipeline/CCLoader": 100,
    "../load-pipeline/auto-release-utils": 104,
    "../load-pipeline/md5-pipe": 110,
    "../load-pipeline/pack-downloader": 111,
    "../utils/decode-uuid": 203,
    "./js": 167,
    "./utils": 171
  } ],
  147: [ (function(require, module, exports) {
    var js = require("./js");
    var Enum = require("./CCEnum");
    var utils = require("./utils");
    var _isPlainEmptyObj_DEV = utils.isPlainEmptyObj_DEV;
    var _cloneable_DEV = utils.cloneable_DEV;
    var Attr = require("./attribute");
    var DELIMETER = Attr.DELIMETER;
    var getTypeChecker = Attr.getTypeChecker;
    var preprocess = require("./preprocess-class");
    require("./requiring-frame");
    var BUILTIN_ENTRIES = [ "name", "extends", "mixins", "ctor", "__ctor__", "properties", "statics", "editor", "__ES6__" ];
    var INVALID_STATICS_DEV = false;
    function pushUnique(array, item) {
      array.indexOf(item) < 0 && array.push(item);
    }
    var deferredInitializer = {
      datas: null,
      push: function(data) {
        if (this.datas) this.datas.push(data); else {
          this.datas = [ data ];
          var self = this;
          setTimeout((function() {
            self.init();
          }), 0);
        }
      },
      init: function() {
        var datas = this.datas;
        if (datas) {
          for (var i = 0; i < datas.length; ++i) {
            var data = datas[i];
            var cls = data.cls;
            var properties = data.props;
            "function" === typeof properties && (properties = properties());
            var name = js.getClassName(cls);
            properties ? declareProperties(cls, name, properties, cls.$super, data.mixins) : cc.errorID(3633, name);
          }
          this.datas = null;
        }
      }
    };
    function appendProp(cls, name) {
      false;
      pushUnique(cls.__props__, name);
    }
    var tmpArray = [];
    function defineProp(cls, className, propName, val, es6) {
      var defaultValue = val.default;
      false;
      Attr.setClassAttr(cls, propName, "default", defaultValue);
      appendProp(cls, propName);
      var attrs = parseAttributes(cls, val, className, propName, false);
      if (attrs) {
        var onAfterProp = tmpArray;
        for (var i = 0; i < attrs.length; i++) {
          var attr = attrs[i];
          Attr.attr(cls, propName, attr);
          false === attr["serializable"] && pushUnique(cls.__values__, propName);
          attr._onAfterProp && onAfterProp.push(attr._onAfterProp);
        }
        for (var c = 0; c < onAfterProp.length; c++) onAfterProp[c](cls, propName);
        tmpArray.length = 0;
        attrs.length = 0;
      }
    }
    function defineGetSet(cls, name, propName, val, es6) {
      var getter = val.get;
      var setter = val.set;
      var proto = cls.prototype;
      var d = Object.getOwnPropertyDescriptor(proto, propName);
      var setterUndefined = !d;
      if (getter) {
        false;
        var attrs = parseAttributes(cls, val, name, propName, true);
        for (var i = 0; i < attrs.length; i++) Attr.attr(cls, propName, attrs[i]);
        attrs.length = 0;
        Attr.setClassAttr(cls, propName, "serializable", false);
        false;
        es6 || js.get(proto, propName, getter, setterUndefined, setterUndefined);
        false, false;
      }
      if (setter) {
        if (!es6) {
          false;
          js.set(proto, propName, setter, setterUndefined, setterUndefined);
        }
        false, false;
      }
    }
    function getDefault(defaultVal) {
      if ("function" === typeof defaultVal) {
        false;
        return defaultVal();
      }
      return defaultVal;
    }
    function mixinWithInherited(dest, src, filter) {
      for (var prop in src) dest.hasOwnProperty(prop) || filter && !filter(prop) || Object.defineProperty(dest, prop, js.getPropertyDescriptor(src, prop));
    }
    function doDefine(className, baseClass, mixins, options) {
      var shouldAddProtoCtor;
      var __ctor__ = options.__ctor__;
      var ctor = options.ctor;
      var __es6__ = options.__ES6__;
      var ctorToUse;
      false;
      var ctors;
      var fireClass;
      if (__es6__) {
        ctors = [ ctor ];
        fireClass = ctor;
      } else {
        ctors = __ctor__ ? [ __ctor__ ] : _getAllCtors(baseClass, mixins, options);
        fireClass = _createCtor(ctors, baseClass, className, options);
        js.value(fireClass, "extend", (function(options) {
          options.extends = this;
          return CCClass(options);
        }), true);
      }
      js.value(fireClass, "__ctors__", ctors.length > 0 ? ctors : null, true);
      var prototype = fireClass.prototype;
      if (baseClass) {
        if (!__es6__) {
          js.extend(fireClass, baseClass);
          prototype = fireClass.prototype;
        }
        fireClass.$super = baseClass;
        false;
      }
      if (mixins) {
        for (var m = mixins.length - 1; m >= 0; m--) {
          var mixin = mixins[m];
          mixinWithInherited(prototype, mixin.prototype);
          mixinWithInherited(fireClass, mixin, (function(prop) {
            return mixin.hasOwnProperty(prop) && true;
          }));
          CCClass._isCCClass(mixin) && mixinWithInherited(Attr.getClassAttrs(fireClass).constructor.prototype, Attr.getClassAttrs(mixin).constructor.prototype);
        }
        prototype.constructor = fireClass;
      }
      __es6__ || (prototype.__initProps__ = compileProps);
      js.setClassName(className, fireClass);
      return fireClass;
    }
    function define(className, baseClass, mixins, options) {
      var Component = cc.Component;
      var frame = cc._RF.peek();
      if (frame && js.isChildClassOf(baseClass, Component)) {
        if (js.isChildClassOf(frame.cls, Component)) {
          cc.errorID(3615);
          return null;
        }
        false;
        className = className || frame.script;
      }
      var cls = doDefine(className, baseClass, mixins, options);
      if (frame) if (js.isChildClassOf(baseClass, Component)) {
        var uuid = frame.uuid;
        if (uuid) {
          js._setClassId(uuid, cls);
          false;
        }
        frame.cls = cls;
      } else js.isChildClassOf(frame.cls, Component) || (frame.cls = cls);
      return cls;
    }
    function normalizeClassName_DEV(className) {
      var DefaultName = "CCClass";
      if (className) {
        className = className.replace(/^[^$A-Za-z_]/, "_").replace(/[^0-9A-Za-z_$]/g, "_");
        try {
          Function("function " + className + "(){}")();
          return className;
        } catch (e) {}
      }
      return DefaultName;
    }
    function getNewValueTypeCodeJit(value) {
      var clsName = js.getClassName(value);
      var type = value.constructor;
      var res = "new " + clsName + "(";
      for (var i = 0; i < type.__props__.length; i++) {
        var prop = type.__props__[i];
        var propVal = value[prop];
        false;
        res += propVal;
        i < type.__props__.length - 1 && (res += ",");
      }
      return res + ")";
    }
    function escapeForJS(s) {
      return JSON.stringify(s).replace(/\u2028/g, "\\u2028").replace(/\u2029/g, "\\u2029");
    }
    function getInitPropsJit(attrs, propList) {
      var F = [];
      var func = "";
      for (var i = 0; i < propList.length; i++) {
        var prop = propList[i];
        var attrKey = prop + DELIMETER + "default";
        if (attrKey in attrs) {
          var statement;
          statement = IDENTIFIER_RE.test(prop) ? "this." + prop + "=" : "this[" + escapeForJS(prop) + "]=";
          var expression;
          var def = attrs[attrKey];
          if ("object" === typeof def && def) expression = def instanceof cc.ValueType ? getNewValueTypeCodeJit(def) : Array.isArray(def) ? "[]" : "{}"; else if ("function" === typeof def) {
            var index = F.length;
            F.push(def);
            expression = "F[" + index + "]()";
            false;
          } else expression = "string" === typeof def ? escapeForJS(def) : def;
          statement = statement + expression + ";\n";
          func += statement;
        }
      }
      var initProps;
      initProps = 0 === F.length ? Function(func) : Function("F", "return (function(){\n" + func + "})")(F);
      return initProps;
    }
    function getInitProps(attrs, propList) {
      var advancedProps = [];
      var advancedValues = [];
      var simpleProps = [];
      var simpleValues = [];
      for (var i = 0; i < propList.length; ++i) {
        var prop = propList[i];
        var attrKey = prop + DELIMETER + "default";
        if (attrKey in attrs) {
          var def = attrs[attrKey];
          if ("object" === typeof def && def || "function" === typeof def) {
            advancedProps.push(prop);
            advancedValues.push(def);
          } else {
            simpleProps.push(prop);
            simpleValues.push(def);
          }
        }
      }
      return function() {
        for (var _i = 0; _i < simpleProps.length; ++_i) this[simpleProps[_i]] = simpleValues[_i];
        for (var _i2 = 0; _i2 < advancedProps.length; _i2++) {
          var _prop = advancedProps[_i2];
          var expression;
          var def = advancedValues[_i2];
          if ("object" === typeof def) expression = def instanceof cc.ValueType ? def.clone() : Array.isArray(def) ? [] : {}; else {
            false;
            expression = def();
          }
          this[_prop] = expression;
        }
      };
    }
    var IDENTIFIER_RE = /^[A-Za-z_$][0-9A-Za-z_$]*$/;
    function compileProps(actualClass) {
      var attrs = Attr.getClassAttrs(actualClass);
      var propList = actualClass.__props__;
      if (null === propList) {
        deferredInitializer.init();
        propList = actualClass.__props__;
      }
      var initProps = getInitProps(attrs, propList);
      actualClass.prototype.__initProps__ = initProps;
      initProps.call(this);
    }
    var _createCtor = function(ctors, baseClass, className, options) {
      var superCallBounded = baseClass && boundSuperCalls(baseClass, options, className);
      var ctorLen = ctors.length;
      var Class;
      Class = ctorLen > 0 ? superCallBounded ? 2 === ctorLen ? function() {
        this._super = null;
        this.__initProps__(Class);
        ctors[0].apply(this, arguments);
        ctors[1].apply(this, arguments);
      } : function() {
        this._super = null;
        this.__initProps__(Class);
        for (var i = 0; i < ctors.length; ++i) ctors[i].apply(this, arguments);
      } : 3 === ctorLen ? function() {
        this.__initProps__(Class);
        ctors[0].apply(this, arguments);
        ctors[1].apply(this, arguments);
        ctors[2].apply(this, arguments);
      } : function() {
        this.__initProps__(Class);
        var ctors = Class.__ctors__;
        for (var i = 0; i < ctors.length; ++i) ctors[i].apply(this, arguments);
      } : function() {
        superCallBounded && (this._super = null);
        this.__initProps__(Class);
      };
      return Class;
    };
    function _validateCtor_DEV(ctor, baseClass, className, options) {
      var originCtor;
      false;
      !(ctor.length > 0) || className && className.startsWith("cc.") || cc.warnID(3617, className);
      return ctor;
    }
    function _getAllCtors(baseClass, mixins, options) {
      function getCtors(cls) {
        return CCClass._isCCClass(cls) ? cls.__ctors__ || [] : [ cls ];
      }
      var ctors = [];
      var baseOrMixins = [ baseClass ].concat(mixins);
      for (var b = 0; b < baseOrMixins.length; b++) {
        var baseOrMixin = baseOrMixins[b];
        if (baseOrMixin) {
          var baseCtors = getCtors(baseOrMixin);
          for (var c = 0; c < baseCtors.length; c++) pushUnique(ctors, baseCtors[c]);
        }
      }
      var ctor = options.ctor;
      ctor && ctors.push(ctor);
      return ctors;
    }
    var SuperCallReg = /xyz/.test((function() {
      xyz;
    })) ? /\b\._super\b/ : /.*/;
    var SuperCallRegStrict = /xyz/.test((function() {
      xyz;
    })) ? /this\._super\s*\(/ : /(NONE){99}/;
    function boundSuperCalls(baseClass, options, className) {
      var hasSuperCall = false;
      for (var funcName in options) {
        if (BUILTIN_ENTRIES.indexOf(funcName) >= 0) continue;
        var func = options[funcName];
        if ("function" !== typeof func) continue;
        var pd = js.getPropertyDescriptor(baseClass.prototype, funcName);
        if (pd) {
          var superFunc = pd.value;
          if ("function" === typeof superFunc) {
            if (SuperCallReg.test(func)) {
              hasSuperCall = true;
              options[funcName] = (function(superFunc, func) {
                return function() {
                  var tmp = this._super;
                  this._super = superFunc;
                  var ret = func.apply(this, arguments);
                  this._super = tmp;
                  return ret;
                };
              })(superFunc, func);
            }
            continue;
          }
        }
        false;
      }
      return hasSuperCall;
    }
    function declareProperties(cls, className, properties, baseClass, mixins, es6) {
      cls.__props__ = [];
      baseClass && baseClass.__props__ && (cls.__props__ = baseClass.__props__.slice());
      if (mixins) for (var m = 0; m < mixins.length; ++m) {
        var mixin = mixins[m];
        mixin.__props__ && (cls.__props__ = cls.__props__.concat(mixin.__props__.filter((function(x) {
          return cls.__props__.indexOf(x) < 0;
        }))));
      }
      if (properties) {
        preprocess.preprocessAttrs(properties, className, cls, es6);
        for (var propName in properties) {
          var val = properties[propName];
          "default" in val ? defineProp(cls, className, propName, val, es6) : defineGetSet(cls, className, propName, val, es6);
        }
      }
      var attrs = Attr.getClassAttrs(cls);
      cls.__values__ = cls.__props__.filter((function(prop) {
        return false !== attrs[prop + DELIMETER + "serializable"];
      }));
    }
    function CCClass(options) {
      options = options || {};
      var name = options.name;
      var base = options.extends;
      var mixins = options.mixins;
      var cls = define(name, base, mixins, options);
      name || (name = cc.js.getClassName(cls));
      cls._sealed = true;
      base && (base._sealed = false);
      var properties = options.properties;
      if ("function" === typeof properties || base && null === base.__props__ || mixins && mixins.some((function(x) {
        return null === x.__props__;
      }))) {
        false;
        deferredInitializer.push({
          cls: cls,
          props: properties,
          mixins: mixins
        });
        cls.__props__ = cls.__values__ = null;
      } else declareProperties(cls, name, properties, base, options.mixins, options.__ES6__);
      var statics = options.statics;
      if (statics) {
        var staticPropName;
        false;
        for (staticPropName in statics) cls[staticPropName] = statics[staticPropName];
      }
      for (var funcName in options) {
        if (BUILTIN_ENTRIES.indexOf(funcName) >= 0) continue;
        var func = options[funcName];
        if (!preprocess.validateMethodWithProps(func, funcName, name, cls, base)) continue;
        js.value(cls.prototype, funcName, func, true, true);
      }
      var editor = options.editor;
      editor && !!js.isChildClassOf(base, cc.Component) && cc.Component._registerEditorProps(cls, editor);
      return cls;
    }
    CCClass._isCCClass = function(constructor) {
      return constructor && constructor.hasOwnProperty("__ctors__");
    };
    CCClass._fastDefine = function(className, constructor, serializableFields) {
      js.setClassName(className, constructor);
      var props = constructor.__props__ = constructor.__values__ = Object.keys(serializableFields);
      var attrProtos = Attr.getClassAttrsProto(constructor);
      for (var i = 0; i < props.length; i++) {
        var key = props[i];
        attrProtos[key + DELIMETER + "visible"] = false;
        attrProtos[key + DELIMETER + "default"] = serializableFields[key];
      }
    };
    CCClass.Attr = Attr;
    CCClass.attr = Attr.attr;
    CCClass.getInheritanceChain = function(klass) {
      var chain = [];
      for (;;) {
        klass = js.getSuper(klass);
        if (!klass) break;
        klass !== Object && chain.push(klass);
      }
      return chain;
    };
    var PrimitiveTypes = {
      Integer: "Number",
      Float: "Number",
      Boolean: "Boolean",
      String: "String"
    };
    var tmpAttrs = [];
    function parseAttributes(cls, attrs, className, propName, usedInGetter) {
      var ERR_Type = "";
      var attrsProto = null;
      var attrsProtoKey = "";
      function getAttrsProto() {
        attrsProtoKey = propName + DELIMETER;
        return attrsProto = Attr.getClassAttrsProto(cls);
      }
      tmpAttrs.length = 0;
      var result = tmpAttrs;
      var type = attrs.type;
      if (type) {
        var primitiveType = PrimitiveTypes[type];
        if (primitiveType) result.push({
          type: type,
          _onAfterProp: getTypeChecker(primitiveType, "cc." + type)
        }); else if ("Object" === type) false; else if (type === Attr.ScriptUuid) {
          var attr = Attr.ObjectType(cc.ScriptAsset);
          attr.type = "Script";
          result.push(attr);
        } else "object" === typeof type ? !!Enum.isEnum(type) && result.push({
          type: "Enum",
          enumList: Enum.getList(type)
        }) : "function" === typeof type && (attrs.url ? result.push({
          type: "Object",
          ctor: type,
          _onAfterProp: getTypeChecker("String", "cc.String")
        }) : result.push(attrs._short ? {
          type: "Object",
          ctor: type
        } : Attr.ObjectType(type)));
      }
      function parseSimpleAttr(attrName, expectType) {
        if (attrName in attrs) {
          var val = attrs[attrName];
          typeof val === expectType && ((attrsProto || getAttrsProto())[attrsProtoKey + attrName] = val);
        }
      }
      if (attrs.editorOnly) {
        false;
        (attrsProto || getAttrsProto())[attrsProtoKey + "editorOnly"] = true;
      }
      false;
      attrs.url && ((attrsProto || getAttrsProto())[attrsProtoKey + "saveUrlAsAsset"] = true);
      if (false === attrs.serializable) {
        false;
        (attrsProto || getAttrsProto())[attrsProtoKey + "serializable"] = false;
      }
      parseSimpleAttr("formerlySerializedAs", "string");
      false;
      var visible;
      var startsWithUS;
      false;
      var range = attrs.range;
      if (range) if (Array.isArray(range)) if (range.length >= 2) {
        (attrsProto || getAttrsProto())[attrsProtoKey + "min"] = range[0];
        attrsProto[attrsProtoKey + "max"] = range[1];
        range.length > 2 && (attrsProto[attrsProtoKey + "step"] = range[2]);
      } else false; else false;
      parseSimpleAttr("min", "number");
      parseSimpleAttr("max", "number");
      parseSimpleAttr("step", "number");
      return result;
    }
    cc.Class = CCClass;
    module.exports = {
      isArray: function(defaultVal) {
        defaultVal = getDefault(defaultVal);
        return Array.isArray(defaultVal);
      },
      fastDefine: CCClass._fastDefine,
      getNewValueTypeCode: false,
      IDENTIFIER_RE: IDENTIFIER_RE,
      escapeForJS: escapeForJS,
      getDefault: getDefault
    };
    false;
  }), {
    "./CCEnum": 149,
    "./attribute": 159,
    "./js": 167,
    "./preprocess-class": 168,
    "./requiring-frame": 169,
    "./utils": 171
  } ],
  148: [ (function(require, module, exports) {
    require("./CCClass");
    var Preprocess = require("./preprocess-class");
    var js = require("./js");
    var isPlainEmptyObj_DEV = false;
    var CACHE_KEY = "__ccclassCache__";
    function fNOP(ctor) {
      return ctor;
    }
    function getSubDict(obj, key) {
      return obj[key] || (obj[key] = {});
    }
    function checkCtorArgument(decorate) {
      return function(target) {
        if ("function" === typeof target) return decorate(target);
        return function(ctor) {
          return decorate(ctor, target);
        };
      };
    }
    function _checkNormalArgument(validator_DEV, decorate, decoratorName) {
      return function(target) {
        false;
        return function(ctor) {
          return decorate(ctor, target);
        };
      };
    }
    var checkCompArgument = _checkNormalArgument.bind(null, false);
    function _argumentChecker(type) {
      return _checkNormalArgument.bind(null, false);
    }
    var checkStringArgument = _argumentChecker("string");
    var checkNumberArgument = _argumentChecker("number");
    function getClassCache(ctor, decoratorName) {
      false;
      return getSubDict(ctor, CACHE_KEY);
    }
    function getDefaultFromInitializer(initializer) {
      var value;
      try {
        value = initializer();
      } catch (e) {
        return initializer;
      }
      return "object" !== typeof value || null === value ? value : initializer;
    }
    function extractActualDefaultValues(ctor) {
      var dummyObj;
      try {
        dummyObj = new ctor();
      } catch (e) {
        false;
        return {};
      }
      return dummyObj;
    }
    function genProperty(ctor, properties, propName, options, desc, cache) {
      var fullOptions;
      if (options) {
        fullOptions = Preprocess.getFullFormOfProperty(options);
        fullOptions = fullOptions || options;
      }
      var existsProperty = properties[propName];
      var prop = js.mixin(existsProperty || {}, fullOptions || {});
      var isGetset = desc && (desc.get || desc.set);
      if (isGetset) {
        var errorProps;
        false;
        desc.get && (prop.get = desc.get);
        desc.set && (prop.set = desc.set);
      } else {
        false;
        var defaultValue = void 0;
        var isDefaultValueSpecified = false;
        if (desc) {
          if (desc.initializer) {
            defaultValue = getDefaultFromInitializer(desc.initializer);
            isDefaultValueSpecified = true;
          }
        } else {
          var actualDefaultValues = cache.default || (cache.default = extractActualDefaultValues(ctor));
          if (actualDefaultValues.hasOwnProperty(propName)) {
            defaultValue = actualDefaultValues[propName];
            isDefaultValueSpecified = true;
          }
        }
        false;
        prop.default = defaultValue;
      }
      properties[propName] = prop;
    }
    var ccclass = checkCtorArgument((function(ctor, name) {
      var base = js.getSuper(ctor);
      base === Object && (base = null);
      var proto = {
        name: name,
        extends: base,
        ctor: ctor,
        __ES6__: true
      };
      var cache = ctor[CACHE_KEY];
      if (cache) {
        var decoratedProto = cache.proto;
        decoratedProto && js.mixin(proto, decoratedProto);
        ctor[CACHE_KEY] = void 0;
      }
      var res = cc.Class(proto);
      var propNames;
      var i;
      var prop;
      var desc;
      var func;
      false;
      return res;
    }));
    function property(ctorProtoOrOptions, propName, desc) {
      var options = null;
      function normalized(ctorProto, propName, desc) {
        var cache = getClassCache(ctorProto.constructor);
        if (cache) {
          var ccclassProto = getSubDict(cache, "proto");
          var properties = getSubDict(ccclassProto, "properties");
          genProperty(ctorProto.constructor, properties, propName, options, desc, cache);
        }
      }
      if ("undefined" === typeof propName) {
        options = ctorProtoOrOptions;
        return normalized;
      }
      normalized(ctorProtoOrOptions, propName, desc);
    }
    function createEditorDecorator(argCheckFunc, editorPropName, staticValue) {
      return argCheckFunc((function(ctor, decoratedValue) {
        var cache = getClassCache(ctor, editorPropName);
        if (cache) {
          var value = void 0 !== staticValue ? staticValue : decoratedValue;
          var proto = getSubDict(cache, "proto");
          getSubDict(proto, "editor")[editorPropName] = value;
        }
      }), editorPropName);
    }
    function createDummyDecorator(argCheckFunc) {
      return argCheckFunc(fNOP);
    }
    var executeInEditMode = createDummyDecorator(checkCtorArgument, "executeInEditMode", true);
    var requireComponent = createEditorDecorator(checkCompArgument, "requireComponent");
    var menu = createDummyDecorator(checkStringArgument, "menu");
    var executionOrder = createEditorDecorator(checkNumberArgument, "executionOrder");
    var disallowMultiple = createDummyDecorator(checkCtorArgument, "disallowMultiple");
    var playOnFocus = createDummyDecorator(checkCtorArgument, "playOnFocus");
    var inspector = createDummyDecorator(checkStringArgument, "inspector");
    var icon = createDummyDecorator(checkStringArgument, "icon");
    var help = createDummyDecorator(checkStringArgument, "help");
    function mixins() {
      var mixins = [];
      for (var i = 0; i < arguments.length; i++) mixins[i] = arguments[i];
      return function(ctor) {
        var cache = getClassCache(ctor, "mixins");
        cache && (getSubDict(cache, "proto").mixins = mixins);
      };
    }
    cc._decorator = module.exports = {
      ccclass: ccclass,
      property: property,
      executeInEditMode: executeInEditMode,
      requireComponent: requireComponent,
      menu: menu,
      executionOrder: executionOrder,
      disallowMultiple: disallowMultiple,
      playOnFocus: playOnFocus,
      inspector: inspector,
      icon: icon,
      help: help,
      mixins: mixins
    };
  }), {
    "./CCClass": 147,
    "./js": 167,
    "./preprocess-class": 168,
    "./utils": 171
  } ],
  149: [ (function(require, module, exports) {
    var js = require("./js");
    function Enum(obj) {
      if ("__enums__" in obj) return obj;
      js.value(obj, "__enums__", null, true);
      var lastIndex = -1;
      var keys = Object.keys(obj);
      for (var i = 0; i < keys.length; i++) {
        var key = keys[i];
        var val = obj[key];
        if (-1 === val) {
          val = ++lastIndex;
          obj[key] = val;
        } else if ("number" === typeof val) lastIndex = val; else if ("string" === typeof val && Number.isInteger(parseFloat(key))) continue;
        var reverseKey = "" + val;
        if (key !== reverseKey) {
          if ((false, false) && reverseKey in obj && obj[reverseKey] !== key) {
            cc.errorID(7100, reverseKey);
            continue;
          }
          js.value(obj, reverseKey, key);
        }
      }
      return obj;
    }
    Enum.isEnum = function(enumType) {
      return enumType && enumType.hasOwnProperty("__enums__");
    };
    Enum.getList = function(enumDef) {
      if (enumDef.__enums__) return enumDef.__enums__;
      var enums = enumDef.__enums__ = [];
      for (var name in enumDef) {
        var value = enumDef[name];
        Number.isInteger(value) && enums.push({
          name: name,
          value: value
        });
      }
      enums.sort((function(a, b) {
        return a.value - b.value;
      }));
      return enums;
    };
    var _TestEnum;
    false;
    module.exports = cc.Enum = Enum;
  }), {
    "./js": 167
  } ],
  150: [ (function(require, module, exports) {
    var eventManager = require("../event-manager");
    var inputManager = require("./CCInputManager");
    var PORTRAIT = 0;
    var LANDSCAPE_LEFT = -90;
    var PORTRAIT_UPSIDE_DOWN = 180;
    var LANDSCAPE_RIGHT = 90;
    var _didAccelerateFun = void 0;
    cc.Acceleration = function(x, y, z, timestamp) {
      this.x = x || 0;
      this.y = y || 0;
      this.z = z || 0;
      this.timestamp = timestamp || 0;
    };
    inputManager.setAccelerometerEnabled = function(isEnable) {
      var _t = this;
      if (_t._accelEnabled === isEnable) return;
      _t._accelEnabled = isEnable;
      var scheduler = cc.director.getScheduler();
      scheduler.enableForTarget(_t);
      if (_t._accelEnabled) {
        _t._registerAccelerometerEvent();
        _t._accelCurTime = 0;
        scheduler.scheduleUpdate(_t);
      } else {
        _t._unregisterAccelerometerEvent();
        _t._accelCurTime = 0;
        scheduler.unscheduleUpdate(_t);
      }
    };
    inputManager.setAccelerometerInterval = function(interval) {
      this._accelInterval !== interval && (this._accelInterval = interval);
    };
    inputManager._registerKeyboardEvent = function() {
      cc.game.canvas.addEventListener("keydown", (function(e) {
        eventManager.dispatchEvent(new cc.Event.EventKeyboard(e.keyCode, true));
        e.stopPropagation();
        e.preventDefault();
      }), false);
      cc.game.canvas.addEventListener("keyup", (function(e) {
        eventManager.dispatchEvent(new cc.Event.EventKeyboard(e.keyCode, false));
        e.stopPropagation();
        e.preventDefault();
      }), false);
    };
    inputManager._registerAccelerometerEvent = function() {
      var w = window, _t = this;
      _t._acceleration = new cc.Acceleration();
      _t._accelDeviceEvent = w.DeviceMotionEvent || w.DeviceOrientationEvent;
      cc.sys.browserType === cc.sys.BROWSER_TYPE_MOBILE_QQ && (_t._accelDeviceEvent = window.DeviceOrientationEvent);
      var _deviceEventType = _t._accelDeviceEvent === w.DeviceMotionEvent ? "devicemotion" : "deviceorientation";
      var ua = navigator.userAgent;
      (/Android/.test(ua) || /Adr/.test(ua) && cc.sys.browserType === cc.BROWSER_TYPE_UC) && (_t._minus = -1);
      _didAccelerateFun = _t.didAccelerate.bind(_t);
      w.addEventListener(_deviceEventType, _didAccelerateFun, false);
    };
    inputManager._unregisterAccelerometerEvent = function() {
      var w = window, _t = this;
      var _deviceEventType = _t._accelDeviceEvent === w.DeviceMotionEvent ? "devicemotion" : "deviceorientation";
      _didAccelerateFun && w.removeEventListener(_deviceEventType, _didAccelerateFun, false);
    };
    inputManager.didAccelerate = function(eventData) {
      var _t = this, w = window;
      if (!_t._accelEnabled) return;
      var mAcceleration = _t._acceleration;
      var x = void 0, y = void 0, z = void 0;
      if (_t._accelDeviceEvent === window.DeviceMotionEvent) {
        var eventAcceleration = eventData["accelerationIncludingGravity"];
        x = _t._accelMinus * eventAcceleration.x * .1;
        y = _t._accelMinus * eventAcceleration.y * .1;
        z = .1 * eventAcceleration.z;
      } else {
        x = eventData["gamma"] / 90 * .981;
        y = -eventData["beta"] / 90 * .981;
        z = eventData["alpha"] / 90 * .981;
      }
      if (cc.view._isRotated) {
        var tmp = x;
        x = -y;
        y = tmp;
      }
      mAcceleration.x = x;
      mAcceleration.y = y;
      mAcceleration.z = z;
      mAcceleration.timestamp = eventData.timeStamp || Date.now();
      var tmpX = mAcceleration.x;
      if (w.orientation === LANDSCAPE_RIGHT) {
        mAcceleration.x = -mAcceleration.y;
        mAcceleration.y = tmpX;
      } else if (w.orientation === LANDSCAPE_LEFT) {
        mAcceleration.x = mAcceleration.y;
        mAcceleration.y = -tmpX;
      } else if (w.orientation === PORTRAIT_UPSIDE_DOWN) {
        mAcceleration.x = -mAcceleration.x;
        mAcceleration.y = -mAcceleration.y;
      }
      if (cc.sys.os === cc.sys.OS_ANDROID && cc.sys.browserType !== cc.sys.BROWSER_TYPE_MOBILE_QQ) {
        mAcceleration.x = -mAcceleration.x;
        mAcceleration.y = -mAcceleration.y;
      }
    };
  }), {
    "../event-manager": 89,
    "./CCInputManager": 151
  } ],
  151: [ (function(require, module, exports) {
    var macro = require("./CCMacro");
    var sys = require("./CCSys");
    var eventManager = require("../event-manager");
    var TOUCH_TIMEOUT = macro.TOUCH_TIMEOUT;
    var _vec2 = cc.v2();
    var inputManager = {
      _mousePressed: false,
      _isRegisterEvent: false,
      _preTouchPoint: cc.v2(0, 0),
      _prevMousePoint: cc.v2(0, 0),
      _preTouchPool: [],
      _preTouchPoolPointer: 0,
      _touches: [],
      _touchesIntegerDict: {},
      _indexBitsUsed: 0,
      _maxTouches: 8,
      _accelEnabled: false,
      _accelInterval: .2,
      _accelMinus: 1,
      _accelCurTime: 0,
      _acceleration: null,
      _accelDeviceEvent: null,
      _getUnUsedIndex: function() {
        var temp = this._indexBitsUsed;
        var now = cc.sys.now();
        for (var i = 0; i < this._maxTouches; i++) {
          if (!(1 & temp)) {
            this._indexBitsUsed |= 1 << i;
            return i;
          }
          var touch = this._touches[i];
          if (now - touch._lastModified > TOUCH_TIMEOUT) {
            this._removeUsedIndexBit(i);
            delete this._touchesIntegerDict[touch.getID()];
            return i;
          }
          temp >>= 1;
        }
        return -1;
      },
      _removeUsedIndexBit: function(index) {
        if (index < 0 || index >= this._maxTouches) return;
        var temp = 1 << index;
        temp = ~temp;
        this._indexBitsUsed &= temp;
      },
      _glView: null,
      handleTouchesBegin: function(touches) {
        var selTouch = void 0, index = void 0, curTouch = void 0, touchID = void 0, handleTouches = [], locTouchIntDict = this._touchesIntegerDict, now = sys.now();
        for (var i = 0, len = touches.length; i < len; i++) {
          selTouch = touches[i];
          touchID = selTouch.getID();
          index = locTouchIntDict[touchID];
          if (null == index) {
            var unusedIndex = this._getUnUsedIndex();
            if (-1 === unusedIndex) {
              cc.logID(2300, unusedIndex);
              continue;
            }
            curTouch = this._touches[unusedIndex] = new cc.Touch(selTouch._point.x, selTouch._point.y, selTouch.getID());
            curTouch._lastModified = now;
            curTouch._setPrevPoint(selTouch._prevPoint);
            locTouchIntDict[touchID] = unusedIndex;
            handleTouches.push(curTouch);
          }
        }
        if (handleTouches.length > 0) {
          this._glView._convertTouchesWithScale(handleTouches);
          var touchEvent = new cc.Event.EventTouch(handleTouches);
          touchEvent._eventCode = cc.Event.EventTouch.BEGAN;
          eventManager.dispatchEvent(touchEvent);
        }
      },
      handleTouchesMove: function(touches) {
        var selTouch = void 0, index = void 0, touchID = void 0, handleTouches = [], locTouches = this._touches, now = sys.now();
        for (var i = 0, len = touches.length; i < len; i++) {
          selTouch = touches[i];
          touchID = selTouch.getID();
          index = this._touchesIntegerDict[touchID];
          if (null == index) continue;
          if (locTouches[index]) {
            locTouches[index]._setPoint(selTouch._point);
            locTouches[index]._setPrevPoint(selTouch._prevPoint);
            locTouches[index]._lastModified = now;
            handleTouches.push(locTouches[index]);
          }
        }
        if (handleTouches.length > 0) {
          this._glView._convertTouchesWithScale(handleTouches);
          var touchEvent = new cc.Event.EventTouch(handleTouches);
          touchEvent._eventCode = cc.Event.EventTouch.MOVED;
          eventManager.dispatchEvent(touchEvent);
        }
      },
      handleTouchesEnd: function(touches) {
        var handleTouches = this.getSetOfTouchesEndOrCancel(touches);
        if (handleTouches.length > 0) {
          this._glView._convertTouchesWithScale(handleTouches);
          var touchEvent = new cc.Event.EventTouch(handleTouches);
          touchEvent._eventCode = cc.Event.EventTouch.ENDED;
          eventManager.dispatchEvent(touchEvent);
        }
      },
      handleTouchesCancel: function(touches) {
        var handleTouches = this.getSetOfTouchesEndOrCancel(touches);
        if (handleTouches.length > 0) {
          this._glView._convertTouchesWithScale(handleTouches);
          var touchEvent = new cc.Event.EventTouch(handleTouches);
          touchEvent._eventCode = cc.Event.EventTouch.CANCELLED;
          eventManager.dispatchEvent(touchEvent);
        }
      },
      getSetOfTouchesEndOrCancel: function(touches) {
        var selTouch = void 0, index = void 0, touchID = void 0, handleTouches = [], locTouches = this._touches, locTouchesIntDict = this._touchesIntegerDict;
        for (var i = 0, len = touches.length; i < len; i++) {
          selTouch = touches[i];
          touchID = selTouch.getID();
          index = locTouchesIntDict[touchID];
          if (null == index) continue;
          if (locTouches[index]) {
            locTouches[index]._setPoint(selTouch._point);
            locTouches[index]._setPrevPoint(selTouch._prevPoint);
            handleTouches.push(locTouches[index]);
            this._removeUsedIndexBit(index);
            delete locTouchesIntDict[touchID];
          }
        }
        return handleTouches;
      },
      getHTMLElementPosition: function(element) {
        if (sys.platform === sys.WECHAT_GAME) return {
          left: 0,
          top: 0,
          width: window.innerWidth,
          height: window.innerHeight
        };
        var docElem = document.documentElement;
        var leftOffset = window.pageXOffset - docElem.clientLeft;
        var topOffset = window.pageYOffset - docElem.clientTop;
        if (element.getBoundingClientRect) {
          var box = element.getBoundingClientRect();
          return {
            left: box.left + leftOffset,
            top: box.top + topOffset,
            width: box.width,
            height: box.height
          };
        }
        return element instanceof HTMLCanvasElement ? {
          left: leftOffset,
          top: topOffset,
          width: element.width,
          height: element.height
        } : {
          left: leftOffset,
          top: topOffset,
          width: parseInt(element.style.width),
          height: parseInt(element.style.height)
        };
      },
      getPreTouch: function(touch) {
        var preTouch = null;
        var locPreTouchPool = this._preTouchPool;
        var id = touch.getID();
        for (var i = locPreTouchPool.length - 1; i >= 0; i--) if (locPreTouchPool[i].getID() === id) {
          preTouch = locPreTouchPool[i];
          break;
        }
        preTouch || (preTouch = touch);
        return preTouch;
      },
      setPreTouch: function(touch) {
        var find = false;
        var locPreTouchPool = this._preTouchPool;
        var id = touch.getID();
        for (var i = locPreTouchPool.length - 1; i >= 0; i--) if (locPreTouchPool[i].getID() === id) {
          locPreTouchPool[i] = touch;
          find = true;
          break;
        }
        if (!find) if (locPreTouchPool.length <= 50) locPreTouchPool.push(touch); else {
          locPreTouchPool[this._preTouchPoolPointer] = touch;
          this._preTouchPoolPointer = (this._preTouchPoolPointer + 1) % 50;
        }
      },
      getTouchByXY: function(tx, ty, pos) {
        var locPreTouch = this._preTouchPoint;
        var location = this._glView.convertToLocationInView(tx, ty, pos);
        var touch = new cc.Touch(location.x, location.y, 0);
        touch._setPrevPoint(locPreTouch.x, locPreTouch.y);
        locPreTouch.x = location.x;
        locPreTouch.y = location.y;
        return touch;
      },
      getMouseEvent: function(location, pos, eventType) {
        var locPreMouse = this._prevMousePoint;
        var mouseEvent = new cc.Event.EventMouse(eventType);
        mouseEvent._setPrevCursor(locPreMouse.x, locPreMouse.y);
        locPreMouse.x = location.x;
        locPreMouse.y = location.y;
        this._glView._convertMouseToLocationInView(locPreMouse, pos);
        mouseEvent.setLocation(locPreMouse.x, locPreMouse.y);
        return mouseEvent;
      },
      getPointByEvent: function(event, pos) {
        if (null != event.pageX) return {
          x: event.pageX,
          y: event.pageY
        };
        if (sys.platform === sys.WECHAT_GAME) {
          pos.left = 0;
          pos.top = 0;
        } else {
          pos.left -= document.body.scrollLeft;
          pos.top -= document.body.scrollTop;
        }
        return {
          x: event.clientX,
          y: event.clientY
        };
      },
      getTouchesByEvent: function(event, pos) {
        var touchArr = [], locView = this._glView;
        var touch_event = void 0, touch = void 0, preLocation = void 0;
        var locPreTouch = this._preTouchPoint;
        var length = event.changedTouches.length;
        for (var i = 0; i < length; i++) {
          touch_event = event.changedTouches[i];
          if (touch_event) {
            var location = void 0;
            location = sys.BROWSER_TYPE_FIREFOX === sys.browserType ? locView.convertToLocationInView(touch_event.pageX, touch_event.pageY, pos, _vec2) : locView.convertToLocationInView(touch_event.clientX, touch_event.clientY, pos, _vec2);
            if (null != touch_event.identifier) {
              touch = new cc.Touch(location.x, location.y, touch_event.identifier);
              preLocation = this.getPreTouch(touch).getLocation();
              touch._setPrevPoint(preLocation.x, preLocation.y);
              this.setPreTouch(touch);
            } else {
              touch = new cc.Touch(location.x, location.y);
              touch._setPrevPoint(locPreTouch.x, locPreTouch.y);
            }
            locPreTouch.x = location.x;
            locPreTouch.y = location.y;
            touchArr.push(touch);
          }
        }
        return touchArr;
      },
      registerSystemEvent: function(element) {
        if (this._isRegisterEvent) return;
        this._glView = cc.view;
        var selfPointer = this;
        var prohibition = sys.isMobile;
        var supportMouse = "mouse" in sys.capabilities;
        var supportTouches = "touches" in sys.capabilities;
        if (sys.platform === sys.WECHAT_GAME) {
          prohibition = false;
          supportTouches = true;
          supportMouse = false;
        }
        if (supportMouse) {
          if (!prohibition) {
            window.addEventListener("mousedown", (function() {
              selfPointer._mousePressed = true;
            }), false);
            window.addEventListener("mouseup", (function(event) {
              if (!selfPointer._mousePressed) return;
              selfPointer._mousePressed = false;
              var pos = selfPointer.getHTMLElementPosition(element);
              var location = selfPointer.getPointByEvent(event, pos);
              if (!cc.rect(pos.left, pos.top, pos.width, pos.height).contains(location)) {
                selfPointer.handleTouchesEnd([ selfPointer.getTouchByXY(location.x, location.y, pos) ]);
                var mouseEvent = selfPointer.getMouseEvent(location, pos, cc.Event.EventMouse.UP);
                mouseEvent.setButton(event.button);
                eventManager.dispatchEvent(mouseEvent);
              }
            }), false);
          }
          var EventMouse = cc.Event.EventMouse;
          var _mouseEventsOnElement = [ !prohibition && [ "mousedown", EventMouse.DOWN, function(event, mouseEvent, location, pos) {
            selfPointer._mousePressed = true;
            selfPointer.handleTouchesBegin([ selfPointer.getTouchByXY(location.x, location.y, pos) ]);
            element.focus();
          } ], !prohibition && [ "mouseup", EventMouse.UP, function(event, mouseEvent, location, pos) {
            selfPointer._mousePressed = false;
            selfPointer.handleTouchesEnd([ selfPointer.getTouchByXY(location.x, location.y, pos) ]);
          } ], !prohibition && [ "mousemove", EventMouse.MOVE, function(event, mouseEvent, location, pos) {
            selfPointer.handleTouchesMove([ selfPointer.getTouchByXY(location.x, location.y, pos) ]);
            selfPointer._mousePressed || mouseEvent.setButton(null);
          } ], [ "mousewheel", EventMouse.SCROLL, function(event, mouseEvent) {
            mouseEvent.setScrollData(0, event.wheelDelta);
          } ], [ "DOMMouseScroll", EventMouse.SCROLL, function(event, mouseEvent) {
            mouseEvent.setScrollData(0, -120 * event.detail);
          } ] ];
          for (var i = 0; i < _mouseEventsOnElement.length; ++i) {
            var entry = _mouseEventsOnElement[i];
            entry && (function() {
              var name = entry[0];
              var type = entry[1];
              var handler = entry[2];
              element.addEventListener(name, (function(event) {
                var pos = selfPointer.getHTMLElementPosition(element);
                var location = selfPointer.getPointByEvent(event, pos);
                var mouseEvent = selfPointer.getMouseEvent(location, pos, type);
                mouseEvent.setButton(event.button);
                handler(event, mouseEvent, location, pos);
                eventManager.dispatchEvent(mouseEvent);
                event.stopPropagation();
                event.preventDefault();
              }), false);
            })();
          }
        }
        if (window.navigator.msPointerEnabled) {
          var _pointerEventsMap = {
            MSPointerDown: selfPointer.handleTouchesBegin,
            MSPointerMove: selfPointer.handleTouchesMove,
            MSPointerUp: selfPointer.handleTouchesEnd,
            MSPointerCancel: selfPointer.handleTouchesCancel
          };
          var _loop = function(eventName) {
            var touchEvent = _pointerEventsMap[eventName];
            element.addEventListener(eventName, (function(event) {
              var pos = selfPointer.getHTMLElementPosition(element);
              pos.left -= document.documentElement.scrollLeft;
              pos.top -= document.documentElement.scrollTop;
              touchEvent.call(selfPointer, [ selfPointer.getTouchByXY(event.clientX, event.clientY, pos) ]);
              event.stopPropagation();
            }), false);
          };
          for (var eventName in _pointerEventsMap) _loop(eventName);
        }
        supportTouches && (function() {
          var _touchEventsMap = {
            touchstart: function(touchesToHandle) {
              selfPointer.handleTouchesBegin(touchesToHandle);
              sys.platform !== sys.WECHAT_GAME && element.focus();
            },
            touchmove: function(touchesToHandle) {
              selfPointer.handleTouchesMove(touchesToHandle);
            },
            touchend: function(touchesToHandle) {
              selfPointer.handleTouchesEnd(touchesToHandle);
            },
            touchcancel: function(touchesToHandle) {
              selfPointer.handleTouchesCancel(touchesToHandle);
            }
          };
          var registerTouchEvent = void 0;
          if (cc.sys.browserType === cc.sys.BROWSER_TYPE_WECHAT_GAME_SUB) {
            _touchEventsMap = {
              onTouchStart: _touchEventsMap.touchstart,
              onTouchMove: _touchEventsMap.touchmove,
              onTouchEnd: _touchEventsMap.touchend,
              onTouchCancel: _touchEventsMap.touchcancel
            };
            registerTouchEvent = function(eventName) {
              var handler = _touchEventsMap[eventName];
              wx[eventName]((function(event) {
                if (!event.changedTouches) return;
                var pos = selfPointer.getHTMLElementPosition(element);
                var body = document.body;
                pos.left -= body.scrollLeft || 0;
                pos.top -= body.scrollTop || 0;
                handler(selfPointer.getTouchesByEvent(event, pos));
              }));
            };
          } else registerTouchEvent = function(eventName) {
            var handler = _touchEventsMap[eventName];
            element.addEventListener(eventName, (function(event) {
              if (!event.changedTouches) return;
              var pos = selfPointer.getHTMLElementPosition(element);
              var body = document.body;
              pos.left -= body.scrollLeft || 0;
              pos.top -= body.scrollTop || 0;
              handler(selfPointer.getTouchesByEvent(event, pos));
              event.stopPropagation();
              event.preventDefault();
            }), false);
          };
          for (var eventName in _touchEventsMap) registerTouchEvent(eventName);
        })();
        cc.sys.browserType !== cc.sys.BROWSER_TYPE_WECHAT_GAME_SUB && this._registerKeyboardEvent();
        this._isRegisterEvent = true;
      },
      _registerKeyboardEvent: function() {},
      _registerAccelerometerEvent: function() {},
      update: function(dt) {
        if (this._accelCurTime > this._accelInterval) {
          this._accelCurTime -= this._accelInterval;
          eventManager.dispatchEvent(new cc.Event.EventAcceleration(this._acceleration));
        }
        this._accelCurTime += dt;
      }
    };
    module.exports = _cc.inputManager = inputManager;
  }), {
    "../event-manager": 89,
    "./CCMacro": 152,
    "./CCSys": 156
  } ],
  152: [ (function(require, module, exports) {
    var js = require("./js");
    cc.macro = {
      RAD: Math.PI / 180,
      DEG: 180 / Math.PI,
      REPEAT_FOREVER: Number.MAX_VALUE - 1,
      FLT_EPSILON: 1.192092896e-7,
      MIN_ZINDEX: -Math.pow(2, 15),
      MAX_ZINDEX: Math.pow(2, 15) - 1,
      ONE: 1,
      ZERO: 0,
      SRC_ALPHA: 770,
      SRC_ALPHA_SATURATE: 776,
      SRC_COLOR: 768,
      DST_ALPHA: 772,
      DST_COLOR: 774,
      ONE_MINUS_SRC_ALPHA: 771,
      ONE_MINUS_SRC_COLOR: 769,
      ONE_MINUS_DST_ALPHA: 773,
      ONE_MINUS_DST_COLOR: 775,
      ONE_MINUS_CONSTANT_ALPHA: 32772,
      ONE_MINUS_CONSTANT_COLOR: 32770,
      ORIENTATION_PORTRAIT: 1,
      ORIENTATION_LANDSCAPE: 2,
      ORIENTATION_AUTO: 3,
      DENSITYDPI_DEVICE: "device-dpi",
      DENSITYDPI_HIGH: "high-dpi",
      DENSITYDPI_MEDIUM: "medium-dpi",
      DENSITYDPI_LOW: "low-dpi",
      FIX_ARTIFACTS_BY_STRECHING_TEXEL_TMX: true,
      DIRECTOR_STATS_POSITION: cc.v2(0, 0),
      ENABLE_STACKABLE_ACTIONS: true,
      TOUCH_TIMEOUT: 5e3,
      BATCH_VERTEX_COUNT: 2e4,
      ENABLE_TILEDMAP_CULLING: true,
      DOWNLOAD_MAX_CONCURRENT: 64,
      ENABLE_TRANSPARENT_CANVAS: false,
      ENABLE_WEBGL_ANTIALIAS: false,
      ENABLE_CULLING: false,
      CLEANUP_IMAGE_CACHE: false
    };
    js.getset(cc.macro, "ENABLE_3D", (function() {
      return cc._polyfill3D.enabled;
    }), (function(enabled) {
      enabled ? cc._polyfill3D.enable() : cc._polyfill3D.disable();
    }));
    cc.macro.KEY = {
      none: 0,
      back: 6,
      menu: 18,
      backspace: 8,
      tab: 9,
      enter: 13,
      shift: 16,
      ctrl: 17,
      alt: 18,
      pause: 19,
      capslock: 20,
      escape: 27,
      space: 32,
      pageup: 33,
      pagedown: 34,
      end: 35,
      home: 36,
      left: 37,
      up: 38,
      right: 39,
      down: 40,
      select: 41,
      insert: 45,
      Delete: 46,
      0: 48,
      1: 49,
      2: 50,
      3: 51,
      4: 52,
      5: 53,
      6: 54,
      7: 55,
      8: 56,
      9: 57,
      a: 65,
      b: 66,
      c: 67,
      d: 68,
      e: 69,
      f: 70,
      g: 71,
      h: 72,
      i: 73,
      j: 74,
      k: 75,
      l: 76,
      m: 77,
      n: 78,
      o: 79,
      p: 80,
      q: 81,
      r: 82,
      s: 83,
      t: 84,
      u: 85,
      v: 86,
      w: 87,
      x: 88,
      y: 89,
      z: 90,
      num0: 96,
      num1: 97,
      num2: 98,
      num3: 99,
      num4: 100,
      num5: 101,
      num6: 102,
      num7: 103,
      num8: 104,
      num9: 105,
      "*": 106,
      "+": 107,
      "-": 109,
      numdel: 110,
      "/": 111,
      f1: 112,
      f2: 113,
      f3: 114,
      f4: 115,
      f5: 116,
      f6: 117,
      f7: 118,
      f8: 119,
      f9: 120,
      f10: 121,
      f11: 122,
      f12: 123,
      numlock: 144,
      scrolllock: 145,
      ";": 186,
      semicolon: 186,
      equal: 187,
      "=": 187,
      ",": 188,
      comma: 188,
      dash: 189,
      ".": 190,
      period: 190,
      forwardslash: 191,
      grave: 192,
      "[": 219,
      openbracket: 219,
      backslash: 220,
      "]": 221,
      closebracket: 221,
      quote: 222,
      dpadLeft: 1e3,
      dpadRight: 1001,
      dpadUp: 1003,
      dpadDown: 1004,
      dpadCenter: 1005
    };
    cc.macro.ImageFormat = cc.Enum({
      JPG: 0,
      PNG: 1,
      TIFF: 2,
      WEBP: 3,
      PVR: 4,
      ETC: 5,
      S3TC: 6,
      ATITC: 7,
      TGA: 8,
      RAWDATA: 9,
      UNKNOWN: 10
    });
    cc.macro.BlendFactor = cc.Enum({
      ONE: 1,
      ZERO: 0,
      SRC_ALPHA: 770,
      SRC_COLOR: 768,
      DST_ALPHA: 772,
      DST_COLOR: 774,
      ONE_MINUS_SRC_ALPHA: 771,
      ONE_MINUS_SRC_COLOR: 769,
      ONE_MINUS_DST_ALPHA: 773,
      ONE_MINUS_DST_COLOR: 775
    });
    cc.macro.TextAlignment = cc.Enum({
      LEFT: 0,
      CENTER: 1,
      RIGHT: 2
    });
    cc.macro.VerticalTextAlignment = cc.Enum({
      TOP: 0,
      CENTER: 1,
      BOTTOM: 2
    });
    module.exports = cc.macro;
  }), {
    "./js": 167
  } ],
  153: [ (function(require, module, exports) {
    var js = require("./js");
    var CCClass = require("./CCClass");
    var Destroyed = 1;
    var RealDestroyed = 2;
    var ToDestroy = 4;
    var DontSave = 8;
    var EditorOnly = 16;
    var Dirty = 32;
    var DontDestroy = 64;
    var Destroying = 128;
    var Deactivating = 256;
    var LockedInEditor = 512;
    var IsOnEnableCalled = 2048;
    var IsEditorOnEnableCalled = 4096;
    var IsPreloadStarted = 8192;
    var IsOnLoadCalled = 16384;
    var IsOnLoadStarted = 32768;
    var IsStartCalled = 65536;
    var IsRotationLocked = 1 << 17;
    var IsScaleLocked = 1 << 18;
    var IsAnchorLocked = 1 << 19;
    var IsSizeLocked = 1 << 20;
    var IsPositionLocked = 1 << 21;
    var PersistentMask = ~(ToDestroy | Dirty | Destroying | DontDestroy | Deactivating | IsPreloadStarted | IsOnLoadStarted | IsOnLoadCalled | IsStartCalled | IsOnEnableCalled | IsEditorOnEnableCalled | IsRotationLocked | IsScaleLocked | IsAnchorLocked | IsSizeLocked | IsPositionLocked);
    function CCObject() {
      this._name = "";
      this._objFlags = 0;
    }
    CCClass.fastDefine("cc.Object", CCObject, {
      _name: "",
      _objFlags: 0
    });
    js.value(CCObject, "Flags", {
      Destroyed: Destroyed,
      DontSave: DontSave,
      EditorOnly: EditorOnly,
      Dirty: Dirty,
      DontDestroy: DontDestroy,
      PersistentMask: PersistentMask,
      Destroying: Destroying,
      Deactivating: Deactivating,
      LockedInEditor: LockedInEditor,
      IsPreloadStarted: IsPreloadStarted,
      IsOnLoadStarted: IsOnLoadStarted,
      IsOnLoadCalled: IsOnLoadCalled,
      IsOnEnableCalled: IsOnEnableCalled,
      IsStartCalled: IsStartCalled,
      IsEditorOnEnableCalled: IsEditorOnEnableCalled,
      IsPositionLocked: IsPositionLocked,
      IsRotationLocked: IsRotationLocked,
      IsScaleLocked: IsScaleLocked,
      IsAnchorLocked: IsAnchorLocked,
      IsSizeLocked: IsSizeLocked
    });
    var objectsToDestroy = [];
    function deferredDestroy() {
      var deleteCount = objectsToDestroy.length;
      for (var i = 0; i < deleteCount; ++i) {
        var obj = objectsToDestroy[i];
        obj._objFlags & Destroyed || obj._destroyImmediate();
      }
      deleteCount === objectsToDestroy.length ? objectsToDestroy.length = 0 : objectsToDestroy.splice(0, deleteCount);
      false;
    }
    js.value(CCObject, "_deferredDestroy", deferredDestroy);
    false;
    var prototype = CCObject.prototype;
    js.getset(prototype, "name", (function() {
      return this._name;
    }), (function(value) {
      this._name = value;
    }), true);
    js.get(prototype, "isValid", (function() {
      return !(this._objFlags & Destroyed);
    }), true);
    false, false;
    var deferredDestroyTimer = null;
    prototype.destroy = function() {
      if (this._objFlags & Destroyed) {
        cc.warnID(5e3);
        return false;
      }
      if (this._objFlags & ToDestroy) return false;
      this._objFlags |= ToDestroy;
      objectsToDestroy.push(this);
      false;
      return true;
    };
    false, false;
    function compileDestruct(obj, ctor) {
      var shouldSkipId = obj instanceof cc._BaseNode || obj instanceof cc.Component;
      var idToSkip = shouldSkipId ? "_id" : null;
      var key, propsToReset = {};
      for (key in obj) if (obj.hasOwnProperty(key)) {
        if (key === idToSkip) continue;
        switch (typeof obj[key]) {
         case "string":
          propsToReset[key] = "";
          break;

         case "object":
         case "function":
          propsToReset[key] = null;
        }
      }
      if (cc.Class._isCCClass(ctor)) {
        var attrs = cc.Class.Attr.getClassAttrs(ctor);
        var propList = ctor.__props__;
        for (var i = 0; i < propList.length; i++) {
          key = propList[i];
          var attrKey = key + cc.Class.Attr.DELIMETER + "default";
          if (attrKey in attrs) {
            if (shouldSkipId && "_id" === key) continue;
            switch (typeof attrs[attrKey]) {
             case "string":
              propsToReset[key] = "";
              break;

             case "object":
             case "function":
              propsToReset[key] = null;
              break;

             case "undefined":
              propsToReset[key] = void 0;
            }
          }
        }
      }
      var func;
      var statement;
      var val;
      false;
      return function(o) {
        for (var key in propsToReset) o[key] = propsToReset[key];
      };
    }
    prototype._destruct = function() {
      var ctor = this.constructor;
      var destruct = ctor.__destruct__;
      if (!destruct) {
        destruct = compileDestruct(this, ctor);
        js.value(ctor, "__destruct__", destruct, true);
      }
      destruct(this);
    };
    prototype._onPreDestroy = null;
    prototype._destroyImmediate = function() {
      if (this._objFlags & Destroyed) {
        cc.errorID(5e3);
        return;
      }
      this._onPreDestroy && this._onPreDestroy();
      true;
      this._destruct();
      this._objFlags |= Destroyed;
    };
    false;
    prototype._deserialize = null;
    cc.isValid = function(value, strictMode) {
      return "object" === typeof value ? !!value && !(value._objFlags & (strictMode ? Destroyed | ToDestroy : Destroyed)) : "undefined" !== typeof value;
    };
    false, false;
    cc.Object = module.exports = CCObject;
  }), {
    "./CCClass": 147,
    "./js": 167
  } ],
  154: [ (function(require, module, exports) {
    var js = require("../platform/js");
    cc.SAXParser = function() {
      if (true, window.DOMParser) {
        this._isSupportDOMParser = true;
        this._parser = new DOMParser();
      } else {
        this._isSupportDOMParser = false;
        this._parser = null;
      }
    };
    cc.SAXParser.prototype = {
      constructor: cc.SAXParser,
      parse: function(xmlTxt) {
        return this._parseXML(xmlTxt);
      },
      _parseXML: function(textxml) {
        var xmlDoc;
        if (this._isSupportDOMParser) xmlDoc = this._parser.parseFromString(textxml, "text/xml"); else {
          xmlDoc = new ActiveXObject("Microsoft.XMLDOM");
          xmlDoc.async = "false";
          xmlDoc.loadXML(textxml);
        }
        return xmlDoc;
      }
    };
    cc.PlistParser = function() {
      cc.SAXParser.call(this);
    };
    js.extend(cc.PlistParser, cc.SAXParser);
    js.mixin(cc.PlistParser.prototype, {
      parse: function(xmlTxt) {
        var xmlDoc = this._parseXML(xmlTxt);
        var plist = xmlDoc.documentElement;
        if ("plist" !== plist.tagName) {
          cc.warnID(5100);
          return {};
        }
        var node = null;
        for (var i = 0, len = plist.childNodes.length; i < len; i++) {
          node = plist.childNodes[i];
          if (1 === node.nodeType) break;
        }
        xmlDoc = null;
        return this._parseNode(node);
      },
      _parseNode: function(node) {
        var data = null, tagName = node.tagName;
        if ("dict" === tagName) data = this._parseDict(node); else if ("array" === tagName) data = this._parseArray(node); else if ("string" === tagName) if (1 === node.childNodes.length) data = node.firstChild.nodeValue; else {
          data = "";
          for (var i = 0; i < node.childNodes.length; i++) data += node.childNodes[i].nodeValue;
        } else "false" === tagName ? data = false : "true" === tagName ? data = true : "real" === tagName ? data = parseFloat(node.firstChild.nodeValue) : "integer" === tagName && (data = parseInt(node.firstChild.nodeValue, 10));
        return data;
      },
      _parseArray: function(node) {
        var data = [];
        for (var i = 0, len = node.childNodes.length; i < len; i++) {
          var child = node.childNodes[i];
          if (1 !== child.nodeType) continue;
          data.push(this._parseNode(child));
        }
        return data;
      },
      _parseDict: function(node) {
        var data = {};
        var key = null;
        for (var i = 0, len = node.childNodes.length; i < len; i++) {
          var child = node.childNodes[i];
          if (1 !== child.nodeType) continue;
          "key" === child.tagName ? key = child.firstChild.nodeValue : data[key] = this._parseNode(child);
        }
        return data;
      }
    });
    cc.saxParser = new cc.SAXParser();
    cc.plistParser = new cc.PlistParser();
    module.exports = {
      saxParser: cc.saxParser,
      plistParser: cc.plistParser
    };
  }), {
    "../platform/js": 167
  } ],
  155: [ (function(require, module, exports) {
    cc.screen = {
      _supportsFullScreen: false,
      _preOnFullScreenChange: null,
      _touchEvent: "",
      _fn: null,
      _fnMap: [ [ "requestFullscreen", "exitFullscreen", "fullscreenchange", "fullscreenEnabled", "fullscreenElement" ], [ "requestFullScreen", "exitFullScreen", "fullScreenchange", "fullScreenEnabled", "fullScreenElement" ], [ "webkitRequestFullScreen", "webkitCancelFullScreen", "webkitfullscreenchange", "webkitIsFullScreen", "webkitCurrentFullScreenElement" ], [ "mozRequestFullScreen", "mozCancelFullScreen", "mozfullscreenchange", "mozFullScreen", "mozFullScreenElement" ], [ "msRequestFullscreen", "msExitFullscreen", "MSFullscreenChange", "msFullscreenEnabled", "msFullscreenElement" ] ],
      init: function() {
        this._fn = {};
        var i, l, val, map = this._fnMap, valL;
        for (i = 0, l = map.length; i < l; i++) {
          val = map[i];
          if (val && "undefined" !== typeof document[val[1]]) {
            for (i = 0, valL = val.length; i < valL; i++) this._fn[map[0][i]] = val[i];
            break;
          }
        }
        this._supportsFullScreen = void 0 !== this._fn.requestFullscreen;
        this._touchEvent = "ontouchstart" in window ? "touchstart" : "mousedown";
      },
      fullScreen: function() {
        return !!this._supportsFullScreen && (void 0 !== document[this._fn.fullscreenElement] && null !== document[this._fn.fullscreenElement]);
      },
      requestFullScreen: function(element, onFullScreenChange) {
        if (!this._supportsFullScreen) return;
        element = element || document.documentElement;
        if (onFullScreenChange) {
          var eventName = this._fn.fullscreenchange;
          this._preOnFullScreenChange && document.removeEventListener(eventName, this._preOnFullScreenChange);
          this._preOnFullScreenChange = onFullScreenChange;
          document.addEventListener(eventName, onFullScreenChange, false);
        }
        return element[this._fn.requestFullscreen]();
      },
      exitFullScreen: function() {
        return !this._supportsFullScreen || document[this._fn.exitFullscreen]();
      },
      autoFullScreen: function(element, onFullScreenChange) {
        element = element || document.body;
        var touchTarget = cc.game.canvas || element;
        var theScreen = this;
        function callback() {
          touchTarget.removeEventListener(theScreen._touchEvent, callback);
          theScreen.requestFullScreen(element, onFullScreenChange);
        }
        this.requestFullScreen(element, onFullScreenChange);
        touchTarget.addEventListener(this._touchEvent, callback);
      }
    };
    cc.screen.init();
  }), {} ],
  156: [ (function(require, module, exports) {
    function initSys() {
      cc.sys = {};
      var sys = cc.sys;
      sys.LANGUAGE_ENGLISH = "en";
      sys.LANGUAGE_CHINESE = "zh";
      sys.LANGUAGE_FRENCH = "fr";
      sys.LANGUAGE_ITALIAN = "it";
      sys.LANGUAGE_GERMAN = "de";
      sys.LANGUAGE_SPANISH = "es";
      sys.LANGUAGE_DUTCH = "du";
      sys.LANGUAGE_RUSSIAN = "ru";
      sys.LANGUAGE_KOREAN = "ko";
      sys.LANGUAGE_JAPANESE = "ja";
      sys.LANGUAGE_HUNGARIAN = "hu";
      sys.LANGUAGE_PORTUGUESE = "pt";
      sys.LANGUAGE_ARABIC = "ar";
      sys.LANGUAGE_NORWEGIAN = "no";
      sys.LANGUAGE_POLISH = "pl";
      sys.LANGUAGE_TURKISH = "tr";
      sys.LANGUAGE_UKRAINIAN = "uk";
      sys.LANGUAGE_ROMANIAN = "ro";
      sys.LANGUAGE_BULGARIAN = "bg";
      sys.LANGUAGE_UNKNOWN = "unknown";
      sys.OS_IOS = "iOS";
      sys.OS_ANDROID = "Android";
      sys.OS_WINDOWS = "Windows";
      sys.OS_MARMALADE = "Marmalade";
      sys.OS_LINUX = "Linux";
      sys.OS_BADA = "Bada";
      sys.OS_BLACKBERRY = "Blackberry";
      sys.OS_OSX = "OS X";
      sys.OS_WP8 = "WP8";
      sys.OS_WINRT = "WINRT";
      sys.OS_UNKNOWN = "Unknown";
      sys.UNKNOWN = -1;
      sys.WIN32 = 0;
      sys.LINUX = 1;
      sys.MACOS = 2;
      sys.ANDROID = 3;
      sys.IPHONE = 4;
      sys.IPAD = 5;
      sys.BLACKBERRY = 6;
      sys.NACL = 7;
      sys.EMSCRIPTEN = 8;
      sys.TIZEN = 9;
      sys.WINRT = 10;
      sys.WP8 = 11;
      sys.MOBILE_BROWSER = 100;
      sys.DESKTOP_BROWSER = 101;
      sys.EDITOR_PAGE = 102;
      sys.EDITOR_CORE = 103;
      sys.WECHAT_GAME = 104;
      sys.QQ_PLAY = 105;
      sys.BROWSER_TYPE_WECHAT = "wechat";
      sys.BROWSER_TYPE_WECHAT_GAME = "wechatgame";
      sys.BROWSER_TYPE_WECHAT_GAME_SUB = "wechatgamesub";
      sys.BROWSER_TYPE_QQ_PLAY = "qqplay";
      sys.BROWSER_TYPE_ANDROID = "androidbrowser";
      sys.BROWSER_TYPE_IE = "ie";
      sys.BROWSER_TYPE_QQ = "qqbrowser";
      sys.BROWSER_TYPE_MOBILE_QQ = "mqqbrowser";
      sys.BROWSER_TYPE_UC = "ucbrowser";
      sys.BROWSER_TYPE_UCBS = "ucbs";
      sys.BROWSER_TYPE_360 = "360browser";
      sys.BROWSER_TYPE_BAIDU_APP = "baiduboxapp";
      sys.BROWSER_TYPE_BAIDU = "baidubrowser";
      sys.BROWSER_TYPE_MAXTHON = "maxthon";
      sys.BROWSER_TYPE_OPERA = "opera";
      sys.BROWSER_TYPE_OUPENG = "oupeng";
      sys.BROWSER_TYPE_MIUI = "miuibrowser";
      sys.BROWSER_TYPE_FIREFOX = "firefox";
      sys.BROWSER_TYPE_SAFARI = "safari";
      sys.BROWSER_TYPE_CHROME = "chrome";
      sys.BROWSER_TYPE_LIEBAO = "liebao";
      sys.BROWSER_TYPE_QZONE = "qzone";
      sys.BROWSER_TYPE_SOUGOU = "sogou";
      sys.BROWSER_TYPE_UNKNOWN = "unknown";
      sys.isNative = false;
      sys.isBrowser = "object" === typeof window && "object" === typeof document && false;
      false;
      var platform;
      var w;
      var h;
      var ratio;
      var capabilities;
      false;
      var env;
      var system;
      var version;
      var w;
      var h;
      var ratio;
      var win, nav, doc, docEle;
      var ua;
      var currLanguage;
      var isAndroid, iOS, osVersion, osMainVersion;
      var uaResult;
      var osName;
      var w;
      var h;
      var ratio;
      var _tmpCanvas1;
      var create3DContext;
      var localStorage;
      var warn;
      var _supportWebp;
      var _supportCanvas;
      var _supportWebGL;
      var browserVer;
      var capabilities;
      var __audioSupport;
      var formatSupport;
      true;
      var env = wx.getSystemInfoSync();
      sys.isMobile = true;
      sys.platform = sys.WECHAT_GAME;
      sys.language = env.language.substr(0, 2);
      var system = env.system.toLowerCase();
      if ("android" === env.platform) sys.os = sys.OS_ANDROID; else if ("ios" === env.platform) sys.os = sys.OS_IOS; else if ("devtools" === env.platform) {
        sys.isMobile = false;
        system.indexOf("android") > -1 ? sys.os = sys.OS_ANDROID : system.indexOf("ios") > -1 && (sys.os = sys.OS_IOS);
      }
      "android p" === system && (system = "android p 9.0");
      var version = /[\d\.]+/.exec(system);
      sys.osVersion = version ? version[0] : system;
      sys.osMainVersion = parseInt(sys.osVersion);
      wx.getFileSystemManager ? sys.browserType = sys.BROWSER_TYPE_WECHAT_GAME : sys.browserType = sys.BROWSER_TYPE_WECHAT_GAME_SUB;
      sys.browserVersion = env.version;
      var w = env.windowWidth;
      var h = env.windowHeight;
      var ratio = env.pixelRatio || 1;
      sys.windowPixelResolution = {
        width: ratio * w,
        height: ratio * h
      };
      sys.localStorage = window.localStorage;
      sys.capabilities = {
        canvas: true,
        opengl: sys.browserType !== sys.BROWSER_TYPE_WECHAT_GAME_SUB,
        webp: false
      };
      sys.__audioSupport = {
        ONLY_ONE: false,
        WEB_AUDIO: false,
        DELAY_CREATE_CTX: false,
        format: [ ".mp3" ]
      };
      sys.NetworkType = {
        NONE: 0,
        LAN: 1,
        WWAN: 2
      };
      sys.getNetworkType = function() {
        return sys.NetworkType.LAN;
      };
      sys.getBatteryLevel = function() {
        return 1;
      };
      sys.garbageCollect = function() {
        false;
      };
      sys.dumpRoot = function() {
        false;
      };
      sys.restartVM = function() {
        false;
      };
      sys.cleanScript = function(jsfile) {
        false;
      };
      sys.isObjectValid = function(obj) {
        false;
        if (obj) return true;
        return false;
      };
      sys.dump = function() {
        var self = this;
        var str = "";
        str += "isMobile : " + self.isMobile + "\r\n";
        str += "language : " + self.language + "\r\n";
        str += "browserType : " + self.browserType + "\r\n";
        str += "browserVersion : " + self.browserVersion + "\r\n";
        str += "capabilities : " + JSON.stringify(self.capabilities) + "\r\n";
        str += "os : " + self.os + "\r\n";
        str += "osVersion : " + self.osVersion + "\r\n";
        str += "platform : " + self.platform + "\r\n";
        str += "Using " + (cc.game.renderType === cc.game.RENDER_TYPE_WEBGL ? "WEBGL" : "CANVAS") + " renderer.\r\n";
        cc.log(str);
      };
      sys.openURL = function(url) {
        false;
        window.open(url);
      };
      sys.now = function() {
        return Date.now ? Date.now() : +new Date();
      };
      return sys;
    }
    var sys = cc && cc.sys ? cc.sys : initSys();
    module.exports = sys;
  }), {} ],
  157: [ (function(require, module, exports) {
    var EventTarget = require("../event/event-target");
    var js = require("../platform/js");
    var renderer = require("../renderer");
    require("../platform/CCClass");
    var __BrowserGetter = {
      init: function() {
        false;
      },
      availWidth: function(frame) {
        return frame && frame !== this.html ? frame.clientWidth : window.innerWidth;
      },
      availHeight: function(frame) {
        return frame && frame !== this.html ? frame.clientHeight : window.innerHeight;
      },
      meta: {
        width: "device-width"
      },
      adaptationType: cc.sys.browserType
    };
    cc.sys.os === cc.sys.OS_IOS && (__BrowserGetter.adaptationType = cc.sys.BROWSER_TYPE_SAFARI);
    true;
    cc.sys.browserType === cc.sys.BROWSER_TYPE_WECHAT_GAME_SUB ? __BrowserGetter.adaptationType = cc.sys.BROWSER_TYPE_WECHAT_GAME_SUB : __BrowserGetter.adaptationType = cc.sys.BROWSER_TYPE_WECHAT_GAME;
    false;
    switch (__BrowserGetter.adaptationType) {
     case cc.sys.BROWSER_TYPE_SAFARI:
      __BrowserGetter.meta["minimal-ui"] = "true";

     case cc.sys.BROWSER_TYPE_SOUGOU:
     case cc.sys.BROWSER_TYPE_UC:
      __BrowserGetter.availWidth = function(frame) {
        return frame.clientWidth;
      };
      __BrowserGetter.availHeight = function(frame) {
        return frame.clientHeight;
      };
      break;

     case cc.sys.BROWSER_TYPE_WECHAT_GAME:
      __BrowserGetter.availWidth = function() {
        return window.innerWidth;
      };
      __BrowserGetter.availHeight = function() {
        return window.innerHeight;
      };
      break;

     case cc.sys.BROWSER_TYPE_WECHAT_GAME_SUB:
      var sharedCanvas = window.sharedCanvas || wx.getSharedCanvas();
      __BrowserGetter.availWidth = function() {
        return sharedCanvas.width;
      };
      __BrowserGetter.availHeight = function() {
        return sharedCanvas.height;
      };
    }
    var _scissorRect = null;
    var View = function() {
      EventTarget.call(this);
      var _t = this, _strategyer = cc.ContainerStrategy, _strategy = cc.ContentStrategy;
      __BrowserGetter.init(this);
      _t._frameSize = cc.size(0, 0);
      _t._designResolutionSize = cc.size(0, 0);
      _t._originalDesignResolutionSize = cc.size(0, 0);
      _t._scaleX = 1;
      _t._scaleY = 1;
      _t._viewportRect = cc.rect(0, 0, 0, 0);
      _t._visibleRect = cc.rect(0, 0, 0, 0);
      _t._autoFullScreen = false;
      _t._devicePixelRatio = 1;
      _t._retinaEnabled = false;
      _t._resizeCallback = null;
      _t._resizing = false;
      _t._resizeWithBrowserSize = false;
      _t._orientationChanging = true;
      _t._isRotated = false;
      _t._orientation = cc.macro.ORIENTATION_AUTO;
      _t._isAdjustViewport = true;
      _t._antiAliasEnabled = false;
      _t._resolutionPolicy = null;
      _t._rpExactFit = new cc.ResolutionPolicy(_strategyer.EQUAL_TO_FRAME, _strategy.EXACT_FIT);
      _t._rpShowAll = new cc.ResolutionPolicy(_strategyer.EQUAL_TO_FRAME, _strategy.SHOW_ALL);
      _t._rpNoBorder = new cc.ResolutionPolicy(_strategyer.EQUAL_TO_FRAME, _strategy.NO_BORDER);
      _t._rpFixedHeight = new cc.ResolutionPolicy(_strategyer.EQUAL_TO_FRAME, _strategy.FIXED_HEIGHT);
      _t._rpFixedWidth = new cc.ResolutionPolicy(_strategyer.EQUAL_TO_FRAME, _strategy.FIXED_WIDTH);
      cc.game.once(cc.game.EVENT_ENGINE_INITED, this.init, this);
    };
    cc.js.extend(View, EventTarget);
    cc.js.mixin(View.prototype, {
      init: function() {
        this._initFrameSize();
        this.enableAntiAlias(true);
        var w = cc.game.canvas.width, h = cc.game.canvas.height;
        this._designResolutionSize.width = w;
        this._designResolutionSize.height = h;
        this._originalDesignResolutionSize.width = w;
        this._originalDesignResolutionSize.height = h;
        this._viewportRect.width = w;
        this._viewportRect.height = h;
        this._visibleRect.width = w;
        this._visibleRect.height = h;
        cc.winSize.width = this._visibleRect.width;
        cc.winSize.height = this._visibleRect.height;
        cc.visibleRect && cc.visibleRect.init(this._visibleRect);
      },
      _resizeEvent: function() {
        var view;
        view = this.setDesignResolutionSize ? this : cc.view;
        var prevFrameW = view._frameSize.width, prevFrameH = view._frameSize.height, prevRotated = view._isRotated;
        if (cc.sys.isMobile) {
          var containerStyle = cc.game.container.style, margin = containerStyle.margin;
          containerStyle.margin = "0";
          containerStyle.display = "none";
          view._initFrameSize();
          containerStyle.margin = margin;
          containerStyle.display = "block";
        } else view._initFrameSize();
        if (view._isRotated === prevRotated && view._frameSize.width === prevFrameW && view._frameSize.height === prevFrameH) return;
        var width = view._originalDesignResolutionSize.width;
        var height = view._originalDesignResolutionSize.height;
        view._resizing = true;
        width > 0 && view.setDesignResolutionSize(width, height, view._resolutionPolicy);
        view._resizing = false;
        view.emit("canvas-resize");
        view._resizeCallback && view._resizeCallback.call();
      },
      _orientationChange: function() {
        cc.view._orientationChanging = true;
        cc.view._resizeEvent();
      },
      resizeWithBrowserSize: function(enabled) {
        if (enabled) {
          if (!this._resizeWithBrowserSize) {
            this._resizeWithBrowserSize = true;
            window.addEventListener("resize", this._resizeEvent);
            window.addEventListener("orientationchange", this._orientationChange);
          }
        } else if (this._resizeWithBrowserSize) {
          this._resizeWithBrowserSize = false;
          window.removeEventListener("resize", this._resizeEvent);
          window.removeEventListener("orientationchange", this._orientationChange);
        }
      },
      setResizeCallback: function(callback) {
        "function" !== typeof callback && null != callback || (this._resizeCallback = callback);
      },
      setOrientation: function(orientation) {
        orientation &= cc.macro.ORIENTATION_AUTO;
        if (orientation && this._orientation !== orientation) {
          this._orientation = orientation;
          var designWidth = this._originalDesignResolutionSize.width;
          var designHeight = this._originalDesignResolutionSize.height;
          this.setDesignResolutionSize(designWidth, designHeight, this._resolutionPolicy);
        }
      },
      _initFrameSize: function() {
        var locFrameSize = this._frameSize;
        var w = __BrowserGetter.availWidth(cc.game.frame);
        var h = __BrowserGetter.availHeight(cc.game.frame);
        var isLandscape = w >= h;
        if ((false, !cc.sys.isMobile) || isLandscape && this._orientation & cc.macro.ORIENTATION_LANDSCAPE || !isLandscape && this._orientation & cc.macro.ORIENTATION_PORTRAIT) {
          locFrameSize.width = w;
          locFrameSize.height = h;
          cc.game.container.style["-webkit-transform"] = "rotate(0deg)";
          cc.game.container.style.transform = "rotate(0deg)";
          this._isRotated = false;
        } else {
          locFrameSize.width = h;
          locFrameSize.height = w;
          cc.game.container.style["-webkit-transform"] = "rotate(90deg)";
          cc.game.container.style.transform = "rotate(90deg)";
          cc.game.container.style["-webkit-transform-origin"] = "0px 0px 0px";
          cc.game.container.style.transformOrigin = "0px 0px 0px";
          this._isRotated = true;
        }
        this._orientationChanging && setTimeout((function() {
          cc.view._orientationChanging = false;
        }), 1e3);
      },
      _adjustSizeKeepCanvasSize: function() {
        var designWidth = this._originalDesignResolutionSize.width;
        var designHeight = this._originalDesignResolutionSize.height;
        designWidth > 0 && this.setDesignResolutionSize(designWidth, designHeight, this._resolutionPolicy);
      },
      _setViewportMeta: function(metas, overwrite) {
        var vp = document.getElementById("cocosMetaElement");
        vp && overwrite && document.head.removeChild(vp);
        var elems = document.getElementsByName("viewport"), currentVP = elems ? elems[0] : null, content, key, pattern;
        content = currentVP ? currentVP.content : "";
        vp = vp || document.createElement("meta");
        vp.id = "cocosMetaElement";
        vp.name = "viewport";
        vp.content = "";
        for (key in metas) if (-1 == content.indexOf(key)) content += "," + key + "=" + metas[key]; else if (overwrite) {
          pattern = new RegExp(key + "s*=s*[^,]+");
          content.replace(pattern, key + "=" + metas[key]);
        }
        /^,/.test(content) && (content = content.substr(1));
        vp.content = content;
        currentVP && (currentVP.content = content);
        document.head.appendChild(vp);
      },
      _adjustViewportMeta: function() {
        if (this._isAdjustViewport && false) {
          this._setViewportMeta(__BrowserGetter.meta, false);
          this._isAdjustViewport = false;
        }
      },
      adjustViewportMeta: function(enabled) {
        this._isAdjustViewport = enabled;
      },
      enableRetina: function(enabled) {
        this._retinaEnabled = !!enabled;
      },
      isRetinaEnabled: function() {
        return this._retinaEnabled;
      },
      enableAntiAlias: function(enabled) {
        if (this._antiAliasEnabled === enabled) return;
        this._antiAliasEnabled = enabled;
        if (cc.game.renderType === cc.game.RENDER_TYPE_WEBGL) {
          var cache = cc.loader._cache;
          for (var key in cache) {
            var item = cache[key];
            var tex = item && item.content instanceof cc.Texture2D ? item.content : null;
            if (tex) {
              var Filter = cc.Texture2D.Filter;
              enabled ? tex.setFilters(Filter.LINEAR, Filter.LINEAR) : tex.setFilters(Filter.NEAREST, Filter.NEAREST);
            }
          }
        } else if (cc.game.renderType === cc.game.RENDER_TYPE_CANVAS) {
          var ctx = cc.game.canvas.getContext("2d");
          ctx.imageSmoothingEnabled = enabled;
          ctx.mozImageSmoothingEnabled = enabled;
        }
      },
      isAntiAliasEnabled: function() {
        return this._antiAliasEnabled;
      },
      enableAutoFullScreen: function(enabled) {
        if (enabled && enabled !== this._autoFullScreen && cc.sys.isMobile && cc.sys.browserType !== cc.sys.BROWSER_TYPE_WECHAT) {
          this._autoFullScreen = true;
          cc.screen.autoFullScreen(cc.game.frame);
        } else this._autoFullScreen = false;
      },
      isAutoFullScreenEnabled: function() {
        return this._autoFullScreen;
      },
      setCanvasSize: function(width, height) {
        var canvas = cc.game.canvas;
        var container = cc.game.container;
        canvas.width = width * this._devicePixelRatio;
        canvas.height = height * this._devicePixelRatio;
        canvas.style.width = width + "px";
        canvas.style.height = height + "px";
        container.style.width = width + "px";
        container.style.height = height + "px";
        this._resizeEvent();
      },
      getCanvasSize: function() {
        return cc.size(cc.game.canvas.width, cc.game.canvas.height);
      },
      getFrameSize: function() {
        return cc.size(this._frameSize.width, this._frameSize.height);
      },
      setFrameSize: function(width, height) {
        this._frameSize.width = width;
        this._frameSize.height = height;
        cc.game.frame.style.width = width + "px";
        cc.game.frame.style.height = height + "px";
        this._resizeEvent();
      },
      getVisibleSize: function() {
        return cc.size(this._visibleRect.width, this._visibleRect.height);
      },
      getVisibleSizeInPixel: function() {
        return cc.size(this._visibleRect.width * this._scaleX, this._visibleRect.height * this._scaleY);
      },
      getVisibleOrigin: function() {
        return cc.v2(this._visibleRect.x, this._visibleRect.y);
      },
      getVisibleOriginInPixel: function() {
        return cc.v2(this._visibleRect.x * this._scaleX, this._visibleRect.y * this._scaleY);
      },
      getResolutionPolicy: function() {
        return this._resolutionPolicy;
      },
      setResolutionPolicy: function(resolutionPolicy) {
        var _t = this;
        if (resolutionPolicy instanceof cc.ResolutionPolicy) _t._resolutionPolicy = resolutionPolicy; else {
          var _locPolicy = cc.ResolutionPolicy;
          resolutionPolicy === _locPolicy.EXACT_FIT && (_t._resolutionPolicy = _t._rpExactFit);
          resolutionPolicy === _locPolicy.SHOW_ALL && (_t._resolutionPolicy = _t._rpShowAll);
          resolutionPolicy === _locPolicy.NO_BORDER && (_t._resolutionPolicy = _t._rpNoBorder);
          resolutionPolicy === _locPolicy.FIXED_HEIGHT && (_t._resolutionPolicy = _t._rpFixedHeight);
          resolutionPolicy === _locPolicy.FIXED_WIDTH && (_t._resolutionPolicy = _t._rpFixedWidth);
        }
      },
      setDesignResolutionSize: function(width, height, resolutionPolicy) {
        if (!(width > 0 || height > 0)) {
          cc.logID(2200);
          return;
        }
        this.setResolutionPolicy(resolutionPolicy);
        var policy = this._resolutionPolicy;
        policy && policy.preApply(this);
        cc.sys.isMobile && this._adjustViewportMeta();
        this._orientationChanging = true;
        this._resizing || this._initFrameSize();
        if (!policy) {
          cc.logID(2201);
          return;
        }
        this._originalDesignResolutionSize.width = this._designResolutionSize.width = width;
        this._originalDesignResolutionSize.height = this._designResolutionSize.height = height;
        var result = policy.apply(this, this._designResolutionSize);
        if (result.scale && 2 === result.scale.length) {
          this._scaleX = result.scale[0];
          this._scaleY = result.scale[1];
        }
        if (result.viewport) {
          var vp = this._viewportRect, vb = this._visibleRect, rv = result.viewport;
          vp.x = rv.x;
          vp.y = rv.y;
          vp.width = rv.width;
          vp.height = rv.height;
          vb.x = 0;
          vb.y = 0;
          vb.width = rv.width / this._scaleX;
          vb.height = rv.height / this._scaleY;
        }
        policy.postApply(this);
        cc.winSize.width = this._visibleRect.width;
        cc.winSize.height = this._visibleRect.height;
        cc.visibleRect && cc.visibleRect.init(this._visibleRect);
        renderer.updateCameraViewport();
        this.emit("design-resolution-changed");
      },
      getDesignResolutionSize: function() {
        return cc.size(this._designResolutionSize.width, this._designResolutionSize.height);
      },
      setRealPixelResolution: function(width, height, resolutionPolicy) {
        if ((true, false) && true) {
          this._setViewportMeta({
            width: width
          }, true);
          document.documentElement.style.width = width + "px";
          document.body.style.width = width + "px";
          document.body.style.left = "0px";
          document.body.style.top = "0px";
        }
        this.setDesignResolutionSize(width, height, resolutionPolicy);
      },
      setViewportInPoints: function(x, y, w, h) {
        var locScaleX = this._scaleX, locScaleY = this._scaleY;
        cc.game._renderContext.viewport(x * locScaleX + this._viewportRect.x, y * locScaleY + this._viewportRect.y, w * locScaleX, h * locScaleY);
      },
      setScissorInPoints: function(x, y, w, h) {
        var scaleX = this._scaleX, scaleY = this._scaleY;
        var sx = Math.ceil(x * scaleX + this._viewportRect.x);
        var sy = Math.ceil(y * scaleY + this._viewportRect.y);
        var sw = Math.ceil(w * scaleX);
        var sh = Math.ceil(h * scaleY);
        var gl = cc.game._renderContext;
        if (!_scissorRect) {
          var boxArr = gl.getParameter(gl.SCISSOR_BOX);
          _scissorRect = cc.rect(boxArr[0], boxArr[1], boxArr[2], boxArr[3]);
        }
        if (_scissorRect.x !== sx || _scissorRect.y !== sy || _scissorRect.width !== sw || _scissorRect.height !== sh) {
          _scissorRect.x = sx;
          _scissorRect.y = sy;
          _scissorRect.width = sw;
          _scissorRect.height = sh;
          gl.scissor(sx, sy, sw, sh);
        }
      },
      isScissorEnabled: function() {
        return cc.game._renderContext.isEnabled(gl.SCISSOR_TEST);
      },
      getScissorRect: function() {
        if (!_scissorRect) {
          var boxArr = gl.getParameter(gl.SCISSOR_BOX);
          _scissorRect = cc.rect(boxArr[0], boxArr[1], boxArr[2], boxArr[3]);
        }
        var scaleXFactor = 1 / this._scaleX;
        var scaleYFactor = 1 / this._scaleY;
        return cc.rect((_scissorRect.x - this._viewportRect.x) * scaleXFactor, (_scissorRect.y - this._viewportRect.y) * scaleYFactor, _scissorRect.width * scaleXFactor, _scissorRect.height * scaleYFactor);
      },
      getViewportRect: function() {
        return this._viewportRect;
      },
      getScaleX: function() {
        return this._scaleX;
      },
      getScaleY: function() {
        return this._scaleY;
      },
      getDevicePixelRatio: function() {
        return this._devicePixelRatio;
      },
      convertToLocationInView: function(tx, ty, relatedPos, out) {
        var result = out || cc.v2();
        var x = this._devicePixelRatio * (tx - relatedPos.left);
        var y = this._devicePixelRatio * (relatedPos.top + relatedPos.height - ty);
        if (this._isRotated) {
          result.x = this._viewportRect.width - y;
          result.y = x;
        } else {
          result.x = x;
          result.y = y;
        }
        return result;
      },
      _convertMouseToLocationInView: function(in_out_point, relatedPos) {
        var viewport = this._viewportRect, _t = this;
        in_out_point.x = (_t._devicePixelRatio * (in_out_point.x - relatedPos.left) - viewport.x) / _t._scaleX;
        in_out_point.y = (_t._devicePixelRatio * (relatedPos.top + relatedPos.height - in_out_point.y) - viewport.y) / _t._scaleY;
      },
      _convertPointWithScale: function(point) {
        var viewport = this._viewportRect;
        point.x = (point.x - viewport.x) / this._scaleX;
        point.y = (point.y - viewport.y) / this._scaleY;
      },
      _convertTouchesWithScale: function(touches) {
        var viewport = this._viewportRect, scaleX = this._scaleX, scaleY = this._scaleY, selTouch, selPoint, selPrePoint;
        for (var i = 0; i < touches.length; i++) {
          selTouch = touches[i];
          selPoint = selTouch._point;
          selPrePoint = selTouch._prevPoint;
          selPoint.x = (selPoint.x - viewport.x) / scaleX;
          selPoint.y = (selPoint.y - viewport.y) / scaleY;
          selPrePoint.x = (selPrePoint.x - viewport.x) / scaleX;
          selPrePoint.y = (selPrePoint.y - viewport.y) / scaleY;
        }
      }
    });
    cc.ContainerStrategy = cc.Class({
      name: "ContainerStrategy",
      preApply: function(view) {},
      apply: function(view, designedResolution) {},
      postApply: function(view) {},
      _setupContainer: function(view, w, h) {
        var locCanvas = cc.game.canvas, locContainer = cc.game.container;
        if (cc.sys.platform !== cc.sys.WECHAT_GAME) {
          if (cc.sys.os === cc.sys.OS_ANDROID) {
            document.body.style.width = (view._isRotated ? h : w) + "px";
            document.body.style.height = (view._isRotated ? w : h) + "px";
          }
          locContainer.style.width = locCanvas.style.width = w + "px";
          locContainer.style.height = locCanvas.style.height = h + "px";
        }
        var devicePixelRatio = view._devicePixelRatio = 1;
        view.isRetinaEnabled() && (devicePixelRatio = view._devicePixelRatio = Math.min(2, window.devicePixelRatio || 1));
        locCanvas.width = w * devicePixelRatio;
        locCanvas.height = h * devicePixelRatio;
      },
      _fixContainer: function() {
        document.body.insertBefore(cc.game.container, document.body.firstChild);
        var bs = document.body.style;
        bs.width = window.innerWidth + "px";
        bs.height = window.innerHeight + "px";
        bs.overflow = "hidden";
        var contStyle = cc.game.container.style;
        contStyle.position = "fixed";
        contStyle.left = contStyle.top = "0px";
        document.body.scrollTop = 0;
      }
    });
    cc.ContentStrategy = cc.Class({
      name: "ContentStrategy",
      ctor: function() {
        this._result = {
          scale: [ 1, 1 ],
          viewport: null
        };
      },
      _buildResult: function(containerW, containerH, contentW, contentH, scaleX, scaleY) {
        Math.abs(containerW - contentW) < 2 && (contentW = containerW);
        Math.abs(containerH - contentH) < 2 && (contentH = containerH);
        var viewport = cc.rect(Math.round((containerW - contentW) / 2), Math.round((containerH - contentH) / 2), contentW, contentH);
        cc.game.renderType === cc.game.RENDER_TYPE_CANVAS;
        this._result.scale = [ scaleX, scaleY ];
        this._result.viewport = viewport;
        return this._result;
      },
      preApply: function(view) {},
      apply: function(view, designedResolution) {
        return {
          scale: [ 1, 1 ]
        };
      },
      postApply: function(view) {}
    });
    (function() {
      var EqualToFrame = cc.Class({
        name: "EqualToFrame",
        extends: cc.ContainerStrategy,
        apply: function(view) {
          var frameH = view._frameSize.height, containerStyle = cc.game.container.style;
          this._setupContainer(view, view._frameSize.width, view._frameSize.height);
          view._isRotated ? containerStyle.margin = "0 0 0 " + frameH + "px" : containerStyle.margin = "0px";
          containerStyle.padding = "0px";
        }
      });
      var ProportionalToFrame = cc.Class({
        name: "ProportionalToFrame",
        extends: cc.ContainerStrategy,
        apply: function(view, designedResolution) {
          var frameW = view._frameSize.width, frameH = view._frameSize.height, containerStyle = cc.game.container.style, designW = designedResolution.width, designH = designedResolution.height, scaleX = frameW / designW, scaleY = frameH / designH, containerW, containerH;
          scaleX < scaleY ? (containerW = frameW, containerH = designH * scaleX) : (containerW = designW * scaleY, 
          containerH = frameH);
          var offx = Math.round((frameW - containerW) / 2);
          var offy = Math.round((frameH - containerH) / 2);
          containerW = frameW - 2 * offx;
          containerH = frameH - 2 * offy;
          this._setupContainer(view, containerW, containerH);
          true;
          view._isRotated ? containerStyle.margin = "0 0 0 " + frameH + "px" : containerStyle.margin = "0px";
          containerStyle.paddingLeft = offx + "px";
          containerStyle.paddingRight = offx + "px";
          containerStyle.paddingTop = offy + "px";
          containerStyle.paddingBottom = offy + "px";
        }
      });
      var EqualToWindow = cc.Class({
        name: "EqualToWindow",
        extends: EqualToFrame,
        preApply: function(view) {
          this._super(view);
          cc.game.frame = document.documentElement;
        },
        apply: function(view) {
          this._super(view);
          this._fixContainer();
        }
      });
      var ProportionalToWindow = cc.Class({
        name: "ProportionalToWindow",
        extends: ProportionalToFrame,
        preApply: function(view) {
          this._super(view);
          cc.game.frame = document.documentElement;
        },
        apply: function(view, designedResolution) {
          this._super(view, designedResolution);
          this._fixContainer();
        }
      });
      var OriginalContainer = cc.Class({
        name: "OriginalContainer",
        extends: cc.ContainerStrategy,
        apply: function(view) {
          this._setupContainer(view, cc.game.canvas.width, cc.game.canvas.height);
        }
      });
      cc.ContainerStrategy.EQUAL_TO_FRAME = new EqualToFrame();
      cc.ContainerStrategy.PROPORTION_TO_FRAME = new ProportionalToFrame();
      cc.ContainerStrategy.ORIGINAL_CONTAINER = new OriginalContainer();
      var ExactFit = cc.Class({
        name: "ExactFit",
        extends: cc.ContentStrategy,
        apply: function(view, designedResolution) {
          var containerW = cc.game.canvas.width, containerH = cc.game.canvas.height, scaleX = containerW / designedResolution.width, scaleY = containerH / designedResolution.height;
          return this._buildResult(containerW, containerH, containerW, containerH, scaleX, scaleY);
        }
      });
      var ShowAll = cc.Class({
        name: "ShowAll",
        extends: cc.ContentStrategy,
        apply: function(view, designedResolution) {
          var containerW = cc.game.canvas.width, containerH = cc.game.canvas.height, designW = designedResolution.width, designH = designedResolution.height, scaleX = containerW / designW, scaleY = containerH / designH, scale = 0, contentW, contentH;
          scaleX < scaleY ? (scale = scaleX, contentW = containerW, contentH = designH * scale) : (scale = scaleY, 
          contentW = designW * scale, contentH = containerH);
          return this._buildResult(containerW, containerH, contentW, contentH, scale, scale);
        }
      });
      var NoBorder = cc.Class({
        name: "NoBorder",
        extends: cc.ContentStrategy,
        apply: function(view, designedResolution) {
          var containerW = cc.game.canvas.width, containerH = cc.game.canvas.height, designW = designedResolution.width, designH = designedResolution.height, scaleX = containerW / designW, scaleY = containerH / designH, scale, contentW, contentH;
          scaleX < scaleY ? (scale = scaleY, contentW = designW * scale, contentH = containerH) : (scale = scaleX, 
          contentW = containerW, contentH = designH * scale);
          return this._buildResult(containerW, containerH, contentW, contentH, scale, scale);
        }
      });
      var FixedHeight = cc.Class({
        name: "FixedHeight",
        extends: cc.ContentStrategy,
        apply: function(view, designedResolution) {
          var containerW = cc.game.canvas.width, containerH = cc.game.canvas.height, designH = designedResolution.height, scale = containerH / designH, contentW = containerW, contentH = containerH;
          return this._buildResult(containerW, containerH, contentW, contentH, scale, scale);
        }
      });
      var FixedWidth = cc.Class({
        name: "FixedWidth",
        extends: cc.ContentStrategy,
        apply: function(view, designedResolution) {
          var containerW = cc.game.canvas.width, containerH = cc.game.canvas.height, designW = designedResolution.width, scale = containerW / designW, contentW = containerW, contentH = containerH;
          return this._buildResult(containerW, containerH, contentW, contentH, scale, scale);
        }
      });
      cc.ContentStrategy.EXACT_FIT = new ExactFit();
      cc.ContentStrategy.SHOW_ALL = new ShowAll();
      cc.ContentStrategy.NO_BORDER = new NoBorder();
      cc.ContentStrategy.FIXED_HEIGHT = new FixedHeight();
      cc.ContentStrategy.FIXED_WIDTH = new FixedWidth();
    })();
    cc.ResolutionPolicy = cc.Class({
      name: "cc.ResolutionPolicy",
      ctor: function(containerStg, contentStg) {
        this._containerStrategy = null;
        this._contentStrategy = null;
        this.setContainerStrategy(containerStg);
        this.setContentStrategy(contentStg);
      },
      preApply: function(view) {
        this._containerStrategy.preApply(view);
        this._contentStrategy.preApply(view);
      },
      apply: function(view, designedResolution) {
        this._containerStrategy.apply(view, designedResolution);
        return this._contentStrategy.apply(view, designedResolution);
      },
      postApply: function(view) {
        this._containerStrategy.postApply(view);
        this._contentStrategy.postApply(view);
      },
      setContainerStrategy: function(containerStg) {
        containerStg instanceof cc.ContainerStrategy && (this._containerStrategy = containerStg);
      },
      setContentStrategy: function(contentStg) {
        contentStg instanceof cc.ContentStrategy && (this._contentStrategy = contentStg);
      }
    });
    js.get(cc.ResolutionPolicy.prototype, "canvasSize", (function() {
      return cc.v2(cc.game.canvas.width, cc.game.canvas.height);
    }));
    cc.ResolutionPolicy.EXACT_FIT = 0;
    cc.ResolutionPolicy.NO_BORDER = 1;
    cc.ResolutionPolicy.SHOW_ALL = 2;
    cc.ResolutionPolicy.FIXED_HEIGHT = 3;
    cc.ResolutionPolicy.FIXED_WIDTH = 4;
    cc.ResolutionPolicy.UNKNOWN = 5;
    cc.view = new View();
    cc.winSize = cc.v2();
    module.exports = cc.view;
  }), {
    "../event/event-target": 91,
    "../platform/CCClass": 147,
    "../platform/js": 167,
    "../renderer": 173
  } ],
  158: [ (function(require, module, exports) {
    cc.visibleRect = {
      topLeft: cc.v2(0, 0),
      topRight: cc.v2(0, 0),
      top: cc.v2(0, 0),
      bottomLeft: cc.v2(0, 0),
      bottomRight: cc.v2(0, 0),
      bottom: cc.v2(0, 0),
      center: cc.v2(0, 0),
      left: cc.v2(0, 0),
      right: cc.v2(0, 0),
      width: 0,
      height: 0,
      init: function(visibleRect) {
        var w = this.width = visibleRect.width;
        var h = this.height = visibleRect.height;
        var l = visibleRect.x, b = visibleRect.y, t = b + h, r = l + w;
        this.topLeft.x = l;
        this.topLeft.y = t;
        this.topRight.x = r;
        this.topRight.y = t;
        this.top.x = l + w / 2;
        this.top.y = t;
        this.bottomLeft.x = l;
        this.bottomLeft.y = b;
        this.bottomRight.x = r;
        this.bottomRight.y = b;
        this.bottom.x = l + w / 2;
        this.bottom.y = b;
        this.center.x = l + w / 2;
        this.center.y = b + h / 2;
        this.left.x = l;
        this.left.y = b + h / 2;
        this.right.x = r;
        this.right.y = b + h / 2;
      }
    };
  }), {} ],
  159: [ (function(require, module, exports) {
    var js = require("./js");
    var isPlainEmptyObj = require("./utils").isPlainEmptyObj_DEV;
    var DELIMETER = "$_$";
    function createAttrsSingle(owner, ownerCtor, superAttrs) {
      var AttrsCtor;
      var ctorName;
      false;
      AttrsCtor = function() {};
      superAttrs && js.extend(AttrsCtor, superAttrs.constructor);
      var attrs = new AttrsCtor();
      js.value(owner, "__attrs__", attrs);
      return attrs;
    }
    function createAttrs(subclass) {
      var superClass;
      var chains = cc.Class.getInheritanceChain(subclass);
      for (var i = chains.length - 1; i >= 0; i--) {
        var cls = chains[i];
        var attrs = cls.hasOwnProperty("__attrs__") && cls.__attrs__;
        if (!attrs) {
          superClass = chains[i + 1];
          createAttrsSingle(cls, cls, superClass && superClass.__attrs__);
        }
      }
      superClass = chains[0];
      createAttrsSingle(subclass, subclass, superClass && superClass.__attrs__);
      return subclass.__attrs__;
    }
    function attr(ctor, propName, newAttrs) {
      var attrs, setter, key;
      if ("function" === typeof ctor) {
        attrs = getClassAttrs(ctor);
        setter = attrs.constructor.prototype;
      } else {
        var instance = ctor;
        attrs = instance.__attrs__;
        if (!attrs) {
          ctor = instance.constructor;
          var clsAttrs = getClassAttrs(ctor);
          attrs = createAttrsSingle(instance, ctor, clsAttrs);
        }
        setter = attrs;
      }
      if ("undefined" === typeof newAttrs) {
        var prefix = propName + DELIMETER;
        var ret = {};
        for (key in attrs) key.startsWith(prefix) && (ret[key.slice(prefix.length)] = attrs[key]);
        return ret;
      }
      if ("object" === typeof newAttrs) for (key in newAttrs) 95 !== key.charCodeAt(0) && (setter[propName + DELIMETER + key] = newAttrs[key]); else false;
    }
    function getClassAttrs(ctor) {
      return ctor.hasOwnProperty("__attrs__") && ctor.__attrs__ || createAttrs(ctor);
    }
    function getClassAttrsProto(ctor) {
      return getClassAttrs(ctor).constructor.prototype;
    }
    function setClassAttr(ctor, propName, key, value) {
      var proto = getClassAttrsProto(ctor);
      proto[propName + DELIMETER + key] = value;
    }
    cc.Integer = "Integer";
    cc.Float = "Float";
    false;
    cc.Boolean = "Boolean";
    cc.String = "String";
    function getTypeChecker(type, attrName) {
      false;
    }
    function ObjectType(typeCtor) {
      return {
        type: "Object",
        ctor: typeCtor,
        _onAfterProp: false
      };
    }
    module.exports = {
      attr: attr,
      getClassAttrs: getClassAttrs,
      getClassAttrsProto: getClassAttrsProto,
      setClassAttr: setClassAttr,
      DELIMETER: DELIMETER,
      getTypeChecker: getTypeChecker,
      ObjectType: ObjectType,
      ScriptUuid: {}
    };
  }), {
    "./CCClass": 147,
    "./js": 167,
    "./utils": 171
  } ],
  160: [ (function(require, module, exports) {
    var js = require("./js");
    var fastRemoveAt = js.array.fastRemoveAt;
    function CallbackList() {
      this.callbacks = [];
      this.targets = [];
      this.isInvoking = false;
      this.containCanceled = false;
    }
    var proto = CallbackList.prototype;
    proto.removeBy = function(array, value) {
      var callbacks = this.callbacks;
      var targets = this.targets;
      for (var i = 0; i < array.length; ++i) if (array[i] === value) {
        fastRemoveAt(callbacks, i);
        fastRemoveAt(targets, i);
        --i;
      }
    };
    proto.cancel = function(index) {
      this.callbacks[index] = this.targets[index] = null;
      this.containCanceled = true;
    };
    proto.cancelAll = function() {
      var callbacks = this.callbacks;
      var targets = this.targets;
      for (var i = 0; i < callbacks.length; i++) callbacks[i] = targets[i] = null;
      this.containCanceled = true;
    };
    proto.purgeCanceled = function() {
      this.removeBy(this.callbacks, null);
      this.containCanceled = false;
    };
    var MAX_SIZE = 16;
    var callbackListPool = new js.Pool(function(list) {
      list.callbacks.length = 0;
      list.targets.length = 0;
      list.isInvoking = false;
      list.containCanceled = false;
    }, MAX_SIZE);
    callbackListPool.get = function() {
      return this._get() || new CallbackList();
    };
    function CallbacksHandler() {
      this._callbackTable = js.createMap(true);
    }
    proto = CallbacksHandler.prototype;
    proto.add = function(key, callback, target) {
      var list = this._callbackTable[key];
      list || (list = this._callbackTable[key] = callbackListPool.get());
      list.callbacks.push(callback);
      list.targets.push(target || null);
    };
    proto.hasEventListener = function(key, callback, target) {
      var list = this._callbackTable[key];
      if (!list) return false;
      var callbacks = list.callbacks;
      if (!callback) {
        if (list.isInvoking) {
          for (var i = 0; i < callbacks.length; i++) if (callbacks[i]) return true;
          return false;
        }
        return callbacks.length > 0;
      }
      target = target || null;
      var targets = list.targets;
      for (var _i = 0; _i < callbacks.length; ++_i) if (callbacks[_i] === callback && targets[_i] === target) return true;
      return false;
    };
    proto.removeAll = function(keyOrTarget) {
      if ("string" === typeof keyOrTarget) {
        var list = this._callbackTable[keyOrTarget];
        if (list) if (list.isInvoking) list.cancelAll(); else {
          callbackListPool.put(list);
          delete this._callbackTable[keyOrTarget];
        }
      } else if (keyOrTarget) for (var key in this._callbackTable) {
        var _list = this._callbackTable[key];
        if (_list.isInvoking) {
          var targets = _list.targets;
          for (var i = 0; i < targets.length; ++i) targets[i] === keyOrTarget && _list.cancel(i);
        } else _list.removeBy(_list.targets, keyOrTarget);
      }
    };
    proto.remove = function(key, callback, target) {
      var list = this._callbackTable[key];
      if (list) {
        target = target || null;
        var callbacks = list.callbacks;
        var targets = list.targets;
        for (var i = 0; i < callbacks.length; ++i) if (callbacks[i] === callback && targets[i] === target) {
          if (list.isInvoking) list.cancel(i); else {
            fastRemoveAt(callbacks, i);
            fastRemoveAt(targets, i);
          }
          break;
        }
      }
    };
    var CallbacksInvoker = function() {
      CallbacksHandler.call(this);
    };
    js.extend(CallbacksInvoker, CallbacksHandler);
    false;
    CallbacksInvoker.prototype.invoke = function(key, p1, p2, p3, p4, p5) {
      var list = this._callbackTable[key];
      if (list) {
        var rootInvoker = !list.isInvoking;
        list.isInvoking = true;
        var callbacks = list.callbacks;
        var targets = list.targets;
        for (var i = 0, len = callbacks.length; i < len; ++i) {
          var callback = callbacks[i];
          if (callback) {
            var target = targets[i];
            target ? callback.call(target, p1, p2, p3, p4, p5) : callback(p1, p2, p3, p4, p5);
          }
        }
        if (rootInvoker) {
          list.isInvoking = false;
          list.containCanceled && list.purgeCanceled();
        }
      }
    };
    CallbacksInvoker.CallbacksHandler = CallbacksHandler;
    module.exports = CallbacksInvoker;
  }), {
    "./js": 167
  } ],
  161: [ (function(require, module, exports) {
    function deepFlatten(strList, array) {
      for (var i = 0; i < array.length; i++) {
        var item = array[i];
        Array.isArray(item) ? deepFlatten(strList, item) : strList.push(item);
      }
    }
    function flattenCodeArray(array) {
      var separator = "";
      var strList = [];
      deepFlatten(strList, array);
      return strList.join(separator);
    }
    module.exports = {
      flattenCodeArray: flattenCodeArray
    };
  }), {} ],
  162: [ (function(require, module, exports) {
    var js = require("./js");
    var Attr = require("./attribute");
    var CCClass = require("./CCClass");
    var misc = require("../utils/misc");
    var Details = function() {
      this.uuidList = [];
      this.uuidObjList = [];
      this.uuidPropList = [];
      this._stillUseUrl = js.createMap(true);
    };
    Details.prototype.reset = function() {
      this.uuidList.length = 0;
      this.uuidObjList.length = 0;
      this.uuidPropList.length = 0;
      js.clear(this._stillUseUrl);
    };
    false, false;
    Details.prototype.push = function(obj, propName, uuid, _stillUseUrl) {
      _stillUseUrl && (this._stillUseUrl[this.uuidList.length] = true);
      this.uuidList.push(uuid);
      this.uuidObjList.push(obj);
      this.uuidPropList.push(propName);
    };
    Details.pool = new js.Pool(function(obj) {
      obj.reset();
    }, 10);
    Details.pool.get = function() {
      return this._get() || new Details();
    };
    var _Deserializer = (function() {
      function _Deserializer(result, target, classFinder, customEnv, ignoreEditorOnly) {
        this.result = result;
        this.customEnv = customEnv;
        this.deserializedList = [];
        this.deserializedData = null;
        this._classFinder = classFinder;
        false;
        this._idList = [];
        this._idObjList = [];
        this._idPropList = [];
      }
      function _dereference(self) {
        var deserializedList = self.deserializedList;
        var idPropList = self._idPropList;
        var idList = self._idList;
        var idObjList = self._idObjList;
        var onDereferenced = self._classFinder && self._classFinder.onDereferenced;
        var i, propName, id;
        false;
        for (i = 0; i < idList.length; i++) {
          propName = idPropList[i];
          id = idList[i];
          idObjList[i][propName] = deserializedList[id];
        }
      }
      var prototype = _Deserializer.prototype;
      prototype.deserialize = function(jsonObj) {
        if (Array.isArray(jsonObj)) {
          var jsonArray = jsonObj;
          var refCount = jsonArray.length;
          this.deserializedList.length = refCount;
          for (var i = 0; i < refCount; i++) if (jsonArray[i]) {
            var mainTarget;
            false, false;
            this.deserializedList[i] = this._deserializeObject(jsonArray[i], false);
          }
          this.deserializedData = refCount > 0 ? this.deserializedList[0] : [];
        } else {
          this.deserializedList.length = 1;
          false, false;
          this.deserializedData = jsonObj ? this._deserializeObject(jsonObj, false) : null;
          this.deserializedList[0] = this.deserializedData;
        }
        _dereference(this);
        return this.deserializedData;
      };
      prototype._deserializeObject = function(serialized, _stillUseUrl, target, owner, propName) {
        var prop;
        var obj = null;
        var klass = null;
        var type = serialized.__type__;
        if (type) {
          klass = this._classFinder(type, serialized, owner, propName);
          if (!klass) {
            var notReported = this._classFinder === js._getClassById;
            notReported && cc.deserialize.reportMissingClass(type);
            return null;
          }
          if ((false, false) && target) {
            target instanceof klass || cc.warnID(5300, js.getClassName(target), klass);
            obj = target;
          } else obj = new klass();
          if (obj._deserialize) {
            obj._deserialize(serialized.content, this);
            return obj;
          }
          cc.Class._isCCClass(klass) ? _deserializeFireClass(this, obj, serialized, klass, target) : this._deserializeTypedObject(obj, serialized, klass);
        } else if (Array.isArray(serialized)) {
          if ((false, false) && target) {
            target.length = serialized.length;
            obj = target;
          } else obj = new Array(serialized.length);
          for (var i = 0; i < serialized.length; i++) {
            prop = serialized[i];
            if ("object" === typeof prop && prop) {
              false, false;
              this._deserializeObjField(obj, prop, "" + i, null, _stillUseUrl);
            } else obj[i] = prop;
          }
        } else {
          obj = (false, false) && target || {};
          this._deserializePrimitiveObject(obj, serialized);
        }
        return obj;
      };
      prototype._deserializeObjField = function(obj, jsonObj, propName, target, _stillUseUrl) {
        var id = jsonObj.__id__;
        if (void 0 === id) {
          var uuid = jsonObj.__uuid__;
          if (uuid) this.result.push(obj, propName, uuid, _stillUseUrl); else {
            false, false;
            obj[propName] = this._deserializeObject(jsonObj, _stillUseUrl);
          }
        } else {
          var dObj = this.deserializedList[id];
          if (dObj) obj[propName] = dObj; else {
            this._idList.push(id);
            this._idObjList.push(obj);
            this._idPropList.push(propName);
          }
        }
      };
      prototype._deserializePrimitiveObject = function(instance, serialized) {
        var self = this;
        for (var propName in serialized) if (serialized.hasOwnProperty(propName)) {
          var prop = serialized[propName];
          if ("object" !== typeof prop) "__type__" !== propName && (instance[propName] = prop); else if (prop) {
            false, false;
            self._deserializeObjField(instance, prop, propName);
          } else instance[propName] = null;
        }
      };
      prototype._deserializeTypedObject = function(instance, serialized, klass) {
        if (klass === cc.Vec2) {
          instance.x = serialized.x || 0;
          instance.y = serialized.y || 0;
          return;
        }
        if (klass === cc.Color) {
          instance.r = serialized.r || 0;
          instance.g = serialized.g || 0;
          instance.b = serialized.b || 0;
          var a = serialized.a;
          instance.a = void 0 === a ? 255 : a;
          return;
        }
        if (klass === cc.Size) {
          instance.width = serialized.width || 0;
          instance.height = serialized.height || 0;
          return;
        }
        var fastDefinedProps = klass.__props__;
        fastDefinedProps || (fastDefinedProps = Object.keys(instance));
        for (var i = 0; i < fastDefinedProps.length; i++) {
          var propName = fastDefinedProps[i];
          var prop = serialized[propName];
          if (void 0 !== prop && serialized.hasOwnProperty(propName)) if ("object" !== typeof prop) instance[propName] = prop; else if (prop) {
            false, false;
            this._deserializeObjField(instance, prop, propName);
          } else instance[propName] = null;
        }
      };
      function compileObjectTypeJit(sources, defaultValue, accessorToSet, propNameLiteralToSet, assumeHavePropIfIsValue, stillUseUrl) {
        if (defaultValue instanceof cc.ValueType) {
          assumeHavePropIfIsValue || sources.push("if(prop){");
          var ctorCode = js.getClassName(defaultValue);
          sources.push("s._deserializeTypedObject(o" + accessorToSet + ",prop," + ctorCode + ");");
          assumeHavePropIfIsValue || sources.push("}else o" + accessorToSet + "=null;");
        } else {
          sources.push("if(prop){");
          sources.push("s._deserializeObjField(o,prop," + propNameLiteralToSet + (false, ",null,") + !!stillUseUrl + ");");
          sources.push("}else o" + accessorToSet + "=null;");
        }
      }
      var compileDeserialize = function(self, klass) {
        var fastMode = misc.BUILTIN_CLASSID_RE.test(js._getClassId(klass));
        var shouldCopyId = cc.js.isChildClassOf(klass, cc._BaseNode) || cc.js.isChildClassOf(klass, cc.Component);
        var shouldCopyRawData;
        var simpleProps = [];
        var simplePropsToRead = simpleProps;
        var advancedProps = [];
        var advancedPropsToRead = advancedProps;
        var advancedPropsUseUrl = [];
        var advancedPropsValueType = [];
        (function() {
          var props = klass.__values__;
          shouldCopyRawData = "_$erialized" === props[props.length - 1];
          var attrs = Attr.getClassAttrs(klass);
          var TYPE = Attr.DELIMETER + "type";
          var DEFAULT = Attr.DELIMETER + "default";
          var SAVE_URL_AS_ASSET = Attr.DELIMETER + "saveUrlAsAsset";
          var FORMERLY_SERIALIZED_AS = Attr.DELIMETER + "formerlySerializedAs";
          for (var p = 0; p < props.length; p++) {
            var propName = props[p];
            var propNameToRead = propName;
            attrs[propName + FORMERLY_SERIALIZED_AS] && (propNameToRead = attrs[propName + FORMERLY_SERIALIZED_AS]);
            var stillUseUrl = attrs[propName + SAVE_URL_AS_ASSET];
            var defaultValue = CCClass.getDefault(attrs[propName + DEFAULT]);
            var isPrimitiveType = false;
            if (fastMode) {
              var userType = attrs[propName + TYPE];
              if (void 0 === defaultValue && userType) isPrimitiveType = userType === cc.String || userType === cc.Integer || userType === cc.Float || userType === cc.Boolean; else {
                var defaultType = typeof defaultValue;
                isPrimitiveType = "string" === defaultType && !stillUseUrl || "number" === defaultType || "boolean" === defaultType;
              }
            }
            if (fastMode && isPrimitiveType) {
              propNameToRead !== propName && simplePropsToRead === simpleProps && (simplePropsToRead = simpleProps.slice());
              simpleProps.push(propName);
              simplePropsToRead !== simpleProps && simplePropsToRead.push(propNameToRead);
            } else {
              propNameToRead !== propName && advancedPropsToRead === advancedProps && (advancedPropsToRead = advancedProps.slice());
              advancedProps.push(propName);
              advancedPropsToRead !== advancedProps && advancedPropsToRead.push(propNameToRead);
              advancedPropsUseUrl.push(stillUseUrl);
              advancedPropsValueType.push(defaultValue instanceof cc.ValueType && defaultValue.constructor);
            }
          }
        })();
        return function(s, o, d, k, t) {
          for (var i = 0; i < simpleProps.length; ++i) {
            var _prop = d[simplePropsToRead[i]];
            void 0 !== _prop && (o[simpleProps[i]] = _prop);
          }
          for (var _i = 0; _i < advancedProps.length; ++_i) {
            var propName = advancedProps[_i];
            var prop = d[advancedPropsToRead[_i]];
            if (void 0 === prop) continue;
            if (fastMode || "object" === typeof prop) {
              var valueTypeCtor = advancedPropsValueType[_i];
              valueTypeCtor ? fastMode || prop ? s._deserializeTypedObject(o[propName], prop, valueTypeCtor) : o[propName] = null : prop ? s._deserializeObjField(o, prop, propName, (false, 
              null), advancedPropsUseUrl[_i]) : o[propName] = null;
            } else o[propName] = prop;
          }
          shouldCopyId && d._id && (o._id = d._id);
          if (shouldCopyRawData) {
            o._$erialized = JSON.parse(JSON.stringify(d));
            s._deserializePrimitiveObject(o._$erialized, d);
          }
        };
      };
      function unlinkUnusedPrefab(self, serialized, obj) {
        var uuid = serialized["asset"] && serialized["asset"].__uuid__;
        if (uuid) {
          var last = self.result.uuidList.length - 1;
          if (self.result.uuidList[last] === uuid && self.result.uuidObjList[last] === obj && "asset" === self.result.uuidPropList[last]) {
            self.result.uuidList.pop();
            self.result.uuidObjList.pop();
            self.result.uuidPropList.pop();
          } else {
            var debugEnvOnlyInfo = "Failed to skip prefab asset while deserializing PrefabInfo";
            cc.warn(debugEnvOnlyInfo);
          }
        }
      }
      function _deserializeFireClass(self, obj, serialized, klass, target) {
        var deserialize;
        if (klass.hasOwnProperty("__deserialize__")) deserialize = klass.__deserialize__; else {
          deserialize = compileDeserialize(self, klass);
          js.value(klass, "__deserialize__", deserialize, true);
        }
        deserialize(self, obj, serialized, klass, target);
        false, false;
      }
      _Deserializer.pool = new js.Pool(function(obj) {
        obj.result = null;
        obj.customEnv = null;
        obj.deserializedList.length = 0;
        obj.deserializedData = null;
        obj._classFinder = null;
        false;
        obj._idList.length = 0;
        obj._idObjList.length = 0;
        obj._idPropList.length = 0;
      }, 1);
      _Deserializer.pool.get = function(result, target, classFinder, customEnv, ignoreEditorOnly) {
        var cache = this._get();
        if (cache) {
          cache.result = result;
          cache.customEnv = customEnv;
          cache._classFinder = classFinder;
          false;
          return cache;
        }
        return new _Deserializer(result, target, classFinder, customEnv, ignoreEditorOnly);
      };
      return _Deserializer;
    })();
    cc.deserialize = function(data, details, options) {
      options = options || {};
      var classFinder = options.classFinder || js._getClassById;
      var createAssetRefs = options.createAssetRefs || cc.sys.platform === cc.sys.EDITOR_CORE;
      var target = (false, false) && options.target;
      var customEnv = options.customEnv;
      var ignoreEditorOnly = options.ignoreEditorOnly;
      false;
      "string" === typeof data && (data = JSON.parse(data));
      var tempDetails = !details;
      details = details || Details.pool.get();
      var deserializer = _Deserializer.pool.get(details, target, classFinder, customEnv, ignoreEditorOnly);
      cc.game._isCloning = true;
      var res = deserializer.deserialize(data);
      cc.game._isCloning = false;
      _Deserializer.pool.put(deserializer);
      createAssetRefs && details.assignAssetsBy(Editor.serialize.asAsset);
      tempDetails && Details.pool.put(details);
      return res;
    };
    cc.deserialize.Details = Details;
    cc.deserialize.reportMissingClass = function(id) {
      false;
      cc.warnID(5302, id);
    };
  }), {
    "../utils/misc": 208,
    "./CCClass": 147,
    "./attribute": 159,
    "./js": 167
  } ],
  163: [ (function(require, module, exports) {
    var NonUuidMark = ".";
    function IdGenerater(category) {
      this.id = 0 | 998 * Math.random();
      this.prefix = category ? category + NonUuidMark : "";
    }
    IdGenerater.prototype.getNewId = function() {
      return this.prefix + ++this.id;
    };
    IdGenerater.global = new IdGenerater("global");
    module.exports = IdGenerater;
  }), {} ],
  164: [ (function(require, module, exports) {
    require("./js");
    require("./CCClass");
    require("./CCClassDecorator");
    require("./CCEnum");
    require("./CCObject");
    require("./callbacks-invoker");
    require("./url");
    require("./deserialize");
    require("./instantiate");
    require("./instantiate-jit");
    require("./requiring-frame");
    require("./CCSys");
    require("./CCMacro");
    true;
    require("./CCAssetLibrary");
    require("./CCVisibleRect");
  }), {
    "./CCAssetLibrary": 146,
    "./CCClass": 147,
    "./CCClassDecorator": 148,
    "./CCEnum": 149,
    "./CCMacro": 152,
    "./CCObject": 153,
    "./CCSys": 156,
    "./CCVisibleRect": 158,
    "./callbacks-invoker": 160,
    "./deserialize": 162,
    "./instantiate": 166,
    "./instantiate-jit": 165,
    "./js": 167,
    "./requiring-frame": 169,
    "./url": 170
  } ],
  165: [ (function(require, module, exports) {
    var CCObject = require("./CCObject");
    var Destroyed = CCObject.Flags.Destroyed;
    var PersistentMask = CCObject.Flags.PersistentMask;
    var Attr = require("./attribute");
    var js = require("./js");
    var CCClass = require("./CCClass");
    var Compiler = require("./compiler");
    var DEFAULT = Attr.DELIMETER + "default";
    var IDENTIFIER_RE = CCClass.IDENTIFIER_RE;
    var escapeForJS = CCClass.escapeForJS;
    var VAR = "var ";
    var LOCAL_OBJ = "o";
    var LOCAL_TEMP_OBJ = "t";
    var LOCAL_ARRAY = "a";
    var LINE_INDEX_OF_NEW_OBJ = 0;
    var DEFAULT_MODULE_CACHE = {
      "cc.Node": "cc.Node",
      "cc.Sprite": "cc.Sprite",
      "cc.Label": "cc.Label",
      "cc.Button": "cc.Button",
      "cc.Widget": "cc.Widget",
      "cc.Animation": "cc.Animation",
      "cc.ClickEvent": false,
      "cc.PrefabInfo": false
    };
    function Declaration(varName, expression) {
      this.varName = varName;
      this.expression = expression;
    }
    Declaration.prototype.toString = function() {
      return VAR + this.varName + "=" + this.expression + ";";
    };
    function mergeDeclaration(statement, expression) {
      return expression instanceof Declaration ? new Declaration(expression.varName, statement + expression.expression) : statement + expression;
    }
    function writeAssignment(codeArray, statement, expression) {
      if (Array.isArray(expression)) {
        expression[0] = mergeDeclaration(statement, expression[0]);
        codeArray.push(expression);
      } else codeArray.push(mergeDeclaration(statement, expression) + ";");
    }
    function Assignments(targetExpression) {
      this._exps = [];
      this._targetExp = targetExpression;
    }
    Assignments.prototype.append = function(key, expression) {
      this._exps.push([ key, expression ]);
    };
    Assignments.prototype.writeCode = function(codeArray) {
      var targetVar;
      if (this._exps.length > 1) {
        codeArray.push(LOCAL_TEMP_OBJ + "=" + this._targetExp + ";");
        targetVar = LOCAL_TEMP_OBJ;
      } else {
        if (1 !== this._exps.length) return;
        targetVar = this._targetExp;
      }
      for (var i = 0; i < this._exps.length; i++) {
        var pair = this._exps[i];
        writeAssignment(codeArray, targetVar + getPropAccessor(pair[0]) + "=", pair[1]);
      }
    };
    Assignments.pool = new js.Pool(function(obj) {
      obj._exps.length = 0;
      obj._targetExp = null;
    }, 1);
    Assignments.pool.get = function(targetExpression) {
      var cache = this._get() || new Assignments();
      cache._targetExp = targetExpression;
      return cache;
    };
    function equalsToDefault(def, value) {
      if ("function" === typeof def) try {
        def = def();
      } catch (e) {
        return false;
      }
      if (def === value) return true;
      if (def && value) {
        if (def instanceof cc.ValueType && def.equals(value)) return true;
        if (Array.isArray(def) && Array.isArray(value) || def.constructor === Object && value.constructor === Object) try {
          return Array.isArray(def) && Array.isArray(value) && 0 === def.length && 0 === value.length;
        } catch (e) {}
      }
      return false;
    }
    function getPropAccessor(key) {
      return IDENTIFIER_RE.test(key) ? "." + key : "[" + escapeForJS(key) + "]";
    }
    function Parser(obj, parent) {
      this.parent = parent;
      this.objsToClear_iN$t = [];
      this.codeArray = [];
      this.objs = [];
      this.funcs = [];
      this.funcModuleCache = js.createMap();
      js.mixin(this.funcModuleCache, DEFAULT_MODULE_CACHE);
      this.globalVariables = [];
      this.globalVariableId = 0;
      this.localVariableId = 0;
      this.codeArray.push(VAR + LOCAL_OBJ + "," + LOCAL_TEMP_OBJ + ";", "if(R){", LOCAL_OBJ + "=R;", "}else{", LOCAL_OBJ + "=R=new " + this.getFuncModule(obj.constructor, true) + "();", "}");
      obj._iN$t = {
        globalVar: "R"
      };
      this.objsToClear_iN$t.push(obj);
      this.enumerateObject(this.codeArray, obj);
      var globalVariablesDeclaration;
      this.globalVariables.length > 0 && (globalVariablesDeclaration = VAR + this.globalVariables.join(",") + ";");
      var code = Compiler.flattenCodeArray([ "return (function(R){", globalVariablesDeclaration || [], this.codeArray, "return o;", "})" ]);
      this.result = Function("O", "F", code)(this.objs, this.funcs);
      for (var i = 0, len = this.objsToClear_iN$t.length; i < len; ++i) this.objsToClear_iN$t[i]._iN$t = null;
      this.objsToClear_iN$t.length = 0;
    }
    var proto = Parser.prototype;
    proto.getFuncModule = function(func, usedInNew) {
      var clsName = js.getClassName(func);
      if (clsName) {
        var cache = this.funcModuleCache[clsName];
        if (cache) return cache;
        if (void 0 === cache) {
          var clsNameIsModule = -1 !== clsName.indexOf(".");
          if (clsNameIsModule) try {
            clsNameIsModule = func === Function("return " + clsName)();
            if (clsNameIsModule) {
              this.funcModuleCache[clsName] = clsName;
              return clsName;
            }
          } catch (e) {}
        }
      }
      var index = this.funcs.indexOf(func);
      if (index < 0) {
        index = this.funcs.length;
        this.funcs.push(func);
      }
      var res = "F[" + index + "]";
      usedInNew && (res = "(" + res + ")");
      this.funcModuleCache[clsName] = res;
      return res;
    };
    proto.getObjRef = function(obj) {
      var index = this.objs.indexOf(obj);
      if (index < 0) {
        index = this.objs.length;
        this.objs.push(obj);
      }
      return "O[" + index + "]";
    };
    proto.setValueType = function(codeArray, defaultValue, srcValue, targetExpression) {
      var assignments = Assignments.pool.get(targetExpression);
      var fastDefinedProps = defaultValue.constructor.__props__;
      fastDefinedProps || (fastDefinedProps = Object.keys(defaultValue));
      for (var i = 0; i < fastDefinedProps.length; i++) {
        var propName = fastDefinedProps[i];
        var prop = srcValue[propName];
        if (defaultValue[propName] === prop) continue;
        var expression = this.enumerateField(srcValue, propName, prop);
        assignments.append(propName, expression);
      }
      assignments.writeCode(codeArray);
      Assignments.pool.put(assignments);
    };
    proto.enumerateCCClass = function(codeArray, obj, klass) {
      var props = klass.__values__;
      var attrs = Attr.getClassAttrs(klass);
      for (var p = 0; p < props.length; p++) {
        var key = props[p];
        var val = obj[key];
        var defaultValue = attrs[key + DEFAULT];
        if (equalsToDefault(defaultValue, val)) continue;
        if ("object" === typeof val && val instanceof cc.ValueType) {
          defaultValue = CCClass.getDefault(defaultValue);
          if (defaultValue && defaultValue.constructor === val.constructor) {
            var targetExpression = LOCAL_OBJ + getPropAccessor(key);
            this.setValueType(codeArray, defaultValue, val, targetExpression);
            continue;
          }
        }
        this.setObjProp(codeArray, obj, key, val);
      }
    };
    proto.instantiateArray = function(value) {
      if (0 === value.length) return "[]";
      var arrayVar = LOCAL_ARRAY + ++this.localVariableId;
      var declaration = new Declaration(arrayVar, "new Array(" + value.length + ")");
      var codeArray = [ declaration ];
      value._iN$t = {
        globalVar: "",
        source: codeArray
      };
      this.objsToClear_iN$t.push(value);
      for (var i = 0; i < value.length; ++i) {
        var statement = arrayVar + "[" + i + "]=";
        var expression = this.enumerateField(value, i, value[i]);
        writeAssignment(codeArray, statement, expression);
      }
      return codeArray;
    };
    proto.enumerateField = function(obj, key, value) {
      if ("object" === typeof value && value) {
        var _iN$t = value._iN$t;
        if (_iN$t) {
          var globalVar = _iN$t.globalVar;
          if (!globalVar) {
            globalVar = _iN$t.globalVar = "v" + ++this.globalVariableId;
            this.globalVariables.push(globalVar);
            var line = _iN$t.source[LINE_INDEX_OF_NEW_OBJ];
            _iN$t.source[LINE_INDEX_OF_NEW_OBJ] = mergeDeclaration(globalVar + "=", line);
          }
          return globalVar;
        }
        return Array.isArray(value) ? this.instantiateArray(value) : this.instantiateObj(value);
      }
      if ("function" === typeof value) return this.getFuncModule(value);
      if ("string" === typeof value) return escapeForJS(value);
      "_objFlags" === key && obj instanceof CCObject && (value &= PersistentMask);
      return value;
    };
    proto.setObjProp = function(codeArray, obj, key, value) {
      var statement = LOCAL_OBJ + getPropAccessor(key) + "=";
      var expression = this.enumerateField(obj, key, value);
      writeAssignment(codeArray, statement, expression);
    };
    proto.enumerateObject = function(codeArray, obj) {
      var klass = obj.constructor;
      if (cc.Class._isCCClass(klass)) this.enumerateCCClass(codeArray, obj, klass); else for (var key in obj) {
        if (!obj.hasOwnProperty(key) || 95 === key.charCodeAt(0) && 95 === key.charCodeAt(1) && "__type__" !== key) continue;
        var value = obj[key];
        if ("object" === typeof value && value && value === obj._iN$t) continue;
        this.setObjProp(codeArray, obj, key, value);
      }
    };
    proto.instantiateObj = function(obj) {
      if (obj instanceof cc.ValueType) return CCClass.getNewValueTypeCode(obj);
      if (obj instanceof cc.Asset) return this.getObjRef(obj);
      if (obj._objFlags & Destroyed) return null;
      var createCode;
      var ctor = obj.constructor;
      if (cc.Class._isCCClass(ctor)) {
        if (this.parent) if (this.parent instanceof cc.Component) {
          if (obj instanceof cc._BaseNode || obj instanceof cc.Component) return this.getObjRef(obj);
        } else if (this.parent instanceof cc._BaseNode) if (obj instanceof cc._BaseNode) {
          if (!obj.isChildOf(this.parent)) return this.getObjRef(obj);
        } else if (obj instanceof cc.Component && !obj.node.isChildOf(this.parent)) return this.getObjRef(obj);
        createCode = new Declaration(LOCAL_OBJ, "new " + this.getFuncModule(ctor, true) + "()");
      } else if (ctor === Object) createCode = new Declaration(LOCAL_OBJ, "{}"); else {
        if (ctor) return this.getObjRef(obj);
        createCode = new Declaration(LOCAL_OBJ, "Object.create(null)");
      }
      var codeArray = [ createCode ];
      obj._iN$t = {
        globalVar: "",
        source: codeArray
      };
      this.objsToClear_iN$t.push(obj);
      this.enumerateObject(codeArray, obj);
      return [ "(function(){", codeArray, "return o;})();" ];
    };
    function compile(node) {
      var root = node instanceof cc._BaseNode && node;
      var parser = new Parser(node, root);
      return parser.result;
    }
    module.exports = {
      compile: compile,
      equalsToDefault: equalsToDefault
    };
    false;
  }), {
    "./CCClass": 147,
    "./CCObject": 153,
    "./attribute": 159,
    "./compiler": 161,
    "./js": 167
  } ],
  166: [ (function(require, module, exports) {
    var CCObject = require("./CCObject");
    var CCValueType = require("../value-types/value-type");
    var Destroyed = CCObject.Flags.Destroyed;
    var PersistentMask = CCObject.Flags.PersistentMask;
    var _isDomNode = require("./utils").isDomNode;
    function instantiate(original, internal_force) {
      if (!internal_force) {
        if ("object" !== typeof original || Array.isArray(original)) {
          false;
          return null;
        }
        if (!original) {
          false;
          return null;
        }
        if (!cc.isValid(original)) {
          false;
          return null;
        }
        false;
      }
      var clone;
      if (original instanceof CCObject) {
        if (original._instantiate) {
          cc.game._isCloning = true;
          clone = original._instantiate();
          cc.game._isCloning = false;
          return clone;
        }
        if (original instanceof cc.Asset) {
          false;
          return null;
        }
      }
      cc.game._isCloning = true;
      clone = doInstantiate(original);
      cc.game._isCloning = false;
      return clone;
    }
    var objsToClearTmpVar = [];
    function doInstantiate(obj, parent) {
      if (Array.isArray(obj)) {
        false;
        return null;
      }
      if (_isDomNode && _isDomNode(obj)) {
        false;
        return null;
      }
      var clone;
      if (obj._iN$t) clone = obj._iN$t; else if (obj.constructor) {
        var klass = obj.constructor;
        clone = new klass();
      } else clone = Object.create(null);
      enumerateObject(obj, clone, parent);
      for (var i = 0, len = objsToClearTmpVar.length; i < len; ++i) objsToClearTmpVar[i]._iN$t = null;
      objsToClearTmpVar.length = 0;
      return clone;
    }
    function enumerateCCClass(klass, obj, clone, parent) {
      var props = klass.__values__;
      for (var p = 0; p < props.length; p++) {
        var key = props[p];
        var value = obj[key];
        if ("object" === typeof value && value) {
          var initValue = clone[key];
          initValue instanceof CCValueType && initValue.constructor === value.constructor ? initValue.set(value) : clone[key] = value._iN$t || instantiateObj(value, parent);
        } else clone[key] = value;
      }
    }
    function enumerateObject(obj, clone, parent) {
      obj._iN$t = clone;
      objsToClearTmpVar.push(obj);
      var klass = obj.constructor;
      if (cc.Class._isCCClass(klass)) enumerateCCClass(klass, obj, clone, parent); else for (var key in obj) {
        if (!obj.hasOwnProperty(key) || 95 === key.charCodeAt(0) && 95 === key.charCodeAt(1) && "__type__" !== key) continue;
        var value = obj[key];
        if ("object" === typeof value && value) {
          if (value === clone) continue;
          clone[key] = value._iN$t || instantiateObj(value, parent);
        } else clone[key] = value;
      }
      obj instanceof CCObject && (clone._objFlags &= PersistentMask);
    }
    function instantiateObj(obj, parent) {
      if (obj instanceof CCValueType) return obj.clone();
      if (obj instanceof cc.Asset) return obj;
      var clone;
      if (Array.isArray(obj)) {
        var len = obj.length;
        clone = new Array(len);
        obj._iN$t = clone;
        for (var i = 0; i < len; ++i) {
          var value = obj[i];
          clone[i] = "object" === typeof value && value ? value._iN$t || instantiateObj(value, parent) : value;
        }
        objsToClearTmpVar.push(obj);
        return clone;
      }
      if (obj._objFlags & Destroyed) return null;
      var ctor = obj.constructor;
      if (cc.Class._isCCClass(ctor)) {
        if (parent) if (parent instanceof cc.Component) {
          if (obj instanceof cc._BaseNode || obj instanceof cc.Component) return obj;
        } else if (parent instanceof cc._BaseNode) if (obj instanceof cc._BaseNode) {
          if (!obj.isChildOf(parent)) return obj;
        } else if (obj instanceof cc.Component && !obj.node.isChildOf(parent)) return obj;
        clone = new ctor();
      } else if (ctor === Object) clone = {}; else {
        if (ctor) return obj;
        clone = Object.create(null);
      }
      enumerateObject(obj, clone, parent);
      return clone;
    }
    instantiate._clone = doInstantiate;
    cc.instantiate = instantiate;
    module.exports = instantiate;
  }), {
    "../value-types/value-type": 222,
    "./CCObject": 153,
    "./utils": 171
  } ],
  167: [ (function(require, module, exports) {
    var tempCIDGenerater = new (require("./id-generater"))("TmpCId.");
    function _getPropertyDescriptor(obj, name) {
      while (obj) {
        var pd = Object.getOwnPropertyDescriptor(obj, name);
        if (pd) return pd;
        obj = Object.getPrototypeOf(obj);
      }
      return null;
    }
    function _copyprop(name, source, target) {
      var pd = _getPropertyDescriptor(source, name);
      Object.defineProperty(target, name, pd);
    }
    var js = {
      isNumber: function(obj) {
        return "number" === typeof obj || obj instanceof Number;
      },
      isString: function(obj) {
        return "string" === typeof obj || obj instanceof String;
      },
      addon: function(obj) {
        "use strict";
        obj = obj || {};
        for (var i = 1, length = arguments.length; i < length; i++) {
          var source = arguments[i];
          if (source) {
            if ("object" !== typeof source) {
              cc.errorID(5402, source);
              continue;
            }
            for (var name in source) name in obj || _copyprop(name, source, obj);
          }
        }
        return obj;
      },
      mixin: function(obj) {
        "use strict";
        obj = obj || {};
        for (var i = 1, length = arguments.length; i < length; i++) {
          var source = arguments[i];
          if (source) {
            if ("object" !== typeof source) {
              cc.errorID(5403, source);
              continue;
            }
            for (var name in source) _copyprop(name, source, obj);
          }
        }
        return obj;
      },
      extend: function(cls, base) {
        false;
        for (var p in base) base.hasOwnProperty(p) && (cls[p] = base[p]);
        cls.prototype = Object.create(base.prototype, {
          constructor: {
            value: cls,
            writable: true,
            configurable: true
          }
        });
        return cls;
      },
      getSuper: function(ctor) {
        var proto = ctor.prototype;
        var dunderProto = proto && Object.getPrototypeOf(proto);
        return dunderProto && dunderProto.constructor;
      },
      isChildClassOf: function(subclass, superclass) {
        if (subclass && superclass) {
          if ("function" !== typeof subclass) return false;
          if ("function" !== typeof superclass) {
            false;
            return false;
          }
          if (subclass === superclass) return true;
          for (;;) {
            subclass = js.getSuper(subclass);
            if (!subclass) return false;
            if (subclass === superclass) return true;
          }
        }
        return false;
      },
      clear: function(obj) {
        var keys = Object.keys(obj);
        for (var i = 0; i < keys.length; i++) delete obj[keys[i]];
      },
      getPropertyDescriptor: _getPropertyDescriptor
    };
    var tmpValueDesc = {
      value: void 0,
      enumerable: false,
      writable: false,
      configurable: true
    };
    js.value = function(obj, prop, value, writable, enumerable) {
      tmpValueDesc.value = value;
      tmpValueDesc.writable = writable;
      tmpValueDesc.enumerable = enumerable;
      Object.defineProperty(obj, prop, tmpValueDesc);
      tmpValueDesc.value = void 0;
    };
    var tmpGetSetDesc = {
      get: null,
      set: null,
      enumerable: false
    };
    js.getset = function(obj, prop, getter, setter, enumerable) {
      if ("function" !== typeof setter) {
        enumerable = setter;
        setter = void 0;
      }
      tmpGetSetDesc.get = getter;
      tmpGetSetDesc.set = setter;
      tmpGetSetDesc.enumerable = enumerable;
      Object.defineProperty(obj, prop, tmpGetSetDesc);
      tmpGetSetDesc.get = null;
      tmpGetSetDesc.set = null;
    };
    var tmpGetDesc = {
      get: null,
      enumerable: false,
      configurable: false
    };
    js.get = function(obj, prop, getter, enumerable, configurable) {
      tmpGetDesc.get = getter;
      tmpGetDesc.enumerable = enumerable;
      tmpGetDesc.configurable = configurable;
      Object.defineProperty(obj, prop, tmpGetDesc);
      tmpGetDesc.get = null;
    };
    var tmpSetDesc = {
      set: null,
      enumerable: false,
      configurable: false
    };
    js.set = function(obj, prop, setter, enumerable, configurable) {
      tmpSetDesc.set = setter;
      tmpSetDesc.enumerable = enumerable;
      tmpSetDesc.configurable = configurable;
      Object.defineProperty(obj, prop, tmpSetDesc);
      tmpSetDesc.set = null;
    };
    js.getClassName = function(objOrCtor) {
      if ("function" === typeof objOrCtor) {
        var prototype = objOrCtor.prototype;
        if (prototype && prototype.hasOwnProperty("__classname__") && prototype.__classname__) return prototype.__classname__;
        var retval = "";
        objOrCtor.name && (retval = objOrCtor.name);
        if (objOrCtor.toString) {
          var arr, str = objOrCtor.toString();
          arr = "[" === str.charAt(0) ? str.match(/\[\w+\s*(\w+)\]/) : str.match(/function\s*(\w+)/);
          arr && 2 === arr.length && (retval = arr[1]);
        }
        return "Object" !== retval ? retval : "";
      }
      if (objOrCtor && objOrCtor.constructor) return js.getClassName(objOrCtor.constructor);
      return "";
    };
    function isTempClassId(id) {
      return "string" !== typeof id || id.startsWith(tempCIDGenerater.prefix);
    }
    (function() {
      var _idToClass = {};
      var _nameToClass = {};
      function getRegister(key, table) {
        return function(id, constructor) {
          constructor.prototype.hasOwnProperty(key) && delete table[constructor.prototype[key]];
          js.value(constructor.prototype, key, id);
          if (id) {
            var registered = table[id];
            if (registered && registered !== constructor) {
              var error = "A Class already exists with the same " + key + ' : "' + id + '".';
              false;
              cc.error(error);
            } else table[id] = constructor;
          }
        };
      }
      js._setClassId = getRegister("__cid__", _idToClass);
      var doSetClassName = getRegister("__classname__", _nameToClass);
      js.setClassName = function(className, constructor) {
        doSetClassName(className, constructor);
        if (!constructor.prototype.hasOwnProperty("__cid__")) {
          var id = className || tempCIDGenerater.getNewId();
          id && js._setClassId(id, constructor);
        }
      };
      js.unregisterClass = function() {
        for (var i = 0; i < arguments.length; i++) {
          var p = arguments[i].prototype;
          var classId = p.__cid__;
          classId && delete _idToClass[classId];
          var classname = p.__classname__;
          classname && delete _nameToClass[classname];
        }
      };
      js._getClassById = function(classId) {
        return _idToClass[classId];
      };
      js.getClassByName = function(classname) {
        return _nameToClass[classname];
      };
      js._getClassId = function(obj, allowTempId) {
        allowTempId = "undefined" === typeof allowTempId || allowTempId;
        var res;
        if ("function" === typeof obj && obj.prototype.hasOwnProperty("__cid__")) {
          res = obj.prototype.__cid__;
          if (!allowTempId && (false, false) && isTempClassId(res)) return "";
          return res;
        }
        if (obj && obj.constructor) {
          var prototype = obj.constructor.prototype;
          if (prototype && prototype.hasOwnProperty("__cid__")) {
            res = obj.__cid__;
            if (!allowTempId && (false, false) && isTempClassId(res)) return "";
            return res;
          }
        }
        return "";
      };
      false;
    })();
    js.obsolete = function(obj, obsoleted, newExpr, writable) {
      var extractPropName = /([^.]+)$/;
      var oldProp = extractPropName.exec(obsoleted)[0];
      var newProp = extractPropName.exec(newExpr)[0];
      function get() {
        false;
        return this[newProp];
      }
      writable ? js.getset(obj, oldProp, get, (function(value) {
        false;
        this[newProp] = value;
      })) : js.get(obj, oldProp, get);
    };
    js.obsoletes = function(obj, objName, props, writable) {
      for (var obsoleted in props) {
        var newName = props[obsoleted];
        js.obsolete(obj, objName + "." + obsoleted, newName, writable);
      }
    };
    var REGEXP_NUM_OR_STR = /(%d)|(%s)/;
    var REGEXP_STR = /%s/;
    js.formatStr = function() {
      var argLen = arguments.length;
      if (0 === argLen) return "";
      var msg = arguments[0];
      if (1 === argLen) return "" + msg;
      var hasSubstitution = "string" === typeof msg && REGEXP_NUM_OR_STR.test(msg);
      if (hasSubstitution) for (var i = 1; i < argLen; ++i) {
        var arg = arguments[i];
        var regExpToTest = "number" === typeof arg ? REGEXP_NUM_OR_STR : REGEXP_STR;
        regExpToTest.test(msg) ? msg = msg.replace(regExpToTest, arg) : msg += " " + arg;
      } else for (var _i = 1; _i < argLen; ++_i) msg += " " + arguments[_i];
      return msg;
    };
    js.shiftArguments = function() {
      var len = arguments.length - 1;
      var args = new Array(len);
      for (var i = 0; i < len; ++i) args[i] = arguments[i + 1];
      return args;
    };
    js.createMap = function(forceDictMode) {
      var map = Object.create(null);
      if (forceDictMode) {
        var INVALID_IDENTIFIER_1 = ".";
        var INVALID_IDENTIFIER_2 = "/";
        map[INVALID_IDENTIFIER_1] = true;
        map[INVALID_IDENTIFIER_2] = true;
        delete map[INVALID_IDENTIFIER_1];
        delete map[INVALID_IDENTIFIER_2];
      }
      return map;
    };
    function removeAt(array, index) {
      array.splice(index, 1);
    }
    function fastRemoveAt(array, index) {
      var length = array.length;
      if (index < 0 || index >= length) return;
      array[index] = array[length - 1];
      array.length = length - 1;
    }
    function remove(array, value) {
      var index = array.indexOf(value);
      if (index >= 0) {
        removeAt(array, index);
        return true;
      }
      return false;
    }
    function fastRemove(array, value) {
      var index = array.indexOf(value);
      if (index >= 0) {
        array[index] = array[array.length - 1];
        --array.length;
      }
    }
    function verifyType(array, type) {
      if (array && array.length > 0) for (var i = 0; i < array.length; i++) if (!(array[i] instanceof type)) {
        cc.logID(1300);
        return false;
      }
      return true;
    }
    function removeArray(array, minusArr) {
      for (var i = 0, l = minusArr.length; i < l; i++) remove(array, minusArr[i]);
    }
    function appendObjectsAt(array, addObjs, index) {
      array.splice.apply(array, [ index, 0 ].concat(addObjs));
      return array;
    }
    var indexOf = Array.prototype.indexOf;
    function contains(array, value) {
      return array.indexOf(value) >= 0;
    }
    function copy(array) {
      var i, len = array.length, arr_clone = new Array(len