"use strict";
cc._RF.push(module, 'c7740GnumdE+7dwFSqErqYQ', 'SimpleBulletView');
// Script/SimpleBulletView.ts

//    Copyright (C) 2016-2018 __COMPANY_NAME
//    All rights reserved
//
//    created by zone at 2018-05-12 21:16
Object.defineProperty(exports, "__esModule", { value: true });
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property, disallowMultiple = _a.disallowMultiple, menu = _a.menu;
function pSetInLength(v, len) {
    v.normalizeSelf();
    v.mulSelf(len);
}
exports.pSetInLength = pSetInLength;
var SimpleBulletView = /** @class */ (function (_super) {
    __extends(SimpleBulletView, _super);
    function SimpleBulletView() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.id = 0;
        _this.acc = 0;
        // endPos:cc.Vec2
        _this.isDying = false;
        _this._dyingCnt = 0;
        _this.inited = false;
        _this.isFirstUpdate = false;
        return _this;
    }
    SimpleBulletView.prototype.start = function () {
    };
    SimpleBulletView.prototype.reuse = function (id, pos, endPos, curVel, acc) {
        this.endPos = endPos;
        this.isDying = false;
        this._dyingCnt = 0;
        this.id = id;
        this.node.setPosition(pos);
        var dir = endPos.sub(pos);
        pSetInLength(dir, curVel);
        this.speed = dir;
        this.acc = acc;
        this.inited = true;
        this.isFirstUpdate = true;
    };
    SimpleBulletView.prototype.unuse = function () {
    };
    SimpleBulletView.prototype.lateUpdate = function (dt) {
        if (!this.inited)
            return;
        if (this.isFirstUpdate) {
            this.isFirstUpdate = false;
            return;
        }
        var speedLen;
        if (this.isDying)
            return;
        speedLen = this.speed.mag();
        speedLen += this.acc * dt;
        pSetInLength(this.speed, speedLen);
        this.node.x += this.speed.x * dt;
        this.node.y += this.speed.y * dt;
        if (this.endPos) {
            var isXOver = false;
            var isYOver = false;
            if (this.speed.x > 0) {
                isXOver = this.node.x >= this.endPos.x;
            }
            else {
                isXOver = this.node.x <= this.endPos.x;
            }
            if (this.speed.y > 0) {
                isYOver = this.node.y >= this.endPos.y;
            }
            else {
                isYOver = this.node.y <= this.endPos.y;
            }
            if (isXOver && isYOver) {
                this.die(this.endPos);
                // this.destroy()
            }
        }
    };
    SimpleBulletView.prototype.die = function (pos) {
        var _this = this;
        if (this.isDying)
            return;
        this.isDying = true;
        if (pos) {
            this.node.setPosition(pos);
        }
        this.getComponent(cc.MotionStreak).reset();
        var disappearTime = 0.2;
        this.node.runAction(cc.sequence(cc.delayTime(disappearTime), cc.callFunc(function () {
            _this.node.destroy();
            _this.inited = false;
        })));
    };
    SimpleBulletView = __decorate([
        ccclass,
        disallowMultiple,
        menu("View/SimpleBulletView")
    ], SimpleBulletView);
    return SimpleBulletView;
}(cc.Component));
exports.SimpleBulletView = SimpleBulletView;

cc._RF.pop();