(function() {"use strict";var __module = CC_EDITOR ? module : {exports:{}};var __filename = 'preview-scripts/assets/Script/Helloworld.js';var __require = CC_EDITOR ? function (request) {return cc.require(request, require);} : function (request) {return cc.require(request, __filename);};function __define (exports, require, module) {"use strict";
cc._RF.push(module, 'e1b90/rohdEk4SdmmEZANaD', 'Helloworld', __filename);
// Script/Helloworld.ts

Object.defineProperty(exports, "__esModule", { value: true });
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
function addTouchEvent(com) {
    com.node.on(cc.Node.EventType.TOUCH_START, com.onTouchStart, com);
    com.node.on(cc.Node.EventType.TOUCH_MOVE, com.onTouchMove, com);
    com.node.on(cc.Node.EventType.TOUCH_END, com.onTouchEnd, com);
    com.node.on(cc.Node.EventType.TOUCH_CANCEL, com.onTouchEnd, com);
    // onTouchStart(eve:cc.Event.EventTouch){
    //
    // }
    // onTouchMove(eve:cc.Event.EventTouch){
    //
    // }
    // onTouchEnd(eve:cc.Event.EventTouch){
    //
    // }
}
exports.addTouchEvent = addTouchEvent;
var Helloworld = /** @class */ (function (_super) {
    __extends(Helloworld, _super);
    function Helloworld() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.label = null;
        _this.text = 'hello';
        _this.bulletPf = null;
        _this.isPress = false;
        _this.playerVel = 0;
        _this.showCnt = 0;
        return _this;
    }
    Helloworld.prototype.onLoad = function () {
        cc.director.getPhysicsManager().gravity = cc.v2(0, 0);
        cc.director.getPhysicsManager().enabled = true;
        this.velStr = cc.find("Vel").getComponent(cc.Label);
    };
    Helloworld.prototype.start = function () {
        this.moveVector = cc.v2();
        this.label.string = this.text;
        this.player = cc.find("World/Player");
        cc.game.setFrameRate(30);
        addTouchEvent(this);
    };
    Helloworld.prototype.update = function (dt) {
        var rigidBody = this.player.getComponent(cc.RigidBody);
        if (this.moveVector.x == 0) {
            rigidBody.linearVelocity = cc.v2();
        }
        else {
            var addV = 500;
            // if(cc.sys.platform==cc.sys.WECHAT_GAME){
            //     addV=2000
            // }
            rigidBody.applyLinearImpulse(this.moveVector.mul(addV), this.player.position, true);
            var curSpeed = rigidBody.linearVelocity;
            // rigidBody.linearVelocity=this.moveVector.mul(500)
            var curVelocity = curSpeed.mag();
            var limit = 500;
            // if(cc.sys.platform==cc.sys.WECHAT_GAME) {
            //     limit=1000
            // }
            if (curVelocity > limit) {
                var newvec = curSpeed.normalize().mul(limit);
                rigidBody.linearVelocity = newvec;
            }
        }
    };
    Helloworld.prototype.lateUpdate = function (dt) {
        if (!this.lastPos)
            this.lastPos = this.player.getPosition();
        this.showCnt += dt;
        if (this.showCnt > 0.5) {
            this.velStr.string = String(Math.round(this.player.position.sub(this.lastPos).mag() / dt));
            this.showCnt = 0;
        }
        this.lastPos = this.player.getPosition();
    };
    Helloworld.prototype.onTouchStart = function (eve) {
        this.isPress = true;
        var n = eve.getLocation();
        if (n.x > 960 / 2) {
            this.moveVector = cc.v2(1, 0);
        }
        else {
            this.moveVector = cc.v2(-1, 0);
        }
    };
    Helloworld.prototype.onTouchMove = function (eve) {
    };
    Helloworld.prototype.onTouchEnd = function (eve) {
        this.isPress = false;
        this.moveVector = cc.v2();
    };
    __decorate([
        property(cc.Label)
    ], Helloworld.prototype, "label", void 0);
    __decorate([
        property
    ], Helloworld.prototype, "text", void 0);
    __decorate([
        property(cc.Prefab)
    ], Helloworld.prototype, "bulletPf", void 0);
    Helloworld = __decorate([
        ccclass
    ], Helloworld);
    return Helloworld;
}(cc.Component));
exports.default = Helloworld;

cc._RF.pop();
        }
        if (CC_EDITOR) {
            __define(__module.exports, __require, __module);
        }
        else {
            cc.registerModuleFunc(__filename, function () {
                __define(__module.exports, __require, __module);
            });
        }
        })();
        //# sourceMappingURL=Helloworld.js.map
        