"use strict";
cc._RF.push(module, 'e1187Zr6rhIIbT5o8zZ+9zT', 'mesh-texture');
// mesh-texture.js

"use strict";

var gfx = cc.gfx;

cc.Class({
    extends: cc.Component,

    editor: CC_EDITOR && {
        requireComponent: cc.MeshRenderer
    },

    properties: {
        speed: 50
    },

    // LIFE-CYCLE CALLBACKS:

    // onLoad () {},

    start: function start() {
        var vfmt = new gfx.VertexFormat([{ name: gfx.ATTR_POSITION, type: gfx.ATTR_TYPE_FLOAT32, num: 2 }, { name: gfx.ATTR_UV0, type: gfx.ATTR_TYPE_FLOAT32, num: 2 }]);

        var mesh = new cc.Mesh();
        mesh.init(vfmt, 9, true);
        this.mesh = mesh;

        this.vertexes = [cc.v2(-100, 100), cc.v2(0, 100), cc.v2(100, 100), cc.v2(-100, 0), cc.v2(0, 0), cc.v2(100, 0), cc.v2(-100, -100), cc.v2(0, -100), cc.v2(100, -100)];

        mesh.setVertices(gfx.ATTR_POSITION, this.vertexes);

        mesh.setVertices(gfx.ATTR_UV0, [cc.v2(0, 0), cc.v2(0.5, 0), cc.v2(1, 0), cc.v2(0, 0.5), cc.v2(0.5, 0.5), cc.v2(1, 0.5), cc.v2(0, 1), cc.v2(0.5, 1), cc.v2(1, 1)]);

        mesh.setIndices([0, 1, 3, 1, 4, 3, 1, 2, 4, 2, 5, 4, 3, 4, 6, 4, 7, 6, 4, 5, 7, 5, 8, 7]);

        var renderer = this.node.getComponent(cc.MeshRenderer);
        if (!renderer) {
            renderer = this.node.addComponent(cc.MeshRenderer);
        }
        renderer.mesh = mesh;
        this.mesh = mesh;
    }
});

cc._RF.pop();