const { ccclass, property } = cc._decorator;

@ccclass
export default class DragonBones extends cc.Component {

    @property(cc.Node)
    touchHandler: cc.Node = null;

    armatureDisplay: dragonBones.ArmatureDisplay = null;
    armature: dragonBones.Armature = null;
    aimDir = 0;
    aimRadian = 0;
    aimState = null;
    target: cc.Vec2;
    beginLocation: cc.Vec2;
    bow_Point: cc.Vec2;

    start() {
        this.armatureDisplay = this.getComponent(dragonBones.ArmatureDisplay);
        this.armature = this.armatureDisplay.armature();

        dragonBones.WorldClock.clock.add(this.armature);


        this.touchHandler.on(cc.Node.EventType.TOUCH_MOVE, this.onTouchMove, this, true);
        this.touchHandler.on(cc.Node.EventType.TOUCH_START, this.onTouchStart, this, true);
        this.touchHandler.on(cc.Node.EventType.TOUCH_END, this.onTouchEnd, this, true);
        this.touchHandler.on(cc.Node.EventType.TOUCH_CANCEL, this.onTouchEnd, this, true);
    }

    onTouchStart(e: cc.Event.EventTouch) {
        this.beginLocation = e.getLocation();
        this.armature.animation.play("open_normal", 1);
    }

    onTouchMove(e: cc.Event.EventTouch) {
        let touches = e.getTouches();
        let touchLoc = touches[0].getLocation();
        this.aim(touchLoc.x, touchLoc.y);

        let firePointBone = this.armature.getBone("bow");
        let localPoint = cc.v2(firePointBone.global.x, -firePointBone.global.y);
        this.bow_Point = this.node.convertToWorldSpaceAR(localPoint);

    }

    onTouchEnd(e: cc.Event.EventTouch) {
        if (this.beginLocation.x - e.getLocation().x === 0) {
            return;
        }
        this.armature.animation.play("shoot_normal", 1);
    }

    aim(x: number, y: number) {
        if (this.aimDir === 0) {
            this.aimDir = 10;
        }

        this.target = this.node.getParent().convertToNodeSpaceAR(cc.v2(x, y));
    }

    update(dt) {
        this._updateAim();
    }

    _updateAim() {
        if (this.aimDir === 0) {
            return;
        }

        let vec = cc.v2(this.target.x, this.target.y).sub(this.beginLocation).neg();
        let hudu = Math.atan2(-(vec.y), vec.x);
        if (Math.abs(hudu) < Math.PI / 4) {
            this.aimRadian = hudu;
        }

        // this._aimState.weight = Math.abs(this._aimRadian / Math.PI * 2);
        this.armature.getBone("body").offset.rotation = -this.aimRadian;
        console.log(this.armature.getBone("body").offset.rotation);
        this.armature.invalidUpdate();
        this.aimDir = 0;
    }

    // update (dt) {},
}
