(function() {"use strict";var __module = CC_EDITOR ? module : {exports:{}};var __filename = 'preview-scripts/assets/Script/dragon_bones.js';var __require = CC_EDITOR ? function (request) {return cc.require(request, require);} : function (request) {return cc.require(request, __filename);};function __define (exports, require, module) {"use strict";
cc._RF.push(module, '7d5beInAPZE9bYEm/7t7vso', 'dragon_bones', __filename);
// Script/dragon_bones.ts

Object.defineProperty(exports, "__esModule", { value: true });
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var DragonBones = /** @class */ (function (_super) {
    __extends(DragonBones, _super);
    function DragonBones() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.touchHandler = null;
        _this.armatureDisplay = null;
        _this.armature = null;
        _this.aimDir = 0;
        _this.aimRadian = 0;
        _this.aimState = null;
        return _this;
        // update (dt) {},
    }
    DragonBones.prototype.start = function () {
        this.armatureDisplay = this.getComponent(dragonBones.ArmatureDisplay);
        this.armature = this.armatureDisplay.armature();
        dragonBones.WorldClock.clock.add(this.armature);
        this.touchHandler.on(cc.Node.EventType.TOUCH_MOVE, this.onTouchMove, this, true);
        this.touchHandler.on(cc.Node.EventType.TOUCH_START, this.onTouchStart, this, true);
        this.touchHandler.on(cc.Node.EventType.TOUCH_END, this.onTouchEnd, this, true);
        this.touchHandler.on(cc.Node.EventType.TOUCH_CANCEL, this.onTouchEnd, this, true);
    };
    DragonBones.prototype.onTouchStart = function (e) {
        this.beginLocation = e.getLocation();
        this.armature.animation.play("open_normal", 1);
    };
    DragonBones.prototype.onTouchMove = function (e) {
        var touches = e.getTouches();
        var touchLoc = touches[0].getLocation();
        this.aim(touchLoc.x, touchLoc.y);
        var firePointBone = this.armature.getBone("bow");
        var localPoint = cc.v2(firePointBone.global.x, -firePointBone.global.y);
        this.bow_Point = this.node.convertToWorldSpaceAR(localPoint);
    };
    DragonBones.prototype.onTouchEnd = function (e) {
        if (this.beginLocation.x - e.getLocation().x === 0) {
            return;
        }
        this.armature.animation.play("shoot_normal", 1);
    };
    DragonBones.prototype.aim = function (x, y) {
        if (this.aimDir === 0) {
            this.aimDir = 10;
        }
        this.target = this.node.getParent().convertToNodeSpaceAR(cc.v2(x, y));
    };
    DragonBones.prototype.update = function (dt) {
        this._updateAim();
    };
    DragonBones.prototype._updateAim = function () {
        if (this.aimDir === 0) {
            return;
        }
        var vec = cc.v2(this.target.x, this.target.y).sub(this.beginLocation).neg();
        var hudu = Math.atan2(-(vec.y), vec.x);
        if (Math.abs(hudu) < Math.PI / 4) {
            this.aimRadian = hudu;
        }
        // this._aimState.weight = Math.abs(this._aimRadian / Math.PI * 2);
        this.armature.getBone("body").offset.rotation = -this.aimRadian;
        console.log(this.armature.getBone("body").offset.rotation);
        this.armature.invalidUpdate();
        this.aimDir = 0;
    };
    __decorate([
        property(cc.Node)
    ], DragonBones.prototype, "touchHandler", void 0);
    DragonBones = __decorate([
        ccclass
    ], DragonBones);
    return DragonBones;
}(cc.Component));
exports.default = DragonBones;

cc._RF.pop();
        }
        if (CC_EDITOR) {
            __define(__module.exports, __require, __module);
        }
        else {
            cc.registerModuleFunc(__filename, function () {
                __define(__module.exports, __require, __module);
            });
        }
        })();
        //# sourceMappingURL=dragon_bones.js.map
        