cc.Class({
    extends: cc.Component,

    properties: {
        label: {
            default: null,
            type: cc.Label
        },
        // defaults, set visually when attaching this script to the Canvas
        text: 'Hello, World!',
        spineboy: cc.Node,
    },

    // use this for initialization
    onLoad: function () {
        this.label.string = this.text;
        this.spineboy.active = false;
    },
    start() {
        this.createSpine("spineboy");
        setTimeout(() => {
            this._spineNode.removeComponent(this._ske);
            this._ske.destroy();
            this._spineNode.destroy();
            this.spineboy.active = true;
        }, 2000)
    },
    // called every frame
    update: function (dt) {

    },
    createSpine(path) {
        let node = new cc.Node;
        let ske = node.addComponent(sp.Skeleton);
        ske.setAnimationCacheMode(sp.Skeleton.AnimationCacheMode.SHARED_CACHE);
        ske.setCompleteListener(function (event) {
            console.log("spineCompleteListener:", event, event.trackIndex)
        })
        cc.resources.load(path, sp.SkeletonData, () => { }, (err, skeRes) => {
            ske.skeletonData = skeRes;
            let animate = ske.setAnimation(0, 'run', true);
        })
        this.spineboy.addChild(node);
        this._spineNode = node;
        this._ske = ske;
    },
});
