// var Utils = require('Utils');
cc.Class({
    extends: cc.Component,

    properties: {

        m_n_gamecamera: cc.Node,

        m_sp_maingold: cc.Node,
        m_l_maingold: cc.Label,
        m_n_gamenode: cc.Node,
        m_l_score: cc.Label,
        // m_n_prize_draw: cc.Node,

        m_pre_relive: cc.Prefab,
        m_n_firstblock: cc.Node,
        m_pre_block: cc.Prefab,
        m_n_UI: cc.Node,
        m_n_blood: cc.Node,
        m_sp_moon: cc.Node,
        m_sp_decorate: cc.Sprite,
        m_n_bg1: cc.Node,
        m_n_bg2: cc.Node,
        m_n_bg3: cc.Node,
        m_n_bg4: cc.Node,
        m_n_bg5: cc.Node,
        m_n_bg6: cc.Node,
        sp_cloud1: cc.Node,
        sp_cloud2: cc.Node,
        sp_cloud3: cc.Node,
        sp_cloud4: cc.Node,
        sp_cloud5: cc.Node,
        sp_start: cc.Node,
        m_sp_starlizi: {
            type: cc.Node,
            default: [],
        },
    },

    // LIFE-CYCLE CALLBACKS:

    onLoad() {
        window.GAME_CONTROL = this;
        // Utils.setDesignResolution();
        var canvas = cc.find("Canvas").getComponent(cc.Canvas);
        let winSize = cc.director.getWinSize();
        canvas.fitHeight = true;
    },

    start() {


        this.initData();
        this.initMyConfig();
        this.startGame();
    },

    initData() {
        this._is_relived = false;
        this.m_judge = false;//是否需要判断
        this.m_gamestate = 2; //0普通状态  1缩放  2等待状态
        this.m_blocklist = [];
        this.m_bglist = [];
        this.m_touchid = -1;
        this.m_decorate_state = 0;//装饰的状态
        this.m_target_width = 580;//目标宽度
        this.m_first_target_width = 580;
        this.m_error_range = window.ERROR_RANGE;
        this.m_init_camerapos = this.m_n_gamecamera.position;
        this.m_limited_width = 626;//超过宽度
        this.m_cur_width = 0;//当前宽度
        this.m_curtime = 0;
        this.m_allscore = 0;
        this.m_cur_blood = 3;//当前血量
        this.m_limited_blood = 3;//血量上限
        this.m_perfect_hit = 0; //当前连击数
        this.m_playstartime = 0;
        this.m_playliuxing = 0;
        this.m_banner_refresh_time = 0;
        this.updateGold();
        this.m_cur_operatebg = 1;//当前需要操作的背景层
        this.m_bglist.push(this.m_n_bg4);
        this.m_bglist.push(this.m_n_bg5);
        this.m_bglist.push(this.m_n_bg6);
        this.m_cur_height = this.m_n_bg4.y;
        this.m_l_score.string = this.m_allscore + '米';

    },

    initMyConfig() {
        for (let i = 0; i < window.INIT_GAME_SAVE_DATA.man.length; i++) {
            if (window.INIT_GAME_SAVE_DATA.man[i] == 2) {
                this.m_block_style = i;
                break;
            }
        }
        let t = [42, 0, 0, 0, 0, 45];
        let y = [0, 0, 0, 5, 20, 33];
        for (let i = 0; i < window.INIT_GAME_SAVE_DATA.skin.length; i++) {
            if (window.INIT_GAME_SAVE_DATA.skin[i] == 2) {
                this.m_dis_decorate = t[i];
                this.m_dis_ydec = y[i];
                let style = i + 1;
                this.m_sp_decorate.node.getComponent(cc.Animation).play("mouse" + style + "_stand");
                break;
            }
        }
        this.m_sp_decorate.node.position = cc.v2(this.m_n_firstblock.x - this.m_dis_decorate, this.m_n_firstblock.y + this.m_n_firstblock.height / 2 - this.m_dis_ydec);
        this.sp_cloud1.runAction(cc.repeatForever(cc.sequence(cc.moveBy(40, -1480, 0), cc.moveBy(40, 1480, 0))));
        this.sp_cloud2.runAction(cc.repeatForever(cc.sequence(cc.moveBy(35, 1480, 0), cc.moveBy(35, -1480, 0))));
        this.sp_cloud3.runAction(cc.repeatForever(cc.sequence(cc.moveBy(15, -1480, 0), cc.moveBy(15, 1480, 0))));
        this.sp_cloud4.runAction(cc.repeatForever(cc.sequence(cc.moveBy(30, -1480, 0), cc.moveBy(35, 1780, 0))));
        this.sp_cloud5.runAction(cc.repeatForever(cc.sequence(cc.moveBy(35, 1480, 0), cc.moveBy(30, -1480, 0))));
        this.m_sp_moon.runAction(cc.moveBy(200, 0, 1080));
        this.m_n_firstblock.getComponent("BlockItem").updateStyle(this.m_block_style);
        this.addBlock(true);
    },

    addBlock(first) {
        let node = this.createBlock();
        node.getComponent("BlockItem").init();
        let position = null;
        if (first) {
            position = cc.v2(this.m_n_firstblock.x, this.m_n_firstblock.height + this.m_n_firstblock.y);
        } else {
            let blocknode = this.m_blocklist[this.m_blocklist.length - 1];
            position = cc.v2(blocknode.x, blocknode.height + blocknode.y);
        }
        this.m_blocklist.push(node);
        node.position = position;
        node.parent = this.m_n_gamenode;
    },

    startGame() {
        this.m_gamestate = 0;
        this.node.on(cc.Node.EventType.TOUCH_START, this.touchScene, this);
        this.node.on(cc.Node.EventType.TOUCH_END, this.onEndFire, this);
    },

    initSkill(index, node) {
        // let skill_tag = 0;//window.INIT_GAME_SAVE_DATA.touse[index];
        // let skill_name = cc.find('Label', node);
        // let skill_num = cc.find('l_num', node);
        // if (skill_tag != -1) {
        //     let data = window.CONFIG_GOODS[skill_tag];
        //     Utils.loadRes(data.name, cc.SpriteFrame, (sprite) => {
        //         node.getComponent(cc.Sprite).spriteFrame = sprite;
        //     })
        //     skill_name.getComponent(cc.Label).string = data.nickname;
        //     skill_num.getComponent(cc.Label).string = window.INIT_GAME_SAVE_DATA.tool[skill_tag];
        // } else {
        //     // Utils.loadRes(data.name, cc.SpriteFrame, (sprite) => {
        //     //     node.getComponent(cc.Sprite).spriteFrame = sprite;
        //     // })
        //     skill_name.getComponent(cc.Label).string = '';
        //     skill_num.getComponent(cc.Label).string = ''//window.INIT_GAME_SAVE_DATA.tool[skill_tag];
        // }
    },



    updateGold() {
        this.m_l_maingold.string = window.INIT_GAME_SAVE_DATA.gold;
    },

    createBlock(style) {
        let node = cc.instantiate(this.m_pre_block);
        node.getComponent("BlockItem").updateStyle(this.m_block_style);
        return node;
    },

    //增加分数
    addScore(score) {
        let color = new cc.Color(225, 241, 235, 255);
        // Utils.showTipsText('+' + score, this.m_n_UI, 0, 200, 90, color, 0.5, 40, 1);
        this.m_allscore += score;
        this.addScoreAnim(score);
    },

    addScoreAnim(score) {
        let self = this;
        this.m_l_score.node.stopAllActions();
        if (this.m_setscoreready) {
            this.m_l_score.string = this.m_allscore + '米';
        }
        this.m_l_score.node.opacity = 255;
        this.m_l_score.node.scale = 1;
        this.m_setscoreready = true;
        this.m_l_score.node.runAction(cc.sequence(cc.spawn(cc.fadeOut(0.2), cc.scaleTo(0.2, 1.5, 1.5).easing(cc.easeInOut(3.0))), cc.callFunc(() => {
            this.m_l_score.string = this.m_allscore + '米';
            self.m_setscoreready = false;
        }), cc.spawn(cc.fadeIn(0.2), cc.scaleTo(0.2, 1.0, 1.0).easing(cc.easeInOut(3.0)))));
    },

    //增加生命值
    addLife() {
        if (this.m_cur_blood >= this.m_limited_blood) return;
        let node = cc.find('sp_blood' + this.m_cur_blood, this.m_n_blood);
        if (node) {
            node.active = true;
            node.runAction(cc.sequence(cc.spawn(cc.fadeOut(0.2), cc.scaleTo(0.2, 1.5, 1.5).easing(cc.easeInOut(3.0))), cc.spawn(cc.fadeIn(0.2), cc.scaleTo(0.2, 1.0, 1.0).easing(cc.easeInOut(3.0)))));
        }
        this.m_cur_blood += 1;
    },

    reduceLife() {
        this.m_cur_blood -= 1;
        let node = cc.find('sp_blood' + this.m_cur_blood, this.m_n_blood);
        if (node) {
            node.active = false;
        }
        if (this.m_cur_blood <= 0) {
            this.judgeGame();
        }
    },

    addGold(num) {
        // Utils.showTipsText('+' + num, this.m_l_maingold.node, 20, -100, 70, cc.Color.WHITE, 0.5, 40, 1);
        window.INIT_GAME_SAVE_DATA.gold += num;
        this.updateGold();
    },

    updateDecoratePos(type) {
        let block = null;
        if (this.m_blocklist.length > 0) {
            block = this.m_blocklist[this.m_blocklist.length - 1];
        } else {
            block = this.m_n_firstblock;
        }

        this.m_sp_decorate.node.y = block.y + block.height / 2 - this.m_dis_ydec;

    },

    updateDecoratePosAnim(time) {
        let runtime = time ? time : 0.35;
        let block = null;
        if (this.m_blocklist.length > 0) {
            block = this.m_blocklist[this.m_blocklist.length - 1];
        } else {
            block = this.m_n_firstblock;
        }
        this.m_sp_decorate.node.runAction(cc.moveTo(runtime, block.x - this.m_dis_decorate, block.y + block.height / 2 - this.m_dis_ydec).easing(cc.easeOut(3.0)));
    },


    touchScene(event) {
        let id = event.touch.getID();
        if (this.m_touchid == -1 && this.m_gamestate == 0) {
            this.m_touchid = id;
            this.m_curtime = 0;
            this.m_judgegame = false;
            this.m_gamestate = 1;
            this.m_judge = true;
            // this._holdonid = Utils.SetSoundEffect(window.HOLD_ON_MUSIC, false, 1);
            this.updateDecoratePos(2);
            this.updateDecoratePosAnim();
        }
    },

    onEndFire(event) {
        let id = event.touch.getID();
        if (id == this.m_touchid) {
            this.m_touchid = -1;
            if (!this.m_judge) return;
            if (this.m_gamestate != 2) {
                this.m_cur_width = this.m_target_width;
                if (this.m_cur_width > this.m_target_width + this.m_error_range) {
                    this.m_judge = false;
                    this.endPlace(1);
                }
                else {
                    this.endPlace(0);
                    this.m_use_skill = false;
                    this.adjustCamera();
                }
            }
            // this.m_gamestate = 0;
        }
    },

    //state 0可以放置处理  1超出目标范围处理
    endPlace(state, substate) {
        // Utils.stopSoundEffect(this._holdonid);
        if (this.endPlacejudge) return;
        this.endPlacejudge = true;
        this.m_gamestate = 2;
        if (state == 0) {
            let range = Math.abs(this.m_target_width - this.m_cur_width);
            let node = this.m_blocklist[this.m_blocklist.length - 1];
            if (range <= this.m_error_range) {//完美放置
                node.getComponent("BlockItem").setMaskwidth(this.m_target_width);
                // this.addScore(3);
                // this.addLife();
                this.m_perfect_hit += 1;
                // this.showPerfect(1);
                // Utils.SetSoundEffect(window.PERFECT_MUSIC, false, 1);
            } else {
                this.addScore(1);
                this.m_target_width = this.m_cur_width;
                if (this.m_perfect_hit >= 3) {
                    this.m_awardblock = this.m_perfect_hit;
                } else {

                }
                // Utils.SetSoundEffect(window.GOOD_MUSIC, false, 1);
                // this.m_perfect_hit = 0;
                // this.showPerfect(0);
            }
            if (this.m_target_width <= this.m_error_range) {
                this.m_error_range = this.m_target_width - 30;
                if (this.m_error_range < 0) {
                    this.m_error_range = 0;
                }
            }
            if (this.m_target_width <= window.LIMITED_ERROR_RANGE) {
                this.m_error_range = 0;
            }
            // if (this.m_awardblock && this.m_awardblock > 0) {
                // this.awardBlock(this.m_awardblock);
                // this.m_awardblock = 0;
                // this.addGold(2);
            // } else {
                this.updateBlockEffect(node);
                // this.updateDecorateState(1);
                this.updateDecoratePos(1);
                this.addBlock();
                // console.log('endplaceafter', this.m_target_width, this.m_error_range);
                this.m_gamestate = 0;//可以重新放置了
                this.endPlacejudge = false;

                //   删除之前的节点
                // if (this.m_blocklist.length > 11) {
                //     let node = this.m_blocklist.shift();
                //     node.destroy();
                // }
            // }
            // this.addGold(2);
        }
    },

    resetTargeWidth() {
        if (this.m_blocklist.length > 0) {
            this.m_target_width = this.m_blocklist[this.m_blocklist.length - 1].getComponent("BlockItem").getMaskwidth();
            if (this.m_target_width <= this.m_error_range) {
                this.m_error_range = this.m_target_width - 30;
                if (this.m_error_range < 0) {
                    this.m_error_range = 0;
                }
            }
            if (this.m_target_width <= window.LIMITED_ERROR_RANGE) {
                this.m_error_range = 0;
            }
        } else {
            this.m_target_width = this.m_first_target_width;
            this.m_error_range = window.ERROR_RANGE;
        }
    },

    //调整摄像机位置
    adjustCamera() {
        if (this.m_blocklist[this.m_blocklist.length - 1].y > 0) {
            this.m_n_gamecamera.getComponent('GameCamera').updatePos(this.m_blocklist[this.m_blocklist.length - 1].y);
        }
        if (this.m_blocklist[this.m_blocklist.length - 1].y > this.m_cur_height) {
            this.m_bglist[this.m_cur_operatebg].y = this.m_cur_height + this.m_bglist[this.m_cur_operatebg].height;
            this.m_cur_height += this.m_bglist[this.m_cur_operatebg].height;
            this.m_cur_operatebg += 1;
            if (this.m_cur_operatebg >= 3) this.m_cur_operatebg = 0;
        }
    },

    playStar(dt) {
        // this.m_playstartime += dt;
        // this.m_playliuxing += dt;
        // if (this.m_n_gamecamera.y >= 1080 && this.m_playstartime >= 4) {
        //     let x = 0;//Utils.random(100 - cc.winSize.width / 2, cc.winSize.width / 2 - 100);
        //     this.sp_start.x = x;
        //     // this.sp_start.y = Utils.random(this.m_n_gamecamera.y - 300, this.m_n_gamecamera.y + 400);
        //     this.sp_start.getComponent(cc.Animation).play();
        // }
        // if (this.m_n_gamecamera.y >= 2000 && this.m_playliuxing >= 7.5) {
        //     this.playliuxing(0);
        //     // this.playliuxing(1);
        //     // this.playliuxing(2);
        // }
        // if (this.m_playstartime >= 4) {
        //     this.m_playstartime = 0;
        // }
        // if (this.m_playliuxing >= 7.5) {
        //     this.m_playliuxing = 0;
        // }
    },


    playliuxing(index) {
        // let x = 0;//Utils.random(0, cc.winSize.width / 2 - 100);
        // this.m_sp_starlizi[index].x = x;
        // this.m_sp_starlizi[index].y = 0;//Utils.random(this.m_n_gamecamera.y + 300, this.m_n_gamecamera.y + 700);
        // this.m_sp_starlizi[index].getComponent(cc.MotionStreak).reset();
        // this.m_sp_starlizi[index].opacity = 255;
        // let ss = Utils.random(-700, -400);
        // let yy = Utils.random(-200, -100);
        // this.m_sp_starlizi[index].runAction(cc.sequence(cc.moveBy(0.5, ss, yy), cc.fadeOut(0.5)));
    },
    awardBlock(num) {
        let self = this;
        let block_num = 0;
        let base_node = this.m_blocklist[this.m_blocklist.length - 1];
        let base_nodey = base_node.y;
        let base_height = base_node.height;

        this.schedule(() => {
            // Utils.SetSoundEffect(window.PERFECT_MUSIC, false, 1);
            block_num += 1;
            // console.log(num);
            let node = this.createBlock();
            node.getComponent("BlockItem").setMaskwidth(self.m_target_width);
            node.x = base_node.x;
            node.y = base_nodey + base_height * block_num;
            node.getComponent("BlockItem").showAwardText(self.m_n_gamenode, block_num);
            self.m_blocklist.push(node);
            node.parent = self.m_n_gamenode;

            self.adjustCamera();
            self.updateDecoratePos();
            if (block_num >= num) {
                self.updateBlockEffect(node);
                self.addBlock();
                self.scheduleOnce(() => {
                    self.m_gamestate = 0;
                    self.endPlacejudge = false;
                }, 0.3);
            }
            self.addScore(1);
        }, 0.15, num - 1, 0);
    },

    showPerfect(state) {
        let str = 'Perfect';
        if (state == 1) {
            if (this.m_perfect_hit > 1) {
                str = str + 'x' + this.m_perfect_hit;
            }
        }
        else {
            str = "Good";
        }
        // Utils.showPerfectText(str, this.m_n_UI, 0, 0, 70, cc.Color.YELLOW);
    },

    update(dt) {
        this.playStar(dt);

    },

    lateUpdate(dt) {
        // if (this.m_gamestate == 1) {
        //     if (this.m_blocklist.length > 0) {
        //         this.m_curtime += dt;
        //         let node = this.m_blocklist[this.m_blocklist.length - 1];
        //         // console.log('time = ', this.m_curtime, window.OPEN_TIME);
        //         // let width = this.m_curtime / window.OPEN_TIME * this.m_first_target_width;
        //         let width = window.START_VELOCITY * this.m_curtime + 0.5 * window.ACCEL_VELOCITY * this.m_curtime * this.m_curtime// / window.OPEN_TIME * this.m_first_target_width
        //         // 1/2at^2
        //         node.getComponent("BlockItem").setMaskwidth(width);
        //         this.m_cur_width = width;
        //         if (width > this.m_limited_width) {
        //             this.m_gamestate = 2;
        //             this.m_judge = false;
        //             this.endPlace(1);
        //         }
        //     }
        // }
    },

    updateBlockEffect(node) {
        // let block_node = this.createBlock();
        // block_node.position = node.position;
        // block_node.getComponent("BlockItem").setMaskwidth(node.getComponent("BlockItem").getMaskwidth());
        // block_node.parent = this.m_n_gamenode;
        // block_node.runAction(cc.sequence(cc.spawn(cc.fadeOut(0.3), cc.scaleTo(0.3, 2.0, 1.7).easing(cc.easeIn(2.0))), cc.callFunc(() => {
        //     block_node.destroy();
        // })));
        // node.runAction(cc.sequence(cc.scaleTo(0.15, 1.5, 1.0).easing(cc.easeIn(3.0)), cc.scaleTo(0.15, 1.0, 1.0).easing(cc.easeOut(3.0))));
    },

    //摄像机抖动
    shakeCamera(type) {
        let pos = this.m_n_gamecamera.position;
        if (type != 0) {
            pos = this._camerapos;
        }
        if (type == 0) {//boss出现抖动
            this.m_n_gamecamera.runAction(
                cc.sequence(cc.moveTo(0.03, pos.x - 12, pos.y - 12),
                    cc.moveTo(0.03, pos.x - 12, pos.y + 12),
                    cc.moveTo(0.03, pos.x + 12, pos.y - 12),
                    cc.moveTo(0.03, pos.x + 12, pos.y + 12),
                    cc.moveTo(0.03, pos.x, pos.y)));
        } else if (type == 1) {//枪击中台阶
            this.m_n_gamecamera.runAction(
                cc.sequence(cc.moveTo(0.06, pos.x + 10, pos.y),
                    cc.moveTo(0.06, pos.x, pos.y)));
        } else if (type == 2) {//枪击中台阶
            this.m_n_gamecamera.runAction(
                cc.sequence(cc.moveTo(0.06, pos.x - 10, pos.y),
                    cc.moveTo(0.06, pos.x, pos.y)));
        }
    },


    judgeGame() {

    },

    reliveGame() {

    },

    onTest() {
        this.m_n_gamecamera.runAction(cc.moveTo(4, 0, 0));
    },

    //游戏结束
    gameOver() {

    },

    onDestroy() {
        if (this.m_bannerad) {
            this.m_bannerad.destroy();
            this.m_bannerad = null;
        }

        window.GAME_CONTROL = null;
    },
});
