import CommonUtil from './Common_CommonUtil';
export default class wxShortCut {
    private static clearId: number = 0;

    public static showToast(title: string, timeout: number, icon: string = "none", image: string = "", duration: number = 0) {
        if (!CommonUtil.isWeChat())
            return;
        wx.hideToast();
        clearTimeout(wxShortCut.clearId);
        //console.log("显示toast");
        wx.showToast({
            title: title,
            icon: icon,
            image: image,
            duration: duration || 0,
        });
        wxShortCut.clearId = setTimeout(() => wx.hideToast(), timeout);
    }

    public static showModal(title: string, content: string) {
        wx.showModal({
            title: title,
            content: content,
            showCancel: false,
        });

    }

    // public static showModalRet(title: string, content: string,confirmstr:string = '确认',call:any) {
    //     wx.showModal({
    //         title: title,
    //         content: content,
    //         showCancel: false,
    //         confirmText:confirmstr,
    //         success: function(res) {  
    //             if (res.confirm) {  
    //                 console.log('用户点击确定');
    //                 call();
    //             }
    //         }  
    //     });

    // }



    // public static httpGet(url:string, success:Function, fail:Function) {
    //     console.log("sessionId:",wx.getStorageSync('sessionId'));
    //     wx.request({
    //         url: url,
    //         method: "GET",
    //         header: { 'content-type': "application/json", 'session-id':wx.getStorageSync('sessionId')},
    //         success: success,
    //         fail: (e) => {
    //             console.log("wxShortCut.httpGet 获取数据失败！ err:", e);
    //             if (fail)
    //                 fail(e);
    //         }
    //     });
    // }
}