"use strict";
cc._RF.push(module, 'd3c799Zx8dLBrLFPByn86R1', 'listBlock');
// script/listBlock.js

'use strict';

// Learn cc.Class:
//  - [Chinese] http://docs.cocos.com/creator/manual/zh/scripting/class.html
//  - [English] http://www.cocos2d-x.org/docs/creator/en/scripting/class.html
// Learn Attribute:
//  - [Chinese] http://docs.cocos.com/creator/manual/zh/scripting/reference/attributes.html
//  - [English] http://www.cocos2d-x.org/docs/creator/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - [Chinese] http://docs.cocos.com/creator/manual/zh/scripting/life-cycle-callbacks.html
//  - [English] http://www.cocos2d-x.org/docs/creator/en/scripting/life-cycle-callbacks.html

cc.Class({
    extends: cc.Component,

    properties: {
        rankNumber: {
            type: cc.Node,
            default: null
        },
        topIcon: {
            type: cc.Node,
            default: null
        },
        avatar: {
            type: cc.Node,
            default: null
        }
    },

    // LIFE-CYCLE CALLBACKS:

    onLoad: function onLoad() {},
    first: function first() {
        this.rankNumber.active = false;
        this.topIcon.active = true;
    },
    setAvatar: function setAvatar(url) {
        var self = this;
        cc.loader.load({
            url: url, type: 'png'
        }, function (err, texture) {
            if (err) console.error(err);
            self.avatar.spriteFrame = new cc.SpriteFrame(texture);
        });
    },
    setNumber: function setNumber(number) {
        this.rankNumber.getComponent(cc.Label).string = number;
    },
    start: function start() {}
}

// update (dt) {},
);

cc._RF.pop();