const {ccclass, property} = cc._decorator;

@ccclass
export default class MoveCamera extends cc.Component {

    @property(cc.Camera)
    mainCamera: cc.Camera = null;

    @property(cc.Node)
    platform: cc.Node = null;

    onLoad () {
        console.log('xxx');
        var manager = cc.director.getCollisionManager();
        manager.enabled = true;
        manager.enabledDebugDraw = true;
    }

    start () {
        this.node.on(cc.Node.EventType.TOUCH_MOVE,this.move,this);
        this.platform.on(cc.Node.EventType.TOUCH_MOVE,this.moveP,this);
    }

    move(e) {
        // 移动主摄像机(Main Camera)
        let t = e.getDelta();
        this.mainCamera.node.x -= t.x;
        this.mainCamera.node.y -= t.y;
    }

    moveP(e) {
        // 移动另外一个摄像机(Other Camera)所渲染的对象
        e.stopPropagation();
        let t = e.getDelta();
        this.platform.x += t.x;
        this.platform.y += t.y;
    }

    // update (dt) {}
}
