import arrow from "./arrow";

const { ccclass, property } = cc._decorator;

@ccclass
export default class arrow_scene extends cc.Component {
    @property(arrow)
    curArrow: arrow = null;
    @property(cc.Node)
    target: cc.Node = null;


    // LIFE-CYCLE CALLBACKS:

    onLoad() {
        this.node.on(cc.Node.EventType.TOUCH_MOVE, this.controlArrow, this);
        this.node.on(cc.Node.EventType.TOUCH_END, this.hideArrow, this);
        this.node.on(cc.Node.EventType.TOUCH_CANCEL, this.hideArrow, this);
    }

    start() {

    }

    // update (dt) {}

    private controlArrow(e): void {
        var location = e.getLocation();
        this.checkIsOnTarget(location);
        var ePos = this.curArrow.node.convertToNodeSpaceAR(location);
        this.curArrow.controlArrows(cc.v2(), ePos);
        this.curArrow.node.active = true;
    }

    private hideArrow(e): void {
        this.curArrow.node.active = false;
        this.curArrow.controlArrows(cc.v2(), cc.v2());
    }

    //判断主箭头是否移到目标target
    private checkIsOnTarget(pos: cc.Vec2): void {
        //rect是以target的父节点为基准的，那point也需要以target的父节点为基准
        var rect = this.target.getBoundingBox();
        var point = this.target.parent.convertToNodeSpaceAR(pos);
        this.curArrow.newOnTargetStatus = rect.contains(point);
    }

}
