(function() {"use strict";var __module = CC_EDITOR ? module : {exports:{}};var __filename = 'preview-scripts/assets/scripts/arrow/arrow_scene.js';var __require = CC_EDITOR ? function (request) {return cc.require(request, require);} : function (request) {return cc.require(request, __filename);};function __define (exports, require, module) {"use strict";
cc._RF.push(module, '517622B8uRLUZdgS7//0r2H', 'arrow_scene', __filename);
// scripts/arrow/arrow_scene.ts

Object.defineProperty(exports, "__esModule", { value: true });
var arrow_1 = require("./arrow");
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var arrow_scene = /** @class */ (function (_super) {
    __extends(arrow_scene, _super);
    function arrow_scene() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.curArrow = null;
        _this.target = null;
        return _this;
    }
    // LIFE-CYCLE CALLBACKS:
    arrow_scene.prototype.onLoad = function () {
        this.node.on(cc.Node.EventType.TOUCH_MOVE, this.controlArrow, this);
        this.node.on(cc.Node.EventType.TOUCH_END, this.hideArrow, this);
        this.node.on(cc.Node.EventType.TOUCH_CANCEL, this.hideArrow, this);
    };
    arrow_scene.prototype.start = function () {
    };
    // update (dt) {}
    arrow_scene.prototype.controlArrow = function (e) {
        var location = e.getLocation();
        this.checkIsOnTarget(location);
        var ePos = this.curArrow.node.convertToNodeSpaceAR(location);
        this.curArrow.controlArrows(cc.v2(), ePos);
        this.curArrow.node.active = true;
    };
    arrow_scene.prototype.hideArrow = function (e) {
        this.curArrow.node.active = false;
        this.curArrow.controlArrows(cc.v2(), cc.v2());
    };
    //判断主箭头是否移到目标target
    arrow_scene.prototype.checkIsOnTarget = function (pos) {
        //rect是以target的父节点为基准的，那point也需要以target的父节点为基准
        var rect = this.target.getBoundingBox();
        var point = this.target.parent.convertToNodeSpaceAR(pos);
        this.curArrow.newOnTargetStatus = rect.contains(point);
    };
    __decorate([
        property(arrow_1.default)
    ], arrow_scene.prototype, "curArrow", void 0);
    __decorate([
        property(cc.Node)
    ], arrow_scene.prototype, "target", void 0);
    arrow_scene = __decorate([
        ccclass
    ], arrow_scene);
    return arrow_scene;
}(cc.Component));
exports.default = arrow_scene;

cc._RF.pop();
        }
        if (CC_EDITOR) {
            __define(__module.exports, __require, __module);
        }
        else {
            cc.registerModuleFunc(__filename, function () {
                __define(__module.exports, __require, __module);
            });
        }
        })();
        //# sourceMappingURL=arrow_scene.js.map
        