(function() {"use strict";var __module = CC_EDITOR ? module : {exports:{}};var __filename = 'preview-scripts/assets/scripts/main.js';var __require = CC_EDITOR ? function (request) {return cc.require(request, require);} : function (request) {return cc.require(request, __filename);};function __define (exports, require, module) {"use strict";
cc._RF.push(module, '1f7f6+zOMZGa7RyavceQFn+', 'main', __filename);
// scripts/main.js

"use strict";

// Learn cc.Class:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/class.html
//  - [English] http://docs.cocos2d-x.org/creator/manual/en/scripting/class.html
// Learn Attribute:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/reference/attributes.html
//  - [English] http://docs.cocos2d-x.org/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/life-cycle-callbacks.html
//  - [English] https://www.cocos2d-x.org/docs/creator/manual/en/scripting/life-cycle-callbacks.html

cc.Class({
    extends: cc.Component,

    properties: {
        hero: {
            default: null,
            type: cc.Prefab

        },
        mapList: {
            default: [],
            type: cc.TiledMapAsset
        }
    },

    onLoad: function onLoad() {
        //初始化按钮监听
        cc.systemEvent.on(cc.SystemEvent.EventType.KEY_DOWN, this.onKeyDown, this);
        //加载地图
        //this.loadMap(0);
    },
    start: function start() {},
    update: function update(dt) {},


    onKeyDown: function onKeyDown(event) {
        var newTile = cc.v2(this.playerTile.x, this.playerTile.y);
        switch (event.keyCode) {
            case cc.macro.KEY.up:
                newTile.y -= 1;
                break;
            case cc.macro.KEY.down:
                newTile.y += 1;
                break;
            case cc.macro.KEY.left:
                newTile.x -= 1;
                break;
            case cc.macro.KEY.right:
                newTile.x += 1;
                break;
            default:
                return;
        }
        this.tryMoveToNewTile(newTile);
    },

    //初始化Hero
    initHero: function initHero() {
        var scene = cc.director.getScene();
        var heroInstance = cc.instantiate(this.hero);

        heroInstance.parent = scene;
        heroInstance.setPosition(0, 0);
    },

    //初始化地图
    initMap: function initMap() {},

    //初始化Map
    //加载地图文件时调用
    loadMap: function loadMap(mapIndex) {

        //获取地图节点
        var tiledMap = this.node.getChildByName("map");
        cc.loader.loadRes("mapResource/maps/1", function (err, map) {
            tiledMap.tmxAsset = map;
            cc.log("tiledMap:" + tiledMap.name);
            cc.log("tiledMap,err:" + err);
        });
        // //startPoint和endPoint对象
        // var startPoint = players.getObject('startPoint');
        // var endPoint = players.getObject('endPoint');
        // //像素坐标
        // var startPos = cc.v2(startPoint.x, startPoint.y);
        // var endPos = cc.v2(endPoint.x, endPoint.y);
        //各个图层
        //this.foreground = this.tiledMap.getLayer('foreground');
        //this.eventground = this.tiledMap.getLayer('eventground');
        //this.background = this.tiledMap.getLayer('background');
        //出生Tile和结束Tile
        //this.playerTile = this.startTile = this.getTilePos(startPos);
        //this.endTile = this.getTilePos(endPos);
        //更新player位置
        //this.updatePlayerPos();
    },

    //将像素坐标转化为瓦片坐标
    pixel2Tiled: function pixel2Tiled(posInPixel) {

        var mapSize = this.node.getContentSize();
        var tileSize = this.tiledMap.getTileSize();
        var x = Math.floor(posInPixel.x / tileSize.width);
        var y = Math.floor((mapSize.height - posInPixel.y) / tileSize.height);
        return cc.v2(x, y);
    }
});

cc._RF.pop();
        }
        if (CC_EDITOR) {
            __define(__module.exports, __require, __module);
        }
        else {
            cc.registerModuleFunc(__filename, function () {
                __define(__module.exports, __require, __module);
            });
        }
        })();
        //# sourceMappingURL=main.js.map
        